/*
 * Decompiled with CFR 0.152.
 */
package oshi.driver.unix.solaris;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import oshi.annotation.concurrent.ThreadSafe;
import oshi.jna.platform.unix.solaris.SolarisLibc;
import oshi.software.os.OSSession;

@ThreadSafe
public final class Who {
    private static final SolarisLibc LIBC = SolarisLibc.INSTANCE;

    private Who() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static synchronized List<OSSession> queryUtxent() {
        ArrayList<OSSession> whoList = new ArrayList<OSSession>();
        LIBC.setutxent();
        try {
            SolarisLibc.SolarisUtmpx ut;
            while ((ut = LIBC.getutxent()) != null) {
                String user;
                if (ut.ut_type != 7 && ut.ut_type != 6 || "LOGIN".equals(user = new String(ut.ut_user, StandardCharsets.US_ASCII).trim())) continue;
                String device = new String(ut.ut_line, StandardCharsets.US_ASCII).trim();
                String host = new String(ut.ut_host, StandardCharsets.US_ASCII).trim();
                long loginTime = ut.ut_tv.tv_sec.longValue() * 1000L + ut.ut_tv.tv_usec.longValue() / 1000L;
                if (user.isEmpty() || device.isEmpty() || loginTime < 0L || loginTime > System.currentTimeMillis()) {
                    List<OSSession> list = oshi.driver.unix.Who.queryWho();
                    return list;
                }
                whoList.add(new OSSession(user, device, loginTime, host));
            }
            return whoList;
        }
        finally {
            LIBC.endutxent();
        }
    }
}

