/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.offroad.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.text.MessageFormat;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableRowSorter;
import net.osmand.PlatformUtil;
import net.osmand.data.Amenity;
import net.osmand.data.LatLon;
import net.osmand.data.MapObject;
import net.osmand.plus.poi.PoiUIFilter;
import net.sourceforge.offroad.OsmWindow;
import net.sourceforge.offroad.ui.BlindIcon;
import org.apache.commons.logging.Log;

public class AmenityTablePanel
extends JPanel {
    private static final Log log = PlatformUtil.getLog(AmenityTablePanel.class);
    public static final MessageFormat formatDistance = new MessageFormat("{0, number,##.#} km", Locale.US);
    private static final int ICON_COLUMN_INDEX = 0;
    private OsmWindow mContext;
    private JTable mTable;
    private AmenityTableModel mSourceModel;
    private TableRowSorter<AmenityTableModel> mSorter;
    private KeyAdapter mKeyListener;
    private MouseAdapter mMouseListener;
    private PoiUIFilter mFilter;

    public AmenityTablePanel(OsmWindow pContext) {
        this.mContext = pContext;
        GridBagLayout gbl = new GridBagLayout();
        gbl.columnWeights = new double[]{1.0};
        gbl.rowWeights = new double[]{1.0};
        this.setLayout(gbl);
        int y = 0;
        this.mTable = new JTable();
        this.mSourceModel = new AmenityTableModel();
        this.mTable.setModel(this.mSourceModel);
        this.mTable.setSelectionMode(0);
        this.mSorter = new TableRowSorter<AmenityTableModel>(this.mSourceModel);
        this.mSorter.setComparator(0, new Comparator<ImageHolder>(){

            @Override
            public int compare(ImageHolder pO1, ImageHolder pO2) {
                try {
                    return pO1.getPoiIconKeyName().compareTo(pO2.getPoiIconKeyName());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return 0;
                }
            }
        });
        this.mTable.setRowSorter(this.mSorter);
        this.mKeyListener = new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent pE) {
                if (pE.getKeyCode() == 10) {
                    pE.consume();
                    AmenityTablePanel.this.select(AmenityTablePanel.this.mSourceModel.getSelectedRow());
                }
                super.keyTyped(pE);
            }
        };
        this.mTable.addKeyListener(this.mKeyListener);
        this.mMouseListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                if (evt.getClickCount() >= 2) {
                    evt.consume();
                    AmenityTablePanel.this.select(AmenityTablePanel.this.mSourceModel.getSelectedRow());
                }
            }
        };
        this.mTable.addMouseListener(this.mMouseListener);
        this.add((Component)new JScrollPane(this.mTable), new GridBagConstraints(0, y++, 2, 1, 1.0, 4.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    protected void select(MapObject pSelectedRow) {
        if (pSelectedRow == null) {
            return;
        }
        LatLon loc = pSelectedRow.getLocation();
        this.mContext.move(loc, null);
    }

    public void setSearchResult(List<MapObject> pResult) {
        this.mSourceModel.clear();
        for (MapObject am : pResult) {
            this.mSourceModel.addRow(am);
        }
        this.mSourceModel.fireTableDataChanged();
        this.updateRowHeights();
    }

    private void recalculateDistances() {
        int distanceColumn = this.mSourceModel.getDistanceColumn();
        for (int i = 0; i < this.mSourceModel.getRowCount(); ++i) {
            this.mSourceModel.fireTableCellUpdated(i, distanceColumn);
        }
    }

    private void updateRowHeights() {
        for (int row = 0; row < this.mTable.getRowCount(); ++row) {
            int rowHeight = this.mTable.getRowHeight();
            for (int column = 0; column < this.mTable.getColumnCount(); ++column) {
                Component comp = this.mTable.prepareRenderer(this.mTable.getCellRenderer(row, column), row, column);
                rowHeight = Math.max(rowHeight, comp.getPreferredSize().height);
            }
            this.mTable.setRowHeight(row, rowHeight);
        }
    }

    public class AmenityTableModel
    extends AbstractTableModel {
        private Vector<AmenityTableColumn> mColumns = new Vector();
        private Vector<MapObject> mRows = new Vector();

        public AmenityTableModel() {
            this.mColumns.addElement(new AmenityTableColumn("icon", ImageHolder.class, item -> new ImageHolder(AmenityTablePanel.this.mContext.getBitmap(item), item), new ImageTableCellRenderer()));
            this.mColumns.addElement(new AmenityTableColumn("name", String.class, item -> item.getName(AmenityTablePanel.this.mContext.getLanguage()), new DefaultTableCellRenderer()));
            this.mColumns.addElement(new AmenityTableColumn("distance", Double.class, item -> item.getDistance(AmenityTablePanel.this.mContext.getCursorPosition()) / 1000.0, new DistanceTableCellRenderer()));
            for (AmenityTableColumn column : this.mColumns) {
                AmenityTablePanel.this.mTable.setDefaultRenderer(column.mClass, column.mRenderer);
            }
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return this.mColumns.get((int)columnIndex).mClass;
        }

        @Override
        public String getColumnName(int pColumn) {
            return AmenityTablePanel.this.mContext.getOffRoadString("offroad.amenity." + this.mColumns.get((int)pColumn).mName);
        }

        public void addRow(MapObject pItem) {
            this.mRows.add(pItem);
        }

        public MapObject getItemAt(int pJ) {
            return this.mRows.get(pJ);
        }

        @Override
        public int getRowCount() {
            return this.mRows.size();
        }

        @Override
        public int getColumnCount() {
            return this.mColumns.size();
        }

        @Override
        public Object getValueAt(int pRowIndex, int pColumnIndex) {
            AmenityTableColumn column = this.mColumns.get(pColumnIndex);
            Object result = column.mMapping.get(this.getItemAt(pRowIndex));
            return result;
        }

        public MapObject getSelectedRow() {
            int sel = AmenityTablePanel.this.mTable.getSelectedRow();
            if (sel < 0) {
                return null;
            }
            return this.getItemAt(AmenityTablePanel.this.mTable.convertRowIndexToModel(sel));
        }

        public List<MapObject> getSelectedRows() {
            int[] selectedRows = AmenityTablePanel.this.mTable.getSelectedRows();
            Vector<MapObject> res = new Vector<MapObject>();
            for (int i = 0; i < selectedRows.length; ++i) {
                int j = AmenityTablePanel.this.mTable.convertRowIndexToModel(selectedRows[i]);
                res.add(this.getItemAt(j));
            }
            return res;
        }

        public void clear() {
            this.mRows.clear();
        }

        public int getDistanceColumn() {
            for (int i = 0; i < this.mColumns.size(); ++i) {
                if (this.mColumns.get((int)i).mClass != Double.class) continue;
                return i;
            }
            return -1;
        }
    }

    public static class AmenityTableColumn {
        private AmenityToColumn mMapping;
        String mName;
        Class mClass;
        private TableCellRenderer mRenderer;

        public AmenityTableColumn(String pName, Class pClass, AmenityToColumn pMapping, TableCellRenderer pRenderer) {
            this.mName = pName;
            this.mClass = pClass;
            this.mMapping = pMapping;
            this.mRenderer = pRenderer;
        }
    }

    static interface AmenityToColumn {
        public Object get(MapObject var1);
    }

    public class DistanceTableCellRenderer
    extends DefaultTableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (value == null) {
                this.setText(AmenityTablePanel.this.mContext.getString(394));
            } else if (value instanceof Double) {
                Double d = (Double)value;
                this.setText(formatDistance.format(new Object[]{(double)d}));
            }
            return this;
        }
    }

    public class ImageTableCellRenderer
    extends DefaultTableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (value instanceof ImageHolder) {
                ImageHolder holder = (ImageHolder)value;
                BufferedImage img = holder.image;
                if (img != null) {
                    this.setIcon(new ImageIcon(img));
                    this.setSize(new Dimension(img.getWidth(), img.getHeight()));
                } else {
                    this.setIcon(new BlindIcon(20));
                    this.setSize(new Dimension(20, 20));
                }
                this.setText("");
                this.setToolTipText(holder.getTypeTranslation());
            }
            return this;
        }
    }

    public static class ImageHolder {
        public BufferedImage image;
        public MapObject item;

        public ImageHolder(BufferedImage pImage, MapObject pItem) {
            this.image = pImage;
            this.item = pItem;
        }

        String getTypeTranslation() {
            if (this.item instanceof Amenity) {
                Amenity amenity = (Amenity)this.item;
                return amenity.getType().getTranslation();
            }
            return null;
        }

        String getPoiIconKeyName() {
            if (this.item instanceof Amenity) {
                Amenity amenity = (Amenity)this.item;
                return amenity.getType().getPoiTypeByKeyName(amenity.getSubType()).getIconKeyName();
            }
            return null;
        }
    }
}

