/*
 * Decompiled with CFR 0.152.
 */
package pdftk.com.lowagie.text.pdf;

import java.io.IOException;
import java.io.OutputStream;
import pdftk.com.lowagie.text.pdf.ByteBuffer;
import pdftk.com.lowagie.text.pdf.PdfContentByte;
import pdftk.com.lowagie.text.pdf.PdfEncodings;
import pdftk.com.lowagie.text.pdf.PdfEncryption;
import pdftk.com.lowagie.text.pdf.PdfObject;
import pdftk.com.lowagie.text.pdf.PdfReader;
import pdftk.com.lowagie.text.pdf.PdfWriter;

public class PdfString
extends PdfObject {
    protected String value = null;
    protected byte[] originalBytes = null;
    protected String encoding = null;
    protected int objNum = 0;
    protected int objGen = 0;
    protected boolean hexWriting = false;

    public PdfString() {
        super(3);
    }

    public PdfString(String value) {
        super(3);
        this.value = value;
    }

    public PdfString(String value, String encoding) {
        super(3);
        this.value = value;
        this.encoding = encoding;
    }

    public PdfString(byte[] bytes) {
        super(3);
        this.bytes = bytes;
    }

    public PdfString(byte[] bytes, String encoding) {
        super(3);
        this.bytes = bytes;
        this.encoding = encoding;
    }

    @Override
    public void toPdf(PdfWriter writer, OutputStream os) throws IOException {
        byte[] b = this.getBytes();
        PdfEncryption crypto = null;
        if (writer != null) {
            crypto = writer.getEncryption();
        }
        if (crypto != null && !crypto.isEmbeddedFilesOnly()) {
            b = crypto.encryptByteArray(b);
        }
        if (this.hexWriting) {
            ByteBuffer buf = new ByteBuffer();
            buf.append('<');
            int len = b.length;
            for (int k = 0; k < len; ++k) {
                buf.appendHex(b[k]);
            }
            buf.append('>');
            os.write(buf.toByteArray());
        } else {
            os.write(PdfContentByte.escapeString(b));
        }
    }

    @Override
    public String toString() {
        return this.getValue();
    }

    @Override
    public byte[] getBytes() {
        if (this.bytes == null && this.value != null) {
            if (this.encoding == null) {
                this.encoding = PdfEncodings.isPdfDocEncoding(this.value) ? "PDF" : "UTF-16";
            }
            this.bytes = PdfEncodings.convertToBytes(this.value, this.encoding);
        }
        return this.bytes;
    }

    private String getValue() {
        if (this.value == null && this.bytes != null) {
            if (this.encoding == null) {
                this.encoding = PdfString.isUnicode(this.bytes) ? "UTF-16" : "PDF";
            }
            this.value = PdfEncodings.convertToString(this.bytes, this.encoding);
        }
        return this.value;
    }

    public String toUnicodeString() {
        return this.getValue();
    }

    public String getEncoding() {
        return this.encoding;
    }

    void setObjNum(int objNum, int objGen) {
        this.objNum = objNum;
        this.objGen = objGen;
    }

    void decrypt(PdfReader reader) {
        PdfEncryption decrypt = reader.getDecrypt();
        if (decrypt != null) {
            this.getBytes();
            this.originalBytes = new byte[this.bytes.length];
            System.arraycopy(this.bytes, 0, this.originalBytes, 0, this.bytes.length);
            decrypt.setHashKey(this.objNum, this.objGen);
            this.bytes = decrypt.decryptByteArray(this.bytes);
            this.value = null;
            this.encoding = null;
        }
    }

    public byte[] getOriginalBytes() {
        if (this.originalBytes != null) {
            return this.originalBytes;
        }
        return this.getBytes();
    }

    public PdfString setHexWriting(boolean hexWriting) {
        this.hexWriting = hexWriting;
        return this;
    }

    public boolean isHexWriting() {
        return this.hexWriting;
    }

    public static boolean isUnicode(byte[] bb) {
        return bb.length >= 2 && bb[0] == -2 && bb[1] == -1;
    }
}

