/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.creole.command;

import net.sourceforge.plantuml.command.regex.Matcher2;
import net.sourceforge.plantuml.command.regex.MyPattern;
import net.sourceforge.plantuml.command.regex.Pattern2;
import net.sourceforge.plantuml.creole.command.Command;
import net.sourceforge.plantuml.creole.legacy.StripeSimple;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.ugraphic.color.HColor;
import net.sourceforge.plantuml.ugraphic.color.HColorSet;
import net.sourceforge.plantuml.ugraphic.color.NoSuchColorException;
import net.sourceforge.plantuml.ugraphic.color.NoSuchColorRuntimeException;

public class CommandCreoleColorChange
implements Command {
    private final Pattern2 pattern;

    public static Command create() {
        return new CommandCreoleColorChange("^(?i)(\\<color[\\s:]+(#[0-9a-fA-F]{6}|#?\\w+)[%s]*\\>(.*?)\\</color\\>)");
    }

    public static Command createEol() {
        return new CommandCreoleColorChange("^(?i)(\\<color[\\s:]+(#[0-9a-fA-F]{6}|#?\\w+)[%s]*\\>(.*)$)");
    }

    private CommandCreoleColorChange(String p) {
        this.pattern = MyPattern.cmpile(p);
    }

    @Override
    public int matchingSize(String line) {
        Matcher2 m = this.pattern.matcher(line);
        if (!m.find()) {
            return 0;
        }
        return m.group(2).length();
    }

    @Override
    public String executeAndGetRemaining(String line, StripeSimple stripe) throws NoSuchColorRuntimeException {
        Matcher2 m = this.pattern.matcher(line);
        if (!m.find()) {
            throw new IllegalStateException();
        }
        FontConfiguration fc1 = stripe.getActualFontConfiguration();
        String s = m.group(2);
        try {
            HColor color = HColorSet.instance().getColor(s);
            FontConfiguration fc2 = fc1.changeColor(color);
            stripe.setActualFontConfiguration(fc2);
            stripe.analyzeAndAdd(m.group(3));
            stripe.setActualFontConfiguration(fc1);
            return line.substring(m.group(1).length());
        }
        catch (NoSuchColorException e) {
            throw new NoSuchColorRuntimeException();
        }
    }
}

