/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic.debug;

import java.awt.Color;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.posimo.DotPath;
import net.sourceforge.plantuml.ugraphic.AbstractCommonUGraphic;
import net.sourceforge.plantuml.ugraphic.ClipContainer;
import net.sourceforge.plantuml.ugraphic.UCenteredCharacter;
import net.sourceforge.plantuml.ugraphic.UComment;
import net.sourceforge.plantuml.ugraphic.UEllipse;
import net.sourceforge.plantuml.ugraphic.UEmpty;
import net.sourceforge.plantuml.ugraphic.UGraphic2;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UPath;
import net.sourceforge.plantuml.ugraphic.UPolygon;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.USegment;
import net.sourceforge.plantuml.ugraphic.USegmentType;
import net.sourceforge.plantuml.ugraphic.UShape;
import net.sourceforge.plantuml.ugraphic.UText;
import net.sourceforge.plantuml.ugraphic.color.ColorMapperIdentity;
import net.sourceforge.plantuml.ugraphic.color.HColor;
import net.sourceforge.plantuml.ugraphic.color.HColorMiddle;
import net.sourceforge.plantuml.ugraphic.color.HColorSimple;
import net.sourceforge.plantuml.ugraphic.debug.StringBounderDebug;

public class UGraphicDebug
extends AbstractCommonUGraphic
implements ClipContainer,
UGraphic2 {
    private final List<String> output;
    private final double scaleFactor;
    private final Dimension2D dim;
    private final String svgLinkTarget;
    private final String hoverPathColorRGB;
    private final long seed;
    private final String preserveAspectRatio;

    @Override
    protected AbstractCommonUGraphic copyUGraphic() {
        return new UGraphicDebug(this, this.output, this.scaleFactor, this.dim, this.svgLinkTarget, this.hoverPathColorRGB, this.seed, this.preserveAspectRatio);
    }

    private UGraphicDebug(UGraphicDebug other, List<String> output, double scaleFactor, Dimension2D dim, String svgLinkTarget, String hoverPathColorRGB, long seed, String preserveAspectRatio) {
        super(other);
        this.output = output;
        this.scaleFactor = scaleFactor;
        this.dim = dim;
        this.svgLinkTarget = svgLinkTarget;
        this.hoverPathColorRGB = hoverPathColorRGB;
        this.seed = seed;
        this.preserveAspectRatio = preserveAspectRatio;
    }

    public UGraphicDebug(double scaleFactor, Dimension2D dim, String svgLinkTarget, String hoverPathColorRGB, long seed, String preserveAspectRatio) {
        super(new ColorMapperIdentity());
        this.output = new ArrayList<String>();
        this.scaleFactor = scaleFactor;
        this.dim = dim;
        this.svgLinkTarget = svgLinkTarget;
        this.hoverPathColorRGB = hoverPathColorRGB;
        this.seed = seed;
        this.preserveAspectRatio = preserveAspectRatio;
    }

    @Override
    public StringBounder getStringBounder() {
        return new StringBounderDebug();
    }

    @Override
    public void draw(UShape shape) {
        if (shape instanceof ULine) {
            this.outLine((ULine)shape);
        } else if (shape instanceof URectangle) {
            this.outRectangle((URectangle)shape);
        } else if (shape instanceof UText) {
            this.outText((UText)shape);
        } else if (shape instanceof UPolygon) {
            this.outPolygon((UPolygon)shape);
        } else if (shape instanceof UEllipse) {
            this.outEllipse((UEllipse)shape);
        } else if (shape instanceof UEmpty) {
            this.outEmpty((UEmpty)shape);
        } else if (shape instanceof UPath) {
            this.outPath((UPath)shape);
        } else if (shape instanceof UComment) {
            this.outComment((UComment)shape);
        } else if (shape instanceof DotPath) {
            this.outPath(((DotPath)shape).toUPath());
        } else if (shape instanceof UCenteredCharacter) {
            this.outCenteredCharacter((UCenteredCharacter)shape);
        } else {
            System.err.println("UGraphicDebug " + shape.getClass().getSimpleName());
            this.output.add("UGraphicDebug " + shape.getClass().getSimpleName() + " " + new Date());
        }
    }

    private void outCenteredCharacter(UCenteredCharacter shape) {
        this.output.add("CENTERED_CHAR:");
        this.output.add("  char: " + shape.getChar());
        this.output.add("  position: " + this.pointd(this.getTranslateX(), this.getTranslateY()));
        this.output.add("  font: " + shape.getFont().toStringDebug());
        this.output.add("  color: " + this.colorToString(this.getParam().getColor()));
        this.output.add("");
    }

    private void outComment(UComment shape) {
        this.output.add("COMMENT: " + shape.getComment());
    }

    private void outPath(UPath shape) {
        this.output.add("PATH:");
        for (USegment seg : shape) {
            USegmentType type = seg.getSegmentType();
            double[] coord = seg.getCoord();
            this.output.add("   - type: " + (Object)((Object)type));
            if (type == USegmentType.SEG_ARCTO) {
                this.output.add("     radius: " + this.pointd(coord[0], coord[1]));
                this.output.add("     angle: " + coord[2]);
                this.output.add("     largeArcFlag: " + (coord[3] != 0.0));
                this.output.add("     sweepFlag: " + (coord[4] != 0.0));
                this.output.add("     dest: " + this.pointd(coord[5], coord[6]));
                continue;
            }
            for (int i = 0; i < type.getNbPoints(); ++i) {
                String key = "     pt" + (i + 1) + ": ";
                this.output.add(key + this.pointd(coord[2 * i], coord[2 * i + 1]));
            }
        }
        this.output.add("  stroke: " + this.getParam().getStroke());
        this.output.add("  shadow: " + (int)shape.getDeltaShadow());
        this.output.add("  color: " + this.colorToString(this.getParam().getColor()));
        this.output.add("  backcolor: " + this.colorToString(this.getParam().getBackcolor()));
        this.output.add("");
    }

    private void outPolygon(UPolygon shape) {
        this.output.add("POLYGON:");
        this.output.add("  points:");
        for (Point2D point2D : shape.getPoints()) {
            double xp = this.getTranslateX() + point2D.getX();
            double yp = this.getTranslateY() + point2D.getY();
            this.output.add("   - " + this.pointd(xp, yp));
        }
        this.output.add("  stroke: " + this.getParam().getStroke());
        this.output.add("  shadow: " + (int)shape.getDeltaShadow());
        this.output.add("  color: " + this.colorToString(this.getParam().getColor()));
        this.output.add("  backcolor: " + this.colorToString(this.getParam().getBackcolor()));
        this.output.add("");
    }

    private void outText(UText shape) {
        this.output.add("TEXT:");
        this.output.add("  text: " + shape.getText());
        this.output.add("  position: " + this.pointd(this.getTranslateX(), this.getTranslateY()));
        this.output.add("  orientation: " + shape.getOrientation());
        this.output.add("  font: " + shape.getFontConfiguration().toStringDebug());
        this.output.add("  color: " + this.colorToString(shape.getFontConfiguration().getColor()));
        this.output.add("  extendedColor: " + this.colorToString(shape.getFontConfiguration().getExtendedColor()));
        this.output.add("");
    }

    private void outEmpty(UEmpty shape) {
        this.output.add("EMPTY:");
        this.output.add("  pt1: " + this.pointd(this.getTranslateX(), this.getTranslateY()));
        this.output.add("  pt2: " + this.pointd(this.getTranslateX() + shape.getWidth(), this.getTranslateY() + shape.getHeight()));
        this.output.add("");
    }

    private void outEllipse(UEllipse shape) {
        this.output.add("ELLIPSE:");
        this.output.add("  pt1: " + this.pointd(this.getTranslateX(), this.getTranslateY()));
        this.output.add("  pt2: " + this.pointd(this.getTranslateX() + shape.getWidth(), this.getTranslateY() + shape.getHeight()));
        this.output.add("  start: " + shape.getStart());
        this.output.add("  extend: " + shape.getExtend());
        this.output.add("  stroke: " + this.getParam().getStroke());
        this.output.add("  shadow: " + (int)shape.getDeltaShadow());
        this.output.add("  color: " + this.colorToString(this.getParam().getColor()));
        this.output.add("  backcolor: " + this.colorToString(this.getParam().getBackcolor()));
        this.output.add("");
    }

    private void outRectangle(URectangle shape) {
        this.output.add("RECTANGLE:");
        this.output.add("  pt1: " + this.pointd(this.getTranslateX(), this.getTranslateY()));
        this.output.add("  pt2: " + this.pointd(this.getTranslateX() + shape.getWidth(), this.getTranslateY() + shape.getHeight()));
        this.output.add("  xCorner: " + (int)shape.getRx());
        this.output.add("  yCorner: " + (int)shape.getRy());
        this.output.add("  stroke: " + this.getParam().getStroke());
        this.output.add("  shadow: " + (int)shape.getDeltaShadow());
        this.output.add("  color: " + this.colorToString(this.getParam().getColor()));
        this.output.add("  backcolor: " + this.colorToString(this.getParam().getBackcolor()));
        this.output.add("");
    }

    private void outLine(ULine shape) {
        this.output.add("LINE:");
        this.output.add("  pt1: " + this.pointd(this.getTranslateX(), this.getTranslateY()));
        this.output.add("  pt2: " + this.pointd(this.getTranslateX() + shape.getDX(), this.getTranslateY() + shape.getDY()));
        this.output.add("  stroke: " + this.getParam().getStroke());
        this.output.add("  shadow: " + (int)shape.getDeltaShadow());
        this.output.add("  color: " + this.colorToString(this.getParam().getColor()));
        this.output.add("");
    }

    private String pointd(double x, double y) {
        return String.format(Locale.US, "[ %.4f ; %.4f ]", x, y);
    }

    private String colorToString(HColor color) {
        if (color == null) {
            return "NULL_COLOR";
        }
        if (color instanceof HColorSimple) {
            HColorSimple simple = (HColorSimple)color;
            Color internal = simple.getColor999();
            if (simple.isMonochrome()) {
                return "monochrome " + Integer.toHexString(internal.getRGB());
            }
            return Integer.toHexString(internal.getRGB());
        }
        if (color instanceof HColorMiddle) {
            HColorMiddle middle = (HColorMiddle)color;
            return "middle(" + this.colorToString(middle.getC1()) + " & " + this.colorToString(middle.getC1()) + " )";
        }
        System.err.println("Error colorToString " + color.getClass().getSimpleName());
        return color.getClass().getSimpleName() + " " + new Date();
    }

    @Override
    public void writeImageTOBEMOVED(OutputStream os, String metadata, int dpi) throws IOException {
        this.print(os, "DPI: " + dpi);
        this.print(os, "dimension: " + this.pointd(this.dim.getWidth(), this.dim.getHeight()));
        this.print(os, "scaleFactor: " + String.format(Locale.US, "%.4f", this.scaleFactor));
        this.print(os, "seed: " + this.seed);
        this.print(os, "svgLinkTarget: " + this.svgLinkTarget);
        this.print(os, "hoverPathColorRGB: " + this.hoverPathColorRGB);
        this.print(os, "preserveAspectRatio: " + this.preserveAspectRatio);
        this.print(os, "");
        for (String s : this.output) {
            this.print(os, s);
        }
        os.flush();
    }

    private void print(OutputStream os, String out) throws UnsupportedEncodingException, IOException {
        os.write(out.getBytes("UTF-8"));
        os.write("\n".getBytes("UTF-8"));
    }
}

