/*
 * Decompiled with CFR 0.152.
 */
package jogamp.newt.driver.windows;

import com.jogamp.common.os.Platform;
import com.jogamp.common.util.VersionNumber;
import com.jogamp.nativewindow.AbstractGraphicsConfiguration;
import com.jogamp.nativewindow.GraphicsConfigurationFactory;
import com.jogamp.nativewindow.NativeWindowException;
import com.jogamp.nativewindow.util.InsetsImmutable;
import com.jogamp.nativewindow.util.Point;
import com.jogamp.newt.event.KeyEvent;
import com.jogamp.newt.event.MouseEvent;
import java.nio.ByteBuffer;
import jogamp.nativewindow.windows.GDI;
import jogamp.nativewindow.windows.GDIUtil;
import jogamp.newt.PointerIconImpl;
import jogamp.newt.WindowImpl;
import jogamp.newt.driver.windows.DisplayDriver;
import jogamp.newt.driver.windows.ScreenDriver;

public class WindowDriver
extends WindowImpl {
    private long hmon;
    private long hdc;
    private long hdc_old;
    private long windowHandleClose;
    private short repeatedKey = 0;

    @Override
    protected int lockSurfaceImpl() {
        if (0L != this.hdc) {
            throw new InternalError("surface not released");
        }
        long l = this.getWindowHandle();
        this.hdc = GDI.GetDC(l);
        if (0L == this.hdc) {
            return 1;
        }
        this.hmon = this.MonitorFromWindow0(l);
        return 3;
    }

    @Override
    protected void unlockSurfaceImpl() {
        if (0L != this.hdc) {
            GDI.ReleaseDC(this.getWindowHandle(), this.hdc);
            this.hdc_old = this.hdc;
            this.hdc = 0L;
        }
    }

    @Override
    public final long getSurfaceHandle() {
        return this.hdc;
    }

    @Override
    public boolean hasDeviceChanged() {
        long l;
        if (0L != this.getWindowHandle() && this.hmon != (l = this.MonitorFromWindow0(this.getWindowHandle()))) {
            if (DEBUG_IMPLEMENTATION) {
                System.err.println("Info: Window Device Changed " + Thread.currentThread().getName() + ", HMON " + WindowDriver.toHexString(this.hmon) + " -> " + WindowDriver.toHexString(l));
            }
            this.hmon = l;
            return true;
        }
        return false;
    }

    @Override
    protected void createNativeImpl() {
        long l;
        ScreenDriver screenDriver = (ScreenDriver)this.getScreen();
        DisplayDriver displayDriver = (DisplayDriver)screenDriver.getDisplay();
        AbstractGraphicsConfiguration abstractGraphicsConfiguration = GraphicsConfigurationFactory.getFactory(displayDriver.getGraphicsDevice(), this.capsRequested).chooseGraphicsConfiguration(this.capsRequested, this.capsRequested, this.capabilitiesChooser, screenDriver.getGraphicsScreen(), 0);
        if (null == abstractGraphicsConfiguration) {
            throw new NativeWindowException("Error choosing GraphicsConfiguration creating window: " + this);
        }
        this.setGraphicsConfiguration(abstractGraphicsConfiguration);
        VersionNumber versionNumber = Platform.getOSVersionNumber();
        int n = this.getReconfigureMask(0, true) & 0x47FF;
        int n2 = 0;
        if (0 != (0x400 & n)) {
            n |= 0x400000;
            ++n2;
        }
        if (0 != (0x200 & n)) {
            n |= 0x800000;
            ++n2;
        }
        if (0L == (l = this.CreateWindow0(DisplayDriver.getHInstance(), displayDriver.getWindowClassName(), displayDriver.getWindowClassName(), versionNumber.getMajor(), versionNumber.getMinor(), this.getParentWindowHandle(), this.getX(), this.getY(), this.getWidth(), this.getHeight(), n))) {
            throw new NativeWindowException("Error creating window");
        }
        if (!abstractGraphicsConfiguration.getChosenCapabilities().isBackgroundOpaque()) {
            GDIUtil.DwmSetupTranslucency(l, true);
        }
        this.InitWindow0(l, n);
        this.setWindowHandle(l);
        this.windowHandleClose = l;
        if (0 == (4 & n) && 1 == n2) {
            this.reconfigureWindowImpl(this.getX(), this.getY(), this.getWidth(), this.getHeight(), n);
        }
        if (DEBUG_IMPLEMENTATION) {
            Exception exception = new Exception("Info: Window new window handle " + Thread.currentThread().getName() + " (Parent HWND " + WindowDriver.toHexString(this.getParentWindowHandle()) + ") : HWND " + WindowDriver.toHexString(l) + ", " + Thread.currentThread());
            exception.printStackTrace();
        }
    }

    @Override
    protected void closeNativeImpl() {
        block7: {
            if (0L != this.windowHandleClose) {
                Exception exception;
                block6: {
                    if (0L != this.hdc) {
                        try {
                            GDI.ReleaseDC(this.windowHandleClose, this.hdc);
                        }
                        catch (Throwable throwable) {
                            if (!DEBUG_IMPLEMENTATION) break block6;
                            exception = new Exception("Warning: closeNativeImpl failed - " + Thread.currentThread().getName(), throwable);
                            exception.printStackTrace();
                        }
                    }
                }
                try {
                    GDI.DestroyWindow(this.windowHandleClose);
                }
                catch (Throwable throwable) {
                    if (!DEBUG_IMPLEMENTATION) break block7;
                    exception = new Exception("Warning: closeNativeImpl failed - " + Thread.currentThread().getName(), throwable);
                    exception.printStackTrace();
                }
            }
        }
        this.windowHandleClose = 0L;
        this.hdc = 0L;
        this.hdc_old = 0L;
    }

    @Override
    protected final int getSupportedReconfigMaskImpl() {
        return 32637;
    }

    @Override
    protected boolean reconfigureWindowImpl(int n, int n2, int n3, int n4, int n5) {
        boolean bl;
        if (DEBUG_IMPLEMENTATION) {
            System.err.println("WindowsWindow reconfig.0: " + n + "/" + n2 + " " + n3 + "x" + n4 + ", " + WindowDriver.getReconfigStateMaskString(n5));
        }
        InsetsImmutable insetsImmutable = this.getInsets();
        if (0 == (4 & n5) && 0 != (0xC00000 & n5)) {
            int[] nArray = new int[]{n, n2, n3, n4};
            if (0 != (0x400 & n5) == (0 != (0x200 & n5))) {
                this.resetMaximizedManual(nArray);
            } else {
                this.reconfigMaximizedManual(n5, nArray, insetsImmutable);
            }
            n = nArray[0];
            n2 = nArray[1];
            n3 = nArray[2];
            n4 = nArray[3];
        }
        boolean bl2 = 0 != (0x10000000 & n5);
        boolean bl3 = bl = !this.getChosenCapabilities().isBackgroundOpaque();
        if (bl2 && bl) {
            GDIUtil.DwmSetupTranslucency(this.getWindowHandle(), false);
        }
        this.reconfigureWindow0(this.getParentWindowHandle(), this.getWindowHandle(), n, n2, n3, n4, n5);
        if (bl2 && bl) {
            GDIUtil.DwmSetupTranslucency(this.getWindowHandle(), true);
        }
        if (0 != (Integer.MIN_VALUE & n5)) {
            this.visibleChanged(0 != (1 & n5));
        }
        if (DEBUG_IMPLEMENTATION) {
            System.err.println("WindowsWindow reconfig.X: " + this.getX() + "/" + this.getY() + " " + this.getWidth() + "x" + this.getHeight() + ", " + this.getStateMaskString());
        }
        return true;
    }

    @Override
    protected void requestFocusImpl(boolean bl) {
        this.requestFocus0(this.getWindowHandle(), bl);
    }

    @Override
    protected void setTitleImpl(String string) {
        WindowDriver.setTitle0(this.getWindowHandle(), string);
    }

    @Override
    protected void setPointerIconImpl(PointerIconImpl pointerIconImpl) {
        WindowDriver.setPointerIcon0(this.getWindowHandle(), null != pointerIconImpl ? pointerIconImpl.validatedHandle() : 0L);
    }

    @Override
    protected boolean setPointerVisibleImpl(final boolean bl) {
        final boolean[] blArray = new boolean[]{false};
        this.runOnEDTIfAvail(true, new Runnable(){

            @Override
            public void run() {
                blArray[0] = WindowDriver.setPointerVisible0(WindowDriver.this.getWindowHandle(), bl);
            }
        });
        return blArray[0];
    }

    @Override
    protected boolean confinePointerImpl(final boolean bl) {
        final Boolean[] booleanArray = new Boolean[]{Boolean.FALSE};
        this.runOnEDTIfAvail(true, new Runnable(){

            @Override
            public void run() {
                Point point = WindowDriver.this.convertToPixelUnits(WindowDriver.this.getLocationOnScreenImpl(0, 0));
                booleanArray[0] = WindowDriver.confinePointer0(WindowDriver.this.getWindowHandle(), bl, point.getX(), point.getY(), point.getX() + WindowDriver.this.getSurfaceWidth(), point.getY() + WindowDriver.this.getSurfaceHeight());
            }
        });
        return booleanArray[0];
    }

    @Override
    protected void warpPointerImpl(final int n, final int n2) {
        this.runOnEDTIfAvail(true, new Runnable(){

            @Override
            public void run() {
                Point point = WindowDriver.this.convertToPixelUnits(WindowDriver.this.getLocationOnScreenImpl(n, n2));
                WindowDriver.warpPointer0(WindowDriver.this.getWindowHandle(), point.getX(), point.getY());
            }
        });
    }

    @Override
    protected Point getLocationOnScreenImpl(int n, int n2) {
        return GDIUtil.GetRelativeLocation(this.getWindowHandle(), 0L, n, n2);
    }

    public final void sendTouchScreenEvent(short s, int n, int n2, short[] sArray, int[] nArray, int[] nArray2, float[] fArray, float f) {
        int n3 = sArray.length;
        MouseEvent.PointerType[] pointerTypeArray = new MouseEvent.PointerType[n3];
        for (int i = n3 - 1; i >= 0; --i) {
            pointerTypeArray[i] = MouseEvent.PointerType.TouchScreen;
        }
        this.doPointerEvent(false, false, pointerTypeArray, s, n, n2, false, sArray, nArray, nArray2, fArray, f, new float[]{0.0f, 0.0f, 0.0f}, 1.0f);
    }

    private final boolean handlePressTypedAutoRepeat(boolean bl, int n, short s, short s2, char c) {
        if (this.setKeyPressed(s, true)) {
            boolean bl2 = this.repeatedKey == s;
            this.repeatedKey = s;
            if (!bl) {
                n |= 0x20000000;
                if (bl2) {
                    super.sendKeyEvent((short)300, n, s, s2, c);
                }
                super.sendKeyEvent((short)301, n, s, s2, c);
            }
            return true;
        }
        return false;
    }

    @Override
    public final void sendKeyEvent(short s, int n, short s2, short s3, char c) {
        boolean bl = KeyEvent.isModifierKey(s3);
        switch (s) {
            case 301: {
                if (this.isKeyCodeTracked(s2)) {
                    if (this.repeatedKey == s2 && !bl) {
                        super.sendKeyEvent((short)300, n | 0x20000000, s2, s3, c);
                    }
                    this.setKeyPressed(s2, false);
                    this.repeatedKey = 0;
                }
                super.sendKeyEvent((short)301, n, s2, s3, c);
                break;
            }
            case 300: {
                if (this.handlePressTypedAutoRepeat(bl, n, s2, s3, c)) break;
                super.sendKeyEvent((short)300, n, s2, s3, c);
            }
        }
    }

    @Override
    public final void enqueueKeyEvent(boolean bl, short s, int n, short s2, short s3, char c) {
        throw new InternalError("XXX: Adapt Java Code to Native Code Changes");
    }

    protected static native long getNewtWndProc0();

    protected static native boolean initIDs0(long var0);

    private native long CreateWindow0(long var1, String var3, String var4, int var5, int var6, long var7, int var9, int var10, int var11, int var12, int var13);

    private native void InitWindow0(long var1, int var3);

    private native long MonitorFromWindow0(long var1);

    private native void reconfigureWindow0(long var1, long var3, int var5, int var6, int var7, int var8, int var9);

    private static native void setTitle0(long var0, String var2);

    private native void requestFocus0(long var1, boolean var3);

    private static native boolean setPointerVisible0(long var0, boolean var2);

    private static native boolean confinePointer0(long var0, boolean var2, int var3, int var4, int var5, int var6);

    private static native void warpPointer0(long var0, int var2, int var3);

    private static native ByteBuffer newDirectByteBuffer(long var0, long var2);

    private static native void setPointerIcon0(long var0, long var2);

    static {
        DisplayDriver.initSingleton();
    }
}

