// Automatically generated file. DO NOT EDIT.
// Generated by gen-device-svd.go from LPC1102_4_v4.svd, see https://github.com/posborne/cmsis-svd/tree/master/data/NXP

// +build nxp,lpc1102_04

// LPC1102/04
//

package nxp

import (
	"runtime/interrupt"
	"runtime/volatile"
	"unsafe"
)

// Some information about this device.
const (
	DEVICE = "LPC1102_04"
)

// Interrupt numbers.
const (
	// System configuration
	IRQ_PIO0_0 = 0

	// System configuration
	IRQ_PIO0_8 = 8

	// System configuration
	IRQ_PIO0_9 = 9

	// System configuration
	IRQ_PIO0_10 = 10

	// System configuration
	IRQ_PIO0_11 = 11

	// System configuration
	IRQ_PIO1_0 = 12

	// 16-bitcounter/timers (CT16B0/1)
	IRQ_CT16B0 = 16

	IRQ_CT16B1 = 17

	// 32-bit counter/timers (CT32B0/1)
	IRQ_CT32B0 = 18

	// Product name title=UM10429 Chapter title=LPC11102 32-bit counter/timers (CT32B0/1) Modification date=11/1/2010 Major revision=1 Minor revision=not available
	IRQ_CT32B1 = 19

	// SPI0
	IRQ_SPI0 = 20

	// UART
	IRQ_UART = 21

	// 10-bit ADC
	IRQ_ADC = 24

	// Windowed WatchDog Timer (WDT)
	IRQ_WDT = 25

	// System configuration
	IRQ_BOD = 26

	// Flash controller
	IRQ_FMC = 27

	IRQ_GPIO1 = 30

	// General Purpose I/O (GPIO)
	IRQ_GPIO0 = 31

	// Highest interrupt number on this device.
	IRQ_max = 31
)

// Map interrupt numbers to function names.
// These aren't real calls, they're removed by the compiler.
var (
	_ = interrupt.Register(IRQ_PIO0_0, "PIO0_0_IRQHandler")
	_ = interrupt.Register(IRQ_PIO0_8, "PIO0_8_IRQHandler")
	_ = interrupt.Register(IRQ_PIO0_9, "PIO0_9_IRQHandler")
	_ = interrupt.Register(IRQ_PIO0_10, "PIO0_10_IRQHandler")
	_ = interrupt.Register(IRQ_PIO0_11, "PIO0_11_IRQHandler")
	_ = interrupt.Register(IRQ_PIO1_0, "PIO1_0_IRQHandler")
	_ = interrupt.Register(IRQ_CT16B0, "CT16B0_IRQHandler")
	_ = interrupt.Register(IRQ_CT16B1, "CT16B1_IRQHandler")
	_ = interrupt.Register(IRQ_CT32B0, "CT32B0_IRQHandler")
	_ = interrupt.Register(IRQ_CT32B1, "CT32B1_IRQHandler")
	_ = interrupt.Register(IRQ_SPI0, "SPI0_IRQHandler")
	_ = interrupt.Register(IRQ_UART, "UART_IRQHandler")
	_ = interrupt.Register(IRQ_ADC, "ADC_IRQHandler")
	_ = interrupt.Register(IRQ_WDT, "WDT_IRQHandler")
	_ = interrupt.Register(IRQ_BOD, "BOD_IRQHandler")
	_ = interrupt.Register(IRQ_FMC, "FMC_IRQHandler")
	_ = interrupt.Register(IRQ_GPIO1, "GPIO1_IRQHandler")
	_ = interrupt.Register(IRQ_GPIO0, "GPIO0_IRQHandler")
)

// Peripherals.
var (
	// Windowed WatchDog Timer (WDT)
	WWDT = (*WWDT_Type)(unsafe.Pointer(uintptr(0x40004000)))

	// UART
	UART = (*UART_Type)(unsafe.Pointer(uintptr(0x40008000)))

	// 16-bitcounter/timers (CT16B0/1)
	CT16B0 = (*CT16B0_Type)(unsafe.Pointer(uintptr(0x4000c000)))

	// 16-bitcounter/timers (CT16B0/1)
	CT16B1 = (*CT16B0_Type)(unsafe.Pointer(uintptr(0x40010000)))

	// 32-bit counter/timers (CT32B0/1)
	CT32B0 = (*CT32B0_Type)(unsafe.Pointer(uintptr(0x40014000)))

	// Product name title=UM10429 Chapter title=LPC11102 32-bit counter/timers (CT32B0/1) Modification date=11/1/2010 Major revision=1 Minor revision=not available
	CT32B1 = (*CT32B1_Type)(unsafe.Pointer(uintptr(0x40018000)))

	// 10-bit ADC
	ADC = (*ADC_Type)(unsafe.Pointer(uintptr(0x4001c000)))

	// PMU (PowerManagement Unit)
	PMU = (*PMU_Type)(unsafe.Pointer(uintptr(0x40038000)))

	// Flash controller
	FLASHCTRL = (*FLASHCTRL_Type)(unsafe.Pointer(uintptr(0x4003c000)))

	// SPI0
	SPI0 = (*SPI_Type)(unsafe.Pointer(uintptr(0x40040000)))

	// I/O Configuration
	IOCON = (*IOCON_Type)(unsafe.Pointer(uintptr(0x40044000)))

	// System configuration
	SYSCON = (*SYSCON_Type)(unsafe.Pointer(uintptr(0x40048000)))

	// General Purpose I/O (GPIO)
	GPIO0 = (*GPIO_Type)(unsafe.Pointer(uintptr(0x50000000)))

	// General Purpose I/O (GPIO)
	GPIO1 = (*GPIO_Type)(unsafe.Pointer(uintptr(0x50010000)))
)

// Windowed WatchDog Timer (WDT)
type WWDT_Type struct {
	WDMOD     volatile.Register32 // 0x0
	WDTC      volatile.Register32 // 0x4
	WDFEED    volatile.Register32 // 0x8
	WDTV      volatile.Register32 // 0xC
	_         [4]byte
	WDWARNINT volatile.Register32 // 0x14
	WDWINDOW  volatile.Register32 // 0x18
}

// UART
type UART_Type struct {
	RBR           volatile.Register32 // 0x0
	DLM           volatile.Register32 // 0x4
	IIR           volatile.Register32 // 0x8
	LCR           volatile.Register32 // 0xC
	_             [4]byte
	LSR           volatile.Register32 // 0x14
	_             [4]byte
	SCR           volatile.Register32 // 0x1C
	ACR           volatile.Register32 // 0x20
	_             [4]byte
	FDR           volatile.Register32 // 0x28
	_             [4]byte
	TER           volatile.Register32 // 0x30
	_             [24]byte
	RS485CTRL     volatile.Register32 // 0x4C
	RS485ADRMATCH volatile.Register32 // 0x50
	RS485DLY      volatile.Register32 // 0x54
}

// 16-bitcounter/timers (CT16B0/1)
type CT16B0_Type struct {
	IR   volatile.Register32 // 0x0
	TCR  volatile.Register32 // 0x4
	TC   volatile.Register32 // 0x8
	PR   volatile.Register32 // 0xC
	PC   volatile.Register32 // 0x10
	MCR  volatile.Register32 // 0x14
	MR0  volatile.Register32 // 0x18
	MR1  volatile.Register32 // 0x1C
	MR2  volatile.Register32 // 0x20
	MR3  volatile.Register32 // 0x24
	_    [20]byte
	EMR  volatile.Register32 // 0x3C
	_    [52]byte
	PWMC volatile.Register32 // 0x74
}

// 32-bit counter/timers (CT32B0/1)
type CT32B0_Type struct {
	IR   volatile.Register32 // 0x0
	TCR  volatile.Register32 // 0x4
	TC   volatile.Register32 // 0x8
	PR   volatile.Register32 // 0xC
	PC   volatile.Register32 // 0x10
	MCR  volatile.Register32 // 0x14
	MR0  volatile.Register32 // 0x18
	MR1  volatile.Register32 // 0x1C
	MR2  volatile.Register32 // 0x20
	MR3  volatile.Register32 // 0x24
	_    [20]byte
	EMR  volatile.Register32 // 0x3C
	_    [52]byte
	PWMC volatile.Register32 // 0x74
}

// Product name title=UM10429 Chapter title=LPC11102 32-bit counter/timers (CT32B0/1) Modification date=11/1/2010 Major revision=1 Minor revision=not available
type CT32B1_Type struct {
	IR   volatile.Register32 // 0x0
	TCR  volatile.Register32 // 0x4
	TC   volatile.Register32 // 0x8
	PR   volatile.Register32 // 0xC
	PC   volatile.Register32 // 0x10
	MCR  volatile.Register32 // 0x14
	MR0  volatile.Register32 // 0x18
	MR1  volatile.Register32 // 0x1C
	MR2  volatile.Register32 // 0x20
	MR3  volatile.Register32 // 0x24
	CCR  volatile.Register32 // 0x28
	CR0  volatile.Register32 // 0x2C
	_    [12]byte
	EMR  volatile.Register32 // 0x3C
	_    [48]byte
	CTCR volatile.Register32 // 0x70
	PWMC volatile.Register32 // 0x74
}

// 10-bit ADC
type ADC_Type struct {
	CR    volatile.Register32 // 0x0
	GDR   volatile.Register32 // 0x4
	_     [4]byte
	INTEN volatile.Register32 // 0xC
	DR0   volatile.Register32 // 0x10
	DR1   volatile.Register32 // 0x14
	DR2   volatile.Register32 // 0x18
	DR3   volatile.Register32 // 0x1C
	DR4   volatile.Register32 // 0x20
	_     [12]byte
	STAT  volatile.Register32 // 0x30
}

// PMU (PowerManagement Unit)
type PMU_Type struct {
	PCON volatile.Register32 // 0x0
}

// Flash controller
type FLASHCTRL_Type struct {
	_         [16]byte
	FLASHCFG  volatile.Register32 // 0x10
	_         [12]byte
	FMSSTART  volatile.Register32 // 0x20
	FMSSTOP   volatile.Register32 // 0x24
	_         [4]byte
	FMSW0     volatile.Register32 // 0x2C
	FMSW1     volatile.Register32 // 0x30
	FMSW2     volatile.Register32 // 0x34
	FMSW3     volatile.Register32 // 0x38
	_         [4004]byte
	FMSTAT    volatile.Register32 // 0xFE0
	_         [4]byte
	FMSTATCLR volatile.Register32 // 0xFE8
}

// SPI0
type SPI_Type struct {
	CR0  volatile.Register32 // 0x0
	CR1  volatile.Register32 // 0x4
	DR   volatile.Register32 // 0x8
	SR   volatile.Register32 // 0xC
	CPSR volatile.Register32 // 0x10
	IMSC volatile.Register32 // 0x14
	RIS  volatile.Register32 // 0x18
	MIS  volatile.Register32 // 0x1C
	ICR  volatile.Register32 // 0x20
}

// I/O Configuration
type IOCON_Type struct {
	_             [12]byte
	RESET_PIO0_0  volatile.Register32 // 0xC
	IOCON_PIO0_1  volatile.Register32 // 0x10
	_             [56]byte
	IOCON_PIO0_6  volatile.Register32 // 0x4C
	_             [16]byte
	PIO0_8        volatile.Register32 // 0x60
	PIO0_9        volatile.Register32 // 0x64
	SWCLK_PIO0_10 volatile.Register32 // 0x68
	_             [8]byte
	R_PIO0_11     volatile.Register32 // 0x74
	R_PIO1_0      volatile.Register32 // 0x78
	R_PIO1_1      volatile.Register32 // 0x7C
	R_PIO1_2      volatile.Register32 // 0x80
	_             [12]byte
	SWDIO_PIO1_3  volatile.Register32 // 0x90
	_             [16]byte
	PIO1_6        volatile.Register32 // 0xA4
	PIO1_7        volatile.Register32 // 0xA8
}

// System configuration
type SYSCON_Type struct {
	SYSMEMREMAP   volatile.Register32 // 0x0
	PRESETCTRL    volatile.Register32 // 0x4
	SYSPLLCTRL    volatile.Register32 // 0x8
	SYSPLLSTAT    volatile.Register32 // 0xC
	_             [16]byte
	SYSOSCCTRL    volatile.Register32 // 0x20
	WDTOSCCTRL    volatile.Register32 // 0x24
	IRCCTRL       volatile.Register32 // 0x28
	_             [4]byte
	SYSRSTSTAT    volatile.Register32 // 0x30
	_             [12]byte
	SYSPLLCLKSEL  volatile.Register32 // 0x40
	SYSPLLCLKUEN  volatile.Register32 // 0x44
	_             [40]byte
	MAINCLKSEL    volatile.Register32 // 0x70
	MAINCLKUEN    volatile.Register32 // 0x74
	SYSAHBCLKDIV  volatile.Register32 // 0x78
	_             [4]byte
	SYSAHBCLKCTRL volatile.Register32 // 0x80
	_             [16]byte
	SSP0CLKDIV    volatile.Register32 // 0x94
	UARTCLKDIV    volatile.Register32 // 0x98
	_             [52]byte
	WDTCLKSEL     volatile.Register32 // 0xD0
	WDTCLKUEN     volatile.Register32 // 0xD4
	WDTCLKDIV     volatile.Register32 // 0xD8
	_             [4]byte
	CLKOUTCLKSEL  volatile.Register32 // 0xE0
	CLKOUTUEN     volatile.Register32 // 0xE4
	CLKOUTCLKDIV  volatile.Register32 // 0xE8
	_             [20]byte
	PIOPORCAP0    volatile.Register32 // 0x100
	_             [76]byte
	BODCTRL       volatile.Register32 // 0x150
	SYSTCKCAL     volatile.Register32 // 0x154
	_             [168]byte
	STARTAPRP0    volatile.Register32 // 0x200
	STARTERP0     volatile.Register32 // 0x204
	STARTRSRP0CLR volatile.Register32 // 0x208
	STARTSRP0     volatile.Register32 // 0x20C
	_             [32]byte
	PDSLEEPCFG    volatile.Register32 // 0x230
	PDAWAKECFG    volatile.Register32 // 0x234
	PDRUNCFG      volatile.Register32 // 0x238
	_             [440]byte
	DEVICE_ID     volatile.Register32 // 0x3F4
}

// General Purpose I/O (GPIO)
type GPIO_Type struct {
	_    [16376]byte
	DATA volatile.Register32 // 0x3FF8
	_    [16388]byte
	DIR  volatile.Register32 // 0x8000
	IS   volatile.Register32 // 0x8004
	IBE  volatile.Register32 // 0x8008
	IEV  volatile.Register32 // 0x800C
	IE   volatile.Register32 // 0x8010
	RIS  volatile.Register32 // 0x8014
	MIS  volatile.Register32 // 0x8018
	IC   volatile.Register32 // 0x801C
}

// Bitfields for WWDT: Windowed WatchDog Timer (WDT)
const (
	// WDMOD: Watchdog mode register. This register contains the basic mode and status of the Watchdog Timer.
	// Position of WDEN field.
	WWDT_WDMOD_WDEN_Pos = 0x0
	// Bit mask of WDEN field.
	WWDT_WDMOD_WDEN_Msk = 0x1
	// Bit WDEN.
	WWDT_WDMOD_WDEN = 0x1
	// The watchdog timer is stopped.
	WWDT_WDMOD_WDEN_STOPPED = 0x0
	// The watchdog timer is running.
	WWDT_WDMOD_WDEN_RUN = 0x1
	// Position of WDRESET field.
	WWDT_WDMOD_WDRESET_Pos = 0x1
	// Bit mask of WDRESET field.
	WWDT_WDMOD_WDRESET_Msk = 0x2
	// Bit WDRESET.
	WWDT_WDMOD_WDRESET = 0x2
	// A watchdog timeout will not cause a chip reset.
	WWDT_WDMOD_WDRESET_NORESET = 0x0
	// A watchdog timeout will cause a chip reset.
	WWDT_WDMOD_WDRESET_RESET = 0x1
	// Position of WDTOF field.
	WWDT_WDMOD_WDTOF_Pos = 0x2
	// Bit mask of WDTOF field.
	WWDT_WDMOD_WDTOF_Msk = 0x4
	// Bit WDTOF.
	WWDT_WDMOD_WDTOF = 0x4
	// Position of WDINT field.
	WWDT_WDMOD_WDINT_Pos = 0x3
	// Bit mask of WDINT field.
	WWDT_WDMOD_WDINT_Msk = 0x8
	// Bit WDINT.
	WWDT_WDMOD_WDINT = 0x8
	// Position of WDPROTECT field.
	WWDT_WDMOD_WDPROTECT_Pos = 0x4
	// Bit mask of WDPROTECT field.
	WWDT_WDMOD_WDPROTECT_Msk = 0x10
	// Bit WDPROTECT.
	WWDT_WDMOD_WDPROTECT = 0x10
	// The watchdog reload value (WDTC) can be changed at any time.
	WWDT_WDMOD_WDPROTECT_ANYTIME = 0x0
	// The watchdog reload value (WDTC) can be changed only after the counter is below the value of WDWARNINT and WDWINDOW. Note: this mode is intended for use only when WDRESET =1.
	WWDT_WDMOD_WDPROTECT_LOWCOUNTER = 0x1
	// Position of RESERVED field.
	WWDT_WDMOD_RESERVED_Pos = 0x5
	// Bit mask of RESERVED field.
	WWDT_WDMOD_RESERVED_Msk = 0xffffffe0

	// WDTC: Watchdog timer constant register. This register determines the time-out value.
	// Position of Count field.
	WWDT_WDTC_Count_Pos = 0x0
	// Bit mask of Count field.
	WWDT_WDTC_Count_Msk = 0xffffff
	// Position of RESERVED field.
	WWDT_WDTC_RESERVED_Pos = 0x18
	// Bit mask of RESERVED field.
	WWDT_WDTC_RESERVED_Msk = 0xff000000

	// WDFEED: Watchdog feed sequence register. Writing 0xAA followed by 0x55 to this register reloads the Watchdog timer with the value contained in WDTC.
	// Position of Feed field.
	WWDT_WDFEED_Feed_Pos = 0x0
	// Bit mask of Feed field.
	WWDT_WDFEED_Feed_Msk = 0xff
	// Position of RESERVED field.
	WWDT_WDFEED_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	WWDT_WDFEED_RESERVED_Msk = 0xffffff00

	// WDTV: Watchdog timer value register. This register reads out the current value of the Watchdog timer.
	// Position of Count field.
	WWDT_WDTV_Count_Pos = 0x0
	// Bit mask of Count field.
	WWDT_WDTV_Count_Msk = 0xffffff
	// Position of RESERVED field.
	WWDT_WDTV_RESERVED_Pos = 0x18
	// Bit mask of RESERVED field.
	WWDT_WDTV_RESERVED_Msk = 0xff000000

	// WDWARNINT: Watchdog Warning Interrupt compare value.
	// Position of WARNINT field.
	WWDT_WDWARNINT_WARNINT_Pos = 0x0
	// Bit mask of WARNINT field.
	WWDT_WDWARNINT_WARNINT_Msk = 0x3ff
	// Position of RESERVED field.
	WWDT_WDWARNINT_RESERVED_Pos = 0xa
	// Bit mask of RESERVED field.
	WWDT_WDWARNINT_RESERVED_Msk = 0xfffffc00

	// WDWINDOW: Watchdog Window compare value.
	// Position of WINDOW field.
	WWDT_WDWINDOW_WINDOW_Pos = 0x0
	// Bit mask of WINDOW field.
	WWDT_WDWINDOW_WINDOW_Msk = 0xffffff
	// Position of RESERVED field.
	WWDT_WDWINDOW_RESERVED_Pos = 0x18
	// Bit mask of RESERVED field.
	WWDT_WDWINDOW_RESERVED_Msk = 0xff000000
)

// Bitfields for UART: UART
const (
	// RBR: Receiver Buffer Register. Contains the next received character to be read. (DLAB=0)
	// Position of RBR field.
	UART_RBR_RBR_Pos = 0x0
	// Bit mask of RBR field.
	UART_RBR_RBR_Msk = 0xff
	// Position of RESERVED field.
	UART_RBR_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	UART_RBR_RESERVED_Msk = 0xffffff00

	// THR: Transmit Holding Register. The next character to be transmitted is written here. (DLAB=0)
	// Position of THR field.
	UART_THR_THR_Pos = 0x0
	// Bit mask of THR field.
	UART_THR_THR_Msk = 0xff
	// Position of RESERVED field.
	UART_THR_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	UART_THR_RESERVED_Msk = 0xffffff00

	// DLL: Divisor Latch LSB. Least significant byte of the baud rate divisor value. The full divisor is used to generate a baud rate from the fractional rate divider. (DLAB=1)
	// Position of DLLSB field.
	UART_DLL_DLLSB_Pos = 0x0
	// Bit mask of DLLSB field.
	UART_DLL_DLLSB_Msk = 0xff
	// Position of RESERVED field.
	UART_DLL_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	UART_DLL_RESERVED_Msk = 0xffffff00

	// DLM: Divisor Latch MSB. Most significant byte of the baud rate divisor value. The full divisor is used to generate a baud rate from the fractional rate divider. (DLAB=1)
	// Position of DLMSB field.
	UART_DLM_DLMSB_Pos = 0x0
	// Bit mask of DLMSB field.
	UART_DLM_DLMSB_Msk = 0xff
	// Position of RESERVED field.
	UART_DLM_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	UART_DLM_RESERVED_Msk = 0xffffff00

	// IER: Interrupt Enable Register. Contains individual interrupt enable bits for the 7 potential UART interrupts. (DLAB=0)
	// Position of RBRIE field.
	UART_IER_RBRIE_Pos = 0x0
	// Bit mask of RBRIE field.
	UART_IER_RBRIE_Msk = 0x1
	// Bit RBRIE.
	UART_IER_RBRIE = 0x1
	// Disable the RDA interrupt.
	UART_IER_RBRIE_DISABLE_THE_RDA_INTE = 0x0
	// Enable the RDA interrupt.
	UART_IER_RBRIE_ENABLE_THE_RDA_INTER = 0x1
	// Position of THREIE field.
	UART_IER_THREIE_Pos = 0x1
	// Bit mask of THREIE field.
	UART_IER_THREIE_Msk = 0x2
	// Bit THREIE.
	UART_IER_THREIE = 0x2
	// Disable the THRE interrupt.
	UART_IER_THREIE_DISABLE_THE_THRE_INT = 0x0
	// Enable the THRE interrupt.
	UART_IER_THREIE_ENABLE_THE_THRE_INTE = 0x1
	// Position of RXLIE field.
	UART_IER_RXLIE_Pos = 0x2
	// Bit mask of RXLIE field.
	UART_IER_RXLIE_Msk = 0x4
	// Bit RXLIE.
	UART_IER_RXLIE = 0x4
	// Disable the RX line status interrupts.
	UART_IER_RXLIE_DISABLE_THE_RX_LINE_ = 0x0
	// Enable the RX line status interrupts.
	UART_IER_RXLIE_ENABLE_THE_RX_LINE_S = 0x1
	// Position of RESERVED field.
	UART_IER_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	UART_IER_RESERVED_Msk = 0x8
	// Bit RESERVED.
	UART_IER_RESERVED = 0x8
	// Position of RESERVED field.
	UART_IER_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	UART_IER_RESERVED_Msk = 0x70
	// Position of RESERVED field.
	UART_IER_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	UART_IER_RESERVED_Msk = 0x80
	// Bit RESERVED.
	UART_IER_RESERVED = 0x80
	// Position of ABEOINTEN field.
	UART_IER_ABEOINTEN_Pos = 0x8
	// Bit mask of ABEOINTEN field.
	UART_IER_ABEOINTEN_Msk = 0x100
	// Bit ABEOINTEN.
	UART_IER_ABEOINTEN = 0x100
	// Disable end of auto-baud Interrupt.
	UART_IER_ABEOINTEN_DISABLE_END_OF_AUTO_ = 0x0
	// Enable end of auto-baud Interrupt.
	UART_IER_ABEOINTEN_ENABLE_END_OF_AUTO_B = 0x1
	// Position of ABTOINTEN field.
	UART_IER_ABTOINTEN_Pos = 0x9
	// Bit mask of ABTOINTEN field.
	UART_IER_ABTOINTEN_Msk = 0x200
	// Bit ABTOINTEN.
	UART_IER_ABTOINTEN = 0x200
	// Disable auto-baud time-out Interrupt.
	UART_IER_ABTOINTEN_DISABLE_AUTO_BAUD_TI = 0x0
	// Enable auto-baud time-out Interrupt.
	UART_IER_ABTOINTEN_ENABLE_AUTO_BAUD_TIM = 0x1
	// Position of RESERVED field.
	UART_IER_RESERVED_Pos = 0xa
	// Bit mask of RESERVED field.
	UART_IER_RESERVED_Msk = 0xfffffc00

	// IIR: Interrupt ID Register. Identifies which interrupt(s) are pending.
	// Position of INTSTATUS field.
	UART_IIR_INTSTATUS_Pos = 0x0
	// Bit mask of INTSTATUS field.
	UART_IIR_INTSTATUS_Msk = 0x1
	// Bit INTSTATUS.
	UART_IIR_INTSTATUS = 0x1
	// At least one interrupt is pending.
	UART_IIR_INTSTATUS_PENDING = 0x0
	// No interrupt is pending.
	UART_IIR_INTSTATUS_NO_INTERRUPT_IS_PEND = 0x1
	// Position of INTID field.
	UART_IIR_INTID_Pos = 0x1
	// Bit mask of INTID field.
	UART_IIR_INTID_Msk = 0xe
	// 1 - Receive Line Status (RLS).
	UART_IIR_INTID_1_RECEIVE_LINE_S = 0x3
	// 2a - Receive Data Available (RDA).
	UART_IIR_INTID_2A__RECEIVE_DATA_AV = 0x2
	// 2b - Character Time-out Indicator (CTI).
	UART_IIR_INTID_2B__CHARACTER_TIME_ = 0x6
	// 3 - THRE Interrupt.
	UART_IIR_INTID_3_THRE_INTERRUPT = 0x1
	// 4 - Modem interrupt.
	UART_IIR_INTID_4_MODEM_INTERRUP = 0x0
	// Position of RESERVED field.
	UART_IIR_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	UART_IIR_RESERVED_Msk = 0x30
	// Position of FIFOENABLE field.
	UART_IIR_FIFOENABLE_Pos = 0x6
	// Bit mask of FIFOENABLE field.
	UART_IIR_FIFOENABLE_Msk = 0xc0
	// Position of ABEOINT field.
	UART_IIR_ABEOINT_Pos = 0x8
	// Bit mask of ABEOINT field.
	UART_IIR_ABEOINT_Msk = 0x100
	// Bit ABEOINT.
	UART_IIR_ABEOINT = 0x100
	// Position of ABTOINT field.
	UART_IIR_ABTOINT_Pos = 0x9
	// Bit mask of ABTOINT field.
	UART_IIR_ABTOINT_Msk = 0x200
	// Bit ABTOINT.
	UART_IIR_ABTOINT = 0x200
	// Position of RESERVED field.
	UART_IIR_RESERVED_Pos = 0xa
	// Bit mask of RESERVED field.
	UART_IIR_RESERVED_Msk = 0xfffffc00

	// FCR: FIFO Control Register. Controls UART FIFO usage and modes.
	// Position of FIFOEN field.
	UART_FCR_FIFOEN_Pos = 0x0
	// Bit mask of FIFOEN field.
	UART_FCR_FIFOEN_Msk = 0x1
	// Bit FIFOEN.
	UART_FCR_FIFOEN = 0x1
	// UART FIFOs are disabled. Must not be used in the application.
	UART_FCR_FIFOEN_DISABLED = 0x0
	// Active high enable for both UART Rx and TX FIFOs and FCR[7:1] access. This bit must be set for proper UART operation. Any transition on this bit will automatically clear the UART FIFOs.
	UART_FCR_FIFOEN_ENABLED = 0x1
	// Position of RXFIFORES field.
	UART_FCR_RXFIFORES_Pos = 0x1
	// Bit mask of RXFIFORES field.
	UART_FCR_RXFIFORES_Msk = 0x2
	// Bit RXFIFORES.
	UART_FCR_RXFIFORES = 0x2
	// No impact on either of UART FIFOs.
	UART_FCR_RXFIFORES_NO_IMPACT_ON_EITHER_ = 0x0
	// Writing a logic 1 to FCR[1] will clear all bytes in UART Rx FIFO, reset the pointer logic. This bit is self-clearing.
	UART_FCR_RXFIFORES_CLEAR = 0x1
	// Position of TXFIFORES field.
	UART_FCR_TXFIFORES_Pos = 0x2
	// Bit mask of TXFIFORES field.
	UART_FCR_TXFIFORES_Msk = 0x4
	// Bit TXFIFORES.
	UART_FCR_TXFIFORES = 0x4
	// No impact on either of UART FIFOs.
	UART_FCR_TXFIFORES_NO_IMPACT_ON_EITHER_ = 0x0
	// Writing a logic 1 to FCR[2] will clear all bytes in UART TX FIFO, reset the pointer logic. This bit is self-clearing.
	UART_FCR_TXFIFORES_CLEAR = 0x1
	// Position of RESERVED field.
	UART_FCR_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	UART_FCR_RESERVED_Msk = 0x8
	// Bit RESERVED.
	UART_FCR_RESERVED = 0x8
	// Position of RESERVED field.
	UART_FCR_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	UART_FCR_RESERVED_Msk = 0x30
	// Position of RXTL field.
	UART_FCR_RXTL_Pos = 0x6
	// Bit mask of RXTL field.
	UART_FCR_RXTL_Msk = 0xc0
	// Trigger level 0 (1 character or 0x01).
	UART_FCR_RXTL_TRIGGER_LEVEL_0_1_C = 0x0
	// Trigger level 1 (4 characters or 0x04).
	UART_FCR_RXTL_TRIGGER_LEVEL_1_4_C = 0x1
	// Trigger level 2 (8 characters or 0x08).
	UART_FCR_RXTL_TRIGGER_LEVEL_2_8_C = 0x2
	// Trigger level 3 (14 characters or 0x0E).
	UART_FCR_RXTL_TRIGGER_LEVEL_3_14_ = 0x3
	// Position of RESERVED field.
	UART_FCR_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	UART_FCR_RESERVED_Msk = 0xffffff00

	// LCR: Line Control Register. Contains controls for frame formatting and break generation.
	// Position of WLS field.
	UART_LCR_WLS_Pos = 0x0
	// Bit mask of WLS field.
	UART_LCR_WLS_Msk = 0x3
	// 5-bit character length.
	UART_LCR_WLS_5_BIT_CHARACTER_LENG = 0x0
	// 6-bit character length.
	UART_LCR_WLS_6_BIT_CHARACTER_LENG = 0x1
	// 7-bit character length.
	UART_LCR_WLS_7_BIT_CHARACTER_LENG = 0x2
	// 8-bit character length.
	UART_LCR_WLS_8_BIT_CHARACTER_LENG = 0x3
	// Position of SBS field.
	UART_LCR_SBS_Pos = 0x2
	// Bit mask of SBS field.
	UART_LCR_SBS_Msk = 0x4
	// Bit SBS.
	UART_LCR_SBS = 0x4
	// 1 stop bit.
	UART_LCR_SBS_1_STOP_BIT_ = 0x0
	// 2 stop bits (1.5 if LCR[1:0]=00).
	UART_LCR_SBS_2_STOP_BITS = 0x1
	// Position of PE field.
	UART_LCR_PE_Pos = 0x3
	// Bit mask of PE field.
	UART_LCR_PE_Msk = 0x8
	// Bit PE.
	UART_LCR_PE = 0x8
	// Disable parity generation and checking.
	UART_LCR_PE_DISABLE_PARITY_GENER = 0x0
	// Enable parity generation and checking.
	UART_LCR_PE_ENABLE_PARITY_GENERA = 0x1
	// Position of PS field.
	UART_LCR_PS_Pos = 0x4
	// Bit mask of PS field.
	UART_LCR_PS_Msk = 0x30
	// Odd parity. Number of 1s in the transmitted character and the attached parity bit will be odd.
	UART_LCR_PS_ODD_PARITY_NUMBER_O = 0x0
	// Even Parity. Number of 1s in the transmitted character and the attached parity bit will be even.
	UART_LCR_PS_EVEN_PARITY_NUMBER_ = 0x1
	// Forced 1 stick parity.
	UART_LCR_PS_FORCED_1_STICK_PARIT = 0x2
	// Forced 0 stick parity.
	UART_LCR_PS_FORCED_0_STICK_PARIT = 0x3
	// Position of BC field.
	UART_LCR_BC_Pos = 0x6
	// Bit mask of BC field.
	UART_LCR_BC_Msk = 0x40
	// Bit BC.
	UART_LCR_BC = 0x40
	// Disable break transmission.
	UART_LCR_BC_DISABLE_BREAK_TRANSM = 0x0
	// Enable break transmission. Output pin UART TXD is forced to logic 0 when LCR[6] is active high.
	UART_LCR_BC_ENABLE_BREAK_TRANSMI = 0x1
	// Position of DLAB field.
	UART_LCR_DLAB_Pos = 0x7
	// Bit mask of DLAB field.
	UART_LCR_DLAB_Msk = 0x80
	// Bit DLAB.
	UART_LCR_DLAB = 0x80
	// Disable access to Divisor Latches.
	UART_LCR_DLAB_DISABLE_ACCESS_TO_DI = 0x0
	// Enable access to Divisor Latches.
	UART_LCR_DLAB_ENABLE_ACCESS_TO_DIV = 0x1
	// Position of RESERVED field.
	UART_LCR_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	UART_LCR_RESERVED_Msk = 0xffffff00

	// LSR: Line Status Register. Contains flags for transmit and receive status, including line errors.
	// Position of RDR field.
	UART_LSR_RDR_Pos = 0x0
	// Bit mask of RDR field.
	UART_LSR_RDR_Msk = 0x1
	// Bit RDR.
	UART_LSR_RDR = 0x1
	// RBR is empty.
	UART_LSR_RDR_EMPTY_ = 0x0
	// RBR contains valid data.
	UART_LSR_RDR_VALID = 0x1
	// Position of OE field.
	UART_LSR_OE_Pos = 0x1
	// Bit mask of OE field.
	UART_LSR_OE_Msk = 0x2
	// Bit OE.
	UART_LSR_OE = 0x2
	// Overrun error status is inactive.
	UART_LSR_OE_INACTIVE = 0x0
	// Overrun error status is active.
	UART_LSR_OE_ACTIVE = 0x1
	// Position of PE field.
	UART_LSR_PE_Pos = 0x2
	// Bit mask of PE field.
	UART_LSR_PE_Msk = 0x4
	// Bit PE.
	UART_LSR_PE = 0x4
	// Parity error status is inactive.
	UART_LSR_PE_INACTIVE = 0x0
	// Parity error status is active.
	UART_LSR_PE_ACTIVE = 0x1
	// Position of FE field.
	UART_LSR_FE_Pos = 0x3
	// Bit mask of FE field.
	UART_LSR_FE_Msk = 0x8
	// Bit FE.
	UART_LSR_FE = 0x8
	// Framing error status is inactive.
	UART_LSR_FE_INACTIVE = 0x0
	// Framing error status is active.
	UART_LSR_FE_ACTIVE = 0x1
	// Position of BI field.
	UART_LSR_BI_Pos = 0x4
	// Bit mask of BI field.
	UART_LSR_BI_Msk = 0x10
	// Bit BI.
	UART_LSR_BI = 0x10
	// Break interrupt status is inactive.
	UART_LSR_BI_INACTIVE = 0x0
	// Break interrupt status is active.
	UART_LSR_BI_ACTIVE = 0x1
	// Position of THRE field.
	UART_LSR_THRE_Pos = 0x5
	// Bit mask of THRE field.
	UART_LSR_THRE_Msk = 0x20
	// Bit THRE.
	UART_LSR_THRE = 0x20
	// THR contains valid data.
	UART_LSR_THRE_VALID = 0x0
	// THR is empty.
	UART_LSR_THRE_EMPTY_ = 0x1
	// Position of TEMT field.
	UART_LSR_TEMT_Pos = 0x6
	// Bit mask of TEMT field.
	UART_LSR_TEMT_Msk = 0x40
	// Bit TEMT.
	UART_LSR_TEMT = 0x40
	// THR and/or the TSR contains valid data.
	UART_LSR_TEMT_VALID = 0x0
	// THR and the TSR are empty.
	UART_LSR_TEMT_EMPTY_ = 0x1
	// Position of RXFE field.
	UART_LSR_RXFE_Pos = 0x7
	// Bit mask of RXFE field.
	UART_LSR_RXFE_Msk = 0x80
	// Bit RXFE.
	UART_LSR_RXFE = 0x80
	// RBR contains no UART RX errors or FCR[0]=0.
	UART_LSR_RXFE_NOERROR = 0x0
	// UART RBR contains at least one UART RX error.
	UART_LSR_RXFE_ERROR = 0x1
	// Position of RESERVED field.
	UART_LSR_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	UART_LSR_RESERVED_Msk = 0xffffff00

	// SCR: Scratch Pad Register. Eight-bit temporary storage for software.
	// Position of PAD field.
	UART_SCR_PAD_Pos = 0x0
	// Bit mask of PAD field.
	UART_SCR_PAD_Msk = 0xff
	// Position of RESERVED field.
	UART_SCR_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	UART_SCR_RESERVED_Msk = 0xffffff00

	// ACR: Auto-baud Control Register. Contains controls for the auto-baud feature.
	// Position of START field.
	UART_ACR_START_Pos = 0x0
	// Bit mask of START field.
	UART_ACR_START_Msk = 0x1
	// Bit START.
	UART_ACR_START = 0x1
	// Auto-baud stop (auto-baud is not running).
	UART_ACR_START_STOP = 0x0
	// Auto-baud start (auto-baud is running). Auto-baud run bit. This bit is automatically cleared after auto-baud completion.
	UART_ACR_START_START = 0x1
	// Position of MODE field.
	UART_ACR_MODE_Pos = 0x1
	// Bit mask of MODE field.
	UART_ACR_MODE_Msk = 0x2
	// Bit MODE.
	UART_ACR_MODE = 0x2
	// Mode 0.
	UART_ACR_MODE_MODE_0_ = 0x0
	// Mode 1.
	UART_ACR_MODE_MODE_1_ = 0x1
	// Position of AUTORESTART field.
	UART_ACR_AUTORESTART_Pos = 0x2
	// Bit mask of AUTORESTART field.
	UART_ACR_AUTORESTART_Msk = 0x4
	// Bit AUTORESTART.
	UART_ACR_AUTORESTART = 0x4
	// No restart
	UART_ACR_AUTORESTART_NO_RESTART = 0x0
	// Restart in case of time-out (counter restarts at next UART Rx falling edge)
	UART_ACR_AUTORESTART_RESTART_IN_CASE_OF_T = 0x1
	// Position of RESERVED field.
	UART_ACR_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	UART_ACR_RESERVED_Msk = 0xf8
	// Position of ABEOINTCLR field.
	UART_ACR_ABEOINTCLR_Pos = 0x8
	// Bit mask of ABEOINTCLR field.
	UART_ACR_ABEOINTCLR_Msk = 0x100
	// Bit ABEOINTCLR.
	UART_ACR_ABEOINTCLR = 0x100
	// Writing a 0 has no impact.
	UART_ACR_ABEOINTCLR_NOIMPACT = 0x0
	// Writing a 1 will clear the corresponding interrupt in the IIR.
	UART_ACR_ABEOINTCLR_CLEAR = 0x1
	// Position of ABTOINTCLR field.
	UART_ACR_ABTOINTCLR_Pos = 0x9
	// Bit mask of ABTOINTCLR field.
	UART_ACR_ABTOINTCLR_Msk = 0x200
	// Bit ABTOINTCLR.
	UART_ACR_ABTOINTCLR = 0x200
	// Writing a 0 has no impact.
	UART_ACR_ABTOINTCLR_NOIMPACT = 0x0
	// Writing a 1 will clear the corresponding interrupt in the IIR.
	UART_ACR_ABTOINTCLR_CLEAR = 0x1
	// Position of RESERVED field.
	UART_ACR_RESERVED_Pos = 0xa
	// Bit mask of RESERVED field.
	UART_ACR_RESERVED_Msk = 0xfffffc00

	// FDR: Fractional Divider Register. Generates a clock input for the baud rate divider.
	// Position of DIVADDVAL field.
	UART_FDR_DIVADDVAL_Pos = 0x0
	// Bit mask of DIVADDVAL field.
	UART_FDR_DIVADDVAL_Msk = 0xf
	// Position of MULVAL field.
	UART_FDR_MULVAL_Pos = 0x4
	// Bit mask of MULVAL field.
	UART_FDR_MULVAL_Msk = 0xf0
	// Position of RESERVED field.
	UART_FDR_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	UART_FDR_RESERVED_Msk = 0xffffff00

	// TER: Transmit Enable Register. Turns off UART transmitter for use with software flow control.
	// Position of RESERVED field.
	UART_TER_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	UART_TER_RESERVED_Msk = 0x7f
	// Position of TXEN field.
	UART_TER_TXEN_Pos = 0x7
	// Bit mask of TXEN field.
	UART_TER_TXEN_Msk = 0x80
	// Bit TXEN.
	UART_TER_TXEN = 0x80
	// Position of RESERVED field.
	UART_TER_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	UART_TER_RESERVED_Msk = 0xffffff00

	// RS485CTRL: RS-485/EIA-485 Control. Contains controls to configure various aspects of RS-485/EIA-485 modes.
	// Position of NMMEN field.
	UART_RS485CTRL_NMMEN_Pos = 0x0
	// Bit mask of NMMEN field.
	UART_RS485CTRL_NMMEN_Msk = 0x1
	// Bit NMMEN.
	UART_RS485CTRL_NMMEN = 0x1
	// RS-485/EIA-485 Normal Multidrop Mode (NMM) is disabled.
	UART_RS485CTRL_NMMEN_DISABLED = 0x0
	// RS-485/EIA-485 Normal Multidrop Mode (NMM) is enabled. In this mode, an address is detected when a received byte causes the UART to set the parity error and generate an interrupt.
	UART_RS485CTRL_NMMEN_ENABLED = 0x1
	// Position of RXDIS field.
	UART_RS485CTRL_RXDIS_Pos = 0x1
	// Bit mask of RXDIS field.
	UART_RS485CTRL_RXDIS_Msk = 0x2
	// Bit RXDIS.
	UART_RS485CTRL_RXDIS = 0x2
	// The receiver is enabled.
	UART_RS485CTRL_RXDIS_ENABLED = 0x0
	// The receiver is disabled.
	UART_RS485CTRL_RXDIS_DISABLED = 0x1
	// Position of AADEN field.
	UART_RS485CTRL_AADEN_Pos = 0x2
	// Bit mask of AADEN field.
	UART_RS485CTRL_AADEN_Msk = 0x4
	// Bit AADEN.
	UART_RS485CTRL_AADEN = 0x4
	// Auto Address Detect (AAD) is disabled.
	UART_RS485CTRL_AADEN_DISABLED = 0x0
	// Auto Address Detect (AAD) is enabled.
	UART_RS485CTRL_AADEN_ENABLED = 0x1
	// Position of SEL field.
	UART_RS485CTRL_SEL_Pos = 0x3
	// Bit mask of SEL field.
	UART_RS485CTRL_SEL_Msk = 0x8
	// Bit SEL.
	UART_RS485CTRL_SEL = 0x8
	// If direction control is enabled (bit DCTRL = 1), pin RTS is used for direction control.
	UART_RS485CTRL_SEL_RTS = 0x0
	// If direction control is enabled (bit DCTRL = 1), pin DTR is used for direction control.
	UART_RS485CTRL_SEL_DTR = 0x1
	// Position of DCTRL field.
	UART_RS485CTRL_DCTRL_Pos = 0x4
	// Bit mask of DCTRL field.
	UART_RS485CTRL_DCTRL_Msk = 0x10
	// Bit DCTRL.
	UART_RS485CTRL_DCTRL = 0x10
	// Disable Auto Direction Control.
	UART_RS485CTRL_DCTRL_DISABLE_AUTO_DIRECTI = 0x0
	// Enable Auto Direction Control.
	UART_RS485CTRL_DCTRL_ENABLE_AUTO_DIRECTIO = 0x1
	// Position of OINV field.
	UART_RS485CTRL_OINV_Pos = 0x5
	// Bit mask of OINV field.
	UART_RS485CTRL_OINV_Msk = 0x20
	// Bit OINV.
	UART_RS485CTRL_OINV = 0x20
	// The direction control pin will be driven to logic 0 when the transmitter has data to be sent. It will be driven to logic 1 after the last bit of data has been transmitted.
	UART_RS485CTRL_OINV_LOW = 0x0
	// The direction control pin will be driven to logic 1 when the transmitter has data to be sent. It will be driven to logic 0 after the last bit of data has been transmitted.
	UART_RS485CTRL_OINV_HIGH = 0x1
	// Position of RESERVED field.
	UART_RS485CTRL_RESERVED_Pos = 0x6
	// Bit mask of RESERVED field.
	UART_RS485CTRL_RESERVED_Msk = 0xffffffc0

	// RS485ADRMATCH: RS-485/EIA-485 address match. Contains the address match value for RS-485/EIA-485 mode.
	// Position of ADRMATCH field.
	UART_RS485ADRMATCH_ADRMATCH_Pos = 0x0
	// Bit mask of ADRMATCH field.
	UART_RS485ADRMATCH_ADRMATCH_Msk = 0xff
	// Position of RESERVED field.
	UART_RS485ADRMATCH_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	UART_RS485ADRMATCH_RESERVED_Msk = 0xffffff00

	// RS485DLY: RS-485/EIA-485 direction control delay.
	// Position of DLY field.
	UART_RS485DLY_DLY_Pos = 0x0
	// Bit mask of DLY field.
	UART_RS485DLY_DLY_Msk = 0xff
	// Position of RESERVED field.
	UART_RS485DLY_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	UART_RS485DLY_RESERVED_Msk = 0xffffff00
)

// Bitfields for CT16B0: 16-bitcounter/timers (CT16B0/1)
const (
	// IR: Interrupt Register (IR). The IR can be written to clear interrupts. The IR can be read to identify which of five possible interrupt sources are pending.
	// Position of MR0INT field.
	CT16B0_IR_MR0INT_Pos = 0x0
	// Bit mask of MR0INT field.
	CT16B0_IR_MR0INT_Msk = 0x1
	// Bit MR0INT.
	CT16B0_IR_MR0INT = 0x1
	// Position of MR1INT field.
	CT16B0_IR_MR1INT_Pos = 0x1
	// Bit mask of MR1INT field.
	CT16B0_IR_MR1INT_Msk = 0x2
	// Bit MR1INT.
	CT16B0_IR_MR1INT = 0x2
	// Position of MR2INT field.
	CT16B0_IR_MR2INT_Pos = 0x2
	// Bit mask of MR2INT field.
	CT16B0_IR_MR2INT_Msk = 0x4
	// Bit MR2INT.
	CT16B0_IR_MR2INT = 0x4
	// Position of MR3INT field.
	CT16B0_IR_MR3INT_Pos = 0x3
	// Bit mask of MR3INT field.
	CT16B0_IR_MR3INT_Msk = 0x8
	// Bit MR3INT.
	CT16B0_IR_MR3INT = 0x8
	// Position of RESERVED field.
	CT16B0_IR_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	CT16B0_IR_RESERVED_Msk = 0xfffffff0

	// TCR: Timer Control Register (TCR). The TCR is used to control the Timer Counter functions. The Timer Counter can be disabled or reset through the TCR.
	// Position of CEN field.
	CT16B0_TCR_CEN_Pos = 0x0
	// Bit mask of CEN field.
	CT16B0_TCR_CEN_Msk = 0x1
	// Bit CEN.
	CT16B0_TCR_CEN = 0x1
	// Position of CRST field.
	CT16B0_TCR_CRST_Pos = 0x1
	// Bit mask of CRST field.
	CT16B0_TCR_CRST_Msk = 0x2
	// Bit CRST.
	CT16B0_TCR_CRST = 0x2
	// Position of RESERVED field.
	CT16B0_TCR_RESERVED_Pos = 0x2
	// Bit mask of RESERVED field.
	CT16B0_TCR_RESERVED_Msk = 0xfffffffc

	// TC: Timer Counter (TC). The 16-bit TC is incremented every PR+1 cycles of PCLK. The TC is controlled through the TCR.
	// Position of TC field.
	CT16B0_TC_TC_Pos = 0x0
	// Bit mask of TC field.
	CT16B0_TC_TC_Msk = 0xffff
	// Position of RESERVED field.
	CT16B0_TC_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	CT16B0_TC_RESERVED_Msk = 0xffff0000

	// PR: Prescale Register (PR). When the Prescale Counter (below) is equal to this value, the next clock increments the TC and clears the PC.
	// Position of PR field.
	CT16B0_PR_PR_Pos = 0x0
	// Bit mask of PR field.
	CT16B0_PR_PR_Msk = 0xffff
	// Position of RESERVED field.
	CT16B0_PR_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	CT16B0_PR_RESERVED_Msk = 0xffff0000

	// PC: Prescale Counter (PC). The 16-bit PC is a counter which is incremented to the value stored in PR. When the value in PR is reached, the TC is incremented and the PC is cleared. The PC is observable and controllable through the bus interface.
	// Position of PC field.
	CT16B0_PC_PC_Pos = 0x0
	// Bit mask of PC field.
	CT16B0_PC_PC_Msk = 0xffff
	// Position of RESERVED field.
	CT16B0_PC_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	CT16B0_PC_RESERVED_Msk = 0xffff0000

	// MCR: Match Control Register (MCR). The MCR is used to control if an interrupt is generated and if the TC is reset when a Match occurs.
	// Position of MR0I field.
	CT16B0_MCR_MR0I_Pos = 0x0
	// Bit mask of MR0I field.
	CT16B0_MCR_MR0I_Msk = 0x1
	// Bit MR0I.
	CT16B0_MCR_MR0I = 0x1
	// Enabled
	CT16B0_MCR_MR0I_Enabled = 0x1
	// Disabled
	CT16B0_MCR_MR0I_Disabled = 0x0
	// Position of MR0R field.
	CT16B0_MCR_MR0R_Pos = 0x1
	// Bit mask of MR0R field.
	CT16B0_MCR_MR0R_Msk = 0x2
	// Bit MR0R.
	CT16B0_MCR_MR0R = 0x2
	// Enabled
	CT16B0_MCR_MR0R_Enabled = 0x1
	// Disabled
	CT16B0_MCR_MR0R_Disabled = 0x0
	// Position of MR0S field.
	CT16B0_MCR_MR0S_Pos = 0x2
	// Bit mask of MR0S field.
	CT16B0_MCR_MR0S_Msk = 0x4
	// Bit MR0S.
	CT16B0_MCR_MR0S = 0x4
	// Enabled
	CT16B0_MCR_MR0S_Enabled = 0x1
	// Disabled
	CT16B0_MCR_MR0S_Disabled = 0x0
	// Position of MR1I field.
	CT16B0_MCR_MR1I_Pos = 0x3
	// Bit mask of MR1I field.
	CT16B0_MCR_MR1I_Msk = 0x8
	// Bit MR1I.
	CT16B0_MCR_MR1I = 0x8
	// Enabled
	CT16B0_MCR_MR1I_Enabled = 0x1
	// Disabled
	CT16B0_MCR_MR1I_Disabled = 0x0
	// Position of MR1R field.
	CT16B0_MCR_MR1R_Pos = 0x4
	// Bit mask of MR1R field.
	CT16B0_MCR_MR1R_Msk = 0x10
	// Bit MR1R.
	CT16B0_MCR_MR1R = 0x10
	// Enabled
	CT16B0_MCR_MR1R_Enabled = 0x1
	// Disabled
	CT16B0_MCR_MR1R_Disabled = 0x0
	// Position of MR1S field.
	CT16B0_MCR_MR1S_Pos = 0x5
	// Bit mask of MR1S field.
	CT16B0_MCR_MR1S_Msk = 0x20
	// Bit MR1S.
	CT16B0_MCR_MR1S = 0x20
	// Enabled
	CT16B0_MCR_MR1S_Enabled = 0x1
	// Disabled
	CT16B0_MCR_MR1S_Disabled = 0x0
	// Position of MR2I field.
	CT16B0_MCR_MR2I_Pos = 0x6
	// Bit mask of MR2I field.
	CT16B0_MCR_MR2I_Msk = 0x40
	// Bit MR2I.
	CT16B0_MCR_MR2I = 0x40
	// Enabled
	CT16B0_MCR_MR2I_Enabled = 0x1
	// Disabled
	CT16B0_MCR_MR2I_Disabled = 0x0
	// Position of MR2R field.
	CT16B0_MCR_MR2R_Pos = 0x7
	// Bit mask of MR2R field.
	CT16B0_MCR_MR2R_Msk = 0x80
	// Bit MR2R.
	CT16B0_MCR_MR2R = 0x80
	// Enabled
	CT16B0_MCR_MR2R_Enabled = 0x1
	// Disabled
	CT16B0_MCR_MR2R_Disabled = 0x0
	// Position of MR2S field.
	CT16B0_MCR_MR2S_Pos = 0x8
	// Bit mask of MR2S field.
	CT16B0_MCR_MR2S_Msk = 0x100
	// Bit MR2S.
	CT16B0_MCR_MR2S = 0x100
	// Enabled
	CT16B0_MCR_MR2S_Enabled = 0x1
	// Disabled
	CT16B0_MCR_MR2S_Disabled = 0x0
	// Position of MR3I field.
	CT16B0_MCR_MR3I_Pos = 0x9
	// Bit mask of MR3I field.
	CT16B0_MCR_MR3I_Msk = 0x200
	// Bit MR3I.
	CT16B0_MCR_MR3I = 0x200
	// Enabled
	CT16B0_MCR_MR3I_Enabled = 0x1
	// Disabled
	CT16B0_MCR_MR3I_Disabled = 0x0
	// Position of MR3R field.
	CT16B0_MCR_MR3R_Pos = 0xa
	// Bit mask of MR3R field.
	CT16B0_MCR_MR3R_Msk = 0x400
	// Bit MR3R.
	CT16B0_MCR_MR3R = 0x400
	// Enabled
	CT16B0_MCR_MR3R_Enabled = 0x1
	// Disabled
	CT16B0_MCR_MR3R_Disabled = 0x0
	// Position of MR3S field.
	CT16B0_MCR_MR3S_Pos = 0xb
	// Bit mask of MR3S field.
	CT16B0_MCR_MR3S_Msk = 0x800
	// Bit MR3S.
	CT16B0_MCR_MR3S = 0x800
	// Enabled
	CT16B0_MCR_MR3S_Enabled = 0x1
	// Disabled
	CT16B0_MCR_MR3S_Disabled = 0x0
	// Position of RESERVED field.
	CT16B0_MCR_RESERVED_Pos = 0xc
	// Bit mask of RESERVED field.
	CT16B0_MCR_RESERVED_Msk = 0xfffff000

	// MR0: Match Register. MR can be enabled through the MCR to reset the TC, stop both the TC and PC, and/or generate aninterrupt every time MR matches the TC.
	// Position of MATCH field.
	CT16B0_MR_MATCH_Pos = 0x0
	// Bit mask of MATCH field.
	CT16B0_MR_MATCH_Msk = 0xffff
	// Position of RESERVED field.
	CT16B0_MR_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	CT16B0_MR_RESERVED_Msk = 0xffff0000

	// EMR: External Match Register (EMR). The EMR controls the match function and the external match pins CT16B0_MAT[2:0].
	// Position of EM0 field.
	CT16B0_EMR_EM0_Pos = 0x0
	// Bit mask of EM0 field.
	CT16B0_EMR_EM0_Msk = 0x1
	// Bit EM0.
	CT16B0_EMR_EM0 = 0x1
	// Position of EM1 field.
	CT16B0_EMR_EM1_Pos = 0x1
	// Bit mask of EM1 field.
	CT16B0_EMR_EM1_Msk = 0x2
	// Bit EM1.
	CT16B0_EMR_EM1 = 0x2
	// Position of EM2 field.
	CT16B0_EMR_EM2_Pos = 0x2
	// Bit mask of EM2 field.
	CT16B0_EMR_EM2_Msk = 0x4
	// Bit EM2.
	CT16B0_EMR_EM2 = 0x4
	// Position of EM3 field.
	CT16B0_EMR_EM3_Pos = 0x3
	// Bit mask of EM3 field.
	CT16B0_EMR_EM3_Msk = 0x8
	// Bit EM3.
	CT16B0_EMR_EM3 = 0x8
	// Position of EMC0 field.
	CT16B0_EMR_EMC0_Pos = 0x4
	// Bit mask of EMC0 field.
	CT16B0_EMR_EMC0_Msk = 0x30
	// Do Nothing.
	CT16B0_EMR_EMC0_DONOTHING = 0x0
	// Clear the corresponding External Match bit/output to 0 (CT16Bn_MATm pin is LOW if pinned out).
	CT16B0_EMR_EMC0_CLEAR = 0x1
	// Set the corresponding External Match bit/output to 1 (CT16Bn_MATm pin is HIGH if pinned out).
	CT16B0_EMR_EMC0_SET = 0x2
	// Toggle the corresponding External Match bit/output.
	CT16B0_EMR_EMC0_TOGGLE = 0x3
	// Position of EMC1 field.
	CT16B0_EMR_EMC1_Pos = 0x6
	// Bit mask of EMC1 field.
	CT16B0_EMR_EMC1_Msk = 0xc0
	// Do Nothing.
	CT16B0_EMR_EMC1_DONOTHING = 0x0
	// Clear the corresponding External Match bit/output to 0 (CT16Bn_MATm pin is LOW if pinned out).
	CT16B0_EMR_EMC1_CLEAR = 0x1
	// Set the corresponding External Match bit/output to 1 (CT16Bn_MATm pin is HIGH if pinned out).
	CT16B0_EMR_EMC1_SET = 0x2
	// Toggle the corresponding External Match bit/output.
	CT16B0_EMR_EMC1_TOGGLE = 0x3
	// Position of EMC2 field.
	CT16B0_EMR_EMC2_Pos = 0x8
	// Bit mask of EMC2 field.
	CT16B0_EMR_EMC2_Msk = 0x300
	// Do Nothing.
	CT16B0_EMR_EMC2_DONOTHING = 0x0
	// Clear the corresponding External Match bit/output to 0 (CT16Bn_MATm pin is LOW if pinned out).
	CT16B0_EMR_EMC2_CLEAR = 0x1
	// Set the corresponding External Match bit/output to 1 (CT16Bn_MATm pin is HIGH if pinned out).
	CT16B0_EMR_EMC2_SET = 0x2
	// Toggle the corresponding External Match bit/output.
	CT16B0_EMR_EMC2_TOGGLE = 0x3
	// Position of EMC3 field.
	CT16B0_EMR_EMC3_Pos = 0xa
	// Bit mask of EMC3 field.
	CT16B0_EMR_EMC3_Msk = 0xc00
	// Do Nothing.
	CT16B0_EMR_EMC3_DONOTHING = 0x0
	// Clear the corresponding External Match bit/output to 0 (CT16Bn_MATm pin is LOW if pinned out).
	CT16B0_EMR_EMC3_CLEAR = 0x1
	// Set the corresponding External Match bit/output to 1 (CT16Bn_MATm pin is HIGH if pinned out).
	CT16B0_EMR_EMC3_SET = 0x2
	// Toggle the corresponding External Match bit/output.
	CT16B0_EMR_EMC3_TOGGLE = 0x3
	// Position of RESERVED field.
	CT16B0_EMR_RESERVED_Pos = 0xc
	// Bit mask of RESERVED field.
	CT16B0_EMR_RESERVED_Msk = 0xfffff000

	// PWMC: PWM Control Register (PWMCON). The PWMCON enables PWM mode for the external match pins CT16B0_MAT[2:0].
	// Position of PWMEN0 field.
	CT16B0_PWMC_PWMEN0_Pos = 0x0
	// Bit mask of PWMEN0 field.
	CT16B0_PWMC_PWMEN0_Msk = 0x1
	// Bit PWMEN0.
	CT16B0_PWMC_PWMEN0 = 0x1
	// Position of PWMEN1 field.
	CT16B0_PWMC_PWMEN1_Pos = 0x1
	// Bit mask of PWMEN1 field.
	CT16B0_PWMC_PWMEN1_Msk = 0x2
	// Bit PWMEN1.
	CT16B0_PWMC_PWMEN1 = 0x2
	// Position of PWMEN2 field.
	CT16B0_PWMC_PWMEN2_Pos = 0x2
	// Bit mask of PWMEN2 field.
	CT16B0_PWMC_PWMEN2_Msk = 0x4
	// Bit PWMEN2.
	CT16B0_PWMC_PWMEN2 = 0x4
	// Position of PWMEN3 field.
	CT16B0_PWMC_PWMEN3_Pos = 0x3
	// Bit mask of PWMEN3 field.
	CT16B0_PWMC_PWMEN3_Msk = 0x8
	// Bit PWMEN3.
	CT16B0_PWMC_PWMEN3 = 0x8
	// Position of RESERVED field.
	CT16B0_PWMC_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	CT16B0_PWMC_RESERVED_Msk = 0xfffffff0
)

// Bitfields for CT32B0: 32-bit counter/timers (CT32B0/1)
const (
	// IR: Interrupt Register (IR). The IR can be written to clear interrupts. The IR can be read to identify which of five possible interrupt sources are pending.
	// Position of MR0INT field.
	CT32B0_IR_MR0INT_Pos = 0x0
	// Bit mask of MR0INT field.
	CT32B0_IR_MR0INT_Msk = 0x1
	// Bit MR0INT.
	CT32B0_IR_MR0INT = 0x1
	// Position of MR1INT field.
	CT32B0_IR_MR1INT_Pos = 0x1
	// Bit mask of MR1INT field.
	CT32B0_IR_MR1INT_Msk = 0x2
	// Bit MR1INT.
	CT32B0_IR_MR1INT = 0x2
	// Position of MR2INT field.
	CT32B0_IR_MR2INT_Pos = 0x2
	// Bit mask of MR2INT field.
	CT32B0_IR_MR2INT_Msk = 0x4
	// Bit MR2INT.
	CT32B0_IR_MR2INT = 0x4
	// Position of MR3INT field.
	CT32B0_IR_MR3INT_Pos = 0x3
	// Bit mask of MR3INT field.
	CT32B0_IR_MR3INT_Msk = 0x8
	// Bit MR3INT.
	CT32B0_IR_MR3INT = 0x8
	// Position of CR0INT field.
	CT32B0_IR_CR0INT_Pos = 0x4
	// Bit mask of CR0INT field.
	CT32B0_IR_CR0INT_Msk = 0x10
	// Bit CR0INT.
	CT32B0_IR_CR0INT = 0x10
	// Position of RESERVED field.
	CT32B0_IR_RESERVED_Pos = 0x5
	// Bit mask of RESERVED field.
	CT32B0_IR_RESERVED_Msk = 0xffffffe0

	// TCR: Timer Control Register (TCR). The TCR is used to control the Timer Counter functions. The Timer Counter can be disabled or reset through the TCR.
	// Position of CEN field.
	CT32B0_TCR_CEN_Pos = 0x0
	// Bit mask of CEN field.
	CT32B0_TCR_CEN_Msk = 0x1
	// Bit CEN.
	CT32B0_TCR_CEN = 0x1
	// Position of CRST field.
	CT32B0_TCR_CRST_Pos = 0x1
	// Bit mask of CRST field.
	CT32B0_TCR_CRST_Msk = 0x2
	// Bit CRST.
	CT32B0_TCR_CRST = 0x2
	// Position of RESERVED field.
	CT32B0_TCR_RESERVED_Pos = 0x2
	// Bit mask of RESERVED field.
	CT32B0_TCR_RESERVED_Msk = 0xfffffffc

	// TC: Timer Counter (TC). The 32-bit TC is incremented every PR+1 cycles of PCLK. The TC is controlled through the TCR.
	// Position of TC field.
	CT32B0_TC_TC_Pos = 0x0
	// Bit mask of TC field.
	CT32B0_TC_TC_Msk = 0xffffffff

	// PR: Prescale Register (PR). When the Prescale Counter (below) is equal to this value, the next clock increments the TC and clears the PC.
	// Position of PR field.
	CT32B0_PR_PR_Pos = 0x0
	// Bit mask of PR field.
	CT32B0_PR_PR_Msk = 0xffffffff

	// PC: Prescale Counter (PC). The 32-bit PC is a counter which is incremented to the value stored in PR. When the value in PR is reached, the TC is incremented and the PC is cleared. The PC is observable and controllable through the bus interface.
	// Position of PC field.
	CT32B0_PC_PC_Pos = 0x0
	// Bit mask of PC field.
	CT32B0_PC_PC_Msk = 0xffffffff

	// MCR: Match Control Register (MCR). The MCR is used to control if an interrupt is generated and if the TC is reset when a Match occurs.
	// Position of MR0I field.
	CT32B0_MCR_MR0I_Pos = 0x0
	// Bit mask of MR0I field.
	CT32B0_MCR_MR0I_Msk = 0x1
	// Bit MR0I.
	CT32B0_MCR_MR0I = 0x1
	// Enabled
	CT32B0_MCR_MR0I_Enabled = 0x1
	// Disabled
	CT32B0_MCR_MR0I_Disabled = 0x0
	// Position of MR0R field.
	CT32B0_MCR_MR0R_Pos = 0x1
	// Bit mask of MR0R field.
	CT32B0_MCR_MR0R_Msk = 0x2
	// Bit MR0R.
	CT32B0_MCR_MR0R = 0x2
	// Enabled
	CT32B0_MCR_MR0R_Enabled = 0x1
	// Disabled
	CT32B0_MCR_MR0R_Disabled = 0x0
	// Position of MR0S field.
	CT32B0_MCR_MR0S_Pos = 0x2
	// Bit mask of MR0S field.
	CT32B0_MCR_MR0S_Msk = 0x4
	// Bit MR0S.
	CT32B0_MCR_MR0S = 0x4
	// Enabled
	CT32B0_MCR_MR0S_Enabled = 0x1
	// Disabled
	CT32B0_MCR_MR0S_Disabled = 0x0
	// Position of MR1I field.
	CT32B0_MCR_MR1I_Pos = 0x3
	// Bit mask of MR1I field.
	CT32B0_MCR_MR1I_Msk = 0x8
	// Bit MR1I.
	CT32B0_MCR_MR1I = 0x8
	// Enabled
	CT32B0_MCR_MR1I_Enabled = 0x1
	// Disabled
	CT32B0_MCR_MR1I_Disabled = 0x0
	// Position of MR1R field.
	CT32B0_MCR_MR1R_Pos = 0x4
	// Bit mask of MR1R field.
	CT32B0_MCR_MR1R_Msk = 0x10
	// Bit MR1R.
	CT32B0_MCR_MR1R = 0x10
	// Enabled
	CT32B0_MCR_MR1R_Enabled = 0x1
	// Disabled
	CT32B0_MCR_MR1R_Disabled = 0x0
	// Position of MR1S field.
	CT32B0_MCR_MR1S_Pos = 0x5
	// Bit mask of MR1S field.
	CT32B0_MCR_MR1S_Msk = 0x20
	// Bit MR1S.
	CT32B0_MCR_MR1S = 0x20
	// Enabled
	CT32B0_MCR_MR1S_Enabled = 0x1
	// Disabled
	CT32B0_MCR_MR1S_Disabled = 0x0
	// Position of MR2I field.
	CT32B0_MCR_MR2I_Pos = 0x6
	// Bit mask of MR2I field.
	CT32B0_MCR_MR2I_Msk = 0x40
	// Bit MR2I.
	CT32B0_MCR_MR2I = 0x40
	// Enabled
	CT32B0_MCR_MR2I_Enabled = 0x1
	// Disabled
	CT32B0_MCR_MR2I_Disabled = 0x0
	// Position of MR2R field.
	CT32B0_MCR_MR2R_Pos = 0x7
	// Bit mask of MR2R field.
	CT32B0_MCR_MR2R_Msk = 0x80
	// Bit MR2R.
	CT32B0_MCR_MR2R = 0x80
	// Enabled
	CT32B0_MCR_MR2R_Enabled = 0x1
	// Disabled
	CT32B0_MCR_MR2R_Disabled = 0x0
	// Position of MR2S field.
	CT32B0_MCR_MR2S_Pos = 0x8
	// Bit mask of MR2S field.
	CT32B0_MCR_MR2S_Msk = 0x100
	// Bit MR2S.
	CT32B0_MCR_MR2S = 0x100
	// Enabled
	CT32B0_MCR_MR2S_Enabled = 0x1
	// Disabled
	CT32B0_MCR_MR2S_Disabled = 0x0
	// Position of MR3I field.
	CT32B0_MCR_MR3I_Pos = 0x9
	// Bit mask of MR3I field.
	CT32B0_MCR_MR3I_Msk = 0x200
	// Bit MR3I.
	CT32B0_MCR_MR3I = 0x200
	// Enabled
	CT32B0_MCR_MR3I_Enabled = 0x1
	// Disabled
	CT32B0_MCR_MR3I_Disabled = 0x0
	// Position of MR3R field.
	CT32B0_MCR_MR3R_Pos = 0xa
	// Bit mask of MR3R field.
	CT32B0_MCR_MR3R_Msk = 0x400
	// Bit MR3R.
	CT32B0_MCR_MR3R = 0x400
	// Enabled
	CT32B0_MCR_MR3R_Enabled = 0x1
	// Disabled
	CT32B0_MCR_MR3R_Disabled = 0x0
	// Position of MR3S field.
	CT32B0_MCR_MR3S_Pos = 0xb
	// Bit mask of MR3S field.
	CT32B0_MCR_MR3S_Msk = 0x800
	// Bit MR3S.
	CT32B0_MCR_MR3S = 0x800
	// Enabled
	CT32B0_MCR_MR3S_Enabled = 0x1
	// Disabled
	CT32B0_MCR_MR3S_Disabled = 0x0
	// Position of RESERVED field.
	CT32B0_MCR_RESERVED_Pos = 0xc
	// Bit mask of RESERVED field.
	CT32B0_MCR_RESERVED_Msk = 0xfffff000

	// MR0: Match Register. MR can be enabled through the MCR to reset the TC, stop both the TC and PC, and/or generate aninterrupt every time MR matches the TC.
	// Position of MATCH field.
	CT32B0_MR_MATCH_Pos = 0x0
	// Bit mask of MATCH field.
	CT32B0_MR_MATCH_Msk = 0xffffffff

	// EMR: External Match Register (EMR). The EMR controls the match function and the external match pins CT32B0_MAT[3:0].
	// Position of EM0 field.
	CT32B0_EMR_EM0_Pos = 0x0
	// Bit mask of EM0 field.
	CT32B0_EMR_EM0_Msk = 0x1
	// Bit EM0.
	CT32B0_EMR_EM0 = 0x1
	// Position of EM1 field.
	CT32B0_EMR_EM1_Pos = 0x1
	// Bit mask of EM1 field.
	CT32B0_EMR_EM1_Msk = 0x2
	// Bit EM1.
	CT32B0_EMR_EM1 = 0x2
	// Position of EM2 field.
	CT32B0_EMR_EM2_Pos = 0x2
	// Bit mask of EM2 field.
	CT32B0_EMR_EM2_Msk = 0x4
	// Bit EM2.
	CT32B0_EMR_EM2 = 0x4
	// Position of EM3 field.
	CT32B0_EMR_EM3_Pos = 0x3
	// Bit mask of EM3 field.
	CT32B0_EMR_EM3_Msk = 0x8
	// Bit EM3.
	CT32B0_EMR_EM3 = 0x8
	// Position of EMC0 field.
	CT32B0_EMR_EMC0_Pos = 0x4
	// Bit mask of EMC0 field.
	CT32B0_EMR_EMC0_Msk = 0x30
	// Do Nothing.
	CT32B0_EMR_EMC0_DONOTHING = 0x0
	// Clear the corresponding External Match bit/output to 0 (CT32Bn_MATm pin is LOW if pinned out).
	CT32B0_EMR_EMC0_CLEAR = 0x1
	// Set the corresponding External Match bit/output to 1 (CT32Bn_MATm pin is HIGH if pinned out).
	CT32B0_EMR_EMC0_SET = 0x2
	// Toggle the corresponding External Match bit/output.
	CT32B0_EMR_EMC0_TOGGLE = 0x3
	// Position of EMC1 field.
	CT32B0_EMR_EMC1_Pos = 0x6
	// Bit mask of EMC1 field.
	CT32B0_EMR_EMC1_Msk = 0xc0
	// Do Nothing.
	CT32B0_EMR_EMC1_DONOTHING = 0x0
	// Clear the corresponding External Match bit/output to 0 (CT32Bn_MATm pin is LOW if pinned out).
	CT32B0_EMR_EMC1_CLEAR = 0x1
	// Set the corresponding External Match bit/output to 1 (CT32Bn_MATm pin is HIGH if pinned out).
	CT32B0_EMR_EMC1_SET = 0x2
	// Toggle the corresponding External Match bit/output.
	CT32B0_EMR_EMC1_TOGGLE = 0x3
	// Position of EMC2 field.
	CT32B0_EMR_EMC2_Pos = 0x8
	// Bit mask of EMC2 field.
	CT32B0_EMR_EMC2_Msk = 0x300
	// Do Nothing.
	CT32B0_EMR_EMC2_DONOTHING = 0x0
	// Clear the corresponding External Match bit/output to 0 (CT32Bn_MATm pin is LOW if pinned out).
	CT32B0_EMR_EMC2_CLEAR = 0x1
	// Set the corresponding External Match bit/output to 1 (CT32Bn_MATm pin is HIGH if pinned out).
	CT32B0_EMR_EMC2_SET = 0x2
	// Toggle the corresponding External Match bit/output.
	CT32B0_EMR_EMC2_TOGGLE = 0x3
	// Position of EMC3 field.
	CT32B0_EMR_EMC3_Pos = 0xa
	// Bit mask of EMC3 field.
	CT32B0_EMR_EMC3_Msk = 0xc00
	// Do Nothing.
	CT32B0_EMR_EMC3_DONOTHING = 0x0
	// Clear the corresponding External Match bit/output to 0 (CT32Bn_MATm pin is LOW if pinned out).
	CT32B0_EMR_EMC3_CLEAR = 0x1
	// Set the corresponding External Match bit/output to 1 (CT32Bn_MATm pin is HIGH if pinned out).
	CT32B0_EMR_EMC3_SET = 0x2
	// Toggle the corresponding External Match bit/output.
	CT32B0_EMR_EMC3_TOGGLE = 0x3
	// Position of RESERVED field.
	CT32B0_EMR_RESERVED_Pos = 0xc
	// Bit mask of RESERVED field.
	CT32B0_EMR_RESERVED_Msk = 0xfffff000

	// PWMC: PWM Control Register (PWMCON). The PWMCON enables PWM mode for the external match pins CT32B0_MAT[3:0].
	// Position of PWMEN0 field.
	CT32B0_PWMC_PWMEN0_Pos = 0x0
	// Bit mask of PWMEN0 field.
	CT32B0_PWMC_PWMEN0_Msk = 0x1
	// Bit PWMEN0.
	CT32B0_PWMC_PWMEN0 = 0x1
	// Position of PWMEN1 field.
	CT32B0_PWMC_PWMEN1_Pos = 0x1
	// Bit mask of PWMEN1 field.
	CT32B0_PWMC_PWMEN1_Msk = 0x2
	// Bit PWMEN1.
	CT32B0_PWMC_PWMEN1 = 0x2
	// Position of PWMEN2 field.
	CT32B0_PWMC_PWMEN2_Pos = 0x2
	// Bit mask of PWMEN2 field.
	CT32B0_PWMC_PWMEN2_Msk = 0x4
	// Bit PWMEN2.
	CT32B0_PWMC_PWMEN2 = 0x4
	// Position of PWMEN3 field.
	CT32B0_PWMC_PWMEN3_Pos = 0x3
	// Bit mask of PWMEN3 field.
	CT32B0_PWMC_PWMEN3_Msk = 0x8
	// Bit PWMEN3.
	CT32B0_PWMC_PWMEN3 = 0x8
	// Position of RESERVED field.
	CT32B0_PWMC_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	CT32B0_PWMC_RESERVED_Msk = 0xfffffff0
)

// Bitfields for CT32B1: Product name title=UM10429 Chapter title=LPC11102 32-bit counter/timers (CT32B0/1) Modification date=11/1/2010 Major revision=1 Minor revision=not available
const (
	// IR: Interrupt Register (IR). The IR can be written to clear interrupts. The IR can be read to identify which of five possible interrupt sources are pending.
	// Position of MR0INT field.
	CT32B1_IR_MR0INT_Pos = 0x0
	// Bit mask of MR0INT field.
	CT32B1_IR_MR0INT_Msk = 0x1
	// Bit MR0INT.
	CT32B1_IR_MR0INT = 0x1
	// Position of MR1INT field.
	CT32B1_IR_MR1INT_Pos = 0x1
	// Bit mask of MR1INT field.
	CT32B1_IR_MR1INT_Msk = 0x2
	// Bit MR1INT.
	CT32B1_IR_MR1INT = 0x2
	// Position of MR2INT field.
	CT32B1_IR_MR2INT_Pos = 0x2
	// Bit mask of MR2INT field.
	CT32B1_IR_MR2INT_Msk = 0x4
	// Bit MR2INT.
	CT32B1_IR_MR2INT = 0x4
	// Position of MR3INT field.
	CT32B1_IR_MR3INT_Pos = 0x3
	// Bit mask of MR3INT field.
	CT32B1_IR_MR3INT_Msk = 0x8
	// Bit MR3INT.
	CT32B1_IR_MR3INT = 0x8
	// Position of CR0INT field.
	CT32B1_IR_CR0INT_Pos = 0x4
	// Bit mask of CR0INT field.
	CT32B1_IR_CR0INT_Msk = 0x10
	// Bit CR0INT.
	CT32B1_IR_CR0INT = 0x10
	// Position of RESERVED field.
	CT32B1_IR_RESERVED_Pos = 0x5
	// Bit mask of RESERVED field.
	CT32B1_IR_RESERVED_Msk = 0xffffffe0

	// TCR: Timer Control Register (TCR). The TCR is used to control the Timer Counter functions. The Timer Counter can be disabled or reset through the TCR.
	// Position of CEN field.
	CT32B1_TCR_CEN_Pos = 0x0
	// Bit mask of CEN field.
	CT32B1_TCR_CEN_Msk = 0x1
	// Bit CEN.
	CT32B1_TCR_CEN = 0x1
	// Position of CRST field.
	CT32B1_TCR_CRST_Pos = 0x1
	// Bit mask of CRST field.
	CT32B1_TCR_CRST_Msk = 0x2
	// Bit CRST.
	CT32B1_TCR_CRST = 0x2
	// Position of RESERVED field.
	CT32B1_TCR_RESERVED_Pos = 0x2
	// Bit mask of RESERVED field.
	CT32B1_TCR_RESERVED_Msk = 0xfffffffc

	// TC: Timer Counter (TC). The 32-bit TC is incremented every PR+1 cycles of PCLK. The TC is controlled through the TCR.
	// Position of TC field.
	CT32B1_TC_TC_Pos = 0x0
	// Bit mask of TC field.
	CT32B1_TC_TC_Msk = 0xffffffff

	// PR: Prescale Register (PR). When the Prescale Counter (below) is equal to this value, the next clock increments the TC and clears the PC.
	// Position of PR field.
	CT32B1_PR_PR_Pos = 0x0
	// Bit mask of PR field.
	CT32B1_PR_PR_Msk = 0xffffffff

	// PC: Prescale Counter (PC). The 32-bit PC is a counter which is incremented to the value stored in PR. When the value in PR is reached, the TC is incremented and the PC is cleared. The PC is observable and controllable through the bus interface.
	// Position of PC field.
	CT32B1_PC_PC_Pos = 0x0
	// Bit mask of PC field.
	CT32B1_PC_PC_Msk = 0xffffffff

	// MCR: Match Control Register (MCR). The MCR is used to control if an interrupt is generated and if the TC is reset when a Match occurs.
	// Position of MR0I field.
	CT32B1_MCR_MR0I_Pos = 0x0
	// Bit mask of MR0I field.
	CT32B1_MCR_MR0I_Msk = 0x1
	// Bit MR0I.
	CT32B1_MCR_MR0I = 0x1
	// Enabled
	CT32B1_MCR_MR0I_Enabled = 0x1
	// Disabled
	CT32B1_MCR_MR0I_Disabled = 0x0
	// Position of MR0R field.
	CT32B1_MCR_MR0R_Pos = 0x1
	// Bit mask of MR0R field.
	CT32B1_MCR_MR0R_Msk = 0x2
	// Bit MR0R.
	CT32B1_MCR_MR0R = 0x2
	// Enabled
	CT32B1_MCR_MR0R_Enabled = 0x1
	// Disabled
	CT32B1_MCR_MR0R_Disabled = 0x0
	// Position of MR0S field.
	CT32B1_MCR_MR0S_Pos = 0x2
	// Bit mask of MR0S field.
	CT32B1_MCR_MR0S_Msk = 0x4
	// Bit MR0S.
	CT32B1_MCR_MR0S = 0x4
	// Enabled
	CT32B1_MCR_MR0S_Enabled = 0x1
	// Disabled
	CT32B1_MCR_MR0S_Disabled = 0x0
	// Position of MR1I field.
	CT32B1_MCR_MR1I_Pos = 0x3
	// Bit mask of MR1I field.
	CT32B1_MCR_MR1I_Msk = 0x8
	// Bit MR1I.
	CT32B1_MCR_MR1I = 0x8
	// Enabled
	CT32B1_MCR_MR1I_Enabled = 0x1
	// Disabled
	CT32B1_MCR_MR1I_Disabled = 0x0
	// Position of MR1R field.
	CT32B1_MCR_MR1R_Pos = 0x4
	// Bit mask of MR1R field.
	CT32B1_MCR_MR1R_Msk = 0x10
	// Bit MR1R.
	CT32B1_MCR_MR1R = 0x10
	// Enabled
	CT32B1_MCR_MR1R_Enabled = 0x1
	// Disabled
	CT32B1_MCR_MR1R_Disabled = 0x0
	// Position of MR1S field.
	CT32B1_MCR_MR1S_Pos = 0x5
	// Bit mask of MR1S field.
	CT32B1_MCR_MR1S_Msk = 0x20
	// Bit MR1S.
	CT32B1_MCR_MR1S = 0x20
	// Enabled
	CT32B1_MCR_MR1S_Enabled = 0x1
	// Disabled
	CT32B1_MCR_MR1S_Disabled = 0x0
	// Position of MR2I field.
	CT32B1_MCR_MR2I_Pos = 0x6
	// Bit mask of MR2I field.
	CT32B1_MCR_MR2I_Msk = 0x40
	// Bit MR2I.
	CT32B1_MCR_MR2I = 0x40
	// Enabled
	CT32B1_MCR_MR2I_Enabled = 0x1
	// Disabled
	CT32B1_MCR_MR2I_Disabled = 0x0
	// Position of MR2R field.
	CT32B1_MCR_MR2R_Pos = 0x7
	// Bit mask of MR2R field.
	CT32B1_MCR_MR2R_Msk = 0x80
	// Bit MR2R.
	CT32B1_MCR_MR2R = 0x80
	// Enabled
	CT32B1_MCR_MR2R_Enabled = 0x1
	// Disabled
	CT32B1_MCR_MR2R_Disabled = 0x0
	// Position of MR2S field.
	CT32B1_MCR_MR2S_Pos = 0x8
	// Bit mask of MR2S field.
	CT32B1_MCR_MR2S_Msk = 0x100
	// Bit MR2S.
	CT32B1_MCR_MR2S = 0x100
	// Enabled
	CT32B1_MCR_MR2S_Enabled = 0x1
	// Disabled
	CT32B1_MCR_MR2S_Disabled = 0x0
	// Position of MR3I field.
	CT32B1_MCR_MR3I_Pos = 0x9
	// Bit mask of MR3I field.
	CT32B1_MCR_MR3I_Msk = 0x200
	// Bit MR3I.
	CT32B1_MCR_MR3I = 0x200
	// Enabled
	CT32B1_MCR_MR3I_Enabled = 0x1
	// Disabled
	CT32B1_MCR_MR3I_Disabled = 0x0
	// Position of MR3R field.
	CT32B1_MCR_MR3R_Pos = 0xa
	// Bit mask of MR3R field.
	CT32B1_MCR_MR3R_Msk = 0x400
	// Bit MR3R.
	CT32B1_MCR_MR3R = 0x400
	// Enabled
	CT32B1_MCR_MR3R_Enabled = 0x1
	// Disabled
	CT32B1_MCR_MR3R_Disabled = 0x0
	// Position of MR3S field.
	CT32B1_MCR_MR3S_Pos = 0xb
	// Bit mask of MR3S field.
	CT32B1_MCR_MR3S_Msk = 0x800
	// Bit MR3S.
	CT32B1_MCR_MR3S = 0x800
	// Enabled
	CT32B1_MCR_MR3S_Enabled = 0x1
	// Disabled
	CT32B1_MCR_MR3S_Disabled = 0x0
	// Position of RESERVED field.
	CT32B1_MCR_RESERVED_Pos = 0xc
	// Bit mask of RESERVED field.
	CT32B1_MCR_RESERVED_Msk = 0xfffff000

	// MR0: Match Register. MR can be enabled through theMCR to reset the TC, stop both the TC and PC, and/or generate an interrupt every time MR matches the TC.
	// Position of MATCH field.
	CT32B1_MR_MATCH_Pos = 0x0
	// Bit mask of MATCH field.
	CT32B1_MR_MATCH_Msk = 0xffffffff

	// CCR: Capture Control Register (CCR). The CCR controls which edges of the capture inputs are used to load the Capture Registers and whether or not an interrupt is generated when a capture takes place.
	// Position of CAP0RE field.
	CT32B1_CCR_CAP0RE_Pos = 0x0
	// Bit mask of CAP0RE field.
	CT32B1_CCR_CAP0RE_Msk = 0x1
	// Bit CAP0RE.
	CT32B1_CCR_CAP0RE = 0x1
	// Enabled
	CT32B1_CCR_CAP0RE_Enabled = 0x1
	// Disabled
	CT32B1_CCR_CAP0RE_Disabled = 0x0
	// Position of CAP0FE field.
	CT32B1_CCR_CAP0FE_Pos = 0x1
	// Bit mask of CAP0FE field.
	CT32B1_CCR_CAP0FE_Msk = 0x2
	// Bit CAP0FE.
	CT32B1_CCR_CAP0FE = 0x2
	// Enabled
	CT32B1_CCR_CAP0FE_Enabled = 0x1
	// Disabled
	CT32B1_CCR_CAP0FE_Disabled = 0x0
	// Position of CAP0I field.
	CT32B1_CCR_CAP0I_Pos = 0x2
	// Bit mask of CAP0I field.
	CT32B1_CCR_CAP0I_Msk = 0x4
	// Bit CAP0I.
	CT32B1_CCR_CAP0I = 0x4
	// Enabled
	CT32B1_CCR_CAP0I_Enabled = 0x1
	// Disabled
	CT32B1_CCR_CAP0I_Disabled = 0x0
	// Position of RESERVED field.
	CT32B1_CCR_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	CT32B1_CCR_RESERVED_Msk = 0xfffffff8

	// CR0: Capture Register 0 (CR0). CR0 is loaded with the value of TC when there is an event on the CT16B0_CAP0 input.
	// Position of CAP field.
	CT32B1_CR0_CAP_Pos = 0x0
	// Bit mask of CAP field.
	CT32B1_CR0_CAP_Msk = 0xffffffff

	// EMR: External Match Register (EMR). The EMR controls the match function and the external match pins CT32B0_MAT[3:0].
	// Position of EM0 field.
	CT32B1_EMR_EM0_Pos = 0x0
	// Bit mask of EM0 field.
	CT32B1_EMR_EM0_Msk = 0x1
	// Bit EM0.
	CT32B1_EMR_EM0 = 0x1
	// Position of EM1 field.
	CT32B1_EMR_EM1_Pos = 0x1
	// Bit mask of EM1 field.
	CT32B1_EMR_EM1_Msk = 0x2
	// Bit EM1.
	CT32B1_EMR_EM1 = 0x2
	// Position of EM2 field.
	CT32B1_EMR_EM2_Pos = 0x2
	// Bit mask of EM2 field.
	CT32B1_EMR_EM2_Msk = 0x4
	// Bit EM2.
	CT32B1_EMR_EM2 = 0x4
	// Position of EM3 field.
	CT32B1_EMR_EM3_Pos = 0x3
	// Bit mask of EM3 field.
	CT32B1_EMR_EM3_Msk = 0x8
	// Bit EM3.
	CT32B1_EMR_EM3 = 0x8
	// Position of EMC0 field.
	CT32B1_EMR_EMC0_Pos = 0x4
	// Bit mask of EMC0 field.
	CT32B1_EMR_EMC0_Msk = 0x30
	// Do Nothing.
	CT32B1_EMR_EMC0_DONOTHING = 0x0
	// Clear the corresponding External Match bit/output to 0 (CT32Bn_MATm pin is LOW if pinned out).
	CT32B1_EMR_EMC0_CLEAR = 0x1
	// Set the corresponding External Match bit/output to 1 (CT32Bn_MATm pin is HIGH if pinned out).
	CT32B1_EMR_EMC0_SET = 0x2
	// Toggle the corresponding External Match bit/output.
	CT32B1_EMR_EMC0_TOGGLE = 0x3
	// Position of EMC1 field.
	CT32B1_EMR_EMC1_Pos = 0x6
	// Bit mask of EMC1 field.
	CT32B1_EMR_EMC1_Msk = 0xc0
	// Do Nothing.
	CT32B1_EMR_EMC1_DONOTHING = 0x0
	// Clear the corresponding External Match bit/output to 0 (CT32Bn_MATm pin is LOW if pinned out).
	CT32B1_EMR_EMC1_CLEAR = 0x1
	// Set the corresponding External Match bit/output to 1 (CT32Bn_MATm pin is HIGH if pinned out).
	CT32B1_EMR_EMC1_SET = 0x2
	// Toggle the corresponding External Match bit/output.
	CT32B1_EMR_EMC1_TOGGLE = 0x3
	// Position of EMC2 field.
	CT32B1_EMR_EMC2_Pos = 0x8
	// Bit mask of EMC2 field.
	CT32B1_EMR_EMC2_Msk = 0x300
	// Do Nothing.
	CT32B1_EMR_EMC2_DONOTHING = 0x0
	// Clear the corresponding External Match bit/output to 0 (CT32Bn_MATm pin is LOW if pinned out).
	CT32B1_EMR_EMC2_CLEAR = 0x1
	// Set the corresponding External Match bit/output to 1 (CT32Bn_MATm pin is HIGH if pinned out).
	CT32B1_EMR_EMC2_SET = 0x2
	// Toggle the corresponding External Match bit/output.
	CT32B1_EMR_EMC2_TOGGLE = 0x3
	// Position of EMC3 field.
	CT32B1_EMR_EMC3_Pos = 0xa
	// Bit mask of EMC3 field.
	CT32B1_EMR_EMC3_Msk = 0xc00
	// Do Nothing.
	CT32B1_EMR_EMC3_DONOTHING = 0x0
	// Clear the corresponding External Match bit/output to 0 (CT32Bn_MATm pin is LOW if pinned out).
	CT32B1_EMR_EMC3_CLEAR = 0x1
	// Set the corresponding External Match bit/output to 1 (CT32Bn_MATm pin is HIGH if pinned out).
	CT32B1_EMR_EMC3_SET = 0x2
	// Toggle the corresponding External Match bit/output.
	CT32B1_EMR_EMC3_TOGGLE = 0x3
	// Position of RESERVED field.
	CT32B1_EMR_RESERVED_Pos = 0xc
	// Bit mask of RESERVED field.
	CT32B1_EMR_RESERVED_Msk = 0xfffff000

	// CTCR: Count Control Register (CTCR). The CTCR selects between Timer and Counter mode, and in Counter mode selects the signal and edge(s) for counting.
	// Position of CTM field.
	CT32B1_CTCR_CTM_Pos = 0x0
	// Bit mask of CTM field.
	CT32B1_CTCR_CTM_Msk = 0x3
	// Timer Mode: every rising PCLK edge
	CT32B1_CTCR_CTM_TIMERMODE = 0x0
	// Counter Mode: TC is incremented on rising edges on the CAP input selected by bits 3:2.
	CT32B1_CTCR_CTM_RISING = 0x1
	// Counter Mode: TC is incremented on falling edges on the CAP input selected by bits 3:2.
	CT32B1_CTCR_CTM_FALLING = 0x2
	// Counter Mode: TC is incremented on both edges on the CAP input selected by bits 3:2.
	CT32B1_CTCR_CTM_RISINGFALLING = 0x3
	// Position of CIS field.
	CT32B1_CTCR_CIS_Pos = 0x2
	// Bit mask of CIS field.
	CT32B1_CTCR_CIS_Msk = 0xc
	// CT32Bn_CAP0
	CT32B1_CTCR_CIS_CT32Bn_CAP0 = 0x0
	// Position of RESERVED field.
	CT32B1_CTCR_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	CT32B1_CTCR_RESERVED_Msk = 0xfffffff0

	// PWMC: PWM Control Register (PWMCON). The PWMCON enables PWM mode for the external match pins CT32B0_MAT[3:0].
	// Position of PWMEN0 field.
	CT32B1_PWMC_PWMEN0_Pos = 0x0
	// Bit mask of PWMEN0 field.
	CT32B1_PWMC_PWMEN0_Msk = 0x1
	// Bit PWMEN0.
	CT32B1_PWMC_PWMEN0 = 0x1
	// Position of PWMEN1 field.
	CT32B1_PWMC_PWMEN1_Pos = 0x1
	// Bit mask of PWMEN1 field.
	CT32B1_PWMC_PWMEN1_Msk = 0x2
	// Bit PWMEN1.
	CT32B1_PWMC_PWMEN1 = 0x2
	// Position of PWMEN2 field.
	CT32B1_PWMC_PWMEN2_Pos = 0x2
	// Bit mask of PWMEN2 field.
	CT32B1_PWMC_PWMEN2_Msk = 0x4
	// Bit PWMEN2.
	CT32B1_PWMC_PWMEN2 = 0x4
	// Position of PWMEN3 field.
	CT32B1_PWMC_PWMEN3_Pos = 0x3
	// Bit mask of PWMEN3 field.
	CT32B1_PWMC_PWMEN3_Msk = 0x8
	// Bit PWMEN3.
	CT32B1_PWMC_PWMEN3 = 0x8
	// Position of RESERVED field.
	CT32B1_PWMC_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	CT32B1_PWMC_RESERVED_Msk = 0xfffffff0
)

// Bitfields for ADC: 10-bit ADC
const (
	// CR: A/D Control Register. The ADCR register must be written to select the operating mode before A/D conversion can occur.
	// Position of SEL field.
	ADC_CR_SEL_Pos = 0x0
	// Bit mask of SEL field.
	ADC_CR_SEL_Msk = 0xff
	// Position of CLKDIV field.
	ADC_CR_CLKDIV_Pos = 0x8
	// Bit mask of CLKDIV field.
	ADC_CR_CLKDIV_Msk = 0xff00
	// Position of BURST field.
	ADC_CR_BURST_Pos = 0x10
	// Bit mask of BURST field.
	ADC_CR_BURST_Msk = 0x10000
	// Bit BURST.
	ADC_CR_BURST = 0x10000
	// Software-controlled mode: Conversions are software-controlled and require 11 clocks.
	ADC_CR_BURST_SWMODE = 0x0
	// Hardware scan mode: The AD converter does repeated conversions at the rate selected by the CLKS field, scanning (if necessary) through the pins selected by 1s in the SEL field. The first conversion after the start corresponds to the least-significant bit set to 1 in the SEL field, then the next higher bits (pins) set to 1 are scanned if applicable. Repeated conversions can be terminated by clearing this bit, but the conversion in progress when this bit is cleared will be completed. Important: START bits must be 000 when BURST = 1 or conversions will not start.
	ADC_CR_BURST_HWMODE = 0x1
	// Position of CLKS field.
	ADC_CR_CLKS_Pos = 0x11
	// Bit mask of CLKS field.
	ADC_CR_CLKS_Msk = 0xe0000
	// 11 clocks / 10 bits
	ADC_CR_CLKS_10BIT = 0x0
	// 10 clocks / 9 bits
	ADC_CR_CLKS_9BIT = 0x1
	// 9 clocks / 8 bits
	ADC_CR_CLKS_8BIT = 0x2
	// 8 clocks / 7 bits
	ADC_CR_CLKS_7BIT = 0x3
	// 7 clocks / 6 bits
	ADC_CR_CLKS_6BIT = 0x4
	// 6 clocks / 5 bits
	ADC_CR_CLKS_5BIT = 0x5
	// 5 clocks / 4 bits
	ADC_CR_CLKS_4BIT = 0x6
	// 4 clocks / 3 bits
	ADC_CR_CLKS_3BIT = 0x7
	// Position of RESERVED field.
	ADC_CR_RESERVED_Pos = 0x14
	// Bit mask of RESERVED field.
	ADC_CR_RESERVED_Msk = 0xf00000
	// Position of START field.
	ADC_CR_START_Pos = 0x18
	// Bit mask of START field.
	ADC_CR_START_Msk = 0x7000000
	// No start (this value should be used when clearing PDN to 0).
	ADC_CR_START_STOP = 0x0
	// Start conversion now.
	ADC_CR_START_START = 0x1
	// Start conversion when the edge selected by bit 27 occurs on PIO0_2/SSEL/CT16B0_CAP0.
	ADC_CR_START_EDGEPIO0_2 = 0x2
	// Start conversion when the edge selected by bit 27 occurs on PIO1_5/DIR/CT32B0_CAP0.
	ADC_CR_START_EDGEPIO1_5 = 0x3
	// Start conversion when the edge selected by bit 27 occurs on CT32B0_MAT0[1].
	ADC_CR_START_EDGECT32B0_MAT0_1 = 0x4
	// Start conversion when the edge selected by bit 27 occurs on CT32B0_MAT1[1].
	ADC_CR_START_EDGECT32B0_MAT1_1 = 0x5
	// Start conversion when the edge selected by bit 27 occurs on CT16B0_MAT0[1].
	ADC_CR_START_EDGECT16B0_MAT0_1 = 0x6
	// Start conversion when the edge selected by bit 27 occurs on CT16B0_MAT1[1].
	ADC_CR_START_EDGECT16B0_MAT1_1 = 0x7
	// Position of EDGE field.
	ADC_CR_EDGE_Pos = 0x1b
	// Bit mask of EDGE field.
	ADC_CR_EDGE_Msk = 0x8000000
	// Bit EDGE.
	ADC_CR_EDGE = 0x8000000
	// Start conversion on a rising edge on the selected CAP/MAT signal.
	ADC_CR_EDGE_RISING = 0x0
	// Start conversion on a rising edge on the selected CAP/MAT signal.
	ADC_CR_EDGE_FALLING = 0x1
	// Position of RESERVED field.
	ADC_CR_RESERVED_Pos = 0x1c
	// Bit mask of RESERVED field.
	ADC_CR_RESERVED_Msk = 0xf0000000

	// GDR: A/D Global Data Register. Contains the result of the most recent A/D conversion.
	// Position of RESERVED field.
	ADC_GDR_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	ADC_GDR_RESERVED_Msk = 0x3f
	// Position of V_VREF field.
	ADC_GDR_V_VREF_Pos = 0x6
	// Bit mask of V_VREF field.
	ADC_GDR_V_VREF_Msk = 0xffc0
	// Position of RESERVED field.
	ADC_GDR_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	ADC_GDR_RESERVED_Msk = 0xff0000
	// Position of CHN field.
	ADC_GDR_CHN_Pos = 0x18
	// Bit mask of CHN field.
	ADC_GDR_CHN_Msk = 0x7000000
	// Position of RESERVED field.
	ADC_GDR_RESERVED_Pos = 0x1b
	// Bit mask of RESERVED field.
	ADC_GDR_RESERVED_Msk = 0x38000000
	// Position of OVERRUN field.
	ADC_GDR_OVERRUN_Pos = 0x1e
	// Bit mask of OVERRUN field.
	ADC_GDR_OVERRUN_Msk = 0x40000000
	// Bit OVERRUN.
	ADC_GDR_OVERRUN = 0x40000000
	// Position of DONE field.
	ADC_GDR_DONE_Pos = 0x1f
	// Bit mask of DONE field.
	ADC_GDR_DONE_Msk = 0x80000000
	// Bit DONE.
	ADC_GDR_DONE = 0x80000000

	// INTEN: A/D Interrupt Enable Register. This register contains enable bits that allow the DONE flag of each A/D channel to be included or excluded from contributing to the generation of an A/D interrupt.
	// Position of ADINTENn field.
	ADC_INTEN_ADINTENn_Pos = 0x0
	// Bit mask of ADINTENn field.
	ADC_INTEN_ADINTENn_Msk = 0xff
	// Position of ADGINTEN field.
	ADC_INTEN_ADGINTEN_Pos = 0x8
	// Bit mask of ADGINTEN field.
	ADC_INTEN_ADGINTEN_Msk = 0x100
	// Bit ADGINTEN.
	ADC_INTEN_ADGINTEN = 0x100
	// Position of RESERVED field.
	ADC_INTEN_RESERVED_Pos = 0x9
	// Bit mask of RESERVED field.
	ADC_INTEN_RESERVED_Msk = 0xfffffe00

	// DR0: A/D Channel n Data Register. This register contains the result of the most recent conversion completed on channel n.
	// Position of RESERVED field.
	ADC_DR_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	ADC_DR_RESERVED_Msk = 0x3f
	// Position of V_VREF field.
	ADC_DR_V_VREF_Pos = 0x6
	// Bit mask of V_VREF field.
	ADC_DR_V_VREF_Msk = 0xffc0
	// Position of RESERVED field.
	ADC_DR_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	ADC_DR_RESERVED_Msk = 0x3fff0000
	// Position of OVERRUN field.
	ADC_DR_OVERRUN_Pos = 0x1e
	// Bit mask of OVERRUN field.
	ADC_DR_OVERRUN_Msk = 0x40000000
	// Bit OVERRUN.
	ADC_DR_OVERRUN = 0x40000000
	// Position of DONE field.
	ADC_DR_DONE_Pos = 0x1f
	// Bit mask of DONE field.
	ADC_DR_DONE_Msk = 0x80000000
	// Bit DONE.
	ADC_DR_DONE = 0x80000000

	// STAT: A/D Status Register. This register contains DONE and OVERRUN flags for all of the A/D channels, as well as the A/D interrupt flag.
	// Position of DONE field.
	ADC_STAT_DONE_Pos = 0x0
	// Bit mask of DONE field.
	ADC_STAT_DONE_Msk = 0xff
	// Position of OVERRUN field.
	ADC_STAT_OVERRUN_Pos = 0x8
	// Bit mask of OVERRUN field.
	ADC_STAT_OVERRUN_Msk = 0xff00
	// Position of ADINT field.
	ADC_STAT_ADINT_Pos = 0x10
	// Bit mask of ADINT field.
	ADC_STAT_ADINT_Msk = 0x10000
	// Bit ADINT.
	ADC_STAT_ADINT = 0x10000
	// Position of RESERVED field.
	ADC_STAT_RESERVED_Pos = 0x11
	// Bit mask of RESERVED field.
	ADC_STAT_RESERVED_Msk = 0xfffe0000
)

// Bitfields for PMU: PMU (PowerManagement Unit)
const (
	// PCON: Power control register
	// Position of RESERVED field.
	PMU_PCON_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	PMU_PCON_RESERVED_Msk = 0x1
	// Bit RESERVED.
	PMU_PCON_RESERVED = 0x1
	// Position of RESERVED field.
	PMU_PCON_RESERVED_Pos = 0x1
	// Bit mask of RESERVED field.
	PMU_PCON_RESERVED_Msk = 0x2
	// Bit RESERVED.
	PMU_PCON_RESERVED = 0x2
	// Position of RESERVED field.
	PMU_PCON_RESERVED_Pos = 0x2
	// Bit mask of RESERVED field.
	PMU_PCON_RESERVED_Msk = 0xfc
	// Position of SLEEPFLAG field.
	PMU_PCON_SLEEPFLAG_Pos = 0x8
	// Bit mask of SLEEPFLAG field.
	PMU_PCON_SLEEPFLAG_Msk = 0x100
	// Bit SLEEPFLAG.
	PMU_PCON_SLEEPFLAG = 0x100
	// Read: No power-down mode entered. LPC1102 is in Active mode. Write: No effect.
	PMU_PCON_SLEEPFLAG_NOPOWERDOWN = 0x0
	// Read: Sleep/Deep-sleepmode entered. Write: Writing a 1 clears the SLEEPFLAG bit to 0.
	PMU_PCON_SLEEPFLAG_POWERDOWNENTERED = 0x1
	// Position of RESERVED field.
	PMU_PCON_RESERVED_Pos = 0x9
	// Bit mask of RESERVED field.
	PMU_PCON_RESERVED_Msk = 0x600
	// Position of RESERVED field.
	PMU_PCON_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	PMU_PCON_RESERVED_Msk = 0x800
	// Bit RESERVED.
	PMU_PCON_RESERVED = 0x800
	// Position of RESERVED field.
	PMU_PCON_RESERVED_Pos = 0xc
	// Bit mask of RESERVED field.
	PMU_PCON_RESERVED_Msk = 0xfffff000
)

// Bitfields for FLASHCTRL: Flash controller
const (
	// FLASHCFG: Flash memory access time configuration register
	// Position of FLASHTIM field.
	FLASHCTRL_FLASHCFG_FLASHTIM_Pos = 0x0
	// Bit mask of FLASHTIM field.
	FLASHCTRL_FLASHCFG_FLASHTIM_Msk = 0x3
	// 1 system clock flash access time (for system clock frequencies of up to 20 MHz).
	FLASHCTRL_FLASHCFG_FLASHTIM_1_SYSTEM_CLOCK_FLASH = 0x1
	// 2 system clocks flash access time (for system clock frequencies of up to 40 MHz).
	FLASHCTRL_FLASHCFG_FLASHTIM_2_SYSTEM_CLOCKS_FLAS = 0x2
	// 3 system clocks flash access time (for system clock frequencies of up to 50 MHz).
	FLASHCTRL_FLASHCFG_FLASHTIM_3_SYSTEM_CLOCKS_FLAS = 0x3
	// Position of RESERVED field.
	FLASHCTRL_FLASHCFG_RESERVED_Pos = 0x2
	// Bit mask of RESERVED field.
	FLASHCTRL_FLASHCFG_RESERVED_Msk = 0xfffffffc

	// FMSSTART: Signature start address register
	// Position of START field.
	FLASHCTRL_FMSSTART_START_Pos = 0x0
	// Bit mask of START field.
	FLASHCTRL_FMSSTART_START_Msk = 0x1ffff
	// Position of RESERVED field.
	FLASHCTRL_FMSSTART_RESERVED_Pos = 0x11
	// Bit mask of RESERVED field.
	FLASHCTRL_FMSSTART_RESERVED_Msk = 0xfffe0000

	// FMSSTOP: Signature stop-address register
	// Position of STOP field.
	FLASHCTRL_FMSSTOP_STOP_Pos = 0x0
	// Bit mask of STOP field.
	FLASHCTRL_FMSSTOP_STOP_Msk = 0x1ffff
	// Position of SIG_START field.
	FLASHCTRL_FMSSTOP_SIG_START_Pos = 0x11
	// Bit mask of SIG_START field.
	FLASHCTRL_FMSSTOP_SIG_START_Msk = 0x20000
	// Bit SIG_START.
	FLASHCTRL_FMSSTOP_SIG_START = 0x20000
	// Signature generation is stopped
	FLASHCTRL_FMSSTOP_SIG_START_SIGNATURE_GENERATION = 0x0
	// Initiate signature generation
	FLASHCTRL_FMSSTOP_SIG_START_INITIATE_SIGNATURE_G = 0x1
	// Position of RESERVED field.
	FLASHCTRL_FMSSTOP_RESERVED_Pos = 0x12
	// Bit mask of RESERVED field.
	FLASHCTRL_FMSSTOP_RESERVED_Msk = 0xfffc0000

	// FMSW0: Word 0 [31:0]
	// Position of SW0_31_0 field.
	FLASHCTRL_FMSW0_SW0_31_0_Pos = 0x0
	// Bit mask of SW0_31_0 field.
	FLASHCTRL_FMSW0_SW0_31_0_Msk = 0xffffffff

	// FMSW1: Word 1 [63:32]
	// Position of SW1_63_32 field.
	FLASHCTRL_FMSW1_SW1_63_32_Pos = 0x0
	// Bit mask of SW1_63_32 field.
	FLASHCTRL_FMSW1_SW1_63_32_Msk = 0xffffffff

	// FMSW2: Word 2 [95:64]
	// Position of SW2_95_64 field.
	FLASHCTRL_FMSW2_SW2_95_64_Pos = 0x0
	// Bit mask of SW2_95_64 field.
	FLASHCTRL_FMSW2_SW2_95_64_Msk = 0xffffffff

	// FMSW3: Word 3 [127:96]
	// Position of SW3_127_96 field.
	FLASHCTRL_FMSW3_SW3_127_96_Pos = 0x0
	// Bit mask of SW3_127_96 field.
	FLASHCTRL_FMSW3_SW3_127_96_Msk = 0xffffffff

	// FMSTAT: Signature generation status register
	// Position of RESERVED field.
	FLASHCTRL_FMSTAT_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	FLASHCTRL_FMSTAT_RESERVED_Msk = 0x3
	// Position of SIG_DONE field.
	FLASHCTRL_FMSTAT_SIG_DONE_Pos = 0x2
	// Bit mask of SIG_DONE field.
	FLASHCTRL_FMSTAT_SIG_DONE_Msk = 0x4
	// Bit SIG_DONE.
	FLASHCTRL_FMSTAT_SIG_DONE = 0x4
	// Position of RESERVED field.
	FLASHCTRL_FMSTAT_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	FLASHCTRL_FMSTAT_RESERVED_Msk = 0xfffffff8

	// FMSTATCLR: Signature generation status clear register
	// Position of RESERVED field.
	FLASHCTRL_FMSTATCLR_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	FLASHCTRL_FMSTATCLR_RESERVED_Msk = 0x3
	// Position of SIG_DONE_CLR field.
	FLASHCTRL_FMSTATCLR_SIG_DONE_CLR_Pos = 0x2
	// Bit mask of SIG_DONE_CLR field.
	FLASHCTRL_FMSTATCLR_SIG_DONE_CLR_Msk = 0x4
	// Bit SIG_DONE_CLR.
	FLASHCTRL_FMSTATCLR_SIG_DONE_CLR = 0x4
	// Position of RESERVED field.
	FLASHCTRL_FMSTATCLR_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	FLASHCTRL_FMSTATCLR_RESERVED_Msk = 0xfffffff8
)

// Bitfields for SPI0: SPI0
const (
	// CR0: Control Register 0. Selects the serial clock rate, bus type, and data size.
	// Position of DSS field.
	SPI_CR0_DSS_Pos = 0x0
	// Bit mask of DSS field.
	SPI_CR0_DSS_Msk = 0xf
	// 4-bit transfer
	SPI_CR0_DSS_4_BIT_TRANSFER = 0x3
	// 5-bit transfer
	SPI_CR0_DSS_5_BIT_TRANSFER = 0x4
	// 6-bit transfer
	SPI_CR0_DSS_6_BIT_TRANSFER = 0x5
	// 7-bit transfer
	SPI_CR0_DSS_7_BIT_TRANSFER = 0x6
	// 8-bit transfer
	SPI_CR0_DSS_8_BIT_TRANSFER = 0x7
	// 9-bit transfer
	SPI_CR0_DSS_9_BIT_TRANSFER = 0x8
	// 10-bit transfer
	SPI_CR0_DSS_10_BIT_TRANSFER = 0x9
	// 11-bit transfer
	SPI_CR0_DSS_11_BIT_TRANSFER = 0xa
	// 12-bit transfer
	SPI_CR0_DSS_12_BIT_TRANSFER = 0xb
	// 13-bit transfer
	SPI_CR0_DSS_13_BIT_TRANSFER = 0xc
	// 14-bit transfer
	SPI_CR0_DSS_14_BIT_TRANSFER = 0xd
	// 15-bit transfer
	SPI_CR0_DSS_15_BIT_TRANSFER = 0xe
	// 16-bit transfer
	SPI_CR0_DSS_16_BIT_TRANSFER = 0xf
	// Position of FRF field.
	SPI_CR0_FRF_Pos = 0x4
	// Bit mask of FRF field.
	SPI_CR0_FRF_Msk = 0x30
	// SPI
	SPI_CR0_FRF_SPI = 0x0
	// TI
	SPI_CR0_FRF_TI = 0x1
	// Microwire
	SPI_CR0_FRF_MICROWIRE = 0x2
	// Position of CPOL field.
	SPI_CR0_CPOL_Pos = 0x6
	// Bit mask of CPOL field.
	SPI_CR0_CPOL_Msk = 0x40
	// Bit CPOL.
	SPI_CR0_CPOL = 0x40
	// SPI controller maintains the bus clock low between frames.
	SPI_CR0_CPOL_LOW = 0x0
	// SPI controller maintains the bus clock high between frames.
	SPI_CR0_CPOL_HIGH = 0x1
	// Position of CPHA field.
	SPI_CR0_CPHA_Pos = 0x7
	// Bit mask of CPHA field.
	SPI_CR0_CPHA_Msk = 0x80
	// Bit CPHA.
	SPI_CR0_CPHA = 0x80
	// SPI controller captures serial data on the first clock transition of the frame, that is, the transition away from the inter-frame state of the clock line.
	SPI_CR0_CPHA_FIRSTCLOCK = 0x0
	// SPI controller captures serial data on the second clock transition of the frame, that is, the transition back to the inter-frame state of the clock line.
	SPI_CR0_CPHA_SECONDCLOCK = 0x1
	// Position of SCR field.
	SPI_CR0_SCR_Pos = 0x8
	// Bit mask of SCR field.
	SPI_CR0_SCR_Msk = 0xff00
	// Position of RESERVED field.
	SPI_CR0_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	SPI_CR0_RESERVED_Msk = 0xffff0000

	// CR1: Control Register 1. Selects master/slave and other modes.
	// Position of LBM field.
	SPI_CR1_LBM_Pos = 0x0
	// Bit mask of LBM field.
	SPI_CR1_LBM_Msk = 0x1
	// Bit LBM.
	SPI_CR1_LBM = 0x1
	// During normal operation.
	SPI_CR1_LBM_NORMAL = 0x0
	// Serial input is taken from the serial output (MOSI or MISO) rather than the serial input pin (MISO or MOSI respectively).
	SPI_CR1_LBM_LOOPBACK = 0x1
	// Position of SSE field.
	SPI_CR1_SSE_Pos = 0x1
	// Bit mask of SSE field.
	SPI_CR1_SSE_Msk = 0x2
	// Bit SSE.
	SPI_CR1_SSE = 0x2
	// The SPI controller is disabled.
	SPI_CR1_SSE_DISABLE = 0x0
	// The SPI controller will interact with other devices on the serial bus. Software should write the appropriate control information to the other SPI/SSP registers and interrupt controller registers, before setting this bit.
	SPI_CR1_SSE_ENABLE = 0x1
	// Position of MS field.
	SPI_CR1_MS_Pos = 0x2
	// Bit mask of MS field.
	SPI_CR1_MS_Msk = 0x4
	// Bit MS.
	SPI_CR1_MS = 0x4
	// The SPI controller acts as a master on the bus, driving the SCLK, MOSI, and SSEL lines and receiving the MISO line.
	SPI_CR1_MS_MASTER = 0x0
	// The SPI controller acts as a slave on the bus, driving MISO line and receiving SCLK, MOSI, and SSEL lines.
	SPI_CR1_MS_SLAVE = 0x1
	// Position of SOD field.
	SPI_CR1_SOD_Pos = 0x3
	// Bit mask of SOD field.
	SPI_CR1_SOD_Msk = 0x8
	// Bit SOD.
	SPI_CR1_SOD = 0x8
	// Position of RESERVED field.
	SPI_CR1_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	SPI_CR1_RESERVED_Msk = 0xfffffff0

	// DR: Data Register. Writes fill the transmit FIFO, and reads empty the receive FIFO.
	// Position of DATA field.
	SPI_DR_DATA_Pos = 0x0
	// Bit mask of DATA field.
	SPI_DR_DATA_Msk = 0xffff
	// Position of RESERVED field.
	SPI_DR_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	SPI_DR_RESERVED_Msk = 0xffff0000

	// SR: Status Register
	// Position of TFE field.
	SPI_SR_TFE_Pos = 0x0
	// Bit mask of TFE field.
	SPI_SR_TFE_Msk = 0x1
	// Bit TFE.
	SPI_SR_TFE = 0x1
	// Position of TNF field.
	SPI_SR_TNF_Pos = 0x1
	// Bit mask of TNF field.
	SPI_SR_TNF_Msk = 0x2
	// Bit TNF.
	SPI_SR_TNF = 0x2
	// Position of RNE field.
	SPI_SR_RNE_Pos = 0x2
	// Bit mask of RNE field.
	SPI_SR_RNE_Msk = 0x4
	// Bit RNE.
	SPI_SR_RNE = 0x4
	// Position of RFF field.
	SPI_SR_RFF_Pos = 0x3
	// Bit mask of RFF field.
	SPI_SR_RFF_Msk = 0x8
	// Bit RFF.
	SPI_SR_RFF = 0x8
	// Position of BSY field.
	SPI_SR_BSY_Pos = 0x4
	// Bit mask of BSY field.
	SPI_SR_BSY_Msk = 0x10
	// Bit BSY.
	SPI_SR_BSY = 0x10
	// Position of RESERVED field.
	SPI_SR_RESERVED_Pos = 0x5
	// Bit mask of RESERVED field.
	SPI_SR_RESERVED_Msk = 0xffffffe0

	// CPSR: Clock Prescale Register
	// Position of CPSDVSR field.
	SPI_CPSR_CPSDVSR_Pos = 0x0
	// Bit mask of CPSDVSR field.
	SPI_CPSR_CPSDVSR_Msk = 0xff
	// Position of RESERVED field.
	SPI_CPSR_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	SPI_CPSR_RESERVED_Msk = 0xffffff00

	// IMSC: Interrupt Mask Set and Clear Register
	// Position of RORIM field.
	SPI_IMSC_RORIM_Pos = 0x0
	// Bit mask of RORIM field.
	SPI_IMSC_RORIM_Msk = 0x1
	// Bit RORIM.
	SPI_IMSC_RORIM = 0x1
	// Position of RTIM field.
	SPI_IMSC_RTIM_Pos = 0x1
	// Bit mask of RTIM field.
	SPI_IMSC_RTIM_Msk = 0x2
	// Bit RTIM.
	SPI_IMSC_RTIM = 0x2
	// Position of RXIM field.
	SPI_IMSC_RXIM_Pos = 0x2
	// Bit mask of RXIM field.
	SPI_IMSC_RXIM_Msk = 0x4
	// Bit RXIM.
	SPI_IMSC_RXIM = 0x4
	// Position of TXIM field.
	SPI_IMSC_TXIM_Pos = 0x3
	// Bit mask of TXIM field.
	SPI_IMSC_TXIM_Msk = 0x8
	// Bit TXIM.
	SPI_IMSC_TXIM = 0x8
	// Position of RESERVED field.
	SPI_IMSC_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	SPI_IMSC_RESERVED_Msk = 0xfffffff0

	// RIS: Raw Interrupt Status Register
	// Position of RORRIS field.
	SPI_RIS_RORRIS_Pos = 0x0
	// Bit mask of RORRIS field.
	SPI_RIS_RORRIS_Msk = 0x1
	// Bit RORRIS.
	SPI_RIS_RORRIS = 0x1
	// Position of RTRIS field.
	SPI_RIS_RTRIS_Pos = 0x1
	// Bit mask of RTRIS field.
	SPI_RIS_RTRIS_Msk = 0x2
	// Bit RTRIS.
	SPI_RIS_RTRIS = 0x2
	// Position of RXRIS field.
	SPI_RIS_RXRIS_Pos = 0x2
	// Bit mask of RXRIS field.
	SPI_RIS_RXRIS_Msk = 0x4
	// Bit RXRIS.
	SPI_RIS_RXRIS = 0x4
	// Position of TXRIS field.
	SPI_RIS_TXRIS_Pos = 0x3
	// Bit mask of TXRIS field.
	SPI_RIS_TXRIS_Msk = 0x8
	// Bit TXRIS.
	SPI_RIS_TXRIS = 0x8
	// Position of RESERVED field.
	SPI_RIS_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	SPI_RIS_RESERVED_Msk = 0xfffffff0

	// MIS: Masked Interrupt Status Register
	// Position of RORMIS field.
	SPI_MIS_RORMIS_Pos = 0x0
	// Bit mask of RORMIS field.
	SPI_MIS_RORMIS_Msk = 0x1
	// Bit RORMIS.
	SPI_MIS_RORMIS = 0x1
	// Position of RTMIS field.
	SPI_MIS_RTMIS_Pos = 0x1
	// Bit mask of RTMIS field.
	SPI_MIS_RTMIS_Msk = 0x2
	// Bit RTMIS.
	SPI_MIS_RTMIS = 0x2
	// Position of RXMIS field.
	SPI_MIS_RXMIS_Pos = 0x2
	// Bit mask of RXMIS field.
	SPI_MIS_RXMIS_Msk = 0x4
	// Bit RXMIS.
	SPI_MIS_RXMIS = 0x4
	// Position of TXMIS field.
	SPI_MIS_TXMIS_Pos = 0x3
	// Bit mask of TXMIS field.
	SPI_MIS_TXMIS_Msk = 0x8
	// Bit TXMIS.
	SPI_MIS_TXMIS = 0x8
	// Position of RESERVED field.
	SPI_MIS_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	SPI_MIS_RESERVED_Msk = 0xfffffff0

	// ICR: SSPICR Interrupt Clear Register
	// Position of RORIC field.
	SPI_ICR_RORIC_Pos = 0x0
	// Bit mask of RORIC field.
	SPI_ICR_RORIC_Msk = 0x1
	// Bit RORIC.
	SPI_ICR_RORIC = 0x1
	// Position of RTIC field.
	SPI_ICR_RTIC_Pos = 0x1
	// Bit mask of RTIC field.
	SPI_ICR_RTIC_Msk = 0x2
	// Bit RTIC.
	SPI_ICR_RTIC = 0x2
	// Position of RESERVED field.
	SPI_ICR_RESERVED_Pos = 0x2
	// Bit mask of RESERVED field.
	SPI_ICR_RESERVED_Msk = 0xfffffffc
)

// Bitfields for IOCON: I/O Configuration
const (
	// RESET_PIO0_0: I/O configuration for pin RESET/PIO0_0
	// Position of FUNC field.
	IOCON_RESET_PIO0_0_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_RESET_PIO0_0_FUNC_Msk = 0x7
	// Selects function RESET.
	IOCON_RESET_PIO0_0_FUNC_SELECTS_FUNCTION_RESET = 0x0
	// Selects function PIO0_0.
	IOCON_RESET_PIO0_0_FUNC_SELECTS_FUNCTION_PIO0_0 = 0x1
	// Position of MODE field.
	IOCON_RESET_PIO0_0_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_RESET_PIO0_0_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_RESET_PIO0_0_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_RESET_PIO0_0_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_RESET_PIO0_0_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_RESET_PIO0_0_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_RESET_PIO0_0_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_RESET_PIO0_0_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_RESET_PIO0_0_HYS = 0x20
	// Disable.
	IOCON_RESET_PIO0_0_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_RESET_PIO0_0_HYS_ENABLE_ = 0x1
	// Position of RESERVED field.
	IOCON_RESET_PIO0_0_RESERVED_Pos = 0x6
	// Bit mask of RESERVED field.
	IOCON_RESET_PIO0_0_RESERVED_Msk = 0x3c0
	// Position of OD field.
	IOCON_RESET_PIO0_0_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_RESET_PIO0_0_OD_Msk = 0x400
	// Bit OD.
	IOCON_RESET_PIO0_0_OD = 0x400
	// Standard GPIO output
	IOCON_RESET_PIO0_0_OD_STANDARD_GPIO_OUTPUT = 0x0
	// Open-drain output
	IOCON_RESET_PIO0_0_OD_OPEN_DRAIN_OUTPUT = 0x1
	// Position of RESERVED field.
	IOCON_RESET_PIO0_0_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_RESET_PIO0_0_RESERVED_Msk = 0xfffff800

	// IOCON_PIO0_1: I/O configuration for pin PIO0_1/CLKOUT/CT32B0_MAT2
	// Position of FUNC field.
	IOCON_IOCON_PIO0_1_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_IOCON_PIO0_1_FUNC_Msk = 0x7
	// Selects function PIO0_1.
	IOCON_IOCON_PIO0_1_FUNC_SELECTS_FUNCTION_PIO0_1 = 0x0
	// Selects function CLKOUT.
	IOCON_IOCON_PIO0_1_FUNC_SELECTS_FUNCTION_CLKOUT = 0x1
	// Selects function CT32B0_MAT2.
	IOCON_IOCON_PIO0_1_FUNC_SELECTS_FUNCTION_CT32B0_MAT2 = 0x2
	// Position of MODE field.
	IOCON_IOCON_PIO0_1_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_IOCON_PIO0_1_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_IOCON_PIO0_1_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_IOCON_PIO0_1_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_IOCON_PIO0_1_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_IOCON_PIO0_1_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_IOCON_PIO0_1_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_IOCON_PIO0_1_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_IOCON_PIO0_1_HYS = 0x20
	// Disable.
	IOCON_IOCON_PIO0_1_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_IOCON_PIO0_1_HYS_ENABLE_ = 0x1
	// Position of RESERVED field.
	IOCON_IOCON_PIO0_1_RESERVED_Pos = 0x6
	// Bit mask of RESERVED field.
	IOCON_IOCON_PIO0_1_RESERVED_Msk = 0x3c0
	// Position of OD field.
	IOCON_IOCON_PIO0_1_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_IOCON_PIO0_1_OD_Msk = 0x400
	// Bit OD.
	IOCON_IOCON_PIO0_1_OD = 0x400
	// Standard GPIO output
	IOCON_IOCON_PIO0_1_OD_STANDARD_GPIO_OUTPUT = 0x0
	// Open-drain output
	IOCON_IOCON_PIO0_1_OD_OPEN_DRAIN_OUTPUT = 0x1
	// Position of RESERVED field.
	IOCON_IOCON_PIO0_1_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_IOCON_PIO0_1_RESERVED_Msk = 0xfffff800

	// IOCON_PIO0_6: I/O configuration for pin PIO0_6/SCK0
	// Position of FUNC field.
	IOCON_IOCON_PIO0_6_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_IOCON_PIO0_6_FUNC_Msk = 0x7
	// Selects function PIO0_6.
	IOCON_IOCON_PIO0_6_FUNC_SELECTS_FUNCTION_PIO0_6 = 0x0
	// Reserved.
	IOCON_IOCON_PIO0_6_FUNC_RESERVED_ = 0x1
	// Selects function SCK0 (only if pin PIO0_6/SCK0 selected in Table 147).
	IOCON_IOCON_PIO0_6_FUNC_SELECTS_FUNCTION_SCK0 = 0x2
	// Position of MODE field.
	IOCON_IOCON_PIO0_6_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_IOCON_PIO0_6_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_IOCON_PIO0_6_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_IOCON_PIO0_6_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_IOCON_PIO0_6_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_IOCON_PIO0_6_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_IOCON_PIO0_6_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_IOCON_PIO0_6_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_IOCON_PIO0_6_HYS = 0x20
	// Disable.
	IOCON_IOCON_PIO0_6_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_IOCON_PIO0_6_HYS_ENABLE_ = 0x1
	// Position of RESERVED field.
	IOCON_IOCON_PIO0_6_RESERVED_Pos = 0x6
	// Bit mask of RESERVED field.
	IOCON_IOCON_PIO0_6_RESERVED_Msk = 0x3c0
	// Position of OD field.
	IOCON_IOCON_PIO0_6_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_IOCON_PIO0_6_OD_Msk = 0x400
	// Bit OD.
	IOCON_IOCON_PIO0_6_OD = 0x400
	// Standard GPIO output
	IOCON_IOCON_PIO0_6_OD_STANDARD_GPIO_OUTPUT = 0x0
	// Open-drain output
	IOCON_IOCON_PIO0_6_OD_OPEN_DRAIN_OUTPUT = 0x1
	// Position of RESERVED field.
	IOCON_IOCON_PIO0_6_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_IOCON_PIO0_6_RESERVED_Msk = 0xfffff800

	// PIO0_8: I/O configuration for pin PIO0_8/MISO0/CT16B0_MAT0
	// Position of FUNC field.
	IOCON_PIO0_8_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_PIO0_8_FUNC_Msk = 0x7
	// Selects function PIO0_8.
	IOCON_PIO0_8_FUNC_SELECTS_FUNCTION_PIO0_8 = 0x0
	// Selects function MISO0.
	IOCON_PIO0_8_FUNC_SELECTS_FUNCTION_MISO0 = 0x1
	// Selects function CT16B0_MAT0.
	IOCON_PIO0_8_FUNC_SELECTS_FUNCTION_CT16B0_MAT0 = 0x2
	// Position of MODE field.
	IOCON_PIO0_8_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_PIO0_8_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_PIO0_8_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_PIO0_8_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_PIO0_8_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_PIO0_8_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_PIO0_8_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_PIO0_8_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_PIO0_8_HYS = 0x20
	// Disable.
	IOCON_PIO0_8_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_PIO0_8_HYS_ENABLE_ = 0x1
	// Position of RESERVED field.
	IOCON_PIO0_8_RESERVED_Pos = 0x6
	// Bit mask of RESERVED field.
	IOCON_PIO0_8_RESERVED_Msk = 0x3c0
	// Position of OD field.
	IOCON_PIO0_8_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_PIO0_8_OD_Msk = 0x400
	// Bit OD.
	IOCON_PIO0_8_OD = 0x400
	// Standard GPIO output
	IOCON_PIO0_8_OD_STANDARD_GPIO_OUTPUT = 0x0
	// Open-drain output
	IOCON_PIO0_8_OD_OPEN_DRAIN_OUTPUT = 0x1
	// Position of RESERVED field.
	IOCON_PIO0_8_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_PIO0_8_RESERVED_Msk = 0xfffff800

	// PIO0_9: I/O configuration for pin PIO0_9/MOSI0/CT16B0_MAT1
	// Position of FUNC field.
	IOCON_PIO0_9_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_PIO0_9_FUNC_Msk = 0x7
	// Selects function PIO0_9.
	IOCON_PIO0_9_FUNC_SELECTS_FUNCTION_PIO0_9 = 0x0
	// Selects function MOSI0.
	IOCON_PIO0_9_FUNC_SELECTS_FUNCTION_MOSI0 = 0x1
	// Selects function CT16B0_MAT1.
	IOCON_PIO0_9_FUNC_SELECTS_FUNCTION_CT16B0_MAT1 = 0x2
	// Position of MODE field.
	IOCON_PIO0_9_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_PIO0_9_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_PIO0_9_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_PIO0_9_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_PIO0_9_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_PIO0_9_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_PIO0_9_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_PIO0_9_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_PIO0_9_HYS = 0x20
	// Disable.
	IOCON_PIO0_9_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_PIO0_9_HYS_ENABLE_ = 0x1
	// Position of RESERVED field.
	IOCON_PIO0_9_RESERVED_Pos = 0x6
	// Bit mask of RESERVED field.
	IOCON_PIO0_9_RESERVED_Msk = 0x3c0
	// Position of OD field.
	IOCON_PIO0_9_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_PIO0_9_OD_Msk = 0x400
	// Bit OD.
	IOCON_PIO0_9_OD = 0x400
	// Standard GPIO output
	IOCON_PIO0_9_OD_STANDARD_GPIO_OUTPUT = 0x0
	// Open-drain output
	IOCON_PIO0_9_OD_OPEN_DRAIN_OUTPUT = 0x1
	// Position of RESERVED field.
	IOCON_PIO0_9_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_PIO0_9_RESERVED_Msk = 0xfffff800

	// SWCLK_PIO0_10: I/O configuration for pin SWCLK/PIO0_10/ SCK0/CT16B0_MAT2
	// Position of FUNC field.
	IOCON_SWCLK_PIO0_10_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_SWCLK_PIO0_10_FUNC_Msk = 0x7
	// Selects function SWCLK.
	IOCON_SWCLK_PIO0_10_FUNC_SELECTS_FUNCTION_SWCLK = 0x0
	// Selects function PIO0_10.
	IOCON_SWCLK_PIO0_10_FUNC_SELECTS_FUNCTION_PIO0_10 = 0x1
	// Selects function SCK0 (only if pin SWCLK/PIO0_10/SCK0/CT16B0_MAT2 selected in Table 98).
	IOCON_SWCLK_PIO0_10_FUNC_SELECTS_FUNCTION_SCK0 = 0x2
	// Selects function CT16B0_MAT2.
	IOCON_SWCLK_PIO0_10_FUNC_SELECTS_FUNCTION_CT16B0_MAT2 = 0x3
	// Position of MODE field.
	IOCON_SWCLK_PIO0_10_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_SWCLK_PIO0_10_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_SWCLK_PIO0_10_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_SWCLK_PIO0_10_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_SWCLK_PIO0_10_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_SWCLK_PIO0_10_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_SWCLK_PIO0_10_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_SWCLK_PIO0_10_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_SWCLK_PIO0_10_HYS = 0x20
	// Disable.
	IOCON_SWCLK_PIO0_10_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_SWCLK_PIO0_10_HYS_ENABLE_ = 0x1
	// Position of RESERVED field.
	IOCON_SWCLK_PIO0_10_RESERVED_Pos = 0x6
	// Bit mask of RESERVED field.
	IOCON_SWCLK_PIO0_10_RESERVED_Msk = 0x3c0
	// Position of OD field.
	IOCON_SWCLK_PIO0_10_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_SWCLK_PIO0_10_OD_Msk = 0x400
	// Bit OD.
	IOCON_SWCLK_PIO0_10_OD = 0x400
	// Standard GPIO output
	IOCON_SWCLK_PIO0_10_OD_STANDARD_GPIO_OUTPUT = 0x0
	// Open-drain output
	IOCON_SWCLK_PIO0_10_OD_OPEN_DRAIN_OUTPUT = 0x1
	// Position of RESERVED field.
	IOCON_SWCLK_PIO0_10_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_SWCLK_PIO0_10_RESERVED_Msk = 0xfffff800

	// R_PIO0_11: I/O configuration for pin R/PIO0_11/AD0/CT32B0_MAT3
	// Position of FUNC field.
	IOCON_R_PIO0_11_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_R_PIO0_11_FUNC_Msk = 0x7
	// Selects function R. This function is reserved. Select one of the alternate functions below.
	IOCON_R_PIO0_11_FUNC_SELECTS_FUNCTION_R_ = 0x0
	// Selects function PIO0_11.
	IOCON_R_PIO0_11_FUNC_SELECTS_FUNCTION_PIO0_11 = 0x1
	// Selects function AD0.
	IOCON_R_PIO0_11_FUNC_SELECTS_FUNCTION_AD0 = 0x2
	// Selects function CT32B0_MAT3.
	IOCON_R_PIO0_11_FUNC_SELECTS_FUNCTION_CT32B0_MAT3 = 0x3
	// Position of MODE field.
	IOCON_R_PIO0_11_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_R_PIO0_11_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_R_PIO0_11_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_R_PIO0_11_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_R_PIO0_11_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_R_PIO0_11_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_R_PIO0_11_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_R_PIO0_11_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_R_PIO0_11_HYS = 0x20
	// Disable.
	IOCON_R_PIO0_11_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_R_PIO0_11_HYS_ENABLE_ = 0x1
	// Position of RESERVED field.
	IOCON_R_PIO0_11_RESERVED_Pos = 0x6
	// Bit mask of RESERVED field.
	IOCON_R_PIO0_11_RESERVED_Msk = 0x40
	// Bit RESERVED.
	IOCON_R_PIO0_11_RESERVED = 0x40
	// Position of ADMODE field.
	IOCON_R_PIO0_11_ADMODE_Pos = 0x7
	// Bit mask of ADMODE field.
	IOCON_R_PIO0_11_ADMODE_Msk = 0x80
	// Bit ADMODE.
	IOCON_R_PIO0_11_ADMODE = 0x80
	// Analog input mode
	IOCON_R_PIO0_11_ADMODE_ANALOG_INPUT_MODE = 0x0
	// Digital functional mode
	IOCON_R_PIO0_11_ADMODE_DIGITAL_FUNCTIONAL_M = 0x1
	// Position of RESERVED field.
	IOCON_R_PIO0_11_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	IOCON_R_PIO0_11_RESERVED_Msk = 0x300
	// Position of OD field.
	IOCON_R_PIO0_11_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_R_PIO0_11_OD_Msk = 0x400
	// Bit OD.
	IOCON_R_PIO0_11_OD = 0x400
	// Standard GPIO output
	IOCON_R_PIO0_11_OD_STANDARD_GPIO_OUTPUT = 0x0
	// Open-drain output
	IOCON_R_PIO0_11_OD_OPEN_DRAIN_OUTPUT = 0x1
	// Position of RESERVED field.
	IOCON_R_PIO0_11_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_R_PIO0_11_RESERVED_Msk = 0xfffff800

	// R_PIO1_0: I/O configuration for pin R/PIO1_0/AD1/CT32B1_CAP0
	// Position of FUNC field.
	IOCON_R_PIO1_0_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_R_PIO1_0_FUNC_Msk = 0x7
	// Selects function R. This function is reserved. Select one of the alternate functions below.
	IOCON_R_PIO1_0_FUNC_SELECTS_FUNCTION_R_ = 0x0
	// Selects function PIO1_0.
	IOCON_R_PIO1_0_FUNC_SELECTS_FUNCTION_PIO1_0 = 0x1
	// Selects function AD1.
	IOCON_R_PIO1_0_FUNC_SELECTS_FUNCTION_AD1 = 0x2
	// Selects function CT32B1_CAP0.
	IOCON_R_PIO1_0_FUNC_SELECTS_FUNCTION_CT32B1_CAP0 = 0x3
	// Position of MODE field.
	IOCON_R_PIO1_0_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_R_PIO1_0_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_R_PIO1_0_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_R_PIO1_0_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_R_PIO1_0_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_R_PIO1_0_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_R_PIO1_0_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_R_PIO1_0_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_R_PIO1_0_HYS = 0x20
	// Disable.
	IOCON_R_PIO1_0_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_R_PIO1_0_HYS_ENABLE_ = 0x1
	// Position of RESERVED field.
	IOCON_R_PIO1_0_RESERVED_Pos = 0x6
	// Bit mask of RESERVED field.
	IOCON_R_PIO1_0_RESERVED_Msk = 0x40
	// Bit RESERVED.
	IOCON_R_PIO1_0_RESERVED = 0x40
	// Position of ADMODE field.
	IOCON_R_PIO1_0_ADMODE_Pos = 0x7
	// Bit mask of ADMODE field.
	IOCON_R_PIO1_0_ADMODE_Msk = 0x80
	// Bit ADMODE.
	IOCON_R_PIO1_0_ADMODE = 0x80
	// Analog input mode
	IOCON_R_PIO1_0_ADMODE_ANALOG_INPUT_MODE = 0x0
	// Digital functional mode
	IOCON_R_PIO1_0_ADMODE_DIGITAL_FUNCTIONAL_M = 0x1
	// Position of RESERVED field.
	IOCON_R_PIO1_0_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	IOCON_R_PIO1_0_RESERVED_Msk = 0x300
	// Position of OD field.
	IOCON_R_PIO1_0_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_R_PIO1_0_OD_Msk = 0x400
	// Bit OD.
	IOCON_R_PIO1_0_OD = 0x400
	// Standard GPIO output
	IOCON_R_PIO1_0_OD_STANDARD_GPIO_OUTPUT = 0x0
	// Open-drain output
	IOCON_R_PIO1_0_OD_OPEN_DRAIN_OUTPUT = 0x1
	// Position of RESERVED field.
	IOCON_R_PIO1_0_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_R_PIO1_0_RESERVED_Msk = 0xfffff800

	// R_PIO1_1: I/O configuration for pin R/PIO1_1/AD2/CT32B1_MAT0
	// Position of FUNC field.
	IOCON_R_PIO1_1_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_R_PIO1_1_FUNC_Msk = 0x7
	// Selects function R. This function is reserved. Select one of the alternate functions below.
	IOCON_R_PIO1_1_FUNC_SELECTS_FUNCTION_R_ = 0x0
	// Selects function PIO1_1.
	IOCON_R_PIO1_1_FUNC_SELECTS_FUNCTION_PIO1_1 = 0x1
	// Selects function AD2.
	IOCON_R_PIO1_1_FUNC_SELECTS_FUNCTION_AD2 = 0x2
	// Selects function CT32B1_MAT0.
	IOCON_R_PIO1_1_FUNC_SELECTS_FUNCTION_CT32B1_MAT0 = 0x3
	// Position of MODE field.
	IOCON_R_PIO1_1_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_R_PIO1_1_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_R_PIO1_1_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_R_PIO1_1_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_R_PIO1_1_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_R_PIO1_1_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_R_PIO1_1_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_R_PIO1_1_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_R_PIO1_1_HYS = 0x20
	// Disable.
	IOCON_R_PIO1_1_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_R_PIO1_1_HYS_ENABLE_ = 0x1
	// Position of RESERVED field.
	IOCON_R_PIO1_1_RESERVED_Pos = 0x6
	// Bit mask of RESERVED field.
	IOCON_R_PIO1_1_RESERVED_Msk = 0x40
	// Bit RESERVED.
	IOCON_R_PIO1_1_RESERVED = 0x40
	// Position of ADMODE field.
	IOCON_R_PIO1_1_ADMODE_Pos = 0x7
	// Bit mask of ADMODE field.
	IOCON_R_PIO1_1_ADMODE_Msk = 0x80
	// Bit ADMODE.
	IOCON_R_PIO1_1_ADMODE = 0x80
	// Analog input mode
	IOCON_R_PIO1_1_ADMODE_ANALOG_INPUT_MODE = 0x0
	// Digital functional mode
	IOCON_R_PIO1_1_ADMODE_DIGITAL_FUNCTIONAL_M = 0x1
	// Position of RESERVED field.
	IOCON_R_PIO1_1_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	IOCON_R_PIO1_1_RESERVED_Msk = 0x300
	// Position of OD field.
	IOCON_R_PIO1_1_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_R_PIO1_1_OD_Msk = 0x400
	// Bit OD.
	IOCON_R_PIO1_1_OD = 0x400
	// Standard GPIO output
	IOCON_R_PIO1_1_OD_STANDARD_GPIO_OUTPUT = 0x0
	// Open-drain output
	IOCON_R_PIO1_1_OD_OPEN_DRAIN_OUTPUT = 0x1
	// Position of RESERVED field.
	IOCON_R_PIO1_1_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_R_PIO1_1_RESERVED_Msk = 0xfffff800

	// R_PIO1_2: I/O configuration for pin R/PIO1_2/AD3/CT32B1_MAT1
	// Position of FUNC field.
	IOCON_R_PIO1_2_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_R_PIO1_2_FUNC_Msk = 0x7
	// Selects function R. This function is reserved. Select one of the alternate functions below.
	IOCON_R_PIO1_2_FUNC_SELECTS_FUNCTION_R_ = 0x0
	// Selects function PIO1_2.
	IOCON_R_PIO1_2_FUNC_SELECTS_FUNCTION_PIO1_2 = 0x1
	// Selects function AD3.
	IOCON_R_PIO1_2_FUNC_SELECTS_FUNCTION_AD3 = 0x2
	// Selects function CT32B1_MAT1.
	IOCON_R_PIO1_2_FUNC_SELECTS_FUNCTION_CT32B1_MAT1 = 0x3
	// Position of MODE field.
	IOCON_R_PIO1_2_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_R_PIO1_2_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_R_PIO1_2_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_R_PIO1_2_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_R_PIO1_2_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_R_PIO1_2_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_R_PIO1_2_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_R_PIO1_2_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_R_PIO1_2_HYS = 0x20
	// Disable.
	IOCON_R_PIO1_2_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_R_PIO1_2_HYS_ENABLE_ = 0x1
	// Position of RESERVED field.
	IOCON_R_PIO1_2_RESERVED_Pos = 0x6
	// Bit mask of RESERVED field.
	IOCON_R_PIO1_2_RESERVED_Msk = 0x40
	// Bit RESERVED.
	IOCON_R_PIO1_2_RESERVED = 0x40
	// Position of ADMODE field.
	IOCON_R_PIO1_2_ADMODE_Pos = 0x7
	// Bit mask of ADMODE field.
	IOCON_R_PIO1_2_ADMODE_Msk = 0x80
	// Bit ADMODE.
	IOCON_R_PIO1_2_ADMODE = 0x80
	// Analog input mode
	IOCON_R_PIO1_2_ADMODE_ANALOG_INPUT_MODE = 0x0
	// Digital functional mode
	IOCON_R_PIO1_2_ADMODE_DIGITAL_FUNCTIONAL_M = 0x1
	// Position of RESERVED field.
	IOCON_R_PIO1_2_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	IOCON_R_PIO1_2_RESERVED_Msk = 0x300
	// Position of OD field.
	IOCON_R_PIO1_2_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_R_PIO1_2_OD_Msk = 0x400
	// Bit OD.
	IOCON_R_PIO1_2_OD = 0x400
	// Standard GPIO output
	IOCON_R_PIO1_2_OD_STANDARD_GPIO_OUTPUT = 0x0
	// Open-drain output
	IOCON_R_PIO1_2_OD_OPEN_DRAIN_OUTPUT = 0x1
	// Position of RESERVED field.
	IOCON_R_PIO1_2_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_R_PIO1_2_RESERVED_Msk = 0xfffff800

	// SWDIO_PIO1_3: I/O configuration for pin SWDIO/PIO1_3/AD4/CT32B1_MAT2
	// Position of FUNC field.
	IOCON_SWDIO_PIO1_3_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_SWDIO_PIO1_3_FUNC_Msk = 0x7
	// Selects function SWDIO.
	IOCON_SWDIO_PIO1_3_FUNC_SELECTS_FUNCTION_SWDIO = 0x0
	// Selects function PIO1_3.
	IOCON_SWDIO_PIO1_3_FUNC_SELECTS_FUNCTION_PIO1_3 = 0x1
	// Selects function AD4.
	IOCON_SWDIO_PIO1_3_FUNC_SELECTS_FUNCTION_AD4 = 0x2
	// Selects function CT32B1_MAT2.
	IOCON_SWDIO_PIO1_3_FUNC_SELECTS_FUNCTION_CT32B1_MAT2 = 0x3
	// Position of MODE field.
	IOCON_SWDIO_PIO1_3_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_SWDIO_PIO1_3_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_SWDIO_PIO1_3_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_SWDIO_PIO1_3_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_SWDIO_PIO1_3_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_SWDIO_PIO1_3_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_SWDIO_PIO1_3_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_SWDIO_PIO1_3_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_SWDIO_PIO1_3_HYS = 0x20
	// Disable.
	IOCON_SWDIO_PIO1_3_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_SWDIO_PIO1_3_HYS_ENABLE_ = 0x1
	// Position of RESERVED field.
	IOCON_SWDIO_PIO1_3_RESERVED_Pos = 0x6
	// Bit mask of RESERVED field.
	IOCON_SWDIO_PIO1_3_RESERVED_Msk = 0x40
	// Bit RESERVED.
	IOCON_SWDIO_PIO1_3_RESERVED = 0x40
	// Position of ADMODE field.
	IOCON_SWDIO_PIO1_3_ADMODE_Pos = 0x7
	// Bit mask of ADMODE field.
	IOCON_SWDIO_PIO1_3_ADMODE_Msk = 0x80
	// Bit ADMODE.
	IOCON_SWDIO_PIO1_3_ADMODE = 0x80
	// Analog input mode
	IOCON_SWDIO_PIO1_3_ADMODE_ANALOG_INPUT_MODE = 0x0
	// Digital functional mode
	IOCON_SWDIO_PIO1_3_ADMODE_DIGITAL_FUNCTIONAL_M = 0x1
	// Position of RESERVED field.
	IOCON_SWDIO_PIO1_3_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	IOCON_SWDIO_PIO1_3_RESERVED_Msk = 0x300
	// Position of OD field.
	IOCON_SWDIO_PIO1_3_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_SWDIO_PIO1_3_OD_Msk = 0x400
	// Bit OD.
	IOCON_SWDIO_PIO1_3_OD = 0x400
	// Standard GPIO output
	IOCON_SWDIO_PIO1_3_OD_STANDARD_GPIO_OUTPUT = 0x0
	// Open-drain output
	IOCON_SWDIO_PIO1_3_OD_OPEN_DRAIN_OUTPUT = 0x1
	// Position of RESERVED field.
	IOCON_SWDIO_PIO1_3_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_SWDIO_PIO1_3_RESERVED_Msk = 0xfffff800

	// PIO1_6: I/O configuration for pin PIO1_6/RXD/CT32B0_MAT0
	// Position of FUNC field.
	IOCON_PIO1_6_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_PIO1_6_FUNC_Msk = 0x7
	// Selects function PIO1_6.
	IOCON_PIO1_6_FUNC_SELECTS_FUNCTION_PIO1_6 = 0x0
	// Selects function RXD.
	IOCON_PIO1_6_FUNC_SELECTS_FUNCTION_RXD = 0x1
	// Selects function CT32B0_MAT0.
	IOCON_PIO1_6_FUNC_SELECTS_FUNCTION_CT32B0_MAT0 = 0x2
	// Position of MODE field.
	IOCON_PIO1_6_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_PIO1_6_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_PIO1_6_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_PIO1_6_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_PIO1_6_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_PIO1_6_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_PIO1_6_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_PIO1_6_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_PIO1_6_HYS = 0x20
	// Disable.
	IOCON_PIO1_6_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_PIO1_6_HYS_ENABLE_ = 0x1
	// Position of RESERVED field.
	IOCON_PIO1_6_RESERVED_Pos = 0x6
	// Bit mask of RESERVED field.
	IOCON_PIO1_6_RESERVED_Msk = 0x3c0
	// Position of OD field.
	IOCON_PIO1_6_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_PIO1_6_OD_Msk = 0x400
	// Bit OD.
	IOCON_PIO1_6_OD = 0x400
	// Standard GPIO output
	IOCON_PIO1_6_OD_STANDARD_GPIO_OUTPUT = 0x0
	// Open-drain output
	IOCON_PIO1_6_OD_OPEN_DRAIN_OUTPUT = 0x1
	// Position of RESERVED field.
	IOCON_PIO1_6_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_PIO1_6_RESERVED_Msk = 0xfffff800

	// PIO1_7: I/O configuration for pin PIO1_7/TXD/CT32B0_MAT1
	// Position of FUNC field.
	IOCON_PIO1_7_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_PIO1_7_FUNC_Msk = 0x7
	// Selects function PIO1_7.
	IOCON_PIO1_7_FUNC_SELECTS_FUNCTION_PIO1_7 = 0x0
	// Selects function TXD.
	IOCON_PIO1_7_FUNC_SELECTS_FUNCTION_TXD = 0x1
	// Selects function CT32B0_MAT1.
	IOCON_PIO1_7_FUNC_SELECTS_FUNCTION_CT32B0_MAT1 = 0x2
	// Position of MODE field.
	IOCON_PIO1_7_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_PIO1_7_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_PIO1_7_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_PIO1_7_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_PIO1_7_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_PIO1_7_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_PIO1_7_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_PIO1_7_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_PIO1_7_HYS = 0x20
	// Disable.
	IOCON_PIO1_7_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_PIO1_7_HYS_ENABLE_ = 0x1
	// Position of RESERVED field.
	IOCON_PIO1_7_RESERVED_Pos = 0x6
	// Bit mask of RESERVED field.
	IOCON_PIO1_7_RESERVED_Msk = 0x3c0
	// Position of OD field.
	IOCON_PIO1_7_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_PIO1_7_OD_Msk = 0x400
	// Bit OD.
	IOCON_PIO1_7_OD = 0x400
	// Standard GPIO output
	IOCON_PIO1_7_OD_STANDARD_GPIO_OUTPUT = 0x0
	// Open-drain output
	IOCON_PIO1_7_OD_OPEN_DRAIN_OUTPUT = 0x1
	// Position of RESERVED field.
	IOCON_PIO1_7_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_PIO1_7_RESERVED_Msk = 0xfffff800
)

// Bitfields for SYSCON: System configuration
const (
	// SYSMEMREMAP: System memory remap
	// Position of MAP field.
	SYSCON_SYSMEMREMAP_MAP_Pos = 0x0
	// Bit mask of MAP field.
	SYSCON_SYSMEMREMAP_MAP_Msk = 0x3
	// Boot Loader Mode. Interrupt vectors are re-mapped to Boot ROM.
	SYSCON_SYSMEMREMAP_MAP_BOOT_LOADER_MODE_IN = 0x0
	// User RAM Mode. Interrupt vectors are re-mapped to Static RAM.
	SYSCON_SYSMEMREMAP_MAP_USER_RAM_MODE_INTER = 0x1
	// Position of RESERVED field.
	SYSCON_SYSMEMREMAP_RESERVED_Pos = 0x2
	// Bit mask of RESERVED field.
	SYSCON_SYSMEMREMAP_RESERVED_Msk = 0xfffffffc

	// PRESETCTRL: Peripheral reset control
	// Position of SSP0_RST_N field.
	SYSCON_PRESETCTRL_SSP0_RST_N_Pos = 0x0
	// Bit mask of SSP0_RST_N field.
	SYSCON_PRESETCTRL_SSP0_RST_N_Msk = 0x1
	// Bit SSP0_RST_N.
	SYSCON_PRESETCTRL_SSP0_RST_N = 0x1
	// Resets the SPI0 peripheral.
	SYSCON_PRESETCTRL_SSP0_RST_N_RESETS_THE_SPI0_PERI = 0x0
	// SPI0 reset de-asserted.
	SYSCON_PRESETCTRL_SSP0_RST_N_SPI0_RESET_DE_ASSERT = 0x1
	// Position of RESERVED field.
	SYSCON_PRESETCTRL_RESERVED_Pos = 0x1
	// Bit mask of RESERVED field.
	SYSCON_PRESETCTRL_RESERVED_Msk = 0xfffffffe

	// SYSPLLCTRL: System PLL control
	// Position of MSEL field.
	SYSCON_SYSPLLCTRL_MSEL_Pos = 0x0
	// Bit mask of MSEL field.
	SYSCON_SYSPLLCTRL_MSEL_Msk = 0x1f
	// Position of PSEL field.
	SYSCON_SYSPLLCTRL_PSEL_Pos = 0x5
	// Bit mask of PSEL field.
	SYSCON_SYSPLLCTRL_PSEL_Msk = 0x60
	// P = 1
	SYSCON_SYSPLLCTRL_PSEL_P_EQ_1 = 0x0
	// P = 2
	SYSCON_SYSPLLCTRL_PSEL_P_EQ_2 = 0x1
	// P = 4
	SYSCON_SYSPLLCTRL_PSEL_P_EQ_4 = 0x2
	// P = 8
	SYSCON_SYSPLLCTRL_PSEL_P_EQ_8 = 0x3
	// Position of RESERVED field.
	SYSCON_SYSPLLCTRL_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	SYSCON_SYSPLLCTRL_RESERVED_Msk = 0xffffff80

	// SYSPLLSTAT: System PLL status
	// Position of LOCK field.
	SYSCON_SYSPLLSTAT_LOCK_Pos = 0x0
	// Bit mask of LOCK field.
	SYSCON_SYSPLLSTAT_LOCK_Msk = 0x1
	// Bit LOCK.
	SYSCON_SYSPLLSTAT_LOCK = 0x1
	// PLL not locked
	SYSCON_SYSPLLSTAT_LOCK_PLL_NOT_LOCKED = 0x0
	// PLL locked
	SYSCON_SYSPLLSTAT_LOCK_PLL_LOCKED = 0x1
	// Position of RESERVED field.
	SYSCON_SYSPLLSTAT_RESERVED_Pos = 0x1
	// Bit mask of RESERVED field.
	SYSCON_SYSPLLSTAT_RESERVED_Msk = 0xfffffffe

	// SYSOSCCTRL: System oscillator control
	// Position of BYPASS field.
	SYSCON_SYSOSCCTRL_BYPASS_Pos = 0x0
	// Bit mask of BYPASS field.
	SYSCON_SYSOSCCTRL_BYPASS_Msk = 0x1
	// Bit BYPASS.
	SYSCON_SYSOSCCTRL_BYPASS = 0x1
	// Oscillator is not bypassed.
	SYSCON_SYSOSCCTRL_BYPASS_OSCILLATOR_IS_NOT_BY = 0x0
	// Bypass enabled. PLL input (sys_osc_clk) is fed directly from the XTALIN pin bypassing the oscillator. Use this mode when using an external clock source instead of the crystal oscillator.
	SYSCON_SYSOSCCTRL_BYPASS_BYPASS_ENABLED_PLL_ = 0x1
	// Position of FREQRANGE field.
	SYSCON_SYSOSCCTRL_FREQRANGE_Pos = 0x1
	// Bit mask of FREQRANGE field.
	SYSCON_SYSOSCCTRL_FREQRANGE_Msk = 0x2
	// Bit FREQRANGE.
	SYSCON_SYSOSCCTRL_FREQRANGE = 0x2
	// 1 - 20 MHz frequency range.
	SYSCON_SYSOSCCTRL_FREQRANGE_1__20_MHZ_FREQUENCY = 0x0
	// 15 - 25 MHz frequency range
	SYSCON_SYSOSCCTRL_FREQRANGE_15__25_MHZ_FREQUENC = 0x1
	// Position of RESERVED field.
	SYSCON_SYSOSCCTRL_RESERVED_Pos = 0x2
	// Bit mask of RESERVED field.
	SYSCON_SYSOSCCTRL_RESERVED_Msk = 0xfffffffc

	// WDTOSCCTRL: Watchdog oscillator control
	// Position of DIVSEL field.
	SYSCON_WDTOSCCTRL_DIVSEL_Pos = 0x0
	// Bit mask of DIVSEL field.
	SYSCON_WDTOSCCTRL_DIVSEL_Msk = 0x1f
	// Position of FREQSEL field.
	SYSCON_WDTOSCCTRL_FREQSEL_Pos = 0x5
	// Bit mask of FREQSEL field.
	SYSCON_WDTOSCCTRL_FREQSEL_Msk = 0x1e0
	// 0.6 MHz
	SYSCON_WDTOSCCTRL_FREQSEL_0_6_MHZ = 0x1
	// 1.05 MHz
	SYSCON_WDTOSCCTRL_FREQSEL_1_05_MHZ = 0x2
	// 1.4 MHz
	SYSCON_WDTOSCCTRL_FREQSEL_1_4_MHZ = 0x3
	// 1.75 MHz
	SYSCON_WDTOSCCTRL_FREQSEL_1_75_MHZ = 0x4
	// 2.1 MHz
	SYSCON_WDTOSCCTRL_FREQSEL_2_1_MHZ = 0x5
	// 2.4 MHz
	SYSCON_WDTOSCCTRL_FREQSEL_2_4_MHZ = 0x6
	// 2.7 MHz
	SYSCON_WDTOSCCTRL_FREQSEL_2_7_MHZ = 0x7
	// 3.0 MHz
	SYSCON_WDTOSCCTRL_FREQSEL_3_0_MHZ = 0x8
	// 3.25 MHz
	SYSCON_WDTOSCCTRL_FREQSEL_3_25_MHZ = 0x9
	// 3.5 MHz
	SYSCON_WDTOSCCTRL_FREQSEL_3_5_MHZ = 0xa
	// 3.75 MHz
	SYSCON_WDTOSCCTRL_FREQSEL_3_75_MHZ = 0xb
	// 4.0 MHz
	SYSCON_WDTOSCCTRL_FREQSEL_4_0_MHZ = 0xc
	// 4.2 MHz
	SYSCON_WDTOSCCTRL_FREQSEL_4_2_MHZ = 0xd
	// 4.4 MHz
	SYSCON_WDTOSCCTRL_FREQSEL_4_4_MHZ = 0xe
	// 4.6 MHz
	SYSCON_WDTOSCCTRL_FREQSEL_4_6_MHZ = 0xf
	// Position of RESERVED field.
	SYSCON_WDTOSCCTRL_RESERVED_Pos = 0x9
	// Bit mask of RESERVED field.
	SYSCON_WDTOSCCTRL_RESERVED_Msk = 0xfffffe00

	// IRCCTRL: IRC control
	// Position of TRIM field.
	SYSCON_IRCCTRL_TRIM_Pos = 0x0
	// Bit mask of TRIM field.
	SYSCON_IRCCTRL_TRIM_Msk = 0xff
	// Position of RESERVED field.
	SYSCON_IRCCTRL_RESERVED_Pos = 0x9
	// Bit mask of RESERVED field.
	SYSCON_IRCCTRL_RESERVED_Msk = 0xfffffe00

	// SYSRSTSTAT: System reset status register
	// Position of POR field.
	SYSCON_SYSRSTSTAT_POR_Pos = 0x0
	// Bit mask of POR field.
	SYSCON_SYSRSTSTAT_POR_Msk = 0x1
	// Bit POR.
	SYSCON_SYSRSTSTAT_POR = 0x1
	// No POR detected
	SYSCON_SYSRSTSTAT_POR_NO_POR_DETECTED = 0x0
	// POR detected. Writing a one clears this reset.
	SYSCON_SYSRSTSTAT_POR_POR_DETECTED_WRITIN = 0x1
	// Position of EXTRST field.
	SYSCON_SYSRSTSTAT_EXTRST_Pos = 0x1
	// Bit mask of EXTRST field.
	SYSCON_SYSRSTSTAT_EXTRST_Msk = 0x2
	// Bit EXTRST.
	SYSCON_SYSRSTSTAT_EXTRST = 0x2
	// No RESET pin event detected
	SYSCON_SYSRSTSTAT_EXTRST_NO_RESET_PIN_EVENT_D = 0x0
	// RESET detected. Writing a one clears this reset.
	SYSCON_SYSRSTSTAT_EXTRST_RESET_DETECTED_WRIT = 0x1
	// Position of WDT field.
	SYSCON_SYSRSTSTAT_WDT_Pos = 0x2
	// Bit mask of WDT field.
	SYSCON_SYSRSTSTAT_WDT_Msk = 0x4
	// Bit WDT.
	SYSCON_SYSRSTSTAT_WDT = 0x4
	// No WDT reset detected
	SYSCON_SYSRSTSTAT_WDT_NO_WDT_RESET_DETECTE = 0x0
	// WDT reset detected. Writing a one clears this reset.
	SYSCON_SYSRSTSTAT_WDT_WDT_RESET_DETECTED_ = 0x1
	// Position of BOD field.
	SYSCON_SYSRSTSTAT_BOD_Pos = 0x3
	// Bit mask of BOD field.
	SYSCON_SYSRSTSTAT_BOD_Msk = 0x8
	// Bit BOD.
	SYSCON_SYSRSTSTAT_BOD = 0x8
	// No BOD reset detected
	SYSCON_SYSRSTSTAT_BOD_NO_BOD_RESET_DETECTE = 0x0
	// BOD reset detected. Writing a one clears this reset.
	SYSCON_SYSRSTSTAT_BOD_BOD_RESET_DETECTED_ = 0x1
	// Position of SYSRST field.
	SYSCON_SYSRSTSTAT_SYSRST_Pos = 0x4
	// Bit mask of SYSRST field.
	SYSCON_SYSRSTSTAT_SYSRST_Msk = 0x10
	// Bit SYSRST.
	SYSCON_SYSRSTSTAT_SYSRST = 0x10
	// No System reset detected
	SYSCON_SYSRSTSTAT_SYSRST_NO_SYSTEM_RESET_DETE = 0x0
	// System reset detected. Writing a one clears this reset.
	SYSCON_SYSRSTSTAT_SYSRST_SYSTEM_RESET_DETECTE = 0x1
	// Position of RESERVED field.
	SYSCON_SYSRSTSTAT_RESERVED_Pos = 0x5
	// Bit mask of RESERVED field.
	SYSCON_SYSRSTSTAT_RESERVED_Msk = 0xffffffe0

	// SYSPLLCLKSEL: System PLL clock source select
	// Position of SEL field.
	SYSCON_SYSPLLCLKSEL_SEL_Pos = 0x0
	// Bit mask of SEL field.
	SYSCON_SYSPLLCLKSEL_SEL_Msk = 0x3
	// IRC oscillator
	SYSCON_SYSPLLCLKSEL_SEL_IRC_OSCILLATOR = 0x0
	// System oscillator
	SYSCON_SYSPLLCLKSEL_SEL_SYSTEM_OSCILLATOR = 0x1
	// Position of RESERVED field.
	SYSCON_SYSPLLCLKSEL_RESERVED_Pos = 0x2
	// Bit mask of RESERVED field.
	SYSCON_SYSPLLCLKSEL_RESERVED_Msk = 0xfffffffc

	// SYSPLLCLKUEN: System PLL clock source update enable
	// Position of ENA field.
	SYSCON_SYSPLLCLKUEN_ENA_Pos = 0x0
	// Bit mask of ENA field.
	SYSCON_SYSPLLCLKUEN_ENA_Msk = 0x1
	// Bit ENA.
	SYSCON_SYSPLLCLKUEN_ENA = 0x1
	// No change
	SYSCON_SYSPLLCLKUEN_ENA_NO_CHANGE = 0x0
	// Update clock source
	SYSCON_SYSPLLCLKUEN_ENA_UPDATE_CLOCK_SOURCE = 0x1
	// Position of RESERVED field.
	SYSCON_SYSPLLCLKUEN_RESERVED_Pos = 0x1
	// Bit mask of RESERVED field.
	SYSCON_SYSPLLCLKUEN_RESERVED_Msk = 0xfffffffe

	// MAINCLKSEL: Main clock source select
	// Position of SEL field.
	SYSCON_MAINCLKSEL_SEL_Pos = 0x0
	// Bit mask of SEL field.
	SYSCON_MAINCLKSEL_SEL_Msk = 0x3
	// IRC oscillator
	SYSCON_MAINCLKSEL_SEL_IRC_OSCILLATOR = 0x0
	// Input clock to system PLL
	SYSCON_MAINCLKSEL_SEL_INPUT_CLOCK_TO_SYSTE = 0x1
	// WDT oscillator
	SYSCON_MAINCLKSEL_SEL_WDT_OSCILLATOR = 0x2
	// System PLL clock out
	SYSCON_MAINCLKSEL_SEL_SYSTEM_PLL_CLOCK_OUT = 0x3
	// Position of RESERVED field.
	SYSCON_MAINCLKSEL_RESERVED_Pos = 0x2
	// Bit mask of RESERVED field.
	SYSCON_MAINCLKSEL_RESERVED_Msk = 0xfffffffc

	// MAINCLKUEN: Main clock source update enable
	// Position of ENA field.
	SYSCON_MAINCLKUEN_ENA_Pos = 0x0
	// Bit mask of ENA field.
	SYSCON_MAINCLKUEN_ENA_Msk = 0x1
	// Bit ENA.
	SYSCON_MAINCLKUEN_ENA = 0x1
	// No change
	SYSCON_MAINCLKUEN_ENA_NO_CHANGE = 0x0
	// Update clock source
	SYSCON_MAINCLKUEN_ENA_UPDATE_CLOCK_SOURCE = 0x1
	// Position of RESERVED field.
	SYSCON_MAINCLKUEN_RESERVED_Pos = 0x1
	// Bit mask of RESERVED field.
	SYSCON_MAINCLKUEN_RESERVED_Msk = 0xfffffffe

	// SYSAHBCLKDIV: System AHB clock divider
	// Position of DIV field.
	SYSCON_SYSAHBCLKDIV_DIV_Pos = 0x0
	// Bit mask of DIV field.
	SYSCON_SYSAHBCLKDIV_DIV_Msk = 0xff
	// Position of RESERVED field.
	SYSCON_SYSAHBCLKDIV_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	SYSCON_SYSAHBCLKDIV_RESERVED_Msk = 0xffffff00

	// SYSAHBCLKCTRL: System AHB clock control
	// Position of SYS field.
	SYSCON_SYSAHBCLKCTRL_SYS_Pos = 0x0
	// Bit mask of SYS field.
	SYSCON_SYSAHBCLKCTRL_SYS_Msk = 0x1
	// Bit SYS.
	SYSCON_SYSAHBCLKCTRL_SYS = 0x1
	// Enable
	SYSCON_SYSAHBCLKCTRL_SYS_ENABLE = 0x1
	// Position of ROM field.
	SYSCON_SYSAHBCLKCTRL_ROM_Pos = 0x1
	// Bit mask of ROM field.
	SYSCON_SYSAHBCLKCTRL_ROM_Msk = 0x2
	// Bit ROM.
	SYSCON_SYSAHBCLKCTRL_ROM = 0x2
	// Disable
	SYSCON_SYSAHBCLKCTRL_ROM_DISABLE = 0x0
	// Enable
	SYSCON_SYSAHBCLKCTRL_ROM_ENABLE = 0x1
	// Position of RAM field.
	SYSCON_SYSAHBCLKCTRL_RAM_Pos = 0x2
	// Bit mask of RAM field.
	SYSCON_SYSAHBCLKCTRL_RAM_Msk = 0x4
	// Bit RAM.
	SYSCON_SYSAHBCLKCTRL_RAM = 0x4
	// Disable
	SYSCON_SYSAHBCLKCTRL_RAM_DISABLE = 0x0
	// Enable
	SYSCON_SYSAHBCLKCTRL_RAM_ENABLE = 0x1
	// Position of FLASHREG field.
	SYSCON_SYSAHBCLKCTRL_FLASHREG_Pos = 0x3
	// Bit mask of FLASHREG field.
	SYSCON_SYSAHBCLKCTRL_FLASHREG_Msk = 0x8
	// Bit FLASHREG.
	SYSCON_SYSAHBCLKCTRL_FLASHREG = 0x8
	// Disabled
	SYSCON_SYSAHBCLKCTRL_FLASHREG_DISABLED = 0x0
	// Enabled
	SYSCON_SYSAHBCLKCTRL_FLASHREG_ENABLED = 0x1
	// Position of FLASHARRAY field.
	SYSCON_SYSAHBCLKCTRL_FLASHARRAY_Pos = 0x4
	// Bit mask of FLASHARRAY field.
	SYSCON_SYSAHBCLKCTRL_FLASHARRAY_Msk = 0x10
	// Bit FLASHARRAY.
	SYSCON_SYSAHBCLKCTRL_FLASHARRAY = 0x10
	// Disabled
	SYSCON_SYSAHBCLKCTRL_FLASHARRAY_DISABLED = 0x0
	// Enabled
	SYSCON_SYSAHBCLKCTRL_FLASHARRAY_ENABLED = 0x1
	// Position of RESERVED field.
	SYSCON_SYSAHBCLKCTRL_RESERVED_Pos = 0x5
	// Bit mask of RESERVED field.
	SYSCON_SYSAHBCLKCTRL_RESERVED_Msk = 0x20
	// Bit RESERVED.
	SYSCON_SYSAHBCLKCTRL_RESERVED = 0x20
	// Position of GPIO field.
	SYSCON_SYSAHBCLKCTRL_GPIO_Pos = 0x6
	// Bit mask of GPIO field.
	SYSCON_SYSAHBCLKCTRL_GPIO_Msk = 0x40
	// Bit GPIO.
	SYSCON_SYSAHBCLKCTRL_GPIO = 0x40
	// Disable
	SYSCON_SYSAHBCLKCTRL_GPIO_DISABLE = 0x0
	// Enable
	SYSCON_SYSAHBCLKCTRL_GPIO_ENABLE = 0x1
	// Position of CT16B0 field.
	SYSCON_SYSAHBCLKCTRL_CT16B0_Pos = 0x7
	// Bit mask of CT16B0 field.
	SYSCON_SYSAHBCLKCTRL_CT16B0_Msk = 0x80
	// Bit CT16B0.
	SYSCON_SYSAHBCLKCTRL_CT16B0 = 0x80
	// Disable
	SYSCON_SYSAHBCLKCTRL_CT16B0_DISABLE = 0x0
	// Enable
	SYSCON_SYSAHBCLKCTRL_CT16B0_ENABLE = 0x1
	// Position of CT16B1 field.
	SYSCON_SYSAHBCLKCTRL_CT16B1_Pos = 0x8
	// Bit mask of CT16B1 field.
	SYSCON_SYSAHBCLKCTRL_CT16B1_Msk = 0x100
	// Bit CT16B1.
	SYSCON_SYSAHBCLKCTRL_CT16B1 = 0x100
	// Disable
	SYSCON_SYSAHBCLKCTRL_CT16B1_DISABLE = 0x0
	// Enable
	SYSCON_SYSAHBCLKCTRL_CT16B1_ENABLE = 0x1
	// Position of CT32B0 field.
	SYSCON_SYSAHBCLKCTRL_CT32B0_Pos = 0x9
	// Bit mask of CT32B0 field.
	SYSCON_SYSAHBCLKCTRL_CT32B0_Msk = 0x200
	// Bit CT32B0.
	SYSCON_SYSAHBCLKCTRL_CT32B0 = 0x200
	// Disable
	SYSCON_SYSAHBCLKCTRL_CT32B0_DISABLE = 0x0
	// Enable
	SYSCON_SYSAHBCLKCTRL_CT32B0_ENABLE = 0x1
	// Position of CT32B1 field.
	SYSCON_SYSAHBCLKCTRL_CT32B1_Pos = 0xa
	// Bit mask of CT32B1 field.
	SYSCON_SYSAHBCLKCTRL_CT32B1_Msk = 0x400
	// Bit CT32B1.
	SYSCON_SYSAHBCLKCTRL_CT32B1 = 0x400
	// Disable
	SYSCON_SYSAHBCLKCTRL_CT32B1_DISABLE = 0x0
	// Enable
	SYSCON_SYSAHBCLKCTRL_CT32B1_ENABLE = 0x1
	// Position of SSP0 field.
	SYSCON_SYSAHBCLKCTRL_SSP0_Pos = 0xb
	// Bit mask of SSP0 field.
	SYSCON_SYSAHBCLKCTRL_SSP0_Msk = 0x800
	// Bit SSP0.
	SYSCON_SYSAHBCLKCTRL_SSP0 = 0x800
	// Disable
	SYSCON_SYSAHBCLKCTRL_SSP0_DISABLE = 0x0
	// Enable
	SYSCON_SYSAHBCLKCTRL_SSP0_ENABLE = 0x1
	// Position of UART field.
	SYSCON_SYSAHBCLKCTRL_UART_Pos = 0xc
	// Bit mask of UART field.
	SYSCON_SYSAHBCLKCTRL_UART_Msk = 0x1000
	// Bit UART.
	SYSCON_SYSAHBCLKCTRL_UART = 0x1000
	// Disable
	SYSCON_SYSAHBCLKCTRL_UART_DISABLE = 0x0
	// Enable
	SYSCON_SYSAHBCLKCTRL_UART_ENABLE = 0x1
	// Position of ADC field.
	SYSCON_SYSAHBCLKCTRL_ADC_Pos = 0xd
	// Bit mask of ADC field.
	SYSCON_SYSAHBCLKCTRL_ADC_Msk = 0x2000
	// Bit ADC.
	SYSCON_SYSAHBCLKCTRL_ADC = 0x2000
	// Disable
	SYSCON_SYSAHBCLKCTRL_ADC_DISABLE = 0x0
	// Enable
	SYSCON_SYSAHBCLKCTRL_ADC_ENABLE = 0x1
	// Position of RESERVED field.
	SYSCON_SYSAHBCLKCTRL_RESERVED_Pos = 0xe
	// Bit mask of RESERVED field.
	SYSCON_SYSAHBCLKCTRL_RESERVED_Msk = 0x4000
	// Bit RESERVED.
	SYSCON_SYSAHBCLKCTRL_RESERVED = 0x4000
	// Position of WDT field.
	SYSCON_SYSAHBCLKCTRL_WDT_Pos = 0xf
	// Bit mask of WDT field.
	SYSCON_SYSAHBCLKCTRL_WDT_Msk = 0x8000
	// Bit WDT.
	SYSCON_SYSAHBCLKCTRL_WDT = 0x8000
	// Disable
	SYSCON_SYSAHBCLKCTRL_WDT_DISABLE = 0x0
	// Enable
	SYSCON_SYSAHBCLKCTRL_WDT_ENABLE = 0x1
	// Position of IOCON field.
	SYSCON_SYSAHBCLKCTRL_IOCON_Pos = 0x10
	// Bit mask of IOCON field.
	SYSCON_SYSAHBCLKCTRL_IOCON_Msk = 0x10000
	// Bit IOCON.
	SYSCON_SYSAHBCLKCTRL_IOCON = 0x10000
	// Disable
	SYSCON_SYSAHBCLKCTRL_IOCON_DISABLE = 0x0
	// Enable
	SYSCON_SYSAHBCLKCTRL_IOCON_ENABLE = 0x1
	// Position of RESERVED field.
	SYSCON_SYSAHBCLKCTRL_RESERVED_Pos = 0x11
	// Bit mask of RESERVED field.
	SYSCON_SYSAHBCLKCTRL_RESERVED_Msk = 0xfffe0000

	// SSP0CLKDIV: SPI0 clock divder
	// Position of DIV field.
	SYSCON_SSP0CLKDIV_DIV_Pos = 0x0
	// Bit mask of DIV field.
	SYSCON_SSP0CLKDIV_DIV_Msk = 0xff
	// Position of RESERVED field.
	SYSCON_SSP0CLKDIV_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	SYSCON_SSP0CLKDIV_RESERVED_Msk = 0xffffff00

	// UARTCLKDIV: UART clock divder
	// Position of DIV field.
	SYSCON_UARTCLKDIV_DIV_Pos = 0x0
	// Bit mask of DIV field.
	SYSCON_UARTCLKDIV_DIV_Msk = 0xff
	// Position of RESERVED field.
	SYSCON_UARTCLKDIV_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	SYSCON_UARTCLKDIV_RESERVED_Msk = 0xffffff00

	// WDTCLKSEL: WDT clock source select
	// Position of SEL field.
	SYSCON_WDTCLKSEL_SEL_Pos = 0x0
	// Bit mask of SEL field.
	SYSCON_WDTCLKSEL_SEL_Msk = 0x3
	// IRC oscillator
	SYSCON_WDTCLKSEL_SEL_IRC_OSCILLATOR = 0x0
	// Main clock
	SYSCON_WDTCLKSEL_SEL_MAIN_CLOCK = 0x1
	// Watchdog oscillator
	SYSCON_WDTCLKSEL_SEL_WATCHDOG_OSCILLATOR = 0x2
	// Position of RESERVED field.
	SYSCON_WDTCLKSEL_RESERVED_Pos = 0x2
	// Bit mask of RESERVED field.
	SYSCON_WDTCLKSEL_RESERVED_Msk = 0xfffffffc

	// WDTCLKUEN: WDT clock source update enable
	// Position of ENA field.
	SYSCON_WDTCLKUEN_ENA_Pos = 0x0
	// Bit mask of ENA field.
	SYSCON_WDTCLKUEN_ENA_Msk = 0x1
	// Bit ENA.
	SYSCON_WDTCLKUEN_ENA = 0x1
	// No change
	SYSCON_WDTCLKUEN_ENA_NO_CHANGE = 0x0
	// Update clock source
	SYSCON_WDTCLKUEN_ENA_UPDATE_CLOCK_SOURCE = 0x1
	// Position of RESERVED field.
	SYSCON_WDTCLKUEN_RESERVED_Pos = 0x1
	// Bit mask of RESERVED field.
	SYSCON_WDTCLKUEN_RESERVED_Msk = 0xfffffffe

	// WDTCLKDIV: WDT clock divider
	// Position of DIV field.
	SYSCON_WDTCLKDIV_DIV_Pos = 0x0
	// Bit mask of DIV field.
	SYSCON_WDTCLKDIV_DIV_Msk = 0xff
	// Position of RESERVED field.
	SYSCON_WDTCLKDIV_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	SYSCON_WDTCLKDIV_RESERVED_Msk = 0xffffff00

	// CLKOUTCLKSEL: CLKOUT clock source select
	// Position of SEL field.
	SYSCON_CLKOUTCLKSEL_SEL_Pos = 0x0
	// Bit mask of SEL field.
	SYSCON_CLKOUTCLKSEL_SEL_Msk = 0x3
	// IRC oscillator
	SYSCON_CLKOUTCLKSEL_SEL_IRC_OSCILLATOR = 0x0
	// System oscillator
	SYSCON_CLKOUTCLKSEL_SEL_SYSTEM_OSCILLATOR = 0x1
	// Watchdog oscillator
	SYSCON_CLKOUTCLKSEL_SEL_WATCHDOG_OSCILLATOR = 0x2
	// Main clock
	SYSCON_CLKOUTCLKSEL_SEL_MAIN_CLOCK = 0x3
	// Position of RESERVED field.
	SYSCON_CLKOUTCLKSEL_RESERVED_Pos = 0x2
	// Bit mask of RESERVED field.
	SYSCON_CLKOUTCLKSEL_RESERVED_Msk = 0xfffffffc

	// CLKOUTUEN: CLKOUT clock source update enable
	// Position of ENA field.
	SYSCON_CLKOUTUEN_ENA_Pos = 0x0
	// Bit mask of ENA field.
	SYSCON_CLKOUTUEN_ENA_Msk = 0x1
	// Bit ENA.
	SYSCON_CLKOUTUEN_ENA = 0x1
	// No change
	SYSCON_CLKOUTUEN_ENA_NO_CHANGE = 0x0
	// Update clock source
	SYSCON_CLKOUTUEN_ENA_UPDATE_CLOCK_SOURCE = 0x1
	// Position of RESERVED field.
	SYSCON_CLKOUTUEN_RESERVED_Pos = 0x1
	// Bit mask of RESERVED field.
	SYSCON_CLKOUTUEN_RESERVED_Msk = 0xfffffffe

	// CLKOUTCLKDIV: CLKOUT clock divider
	// Position of DIV field.
	SYSCON_CLKOUTCLKDIV_DIV_Pos = 0x0
	// Bit mask of DIV field.
	SYSCON_CLKOUTCLKDIV_DIV_Msk = 0xff
	// Position of RESERVED field.
	SYSCON_CLKOUTCLKDIV_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	SYSCON_CLKOUTCLKDIV_RESERVED_Msk = 0xffffff00

	// PIOPORCAP0: POR captured PIO status 0
	// Position of CAPPIO0_0 field.
	SYSCON_PIOPORCAP0_CAPPIO0_0_Pos = 0x0
	// Bit mask of CAPPIO0_0 field.
	SYSCON_PIOPORCAP0_CAPPIO0_0_Msk = 0x1
	// Bit CAPPIO0_0.
	SYSCON_PIOPORCAP0_CAPPIO0_0 = 0x1
	// Position of RESERVED field.
	SYSCON_PIOPORCAP0_RESERVED_Pos = 0x1
	// Bit mask of RESERVED field.
	SYSCON_PIOPORCAP0_RESERVED_Msk = 0xfe
	// Position of CAPPIO0_8 field.
	SYSCON_PIOPORCAP0_CAPPIO0_8_Pos = 0x8
	// Bit mask of CAPPIO0_8 field.
	SYSCON_PIOPORCAP0_CAPPIO0_8_Msk = 0x100
	// Bit CAPPIO0_8.
	SYSCON_PIOPORCAP0_CAPPIO0_8 = 0x100
	// Position of CAPPIO0_9 field.
	SYSCON_PIOPORCAP0_CAPPIO0_9_Pos = 0x9
	// Bit mask of CAPPIO0_9 field.
	SYSCON_PIOPORCAP0_CAPPIO0_9_Msk = 0x200
	// Bit CAPPIO0_9.
	SYSCON_PIOPORCAP0_CAPPIO0_9 = 0x200
	// Position of CAPPIO0_10 field.
	SYSCON_PIOPORCAP0_CAPPIO0_10_Pos = 0xa
	// Bit mask of CAPPIO0_10 field.
	SYSCON_PIOPORCAP0_CAPPIO0_10_Msk = 0x400
	// Bit CAPPIO0_10.
	SYSCON_PIOPORCAP0_CAPPIO0_10 = 0x400
	// Position of CAPPIO0_11 field.
	SYSCON_PIOPORCAP0_CAPPIO0_11_Pos = 0xb
	// Bit mask of CAPPIO0_11 field.
	SYSCON_PIOPORCAP0_CAPPIO0_11_Msk = 0x800
	// Bit CAPPIO0_11.
	SYSCON_PIOPORCAP0_CAPPIO0_11 = 0x800
	// Position of CAPPIO1_0 field.
	SYSCON_PIOPORCAP0_CAPPIO1_0_Pos = 0xc
	// Bit mask of CAPPIO1_0 field.
	SYSCON_PIOPORCAP0_CAPPIO1_0_Msk = 0x1000
	// Bit CAPPIO1_0.
	SYSCON_PIOPORCAP0_CAPPIO1_0 = 0x1000
	// Position of CAPPIO1_1 field.
	SYSCON_PIOPORCAP0_CAPPIO1_1_Pos = 0xd
	// Bit mask of CAPPIO1_1 field.
	SYSCON_PIOPORCAP0_CAPPIO1_1_Msk = 0x2000
	// Bit CAPPIO1_1.
	SYSCON_PIOPORCAP0_CAPPIO1_1 = 0x2000
	// Position of CAPPIO1_2 field.
	SYSCON_PIOPORCAP0_CAPPIO1_2_Pos = 0xe
	// Bit mask of CAPPIO1_2 field.
	SYSCON_PIOPORCAP0_CAPPIO1_2_Msk = 0x4000
	// Bit CAPPIO1_2.
	SYSCON_PIOPORCAP0_CAPPIO1_2 = 0x4000
	// Position of CAPPIO1_3 field.
	SYSCON_PIOPORCAP0_CAPPIO1_3_Pos = 0xf
	// Bit mask of CAPPIO1_3 field.
	SYSCON_PIOPORCAP0_CAPPIO1_3_Msk = 0x8000
	// Bit CAPPIO1_3.
	SYSCON_PIOPORCAP0_CAPPIO1_3 = 0x8000
	// Position of RESERVED field.
	SYSCON_PIOPORCAP0_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	SYSCON_PIOPORCAP0_RESERVED_Msk = 0x30000
	// Position of CAPPIO1_6 field.
	SYSCON_PIOPORCAP0_CAPPIO1_6_Pos = 0x12
	// Bit mask of CAPPIO1_6 field.
	SYSCON_PIOPORCAP0_CAPPIO1_6_Msk = 0x40000
	// Bit CAPPIO1_6.
	SYSCON_PIOPORCAP0_CAPPIO1_6 = 0x40000
	// Position of CAPPIO1_7 field.
	SYSCON_PIOPORCAP0_CAPPIO1_7_Pos = 0x13
	// Bit mask of CAPPIO1_7 field.
	SYSCON_PIOPORCAP0_CAPPIO1_7_Msk = 0x80000
	// Bit CAPPIO1_7.
	SYSCON_PIOPORCAP0_CAPPIO1_7 = 0x80000
	// Position of RESERVED field.
	SYSCON_PIOPORCAP0_RESERVED_Pos = 0x14
	// Bit mask of RESERVED field.
	SYSCON_PIOPORCAP0_RESERVED_Msk = 0xfff00000

	// BODCTRL: BOD control
	// Position of BODRSTLEV field.
	SYSCON_BODCTRL_BODRSTLEV_Pos = 0x0
	// Bit mask of BODRSTLEV field.
	SYSCON_BODCTRL_BODRSTLEV_Msk = 0x3
	// Level 0: Reserved.
	SYSCON_BODCTRL_BODRSTLEV_LEVEL_0_RESERVED_ = 0x0
	// Level 1: The reset assertion threshold voltage is 2.06 V; the reset de-assertion threshold voltage is 2.15 V.
	SYSCON_BODCTRL_BODRSTLEV_LEVEL_1_THE_RESET_A = 0x1
	// Level 2: The reset assertion threshold voltage is 2.35 V; the reset de-assertion threshold voltage is 2.43 V.
	SYSCON_BODCTRL_BODRSTLEV_LEVEL_2_THE_RESET_A = 0x2
	// Level 3: The reset assertion threshold voltage is 2.63 V; the reset de-assertion threshold voltage is 2.71 V.
	SYSCON_BODCTRL_BODRSTLEV_LEVEL_3_THE_RESET_A = 0x3
	// Position of BODINTVAL field.
	SYSCON_BODCTRL_BODINTVAL_Pos = 0x2
	// Bit mask of BODINTVAL field.
	SYSCON_BODCTRL_BODINTVAL_Msk = 0xc
	// Level 0: Reserved.
	SYSCON_BODCTRL_BODINTVAL_LEVEL_0_RESERVED_ = 0x0
	// Level 1:The interrupt assertion threshold voltage is 2.22 V; the interrupt de-assertion threshold voltage is 2.35 V.
	SYSCON_BODCTRL_BODINTVAL_LEVEL_1THE_INTERRUP = 0x1
	// Level 2: The interrupt assertion threshold voltage is 2.52 V; the interrupt de-assertion threshold voltage is 2.66 V.
	SYSCON_BODCTRL_BODINTVAL_LEVEL_2_THE_INTERRU = 0x2
	// Level 3: The interrupt assertion threshold voltage is 2.80 V; the interrupt de-assertion threshold voltage is 2.90 V.
	SYSCON_BODCTRL_BODINTVAL_LEVEL_3_THE_INTERRU = 0x3
	// Position of BODRSTENA field.
	SYSCON_BODCTRL_BODRSTENA_Pos = 0x4
	// Bit mask of BODRSTENA field.
	SYSCON_BODCTRL_BODRSTENA_Msk = 0x10
	// Bit BODRSTENA.
	SYSCON_BODCTRL_BODRSTENA = 0x10
	// Disable reset function.
	SYSCON_BODCTRL_BODRSTENA_DISABLE_RESET_FUNCTI = 0x0
	// Enable reset function.
	SYSCON_BODCTRL_BODRSTENA_ENABLE_RESET_FUNCTIO = 0x1
	// Position of RESERVED field.
	SYSCON_BODCTRL_RESERVED_Pos = 0x5
	// Bit mask of RESERVED field.
	SYSCON_BODCTRL_RESERVED_Msk = 0xffffffe0

	// SYSTCKCAL: System tick counter calibration
	// Position of CAL field.
	SYSCON_SYSTCKCAL_CAL_Pos = 0x0
	// Bit mask of CAL field.
	SYSCON_SYSTCKCAL_CAL_Msk = 0x3ffffff
	// Position of RESERVED field.
	SYSCON_SYSTCKCAL_RESERVED_Pos = 0x1a
	// Bit mask of RESERVED field.
	SYSCON_SYSTCKCAL_RESERVED_Msk = 0xfc000000

	// STARTAPRP0: Start logic edge control register 0
	// Position of APRPIO0_0 field.
	SYSCON_STARTAPRP0_APRPIO0_0_Pos = 0x0
	// Bit mask of APRPIO0_0 field.
	SYSCON_STARTAPRP0_APRPIO0_0_Msk = 0x1
	// Bit APRPIO0_0.
	SYSCON_STARTAPRP0_APRPIO0_0 = 0x1
	// Falling edge
	SYSCON_STARTAPRP0_APRPIO0_0_FALLING_EDGE = 0x0
	// Rising edge
	SYSCON_STARTAPRP0_APRPIO0_0_RISING_EDGE = 0x1
	// Position of RESERVED field.
	SYSCON_STARTAPRP0_RESERVED_Pos = 0x1
	// Bit mask of RESERVED field.
	SYSCON_STARTAPRP0_RESERVED_Msk = 0xfe
	// Position of APRPIO0_8 field.
	SYSCON_STARTAPRP0_APRPIO0_8_Pos = 0x8
	// Bit mask of APRPIO0_8 field.
	SYSCON_STARTAPRP0_APRPIO0_8_Msk = 0x100
	// Bit APRPIO0_8.
	SYSCON_STARTAPRP0_APRPIO0_8 = 0x100
	// Falling edge
	SYSCON_STARTAPRP0_APRPIO0_8_FALLING_EDGE = 0x0
	// Rising edge
	SYSCON_STARTAPRP0_APRPIO0_8_RISING_EDGE = 0x1
	// Position of APRPIO0_9 field.
	SYSCON_STARTAPRP0_APRPIO0_9_Pos = 0x9
	// Bit mask of APRPIO0_9 field.
	SYSCON_STARTAPRP0_APRPIO0_9_Msk = 0x200
	// Bit APRPIO0_9.
	SYSCON_STARTAPRP0_APRPIO0_9 = 0x200
	// Falling edge
	SYSCON_STARTAPRP0_APRPIO0_9_FALLING_EDGE = 0x0
	// Rising edge
	SYSCON_STARTAPRP0_APRPIO0_9_RISING_EDGE = 0x1
	// Position of APRPIO0_10 field.
	SYSCON_STARTAPRP0_APRPIO0_10_Pos = 0xa
	// Bit mask of APRPIO0_10 field.
	SYSCON_STARTAPRP0_APRPIO0_10_Msk = 0x400
	// Bit APRPIO0_10.
	SYSCON_STARTAPRP0_APRPIO0_10 = 0x400
	// Falling edge
	SYSCON_STARTAPRP0_APRPIO0_10_FALLING_EDGE = 0x0
	// Rising edge
	SYSCON_STARTAPRP0_APRPIO0_10_RISING_EDGE = 0x1
	// Position of APRPIO0_11 field.
	SYSCON_STARTAPRP0_APRPIO0_11_Pos = 0xb
	// Bit mask of APRPIO0_11 field.
	SYSCON_STARTAPRP0_APRPIO0_11_Msk = 0x800
	// Bit APRPIO0_11.
	SYSCON_STARTAPRP0_APRPIO0_11 = 0x800
	// Falling edge
	SYSCON_STARTAPRP0_APRPIO0_11_FALLING_EDGE = 0x0
	// Rising edge
	SYSCON_STARTAPRP0_APRPIO0_11_RISING_EDGE = 0x1
	// Position of APRPIO1_0 field.
	SYSCON_STARTAPRP0_APRPIO1_0_Pos = 0xc
	// Bit mask of APRPIO1_0 field.
	SYSCON_STARTAPRP0_APRPIO1_0_Msk = 0x1000
	// Bit APRPIO1_0.
	SYSCON_STARTAPRP0_APRPIO1_0 = 0x1000
	// Falling edge
	SYSCON_STARTAPRP0_APRPIO1_0_FALLING_EDGE = 0x0
	// Rising edge
	SYSCON_STARTAPRP0_APRPIO1_0_RISING_EDGE = 0x1
	// Position of RESERVED field.
	SYSCON_STARTAPRP0_RESERVED_Pos = 0xd
	// Bit mask of RESERVED field.
	SYSCON_STARTAPRP0_RESERVED_Msk = 0xffffe000

	// STARTERP0: Start logic signal enable register 0
	// Position of ERPIO0_0 field.
	SYSCON_STARTERP0_ERPIO0_0_Pos = 0x0
	// Bit mask of ERPIO0_0 field.
	SYSCON_STARTERP0_ERPIO0_0_Msk = 0x1
	// Bit ERPIO0_0.
	SYSCON_STARTERP0_ERPIO0_0 = 0x1
	// Disabled
	SYSCON_STARTERP0_ERPIO0_0_DISABLED = 0x0
	// Enabled
	SYSCON_STARTERP0_ERPIO0_0_ENABLED = 0x1
	// Position of RESERVED field.
	SYSCON_STARTERP0_RESERVED_Pos = 0x1
	// Bit mask of RESERVED field.
	SYSCON_STARTERP0_RESERVED_Msk = 0xfe
	// Position of ERPIO0_8 field.
	SYSCON_STARTERP0_ERPIO0_8_Pos = 0x8
	// Bit mask of ERPIO0_8 field.
	SYSCON_STARTERP0_ERPIO0_8_Msk = 0x100
	// Bit ERPIO0_8.
	SYSCON_STARTERP0_ERPIO0_8 = 0x100
	// Disabled
	SYSCON_STARTERP0_ERPIO0_8_DISABLED = 0x0
	// Enabled
	SYSCON_STARTERP0_ERPIO0_8_ENABLED = 0x1
	// Position of ERPIO0_9 field.
	SYSCON_STARTERP0_ERPIO0_9_Pos = 0x9
	// Bit mask of ERPIO0_9 field.
	SYSCON_STARTERP0_ERPIO0_9_Msk = 0x200
	// Bit ERPIO0_9.
	SYSCON_STARTERP0_ERPIO0_9 = 0x200
	// Disabled
	SYSCON_STARTERP0_ERPIO0_9_DISABLED = 0x0
	// Enabled
	SYSCON_STARTERP0_ERPIO0_9_ENABLED = 0x1
	// Position of ERPIO0_10 field.
	SYSCON_STARTERP0_ERPIO0_10_Pos = 0xa
	// Bit mask of ERPIO0_10 field.
	SYSCON_STARTERP0_ERPIO0_10_Msk = 0x400
	// Bit ERPIO0_10.
	SYSCON_STARTERP0_ERPIO0_10 = 0x400
	// Disabled
	SYSCON_STARTERP0_ERPIO0_10_DISABLED = 0x0
	// Enabled
	SYSCON_STARTERP0_ERPIO0_10_ENABLED = 0x1
	// Position of ERPIO0_11 field.
	SYSCON_STARTERP0_ERPIO0_11_Pos = 0xb
	// Bit mask of ERPIO0_11 field.
	SYSCON_STARTERP0_ERPIO0_11_Msk = 0x800
	// Bit ERPIO0_11.
	SYSCON_STARTERP0_ERPIO0_11 = 0x800
	// Disabled
	SYSCON_STARTERP0_ERPIO0_11_DISABLED = 0x0
	// Enabled
	SYSCON_STARTERP0_ERPIO0_11_ENABLED = 0x1
	// Position of ERPIO1_0 field.
	SYSCON_STARTERP0_ERPIO1_0_Pos = 0xc
	// Bit mask of ERPIO1_0 field.
	SYSCON_STARTERP0_ERPIO1_0_Msk = 0x1000
	// Bit ERPIO1_0.
	SYSCON_STARTERP0_ERPIO1_0 = 0x1000
	// Disabled
	SYSCON_STARTERP0_ERPIO1_0_DISABLED = 0x0
	// Enabled
	SYSCON_STARTERP0_ERPIO1_0_ENABLED = 0x1
	// Position of RESERVED field.
	SYSCON_STARTERP0_RESERVED_Pos = 0xd
	// Bit mask of RESERVED field.
	SYSCON_STARTERP0_RESERVED_Msk = 0xffffe000

	// STARTRSRP0CLR: Start logic reset register 0
	// Position of RSRPIO0_0 field.
	SYSCON_STARTRSRP0CLR_RSRPIO0_0_Pos = 0x0
	// Bit mask of RSRPIO0_0 field.
	SYSCON_STARTRSRP0CLR_RSRPIO0_0_Msk = 0x1
	// Bit RSRPIO0_0.
	SYSCON_STARTRSRP0CLR_RSRPIO0_0 = 0x1
	// RESERVED
	SYSCON_STARTRSRP0CLR_RSRPIO0_0__ = 0x0
	// Write: reset start signal
	SYSCON_STARTRSRP0CLR_RSRPIO0_0_WRITE_RESET_START_S = 0x1
	// Position of RESERVED field.
	SYSCON_STARTRSRP0CLR_RESERVED_Pos = 0x1
	// Bit mask of RESERVED field.
	SYSCON_STARTRSRP0CLR_RESERVED_Msk = 0xfe
	// Position of RSRPIO0_8 field.
	SYSCON_STARTRSRP0CLR_RSRPIO0_8_Pos = 0x8
	// Bit mask of RSRPIO0_8 field.
	SYSCON_STARTRSRP0CLR_RSRPIO0_8_Msk = 0x100
	// Bit RSRPIO0_8.
	SYSCON_STARTRSRP0CLR_RSRPIO0_8 = 0x100
	// RESERVED
	SYSCON_STARTRSRP0CLR_RSRPIO0_8__ = 0x0
	// Write: reset start signal
	SYSCON_STARTRSRP0CLR_RSRPIO0_8_WRITE_RESET_START_S = 0x1
	// Position of RSRPIO0_9 field.
	SYSCON_STARTRSRP0CLR_RSRPIO0_9_Pos = 0x9
	// Bit mask of RSRPIO0_9 field.
	SYSCON_STARTRSRP0CLR_RSRPIO0_9_Msk = 0x200
	// Bit RSRPIO0_9.
	SYSCON_STARTRSRP0CLR_RSRPIO0_9 = 0x200
	// RESERVED
	SYSCON_STARTRSRP0CLR_RSRPIO0_9__ = 0x0
	// Write: reset start signal
	SYSCON_STARTRSRP0CLR_RSRPIO0_9_WRITE_RESET_START_S = 0x1
	// Position of RSRPIO0_10 field.
	SYSCON_STARTRSRP0CLR_RSRPIO0_10_Pos = 0xa
	// Bit mask of RSRPIO0_10 field.
	SYSCON_STARTRSRP0CLR_RSRPIO0_10_Msk = 0x400
	// Bit RSRPIO0_10.
	SYSCON_STARTRSRP0CLR_RSRPIO0_10 = 0x400
	// RESERVED
	SYSCON_STARTRSRP0CLR_RSRPIO0_10__ = 0x0
	// Write: reset start signal
	SYSCON_STARTRSRP0CLR_RSRPIO0_10_WRITE_RESET_START_S = 0x1
	// Position of RSRPIO0_11 field.
	SYSCON_STARTRSRP0CLR_RSRPIO0_11_Pos = 0xb
	// Bit mask of RSRPIO0_11 field.
	SYSCON_STARTRSRP0CLR_RSRPIO0_11_Msk = 0x800
	// Bit RSRPIO0_11.
	SYSCON_STARTRSRP0CLR_RSRPIO0_11 = 0x800
	// RESERVED
	SYSCON_STARTRSRP0CLR_RSRPIO0_11__ = 0x0
	// Write: reset start signal
	SYSCON_STARTRSRP0CLR_RSRPIO0_11_WRITE_RESET_START_S = 0x1
	// Position of RSRPIO1_0 field.
	SYSCON_STARTRSRP0CLR_RSRPIO1_0_Pos = 0xc
	// Bit mask of RSRPIO1_0 field.
	SYSCON_STARTRSRP0CLR_RSRPIO1_0_Msk = 0x1000
	// Bit RSRPIO1_0.
	SYSCON_STARTRSRP0CLR_RSRPIO1_0 = 0x1000
	// RESERVED
	SYSCON_STARTRSRP0CLR_RSRPIO1_0__ = 0x0
	// Write: reset start signal
	SYSCON_STARTRSRP0CLR_RSRPIO1_0_WRITE_RESET_START_S = 0x1
	// Position of RESERVED field.
	SYSCON_STARTRSRP0CLR_RESERVED_Pos = 0xd
	// Bit mask of RESERVED field.
	SYSCON_STARTRSRP0CLR_RESERVED_Msk = 0xffffe000

	// STARTSRP0: Start logic status register 0
	// Position of SRPIO0_0 field.
	SYSCON_STARTSRP0_SRPIO0_0_Pos = 0x0
	// Bit mask of SRPIO0_0 field.
	SYSCON_STARTSRP0_SRPIO0_0_Msk = 0x1
	// Bit SRPIO0_0.
	SYSCON_STARTSRP0_SRPIO0_0 = 0x1
	// No start signal received
	SYSCON_STARTSRP0_SRPIO0_0_NO_START_SIGNAL_RECE = 0x0
	// Start signal pending
	SYSCON_STARTSRP0_SRPIO0_0_START_SIGNAL_PENDING = 0x1
	// Position of RESERVED field.
	SYSCON_STARTSRP0_RESERVED_Pos = 0x1
	// Bit mask of RESERVED field.
	SYSCON_STARTSRP0_RESERVED_Msk = 0xfe
	// Position of SRPIO0_8 field.
	SYSCON_STARTSRP0_SRPIO0_8_Pos = 0x8
	// Bit mask of SRPIO0_8 field.
	SYSCON_STARTSRP0_SRPIO0_8_Msk = 0x100
	// Bit SRPIO0_8.
	SYSCON_STARTSRP0_SRPIO0_8 = 0x100
	// No start signal received
	SYSCON_STARTSRP0_SRPIO0_8_NO_START_SIGNAL_RECE = 0x0
	// Start signal pending
	SYSCON_STARTSRP0_SRPIO0_8_START_SIGNAL_PENDING = 0x1
	// Position of SRPIO0_9 field.
	SYSCON_STARTSRP0_SRPIO0_9_Pos = 0x9
	// Bit mask of SRPIO0_9 field.
	SYSCON_STARTSRP0_SRPIO0_9_Msk = 0x200
	// Bit SRPIO0_9.
	SYSCON_STARTSRP0_SRPIO0_9 = 0x200
	// No start signal received
	SYSCON_STARTSRP0_SRPIO0_9_NO_START_SIGNAL_RECE = 0x0
	// Start signal pending
	SYSCON_STARTSRP0_SRPIO0_9_START_SIGNAL_PENDING = 0x1
	// Position of SRPIO0_10 field.
	SYSCON_STARTSRP0_SRPIO0_10_Pos = 0xa
	// Bit mask of SRPIO0_10 field.
	SYSCON_STARTSRP0_SRPIO0_10_Msk = 0x400
	// Bit SRPIO0_10.
	SYSCON_STARTSRP0_SRPIO0_10 = 0x400
	// No start signal received
	SYSCON_STARTSRP0_SRPIO0_10_NO_START_SIGNAL_RECE = 0x0
	// Start signal pending
	SYSCON_STARTSRP0_SRPIO0_10_START_SIGNAL_PENDING = 0x1
	// Position of SRPIO0_11 field.
	SYSCON_STARTSRP0_SRPIO0_11_Pos = 0xb
	// Bit mask of SRPIO0_11 field.
	SYSCON_STARTSRP0_SRPIO0_11_Msk = 0x800
	// Bit SRPIO0_11.
	SYSCON_STARTSRP0_SRPIO0_11 = 0x800
	// No start signal received
	SYSCON_STARTSRP0_SRPIO0_11_NO_START_SIGNAL_RECE = 0x0
	// Start signal pending
	SYSCON_STARTSRP0_SRPIO0_11_START_SIGNAL_PENDING = 0x1
	// Position of SRPIO1_0 field.
	SYSCON_STARTSRP0_SRPIO1_0_Pos = 0xc
	// Bit mask of SRPIO1_0 field.
	SYSCON_STARTSRP0_SRPIO1_0_Msk = 0x1000
	// Bit SRPIO1_0.
	SYSCON_STARTSRP0_SRPIO1_0 = 0x1000
	// No start signal received
	SYSCON_STARTSRP0_SRPIO1_0_NO_START_SIGNAL_RECE = 0x0
	// Start signal pending
	SYSCON_STARTSRP0_SRPIO1_0_START_SIGNAL_PENDING = 0x1
	// Position of RESERVED field.
	SYSCON_STARTSRP0_RESERVED_Pos = 0xd
	// Bit mask of RESERVED field.
	SYSCON_STARTSRP0_RESERVED_Msk = 0xffffe000

	// PDSLEEPCFG: Power-down states in Deep-sleep mode
	// Position of RESERVED field.
	SYSCON_PDSLEEPCFG_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	SYSCON_PDSLEEPCFG_RESERVED_Msk = 0x7
	// Position of BOD_PD field.
	SYSCON_PDSLEEPCFG_BOD_PD_Pos = 0x3
	// Bit mask of BOD_PD field.
	SYSCON_PDSLEEPCFG_BOD_PD_Msk = 0x8
	// Bit BOD_PD.
	SYSCON_PDSLEEPCFG_BOD_PD = 0x8
	// Powered
	SYSCON_PDSLEEPCFG_BOD_PD_POWERED = 0x0
	// Powered down
	SYSCON_PDSLEEPCFG_BOD_PD_POWERED_DOWN = 0x1
	// Position of RESERVED field.
	SYSCON_PDSLEEPCFG_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	SYSCON_PDSLEEPCFG_RESERVED_Msk = 0x30
	// Position of WDTOSC_PD field.
	SYSCON_PDSLEEPCFG_WDTOSC_PD_Pos = 0x6
	// Bit mask of WDTOSC_PD field.
	SYSCON_PDSLEEPCFG_WDTOSC_PD_Msk = 0x40
	// Bit WDTOSC_PD.
	SYSCON_PDSLEEPCFG_WDTOSC_PD = 0x40
	// Powered
	SYSCON_PDSLEEPCFG_WDTOSC_PD_POWERED = 0x0
	// Powered down
	SYSCON_PDSLEEPCFG_WDTOSC_PD_POWERED_DOWN = 0x1
	// Position of RESERVED field.
	SYSCON_PDSLEEPCFG_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	SYSCON_PDSLEEPCFG_RESERVED_Msk = 0x80
	// Bit RESERVED.
	SYSCON_PDSLEEPCFG_RESERVED = 0x80
	// Position of RESERVED field.
	SYSCON_PDSLEEPCFG_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	SYSCON_PDSLEEPCFG_RESERVED_Msk = 0x700
	// Position of RESERVED field.
	SYSCON_PDSLEEPCFG_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	SYSCON_PDSLEEPCFG_RESERVED_Msk = 0x1800
	// Position of RESERVED field.
	SYSCON_PDSLEEPCFG_RESERVED_Pos = 0xd
	// Bit mask of RESERVED field.
	SYSCON_PDSLEEPCFG_RESERVED_Msk = 0xffffe000

	// PDAWAKECFG: Power-down states after wake-up from Deep-sleep mode
	// Position of IRCOUT_PD field.
	SYSCON_PDAWAKECFG_IRCOUT_PD_Pos = 0x0
	// Bit mask of IRCOUT_PD field.
	SYSCON_PDAWAKECFG_IRCOUT_PD_Msk = 0x1
	// Bit IRCOUT_PD.
	SYSCON_PDAWAKECFG_IRCOUT_PD = 0x1
	// Powered
	SYSCON_PDAWAKECFG_IRCOUT_PD_POWERED = 0x0
	// Powered down
	SYSCON_PDAWAKECFG_IRCOUT_PD_POWERED_DOWN = 0x1
	// Position of IRC_PD field.
	SYSCON_PDAWAKECFG_IRC_PD_Pos = 0x1
	// Bit mask of IRC_PD field.
	SYSCON_PDAWAKECFG_IRC_PD_Msk = 0x2
	// Bit IRC_PD.
	SYSCON_PDAWAKECFG_IRC_PD = 0x2
	// Powered
	SYSCON_PDAWAKECFG_IRC_PD_POWERED = 0x0
	// Powered down
	SYSCON_PDAWAKECFG_IRC_PD_POWERED_DOWN = 0x1
	// Position of FLASH_PD field.
	SYSCON_PDAWAKECFG_FLASH_PD_Pos = 0x2
	// Bit mask of FLASH_PD field.
	SYSCON_PDAWAKECFG_FLASH_PD_Msk = 0x4
	// Bit FLASH_PD.
	SYSCON_PDAWAKECFG_FLASH_PD = 0x4
	// Powered
	SYSCON_PDAWAKECFG_FLASH_PD_POWERED = 0x0
	// Powered down
	SYSCON_PDAWAKECFG_FLASH_PD_POWERED_DOWN = 0x1
	// Position of BOD_PD field.
	SYSCON_PDAWAKECFG_BOD_PD_Pos = 0x3
	// Bit mask of BOD_PD field.
	SYSCON_PDAWAKECFG_BOD_PD_Msk = 0x8
	// Bit BOD_PD.
	SYSCON_PDAWAKECFG_BOD_PD = 0x8
	// Powered
	SYSCON_PDAWAKECFG_BOD_PD_POWERED = 0x0
	// Powered down
	SYSCON_PDAWAKECFG_BOD_PD_POWERED_DOWN = 0x1
	// Position of ADC_PD field.
	SYSCON_PDAWAKECFG_ADC_PD_Pos = 0x4
	// Bit mask of ADC_PD field.
	SYSCON_PDAWAKECFG_ADC_PD_Msk = 0x10
	// Bit ADC_PD.
	SYSCON_PDAWAKECFG_ADC_PD = 0x10
	// Powered
	SYSCON_PDAWAKECFG_ADC_PD_POWERED = 0x0
	// Powered down
	SYSCON_PDAWAKECFG_ADC_PD_POWERED_DOWN = 0x1
	// Position of SYSOSC_PD field.
	SYSCON_PDAWAKECFG_SYSOSC_PD_Pos = 0x5
	// Bit mask of SYSOSC_PD field.
	SYSCON_PDAWAKECFG_SYSOSC_PD_Msk = 0x20
	// Bit SYSOSC_PD.
	SYSCON_PDAWAKECFG_SYSOSC_PD = 0x20
	// Powered
	SYSCON_PDAWAKECFG_SYSOSC_PD_POWERED = 0x0
	// Powered down
	SYSCON_PDAWAKECFG_SYSOSC_PD_POWERED_DOWN = 0x1
	// Position of WDTOSC_PD field.
	SYSCON_PDAWAKECFG_WDTOSC_PD_Pos = 0x6
	// Bit mask of WDTOSC_PD field.
	SYSCON_PDAWAKECFG_WDTOSC_PD_Msk = 0x40
	// Bit WDTOSC_PD.
	SYSCON_PDAWAKECFG_WDTOSC_PD = 0x40
	// Powered
	SYSCON_PDAWAKECFG_WDTOSC_PD_POWERED = 0x0
	// Powered down
	SYSCON_PDAWAKECFG_WDTOSC_PD_POWERED_DOWN = 0x1
	// Position of SYSPLL_PD field.
	SYSCON_PDAWAKECFG_SYSPLL_PD_Pos = 0x7
	// Bit mask of SYSPLL_PD field.
	SYSCON_PDAWAKECFG_SYSPLL_PD_Msk = 0x80
	// Bit SYSPLL_PD.
	SYSCON_PDAWAKECFG_SYSPLL_PD = 0x80
	// Powered
	SYSCON_PDAWAKECFG_SYSPLL_PD_POWERED = 0x0
	// Powered down
	SYSCON_PDAWAKECFG_SYSPLL_PD_POWERED_DOWN = 0x1
	// Position of RESERVED field.
	SYSCON_PDAWAKECFG_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	SYSCON_PDAWAKECFG_RESERVED_Msk = 0x100
	// Bit RESERVED.
	SYSCON_PDAWAKECFG_RESERVED = 0x100
	// Position of RESERVED field.
	SYSCON_PDAWAKECFG_RESERVED_Pos = 0x9
	// Bit mask of RESERVED field.
	SYSCON_PDAWAKECFG_RESERVED_Msk = 0x200
	// Bit RESERVED.
	SYSCON_PDAWAKECFG_RESERVED = 0x200
	// Position of RESERVED field.
	SYSCON_PDAWAKECFG_RESERVED_Pos = 0xa
	// Bit mask of RESERVED field.
	SYSCON_PDAWAKECFG_RESERVED_Msk = 0x400
	// Bit RESERVED.
	SYSCON_PDAWAKECFG_RESERVED = 0x400
	// Position of RESERVED field.
	SYSCON_PDAWAKECFG_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	SYSCON_PDAWAKECFG_RESERVED_Msk = 0x800
	// Bit RESERVED.
	SYSCON_PDAWAKECFG_RESERVED = 0x800
	// Position of RESERVED field.
	SYSCON_PDAWAKECFG_RESERVED_Pos = 0xc
	// Bit mask of RESERVED field.
	SYSCON_PDAWAKECFG_RESERVED_Msk = 0x1000
	// Bit RESERVED.
	SYSCON_PDAWAKECFG_RESERVED = 0x1000
	// Position of RESERVED field.
	SYSCON_PDAWAKECFG_RESERVED_Pos = 0xd
	// Bit mask of RESERVED field.
	SYSCON_PDAWAKECFG_RESERVED_Msk = 0xe000
	// Position of RESERVED field.
	SYSCON_PDAWAKECFG_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	SYSCON_PDAWAKECFG_RESERVED_Msk = 0xffff0000

	// PDRUNCFG: Power-down configuration register
	// Position of IRCOUT_PD field.
	SYSCON_PDRUNCFG_IRCOUT_PD_Pos = 0x0
	// Bit mask of IRCOUT_PD field.
	SYSCON_PDRUNCFG_IRCOUT_PD_Msk = 0x1
	// Bit IRCOUT_PD.
	SYSCON_PDRUNCFG_IRCOUT_PD = 0x1
	// Powered
	SYSCON_PDRUNCFG_IRCOUT_PD_POWERED = 0x0
	// Powered down
	SYSCON_PDRUNCFG_IRCOUT_PD_POWERED_DOWN = 0x1
	// Position of IRC_PD field.
	SYSCON_PDRUNCFG_IRC_PD_Pos = 0x1
	// Bit mask of IRC_PD field.
	SYSCON_PDRUNCFG_IRC_PD_Msk = 0x2
	// Bit IRC_PD.
	SYSCON_PDRUNCFG_IRC_PD = 0x2
	// Powered
	SYSCON_PDRUNCFG_IRC_PD_POWERED = 0x0
	// Powered down
	SYSCON_PDRUNCFG_IRC_PD_POWERED_DOWN = 0x1
	// Position of FLASH_PD field.
	SYSCON_PDRUNCFG_FLASH_PD_Pos = 0x2
	// Bit mask of FLASH_PD field.
	SYSCON_PDRUNCFG_FLASH_PD_Msk = 0x4
	// Bit FLASH_PD.
	SYSCON_PDRUNCFG_FLASH_PD = 0x4
	// Powered
	SYSCON_PDRUNCFG_FLASH_PD_POWERED = 0x0
	// Powered down
	SYSCON_PDRUNCFG_FLASH_PD_POWERED_DOWN = 0x1
	// Position of BOD_PD field.
	SYSCON_PDRUNCFG_BOD_PD_Pos = 0x3
	// Bit mask of BOD_PD field.
	SYSCON_PDRUNCFG_BOD_PD_Msk = 0x8
	// Bit BOD_PD.
	SYSCON_PDRUNCFG_BOD_PD = 0x8
	// Powered
	SYSCON_PDRUNCFG_BOD_PD_POWERED = 0x0
	// Powered down
	SYSCON_PDRUNCFG_BOD_PD_POWERED_DOWN = 0x1
	// Position of ADC_PD field.
	SYSCON_PDRUNCFG_ADC_PD_Pos = 0x4
	// Bit mask of ADC_PD field.
	SYSCON_PDRUNCFG_ADC_PD_Msk = 0x10
	// Bit ADC_PD.
	SYSCON_PDRUNCFG_ADC_PD = 0x10
	// Powered
	SYSCON_PDRUNCFG_ADC_PD_POWERED = 0x0
	// Powered down
	SYSCON_PDRUNCFG_ADC_PD_POWERED_DOWN = 0x1
	// Position of SYSOSC_PD field.
	SYSCON_PDRUNCFG_SYSOSC_PD_Pos = 0x5
	// Bit mask of SYSOSC_PD field.
	SYSCON_PDRUNCFG_SYSOSC_PD_Msk = 0x20
	// Bit SYSOSC_PD.
	SYSCON_PDRUNCFG_SYSOSC_PD = 0x20
	// Powered
	SYSCON_PDRUNCFG_SYSOSC_PD_POWERED = 0x0
	// Powered down
	SYSCON_PDRUNCFG_SYSOSC_PD_POWERED_DOWN = 0x1
	// Position of WDTOSC_PD field.
	SYSCON_PDRUNCFG_WDTOSC_PD_Pos = 0x6
	// Bit mask of WDTOSC_PD field.
	SYSCON_PDRUNCFG_WDTOSC_PD_Msk = 0x40
	// Bit WDTOSC_PD.
	SYSCON_PDRUNCFG_WDTOSC_PD = 0x40
	// Powered
	SYSCON_PDRUNCFG_WDTOSC_PD_POWERED = 0x0
	// Powered down
	SYSCON_PDRUNCFG_WDTOSC_PD_POWERED_DOWN = 0x1
	// Position of SYSPLL_PD field.
	SYSCON_PDRUNCFG_SYSPLL_PD_Pos = 0x7
	// Bit mask of SYSPLL_PD field.
	SYSCON_PDRUNCFG_SYSPLL_PD_Msk = 0x80
	// Bit SYSPLL_PD.
	SYSCON_PDRUNCFG_SYSPLL_PD = 0x80
	// Powered
	SYSCON_PDRUNCFG_SYSPLL_PD_POWERED = 0x0
	// Powered down
	SYSCON_PDRUNCFG_SYSPLL_PD_POWERED_DOWN = 0x1
	// Position of RESERVED field.
	SYSCON_PDRUNCFG_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	SYSCON_PDRUNCFG_RESERVED_Msk = 0x100
	// Bit RESERVED.
	SYSCON_PDRUNCFG_RESERVED = 0x100
	// Position of RESERVED field.
	SYSCON_PDRUNCFG_RESERVED_Pos = 0x9
	// Bit mask of RESERVED field.
	SYSCON_PDRUNCFG_RESERVED_Msk = 0x200
	// Bit RESERVED.
	SYSCON_PDRUNCFG_RESERVED = 0x200
	// Position of RESERVED field.
	SYSCON_PDRUNCFG_RESERVED_Pos = 0xa
	// Bit mask of RESERVED field.
	SYSCON_PDRUNCFG_RESERVED_Msk = 0x400
	// Bit RESERVED.
	SYSCON_PDRUNCFG_RESERVED = 0x400
	// Position of RESERVED field.
	SYSCON_PDRUNCFG_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	SYSCON_PDRUNCFG_RESERVED_Msk = 0x800
	// Bit RESERVED.
	SYSCON_PDRUNCFG_RESERVED = 0x800
	// Position of RESERVED field.
	SYSCON_PDRUNCFG_RESERVED_Pos = 0xc
	// Bit mask of RESERVED field.
	SYSCON_PDRUNCFG_RESERVED_Msk = 0x1000
	// Bit RESERVED.
	SYSCON_PDRUNCFG_RESERVED = 0x1000
	// Position of RESERVED field.
	SYSCON_PDRUNCFG_RESERVED_Pos = 0xd
	// Bit mask of RESERVED field.
	SYSCON_PDRUNCFG_RESERVED_Msk = 0xe000
	// Position of RESERVED field.
	SYSCON_PDRUNCFG_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	SYSCON_PDRUNCFG_RESERVED_Msk = 0xffff0000

	// DEVICE_ID: Device ID
	// Position of DEVICEID field.
	SYSCON_DEVICE_ID_DEVICEID_Pos = 0x0
	// Bit mask of DEVICEID field.
	SYSCON_DEVICE_ID_DEVICEID_Msk = 0xffffffff
)

// Bitfields for GPIO0: General Purpose I/O (GPIO)
const (
	// DATA: Port n data address masking register locations for pins PIOn_0 to PIOn_11 (see Section 9.4.1).
	// Position of DATA0 field.
	GPIO_DATA_DATA0_Pos = 0x0
	// Bit mask of DATA0 field.
	GPIO_DATA_DATA0_Msk = 0x1
	// Bit DATA0.
	GPIO_DATA_DATA0 = 0x1
	// Position of DATA1 field.
	GPIO_DATA_DATA1_Pos = 0x1
	// Bit mask of DATA1 field.
	GPIO_DATA_DATA1_Msk = 0x2
	// Bit DATA1.
	GPIO_DATA_DATA1 = 0x2
	// Position of DATA2 field.
	GPIO_DATA_DATA2_Pos = 0x2
	// Bit mask of DATA2 field.
	GPIO_DATA_DATA2_Msk = 0x4
	// Bit DATA2.
	GPIO_DATA_DATA2 = 0x4
	// Position of DATA3 field.
	GPIO_DATA_DATA3_Pos = 0x3
	// Bit mask of DATA3 field.
	GPIO_DATA_DATA3_Msk = 0x8
	// Bit DATA3.
	GPIO_DATA_DATA3 = 0x8
	// Position of DATA4 field.
	GPIO_DATA_DATA4_Pos = 0x4
	// Bit mask of DATA4 field.
	GPIO_DATA_DATA4_Msk = 0x10
	// Bit DATA4.
	GPIO_DATA_DATA4 = 0x10
	// Position of DATA5 field.
	GPIO_DATA_DATA5_Pos = 0x5
	// Bit mask of DATA5 field.
	GPIO_DATA_DATA5_Msk = 0x20
	// Bit DATA5.
	GPIO_DATA_DATA5 = 0x20
	// Position of DATA6 field.
	GPIO_DATA_DATA6_Pos = 0x6
	// Bit mask of DATA6 field.
	GPIO_DATA_DATA6_Msk = 0x40
	// Bit DATA6.
	GPIO_DATA_DATA6 = 0x40
	// Position of DATA7 field.
	GPIO_DATA_DATA7_Pos = 0x7
	// Bit mask of DATA7 field.
	GPIO_DATA_DATA7_Msk = 0x80
	// Bit DATA7.
	GPIO_DATA_DATA7 = 0x80
	// Position of DATA8 field.
	GPIO_DATA_DATA8_Pos = 0x8
	// Bit mask of DATA8 field.
	GPIO_DATA_DATA8_Msk = 0x100
	// Bit DATA8.
	GPIO_DATA_DATA8 = 0x100
	// Position of DATA9 field.
	GPIO_DATA_DATA9_Pos = 0x9
	// Bit mask of DATA9 field.
	GPIO_DATA_DATA9_Msk = 0x200
	// Bit DATA9.
	GPIO_DATA_DATA9 = 0x200
	// Position of DATA10 field.
	GPIO_DATA_DATA10_Pos = 0xa
	// Bit mask of DATA10 field.
	GPIO_DATA_DATA10_Msk = 0x400
	// Bit DATA10.
	GPIO_DATA_DATA10 = 0x400
	// Position of DATA11 field.
	GPIO_DATA_DATA11_Pos = 0xb
	// Bit mask of DATA11 field.
	GPIO_DATA_DATA11_Msk = 0x800
	// Bit DATA11.
	GPIO_DATA_DATA11 = 0x800
	// Position of RESERVED field.
	GPIO_DATA_RESERVED_Pos = 0xc
	// Bit mask of RESERVED field.
	GPIO_DATA_RESERVED_Msk = 0xfffff000

	// DIR: Data direction register for port n
	// Position of IO0 field.
	GPIO_DIR_IO0_Pos = 0x0
	// Bit mask of IO0 field.
	GPIO_DIR_IO0_Msk = 0x1
	// Bit IO0.
	GPIO_DIR_IO0 = 0x1
	// Position of IO1 field.
	GPIO_DIR_IO1_Pos = 0x1
	// Bit mask of IO1 field.
	GPIO_DIR_IO1_Msk = 0x2
	// Bit IO1.
	GPIO_DIR_IO1 = 0x2
	// Position of IO2 field.
	GPIO_DIR_IO2_Pos = 0x2
	// Bit mask of IO2 field.
	GPIO_DIR_IO2_Msk = 0x4
	// Bit IO2.
	GPIO_DIR_IO2 = 0x4
	// Position of IO3 field.
	GPIO_DIR_IO3_Pos = 0x3
	// Bit mask of IO3 field.
	GPIO_DIR_IO3_Msk = 0x8
	// Bit IO3.
	GPIO_DIR_IO3 = 0x8
	// Position of IO4 field.
	GPIO_DIR_IO4_Pos = 0x4
	// Bit mask of IO4 field.
	GPIO_DIR_IO4_Msk = 0x10
	// Bit IO4.
	GPIO_DIR_IO4 = 0x10
	// Position of IO5 field.
	GPIO_DIR_IO5_Pos = 0x5
	// Bit mask of IO5 field.
	GPIO_DIR_IO5_Msk = 0x20
	// Bit IO5.
	GPIO_DIR_IO5 = 0x20
	// Position of IO6 field.
	GPIO_DIR_IO6_Pos = 0x6
	// Bit mask of IO6 field.
	GPIO_DIR_IO6_Msk = 0x40
	// Bit IO6.
	GPIO_DIR_IO6 = 0x40
	// Position of IO7 field.
	GPIO_DIR_IO7_Pos = 0x7
	// Bit mask of IO7 field.
	GPIO_DIR_IO7_Msk = 0x80
	// Bit IO7.
	GPIO_DIR_IO7 = 0x80
	// Position of IO8 field.
	GPIO_DIR_IO8_Pos = 0x8
	// Bit mask of IO8 field.
	GPIO_DIR_IO8_Msk = 0x100
	// Bit IO8.
	GPIO_DIR_IO8 = 0x100
	// Position of IO9 field.
	GPIO_DIR_IO9_Pos = 0x9
	// Bit mask of IO9 field.
	GPIO_DIR_IO9_Msk = 0x200
	// Bit IO9.
	GPIO_DIR_IO9 = 0x200
	// Position of IO10 field.
	GPIO_DIR_IO10_Pos = 0xa
	// Bit mask of IO10 field.
	GPIO_DIR_IO10_Msk = 0x400
	// Bit IO10.
	GPIO_DIR_IO10 = 0x400
	// Position of IO11 field.
	GPIO_DIR_IO11_Pos = 0xb
	// Bit mask of IO11 field.
	GPIO_DIR_IO11_Msk = 0x800
	// Bit IO11.
	GPIO_DIR_IO11 = 0x800
	// Position of RESERVED field.
	GPIO_DIR_RESERVED_Pos = 0xc
	// Bit mask of RESERVED field.
	GPIO_DIR_RESERVED_Msk = 0xfffff000

	// IS: Interrupt sense register for port n
	// Position of ISENSE0 field.
	GPIO_IS_ISENSE0_Pos = 0x0
	// Bit mask of ISENSE0 field.
	GPIO_IS_ISENSE0_Msk = 0x1
	// Bit ISENSE0.
	GPIO_IS_ISENSE0 = 0x1
	// Position of ISENSE1 field.
	GPIO_IS_ISENSE1_Pos = 0x1
	// Bit mask of ISENSE1 field.
	GPIO_IS_ISENSE1_Msk = 0x2
	// Bit ISENSE1.
	GPIO_IS_ISENSE1 = 0x2
	// Position of ISENSE2 field.
	GPIO_IS_ISENSE2_Pos = 0x2
	// Bit mask of ISENSE2 field.
	GPIO_IS_ISENSE2_Msk = 0x4
	// Bit ISENSE2.
	GPIO_IS_ISENSE2 = 0x4
	// Position of ISENSE3 field.
	GPIO_IS_ISENSE3_Pos = 0x3
	// Bit mask of ISENSE3 field.
	GPIO_IS_ISENSE3_Msk = 0x8
	// Bit ISENSE3.
	GPIO_IS_ISENSE3 = 0x8
	// Position of ISENSE4 field.
	GPIO_IS_ISENSE4_Pos = 0x4
	// Bit mask of ISENSE4 field.
	GPIO_IS_ISENSE4_Msk = 0x10
	// Bit ISENSE4.
	GPIO_IS_ISENSE4 = 0x10
	// Position of ISENSE5 field.
	GPIO_IS_ISENSE5_Pos = 0x5
	// Bit mask of ISENSE5 field.
	GPIO_IS_ISENSE5_Msk = 0x20
	// Bit ISENSE5.
	GPIO_IS_ISENSE5 = 0x20
	// Position of ISENSE6 field.
	GPIO_IS_ISENSE6_Pos = 0x6
	// Bit mask of ISENSE6 field.
	GPIO_IS_ISENSE6_Msk = 0x40
	// Bit ISENSE6.
	GPIO_IS_ISENSE6 = 0x40
	// Position of ISENSE7 field.
	GPIO_IS_ISENSE7_Pos = 0x7
	// Bit mask of ISENSE7 field.
	GPIO_IS_ISENSE7_Msk = 0x80
	// Bit ISENSE7.
	GPIO_IS_ISENSE7 = 0x80
	// Position of ISENSE8 field.
	GPIO_IS_ISENSE8_Pos = 0x8
	// Bit mask of ISENSE8 field.
	GPIO_IS_ISENSE8_Msk = 0x100
	// Bit ISENSE8.
	GPIO_IS_ISENSE8 = 0x100
	// Position of ISENSE9 field.
	GPIO_IS_ISENSE9_Pos = 0x9
	// Bit mask of ISENSE9 field.
	GPIO_IS_ISENSE9_Msk = 0x200
	// Bit ISENSE9.
	GPIO_IS_ISENSE9 = 0x200
	// Position of ISENSE10 field.
	GPIO_IS_ISENSE10_Pos = 0xa
	// Bit mask of ISENSE10 field.
	GPIO_IS_ISENSE10_Msk = 0x400
	// Bit ISENSE10.
	GPIO_IS_ISENSE10 = 0x400
	// Position of ISENSE11 field.
	GPIO_IS_ISENSE11_Pos = 0xb
	// Bit mask of ISENSE11 field.
	GPIO_IS_ISENSE11_Msk = 0x800
	// Bit ISENSE11.
	GPIO_IS_ISENSE11 = 0x800
	// Position of RESERVED field.
	GPIO_IS_RESERVED_Pos = 0xc
	// Bit mask of RESERVED field.
	GPIO_IS_RESERVED_Msk = 0xfffff000

	// IBE: Interrupt both edges register for port n
	// Position of IBE0 field.
	GPIO_IBE_IBE0_Pos = 0x0
	// Bit mask of IBE0 field.
	GPIO_IBE_IBE0_Msk = 0x1
	// Bit IBE0.
	GPIO_IBE_IBE0 = 0x1
	// Position of IBE1 field.
	GPIO_IBE_IBE1_Pos = 0x1
	// Bit mask of IBE1 field.
	GPIO_IBE_IBE1_Msk = 0x2
	// Bit IBE1.
	GPIO_IBE_IBE1 = 0x2
	// Position of IBE2 field.
	GPIO_IBE_IBE2_Pos = 0x2
	// Bit mask of IBE2 field.
	GPIO_IBE_IBE2_Msk = 0x4
	// Bit IBE2.
	GPIO_IBE_IBE2 = 0x4
	// Position of IBE3 field.
	GPIO_IBE_IBE3_Pos = 0x3
	// Bit mask of IBE3 field.
	GPIO_IBE_IBE3_Msk = 0x8
	// Bit IBE3.
	GPIO_IBE_IBE3 = 0x8
	// Position of IBE4 field.
	GPIO_IBE_IBE4_Pos = 0x4
	// Bit mask of IBE4 field.
	GPIO_IBE_IBE4_Msk = 0x10
	// Bit IBE4.
	GPIO_IBE_IBE4 = 0x10
	// Position of IBE5 field.
	GPIO_IBE_IBE5_Pos = 0x5
	// Bit mask of IBE5 field.
	GPIO_IBE_IBE5_Msk = 0x20
	// Bit IBE5.
	GPIO_IBE_IBE5 = 0x20
	// Position of IBE6 field.
	GPIO_IBE_IBE6_Pos = 0x6
	// Bit mask of IBE6 field.
	GPIO_IBE_IBE6_Msk = 0x40
	// Bit IBE6.
	GPIO_IBE_IBE6 = 0x40
	// Position of IBE7 field.
	GPIO_IBE_IBE7_Pos = 0x7
	// Bit mask of IBE7 field.
	GPIO_IBE_IBE7_Msk = 0x80
	// Bit IBE7.
	GPIO_IBE_IBE7 = 0x80
	// Position of IBE8 field.
	GPIO_IBE_IBE8_Pos = 0x8
	// Bit mask of IBE8 field.
	GPIO_IBE_IBE8_Msk = 0x100
	// Bit IBE8.
	GPIO_IBE_IBE8 = 0x100
	// Position of IBE9 field.
	GPIO_IBE_IBE9_Pos = 0x9
	// Bit mask of IBE9 field.
	GPIO_IBE_IBE9_Msk = 0x200
	// Bit IBE9.
	GPIO_IBE_IBE9 = 0x200
	// Position of IBE10 field.
	GPIO_IBE_IBE10_Pos = 0xa
	// Bit mask of IBE10 field.
	GPIO_IBE_IBE10_Msk = 0x400
	// Bit IBE10.
	GPIO_IBE_IBE10 = 0x400
	// Position of IBE11 field.
	GPIO_IBE_IBE11_Pos = 0xb
	// Bit mask of IBE11 field.
	GPIO_IBE_IBE11_Msk = 0x800
	// Bit IBE11.
	GPIO_IBE_IBE11 = 0x800
	// Position of RESERVED field.
	GPIO_IBE_RESERVED_Pos = 0xc
	// Bit mask of RESERVED field.
	GPIO_IBE_RESERVED_Msk = 0xfffff000

	// IEV: Interrupt event register for port n
	// Position of IEV0 field.
	GPIO_IEV_IEV0_Pos = 0x0
	// Bit mask of IEV0 field.
	GPIO_IEV_IEV0_Msk = 0x1
	// Bit IEV0.
	GPIO_IEV_IEV0 = 0x1
	// Position of IEV1 field.
	GPIO_IEV_IEV1_Pos = 0x1
	// Bit mask of IEV1 field.
	GPIO_IEV_IEV1_Msk = 0x2
	// Bit IEV1.
	GPIO_IEV_IEV1 = 0x2
	// Position of IEV2 field.
	GPIO_IEV_IEV2_Pos = 0x2
	// Bit mask of IEV2 field.
	GPIO_IEV_IEV2_Msk = 0x4
	// Bit IEV2.
	GPIO_IEV_IEV2 = 0x4
	// Position of IEV3 field.
	GPIO_IEV_IEV3_Pos = 0x3
	// Bit mask of IEV3 field.
	GPIO_IEV_IEV3_Msk = 0x8
	// Bit IEV3.
	GPIO_IEV_IEV3 = 0x8
	// Position of IEV4 field.
	GPIO_IEV_IEV4_Pos = 0x4
	// Bit mask of IEV4 field.
	GPIO_IEV_IEV4_Msk = 0x10
	// Bit IEV4.
	GPIO_IEV_IEV4 = 0x10
	// Position of IEV5 field.
	GPIO_IEV_IEV5_Pos = 0x5
	// Bit mask of IEV5 field.
	GPIO_IEV_IEV5_Msk = 0x20
	// Bit IEV5.
	GPIO_IEV_IEV5 = 0x20
	// Position of IEV6 field.
	GPIO_IEV_IEV6_Pos = 0x6
	// Bit mask of IEV6 field.
	GPIO_IEV_IEV6_Msk = 0x40
	// Bit IEV6.
	GPIO_IEV_IEV6 = 0x40
	// Position of IEV7 field.
	GPIO_IEV_IEV7_Pos = 0x7
	// Bit mask of IEV7 field.
	GPIO_IEV_IEV7_Msk = 0x80
	// Bit IEV7.
	GPIO_IEV_IEV7 = 0x80
	// Position of IEV8 field.
	GPIO_IEV_IEV8_Pos = 0x8
	// Bit mask of IEV8 field.
	GPIO_IEV_IEV8_Msk = 0x100
	// Bit IEV8.
	GPIO_IEV_IEV8 = 0x100
	// Position of IEV9 field.
	GPIO_IEV_IEV9_Pos = 0x9
	// Bit mask of IEV9 field.
	GPIO_IEV_IEV9_Msk = 0x200
	// Bit IEV9.
	GPIO_IEV_IEV9 = 0x200
	// Position of IEV10 field.
	GPIO_IEV_IEV10_Pos = 0xa
	// Bit mask of IEV10 field.
	GPIO_IEV_IEV10_Msk = 0x400
	// Bit IEV10.
	GPIO_IEV_IEV10 = 0x400
	// Position of IEV11 field.
	GPIO_IEV_IEV11_Pos = 0xb
	// Bit mask of IEV11 field.
	GPIO_IEV_IEV11_Msk = 0x800
	// Bit IEV11.
	GPIO_IEV_IEV11 = 0x800
	// Position of RESERVED field.
	GPIO_IEV_RESERVED_Pos = 0xc
	// Bit mask of RESERVED field.
	GPIO_IEV_RESERVED_Msk = 0xfffff000

	// IE: Interrupt mask register for port n
	// Position of MASK0 field.
	GPIO_IE_MASK0_Pos = 0x0
	// Bit mask of MASK0 field.
	GPIO_IE_MASK0_Msk = 0x1
	// Bit MASK0.
	GPIO_IE_MASK0 = 0x1
	// Position of MASK1 field.
	GPIO_IE_MASK1_Pos = 0x1
	// Bit mask of MASK1 field.
	GPIO_IE_MASK1_Msk = 0x2
	// Bit MASK1.
	GPIO_IE_MASK1 = 0x2
	// Position of MASK2 field.
	GPIO_IE_MASK2_Pos = 0x2
	// Bit mask of MASK2 field.
	GPIO_IE_MASK2_Msk = 0x4
	// Bit MASK2.
	GPIO_IE_MASK2 = 0x4
	// Position of MASK3 field.
	GPIO_IE_MASK3_Pos = 0x3
	// Bit mask of MASK3 field.
	GPIO_IE_MASK3_Msk = 0x8
	// Bit MASK3.
	GPIO_IE_MASK3 = 0x8
	// Position of MASK4 field.
	GPIO_IE_MASK4_Pos = 0x4
	// Bit mask of MASK4 field.
	GPIO_IE_MASK4_Msk = 0x10
	// Bit MASK4.
	GPIO_IE_MASK4 = 0x10
	// Position of MASK5 field.
	GPIO_IE_MASK5_Pos = 0x5
	// Bit mask of MASK5 field.
	GPIO_IE_MASK5_Msk = 0x20
	// Bit MASK5.
	GPIO_IE_MASK5 = 0x20
	// Position of MASK6 field.
	GPIO_IE_MASK6_Pos = 0x6
	// Bit mask of MASK6 field.
	GPIO_IE_MASK6_Msk = 0x40
	// Bit MASK6.
	GPIO_IE_MASK6 = 0x40
	// Position of MASK7 field.
	GPIO_IE_MASK7_Pos = 0x7
	// Bit mask of MASK7 field.
	GPIO_IE_MASK7_Msk = 0x80
	// Bit MASK7.
	GPIO_IE_MASK7 = 0x80
	// Position of MASK8 field.
	GPIO_IE_MASK8_Pos = 0x8
	// Bit mask of MASK8 field.
	GPIO_IE_MASK8_Msk = 0x100
	// Bit MASK8.
	GPIO_IE_MASK8 = 0x100
	// Position of MASK9 field.
	GPIO_IE_MASK9_Pos = 0x9
	// Bit mask of MASK9 field.
	GPIO_IE_MASK9_Msk = 0x200
	// Bit MASK9.
	GPIO_IE_MASK9 = 0x200
	// Position of MASK10 field.
	GPIO_IE_MASK10_Pos = 0xa
	// Bit mask of MASK10 field.
	GPIO_IE_MASK10_Msk = 0x400
	// Bit MASK10.
	GPIO_IE_MASK10 = 0x400
	// Position of MASK11 field.
	GPIO_IE_MASK11_Pos = 0xb
	// Bit mask of MASK11 field.
	GPIO_IE_MASK11_Msk = 0x800
	// Bit MASK11.
	GPIO_IE_MASK11 = 0x800
	// Position of RESERVED field.
	GPIO_IE_RESERVED_Pos = 0xc
	// Bit mask of RESERVED field.
	GPIO_IE_RESERVED_Msk = 0xfffff000

	// RIS: Raw interrupt status register for port n
	// Position of RAWST0 field.
	GPIO_RIS_RAWST0_Pos = 0x0
	// Bit mask of RAWST0 field.
	GPIO_RIS_RAWST0_Msk = 0x1
	// Bit RAWST0.
	GPIO_RIS_RAWST0 = 0x1
	// Position of RAWST1 field.
	GPIO_RIS_RAWST1_Pos = 0x1
	// Bit mask of RAWST1 field.
	GPIO_RIS_RAWST1_Msk = 0x2
	// Bit RAWST1.
	GPIO_RIS_RAWST1 = 0x2
	// Position of RAWST2 field.
	GPIO_RIS_RAWST2_Pos = 0x2
	// Bit mask of RAWST2 field.
	GPIO_RIS_RAWST2_Msk = 0x4
	// Bit RAWST2.
	GPIO_RIS_RAWST2 = 0x4
	// Position of RAWST3 field.
	GPIO_RIS_RAWST3_Pos = 0x3
	// Bit mask of RAWST3 field.
	GPIO_RIS_RAWST3_Msk = 0x8
	// Bit RAWST3.
	GPIO_RIS_RAWST3 = 0x8
	// Position of RAWST4 field.
	GPIO_RIS_RAWST4_Pos = 0x4
	// Bit mask of RAWST4 field.
	GPIO_RIS_RAWST4_Msk = 0x10
	// Bit RAWST4.
	GPIO_RIS_RAWST4 = 0x10
	// Position of RAWST5 field.
	GPIO_RIS_RAWST5_Pos = 0x5
	// Bit mask of RAWST5 field.
	GPIO_RIS_RAWST5_Msk = 0x20
	// Bit RAWST5.
	GPIO_RIS_RAWST5 = 0x20
	// Position of RAWST6 field.
	GPIO_RIS_RAWST6_Pos = 0x6
	// Bit mask of RAWST6 field.
	GPIO_RIS_RAWST6_Msk = 0x40
	// Bit RAWST6.
	GPIO_RIS_RAWST6 = 0x40
	// Position of RAWST7 field.
	GPIO_RIS_RAWST7_Pos = 0x7
	// Bit mask of RAWST7 field.
	GPIO_RIS_RAWST7_Msk = 0x80
	// Bit RAWST7.
	GPIO_RIS_RAWST7 = 0x80
	// Position of RAWST8 field.
	GPIO_RIS_RAWST8_Pos = 0x8
	// Bit mask of RAWST8 field.
	GPIO_RIS_RAWST8_Msk = 0x100
	// Bit RAWST8.
	GPIO_RIS_RAWST8 = 0x100
	// Position of RAWST9 field.
	GPIO_RIS_RAWST9_Pos = 0x9
	// Bit mask of RAWST9 field.
	GPIO_RIS_RAWST9_Msk = 0x200
	// Bit RAWST9.
	GPIO_RIS_RAWST9 = 0x200
	// Position of RAWST10 field.
	GPIO_RIS_RAWST10_Pos = 0xa
	// Bit mask of RAWST10 field.
	GPIO_RIS_RAWST10_Msk = 0x400
	// Bit RAWST10.
	GPIO_RIS_RAWST10 = 0x400
	// Position of RAWST11 field.
	GPIO_RIS_RAWST11_Pos = 0xb
	// Bit mask of RAWST11 field.
	GPIO_RIS_RAWST11_Msk = 0x800
	// Bit RAWST11.
	GPIO_RIS_RAWST11 = 0x800
	// Position of RESERVED field.
	GPIO_RIS_RESERVED_Pos = 0xc
	// Bit mask of RESERVED field.
	GPIO_RIS_RESERVED_Msk = 0xfffff000

	// MIS: Masked interrupt status register for port n
	// Position of MASK0 field.
	GPIO_MIS_MASK0_Pos = 0x0
	// Bit mask of MASK0 field.
	GPIO_MIS_MASK0_Msk = 0x1
	// Bit MASK0.
	GPIO_MIS_MASK0 = 0x1
	// Position of MASK1 field.
	GPIO_MIS_MASK1_Pos = 0x1
	// Bit mask of MASK1 field.
	GPIO_MIS_MASK1_Msk = 0x2
	// Bit MASK1.
	GPIO_MIS_MASK1 = 0x2
	// Position of MASK2 field.
	GPIO_MIS_MASK2_Pos = 0x2
	// Bit mask of MASK2 field.
	GPIO_MIS_MASK2_Msk = 0x4
	// Bit MASK2.
	GPIO_MIS_MASK2 = 0x4
	// Position of MASK3 field.
	GPIO_MIS_MASK3_Pos = 0x3
	// Bit mask of MASK3 field.
	GPIO_MIS_MASK3_Msk = 0x8
	// Bit MASK3.
	GPIO_MIS_MASK3 = 0x8
	// Position of MASK4 field.
	GPIO_MIS_MASK4_Pos = 0x4
	// Bit mask of MASK4 field.
	GPIO_MIS_MASK4_Msk = 0x10
	// Bit MASK4.
	GPIO_MIS_MASK4 = 0x10
	// Position of MASK5 field.
	GPIO_MIS_MASK5_Pos = 0x5
	// Bit mask of MASK5 field.
	GPIO_MIS_MASK5_Msk = 0x20
	// Bit MASK5.
	GPIO_MIS_MASK5 = 0x20
	// Position of MASK6 field.
	GPIO_MIS_MASK6_Pos = 0x6
	// Bit mask of MASK6 field.
	GPIO_MIS_MASK6_Msk = 0x40
	// Bit MASK6.
	GPIO_MIS_MASK6 = 0x40
	// Position of MASK7 field.
	GPIO_MIS_MASK7_Pos = 0x7
	// Bit mask of MASK7 field.
	GPIO_MIS_MASK7_Msk = 0x80
	// Bit MASK7.
	GPIO_MIS_MASK7 = 0x80
	// Position of MASK8 field.
	GPIO_MIS_MASK8_Pos = 0x8
	// Bit mask of MASK8 field.
	GPIO_MIS_MASK8_Msk = 0x100
	// Bit MASK8.
	GPIO_MIS_MASK8 = 0x100
	// Position of MASK9 field.
	GPIO_MIS_MASK9_Pos = 0x9
	// Bit mask of MASK9 field.
	GPIO_MIS_MASK9_Msk = 0x200
	// Bit MASK9.
	GPIO_MIS_MASK9 = 0x200
	// Position of MASK10 field.
	GPIO_MIS_MASK10_Pos = 0xa
	// Bit mask of MASK10 field.
	GPIO_MIS_MASK10_Msk = 0x400
	// Bit MASK10.
	GPIO_MIS_MASK10 = 0x400
	// Position of MASK11 field.
	GPIO_MIS_MASK11_Pos = 0xb
	// Bit mask of MASK11 field.
	GPIO_MIS_MASK11_Msk = 0x800
	// Bit MASK11.
	GPIO_MIS_MASK11 = 0x800
	// Position of RESERVED field.
	GPIO_MIS_RESERVED_Pos = 0xc
	// Bit mask of RESERVED field.
	GPIO_MIS_RESERVED_Msk = 0xfffff000

	// IC: Interrupt clear register for port n
	// Position of CLR0 field.
	GPIO_IC_CLR0_Pos = 0x0
	// Bit mask of CLR0 field.
	GPIO_IC_CLR0_Msk = 0x1
	// Bit CLR0.
	GPIO_IC_CLR0 = 0x1
	// Position of CLR1 field.
	GPIO_IC_CLR1_Pos = 0x1
	// Bit mask of CLR1 field.
	GPIO_IC_CLR1_Msk = 0x2
	// Bit CLR1.
	GPIO_IC_CLR1 = 0x2
	// Position of CLR2 field.
	GPIO_IC_CLR2_Pos = 0x2
	// Bit mask of CLR2 field.
	GPIO_IC_CLR2_Msk = 0x4
	// Bit CLR2.
	GPIO_IC_CLR2 = 0x4
	// Position of CLR3 field.
	GPIO_IC_CLR3_Pos = 0x3
	// Bit mask of CLR3 field.
	GPIO_IC_CLR3_Msk = 0x8
	// Bit CLR3.
	GPIO_IC_CLR3 = 0x8
	// Position of CLR4 field.
	GPIO_IC_CLR4_Pos = 0x4
	// Bit mask of CLR4 field.
	GPIO_IC_CLR4_Msk = 0x10
	// Bit CLR4.
	GPIO_IC_CLR4 = 0x10
	// Position of CLR5 field.
	GPIO_IC_CLR5_Pos = 0x5
	// Bit mask of CLR5 field.
	GPIO_IC_CLR5_Msk = 0x20
	// Bit CLR5.
	GPIO_IC_CLR5 = 0x20
	// Position of CLR6 field.
	GPIO_IC_CLR6_Pos = 0x6
	// Bit mask of CLR6 field.
	GPIO_IC_CLR6_Msk = 0x40
	// Bit CLR6.
	GPIO_IC_CLR6 = 0x40
	// Position of CLR7 field.
	GPIO_IC_CLR7_Pos = 0x7
	// Bit mask of CLR7 field.
	GPIO_IC_CLR7_Msk = 0x80
	// Bit CLR7.
	GPIO_IC_CLR7 = 0x80
	// Position of CLR8 field.
	GPIO_IC_CLR8_Pos = 0x8
	// Bit mask of CLR8 field.
	GPIO_IC_CLR8_Msk = 0x100
	// Bit CLR8.
	GPIO_IC_CLR8 = 0x100
	// Position of CLR9 field.
	GPIO_IC_CLR9_Pos = 0x9
	// Bit mask of CLR9 field.
	GPIO_IC_CLR9_Msk = 0x200
	// Bit CLR9.
	GPIO_IC_CLR9 = 0x200
	// Position of CLR10 field.
	GPIO_IC_CLR10_Pos = 0xa
	// Bit mask of CLR10 field.
	GPIO_IC_CLR10_Msk = 0x400
	// Bit CLR10.
	GPIO_IC_CLR10 = 0x400
	// Position of CLR11 field.
	GPIO_IC_CLR11_Pos = 0xb
	// Bit mask of CLR11 field.
	GPIO_IC_CLR11_Msk = 0x800
	// Bit CLR11.
	GPIO_IC_CLR11 = 0x800
	// Position of RESERVED field.
	GPIO_IC_RESERVED_Pos = 0xc
	// Bit mask of RESERVED field.
	GPIO_IC_RESERVED_Msk = 0xfffff000
)
