// Automatically generated file. DO NOT EDIT.
// Generated by gen-device-svd.go from MKW41Z4.svd, see https://github.com/posborne/cmsis-svd/tree/master/data/NXP

// +build nxp,mkw41z4

// MKW41Z4 NXP Microcontroller
//
//     Redistribution and use in source and binary forms, with or without modification,\nare permitted provided that the following conditions are met:
//     o Redistributions of source code must retain the above copyright notice, this list
//     of conditions and the following disclaimer.
//     o Redistributions in binary form must reproduce the above copyright notice, this
//     list of conditions and the following disclaimer in the documentation and/or
//     other materials provided with the distribution.
//     o Neither the name of the copyright holder nor the names of its
//     contributors may be used to endorse or promote products derived from this
//     software without specific prior written permission.
//     THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
//     ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//     WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
//     DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
//     ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
//     (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
//     LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
//     ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
//     (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
//     SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
package nxp

import (
	"runtime/interrupt"
	"runtime/volatile"
	"unsafe"
)

// Some information about this device.
const (
	DEVICE = "MKW41Z4"
)

// Interrupt numbers.
const (
	// Enhanced direct memory access controller
	IRQ_DMA0 = 0

	// Enhanced direct memory access controller
	IRQ_DMA1 = 1

	// Enhanced direct memory access controller
	IRQ_DMA2 = 2

	// Enhanced direct memory access controller
	IRQ_DMA3 = 3

	// Flash Memory Interface
	IRQ_FTFA = 5

	// DC to DC Converter // Power Management Controller
	IRQ_LVD_LVW_DCDC = 6

	// Low leakage wakeup unit
	IRQ_LLWU = 7

	// Inter-Integrated Circuit
	IRQ_I2C0 = 8

	// Inter-Integrated Circuit
	IRQ_I2C1 = 9

	// Serial Peripheral Interface
	IRQ_SPI0 = 10

	// Touch sense input
	IRQ_TSI0 = 11

	// Universal Asynchronous Receiver/Transmitter
	IRQ_LPUART0 = 12

	// TRNG0
	IRQ_TRNG0 = 13

	// Carrier Modulator Transmitter
	IRQ_CMT = 14

	// Analog-to-Digital Converter
	IRQ_ADC0 = 15

	// High-Speed Comparator (CMP), Voltage Reference (VREF) Digital-to-Analog Converter (DAC), and Analog Mux (ANMUX)
	IRQ_CMP0 = 16

	// Timer/PWM Module
	IRQ_TPM0 = 17

	// Timer/PWM Module
	IRQ_TPM1 = 18

	// Timer/PWM Module
	IRQ_TPM2 = 19

	// Secure Real Time Clock
	IRQ_RTC = 20

	// Secure Real Time Clock
	IRQ_RTC_Seconds = 21

	// Periodic Interrupt Timer
	IRQ_PIT = 22

	// LTC
	IRQ_LTC0 = 23

	// 12-Bit Digital-to-Analog Converter
	IRQ_DAC0 = 25

	// Multipurpose Clock Generator module
	IRQ_MCG = 27

	// Low Power Timer
	IRQ_LPTMR0 = 28

	// Serial Peripheral Interface
	IRQ_SPI1 = 29

	// Pin Control and Interrupts // General Purpose Input/Output
	IRQ_PORTA = 30

	// Pin Control and Interrupts // General Purpose Input/Output
	IRQ_PORTB_PORTC = 31

	// Highest interrupt number on this device.
	IRQ_max = 31
)

// Map interrupt numbers to function names.
// These aren't real calls, they're removed by the compiler.
var (
	_ = interrupt.Register(IRQ_DMA0, "DMA0_IRQHandler")
	_ = interrupt.Register(IRQ_DMA1, "DMA1_IRQHandler")
	_ = interrupt.Register(IRQ_DMA2, "DMA2_IRQHandler")
	_ = interrupt.Register(IRQ_DMA3, "DMA3_IRQHandler")
	_ = interrupt.Register(IRQ_FTFA, "FTFA_IRQHandler")
	_ = interrupt.Register(IRQ_LVD_LVW_DCDC, "LVD_LVW_DCDC_IRQHandler")
	_ = interrupt.Register(IRQ_LLWU, "LLWU_IRQHandler")
	_ = interrupt.Register(IRQ_I2C0, "I2C0_IRQHandler")
	_ = interrupt.Register(IRQ_I2C1, "I2C1_IRQHandler")
	_ = interrupt.Register(IRQ_SPI0, "SPI0_IRQHandler")
	_ = interrupt.Register(IRQ_TSI0, "TSI0_IRQHandler")
	_ = interrupt.Register(IRQ_LPUART0, "LPUART0_IRQHandler")
	_ = interrupt.Register(IRQ_TRNG0, "TRNG0_IRQHandler")
	_ = interrupt.Register(IRQ_CMT, "CMT_IRQHandler")
	_ = interrupt.Register(IRQ_ADC0, "ADC0_IRQHandler")
	_ = interrupt.Register(IRQ_CMP0, "CMP0_IRQHandler")
	_ = interrupt.Register(IRQ_TPM0, "TPM0_IRQHandler")
	_ = interrupt.Register(IRQ_TPM1, "TPM1_IRQHandler")
	_ = interrupt.Register(IRQ_TPM2, "TPM2_IRQHandler")
	_ = interrupt.Register(IRQ_RTC, "RTC_IRQHandler")
	_ = interrupt.Register(IRQ_RTC_Seconds, "RTC_Seconds_IRQHandler")
	_ = interrupt.Register(IRQ_PIT, "PIT_IRQHandler")
	_ = interrupt.Register(IRQ_LTC0, "LTC0_IRQHandler")
	_ = interrupt.Register(IRQ_DAC0, "DAC0_IRQHandler")
	_ = interrupt.Register(IRQ_MCG, "MCG_IRQHandler")
	_ = interrupt.Register(IRQ_LPTMR0, "LPTMR0_IRQHandler")
	_ = interrupt.Register(IRQ_SPI1, "SPI1_IRQHandler")
	_ = interrupt.Register(IRQ_PORTA, "PORTA_IRQHandler")
	_ = interrupt.Register(IRQ_PORTB_PORTC, "PORTB_PORTC_IRQHandler")
)

// Peripherals.
var (
	// Flash configuration field
	FTFA_FlashConfig = (*FTFA_FlashConfig_Type)(unsafe.Pointer(uintptr(0x400)))

	// Enhanced direct memory access controller
	DMA = (*DMA_Type)(unsafe.Pointer(uintptr(0x40008000)))

	// Flash Memory Interface
	FTFA = (*FTFA_Type)(unsafe.Pointer(uintptr(0x40020000)))

	// DMA channel multiplexor
	DMAMUX0 = (*DMAMUX0_Type)(unsafe.Pointer(uintptr(0x40021000)))

	// TRNG0
	TRNG0 = (*TRNG0_Type)(unsafe.Pointer(uintptr(0x40029000)))

	// Serial Peripheral Interface
	SPI0 = (*SPI_Type)(unsafe.Pointer(uintptr(0x4002c000)))

	// Serial Peripheral Interface
	SPI1 = (*SPI_Type)(unsafe.Pointer(uintptr(0x4002d000)))

	// Periodic Interrupt Timer
	PIT = (*PIT_Type)(unsafe.Pointer(uintptr(0x40037000)))

	// Timer/PWM Module
	TPM0 = (*TPM_Type)(unsafe.Pointer(uintptr(0x40038000)))

	// Timer/PWM Module
	TPM1 = (*TPM_Type)(unsafe.Pointer(uintptr(0x40039000)))

	// Timer/PWM Module
	TPM2 = (*TPM_Type)(unsafe.Pointer(uintptr(0x4003a000)))

	// Analog-to-Digital Converter
	ADC0 = (*ADC0_Type)(unsafe.Pointer(uintptr(0x4003b000)))

	// Secure Real Time Clock
	RTC = (*RTC_Type)(unsafe.Pointer(uintptr(0x4003d000)))

	// 12-Bit Digital-to-Analog Converter
	DAC0 = (*DAC0_Type)(unsafe.Pointer(uintptr(0x4003f000)))

	// Low Power Timer
	LPTMR0 = (*LPTMR0_Type)(unsafe.Pointer(uintptr(0x40040000)))

	// System register file
	RFSYS = (*RFSYS_Type)(unsafe.Pointer(uintptr(0x40041000)))

	// Touch sense input
	TSI0 = (*TSI0_Type)(unsafe.Pointer(uintptr(0x40045000)))

	// System Integration Module
	SIM = (*SIM_Type)(unsafe.Pointer(uintptr(0x40047000)))

	// Pin Control and Interrupts
	PORTA = (*PORT_Type)(unsafe.Pointer(uintptr(0x40049000)))

	// Pin Control and Interrupts
	PORTB = (*PORT_Type)(unsafe.Pointer(uintptr(0x4004a000)))

	// Pin Control and Interrupts
	PORTC = (*PORT_Type)(unsafe.Pointer(uintptr(0x4004b000)))

	// Universal Asynchronous Receiver/Transmitter
	LPUART0 = (*LPUART0_Type)(unsafe.Pointer(uintptr(0x40054000)))

	// LTC
	LTC0 = (*LTC0_Type)(unsafe.Pointer(uintptr(0x40058000)))

	// RSIM
	RSIM = (*RSIM_Type)(unsafe.Pointer(uintptr(0x40059000)))

	// DC to DC Converter
	DCDC = (*DCDC_Type)(unsafe.Pointer(uintptr(0x4005a000)))

	// BLE_RF
	BTLE_RF = (*BTLE_RF_Type)(unsafe.Pointer(uintptr(0x4005b000)))

	// XCVR_RX_DIG
	XCVR_RX_DIG = (*XCVR_RX_DIG_Type)(unsafe.Pointer(uintptr(0x4005c000)))

	// XCVR_TX_DIG
	XCVR_TX_DIG = (*XCVR_TX_DIG_Type)(unsafe.Pointer(uintptr(0x4005c200)))

	// XCVR_PLL_DIG
	XCVR_PLL_DIG = (*XCVR_PLL_DIG_Type)(unsafe.Pointer(uintptr(0x4005c224)))

	// XCVR_MISC
	XCVR_MISC = (*XCVR_MISC_Type)(unsafe.Pointer(uintptr(0x4005c280)))

	// XCVR_TSM
	XCVR_TSM = (*XCVR_TSM_Type)(unsafe.Pointer(uintptr(0x4005c2c0)))

	// XCVR_PHY
	XCVR_PHY = (*XCVR_PHY_Type)(unsafe.Pointer(uintptr(0x4005c400)))

	// XCVR_ZBDEMOD
	XCVR_ZBDEM = (*XCVR_ZBDEM_Type)(unsafe.Pointer(uintptr(0x4005c480)))

	// XCVR_ANALOG
	XCVR_ANA = (*XCVR_ANA_Type)(unsafe.Pointer(uintptr(0x4005c500)))

	// XCVR_PKT_RAM
	XCVR_PKT_RAM = (*XCVR_PKT_RAM_Type)(unsafe.Pointer(uintptr(0x4005c700)))

	// ZLL
	ZLL = (*ZLL_Type)(unsafe.Pointer(uintptr(0x4005d000)))

	// ANT
	ANT = (*ANT_Type)(unsafe.Pointer(uintptr(0x4005e000)))

	// GENERIC_FSK
	GENFSK = (*GENFSK_Type)(unsafe.Pointer(uintptr(0x4005f000)))

	// Carrier Modulator Transmitter
	CMT = (*CMT_Type)(unsafe.Pointer(uintptr(0x40062000)))

	// Multipurpose Clock Generator module
	MCG = (*MCG_Type)(unsafe.Pointer(uintptr(0x40064000)))

	// Inter-Integrated Circuit
	I2C0 = (*I2C_Type)(unsafe.Pointer(uintptr(0x40066000)))

	// Inter-Integrated Circuit
	I2C1 = (*I2C_Type)(unsafe.Pointer(uintptr(0x40067000)))

	// High-Speed Comparator (CMP), Voltage Reference (VREF) Digital-to-Analog Converter (DAC), and Analog Mux (ANMUX)
	CMP0 = (*CMP0_Type)(unsafe.Pointer(uintptr(0x40073000)))

	// Voltage Reference
	VREF = (*VREF_Type)(unsafe.Pointer(uintptr(0x40074000)))

	// Low leakage wakeup unit
	LLWU = (*LLWU_Type)(unsafe.Pointer(uintptr(0x4007c000)))

	// Power Management Controller
	PMC = (*PMC_Type)(unsafe.Pointer(uintptr(0x4007d000)))

	// System Mode Controller
	SMC = (*SMC_Type)(unsafe.Pointer(uintptr(0x4007e000)))

	// Reset Control Module
	RCM = (*RCM_Type)(unsafe.Pointer(uintptr(0x4007f000)))

	// General Purpose Input/Output
	GPIOA = (*GPIO_Type)(unsafe.Pointer(uintptr(0x400ff000)))

	// General Purpose Input/Output
	GPIOB = (*GPIO_Type)(unsafe.Pointer(uintptr(0x400ff040)))

	// General Purpose Input/Output
	GPIOC = (*GPIO_Type)(unsafe.Pointer(uintptr(0x400ff080)))

	// System Control Block
	SystemControl = (*SystemControl_Type)(unsafe.Pointer(uintptr(0xe000e000)))

	// System timer
	SysTick = (*SysTick_Type)(unsafe.Pointer(uintptr(0xe000e010)))

	// Nested Vectored Interrupt Controller
	NVIC = (*NVIC_Type)(unsafe.Pointer(uintptr(0xe000e100)))

	// Micro Trace Buffer
	MTB = (*MTB_Type)(unsafe.Pointer(uintptr(0xf0000000)))

	// MTB data watchpoint and trace
	MTBDWT = (*MTBDWT_Type)(unsafe.Pointer(uintptr(0xf0001000)))

	// System ROM
	ROM = (*ROM_Type)(unsafe.Pointer(uintptr(0xf0002000)))

	// Core Platform Miscellaneous Control Module
	MCM = (*MCM_Type)(unsafe.Pointer(uintptr(0xf0003000)))

	// General Purpose Input/Output
	FGPIOA = (*FGPIO_Type)(unsafe.Pointer(uintptr(0xf8000000)))

	// General Purpose Input/Output
	FGPIOB = (*FGPIO_Type)(unsafe.Pointer(uintptr(0xf8000040)))

	// General Purpose Input/Output
	FGPIOC = (*FGPIO_Type)(unsafe.Pointer(uintptr(0xf8000080)))
)

// Flash configuration field
type FTFA_FlashConfig_Type struct {
	BACKKEY3 volatile.Register8 // 0x0
	BACKKEY2 volatile.Register8 // 0x1
	BACKKEY1 volatile.Register8 // 0x2
	BACKKEY0 volatile.Register8 // 0x3
	BACKKEY7 volatile.Register8 // 0x4
	BACKKEY6 volatile.Register8 // 0x5
	BACKKEY5 volatile.Register8 // 0x6
	BACKKEY4 volatile.Register8 // 0x7
	FPROT3   volatile.Register8 // 0x8
	FPROT2   volatile.Register8 // 0x9
	FPROT1   volatile.Register8 // 0xA
	FPROT0   volatile.Register8 // 0xB
	FSEC     volatile.Register8 // 0xC
	FOPT     volatile.Register8 // 0xD
}

// Enhanced direct memory access controller
type DMA_Type struct {
	CR                 volatile.Register32 // 0x0
	ES                 volatile.Register32 // 0x4
	_                  [4]byte
	ERQ                volatile.Register32 // 0xC
	_                  [4]byte
	EEI                volatile.Register32 // 0x14
	CEEI               volatile.Register8  // 0x18
	SEEI               volatile.Register8  // 0x19
	CERQ               volatile.Register8  // 0x1A
	SERQ               volatile.Register8  // 0x1B
	CDNE               volatile.Register8  // 0x1C
	SSRT               volatile.Register8  // 0x1D
	CERR               volatile.Register8  // 0x1E
	CINT               volatile.Register8  // 0x1F
	_                  [4]byte
	INT                volatile.Register32 // 0x24
	_                  [4]byte
	ERR                volatile.Register32 // 0x2C
	_                  [4]byte
	HRS                volatile.Register32 // 0x34
	_                  [12]byte
	EARS               volatile.Register32 // 0x44
	_                  [184]byte
	DCHPRI3            volatile.Register8 // 0x100
	DCHPRI2            volatile.Register8 // 0x101
	DCHPRI1            volatile.Register8 // 0x102
	DCHPRI0            volatile.Register8 // 0x103
	_                  [3836]byte
	TCD0_SADDR         volatile.Register32 // 0x1000
	TCD0_SOFF          volatile.Register16 // 0x1004
	TCD0_ATTR          volatile.Register16 // 0x1006
	TCD0_NBYTES_MLNO   volatile.Register32 // 0x1008
	TCD0_SLAST         volatile.Register32 // 0x100C
	TCD0_DADDR         volatile.Register32 // 0x1010
	TCD0_DOFF          volatile.Register16 // 0x1014
	TCD0_CITER_ELINKNO volatile.Register16 // 0x1016
	TCD0_DLASTSGA      volatile.Register32 // 0x1018
	TCD0_CSR           volatile.Register16 // 0x101C
	TCD0_BITER_ELINKNO volatile.Register16 // 0x101E
	TCD1_SADDR         volatile.Register32 // 0x1020
	TCD1_SOFF          volatile.Register16 // 0x1024
	TCD1_ATTR          volatile.Register16 // 0x1026
	TCD1_NBYTES_MLNO   volatile.Register32 // 0x1028
	TCD1_SLAST         volatile.Register32 // 0x102C
	TCD1_DADDR         volatile.Register32 // 0x1030
	TCD1_DOFF          volatile.Register16 // 0x1034
	TCD1_CITER_ELINKNO volatile.Register16 // 0x1036
	TCD1_DLASTSGA      volatile.Register32 // 0x1038
	TCD1_CSR           volatile.Register16 // 0x103C
	TCD1_BITER_ELINKNO volatile.Register16 // 0x103E
	TCD2_SADDR         volatile.Register32 // 0x1040
	TCD2_SOFF          volatile.Register16 // 0x1044
	TCD2_ATTR          volatile.Register16 // 0x1046
	TCD2_NBYTES_MLNO   volatile.Register32 // 0x1048
	TCD2_SLAST         volatile.Register32 // 0x104C
	TCD2_DADDR         volatile.Register32 // 0x1050
	TCD2_DOFF          volatile.Register16 // 0x1054
	TCD2_CITER_ELINKNO volatile.Register16 // 0x1056
	TCD2_DLASTSGA      volatile.Register32 // 0x1058
	TCD2_CSR           volatile.Register16 // 0x105C
	TCD2_BITER_ELINKNO volatile.Register16 // 0x105E
	TCD3_SADDR         volatile.Register32 // 0x1060
	TCD3_SOFF          volatile.Register16 // 0x1064
	TCD3_ATTR          volatile.Register16 // 0x1066
	TCD3_NBYTES_MLNO   volatile.Register32 // 0x1068
	TCD3_SLAST         volatile.Register32 // 0x106C
	TCD3_DADDR         volatile.Register32 // 0x1070
	TCD3_DOFF          volatile.Register16 // 0x1074
	TCD3_CITER_ELINKNO volatile.Register16 // 0x1076
	TCD3_DLASTSGA      volatile.Register32 // 0x1078
	TCD3_CSR           volatile.Register16 // 0x107C
	TCD3_BITER_ELINKNO volatile.Register16 // 0x107E
}

// Flash Memory Interface
type FTFA_Type struct {
	FSTAT  volatile.Register8 // 0x0
	FCNFG  volatile.Register8 // 0x1
	FSEC   volatile.Register8 // 0x2
	FOPT   volatile.Register8 // 0x3
	FCCOB3 volatile.Register8 // 0x4
	FCCOB2 volatile.Register8 // 0x5
	FCCOB1 volatile.Register8 // 0x6
	FCCOB0 volatile.Register8 // 0x7
	FCCOB7 volatile.Register8 // 0x8
	FCCOB6 volatile.Register8 // 0x9
	FCCOB5 volatile.Register8 // 0xA
	FCCOB4 volatile.Register8 // 0xB
	FCCOBB volatile.Register8 // 0xC
	FCCOBA volatile.Register8 // 0xD
	FCCOB9 volatile.Register8 // 0xE
	FCCOB8 volatile.Register8 // 0xF
	FPROT3 volatile.Register8 // 0x10
	FPROT2 volatile.Register8 // 0x11
	FPROT1 volatile.Register8 // 0x12
	FPROT0 volatile.Register8 // 0x13
	_      [4]byte
	XACCH3 volatile.Register8 // 0x18
	XACCH2 volatile.Register8 // 0x19
	XACCH1 volatile.Register8 // 0x1A
	XACCH0 volatile.Register8 // 0x1B
	XACCL3 volatile.Register8 // 0x1C
	XACCL2 volatile.Register8 // 0x1D
	XACCL1 volatile.Register8 // 0x1E
	XACCL0 volatile.Register8 // 0x1F
	SACCH3 volatile.Register8 // 0x20
	SACCH2 volatile.Register8 // 0x21
	SACCH1 volatile.Register8 // 0x22
	SACCH0 volatile.Register8 // 0x23
	SACCL3 volatile.Register8 // 0x24
	SACCL2 volatile.Register8 // 0x25
	SACCL1 volatile.Register8 // 0x26
	SACCL0 volatile.Register8 // 0x27
	FACSS  volatile.Register8 // 0x28
	_      [2]byte
	FACSN  volatile.Register8 // 0x2B
}

// DMA channel multiplexor
type DMAMUX0_Type struct {
	CHCFG0 volatile.Register8 // 0x0
	CHCFG1 volatile.Register8 // 0x1
	CHCFG2 volatile.Register8 // 0x2
	CHCFG3 volatile.Register8 // 0x3
}

// TRNG0
type TRNG0_Type struct {
	MCTL       volatile.Register32 // 0x0
	SCMISC     volatile.Register32 // 0x4
	PKRRNG     volatile.Register32 // 0x8
	PKRMAX     volatile.Register32 // 0xC
	SDCTL      volatile.Register32 // 0x10
	SBLIM      volatile.Register32 // 0x14
	FRQMIN     volatile.Register32 // 0x18
	FRQCNT     volatile.Register32 // 0x1C
	SCMC       volatile.Register32 // 0x20
	SCR1C      volatile.Register32 // 0x24
	SCR2C      volatile.Register32 // 0x28
	SCR3C      volatile.Register32 // 0x2C
	SCR4C      volatile.Register32 // 0x30
	SCR5C      volatile.Register32 // 0x34
	SCR6PC     volatile.Register32 // 0x38
	STATUS     volatile.Register32 // 0x3C
	ENT0       volatile.Register32 // 0x40
	ENT1       volatile.Register32 // 0x44
	ENT2       volatile.Register32 // 0x48
	ENT3       volatile.Register32 // 0x4C
	ENT4       volatile.Register32 // 0x50
	ENT5       volatile.Register32 // 0x54
	ENT6       volatile.Register32 // 0x58
	ENT7       volatile.Register32 // 0x5C
	ENT8       volatile.Register32 // 0x60
	ENT9       volatile.Register32 // 0x64
	ENT10      volatile.Register32 // 0x68
	ENT11      volatile.Register32 // 0x6C
	ENT12      volatile.Register32 // 0x70
	ENT13      volatile.Register32 // 0x74
	ENT14      volatile.Register32 // 0x78
	ENT15      volatile.Register32 // 0x7C
	PKRCNT10   volatile.Register32 // 0x80
	PKRCNT32   volatile.Register32 // 0x84
	PKRCNT54   volatile.Register32 // 0x88
	PKRCNT76   volatile.Register32 // 0x8C
	PKRCNT98   volatile.Register32 // 0x90
	PKRCNTBA   volatile.Register32 // 0x94
	PKRCNTDC   volatile.Register32 // 0x98
	PKRCNTFE   volatile.Register32 // 0x9C
	_          [16]byte
	SEC_CFG    volatile.Register32 // 0xB0
	INT_CTRL   volatile.Register32 // 0xB4
	INT_MASK   volatile.Register32 // 0xB8
	INT_STATUS volatile.Register32 // 0xBC
	_          [48]byte
	VID1       volatile.Register32 // 0xF0
	VID2       volatile.Register32 // 0xF4
}

// Serial Peripheral Interface
type SPI_Type struct {
	MCR   volatile.Register32 // 0x0
	_     [4]byte
	TCR   volatile.Register32 // 0x8
	CTAR0 volatile.Register32 // 0xC
	CTAR1 volatile.Register32 // 0x10
	_     [24]byte
	SR    volatile.Register32 // 0x2C
	RSER  volatile.Register32 // 0x30
	PUSHR volatile.Register32 // 0x34
	POPR  volatile.Register32 // 0x38
	TXFR0 volatile.Register32 // 0x3C
	TXFR1 volatile.Register32 // 0x40
	TXFR2 volatile.Register32 // 0x44
	TXFR3 volatile.Register32 // 0x48
	_     [48]byte
	RXFR0 volatile.Register32 // 0x7C
	RXFR1 volatile.Register32 // 0x80
	RXFR2 volatile.Register32 // 0x84
	RXFR3 volatile.Register32 // 0x88
}

// Periodic Interrupt Timer
type PIT_Type struct {
	MCR     volatile.Register32 // 0x0
	_       [220]byte
	LTMR64H volatile.Register32 // 0xE0
	LTMR64L volatile.Register32 // 0xE4
	_       [24]byte
	LDVAL0  volatile.Register32 // 0x100
	CVAL0   volatile.Register32 // 0x104
	TCTRL0  volatile.Register32 // 0x108
	TFLG0   volatile.Register32 // 0x10C
	LDVAL1  volatile.Register32 // 0x110
	CVAL1   volatile.Register32 // 0x114
	TCTRL1  volatile.Register32 // 0x118
	TFLG1   volatile.Register32 // 0x11C
}

// Timer/PWM Module
type TPM_Type struct {
	SC      volatile.Register32 // 0x0
	CNT     volatile.Register32 // 0x4
	MOD     volatile.Register32 // 0x8
	C0SC    volatile.Register32 // 0xC
	C0V     volatile.Register32 // 0x10
	C1SC    volatile.Register32 // 0x14
	C1V     volatile.Register32 // 0x18
	C2SC    volatile.Register32 // 0x1C
	C2V     volatile.Register32 // 0x20
	C3SC    volatile.Register32 // 0x24
	C3V     volatile.Register32 // 0x28
	_       [36]byte
	STATUS  volatile.Register32 // 0x50
	_       [16]byte
	COMBINE volatile.Register32 // 0x64
	_       [8]byte
	POL     volatile.Register32 // 0x70
	_       [4]byte
	FILTER  volatile.Register32 // 0x78
	_       [4]byte
	QDCTRL  volatile.Register32 // 0x80
	CONF    volatile.Register32 // 0x84
}

// Analog-to-Digital Converter
type ADC0_Type struct {
	SC1A volatile.Register32 // 0x0
	SC1B volatile.Register32 // 0x4
	CFG1 volatile.Register32 // 0x8
	CFG2 volatile.Register32 // 0xC
	RA   volatile.Register32 // 0x10
	RB   volatile.Register32 // 0x14
	CV1  volatile.Register32 // 0x18
	CV2  volatile.Register32 // 0x1C
	SC2  volatile.Register32 // 0x20
	SC3  volatile.Register32 // 0x24
	OFS  volatile.Register32 // 0x28
	PG   volatile.Register32 // 0x2C
	MG   volatile.Register32 // 0x30
	CLPD volatile.Register32 // 0x34
	CLPS volatile.Register32 // 0x38
	CLP4 volatile.Register32 // 0x3C
	CLP3 volatile.Register32 // 0x40
	CLP2 volatile.Register32 // 0x44
	CLP1 volatile.Register32 // 0x48
	CLP0 volatile.Register32 // 0x4C
	_    [4]byte
	CLMD volatile.Register32 // 0x54
	CLMS volatile.Register32 // 0x58
	CLM4 volatile.Register32 // 0x5C
	CLM3 volatile.Register32 // 0x60
	CLM2 volatile.Register32 // 0x64
	CLM1 volatile.Register32 // 0x68
	CLM0 volatile.Register32 // 0x6C
}

// Secure Real Time Clock
type RTC_Type struct {
	TSR volatile.Register32 // 0x0
	TPR volatile.Register32 // 0x4
	TAR volatile.Register32 // 0x8
	TCR volatile.Register32 // 0xC
	CR  volatile.Register32 // 0x10
	SR  volatile.Register32 // 0x14
	LR  volatile.Register32 // 0x18
	IER volatile.Register32 // 0x1C
}

// 12-Bit Digital-to-Analog Converter
type DAC0_Type struct {
	DAT0L volatile.Register8 // 0x0
	DAT0H volatile.Register8 // 0x1
	DAT1L volatile.Register8 // 0x2
	DAT1H volatile.Register8 // 0x3
	_     [28]byte
	SR    volatile.Register8 // 0x20
	C0    volatile.Register8 // 0x21
	C1    volatile.Register8 // 0x22
	C2    volatile.Register8 // 0x23
}

// Low Power Timer
type LPTMR0_Type struct {
	CSR volatile.Register32 // 0x0
	PSR volatile.Register32 // 0x4
	CMR volatile.Register32 // 0x8
	CNR volatile.Register32 // 0xC
}

// System register file
type RFSYS_Type struct {
	REG0 volatile.Register32 // 0x0
	REG1 volatile.Register32 // 0x4
	REG2 volatile.Register32 // 0x8
	REG3 volatile.Register32 // 0xC
	REG4 volatile.Register32 // 0x10
	REG5 volatile.Register32 // 0x14
	REG6 volatile.Register32 // 0x18
	REG7 volatile.Register32 // 0x1C
}

// Touch sense input
type TSI0_Type struct {
	GENCS volatile.Register32 // 0x0
	DATA  volatile.Register32 // 0x4
	TSHD  volatile.Register32 // 0x8
}

// System Integration Module
type SIM_Type struct {
	SOPT1   volatile.Register32 // 0x0
	_       [4096]byte
	SOPT2   volatile.Register32 // 0x1004
	_       [4]byte
	SOPT4   volatile.Register32 // 0x100C
	SOPT5   volatile.Register32 // 0x1010
	_       [4]byte
	SOPT7   volatile.Register32 // 0x1018
	_       [8]byte
	SDID    volatile.Register32 // 0x1024
	_       [12]byte
	SCGC4   volatile.Register32 // 0x1034
	SCGC5   volatile.Register32 // 0x1038
	SCGC6   volatile.Register32 // 0x103C
	SCGC7   volatile.Register32 // 0x1040
	CLKDIV1 volatile.Register32 // 0x1044
	_       [4]byte
	FCFG1   volatile.Register32 // 0x104C
	FCFG2   volatile.Register32 // 0x1050
	_       [4]byte
	UIDMH   volatile.Register32 // 0x1058
	UIDML   volatile.Register32 // 0x105C
	UIDL    volatile.Register32 // 0x1060
	_       [156]byte
	COPC    volatile.Register32 // 0x1100
	SRVCOP  volatile.Register32 // 0x1104
}

// Pin Control and Interrupts
type PORT_Type struct {
	PCR0  volatile.Register32 // 0x0
	PCR1  volatile.Register32 // 0x4
	PCR2  volatile.Register32 // 0x8
	PCR3  volatile.Register32 // 0xC
	PCR4  volatile.Register32 // 0x10
	PCR5  volatile.Register32 // 0x14
	PCR6  volatile.Register32 // 0x18
	PCR7  volatile.Register32 // 0x1C
	PCR8  volatile.Register32 // 0x20
	PCR9  volatile.Register32 // 0x24
	PCR10 volatile.Register32 // 0x28
	PCR11 volatile.Register32 // 0x2C
	PCR12 volatile.Register32 // 0x30
	PCR13 volatile.Register32 // 0x34
	PCR14 volatile.Register32 // 0x38
	PCR15 volatile.Register32 // 0x3C
	PCR16 volatile.Register32 // 0x40
	PCR17 volatile.Register32 // 0x44
	PCR18 volatile.Register32 // 0x48
	PCR19 volatile.Register32 // 0x4C
	PCR20 volatile.Register32 // 0x50
	PCR21 volatile.Register32 // 0x54
	PCR22 volatile.Register32 // 0x58
	PCR23 volatile.Register32 // 0x5C
	PCR24 volatile.Register32 // 0x60
	PCR25 volatile.Register32 // 0x64
	PCR26 volatile.Register32 // 0x68
	PCR27 volatile.Register32 // 0x6C
	PCR28 volatile.Register32 // 0x70
	PCR29 volatile.Register32 // 0x74
	PCR30 volatile.Register32 // 0x78
	PCR31 volatile.Register32 // 0x7C
	GPCLR volatile.Register32 // 0x80
	GPCHR volatile.Register32 // 0x84
	_     [24]byte
	ISFR  volatile.Register32 // 0xA0
}

// Universal Asynchronous Receiver/Transmitter
type LPUART0_Type struct {
	BAUD  volatile.Register32 // 0x0
	STAT  volatile.Register32 // 0x4
	CTRL  volatile.Register32 // 0x8
	DATA  volatile.Register32 // 0xC
	MATCH volatile.Register32 // 0x10
	MODIR volatile.Register32 // 0x14
}

// LTC
type LTC0_Type struct {
	MD      volatile.Register32 // 0x0
	_       [4]byte
	KS      volatile.Register32 // 0x8
	_       [4]byte
	DS      volatile.Register32 // 0x10
	_       [4]byte
	ICVS    volatile.Register32 // 0x18
	_       [20]byte
	COM     volatile.Register32 // 0x30
	CTL     volatile.Register32 // 0x34
	_       [8]byte
	CW      volatile.Register32 // 0x40
	_       [4]byte
	STA     volatile.Register32 // 0x48
	ESTA    volatile.Register32 // 0x4C
	_       [8]byte
	AADSZ   volatile.Register32 // 0x58
	_       [164]byte
	CTX_0   volatile.Register32 // 0x100
	CTX_1   volatile.Register32 // 0x104
	CTX_2   volatile.Register32 // 0x108
	CTX_3   volatile.Register32 // 0x10C
	CTX_4   volatile.Register32 // 0x110
	CTX_5   volatile.Register32 // 0x114
	CTX_6   volatile.Register32 // 0x118
	CTX_7   volatile.Register32 // 0x11C
	CTX_8   volatile.Register32 // 0x120
	CTX_9   volatile.Register32 // 0x124
	CTX_10  volatile.Register32 // 0x128
	CTX_11  volatile.Register32 // 0x12C
	CTX_12  volatile.Register32 // 0x130
	CTX_13  volatile.Register32 // 0x134
	_       [200]byte
	KEY_0   volatile.Register32 // 0x200
	KEY_1   volatile.Register32 // 0x204
	KEY_2   volatile.Register32 // 0x208
	KEY_3   volatile.Register32 // 0x20C
	_       [736]byte
	VID1    volatile.Register32 // 0x4F0
	VID2    volatile.Register32 // 0x4F4
	CHAVID  volatile.Register32 // 0x4F8
	_       [708]byte
	FIFOSTA volatile.Register32 // 0x7C0
	_       [28]byte
	IFIFO   volatile.Register32 // 0x7E0
	_       [12]byte
	OFIFO   volatile.Register32 // 0x7F0
}

// RSIM
type RSIM_Type struct {
	CONTROL        volatile.Register32 // 0x0
	ACTIVE_DELAY   volatile.Register32 // 0x4
	MAC_MSB        volatile.Register32 // 0x8
	MAC_LSB        volatile.Register32 // 0xC
	MISC           volatile.Register32 // 0x10
	_              [236]byte
	DSM_TIMER      volatile.Register32 // 0x100
	DSM_CONTROL    volatile.Register32 // 0x104
	DSM_OSC_OFFSET volatile.Register32 // 0x108
	ANT_SLEEP      volatile.Register32 // 0x10C
	ANT_WAKE       volatile.Register32 // 0x110
	ZIG_SLEEP      volatile.Register32 // 0x114
	ZIG_WAKE       volatile.Register32 // 0x118
	GEN_SLEEP      volatile.Register32 // 0x11C
	GEN_WAKE       volatile.Register32 // 0x120
	RF_OSC_CTRL    volatile.Register32 // 0x124
	ANA_TEST       volatile.Register32 // 0x128
	ANA_TRIM       volatile.Register32 // 0x12C
}

// DC to DC Converter
type DCDC_Type struct {
	REG0 volatile.Register32 // 0x0
	REG1 volatile.Register32 // 0x4
	REG2 volatile.Register32 // 0x8
	REG3 volatile.Register32 // 0xC
	REG4 volatile.Register32 // 0x10
	_    [4]byte
	REG6 volatile.Register32 // 0x18
	REG7 volatile.Register32 // 0x1C
}

// BLE_RF
type BTLE_RF_Type struct {
	_           [1536]byte
	BLE_PART_ID volatile.Register16 // 0x600
	_           [2]byte
	DSM_STATUS  volatile.Register16 // 0x604
	_           [2]byte
	MISC_CTRL   volatile.Register16 // 0x608
}

// XCVR_RX_DIG
type XCVR_RX_DIG_Type struct {
	RX_DIG_CTRL               volatile.Register32 // 0x0
	AGC_CTRL_0                volatile.Register32 // 0x4
	AGC_CTRL_1                volatile.Register32 // 0x8
	AGC_CTRL_2                volatile.Register32 // 0xC
	AGC_CTRL_3                volatile.Register32 // 0x10
	AGC_STAT                  volatile.Register32 // 0x14
	RSSI_CTRL_0               volatile.Register32 // 0x18
	RSSI_CTRL_1               volatile.Register32 // 0x1C
	RSSI_DFT                  volatile.Register32 // 0x20
	DCOC_CTRL_0               volatile.Register32 // 0x24
	DCOC_CTRL_1               volatile.Register32 // 0x28
	DCOC_DAC_INIT             volatile.Register32 // 0x2C
	DCOC_DIG_MAN              volatile.Register32 // 0x30
	DCOC_CAL_GAIN             volatile.Register32 // 0x34
	DCOC_STAT                 volatile.Register32 // 0x38
	DCOC_DC_EST               volatile.Register32 // 0x3C
	DCOC_CAL_RCP              volatile.Register32 // 0x40
	_                         [4]byte
	IQMC_CTRL                 volatile.Register32 // 0x48
	IQMC_CAL                  volatile.Register32 // 0x4C
	LNA_GAIN_VAL_3_0          volatile.Register32 // 0x50
	LNA_GAIN_VAL_7_4          volatile.Register32 // 0x54
	LNA_GAIN_VAL_8            volatile.Register32 // 0x58
	BBA_RES_TUNE_VAL_7_0      volatile.Register32 // 0x5C
	BBA_RES_TUNE_VAL_10_8     volatile.Register32 // 0x60
	LNA_GAIN_LIN_VAL_2_0      volatile.Register32 // 0x64
	LNA_GAIN_LIN_VAL_5_3      volatile.Register32 // 0x68
	LNA_GAIN_LIN_VAL_8_6      volatile.Register32 // 0x6C
	LNA_GAIN_LIN_VAL_9        volatile.Register32 // 0x70
	BBA_RES_TUNE_LIN_VAL_3_0  volatile.Register32 // 0x74
	BBA_RES_TUNE_LIN_VAL_7_4  volatile.Register32 // 0x78
	BBA_RES_TUNE_LIN_VAL_10_8 volatile.Register32 // 0x7C
	AGC_GAIN_TBL_03_00        volatile.Register32 // 0x80
	AGC_GAIN_TBL_07_04        volatile.Register32 // 0x84
	AGC_GAIN_TBL_11_08        volatile.Register32 // 0x88
	AGC_GAIN_TBL_15_12        volatile.Register32 // 0x8C
	AGC_GAIN_TBL_19_16        volatile.Register32 // 0x90
	AGC_GAIN_TBL_23_20        volatile.Register32 // 0x94
	AGC_GAIN_TBL_26_24        volatile.Register32 // 0x98
	_                         [4]byte
	DCOC_OFFSET_0             volatile.Register32 // 0xA0
	DCOC_OFFSET_1             volatile.Register32 // 0xA4
	DCOC_OFFSET_2             volatile.Register32 // 0xA8
	DCOC_OFFSET_3             volatile.Register32 // 0xAC
	DCOC_OFFSET_4             volatile.Register32 // 0xB0
	DCOC_OFFSET_5             volatile.Register32 // 0xB4
	DCOC_OFFSET_6             volatile.Register32 // 0xB8
	DCOC_OFFSET_7             volatile.Register32 // 0xBC
	DCOC_OFFSET_8             volatile.Register32 // 0xC0
	DCOC_OFFSET_9             volatile.Register32 // 0xC4
	DCOC_OFFSET_10            volatile.Register32 // 0xC8
	DCOC_OFFSET_11            volatile.Register32 // 0xCC
	DCOC_OFFSET_12            volatile.Register32 // 0xD0
	DCOC_OFFSET_13            volatile.Register32 // 0xD4
	DCOC_OFFSET_14            volatile.Register32 // 0xD8
	DCOC_OFFSET_15            volatile.Register32 // 0xDC
	DCOC_OFFSET_16            volatile.Register32 // 0xE0
	DCOC_OFFSET_17            volatile.Register32 // 0xE4
	DCOC_OFFSET_18            volatile.Register32 // 0xE8
	DCOC_OFFSET_19            volatile.Register32 // 0xEC
	DCOC_OFFSET_20            volatile.Register32 // 0xF0
	DCOC_OFFSET_21            volatile.Register32 // 0xF4
	DCOC_OFFSET_22            volatile.Register32 // 0xF8
	DCOC_OFFSET_23            volatile.Register32 // 0xFC
	DCOC_OFFSET_24            volatile.Register32 // 0x100
	DCOC_OFFSET_25            volatile.Register32 // 0x104
	DCOC_OFFSET_26            volatile.Register32 // 0x108
	DCOC_BBA_STEP             volatile.Register32 // 0x10C
	DCOC_TZA_STEP_0           volatile.Register32 // 0x110
	DCOC_TZA_STEP_1           volatile.Register32 // 0x114
	DCOC_TZA_STEP_2           volatile.Register32 // 0x118
	DCOC_TZA_STEP_3           volatile.Register32 // 0x11C
	DCOC_TZA_STEP_4           volatile.Register32 // 0x120
	DCOC_TZA_STEP_5           volatile.Register32 // 0x124
	DCOC_TZA_STEP_6           volatile.Register32 // 0x128
	DCOC_TZA_STEP_7           volatile.Register32 // 0x12C
	DCOC_TZA_STEP_8           volatile.Register32 // 0x130
	DCOC_TZA_STEP_9           volatile.Register32 // 0x134
	DCOC_TZA_STEP_10          volatile.Register32 // 0x138
	_                         [44]byte
	DCOC_CAL_ALPHA            volatile.Register32 // 0x168
	DCOC_CAL_BETA_Q           volatile.Register32 // 0x16C
	DCOC_CAL_BETA_I           volatile.Register32 // 0x170
	DCOC_CAL_GAMMA            volatile.Register32 // 0x174
	DCOC_CAL_IIR              volatile.Register32 // 0x178
	_                         [4]byte
	DCOC_CAL1                 volatile.Register32 // 0x180
	DCOC_CAL2                 volatile.Register32 // 0x184
	DCOC_CAL3                 volatile.Register32 // 0x188
	_                         [4]byte
	CCA_ED_LQI_CTRL_0         volatile.Register32 // 0x190
	CCA_ED_LQI_CTRL_1         volatile.Register32 // 0x194
	CCA_ED_LQI_STAT_0         volatile.Register32 // 0x198
	_                         [4]byte
	RX_CHF_COEF_0             volatile.Register32 // 0x1A0
	RX_CHF_COEF_1             volatile.Register32 // 0x1A4
	RX_CHF_COEF_2             volatile.Register32 // 0x1A8
	RX_CHF_COEF_3             volatile.Register32 // 0x1AC
	RX_CHF_COEF_4             volatile.Register32 // 0x1B0
	RX_CHF_COEF_5             volatile.Register32 // 0x1B4
	RX_CHF_COEF_6             volatile.Register32 // 0x1B8
	RX_CHF_COEF_7             volatile.Register32 // 0x1BC
	RX_CHF_COEF_8             volatile.Register32 // 0x1C0
	RX_CHF_COEF_9             volatile.Register32 // 0x1C4
	RX_CHF_COEF_10            volatile.Register32 // 0x1C8
	RX_CHF_COEF_11            volatile.Register32 // 0x1CC
	AGC_MAN_AGC_IDX           volatile.Register32 // 0x1D0
	DC_RESID_CTRL             volatile.Register32 // 0x1D4
	DC_RESID_EST              volatile.Register32 // 0x1D8
	RX_RCCAL_CTRL0            volatile.Register32 // 0x1DC
	RX_RCCAL_CTRL1            volatile.Register32 // 0x1E0
	RX_RCCAL_STAT             volatile.Register32 // 0x1E4
	AUXPLL_FCAL_CTRL          volatile.Register32 // 0x1E8
	AUXPLL_FCAL_CNT6          volatile.Register32 // 0x1EC
	AUXPLL_FCAL_CNT5_4        volatile.Register32 // 0x1F0
	AUXPLL_FCAL_CNT3_2        volatile.Register32 // 0x1F4
	AUXPLL_FCAL_CNT1_0        volatile.Register32 // 0x1F8
	RXDIG_DFT                 volatile.Register32 // 0x1FC
}

// XCVR_TX_DIG
type XCVR_TX_DIG_Type struct {
	CTRL          volatile.Register32 // 0x0
	DATA_PADDING  volatile.Register32 // 0x4
	GFSK_CTRL     volatile.Register32 // 0x8
	GFSK_COEFF2   volatile.Register32 // 0xC
	GFSK_COEFF1   volatile.Register32 // 0x10
	FSK_SCALE     volatile.Register32 // 0x14
	DFT_PATTERN   volatile.Register32 // 0x18
	RF_DFT_BIST_1 volatile.Register32 // 0x1C
	RF_DFT_BIST_2 volatile.Register32 // 0x20
}

// XCVR_PLL_DIG
type XCVR_PLL_DIG_Type struct {
	HPM_BUMP      volatile.Register32 // 0x0
	MOD_CTRL      volatile.Register32 // 0x4
	CHAN_MAP      volatile.Register32 // 0x8
	LOCK_DETECT   volatile.Register32 // 0xC
	HPM_CTRL      volatile.Register32 // 0x10
	HPMCAL_CTRL   volatile.Register32 // 0x14
	HPM_CAL1      volatile.Register32 // 0x18
	HPM_CAL2      volatile.Register32 // 0x1C
	HPM_SDM_RES   volatile.Register32 // 0x20
	LPM_CTRL      volatile.Register32 // 0x24
	LPM_SDM_CTRL1 volatile.Register32 // 0x28
	LPM_SDM_CTRL2 volatile.Register32 // 0x2C
	LPM_SDM_CTRL3 volatile.Register32 // 0x30
	LPM_SDM_RES1  volatile.Register32 // 0x34
	LPM_SDM_RES2  volatile.Register32 // 0x38
	DELAY_MATCH   volatile.Register32 // 0x3C
	CTUNE_CTRL    volatile.Register32 // 0x40
	CTUNE_CNT6    volatile.Register32 // 0x44
	CTUNE_CNT5_4  volatile.Register32 // 0x48
	CTUNE_CNT3_2  volatile.Register32 // 0x4C
	CTUNE_CNT1_0  volatile.Register32 // 0x50
	CTUNE_RES     volatile.Register32 // 0x54
}

// XCVR_MISC
type XCVR_MISC_Type struct {
	XCVR_CTRL           volatile.Register32 // 0x0
	XCVR_STATUS         volatile.Register32 // 0x4
	BLE_ARB_CTRL        volatile.Register32 // 0x8
	_                   [4]byte
	OVERWRITE_VER       volatile.Register32 // 0x10
	DMA_CTRL            volatile.Register32 // 0x14
	DMA_DATA            volatile.Register32 // 0x18
	DTEST_CTRL          volatile.Register32 // 0x1C
	PACKET_RAM_CTRL     volatile.Register32 // 0x20
	FAD_CTRL            volatile.Register32 // 0x24
	LPPS_CTRL           volatile.Register32 // 0x28
	RF_NOT_ALLOWED_CTRL volatile.Register32 // 0x2C
	CRCW_CFG            volatile.Register32 // 0x30
	CRC_EC_MASK         volatile.Register32 // 0x34
	CRC_RES_OUT         volatile.Register32 // 0x38
}

// XCVR_TSM
type XCVR_TSM_Type struct {
	CTRL          volatile.Register32 // 0x0
	END_OF_SEQ    volatile.Register32 // 0x4
	OVRD0         volatile.Register32 // 0x8
	OVRD1         volatile.Register32 // 0xC
	OVRD2         volatile.Register32 // 0x10
	OVRD3         volatile.Register32 // 0x14
	PA_POWER      volatile.Register32 // 0x18
	PA_RAMP_TBL0  volatile.Register32 // 0x1C
	PA_RAMP_TBL1  volatile.Register32 // 0x20
	RECYCLE_COUNT volatile.Register32 // 0x24
	FAST_CTRL1    volatile.Register32 // 0x28
	FAST_CTRL2    volatile.Register32 // 0x2C
	TIMING00      volatile.Register32 // 0x30
	TIMING01      volatile.Register32 // 0x34
	TIMING02      volatile.Register32 // 0x38
	TIMING03      volatile.Register32 // 0x3C
	TIMING04      volatile.Register32 // 0x40
	TIMING05      volatile.Register32 // 0x44
	TIMING06      volatile.Register32 // 0x48
	TIMING07      volatile.Register32 // 0x4C
	TIMING08      volatile.Register32 // 0x50
	TIMING09      volatile.Register32 // 0x54
	TIMING10      volatile.Register32 // 0x58
	TIMING11      volatile.Register32 // 0x5C
	TIMING12      volatile.Register32 // 0x60
	TIMING13      volatile.Register32 // 0x64
	TIMING14      volatile.Register32 // 0x68
	TIMING15      volatile.Register32 // 0x6C
	TIMING16      volatile.Register32 // 0x70
	TIMING17      volatile.Register32 // 0x74
	TIMING18      volatile.Register32 // 0x78
	TIMING19      volatile.Register32 // 0x7C
	TIMING20      volatile.Register32 // 0x80
	TIMING21      volatile.Register32 // 0x84
	TIMING22      volatile.Register32 // 0x88
	TIMING23      volatile.Register32 // 0x8C
	TIMING24      volatile.Register32 // 0x90
	TIMING25      volatile.Register32 // 0x94
	TIMING26      volatile.Register32 // 0x98
	TIMING27      volatile.Register32 // 0x9C
	TIMING28      volatile.Register32 // 0xA0
	TIMING29      volatile.Register32 // 0xA4
	TIMING30      volatile.Register32 // 0xA8
	TIMING31      volatile.Register32 // 0xAC
	TIMING32      volatile.Register32 // 0xB0
	TIMING33      volatile.Register32 // 0xB4
	TIMING34      volatile.Register32 // 0xB8
	TIMING35      volatile.Register32 // 0xBC
	TIMING36      volatile.Register32 // 0xC0
	TIMING37      volatile.Register32 // 0xC4
	TIMING38      volatile.Register32 // 0xC8
	TIMING39      volatile.Register32 // 0xCC
	TIMING40      volatile.Register32 // 0xD0
	TIMING41      volatile.Register32 // 0xD4
	TIMING42      volatile.Register32 // 0xD8
	TIMING43      volatile.Register32 // 0xDC
	TIMING44      volatile.Register32 // 0xE0
	TIMING45      volatile.Register32 // 0xE4
	TIMING46      volatile.Register32 // 0xE8
	TIMING47      volatile.Register32 // 0xEC
	TIMING48      volatile.Register32 // 0xF0
	TIMING49      volatile.Register32 // 0xF4
	TIMING50      volatile.Register32 // 0xF8
	TIMING51      volatile.Register32 // 0xFC
	TIMING52      volatile.Register32 // 0x100
	TIMING53      volatile.Register32 // 0x104
	TIMING54      volatile.Register32 // 0x108
	TIMING55      volatile.Register32 // 0x10C
	TIMING56      volatile.Register32 // 0x110
	TIMING57      volatile.Register32 // 0x114
	TIMING58      volatile.Register32 // 0x118
}

// XCVR_PHY
type XCVR_PHY_Type struct {
	PHY_PRE_REF0 volatile.Register32 // 0x0
	PRE_REF1     volatile.Register32 // 0x4
	PRE_REF2     volatile.Register32 // 0x8
	_            [20]byte
	CFG1         volatile.Register32 // 0x20
	CFG2         volatile.Register32 // 0x24
	EL_CFG       volatile.Register32 // 0x28
	NTW_ADR_BSM  volatile.Register32 // 0x2C
	STATUS       volatile.Register32 // 0x30
}

// XCVR_ZBDEMOD
type XCVR_ZBDEM_Type struct {
	CORR_CTRL   volatile.Register32 // 0x0
	PN_TYPE     volatile.Register32 // 0x4
	PN_CODE     volatile.Register32 // 0x8
	SYNC_CTRL   volatile.Register32 // 0xC
	CCA_LQI_SRC volatile.Register32 // 0x10
	FAD_THR     volatile.Register32 // 0x14
	ZBDEM_AFC   volatile.Register32 // 0x18
}

// XCVR_ANALOG
type XCVR_ANA_Type struct {
	BB_LDO_1   volatile.Register32 // 0x0
	BB_LDO_2   volatile.Register32 // 0x4
	RX_ADC     volatile.Register32 // 0x8
	RX_BBA     volatile.Register32 // 0xC
	RX_LNA     volatile.Register32 // 0x10
	RX_TZA     volatile.Register32 // 0x14
	RX_AUXPLL  volatile.Register32 // 0x18
	SY_CTRL_1  volatile.Register32 // 0x1C
	SY_CTRL_2  volatile.Register32 // 0x20
	TX_DAC_PA  volatile.Register32 // 0x24
	BALUN_TX   volatile.Register32 // 0x28
	BALUN_RX   volatile.Register32 // 0x2C
	DFT_OBSV_1 volatile.Register32 // 0x30
	DFT_OBSV_2 volatile.Register32 // 0x34
}

// XCVR_PKT_RAM
type XCVR_PKT_RAM_Type struct {
	PACKET_RAM_0_0   volatile.Register16 // 0x0
	PACKET_RAM_0_1   volatile.Register16 // 0x2
	PACKET_RAM_0_2   volatile.Register16 // 0x4
	PACKET_RAM_0_3   volatile.Register16 // 0x6
	PACKET_RAM_0_4   volatile.Register16 // 0x8
	PACKET_RAM_0_5   volatile.Register16 // 0xA
	PACKET_RAM_0_6   volatile.Register16 // 0xC
	PACKET_RAM_0_7   volatile.Register16 // 0xE
	PACKET_RAM_0_8   volatile.Register16 // 0x10
	PACKET_RAM_0_9   volatile.Register16 // 0x12
	PACKET_RAM_0_10  volatile.Register16 // 0x14
	PACKET_RAM_0_11  volatile.Register16 // 0x16
	PACKET_RAM_0_12  volatile.Register16 // 0x18
	PACKET_RAM_0_13  volatile.Register16 // 0x1A
	PACKET_RAM_0_14  volatile.Register16 // 0x1C
	PACKET_RAM_0_15  volatile.Register16 // 0x1E
	PACKET_RAM_0_16  volatile.Register16 // 0x20
	PACKET_RAM_0_17  volatile.Register16 // 0x22
	PACKET_RAM_0_18  volatile.Register16 // 0x24
	PACKET_RAM_0_19  volatile.Register16 // 0x26
	PACKET_RAM_0_20  volatile.Register16 // 0x28
	PACKET_RAM_0_21  volatile.Register16 // 0x2A
	PACKET_RAM_0_22  volatile.Register16 // 0x2C
	PACKET_RAM_0_23  volatile.Register16 // 0x2E
	PACKET_RAM_0_24  volatile.Register16 // 0x30
	PACKET_RAM_0_25  volatile.Register16 // 0x32
	PACKET_RAM_0_26  volatile.Register16 // 0x34
	PACKET_RAM_0_27  volatile.Register16 // 0x36
	PACKET_RAM_0_28  volatile.Register16 // 0x38
	PACKET_RAM_0_29  volatile.Register16 // 0x3A
	PACKET_RAM_0_30  volatile.Register16 // 0x3C
	PACKET_RAM_0_31  volatile.Register16 // 0x3E
	PACKET_RAM_0_32  volatile.Register16 // 0x40
	PACKET_RAM_0_33  volatile.Register16 // 0x42
	PACKET_RAM_0_34  volatile.Register16 // 0x44
	PACKET_RAM_0_35  volatile.Register16 // 0x46
	PACKET_RAM_0_36  volatile.Register16 // 0x48
	PACKET_RAM_0_37  volatile.Register16 // 0x4A
	PACKET_RAM_0_38  volatile.Register16 // 0x4C
	PACKET_RAM_0_39  volatile.Register16 // 0x4E
	PACKET_RAM_0_40  volatile.Register16 // 0x50
	PACKET_RAM_0_41  volatile.Register16 // 0x52
	PACKET_RAM_0_42  volatile.Register16 // 0x54
	PACKET_RAM_0_43  volatile.Register16 // 0x56
	PACKET_RAM_0_44  volatile.Register16 // 0x58
	PACKET_RAM_0_45  volatile.Register16 // 0x5A
	PACKET_RAM_0_46  volatile.Register16 // 0x5C
	PACKET_RAM_0_47  volatile.Register16 // 0x5E
	PACKET_RAM_0_48  volatile.Register16 // 0x60
	PACKET_RAM_0_49  volatile.Register16 // 0x62
	PACKET_RAM_0_50  volatile.Register16 // 0x64
	PACKET_RAM_0_51  volatile.Register16 // 0x66
	PACKET_RAM_0_52  volatile.Register16 // 0x68
	PACKET_RAM_0_53  volatile.Register16 // 0x6A
	PACKET_RAM_0_54  volatile.Register16 // 0x6C
	PACKET_RAM_0_55  volatile.Register16 // 0x6E
	PACKET_RAM_0_56  volatile.Register16 // 0x70
	PACKET_RAM_0_57  volatile.Register16 // 0x72
	PACKET_RAM_0_58  volatile.Register16 // 0x74
	PACKET_RAM_0_59  volatile.Register16 // 0x76
	PACKET_RAM_0_60  volatile.Register16 // 0x78
	PACKET_RAM_0_61  volatile.Register16 // 0x7A
	PACKET_RAM_0_62  volatile.Register16 // 0x7C
	PACKET_RAM_0_63  volatile.Register16 // 0x7E
	PACKET_RAM_0_64  volatile.Register16 // 0x80
	PACKET_RAM_0_65  volatile.Register16 // 0x82
	PACKET_RAM_0_66  volatile.Register16 // 0x84
	PACKET_RAM_0_67  volatile.Register16 // 0x86
	PACKET_RAM_0_68  volatile.Register16 // 0x88
	PACKET_RAM_0_69  volatile.Register16 // 0x8A
	PACKET_RAM_0_70  volatile.Register16 // 0x8C
	PACKET_RAM_0_71  volatile.Register16 // 0x8E
	PACKET_RAM_0_72  volatile.Register16 // 0x90
	PACKET_RAM_0_73  volatile.Register16 // 0x92
	PACKET_RAM_0_74  volatile.Register16 // 0x94
	PACKET_RAM_0_75  volatile.Register16 // 0x96
	PACKET_RAM_0_76  volatile.Register16 // 0x98
	PACKET_RAM_0_77  volatile.Register16 // 0x9A
	PACKET_RAM_0_78  volatile.Register16 // 0x9C
	PACKET_RAM_0_79  volatile.Register16 // 0x9E
	PACKET_RAM_0_80  volatile.Register16 // 0xA0
	PACKET_RAM_0_81  volatile.Register16 // 0xA2
	PACKET_RAM_0_82  volatile.Register16 // 0xA4
	PACKET_RAM_0_83  volatile.Register16 // 0xA6
	PACKET_RAM_0_84  volatile.Register16 // 0xA8
	PACKET_RAM_0_85  volatile.Register16 // 0xAA
	PACKET_RAM_0_86  volatile.Register16 // 0xAC
	PACKET_RAM_0_87  volatile.Register16 // 0xAE
	PACKET_RAM_0_88  volatile.Register16 // 0xB0
	PACKET_RAM_0_89  volatile.Register16 // 0xB2
	PACKET_RAM_0_90  volatile.Register16 // 0xB4
	PACKET_RAM_0_91  volatile.Register16 // 0xB6
	PACKET_RAM_0_92  volatile.Register16 // 0xB8
	PACKET_RAM_0_93  volatile.Register16 // 0xBA
	PACKET_RAM_0_94  volatile.Register16 // 0xBC
	PACKET_RAM_0_95  volatile.Register16 // 0xBE
	PACKET_RAM_0_96  volatile.Register16 // 0xC0
	PACKET_RAM_0_97  volatile.Register16 // 0xC2
	PACKET_RAM_0_98  volatile.Register16 // 0xC4
	PACKET_RAM_0_99  volatile.Register16 // 0xC6
	PACKET_RAM_0_100 volatile.Register16 // 0xC8
	PACKET_RAM_0_101 volatile.Register16 // 0xCA
	PACKET_RAM_0_102 volatile.Register16 // 0xCC
	PACKET_RAM_0_103 volatile.Register16 // 0xCE
	PACKET_RAM_0_104 volatile.Register16 // 0xD0
	PACKET_RAM_0_105 volatile.Register16 // 0xD2
	PACKET_RAM_0_106 volatile.Register16 // 0xD4
	PACKET_RAM_0_107 volatile.Register16 // 0xD6
	PACKET_RAM_0_108 volatile.Register16 // 0xD8
	PACKET_RAM_0_109 volatile.Register16 // 0xDA
	PACKET_RAM_0_110 volatile.Register16 // 0xDC
	PACKET_RAM_0_111 volatile.Register16 // 0xDE
	PACKET_RAM_0_112 volatile.Register16 // 0xE0
	PACKET_RAM_0_113 volatile.Register16 // 0xE2
	PACKET_RAM_0_114 volatile.Register16 // 0xE4
	PACKET_RAM_0_115 volatile.Register16 // 0xE6
	PACKET_RAM_0_116 volatile.Register16 // 0xE8
	PACKET_RAM_0_117 volatile.Register16 // 0xEA
	PACKET_RAM_0_118 volatile.Register16 // 0xEC
	PACKET_RAM_0_119 volatile.Register16 // 0xEE
	PACKET_RAM_0_120 volatile.Register16 // 0xF0
	PACKET_RAM_0_121 volatile.Register16 // 0xF2
	PACKET_RAM_0_122 volatile.Register16 // 0xF4
	PACKET_RAM_0_123 volatile.Register16 // 0xF6
	PACKET_RAM_0_124 volatile.Register16 // 0xF8
	PACKET_RAM_0_125 volatile.Register16 // 0xFA
	PACKET_RAM_0_126 volatile.Register16 // 0xFC
	PACKET_RAM_0_127 volatile.Register16 // 0xFE
	PACKET_RAM_0_128 volatile.Register16 // 0x100
	PACKET_RAM_0_129 volatile.Register16 // 0x102
	PACKET_RAM_0_130 volatile.Register16 // 0x104
	PACKET_RAM_0_131 volatile.Register16 // 0x106
	PACKET_RAM_0_132 volatile.Register16 // 0x108
	PACKET_RAM_0_133 volatile.Register16 // 0x10A
	PACKET_RAM_0_134 volatile.Register16 // 0x10C
	PACKET_RAM_0_135 volatile.Register16 // 0x10E
	PACKET_RAM_0_136 volatile.Register16 // 0x110
	PACKET_RAM_0_137 volatile.Register16 // 0x112
	PACKET_RAM_0_138 volatile.Register16 // 0x114
	PACKET_RAM_0_139 volatile.Register16 // 0x116
	PACKET_RAM_0_140 volatile.Register16 // 0x118
	PACKET_RAM_0_141 volatile.Register16 // 0x11A
	PACKET_RAM_0_142 volatile.Register16 // 0x11C
	PACKET_RAM_0_143 volatile.Register16 // 0x11E
	PACKET_RAM_0_144 volatile.Register16 // 0x120
	PACKET_RAM_0_145 volatile.Register16 // 0x122
	PACKET_RAM_0_146 volatile.Register16 // 0x124
	PACKET_RAM_0_147 volatile.Register16 // 0x126
	PACKET_RAM_0_148 volatile.Register16 // 0x128
	PACKET_RAM_0_149 volatile.Register16 // 0x12A
	PACKET_RAM_0_150 volatile.Register16 // 0x12C
	PACKET_RAM_0_151 volatile.Register16 // 0x12E
	PACKET_RAM_0_152 volatile.Register16 // 0x130
	PACKET_RAM_0_153 volatile.Register16 // 0x132
	PACKET_RAM_0_154 volatile.Register16 // 0x134
	PACKET_RAM_0_155 volatile.Register16 // 0x136
	PACKET_RAM_0_156 volatile.Register16 // 0x138
	PACKET_RAM_0_157 volatile.Register16 // 0x13A
	PACKET_RAM_0_158 volatile.Register16 // 0x13C
	PACKET_RAM_0_159 volatile.Register16 // 0x13E
	PACKET_RAM_0_160 volatile.Register16 // 0x140
	PACKET_RAM_0_161 volatile.Register16 // 0x142
	PACKET_RAM_0_162 volatile.Register16 // 0x144
	PACKET_RAM_0_163 volatile.Register16 // 0x146
	PACKET_RAM_0_164 volatile.Register16 // 0x148
	PACKET_RAM_0_165 volatile.Register16 // 0x14A
	PACKET_RAM_0_166 volatile.Register16 // 0x14C
	PACKET_RAM_0_167 volatile.Register16 // 0x14E
	PACKET_RAM_0_168 volatile.Register16 // 0x150
	PACKET_RAM_0_169 volatile.Register16 // 0x152
	PACKET_RAM_0_170 volatile.Register16 // 0x154
	PACKET_RAM_0_171 volatile.Register16 // 0x156
	PACKET_RAM_0_172 volatile.Register16 // 0x158
	PACKET_RAM_0_173 volatile.Register16 // 0x15A
	PACKET_RAM_0_174 volatile.Register16 // 0x15C
	PACKET_RAM_0_175 volatile.Register16 // 0x15E
	PACKET_RAM_0_176 volatile.Register16 // 0x160
	PACKET_RAM_0_177 volatile.Register16 // 0x162
	PACKET_RAM_0_178 volatile.Register16 // 0x164
	PACKET_RAM_0_179 volatile.Register16 // 0x166
	PACKET_RAM_0_180 volatile.Register16 // 0x168
	PACKET_RAM_0_181 volatile.Register16 // 0x16A
	PACKET_RAM_0_182 volatile.Register16 // 0x16C
	PACKET_RAM_0_183 volatile.Register16 // 0x16E
	PACKET_RAM_0_184 volatile.Register16 // 0x170
	PACKET_RAM_0_185 volatile.Register16 // 0x172
	PACKET_RAM_0_186 volatile.Register16 // 0x174
	PACKET_RAM_0_187 volatile.Register16 // 0x176
	PACKET_RAM_0_188 volatile.Register16 // 0x178
	PACKET_RAM_0_189 volatile.Register16 // 0x17A
	PACKET_RAM_0_190 volatile.Register16 // 0x17C
	PACKET_RAM_0_191 volatile.Register16 // 0x17E
	PACKET_RAM_0_192 volatile.Register16 // 0x180
	PACKET_RAM_0_193 volatile.Register16 // 0x182
	PACKET_RAM_0_194 volatile.Register16 // 0x184
	PACKET_RAM_0_195 volatile.Register16 // 0x186
	PACKET_RAM_0_196 volatile.Register16 // 0x188
	PACKET_RAM_0_197 volatile.Register16 // 0x18A
	PACKET_RAM_0_198 volatile.Register16 // 0x18C
	PACKET_RAM_0_199 volatile.Register16 // 0x18E
	PACKET_RAM_0_200 volatile.Register16 // 0x190
	PACKET_RAM_0_201 volatile.Register16 // 0x192
	PACKET_RAM_0_202 volatile.Register16 // 0x194
	PACKET_RAM_0_203 volatile.Register16 // 0x196
	PACKET_RAM_0_204 volatile.Register16 // 0x198
	PACKET_RAM_0_205 volatile.Register16 // 0x19A
	PACKET_RAM_0_206 volatile.Register16 // 0x19C
	PACKET_RAM_0_207 volatile.Register16 // 0x19E
	PACKET_RAM_0_208 volatile.Register16 // 0x1A0
	PACKET_RAM_0_209 volatile.Register16 // 0x1A2
	PACKET_RAM_0_210 volatile.Register16 // 0x1A4
	PACKET_RAM_0_211 volatile.Register16 // 0x1A6
	PACKET_RAM_0_212 volatile.Register16 // 0x1A8
	PACKET_RAM_0_213 volatile.Register16 // 0x1AA
	PACKET_RAM_0_214 volatile.Register16 // 0x1AC
	PACKET_RAM_0_215 volatile.Register16 // 0x1AE
	PACKET_RAM_0_216 volatile.Register16 // 0x1B0
	PACKET_RAM_0_217 volatile.Register16 // 0x1B2
	PACKET_RAM_0_218 volatile.Register16 // 0x1B4
	PACKET_RAM_0_219 volatile.Register16 // 0x1B6
	PACKET_RAM_0_220 volatile.Register16 // 0x1B8
	PACKET_RAM_0_221 volatile.Register16 // 0x1BA
	PACKET_RAM_0_222 volatile.Register16 // 0x1BC
	PACKET_RAM_0_223 volatile.Register16 // 0x1BE
	PACKET_RAM_0_224 volatile.Register16 // 0x1C0
	PACKET_RAM_0_225 volatile.Register16 // 0x1C2
	PACKET_RAM_0_226 volatile.Register16 // 0x1C4
	PACKET_RAM_0_227 volatile.Register16 // 0x1C6
	PACKET_RAM_0_228 volatile.Register16 // 0x1C8
	PACKET_RAM_0_229 volatile.Register16 // 0x1CA
	PACKET_RAM_0_230 volatile.Register16 // 0x1CC
	PACKET_RAM_0_231 volatile.Register16 // 0x1CE
	PACKET_RAM_0_232 volatile.Register16 // 0x1D0
	PACKET_RAM_0_233 volatile.Register16 // 0x1D2
	PACKET_RAM_0_234 volatile.Register16 // 0x1D4
	PACKET_RAM_0_235 volatile.Register16 // 0x1D6
	PACKET_RAM_0_236 volatile.Register16 // 0x1D8
	PACKET_RAM_0_237 volatile.Register16 // 0x1DA
	PACKET_RAM_0_238 volatile.Register16 // 0x1DC
	PACKET_RAM_0_239 volatile.Register16 // 0x1DE
	PACKET_RAM_0_240 volatile.Register16 // 0x1E0
	PACKET_RAM_0_241 volatile.Register16 // 0x1E2
	PACKET_RAM_0_242 volatile.Register16 // 0x1E4
	PACKET_RAM_0_243 volatile.Register16 // 0x1E6
	PACKET_RAM_0_244 volatile.Register16 // 0x1E8
	PACKET_RAM_0_245 volatile.Register16 // 0x1EA
	PACKET_RAM_0_246 volatile.Register16 // 0x1EC
	PACKET_RAM_0_247 volatile.Register16 // 0x1EE
	PACKET_RAM_0_248 volatile.Register16 // 0x1F0
	PACKET_RAM_0_249 volatile.Register16 // 0x1F2
	PACKET_RAM_0_250 volatile.Register16 // 0x1F4
	PACKET_RAM_0_251 volatile.Register16 // 0x1F6
	PACKET_RAM_0_252 volatile.Register16 // 0x1F8
	PACKET_RAM_0_253 volatile.Register16 // 0x1FA
	PACKET_RAM_0_254 volatile.Register16 // 0x1FC
	PACKET_RAM_0_255 volatile.Register16 // 0x1FE
	PACKET_RAM_0_256 volatile.Register16 // 0x200
	PACKET_RAM_0_257 volatile.Register16 // 0x202
	PACKET_RAM_0_258 volatile.Register16 // 0x204
	PACKET_RAM_0_259 volatile.Register16 // 0x206
	PACKET_RAM_0_260 volatile.Register16 // 0x208
	PACKET_RAM_0_261 volatile.Register16 // 0x20A
	PACKET_RAM_0_262 volatile.Register16 // 0x20C
	PACKET_RAM_0_263 volatile.Register16 // 0x20E
	PACKET_RAM_0_264 volatile.Register16 // 0x210
	PACKET_RAM_0_265 volatile.Register16 // 0x212
	PACKET_RAM_0_266 volatile.Register16 // 0x214
	PACKET_RAM_0_267 volatile.Register16 // 0x216
	PACKET_RAM_0_268 volatile.Register16 // 0x218
	PACKET_RAM_0_269 volatile.Register16 // 0x21A
	PACKET_RAM_0_270 volatile.Register16 // 0x21C
	PACKET_RAM_0_271 volatile.Register16 // 0x21E
	PACKET_RAM_0_272 volatile.Register16 // 0x220
	PACKET_RAM_0_273 volatile.Register16 // 0x222
	PACKET_RAM_0_274 volatile.Register16 // 0x224
	PACKET_RAM_0_275 volatile.Register16 // 0x226
	PACKET_RAM_0_276 volatile.Register16 // 0x228
	PACKET_RAM_0_277 volatile.Register16 // 0x22A
	PACKET_RAM_0_278 volatile.Register16 // 0x22C
	PACKET_RAM_0_279 volatile.Register16 // 0x22E
	PACKET_RAM_0_280 volatile.Register16 // 0x230
	PACKET_RAM_0_281 volatile.Register16 // 0x232
	PACKET_RAM_0_282 volatile.Register16 // 0x234
	PACKET_RAM_0_283 volatile.Register16 // 0x236
	PACKET_RAM_0_284 volatile.Register16 // 0x238
	PACKET_RAM_0_285 volatile.Register16 // 0x23A
	PACKET_RAM_0_286 volatile.Register16 // 0x23C
	PACKET_RAM_0_287 volatile.Register16 // 0x23E
	PACKET_RAM_0_288 volatile.Register16 // 0x240
	PACKET_RAM_0_289 volatile.Register16 // 0x242
	PACKET_RAM_0_290 volatile.Register16 // 0x244
	PACKET_RAM_0_291 volatile.Register16 // 0x246
	PACKET_RAM_0_292 volatile.Register16 // 0x248
	PACKET_RAM_0_293 volatile.Register16 // 0x24A
	PACKET_RAM_0_294 volatile.Register16 // 0x24C
	PACKET_RAM_0_295 volatile.Register16 // 0x24E
	PACKET_RAM_0_296 volatile.Register16 // 0x250
	PACKET_RAM_0_297 volatile.Register16 // 0x252
	PACKET_RAM_0_298 volatile.Register16 // 0x254
	PACKET_RAM_0_299 volatile.Register16 // 0x256
	PACKET_RAM_0_300 volatile.Register16 // 0x258
	PACKET_RAM_0_301 volatile.Register16 // 0x25A
	PACKET_RAM_0_302 volatile.Register16 // 0x25C
	PACKET_RAM_0_303 volatile.Register16 // 0x25E
	PACKET_RAM_0_304 volatile.Register16 // 0x260
	PACKET_RAM_0_305 volatile.Register16 // 0x262
	PACKET_RAM_0_306 volatile.Register16 // 0x264
	PACKET_RAM_0_307 volatile.Register16 // 0x266
	PACKET_RAM_0_308 volatile.Register16 // 0x268
	PACKET_RAM_0_309 volatile.Register16 // 0x26A
	PACKET_RAM_0_310 volatile.Register16 // 0x26C
	PACKET_RAM_0_311 volatile.Register16 // 0x26E
	PACKET_RAM_0_312 volatile.Register16 // 0x270
	PACKET_RAM_0_313 volatile.Register16 // 0x272
	PACKET_RAM_0_314 volatile.Register16 // 0x274
	PACKET_RAM_0_315 volatile.Register16 // 0x276
	PACKET_RAM_0_316 volatile.Register16 // 0x278
	PACKET_RAM_0_317 volatile.Register16 // 0x27A
	PACKET_RAM_0_318 volatile.Register16 // 0x27C
	PACKET_RAM_0_319 volatile.Register16 // 0x27E
	PACKET_RAM_0_320 volatile.Register16 // 0x280
	PACKET_RAM_0_321 volatile.Register16 // 0x282
	PACKET_RAM_0_322 volatile.Register16 // 0x284
	PACKET_RAM_0_323 volatile.Register16 // 0x286
	PACKET_RAM_0_324 volatile.Register16 // 0x288
	PACKET_RAM_0_325 volatile.Register16 // 0x28A
	PACKET_RAM_0_326 volatile.Register16 // 0x28C
	PACKET_RAM_0_327 volatile.Register16 // 0x28E
	PACKET_RAM_0_328 volatile.Register16 // 0x290
	PACKET_RAM_0_329 volatile.Register16 // 0x292
	PACKET_RAM_0_330 volatile.Register16 // 0x294
	PACKET_RAM_0_331 volatile.Register16 // 0x296
	PACKET_RAM_0_332 volatile.Register16 // 0x298
	PACKET_RAM_0_333 volatile.Register16 // 0x29A
	PACKET_RAM_0_334 volatile.Register16 // 0x29C
	PACKET_RAM_0_335 volatile.Register16 // 0x29E
	PACKET_RAM_0_336 volatile.Register16 // 0x2A0
	PACKET_RAM_0_337 volatile.Register16 // 0x2A2
	PACKET_RAM_0_338 volatile.Register16 // 0x2A4
	PACKET_RAM_0_339 volatile.Register16 // 0x2A6
	PACKET_RAM_0_340 volatile.Register16 // 0x2A8
	PACKET_RAM_0_341 volatile.Register16 // 0x2AA
	PACKET_RAM_0_342 volatile.Register16 // 0x2AC
	PACKET_RAM_0_343 volatile.Register16 // 0x2AE
	PACKET_RAM_0_344 volatile.Register16 // 0x2B0
	PACKET_RAM_0_345 volatile.Register16 // 0x2B2
	PACKET_RAM_0_346 volatile.Register16 // 0x2B4
	PACKET_RAM_0_347 volatile.Register16 // 0x2B6
	PACKET_RAM_0_348 volatile.Register16 // 0x2B8
	PACKET_RAM_0_349 volatile.Register16 // 0x2BA
	PACKET_RAM_0_350 volatile.Register16 // 0x2BC
	PACKET_RAM_0_351 volatile.Register16 // 0x2BE
	PACKET_RAM_0_352 volatile.Register16 // 0x2C0
	PACKET_RAM_0_353 volatile.Register16 // 0x2C2
	PACKET_RAM_0_354 volatile.Register16 // 0x2C4
	PACKET_RAM_0_355 volatile.Register16 // 0x2C6
	PACKET_RAM_0_356 volatile.Register16 // 0x2C8
	PACKET_RAM_0_357 volatile.Register16 // 0x2CA
	PACKET_RAM_0_358 volatile.Register16 // 0x2CC
	PACKET_RAM_0_359 volatile.Register16 // 0x2CE
	PACKET_RAM_0_360 volatile.Register16 // 0x2D0
	PACKET_RAM_0_361 volatile.Register16 // 0x2D2
	PACKET_RAM_0_362 volatile.Register16 // 0x2D4
	PACKET_RAM_0_363 volatile.Register16 // 0x2D6
	PACKET_RAM_0_364 volatile.Register16 // 0x2D8
	PACKET_RAM_0_365 volatile.Register16 // 0x2DA
	PACKET_RAM_0_366 volatile.Register16 // 0x2DC
	PACKET_RAM_0_367 volatile.Register16 // 0x2DE
	PACKET_RAM_0_368 volatile.Register16 // 0x2E0
	PACKET_RAM_0_369 volatile.Register16 // 0x2E2
	PACKET_RAM_0_370 volatile.Register16 // 0x2E4
	PACKET_RAM_0_371 volatile.Register16 // 0x2E6
	PACKET_RAM_0_372 volatile.Register16 // 0x2E8
	PACKET_RAM_0_373 volatile.Register16 // 0x2EA
	PACKET_RAM_0_374 volatile.Register16 // 0x2EC
	PACKET_RAM_0_375 volatile.Register16 // 0x2EE
	PACKET_RAM_0_376 volatile.Register16 // 0x2F0
	PACKET_RAM_0_377 volatile.Register16 // 0x2F2
	PACKET_RAM_0_378 volatile.Register16 // 0x2F4
	PACKET_RAM_0_379 volatile.Register16 // 0x2F6
	PACKET_RAM_0_380 volatile.Register16 // 0x2F8
	PACKET_RAM_0_381 volatile.Register16 // 0x2FA
	PACKET_RAM_0_382 volatile.Register16 // 0x2FC
	PACKET_RAM_0_383 volatile.Register16 // 0x2FE
	PACKET_RAM_0_384 volatile.Register16 // 0x300
	PACKET_RAM_0_385 volatile.Register16 // 0x302
	PACKET_RAM_0_386 volatile.Register16 // 0x304
	PACKET_RAM_0_387 volatile.Register16 // 0x306
	PACKET_RAM_0_388 volatile.Register16 // 0x308
	PACKET_RAM_0_389 volatile.Register16 // 0x30A
	PACKET_RAM_0_390 volatile.Register16 // 0x30C
	PACKET_RAM_0_391 volatile.Register16 // 0x30E
	PACKET_RAM_0_392 volatile.Register16 // 0x310
	PACKET_RAM_0_393 volatile.Register16 // 0x312
	PACKET_RAM_0_394 volatile.Register16 // 0x314
	PACKET_RAM_0_395 volatile.Register16 // 0x316
	PACKET_RAM_0_396 volatile.Register16 // 0x318
	PACKET_RAM_0_397 volatile.Register16 // 0x31A
	PACKET_RAM_0_398 volatile.Register16 // 0x31C
	PACKET_RAM_0_399 volatile.Register16 // 0x31E
	PACKET_RAM_0_400 volatile.Register16 // 0x320
	PACKET_RAM_0_401 volatile.Register16 // 0x322
	PACKET_RAM_0_402 volatile.Register16 // 0x324
	PACKET_RAM_0_403 volatile.Register16 // 0x326
	PACKET_RAM_0_404 volatile.Register16 // 0x328
	PACKET_RAM_0_405 volatile.Register16 // 0x32A
	PACKET_RAM_0_406 volatile.Register16 // 0x32C
	PACKET_RAM_0_407 volatile.Register16 // 0x32E
	PACKET_RAM_0_408 volatile.Register16 // 0x330
	PACKET_RAM_0_409 volatile.Register16 // 0x332
	PACKET_RAM_0_410 volatile.Register16 // 0x334
	PACKET_RAM_0_411 volatile.Register16 // 0x336
	PACKET_RAM_0_412 volatile.Register16 // 0x338
	PACKET_RAM_0_413 volatile.Register16 // 0x33A
	PACKET_RAM_0_414 volatile.Register16 // 0x33C
	PACKET_RAM_0_415 volatile.Register16 // 0x33E
	PACKET_RAM_0_416 volatile.Register16 // 0x340
	PACKET_RAM_0_417 volatile.Register16 // 0x342
	PACKET_RAM_0_418 volatile.Register16 // 0x344
	PACKET_RAM_0_419 volatile.Register16 // 0x346
	PACKET_RAM_0_420 volatile.Register16 // 0x348
	PACKET_RAM_0_421 volatile.Register16 // 0x34A
	PACKET_RAM_0_422 volatile.Register16 // 0x34C
	PACKET_RAM_0_423 volatile.Register16 // 0x34E
	PACKET_RAM_0_424 volatile.Register16 // 0x350
	PACKET_RAM_0_425 volatile.Register16 // 0x352
	PACKET_RAM_0_426 volatile.Register16 // 0x354
	PACKET_RAM_0_427 volatile.Register16 // 0x356
	PACKET_RAM_0_428 volatile.Register16 // 0x358
	PACKET_RAM_0_429 volatile.Register16 // 0x35A
	PACKET_RAM_0_430 volatile.Register16 // 0x35C
	PACKET_RAM_0_431 volatile.Register16 // 0x35E
	PACKET_RAM_0_432 volatile.Register16 // 0x360
	PACKET_RAM_0_433 volatile.Register16 // 0x362
	PACKET_RAM_0_434 volatile.Register16 // 0x364
	PACKET_RAM_0_435 volatile.Register16 // 0x366
	PACKET_RAM_0_436 volatile.Register16 // 0x368
	PACKET_RAM_0_437 volatile.Register16 // 0x36A
	PACKET_RAM_0_438 volatile.Register16 // 0x36C
	PACKET_RAM_0_439 volatile.Register16 // 0x36E
	PACKET_RAM_0_440 volatile.Register16 // 0x370
	PACKET_RAM_0_441 volatile.Register16 // 0x372
	PACKET_RAM_0_442 volatile.Register16 // 0x374
	PACKET_RAM_0_443 volatile.Register16 // 0x376
	PACKET_RAM_0_444 volatile.Register16 // 0x378
	PACKET_RAM_0_445 volatile.Register16 // 0x37A
	PACKET_RAM_0_446 volatile.Register16 // 0x37C
	PACKET_RAM_0_447 volatile.Register16 // 0x37E
	PACKET_RAM_0_448 volatile.Register16 // 0x380
	PACKET_RAM_0_449 volatile.Register16 // 0x382
	PACKET_RAM_0_450 volatile.Register16 // 0x384
	PACKET_RAM_0_451 volatile.Register16 // 0x386
	PACKET_RAM_0_452 volatile.Register16 // 0x388
	PACKET_RAM_0_453 volatile.Register16 // 0x38A
	PACKET_RAM_0_454 volatile.Register16 // 0x38C
	PACKET_RAM_0_455 volatile.Register16 // 0x38E
	PACKET_RAM_0_456 volatile.Register16 // 0x390
	PACKET_RAM_0_457 volatile.Register16 // 0x392
	PACKET_RAM_0_458 volatile.Register16 // 0x394
	PACKET_RAM_0_459 volatile.Register16 // 0x396
	PACKET_RAM_0_460 volatile.Register16 // 0x398
	PACKET_RAM_0_461 volatile.Register16 // 0x39A
	PACKET_RAM_0_462 volatile.Register16 // 0x39C
	PACKET_RAM_0_463 volatile.Register16 // 0x39E
	PACKET_RAM_0_464 volatile.Register16 // 0x3A0
	PACKET_RAM_0_465 volatile.Register16 // 0x3A2
	PACKET_RAM_0_466 volatile.Register16 // 0x3A4
	PACKET_RAM_0_467 volatile.Register16 // 0x3A6
	PACKET_RAM_0_468 volatile.Register16 // 0x3A8
	PACKET_RAM_0_469 volatile.Register16 // 0x3AA
	PACKET_RAM_0_470 volatile.Register16 // 0x3AC
	PACKET_RAM_0_471 volatile.Register16 // 0x3AE
	PACKET_RAM_0_472 volatile.Register16 // 0x3B0
	PACKET_RAM_0_473 volatile.Register16 // 0x3B2
	PACKET_RAM_0_474 volatile.Register16 // 0x3B4
	PACKET_RAM_0_475 volatile.Register16 // 0x3B6
	PACKET_RAM_0_476 volatile.Register16 // 0x3B8
	PACKET_RAM_0_477 volatile.Register16 // 0x3BA
	PACKET_RAM_0_478 volatile.Register16 // 0x3BC
	PACKET_RAM_0_479 volatile.Register16 // 0x3BE
	PACKET_RAM_0_480 volatile.Register16 // 0x3C0
	PACKET_RAM_0_481 volatile.Register16 // 0x3C2
	PACKET_RAM_0_482 volatile.Register16 // 0x3C4
	PACKET_RAM_0_483 volatile.Register16 // 0x3C6
	PACKET_RAM_0_484 volatile.Register16 // 0x3C8
	PACKET_RAM_0_485 volatile.Register16 // 0x3CA
	PACKET_RAM_0_486 volatile.Register16 // 0x3CC
	PACKET_RAM_0_487 volatile.Register16 // 0x3CE
	PACKET_RAM_0_488 volatile.Register16 // 0x3D0
	PACKET_RAM_0_489 volatile.Register16 // 0x3D2
	PACKET_RAM_0_490 volatile.Register16 // 0x3D4
	PACKET_RAM_0_491 volatile.Register16 // 0x3D6
	PACKET_RAM_0_492 volatile.Register16 // 0x3D8
	PACKET_RAM_0_493 volatile.Register16 // 0x3DA
	PACKET_RAM_0_494 volatile.Register16 // 0x3DC
	PACKET_RAM_0_495 volatile.Register16 // 0x3DE
	PACKET_RAM_0_496 volatile.Register16 // 0x3E0
	PACKET_RAM_0_497 volatile.Register16 // 0x3E2
	PACKET_RAM_0_498 volatile.Register16 // 0x3E4
	PACKET_RAM_0_499 volatile.Register16 // 0x3E6
	PACKET_RAM_0_500 volatile.Register16 // 0x3E8
	PACKET_RAM_0_501 volatile.Register16 // 0x3EA
	PACKET_RAM_0_502 volatile.Register16 // 0x3EC
	PACKET_RAM_0_503 volatile.Register16 // 0x3EE
	PACKET_RAM_0_504 volatile.Register16 // 0x3F0
	PACKET_RAM_0_505 volatile.Register16 // 0x3F2
	PACKET_RAM_0_506 volatile.Register16 // 0x3F4
	PACKET_RAM_0_507 volatile.Register16 // 0x3F6
	PACKET_RAM_0_508 volatile.Register16 // 0x3F8
	PACKET_RAM_0_509 volatile.Register16 // 0x3FA
	PACKET_RAM_0_510 volatile.Register16 // 0x3FC
	PACKET_RAM_0_511 volatile.Register16 // 0x3FE
	PACKET_RAM_0_512 volatile.Register16 // 0x400
	PACKET_RAM_0_513 volatile.Register16 // 0x402
	PACKET_RAM_0_514 volatile.Register16 // 0x404
	PACKET_RAM_0_515 volatile.Register16 // 0x406
	PACKET_RAM_0_516 volatile.Register16 // 0x408
	PACKET_RAM_0_517 volatile.Register16 // 0x40A
	PACKET_RAM_0_518 volatile.Register16 // 0x40C
	PACKET_RAM_0_519 volatile.Register16 // 0x40E
	PACKET_RAM_0_520 volatile.Register16 // 0x410
	PACKET_RAM_0_521 volatile.Register16 // 0x412
	PACKET_RAM_0_522 volatile.Register16 // 0x414
	PACKET_RAM_0_523 volatile.Register16 // 0x416
	PACKET_RAM_0_524 volatile.Register16 // 0x418
	PACKET_RAM_0_525 volatile.Register16 // 0x41A
	PACKET_RAM_0_526 volatile.Register16 // 0x41C
	PACKET_RAM_0_527 volatile.Register16 // 0x41E
	PACKET_RAM_0_528 volatile.Register16 // 0x420
	PACKET_RAM_0_529 volatile.Register16 // 0x422
	PACKET_RAM_0_530 volatile.Register16 // 0x424
	PACKET_RAM_0_531 volatile.Register16 // 0x426
	PACKET_RAM_0_532 volatile.Register16 // 0x428
	PACKET_RAM_0_533 volatile.Register16 // 0x42A
	PACKET_RAM_0_534 volatile.Register16 // 0x42C
	PACKET_RAM_0_535 volatile.Register16 // 0x42E
	PACKET_RAM_0_536 volatile.Register16 // 0x430
	PACKET_RAM_0_537 volatile.Register16 // 0x432
	PACKET_RAM_0_538 volatile.Register16 // 0x434
	PACKET_RAM_0_539 volatile.Register16 // 0x436
	PACKET_RAM_0_540 volatile.Register16 // 0x438
	PACKET_RAM_0_541 volatile.Register16 // 0x43A
	PACKET_RAM_0_542 volatile.Register16 // 0x43C
	PACKET_RAM_0_543 volatile.Register16 // 0x43E
	PACKET_RAM_1_0   volatile.Register16 // 0x440
	PACKET_RAM_1_1   volatile.Register16 // 0x442
	PACKET_RAM_1_2   volatile.Register16 // 0x444
	PACKET_RAM_1_3   volatile.Register16 // 0x446
	PACKET_RAM_1_4   volatile.Register16 // 0x448
	PACKET_RAM_1_5   volatile.Register16 // 0x44A
	PACKET_RAM_1_6   volatile.Register16 // 0x44C
	PACKET_RAM_1_7   volatile.Register16 // 0x44E
	PACKET_RAM_1_8   volatile.Register16 // 0x450
	PACKET_RAM_1_9   volatile.Register16 // 0x452
	PACKET_RAM_1_10  volatile.Register16 // 0x454
	PACKET_RAM_1_11  volatile.Register16 // 0x456
	PACKET_RAM_1_12  volatile.Register16 // 0x458
	PACKET_RAM_1_13  volatile.Register16 // 0x45A
	PACKET_RAM_1_14  volatile.Register16 // 0x45C
	PACKET_RAM_1_15  volatile.Register16 // 0x45E
	PACKET_RAM_1_16  volatile.Register16 // 0x460
	PACKET_RAM_1_17  volatile.Register16 // 0x462
	PACKET_RAM_1_18  volatile.Register16 // 0x464
	PACKET_RAM_1_19  volatile.Register16 // 0x466
	PACKET_RAM_1_20  volatile.Register16 // 0x468
	PACKET_RAM_1_21  volatile.Register16 // 0x46A
	PACKET_RAM_1_22  volatile.Register16 // 0x46C
	PACKET_RAM_1_23  volatile.Register16 // 0x46E
	PACKET_RAM_1_24  volatile.Register16 // 0x470
	PACKET_RAM_1_25  volatile.Register16 // 0x472
	PACKET_RAM_1_26  volatile.Register16 // 0x474
	PACKET_RAM_1_27  volatile.Register16 // 0x476
	PACKET_RAM_1_28  volatile.Register16 // 0x478
	PACKET_RAM_1_29  volatile.Register16 // 0x47A
	PACKET_RAM_1_30  volatile.Register16 // 0x47C
	PACKET_RAM_1_31  volatile.Register16 // 0x47E
	PACKET_RAM_1_32  volatile.Register16 // 0x480
	PACKET_RAM_1_33  volatile.Register16 // 0x482
	PACKET_RAM_1_34  volatile.Register16 // 0x484
	PACKET_RAM_1_35  volatile.Register16 // 0x486
	PACKET_RAM_1_36  volatile.Register16 // 0x488
	PACKET_RAM_1_37  volatile.Register16 // 0x48A
	PACKET_RAM_1_38  volatile.Register16 // 0x48C
	PACKET_RAM_1_39  volatile.Register16 // 0x48E
	PACKET_RAM_1_40  volatile.Register16 // 0x490
	PACKET_RAM_1_41  volatile.Register16 // 0x492
	PACKET_RAM_1_42  volatile.Register16 // 0x494
	PACKET_RAM_1_43  volatile.Register16 // 0x496
	PACKET_RAM_1_44  volatile.Register16 // 0x498
	PACKET_RAM_1_45  volatile.Register16 // 0x49A
	PACKET_RAM_1_46  volatile.Register16 // 0x49C
	PACKET_RAM_1_47  volatile.Register16 // 0x49E
	PACKET_RAM_1_48  volatile.Register16 // 0x4A0
	PACKET_RAM_1_49  volatile.Register16 // 0x4A2
	PACKET_RAM_1_50  volatile.Register16 // 0x4A4
	PACKET_RAM_1_51  volatile.Register16 // 0x4A6
	PACKET_RAM_1_52  volatile.Register16 // 0x4A8
	PACKET_RAM_1_53  volatile.Register16 // 0x4AA
	PACKET_RAM_1_54  volatile.Register16 // 0x4AC
	PACKET_RAM_1_55  volatile.Register16 // 0x4AE
	PACKET_RAM_1_56  volatile.Register16 // 0x4B0
	PACKET_RAM_1_57  volatile.Register16 // 0x4B2
	PACKET_RAM_1_58  volatile.Register16 // 0x4B4
	PACKET_RAM_1_59  volatile.Register16 // 0x4B6
	PACKET_RAM_1_60  volatile.Register16 // 0x4B8
	PACKET_RAM_1_61  volatile.Register16 // 0x4BA
	PACKET_RAM_1_62  volatile.Register16 // 0x4BC
	PACKET_RAM_1_63  volatile.Register16 // 0x4BE
	PACKET_RAM_1_64  volatile.Register16 // 0x4C0
	PACKET_RAM_1_65  volatile.Register16 // 0x4C2
	PACKET_RAM_1_66  volatile.Register16 // 0x4C4
	PACKET_RAM_1_67  volatile.Register16 // 0x4C6
	PACKET_RAM_1_68  volatile.Register16 // 0x4C8
	PACKET_RAM_1_69  volatile.Register16 // 0x4CA
	PACKET_RAM_1_70  volatile.Register16 // 0x4CC
	PACKET_RAM_1_71  volatile.Register16 // 0x4CE
	PACKET_RAM_1_72  volatile.Register16 // 0x4D0
	PACKET_RAM_1_73  volatile.Register16 // 0x4D2
	PACKET_RAM_1_74  volatile.Register16 // 0x4D4
	PACKET_RAM_1_75  volatile.Register16 // 0x4D6
	PACKET_RAM_1_76  volatile.Register16 // 0x4D8
	PACKET_RAM_1_77  volatile.Register16 // 0x4DA
	PACKET_RAM_1_78  volatile.Register16 // 0x4DC
	PACKET_RAM_1_79  volatile.Register16 // 0x4DE
	PACKET_RAM_1_80  volatile.Register16 // 0x4E0
	PACKET_RAM_1_81  volatile.Register16 // 0x4E2
	PACKET_RAM_1_82  volatile.Register16 // 0x4E4
	PACKET_RAM_1_83  volatile.Register16 // 0x4E6
	PACKET_RAM_1_84  volatile.Register16 // 0x4E8
	PACKET_RAM_1_85  volatile.Register16 // 0x4EA
	PACKET_RAM_1_86  volatile.Register16 // 0x4EC
	PACKET_RAM_1_87  volatile.Register16 // 0x4EE
	PACKET_RAM_1_88  volatile.Register16 // 0x4F0
	PACKET_RAM_1_89  volatile.Register16 // 0x4F2
	PACKET_RAM_1_90  volatile.Register16 // 0x4F4
	PACKET_RAM_1_91  volatile.Register16 // 0x4F6
	PACKET_RAM_1_92  volatile.Register16 // 0x4F8
	PACKET_RAM_1_93  volatile.Register16 // 0x4FA
	PACKET_RAM_1_94  volatile.Register16 // 0x4FC
	PACKET_RAM_1_95  volatile.Register16 // 0x4FE
	PACKET_RAM_1_96  volatile.Register16 // 0x500
	PACKET_RAM_1_97  volatile.Register16 // 0x502
	PACKET_RAM_1_98  volatile.Register16 // 0x504
	PACKET_RAM_1_99  volatile.Register16 // 0x506
	PACKET_RAM_1_100 volatile.Register16 // 0x508
	PACKET_RAM_1_101 volatile.Register16 // 0x50A
	PACKET_RAM_1_102 volatile.Register16 // 0x50C
	PACKET_RAM_1_103 volatile.Register16 // 0x50E
	PACKET_RAM_1_104 volatile.Register16 // 0x510
	PACKET_RAM_1_105 volatile.Register16 // 0x512
	PACKET_RAM_1_106 volatile.Register16 // 0x514
	PACKET_RAM_1_107 volatile.Register16 // 0x516
	PACKET_RAM_1_108 volatile.Register16 // 0x518
	PACKET_RAM_1_109 volatile.Register16 // 0x51A
	PACKET_RAM_1_110 volatile.Register16 // 0x51C
	PACKET_RAM_1_111 volatile.Register16 // 0x51E
	PACKET_RAM_1_112 volatile.Register16 // 0x520
	PACKET_RAM_1_113 volatile.Register16 // 0x522
	PACKET_RAM_1_114 volatile.Register16 // 0x524
	PACKET_RAM_1_115 volatile.Register16 // 0x526
	PACKET_RAM_1_116 volatile.Register16 // 0x528
	PACKET_RAM_1_117 volatile.Register16 // 0x52A
	PACKET_RAM_1_118 volatile.Register16 // 0x52C
	PACKET_RAM_1_119 volatile.Register16 // 0x52E
	PACKET_RAM_1_120 volatile.Register16 // 0x530
	PACKET_RAM_1_121 volatile.Register16 // 0x532
	PACKET_RAM_1_122 volatile.Register16 // 0x534
	PACKET_RAM_1_123 volatile.Register16 // 0x536
	PACKET_RAM_1_124 volatile.Register16 // 0x538
	PACKET_RAM_1_125 volatile.Register16 // 0x53A
	PACKET_RAM_1_126 volatile.Register16 // 0x53C
	PACKET_RAM_1_127 volatile.Register16 // 0x53E
	PACKET_RAM_1_128 volatile.Register16 // 0x540
	PACKET_RAM_1_129 volatile.Register16 // 0x542
	PACKET_RAM_1_130 volatile.Register16 // 0x544
	PACKET_RAM_1_131 volatile.Register16 // 0x546
	PACKET_RAM_1_132 volatile.Register16 // 0x548
	PACKET_RAM_1_133 volatile.Register16 // 0x54A
	PACKET_RAM_1_134 volatile.Register16 // 0x54C
	PACKET_RAM_1_135 volatile.Register16 // 0x54E
	PACKET_RAM_1_136 volatile.Register16 // 0x550
	PACKET_RAM_1_137 volatile.Register16 // 0x552
	PACKET_RAM_1_138 volatile.Register16 // 0x554
	PACKET_RAM_1_139 volatile.Register16 // 0x556
	PACKET_RAM_1_140 volatile.Register16 // 0x558
	PACKET_RAM_1_141 volatile.Register16 // 0x55A
	PACKET_RAM_1_142 volatile.Register16 // 0x55C
	PACKET_RAM_1_143 volatile.Register16 // 0x55E
	PACKET_RAM_1_144 volatile.Register16 // 0x560
	PACKET_RAM_1_145 volatile.Register16 // 0x562
	PACKET_RAM_1_146 volatile.Register16 // 0x564
	PACKET_RAM_1_147 volatile.Register16 // 0x566
	PACKET_RAM_1_148 volatile.Register16 // 0x568
	PACKET_RAM_1_149 volatile.Register16 // 0x56A
	PACKET_RAM_1_150 volatile.Register16 // 0x56C
	PACKET_RAM_1_151 volatile.Register16 // 0x56E
	PACKET_RAM_1_152 volatile.Register16 // 0x570
	PACKET_RAM_1_153 volatile.Register16 // 0x572
	PACKET_RAM_1_154 volatile.Register16 // 0x574
	PACKET_RAM_1_155 volatile.Register16 // 0x576
	PACKET_RAM_1_156 volatile.Register16 // 0x578
	PACKET_RAM_1_157 volatile.Register16 // 0x57A
	PACKET_RAM_1_158 volatile.Register16 // 0x57C
	PACKET_RAM_1_159 volatile.Register16 // 0x57E
	PACKET_RAM_1_160 volatile.Register16 // 0x580
	PACKET_RAM_1_161 volatile.Register16 // 0x582
	PACKET_RAM_1_162 volatile.Register16 // 0x584
	PACKET_RAM_1_163 volatile.Register16 // 0x586
	PACKET_RAM_1_164 volatile.Register16 // 0x588
	PACKET_RAM_1_165 volatile.Register16 // 0x58A
	PACKET_RAM_1_166 volatile.Register16 // 0x58C
	PACKET_RAM_1_167 volatile.Register16 // 0x58E
	PACKET_RAM_1_168 volatile.Register16 // 0x590
	PACKET_RAM_1_169 volatile.Register16 // 0x592
	PACKET_RAM_1_170 volatile.Register16 // 0x594
	PACKET_RAM_1_171 volatile.Register16 // 0x596
	PACKET_RAM_1_172 volatile.Register16 // 0x598
	PACKET_RAM_1_173 volatile.Register16 // 0x59A
	PACKET_RAM_1_174 volatile.Register16 // 0x59C
	PACKET_RAM_1_175 volatile.Register16 // 0x59E
	PACKET_RAM_1_176 volatile.Register16 // 0x5A0
	PACKET_RAM_1_177 volatile.Register16 // 0x5A2
	PACKET_RAM_1_178 volatile.Register16 // 0x5A4
	PACKET_RAM_1_179 volatile.Register16 // 0x5A6
	PACKET_RAM_1_180 volatile.Register16 // 0x5A8
	PACKET_RAM_1_181 volatile.Register16 // 0x5AA
	PACKET_RAM_1_182 volatile.Register16 // 0x5AC
	PACKET_RAM_1_183 volatile.Register16 // 0x5AE
	PACKET_RAM_1_184 volatile.Register16 // 0x5B0
	PACKET_RAM_1_185 volatile.Register16 // 0x5B2
	PACKET_RAM_1_186 volatile.Register16 // 0x5B4
	PACKET_RAM_1_187 volatile.Register16 // 0x5B6
	PACKET_RAM_1_188 volatile.Register16 // 0x5B8
	PACKET_RAM_1_189 volatile.Register16 // 0x5BA
	PACKET_RAM_1_190 volatile.Register16 // 0x5BC
	PACKET_RAM_1_191 volatile.Register16 // 0x5BE
	PACKET_RAM_1_192 volatile.Register16 // 0x5C0
	PACKET_RAM_1_193 volatile.Register16 // 0x5C2
	PACKET_RAM_1_194 volatile.Register16 // 0x5C4
	PACKET_RAM_1_195 volatile.Register16 // 0x5C6
	PACKET_RAM_1_196 volatile.Register16 // 0x5C8
	PACKET_RAM_1_197 volatile.Register16 // 0x5CA
	PACKET_RAM_1_198 volatile.Register16 // 0x5CC
	PACKET_RAM_1_199 volatile.Register16 // 0x5CE
	PACKET_RAM_1_200 volatile.Register16 // 0x5D0
	PACKET_RAM_1_201 volatile.Register16 // 0x5D2
	PACKET_RAM_1_202 volatile.Register16 // 0x5D4
	PACKET_RAM_1_203 volatile.Register16 // 0x5D6
	PACKET_RAM_1_204 volatile.Register16 // 0x5D8
	PACKET_RAM_1_205 volatile.Register16 // 0x5DA
	PACKET_RAM_1_206 volatile.Register16 // 0x5DC
	PACKET_RAM_1_207 volatile.Register16 // 0x5DE
	PACKET_RAM_1_208 volatile.Register16 // 0x5E0
	PACKET_RAM_1_209 volatile.Register16 // 0x5E2
	PACKET_RAM_1_210 volatile.Register16 // 0x5E4
	PACKET_RAM_1_211 volatile.Register16 // 0x5E6
	PACKET_RAM_1_212 volatile.Register16 // 0x5E8
	PACKET_RAM_1_213 volatile.Register16 // 0x5EA
	PACKET_RAM_1_214 volatile.Register16 // 0x5EC
	PACKET_RAM_1_215 volatile.Register16 // 0x5EE
	PACKET_RAM_1_216 volatile.Register16 // 0x5F0
	PACKET_RAM_1_217 volatile.Register16 // 0x5F2
	PACKET_RAM_1_218 volatile.Register16 // 0x5F4
	PACKET_RAM_1_219 volatile.Register16 // 0x5F6
	PACKET_RAM_1_220 volatile.Register16 // 0x5F8
	PACKET_RAM_1_221 volatile.Register16 // 0x5FA
	PACKET_RAM_1_222 volatile.Register16 // 0x5FC
	PACKET_RAM_1_223 volatile.Register16 // 0x5FE
	PACKET_RAM_1_224 volatile.Register16 // 0x600
	PACKET_RAM_1_225 volatile.Register16 // 0x602
	PACKET_RAM_1_226 volatile.Register16 // 0x604
	PACKET_RAM_1_227 volatile.Register16 // 0x606
	PACKET_RAM_1_228 volatile.Register16 // 0x608
	PACKET_RAM_1_229 volatile.Register16 // 0x60A
	PACKET_RAM_1_230 volatile.Register16 // 0x60C
	PACKET_RAM_1_231 volatile.Register16 // 0x60E
	PACKET_RAM_1_232 volatile.Register16 // 0x610
	PACKET_RAM_1_233 volatile.Register16 // 0x612
	PACKET_RAM_1_234 volatile.Register16 // 0x614
	PACKET_RAM_1_235 volatile.Register16 // 0x616
	PACKET_RAM_1_236 volatile.Register16 // 0x618
	PACKET_RAM_1_237 volatile.Register16 // 0x61A
	PACKET_RAM_1_238 volatile.Register16 // 0x61C
	PACKET_RAM_1_239 volatile.Register16 // 0x61E
	PACKET_RAM_1_240 volatile.Register16 // 0x620
	PACKET_RAM_1_241 volatile.Register16 // 0x622
	PACKET_RAM_1_242 volatile.Register16 // 0x624
	PACKET_RAM_1_243 volatile.Register16 // 0x626
	PACKET_RAM_1_244 volatile.Register16 // 0x628
	PACKET_RAM_1_245 volatile.Register16 // 0x62A
	PACKET_RAM_1_246 volatile.Register16 // 0x62C
	PACKET_RAM_1_247 volatile.Register16 // 0x62E
	PACKET_RAM_1_248 volatile.Register16 // 0x630
	PACKET_RAM_1_249 volatile.Register16 // 0x632
	PACKET_RAM_1_250 volatile.Register16 // 0x634
	PACKET_RAM_1_251 volatile.Register16 // 0x636
	PACKET_RAM_1_252 volatile.Register16 // 0x638
	PACKET_RAM_1_253 volatile.Register16 // 0x63A
	PACKET_RAM_1_254 volatile.Register16 // 0x63C
	PACKET_RAM_1_255 volatile.Register16 // 0x63E
	PACKET_RAM_1_256 volatile.Register16 // 0x640
	PACKET_RAM_1_257 volatile.Register16 // 0x642
	PACKET_RAM_1_258 volatile.Register16 // 0x644
	PACKET_RAM_1_259 volatile.Register16 // 0x646
	PACKET_RAM_1_260 volatile.Register16 // 0x648
	PACKET_RAM_1_261 volatile.Register16 // 0x64A
	PACKET_RAM_1_262 volatile.Register16 // 0x64C
	PACKET_RAM_1_263 volatile.Register16 // 0x64E
	PACKET_RAM_1_264 volatile.Register16 // 0x650
	PACKET_RAM_1_265 volatile.Register16 // 0x652
	PACKET_RAM_1_266 volatile.Register16 // 0x654
	PACKET_RAM_1_267 volatile.Register16 // 0x656
	PACKET_RAM_1_268 volatile.Register16 // 0x658
	PACKET_RAM_1_269 volatile.Register16 // 0x65A
	PACKET_RAM_1_270 volatile.Register16 // 0x65C
	PACKET_RAM_1_271 volatile.Register16 // 0x65E
	PACKET_RAM_1_272 volatile.Register16 // 0x660
	PACKET_RAM_1_273 volatile.Register16 // 0x662
	PACKET_RAM_1_274 volatile.Register16 // 0x664
	PACKET_RAM_1_275 volatile.Register16 // 0x666
	PACKET_RAM_1_276 volatile.Register16 // 0x668
	PACKET_RAM_1_277 volatile.Register16 // 0x66A
	PACKET_RAM_1_278 volatile.Register16 // 0x66C
	PACKET_RAM_1_279 volatile.Register16 // 0x66E
	PACKET_RAM_1_280 volatile.Register16 // 0x670
	PACKET_RAM_1_281 volatile.Register16 // 0x672
	PACKET_RAM_1_282 volatile.Register16 // 0x674
	PACKET_RAM_1_283 volatile.Register16 // 0x676
	PACKET_RAM_1_284 volatile.Register16 // 0x678
	PACKET_RAM_1_285 volatile.Register16 // 0x67A
	PACKET_RAM_1_286 volatile.Register16 // 0x67C
	PACKET_RAM_1_287 volatile.Register16 // 0x67E
	PACKET_RAM_1_288 volatile.Register16 // 0x680
	PACKET_RAM_1_289 volatile.Register16 // 0x682
	PACKET_RAM_1_290 volatile.Register16 // 0x684
	PACKET_RAM_1_291 volatile.Register16 // 0x686
	PACKET_RAM_1_292 volatile.Register16 // 0x688
	PACKET_RAM_1_293 volatile.Register16 // 0x68A
	PACKET_RAM_1_294 volatile.Register16 // 0x68C
	PACKET_RAM_1_295 volatile.Register16 // 0x68E
	PACKET_RAM_1_296 volatile.Register16 // 0x690
	PACKET_RAM_1_297 volatile.Register16 // 0x692
	PACKET_RAM_1_298 volatile.Register16 // 0x694
	PACKET_RAM_1_299 volatile.Register16 // 0x696
	PACKET_RAM_1_300 volatile.Register16 // 0x698
	PACKET_RAM_1_301 volatile.Register16 // 0x69A
	PACKET_RAM_1_302 volatile.Register16 // 0x69C
	PACKET_RAM_1_303 volatile.Register16 // 0x69E
	PACKET_RAM_1_304 volatile.Register16 // 0x6A0
	PACKET_RAM_1_305 volatile.Register16 // 0x6A2
	PACKET_RAM_1_306 volatile.Register16 // 0x6A4
	PACKET_RAM_1_307 volatile.Register16 // 0x6A6
	PACKET_RAM_1_308 volatile.Register16 // 0x6A8
	PACKET_RAM_1_309 volatile.Register16 // 0x6AA
	PACKET_RAM_1_310 volatile.Register16 // 0x6AC
	PACKET_RAM_1_311 volatile.Register16 // 0x6AE
	PACKET_RAM_1_312 volatile.Register16 // 0x6B0
	PACKET_RAM_1_313 volatile.Register16 // 0x6B2
	PACKET_RAM_1_314 volatile.Register16 // 0x6B4
	PACKET_RAM_1_315 volatile.Register16 // 0x6B6
	PACKET_RAM_1_316 volatile.Register16 // 0x6B8
	PACKET_RAM_1_317 volatile.Register16 // 0x6BA
	PACKET_RAM_1_318 volatile.Register16 // 0x6BC
	PACKET_RAM_1_319 volatile.Register16 // 0x6BE
	PACKET_RAM_1_320 volatile.Register16 // 0x6C0
	PACKET_RAM_1_321 volatile.Register16 // 0x6C2
	PACKET_RAM_1_322 volatile.Register16 // 0x6C4
	PACKET_RAM_1_323 volatile.Register16 // 0x6C6
	PACKET_RAM_1_324 volatile.Register16 // 0x6C8
	PACKET_RAM_1_325 volatile.Register16 // 0x6CA
	PACKET_RAM_1_326 volatile.Register16 // 0x6CC
	PACKET_RAM_1_327 volatile.Register16 // 0x6CE
	PACKET_RAM_1_328 volatile.Register16 // 0x6D0
	PACKET_RAM_1_329 volatile.Register16 // 0x6D2
	PACKET_RAM_1_330 volatile.Register16 // 0x6D4
	PACKET_RAM_1_331 volatile.Register16 // 0x6D6
	PACKET_RAM_1_332 volatile.Register16 // 0x6D8
	PACKET_RAM_1_333 volatile.Register16 // 0x6DA
	PACKET_RAM_1_334 volatile.Register16 // 0x6DC
	PACKET_RAM_1_335 volatile.Register16 // 0x6DE
	PACKET_RAM_1_336 volatile.Register16 // 0x6E0
	PACKET_RAM_1_337 volatile.Register16 // 0x6E2
	PACKET_RAM_1_338 volatile.Register16 // 0x6E4
	PACKET_RAM_1_339 volatile.Register16 // 0x6E6
	PACKET_RAM_1_340 volatile.Register16 // 0x6E8
	PACKET_RAM_1_341 volatile.Register16 // 0x6EA
	PACKET_RAM_1_342 volatile.Register16 // 0x6EC
	PACKET_RAM_1_343 volatile.Register16 // 0x6EE
	PACKET_RAM_1_344 volatile.Register16 // 0x6F0
	PACKET_RAM_1_345 volatile.Register16 // 0x6F2
	PACKET_RAM_1_346 volatile.Register16 // 0x6F4
	PACKET_RAM_1_347 volatile.Register16 // 0x6F6
	PACKET_RAM_1_348 volatile.Register16 // 0x6F8
	PACKET_RAM_1_349 volatile.Register16 // 0x6FA
	PACKET_RAM_1_350 volatile.Register16 // 0x6FC
	PACKET_RAM_1_351 volatile.Register16 // 0x6FE
	PACKET_RAM_1_352 volatile.Register16 // 0x700
	PACKET_RAM_1_353 volatile.Register16 // 0x702
	PACKET_RAM_1_354 volatile.Register16 // 0x704
	PACKET_RAM_1_355 volatile.Register16 // 0x706
	PACKET_RAM_1_356 volatile.Register16 // 0x708
	PACKET_RAM_1_357 volatile.Register16 // 0x70A
	PACKET_RAM_1_358 volatile.Register16 // 0x70C
	PACKET_RAM_1_359 volatile.Register16 // 0x70E
	PACKET_RAM_1_360 volatile.Register16 // 0x710
	PACKET_RAM_1_361 volatile.Register16 // 0x712
	PACKET_RAM_1_362 volatile.Register16 // 0x714
	PACKET_RAM_1_363 volatile.Register16 // 0x716
	PACKET_RAM_1_364 volatile.Register16 // 0x718
	PACKET_RAM_1_365 volatile.Register16 // 0x71A
	PACKET_RAM_1_366 volatile.Register16 // 0x71C
	PACKET_RAM_1_367 volatile.Register16 // 0x71E
	PACKET_RAM_1_368 volatile.Register16 // 0x720
	PACKET_RAM_1_369 volatile.Register16 // 0x722
	PACKET_RAM_1_370 volatile.Register16 // 0x724
	PACKET_RAM_1_371 volatile.Register16 // 0x726
	PACKET_RAM_1_372 volatile.Register16 // 0x728
	PACKET_RAM_1_373 volatile.Register16 // 0x72A
	PACKET_RAM_1_374 volatile.Register16 // 0x72C
	PACKET_RAM_1_375 volatile.Register16 // 0x72E
	PACKET_RAM_1_376 volatile.Register16 // 0x730
	PACKET_RAM_1_377 volatile.Register16 // 0x732
	PACKET_RAM_1_378 volatile.Register16 // 0x734
	PACKET_RAM_1_379 volatile.Register16 // 0x736
	PACKET_RAM_1_380 volatile.Register16 // 0x738
	PACKET_RAM_1_381 volatile.Register16 // 0x73A
	PACKET_RAM_1_382 volatile.Register16 // 0x73C
	PACKET_RAM_1_383 volatile.Register16 // 0x73E
	PACKET_RAM_1_384 volatile.Register16 // 0x740
	PACKET_RAM_1_385 volatile.Register16 // 0x742
	PACKET_RAM_1_386 volatile.Register16 // 0x744
	PACKET_RAM_1_387 volatile.Register16 // 0x746
	PACKET_RAM_1_388 volatile.Register16 // 0x748
	PACKET_RAM_1_389 volatile.Register16 // 0x74A
	PACKET_RAM_1_390 volatile.Register16 // 0x74C
	PACKET_RAM_1_391 volatile.Register16 // 0x74E
	PACKET_RAM_1_392 volatile.Register16 // 0x750
	PACKET_RAM_1_393 volatile.Register16 // 0x752
	PACKET_RAM_1_394 volatile.Register16 // 0x754
	PACKET_RAM_1_395 volatile.Register16 // 0x756
	PACKET_RAM_1_396 volatile.Register16 // 0x758
	PACKET_RAM_1_397 volatile.Register16 // 0x75A
	PACKET_RAM_1_398 volatile.Register16 // 0x75C
	PACKET_RAM_1_399 volatile.Register16 // 0x75E
	PACKET_RAM_1_400 volatile.Register16 // 0x760
	PACKET_RAM_1_401 volatile.Register16 // 0x762
	PACKET_RAM_1_402 volatile.Register16 // 0x764
	PACKET_RAM_1_403 volatile.Register16 // 0x766
	PACKET_RAM_1_404 volatile.Register16 // 0x768
	PACKET_RAM_1_405 volatile.Register16 // 0x76A
	PACKET_RAM_1_406 volatile.Register16 // 0x76C
	PACKET_RAM_1_407 volatile.Register16 // 0x76E
	PACKET_RAM_1_408 volatile.Register16 // 0x770
	PACKET_RAM_1_409 volatile.Register16 // 0x772
	PACKET_RAM_1_410 volatile.Register16 // 0x774
	PACKET_RAM_1_411 volatile.Register16 // 0x776
	PACKET_RAM_1_412 volatile.Register16 // 0x778
	PACKET_RAM_1_413 volatile.Register16 // 0x77A
	PACKET_RAM_1_414 volatile.Register16 // 0x77C
	PACKET_RAM_1_415 volatile.Register16 // 0x77E
	PACKET_RAM_1_416 volatile.Register16 // 0x780
	PACKET_RAM_1_417 volatile.Register16 // 0x782
	PACKET_RAM_1_418 volatile.Register16 // 0x784
	PACKET_RAM_1_419 volatile.Register16 // 0x786
	PACKET_RAM_1_420 volatile.Register16 // 0x788
	PACKET_RAM_1_421 volatile.Register16 // 0x78A
	PACKET_RAM_1_422 volatile.Register16 // 0x78C
	PACKET_RAM_1_423 volatile.Register16 // 0x78E
	PACKET_RAM_1_424 volatile.Register16 // 0x790
	PACKET_RAM_1_425 volatile.Register16 // 0x792
	PACKET_RAM_1_426 volatile.Register16 // 0x794
	PACKET_RAM_1_427 volatile.Register16 // 0x796
	PACKET_RAM_1_428 volatile.Register16 // 0x798
	PACKET_RAM_1_429 volatile.Register16 // 0x79A
	PACKET_RAM_1_430 volatile.Register16 // 0x79C
	PACKET_RAM_1_431 volatile.Register16 // 0x79E
	PACKET_RAM_1_432 volatile.Register16 // 0x7A0
	PACKET_RAM_1_433 volatile.Register16 // 0x7A2
	PACKET_RAM_1_434 volatile.Register16 // 0x7A4
	PACKET_RAM_1_435 volatile.Register16 // 0x7A6
	PACKET_RAM_1_436 volatile.Register16 // 0x7A8
	PACKET_RAM_1_437 volatile.Register16 // 0x7AA
	PACKET_RAM_1_438 volatile.Register16 // 0x7AC
	PACKET_RAM_1_439 volatile.Register16 // 0x7AE
	PACKET_RAM_1_440 volatile.Register16 // 0x7B0
	PACKET_RAM_1_441 volatile.Register16 // 0x7B2
	PACKET_RAM_1_442 volatile.Register16 // 0x7B4
	PACKET_RAM_1_443 volatile.Register16 // 0x7B6
	PACKET_RAM_1_444 volatile.Register16 // 0x7B8
	PACKET_RAM_1_445 volatile.Register16 // 0x7BA
	PACKET_RAM_1_446 volatile.Register16 // 0x7BC
	PACKET_RAM_1_447 volatile.Register16 // 0x7BE
	PACKET_RAM_1_448 volatile.Register16 // 0x7C0
	PACKET_RAM_1_449 volatile.Register16 // 0x7C2
	PACKET_RAM_1_450 volatile.Register16 // 0x7C4
	PACKET_RAM_1_451 volatile.Register16 // 0x7C6
	PACKET_RAM_1_452 volatile.Register16 // 0x7C8
	PACKET_RAM_1_453 volatile.Register16 // 0x7CA
	PACKET_RAM_1_454 volatile.Register16 // 0x7CC
	PACKET_RAM_1_455 volatile.Register16 // 0x7CE
	PACKET_RAM_1_456 volatile.Register16 // 0x7D0
	PACKET_RAM_1_457 volatile.Register16 // 0x7D2
	PACKET_RAM_1_458 volatile.Register16 // 0x7D4
	PACKET_RAM_1_459 volatile.Register16 // 0x7D6
	PACKET_RAM_1_460 volatile.Register16 // 0x7D8
	PACKET_RAM_1_461 volatile.Register16 // 0x7DA
	PACKET_RAM_1_462 volatile.Register16 // 0x7DC
	PACKET_RAM_1_463 volatile.Register16 // 0x7DE
	PACKET_RAM_1_464 volatile.Register16 // 0x7E0
	PACKET_RAM_1_465 volatile.Register16 // 0x7E2
	PACKET_RAM_1_466 volatile.Register16 // 0x7E4
	PACKET_RAM_1_467 volatile.Register16 // 0x7E6
	PACKET_RAM_1_468 volatile.Register16 // 0x7E8
	PACKET_RAM_1_469 volatile.Register16 // 0x7EA
	PACKET_RAM_1_470 volatile.Register16 // 0x7EC
	PACKET_RAM_1_471 volatile.Register16 // 0x7EE
	PACKET_RAM_1_472 volatile.Register16 // 0x7F0
	PACKET_RAM_1_473 volatile.Register16 // 0x7F2
	PACKET_RAM_1_474 volatile.Register16 // 0x7F4
	PACKET_RAM_1_475 volatile.Register16 // 0x7F6
	PACKET_RAM_1_476 volatile.Register16 // 0x7F8
	PACKET_RAM_1_477 volatile.Register16 // 0x7FA
	PACKET_RAM_1_478 volatile.Register16 // 0x7FC
	PACKET_RAM_1_479 volatile.Register16 // 0x7FE
	PACKET_RAM_1_480 volatile.Register16 // 0x800
	PACKET_RAM_1_481 volatile.Register16 // 0x802
	PACKET_RAM_1_482 volatile.Register16 // 0x804
	PACKET_RAM_1_483 volatile.Register16 // 0x806
	PACKET_RAM_1_484 volatile.Register16 // 0x808
	PACKET_RAM_1_485 volatile.Register16 // 0x80A
	PACKET_RAM_1_486 volatile.Register16 // 0x80C
	PACKET_RAM_1_487 volatile.Register16 // 0x80E
	PACKET_RAM_1_488 volatile.Register16 // 0x810
	PACKET_RAM_1_489 volatile.Register16 // 0x812
	PACKET_RAM_1_490 volatile.Register16 // 0x814
	PACKET_RAM_1_491 volatile.Register16 // 0x816
	PACKET_RAM_1_492 volatile.Register16 // 0x818
	PACKET_RAM_1_493 volatile.Register16 // 0x81A
	PACKET_RAM_1_494 volatile.Register16 // 0x81C
	PACKET_RAM_1_495 volatile.Register16 // 0x81E
	PACKET_RAM_1_496 volatile.Register16 // 0x820
	PACKET_RAM_1_497 volatile.Register16 // 0x822
	PACKET_RAM_1_498 volatile.Register16 // 0x824
	PACKET_RAM_1_499 volatile.Register16 // 0x826
	PACKET_RAM_1_500 volatile.Register16 // 0x828
	PACKET_RAM_1_501 volatile.Register16 // 0x82A
	PACKET_RAM_1_502 volatile.Register16 // 0x82C
	PACKET_RAM_1_503 volatile.Register16 // 0x82E
	PACKET_RAM_1_504 volatile.Register16 // 0x830
	PACKET_RAM_1_505 volatile.Register16 // 0x832
	PACKET_RAM_1_506 volatile.Register16 // 0x834
	PACKET_RAM_1_507 volatile.Register16 // 0x836
	PACKET_RAM_1_508 volatile.Register16 // 0x838
	PACKET_RAM_1_509 volatile.Register16 // 0x83A
	PACKET_RAM_1_510 volatile.Register16 // 0x83C
	PACKET_RAM_1_511 volatile.Register16 // 0x83E
	PACKET_RAM_1_512 volatile.Register16 // 0x840
	PACKET_RAM_1_513 volatile.Register16 // 0x842
	PACKET_RAM_1_514 volatile.Register16 // 0x844
	PACKET_RAM_1_515 volatile.Register16 // 0x846
	PACKET_RAM_1_516 volatile.Register16 // 0x848
	PACKET_RAM_1_517 volatile.Register16 // 0x84A
	PACKET_RAM_1_518 volatile.Register16 // 0x84C
	PACKET_RAM_1_519 volatile.Register16 // 0x84E
	PACKET_RAM_1_520 volatile.Register16 // 0x850
	PACKET_RAM_1_521 volatile.Register16 // 0x852
	PACKET_RAM_1_522 volatile.Register16 // 0x854
	PACKET_RAM_1_523 volatile.Register16 // 0x856
	PACKET_RAM_1_524 volatile.Register16 // 0x858
	PACKET_RAM_1_525 volatile.Register16 // 0x85A
	PACKET_RAM_1_526 volatile.Register16 // 0x85C
	PACKET_RAM_1_527 volatile.Register16 // 0x85E
	PACKET_RAM_1_528 volatile.Register16 // 0x860
	PACKET_RAM_1_529 volatile.Register16 // 0x862
	PACKET_RAM_1_530 volatile.Register16 // 0x864
	PACKET_RAM_1_531 volatile.Register16 // 0x866
	PACKET_RAM_1_532 volatile.Register16 // 0x868
	PACKET_RAM_1_533 volatile.Register16 // 0x86A
	PACKET_RAM_1_534 volatile.Register16 // 0x86C
	PACKET_RAM_1_535 volatile.Register16 // 0x86E
	PACKET_RAM_1_536 volatile.Register16 // 0x870
	PACKET_RAM_1_537 volatile.Register16 // 0x872
	PACKET_RAM_1_538 volatile.Register16 // 0x874
	PACKET_RAM_1_539 volatile.Register16 // 0x876
	PACKET_RAM_1_540 volatile.Register16 // 0x878
	PACKET_RAM_1_541 volatile.Register16 // 0x87A
	PACKET_RAM_1_542 volatile.Register16 // 0x87C
	PACKET_RAM_1_543 volatile.Register16 // 0x87E
}

// ZLL
type ZLL_Type struct {
	IRQSTS            volatile.Register32 // 0x0
	PHY_CTRL          volatile.Register32 // 0x4
	EVENT_TMR         volatile.Register32 // 0x8
	TIMESTAMP         volatile.Register32 // 0xC
	T1CMP             volatile.Register32 // 0x10
	T2CMP             volatile.Register32 // 0x14
	T2PRIMECMP        volatile.Register32 // 0x18
	T3CMP             volatile.Register32 // 0x1C
	T4CMP             volatile.Register32 // 0x20
	PA_PWR            volatile.Register32 // 0x24
	CHANNEL_NUM0      volatile.Register32 // 0x28
	LQI_AND_RSSI      volatile.Register32 // 0x2C
	MACSHORTADDRS0    volatile.Register32 // 0x30
	MACLONGADDRS0_LSB volatile.Register32 // 0x34
	MACLONGADDRS0_MSB volatile.Register32 // 0x38
	RX_FRAME_FILTER   volatile.Register32 // 0x3C
	CCA_LQI_CTRL      volatile.Register32 // 0x40
	CCA2_CTRL         volatile.Register32 // 0x44
	_                 [4]byte
	DSM_CTRL          volatile.Register32 // 0x4C
	BSM_CTRL          volatile.Register32 // 0x50
	MACSHORTADDRS1    volatile.Register32 // 0x54
	MACLONGADDRS1_LSB volatile.Register32 // 0x58
	MACLONGADDRS1_MSB volatile.Register32 // 0x5C
	DUAL_PAN_CTRL     volatile.Register32 // 0x60
	CHANNEL_NUM1      volatile.Register32 // 0x64
	SAM_CTRL          volatile.Register32 // 0x68
	SAM_TABLE         volatile.Register32 // 0x6C
	SAM_MATCH         volatile.Register32 // 0x70
	SAM_FREE_IDX      volatile.Register32 // 0x74
	SEQ_CTRL_STS      volatile.Register32 // 0x78
	ACKDELAY          volatile.Register32 // 0x7C
	FILTERFAIL_CODE   volatile.Register32 // 0x80
	RX_WTR_MARK       volatile.Register32 // 0x84
	_                 [4]byte
	SLOT_PRELOAD      volatile.Register32 // 0x8C
	SEQ_STATE         volatile.Register32 // 0x90
	TMR_PRESCALE      volatile.Register32 // 0x94
	LENIENCY_LSB      volatile.Register32 // 0x98
	LENIENCY_MSB      volatile.Register32 // 0x9C
	PART_ID           volatile.Register32 // 0xA0
	_                 [92]byte
	PKT_BUFFER_TX0    volatile.Register16 // 0x100
	PKT_BUFFER_TX1    volatile.Register16 // 0x102
	PKT_BUFFER_TX2    volatile.Register16 // 0x104
	PKT_BUFFER_TX3    volatile.Register16 // 0x106
	PKT_BUFFER_TX4    volatile.Register16 // 0x108
	PKT_BUFFER_TX5    volatile.Register16 // 0x10A
	PKT_BUFFER_TX6    volatile.Register16 // 0x10C
	PKT_BUFFER_TX7    volatile.Register16 // 0x10E
	PKT_BUFFER_TX8    volatile.Register16 // 0x110
	PKT_BUFFER_TX9    volatile.Register16 // 0x112
	PKT_BUFFER_TX10   volatile.Register16 // 0x114
	PKT_BUFFER_TX11   volatile.Register16 // 0x116
	PKT_BUFFER_TX12   volatile.Register16 // 0x118
	PKT_BUFFER_TX13   volatile.Register16 // 0x11A
	PKT_BUFFER_TX14   volatile.Register16 // 0x11C
	PKT_BUFFER_TX15   volatile.Register16 // 0x11E
	PKT_BUFFER_TX16   volatile.Register16 // 0x120
	PKT_BUFFER_TX17   volatile.Register16 // 0x122
	PKT_BUFFER_TX18   volatile.Register16 // 0x124
	PKT_BUFFER_TX19   volatile.Register16 // 0x126
	PKT_BUFFER_TX20   volatile.Register16 // 0x128
	PKT_BUFFER_TX21   volatile.Register16 // 0x12A
	PKT_BUFFER_TX22   volatile.Register16 // 0x12C
	PKT_BUFFER_TX23   volatile.Register16 // 0x12E
	PKT_BUFFER_TX24   volatile.Register16 // 0x130
	PKT_BUFFER_TX25   volatile.Register16 // 0x132
	PKT_BUFFER_TX26   volatile.Register16 // 0x134
	PKT_BUFFER_TX27   volatile.Register16 // 0x136
	PKT_BUFFER_TX28   volatile.Register16 // 0x138
	PKT_BUFFER_TX29   volatile.Register16 // 0x13A
	PKT_BUFFER_TX30   volatile.Register16 // 0x13C
	PKT_BUFFER_TX31   volatile.Register16 // 0x13E
	PKT_BUFFER_TX32   volatile.Register16 // 0x140
	PKT_BUFFER_TX33   volatile.Register16 // 0x142
	PKT_BUFFER_TX34   volatile.Register16 // 0x144
	PKT_BUFFER_TX35   volatile.Register16 // 0x146
	PKT_BUFFER_TX36   volatile.Register16 // 0x148
	PKT_BUFFER_TX37   volatile.Register16 // 0x14A
	PKT_BUFFER_TX38   volatile.Register16 // 0x14C
	PKT_BUFFER_TX39   volatile.Register16 // 0x14E
	PKT_BUFFER_TX40   volatile.Register16 // 0x150
	PKT_BUFFER_TX41   volatile.Register16 // 0x152
	PKT_BUFFER_TX42   volatile.Register16 // 0x154
	PKT_BUFFER_TX43   volatile.Register16 // 0x156
	PKT_BUFFER_TX44   volatile.Register16 // 0x158
	PKT_BUFFER_TX45   volatile.Register16 // 0x15A
	PKT_BUFFER_TX46   volatile.Register16 // 0x15C
	PKT_BUFFER_TX47   volatile.Register16 // 0x15E
	PKT_BUFFER_TX48   volatile.Register16 // 0x160
	PKT_BUFFER_TX49   volatile.Register16 // 0x162
	PKT_BUFFER_TX50   volatile.Register16 // 0x164
	PKT_BUFFER_TX51   volatile.Register16 // 0x166
	PKT_BUFFER_TX52   volatile.Register16 // 0x168
	PKT_BUFFER_TX53   volatile.Register16 // 0x16A
	PKT_BUFFER_TX54   volatile.Register16 // 0x16C
	PKT_BUFFER_TX55   volatile.Register16 // 0x16E
	PKT_BUFFER_TX56   volatile.Register16 // 0x170
	PKT_BUFFER_TX57   volatile.Register16 // 0x172
	PKT_BUFFER_TX58   volatile.Register16 // 0x174
	PKT_BUFFER_TX59   volatile.Register16 // 0x176
	PKT_BUFFER_TX60   volatile.Register16 // 0x178
	PKT_BUFFER_TX61   volatile.Register16 // 0x17A
	PKT_BUFFER_TX62   volatile.Register16 // 0x17C
	PKT_BUFFER_TX63   volatile.Register16 // 0x17E
	PKT_BUFFER_RX0    volatile.Register16 // 0x180
	PKT_BUFFER_RX1    volatile.Register16 // 0x182
	PKT_BUFFER_RX2    volatile.Register16 // 0x184
	PKT_BUFFER_RX3    volatile.Register16 // 0x186
	PKT_BUFFER_RX4    volatile.Register16 // 0x188
	PKT_BUFFER_RX5    volatile.Register16 // 0x18A
	PKT_BUFFER_RX6    volatile.Register16 // 0x18C
	PKT_BUFFER_RX7    volatile.Register16 // 0x18E
	PKT_BUFFER_RX8    volatile.Register16 // 0x190
	PKT_BUFFER_RX9    volatile.Register16 // 0x192
	PKT_BUFFER_RX10   volatile.Register16 // 0x194
	PKT_BUFFER_RX11   volatile.Register16 // 0x196
	PKT_BUFFER_RX12   volatile.Register16 // 0x198
	PKT_BUFFER_RX13   volatile.Register16 // 0x19A
	PKT_BUFFER_RX14   volatile.Register16 // 0x19C
	PKT_BUFFER_RX15   volatile.Register16 // 0x19E
	PKT_BUFFER_RX16   volatile.Register16 // 0x1A0
	PKT_BUFFER_RX17   volatile.Register16 // 0x1A2
	PKT_BUFFER_RX18   volatile.Register16 // 0x1A4
	PKT_BUFFER_RX19   volatile.Register16 // 0x1A6
	PKT_BUFFER_RX20   volatile.Register16 // 0x1A8
	PKT_BUFFER_RX21   volatile.Register16 // 0x1AA
	PKT_BUFFER_RX22   volatile.Register16 // 0x1AC
	PKT_BUFFER_RX23   volatile.Register16 // 0x1AE
	PKT_BUFFER_RX24   volatile.Register16 // 0x1B0
	PKT_BUFFER_RX25   volatile.Register16 // 0x1B2
	PKT_BUFFER_RX26   volatile.Register16 // 0x1B4
	PKT_BUFFER_RX27   volatile.Register16 // 0x1B6
	PKT_BUFFER_RX28   volatile.Register16 // 0x1B8
	PKT_BUFFER_RX29   volatile.Register16 // 0x1BA
	PKT_BUFFER_RX30   volatile.Register16 // 0x1BC
	PKT_BUFFER_RX31   volatile.Register16 // 0x1BE
	PKT_BUFFER_RX32   volatile.Register16 // 0x1C0
	PKT_BUFFER_RX33   volatile.Register16 // 0x1C2
	PKT_BUFFER_RX34   volatile.Register16 // 0x1C4
	PKT_BUFFER_RX35   volatile.Register16 // 0x1C6
	PKT_BUFFER_RX36   volatile.Register16 // 0x1C8
	PKT_BUFFER_RX37   volatile.Register16 // 0x1CA
	PKT_BUFFER_RX38   volatile.Register16 // 0x1CC
	PKT_BUFFER_RX39   volatile.Register16 // 0x1CE
	PKT_BUFFER_RX40   volatile.Register16 // 0x1D0
	PKT_BUFFER_RX41   volatile.Register16 // 0x1D2
	PKT_BUFFER_RX42   volatile.Register16 // 0x1D4
	PKT_BUFFER_RX43   volatile.Register16 // 0x1D6
	PKT_BUFFER_RX44   volatile.Register16 // 0x1D8
	PKT_BUFFER_RX45   volatile.Register16 // 0x1DA
	PKT_BUFFER_RX46   volatile.Register16 // 0x1DC
	PKT_BUFFER_RX47   volatile.Register16 // 0x1DE
	PKT_BUFFER_RX48   volatile.Register16 // 0x1E0
	PKT_BUFFER_RX49   volatile.Register16 // 0x1E2
	PKT_BUFFER_RX50   volatile.Register16 // 0x1E4
	PKT_BUFFER_RX51   volatile.Register16 // 0x1E6
	PKT_BUFFER_RX52   volatile.Register16 // 0x1E8
	PKT_BUFFER_RX53   volatile.Register16 // 0x1EA
	PKT_BUFFER_RX54   volatile.Register16 // 0x1EC
	PKT_BUFFER_RX55   volatile.Register16 // 0x1EE
	PKT_BUFFER_RX56   volatile.Register16 // 0x1F0
	PKT_BUFFER_RX57   volatile.Register16 // 0x1F2
	PKT_BUFFER_RX58   volatile.Register16 // 0x1F4
	PKT_BUFFER_RX59   volatile.Register16 // 0x1F6
	PKT_BUFFER_RX60   volatile.Register16 // 0x1F8
	PKT_BUFFER_RX61   volatile.Register16 // 0x1FA
	PKT_BUFFER_RX62   volatile.Register16 // 0x1FC
	PKT_BUFFER_RX63   volatile.Register16 // 0x1FE
}

// ANT
type ANT_Type struct {
	IRQ_CTRL         volatile.Register32 // 0x0
	EVENT_TMR        volatile.Register32 // 0x4
	T1_CMP           volatile.Register32 // 0x8
	T2_CMP           volatile.Register32 // 0xC
	TIMESTAMP        volatile.Register32 // 0x10
	XCVR_CTRL        volatile.Register32 // 0x14
	XCVR_STS         volatile.Register32 // 0x18
	XCVR_CFG         volatile.Register32 // 0x1C
	CHANNEL_NUM      volatile.Register32 // 0x20
	TX_POWER         volatile.Register32 // 0x24
	NTW_ADR_CTRL     volatile.Register32 // 0x28
	NTW_ADR_0        volatile.Register32 // 0x2C
	NTW_ADR_1        volatile.Register32 // 0x30
	NTW_ADR_2        volatile.Register32 // 0x34
	NTW_ADR_3        volatile.Register32 // 0x38
	RX_WATERMARK     volatile.Register32 // 0x3C
	DSM_CTRL         volatile.Register32 // 0x40
	PART_ID          volatile.Register32 // 0x44
	_                [184]byte
	PACKET_BUFFER_0  volatile.Register16 // 0x100
	PACKET_BUFFER_1  volatile.Register16 // 0x102
	PACKET_BUFFER_2  volatile.Register16 // 0x104
	PACKET_BUFFER_3  volatile.Register16 // 0x106
	PACKET_BUFFER_4  volatile.Register16 // 0x108
	PACKET_BUFFER_5  volatile.Register16 // 0x10A
	PACKET_BUFFER_6  volatile.Register16 // 0x10C
	PACKET_BUFFER_7  volatile.Register16 // 0x10E
	PACKET_BUFFER_8  volatile.Register16 // 0x110
	PACKET_BUFFER_9  volatile.Register16 // 0x112
	PACKET_BUFFER_10 volatile.Register16 // 0x114
	PACKET_BUFFER_11 volatile.Register16 // 0x116
	PACKET_BUFFER_12 volatile.Register16 // 0x118
	PACKET_BUFFER_13 volatile.Register16 // 0x11A
	PACKET_BUFFER_14 volatile.Register16 // 0x11C
	PACKET_BUFFER_15 volatile.Register16 // 0x11E
	PACKET_BUFFER_16 volatile.Register16 // 0x120
	PACKET_BUFFER_17 volatile.Register16 // 0x122
	PACKET_BUFFER_18 volatile.Register16 // 0x124
	PACKET_BUFFER_19 volatile.Register16 // 0x126
	PACKET_BUFFER_20 volatile.Register16 // 0x128
	PACKET_BUFFER_21 volatile.Register16 // 0x12A
	PACKET_BUFFER_22 volatile.Register16 // 0x12C
	PACKET_BUFFER_23 volatile.Register16 // 0x12E
	PACKET_BUFFER_24 volatile.Register16 // 0x130
	PACKET_BUFFER_25 volatile.Register16 // 0x132
	PACKET_BUFFER_26 volatile.Register16 // 0x134
	PACKET_BUFFER_27 volatile.Register16 // 0x136
	PACKET_BUFFER_28 volatile.Register16 // 0x138
	PACKET_BUFFER_29 volatile.Register16 // 0x13A
	PACKET_BUFFER_30 volatile.Register16 // 0x13C
	PACKET_BUFFER_31 volatile.Register16 // 0x13E
	PACKET_BUFFER_32 volatile.Register16 // 0x140
	PACKET_BUFFER_33 volatile.Register16 // 0x142
	PACKET_BUFFER_34 volatile.Register16 // 0x144
	PACKET_BUFFER_35 volatile.Register16 // 0x146
	PACKET_BUFFER_36 volatile.Register16 // 0x148
	PACKET_BUFFER_37 volatile.Register16 // 0x14A
	PACKET_BUFFER_38 volatile.Register16 // 0x14C
	PACKET_BUFFER_39 volatile.Register16 // 0x14E
	PACKET_BUFFER_40 volatile.Register16 // 0x150
	PACKET_BUFFER_41 volatile.Register16 // 0x152
	PACKET_BUFFER_42 volatile.Register16 // 0x154
	PACKET_BUFFER_43 volatile.Register16 // 0x156
	PACKET_BUFFER_44 volatile.Register16 // 0x158
	PACKET_BUFFER_45 volatile.Register16 // 0x15A
	PACKET_BUFFER_46 volatile.Register16 // 0x15C
	PACKET_BUFFER_47 volatile.Register16 // 0x15E
	PACKET_BUFFER_48 volatile.Register16 // 0x160
	PACKET_BUFFER_49 volatile.Register16 // 0x162
	PACKET_BUFFER_50 volatile.Register16 // 0x164
	PACKET_BUFFER_51 volatile.Register16 // 0x166
	PACKET_BUFFER_52 volatile.Register16 // 0x168
	PACKET_BUFFER_53 volatile.Register16 // 0x16A
	PACKET_BUFFER_54 volatile.Register16 // 0x16C
	PACKET_BUFFER_55 volatile.Register16 // 0x16E
	PACKET_BUFFER_56 volatile.Register16 // 0x170
	PACKET_BUFFER_57 volatile.Register16 // 0x172
	PACKET_BUFFER_58 volatile.Register16 // 0x174
	PACKET_BUFFER_59 volatile.Register16 // 0x176
	PACKET_BUFFER_60 volatile.Register16 // 0x178
	PACKET_BUFFER_61 volatile.Register16 // 0x17A
	PACKET_BUFFER_62 volatile.Register16 // 0x17C
	PACKET_BUFFER_63 volatile.Register16 // 0x17E
}

// GENERIC_FSK
type GENFSK_Type struct {
	IRQ_CTRL      volatile.Register32 // 0x0
	EVENT_TMR     volatile.Register32 // 0x4
	T1_CMP        volatile.Register32 // 0x8
	T2_CMP        volatile.Register32 // 0xC
	TIMESTAMP     volatile.Register32 // 0x10
	XCVR_CTRL     volatile.Register32 // 0x14
	XCVR_STS      volatile.Register32 // 0x18
	XCVR_CFG      volatile.Register32 // 0x1C
	CHANNEL_NUM   volatile.Register32 // 0x20
	TX_POWER      volatile.Register32 // 0x24
	NTW_ADR_CTRL  volatile.Register32 // 0x28
	NTW_ADR_0     volatile.Register32 // 0x2C
	NTW_ADR_1     volatile.Register32 // 0x30
	NTW_ADR_2     volatile.Register32 // 0x34
	NTW_ADR_3     volatile.Register32 // 0x38
	RX_WATERMARK  volatile.Register32 // 0x3C
	DSM_CTRL      volatile.Register32 // 0x40
	PART_ID       volatile.Register32 // 0x44
	_             [24]byte
	PACKET_CFG    volatile.Register32 // 0x60
	H0_CFG        volatile.Register32 // 0x64
	H1_CFG        volatile.Register32 // 0x68
	CRC_CFG       volatile.Register32 // 0x6C
	CRC_INIT      volatile.Register32 // 0x70
	CRC_POLY      volatile.Register32 // 0x74
	CRC_XOR_OUT   volatile.Register32 // 0x78
	WHITEN_CFG    volatile.Register32 // 0x7C
	WHITEN_POLY   volatile.Register32 // 0x80
	WHITEN_SZ_THR volatile.Register32 // 0x84
	BITRATE       volatile.Register32 // 0x88
	PB_PARTITION  volatile.Register32 // 0x8C
}

// Carrier Modulator Transmitter
type CMT_Type struct {
	CGH1 volatile.Register8 // 0x0
	CGL1 volatile.Register8 // 0x1
	CGH2 volatile.Register8 // 0x2
	CGL2 volatile.Register8 // 0x3
	OC   volatile.Register8 // 0x4
	MSC  volatile.Register8 // 0x5
	CMD1 volatile.Register8 // 0x6
	CMD2 volatile.Register8 // 0x7
	CMD3 volatile.Register8 // 0x8
	CMD4 volatile.Register8 // 0x9
	PPS  volatile.Register8 // 0xA
	DMA  volatile.Register8 // 0xB
}

// Multipurpose Clock Generator module
type MCG_Type struct {
	C1    volatile.Register8 // 0x0
	C2    volatile.Register8 // 0x1
	C3    volatile.Register8 // 0x2
	C4    volatile.Register8 // 0x3
	C5    volatile.Register8 // 0x4
	C6    volatile.Register8 // 0x5
	S     volatile.Register8 // 0x6
	_     byte
	SC    volatile.Register8 // 0x8
	_     byte
	ATCVH volatile.Register8 // 0xA
	ATCVL volatile.Register8 // 0xB
	C7    volatile.Register8 // 0xC
	C8    volatile.Register8 // 0xD
}

// Inter-Integrated Circuit
type I2C_Type struct {
	A1   volatile.Register8 // 0x0
	F    volatile.Register8 // 0x1
	C1   volatile.Register8 // 0x2
	S    volatile.Register8 // 0x3
	D    volatile.Register8 // 0x4
	C2   volatile.Register8 // 0x5
	FLT  volatile.Register8 // 0x6
	RA   volatile.Register8 // 0x7
	SMB  volatile.Register8 // 0x8
	A2   volatile.Register8 // 0x9
	SLTH volatile.Register8 // 0xA
	SLTL volatile.Register8 // 0xB
	S2   volatile.Register8 // 0xC
}

// High-Speed Comparator (CMP), Voltage Reference (VREF) Digital-to-Analog Converter (DAC), and Analog Mux (ANMUX)
type CMP0_Type struct {
	CR0   volatile.Register8 // 0x0
	CR1   volatile.Register8 // 0x1
	FPR   volatile.Register8 // 0x2
	SCR   volatile.Register8 // 0x3
	DACCR volatile.Register8 // 0x4
	MUXCR volatile.Register8 // 0x5
}

// Voltage Reference
type VREF_Type struct {
	TRM volatile.Register8 // 0x0
	SC  volatile.Register8 // 0x1
}

// Low leakage wakeup unit
type LLWU_Type struct {
	PE1   volatile.Register8 // 0x0
	PE2   volatile.Register8 // 0x1
	PE3   volatile.Register8 // 0x2
	PE4   volatile.Register8 // 0x3
	ME    volatile.Register8 // 0x4
	F1    volatile.Register8 // 0x5
	F2    volatile.Register8 // 0x6
	F3    volatile.Register8 // 0x7
	FILT1 volatile.Register8 // 0x8
	FILT2 volatile.Register8 // 0x9
}

// Power Management Controller
type PMC_Type struct {
	LVDSC1 volatile.Register8 // 0x0
	LVDSC2 volatile.Register8 // 0x1
	REGSC  volatile.Register8 // 0x2
}

// System Mode Controller
type SMC_Type struct {
	PMPROT   volatile.Register8 // 0x0
	PMCTRL   volatile.Register8 // 0x1
	STOPCTRL volatile.Register8 // 0x2
	PMSTAT   volatile.Register8 // 0x3
}

// Reset Control Module
type RCM_Type struct {
	SRS0 volatile.Register8 // 0x0
	SRS1 volatile.Register8 // 0x1
	_    [2]byte
	RPFC volatile.Register8 // 0x4
	RPFW volatile.Register8 // 0x5
}

// General Purpose Input/Output
type GPIO_Type struct {
	PDOR volatile.Register32 // 0x0
	PSOR volatile.Register32 // 0x4
	PCOR volatile.Register32 // 0x8
	PTOR volatile.Register32 // 0xC
	PDIR volatile.Register32 // 0x10
	PDDR volatile.Register32 // 0x14
}

// System Control Block
type SystemControl_Type struct {
	_     [8]byte
	ACTLR volatile.Register32 // 0x8
	_     [3316]byte
	CPUID volatile.Register32 // 0xD00
	ICSR  volatile.Register32 // 0xD04
	VTOR  volatile.Register32 // 0xD08
	AIRCR volatile.Register32 // 0xD0C
	SCR   volatile.Register32 // 0xD10
	CCR   volatile.Register32 // 0xD14
	_     [4]byte
	SHPR2 volatile.Register32 // 0xD1C
	SHPR3 volatile.Register32 // 0xD20
	SHCSR volatile.Register32 // 0xD24
	_     [8]byte
	DFSR  volatile.Register32 // 0xD30
}

// System timer
type SysTick_Type struct {
	CSR   volatile.Register32 // 0x0
	RVR   volatile.Register32 // 0x4
	CVR   volatile.Register32 // 0x8
	CALIB volatile.Register32 // 0xC
}

// Nested Vectored Interrupt Controller
type NVIC_Type struct {
	NVIC_ISER volatile.Register32 // 0x0
	_         [124]byte
	NVIC_ICER volatile.Register32 // 0x80
	_         [124]byte
	NVIC_ISPR volatile.Register32 // 0x100
	_         [124]byte
	NVIC_ICPR volatile.Register32 // 0x180
	_         [380]byte
	NVIC_IPR0 volatile.Register32 // 0x300
	NVIC_IPR1 volatile.Register32 // 0x304
	NVIC_IPR2 volatile.Register32 // 0x308
	NVIC_IPR3 volatile.Register32 // 0x30C
	NVIC_IPR4 volatile.Register32 // 0x310
	NVIC_IPR5 volatile.Register32 // 0x314
	NVIC_IPR6 volatile.Register32 // 0x318
	NVIC_IPR7 volatile.Register32 // 0x31C
}

// Micro Trace Buffer
type MTB_Type struct {
	POSITION    volatile.Register32 // 0x0
	MASTER      volatile.Register32 // 0x4
	FLOW        volatile.Register32 // 0x8
	BASE        volatile.Register32 // 0xC
	_           [3824]byte
	MODECTRL    volatile.Register32 // 0xF00
	_           [156]byte
	TAGSET      volatile.Register32 // 0xFA0
	TAGCLEAR    volatile.Register32 // 0xFA4
	_           [8]byte
	LOCKACCESS  volatile.Register32 // 0xFB0
	LOCKSTAT    volatile.Register32 // 0xFB4
	AUTHSTAT    volatile.Register32 // 0xFB8
	DEVICEARCH  volatile.Register32 // 0xFBC
	_           [8]byte
	DEVICECFG   volatile.Register32 // 0xFC8
	DEVICETYPID volatile.Register32 // 0xFCC
	PERIPHID4   volatile.Register32 // 0xFD0
	PERIPHID5   volatile.Register32 // 0xFD4
	PERIPHID6   volatile.Register32 // 0xFD8
	PERIPHID7   volatile.Register32 // 0xFDC
	PERIPHID0   volatile.Register32 // 0xFE0
	PERIPHID1   volatile.Register32 // 0xFE4
	PERIPHID2   volatile.Register32 // 0xFE8
	PERIPHID3   volatile.Register32 // 0xFEC
	COMPID0     volatile.Register32 // 0xFF0
	COMPID1     volatile.Register32 // 0xFF4
	COMPID2     volatile.Register32 // 0xFF8
	COMPID3     volatile.Register32 // 0xFFC
}

// MTB data watchpoint and trace
type MTBDWT_Type struct {
	CTRL        volatile.Register32 // 0x0
	_           [28]byte
	COMP0       volatile.Register32 // 0x20
	MASK0       volatile.Register32 // 0x24
	FCT0        volatile.Register32 // 0x28
	_           [4]byte
	COMP1       volatile.Register32 // 0x30
	MASK1       volatile.Register32 // 0x34
	FCT1        volatile.Register32 // 0x38
	_           [452]byte
	TBCTRL      volatile.Register32 // 0x200
	_           [3524]byte
	DEVICECFG   volatile.Register32 // 0xFC8
	DEVICETYPID volatile.Register32 // 0xFCC
	PERIPHID4   volatile.Register32 // 0xFD0
	PERIPHID5   volatile.Register32 // 0xFD4
	PERIPHID6   volatile.Register32 // 0xFD8
	PERIPHID7   volatile.Register32 // 0xFDC
	PERIPHID0   volatile.Register32 // 0xFE0
	PERIPHID1   volatile.Register32 // 0xFE4
	PERIPHID2   volatile.Register32 // 0xFE8
	PERIPHID3   volatile.Register32 // 0xFEC
	COMPID0     volatile.Register32 // 0xFF0
	COMPID1     volatile.Register32 // 0xFF4
	COMPID2     volatile.Register32 // 0xFF8
	COMPID3     volatile.Register32 // 0xFFC
}

// System ROM
type ROM_Type struct {
	ENTRY0    volatile.Register32 // 0x0
	ENTRY1    volatile.Register32 // 0x4
	ENTRY2    volatile.Register32 // 0x8
	TABLEMARK volatile.Register32 // 0xC
	_         [4028]byte
	SYSACCESS volatile.Register32 // 0xFCC
	PERIPHID4 volatile.Register32 // 0xFD0
	PERIPHID5 volatile.Register32 // 0xFD4
	PERIPHID6 volatile.Register32 // 0xFD8
	PERIPHID7 volatile.Register32 // 0xFDC
	PERIPHID0 volatile.Register32 // 0xFE0
	PERIPHID1 volatile.Register32 // 0xFE4
	PERIPHID2 volatile.Register32 // 0xFE8
	PERIPHID3 volatile.Register32 // 0xFEC
	COMPID0   volatile.Register32 // 0xFF0
	COMPID1   volatile.Register32 // 0xFF4
	COMPID2   volatile.Register32 // 0xFF8
	COMPID3   volatile.Register32 // 0xFFC
}

// Core Platform Miscellaneous Control Module
type MCM_Type struct {
	_     [8]byte
	PLASC volatile.Register16 // 0x8
	PLAMC volatile.Register16 // 0xA
	PLACR volatile.Register32 // 0xC
	_     [48]byte
	CPO   volatile.Register32 // 0x40
}

// General Purpose Input/Output
type FGPIO_Type struct {
	PDOR volatile.Register32 // 0x0
	PSOR volatile.Register32 // 0x4
	PCOR volatile.Register32 // 0x8
	PTOR volatile.Register32 // 0xC
	PDIR volatile.Register32 // 0x10
	PDDR volatile.Register32 // 0x14
}

// Bitfields for FTFA_FlashConfig: Flash configuration field
const (
	// BACKKEY3: Backdoor Comparison Key 3.
	// Position of KEY field.
	FTFA_FlashConfig_BACKKEY3_KEY_Pos = 0x0
	// Bit mask of KEY field.
	FTFA_FlashConfig_BACKKEY3_KEY_Msk = 0xff

	// BACKKEY2: Backdoor Comparison Key 2.
	// Position of KEY field.
	FTFA_FlashConfig_BACKKEY2_KEY_Pos = 0x0
	// Bit mask of KEY field.
	FTFA_FlashConfig_BACKKEY2_KEY_Msk = 0xff

	// BACKKEY1: Backdoor Comparison Key 1.
	// Position of KEY field.
	FTFA_FlashConfig_BACKKEY1_KEY_Pos = 0x0
	// Bit mask of KEY field.
	FTFA_FlashConfig_BACKKEY1_KEY_Msk = 0xff

	// BACKKEY0: Backdoor Comparison Key 0.
	// Position of KEY field.
	FTFA_FlashConfig_BACKKEY0_KEY_Pos = 0x0
	// Bit mask of KEY field.
	FTFA_FlashConfig_BACKKEY0_KEY_Msk = 0xff

	// BACKKEY7: Backdoor Comparison Key 7.
	// Position of KEY field.
	FTFA_FlashConfig_BACKKEY7_KEY_Pos = 0x0
	// Bit mask of KEY field.
	FTFA_FlashConfig_BACKKEY7_KEY_Msk = 0xff

	// BACKKEY6: Backdoor Comparison Key 6.
	// Position of KEY field.
	FTFA_FlashConfig_BACKKEY6_KEY_Pos = 0x0
	// Bit mask of KEY field.
	FTFA_FlashConfig_BACKKEY6_KEY_Msk = 0xff

	// BACKKEY5: Backdoor Comparison Key 5.
	// Position of KEY field.
	FTFA_FlashConfig_BACKKEY5_KEY_Pos = 0x0
	// Bit mask of KEY field.
	FTFA_FlashConfig_BACKKEY5_KEY_Msk = 0xff

	// BACKKEY4: Backdoor Comparison Key 4.
	// Position of KEY field.
	FTFA_FlashConfig_BACKKEY4_KEY_Pos = 0x0
	// Bit mask of KEY field.
	FTFA_FlashConfig_BACKKEY4_KEY_Msk = 0xff

	// FPROT3: Non-volatile P-Flash Protection 1 - Low Register
	// Position of PROT field.
	FTFA_FlashConfig_FPROT3_PROT_Pos = 0x0
	// Bit mask of PROT field.
	FTFA_FlashConfig_FPROT3_PROT_Msk = 0xff

	// FPROT2: Non-volatile P-Flash Protection 1 - High Register
	// Position of PROT field.
	FTFA_FlashConfig_FPROT2_PROT_Pos = 0x0
	// Bit mask of PROT field.
	FTFA_FlashConfig_FPROT2_PROT_Msk = 0xff

	// FPROT1: Non-volatile P-Flash Protection 0 - Low Register
	// Position of PROT field.
	FTFA_FlashConfig_FPROT1_PROT_Pos = 0x0
	// Bit mask of PROT field.
	FTFA_FlashConfig_FPROT1_PROT_Msk = 0xff

	// FPROT0: Non-volatile P-Flash Protection 0 - High Register
	// Position of PROT field.
	FTFA_FlashConfig_FPROT0_PROT_Pos = 0x0
	// Bit mask of PROT field.
	FTFA_FlashConfig_FPROT0_PROT_Msk = 0xff

	// FSEC: Non-volatile Flash Security Register
	// Position of SEC field.
	FTFA_FlashConfig_FSEC_SEC_Pos = 0x0
	// Bit mask of SEC field.
	FTFA_FlashConfig_FSEC_SEC_Msk = 0x3
	// MCU security status is unsecure
	FTFA_FlashConfig_FSEC_SEC_10 = 0x2
	// MCU security status is secure
	FTFA_FlashConfig_FSEC_SEC_11 = 0x3
	// Position of FSLACC field.
	FTFA_FlashConfig_FSEC_FSLACC_Pos = 0x2
	// Bit mask of FSLACC field.
	FTFA_FlashConfig_FSEC_FSLACC_Msk = 0xc
	// Freescale factory access denied
	FTFA_FlashConfig_FSEC_FSLACC_10 = 0x2
	// Freescale factory access granted
	FTFA_FlashConfig_FSEC_FSLACC_11 = 0x3
	// Position of MEEN field.
	FTFA_FlashConfig_FSEC_MEEN_Pos = 0x4
	// Bit mask of MEEN field.
	FTFA_FlashConfig_FSEC_MEEN_Msk = 0x30
	// Mass erase is disabled
	FTFA_FlashConfig_FSEC_MEEN_10 = 0x2
	// Mass erase is enabled
	FTFA_FlashConfig_FSEC_MEEN_11 = 0x3
	// Position of KEYEN field.
	FTFA_FlashConfig_FSEC_KEYEN_Pos = 0x6
	// Bit mask of KEYEN field.
	FTFA_FlashConfig_FSEC_KEYEN_Msk = 0xc0
	// Backdoor key access enabled
	FTFA_FlashConfig_FSEC_KEYEN_10 = 0x2
	// Backdoor key access disabled
	FTFA_FlashConfig_FSEC_KEYEN_11 = 0x3

	// FOPT: Non-volatile Flash Option Register
	// Position of LPBOOT0 field.
	FTFA_FlashConfig_FOPT_LPBOOT0_Pos = 0x0
	// Bit mask of LPBOOT0 field.
	FTFA_FlashConfig_FOPT_LPBOOT0_Msk = 0x1
	// Bit LPBOOT0.
	FTFA_FlashConfig_FOPT_LPBOOT0 = 0x1
	// Core and system clock divider (OUTDIV1) is 0x7 (divide by 8) when LPBOOT1=0 or 0x1 (divide by 2) when LPBOOT1=1.
	FTFA_FlashConfig_FOPT_LPBOOT0_00 = 0x0
	// Core and system clock divider (OUTDIV1) is 0x3 (divide by 4) when LPBOOT1=0 or 0x0 (divide by 1) when LPBOOT1=1.
	FTFA_FlashConfig_FOPT_LPBOOT0_01 = 0x1
	// Position of NMI_DIS field.
	FTFA_FlashConfig_FOPT_NMI_DIS_Pos = 0x2
	// Bit mask of NMI_DIS field.
	FTFA_FlashConfig_FOPT_NMI_DIS_Msk = 0x4
	// Bit NMI_DIS.
	FTFA_FlashConfig_FOPT_NMI_DIS = 0x4
	// NMI interrupts are always blocked
	FTFA_FlashConfig_FOPT_NMI_DIS_00 = 0x0
	// NMI_b pin/interrupts reset default to enabled
	FTFA_FlashConfig_FOPT_NMI_DIS_01 = 0x1
	// Position of RESET_PIN_CFG field.
	FTFA_FlashConfig_FOPT_RESET_PIN_CFG_Pos = 0x3
	// Bit mask of RESET_PIN_CFG field.
	FTFA_FlashConfig_FOPT_RESET_PIN_CFG_Msk = 0x8
	// Bit RESET_PIN_CFG.
	FTFA_FlashConfig_FOPT_RESET_PIN_CFG = 0x8
	// RESET pin is disabled following a POR and cannot be enabled as reset function
	FTFA_FlashConfig_FOPT_RESET_PIN_CFG_00 = 0x0
	// RESET_b pin is dedicated
	FTFA_FlashConfig_FOPT_RESET_PIN_CFG_01 = 0x1
	// Position of LPBOOT1 field.
	FTFA_FlashConfig_FOPT_LPBOOT1_Pos = 0x4
	// Bit mask of LPBOOT1 field.
	FTFA_FlashConfig_FOPT_LPBOOT1_Msk = 0x10
	// Bit LPBOOT1.
	FTFA_FlashConfig_FOPT_LPBOOT1 = 0x10
	// Core and system clock divider (OUTDIV1) is 0x7 (divide by 8) when LPBOOT0=0 or 0x3 (divide by 4) when LPBOOT0=1.
	FTFA_FlashConfig_FOPT_LPBOOT1_00 = 0x0
	// Core and system clock divider (OUTDIV1) is 0x1 (divide by 2) when LPBOOT0=0 or 0x0 (divide by 1) when LPBOOT0=1.
	FTFA_FlashConfig_FOPT_LPBOOT1_01 = 0x1
	// Position of FAST_INIT field.
	FTFA_FlashConfig_FOPT_FAST_INIT_Pos = 0x5
	// Bit mask of FAST_INIT field.
	FTFA_FlashConfig_FOPT_FAST_INIT_Msk = 0x20
	// Bit FAST_INIT.
	FTFA_FlashConfig_FOPT_FAST_INIT = 0x20
	// Slower initialization
	FTFA_FlashConfig_FOPT_FAST_INIT_00 = 0x0
	// Fast Initialization
	FTFA_FlashConfig_FOPT_FAST_INIT_01 = 0x1
)

// Bitfields for DMA: Enhanced direct memory access controller
const (
	// CR: Control Register
	// Position of EDBG field.
	DMA_CR_EDBG_Pos = 0x1
	// Bit mask of EDBG field.
	DMA_CR_EDBG_Msk = 0x2
	// Bit EDBG.
	DMA_CR_EDBG = 0x2
	// When in debug mode, the DMA continues to operate.
	DMA_CR_EDBG_0 = 0x0
	// When in debug mode, the DMA stalls the start of a new channel. Executing channels are allowed to complete. Channel execution resumes when the system exits debug mode or the EDBG bit is cleared.
	DMA_CR_EDBG_1 = 0x1
	// Position of ERCA field.
	DMA_CR_ERCA_Pos = 0x2
	// Bit mask of ERCA field.
	DMA_CR_ERCA_Msk = 0x4
	// Bit ERCA.
	DMA_CR_ERCA = 0x4
	// Fixed priority arbitration is used for channel selection .
	DMA_CR_ERCA_0 = 0x0
	// Round robin arbitration is used for channel selection .
	DMA_CR_ERCA_1 = 0x1
	// Position of HOE field.
	DMA_CR_HOE_Pos = 0x4
	// Bit mask of HOE field.
	DMA_CR_HOE_Msk = 0x10
	// Bit HOE.
	DMA_CR_HOE = 0x10
	// Normal operation
	DMA_CR_HOE_0 = 0x0
	// Any error causes the HALT bit to set. Subsequently, all service requests are ignored until the HALT bit is cleared.
	DMA_CR_HOE_1 = 0x1
	// Position of HALT field.
	DMA_CR_HALT_Pos = 0x5
	// Bit mask of HALT field.
	DMA_CR_HALT_Msk = 0x20
	// Bit HALT.
	DMA_CR_HALT = 0x20
	// Normal operation
	DMA_CR_HALT_0 = 0x0
	// Stall the start of any new channels. Executing channels are allowed to complete. Channel execution resumes when this bit is cleared.
	DMA_CR_HALT_1 = 0x1
	// Position of CLM field.
	DMA_CR_CLM_Pos = 0x6
	// Bit mask of CLM field.
	DMA_CR_CLM_Msk = 0x40
	// Bit CLM.
	DMA_CR_CLM = 0x40
	// A minor loop channel link made to itself goes through channel arbitration before being activated again.
	DMA_CR_CLM_0 = 0x0
	// A minor loop channel link made to itself does not go through channel arbitration before being activated again. Upon minor loop completion, the channel activates again if that channel has a minor loop channel link enabled and the link channel is itself. This effectively applies the minor loop offsets and restarts the next minor loop.
	DMA_CR_CLM_1 = 0x1
	// Position of EMLM field.
	DMA_CR_EMLM_Pos = 0x7
	// Bit mask of EMLM field.
	DMA_CR_EMLM_Msk = 0x80
	// Bit EMLM.
	DMA_CR_EMLM = 0x80
	// Disabled. TCDn.word2 is defined as a 32-bit NBYTES field.
	DMA_CR_EMLM_0 = 0x0
	// Enabled. TCDn.word2 is redefined to include individual enable fields, an offset field, and the NBYTES field. The individual enable fields allow the minor loop offset to be applied to the source address, the destination address, or both. The NBYTES field is reduced when either offset is enabled.
	DMA_CR_EMLM_1 = 0x1
	// Position of ECX field.
	DMA_CR_ECX_Pos = 0x10
	// Bit mask of ECX field.
	DMA_CR_ECX_Msk = 0x10000
	// Bit ECX.
	DMA_CR_ECX = 0x10000
	// Normal operation
	DMA_CR_ECX_0 = 0x0
	// Cancel the remaining data transfer in the same fashion as the CX bit. Stop the executing channel and force the minor loop to finish. The cancel takes effect after the last write of the current read/write sequence. The ECX bit clears itself after the cancel is honored. In addition to cancelling the transfer, ECX treats the cancel as an error condition, thus updating the Error Status register (DMAx_ES) and generating an optional error interrupt.
	DMA_CR_ECX_1 = 0x1
	// Position of CX field.
	DMA_CR_CX_Pos = 0x11
	// Bit mask of CX field.
	DMA_CR_CX_Msk = 0x20000
	// Bit CX.
	DMA_CR_CX = 0x20000
	// Normal operation
	DMA_CR_CX_0 = 0x0
	// Cancel the remaining data transfer. Stop the executing channel and force the minor loop to finish. The cancel takes effect after the last write of the current read/write sequence. The CX bit clears itself after the cancel has been honored. This cancel retires the channel normally as if the minor loop was completed.
	DMA_CR_CX_1 = 0x1
	// Position of ACTIVE field.
	DMA_CR_ACTIVE_Pos = 0x1f
	// Bit mask of ACTIVE field.
	DMA_CR_ACTIVE_Msk = 0x80000000
	// Bit ACTIVE.
	DMA_CR_ACTIVE = 0x80000000
	// eDMA is idle.
	DMA_CR_ACTIVE_0 = 0x0
	// eDMA is executing a channel.
	DMA_CR_ACTIVE_1 = 0x1

	// ES: Error Status Register
	// Position of DBE field.
	DMA_ES_DBE_Pos = 0x0
	// Bit mask of DBE field.
	DMA_ES_DBE_Msk = 0x1
	// Bit DBE.
	DMA_ES_DBE = 0x1
	// No destination bus error
	DMA_ES_DBE_0 = 0x0
	// The last recorded error was a bus error on a destination write
	DMA_ES_DBE_1 = 0x1
	// Position of SBE field.
	DMA_ES_SBE_Pos = 0x1
	// Bit mask of SBE field.
	DMA_ES_SBE_Msk = 0x2
	// Bit SBE.
	DMA_ES_SBE = 0x2
	// No source bus error
	DMA_ES_SBE_0 = 0x0
	// The last recorded error was a bus error on a source read
	DMA_ES_SBE_1 = 0x1
	// Position of SGE field.
	DMA_ES_SGE_Pos = 0x2
	// Bit mask of SGE field.
	DMA_ES_SGE_Msk = 0x4
	// Bit SGE.
	DMA_ES_SGE = 0x4
	// No scatter/gather configuration error
	DMA_ES_SGE_0 = 0x0
	// The last recorded error was a configuration error detected in the TCDn_DLASTSGA field. This field is checked at the beginning of a scatter/gather operation after major loop completion if TCDn_CSR[ESG] is enabled. TCDn_DLASTSGA is not on a 32 byte boundary.
	DMA_ES_SGE_1 = 0x1
	// Position of NCE field.
	DMA_ES_NCE_Pos = 0x3
	// Bit mask of NCE field.
	DMA_ES_NCE_Msk = 0x8
	// Bit NCE.
	DMA_ES_NCE = 0x8
	// No NBYTES/CITER configuration error
	DMA_ES_NCE_0 = 0x0
	// The last recorded error was a configuration error detected in the TCDn_NBYTES or TCDn_CITER fields. TCDn_NBYTES is not a multiple of TCDn_ATTR[SSIZE] and TCDn_ATTR[DSIZE], or TCDn_CITER[CITER] is equal to zero, or TCDn_CITER[ELINK] is not equal to TCDn_BITER[ELINK]
	DMA_ES_NCE_1 = 0x1
	// Position of DOE field.
	DMA_ES_DOE_Pos = 0x4
	// Bit mask of DOE field.
	DMA_ES_DOE_Msk = 0x10
	// Bit DOE.
	DMA_ES_DOE = 0x10
	// No destination offset configuration error
	DMA_ES_DOE_0 = 0x0
	// The last recorded error was a configuration error detected in the TCDn_DOFF field. TCDn_DOFF is inconsistent with TCDn_ATTR[DSIZE].
	DMA_ES_DOE_1 = 0x1
	// Position of DAE field.
	DMA_ES_DAE_Pos = 0x5
	// Bit mask of DAE field.
	DMA_ES_DAE_Msk = 0x20
	// Bit DAE.
	DMA_ES_DAE = 0x20
	// No destination address configuration error
	DMA_ES_DAE_0 = 0x0
	// The last recorded error was a configuration error detected in the TCDn_DADDR field. TCDn_DADDR is inconsistent with TCDn_ATTR[DSIZE].
	DMA_ES_DAE_1 = 0x1
	// Position of SOE field.
	DMA_ES_SOE_Pos = 0x6
	// Bit mask of SOE field.
	DMA_ES_SOE_Msk = 0x40
	// Bit SOE.
	DMA_ES_SOE = 0x40
	// No source offset configuration error
	DMA_ES_SOE_0 = 0x0
	// The last recorded error was a configuration error detected in the TCDn_SOFF field. TCDn_SOFF is inconsistent with TCDn_ATTR[SSIZE].
	DMA_ES_SOE_1 = 0x1
	// Position of SAE field.
	DMA_ES_SAE_Pos = 0x7
	// Bit mask of SAE field.
	DMA_ES_SAE_Msk = 0x80
	// Bit SAE.
	DMA_ES_SAE = 0x80
	// No source address configuration error.
	DMA_ES_SAE_0 = 0x0
	// The last recorded error was a configuration error detected in the TCDn_SADDR field. TCDn_SADDR is inconsistent with TCDn_ATTR[SSIZE].
	DMA_ES_SAE_1 = 0x1
	// Position of ERRCHN field.
	DMA_ES_ERRCHN_Pos = 0x8
	// Bit mask of ERRCHN field.
	DMA_ES_ERRCHN_Msk = 0x300
	// Position of CPE field.
	DMA_ES_CPE_Pos = 0xe
	// Bit mask of CPE field.
	DMA_ES_CPE_Msk = 0x4000
	// Bit CPE.
	DMA_ES_CPE = 0x4000
	// No channel priority error
	DMA_ES_CPE_0 = 0x0
	// The last recorded error was a configuration error in the channel priorities . Channel priorities are not unique.
	DMA_ES_CPE_1 = 0x1
	// Position of ECX field.
	DMA_ES_ECX_Pos = 0x10
	// Bit mask of ECX field.
	DMA_ES_ECX_Msk = 0x10000
	// Bit ECX.
	DMA_ES_ECX = 0x10000
	// No canceled transfers
	DMA_ES_ECX_0 = 0x0
	// The last recorded entry was a canceled transfer by the error cancel transfer input
	DMA_ES_ECX_1 = 0x1
	// Position of VLD field.
	DMA_ES_VLD_Pos = 0x1f
	// Bit mask of VLD field.
	DMA_ES_VLD_Msk = 0x80000000
	// Bit VLD.
	DMA_ES_VLD = 0x80000000
	// No ERR bits are set.
	DMA_ES_VLD_0 = 0x0
	// At least one ERR bit is set indicating a valid error exists that has not been cleared.
	DMA_ES_VLD_1 = 0x1

	// ERQ: Enable Request Register
	// Position of ERQ0 field.
	DMA_ERQ_ERQ0_Pos = 0x0
	// Bit mask of ERQ0 field.
	DMA_ERQ_ERQ0_Msk = 0x1
	// Bit ERQ0.
	DMA_ERQ_ERQ0 = 0x1
	// The DMA request signal for the corresponding channel is disabled
	DMA_ERQ_ERQ0_0 = 0x0
	// The DMA request signal for the corresponding channel is enabled
	DMA_ERQ_ERQ0_1 = 0x1
	// Position of ERQ1 field.
	DMA_ERQ_ERQ1_Pos = 0x1
	// Bit mask of ERQ1 field.
	DMA_ERQ_ERQ1_Msk = 0x2
	// Bit ERQ1.
	DMA_ERQ_ERQ1 = 0x2
	// The DMA request signal for the corresponding channel is disabled
	DMA_ERQ_ERQ1_0 = 0x0
	// The DMA request signal for the corresponding channel is enabled
	DMA_ERQ_ERQ1_1 = 0x1
	// Position of ERQ2 field.
	DMA_ERQ_ERQ2_Pos = 0x2
	// Bit mask of ERQ2 field.
	DMA_ERQ_ERQ2_Msk = 0x4
	// Bit ERQ2.
	DMA_ERQ_ERQ2 = 0x4
	// The DMA request signal for the corresponding channel is disabled
	DMA_ERQ_ERQ2_0 = 0x0
	// The DMA request signal for the corresponding channel is enabled
	DMA_ERQ_ERQ2_1 = 0x1
	// Position of ERQ3 field.
	DMA_ERQ_ERQ3_Pos = 0x3
	// Bit mask of ERQ3 field.
	DMA_ERQ_ERQ3_Msk = 0x8
	// Bit ERQ3.
	DMA_ERQ_ERQ3 = 0x8
	// The DMA request signal for the corresponding channel is disabled
	DMA_ERQ_ERQ3_0 = 0x0
	// The DMA request signal for the corresponding channel is enabled
	DMA_ERQ_ERQ3_1 = 0x1

	// EEI: Enable Error Interrupt Register
	// Position of EEI0 field.
	DMA_EEI_EEI0_Pos = 0x0
	// Bit mask of EEI0 field.
	DMA_EEI_EEI0_Msk = 0x1
	// Bit EEI0.
	DMA_EEI_EEI0 = 0x1
	// The error signal for corresponding channel does not generate an error interrupt
	DMA_EEI_EEI0_0 = 0x0
	// The assertion of the error signal for corresponding channel generates an error interrupt request
	DMA_EEI_EEI0_1 = 0x1
	// Position of EEI1 field.
	DMA_EEI_EEI1_Pos = 0x1
	// Bit mask of EEI1 field.
	DMA_EEI_EEI1_Msk = 0x2
	// Bit EEI1.
	DMA_EEI_EEI1 = 0x2
	// The error signal for corresponding channel does not generate an error interrupt
	DMA_EEI_EEI1_0 = 0x0
	// The assertion of the error signal for corresponding channel generates an error interrupt request
	DMA_EEI_EEI1_1 = 0x1
	// Position of EEI2 field.
	DMA_EEI_EEI2_Pos = 0x2
	// Bit mask of EEI2 field.
	DMA_EEI_EEI2_Msk = 0x4
	// Bit EEI2.
	DMA_EEI_EEI2 = 0x4
	// The error signal for corresponding channel does not generate an error interrupt
	DMA_EEI_EEI2_0 = 0x0
	// The assertion of the error signal for corresponding channel generates an error interrupt request
	DMA_EEI_EEI2_1 = 0x1
	// Position of EEI3 field.
	DMA_EEI_EEI3_Pos = 0x3
	// Bit mask of EEI3 field.
	DMA_EEI_EEI3_Msk = 0x8
	// Bit EEI3.
	DMA_EEI_EEI3 = 0x8
	// The error signal for corresponding channel does not generate an error interrupt
	DMA_EEI_EEI3_0 = 0x0
	// The assertion of the error signal for corresponding channel generates an error interrupt request
	DMA_EEI_EEI3_1 = 0x1

	// CEEI: Clear Enable Error Interrupt Register
	// Position of CEEI field.
	DMA_CEEI_CEEI_Pos = 0x0
	// Bit mask of CEEI field.
	DMA_CEEI_CEEI_Msk = 0x3
	// Position of CAEE field.
	DMA_CEEI_CAEE_Pos = 0x6
	// Bit mask of CAEE field.
	DMA_CEEI_CAEE_Msk = 0x40
	// Bit CAEE.
	DMA_CEEI_CAEE = 0x40
	// Clear only the EEI bit specified in the CEEI field
	DMA_CEEI_CAEE_0 = 0x0
	// Clear all bits in EEI
	DMA_CEEI_CAEE_1 = 0x1
	// Position of NOP field.
	DMA_CEEI_NOP_Pos = 0x7
	// Bit mask of NOP field.
	DMA_CEEI_NOP_Msk = 0x80
	// Bit NOP.
	DMA_CEEI_NOP = 0x80
	// Normal operation
	DMA_CEEI_NOP_0 = 0x0
	// No operation, ignore the other bits in this register
	DMA_CEEI_NOP_1 = 0x1

	// SEEI: Set Enable Error Interrupt Register
	// Position of SEEI field.
	DMA_SEEI_SEEI_Pos = 0x0
	// Bit mask of SEEI field.
	DMA_SEEI_SEEI_Msk = 0x3
	// Position of SAEE field.
	DMA_SEEI_SAEE_Pos = 0x6
	// Bit mask of SAEE field.
	DMA_SEEI_SAEE_Msk = 0x40
	// Bit SAEE.
	DMA_SEEI_SAEE = 0x40
	// Set only the EEI bit specified in the SEEI field.
	DMA_SEEI_SAEE_0 = 0x0
	// Sets all bits in EEI
	DMA_SEEI_SAEE_1 = 0x1
	// Position of NOP field.
	DMA_SEEI_NOP_Pos = 0x7
	// Bit mask of NOP field.
	DMA_SEEI_NOP_Msk = 0x80
	// Bit NOP.
	DMA_SEEI_NOP = 0x80
	// Normal operation
	DMA_SEEI_NOP_0 = 0x0
	// No operation, ignore the other bits in this register
	DMA_SEEI_NOP_1 = 0x1

	// CERQ: Clear Enable Request Register
	// Position of CERQ field.
	DMA_CERQ_CERQ_Pos = 0x0
	// Bit mask of CERQ field.
	DMA_CERQ_CERQ_Msk = 0x3
	// Position of CAER field.
	DMA_CERQ_CAER_Pos = 0x6
	// Bit mask of CAER field.
	DMA_CERQ_CAER_Msk = 0x40
	// Bit CAER.
	DMA_CERQ_CAER = 0x40
	// Clear only the ERQ bit specified in the CERQ field
	DMA_CERQ_CAER_0 = 0x0
	// Clear all bits in ERQ
	DMA_CERQ_CAER_1 = 0x1
	// Position of NOP field.
	DMA_CERQ_NOP_Pos = 0x7
	// Bit mask of NOP field.
	DMA_CERQ_NOP_Msk = 0x80
	// Bit NOP.
	DMA_CERQ_NOP = 0x80
	// Normal operation
	DMA_CERQ_NOP_0 = 0x0
	// No operation, ignore the other bits in this register
	DMA_CERQ_NOP_1 = 0x1

	// SERQ: Set Enable Request Register
	// Position of SERQ field.
	DMA_SERQ_SERQ_Pos = 0x0
	// Bit mask of SERQ field.
	DMA_SERQ_SERQ_Msk = 0x3
	// Position of SAER field.
	DMA_SERQ_SAER_Pos = 0x6
	// Bit mask of SAER field.
	DMA_SERQ_SAER_Msk = 0x40
	// Bit SAER.
	DMA_SERQ_SAER = 0x40
	// Set only the ERQ bit specified in the SERQ field
	DMA_SERQ_SAER_0 = 0x0
	// Set all bits in ERQ
	DMA_SERQ_SAER_1 = 0x1
	// Position of NOP field.
	DMA_SERQ_NOP_Pos = 0x7
	// Bit mask of NOP field.
	DMA_SERQ_NOP_Msk = 0x80
	// Bit NOP.
	DMA_SERQ_NOP = 0x80
	// Normal operation
	DMA_SERQ_NOP_0 = 0x0
	// No operation, ignore the other bits in this register
	DMA_SERQ_NOP_1 = 0x1

	// CDNE: Clear DONE Status Bit Register
	// Position of CDNE field.
	DMA_CDNE_CDNE_Pos = 0x0
	// Bit mask of CDNE field.
	DMA_CDNE_CDNE_Msk = 0x3
	// Position of CADN field.
	DMA_CDNE_CADN_Pos = 0x6
	// Bit mask of CADN field.
	DMA_CDNE_CADN_Msk = 0x40
	// Bit CADN.
	DMA_CDNE_CADN = 0x40
	// Clears only the TCDn_CSR[DONE] bit specified in the CDNE field
	DMA_CDNE_CADN_0 = 0x0
	// Clears all bits in TCDn_CSR[DONE]
	DMA_CDNE_CADN_1 = 0x1
	// Position of NOP field.
	DMA_CDNE_NOP_Pos = 0x7
	// Bit mask of NOP field.
	DMA_CDNE_NOP_Msk = 0x80
	// Bit NOP.
	DMA_CDNE_NOP = 0x80
	// Normal operation
	DMA_CDNE_NOP_0 = 0x0
	// No operation, ignore the other bits in this register
	DMA_CDNE_NOP_1 = 0x1

	// SSRT: Set START Bit Register
	// Position of SSRT field.
	DMA_SSRT_SSRT_Pos = 0x0
	// Bit mask of SSRT field.
	DMA_SSRT_SSRT_Msk = 0x3
	// Position of SAST field.
	DMA_SSRT_SAST_Pos = 0x6
	// Bit mask of SAST field.
	DMA_SSRT_SAST_Msk = 0x40
	// Bit SAST.
	DMA_SSRT_SAST = 0x40
	// Set only the TCDn_CSR[START] bit specified in the SSRT field
	DMA_SSRT_SAST_0 = 0x0
	// Set all bits in TCDn_CSR[START]
	DMA_SSRT_SAST_1 = 0x1
	// Position of NOP field.
	DMA_SSRT_NOP_Pos = 0x7
	// Bit mask of NOP field.
	DMA_SSRT_NOP_Msk = 0x80
	// Bit NOP.
	DMA_SSRT_NOP = 0x80
	// Normal operation
	DMA_SSRT_NOP_0 = 0x0
	// No operation, ignore the other bits in this register
	DMA_SSRT_NOP_1 = 0x1

	// CERR: Clear Error Register
	// Position of CERR field.
	DMA_CERR_CERR_Pos = 0x0
	// Bit mask of CERR field.
	DMA_CERR_CERR_Msk = 0x3
	// Position of CAEI field.
	DMA_CERR_CAEI_Pos = 0x6
	// Bit mask of CAEI field.
	DMA_CERR_CAEI_Msk = 0x40
	// Bit CAEI.
	DMA_CERR_CAEI = 0x40
	// Clear only the ERR bit specified in the CERR field
	DMA_CERR_CAEI_0 = 0x0
	// Clear all bits in ERR
	DMA_CERR_CAEI_1 = 0x1
	// Position of NOP field.
	DMA_CERR_NOP_Pos = 0x7
	// Bit mask of NOP field.
	DMA_CERR_NOP_Msk = 0x80
	// Bit NOP.
	DMA_CERR_NOP = 0x80
	// Normal operation
	DMA_CERR_NOP_0 = 0x0
	// No operation, ignore the other bits in this register
	DMA_CERR_NOP_1 = 0x1

	// CINT: Clear Interrupt Request Register
	// Position of CINT field.
	DMA_CINT_CINT_Pos = 0x0
	// Bit mask of CINT field.
	DMA_CINT_CINT_Msk = 0x3
	// Position of CAIR field.
	DMA_CINT_CAIR_Pos = 0x6
	// Bit mask of CAIR field.
	DMA_CINT_CAIR_Msk = 0x40
	// Bit CAIR.
	DMA_CINT_CAIR = 0x40
	// Clear only the INT bit specified in the CINT field
	DMA_CINT_CAIR_0 = 0x0
	// Clear all bits in INT
	DMA_CINT_CAIR_1 = 0x1
	// Position of NOP field.
	DMA_CINT_NOP_Pos = 0x7
	// Bit mask of NOP field.
	DMA_CINT_NOP_Msk = 0x80
	// Bit NOP.
	DMA_CINT_NOP = 0x80
	// Normal operation
	DMA_CINT_NOP_0 = 0x0
	// No operation, ignore the other bits in this register
	DMA_CINT_NOP_1 = 0x1

	// INT: Interrupt Request Register
	// Position of INT0 field.
	DMA_INT_INT0_Pos = 0x0
	// Bit mask of INT0 field.
	DMA_INT_INT0_Msk = 0x1
	// Bit INT0.
	DMA_INT_INT0 = 0x1
	// The interrupt request for corresponding channel is cleared
	DMA_INT_INT0_0 = 0x0
	// The interrupt request for corresponding channel is active
	DMA_INT_INT0_1 = 0x1
	// Position of INT1 field.
	DMA_INT_INT1_Pos = 0x1
	// Bit mask of INT1 field.
	DMA_INT_INT1_Msk = 0x2
	// Bit INT1.
	DMA_INT_INT1 = 0x2
	// The interrupt request for corresponding channel is cleared
	DMA_INT_INT1_0 = 0x0
	// The interrupt request for corresponding channel is active
	DMA_INT_INT1_1 = 0x1
	// Position of INT2 field.
	DMA_INT_INT2_Pos = 0x2
	// Bit mask of INT2 field.
	DMA_INT_INT2_Msk = 0x4
	// Bit INT2.
	DMA_INT_INT2 = 0x4
	// The interrupt request for corresponding channel is cleared
	DMA_INT_INT2_0 = 0x0
	// The interrupt request for corresponding channel is active
	DMA_INT_INT2_1 = 0x1
	// Position of INT3 field.
	DMA_INT_INT3_Pos = 0x3
	// Bit mask of INT3 field.
	DMA_INT_INT3_Msk = 0x8
	// Bit INT3.
	DMA_INT_INT3 = 0x8
	// The interrupt request for corresponding channel is cleared
	DMA_INT_INT3_0 = 0x0
	// The interrupt request for corresponding channel is active
	DMA_INT_INT3_1 = 0x1

	// ERR: Error Register
	// Position of ERR0 field.
	DMA_ERR_ERR0_Pos = 0x0
	// Bit mask of ERR0 field.
	DMA_ERR_ERR0_Msk = 0x1
	// Bit ERR0.
	DMA_ERR_ERR0 = 0x1
	// An error in this channel has not occurred
	DMA_ERR_ERR0_0 = 0x0
	// An error in this channel has occurred
	DMA_ERR_ERR0_1 = 0x1
	// Position of ERR1 field.
	DMA_ERR_ERR1_Pos = 0x1
	// Bit mask of ERR1 field.
	DMA_ERR_ERR1_Msk = 0x2
	// Bit ERR1.
	DMA_ERR_ERR1 = 0x2
	// An error in this channel has not occurred
	DMA_ERR_ERR1_0 = 0x0
	// An error in this channel has occurred
	DMA_ERR_ERR1_1 = 0x1
	// Position of ERR2 field.
	DMA_ERR_ERR2_Pos = 0x2
	// Bit mask of ERR2 field.
	DMA_ERR_ERR2_Msk = 0x4
	// Bit ERR2.
	DMA_ERR_ERR2 = 0x4
	// An error in this channel has not occurred
	DMA_ERR_ERR2_0 = 0x0
	// An error in this channel has occurred
	DMA_ERR_ERR2_1 = 0x1
	// Position of ERR3 field.
	DMA_ERR_ERR3_Pos = 0x3
	// Bit mask of ERR3 field.
	DMA_ERR_ERR3_Msk = 0x8
	// Bit ERR3.
	DMA_ERR_ERR3 = 0x8
	// An error in this channel has not occurred
	DMA_ERR_ERR3_0 = 0x0
	// An error in this channel has occurred
	DMA_ERR_ERR3_1 = 0x1

	// HRS: Hardware Request Status Register
	// Position of HRS0 field.
	DMA_HRS_HRS0_Pos = 0x0
	// Bit mask of HRS0 field.
	DMA_HRS_HRS0_Msk = 0x1
	// Bit HRS0.
	DMA_HRS_HRS0 = 0x1
	// A hardware service request for channel 0 is not present
	DMA_HRS_HRS0_0 = 0x0
	// A hardware service request for channel 0 is present
	DMA_HRS_HRS0_1 = 0x1
	// Position of HRS1 field.
	DMA_HRS_HRS1_Pos = 0x1
	// Bit mask of HRS1 field.
	DMA_HRS_HRS1_Msk = 0x2
	// Bit HRS1.
	DMA_HRS_HRS1 = 0x2
	// A hardware service request for channel 1 is not present
	DMA_HRS_HRS1_0 = 0x0
	// A hardware service request for channel 1 is present
	DMA_HRS_HRS1_1 = 0x1
	// Position of HRS2 field.
	DMA_HRS_HRS2_Pos = 0x2
	// Bit mask of HRS2 field.
	DMA_HRS_HRS2_Msk = 0x4
	// Bit HRS2.
	DMA_HRS_HRS2 = 0x4
	// A hardware service request for channel 2 is not present
	DMA_HRS_HRS2_0 = 0x0
	// A hardware service request for channel 2 is present
	DMA_HRS_HRS2_1 = 0x1
	// Position of HRS3 field.
	DMA_HRS_HRS3_Pos = 0x3
	// Bit mask of HRS3 field.
	DMA_HRS_HRS3_Msk = 0x8
	// Bit HRS3.
	DMA_HRS_HRS3 = 0x8
	// A hardware service request for channel 3 is not present
	DMA_HRS_HRS3_0 = 0x0
	// A hardware service request for channel 3 is present
	DMA_HRS_HRS3_1 = 0x1

	// EARS: Enable Asynchronous Request in Stop Register
	// Position of EDREQ_0 field.
	DMA_EARS_EDREQ_0_Pos = 0x0
	// Bit mask of EDREQ_0 field.
	DMA_EARS_EDREQ_0_Msk = 0x1
	// Bit EDREQ_0.
	DMA_EARS_EDREQ_0 = 0x1
	// Disable asynchronous DMA request for channel 0.
	DMA_EARS_EDREQ_0_0 = 0x0
	// Enable asynchronous DMA request for channel 0.
	DMA_EARS_EDREQ_0_1 = 0x1
	// Position of EDREQ_1 field.
	DMA_EARS_EDREQ_1_Pos = 0x1
	// Bit mask of EDREQ_1 field.
	DMA_EARS_EDREQ_1_Msk = 0x2
	// Bit EDREQ_1.
	DMA_EARS_EDREQ_1 = 0x2
	// Disable asynchronous DMA request for channel 1
	DMA_EARS_EDREQ_1_0 = 0x0
	// Enable asynchronous DMA request for channel 1.
	DMA_EARS_EDREQ_1_1 = 0x1
	// Position of EDREQ_2 field.
	DMA_EARS_EDREQ_2_Pos = 0x2
	// Bit mask of EDREQ_2 field.
	DMA_EARS_EDREQ_2_Msk = 0x4
	// Bit EDREQ_2.
	DMA_EARS_EDREQ_2 = 0x4
	// Disable asynchronous DMA request for channel 2.
	DMA_EARS_EDREQ_2_0 = 0x0
	// Enable asynchronous DMA request for channel 2.
	DMA_EARS_EDREQ_2_1 = 0x1
	// Position of EDREQ_3 field.
	DMA_EARS_EDREQ_3_Pos = 0x3
	// Bit mask of EDREQ_3 field.
	DMA_EARS_EDREQ_3_Msk = 0x8
	// Bit EDREQ_3.
	DMA_EARS_EDREQ_3 = 0x8
	// Disable asynchronous DMA request for channel 3.
	DMA_EARS_EDREQ_3_0 = 0x0
	// Enable asynchronous DMA request for channel 3.
	DMA_EARS_EDREQ_3_1 = 0x1

	// DCHPRI3: Channel n Priority Register
	// Position of CHPRI field.
	DMA_DCHPRI_CHPRI_Pos = 0x0
	// Bit mask of CHPRI field.
	DMA_DCHPRI_CHPRI_Msk = 0x3
	// Position of DPA field.
	DMA_DCHPRI_DPA_Pos = 0x6
	// Bit mask of DPA field.
	DMA_DCHPRI_DPA_Msk = 0x40
	// Bit DPA.
	DMA_DCHPRI_DPA = 0x40
	// Channel n can suspend a lower priority channel.
	DMA_DCHPRI_DPA_0 = 0x0
	// Channel n cannot suspend any channel, regardless of channel priority.
	DMA_DCHPRI_DPA_1 = 0x1
	// Position of ECP field.
	DMA_DCHPRI_ECP_Pos = 0x7
	// Bit mask of ECP field.
	DMA_DCHPRI_ECP_Msk = 0x80
	// Bit ECP.
	DMA_DCHPRI_ECP = 0x80
	// Channel n cannot be suspended by a higher priority channel's service request.
	DMA_DCHPRI_ECP_0 = 0x0
	// Channel n can be temporarily suspended by the service request of a higher priority channel.
	DMA_DCHPRI_ECP_1 = 0x1

	// TCD0_SADDR: TCD Source Address
	// Position of SADDR field.
	DMA_TCD_SADDR_SADDR_Pos = 0x0
	// Bit mask of SADDR field.
	DMA_TCD_SADDR_SADDR_Msk = 0xffffffff

	// TCD0_SOFF: TCD Signed Source Address Offset
	// Position of SOFF field.
	DMA_TCD_SOFF_SOFF_Pos = 0x0
	// Bit mask of SOFF field.
	DMA_TCD_SOFF_SOFF_Msk = 0xffff

	// TCD0_ATTR: TCD Transfer Attributes
	// Position of DSIZE field.
	DMA_TCD_ATTR_DSIZE_Pos = 0x0
	// Bit mask of DSIZE field.
	DMA_TCD_ATTR_DSIZE_Msk = 0x7
	// Position of DMOD field.
	DMA_TCD_ATTR_DMOD_Pos = 0x3
	// Bit mask of DMOD field.
	DMA_TCD_ATTR_DMOD_Msk = 0xf8
	// Position of SSIZE field.
	DMA_TCD_ATTR_SSIZE_Pos = 0x8
	// Bit mask of SSIZE field.
	DMA_TCD_ATTR_SSIZE_Msk = 0x700
	// 8-bit
	DMA_TCD_ATTR_SSIZE_000 = 0x0
	// 16-bit
	DMA_TCD_ATTR_SSIZE_001 = 0x1
	// 32-bit
	DMA_TCD_ATTR_SSIZE_010 = 0x2
	// 16-byte
	DMA_TCD_ATTR_SSIZE_100 = 0x4
	// 32-byte
	DMA_TCD_ATTR_SSIZE_101 = 0x5
	// Position of SMOD field.
	DMA_TCD_ATTR_SMOD_Pos = 0xb
	// Bit mask of SMOD field.
	DMA_TCD_ATTR_SMOD_Msk = 0xf800
	// Source address modulo feature is disabled
	DMA_TCD_ATTR_SMOD_0 = 0x0

	// TCD0_NBYTES_MLNO: TCD Minor Byte Count (Minor Loop Mapping Disabled)
	// Position of NBYTES field.
	DMA_TCD_NBYTES_MLNO_NBYTES_Pos = 0x0
	// Bit mask of NBYTES field.
	DMA_TCD_NBYTES_MLNO_NBYTES_Msk = 0xffffffff

	// TCD0_NBYTES_MLOFFNO: TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled)
	// Position of NBYTES field.
	DMA_TCD_NBYTES_MLOFFNO_NBYTES_Pos = 0x0
	// Bit mask of NBYTES field.
	DMA_TCD_NBYTES_MLOFFNO_NBYTES_Msk = 0x3fffffff
	// Position of DMLOE field.
	DMA_TCD_NBYTES_MLOFFNO_DMLOE_Pos = 0x1e
	// Bit mask of DMLOE field.
	DMA_TCD_NBYTES_MLOFFNO_DMLOE_Msk = 0x40000000
	// Bit DMLOE.
	DMA_TCD_NBYTES_MLOFFNO_DMLOE = 0x40000000
	// The minor loop offset is not applied to the DADDR
	DMA_TCD_NBYTES_MLOFFNO_DMLOE_0 = 0x0
	// The minor loop offset is applied to the DADDR
	DMA_TCD_NBYTES_MLOFFNO_DMLOE_1 = 0x1
	// Position of SMLOE field.
	DMA_TCD_NBYTES_MLOFFNO_SMLOE_Pos = 0x1f
	// Bit mask of SMLOE field.
	DMA_TCD_NBYTES_MLOFFNO_SMLOE_Msk = 0x80000000
	// Bit SMLOE.
	DMA_TCD_NBYTES_MLOFFNO_SMLOE = 0x80000000
	// The minor loop offset is not applied to the SADDR
	DMA_TCD_NBYTES_MLOFFNO_SMLOE_0 = 0x0
	// The minor loop offset is applied to the SADDR
	DMA_TCD_NBYTES_MLOFFNO_SMLOE_1 = 0x1

	// TCD0_NBYTES_MLOFFYES: TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled)
	// Position of NBYTES field.
	DMA_TCD_NBYTES_MLOFFYES_NBYTES_Pos = 0x0
	// Bit mask of NBYTES field.
	DMA_TCD_NBYTES_MLOFFYES_NBYTES_Msk = 0x3ff
	// Position of MLOFF field.
	DMA_TCD_NBYTES_MLOFFYES_MLOFF_Pos = 0xa
	// Bit mask of MLOFF field.
	DMA_TCD_NBYTES_MLOFFYES_MLOFF_Msk = 0x3ffffc00
	// Position of DMLOE field.
	DMA_TCD_NBYTES_MLOFFYES_DMLOE_Pos = 0x1e
	// Bit mask of DMLOE field.
	DMA_TCD_NBYTES_MLOFFYES_DMLOE_Msk = 0x40000000
	// Bit DMLOE.
	DMA_TCD_NBYTES_MLOFFYES_DMLOE = 0x40000000
	// The minor loop offset is not applied to the DADDR
	DMA_TCD_NBYTES_MLOFFYES_DMLOE_0 = 0x0
	// The minor loop offset is applied to the DADDR
	DMA_TCD_NBYTES_MLOFFYES_DMLOE_1 = 0x1
	// Position of SMLOE field.
	DMA_TCD_NBYTES_MLOFFYES_SMLOE_Pos = 0x1f
	// Bit mask of SMLOE field.
	DMA_TCD_NBYTES_MLOFFYES_SMLOE_Msk = 0x80000000
	// Bit SMLOE.
	DMA_TCD_NBYTES_MLOFFYES_SMLOE = 0x80000000
	// The minor loop offset is not applied to the SADDR
	DMA_TCD_NBYTES_MLOFFYES_SMLOE_0 = 0x0
	// The minor loop offset is applied to the SADDR
	DMA_TCD_NBYTES_MLOFFYES_SMLOE_1 = 0x1

	// TCD0_SLAST: TCD Last Source Address Adjustment
	// Position of SLAST field.
	DMA_TCD_SLAST_SLAST_Pos = 0x0
	// Bit mask of SLAST field.
	DMA_TCD_SLAST_SLAST_Msk = 0xffffffff

	// TCD0_DADDR: TCD Destination Address
	// Position of DADDR field.
	DMA_TCD_DADDR_DADDR_Pos = 0x0
	// Bit mask of DADDR field.
	DMA_TCD_DADDR_DADDR_Msk = 0xffffffff

	// TCD0_DOFF: TCD Signed Destination Address Offset
	// Position of DOFF field.
	DMA_TCD_DOFF_DOFF_Pos = 0x0
	// Bit mask of DOFF field.
	DMA_TCD_DOFF_DOFF_Msk = 0xffff

	// TCD0_CITER_ELINKNO: TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled)
	// Position of CITER field.
	DMA_TCD_CITER_ELINKNO_CITER_Pos = 0x0
	// Bit mask of CITER field.
	DMA_TCD_CITER_ELINKNO_CITER_Msk = 0x7fff
	// Position of ELINK field.
	DMA_TCD_CITER_ELINKNO_ELINK_Pos = 0xf
	// Bit mask of ELINK field.
	DMA_TCD_CITER_ELINKNO_ELINK_Msk = 0x8000
	// Bit ELINK.
	DMA_TCD_CITER_ELINKNO_ELINK = 0x8000
	// The channel-to-channel linking is disabled
	DMA_TCD_CITER_ELINKNO_ELINK_0 = 0x0
	// The channel-to-channel linking is enabled
	DMA_TCD_CITER_ELINKNO_ELINK_1 = 0x1

	// TCD0_CITER_ELINKYES: TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled)
	// Position of CITER field.
	DMA_TCD_CITER_ELINKYES_CITER_Pos = 0x0
	// Bit mask of CITER field.
	DMA_TCD_CITER_ELINKYES_CITER_Msk = 0x1ff
	// Position of LINKCH field.
	DMA_TCD_CITER_ELINKYES_LINKCH_Pos = 0x9
	// Bit mask of LINKCH field.
	DMA_TCD_CITER_ELINKYES_LINKCH_Msk = 0x600
	// Position of ELINK field.
	DMA_TCD_CITER_ELINKYES_ELINK_Pos = 0xf
	// Bit mask of ELINK field.
	DMA_TCD_CITER_ELINKYES_ELINK_Msk = 0x8000
	// Bit ELINK.
	DMA_TCD_CITER_ELINKYES_ELINK = 0x8000
	// The channel-to-channel linking is disabled
	DMA_TCD_CITER_ELINKYES_ELINK_0 = 0x0
	// The channel-to-channel linking is enabled
	DMA_TCD_CITER_ELINKYES_ELINK_1 = 0x1

	// TCD0_DLASTSGA: TCD Last Destination Address Adjustment/Scatter Gather Address
	// Position of DLASTSGA field.
	DMA_TCD_DLASTSGA_DLASTSGA_Pos = 0x0
	// Bit mask of DLASTSGA field.
	DMA_TCD_DLASTSGA_DLASTSGA_Msk = 0xffffffff

	// TCD0_CSR: TCD Control and Status
	// Position of START field.
	DMA_TCD_CSR_START_Pos = 0x0
	// Bit mask of START field.
	DMA_TCD_CSR_START_Msk = 0x1
	// Bit START.
	DMA_TCD_CSR_START = 0x1
	// The channel is not explicitly started.
	DMA_TCD_CSR_START_0 = 0x0
	// The channel is explicitly started via a software initiated service request.
	DMA_TCD_CSR_START_1 = 0x1
	// Position of INTMAJOR field.
	DMA_TCD_CSR_INTMAJOR_Pos = 0x1
	// Bit mask of INTMAJOR field.
	DMA_TCD_CSR_INTMAJOR_Msk = 0x2
	// Bit INTMAJOR.
	DMA_TCD_CSR_INTMAJOR = 0x2
	// The end-of-major loop interrupt is disabled.
	DMA_TCD_CSR_INTMAJOR_0 = 0x0
	// The end-of-major loop interrupt is enabled.
	DMA_TCD_CSR_INTMAJOR_1 = 0x1
	// Position of INTHALF field.
	DMA_TCD_CSR_INTHALF_Pos = 0x2
	// Bit mask of INTHALF field.
	DMA_TCD_CSR_INTHALF_Msk = 0x4
	// Bit INTHALF.
	DMA_TCD_CSR_INTHALF = 0x4
	// The half-point interrupt is disabled.
	DMA_TCD_CSR_INTHALF_0 = 0x0
	// The half-point interrupt is enabled.
	DMA_TCD_CSR_INTHALF_1 = 0x1
	// Position of DREQ field.
	DMA_TCD_CSR_DREQ_Pos = 0x3
	// Bit mask of DREQ field.
	DMA_TCD_CSR_DREQ_Msk = 0x8
	// Bit DREQ.
	DMA_TCD_CSR_DREQ = 0x8
	// The channel's ERQ bit is not affected.
	DMA_TCD_CSR_DREQ_0 = 0x0
	// The channel's ERQ bit is cleared when the major loop is complete.
	DMA_TCD_CSR_DREQ_1 = 0x1
	// Position of ESG field.
	DMA_TCD_CSR_ESG_Pos = 0x4
	// Bit mask of ESG field.
	DMA_TCD_CSR_ESG_Msk = 0x10
	// Bit ESG.
	DMA_TCD_CSR_ESG = 0x10
	// The current channel's TCD is normal format.
	DMA_TCD_CSR_ESG_0 = 0x0
	// The current channel's TCD specifies a scatter gather format. The DLASTSGA field provides a memory pointer to the next TCD to be loaded into this channel after the major loop completes its execution.
	DMA_TCD_CSR_ESG_1 = 0x1
	// Position of MAJORELINK field.
	DMA_TCD_CSR_MAJORELINK_Pos = 0x5
	// Bit mask of MAJORELINK field.
	DMA_TCD_CSR_MAJORELINK_Msk = 0x20
	// Bit MAJORELINK.
	DMA_TCD_CSR_MAJORELINK = 0x20
	// The channel-to-channel linking is disabled.
	DMA_TCD_CSR_MAJORELINK_0 = 0x0
	// The channel-to-channel linking is enabled.
	DMA_TCD_CSR_MAJORELINK_1 = 0x1
	// Position of ACTIVE field.
	DMA_TCD_CSR_ACTIVE_Pos = 0x6
	// Bit mask of ACTIVE field.
	DMA_TCD_CSR_ACTIVE_Msk = 0x40
	// Bit ACTIVE.
	DMA_TCD_CSR_ACTIVE = 0x40
	// Position of DONE field.
	DMA_TCD_CSR_DONE_Pos = 0x7
	// Bit mask of DONE field.
	DMA_TCD_CSR_DONE_Msk = 0x80
	// Bit DONE.
	DMA_TCD_CSR_DONE = 0x80
	// Position of MAJORLINKCH field.
	DMA_TCD_CSR_MAJORLINKCH_Pos = 0x8
	// Bit mask of MAJORLINKCH field.
	DMA_TCD_CSR_MAJORLINKCH_Msk = 0x300
	// Position of BWC field.
	DMA_TCD_CSR_BWC_Pos = 0xe
	// Bit mask of BWC field.
	DMA_TCD_CSR_BWC_Msk = 0xc000
	// No eDMA engine stalls.
	DMA_TCD_CSR_BWC_00 = 0x0
	// eDMA engine stalls for 4 cycles after each R/W.
	DMA_TCD_CSR_BWC_10 = 0x2
	// eDMA engine stalls for 8 cycles after each R/W.
	DMA_TCD_CSR_BWC_11 = 0x3

	// TCD0_BITER_ELINKNO: TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled)
	// Position of BITER field.
	DMA_TCD_BITER_ELINKNO_BITER_Pos = 0x0
	// Bit mask of BITER field.
	DMA_TCD_BITER_ELINKNO_BITER_Msk = 0x7fff
	// Position of ELINK field.
	DMA_TCD_BITER_ELINKNO_ELINK_Pos = 0xf
	// Bit mask of ELINK field.
	DMA_TCD_BITER_ELINKNO_ELINK_Msk = 0x8000
	// Bit ELINK.
	DMA_TCD_BITER_ELINKNO_ELINK = 0x8000
	// The channel-to-channel linking is disabled
	DMA_TCD_BITER_ELINKNO_ELINK_0 = 0x0
	// The channel-to-channel linking is enabled
	DMA_TCD_BITER_ELINKNO_ELINK_1 = 0x1

	// TCD0_BITER_ELINKYES: TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled)
	// Position of BITER field.
	DMA_TCD_BITER_ELINKYES_BITER_Pos = 0x0
	// Bit mask of BITER field.
	DMA_TCD_BITER_ELINKYES_BITER_Msk = 0x1ff
	// Position of LINKCH field.
	DMA_TCD_BITER_ELINKYES_LINKCH_Pos = 0x9
	// Bit mask of LINKCH field.
	DMA_TCD_BITER_ELINKYES_LINKCH_Msk = 0x600
	// Position of ELINK field.
	DMA_TCD_BITER_ELINKYES_ELINK_Pos = 0xf
	// Bit mask of ELINK field.
	DMA_TCD_BITER_ELINKYES_ELINK_Msk = 0x8000
	// Bit ELINK.
	DMA_TCD_BITER_ELINKYES_ELINK = 0x8000
	// The channel-to-channel linking is disabled
	DMA_TCD_BITER_ELINKYES_ELINK_0 = 0x0
	// The channel-to-channel linking is enabled
	DMA_TCD_BITER_ELINKYES_ELINK_1 = 0x1
)

// Bitfields for FTFA: Flash Memory Interface
const (
	// FSTAT: Flash Status Register
	// Position of MGSTAT0 field.
	FTFA_FSTAT_MGSTAT0_Pos = 0x0
	// Bit mask of MGSTAT0 field.
	FTFA_FSTAT_MGSTAT0_Msk = 0x1
	// Bit MGSTAT0.
	FTFA_FSTAT_MGSTAT0 = 0x1
	// Position of FPVIOL field.
	FTFA_FSTAT_FPVIOL_Pos = 0x4
	// Bit mask of FPVIOL field.
	FTFA_FSTAT_FPVIOL_Msk = 0x10
	// Bit FPVIOL.
	FTFA_FSTAT_FPVIOL = 0x10
	// No protection violation detected
	FTFA_FSTAT_FPVIOL_0 = 0x0
	// Protection violation detected
	FTFA_FSTAT_FPVIOL_1 = 0x1
	// Position of ACCERR field.
	FTFA_FSTAT_ACCERR_Pos = 0x5
	// Bit mask of ACCERR field.
	FTFA_FSTAT_ACCERR_Msk = 0x20
	// Bit ACCERR.
	FTFA_FSTAT_ACCERR = 0x20
	// No access error detected
	FTFA_FSTAT_ACCERR_0 = 0x0
	// Access error detected
	FTFA_FSTAT_ACCERR_1 = 0x1
	// Position of RDCOLERR field.
	FTFA_FSTAT_RDCOLERR_Pos = 0x6
	// Bit mask of RDCOLERR field.
	FTFA_FSTAT_RDCOLERR_Msk = 0x40
	// Bit RDCOLERR.
	FTFA_FSTAT_RDCOLERR = 0x40
	// No collision error detected
	FTFA_FSTAT_RDCOLERR_0 = 0x0
	// Collision error detected
	FTFA_FSTAT_RDCOLERR_1 = 0x1
	// Position of CCIF field.
	FTFA_FSTAT_CCIF_Pos = 0x7
	// Bit mask of CCIF field.
	FTFA_FSTAT_CCIF_Msk = 0x80
	// Bit CCIF.
	FTFA_FSTAT_CCIF = 0x80
	// Flash command in progress
	FTFA_FSTAT_CCIF_0 = 0x0
	// Flash command has completed
	FTFA_FSTAT_CCIF_1 = 0x1

	// FCNFG: Flash Configuration Register
	// Position of ERSSUSP field.
	FTFA_FCNFG_ERSSUSP_Pos = 0x4
	// Bit mask of ERSSUSP field.
	FTFA_FCNFG_ERSSUSP_Msk = 0x10
	// Bit ERSSUSP.
	FTFA_FCNFG_ERSSUSP = 0x10
	// No suspend requested
	FTFA_FCNFG_ERSSUSP_0 = 0x0
	// Suspend the current Erase Flash Sector command execution.
	FTFA_FCNFG_ERSSUSP_1 = 0x1
	// Position of ERSAREQ field.
	FTFA_FCNFG_ERSAREQ_Pos = 0x5
	// Bit mask of ERSAREQ field.
	FTFA_FCNFG_ERSAREQ_Msk = 0x20
	// Bit ERSAREQ.
	FTFA_FCNFG_ERSAREQ = 0x20
	// No request or request complete
	FTFA_FCNFG_ERSAREQ_0 = 0x0
	// Request to: run the Erase All Blocks command, verify the erased state, program the security byte in the Flash Configuration Field to the unsecure state, and release MCU security by setting the FSEC[SEC] field to the unsecure state.
	FTFA_FCNFG_ERSAREQ_1 = 0x1
	// Position of RDCOLLIE field.
	FTFA_FCNFG_RDCOLLIE_Pos = 0x6
	// Bit mask of RDCOLLIE field.
	FTFA_FCNFG_RDCOLLIE_Msk = 0x40
	// Bit RDCOLLIE.
	FTFA_FCNFG_RDCOLLIE = 0x40
	// Read collision error interrupt disabled
	FTFA_FCNFG_RDCOLLIE_0 = 0x0
	// Read collision error interrupt enabled. An interrupt request is generated whenever a flash memory read collision error is detected (see the description of FSTAT[RDCOLERR]).
	FTFA_FCNFG_RDCOLLIE_1 = 0x1
	// Position of CCIE field.
	FTFA_FCNFG_CCIE_Pos = 0x7
	// Bit mask of CCIE field.
	FTFA_FCNFG_CCIE_Msk = 0x80
	// Bit CCIE.
	FTFA_FCNFG_CCIE = 0x80
	// Command complete interrupt disabled
	FTFA_FCNFG_CCIE_0 = 0x0
	// Command complete interrupt enabled. An interrupt request is generated whenever the FSTAT[CCIF] flag is set.
	FTFA_FCNFG_CCIE_1 = 0x1

	// FSEC: Flash Security Register
	// Position of SEC field.
	FTFA_FSEC_SEC_Pos = 0x0
	// Bit mask of SEC field.
	FTFA_FSEC_SEC_Msk = 0x3
	// MCU security status is secure.
	FTFA_FSEC_SEC_00 = 0x0
	// MCU security status is secure.
	FTFA_FSEC_SEC_01 = 0x1
	// MCU security status is unsecure. (The standard shipping condition of the flash memory module is unsecure.)
	FTFA_FSEC_SEC_10 = 0x2
	// MCU security status is secure.
	FTFA_FSEC_SEC_11 = 0x3
	// Position of FSLACC field.
	FTFA_FSEC_FSLACC_Pos = 0x2
	// Bit mask of FSLACC field.
	FTFA_FSEC_FSLACC_Msk = 0xc
	// NXP factory access granted
	FTFA_FSEC_FSLACC_00 = 0x0
	// NXP factory access denied
	FTFA_FSEC_FSLACC_01 = 0x1
	// NXP factory access denied
	FTFA_FSEC_FSLACC_10 = 0x2
	// NXP factory access granted
	FTFA_FSEC_FSLACC_11 = 0x3
	// Position of MEEN field.
	FTFA_FSEC_MEEN_Pos = 0x4
	// Bit mask of MEEN field.
	FTFA_FSEC_MEEN_Msk = 0x30
	// Mass erase is enabled
	FTFA_FSEC_MEEN_00 = 0x0
	// Mass erase is enabled
	FTFA_FSEC_MEEN_01 = 0x1
	// Mass erase is disabled
	FTFA_FSEC_MEEN_10 = 0x2
	// Mass erase is enabled
	FTFA_FSEC_MEEN_11 = 0x3
	// Position of KEYEN field.
	FTFA_FSEC_KEYEN_Pos = 0x6
	// Bit mask of KEYEN field.
	FTFA_FSEC_KEYEN_Msk = 0xc0
	// Backdoor key access disabled
	FTFA_FSEC_KEYEN_00 = 0x0
	// Backdoor key access disabled (preferred KEYEN state to disable backdoor key access)
	FTFA_FSEC_KEYEN_01 = 0x1
	// Backdoor key access enabled
	FTFA_FSEC_KEYEN_10 = 0x2
	// Backdoor key access disabled
	FTFA_FSEC_KEYEN_11 = 0x3

	// FOPT: Flash Option Register
	// Position of OPT field.
	FTFA_FOPT_OPT_Pos = 0x0
	// Bit mask of OPT field.
	FTFA_FOPT_OPT_Msk = 0xff

	// FCCOB3: Flash Common Command Object Registers
	// Position of CCOBn field.
	FTFA_FCCOB_CCOBn_Pos = 0x0
	// Bit mask of CCOBn field.
	FTFA_FCCOB_CCOBn_Msk = 0xff

	// FPROT3: Program Flash Protection Registers
	// Position of PROT field.
	FTFA_FPROT_PROT_Pos = 0x0
	// Bit mask of PROT field.
	FTFA_FPROT_PROT_Msk = 0xff
	// Program flash region is protected.
	FTFA_FPROT_PROT_0 = 0x0
	// Program flash region is not protected
	FTFA_FPROT_PROT_1 = 0x1

	// XACCH3: Execute-only Access Registers
	// Position of XA field.
	FTFA_XACC_XA_Pos = 0x0
	// Bit mask of XA field.
	FTFA_XACC_XA_Msk = 0xff
	// Associated segment is accessible in execute mode only (as an instruction fetch)
	FTFA_XACC_XA_0 = 0x0
	// Associated segment is accessible as data or in execute mode
	FTFA_XACC_XA_1 = 0x1

	// SACCH3: Supervisor-only Access Registers
	// Position of SA field.
	FTFA_SACC_SA_Pos = 0x0
	// Bit mask of SA field.
	FTFA_SACC_SA_Msk = 0xff
	// Associated segment is accessible in supervisor mode only
	FTFA_SACC_SA_0 = 0x0
	// Associated segment is accessible in user or supervisor mode
	FTFA_SACC_SA_1 = 0x1

	// FACSS: Flash Access Segment Size Register
	// Position of SGSIZE field.
	FTFA_FACSS_SGSIZE_Pos = 0x0
	// Bit mask of SGSIZE field.
	FTFA_FACSS_SGSIZE_Msk = 0xff

	// FACSN: Flash Access Segment Number Register
	// Position of NUMSG field.
	FTFA_FACSN_NUMSG_Pos = 0x0
	// Bit mask of NUMSG field.
	FTFA_FACSN_NUMSG_Msk = 0xff
	// Program flash memory is divided into 32 segments (64 Kbytes, 128 Kbytes)
	FTFA_FACSN_NUMSG_100000 = 0x20
	// Program flash memory is divided into 40 segments (160 Kbytes)
	FTFA_FACSN_NUMSG_101000 = 0x28
	// Program flash memory is divided into 64 segments (256 Kbytes, 512 Kbytes)
	FTFA_FACSN_NUMSG_1000000 = 0x40
)

// Bitfields for DMAMUX0: DMA channel multiplexor
const (
	// CHCFG0: Channel Configuration register
	// Position of SOURCE field.
	DMAMUX0_CHCFG_SOURCE_Pos = 0x0
	// Bit mask of SOURCE field.
	DMAMUX0_CHCFG_SOURCE_Msk = 0x3f
	// Disable_Signal
	DMAMUX0_CHCFG_SOURCE_0 = 0x0
	// LPUART0_Rx_Signal
	DMAMUX0_CHCFG_SOURCE_2 = 0x2
	// LPUART0_Tx_Signal
	DMAMUX0_CHCFG_SOURCE_3 = 0x3
	// SPI0_Rx_Signal
	DMAMUX0_CHCFG_SOURCE_16 = 0x10
	// SPI0_Tx_Signal
	DMAMUX0_CHCFG_SOURCE_17 = 0x11
	// SPI1_Rx_Signal
	DMAMUX0_CHCFG_SOURCE_18 = 0x12
	// SPI1_Tx_Signal
	DMAMUX0_CHCFG_SOURCE_19 = 0x13
	// LTC0_Input_FIFO_Signal
	DMAMUX0_CHCFG_SOURCE_20 = 0x14
	// LTC0_Output_FIFO_Signal
	DMAMUX0_CHCFG_SOURCE_21 = 0x15
	// I2C0_Signal
	DMAMUX0_CHCFG_SOURCE_22 = 0x16
	// I2C1_Signal
	DMAMUX0_CHCFG_SOURCE_23 = 0x17
	// TPM0_Channel0_Signal
	DMAMUX0_CHCFG_SOURCE_24 = 0x18
	// TPM0_Channel1_Signal
	DMAMUX0_CHCFG_SOURCE_25 = 0x19
	// TPM0_Channel2_Signal
	DMAMUX0_CHCFG_SOURCE_26 = 0x1a
	// TPM0_Channel3_Signal
	DMAMUX0_CHCFG_SOURCE_27 = 0x1b
	// TPM1_Channel0_Signal
	DMAMUX0_CHCFG_SOURCE_32 = 0x20
	// TPM1_Channel1_Signal
	DMAMUX0_CHCFG_SOURCE_33 = 0x21
	// TPM2_Channel0_Signal
	DMAMUX0_CHCFG_SOURCE_34 = 0x22
	// TPM2_Channel1_Signal
	DMAMUX0_CHCFG_SOURCE_35 = 0x23
	// ADC0_Signal
	DMAMUX0_CHCFG_SOURCE_40 = 0x28
	// CMP0_Signal
	DMAMUX0_CHCFG_SOURCE_42 = 0x2a
	// DAC0_Signal
	DMAMUX0_CHCFG_SOURCE_45 = 0x2d
	// CMT_Signal
	DMAMUX0_CHCFG_SOURCE_47 = 0x2f
	// PortA_Signal
	DMAMUX0_CHCFG_SOURCE_49 = 0x31
	// PortB_Signal
	DMAMUX0_CHCFG_SOURCE_50 = 0x32
	// PortC_Signal
	DMAMUX0_CHCFG_SOURCE_51 = 0x33
	// TPM0_Overflow_Signal
	DMAMUX0_CHCFG_SOURCE_54 = 0x36
	// TPM1_Overflow_Signal
	DMAMUX0_CHCFG_SOURCE_55 = 0x37
	// TPM2_Overflow_Signal
	DMAMUX0_CHCFG_SOURCE_56 = 0x38
	// TSI0_Signal
	DMAMUX0_CHCFG_SOURCE_57 = 0x39
	// AlwaysOn60_Signal
	DMAMUX0_CHCFG_SOURCE_60 = 0x3c
	// AlwaysOn61_Signal
	DMAMUX0_CHCFG_SOURCE_61 = 0x3d
	// AlwaysOn62_Signal
	DMAMUX0_CHCFG_SOURCE_62 = 0x3e
	// AlwaysOn63_Signal
	DMAMUX0_CHCFG_SOURCE_63 = 0x3f
	// Position of TRIG field.
	DMAMUX0_CHCFG_TRIG_Pos = 0x6
	// Bit mask of TRIG field.
	DMAMUX0_CHCFG_TRIG_Msk = 0x40
	// Bit TRIG.
	DMAMUX0_CHCFG_TRIG = 0x40
	// Triggering is disabled. If triggering is disabled and ENBL is set, the DMA Channel will simply route the specified source to the DMA channel. (Normal mode)
	DMAMUX0_CHCFG_TRIG_0 = 0x0
	// Triggering is enabled. If triggering is enabled and ENBL is set, the DMAMUX is in Periodic Trigger mode.
	DMAMUX0_CHCFG_TRIG_1 = 0x1
	// Position of ENBL field.
	DMAMUX0_CHCFG_ENBL_Pos = 0x7
	// Bit mask of ENBL field.
	DMAMUX0_CHCFG_ENBL_Msk = 0x80
	// Bit ENBL.
	DMAMUX0_CHCFG_ENBL = 0x80
	// DMA channel is disabled. This mode is primarily used during configuration of the DMAMux. The DMA has separate channel enables/disables, which should be used to disable or reconfigure a DMA channel.
	DMAMUX0_CHCFG_ENBL_0 = 0x0
	// DMA channel is enabled
	DMAMUX0_CHCFG_ENBL_1 = 0x1
)

// Bitfields for TRNG0: TRNG0
const (
	// MCTL: Miscellaneous Control Register
	// Position of SAMP_MODE field.
	TRNG0_MCTL_SAMP_MODE_Pos = 0x0
	// Bit mask of SAMP_MODE field.
	TRNG0_MCTL_SAMP_MODE_Msk = 0x3
	// use Von Neumann data into both Entropy shifter and Statistical Checker
	TRNG0_MCTL_SAMP_MODE_00 = 0x0
	// use raw data into both Entropy shifter and Statistical Checker
	TRNG0_MCTL_SAMP_MODE_01 = 0x1
	// use Von Neumann data into Entropy shifter. Use raw data into Statistical Checker
	TRNG0_MCTL_SAMP_MODE_10 = 0x2
	// undefined/reserved.
	TRNG0_MCTL_SAMP_MODE_11 = 0x3
	// Position of OSC_DIV field.
	TRNG0_MCTL_OSC_DIV_Pos = 0x2
	// Bit mask of OSC_DIV field.
	TRNG0_MCTL_OSC_DIV_Msk = 0xc
	// use ring oscillator with no divide
	TRNG0_MCTL_OSC_DIV_00 = 0x0
	// use ring oscillator divided-by-2
	TRNG0_MCTL_OSC_DIV_01 = 0x1
	// use ring oscillator divided-by-4
	TRNG0_MCTL_OSC_DIV_10 = 0x2
	// use ring oscillator divided-by-8
	TRNG0_MCTL_OSC_DIV_11 = 0x3
	// Position of UNUSED field.
	TRNG0_MCTL_UNUSED_Pos = 0x4
	// Bit mask of UNUSED field.
	TRNG0_MCTL_UNUSED_Msk = 0x10
	// Bit UNUSED.
	TRNG0_MCTL_UNUSED = 0x10
	// Position of TRNG_ACC field.
	TRNG0_MCTL_TRNG_ACC_Pos = 0x5
	// Bit mask of TRNG_ACC field.
	TRNG0_MCTL_TRNG_ACC_Msk = 0x20
	// Bit TRNG_ACC.
	TRNG0_MCTL_TRNG_ACC = 0x20
	// Position of RST_DEF field.
	TRNG0_MCTL_RST_DEF_Pos = 0x6
	// Bit mask of RST_DEF field.
	TRNG0_MCTL_RST_DEF_Msk = 0x40
	// Bit RST_DEF.
	TRNG0_MCTL_RST_DEF = 0x40
	// Position of FOR_SCLK field.
	TRNG0_MCTL_FOR_SCLK_Pos = 0x7
	// Bit mask of FOR_SCLK field.
	TRNG0_MCTL_FOR_SCLK_Msk = 0x80
	// Bit FOR_SCLK.
	TRNG0_MCTL_FOR_SCLK = 0x80
	// Position of FCT_FAIL field.
	TRNG0_MCTL_FCT_FAIL_Pos = 0x8
	// Bit mask of FCT_FAIL field.
	TRNG0_MCTL_FCT_FAIL_Msk = 0x100
	// Bit FCT_FAIL.
	TRNG0_MCTL_FCT_FAIL = 0x100
	// Position of FCT_VAL field.
	TRNG0_MCTL_FCT_VAL_Pos = 0x9
	// Bit mask of FCT_VAL field.
	TRNG0_MCTL_FCT_VAL_Msk = 0x200
	// Bit FCT_VAL.
	TRNG0_MCTL_FCT_VAL = 0x200
	// Position of ENT_VAL field.
	TRNG0_MCTL_ENT_VAL_Pos = 0xa
	// Bit mask of ENT_VAL field.
	TRNG0_MCTL_ENT_VAL_Msk = 0x400
	// Bit ENT_VAL.
	TRNG0_MCTL_ENT_VAL = 0x400
	// Position of TST_OUT field.
	TRNG0_MCTL_TST_OUT_Pos = 0xb
	// Bit mask of TST_OUT field.
	TRNG0_MCTL_TST_OUT_Msk = 0x800
	// Bit TST_OUT.
	TRNG0_MCTL_TST_OUT = 0x800
	// Position of ERR field.
	TRNG0_MCTL_ERR_Pos = 0xc
	// Bit mask of ERR field.
	TRNG0_MCTL_ERR_Msk = 0x1000
	// Bit ERR.
	TRNG0_MCTL_ERR = 0x1000
	// Position of TSTOP_OK field.
	TRNG0_MCTL_TSTOP_OK_Pos = 0xd
	// Bit mask of TSTOP_OK field.
	TRNG0_MCTL_TSTOP_OK_Msk = 0x2000
	// Bit TSTOP_OK.
	TRNG0_MCTL_TSTOP_OK = 0x2000
	// Position of PRGM field.
	TRNG0_MCTL_PRGM_Pos = 0x10
	// Bit mask of PRGM field.
	TRNG0_MCTL_PRGM_Msk = 0x10000
	// Bit PRGM.
	TRNG0_MCTL_PRGM = 0x10000

	// SCMISC: Statistical Check Miscellaneous Register
	// Position of LRUN_MAX field.
	TRNG0_SCMISC_LRUN_MAX_Pos = 0x0
	// Bit mask of LRUN_MAX field.
	TRNG0_SCMISC_LRUN_MAX_Msk = 0xff
	// Position of RTY_CT field.
	TRNG0_SCMISC_RTY_CT_Pos = 0x10
	// Bit mask of RTY_CT field.
	TRNG0_SCMISC_RTY_CT_Msk = 0xf0000

	// PKRRNG: Poker Range Register
	// Position of PKR_RNG field.
	TRNG0_PKRRNG_PKR_RNG_Pos = 0x0
	// Bit mask of PKR_RNG field.
	TRNG0_PKRRNG_PKR_RNG_Msk = 0xffff

	// PKRMAX: Poker Maximum Limit Register
	// Position of PKR_MAX field.
	TRNG0_PKRMAX_PKR_MAX_Pos = 0x0
	// Bit mask of PKR_MAX field.
	TRNG0_PKRMAX_PKR_MAX_Msk = 0xffffff

	// PKRSQ: Poker Square Calculation Result Register
	// Position of PKR_SQ field.
	TRNG0_PKRSQ_PKR_SQ_Pos = 0x0
	// Bit mask of PKR_SQ field.
	TRNG0_PKRSQ_PKR_SQ_Msk = 0xffffff

	// SDCTL: Seed Control Register
	// Position of SAMP_SIZE field.
	TRNG0_SDCTL_SAMP_SIZE_Pos = 0x0
	// Bit mask of SAMP_SIZE field.
	TRNG0_SDCTL_SAMP_SIZE_Msk = 0xffff
	// Position of ENT_DLY field.
	TRNG0_SDCTL_ENT_DLY_Pos = 0x10
	// Bit mask of ENT_DLY field.
	TRNG0_SDCTL_ENT_DLY_Msk = 0xffff0000

	// SBLIM: Sparse Bit Limit Register
	// Position of SB_LIM field.
	TRNG0_SBLIM_SB_LIM_Pos = 0x0
	// Bit mask of SB_LIM field.
	TRNG0_SBLIM_SB_LIM_Msk = 0x3ff

	// TOTSAM: Total Samples Register
	// Position of TOT_SAM field.
	TRNG0_TOTSAM_TOT_SAM_Pos = 0x0
	// Bit mask of TOT_SAM field.
	TRNG0_TOTSAM_TOT_SAM_Msk = 0xfffff

	// FRQMIN: Frequency Count Minimum Limit Register
	// Position of FRQ_MIN field.
	TRNG0_FRQMIN_FRQ_MIN_Pos = 0x0
	// Bit mask of FRQ_MIN field.
	TRNG0_FRQMIN_FRQ_MIN_Msk = 0x3fffff

	// FRQCNT: Frequency Count Register
	// Position of FRQ_CT field.
	TRNG0_FRQCNT_FRQ_CT_Pos = 0x0
	// Bit mask of FRQ_CT field.
	TRNG0_FRQCNT_FRQ_CT_Msk = 0x3fffff

	// FRQMAX: Frequency Count Maximum Limit Register
	// Position of FRQ_MAX field.
	TRNG0_FRQMAX_FRQ_MAX_Pos = 0x0
	// Bit mask of FRQ_MAX field.
	TRNG0_FRQMAX_FRQ_MAX_Msk = 0x3fffff

	// SCMC: Statistical Check Monobit Count Register
	// Position of MONO_CT field.
	TRNG0_SCMC_MONO_CT_Pos = 0x0
	// Bit mask of MONO_CT field.
	TRNG0_SCMC_MONO_CT_Msk = 0xffff

	// SCML: Statistical Check Monobit Limit Register
	// Position of MONO_MAX field.
	TRNG0_SCML_MONO_MAX_Pos = 0x0
	// Bit mask of MONO_MAX field.
	TRNG0_SCML_MONO_MAX_Msk = 0xffff
	// Position of MONO_RNG field.
	TRNG0_SCML_MONO_RNG_Pos = 0x10
	// Bit mask of MONO_RNG field.
	TRNG0_SCML_MONO_RNG_Msk = 0xffff0000

	// SCR1C: Statistical Check Run Length 1 Count Register
	// Position of R1_0_CT field.
	TRNG0_SCR1C_R1_0_CT_Pos = 0x0
	// Bit mask of R1_0_CT field.
	TRNG0_SCR1C_R1_0_CT_Msk = 0x7fff
	// Position of R1_1_CT field.
	TRNG0_SCR1C_R1_1_CT_Pos = 0x10
	// Bit mask of R1_1_CT field.
	TRNG0_SCR1C_R1_1_CT_Msk = 0x7fff0000

	// SCR1L: Statistical Check Run Length 1 Limit Register
	// Position of RUN1_MAX field.
	TRNG0_SCR1L_RUN1_MAX_Pos = 0x0
	// Bit mask of RUN1_MAX field.
	TRNG0_SCR1L_RUN1_MAX_Msk = 0x7fff
	// Position of RUN1_RNG field.
	TRNG0_SCR1L_RUN1_RNG_Pos = 0x10
	// Bit mask of RUN1_RNG field.
	TRNG0_SCR1L_RUN1_RNG_Msk = 0x7fff0000

	// SCR2C: Statistical Check Run Length 2 Count Register
	// Position of R2_0_CT field.
	TRNG0_SCR2C_R2_0_CT_Pos = 0x0
	// Bit mask of R2_0_CT field.
	TRNG0_SCR2C_R2_0_CT_Msk = 0x3fff
	// Position of R2_1_CT field.
	TRNG0_SCR2C_R2_1_CT_Pos = 0x10
	// Bit mask of R2_1_CT field.
	TRNG0_SCR2C_R2_1_CT_Msk = 0x3fff0000

	// SCR2L: Statistical Check Run Length 2 Limit Register
	// Position of RUN2_MAX field.
	TRNG0_SCR2L_RUN2_MAX_Pos = 0x0
	// Bit mask of RUN2_MAX field.
	TRNG0_SCR2L_RUN2_MAX_Msk = 0x3fff
	// Position of RUN2_RNG field.
	TRNG0_SCR2L_RUN2_RNG_Pos = 0x10
	// Bit mask of RUN2_RNG field.
	TRNG0_SCR2L_RUN2_RNG_Msk = 0x3fff0000

	// SCR3C: Statistical Check Run Length 3 Count Register
	// Position of R3_0_CT field.
	TRNG0_SCR3C_R3_0_CT_Pos = 0x0
	// Bit mask of R3_0_CT field.
	TRNG0_SCR3C_R3_0_CT_Msk = 0x1fff
	// Position of R3_1_CT field.
	TRNG0_SCR3C_R3_1_CT_Pos = 0x10
	// Bit mask of R3_1_CT field.
	TRNG0_SCR3C_R3_1_CT_Msk = 0x1fff0000

	// SCR3L: Statistical Check Run Length 3 Limit Register
	// Position of RUN3_MAX field.
	TRNG0_SCR3L_RUN3_MAX_Pos = 0x0
	// Bit mask of RUN3_MAX field.
	TRNG0_SCR3L_RUN3_MAX_Msk = 0x1fff
	// Position of RUN3_RNG field.
	TRNG0_SCR3L_RUN3_RNG_Pos = 0x10
	// Bit mask of RUN3_RNG field.
	TRNG0_SCR3L_RUN3_RNG_Msk = 0x1fff0000

	// SCR4C: Statistical Check Run Length 4 Count Register
	// Position of R4_0_CT field.
	TRNG0_SCR4C_R4_0_CT_Pos = 0x0
	// Bit mask of R4_0_CT field.
	TRNG0_SCR4C_R4_0_CT_Msk = 0xfff
	// Position of R4_1_CT field.
	TRNG0_SCR4C_R4_1_CT_Pos = 0x10
	// Bit mask of R4_1_CT field.
	TRNG0_SCR4C_R4_1_CT_Msk = 0xfff0000

	// SCR4L: Statistical Check Run Length 4 Limit Register
	// Position of RUN4_MAX field.
	TRNG0_SCR4L_RUN4_MAX_Pos = 0x0
	// Bit mask of RUN4_MAX field.
	TRNG0_SCR4L_RUN4_MAX_Msk = 0xfff
	// Position of RUN4_RNG field.
	TRNG0_SCR4L_RUN4_RNG_Pos = 0x10
	// Bit mask of RUN4_RNG field.
	TRNG0_SCR4L_RUN4_RNG_Msk = 0xfff0000

	// SCR5C: Statistical Check Run Length 5 Count Register
	// Position of R5_0_CT field.
	TRNG0_SCR5C_R5_0_CT_Pos = 0x0
	// Bit mask of R5_0_CT field.
	TRNG0_SCR5C_R5_0_CT_Msk = 0x7ff
	// Position of R5_1_CT field.
	TRNG0_SCR5C_R5_1_CT_Pos = 0x10
	// Bit mask of R5_1_CT field.
	TRNG0_SCR5C_R5_1_CT_Msk = 0x7ff0000

	// SCR5L: Statistical Check Run Length 5 Limit Register
	// Position of RUN5_MAX field.
	TRNG0_SCR5L_RUN5_MAX_Pos = 0x0
	// Bit mask of RUN5_MAX field.
	TRNG0_SCR5L_RUN5_MAX_Msk = 0x7ff
	// Position of RUN5_RNG field.
	TRNG0_SCR5L_RUN5_RNG_Pos = 0x10
	// Bit mask of RUN5_RNG field.
	TRNG0_SCR5L_RUN5_RNG_Msk = 0x7ff0000

	// SCR6PC: Statistical Check Run Length 6+ Count Register
	// Position of R6P_0_CT field.
	TRNG0_SCR6PC_R6P_0_CT_Pos = 0x0
	// Bit mask of R6P_0_CT field.
	TRNG0_SCR6PC_R6P_0_CT_Msk = 0x7ff
	// Position of R6P_1_CT field.
	TRNG0_SCR6PC_R6P_1_CT_Pos = 0x10
	// Bit mask of R6P_1_CT field.
	TRNG0_SCR6PC_R6P_1_CT_Msk = 0x7ff0000

	// SCR6PL: Statistical Check Run Length 6+ Limit Register
	// Position of RUN6P_MAX field.
	TRNG0_SCR6PL_RUN6P_MAX_Pos = 0x0
	// Bit mask of RUN6P_MAX field.
	TRNG0_SCR6PL_RUN6P_MAX_Msk = 0x7ff
	// Position of RUN6P_RNG field.
	TRNG0_SCR6PL_RUN6P_RNG_Pos = 0x10
	// Bit mask of RUN6P_RNG field.
	TRNG0_SCR6PL_RUN6P_RNG_Msk = 0x7ff0000

	// STATUS: Status Register
	// Position of TF1BR0 field.
	TRNG0_STATUS_TF1BR0_Pos = 0x0
	// Bit mask of TF1BR0 field.
	TRNG0_STATUS_TF1BR0_Msk = 0x1
	// Bit TF1BR0.
	TRNG0_STATUS_TF1BR0 = 0x1
	// Position of TF1BR1 field.
	TRNG0_STATUS_TF1BR1_Pos = 0x1
	// Bit mask of TF1BR1 field.
	TRNG0_STATUS_TF1BR1_Msk = 0x2
	// Bit TF1BR1.
	TRNG0_STATUS_TF1BR1 = 0x2
	// Position of TF2BR0 field.
	TRNG0_STATUS_TF2BR0_Pos = 0x2
	// Bit mask of TF2BR0 field.
	TRNG0_STATUS_TF2BR0_Msk = 0x4
	// Bit TF2BR0.
	TRNG0_STATUS_TF2BR0 = 0x4
	// Position of TF2BR1 field.
	TRNG0_STATUS_TF2BR1_Pos = 0x3
	// Bit mask of TF2BR1 field.
	TRNG0_STATUS_TF2BR1_Msk = 0x8
	// Bit TF2BR1.
	TRNG0_STATUS_TF2BR1 = 0x8
	// Position of TF3BR0 field.
	TRNG0_STATUS_TF3BR0_Pos = 0x4
	// Bit mask of TF3BR0 field.
	TRNG0_STATUS_TF3BR0_Msk = 0x10
	// Bit TF3BR0.
	TRNG0_STATUS_TF3BR0 = 0x10
	// Position of TF3BR1 field.
	TRNG0_STATUS_TF3BR1_Pos = 0x5
	// Bit mask of TF3BR1 field.
	TRNG0_STATUS_TF3BR1_Msk = 0x20
	// Bit TF3BR1.
	TRNG0_STATUS_TF3BR1 = 0x20
	// Position of TF4BR0 field.
	TRNG0_STATUS_TF4BR0_Pos = 0x6
	// Bit mask of TF4BR0 field.
	TRNG0_STATUS_TF4BR0_Msk = 0x40
	// Bit TF4BR0.
	TRNG0_STATUS_TF4BR0 = 0x40
	// Position of TF4BR1 field.
	TRNG0_STATUS_TF4BR1_Pos = 0x7
	// Bit mask of TF4BR1 field.
	TRNG0_STATUS_TF4BR1_Msk = 0x80
	// Bit TF4BR1.
	TRNG0_STATUS_TF4BR1 = 0x80
	// Position of TF5BR0 field.
	TRNG0_STATUS_TF5BR0_Pos = 0x8
	// Bit mask of TF5BR0 field.
	TRNG0_STATUS_TF5BR0_Msk = 0x100
	// Bit TF5BR0.
	TRNG0_STATUS_TF5BR0 = 0x100
	// Position of TF5BR1 field.
	TRNG0_STATUS_TF5BR1_Pos = 0x9
	// Bit mask of TF5BR1 field.
	TRNG0_STATUS_TF5BR1_Msk = 0x200
	// Bit TF5BR1.
	TRNG0_STATUS_TF5BR1 = 0x200
	// Position of TF6PBR0 field.
	TRNG0_STATUS_TF6PBR0_Pos = 0xa
	// Bit mask of TF6PBR0 field.
	TRNG0_STATUS_TF6PBR0_Msk = 0x400
	// Bit TF6PBR0.
	TRNG0_STATUS_TF6PBR0 = 0x400
	// Position of TF6PBR1 field.
	TRNG0_STATUS_TF6PBR1_Pos = 0xb
	// Bit mask of TF6PBR1 field.
	TRNG0_STATUS_TF6PBR1_Msk = 0x800
	// Bit TF6PBR1.
	TRNG0_STATUS_TF6PBR1 = 0x800
	// Position of TFSB field.
	TRNG0_STATUS_TFSB_Pos = 0xc
	// Bit mask of TFSB field.
	TRNG0_STATUS_TFSB_Msk = 0x1000
	// Bit TFSB.
	TRNG0_STATUS_TFSB = 0x1000
	// Position of TFLR field.
	TRNG0_STATUS_TFLR_Pos = 0xd
	// Bit mask of TFLR field.
	TRNG0_STATUS_TFLR_Msk = 0x2000
	// Bit TFLR.
	TRNG0_STATUS_TFLR = 0x2000
	// Position of TFP field.
	TRNG0_STATUS_TFP_Pos = 0xe
	// Bit mask of TFP field.
	TRNG0_STATUS_TFP_Msk = 0x4000
	// Bit TFP.
	TRNG0_STATUS_TFP = 0x4000
	// Position of TFMB field.
	TRNG0_STATUS_TFMB_Pos = 0xf
	// Bit mask of TFMB field.
	TRNG0_STATUS_TFMB_Msk = 0x8000
	// Bit TFMB.
	TRNG0_STATUS_TFMB = 0x8000
	// Position of RETRY_CT field.
	TRNG0_STATUS_RETRY_CT_Pos = 0x10
	// Bit mask of RETRY_CT field.
	TRNG0_STATUS_RETRY_CT_Msk = 0xf0000

	// ENT0: Entropy Read Register
	// Position of ENT field.
	TRNG0_ENT0_ENT_Pos = 0x0
	// Bit mask of ENT field.
	TRNG0_ENT0_ENT_Msk = 0xffffffff

	// ENT1: Entropy Read Register
	// Position of ENT field.
	TRNG0_ENT1_ENT_Pos = 0x0
	// Bit mask of ENT field.
	TRNG0_ENT1_ENT_Msk = 0xffffffff

	// ENT2: Entropy Read Register
	// Position of ENT field.
	TRNG0_ENT2_ENT_Pos = 0x0
	// Bit mask of ENT field.
	TRNG0_ENT2_ENT_Msk = 0xffffffff

	// ENT3: Entropy Read Register
	// Position of ENT field.
	TRNG0_ENT3_ENT_Pos = 0x0
	// Bit mask of ENT field.
	TRNG0_ENT3_ENT_Msk = 0xffffffff

	// ENT4: Entropy Read Register
	// Position of ENT field.
	TRNG0_ENT4_ENT_Pos = 0x0
	// Bit mask of ENT field.
	TRNG0_ENT4_ENT_Msk = 0xffffffff

	// ENT5: Entropy Read Register
	// Position of ENT field.
	TRNG0_ENT5_ENT_Pos = 0x0
	// Bit mask of ENT field.
	TRNG0_ENT5_ENT_Msk = 0xffffffff

	// ENT6: Entropy Read Register
	// Position of ENT field.
	TRNG0_ENT6_ENT_Pos = 0x0
	// Bit mask of ENT field.
	TRNG0_ENT6_ENT_Msk = 0xffffffff

	// ENT7: Entropy Read Register
	// Position of ENT field.
	TRNG0_ENT7_ENT_Pos = 0x0
	// Bit mask of ENT field.
	TRNG0_ENT7_ENT_Msk = 0xffffffff

	// ENT8: Entropy Read Register
	// Position of ENT field.
	TRNG0_ENT8_ENT_Pos = 0x0
	// Bit mask of ENT field.
	TRNG0_ENT8_ENT_Msk = 0xffffffff

	// ENT9: Entropy Read Register
	// Position of ENT field.
	TRNG0_ENT9_ENT_Pos = 0x0
	// Bit mask of ENT field.
	TRNG0_ENT9_ENT_Msk = 0xffffffff

	// ENT10: Entropy Read Register
	// Position of ENT field.
	TRNG0_ENT10_ENT_Pos = 0x0
	// Bit mask of ENT field.
	TRNG0_ENT10_ENT_Msk = 0xffffffff

	// ENT11: Entropy Read Register
	// Position of ENT field.
	TRNG0_ENT11_ENT_Pos = 0x0
	// Bit mask of ENT field.
	TRNG0_ENT11_ENT_Msk = 0xffffffff

	// ENT12: Entropy Read Register
	// Position of ENT field.
	TRNG0_ENT12_ENT_Pos = 0x0
	// Bit mask of ENT field.
	TRNG0_ENT12_ENT_Msk = 0xffffffff

	// ENT13: Entropy Read Register
	// Position of ENT field.
	TRNG0_ENT13_ENT_Pos = 0x0
	// Bit mask of ENT field.
	TRNG0_ENT13_ENT_Msk = 0xffffffff

	// ENT14: Entropy Read Register
	// Position of ENT field.
	TRNG0_ENT14_ENT_Pos = 0x0
	// Bit mask of ENT field.
	TRNG0_ENT14_ENT_Msk = 0xffffffff

	// ENT15: Entropy Read Register
	// Position of ENT field.
	TRNG0_ENT15_ENT_Pos = 0x0
	// Bit mask of ENT field.
	TRNG0_ENT15_ENT_Msk = 0xffffffff

	// PKRCNT10: Statistical Check Poker Count 1 and 0 Register
	// Position of PKR_0_CT field.
	TRNG0_PKRCNT10_PKR_0_CT_Pos = 0x0
	// Bit mask of PKR_0_CT field.
	TRNG0_PKRCNT10_PKR_0_CT_Msk = 0xffff
	// Position of PKR_1_CT field.
	TRNG0_PKRCNT10_PKR_1_CT_Pos = 0x10
	// Bit mask of PKR_1_CT field.
	TRNG0_PKRCNT10_PKR_1_CT_Msk = 0xffff0000

	// PKRCNT32: Statistical Check Poker Count 3 and 2 Register
	// Position of PKR_2_CT field.
	TRNG0_PKRCNT32_PKR_2_CT_Pos = 0x0
	// Bit mask of PKR_2_CT field.
	TRNG0_PKRCNT32_PKR_2_CT_Msk = 0xffff
	// Position of PKR_3_CT field.
	TRNG0_PKRCNT32_PKR_3_CT_Pos = 0x10
	// Bit mask of PKR_3_CT field.
	TRNG0_PKRCNT32_PKR_3_CT_Msk = 0xffff0000

	// PKRCNT54: Statistical Check Poker Count 5 and 4 Register
	// Position of PKR_4_CT field.
	TRNG0_PKRCNT54_PKR_4_CT_Pos = 0x0
	// Bit mask of PKR_4_CT field.
	TRNG0_PKRCNT54_PKR_4_CT_Msk = 0xffff
	// Position of PKR_5_CT field.
	TRNG0_PKRCNT54_PKR_5_CT_Pos = 0x10
	// Bit mask of PKR_5_CT field.
	TRNG0_PKRCNT54_PKR_5_CT_Msk = 0xffff0000

	// PKRCNT76: Statistical Check Poker Count 7 and 6 Register
	// Position of PKR_6_CT field.
	TRNG0_PKRCNT76_PKR_6_CT_Pos = 0x0
	// Bit mask of PKR_6_CT field.
	TRNG0_PKRCNT76_PKR_6_CT_Msk = 0xffff
	// Position of PKR_7_CT field.
	TRNG0_PKRCNT76_PKR_7_CT_Pos = 0x10
	// Bit mask of PKR_7_CT field.
	TRNG0_PKRCNT76_PKR_7_CT_Msk = 0xffff0000

	// PKRCNT98: Statistical Check Poker Count 9 and 8 Register
	// Position of PKR_8_CT field.
	TRNG0_PKRCNT98_PKR_8_CT_Pos = 0x0
	// Bit mask of PKR_8_CT field.
	TRNG0_PKRCNT98_PKR_8_CT_Msk = 0xffff
	// Position of PKR_9_CT field.
	TRNG0_PKRCNT98_PKR_9_CT_Pos = 0x10
	// Bit mask of PKR_9_CT field.
	TRNG0_PKRCNT98_PKR_9_CT_Msk = 0xffff0000

	// PKRCNTBA: Statistical Check Poker Count B and A Register
	// Position of PKR_A_CT field.
	TRNG0_PKRCNTBA_PKR_A_CT_Pos = 0x0
	// Bit mask of PKR_A_CT field.
	TRNG0_PKRCNTBA_PKR_A_CT_Msk = 0xffff
	// Position of PKR_B_CT field.
	TRNG0_PKRCNTBA_PKR_B_CT_Pos = 0x10
	// Bit mask of PKR_B_CT field.
	TRNG0_PKRCNTBA_PKR_B_CT_Msk = 0xffff0000

	// PKRCNTDC: Statistical Check Poker Count D and C Register
	// Position of PKR_C_CT field.
	TRNG0_PKRCNTDC_PKR_C_CT_Pos = 0x0
	// Bit mask of PKR_C_CT field.
	TRNG0_PKRCNTDC_PKR_C_CT_Msk = 0xffff
	// Position of PKR_D_CT field.
	TRNG0_PKRCNTDC_PKR_D_CT_Pos = 0x10
	// Bit mask of PKR_D_CT field.
	TRNG0_PKRCNTDC_PKR_D_CT_Msk = 0xffff0000

	// PKRCNTFE: Statistical Check Poker Count F and E Register
	// Position of PKR_E_CT field.
	TRNG0_PKRCNTFE_PKR_E_CT_Pos = 0x0
	// Bit mask of PKR_E_CT field.
	TRNG0_PKRCNTFE_PKR_E_CT_Msk = 0xffff
	// Position of PKR_F_CT field.
	TRNG0_PKRCNTFE_PKR_F_CT_Pos = 0x10
	// Bit mask of PKR_F_CT field.
	TRNG0_PKRCNTFE_PKR_F_CT_Msk = 0xffff0000

	// SEC_CFG: Security Configuration Register
	// Position of SH0 field.
	TRNG0_SEC_CFG_SH0_Pos = 0x0
	// Bit mask of SH0 field.
	TRNG0_SEC_CFG_SH0_Msk = 0x1
	// Bit SH0.
	TRNG0_SEC_CFG_SH0 = 0x1
	// See DRNG version.
	TRNG0_SEC_CFG_SH0_0 = 0x0
	// See DRNG version.
	TRNG0_SEC_CFG_SH0_1 = 0x1
	// Position of NO_PRGM field.
	TRNG0_SEC_CFG_NO_PRGM_Pos = 0x1
	// Bit mask of NO_PRGM field.
	TRNG0_SEC_CFG_NO_PRGM_Msk = 0x2
	// Bit NO_PRGM.
	TRNG0_SEC_CFG_NO_PRGM = 0x2
	// Programability of registers controlled only by the Miscellaneous Control Register's access mode bit.
	TRNG0_SEC_CFG_NO_PRGM_0 = 0x0
	// Overides Miscellaneous Control Register access mode and prevents TRNG register programming.
	TRNG0_SEC_CFG_NO_PRGM_1 = 0x1
	// Position of SK_VAL field.
	TRNG0_SEC_CFG_SK_VAL_Pos = 0x2
	// Bit mask of SK_VAL field.
	TRNG0_SEC_CFG_SK_VAL_Msk = 0x4
	// Bit SK_VAL.
	TRNG0_SEC_CFG_SK_VAL = 0x4
	// See DRNG version.
	TRNG0_SEC_CFG_SK_VAL_0 = 0x0
	// See DRNG version.
	TRNG0_SEC_CFG_SK_VAL_1 = 0x1

	// INT_CTRL: Interrupt Control Register
	// Position of HW_ERR field.
	TRNG0_INT_CTRL_HW_ERR_Pos = 0x0
	// Bit mask of HW_ERR field.
	TRNG0_INT_CTRL_HW_ERR_Msk = 0x1
	// Bit HW_ERR.
	TRNG0_INT_CTRL_HW_ERR = 0x1
	// Corresponding bit of INT_STATUS cleared.
	TRNG0_INT_CTRL_HW_ERR_0 = 0x0
	// Corresponding bit of INT_STATUS active.
	TRNG0_INT_CTRL_HW_ERR_1 = 0x1
	// Position of ENT_VAL field.
	TRNG0_INT_CTRL_ENT_VAL_Pos = 0x1
	// Bit mask of ENT_VAL field.
	TRNG0_INT_CTRL_ENT_VAL_Msk = 0x2
	// Bit ENT_VAL.
	TRNG0_INT_CTRL_ENT_VAL = 0x2
	// Same behavior as bit 0 above.
	TRNG0_INT_CTRL_ENT_VAL_0 = 0x0
	// Same behavior as bit 0 above.
	TRNG0_INT_CTRL_ENT_VAL_1 = 0x1
	// Position of FRQ_CT_FAIL field.
	TRNG0_INT_CTRL_FRQ_CT_FAIL_Pos = 0x2
	// Bit mask of FRQ_CT_FAIL field.
	TRNG0_INT_CTRL_FRQ_CT_FAIL_Msk = 0x4
	// Bit FRQ_CT_FAIL.
	TRNG0_INT_CTRL_FRQ_CT_FAIL = 0x4
	// Same behavior as bit 0 above.
	TRNG0_INT_CTRL_FRQ_CT_FAIL_0 = 0x0
	// Same behavior as bit 0 above.
	TRNG0_INT_CTRL_FRQ_CT_FAIL_1 = 0x1
	// Position of UNUSED field.
	TRNG0_INT_CTRL_UNUSED_Pos = 0x3
	// Bit mask of UNUSED field.
	TRNG0_INT_CTRL_UNUSED_Msk = 0xfffffff8

	// INT_MASK: Mask Register
	// Position of HW_ERR field.
	TRNG0_INT_MASK_HW_ERR_Pos = 0x0
	// Bit mask of HW_ERR field.
	TRNG0_INT_MASK_HW_ERR_Msk = 0x1
	// Bit HW_ERR.
	TRNG0_INT_MASK_HW_ERR = 0x1
	// Corresponding interrupt of INT_STATUS is masked.
	TRNG0_INT_MASK_HW_ERR_0 = 0x0
	// Corresponding bit of INT_STATUS is active.
	TRNG0_INT_MASK_HW_ERR_1 = 0x1
	// Position of ENT_VAL field.
	TRNG0_INT_MASK_ENT_VAL_Pos = 0x1
	// Bit mask of ENT_VAL field.
	TRNG0_INT_MASK_ENT_VAL_Msk = 0x2
	// Bit ENT_VAL.
	TRNG0_INT_MASK_ENT_VAL = 0x2
	// Same behavior as bit 0 above.
	TRNG0_INT_MASK_ENT_VAL_0 = 0x0
	// Same behavior as bit 0 above.
	TRNG0_INT_MASK_ENT_VAL_1 = 0x1
	// Position of FRQ_CT_FAIL field.
	TRNG0_INT_MASK_FRQ_CT_FAIL_Pos = 0x2
	// Bit mask of FRQ_CT_FAIL field.
	TRNG0_INT_MASK_FRQ_CT_FAIL_Msk = 0x4
	// Bit FRQ_CT_FAIL.
	TRNG0_INT_MASK_FRQ_CT_FAIL = 0x4
	// Same behavior as bit 0 above.
	TRNG0_INT_MASK_FRQ_CT_FAIL_0 = 0x0
	// Same behavior as bit 0 above.
	TRNG0_INT_MASK_FRQ_CT_FAIL_1 = 0x1

	// INT_STATUS: Interrupt Status Register
	// Position of HW_ERR field.
	TRNG0_INT_STATUS_HW_ERR_Pos = 0x0
	// Bit mask of HW_ERR field.
	TRNG0_INT_STATUS_HW_ERR_Msk = 0x1
	// Bit HW_ERR.
	TRNG0_INT_STATUS_HW_ERR = 0x1
	// no error
	TRNG0_INT_STATUS_HW_ERR_0 = 0x0
	// error detected.
	TRNG0_INT_STATUS_HW_ERR_1 = 0x1
	// Position of ENT_VAL field.
	TRNG0_INT_STATUS_ENT_VAL_Pos = 0x1
	// Bit mask of ENT_VAL field.
	TRNG0_INT_STATUS_ENT_VAL_Msk = 0x2
	// Bit ENT_VAL.
	TRNG0_INT_STATUS_ENT_VAL = 0x2
	// Busy generation entropy. Any value read is invalid.
	TRNG0_INT_STATUS_ENT_VAL_0 = 0x0
	// TRNG can be stopped and entropy is valid if read.
	TRNG0_INT_STATUS_ENT_VAL_1 = 0x1
	// Position of FRQ_CT_FAIL field.
	TRNG0_INT_STATUS_FRQ_CT_FAIL_Pos = 0x2
	// Bit mask of FRQ_CT_FAIL field.
	TRNG0_INT_STATUS_FRQ_CT_FAIL_Msk = 0x4
	// Bit FRQ_CT_FAIL.
	TRNG0_INT_STATUS_FRQ_CT_FAIL = 0x4
	// No hardware nor self test frequency errors.
	TRNG0_INT_STATUS_FRQ_CT_FAIL_0 = 0x0
	// The frequency counter has detected a failure.
	TRNG0_INT_STATUS_FRQ_CT_FAIL_1 = 0x1

	// VID1: Version ID Register (MS)
	// Position of MIN_REV field.
	TRNG0_VID1_MIN_REV_Pos = 0x0
	// Bit mask of MIN_REV field.
	TRNG0_VID1_MIN_REV_Msk = 0xff
	// Minor revision number for TRNG.
	TRNG0_VID1_MIN_REV_0x00 = 0x0
	// Position of MAJ_REV field.
	TRNG0_VID1_MAJ_REV_Pos = 0x8
	// Bit mask of MAJ_REV field.
	TRNG0_VID1_MAJ_REV_Msk = 0xff00
	// Major revision number for TRNG.
	TRNG0_VID1_MAJ_REV_0x01 = 0x1
	// Position of IP_ID field.
	TRNG0_VID1_IP_ID_Pos = 0x10
	// Bit mask of IP_ID field.
	TRNG0_VID1_IP_ID_Msk = 0xffff0000
	// ID for TRNG.
	TRNG0_VID1_IP_ID_0x0030 = 0x30

	// VID2: Version ID Register (LS)
	// Position of CONFIG_OPT field.
	TRNG0_VID2_CONFIG_OPT_Pos = 0x0
	// Bit mask of CONFIG_OPT field.
	TRNG0_VID2_CONFIG_OPT_Msk = 0xff
	// TRNG_CONFIG_OPT for TRNG.
	TRNG0_VID2_CONFIG_OPT_0x00 = 0x0
	// Position of ECO_REV field.
	TRNG0_VID2_ECO_REV_Pos = 0x8
	// Bit mask of ECO_REV field.
	TRNG0_VID2_ECO_REV_Msk = 0xff00
	// TRNG_ECO_REV for TRNG.
	TRNG0_VID2_ECO_REV_0x00 = 0x0
	// Position of INTG_OPT field.
	TRNG0_VID2_INTG_OPT_Pos = 0x10
	// Bit mask of INTG_OPT field.
	TRNG0_VID2_INTG_OPT_Msk = 0xff0000
	// INTG_OPT for TRNG.
	TRNG0_VID2_INTG_OPT_0x00 = 0x0
	// Position of ERA field.
	TRNG0_VID2_ERA_Pos = 0x18
	// Bit mask of ERA field.
	TRNG0_VID2_ERA_Msk = 0xff000000
	// COMPILE_OPT for TRNG.
	TRNG0_VID2_ERA_0x00 = 0x0
)

// Bitfields for SPI0: Serial Peripheral Interface
const (
	// MCR: Module Configuration Register
	// Position of HALT field.
	SPI_MCR_HALT_Pos = 0x0
	// Bit mask of HALT field.
	SPI_MCR_HALT_Msk = 0x1
	// Bit HALT.
	SPI_MCR_HALT = 0x1
	// Start transfers.
	SPI_MCR_HALT_0 = 0x0
	// Stop transfers.
	SPI_MCR_HALT_1 = 0x1
	// Position of SMPL_PT field.
	SPI_MCR_SMPL_PT_Pos = 0x8
	// Bit mask of SMPL_PT field.
	SPI_MCR_SMPL_PT_Msk = 0x300
	// 0 protocol clock cycles between SCK edge and SIN sample
	SPI_MCR_SMPL_PT_00 = 0x0
	// 1 protocol clock cycle between SCK edge and SIN sample
	SPI_MCR_SMPL_PT_01 = 0x1
	// 2 protocol clock cycles between SCK edge and SIN sample
	SPI_MCR_SMPL_PT_10 = 0x2
	// Position of CLR_RXF field.
	SPI_MCR_CLR_RXF_Pos = 0xa
	// Bit mask of CLR_RXF field.
	SPI_MCR_CLR_RXF_Msk = 0x400
	// Bit CLR_RXF.
	SPI_MCR_CLR_RXF = 0x400
	// Do not clear the RX FIFO counter.
	SPI_MCR_CLR_RXF_0 = 0x0
	// Clear the RX FIFO counter.
	SPI_MCR_CLR_RXF_1 = 0x1
	// Position of CLR_TXF field.
	SPI_MCR_CLR_TXF_Pos = 0xb
	// Bit mask of CLR_TXF field.
	SPI_MCR_CLR_TXF_Msk = 0x800
	// Bit CLR_TXF.
	SPI_MCR_CLR_TXF = 0x800
	// Do not clear the TX FIFO counter.
	SPI_MCR_CLR_TXF_0 = 0x0
	// Clear the TX FIFO counter.
	SPI_MCR_CLR_TXF_1 = 0x1
	// Position of DIS_RXF field.
	SPI_MCR_DIS_RXF_Pos = 0xc
	// Bit mask of DIS_RXF field.
	SPI_MCR_DIS_RXF_Msk = 0x1000
	// Bit DIS_RXF.
	SPI_MCR_DIS_RXF = 0x1000
	// RX FIFO is enabled.
	SPI_MCR_DIS_RXF_0 = 0x0
	// RX FIFO is disabled.
	SPI_MCR_DIS_RXF_1 = 0x1
	// Position of DIS_TXF field.
	SPI_MCR_DIS_TXF_Pos = 0xd
	// Bit mask of DIS_TXF field.
	SPI_MCR_DIS_TXF_Msk = 0x2000
	// Bit DIS_TXF.
	SPI_MCR_DIS_TXF = 0x2000
	// TX FIFO is enabled.
	SPI_MCR_DIS_TXF_0 = 0x0
	// TX FIFO is disabled.
	SPI_MCR_DIS_TXF_1 = 0x1
	// Position of MDIS field.
	SPI_MCR_MDIS_Pos = 0xe
	// Bit mask of MDIS field.
	SPI_MCR_MDIS_Msk = 0x4000
	// Bit MDIS.
	SPI_MCR_MDIS = 0x4000
	// Enables the module clocks.
	SPI_MCR_MDIS_0 = 0x0
	// Allows external logic to disable the module clocks.
	SPI_MCR_MDIS_1 = 0x1
	// Position of DOZE field.
	SPI_MCR_DOZE_Pos = 0xf
	// Bit mask of DOZE field.
	SPI_MCR_DOZE_Msk = 0x8000
	// Bit DOZE.
	SPI_MCR_DOZE = 0x8000
	// Doze mode has no effect on the module.
	SPI_MCR_DOZE_0 = 0x0
	// Doze mode disables the module.
	SPI_MCR_DOZE_1 = 0x1
	// Position of PCSIS field.
	SPI_MCR_PCSIS_Pos = 0x10
	// Bit mask of PCSIS field.
	SPI_MCR_PCSIS_Msk = 0xf0000
	// The inactive state of PCSx is low.
	SPI_MCR_PCSIS_0 = 0x0
	// The inactive state of PCSx is high.
	SPI_MCR_PCSIS_1 = 0x1
	// Position of ROOE field.
	SPI_MCR_ROOE_Pos = 0x18
	// Bit mask of ROOE field.
	SPI_MCR_ROOE_Msk = 0x1000000
	// Bit ROOE.
	SPI_MCR_ROOE = 0x1000000
	// Incoming data is ignored.
	SPI_MCR_ROOE_0 = 0x0
	// Incoming data is shifted into the shift register.
	SPI_MCR_ROOE_1 = 0x1
	// Position of MTFE field.
	SPI_MCR_MTFE_Pos = 0x1a
	// Bit mask of MTFE field.
	SPI_MCR_MTFE_Msk = 0x4000000
	// Bit MTFE.
	SPI_MCR_MTFE = 0x4000000
	// Modified SPI transfer format disabled.
	SPI_MCR_MTFE_0 = 0x0
	// Modified SPI transfer format enabled.
	SPI_MCR_MTFE_1 = 0x1
	// Position of FRZ field.
	SPI_MCR_FRZ_Pos = 0x1b
	// Bit mask of FRZ field.
	SPI_MCR_FRZ_Msk = 0x8000000
	// Bit FRZ.
	SPI_MCR_FRZ = 0x8000000
	// Do not halt serial transfers in Debug mode.
	SPI_MCR_FRZ_0 = 0x0
	// Halt serial transfers in Debug mode.
	SPI_MCR_FRZ_1 = 0x1
	// Position of DCONF field.
	SPI_MCR_DCONF_Pos = 0x1c
	// Bit mask of DCONF field.
	SPI_MCR_DCONF_Msk = 0x30000000
	// SPI
	SPI_MCR_DCONF_00 = 0x0
	// Position of CONT_SCKE field.
	SPI_MCR_CONT_SCKE_Pos = 0x1e
	// Bit mask of CONT_SCKE field.
	SPI_MCR_CONT_SCKE_Msk = 0x40000000
	// Bit CONT_SCKE.
	SPI_MCR_CONT_SCKE = 0x40000000
	// Continuous SCK disabled.
	SPI_MCR_CONT_SCKE_0 = 0x0
	// Continuous SCK enabled.
	SPI_MCR_CONT_SCKE_1 = 0x1
	// Position of MSTR field.
	SPI_MCR_MSTR_Pos = 0x1f
	// Bit mask of MSTR field.
	SPI_MCR_MSTR_Msk = 0x80000000
	// Bit MSTR.
	SPI_MCR_MSTR = 0x80000000
	// Enables Slave mode
	SPI_MCR_MSTR_0 = 0x0
	// Enables Master mode
	SPI_MCR_MSTR_1 = 0x1

	// TCR: Transfer Count Register
	// Position of SPI_TCNT field.
	SPI_TCR_SPI_TCNT_Pos = 0x10
	// Bit mask of SPI_TCNT field.
	SPI_TCR_SPI_TCNT_Msk = 0xffff0000

	// CTAR0: Clock and Transfer Attributes Register (In Master Mode)
	// Position of BR field.
	SPI_CTAR_BR_Pos = 0x0
	// Bit mask of BR field.
	SPI_CTAR_BR_Msk = 0xf
	// Position of DT field.
	SPI_CTAR_DT_Pos = 0x4
	// Bit mask of DT field.
	SPI_CTAR_DT_Msk = 0xf0
	// Position of ASC field.
	SPI_CTAR_ASC_Pos = 0x8
	// Bit mask of ASC field.
	SPI_CTAR_ASC_Msk = 0xf00
	// Position of CSSCK field.
	SPI_CTAR_CSSCK_Pos = 0xc
	// Bit mask of CSSCK field.
	SPI_CTAR_CSSCK_Msk = 0xf000
	// Position of PBR field.
	SPI_CTAR_PBR_Pos = 0x10
	// Bit mask of PBR field.
	SPI_CTAR_PBR_Msk = 0x30000
	// Baud Rate Prescaler value is 2.
	SPI_CTAR_PBR_00 = 0x0
	// Baud Rate Prescaler value is 3.
	SPI_CTAR_PBR_01 = 0x1
	// Baud Rate Prescaler value is 5.
	SPI_CTAR_PBR_10 = 0x2
	// Baud Rate Prescaler value is 7.
	SPI_CTAR_PBR_11 = 0x3
	// Position of PDT field.
	SPI_CTAR_PDT_Pos = 0x12
	// Bit mask of PDT field.
	SPI_CTAR_PDT_Msk = 0xc0000
	// Delay after Transfer Prescaler value is 1.
	SPI_CTAR_PDT_00 = 0x0
	// Delay after Transfer Prescaler value is 3.
	SPI_CTAR_PDT_01 = 0x1
	// Delay after Transfer Prescaler value is 5.
	SPI_CTAR_PDT_10 = 0x2
	// Delay after Transfer Prescaler value is 7.
	SPI_CTAR_PDT_11 = 0x3
	// Position of PASC field.
	SPI_CTAR_PASC_Pos = 0x14
	// Bit mask of PASC field.
	SPI_CTAR_PASC_Msk = 0x300000
	// Delay after Transfer Prescaler value is 1.
	SPI_CTAR_PASC_00 = 0x0
	// Delay after Transfer Prescaler value is 3.
	SPI_CTAR_PASC_01 = 0x1
	// Delay after Transfer Prescaler value is 5.
	SPI_CTAR_PASC_10 = 0x2
	// Delay after Transfer Prescaler value is 7.
	SPI_CTAR_PASC_11 = 0x3
	// Position of PCSSCK field.
	SPI_CTAR_PCSSCK_Pos = 0x16
	// Bit mask of PCSSCK field.
	SPI_CTAR_PCSSCK_Msk = 0xc00000
	// PCS to SCK Prescaler value is 1.
	SPI_CTAR_PCSSCK_00 = 0x0
	// PCS to SCK Prescaler value is 3.
	SPI_CTAR_PCSSCK_01 = 0x1
	// PCS to SCK Prescaler value is 5.
	SPI_CTAR_PCSSCK_10 = 0x2
	// PCS to SCK Prescaler value is 7.
	SPI_CTAR_PCSSCK_11 = 0x3
	// Position of LSBFE field.
	SPI_CTAR_LSBFE_Pos = 0x18
	// Bit mask of LSBFE field.
	SPI_CTAR_LSBFE_Msk = 0x1000000
	// Bit LSBFE.
	SPI_CTAR_LSBFE = 0x1000000
	// Data is transferred MSB first.
	SPI_CTAR_LSBFE_0 = 0x0
	// Data is transferred LSB first.
	SPI_CTAR_LSBFE_1 = 0x1
	// Position of CPHA field.
	SPI_CTAR_CPHA_Pos = 0x19
	// Bit mask of CPHA field.
	SPI_CTAR_CPHA_Msk = 0x2000000
	// Bit CPHA.
	SPI_CTAR_CPHA = 0x2000000
	// Data is captured on the leading edge of SCK and changed on the following edge.
	SPI_CTAR_CPHA_0 = 0x0
	// Data is changed on the leading edge of SCK and captured on the following edge.
	SPI_CTAR_CPHA_1 = 0x1
	// Position of CPOL field.
	SPI_CTAR_CPOL_Pos = 0x1a
	// Bit mask of CPOL field.
	SPI_CTAR_CPOL_Msk = 0x4000000
	// Bit CPOL.
	SPI_CTAR_CPOL = 0x4000000
	// The inactive state value of SCK is low.
	SPI_CTAR_CPOL_0 = 0x0
	// The inactive state value of SCK is high.
	SPI_CTAR_CPOL_1 = 0x1
	// Position of FMSZ field.
	SPI_CTAR_FMSZ_Pos = 0x1b
	// Bit mask of FMSZ field.
	SPI_CTAR_FMSZ_Msk = 0x78000000
	// Position of DBR field.
	SPI_CTAR_DBR_Pos = 0x1f
	// Bit mask of DBR field.
	SPI_CTAR_DBR_Msk = 0x80000000
	// Bit DBR.
	SPI_CTAR_DBR = 0x80000000
	// The baud rate is computed normally with a 50/50 duty cycle.
	SPI_CTAR_DBR_0 = 0x0
	// The baud rate is doubled with the duty cycle depending on the Baud Rate Prescaler.
	SPI_CTAR_DBR_1 = 0x1

	// CTAR_SLAVE: Clock and Transfer Attributes Register (In Slave Mode)
	// Position of CPHA field.
	SPI_CTAR_SLAVE_CPHA_Pos = 0x19
	// Bit mask of CPHA field.
	SPI_CTAR_SLAVE_CPHA_Msk = 0x2000000
	// Bit CPHA.
	SPI_CTAR_SLAVE_CPHA = 0x2000000
	// Data is captured on the leading edge of SCK and changed on the following edge.
	SPI_CTAR_SLAVE_CPHA_0 = 0x0
	// Data is changed on the leading edge of SCK and captured on the following edge.
	SPI_CTAR_SLAVE_CPHA_1 = 0x1
	// Position of CPOL field.
	SPI_CTAR_SLAVE_CPOL_Pos = 0x1a
	// Bit mask of CPOL field.
	SPI_CTAR_SLAVE_CPOL_Msk = 0x4000000
	// Bit CPOL.
	SPI_CTAR_SLAVE_CPOL = 0x4000000
	// The inactive state value of SCK is low.
	SPI_CTAR_SLAVE_CPOL_0 = 0x0
	// The inactive state value of SCK is high.
	SPI_CTAR_SLAVE_CPOL_1 = 0x1
	// Position of FMSZ field.
	SPI_CTAR_SLAVE_FMSZ_Pos = 0x1b
	// Bit mask of FMSZ field.
	SPI_CTAR_SLAVE_FMSZ_Msk = 0x78000000

	// SR: Status Register
	// Position of POPNXTPTR field.
	SPI_SR_POPNXTPTR_Pos = 0x0
	// Bit mask of POPNXTPTR field.
	SPI_SR_POPNXTPTR_Msk = 0xf
	// Position of RXCTR field.
	SPI_SR_RXCTR_Pos = 0x4
	// Bit mask of RXCTR field.
	SPI_SR_RXCTR_Msk = 0xf0
	// Position of TXNXTPTR field.
	SPI_SR_TXNXTPTR_Pos = 0x8
	// Bit mask of TXNXTPTR field.
	SPI_SR_TXNXTPTR_Msk = 0xf00
	// Position of TXCTR field.
	SPI_SR_TXCTR_Pos = 0xc
	// Bit mask of TXCTR field.
	SPI_SR_TXCTR_Msk = 0xf000
	// Position of RFDF field.
	SPI_SR_RFDF_Pos = 0x11
	// Bit mask of RFDF field.
	SPI_SR_RFDF_Msk = 0x20000
	// Bit RFDF.
	SPI_SR_RFDF = 0x20000
	// RX FIFO is empty.
	SPI_SR_RFDF_0 = 0x0
	// RX FIFO is not empty.
	SPI_SR_RFDF_1 = 0x1
	// Position of RFOF field.
	SPI_SR_RFOF_Pos = 0x13
	// Bit mask of RFOF field.
	SPI_SR_RFOF_Msk = 0x80000
	// Bit RFOF.
	SPI_SR_RFOF = 0x80000
	// No Rx FIFO overflow.
	SPI_SR_RFOF_0 = 0x0
	// Rx FIFO overflow has occurred.
	SPI_SR_RFOF_1 = 0x1
	// Position of TFFF field.
	SPI_SR_TFFF_Pos = 0x19
	// Bit mask of TFFF field.
	SPI_SR_TFFF_Msk = 0x2000000
	// Bit TFFF.
	SPI_SR_TFFF = 0x2000000
	// TX FIFO is full.
	SPI_SR_TFFF_0 = 0x0
	// TX FIFO is not full.
	SPI_SR_TFFF_1 = 0x1
	// Position of TFUF field.
	SPI_SR_TFUF_Pos = 0x1b
	// Bit mask of TFUF field.
	SPI_SR_TFUF_Msk = 0x8000000
	// Bit TFUF.
	SPI_SR_TFUF = 0x8000000
	// No TX FIFO underflow.
	SPI_SR_TFUF_0 = 0x0
	// TX FIFO underflow has occurred.
	SPI_SR_TFUF_1 = 0x1
	// Position of EOQF field.
	SPI_SR_EOQF_Pos = 0x1c
	// Bit mask of EOQF field.
	SPI_SR_EOQF_Msk = 0x10000000
	// Bit EOQF.
	SPI_SR_EOQF = 0x10000000
	// EOQ is not set in the executing command.
	SPI_SR_EOQF_0 = 0x0
	// EOQ is set in the executing SPI command.
	SPI_SR_EOQF_1 = 0x1
	// Position of TXRXS field.
	SPI_SR_TXRXS_Pos = 0x1e
	// Bit mask of TXRXS field.
	SPI_SR_TXRXS_Msk = 0x40000000
	// Bit TXRXS.
	SPI_SR_TXRXS = 0x40000000
	// Transmit and receive operations are disabled (The module is in Stopped state).
	SPI_SR_TXRXS_0 = 0x0
	// Transmit and receive operations are enabled (The module is in Running state).
	SPI_SR_TXRXS_1 = 0x1
	// Position of TCF field.
	SPI_SR_TCF_Pos = 0x1f
	// Bit mask of TCF field.
	SPI_SR_TCF_Msk = 0x80000000
	// Bit TCF.
	SPI_SR_TCF = 0x80000000
	// Transfer not complete.
	SPI_SR_TCF_0 = 0x0
	// Transfer complete.
	SPI_SR_TCF_1 = 0x1

	// RSER: DMA/Interrupt Request Select and Enable Register
	// Position of RFDF_DIRS field.
	SPI_RSER_RFDF_DIRS_Pos = 0x10
	// Bit mask of RFDF_DIRS field.
	SPI_RSER_RFDF_DIRS_Msk = 0x10000
	// Bit RFDF_DIRS.
	SPI_RSER_RFDF_DIRS = 0x10000
	// Interrupt request.
	SPI_RSER_RFDF_DIRS_0 = 0x0
	// DMA request.
	SPI_RSER_RFDF_DIRS_1 = 0x1
	// Position of RFDF_RE field.
	SPI_RSER_RFDF_RE_Pos = 0x11
	// Bit mask of RFDF_RE field.
	SPI_RSER_RFDF_RE_Msk = 0x20000
	// Bit RFDF_RE.
	SPI_RSER_RFDF_RE = 0x20000
	// RFDF interrupt or DMA requests are disabled.
	SPI_RSER_RFDF_RE_0 = 0x0
	// RFDF interrupt or DMA requests are enabled.
	SPI_RSER_RFDF_RE_1 = 0x1
	// Position of RFOF_RE field.
	SPI_RSER_RFOF_RE_Pos = 0x13
	// Bit mask of RFOF_RE field.
	SPI_RSER_RFOF_RE_Msk = 0x80000
	// Bit RFOF_RE.
	SPI_RSER_RFOF_RE = 0x80000
	// RFOF interrupt requests are disabled.
	SPI_RSER_RFOF_RE_0 = 0x0
	// RFOF interrupt requests are enabled.
	SPI_RSER_RFOF_RE_1 = 0x1
	// Position of TFFF_DIRS field.
	SPI_RSER_TFFF_DIRS_Pos = 0x18
	// Bit mask of TFFF_DIRS field.
	SPI_RSER_TFFF_DIRS_Msk = 0x1000000
	// Bit TFFF_DIRS.
	SPI_RSER_TFFF_DIRS = 0x1000000
	// TFFF flag generates interrupt requests.
	SPI_RSER_TFFF_DIRS_0 = 0x0
	// TFFF flag generates DMA requests.
	SPI_RSER_TFFF_DIRS_1 = 0x1
	// Position of TFFF_RE field.
	SPI_RSER_TFFF_RE_Pos = 0x19
	// Bit mask of TFFF_RE field.
	SPI_RSER_TFFF_RE_Msk = 0x2000000
	// Bit TFFF_RE.
	SPI_RSER_TFFF_RE = 0x2000000
	// TFFF interrupts or DMA requests are disabled.
	SPI_RSER_TFFF_RE_0 = 0x0
	// TFFF interrupts or DMA requests are enabled.
	SPI_RSER_TFFF_RE_1 = 0x1
	// Position of TFUF_RE field.
	SPI_RSER_TFUF_RE_Pos = 0x1b
	// Bit mask of TFUF_RE field.
	SPI_RSER_TFUF_RE_Msk = 0x8000000
	// Bit TFUF_RE.
	SPI_RSER_TFUF_RE = 0x8000000
	// TFUF interrupt requests are disabled.
	SPI_RSER_TFUF_RE_0 = 0x0
	// TFUF interrupt requests are enabled.
	SPI_RSER_TFUF_RE_1 = 0x1
	// Position of EOQF_RE field.
	SPI_RSER_EOQF_RE_Pos = 0x1c
	// Bit mask of EOQF_RE field.
	SPI_RSER_EOQF_RE_Msk = 0x10000000
	// Bit EOQF_RE.
	SPI_RSER_EOQF_RE = 0x10000000
	// EOQF interrupt requests are disabled.
	SPI_RSER_EOQF_RE_0 = 0x0
	// EOQF interrupt requests are enabled.
	SPI_RSER_EOQF_RE_1 = 0x1
	// Position of TCF_RE field.
	SPI_RSER_TCF_RE_Pos = 0x1f
	// Bit mask of TCF_RE field.
	SPI_RSER_TCF_RE_Msk = 0x80000000
	// Bit TCF_RE.
	SPI_RSER_TCF_RE = 0x80000000
	// TCF interrupt requests are disabled.
	SPI_RSER_TCF_RE_0 = 0x0
	// TCF interrupt requests are enabled.
	SPI_RSER_TCF_RE_1 = 0x1

	// PUSHR: PUSH TX FIFO Register In Master Mode
	// Position of TXDATA field.
	SPI_PUSHR_TXDATA_Pos = 0x0
	// Bit mask of TXDATA field.
	SPI_PUSHR_TXDATA_Msk = 0xffff
	// Position of PCS field.
	SPI_PUSHR_PCS_Pos = 0x10
	// Bit mask of PCS field.
	SPI_PUSHR_PCS_Msk = 0xf0000
	// Negate the PCS[x] signal
	SPI_PUSHR_PCS_0 = 0x0
	// Assert the PCS[x] signal.
	SPI_PUSHR_PCS_1 = 0x1
	// Position of CTCNT field.
	SPI_PUSHR_CTCNT_Pos = 0x1a
	// Bit mask of CTCNT field.
	SPI_PUSHR_CTCNT_Msk = 0x4000000
	// Bit CTCNT.
	SPI_PUSHR_CTCNT = 0x4000000
	// Do not clear the TCR[TCNT] field.
	SPI_PUSHR_CTCNT_0 = 0x0
	// Clear the TCR[TCNT] field.
	SPI_PUSHR_CTCNT_1 = 0x1
	// Position of EOQ field.
	SPI_PUSHR_EOQ_Pos = 0x1b
	// Bit mask of EOQ field.
	SPI_PUSHR_EOQ_Msk = 0x8000000
	// Bit EOQ.
	SPI_PUSHR_EOQ = 0x8000000
	// The SPI data is not the last data to transfer.
	SPI_PUSHR_EOQ_0 = 0x0
	// The SPI data is the last data to transfer.
	SPI_PUSHR_EOQ_1 = 0x1
	// Position of CTAS field.
	SPI_PUSHR_CTAS_Pos = 0x1c
	// Bit mask of CTAS field.
	SPI_PUSHR_CTAS_Msk = 0x70000000
	// CTAR0
	SPI_PUSHR_CTAS_000 = 0x0
	// CTAR1
	SPI_PUSHR_CTAS_001 = 0x1
	// Position of CONT field.
	SPI_PUSHR_CONT_Pos = 0x1f
	// Bit mask of CONT field.
	SPI_PUSHR_CONT_Msk = 0x80000000
	// Bit CONT.
	SPI_PUSHR_CONT = 0x80000000
	// Return PCSn signals to their inactive state between transfers.
	SPI_PUSHR_CONT_0 = 0x0
	// Keep PCSn signals asserted between transfers.
	SPI_PUSHR_CONT_1 = 0x1

	// PUSHR_SLAVE: PUSH TX FIFO Register In Slave Mode
	// Position of TXDATA field.
	SPI_PUSHR_SLAVE_TXDATA_Pos = 0x0
	// Bit mask of TXDATA field.
	SPI_PUSHR_SLAVE_TXDATA_Msk = 0xffff

	// POPR: POP RX FIFO Register
	// Position of RXDATA field.
	SPI_POPR_RXDATA_Pos = 0x0
	// Bit mask of RXDATA field.
	SPI_POPR_RXDATA_Msk = 0xffffffff

	// TXFR0: Transmit FIFO Registers
	// Position of TXDATA field.
	SPI_TXFR_TXDATA_Pos = 0x0
	// Bit mask of TXDATA field.
	SPI_TXFR_TXDATA_Msk = 0xffff
	// Position of TXCMD_TXDATA field.
	SPI_TXFR_TXCMD_TXDATA_Pos = 0x10
	// Bit mask of TXCMD_TXDATA field.
	SPI_TXFR_TXCMD_TXDATA_Msk = 0xffff0000

	// RXFR0: Receive FIFO Registers
	// Position of RXDATA field.
	SPI_RXFR_RXDATA_Pos = 0x0
	// Bit mask of RXDATA field.
	SPI_RXFR_RXDATA_Msk = 0xffffffff
)

// Bitfields for PIT: Periodic Interrupt Timer
const (
	// MCR: PIT Module Control Register
	// Position of FRZ field.
	PIT_MCR_FRZ_Pos = 0x0
	// Bit mask of FRZ field.
	PIT_MCR_FRZ_Msk = 0x1
	// Bit FRZ.
	PIT_MCR_FRZ = 0x1
	// Timers continue to run in Debug mode.
	PIT_MCR_FRZ_0 = 0x0
	// Timers are stopped in Debug mode.
	PIT_MCR_FRZ_1 = 0x1
	// Position of MDIS field.
	PIT_MCR_MDIS_Pos = 0x1
	// Bit mask of MDIS field.
	PIT_MCR_MDIS_Msk = 0x2
	// Bit MDIS.
	PIT_MCR_MDIS = 0x2
	// Clock for standard PIT timers is enabled.
	PIT_MCR_MDIS_0 = 0x0
	// Clock for standard PIT timers is disabled.
	PIT_MCR_MDIS_1 = 0x1

	// LTMR64H: PIT Upper Lifetime Timer Register
	// Position of LTH field.
	PIT_LTMR64H_LTH_Pos = 0x0
	// Bit mask of LTH field.
	PIT_LTMR64H_LTH_Msk = 0xffffffff

	// LTMR64L: PIT Lower Lifetime Timer Register
	// Position of LTL field.
	PIT_LTMR64L_LTL_Pos = 0x0
	// Bit mask of LTL field.
	PIT_LTMR64L_LTL_Msk = 0xffffffff

	// LDVAL0: Timer Load Value Register
	// Position of TSV field.
	PIT_LDVAL_TSV_Pos = 0x0
	// Bit mask of TSV field.
	PIT_LDVAL_TSV_Msk = 0xffffffff

	// CVAL0: Current Timer Value Register
	// Position of TVL field.
	PIT_CVAL_TVL_Pos = 0x0
	// Bit mask of TVL field.
	PIT_CVAL_TVL_Msk = 0xffffffff

	// TCTRL0: Timer Control Register
	// Position of TEN field.
	PIT_TCTRL_TEN_Pos = 0x0
	// Bit mask of TEN field.
	PIT_TCTRL_TEN_Msk = 0x1
	// Bit TEN.
	PIT_TCTRL_TEN = 0x1
	// Timer n is disabled.
	PIT_TCTRL_TEN_0 = 0x0
	// Timer n is enabled.
	PIT_TCTRL_TEN_1 = 0x1
	// Position of TIE field.
	PIT_TCTRL_TIE_Pos = 0x1
	// Bit mask of TIE field.
	PIT_TCTRL_TIE_Msk = 0x2
	// Bit TIE.
	PIT_TCTRL_TIE = 0x2
	// Interrupt requests from Timer n are disabled.
	PIT_TCTRL_TIE_0 = 0x0
	// Interrupt will be requested whenever TIF is set.
	PIT_TCTRL_TIE_1 = 0x1
	// Position of CHN field.
	PIT_TCTRL_CHN_Pos = 0x2
	// Bit mask of CHN field.
	PIT_TCTRL_CHN_Msk = 0x4
	// Bit CHN.
	PIT_TCTRL_CHN = 0x4
	// Timer is not chained.
	PIT_TCTRL_CHN_0 = 0x0
	// Timer is chained to previous timer. For example, for Channel 2, if this field is set, Timer 2 is chained to Timer 1.
	PIT_TCTRL_CHN_1 = 0x1

	// TFLG0: Timer Flag Register
	// Position of TIF field.
	PIT_TFLG_TIF_Pos = 0x0
	// Bit mask of TIF field.
	PIT_TFLG_TIF_Msk = 0x1
	// Bit TIF.
	PIT_TFLG_TIF = 0x1
	// Timeout has not yet occurred.
	PIT_TFLG_TIF_0 = 0x0
	// Timeout has occurred.
	PIT_TFLG_TIF_1 = 0x1
)

// Bitfields for TPM0: Timer/PWM Module
const (
	// SC: Status and Control
	// Position of PS field.
	TPM_SC_PS_Pos = 0x0
	// Bit mask of PS field.
	TPM_SC_PS_Msk = 0x7
	// Divide by 1
	TPM_SC_PS_000 = 0x0
	// Divide by 2
	TPM_SC_PS_001 = 0x1
	// Divide by 4
	TPM_SC_PS_010 = 0x2
	// Divide by 8
	TPM_SC_PS_011 = 0x3
	// Divide by 16
	TPM_SC_PS_100 = 0x4
	// Divide by 32
	TPM_SC_PS_101 = 0x5
	// Divide by 64
	TPM_SC_PS_110 = 0x6
	// Divide by 128
	TPM_SC_PS_111 = 0x7
	// Position of CMOD field.
	TPM_SC_CMOD_Pos = 0x3
	// Bit mask of CMOD field.
	TPM_SC_CMOD_Msk = 0x18
	// TPM counter is disabled
	TPM_SC_CMOD_00 = 0x0
	// TPM counter increments on every TPM counter clock
	TPM_SC_CMOD_01 = 0x1
	// TPM counter increments on rising edge of TPM_EXTCLK synchronized to the TPM counter clock
	TPM_SC_CMOD_10 = 0x2
	// Position of CPWMS field.
	TPM_SC_CPWMS_Pos = 0x5
	// Bit mask of CPWMS field.
	TPM_SC_CPWMS_Msk = 0x20
	// Bit CPWMS.
	TPM_SC_CPWMS = 0x20
	// TPM counter operates in up counting mode.
	TPM_SC_CPWMS_0 = 0x0
	// TPM counter operates in up-down counting mode.
	TPM_SC_CPWMS_1 = 0x1
	// Position of TOIE field.
	TPM_SC_TOIE_Pos = 0x6
	// Bit mask of TOIE field.
	TPM_SC_TOIE_Msk = 0x40
	// Bit TOIE.
	TPM_SC_TOIE = 0x40
	// Disable TOF interrupts. Use software polling or DMA request.
	TPM_SC_TOIE_0 = 0x0
	// Enable TOF interrupts. An interrupt is generated when TOF equals one.
	TPM_SC_TOIE_1 = 0x1
	// Position of TOF field.
	TPM_SC_TOF_Pos = 0x7
	// Bit mask of TOF field.
	TPM_SC_TOF_Msk = 0x80
	// Bit TOF.
	TPM_SC_TOF = 0x80
	// TPM counter has not overflowed.
	TPM_SC_TOF_0 = 0x0
	// TPM counter has overflowed.
	TPM_SC_TOF_1 = 0x1
	// Position of DMA field.
	TPM_SC_DMA_Pos = 0x8
	// Bit mask of DMA field.
	TPM_SC_DMA_Msk = 0x100
	// Bit DMA.
	TPM_SC_DMA = 0x100
	// Disables DMA transfers.
	TPM_SC_DMA_0 = 0x0
	// Enables DMA transfers.
	TPM_SC_DMA_1 = 0x1

	// CNT: Counter
	// Position of COUNT field.
	TPM_CNT_COUNT_Pos = 0x0
	// Bit mask of COUNT field.
	TPM_CNT_COUNT_Msk = 0xffff

	// MOD: Modulo
	// Position of MOD field.
	TPM_MOD_MOD_Pos = 0x0
	// Bit mask of MOD field.
	TPM_MOD_MOD_Msk = 0xffff

	// C0SC: Channel (n) Status and Control
	// Position of DMA field.
	TPM_CSC_DMA_Pos = 0x0
	// Bit mask of DMA field.
	TPM_CSC_DMA_Msk = 0x1
	// Bit DMA.
	TPM_CSC_DMA = 0x1
	// Disable DMA transfers.
	TPM_CSC_DMA_0 = 0x0
	// Enable DMA transfers.
	TPM_CSC_DMA_1 = 0x1
	// Position of ELSA field.
	TPM_CSC_ELSA_Pos = 0x2
	// Bit mask of ELSA field.
	TPM_CSC_ELSA_Msk = 0x4
	// Bit ELSA.
	TPM_CSC_ELSA = 0x4
	// Position of ELSB field.
	TPM_CSC_ELSB_Pos = 0x3
	// Bit mask of ELSB field.
	TPM_CSC_ELSB_Msk = 0x8
	// Bit ELSB.
	TPM_CSC_ELSB = 0x8
	// Position of MSA field.
	TPM_CSC_MSA_Pos = 0x4
	// Bit mask of MSA field.
	TPM_CSC_MSA_Msk = 0x10
	// Bit MSA.
	TPM_CSC_MSA = 0x10
	// Position of MSB field.
	TPM_CSC_MSB_Pos = 0x5
	// Bit mask of MSB field.
	TPM_CSC_MSB_Msk = 0x20
	// Bit MSB.
	TPM_CSC_MSB = 0x20
	// Position of CHIE field.
	TPM_CSC_CHIE_Pos = 0x6
	// Bit mask of CHIE field.
	TPM_CSC_CHIE_Msk = 0x40
	// Bit CHIE.
	TPM_CSC_CHIE = 0x40
	// Disable channel interrupts.
	TPM_CSC_CHIE_0 = 0x0
	// Enable channel interrupts.
	TPM_CSC_CHIE_1 = 0x1
	// Position of CHF field.
	TPM_CSC_CHF_Pos = 0x7
	// Bit mask of CHF field.
	TPM_CSC_CHF_Msk = 0x80
	// Bit CHF.
	TPM_CSC_CHF = 0x80
	// No channel event has occurred.
	TPM_CSC_CHF_0 = 0x0
	// A channel event has occurred.
	TPM_CSC_CHF_1 = 0x1

	// C0V: Channel (n) Value
	// Position of VAL field.
	TPM_CV_VAL_Pos = 0x0
	// Bit mask of VAL field.
	TPM_CV_VAL_Msk = 0xffff

	// STATUS: Capture and Compare Status
	// Position of CH0F field.
	TPM_STATUS_CH0F_Pos = 0x0
	// Bit mask of CH0F field.
	TPM_STATUS_CH0F_Msk = 0x1
	// Bit CH0F.
	TPM_STATUS_CH0F = 0x1
	// No channel event has occurred.
	TPM_STATUS_CH0F_0 = 0x0
	// A channel event has occurred.
	TPM_STATUS_CH0F_1 = 0x1
	// Position of CH1F field.
	TPM_STATUS_CH1F_Pos = 0x1
	// Bit mask of CH1F field.
	TPM_STATUS_CH1F_Msk = 0x2
	// Bit CH1F.
	TPM_STATUS_CH1F = 0x2
	// No channel event has occurred.
	TPM_STATUS_CH1F_0 = 0x0
	// A channel event has occurred.
	TPM_STATUS_CH1F_1 = 0x1
	// Position of CH2F field.
	TPM_STATUS_CH2F_Pos = 0x2
	// Bit mask of CH2F field.
	TPM_STATUS_CH2F_Msk = 0x4
	// Bit CH2F.
	TPM_STATUS_CH2F = 0x4
	// No channel event has occurred.
	TPM_STATUS_CH2F_0 = 0x0
	// A channel event has occurred.
	TPM_STATUS_CH2F_1 = 0x1
	// Position of CH3F field.
	TPM_STATUS_CH3F_Pos = 0x3
	// Bit mask of CH3F field.
	TPM_STATUS_CH3F_Msk = 0x8
	// Bit CH3F.
	TPM_STATUS_CH3F = 0x8
	// No channel event has occurred.
	TPM_STATUS_CH3F_0 = 0x0
	// A channel event has occurred.
	TPM_STATUS_CH3F_1 = 0x1
	// Position of TOF field.
	TPM_STATUS_TOF_Pos = 0x8
	// Bit mask of TOF field.
	TPM_STATUS_TOF_Msk = 0x100
	// Bit TOF.
	TPM_STATUS_TOF = 0x100
	// TPM counter has not overflowed.
	TPM_STATUS_TOF_0 = 0x0
	// TPM counter has overflowed.
	TPM_STATUS_TOF_1 = 0x1

	// COMBINE: Combine Channel Register
	// Position of COMBINE0 field.
	TPM_COMBINE_COMBINE0_Pos = 0x0
	// Bit mask of COMBINE0 field.
	TPM_COMBINE_COMBINE0_Msk = 0x1
	// Bit COMBINE0.
	TPM_COMBINE_COMBINE0 = 0x1
	// Channels 0 and 1 are independent.
	TPM_COMBINE_COMBINE0_0 = 0x0
	// Channels 0 and 1 are combined.
	TPM_COMBINE_COMBINE0_1 = 0x1
	// Position of COMSWAP0 field.
	TPM_COMBINE_COMSWAP0_Pos = 0x1
	// Bit mask of COMSWAP0 field.
	TPM_COMBINE_COMSWAP0_Msk = 0x2
	// Bit COMSWAP0.
	TPM_COMBINE_COMSWAP0 = 0x2
	// Even channel is used for input capture and 1st compare.
	TPM_COMBINE_COMSWAP0_0 = 0x0
	// Odd channel is used for input capture and 1st compare.
	TPM_COMBINE_COMSWAP0_1 = 0x1
	// Position of COMBINE1 field.
	TPM_COMBINE_COMBINE1_Pos = 0x8
	// Bit mask of COMBINE1 field.
	TPM_COMBINE_COMBINE1_Msk = 0x100
	// Bit COMBINE1.
	TPM_COMBINE_COMBINE1 = 0x100
	// Channels 2 and 3 are independent.
	TPM_COMBINE_COMBINE1_0 = 0x0
	// Channels 2 and 3 are combined.
	TPM_COMBINE_COMBINE1_1 = 0x1
	// Position of COMSWAP1 field.
	TPM_COMBINE_COMSWAP1_Pos = 0x9
	// Bit mask of COMSWAP1 field.
	TPM_COMBINE_COMSWAP1_Msk = 0x200
	// Bit COMSWAP1.
	TPM_COMBINE_COMSWAP1 = 0x200
	// Even channel is used for input capture and 1st compare.
	TPM_COMBINE_COMSWAP1_0 = 0x0
	// Odd channel is used for input capture and 1st compare.
	TPM_COMBINE_COMSWAP1_1 = 0x1

	// POL: Channel Polarity
	// Position of POL0 field.
	TPM_POL_POL0_Pos = 0x0
	// Bit mask of POL0 field.
	TPM_POL_POL0_Msk = 0x1
	// Bit POL0.
	TPM_POL_POL0 = 0x1
	// The channel polarity is active high.
	TPM_POL_POL0_0 = 0x0
	// The channel polarity is active low.
	TPM_POL_POL0_1 = 0x1
	// Position of POL1 field.
	TPM_POL_POL1_Pos = 0x1
	// Bit mask of POL1 field.
	TPM_POL_POL1_Msk = 0x2
	// Bit POL1.
	TPM_POL_POL1 = 0x2
	// The channel polarity is active high.
	TPM_POL_POL1_0 = 0x0
	// The channel polarity is active low.
	TPM_POL_POL1_1 = 0x1
	// Position of POL2 field.
	TPM_POL_POL2_Pos = 0x2
	// Bit mask of POL2 field.
	TPM_POL_POL2_Msk = 0x4
	// Bit POL2.
	TPM_POL_POL2 = 0x4
	// The channel polarity is active high.
	TPM_POL_POL2_0 = 0x0
	// The channel polarity is active low.
	TPM_POL_POL2_1 = 0x1
	// Position of POL3 field.
	TPM_POL_POL3_Pos = 0x3
	// Bit mask of POL3 field.
	TPM_POL_POL3_Msk = 0x8
	// Bit POL3.
	TPM_POL_POL3 = 0x8
	// The channel polarity is active high.
	TPM_POL_POL3_0 = 0x0
	// The channel polarity is active low.
	TPM_POL_POL3_1 = 0x1

	// FILTER: Filter Control
	// Position of CH0FVAL field.
	TPM_FILTER_CH0FVAL_Pos = 0x0
	// Bit mask of CH0FVAL field.
	TPM_FILTER_CH0FVAL_Msk = 0xf
	// Position of CH1FVAL field.
	TPM_FILTER_CH1FVAL_Pos = 0x4
	// Bit mask of CH1FVAL field.
	TPM_FILTER_CH1FVAL_Msk = 0xf0
	// Position of CH2FVAL field.
	TPM_FILTER_CH2FVAL_Pos = 0x8
	// Bit mask of CH2FVAL field.
	TPM_FILTER_CH2FVAL_Msk = 0xf00
	// Position of CH3FVAL field.
	TPM_FILTER_CH3FVAL_Pos = 0xc
	// Bit mask of CH3FVAL field.
	TPM_FILTER_CH3FVAL_Msk = 0xf000

	// QDCTRL: Quadrature Decoder Control and Status
	// Position of QUADEN field.
	TPM_QDCTRL_QUADEN_Pos = 0x0
	// Bit mask of QUADEN field.
	TPM_QDCTRL_QUADEN_Msk = 0x1
	// Bit QUADEN.
	TPM_QDCTRL_QUADEN = 0x1
	// Quadrature decoder mode is disabled.
	TPM_QDCTRL_QUADEN_0 = 0x0
	// Quadrature decoder mode is enabled.
	TPM_QDCTRL_QUADEN_1 = 0x1
	// Position of TOFDIR field.
	TPM_QDCTRL_TOFDIR_Pos = 0x1
	// Bit mask of TOFDIR field.
	TPM_QDCTRL_TOFDIR_Msk = 0x2
	// Bit TOFDIR.
	TPM_QDCTRL_TOFDIR = 0x2
	// TOF bit was set on the bottom of counting. There was an FTM counter decrement and FTM counter changes from its minimum value (zero) to its maximum value (MOD register).
	TPM_QDCTRL_TOFDIR_0 = 0x0
	// TOF bit was set on the top of counting. There was an FTM counter increment and FTM counter changes from its maximum value (MOD register) to its minimum value (zero).
	TPM_QDCTRL_TOFDIR_1 = 0x1
	// Position of QUADIR field.
	TPM_QDCTRL_QUADIR_Pos = 0x2
	// Bit mask of QUADIR field.
	TPM_QDCTRL_QUADIR_Msk = 0x4
	// Bit QUADIR.
	TPM_QDCTRL_QUADIR = 0x4
	// Counter direction is decreasing (counter decrement).
	TPM_QDCTRL_QUADIR_0 = 0x0
	// Counter direction is increasing (counter increment).
	TPM_QDCTRL_QUADIR_1 = 0x1
	// Position of QUADMODE field.
	TPM_QDCTRL_QUADMODE_Pos = 0x3
	// Bit mask of QUADMODE field.
	TPM_QDCTRL_QUADMODE_Msk = 0x8
	// Bit QUADMODE.
	TPM_QDCTRL_QUADMODE = 0x8
	// Phase encoding mode.
	TPM_QDCTRL_QUADMODE_0 = 0x0
	// Count and direction encoding mode.
	TPM_QDCTRL_QUADMODE_1 = 0x1

	// CONF: Configuration
	// Position of DOZEEN field.
	TPM_CONF_DOZEEN_Pos = 0x5
	// Bit mask of DOZEEN field.
	TPM_CONF_DOZEEN_Msk = 0x20
	// Bit DOZEEN.
	TPM_CONF_DOZEEN = 0x20
	// Internal TPM counter continues in Doze mode.
	TPM_CONF_DOZEEN_0 = 0x0
	// Internal TPM counter is paused and does not increment during Doze mode. Trigger inputs and input capture events are also ignored.
	TPM_CONF_DOZEEN_1 = 0x1
	// Position of DBGMODE field.
	TPM_CONF_DBGMODE_Pos = 0x6
	// Bit mask of DBGMODE field.
	TPM_CONF_DBGMODE_Msk = 0xc0
	// TPM counter is paused and does not increment during debug mode. Trigger inputs and input capture events are also ignored.
	TPM_CONF_DBGMODE_00 = 0x0
	// TPM counter continues in debug mode.
	TPM_CONF_DBGMODE_11 = 0x3
	// Position of GTBSYNC field.
	TPM_CONF_GTBSYNC_Pos = 0x8
	// Bit mask of GTBSYNC field.
	TPM_CONF_GTBSYNC_Msk = 0x100
	// Bit GTBSYNC.
	TPM_CONF_GTBSYNC = 0x100
	// Global timebase synchronization disabled.
	TPM_CONF_GTBSYNC_0 = 0x0
	// Global timebase synchronization enabled.
	TPM_CONF_GTBSYNC_1 = 0x1
	// Position of GTBEEN field.
	TPM_CONF_GTBEEN_Pos = 0x9
	// Bit mask of GTBEEN field.
	TPM_CONF_GTBEEN_Msk = 0x200
	// Bit GTBEEN.
	TPM_CONF_GTBEEN = 0x200
	// All channels use the internally generated TPM counter as their timebase
	TPM_CONF_GTBEEN_0 = 0x0
	// All channels use an externally generated global timebase as their timebase
	TPM_CONF_GTBEEN_1 = 0x1
	// Position of CSOT field.
	TPM_CONF_CSOT_Pos = 0x10
	// Bit mask of CSOT field.
	TPM_CONF_CSOT_Msk = 0x10000
	// Bit CSOT.
	TPM_CONF_CSOT = 0x10000
	// TPM counter starts to increment immediately, once it is enabled.
	TPM_CONF_CSOT_0 = 0x0
	// TPM counter only starts to increment when it a rising edge on the selected input trigger is detected, after it has been enabled or after it has stopped due to overflow.
	TPM_CONF_CSOT_1 = 0x1
	// Position of CSOO field.
	TPM_CONF_CSOO_Pos = 0x11
	// Bit mask of CSOO field.
	TPM_CONF_CSOO_Msk = 0x20000
	// Bit CSOO.
	TPM_CONF_CSOO = 0x20000
	// TPM counter continues incrementing or decrementing after overflow
	TPM_CONF_CSOO_0 = 0x0
	// TPM counter stops incrementing or decrementing after overflow.
	TPM_CONF_CSOO_1 = 0x1
	// Position of CROT field.
	TPM_CONF_CROT_Pos = 0x12
	// Bit mask of CROT field.
	TPM_CONF_CROT_Msk = 0x40000
	// Bit CROT.
	TPM_CONF_CROT = 0x40000
	// Counter is not reloaded due to a rising edge on the selected input trigger
	TPM_CONF_CROT_0 = 0x0
	// Counter is reloaded when a rising edge is detected on the selected input trigger
	TPM_CONF_CROT_1 = 0x1
	// Position of CPOT field.
	TPM_CONF_CPOT_Pos = 0x13
	// Bit mask of CPOT field.
	TPM_CONF_CPOT_Msk = 0x80000
	// Bit CPOT.
	TPM_CONF_CPOT = 0x80000
	// Position of TRGPOL field.
	TPM_CONF_TRGPOL_Pos = 0x16
	// Bit mask of TRGPOL field.
	TPM_CONF_TRGPOL_Msk = 0x400000
	// Bit TRGPOL.
	TPM_CONF_TRGPOL = 0x400000
	// Trigger is active high.
	TPM_CONF_TRGPOL_0 = 0x0
	// Trigger is active low.
	TPM_CONF_TRGPOL_1 = 0x1
	// Position of TRGSRC field.
	TPM_CONF_TRGSRC_Pos = 0x17
	// Bit mask of TRGSRC field.
	TPM_CONF_TRGSRC_Msk = 0x800000
	// Bit TRGSRC.
	TPM_CONF_TRGSRC = 0x800000
	// Trigger source selected by TRGSEL is external.
	TPM_CONF_TRGSRC_0 = 0x0
	// Trigger source selected by TRGSEL is internal (channel pin input capture).
	TPM_CONF_TRGSRC_1 = 0x1
	// Position of TRGSEL field.
	TPM_CONF_TRGSEL_Pos = 0x18
	// Bit mask of TRGSEL field.
	TPM_CONF_TRGSEL_Msk = 0xf000000
	// Channel 0 pin input capture
	TPM_CONF_TRGSEL_0001 = 0x1
	// Channel 1 pin input capture
	TPM_CONF_TRGSEL_0010 = 0x2
	// Channel 0 or Channel 1 pin input capture
	TPM_CONF_TRGSEL_0011 = 0x3
	// Channel 2 pin input capture
	TPM_CONF_TRGSEL_0100 = 0x4
	// Channel 0 or Channel 2 pin input capture
	TPM_CONF_TRGSEL_0101 = 0x5
	// Channel 1 or Channel 2 pin input capture
	TPM_CONF_TRGSEL_0110 = 0x6
	// Channel 0 or Channel 1 or Channel 2 pin input capture
	TPM_CONF_TRGSEL_0111 = 0x7
	// Channel 3 pin input capture
	TPM_CONF_TRGSEL_1000 = 0x8
	// Channel 0 or Channel 3 pin input capture
	TPM_CONF_TRGSEL_1001 = 0x9
	// Channel 1 or Channel 3 pin input capture
	TPM_CONF_TRGSEL_1010 = 0xa
	// Channel 0 or Channel 1 or Channel 3 pin input capture
	TPM_CONF_TRGSEL_1011 = 0xb
	// Channel 2 or Channel 3 pin input capture
	TPM_CONF_TRGSEL_1100 = 0xc
	// Channel 0 or Channel 2 or Channel 3 pin input capture
	TPM_CONF_TRGSEL_1101 = 0xd
	// Channel 1 or Channel 2 or Channel 3 pin input capture
	TPM_CONF_TRGSEL_1110 = 0xe
	// Channel 0 or Channel 1 or Channel 2 or Channel 3 pin input capture
	TPM_CONF_TRGSEL_1111 = 0xf
)

// Bitfields for ADC0: Analog-to-Digital Converter
const (
	// SC1A: ADC Status and Control Registers 1
	// Position of ADCH field.
	ADC0_SC1_ADCH_Pos = 0x0
	// Bit mask of ADCH field.
	ADC0_SC1_ADCH_Msk = 0x1f
	// When DIFF=0, DADP0 is selected as input; when DIFF=1, DAD0 is selected as input.
	ADC0_SC1_ADCH_00000 = 0x0
	// When DIFF=0, DADP1 is selected as input; when DIFF=1, DAD1 is selected as input.
	ADC0_SC1_ADCH_00001 = 0x1
	// When DIFF=0, DADP2 is selected as input; when DIFF=1, DAD2 is selected as input.
	ADC0_SC1_ADCH_00010 = 0x2
	// When DIFF=0, DADP3 is selected as input; when DIFF=1, DAD3 is selected as input.
	ADC0_SC1_ADCH_00011 = 0x3
	// When DIFF=0, AD4 is selected as input; when DIFF=1, it is reserved.
	ADC0_SC1_ADCH_00100 = 0x4
	// When DIFF=0, AD5 is selected as input; when DIFF=1, it is reserved.
	ADC0_SC1_ADCH_00101 = 0x5
	// When DIFF=0, AD6 is selected as input; when DIFF=1, it is reserved.
	ADC0_SC1_ADCH_00110 = 0x6
	// When DIFF=0, AD7 is selected as input; when DIFF=1, it is reserved.
	ADC0_SC1_ADCH_00111 = 0x7
	// When DIFF=0, AD8 is selected as input; when DIFF=1, it is reserved.
	ADC0_SC1_ADCH_01000 = 0x8
	// When DIFF=0, AD9 is selected as input; when DIFF=1, it is reserved.
	ADC0_SC1_ADCH_01001 = 0x9
	// When DIFF=0, AD10 is selected as input; when DIFF=1, it is reserved.
	ADC0_SC1_ADCH_01010 = 0xa
	// When DIFF=0, AD11 is selected as input; when DIFF=1, it is reserved.
	ADC0_SC1_ADCH_01011 = 0xb
	// When DIFF=0, AD12 is selected as input; when DIFF=1, it is reserved.
	ADC0_SC1_ADCH_01100 = 0xc
	// When DIFF=0, AD13 is selected as input; when DIFF=1, it is reserved.
	ADC0_SC1_ADCH_01101 = 0xd
	// When DIFF=0, AD14 is selected as input; when DIFF=1, it is reserved.
	ADC0_SC1_ADCH_01110 = 0xe
	// When DIFF=0, AD15 is selected as input; when DIFF=1, it is reserved.
	ADC0_SC1_ADCH_01111 = 0xf
	// When DIFF=0, AD16 is selected as input; when DIFF=1, it is reserved.
	ADC0_SC1_ADCH_10000 = 0x10
	// When DIFF=0, AD17 is selected as input; when DIFF=1, it is reserved.
	ADC0_SC1_ADCH_10001 = 0x11
	// When DIFF=0, AD18 is selected as input; when DIFF=1, it is reserved.
	ADC0_SC1_ADCH_10010 = 0x12
	// When DIFF=0, AD19 is selected as input; when DIFF=1, it is reserved.
	ADC0_SC1_ADCH_10011 = 0x13
	// When DIFF=0, AD20 is selected as input; when DIFF=1, it is reserved.
	ADC0_SC1_ADCH_10100 = 0x14
	// When DIFF=0, AD21 is selected as input; when DIFF=1, it is reserved.
	ADC0_SC1_ADCH_10101 = 0x15
	// When DIFF=0, AD22 is selected as input; when DIFF=1, it is reserved.
	ADC0_SC1_ADCH_10110 = 0x16
	// When DIFF=0, AD23 is selected as input; when DIFF=1, it is reserved.
	ADC0_SC1_ADCH_10111 = 0x17
	// When DIFF=0, Temp Sensor (single-ended) is selected as input; when DIFF=1, Temp Sensor (differential) is selected as input.
	ADC0_SC1_ADCH_11010 = 0x1a
	// When DIFF=0, Bandgap (single-ended) is selected as input; when DIFF=1, Bandgap (differential) is selected as input.
	ADC0_SC1_ADCH_11011 = 0x1b
	// When DIFF=0,VREFSH is selected as input; when DIFF=1, -VREFSH (differential) is selected as input. Voltage reference selected is determined by SC2[REFSEL].
	ADC0_SC1_ADCH_11101 = 0x1d
	// When DIFF=0,VREFSL is selected as input; when DIFF=1, it is reserved. Voltage reference selected is determined by SC2[REFSEL].
	ADC0_SC1_ADCH_11110 = 0x1e
	// Module is disabled.
	ADC0_SC1_ADCH_11111 = 0x1f
	// Position of DIFF field.
	ADC0_SC1_DIFF_Pos = 0x5
	// Bit mask of DIFF field.
	ADC0_SC1_DIFF_Msk = 0x20
	// Bit DIFF.
	ADC0_SC1_DIFF = 0x20
	// Single-ended conversions and input channels are selected.
	ADC0_SC1_DIFF_0 = 0x0
	// Differential conversions and input channels are selected.
	ADC0_SC1_DIFF_1 = 0x1
	// Position of AIEN field.
	ADC0_SC1_AIEN_Pos = 0x6
	// Bit mask of AIEN field.
	ADC0_SC1_AIEN_Msk = 0x40
	// Bit AIEN.
	ADC0_SC1_AIEN = 0x40
	// Conversion complete interrupt is disabled.
	ADC0_SC1_AIEN_0 = 0x0
	// Conversion complete interrupt is enabled.
	ADC0_SC1_AIEN_1 = 0x1
	// Position of COCO field.
	ADC0_SC1_COCO_Pos = 0x7
	// Bit mask of COCO field.
	ADC0_SC1_COCO_Msk = 0x80
	// Bit COCO.
	ADC0_SC1_COCO = 0x80
	// Conversion is not completed.
	ADC0_SC1_COCO_0 = 0x0
	// Conversion is completed.
	ADC0_SC1_COCO_1 = 0x1

	// CFG1: ADC Configuration Register 1
	// Position of ADICLK field.
	ADC0_CFG1_ADICLK_Pos = 0x0
	// Bit mask of ADICLK field.
	ADC0_CFG1_ADICLK_Msk = 0x3
	// Bus clock
	ADC0_CFG1_ADICLK_00 = 0x0
	// Bus clock divided by 2(BUSCLK/2)
	ADC0_CFG1_ADICLK_01 = 0x1
	// Alternate clock (ALTCLK)
	ADC0_CFG1_ADICLK_10 = 0x2
	// Asynchronous clock (ADACK)
	ADC0_CFG1_ADICLK_11 = 0x3
	// Position of MODE field.
	ADC0_CFG1_MODE_Pos = 0x2
	// Bit mask of MODE field.
	ADC0_CFG1_MODE_Msk = 0xc
	// When DIFF=0:It is single-ended 8-bit conversion; when DIFF=1, it is differential 9-bit conversion with 2's complement output.
	ADC0_CFG1_MODE_00 = 0x0
	// When DIFF=0:It is single-ended 12-bit conversion ; when DIFF=1, it is differential 13-bit conversion with 2's complement output.
	ADC0_CFG1_MODE_01 = 0x1
	// When DIFF=0:It is single-ended 10-bit conversion. ; when DIFF=1, it is differential 11-bit conversion with 2's complement output
	ADC0_CFG1_MODE_10 = 0x2
	// When DIFF=0:It is single-ended 16-bit conversion..; when DIFF=1, it is differential 16-bit conversion with 2's complement output
	ADC0_CFG1_MODE_11 = 0x3
	// Position of ADLSMP field.
	ADC0_CFG1_ADLSMP_Pos = 0x4
	// Bit mask of ADLSMP field.
	ADC0_CFG1_ADLSMP_Msk = 0x10
	// Bit ADLSMP.
	ADC0_CFG1_ADLSMP = 0x10
	// Short sample time.
	ADC0_CFG1_ADLSMP_0 = 0x0
	// Long sample time.
	ADC0_CFG1_ADLSMP_1 = 0x1
	// Position of ADIV field.
	ADC0_CFG1_ADIV_Pos = 0x5
	// Bit mask of ADIV field.
	ADC0_CFG1_ADIV_Msk = 0x60
	// The divide ratio is 1 and the clock rate is input clock.
	ADC0_CFG1_ADIV_00 = 0x0
	// The divide ratio is 2 and the clock rate is (input clock)/2.
	ADC0_CFG1_ADIV_01 = 0x1
	// The divide ratio is 4 and the clock rate is (input clock)/4.
	ADC0_CFG1_ADIV_10 = 0x2
	// The divide ratio is 8 and the clock rate is (input clock)/8.
	ADC0_CFG1_ADIV_11 = 0x3
	// Position of ADLPC field.
	ADC0_CFG1_ADLPC_Pos = 0x7
	// Bit mask of ADLPC field.
	ADC0_CFG1_ADLPC_Msk = 0x80
	// Bit ADLPC.
	ADC0_CFG1_ADLPC = 0x80
	// Normal power configuration.
	ADC0_CFG1_ADLPC_0 = 0x0
	// Low-power configuration. The power is reduced at the expense of maximum clock speed.
	ADC0_CFG1_ADLPC_1 = 0x1

	// CFG2: ADC Configuration Register 2
	// Position of ADLSTS field.
	ADC0_CFG2_ADLSTS_Pos = 0x0
	// Bit mask of ADLSTS field.
	ADC0_CFG2_ADLSTS_Msk = 0x3
	// Default longest sample time; 20 extra ADCK cycles; 24 ADCK cycles total.
	ADC0_CFG2_ADLSTS_00 = 0x0
	// 12 extra ADCK cycles; 16 ADCK cycles total sample time.
	ADC0_CFG2_ADLSTS_01 = 0x1
	// 6 extra ADCK cycles; 10 ADCK cycles total sample time.
	ADC0_CFG2_ADLSTS_10 = 0x2
	// 2 extra ADCK cycles; 6 ADCK cycles total sample time.
	ADC0_CFG2_ADLSTS_11 = 0x3
	// Position of ADHSC field.
	ADC0_CFG2_ADHSC_Pos = 0x2
	// Bit mask of ADHSC field.
	ADC0_CFG2_ADHSC_Msk = 0x4
	// Bit ADHSC.
	ADC0_CFG2_ADHSC = 0x4
	// Normal conversion sequence selected.
	ADC0_CFG2_ADHSC_0 = 0x0
	// High-speed conversion sequence selected with 2 additional ADCK cycles to total conversion time.
	ADC0_CFG2_ADHSC_1 = 0x1
	// Position of ADACKEN field.
	ADC0_CFG2_ADACKEN_Pos = 0x3
	// Bit mask of ADACKEN field.
	ADC0_CFG2_ADACKEN_Msk = 0x8
	// Bit ADACKEN.
	ADC0_CFG2_ADACKEN = 0x8
	// Asynchronous clock output disabled; Asynchronous clock is enabled only if selected by ADICLK and a conversion is active.
	ADC0_CFG2_ADACKEN_0 = 0x0
	// Asynchronous clock and clock output is enabled regardless of the state of the ADC.
	ADC0_CFG2_ADACKEN_1 = 0x1
	// Position of MUXSEL field.
	ADC0_CFG2_MUXSEL_Pos = 0x4
	// Bit mask of MUXSEL field.
	ADC0_CFG2_MUXSEL_Msk = 0x10
	// Bit MUXSEL.
	ADC0_CFG2_MUXSEL = 0x10
	// ADxxa channels are selected.
	ADC0_CFG2_MUXSEL_0 = 0x0
	// ADxxb channels are selected.
	ADC0_CFG2_MUXSEL_1 = 0x1

	// RA: ADC Data Result Register
	// Position of D field.
	ADC0_R_D_Pos = 0x0
	// Bit mask of D field.
	ADC0_R_D_Msk = 0xffff

	// CV1: Compare Value Registers
	// Position of CV field.
	ADC0_CV_CV_Pos = 0x0
	// Bit mask of CV field.
	ADC0_CV_CV_Msk = 0xffff

	// SC2: Status and Control Register 2
	// Position of REFSEL field.
	ADC0_SC2_REFSEL_Pos = 0x0
	// Bit mask of REFSEL field.
	ADC0_SC2_REFSEL_Msk = 0x3
	// Default voltage reference pin pair, that is, external pins VREFH and VREFL
	ADC0_SC2_REFSEL_00 = 0x0
	// Alternate reference pair, that is, VALTH and VALTL . This pair may be additional external pins or internal sources depending on the MCU configuration. See the chip configuration information for details specific to this MCU
	ADC0_SC2_REFSEL_01 = 0x1
	// Position of DMAEN field.
	ADC0_SC2_DMAEN_Pos = 0x2
	// Bit mask of DMAEN field.
	ADC0_SC2_DMAEN_Msk = 0x4
	// Bit DMAEN.
	ADC0_SC2_DMAEN = 0x4
	// DMA is disabled.
	ADC0_SC2_DMAEN_0 = 0x0
	// DMA is enabled and will assert the ADC DMA request during an ADC conversion complete event noted when any of the SC1n[COCO] flags is asserted.
	ADC0_SC2_DMAEN_1 = 0x1
	// Position of ACREN field.
	ADC0_SC2_ACREN_Pos = 0x3
	// Bit mask of ACREN field.
	ADC0_SC2_ACREN_Msk = 0x8
	// Bit ACREN.
	ADC0_SC2_ACREN = 0x8
	// Range function disabled. Only CV1 is compared.
	ADC0_SC2_ACREN_0 = 0x0
	// Range function enabled. Both CV1 and CV2 are compared.
	ADC0_SC2_ACREN_1 = 0x1
	// Position of ACFGT field.
	ADC0_SC2_ACFGT_Pos = 0x4
	// Bit mask of ACFGT field.
	ADC0_SC2_ACFGT_Msk = 0x10
	// Bit ACFGT.
	ADC0_SC2_ACFGT = 0x10
	// Configures less than threshold, outside range not inclusive and inside range not inclusive; functionality based on the values placed in CV1 and CV2.
	ADC0_SC2_ACFGT_0 = 0x0
	// Configures greater than or equal to threshold, outside and inside ranges inclusive; functionality based on the values placed in CV1 and CV2.
	ADC0_SC2_ACFGT_1 = 0x1
	// Position of ACFE field.
	ADC0_SC2_ACFE_Pos = 0x5
	// Bit mask of ACFE field.
	ADC0_SC2_ACFE_Msk = 0x20
	// Bit ACFE.
	ADC0_SC2_ACFE = 0x20
	// Compare function disabled.
	ADC0_SC2_ACFE_0 = 0x0
	// Compare function enabled.
	ADC0_SC2_ACFE_1 = 0x1
	// Position of ADTRG field.
	ADC0_SC2_ADTRG_Pos = 0x6
	// Bit mask of ADTRG field.
	ADC0_SC2_ADTRG_Msk = 0x40
	// Bit ADTRG.
	ADC0_SC2_ADTRG = 0x40
	// Software trigger selected.
	ADC0_SC2_ADTRG_0 = 0x0
	// Hardware trigger selected.
	ADC0_SC2_ADTRG_1 = 0x1
	// Position of ADACT field.
	ADC0_SC2_ADACT_Pos = 0x7
	// Bit mask of ADACT field.
	ADC0_SC2_ADACT_Msk = 0x80
	// Bit ADACT.
	ADC0_SC2_ADACT = 0x80
	// Conversion not in progress.
	ADC0_SC2_ADACT_0 = 0x0
	// Conversion in progress.
	ADC0_SC2_ADACT_1 = 0x1

	// SC3: Status and Control Register 3
	// Position of AVGS field.
	ADC0_SC3_AVGS_Pos = 0x0
	// Bit mask of AVGS field.
	ADC0_SC3_AVGS_Msk = 0x3
	// 4 samples averaged.
	ADC0_SC3_AVGS_00 = 0x0
	// 8 samples averaged.
	ADC0_SC3_AVGS_01 = 0x1
	// 16 samples averaged.
	ADC0_SC3_AVGS_10 = 0x2
	// 32 samples averaged.
	ADC0_SC3_AVGS_11 = 0x3
	// Position of AVGE field.
	ADC0_SC3_AVGE_Pos = 0x2
	// Bit mask of AVGE field.
	ADC0_SC3_AVGE_Msk = 0x4
	// Bit AVGE.
	ADC0_SC3_AVGE = 0x4
	// Hardware average function disabled.
	ADC0_SC3_AVGE_0 = 0x0
	// Hardware average function enabled.
	ADC0_SC3_AVGE_1 = 0x1
	// Position of ADCO field.
	ADC0_SC3_ADCO_Pos = 0x3
	// Bit mask of ADCO field.
	ADC0_SC3_ADCO_Msk = 0x8
	// Bit ADCO.
	ADC0_SC3_ADCO = 0x8
	// One conversion or one set of conversions if the hardware average function is enabled, that is, AVGE=1, after initiating a conversion.
	ADC0_SC3_ADCO_0 = 0x0
	// Continuous conversions or sets of conversions if the hardware average function is enabled, that is, AVGE=1, after initiating a conversion.
	ADC0_SC3_ADCO_1 = 0x1
	// Position of CALF field.
	ADC0_SC3_CALF_Pos = 0x6
	// Bit mask of CALF field.
	ADC0_SC3_CALF_Msk = 0x40
	// Bit CALF.
	ADC0_SC3_CALF = 0x40
	// Calibration completed normally.
	ADC0_SC3_CALF_0 = 0x0
	// Calibration failed. ADC accuracy specifications are not guaranteed.
	ADC0_SC3_CALF_1 = 0x1
	// Position of CAL field.
	ADC0_SC3_CAL_Pos = 0x7
	// Bit mask of CAL field.
	ADC0_SC3_CAL_Msk = 0x80
	// Bit CAL.
	ADC0_SC3_CAL = 0x80

	// OFS: ADC Offset Correction Register
	// Position of OFS field.
	ADC0_OFS_OFS_Pos = 0x0
	// Bit mask of OFS field.
	ADC0_OFS_OFS_Msk = 0xffff

	// PG: ADC Plus-Side Gain Register
	// Position of PG field.
	ADC0_PG_PG_Pos = 0x0
	// Bit mask of PG field.
	ADC0_PG_PG_Msk = 0xffff

	// MG: ADC Minus-Side Gain Register
	// Position of MG field.
	ADC0_MG_MG_Pos = 0x0
	// Bit mask of MG field.
	ADC0_MG_MG_Msk = 0xffff

	// CLPD: ADC Plus-Side General Calibration Value Register
	// Position of CLPD field.
	ADC0_CLPD_CLPD_Pos = 0x0
	// Bit mask of CLPD field.
	ADC0_CLPD_CLPD_Msk = 0x3f

	// CLPS: ADC Plus-Side General Calibration Value Register
	// Position of CLPS field.
	ADC0_CLPS_CLPS_Pos = 0x0
	// Bit mask of CLPS field.
	ADC0_CLPS_CLPS_Msk = 0x3f

	// CLP4: ADC Plus-Side General Calibration Value Register
	// Position of CLP4 field.
	ADC0_CLP4_CLP4_Pos = 0x0
	// Bit mask of CLP4 field.
	ADC0_CLP4_CLP4_Msk = 0x3ff

	// CLP3: ADC Plus-Side General Calibration Value Register
	// Position of CLP3 field.
	ADC0_CLP3_CLP3_Pos = 0x0
	// Bit mask of CLP3 field.
	ADC0_CLP3_CLP3_Msk = 0x1ff

	// CLP2: ADC Plus-Side General Calibration Value Register
	// Position of CLP2 field.
	ADC0_CLP2_CLP2_Pos = 0x0
	// Bit mask of CLP2 field.
	ADC0_CLP2_CLP2_Msk = 0xff

	// CLP1: ADC Plus-Side General Calibration Value Register
	// Position of CLP1 field.
	ADC0_CLP1_CLP1_Pos = 0x0
	// Bit mask of CLP1 field.
	ADC0_CLP1_CLP1_Msk = 0x7f

	// CLP0: ADC Plus-Side General Calibration Value Register
	// Position of CLP0 field.
	ADC0_CLP0_CLP0_Pos = 0x0
	// Bit mask of CLP0 field.
	ADC0_CLP0_CLP0_Msk = 0x3f

	// CLMD: ADC Minus-Side General Calibration Value Register
	// Position of CLMD field.
	ADC0_CLMD_CLMD_Pos = 0x0
	// Bit mask of CLMD field.
	ADC0_CLMD_CLMD_Msk = 0x3f

	// CLMS: ADC Minus-Side General Calibration Value Register
	// Position of CLMS field.
	ADC0_CLMS_CLMS_Pos = 0x0
	// Bit mask of CLMS field.
	ADC0_CLMS_CLMS_Msk = 0x3f

	// CLM4: ADC Minus-Side General Calibration Value Register
	// Position of CLM4 field.
	ADC0_CLM4_CLM4_Pos = 0x0
	// Bit mask of CLM4 field.
	ADC0_CLM4_CLM4_Msk = 0x3ff

	// CLM3: ADC Minus-Side General Calibration Value Register
	// Position of CLM3 field.
	ADC0_CLM3_CLM3_Pos = 0x0
	// Bit mask of CLM3 field.
	ADC0_CLM3_CLM3_Msk = 0x1ff

	// CLM2: ADC Minus-Side General Calibration Value Register
	// Position of CLM2 field.
	ADC0_CLM2_CLM2_Pos = 0x0
	// Bit mask of CLM2 field.
	ADC0_CLM2_CLM2_Msk = 0xff

	// CLM1: ADC Minus-Side General Calibration Value Register
	// Position of CLM1 field.
	ADC0_CLM1_CLM1_Pos = 0x0
	// Bit mask of CLM1 field.
	ADC0_CLM1_CLM1_Msk = 0x7f

	// CLM0: ADC Minus-Side General Calibration Value Register
	// Position of CLM0 field.
	ADC0_CLM0_CLM0_Pos = 0x0
	// Bit mask of CLM0 field.
	ADC0_CLM0_CLM0_Msk = 0x3f
)

// Bitfields for RTC: Secure Real Time Clock
const (
	// TSR: RTC Time Seconds Register
	// Position of TSR field.
	RTC_TSR_TSR_Pos = 0x0
	// Bit mask of TSR field.
	RTC_TSR_TSR_Msk = 0xffffffff

	// TPR: RTC Time Prescaler Register
	// Position of TPR field.
	RTC_TPR_TPR_Pos = 0x0
	// Bit mask of TPR field.
	RTC_TPR_TPR_Msk = 0xffff

	// TAR: RTC Time Alarm Register
	// Position of TAR field.
	RTC_TAR_TAR_Pos = 0x0
	// Bit mask of TAR field.
	RTC_TAR_TAR_Msk = 0xffffffff

	// TCR: RTC Time Compensation Register
	// Position of TCR field.
	RTC_TCR_TCR_Pos = 0x0
	// Bit mask of TCR field.
	RTC_TCR_TCR_Msk = 0xff
	// Time Prescaler Register overflows every 32896 clock cycles.
	RTC_TCR_TCR_10000000 = 0x80
	// Time Prescaler Register overflows every 32769 clock cycles.
	RTC_TCR_TCR_11111111 = 0xff
	// Time Prescaler Register overflows every 32768 clock cycles.
	RTC_TCR_TCR_0 = 0x0
	// Time Prescaler Register overflows every 32767 clock cycles.
	RTC_TCR_TCR_1 = 0x1
	// Time Prescaler Register overflows every 32641 clock cycles.
	RTC_TCR_TCR_1111111 = 0x7f
	// Position of CIR field.
	RTC_TCR_CIR_Pos = 0x8
	// Bit mask of CIR field.
	RTC_TCR_CIR_Msk = 0xff00
	// Position of TCV field.
	RTC_TCR_TCV_Pos = 0x10
	// Bit mask of TCV field.
	RTC_TCR_TCV_Msk = 0xff0000
	// Position of CIC field.
	RTC_TCR_CIC_Pos = 0x18
	// Bit mask of CIC field.
	RTC_TCR_CIC_Msk = 0xff000000

	// CR: RTC Control Register
	// Position of SWR field.
	RTC_CR_SWR_Pos = 0x0
	// Bit mask of SWR field.
	RTC_CR_SWR_Msk = 0x1
	// Bit SWR.
	RTC_CR_SWR = 0x1
	// No effect.
	RTC_CR_SWR_0 = 0x0
	// Resets all RTC registers except for the SWR bit . The SWR bit is cleared by POR and by software explicitly clearing it.
	RTC_CR_SWR_1 = 0x1
	// Position of WPE field.
	RTC_CR_WPE_Pos = 0x1
	// Bit mask of WPE field.
	RTC_CR_WPE_Msk = 0x2
	// Bit WPE.
	RTC_CR_WPE = 0x2
	// Wakeup pin is disabled.
	RTC_CR_WPE_0 = 0x0
	// Wakeup pin is enabled and wakeup pin asserts if the RTC interrupt asserts or the wakeup pin is turned on.
	RTC_CR_WPE_1 = 0x1
	// Position of SUP field.
	RTC_CR_SUP_Pos = 0x2
	// Bit mask of SUP field.
	RTC_CR_SUP_Msk = 0x4
	// Bit SUP.
	RTC_CR_SUP = 0x4
	// Non-supervisor mode write accesses are not supported and generate a bus error.
	RTC_CR_SUP_0 = 0x0
	// Non-supervisor mode write accesses are supported.
	RTC_CR_SUP_1 = 0x1
	// Position of UM field.
	RTC_CR_UM_Pos = 0x3
	// Bit mask of UM field.
	RTC_CR_UM_Msk = 0x8
	// Bit UM.
	RTC_CR_UM = 0x8
	// Registers cannot be written when locked.
	RTC_CR_UM_0 = 0x0
	// Registers can be written when locked under limited conditions.
	RTC_CR_UM_1 = 0x1
	// Position of WPS field.
	RTC_CR_WPS_Pos = 0x4
	// Bit mask of WPS field.
	RTC_CR_WPS_Msk = 0x10
	// Bit WPS.
	RTC_CR_WPS = 0x10
	// Wakeup pin asserts (active low, open drain) if the RTC interrupt asserts or the wakeup pin is turned on.
	RTC_CR_WPS_0 = 0x0
	// Wakeup pin instead outputs the RTC 32kHz clock, provided the wakeup pin is turned on and the 32kHz clock is output to other peripherals.
	RTC_CR_WPS_1 = 0x1
	// Position of OSCE field.
	RTC_CR_OSCE_Pos = 0x8
	// Bit mask of OSCE field.
	RTC_CR_OSCE_Msk = 0x100
	// Bit OSCE.
	RTC_CR_OSCE = 0x100
	// 32.768 kHz oscillator is disabled.
	RTC_CR_OSCE_0 = 0x0
	// 32.768 kHz oscillator is enabled. After setting this bit, wait the oscillator startup time before enabling the time counter to allow the 32.768 kHz clock time to stabilize.
	RTC_CR_OSCE_1 = 0x1
	// Position of CLKO field.
	RTC_CR_CLKO_Pos = 0x9
	// Bit mask of CLKO field.
	RTC_CR_CLKO_Msk = 0x200
	// Bit CLKO.
	RTC_CR_CLKO = 0x200
	// The 32 kHz clock is output to other peripherals.
	RTC_CR_CLKO_0 = 0x0
	// The 32 kHz clock is not output to other peripherals.
	RTC_CR_CLKO_1 = 0x1
	// Position of SC16P field.
	RTC_CR_SC16P_Pos = 0xa
	// Bit mask of SC16P field.
	RTC_CR_SC16P_Msk = 0x400
	// Bit SC16P.
	RTC_CR_SC16P = 0x400
	// Disable the load.
	RTC_CR_SC16P_0 = 0x0
	// Enable the additional load.
	RTC_CR_SC16P_1 = 0x1
	// Position of SC8P field.
	RTC_CR_SC8P_Pos = 0xb
	// Bit mask of SC8P field.
	RTC_CR_SC8P_Msk = 0x800
	// Bit SC8P.
	RTC_CR_SC8P = 0x800
	// Disable the load.
	RTC_CR_SC8P_0 = 0x0
	// Enable the additional load.
	RTC_CR_SC8P_1 = 0x1
	// Position of SC4P field.
	RTC_CR_SC4P_Pos = 0xc
	// Bit mask of SC4P field.
	RTC_CR_SC4P_Msk = 0x1000
	// Bit SC4P.
	RTC_CR_SC4P = 0x1000
	// Disable the load.
	RTC_CR_SC4P_0 = 0x0
	// Enable the additional load.
	RTC_CR_SC4P_1 = 0x1
	// Position of SC2P field.
	RTC_CR_SC2P_Pos = 0xd
	// Bit mask of SC2P field.
	RTC_CR_SC2P_Msk = 0x2000
	// Bit SC2P.
	RTC_CR_SC2P = 0x2000
	// Disable the load.
	RTC_CR_SC2P_0 = 0x0
	// Enable the additional load.
	RTC_CR_SC2P_1 = 0x1

	// SR: RTC Status Register
	// Position of TIF field.
	RTC_SR_TIF_Pos = 0x0
	// Bit mask of TIF field.
	RTC_SR_TIF_Msk = 0x1
	// Bit TIF.
	RTC_SR_TIF = 0x1
	// Time is valid.
	RTC_SR_TIF_0 = 0x0
	// Time is invalid and time counter is read as zero.
	RTC_SR_TIF_1 = 0x1
	// Position of TOF field.
	RTC_SR_TOF_Pos = 0x1
	// Bit mask of TOF field.
	RTC_SR_TOF_Msk = 0x2
	// Bit TOF.
	RTC_SR_TOF = 0x2
	// Time overflow has not occurred.
	RTC_SR_TOF_0 = 0x0
	// Time overflow has occurred and time counter is read as zero.
	RTC_SR_TOF_1 = 0x1
	// Position of TAF field.
	RTC_SR_TAF_Pos = 0x2
	// Bit mask of TAF field.
	RTC_SR_TAF_Msk = 0x4
	// Bit TAF.
	RTC_SR_TAF = 0x4
	// Time alarm has not occurred.
	RTC_SR_TAF_0 = 0x0
	// Time alarm has occurred.
	RTC_SR_TAF_1 = 0x1
	// Position of TCE field.
	RTC_SR_TCE_Pos = 0x4
	// Bit mask of TCE field.
	RTC_SR_TCE_Msk = 0x10
	// Bit TCE.
	RTC_SR_TCE = 0x10
	// Time counter is disabled.
	RTC_SR_TCE_0 = 0x0
	// Time counter is enabled.
	RTC_SR_TCE_1 = 0x1

	// LR: RTC Lock Register
	// Position of TCL field.
	RTC_LR_TCL_Pos = 0x3
	// Bit mask of TCL field.
	RTC_LR_TCL_Msk = 0x8
	// Bit TCL.
	RTC_LR_TCL = 0x8
	// Time Compensation Register is locked and writes are ignored.
	RTC_LR_TCL_0 = 0x0
	// Time Compensation Register is not locked and writes complete as normal.
	RTC_LR_TCL_1 = 0x1
	// Position of CRL field.
	RTC_LR_CRL_Pos = 0x4
	// Bit mask of CRL field.
	RTC_LR_CRL_Msk = 0x10
	// Bit CRL.
	RTC_LR_CRL = 0x10
	// Control Register is locked and writes are ignored.
	RTC_LR_CRL_0 = 0x0
	// Control Register is not locked and writes complete as normal.
	RTC_LR_CRL_1 = 0x1
	// Position of SRL field.
	RTC_LR_SRL_Pos = 0x5
	// Bit mask of SRL field.
	RTC_LR_SRL_Msk = 0x20
	// Bit SRL.
	RTC_LR_SRL = 0x20
	// Status Register is locked and writes are ignored.
	RTC_LR_SRL_0 = 0x0
	// Status Register is not locked and writes complete as normal.
	RTC_LR_SRL_1 = 0x1
	// Position of LRL field.
	RTC_LR_LRL_Pos = 0x6
	// Bit mask of LRL field.
	RTC_LR_LRL_Msk = 0x40
	// Bit LRL.
	RTC_LR_LRL = 0x40
	// Lock Register is locked and writes are ignored.
	RTC_LR_LRL_0 = 0x0
	// Lock Register is not locked and writes complete as normal.
	RTC_LR_LRL_1 = 0x1

	// IER: RTC Interrupt Enable Register
	// Position of TIIE field.
	RTC_IER_TIIE_Pos = 0x0
	// Bit mask of TIIE field.
	RTC_IER_TIIE_Msk = 0x1
	// Bit TIIE.
	RTC_IER_TIIE = 0x1
	// Time invalid flag does not generate an interrupt.
	RTC_IER_TIIE_0 = 0x0
	// Time invalid flag does generate an interrupt.
	RTC_IER_TIIE_1 = 0x1
	// Position of TOIE field.
	RTC_IER_TOIE_Pos = 0x1
	// Bit mask of TOIE field.
	RTC_IER_TOIE_Msk = 0x2
	// Bit TOIE.
	RTC_IER_TOIE = 0x2
	// Time overflow flag does not generate an interrupt.
	RTC_IER_TOIE_0 = 0x0
	// Time overflow flag does generate an interrupt.
	RTC_IER_TOIE_1 = 0x1
	// Position of TAIE field.
	RTC_IER_TAIE_Pos = 0x2
	// Bit mask of TAIE field.
	RTC_IER_TAIE_Msk = 0x4
	// Bit TAIE.
	RTC_IER_TAIE = 0x4
	// Time alarm flag does not generate an interrupt.
	RTC_IER_TAIE_0 = 0x0
	// Time alarm flag does generate an interrupt.
	RTC_IER_TAIE_1 = 0x1
	// Position of TSIE field.
	RTC_IER_TSIE_Pos = 0x4
	// Bit mask of TSIE field.
	RTC_IER_TSIE_Msk = 0x10
	// Bit TSIE.
	RTC_IER_TSIE = 0x10
	// Seconds interrupt is disabled.
	RTC_IER_TSIE_0 = 0x0
	// Seconds interrupt is enabled.
	RTC_IER_TSIE_1 = 0x1
	// Position of WPON field.
	RTC_IER_WPON_Pos = 0x7
	// Bit mask of WPON field.
	RTC_IER_WPON_Msk = 0x80
	// Bit WPON.
	RTC_IER_WPON = 0x80
	// No effect.
	RTC_IER_WPON_0 = 0x0
	// If the wakeup pin is enabled, then the wakeup pin will assert.
	RTC_IER_WPON_1 = 0x1
)

// Bitfields for DAC0: 12-Bit Digital-to-Analog Converter
const (
	// DAT0L: DAC Data Low Register
	// Position of DATA0 field.
	DAC0_DATL_DATA0_Pos = 0x0
	// Bit mask of DATA0 field.
	DAC0_DATL_DATA0_Msk = 0xff

	// DAT0H: DAC Data High Register
	// Position of DATA1 field.
	DAC0_DATH_DATA1_Pos = 0x0
	// Bit mask of DATA1 field.
	DAC0_DATH_DATA1_Msk = 0xf

	// SR: DAC Status Register
	// Position of DACBFRPBF field.
	DAC0_SR_DACBFRPBF_Pos = 0x0
	// Bit mask of DACBFRPBF field.
	DAC0_SR_DACBFRPBF_Msk = 0x1
	// Bit DACBFRPBF.
	DAC0_SR_DACBFRPBF = 0x1
	// The DAC buffer read pointer is not equal to C2[DACBFUP].
	DAC0_SR_DACBFRPBF_0 = 0x0
	// The DAC buffer read pointer is equal to C2[DACBFUP].
	DAC0_SR_DACBFRPBF_1 = 0x1
	// Position of DACBFRPTF field.
	DAC0_SR_DACBFRPTF_Pos = 0x1
	// Bit mask of DACBFRPTF field.
	DAC0_SR_DACBFRPTF_Msk = 0x2
	// Bit DACBFRPTF.
	DAC0_SR_DACBFRPTF = 0x2
	// The DAC buffer read pointer is not zero.
	DAC0_SR_DACBFRPTF_0 = 0x0
	// The DAC buffer read pointer is zero.
	DAC0_SR_DACBFRPTF_1 = 0x1
	// Position of DACBFWMF field.
	DAC0_SR_DACBFWMF_Pos = 0x2
	// Bit mask of DACBFWMF field.
	DAC0_SR_DACBFWMF_Msk = 0x4
	// Bit DACBFWMF.
	DAC0_SR_DACBFWMF = 0x4
	// The DAC buffer read pointer has not reached the watermark level.
	DAC0_SR_DACBFWMF_0 = 0x0
	// The DAC buffer read pointer has reached the watermark level.
	DAC0_SR_DACBFWMF_1 = 0x1

	// C0: DAC Control Register
	// Position of DACBBIEN field.
	DAC0_C0_DACBBIEN_Pos = 0x0
	// Bit mask of DACBBIEN field.
	DAC0_C0_DACBBIEN_Msk = 0x1
	// Bit DACBBIEN.
	DAC0_C0_DACBBIEN = 0x1
	// The DAC buffer read pointer bottom flag interrupt is disabled.
	DAC0_C0_DACBBIEN_0 = 0x0
	// The DAC buffer read pointer bottom flag interrupt is enabled.
	DAC0_C0_DACBBIEN_1 = 0x1
	// Position of DACBTIEN field.
	DAC0_C0_DACBTIEN_Pos = 0x1
	// Bit mask of DACBTIEN field.
	DAC0_C0_DACBTIEN_Msk = 0x2
	// Bit DACBTIEN.
	DAC0_C0_DACBTIEN = 0x2
	// The DAC buffer read pointer top flag interrupt is disabled.
	DAC0_C0_DACBTIEN_0 = 0x0
	// The DAC buffer read pointer top flag interrupt is enabled.
	DAC0_C0_DACBTIEN_1 = 0x1
	// Position of DACBWIEN field.
	DAC0_C0_DACBWIEN_Pos = 0x2
	// Bit mask of DACBWIEN field.
	DAC0_C0_DACBWIEN_Msk = 0x4
	// Bit DACBWIEN.
	DAC0_C0_DACBWIEN = 0x4
	// The DAC buffer watermark interrupt is disabled.
	DAC0_C0_DACBWIEN_0 = 0x0
	// The DAC buffer watermark interrupt is enabled.
	DAC0_C0_DACBWIEN_1 = 0x1
	// Position of LPEN field.
	DAC0_C0_LPEN_Pos = 0x3
	// Bit mask of LPEN field.
	DAC0_C0_LPEN_Msk = 0x8
	// Bit LPEN.
	DAC0_C0_LPEN = 0x8
	// High-Power mode
	DAC0_C0_LPEN_0 = 0x0
	// Low-Power mode
	DAC0_C0_LPEN_1 = 0x1
	// Position of DACSWTRG field.
	DAC0_C0_DACSWTRG_Pos = 0x4
	// Bit mask of DACSWTRG field.
	DAC0_C0_DACSWTRG_Msk = 0x10
	// Bit DACSWTRG.
	DAC0_C0_DACSWTRG = 0x10
	// The DAC soft trigger is not valid.
	DAC0_C0_DACSWTRG_0 = 0x0
	// The DAC soft trigger is valid.
	DAC0_C0_DACSWTRG_1 = 0x1
	// Position of DACTRGSEL field.
	DAC0_C0_DACTRGSEL_Pos = 0x5
	// Bit mask of DACTRGSEL field.
	DAC0_C0_DACTRGSEL_Msk = 0x20
	// Bit DACTRGSEL.
	DAC0_C0_DACTRGSEL = 0x20
	// The DAC hardware trigger is selected.
	DAC0_C0_DACTRGSEL_0 = 0x0
	// The DAC software trigger is selected.
	DAC0_C0_DACTRGSEL_1 = 0x1
	// Position of DACRFS field.
	DAC0_C0_DACRFS_Pos = 0x6
	// Bit mask of DACRFS field.
	DAC0_C0_DACRFS_Msk = 0x40
	// Bit DACRFS.
	DAC0_C0_DACRFS = 0x40
	// The DAC selects DACREF_1 as the reference voltage.
	DAC0_C0_DACRFS_0 = 0x0
	// The DAC selects DACREF_2 as the reference voltage.
	DAC0_C0_DACRFS_1 = 0x1
	// Position of DACEN field.
	DAC0_C0_DACEN_Pos = 0x7
	// Bit mask of DACEN field.
	DAC0_C0_DACEN_Msk = 0x80
	// Bit DACEN.
	DAC0_C0_DACEN = 0x80
	// The DAC system is disabled.
	DAC0_C0_DACEN_0 = 0x0
	// The DAC system is enabled.
	DAC0_C0_DACEN_1 = 0x1

	// C1: DAC Control Register 1
	// Position of DACBFEN field.
	DAC0_C1_DACBFEN_Pos = 0x0
	// Bit mask of DACBFEN field.
	DAC0_C1_DACBFEN_Msk = 0x1
	// Bit DACBFEN.
	DAC0_C1_DACBFEN = 0x1
	// Buffer read pointer is disabled. The converted data is always the first word of the buffer.
	DAC0_C1_DACBFEN_0 = 0x0
	// Buffer read pointer is enabled. The converted data is the word that the read pointer points to. It means converted data can be from any word of the buffer.
	DAC0_C1_DACBFEN_1 = 0x1
	// Position of DACBFMD field.
	DAC0_C1_DACBFMD_Pos = 0x2
	// Bit mask of DACBFMD field.
	DAC0_C1_DACBFMD_Msk = 0x4
	// Bit DACBFMD.
	DAC0_C1_DACBFMD = 0x4
	// Normal mode
	DAC0_C1_DACBFMD_0 = 0x0
	// One-Time Scan mode
	DAC0_C1_DACBFMD_1 = 0x1
	// Position of DACBFWM field.
	DAC0_C1_DACBFWM_Pos = 0x3
	// Bit mask of DACBFWM field.
	DAC0_C1_DACBFWM_Msk = 0x18
	// 1 word
	DAC0_C1_DACBFWM_00 = 0x0
	// 2 words
	DAC0_C1_DACBFWM_01 = 0x1
	// Position of DMAEN field.
	DAC0_C1_DMAEN_Pos = 0x7
	// Bit mask of DMAEN field.
	DAC0_C1_DMAEN_Msk = 0x80
	// Bit DMAEN.
	DAC0_C1_DMAEN = 0x80
	// DMA is disabled.
	DAC0_C1_DMAEN_0 = 0x0
	// DMA is enabled. When DMA is enabled, the DMA request will be generated by original interrupts. The interrupts will not be presented on this module at the same time.
	DAC0_C1_DMAEN_1 = 0x1

	// C2: DAC Control Register 2
	// Position of DACBFUP field.
	DAC0_C2_DACBFUP_Pos = 0x0
	// Bit mask of DACBFUP field.
	DAC0_C2_DACBFUP_Msk = 0x1
	// Bit DACBFUP.
	DAC0_C2_DACBFUP = 0x1
	// Position of DACBFRP field.
	DAC0_C2_DACBFRP_Pos = 0x4
	// Bit mask of DACBFRP field.
	DAC0_C2_DACBFRP_Msk = 0x10
	// Bit DACBFRP.
	DAC0_C2_DACBFRP = 0x10
)

// Bitfields for LPTMR0: Low Power Timer
const (
	// CSR: Low Power Timer Control Status Register
	// Position of TEN field.
	LPTMR0_CSR_TEN_Pos = 0x0
	// Bit mask of TEN field.
	LPTMR0_CSR_TEN_Msk = 0x1
	// Bit TEN.
	LPTMR0_CSR_TEN = 0x1
	// LPTMR is disabled and internal logic is reset.
	LPTMR0_CSR_TEN_0 = 0x0
	// LPTMR is enabled.
	LPTMR0_CSR_TEN_1 = 0x1
	// Position of TMS field.
	LPTMR0_CSR_TMS_Pos = 0x1
	// Bit mask of TMS field.
	LPTMR0_CSR_TMS_Msk = 0x2
	// Bit TMS.
	LPTMR0_CSR_TMS = 0x2
	// Time Counter mode.
	LPTMR0_CSR_TMS_0 = 0x0
	// Pulse Counter mode.
	LPTMR0_CSR_TMS_1 = 0x1
	// Position of TFC field.
	LPTMR0_CSR_TFC_Pos = 0x2
	// Bit mask of TFC field.
	LPTMR0_CSR_TFC_Msk = 0x4
	// Bit TFC.
	LPTMR0_CSR_TFC = 0x4
	// CNR is reset whenever TCF is set.
	LPTMR0_CSR_TFC_0 = 0x0
	// CNR is reset on overflow.
	LPTMR0_CSR_TFC_1 = 0x1
	// Position of TPP field.
	LPTMR0_CSR_TPP_Pos = 0x3
	// Bit mask of TPP field.
	LPTMR0_CSR_TPP_Msk = 0x8
	// Bit TPP.
	LPTMR0_CSR_TPP = 0x8
	// Pulse Counter input source is active-high, and the CNR will increment on the rising-edge.
	LPTMR0_CSR_TPP_0 = 0x0
	// Pulse Counter input source is active-low, and the CNR will increment on the falling-edge.
	LPTMR0_CSR_TPP_1 = 0x1
	// Position of TPS field.
	LPTMR0_CSR_TPS_Pos = 0x4
	// Bit mask of TPS field.
	LPTMR0_CSR_TPS_Msk = 0x30
	// Pulse counter input 0 is selected.
	LPTMR0_CSR_TPS_00 = 0x0
	// Pulse counter input 1 is selected.
	LPTMR0_CSR_TPS_01 = 0x1
	// Pulse counter input 2 is selected.
	LPTMR0_CSR_TPS_10 = 0x2
	// Pulse counter input 3 is selected.
	LPTMR0_CSR_TPS_11 = 0x3
	// Position of TIE field.
	LPTMR0_CSR_TIE_Pos = 0x6
	// Bit mask of TIE field.
	LPTMR0_CSR_TIE_Msk = 0x40
	// Bit TIE.
	LPTMR0_CSR_TIE = 0x40
	// Timer interrupt disabled.
	LPTMR0_CSR_TIE_0 = 0x0
	// Timer interrupt enabled.
	LPTMR0_CSR_TIE_1 = 0x1
	// Position of TCF field.
	LPTMR0_CSR_TCF_Pos = 0x7
	// Bit mask of TCF field.
	LPTMR0_CSR_TCF_Msk = 0x80
	// Bit TCF.
	LPTMR0_CSR_TCF = 0x80
	// The value of CNR is not equal to CMR and increments.
	LPTMR0_CSR_TCF_0 = 0x0
	// The value of CNR is equal to CMR and increments.
	LPTMR0_CSR_TCF_1 = 0x1

	// PSR: Low Power Timer Prescale Register
	// Position of PCS field.
	LPTMR0_PSR_PCS_Pos = 0x0
	// Bit mask of PCS field.
	LPTMR0_PSR_PCS_Msk = 0x3
	// Prescaler/glitch filter clock 0 selected.
	LPTMR0_PSR_PCS_00 = 0x0
	// Prescaler/glitch filter clock 1 selected.
	LPTMR0_PSR_PCS_01 = 0x1
	// Prescaler/glitch filter clock 2 selected.
	LPTMR0_PSR_PCS_10 = 0x2
	// Prescaler/glitch filter clock 3 selected.
	LPTMR0_PSR_PCS_11 = 0x3
	// Position of PBYP field.
	LPTMR0_PSR_PBYP_Pos = 0x2
	// Bit mask of PBYP field.
	LPTMR0_PSR_PBYP_Msk = 0x4
	// Bit PBYP.
	LPTMR0_PSR_PBYP = 0x4
	// Prescaler/glitch filter is enabled.
	LPTMR0_PSR_PBYP_0 = 0x0
	// Prescaler/glitch filter is bypassed.
	LPTMR0_PSR_PBYP_1 = 0x1
	// Position of PRESCALE field.
	LPTMR0_PSR_PRESCALE_Pos = 0x3
	// Bit mask of PRESCALE field.
	LPTMR0_PSR_PRESCALE_Msk = 0x78
	// Prescaler divides the prescaler clock by 2; glitch filter does not support this configuration.
	LPTMR0_PSR_PRESCALE_0000 = 0x0
	// Prescaler divides the prescaler clock by 4; glitch filter recognizes change on input pin after 2 rising clock edges.
	LPTMR0_PSR_PRESCALE_0001 = 0x1
	// Prescaler divides the prescaler clock by 8; glitch filter recognizes change on input pin after 4 rising clock edges.
	LPTMR0_PSR_PRESCALE_0010 = 0x2
	// Prescaler divides the prescaler clock by 16; glitch filter recognizes change on input pin after 8 rising clock edges.
	LPTMR0_PSR_PRESCALE_0011 = 0x3
	// Prescaler divides the prescaler clock by 32; glitch filter recognizes change on input pin after 16 rising clock edges.
	LPTMR0_PSR_PRESCALE_0100 = 0x4
	// Prescaler divides the prescaler clock by 64; glitch filter recognizes change on input pin after 32 rising clock edges.
	LPTMR0_PSR_PRESCALE_0101 = 0x5
	// Prescaler divides the prescaler clock by 128; glitch filter recognizes change on input pin after 64 rising clock edges.
	LPTMR0_PSR_PRESCALE_0110 = 0x6
	// Prescaler divides the prescaler clock by 256; glitch filter recognizes change on input pin after 128 rising clock edges.
	LPTMR0_PSR_PRESCALE_0111 = 0x7
	// Prescaler divides the prescaler clock by 512; glitch filter recognizes change on input pin after 256 rising clock edges.
	LPTMR0_PSR_PRESCALE_1000 = 0x8
	// Prescaler divides the prescaler clock by 1024; glitch filter recognizes change on input pin after 512 rising clock edges.
	LPTMR0_PSR_PRESCALE_1001 = 0x9
	// Prescaler divides the prescaler clock by 2048; glitch filter recognizes change on input pin after 1024 rising clock edges.
	LPTMR0_PSR_PRESCALE_1010 = 0xa
	// Prescaler divides the prescaler clock by 4096; glitch filter recognizes change on input pin after 2048 rising clock edges.
	LPTMR0_PSR_PRESCALE_1011 = 0xb
	// Prescaler divides the prescaler clock by 8192; glitch filter recognizes change on input pin after 4096 rising clock edges.
	LPTMR0_PSR_PRESCALE_1100 = 0xc
	// Prescaler divides the prescaler clock by 16,384; glitch filter recognizes change on input pin after 8192 rising clock edges.
	LPTMR0_PSR_PRESCALE_1101 = 0xd
	// Prescaler divides the prescaler clock by 32,768; glitch filter recognizes change on input pin after 16,384 rising clock edges.
	LPTMR0_PSR_PRESCALE_1110 = 0xe
	// Prescaler divides the prescaler clock by 65,536; glitch filter recognizes change on input pin after 32,768 rising clock edges.
	LPTMR0_PSR_PRESCALE_1111 = 0xf

	// CMR: Low Power Timer Compare Register
	// Position of COMPARE field.
	LPTMR0_CMR_COMPARE_Pos = 0x0
	// Bit mask of COMPARE field.
	LPTMR0_CMR_COMPARE_Msk = 0xffff

	// CNR: Low Power Timer Counter Register
	// Position of COUNTER field.
	LPTMR0_CNR_COUNTER_Pos = 0x0
	// Bit mask of COUNTER field.
	LPTMR0_CNR_COUNTER_Msk = 0xffff
)

// Bitfields for RFSYS: System register file
const (
	// REG0: Register file register
	// Position of LL field.
	RFSYS_REG_LL_Pos = 0x0
	// Bit mask of LL field.
	RFSYS_REG_LL_Msk = 0xff
	// Position of LH field.
	RFSYS_REG_LH_Pos = 0x8
	// Bit mask of LH field.
	RFSYS_REG_LH_Msk = 0xff00
	// Position of HL field.
	RFSYS_REG_HL_Pos = 0x10
	// Bit mask of HL field.
	RFSYS_REG_HL_Msk = 0xff0000
	// Position of HH field.
	RFSYS_REG_HH_Pos = 0x18
	// Bit mask of HH field.
	RFSYS_REG_HH_Msk = 0xff000000
)

// Bitfields for TSI0: Touch sense input
const (
	// GENCS: TSI General Control and Status Register
	// Position of CURSW field.
	TSI0_GENCS_CURSW_Pos = 0x1
	// Bit mask of CURSW field.
	TSI0_GENCS_CURSW_Msk = 0x2
	// Bit CURSW.
	TSI0_GENCS_CURSW = 0x2
	// The current source pair are not swapped.
	TSI0_GENCS_CURSW_0 = 0x0
	// The current source pair are swapped.
	TSI0_GENCS_CURSW_1 = 0x1
	// Position of EOSF field.
	TSI0_GENCS_EOSF_Pos = 0x2
	// Bit mask of EOSF field.
	TSI0_GENCS_EOSF_Msk = 0x4
	// Bit EOSF.
	TSI0_GENCS_EOSF = 0x4
	// Scan not complete.
	TSI0_GENCS_EOSF_0 = 0x0
	// Scan complete.
	TSI0_GENCS_EOSF_1 = 0x1
	// Position of SCNIP field.
	TSI0_GENCS_SCNIP_Pos = 0x3
	// Bit mask of SCNIP field.
	TSI0_GENCS_SCNIP_Msk = 0x8
	// Bit SCNIP.
	TSI0_GENCS_SCNIP = 0x8
	// No scan in progress.
	TSI0_GENCS_SCNIP_0 = 0x0
	// Scan in progress.
	TSI0_GENCS_SCNIP_1 = 0x1
	// Position of STM field.
	TSI0_GENCS_STM_Pos = 0x4
	// Bit mask of STM field.
	TSI0_GENCS_STM_Msk = 0x10
	// Bit STM.
	TSI0_GENCS_STM = 0x10
	// Software trigger scan.
	TSI0_GENCS_STM_0 = 0x0
	// Hardware trigger scan.
	TSI0_GENCS_STM_1 = 0x1
	// Position of STPE field.
	TSI0_GENCS_STPE_Pos = 0x5
	// Bit mask of STPE field.
	TSI0_GENCS_STPE_Msk = 0x20
	// Bit STPE.
	TSI0_GENCS_STPE = 0x20
	// TSI is disabled when MCU goes into low power mode.
	TSI0_GENCS_STPE_0 = 0x0
	// Allows TSI to continue running in all low power modes.
	TSI0_GENCS_STPE_1 = 0x1
	// Position of TSIIEN field.
	TSI0_GENCS_TSIIEN_Pos = 0x6
	// Bit mask of TSIIEN field.
	TSI0_GENCS_TSIIEN_Msk = 0x40
	// Bit TSIIEN.
	TSI0_GENCS_TSIIEN = 0x40
	// TSI interrupt is disabled.
	TSI0_GENCS_TSIIEN_0 = 0x0
	// TSI interrupt is enabled.
	TSI0_GENCS_TSIIEN_1 = 0x1
	// Position of TSIEN field.
	TSI0_GENCS_TSIEN_Pos = 0x7
	// Bit mask of TSIEN field.
	TSI0_GENCS_TSIEN_Msk = 0x80
	// Bit TSIEN.
	TSI0_GENCS_TSIEN = 0x80
	// TSI module disabled.
	TSI0_GENCS_TSIEN_0 = 0x0
	// TSI module enabled.
	TSI0_GENCS_TSIEN_1 = 0x1
	// Position of NSCN field.
	TSI0_GENCS_NSCN_Pos = 0x8
	// Bit mask of NSCN field.
	TSI0_GENCS_NSCN_Msk = 0x1f00
	// Once per electrode
	TSI0_GENCS_NSCN_00000 = 0x0
	// Twice per electrode
	TSI0_GENCS_NSCN_00001 = 0x1
	// 3 times per electrode
	TSI0_GENCS_NSCN_00010 = 0x2
	// 4 times per electrode
	TSI0_GENCS_NSCN_00011 = 0x3
	// 5 times per electrode
	TSI0_GENCS_NSCN_00100 = 0x4
	// 6 times per electrode
	TSI0_GENCS_NSCN_00101 = 0x5
	// 7 times per electrode
	TSI0_GENCS_NSCN_00110 = 0x6
	// 8 times per electrode
	TSI0_GENCS_NSCN_00111 = 0x7
	// 9 times per electrode
	TSI0_GENCS_NSCN_01000 = 0x8
	// 10 times per electrode
	TSI0_GENCS_NSCN_01001 = 0x9
	// 11 times per electrode
	TSI0_GENCS_NSCN_01010 = 0xa
	// 12 times per electrode
	TSI0_GENCS_NSCN_01011 = 0xb
	// 13 times per electrode
	TSI0_GENCS_NSCN_01100 = 0xc
	// 14 times per electrode
	TSI0_GENCS_NSCN_01101 = 0xd
	// 15 times per electrode
	TSI0_GENCS_NSCN_01110 = 0xe
	// 16 times per electrode
	TSI0_GENCS_NSCN_01111 = 0xf
	// 17 times per electrode
	TSI0_GENCS_NSCN_10000 = 0x10
	// 18 times per electrode
	TSI0_GENCS_NSCN_10001 = 0x11
	// 19 times per electrode
	TSI0_GENCS_NSCN_10010 = 0x12
	// 20 times per electrode
	TSI0_GENCS_NSCN_10011 = 0x13
	// 21 times per electrode
	TSI0_GENCS_NSCN_10100 = 0x14
	// 22 times per electrode
	TSI0_GENCS_NSCN_10101 = 0x15
	// 23 times per electrode
	TSI0_GENCS_NSCN_10110 = 0x16
	// 24 times per electrode
	TSI0_GENCS_NSCN_10111 = 0x17
	// 25 times per electrode
	TSI0_GENCS_NSCN_11000 = 0x18
	// 26 times per electrode
	TSI0_GENCS_NSCN_11001 = 0x19
	// 27 times per electrode
	TSI0_GENCS_NSCN_11010 = 0x1a
	// 28 times per electrode
	TSI0_GENCS_NSCN_11011 = 0x1b
	// 29 times per electrode
	TSI0_GENCS_NSCN_11100 = 0x1c
	// 30 times per electrode
	TSI0_GENCS_NSCN_11101 = 0x1d
	// 31 times per electrode
	TSI0_GENCS_NSCN_11110 = 0x1e
	// 32 times per electrode
	TSI0_GENCS_NSCN_11111 = 0x1f
	// Position of PS field.
	TSI0_GENCS_PS_Pos = 0xd
	// Bit mask of PS field.
	TSI0_GENCS_PS_Msk = 0xe000
	// Electrode Oscillator Frequency divided by 1
	TSI0_GENCS_PS_000 = 0x0
	// Electrode Oscillator Frequency divided by 2
	TSI0_GENCS_PS_001 = 0x1
	// Electrode Oscillator Frequency divided by 4
	TSI0_GENCS_PS_010 = 0x2
	// Electrode Oscillator Frequency divided by 8
	TSI0_GENCS_PS_011 = 0x3
	// Electrode Oscillator Frequency divided by 16
	TSI0_GENCS_PS_100 = 0x4
	// Electrode Oscillator Frequency divided by 32
	TSI0_GENCS_PS_101 = 0x5
	// Electrode Oscillator Frequency divided by 64
	TSI0_GENCS_PS_110 = 0x6
	// Electrode Oscillator Frequency divided by 128
	TSI0_GENCS_PS_111 = 0x7
	// Position of EXTCHRG field.
	TSI0_GENCS_EXTCHRG_Pos = 0x10
	// Bit mask of EXTCHRG field.
	TSI0_GENCS_EXTCHRG_Msk = 0x70000
	// 500 nA.
	TSI0_GENCS_EXTCHRG_000 = 0x0
	// 1 uA.
	TSI0_GENCS_EXTCHRG_001 = 0x1
	// 2 uA.
	TSI0_GENCS_EXTCHRG_010 = 0x2
	// 4 uA.
	TSI0_GENCS_EXTCHRG_011 = 0x3
	// 8 uA.
	TSI0_GENCS_EXTCHRG_100 = 0x4
	// 16 uA.
	TSI0_GENCS_EXTCHRG_101 = 0x5
	// 32 uA.
	TSI0_GENCS_EXTCHRG_110 = 0x6
	// 64 uA.
	TSI0_GENCS_EXTCHRG_111 = 0x7
	// Position of DVOLT field.
	TSI0_GENCS_DVOLT_Pos = 0x13
	// Bit mask of DVOLT field.
	TSI0_GENCS_DVOLT_Msk = 0x180000
	// DV = 1.026 V; VP = 1.328 V; Vm = 0.302 V.
	TSI0_GENCS_DVOLT_00 = 0x0
	// DV = 0.592 V; VP = 1.111 V; Vm = 0.519 V.
	TSI0_GENCS_DVOLT_01 = 0x1
	// DV = 0.342 V; VP = 0.986 V; Vm = 0.644 V.
	TSI0_GENCS_DVOLT_10 = 0x2
	// DV = 0.197 V; VP = 0.914 V; Vm = 0.716 V.
	TSI0_GENCS_DVOLT_11 = 0x3
	// Position of REFCHRG field.
	TSI0_GENCS_REFCHRG_Pos = 0x15
	// Bit mask of REFCHRG field.
	TSI0_GENCS_REFCHRG_Msk = 0xe00000
	// 500 nA.
	TSI0_GENCS_REFCHRG_000 = 0x0
	// 1 uA.
	TSI0_GENCS_REFCHRG_001 = 0x1
	// 2 uA.
	TSI0_GENCS_REFCHRG_010 = 0x2
	// 4 uA.
	TSI0_GENCS_REFCHRG_011 = 0x3
	// 8 uA.
	TSI0_GENCS_REFCHRG_100 = 0x4
	// 16 uA.
	TSI0_GENCS_REFCHRG_101 = 0x5
	// 32 uA.
	TSI0_GENCS_REFCHRG_110 = 0x6
	// 64 uA.
	TSI0_GENCS_REFCHRG_111 = 0x7
	// Position of MODE field.
	TSI0_GENCS_MODE_Pos = 0x18
	// Bit mask of MODE field.
	TSI0_GENCS_MODE_Msk = 0xf000000
	// Set TSI in capacitive sensing(non-noise detection) mode.
	TSI0_GENCS_MODE_0000 = 0x0
	// Set TSI analog to work in single threshold noise detection mode and the frequency limitation circuit is disabled.
	TSI0_GENCS_MODE_0100 = 0x4
	// Set TSI analog to work in single threshold noise detection mode and the frequency limitation circuit is enabled to work in higher frequencies operations.
	TSI0_GENCS_MODE_1000 = 0x8
	// Set TSI analog to work in automatic noise detection mode.
	TSI0_GENCS_MODE_1100 = 0xc
	// Position of ESOR field.
	TSI0_GENCS_ESOR_Pos = 0x1c
	// Bit mask of ESOR field.
	TSI0_GENCS_ESOR_Msk = 0x10000000
	// Bit ESOR.
	TSI0_GENCS_ESOR = 0x10000000
	// Out-of-range interrupt is allowed.
	TSI0_GENCS_ESOR_0 = 0x0
	// End-of-scan interrupt is allowed.
	TSI0_GENCS_ESOR_1 = 0x1
	// Position of OUTRGF field.
	TSI0_GENCS_OUTRGF_Pos = 0x1f
	// Bit mask of OUTRGF field.
	TSI0_GENCS_OUTRGF_Msk = 0x80000000
	// Bit OUTRGF.
	TSI0_GENCS_OUTRGF = 0x80000000

	// DATA: TSI DATA Register
	// Position of TSICNT field.
	TSI0_DATA_TSICNT_Pos = 0x0
	// Bit mask of TSICNT field.
	TSI0_DATA_TSICNT_Msk = 0xffff
	// Position of SWTS field.
	TSI0_DATA_SWTS_Pos = 0x16
	// Bit mask of SWTS field.
	TSI0_DATA_SWTS_Msk = 0x400000
	// Bit SWTS.
	TSI0_DATA_SWTS = 0x400000
	// No effect.
	TSI0_DATA_SWTS_0 = 0x0
	// Start a scan to determine which channel is specified by TSI_DATA[TSICH].
	TSI0_DATA_SWTS_1 = 0x1
	// Position of DMAEN field.
	TSI0_DATA_DMAEN_Pos = 0x17
	// Bit mask of DMAEN field.
	TSI0_DATA_DMAEN_Msk = 0x800000
	// Bit DMAEN.
	TSI0_DATA_DMAEN = 0x800000
	// Interrupt is selected when the interrupt enable bit is set and the corresponding TSI events assert.
	TSI0_DATA_DMAEN_0 = 0x0
	// DMA transfer request is selected when the interrupt enable bit is set and the corresponding TSI events assert.
	TSI0_DATA_DMAEN_1 = 0x1
	// Position of TSICH field.
	TSI0_DATA_TSICH_Pos = 0x1c
	// Bit mask of TSICH field.
	TSI0_DATA_TSICH_Msk = 0xf0000000
	// Channel 0.
	TSI0_DATA_TSICH_0000 = 0x0
	// Channel 1.
	TSI0_DATA_TSICH_0001 = 0x1
	// Channel 2.
	TSI0_DATA_TSICH_0010 = 0x2
	// Channel 3.
	TSI0_DATA_TSICH_0011 = 0x3
	// Channel 4.
	TSI0_DATA_TSICH_0100 = 0x4
	// Channel 5.
	TSI0_DATA_TSICH_0101 = 0x5
	// Channel 6.
	TSI0_DATA_TSICH_0110 = 0x6
	// Channel 7.
	TSI0_DATA_TSICH_0111 = 0x7
	// Channel 8.
	TSI0_DATA_TSICH_1000 = 0x8
	// Channel 9.
	TSI0_DATA_TSICH_1001 = 0x9
	// Channel 10.
	TSI0_DATA_TSICH_1010 = 0xa
	// Channel 11.
	TSI0_DATA_TSICH_1011 = 0xb
	// Channel 12.
	TSI0_DATA_TSICH_1100 = 0xc
	// Channel 13.
	TSI0_DATA_TSICH_1101 = 0xd
	// Channel 14.
	TSI0_DATA_TSICH_1110 = 0xe
	// Channel 15.
	TSI0_DATA_TSICH_1111 = 0xf

	// TSHD: TSI Threshold Register
	// Position of THRESL field.
	TSI0_TSHD_THRESL_Pos = 0x0
	// Bit mask of THRESL field.
	TSI0_TSHD_THRESL_Msk = 0xffff
	// Position of THRESH field.
	TSI0_TSHD_THRESH_Pos = 0x10
	// Bit mask of THRESH field.
	TSI0_TSHD_THRESH_Msk = 0xffff0000
)

// Bitfields for SIM: System Integration Module
const (
	// SOPT1: System Options Register 1
	// Position of OSC32KOUT field.
	SIM_SOPT1_OSC32KOUT_Pos = 0x10
	// Bit mask of OSC32KOUT field.
	SIM_SOPT1_OSC32KOUT_Msk = 0x30000
	// ERCLK32K is not output.
	SIM_SOPT1_OSC32KOUT_00 = 0x0
	// ERCLK32K is output on PTB3.
	SIM_SOPT1_OSC32KOUT_01 = 0x1
	// Position of OSC32KSEL field.
	SIM_SOPT1_OSC32KSEL_Pos = 0x12
	// Bit mask of OSC32KSEL field.
	SIM_SOPT1_OSC32KSEL_Msk = 0xc0000
	// 32kHz oscillator (OSC32KCLK)
	SIM_SOPT1_OSC32KSEL_00 = 0x0
	// RTC_CLKIN
	SIM_SOPT1_OSC32KSEL_10 = 0x2
	// LPO 1kHz
	SIM_SOPT1_OSC32KSEL_11 = 0x3

	// SOPT2: System Options Register 2
	// Position of CLKOUTSEL field.
	SIM_SOPT2_CLKOUTSEL_Pos = 0x5
	// Bit mask of CLKOUTSEL field.
	SIM_SOPT2_CLKOUTSEL_Msk = 0xe0
	// OSCERCLK DIV2
	SIM_SOPT2_CLKOUTSEL_000 = 0x0
	// OSCERCLK DIV4
	SIM_SOPT2_CLKOUTSEL_001 = 0x1
	// Bus clock
	SIM_SOPT2_CLKOUTSEL_010 = 0x2
	// LPO clock 1 kHz
	SIM_SOPT2_CLKOUTSEL_011 = 0x3
	// MCGIRCLK
	SIM_SOPT2_CLKOUTSEL_100 = 0x4
	// OSCERCLK DIV8
	SIM_SOPT2_CLKOUTSEL_101 = 0x5
	// OSCERCLK
	SIM_SOPT2_CLKOUTSEL_110 = 0x6
	// Position of TPMSRC field.
	SIM_SOPT2_TPMSRC_Pos = 0x18
	// Bit mask of TPMSRC field.
	SIM_SOPT2_TPMSRC_Msk = 0x3000000
	// Clock disabled
	SIM_SOPT2_TPMSRC_00 = 0x0
	// MCGFLLCLK clock
	SIM_SOPT2_TPMSRC_01 = 0x1
	// OSCERCLK clock
	SIM_SOPT2_TPMSRC_10 = 0x2
	// MCGIRCLK clock
	SIM_SOPT2_TPMSRC_11 = 0x3
	// Position of LPUART0SRC field.
	SIM_SOPT2_LPUART0SRC_Pos = 0x1a
	// Bit mask of LPUART0SRC field.
	SIM_SOPT2_LPUART0SRC_Msk = 0xc000000
	// Clock disabled
	SIM_SOPT2_LPUART0SRC_00 = 0x0
	// MCGFLLCLK clock
	SIM_SOPT2_LPUART0SRC_01 = 0x1
	// OSCERCLK clock
	SIM_SOPT2_LPUART0SRC_10 = 0x2
	// MCGIRCLK clock
	SIM_SOPT2_LPUART0SRC_11 = 0x3

	// SOPT4: System Options Register 4
	// Position of TPM1CH0SRC field.
	SIM_SOPT4_TPM1CH0SRC_Pos = 0x12
	// Bit mask of TPM1CH0SRC field.
	SIM_SOPT4_TPM1CH0SRC_Msk = 0x40000
	// Bit TPM1CH0SRC.
	SIM_SOPT4_TPM1CH0SRC = 0x40000
	// TPM1_CH0 signal
	SIM_SOPT4_TPM1CH0SRC_0 = 0x0
	// CMP0 output
	SIM_SOPT4_TPM1CH0SRC_1 = 0x1
	// Position of TPM2CH0SRC field.
	SIM_SOPT4_TPM2CH0SRC_Pos = 0x14
	// Bit mask of TPM2CH0SRC field.
	SIM_SOPT4_TPM2CH0SRC_Msk = 0x100000
	// Bit TPM2CH0SRC.
	SIM_SOPT4_TPM2CH0SRC = 0x100000
	// TPM2_CH0 signal
	SIM_SOPT4_TPM2CH0SRC_0 = 0x0
	// CMP0 output
	SIM_SOPT4_TPM2CH0SRC_1 = 0x1
	// Position of TPM0CLKSEL field.
	SIM_SOPT4_TPM0CLKSEL_Pos = 0x18
	// Bit mask of TPM0CLKSEL field.
	SIM_SOPT4_TPM0CLKSEL_Msk = 0x1000000
	// Bit TPM0CLKSEL.
	SIM_SOPT4_TPM0CLKSEL = 0x1000000
	// TPM0 external clock driven by TPM_CLKIN0 pin.
	SIM_SOPT4_TPM0CLKSEL_0 = 0x0
	// TPM0 external clock driven by TPM_CLKIN1 pin.
	SIM_SOPT4_TPM0CLKSEL_1 = 0x1
	// Position of TPM1CLKSEL field.
	SIM_SOPT4_TPM1CLKSEL_Pos = 0x19
	// Bit mask of TPM1CLKSEL field.
	SIM_SOPT4_TPM1CLKSEL_Msk = 0x2000000
	// Bit TPM1CLKSEL.
	SIM_SOPT4_TPM1CLKSEL = 0x2000000
	// TPM1 external clock driven by TPM_CLKIN0 pin.
	SIM_SOPT4_TPM1CLKSEL_0 = 0x0
	// TPM1 external clock driven by TPM_CLKIN1 pin.
	SIM_SOPT4_TPM1CLKSEL_1 = 0x1
	// Position of TPM2CLKSEL field.
	SIM_SOPT4_TPM2CLKSEL_Pos = 0x1a
	// Bit mask of TPM2CLKSEL field.
	SIM_SOPT4_TPM2CLKSEL_Msk = 0x4000000
	// Bit TPM2CLKSEL.
	SIM_SOPT4_TPM2CLKSEL = 0x4000000
	// TPM2 external clock driven by TPM_CLKIN0 pin.
	SIM_SOPT4_TPM2CLKSEL_0 = 0x0
	// TPM2 external clock driven by TPM_CLKIN1 pin.
	SIM_SOPT4_TPM2CLKSEL_1 = 0x1

	// SOPT5: System Options Register 5
	// Position of LPUART0TXSRC field.
	SIM_SOPT5_LPUART0TXSRC_Pos = 0x0
	// Bit mask of LPUART0TXSRC field.
	SIM_SOPT5_LPUART0TXSRC_Msk = 0x3
	// LPUART0_TX pin
	SIM_SOPT5_LPUART0TXSRC_00 = 0x0
	// LPUART0_TX pin modulated with TPM1 channel 0 output
	SIM_SOPT5_LPUART0TXSRC_01 = 0x1
	// LPUART0_TX pin modulated with TPM2 channel 0 output
	SIM_SOPT5_LPUART0TXSRC_10 = 0x2
	// Position of LPUART0RXSRC field.
	SIM_SOPT5_LPUART0RXSRC_Pos = 0x2
	// Bit mask of LPUART0RXSRC field.
	SIM_SOPT5_LPUART0RXSRC_Msk = 0x4
	// Bit LPUART0RXSRC.
	SIM_SOPT5_LPUART0RXSRC = 0x4
	// LPUART_RX pin
	SIM_SOPT5_LPUART0RXSRC_0 = 0x0
	// CMP0 output
	SIM_SOPT5_LPUART0RXSRC_1 = 0x1
	// Position of LPUART0ODE field.
	SIM_SOPT5_LPUART0ODE_Pos = 0x10
	// Bit mask of LPUART0ODE field.
	SIM_SOPT5_LPUART0ODE_Msk = 0x10000
	// Bit LPUART0ODE.
	SIM_SOPT5_LPUART0ODE = 0x10000
	// Open drain is disabled on LPUART0.
	SIM_SOPT5_LPUART0ODE_0 = 0x0
	// Open drain is enabled on LPUART0.
	SIM_SOPT5_LPUART0ODE_1 = 0x1

	// SOPT7: System Options Register 7
	// Position of ADC0TRGSEL field.
	SIM_SOPT7_ADC0TRGSEL_Pos = 0x0
	// Bit mask of ADC0TRGSEL field.
	SIM_SOPT7_ADC0TRGSEL_Msk = 0xf
	// External trigger pin input (EXTRG_IN)
	SIM_SOPT7_ADC0TRGSEL_0000 = 0x0
	// CMP0 output
	SIM_SOPT7_ADC0TRGSEL_0001 = 0x1
	// PIT trigger 0
	SIM_SOPT7_ADC0TRGSEL_0100 = 0x4
	// PIT trigger 1
	SIM_SOPT7_ADC0TRGSEL_0101 = 0x5
	// TPM0 overflow
	SIM_SOPT7_ADC0TRGSEL_1000 = 0x8
	// TPM1 overflow
	SIM_SOPT7_ADC0TRGSEL_1001 = 0x9
	// TPM2 overflow
	SIM_SOPT7_ADC0TRGSEL_1010 = 0xa
	// RTC alarm
	SIM_SOPT7_ADC0TRGSEL_1100 = 0xc
	// RTC seconds
	SIM_SOPT7_ADC0TRGSEL_1101 = 0xd
	// LPTMR0 trigger
	SIM_SOPT7_ADC0TRGSEL_1110 = 0xe
	// Radio TSM
	SIM_SOPT7_ADC0TRGSEL_1111 = 0xf
	// Position of ADC0PRETRGSEL field.
	SIM_SOPT7_ADC0PRETRGSEL_Pos = 0x4
	// Bit mask of ADC0PRETRGSEL field.
	SIM_SOPT7_ADC0PRETRGSEL_Msk = 0x10
	// Bit ADC0PRETRGSEL.
	SIM_SOPT7_ADC0PRETRGSEL = 0x10
	// Pre-trigger ADHDWTSA is selected, thus ADC0 will use ADC0_SC1A configuration for the next ADC conversion and store the result in ADC0_RA register.
	SIM_SOPT7_ADC0PRETRGSEL_0 = 0x0
	// Pre-trigger ADHDWTSB is selected, thus ADC0 will use ADC0_SC1B configuration for the next ADC conversion and store the result in ADC0_RB register.
	SIM_SOPT7_ADC0PRETRGSEL_1 = 0x1
	// Position of ADC0ALTTRGEN field.
	SIM_SOPT7_ADC0ALTTRGEN_Pos = 0x7
	// Bit mask of ADC0ALTTRGEN field.
	SIM_SOPT7_ADC0ALTTRGEN_Msk = 0x80
	// Bit ADC0ALTTRGEN.
	SIM_SOPT7_ADC0ALTTRGEN = 0x80
	// ADC ADHWT trigger comes from TPM1 channel 0 and channel1. Prior to the assertion of TPM1 channel 0, a pre-trigger pulse will be sent to ADHWTSA to initiate an ADC acquisition using ADCx_SC1A configuration and store ADC conversion in ADCx_RA Register. Prior to the assertion of TPM1 channel 1 a pre-trigger pulse will be sent to ADHWTSB to initiate an ADC acquisition using ADCx_SC1Bconfiguration and store ADC conversion in ADCx_RB Register.
	SIM_SOPT7_ADC0ALTTRGEN_0 = 0x0
	// ADC ADHWT trigger comes from a peripheral event selected by ADC0TRGSEL bits.ADC0PRETRGSEL bit will select the optional ADHWTSA or ADHWTSB select lines for choosing the ADCx_SC1x config and ADCx_Rx result regsiter to store the ADC conversion.
	SIM_SOPT7_ADC0ALTTRGEN_1 = 0x1

	// SDID: System Device Identification Register
	// Position of PINID field.
	SIM_SDID_PINID_Pos = 0x0
	// Bit mask of PINID field.
	SIM_SDID_PINID_Msk = 0xf
	// 48-pin
	SIM_SDID_PINID_0100 = 0x4
	// Position of DIEID field.
	SIM_SDID_DIEID_Pos = 0x7
	// Bit mask of DIEID field.
	SIM_SDID_DIEID_Msk = 0xf80
	// Position of REVID field.
	SIM_SDID_REVID_Pos = 0xc
	// Bit mask of REVID field.
	SIM_SDID_REVID_Msk = 0xf000
	// Position of SRAMSIZE field.
	SIM_SDID_SRAMSIZE_Pos = 0x10
	// Bit mask of SRAMSIZE field.
	SIM_SDID_SRAMSIZE_Msk = 0xf0000
	// 128 KB
	SIM_SDID_SRAMSIZE_1001 = 0x9
	// 64 KB
	SIM_SDID_SRAMSIZE_0111 = 0x7
	// Position of SERIESID field.
	SIM_SDID_SERIESID_Pos = 0x14
	// Bit mask of SERIESID field.
	SIM_SDID_SERIESID_Msk = 0xf00000
	// KW family
	SIM_SDID_SERIESID_0101 = 0x5
	// Position of SUBFAMID field.
	SIM_SDID_SUBFAMID_Pos = 0x18
	// Bit mask of SUBFAMID field.
	SIM_SDID_SUBFAMID_Msk = 0x3000000
	// KWx0 Subfamily
	SIM_SDID_SUBFAMID_00 = 0x0
	// KWx1 Subfamily
	SIM_SDID_SUBFAMID_01 = 0x1
	// KWx2 Subfamily
	SIM_SDID_SUBFAMID_10 = 0x2
	// KWx3 Subfamily
	SIM_SDID_SUBFAMID_11 = 0x3
	// Position of FAMID field.
	SIM_SDID_FAMID_Pos = 0x1c
	// Bit mask of FAMID field.
	SIM_SDID_FAMID_Msk = 0xf0000000
	// KW2x Family (802.15.4)
	SIM_SDID_FAMID_0010 = 0x2
	// KW3x Family (BTLE)
	SIM_SDID_FAMID_0011 = 0x3
	// KW4x Family (802.15.4, BTLE, GFSK , ANT)
	SIM_SDID_FAMID_0100 = 0x4

	// SCGC4: System Clock Gating Control Register 4
	// Position of CMT field.
	SIM_SCGC4_CMT_Pos = 0x2
	// Bit mask of CMT field.
	SIM_SCGC4_CMT_Msk = 0x4
	// Bit CMT.
	SIM_SCGC4_CMT = 0x4
	// Clock disabled
	SIM_SCGC4_CMT_0 = 0x0
	// Clock enabled
	SIM_SCGC4_CMT_1 = 0x1
	// Position of I2C0 field.
	SIM_SCGC4_I2C0_Pos = 0x6
	// Bit mask of I2C0 field.
	SIM_SCGC4_I2C0_Msk = 0x40
	// Bit I2C0.
	SIM_SCGC4_I2C0 = 0x40
	// Clock disabled
	SIM_SCGC4_I2C0_0 = 0x0
	// Clock enabled
	SIM_SCGC4_I2C0_1 = 0x1
	// Position of I2C1 field.
	SIM_SCGC4_I2C1_Pos = 0x7
	// Bit mask of I2C1 field.
	SIM_SCGC4_I2C1_Msk = 0x80
	// Bit I2C1.
	SIM_SCGC4_I2C1 = 0x80
	// Clock disabled
	SIM_SCGC4_I2C1_0 = 0x0
	// Clock enabled
	SIM_SCGC4_I2C1_1 = 0x1
	// Position of CMP field.
	SIM_SCGC4_CMP_Pos = 0x13
	// Bit mask of CMP field.
	SIM_SCGC4_CMP_Msk = 0x80000
	// Bit CMP.
	SIM_SCGC4_CMP = 0x80000
	// Clock disabled
	SIM_SCGC4_CMP_0 = 0x0
	// Clock enabled
	SIM_SCGC4_CMP_1 = 0x1
	// Position of VREF field.
	SIM_SCGC4_VREF_Pos = 0x14
	// Bit mask of VREF field.
	SIM_SCGC4_VREF_Msk = 0x100000
	// Bit VREF.
	SIM_SCGC4_VREF = 0x100000
	// Clock disabled
	SIM_SCGC4_VREF_0 = 0x0
	// Clock enabled
	SIM_SCGC4_VREF_1 = 0x1

	// SCGC5: System Clock Gating Control Register 5
	// Position of LPTMR field.
	SIM_SCGC5_LPTMR_Pos = 0x0
	// Bit mask of LPTMR field.
	SIM_SCGC5_LPTMR_Msk = 0x1
	// Bit LPTMR.
	SIM_SCGC5_LPTMR = 0x1
	// Access disabled
	SIM_SCGC5_LPTMR_0 = 0x0
	// Access enabled
	SIM_SCGC5_LPTMR_1 = 0x1
	// Position of TSI field.
	SIM_SCGC5_TSI_Pos = 0x5
	// Bit mask of TSI field.
	SIM_SCGC5_TSI_Msk = 0x20
	// Bit TSI.
	SIM_SCGC5_TSI = 0x20
	// Access disabled
	SIM_SCGC5_TSI_0 = 0x0
	// Access enabled
	SIM_SCGC5_TSI_1 = 0x1
	// Position of PORTA field.
	SIM_SCGC5_PORTA_Pos = 0x9
	// Bit mask of PORTA field.
	SIM_SCGC5_PORTA_Msk = 0x200
	// Bit PORTA.
	SIM_SCGC5_PORTA = 0x200
	// Clock disabled
	SIM_SCGC5_PORTA_0 = 0x0
	// Clock enabled
	SIM_SCGC5_PORTA_1 = 0x1
	// Position of PORTB field.
	SIM_SCGC5_PORTB_Pos = 0xa
	// Bit mask of PORTB field.
	SIM_SCGC5_PORTB_Msk = 0x400
	// Bit PORTB.
	SIM_SCGC5_PORTB = 0x400
	// Clock disabled
	SIM_SCGC5_PORTB_0 = 0x0
	// Clock enabled
	SIM_SCGC5_PORTB_1 = 0x1
	// Position of PORTC field.
	SIM_SCGC5_PORTC_Pos = 0xb
	// Bit mask of PORTC field.
	SIM_SCGC5_PORTC_Msk = 0x800
	// Bit PORTC.
	SIM_SCGC5_PORTC = 0x800
	// Clock disabled
	SIM_SCGC5_PORTC_0 = 0x0
	// Clock enabled
	SIM_SCGC5_PORTC_1 = 0x1
	// Position of LPUART0 field.
	SIM_SCGC5_LPUART0_Pos = 0x14
	// Bit mask of LPUART0 field.
	SIM_SCGC5_LPUART0_Msk = 0x100000
	// Bit LPUART0.
	SIM_SCGC5_LPUART0 = 0x100000
	// Clock disabled
	SIM_SCGC5_LPUART0_0 = 0x0
	// Clock enabled
	SIM_SCGC5_LPUART0_1 = 0x1
	// Position of LTC field.
	SIM_SCGC5_LTC_Pos = 0x18
	// Bit mask of LTC field.
	SIM_SCGC5_LTC_Msk = 0x1000000
	// Bit LTC.
	SIM_SCGC5_LTC = 0x1000000
	// Clock disabled
	SIM_SCGC5_LTC_0 = 0x0
	// Clock enabled
	SIM_SCGC5_LTC_1 = 0x1
	// Position of RSIM field.
	SIM_SCGC5_RSIM_Pos = 0x19
	// Bit mask of RSIM field.
	SIM_SCGC5_RSIM_Msk = 0x2000000
	// Bit RSIM.
	SIM_SCGC5_RSIM = 0x2000000
	// Position of DCDC field.
	SIM_SCGC5_DCDC_Pos = 0x1a
	// Bit mask of DCDC field.
	SIM_SCGC5_DCDC_Msk = 0x4000000
	// Bit DCDC.
	SIM_SCGC5_DCDC = 0x4000000
	// Clock disabled
	SIM_SCGC5_DCDC_0 = 0x0
	// Clock enabled
	SIM_SCGC5_DCDC_1 = 0x1
	// Position of BTLL field.
	SIM_SCGC5_BTLL_Pos = 0x1b
	// Bit mask of BTLL field.
	SIM_SCGC5_BTLL_Msk = 0x8000000
	// Bit BTLL.
	SIM_SCGC5_BTLL = 0x8000000
	// Clock disabled
	SIM_SCGC5_BTLL_0 = 0x0
	// Clock enabled
	SIM_SCGC5_BTLL_1 = 0x1
	// Position of PHYDIG field.
	SIM_SCGC5_PHYDIG_Pos = 0x1c
	// Bit mask of PHYDIG field.
	SIM_SCGC5_PHYDIG_Msk = 0x10000000
	// Bit PHYDIG.
	SIM_SCGC5_PHYDIG = 0x10000000
	// Clock disabled
	SIM_SCGC5_PHYDIG_0 = 0x0
	// Clock enabled
	SIM_SCGC5_PHYDIG_1 = 0x1
	// Position of ZigBee field.
	SIM_SCGC5_ZigBee_Pos = 0x1d
	// Bit mask of ZigBee field.
	SIM_SCGC5_ZigBee_Msk = 0x20000000
	// Bit ZigBee.
	SIM_SCGC5_ZigBee = 0x20000000
	// Clock disabled
	SIM_SCGC5_ZigBee_0 = 0x0
	// Clock enabled
	SIM_SCGC5_ZigBee_1 = 0x1
	// Position of ANT field.
	SIM_SCGC5_ANT_Pos = 0x1e
	// Bit mask of ANT field.
	SIM_SCGC5_ANT_Msk = 0x40000000
	// Bit ANT.
	SIM_SCGC5_ANT = 0x40000000
	// ANT CGC bit disabled.
	SIM_SCGC5_ANT_0 = 0x0
	// ANT CGC bit can be enabled.
	SIM_SCGC5_ANT_1 = 0x1
	// Position of GEN_FSK field.
	SIM_SCGC5_GEN_FSK_Pos = 0x1f
	// Bit mask of GEN_FSK field.
	SIM_SCGC5_GEN_FSK_Msk = 0x80000000
	// Bit GEN_FSK.
	SIM_SCGC5_GEN_FSK = 0x80000000
	// GFSK CGC bit disabled.
	SIM_SCGC5_GEN_FSK_0 = 0x0
	// GFSK CGC bit enabled.
	SIM_SCGC5_GEN_FSK_1 = 0x1

	// SCGC6: System Clock Gating Control Register 6
	// Position of FTF field.
	SIM_SCGC6_FTF_Pos = 0x0
	// Bit mask of FTF field.
	SIM_SCGC6_FTF_Msk = 0x1
	// Bit FTF.
	SIM_SCGC6_FTF = 0x1
	// Clock disabled
	SIM_SCGC6_FTF_0 = 0x0
	// Clock enabled
	SIM_SCGC6_FTF_1 = 0x1
	// Position of DMAMUX field.
	SIM_SCGC6_DMAMUX_Pos = 0x1
	// Bit mask of DMAMUX field.
	SIM_SCGC6_DMAMUX_Msk = 0x2
	// Bit DMAMUX.
	SIM_SCGC6_DMAMUX = 0x2
	// Clock disabled
	SIM_SCGC6_DMAMUX_0 = 0x0
	// Clock enabled
	SIM_SCGC6_DMAMUX_1 = 0x1
	// Position of TRNG field.
	SIM_SCGC6_TRNG_Pos = 0x9
	// Bit mask of TRNG field.
	SIM_SCGC6_TRNG_Msk = 0x200
	// Bit TRNG.
	SIM_SCGC6_TRNG = 0x200
	// Clock disabled
	SIM_SCGC6_TRNG_0 = 0x0
	// Clock enabled
	SIM_SCGC6_TRNG_1 = 0x1
	// Position of SPI0 field.
	SIM_SCGC6_SPI0_Pos = 0xc
	// Bit mask of SPI0 field.
	SIM_SCGC6_SPI0_Msk = 0x1000
	// Bit SPI0.
	SIM_SCGC6_SPI0 = 0x1000
	// Clock disabled
	SIM_SCGC6_SPI0_0 = 0x0
	// Clock enabled
	SIM_SCGC6_SPI0_1 = 0x1
	// Position of SPI1 field.
	SIM_SCGC6_SPI1_Pos = 0xd
	// Bit mask of SPI1 field.
	SIM_SCGC6_SPI1_Msk = 0x2000
	// Bit SPI1.
	SIM_SCGC6_SPI1 = 0x2000
	// Clock disabled
	SIM_SCGC6_SPI1_0 = 0x0
	// Clock enabled
	SIM_SCGC6_SPI1_1 = 0x1
	// Position of PIT field.
	SIM_SCGC6_PIT_Pos = 0x17
	// Bit mask of PIT field.
	SIM_SCGC6_PIT_Msk = 0x800000
	// Bit PIT.
	SIM_SCGC6_PIT = 0x800000
	// Clock disabled
	SIM_SCGC6_PIT_0 = 0x0
	// Clock enabled
	SIM_SCGC6_PIT_1 = 0x1
	// Position of TPM0 field.
	SIM_SCGC6_TPM0_Pos = 0x18
	// Bit mask of TPM0 field.
	SIM_SCGC6_TPM0_Msk = 0x1000000
	// Bit TPM0.
	SIM_SCGC6_TPM0 = 0x1000000
	// Clock disabled
	SIM_SCGC6_TPM0_0 = 0x0
	// Clock enabled
	SIM_SCGC6_TPM0_1 = 0x1
	// Position of TPM1 field.
	SIM_SCGC6_TPM1_Pos = 0x19
	// Bit mask of TPM1 field.
	SIM_SCGC6_TPM1_Msk = 0x2000000
	// Bit TPM1.
	SIM_SCGC6_TPM1 = 0x2000000
	// Clock disabled
	SIM_SCGC6_TPM1_0 = 0x0
	// Clock enabled
	SIM_SCGC6_TPM1_1 = 0x1
	// Position of TPM2 field.
	SIM_SCGC6_TPM2_Pos = 0x1a
	// Bit mask of TPM2 field.
	SIM_SCGC6_TPM2_Msk = 0x4000000
	// Bit TPM2.
	SIM_SCGC6_TPM2 = 0x4000000
	// Clock disabled
	SIM_SCGC6_TPM2_0 = 0x0
	// Clock enabled
	SIM_SCGC6_TPM2_1 = 0x1
	// Position of ADC0 field.
	SIM_SCGC6_ADC0_Pos = 0x1b
	// Bit mask of ADC0 field.
	SIM_SCGC6_ADC0_Msk = 0x8000000
	// Bit ADC0.
	SIM_SCGC6_ADC0 = 0x8000000
	// Clock disabled
	SIM_SCGC6_ADC0_0 = 0x0
	// Clock enabled
	SIM_SCGC6_ADC0_1 = 0x1
	// Position of RTC field.
	SIM_SCGC6_RTC_Pos = 0x1d
	// Bit mask of RTC field.
	SIM_SCGC6_RTC_Msk = 0x20000000
	// Bit RTC.
	SIM_SCGC6_RTC = 0x20000000
	// Access and interrupts disabled
	SIM_SCGC6_RTC_0 = 0x0
	// Access and interrupts enabled
	SIM_SCGC6_RTC_1 = 0x1
	// Position of DAC0 field.
	SIM_SCGC6_DAC0_Pos = 0x1f
	// Bit mask of DAC0 field.
	SIM_SCGC6_DAC0_Msk = 0x80000000
	// Bit DAC0.
	SIM_SCGC6_DAC0 = 0x80000000
	// Clock disabled
	SIM_SCGC6_DAC0_0 = 0x0
	// Clock enabled
	SIM_SCGC6_DAC0_1 = 0x1

	// SCGC7: System Clock Gating Control Register 7
	// Position of DMA field.
	SIM_SCGC7_DMA_Pos = 0x8
	// Bit mask of DMA field.
	SIM_SCGC7_DMA_Msk = 0x100
	// Bit DMA.
	SIM_SCGC7_DMA = 0x100
	// Clock disabled
	SIM_SCGC7_DMA_0 = 0x0
	// Clock enabled
	SIM_SCGC7_DMA_1 = 0x1

	// CLKDIV1: System Clock Divider Register 1
	// Position of OUTDIV4 field.
	SIM_CLKDIV1_OUTDIV4_Pos = 0x10
	// Bit mask of OUTDIV4 field.
	SIM_CLKDIV1_OUTDIV4_Msk = 0x70000
	// Divide-by-1.
	SIM_CLKDIV1_OUTDIV4_000 = 0x0
	// Divide-by-2.
	SIM_CLKDIV1_OUTDIV4_001 = 0x1
	// Divide-by-3.
	SIM_CLKDIV1_OUTDIV4_010 = 0x2
	// Divide-by-4.
	SIM_CLKDIV1_OUTDIV4_011 = 0x3
	// Divide-by-5.
	SIM_CLKDIV1_OUTDIV4_100 = 0x4
	// Divide-by-6.
	SIM_CLKDIV1_OUTDIV4_101 = 0x5
	// Divide-by-7.
	SIM_CLKDIV1_OUTDIV4_110 = 0x6
	// Divide-by-8.
	SIM_CLKDIV1_OUTDIV4_111 = 0x7
	// Position of OUTDIV1 field.
	SIM_CLKDIV1_OUTDIV1_Pos = 0x1c
	// Bit mask of OUTDIV1 field.
	SIM_CLKDIV1_OUTDIV1_Msk = 0xf0000000
	// Divide-by-1.
	SIM_CLKDIV1_OUTDIV1_0000 = 0x0
	// Divide-by-2.
	SIM_CLKDIV1_OUTDIV1_0001 = 0x1
	// Divide-by-3.
	SIM_CLKDIV1_OUTDIV1_0010 = 0x2
	// Divide-by-4.
	SIM_CLKDIV1_OUTDIV1_0011 = 0x3
	// Divide-by-5.
	SIM_CLKDIV1_OUTDIV1_0100 = 0x4
	// Divide-by-6.
	SIM_CLKDIV1_OUTDIV1_0101 = 0x5
	// Divide-by-7.
	SIM_CLKDIV1_OUTDIV1_0110 = 0x6
	// Divide-by-8.
	SIM_CLKDIV1_OUTDIV1_0111 = 0x7
	// Divide-by-9.
	SIM_CLKDIV1_OUTDIV1_1000 = 0x8
	// Divide-by-10.
	SIM_CLKDIV1_OUTDIV1_1001 = 0x9
	// Divide-by-11.
	SIM_CLKDIV1_OUTDIV1_1010 = 0xa
	// Divide-by-12.
	SIM_CLKDIV1_OUTDIV1_1011 = 0xb
	// Divide-by-13.
	SIM_CLKDIV1_OUTDIV1_1100 = 0xc
	// Divide-by-14.
	SIM_CLKDIV1_OUTDIV1_1101 = 0xd
	// Divide-by-15.
	SIM_CLKDIV1_OUTDIV1_1110 = 0xe
	// Divide-by-16.
	SIM_CLKDIV1_OUTDIV1_1111 = 0xf

	// FCFG1: Flash Configuration Register 1
	// Position of FLASHDIS field.
	SIM_FCFG1_FLASHDIS_Pos = 0x0
	// Bit mask of FLASHDIS field.
	SIM_FCFG1_FLASHDIS_Msk = 0x1
	// Bit FLASHDIS.
	SIM_FCFG1_FLASHDIS = 0x1
	// Flash is enabled.
	SIM_FCFG1_FLASHDIS_0 = 0x0
	// Flash is disabled.
	SIM_FCFG1_FLASHDIS_1 = 0x1
	// Position of FLASHDOZE field.
	SIM_FCFG1_FLASHDOZE_Pos = 0x1
	// Bit mask of FLASHDOZE field.
	SIM_FCFG1_FLASHDOZE_Msk = 0x2
	// Bit FLASHDOZE.
	SIM_FCFG1_FLASHDOZE = 0x2
	// Flash remains enabled during Doze mode.
	SIM_FCFG1_FLASHDOZE_0 = 0x0
	// Flash is disabled for the duration of Doze mode.
	SIM_FCFG1_FLASHDOZE_1 = 0x1
	// Position of PFSIZE field.
	SIM_FCFG1_PFSIZE_Pos = 0x18
	// Bit mask of PFSIZE field.
	SIM_FCFG1_PFSIZE_Msk = 0xf000000
	// 256 KB of program flash memory
	SIM_FCFG1_PFSIZE_1001 = 0x9
	// 512 KB of program flash memory
	SIM_FCFG1_PFSIZE_1011 = 0xb
	// 512 KB of program flash memory
	SIM_FCFG1_PFSIZE_1111 = 0xf

	// FCFG2: Flash Configuration Register 2
	// Position of MAXADDR1 field.
	SIM_FCFG2_MAXADDR1_Pos = 0x10
	// Bit mask of MAXADDR1 field.
	SIM_FCFG2_MAXADDR1_Msk = 0x7f0000
	// Position of MAXADDR0 field.
	SIM_FCFG2_MAXADDR0_Pos = 0x18
	// Bit mask of MAXADDR0 field.
	SIM_FCFG2_MAXADDR0_Msk = 0x7f000000

	// UIDMH: Unique Identification Register Mid-High
	// Position of UID field.
	SIM_UIDMH_UID_Pos = 0x0
	// Bit mask of UID field.
	SIM_UIDMH_UID_Msk = 0xffff

	// UIDML: Unique Identification Register Mid Low
	// Position of UID field.
	SIM_UIDML_UID_Pos = 0x0
	// Bit mask of UID field.
	SIM_UIDML_UID_Msk = 0xffffffff

	// UIDL: Unique Identification Register Low
	// Position of UID field.
	SIM_UIDL_UID_Pos = 0x0
	// Bit mask of UID field.
	SIM_UIDL_UID_Msk = 0xffffffff

	// COPC: COP Control Register
	// Position of COPW field.
	SIM_COPC_COPW_Pos = 0x0
	// Bit mask of COPW field.
	SIM_COPC_COPW_Msk = 0x1
	// Bit COPW.
	SIM_COPC_COPW = 0x1
	// Normal mode
	SIM_COPC_COPW_0 = 0x0
	// Windowed mode
	SIM_COPC_COPW_1 = 0x1
	// Position of COPCLKS field.
	SIM_COPC_COPCLKS_Pos = 0x1
	// Bit mask of COPCLKS field.
	SIM_COPC_COPCLKS_Msk = 0x2
	// Bit COPCLKS.
	SIM_COPC_COPCLKS = 0x2
	// COP configured for short timeout
	SIM_COPC_COPCLKS_0 = 0x0
	// COP configured for long timeout
	SIM_COPC_COPCLKS_1 = 0x1
	// Position of COPT field.
	SIM_COPC_COPT_Pos = 0x2
	// Bit mask of COPT field.
	SIM_COPC_COPT_Msk = 0xc
	// COP disabled
	SIM_COPC_COPT_00 = 0x0
	// COP timeout after 25 cycles for short timeout or 213 cycles for long timeout
	SIM_COPC_COPT_01 = 0x1
	// COP timeout after 28 cycles for short timeout or 216 cycles for long timeout
	SIM_COPC_COPT_10 = 0x2
	// COP timeout after 210 cycles for short timeout or 218 cycles for long timeout
	SIM_COPC_COPT_11 = 0x3
	// Position of COPSTPEN field.
	SIM_COPC_COPSTPEN_Pos = 0x4
	// Bit mask of COPSTPEN field.
	SIM_COPC_COPSTPEN_Msk = 0x10
	// Bit COPSTPEN.
	SIM_COPC_COPSTPEN = 0x10
	// COP is disabled and the counter is reset in Stop modes
	SIM_COPC_COPSTPEN_0 = 0x0
	// COP is enabled in Stop modes
	SIM_COPC_COPSTPEN_1 = 0x1
	// Position of COPDBGEN field.
	SIM_COPC_COPDBGEN_Pos = 0x5
	// Bit mask of COPDBGEN field.
	SIM_COPC_COPDBGEN_Msk = 0x20
	// Bit COPDBGEN.
	SIM_COPC_COPDBGEN = 0x20
	// COP is disabled and the counter is reset in Debug mode
	SIM_COPC_COPDBGEN_0 = 0x0
	// COP is enabled in Debug mode
	SIM_COPC_COPDBGEN_1 = 0x1
	// Position of COPCLKSEL field.
	SIM_COPC_COPCLKSEL_Pos = 0x6
	// Bit mask of COPCLKSEL field.
	SIM_COPC_COPCLKSEL_Msk = 0xc0
	// LPO clock (1 kHz)
	SIM_COPC_COPCLKSEL_00 = 0x0
	// MCGIRCLK
	SIM_COPC_COPCLKSEL_01 = 0x1
	// OSCERCLK
	SIM_COPC_COPCLKSEL_10 = 0x2
	// Bus clock
	SIM_COPC_COPCLKSEL_11 = 0x3

	// SRVCOP: Service COP
	// Position of SRVCOP field.
	SIM_SRVCOP_SRVCOP_Pos = 0x0
	// Bit mask of SRVCOP field.
	SIM_SRVCOP_SRVCOP_Msk = 0xff
)

// Bitfields for PORTA: Pin Control and Interrupts
const (
	// PCR0: Pin Control Register n
	// Position of PS field.
	PORT_PCR0_PS_Pos = 0x0
	// Bit mask of PS field.
	PORT_PCR0_PS_Msk = 0x1
	// Bit PS.
	PORT_PCR0_PS = 0x1
	// Internal pulldown resistor is enabled on the corresponding pin, if the corresponding PE field is set.
	PORT_PCR0_PS_0 = 0x0
	// Internal pullup resistor is enabled on the corresponding pin, if the corresponding PE field is set.
	PORT_PCR0_PS_1 = 0x1
	// Position of PE field.
	PORT_PCR0_PE_Pos = 0x1
	// Bit mask of PE field.
	PORT_PCR0_PE_Msk = 0x2
	// Bit PE.
	PORT_PCR0_PE = 0x2
	// Internal pullup or pulldown resistor is not enabled on the corresponding pin.
	PORT_PCR0_PE_0 = 0x0
	// Internal pullup or pulldown resistor is enabled on the corresponding pin, if the pin is configured as a digital input.
	PORT_PCR0_PE_1 = 0x1
	// Position of SRE field.
	PORT_PCR0_SRE_Pos = 0x2
	// Bit mask of SRE field.
	PORT_PCR0_SRE_Msk = 0x4
	// Bit SRE.
	PORT_PCR0_SRE = 0x4
	// Fast slew rate is configured on the corresponding pin, if the pin is configured as a digital output.
	PORT_PCR0_SRE_0 = 0x0
	// Slow slew rate is configured on the corresponding pin, if the pin is configured as a digital output.
	PORT_PCR0_SRE_1 = 0x1
	// Position of PFE field.
	PORT_PCR0_PFE_Pos = 0x4
	// Bit mask of PFE field.
	PORT_PCR0_PFE_Msk = 0x10
	// Bit PFE.
	PORT_PCR0_PFE = 0x10
	// Passive input filter is disabled on the corresponding pin.
	PORT_PCR0_PFE_0 = 0x0
	// Passive input filter is enabled on the corresponding pin, if the pin is configured as a digital input. Refer to the device data sheet for filter characteristics.
	PORT_PCR0_PFE_1 = 0x1
	// Position of DSE field.
	PORT_PCR0_DSE_Pos = 0x6
	// Bit mask of DSE field.
	PORT_PCR0_DSE_Msk = 0x40
	// Bit DSE.
	PORT_PCR0_DSE = 0x40
	// Low drive strength is configured on the corresponding pin, if pin is configured as a digital output.
	PORT_PCR0_DSE_0 = 0x0
	// High drive strength is configured on the corresponding pin, if pin is configured as a digital output.
	PORT_PCR0_DSE_1 = 0x1
	// Position of MUX field.
	PORT_PCR0_MUX_Pos = 0x8
	// Bit mask of MUX field.
	PORT_PCR0_MUX_Msk = 0x700
	// Pin disabled (Alternative 0) (analog).
	PORT_PCR0_MUX_000 = 0x0
	// Alternative 1 (GPIO).
	PORT_PCR0_MUX_001 = 0x1
	// Alternative 2 (chip-specific).
	PORT_PCR0_MUX_010 = 0x2
	// Alternative 3 (chip-specific).
	PORT_PCR0_MUX_011 = 0x3
	// Alternative 4 (chip-specific).
	PORT_PCR0_MUX_100 = 0x4
	// Alternative 5 (chip-specific).
	PORT_PCR0_MUX_101 = 0x5
	// Alternative 6 (chip-specific).
	PORT_PCR0_MUX_110 = 0x6
	// Alternative 7 (chip-specific).
	PORT_PCR0_MUX_111 = 0x7
	// Position of IRQC field.
	PORT_PCR0_IRQC_Pos = 0x10
	// Bit mask of IRQC field.
	PORT_PCR0_IRQC_Msk = 0xf0000
	// Interrupt Status Flag (ISF) is disabled.
	PORT_PCR0_IRQC_0000 = 0x0
	// ISF flag and DMA request on rising edge.
	PORT_PCR0_IRQC_0001 = 0x1
	// ISF flag and DMA request on falling edge.
	PORT_PCR0_IRQC_0010 = 0x2
	// ISF flag and DMA request on either edge.
	PORT_PCR0_IRQC_0011 = 0x3
	// ISF flag and Interrupt when logic 0.
	PORT_PCR0_IRQC_1000 = 0x8
	// ISF flag and Interrupt on rising-edge.
	PORT_PCR0_IRQC_1001 = 0x9
	// ISF flag and Interrupt on falling-edge.
	PORT_PCR0_IRQC_1010 = 0xa
	// ISF flag and Interrupt on either edge.
	PORT_PCR0_IRQC_1011 = 0xb
	// ISF flag and Interrupt when logic 1.
	PORT_PCR0_IRQC_1100 = 0xc
	// Position of ISF field.
	PORT_PCR0_ISF_Pos = 0x18
	// Bit mask of ISF field.
	PORT_PCR0_ISF_Msk = 0x1000000
	// Bit ISF.
	PORT_PCR0_ISF = 0x1000000
	// Configured interrupt is not detected.
	PORT_PCR0_ISF_0 = 0x0
	// Configured interrupt is detected. If the pin is configured to generate a DMA request, then the corresponding flag will be cleared automatically at the completion of the requested DMA transfer. Otherwise, the flag remains set until a logic 1 is written to the flag. If the pin is configured for a level sensitive interrupt and the pin remains asserted, then the flag is set again immediately after it is cleared.
	PORT_PCR0_ISF_1 = 0x1

	// PCR1: Pin Control Register n
	// Position of PS field.
	PORT_PCR1_PS_Pos = 0x0
	// Bit mask of PS field.
	PORT_PCR1_PS_Msk = 0x1
	// Bit PS.
	PORT_PCR1_PS = 0x1
	// Internal pulldown resistor is enabled on the corresponding pin, if the corresponding PE field is set.
	PORT_PCR1_PS_0 = 0x0
	// Internal pullup resistor is enabled on the corresponding pin, if the corresponding PE field is set.
	PORT_PCR1_PS_1 = 0x1
	// Position of PE field.
	PORT_PCR1_PE_Pos = 0x1
	// Bit mask of PE field.
	PORT_PCR1_PE_Msk = 0x2
	// Bit PE.
	PORT_PCR1_PE = 0x2
	// Internal pullup or pulldown resistor is not enabled on the corresponding pin.
	PORT_PCR1_PE_0 = 0x0
	// Internal pullup or pulldown resistor is enabled on the corresponding pin, if the pin is configured as a digital input.
	PORT_PCR1_PE_1 = 0x1
	// Position of SRE field.
	PORT_PCR1_SRE_Pos = 0x2
	// Bit mask of SRE field.
	PORT_PCR1_SRE_Msk = 0x4
	// Bit SRE.
	PORT_PCR1_SRE = 0x4
	// Fast slew rate is configured on the corresponding pin, if the pin is configured as a digital output.
	PORT_PCR1_SRE_0 = 0x0
	// Slow slew rate is configured on the corresponding pin, if the pin is configured as a digital output.
	PORT_PCR1_SRE_1 = 0x1
	// Position of PFE field.
	PORT_PCR1_PFE_Pos = 0x4
	// Bit mask of PFE field.
	PORT_PCR1_PFE_Msk = 0x10
	// Bit PFE.
	PORT_PCR1_PFE = 0x10
	// Passive input filter is disabled on the corresponding pin.
	PORT_PCR1_PFE_0 = 0x0
	// Passive input filter is enabled on the corresponding pin, if the pin is configured as a digital input. Refer to the device data sheet for filter characteristics.
	PORT_PCR1_PFE_1 = 0x1
	// Position of DSE field.
	PORT_PCR1_DSE_Pos = 0x6
	// Bit mask of DSE field.
	PORT_PCR1_DSE_Msk = 0x40
	// Bit DSE.
	PORT_PCR1_DSE = 0x40
	// Low drive strength is configured on the corresponding pin, if pin is configured as a digital output.
	PORT_PCR1_DSE_0 = 0x0
	// High drive strength is configured on the corresponding pin, if pin is configured as a digital output.
	PORT_PCR1_DSE_1 = 0x1
	// Position of MUX field.
	PORT_PCR1_MUX_Pos = 0x8
	// Bit mask of MUX field.
	PORT_PCR1_MUX_Msk = 0x700
	// Pin disabled (Alternative 0) (analog).
	PORT_PCR1_MUX_000 = 0x0
	// Alternative 1 (GPIO).
	PORT_PCR1_MUX_001 = 0x1
	// Alternative 2 (chip-specific).
	PORT_PCR1_MUX_010 = 0x2
	// Alternative 3 (chip-specific).
	PORT_PCR1_MUX_011 = 0x3
	// Alternative 4 (chip-specific).
	PORT_PCR1_MUX_100 = 0x4
	// Alternative 5 (chip-specific).
	PORT_PCR1_MUX_101 = 0x5
	// Alternative 6 (chip-specific).
	PORT_PCR1_MUX_110 = 0x6
	// Alternative 7 (chip-specific).
	PORT_PCR1_MUX_111 = 0x7
	// Position of IRQC field.
	PORT_PCR1_IRQC_Pos = 0x10
	// Bit mask of IRQC field.
	PORT_PCR1_IRQC_Msk = 0xf0000
	// Interrupt Status Flag (ISF) is disabled.
	PORT_PCR1_IRQC_0000 = 0x0
	// ISF flag and DMA request on rising edge.
	PORT_PCR1_IRQC_0001 = 0x1
	// ISF flag and DMA request on falling edge.
	PORT_PCR1_IRQC_0010 = 0x2
	// ISF flag and DMA request on either edge.
	PORT_PCR1_IRQC_0011 = 0x3
	// ISF flag and Interrupt when logic 0.
	PORT_PCR1_IRQC_1000 = 0x8
	// ISF flag and Interrupt on rising-edge.
	PORT_PCR1_IRQC_1001 = 0x9
	// ISF flag and Interrupt on falling-edge.
	PORT_PCR1_IRQC_1010 = 0xa
	// ISF flag and Interrupt on either edge.
	PORT_PCR1_IRQC_1011 = 0xb
	// ISF flag and Interrupt when logic 1.
	PORT_PCR1_IRQC_1100 = 0xc
	// Position of ISF field.
	PORT_PCR1_ISF_Pos = 0x18
	// Bit mask of ISF field.
	PORT_PCR1_ISF_Msk = 0x1000000
	// Bit ISF.
	PORT_PCR1_ISF = 0x1000000
	// Configured interrupt is not detected.
	PORT_PCR1_ISF_0 = 0x0
	// Configured interrupt is detected. If the pin is configured to generate a DMA request, then the corresponding flag will be cleared automatically at the completion of the requested DMA transfer. Otherwise, the flag remains set until a logic 1 is written to the flag. If the pin is configured for a level sensitive interrupt and the pin remains asserted, then the flag is set again immediately after it is cleared.
	PORT_PCR1_ISF_1 = 0x1

	// PCR2: Pin Control Register n
	// Position of PS field.
	PORT_PCR2_PS_Pos = 0x0
	// Bit mask of PS field.
	PORT_PCR2_PS_Msk = 0x1
	// Bit PS.
	PORT_PCR2_PS = 0x1
	// Internal pulldown resistor is enabled on the corresponding pin, if the corresponding PE field is set.
	PORT_PCR2_PS_0 = 0x0
	// Internal pullup resistor is enabled on the corresponding pin, if the corresponding PE field is set.
	PORT_PCR2_PS_1 = 0x1
	// Position of PE field.
	PORT_PCR2_PE_Pos = 0x1
	// Bit mask of PE field.
	PORT_PCR2_PE_Msk = 0x2
	// Bit PE.
	PORT_PCR2_PE = 0x2
	// Internal pullup or pulldown resistor is not enabled on the corresponding pin.
	PORT_PCR2_PE_0 = 0x0
	// Internal pullup or pulldown resistor is enabled on the corresponding pin, if the pin is configured as a digital input.
	PORT_PCR2_PE_1 = 0x1
	// Position of SRE field.
	PORT_PCR2_SRE_Pos = 0x2
	// Bit mask of SRE field.
	PORT_PCR2_SRE_Msk = 0x4
	// Bit SRE.
	PORT_PCR2_SRE = 0x4
	// Fast slew rate is configured on the corresponding pin, if the pin is configured as a digital output.
	PORT_PCR2_SRE_0 = 0x0
	// Slow slew rate is configured on the corresponding pin, if the pin is configured as a digital output.
	PORT_PCR2_SRE_1 = 0x1
	// Position of PFE field.
	PORT_PCR2_PFE_Pos = 0x4
	// Bit mask of PFE field.
	PORT_PCR2_PFE_Msk = 0x10
	// Bit PFE.
	PORT_PCR2_PFE = 0x10
	// Passive input filter is disabled on the corresponding pin.
	PORT_PCR2_PFE_0 = 0x0
	// Passive input filter is enabled on the corresponding pin, if the pin is configured as a digital input. Refer to the device data sheet for filter characteristics.
	PORT_PCR2_PFE_1 = 0x1
	// Position of DSE field.
	PORT_PCR2_DSE_Pos = 0x6
	// Bit mask of DSE field.
	PORT_PCR2_DSE_Msk = 0x40
	// Bit DSE.
	PORT_PCR2_DSE = 0x40
	// Low drive strength is configured on the corresponding pin, if pin is configured as a digital output.
	PORT_PCR2_DSE_0 = 0x0
	// High drive strength is configured on the corresponding pin, if pin is configured as a digital output.
	PORT_PCR2_DSE_1 = 0x1
	// Position of MUX field.
	PORT_PCR2_MUX_Pos = 0x8
	// Bit mask of MUX field.
	PORT_PCR2_MUX_Msk = 0x700
	// Pin disabled (Alternative 0) (analog).
	PORT_PCR2_MUX_000 = 0x0
	// Alternative 1 (GPIO).
	PORT_PCR2_MUX_001 = 0x1
	// Alternative 2 (chip-specific).
	PORT_PCR2_MUX_010 = 0x2
	// Alternative 3 (chip-specific).
	PORT_PCR2_MUX_011 = 0x3
	// Alternative 4 (chip-specific).
	PORT_PCR2_MUX_100 = 0x4
	// Alternative 5 (chip-specific).
	PORT_PCR2_MUX_101 = 0x5
	// Alternative 6 (chip-specific).
	PORT_PCR2_MUX_110 = 0x6
	// Alternative 7 (chip-specific).
	PORT_PCR2_MUX_111 = 0x7
	// Position of IRQC field.
	PORT_PCR2_IRQC_Pos = 0x10
	// Bit mask of IRQC field.
	PORT_PCR2_IRQC_Msk = 0xf0000
	// Interrupt Status Flag (ISF) is disabled.
	PORT_PCR2_IRQC_0000 = 0x0
	// ISF flag and DMA request on rising edge.
	PORT_PCR2_IRQC_0001 = 0x1
	// ISF flag and DMA request on falling edge.
	PORT_PCR2_IRQC_0010 = 0x2
	// ISF flag and DMA request on either edge.
	PORT_PCR2_IRQC_0011 = 0x3
	// ISF flag and Interrupt when logic 0.
	PORT_PCR2_IRQC_1000 = 0x8
	// ISF flag and Interrupt on rising-edge.
	PORT_PCR2_IRQC_1001 = 0x9
	// ISF flag and Interrupt on falling-edge.
	PORT_PCR2_IRQC_1010 = 0xa
	// ISF flag and Interrupt on either edge.
	PORT_PCR2_IRQC_1011 = 0xb
	// ISF flag and Interrupt when logic 1.
	PORT_PCR2_IRQC_1100 = 0xc
	// Position of ISF field.
	PORT_PCR2_ISF_Pos = 0x18
	// Bit mask of ISF field.
	PORT_PCR2_ISF_Msk = 0x1000000
	// Bit ISF.
	PORT_PCR2_ISF = 0x1000000
	// Configured interrupt is not detected.
	PORT_PCR2_ISF_0 = 0x0
	// Configured interrupt is detected. If the pin is configured to generate a DMA request, then the corresponding flag will be cleared automatically at the completion of the requested DMA transfer. Otherwise, the flag remains set until a logic 1 is written to the flag. If the pin is configured for a level sensitive interrupt and the pin remains asserted, then the flag is set again immediately after it is cleared.
	PORT_PCR2_ISF_1 = 0x1

	// PCR3: Pin Control Register n
	// Position of PS field.
	PORT_PCR3_PS_Pos = 0x0
	// Bit mask of PS field.
	PORT_PCR3_PS_Msk = 0x1
	// Bit PS.
	PORT_PCR3_PS = 0x1
	// Internal pulldown resistor is enabled on the corresponding pin, if the corresponding PE field is set.
	PORT_PCR3_PS_0 = 0x0
	// Internal pullup resistor is enabled on the corresponding pin, if the corresponding PE field is set.
	PORT_PCR3_PS_1 = 0x1
	// Position of PE field.
	PORT_PCR3_PE_Pos = 0x1
	// Bit mask of PE field.
	PORT_PCR3_PE_Msk = 0x2
	// Bit PE.
	PORT_PCR3_PE = 0x2
	// Internal pullup or pulldown resistor is not enabled on the corresponding pin.
	PORT_PCR3_PE_0 = 0x0
	// Internal pullup or pulldown resistor is enabled on the corresponding pin, if the pin is configured as a digital input.
	PORT_PCR3_PE_1 = 0x1
	// Position of SRE field.
	PORT_PCR3_SRE_Pos = 0x2
	// Bit mask of SRE field.
	PORT_PCR3_SRE_Msk = 0x4
	// Bit SRE.
	PORT_PCR3_SRE = 0x4
	// Fast slew rate is configured on the corresponding pin, if the pin is configured as a digital output.
	PORT_PCR3_SRE_0 = 0x0
	// Slow slew rate is configured on the corresponding pin, if the pin is configured as a digital output.
	PORT_PCR3_SRE_1 = 0x1
	// Position of PFE field.
	PORT_PCR3_PFE_Pos = 0x4
	// Bit mask of PFE field.
	PORT_PCR3_PFE_Msk = 0x10
	// Bit PFE.
	PORT_PCR3_PFE = 0x10
	// Passive input filter is disabled on the corresponding pin.
	PORT_PCR3_PFE_0 = 0x0
	// Passive input filter is enabled on the corresponding pin, if the pin is configured as a digital input. Refer to the device data sheet for filter characteristics.
	PORT_PCR3_PFE_1 = 0x1
	// Position of DSE field.
	PORT_PCR3_DSE_Pos = 0x6
	// Bit mask of DSE field.
	PORT_PCR3_DSE_Msk = 0x40
	// Bit DSE.
	PORT_PCR3_DSE = 0x40
	// Low drive strength is configured on the corresponding pin, if pin is configured as a digital output.
	PORT_PCR3_DSE_0 = 0x0
	// High drive strength is configured on the corresponding pin, if pin is configured as a digital output.
	PORT_PCR3_DSE_1 = 0x1
	// Position of MUX field.
	PORT_PCR3_MUX_Pos = 0x8
	// Bit mask of MUX field.
	PORT_PCR3_MUX_Msk = 0x700
	// Pin disabled (Alternative 0) (analog).
	PORT_PCR3_MUX_000 = 0x0
	// Alternative 1 (GPIO).
	PORT_PCR3_MUX_001 = 0x1
	// Alternative 2 (chip-specific).
	PORT_PCR3_MUX_010 = 0x2
	// Alternative 3 (chip-specific).
	PORT_PCR3_MUX_011 = 0x3
	// Alternative 4 (chip-specific).
	PORT_PCR3_MUX_100 = 0x4
	// Alternative 5 (chip-specific).
	PORT_PCR3_MUX_101 = 0x5
	// Alternative 6 (chip-specific).
	PORT_PCR3_MUX_110 = 0x6
	// Alternative 7 (chip-specific).
	PORT_PCR3_MUX_111 = 0x7
	// Position of IRQC field.
	PORT_PCR3_IRQC_Pos = 0x10
	// Bit mask of IRQC field.
	PORT_PCR3_IRQC_Msk = 0xf0000
	// Interrupt Status Flag (ISF) is disabled.
	PORT_PCR3_IRQC_0000 = 0x0
	// ISF flag and DMA request on rising edge.
	PORT_PCR3_IRQC_0001 = 0x1
	// ISF flag and DMA request on falling edge.
	PORT_PCR3_IRQC_0010 = 0x2
	// ISF flag and DMA request on either edge.
	PORT_PCR3_IRQC_0011 = 0x3
	// ISF flag and Interrupt when logic 0.
	PORT_PCR3_IRQC_1000 = 0x8
	// ISF flag and Interrupt on rising-edge.
	PORT_PCR3_IRQC_1001 = 0x9
	// ISF flag and Interrupt on falling-edge.
	PORT_PCR3_IRQC_1010 = 0xa
	// ISF flag and Interrupt on either edge.
	PORT_PCR3_IRQC_1011 = 0xb
	// ISF flag and Interrupt when logic 1.
	PORT_PCR3_IRQC_1100 = 0xc
	// Position of ISF field.
	PORT_PCR3_ISF_Pos = 0x18
	// Bit mask of ISF field.
	PORT_PCR3_ISF_Msk = 0x1000000
	// Bit ISF.
	PORT_PCR3_ISF = 0x1000000
	// Configured interrupt is not detected.
	PORT_PCR3_ISF_0 = 0x0
	// Configured interrupt is detected. If the pin is configured to generate a DMA request, then the corresponding flag will be cleared automatically at the completion of the requested DMA transfer. Otherwise, the flag remains set until a logic 1 is written to the flag. If the pin is configured for a level sensitive interrupt and the pin remains asserted, then the flag is set again immediately after it is cleared.
	PORT_PCR3_ISF_1 = 0x1

	// PCR4: Pin Control Register n
	// Position of PS field.
	PORT_PCR4_PS_Pos = 0x0
	// Bit mask of PS field.
	PORT_PCR4_PS_Msk = 0x1
	// Bit PS.
	PORT_PCR4_PS = 0x1
	// Internal pulldown resistor is enabled on the corresponding pin, if the corresponding PE field is set.
	PORT_PCR4_PS_0 = 0x0
	// Internal pullup resistor is enabled on the corresponding pin, if the corresponding PE field is set.
	PORT_PCR4_PS_1 = 0x1
	// Position of PE field.
	PORT_PCR4_PE_Pos = 0x1
	// Bit mask of PE field.
	PORT_PCR4_PE_Msk = 0x2
	// Bit PE.
	PORT_PCR4_PE = 0x2
	// Internal pullup or pulldown resistor is not enabled on the corresponding pin.
	PORT_PCR4_PE_0 = 0x0
	// Internal pullup or pulldown resistor is enabled on the corresponding pin, if the pin is configured as a digital input.
	PORT_PCR4_PE_1 = 0x1
	// Position of SRE field.
	PORT_PCR4_SRE_Pos = 0x2
	// Bit mask of SRE field.
	PORT_PCR4_SRE_Msk = 0x4
	// Bit SRE.
	PORT_PCR4_SRE = 0x4
	// Fast slew rate is configured on the corresponding pin, if the pin is configured as a digital output.
	PORT_PCR4_SRE_0 = 0x0
	// Slow slew rate is configured on the corresponding pin, if the pin is configured as a digital output.
	PORT_PCR4_SRE_1 = 0x1
	// Position of PFE field.
	PORT_PCR4_PFE_Pos = 0x4
	// Bit mask of PFE field.
	PORT_PCR4_PFE_Msk = 0x10
	// Bit PFE.
	PORT_PCR4_PFE = 0x10
	// Passive input filter is disabled on the corresponding pin.
	PORT_PCR4_PFE_0 = 0x0
	// Passive input filter is enabled on the corresponding pin, if the pin is configured as a digital input. Refer to the device data sheet for filter characteristics.
	PORT_PCR4_PFE_1 = 0x1
	// Position of DSE field.
	PORT_PCR4_DSE_Pos = 0x6
	// Bit mask of DSE field.
	PORT_PCR4_DSE_Msk = 0x40
	// Bit DSE.
	PORT_PCR4_DSE = 0x40
	// Low drive strength is configured on the corresponding pin, if pin is configured as a digital output.
	PORT_PCR4_DSE_0 = 0x0
	// High drive strength is configured on the corresponding pin, if pin is configured as a digital output.
	PORT_PCR4_DSE_1 = 0x1
	// Position of MUX field.
	PORT_PCR4_MUX_Pos = 0x8
	// Bit mask of MUX field.
	PORT_PCR4_MUX_Msk = 0x700
	// Pin disabled (Alternative 0) (analog).
	PORT_PCR4_MUX_000 = 0x0
	// Alternative 1 (GPIO).
	PORT_PCR4_MUX_001 = 0x1
	// Alternative 2 (chip-specific).
	PORT_PCR4_MUX_010 = 0x2
	// Alternative 3 (chip-specific).
	PORT_PCR4_MUX_011 = 0x3
	// Alternative 4 (chip-specific).
	PORT_PCR4_MUX_100 = 0x4
	// Alternative 5 (chip-specific).
	PORT_PCR4_MUX_101 = 0x5
	// Alternative 6 (chip-specific).
	PORT_PCR4_MUX_110 = 0x6
	// Alternative 7 (chip-specific).
	PORT_PCR4_MUX_111 = 0x7
	// Position of IRQC field.
	PORT_PCR4_IRQC_Pos = 0x10
	// Bit mask of IRQC field.
	PORT_PCR4_IRQC_Msk = 0xf0000
	// Interrupt Status Flag (ISF) is disabled.
	PORT_PCR4_IRQC_0000 = 0x0
	// ISF flag and DMA request on rising edge.
	PORT_PCR4_IRQC_0001 = 0x1
	// ISF flag and DMA request on falling edge.
	PORT_PCR4_IRQC_0010 = 0x2
	// ISF flag and DMA request on either edge.
	PORT_PCR4_IRQC_0011 = 0x3
	// ISF flag and Interrupt when logic 0.
	PORT_PCR4_IRQC_1000 = 0x8
	// ISF flag and Interrupt on rising-edge.
	PORT_PCR4_IRQC_1001 = 0x9
	// ISF flag and Interrupt on falling-edge.
	PORT_PCR4_IRQC_1010 = 0xa
	// ISF flag and Interrupt on either edge.
	PORT_PCR4_IRQC_1011 = 0xb
	// ISF flag and Interrupt when logic 1.
	PORT_PCR4_IRQC_1100 = 0xc
	// Position of ISF field.
	PORT_PCR4_ISF_Pos = 0x18
	// Bit mask of ISF field.
	PORT_PCR4_ISF_Msk = 0x1000000
	// Bit ISF.
	PORT_PCR4_ISF = 0x1000000
	// Configured interrupt is not detected.
	PORT_PCR4_ISF_0 = 0x0
	// Configured interrupt is detected. If the pin is configured to generate a DMA request, then the corresponding flag will be cleared automatically at the completion of the requested DMA transfer. Otherwise, the flag remains set until a logic 1 is written to the flag. If the pin is configured for a level sensitive interrupt and the pin remains asserted, then the flag is set again immediately after it is cleared.
	PORT_PCR4_ISF_1 = 0x1

	// PCR5: Pin Control Register n
	// Position of PS field.
	PORT_PCR5_PS_Pos = 0x0
	// Bit mask of PS field.
	PORT_PCR5_PS_Msk = 0x1
	// Bit PS.
	PORT_PCR5_PS = 0x1
	// Internal pulldown resistor is enabled on the corresponding pin, if the corresponding PE field is set.
	PORT_PCR5_PS_0 = 0x0
	// Internal pullup resistor is enabled on the corresponding pin, if the corresponding PE field is set.
	PORT_PCR5_PS_1 = 0x1
	// Position of PE field.
	PORT_PCR5_PE_Pos = 0x1
	// Bit mask of PE field.
	PORT_PCR5_PE_Msk = 0x2
	// Bit PE.
	PORT_PCR5_PE = 0x2
	// Internal pullup or pulldown resistor is not enabled on the corresponding pin.
	PORT_PCR5_PE_0 = 0x0
	// Internal pullup or pulldown resistor is enabled on the corresponding pin, if the pin is configured as a digital input.
	PORT_PCR5_PE_1 = 0x1
	// Position of SRE field.
	PORT_PCR5_SRE_Pos = 0x2
	// Bit mask of SRE field.
	PORT_PCR5_SRE_Msk = 0x4
	// Bit SRE.
	PORT_PCR5_SRE = 0x4
	// Fast slew rate is configured on the corresponding pin, if the pin is configured as a digital output.
	PORT_PCR5_SRE_0 = 0x0
	// Slow slew rate is configured on the corresponding pin, if the pin is configured as a digital output.
	PORT_PCR5_SRE_1 = 0x1
	// Position of PFE field.
	PORT_PCR5_PFE_Pos = 0x4
	// Bit mask of PFE field.
	PORT_PCR5_PFE_Msk = 0x10
	// Bit PFE.
	PORT_PCR5_PFE = 0x10
	// Passive input filter is disabled on the corresponding pin.
	PORT_PCR5_PFE_0 = 0x0
	// Passive input filter is enabled on the corresponding pin, if the pin is configured as a digital input. Refer to the device data sheet for filter characteristics.
	PORT_PCR5_PFE_1 = 0x1
	// Position of DSE field.
	PORT_PCR5_DSE_Pos = 0x6
	// Bit mask of DSE field.
	PORT_PCR5_DSE_Msk = 0x40
	// Bit DSE.
	PORT_PCR5_DSE = 0x40
	// Low drive strength is configured on the corresponding pin, if pin is configured as a digital output.
	PORT_PCR5_DSE_0 = 0x0
	// High drive strength is configured on the corresponding pin, if pin is configured as a digital output.
	PORT_PCR5_DSE_1 = 0x1
	// Position of MUX field.
	PORT_PCR5_MUX_Pos = 0x8
	// Bit mask of MUX field.
	PORT_PCR5_MUX_Msk = 0x700
	// Pin disabled (Alternative 0) (analog).
	PORT_PCR5_MUX_000 = 0x0
	// Alternative 1 (GPIO).
	PORT_PCR5_MUX_001 = 0x1
	// Alternative 2 (chip-specific).
	PORT_PCR5_MUX_010 = 0x2
	// Alternative 3 (chip-specific).
	PORT_PCR5_MUX_011 = 0x3
	// Alternative 4 (chip-specific).
	PORT_PCR5_MUX_100 = 0x4
	// Alternative 5 (chip-specific).
	PORT_PCR5_MUX_101 = 0x5
	// Alternative 6 (chip-specific).
	PORT_PCR5_MUX_110 = 0x6
	// Alternative 7 (chip-specific).
	PORT_PCR5_MUX_111 = 0x7
	// Position of IRQC field.
	PORT_PCR5_IRQC_Pos = 0x10
	// Bit mask of IRQC field.
	PORT_PCR5_IRQC_Msk = 0xf0000
	// Interrupt Status Flag (ISF) is disabled.
	PORT_PCR5_IRQC_0000 = 0x0
	// ISF flag and DMA request on rising edge.
	PORT_PCR5_IRQC_0001 = 0x1
	// ISF flag and DMA request on falling edge.
	PORT_PCR5_IRQC_0010 = 0x2
	// ISF flag and DMA request on either edge.
	PORT_PCR5_IRQC_0011 = 0x3
	// ISF flag and Interrupt when logic 0.
	PORT_PCR5_IRQC_1000 = 0x8
	// ISF flag and Interrupt on rising-edge.
	PORT_PCR5_IRQC_1001 = 0x9
	// ISF flag and Interrupt on falling-edge.
	PORT_PCR5_IRQC_1010 = 0xa
	// ISF flag and Interrupt on either edge.
	PORT_PCR5_IRQC_1011 = 0xb
	// ISF flag and Interrupt when logic 1.
	PORT_PCR5_IRQC_1100 = 0xc
	// Position of ISF field.
	PORT_PCR5_ISF_Pos = 0x18
	// Bit mask of ISF field.
	PORT_PCR5_ISF_Msk = 0x1000000
	// Bit ISF.
	PORT_PCR5_ISF = 0x1000000
	// Configured interrupt is not detected.
	PORT_PCR5_ISF_0 = 0x0
	// Configured interrupt is detected. If the pin is configured to generate a DMA request, then the corresponding flag will be cleared automatically at the completion of the requested DMA transfer. Otherwise, the flag remains set until a logic 1 is written to the flag. If the pin is configured for a level sensitive interrupt and the pin remains asserted, then the flag is set again immediately after it is cleared.
	PORT_PCR5_ISF_1 = 0x1

	// PCR6: Pin Control Register n
	// Position of PS field.
	PORT_PCR6_PS_Pos = 0x0
	// Bit mask of PS field.
	PORT_PCR6_PS_Msk = 0x1
	// Bit PS.
	PORT_PCR6_PS = 0x1
	// Internal pulldown resistor is enabled on the corresponding pin, if the corresponding PE field is set.
	PORT_PCR6_PS_0 = 0x0
	// Internal pullup resistor is enabled on the corresponding pin, if the corresponding PE field is set.
	PORT_PCR6_PS_1 = 0x1
	// Position of PE field.
	PORT_PCR6_PE_Pos = 0x1
	// Bit mask of PE field.
	PORT_PCR6_PE_Msk = 0x2
	// Bit PE.
	PORT_PCR6_PE = 0x2
	// Internal pullup or pulldown resistor is not enabled on the corresponding pin.
	PORT_PCR6_PE_0 = 0x0
	// Internal pullup or pulldown resistor is enabled on the corresponding pin, if the pin is configured as a digital input.
	PORT_PCR6_PE_1 = 0x1
	// Position of SRE field.
	PORT_PCR6_SRE_Pos = 0x2
	// Bit mask of SRE field.
	PORT_PCR6_SRE_Msk = 0x4
	// Bit SRE.
	PORT_PCR6_SRE = 0x4
	// Fast slew rate is configured on the corresponding pin, if the pin is configured as a digital output.
	PORT_PCR6_SRE_0 = 0x0
	// Slow slew rate is configured on the corresponding pin, if the pin is configured as a digital output.
	PORT_PCR6_SRE_1 = 0x1
	// Position of PFE field.
	PORT_PCR6_PFE_Pos = 0x4
	// Bit mask of PFE field.
	PORT_PCR6_PFE_Msk = 0x10
	// Bit PFE.
	PORT_PCR6_PFE = 0x10
	// Passive input filter is disabled on the corresponding pin.
	PORT_PCR6_PFE_0 = 0x0
	// Passive input filter is enabled on the corresponding pin, if the pin is configured as a digital input. Refer to the device data sheet for filter characteristics.
	PORT_PCR6_PFE_1 = 0x1
	// Position of DSE field.
	PORT_PCR6_DSE_Pos = 0x6
	// Bit mask of DSE field.
	PORT_PCR6_DSE_Msk = 0x40
	// Bit DSE.
	PORT_PCR6_DSE = 0x40
	// Low drive strength is configured on the corresponding pin, if pin is configured as a digital output.
	PORT_PCR6_DSE_0 = 0x0
	// High drive strength is configured on the corresponding pin, if pin is configured as a digital output.
	PORT_PCR6_DSE_1 = 0x1
	// Position of MUX field.
	PORT_PCR6_MUX_Pos = 0x8
	// Bit mask of MUX field.
	PORT_PCR6_MUX_Msk = 0x700
	// Pin disabled (Alternative 0) (analog).
	PORT_PCR6_MUX_000 = 0x0
	// Alternative 1 (GPIO).
	PORT_PCR6_MUX_001 = 0x1
	// Alternative 2 (chip-specific).
	PORT_PCR6_MUX_010 = 0x2
	// Alternative 3 (chip-specific).
	PORT_PCR6_MUX_011 = 0x3
	// Alternative 4 (chip-specific).
	PORT_PCR6_MUX_100 = 0x4
	// Alternative 5 (chip-specific).
	PORT_PCR6_MUX_101 = 0x5
	// Alternative 6 (chip-specific).
	PORT_PCR6_MUX_110 = 0x6
	// Alternative 7 (chip-specific).
	PORT_PCR6_MUX_111 = 0x7
	// Position of IRQC field.
	PORT_PCR6_IRQC_Pos = 0x10
	// Bit mask of IRQC field.
	PORT_PCR6_IRQC_Msk = 0xf0000
	// Interrupt Status Flag (ISF) is disabled.
	PORT_PCR6_IRQC_0000 = 0x0
	// ISF flag and DMA request on rising edge.
	PORT_PCR6_IRQC_0001 = 0x1
	// ISF flag and DMA request on falling edge.
	PORT_PCR6_IRQC_0010 = 0x2
	// ISF flag and DMA request on either edge.
	PORT_PCR6_IRQC_0011 = 0x3
	// ISF flag and Interrupt when logic 0.
	PORT_PCR6_IRQC_1000 = 0x8
	// ISF flag and Interrupt on rising-edge.
	PORT_PCR6_IRQC_1001 = 0x9
	// ISF flag and Interrupt on falling-edge.
	PORT_PCR6_IRQC_1010 = 0xa
	// ISF flag and Interrupt on either edge.
	PORT_PCR6_IRQC_1011 = 0xb
	// ISF flag and Interrupt when logic 1.
	PORT_PCR6_IRQC_1100 = 0xc
	// Position of ISF field.
	PORT_PCR6_ISF_Pos = 0x18
	// Bit mask of ISF field.
	PORT_PCR6_ISF_Msk = 0x1000000
	// Bit ISF.
	PORT_PCR6_ISF = 0x1000000
	// Configured interrupt is not detected.
	PORT_PCR6_ISF_0 = 0x0
	// Configured interrupt is detected. If the pin is configured to generate a DMA request, then the corresponding flag will be cleared automatically at the completion of the requested DMA transfer. Otherwise, the flag remains set until a logic 1 is written to the flag. If the pin is configured for a level sensitive interrupt and the pin remains asserted, then the flag is set again immediately after it is cleared.
	PORT_PCR6_ISF_1 = 0x1

	// PCR7: Pin Control Register n
	// Position of PS field.
	PORT_PCR7_PS_Pos = 0x0
	// Bit mask of PS field.
	PORT_PCR7_PS_Msk = 0x1
	// Bit PS.
	PORT_PCR7_PS = 0x1
	// Internal pulldown resistor is enabled on the corresponding pin, if the corresponding PE field is set.
	PORT_PCR7_PS_0 = 0x0
	// Internal pullup resistor is enabled on the corresponding pin, if the corresponding PE field is set.
	PORT_PCR7_PS_1 = 0x1
	// Position of PE field.
	PORT_PCR7_PE_Pos = 0x1
	// Bit mask of PE field.
	PORT_PCR7_PE_Msk = 0x2
	// Bit PE.
	PORT_PCR7_PE = 0x2
	// Internal pullup or pulldown resistor is not enabled on the corresponding pin.
	PORT_PCR7_PE_0 = 0x0
	// Internal pullup or pulldown resistor is enabled on the corresponding pin, if the pin is configured as a digital input.
	PORT_PCR7_PE_1 = 0x1
	// Position of SRE field.
	PORT_PCR7_SRE_Pos = 0x2
	// Bit mask of SRE field.
	PORT_PCR7_SRE_Msk = 0x4
	// Bit SRE.
	PORT_PCR7_SRE = 0x4
	// Fast slew rate is configured on the corresponding pin, if the pin is configured as a digital output.
	PORT_PCR7_SRE_0 = 0x0
	// Slow slew rate is configured on the corresponding pin, if the pin is configured as a digital output.
	PORT_PCR7_SRE_1 = 0x1
	// Position of PFE field.
	PORT_PCR7_PFE_Pos = 0x4
	// Bit mask of PFE field.
	PORT_PCR7_PFE_Msk = 0x10
	// Bit PFE.
	PORT_PCR7_PFE = 0x10
	// Passive input filter is disabled on the corresponding pin.
	PORT_PCR7_PFE_0 = 0x0
	// Passive input filter is enabled on the corresponding pin, if the pin is configured as a digital input. Refer to the device data sheet for filter characteristics.
	PORT_PCR7_PFE_1 = 0x1
	// Position of DSE field.
	PORT_PCR7_DSE_Pos = 0x6
	// Bit mask of DSE field.
	PORT_PCR7_DSE_Msk = 0x40
	// Bit DSE.
	PORT_PCR7_DSE = 0x40
	// Low drive strength is configured on the corresponding pin, if pin is configured as a digital output.
	PORT_PCR7_DSE_0 = 0x0
	// High drive strength is configured on the corresponding pin, if pin is configured as a digital output.
	PORT_PCR7_DSE_1 = 0x1
	// Position of MUX field.
	PORT_PCR7_MUX_Pos = 0x8
	// Bit mask of MUX field.
	PORT_PCR7_MUX_Msk = 0x700
	// Pin disabled (Alternative 0) (analog).
	PORT_PCR7_MUX_000 = 0x0
	// Alternative 1 (GPIO).
	PORT_PCR7_MUX_001 = 0x1
	// Alternative 2 (chip-specific).
	PORT_PCR7_MUX_010 = 0x2
	// Alternative 3 (chip-specific).
	PORT_PCR7_MUX_011 = 0x3
	// Alternative 4 (chip-specific).
	PORT_PCR7_MUX_100 = 0x4
	// Alternative 5 (chip-specific).
	PORT_PCR7_MUX_101 = 0x5
	// Alternative 6 (chip-specific).
	PORT_PCR7_MUX_110 = 0x6
	// Alternative 7 (chip-specific).
	PORT_PCR7_MUX_111 = 0x7
	// Position of IRQC field.
	PORT_PCR7_IRQC_Pos = 0x10
	// Bit mask of IRQC field.
	PORT_PCR7_IRQC_Msk = 0xf0000
	// Interrupt Status Flag (ISF) is disabled.
	PORT_PCR7_IRQC_0000 = 0x0
	// ISF flag and DMA request on rising edge.
	PORT_PCR7_IRQC_0001 = 0x1
	// ISF flag and DMA request on falling edge.
	PORT_PCR7_IRQC_0010 = 0x2
	// ISF flag and DMA request on either edge.
	PORT_PCR7_IRQC_0011 = 0x3
	// ISF flag and Interrupt when logic 0.
	PORT_PCR7_IRQC_1000 = 0x8
	// ISF flag and Interrupt on rising-edge.
	PORT_PCR7_IRQC_1001 = 0x9
	// ISF flag and Interrupt on falling-edge.
	PORT_PCR7_IRQC_1010 = 0xa
	// ISF flag and Interrupt on either edge.
	PORT_PCR7_IRQC_1011 = 0xb
	// ISF flag and Interrupt when logic 1.
	PORT_PCR7_IRQC_1100 = 0xc
	// Position of ISF field.
	PORT_PCR7_ISF_Pos = 0x18
	// Bit mask of ISF field.
	PORT_PCR7_ISF_Msk = 0x1000000
	// Bit ISF.
	PORT_PCR7_ISF = 0x1000000
	// Configured interrupt is not detected.
	PORT_PCR7_ISF_0 = 0x0
	// Configured interrupt is detected. If the pin is configured to generate a DMA request, then the corresponding flag will be cleared automatically at the completion of the requested DMA transfer. Otherwise, the flag remains set until a logic 1 is written to the flag. If the pin is configured for a level sensitive interrupt and the pin remains asserted, then the flag is set again immediately after it is cleared.
	PORT_PCR7_ISF_1 = 0x1

	// PCR8: Pin Control Register n
	// Position of PS field.
	PORT_PCR8_PS_Pos = 0x0
	// Bit mask of PS field.
	PORT_PCR8_PS_Msk = 0x1
	// Bit PS.
	PORT_PCR8_PS = 0x1
	// Internal pulldown resistor is enabled on the corresponding pin, if the corresponding PE field is set.
	PORT_PCR8_PS_0 = 0x0
	// Internal pullup resistor is enabled on the corresponding pin, if the corresponding PE field is set.
	PORT_PCR8_PS_1 = 0x1
	// Position of PE field.
	PORT_PCR8_PE_Pos = 0x1
	// Bit mask of PE field.
	PORT_PCR8_PE_Msk = 0x2
	// Bit PE.
	PORT_PCR8_PE = 0x2
	// Internal pullup or pulldown resistor is not enabled on the corresponding pin.
	PORT_PCR8_PE_0 = 0x0
	// Internal pullup or pulldown resistor is enabled on the corresponding pin, if the pin is configured as a digital input.
	PORT_PCR8_PE_1 = 0x1
	// Position of SRE field.
	PORT_PCR8_SRE_Pos = 0x2
	// Bit mask of SRE field.
	PORT_PCR8_SRE_Msk = 0x4
	// Bit SRE.
	PORT_PCR8_SRE = 0x4
	// Fast slew rate is configured on the corresponding pin, if the pin is configured as a digital output.
	PORT_PCR8_SRE_0 = 0x0
	// Slow slew rate is configured on the corresponding pin, if the pin is configured as a digital output.
	PORT_PCR8_SRE_1 = 0x1
	// Position of PFE field.
	PORT_PCR8_PFE_Pos = 0x4
	// Bit mask of PFE field.
	PORT_PCR8_PFE_Msk = 0x10
	// Bit PFE.
	PORT_PCR8_PFE = 0x10
	// Passive input filter is disabled on the corresponding pin.
	PORT_PCR8_PFE_0 = 0x0
	// Passive input filter is enabled on the corresponding pin, if the pin is configured as a digital input. Refer to the device data sheet for filter characteristics.
	PORT_PCR8_PFE_1 = 0x1
	// Position of DSE field.
	PORT_PCR8_DSE_Pos = 0x6
	// Bit mask of DSE field.
	PORT_PCR8_DSE_Msk = 0x40
	// Bit DSE.
	PORT_PCR8_DSE = 0x40
	// Low drive strength is configured on the corresponding pin, if pin is configured as a digital output.
	PORT_PCR8_DSE_0 = 0x0
	// High drive strength is configured on the corresponding pin, if pin is configured as a digital output.
	PORT_PCR8_DSE_1 = 0x1
	// Position of MUX field.
	PORT_PCR8_MUX_Pos = 0x8
	// Bit mask of MUX field.
	PORT_PCR8_MUX_Msk = 0x700
	// Pin disabled (Alternative 0) (analog).
	PORT_PCR8_MUX_000 = 0x0
	// Alternative 1 (GPIO).
	PORT_PCR8_MUX_001 = 0x1
	// Alternative 2 (chip-specific).
	PORT_PCR8_MUX_010 = 0x2
	// Alternative 3 (chip-specific).
	PORT_PCR8_MUX_011 = 0x3
	// Alternative 4 (chip-specific).
	PORT_PCR8_MUX_100 = 0x4
	// Alternative 5 (chip-specific).
	PORT_PCR8_MUX_101 = 0x5
	// Alternative 6 (chip-specific).
	PORT_PCR8_MUX_110 = 0x6
	// Alternative 7 (chip-specific).
	PORT_PCR8_MUX_111 = 0x7
	// Position of IRQC field.
	PORT_PCR8_IRQC_Pos = 0x10
	// Bit mask of IRQC field.
	PORT_PCR8_IRQC_Msk = 0xf0000
	// Interrupt Status Flag (ISF) is disabled.
	PORT_PCR8_IRQC_0000 = 0x0
	// ISF flag and DMA request on rising edge.
	PORT_PCR8_IRQC_0001 = 0x1
	// ISF flag and DMA request on falling edge.
	PORT_PCR8_IRQC_0010 = 0x2
	// ISF flag and DMA request on either edge.
	PORT_PCR8_IRQC_0011 = 0x3
	// ISF flag and Interrupt when logic 0.
	PORT_PCR8_IRQC_1000 = 0x8
	// ISF flag and Interrupt on rising-edge.
	PORT_PCR8_IRQC_1001 = 0x9
	// ISF flag and Interrupt on falling-edge.
	PORT_PCR8_IRQC_1010 = 0xa
	// ISF flag and Interrupt on either edge.
	PORT_PCR8_IRQC_1011 = 0xb
	// ISF flag and Interrupt when logic 1.
	PORT_PCR8_IRQC_1100 = 0xc
	// Position of ISF field.
	PORT_PCR8_ISF_Pos = 0x18
	// Bit mask of ISF field.
	PORT_PCR8_ISF_Msk = 0x1000000
	// Bit ISF.
	PORT_PCR8_ISF = 0x1000000
	// Configured interrupt is not detected.
	PORT_PCR8_ISF_0 = 0x0
	// Configured interrupt is detected. If the pin is configured to generate a DMA request, then the corresponding flag will be cleared automatically at the completion of the requested DMA transfer. Otherwise, the flag remains set until a logic 1 is written to the flag. If the pin is configured for a level sensitive interrupt and the pin remains asserted, then the flag is set again immediately after it is cleared.
	PORT_PCR8_ISF_1 = 0x1

	// PCR9: Pin Control Register n
	// Position of PS field.
	PORT_PCR9_PS_Pos = 0x0
	// Bit mask of PS field.
	PORT_PCR9_PS_Msk = 0x1
	// Bit PS.
	PORT_PCR9_PS = 0x1
	// Internal pulldown resistor is enabled on the corresponding pin, if the corresponding PE field is set.
	PORT_PCR9_PS_0 = 0x0
	// Internal pullup resistor is enabled on the corresponding pin, if the corresponding PE field is set.
	PORT_PCR9_PS_1 = 0x1
	// Position of PE field.
	PORT_PCR9_PE_Pos = 0x1
	// Bit mask of PE field.
	PORT_PCR9_PE_Msk = 0x2
	// Bit PE.
	PORT_PCR9_PE = 0x2
	// Internal pullup or pulldown resistor is not enabled on the corresponding pin.
	PORT_PCR9_PE_0 = 0x0
	// Internal pullup or pulldown resistor is enabled on the corresponding pin, if the pin is configured as a digital input.
	PORT_PCR9_PE_1 = 0x1
	// Position of SRE field.
	PORT_PCR9_SRE_Pos = 0x2
	// Bit mask of SRE field.
	PORT_PCR9_SRE_Msk = 0x4
	// Bit SRE.
	PORT_PCR9_SRE = 0x4
	// Fast slew rate is configured on the corresponding pin, if the pin is configured as a digital output.
	PORT_PCR9_SRE_0 = 0x0
	// Slow slew rate is configured on the corresponding pin, if the pin is configured as a digital output.
	PORT_PCR9_SRE_1 = 0x1
	// Position of PFE field.
	PORT_PCR9_PFE_Pos = 0x4
	// Bit mask of PFE field.
	PORT_PCR9_PFE_Msk = 0x10
	// Bit PFE.
	PORT_PCR9_PFE = 0x10
	// Passive input filter is disabled on the corresponding pin.
	PORT_PCR9_PFE_0 = 0x0
	// Passive input filter is enabled on the corresponding pin, if the pin is configured as a digital input. Refer to the device data sheet for filter characteristics.
	PORT_PCR9_PFE_1 = 0x1
	// Position of DSE field.
	PORT_PCR9_DSE_Pos = 0x6
	// Bit mask of DSE field.
	PORT_PCR9_DSE_Msk = 0x40
	// Bit DSE.
	PORT_PCR9_DSE = 0x40
	// Low drive strength is configured on the corresponding pin, if pin is configured as a digital output.
	PORT_PCR9_DSE_0 = 0x0
	// High drive strength is configured on the corresponding pin, if pin is configured as a digital output.
	PORT_PCR9_DSE_1 = 0x1
	// Position of MUX field.
	PORT_PCR9_MUX_Pos = 0x8
	// Bit mask of MUX field.
	PORT_PCR9_MUX_Msk = 0x700
	// Pin disabled (Alternative 0) (analog).
	PORT_PCR9_MUX_000 = 0x0
	// Alternative 1 (GPIO).
	PORT_PCR9_MUX_001 = 0x1
	// Alternative 2 (chip-specific).
	PORT_PCR9_MUX_010 = 0x2
	// Alternative 3 (chip-specific).
	PORT_PCR9_MUX_011 = 0x3
	// Alternative 4 (chip-specific).
	PORT_PCR9_MUX_100 = 0x4
	// Alternative 5 (chip-specific).
	PORT_PCR9_MUX_101 = 0x5
	// Alternative 6 (chip-specific).
	PORT_PCR9_MUX_110 = 0x6
	// Alternative 7 (chip-specific).
	PORT_PCR9_MUX_111 = 0x7
	// Position of IRQC field.
	PORT_PCR9_IRQC_Pos = 0x10
	// Bit mask of IRQC field.
	PORT_PCR9_IRQC_Msk = 0xf0000
	// Interrupt Status Flag (ISF) is disabled.
	PORT_PCR9_IRQC_0000 = 0x0
	// ISF flag and DMA request on rising edge.
	PORT_PCR9_IRQC_0001 = 0x1
	// ISF flag and DMA request on falling edge.
	PORT_PCR9_IRQC_0010 = 0x2
	// ISF flag and DMA request on either edge.
	PORT_PCR9_IRQC_0011 = 0x3
	// ISF flag and Interrupt when logic 0.
	PORT_PCR9_IRQC_1000 = 0x8
	// ISF flag and Interrupt on rising-edge.
	PORT_PCR9_IRQC_1001 = 0x9
	// ISF flag and Interrupt on falling-edge.
	PORT_PCR9_IRQC_1010 = 0xa
	// ISF flag and Interrupt on either edge.
	PORT_PCR9_IRQC_1011 = 0xb
	// ISF flag and Interrupt when logic 1.
	PORT_PCR9_IRQC_1100 = 0xc
	// Position of ISF field.
	PORT_PCR9_ISF_Pos = 0x18
	// Bit mask of ISF field.
	PORT_PCR9_ISF_Msk = 0x1000000
	// Bit ISF.
	PORT_PCR9_ISF = 0x1000000
	// Configured interrupt is not detected.
	PORT_PCR9_ISF_0 = 0x0
	// Configured interrupt is detected. If the pin is configured to generate a DMA request, then the corresponding flag will be cleared automatically at the completion of the requested DMA transfer. Otherwise, the flag remains set until a logic 1 is written to the flag. If the pin is configured for a level sensitive interrupt and the pin remains asserted, then the flag is set again immediately after it is cleared.
	PORT_PCR9_ISF_1 = 0x1

	// PCR10: Pin Control Register n
	// Position of PS field.
	PORT_PCR10_PS_Pos = 0x0
	// Bit mask of PS field.
	PORT_PCR10_PS_Msk = 0x1
	// Bit PS.
	PORT_PCR10_PS = 0x1
	// Internal pulldown resistor is enabled on the corresponding pin, if the corresponding PE field is set.
	PORT_PCR10_PS_0 = 0x0
	// Internal pullup resistor is enabled on the corresponding pin, if the corresponding PE field is set.
	PORT_PCR10_PS_1 = 0x1
	// Position of PE field.
	PORT_PCR10_PE_Pos = 0x1
	// Bit mask of PE field.
	PORT_PCR10_PE_Msk = 0x2
	// Bit PE.
	PORT_PCR10_PE = 0x2
	// Internal pullup or pulldown resistor is not enabled on the corresponding pin.
	PORT_PCR10_PE_0 = 0x0
	// Internal pullup or pulldown resistor is enabled on the corresponding pin, if the pin is configured as a digital input.
	PORT_PCR10_PE_1 = 0x1
	// Position of SRE field.
	PORT_PCR10_SRE_Pos = 0x2
	// Bit mask of SRE field.
	PORT_PCR10_SRE_Msk = 0x4
	// Bit SRE.
	PORT_PCR10_SRE = 0x4
	// Fast slew rate is configured on the corresponding pin, if the pin is configured as a digital output.
	PORT_PCR10_SRE_0 = 0x0
	// Slow slew rate is configured on the corresponding pin, if the pin is configured as a digital output.
	PORT_PCR10_SRE_1 = 0x1
	// Position of PFE field.
	PORT_PCR10_PFE_Pos = 0x4
	// Bit mask of PFE field.
	PORT_PCR10_PFE_Msk = 0x10
	// Bit PFE.
	PORT_PCR10_PFE = 0x10
	// Passive input filter is disabled on the corresponding pin.
	PORT_PCR10_PFE_0 = 0x0
	// Passive input filter is enabled on the corresponding pin, if the pin is configured as a digital input. Refer to the device data sheet for filter characteristics.
	PORT_PCR10_PFE_1 = 0x1
	// Position of DSE field.
	PORT_PCR10_DSE_Pos = 0x6
	// Bit mask of DSE field.
	PORT_PCR10_DSE_Msk = 0x40
	// Bit DSE.
	PORT_PCR10_DSE = 0x40
	// Low drive strength is configured on the corresponding pin, if pin is configured as a digital output.
	PORT_PCR10_DSE_0 = 0x0
	// High drive strength is configured on the corresponding pin, if pin is configured as a digital output.
	PORT_PCR10_DSE_1 = 0x1
	// Position of MUX field.
	PORT_PCR10_MUX_Pos = 0x8
	// Bit mask of MUX field.
	PORT_PCR10_MUX_Msk = 0x700
	// Pin disabled (Alternative 0) (analog).
	PORT_PCR10_MUX_000 = 0x0
	// Alternative 1 (GPIO).
	PORT_PCR10_MUX_001 = 0x1
	// Alternative 2 (chip-specific).
	PORT_PCR10_MUX_010 = 0x2
	// Alternative 3 (chip-specific).
	PORT_PCR10_MUX_011 = 0x3
	// Alternative 4 (chip-specific).
	PORT_PCR10_MUX_100 = 0x4
	// Alternative 5 (chip-specific).
	PORT_PCR10_MUX_101 = 0x5
	// Alternative 6 (chip-specific).
	PORT_PCR10_MUX_110 = 0x6
	// Alternative 7 (chip-specific).
	PORT_PCR10_MUX_111 = 0x7
	// Position of IRQC field.
	PORT_PCR10_IRQC_Pos = 0x10
	// Bit mask of IRQC field.
	PORT_PCR10_IRQC_Msk = 0xf0000
	// Interrupt Status Flag (ISF) is disabled.
	PORT_PCR10_IRQC_0000 = 0x0
	// ISF flag and DMA request on rising edge.
	PORT_PCR10_IRQC_0001 = 0x1
	// ISF flag and DMA request on falling edge.
	PORT_PCR10_IRQC_0010 = 0x2
	// ISF flag and DMA request on either edge.
	PORT_PCR10_IRQC_0011 = 0x3
	// ISF flag and Interrupt when logic 0.
	PORT_PCR10_IRQC_1000 = 0x8
	// ISF flag and Interrupt on rising-edge.
	PORT_PCR10_IRQC_1001 = 0x9
	// ISF flag and Interrupt on falling-edge.
	PORT_PCR10_IRQC_1010 = 0xa
	// ISF flag and Interrupt on either edge.
	PORT_PCR10_IRQC_1011 = 0xb
	// ISF flag and Interrupt when logic 1.
	PORT_PCR10_IRQC_1100 = 0xc
	// Position of ISF field.
	PORT_PCR10_ISF_Pos = 0x18
	// Bit mask of ISF field.
	PORT_PCR10_ISF_Msk = 0x1000000
	// Bit ISF.
	PORT_PCR10_ISF = 0x1000000
	// Configured interrupt is not detected.
	PORT_PCR10_ISF_0 = 0x0
	// Configured interrupt is detected. If the pin is configured to generate a DMA request, then the corresponding flag will be cleared automatically at the completion of the requested DMA transfer. Otherwise, the flag remains set until a logic 1 is written to the flag. If the pin is configured for a level sensitive interrupt and the pin remains asserted, then the flag is set again immediately after it is cleared.
	PORT_PCR10_ISF_1 = 0x1

	// PCR11: Pin Control Register n
	// Position of PS field.
	PORT_PCR11_PS_Pos = 0x0
	// Bit mask of PS field.
	PORT_PCR11_PS_Msk = 0x1
	// Bit PS.
	PORT_PCR11_PS = 0x1
	// Internal pulldown resistor is enabled on the corresponding pin, if the corresponding PE field is set.
	PORT_PCR11_PS_0 = 0x0
	// Internal pullup resistor is enabled on the corresponding pin, if the corresponding PE field is set.
	PORT_PCR11_PS_1 = 0x1
	// Position of PE field.
	PORT_PCR11_PE_Pos = 0x1
	// Bit mask of PE field.
	PORT_PCR11_PE_Msk = 0x2
	// Bit PE.
	PORT_PCR11_PE = 0x2
	// Internal pullup or pulldown resistor is not enabled on the corresponding pin.
	PORT_PCR11_PE_0 = 0x0
	// Internal pullup or pulldown resistor is enabled on the corresponding pin, if the pin is configured as a digital input.
	PORT_PCR11_PE_1 = 0x1
	// Position of SRE field.
	PORT_PCR11_SRE_Pos = 0x2
	// Bit mask of SRE field.
	PORT_PCR11_SRE_Msk = 0x4
	// Bit SRE.
	PORT_PCR11_SRE = 0x4
	// Fast slew rate is configured on the corresponding pin, if the pin is configured as a digital output.
	PORT_PCR11_SRE_0 = 0x0
	// Slow slew rate is configured on the corresponding pin, if the pin is configured as a digital output.
	PORT_PCR11_SRE_1 = 0x1
	// Position of PFE field.
	PORT_PCR11_PFE_Pos = 0x4
	// Bit mask of PFE field.
	PORT_PCR11_PFE_Msk = 0x10
	// Bit PFE.
	PORT_PCR11_PFE = 0x10
	// Passive input filter is disabled on the corresponding pin.
	PORT_PCR11_PFE_0 = 0x0
	// Passive input filter is enabled on the corresponding pin, if the pin is configured as a digital input. Refer to the device data sheet for filter characteristics.
	PORT_PCR11_PFE_1 = 0x1
	// Position of DSE field.
	PORT_PCR11_DSE_Pos = 0x6
	// Bit mask of DSE field.
	PORT_PCR11_DSE_Msk = 0x40
	// Bit DSE.
	PORT_PCR11_DSE = 0x40
	// Low drive strength is configured on the corresponding pin, if pin is configured as a digital output.
	PORT_PCR11_DSE_0 = 0x0
	// High drive strength is configured on the corresponding pin, if pin is configured as a digital output.
	PORT_PCR11_DSE_1 = 0x1
	// Position of MUX field.
	PORT_PCR11_MUX_Pos = 0x8
	// Bit mask of MUX field.
	PORT_PCR11_MUX_Msk = 0x700
	// Pin disabled (Alternative 0) (analog).
	PORT_PCR11_MUX_000 = 0x0
	// Alternative 1 (GPIO).
	PORT_PCR11_MUX_001 = 0x1
	// Alternative 2 (chip-specific).
	PORT_PCR11_MUX_010 = 0x2
	// Alternative 3 (chip-specific).
	PORT_PCR11_MUX_011 = 0x3
	// Alternative 4 (chip-specific).
	PORT_PCR11_MUX_100 = 0x4
	// Alternative 5 (chip-specific).
	PORT_PCR11_MUX_101 = 0x5
	// Alternative 6 (chip-specific).
	PORT_PCR11_MUX_110 = 0x6
	// Alternative 7 (chip-specific).
	PORT_PCR11_MUX_111 = 0x7
	// Position of IRQC field.
	PORT_PCR11_IRQC_Pos = 0x10
	// Bit mask of IRQC field.
	PORT_PCR11_IRQC_Msk = 0xf0000
	// Interrupt Status Flag (ISF) is disabled.
	PORT_PCR11_IRQC_0000 = 0x0
	// ISF flag and DMA request on rising edge.
	PORT_PCR11_IRQC_0001 = 0x1
	// ISF flag and DMA request on falling edge.
	PORT_PCR11_IRQC_0010 = 0x2
	// ISF flag and DMA request on either edge.
	PORT_PCR11_IRQC_0011 = 0x3
	// ISF flag and Interrupt when logic 0.
	PORT_PCR11_IRQC_1000 = 0x8
	// ISF flag and Interrupt on rising-edge.
	PORT_PCR11_IRQC_1001 = 0x9
	// ISF flag and Interrupt on falling-edge.
	PORT_PCR11_IRQC_1010 = 0xa
	// ISF flag and Interrupt on either edge.
	PORT_PCR11_IRQC_1011 = 0xb
	// ISF flag and Interrupt when logic 1.
	PORT_PCR11_IRQC_1100 = 0xc
	// Position of ISF field.
	PORT_PCR11_ISF_Pos = 0x18
	// Bit mask of ISF field.
	PORT_PCR11_ISF_Msk = 0x1000000
	// Bit ISF.
	PORT_PCR11_ISF = 0x1000000
	// Configured interrupt is not detected.
	PORT_PCR11_ISF_0 = 0x0
	// Configured interrupt is detected. If the pin is configured to generate a DMA request, then the corresponding flag will be cleared automatically at the completion of the requested DMA transfer. Otherwise, the flag remains set until a logic 1 is written to the flag. If the pin is configured for a level sensitive interrupt and the pin remains asserted, then the flag is set again immediately after it is cleared.
	PORT_PCR11_ISF_1 = 0x1

	// PCR12: Pin Control Register n
	// Position of PS field.
	PORT_PCR12_PS_Pos = 0x0
	// Bit mask of PS field.
	PORT_PCR12_PS_Msk = 0x1
	// Bit PS.
	PORT_PCR12_PS = 0x1
	// Internal pulldown resistor is enabled on the corresponding pin, if the corresponding PE field is set.
	PORT_PCR12_PS_0 = 0x0
	// Internal pullup resistor is enabled on the corresponding pin, if the corresponding PE field is set.
	PORT_PCR12_PS_1 = 0x1
	// Position of PE field.
	PORT_PCR12_PE_Pos = 0x1
	// Bit mask of PE field.
	PORT_PCR12_PE_Msk = 0x2
	// Bit PE.
	PORT_PCR12_PE = 0x2
	// Internal pullup or pulldown resistor is not enabled on the corresponding pin.
	PORT_PCR12_PE_0 = 0x0
	// Internal pullup or pulldown resistor is enabled on the corresponding pin, if the pin is configured as a digital input.
	PORT_PCR12_PE_1 = 0x1
	// Position of SRE field.
	PORT_PCR12_SRE_Pos = 0x2
	// Bit mask of SRE field.
	PORT_PCR12_SRE_Msk = 0x4
	// Bit SRE.
	PORT_PCR12_SRE = 0x4
	// Fast slew rate is configured on the corresponding pin, if the pin is configured as a digital output.
	PORT_PCR12_SRE_0 = 0x0
	// Slow slew rate is configured on the corresponding pin, if the pin is configured as a digital output.
	PORT_PCR12_SRE_1 = 0x1
	// Position of PFE field.
	PORT_PCR12_PFE_Pos = 0x4
	// Bit mask of PFE field.
	PORT_PCR12_PFE_Msk = 0x10
	// Bit PFE.
	PORT_PCR12_PFE = 0x10
	// Passive input filter is disabled on the corresponding pin.
	PORT_PCR12_PFE_0 = 0x0
	// Passive input filter is enabled on the corresponding pin, if the pin is configured as a digital input. Refer to the device data sheet for filter characteristics.
	PORT_PCR12_PFE_1 = 0x1
	// Position of DSE field.
	PORT_PCR12_DSE_Pos = 0x6
	// Bit mask of DSE field.
	PORT_PCR12_DSE_Msk = 0x40
	// Bit DSE.
	PORT_PCR12_DSE = 0x40
	// Low drive strength is configured on the corresponding pin, if pin is configured as a digital output.
	PORT_PCR12_DSE_0 = 0x0
	// High drive strength is configured on the corresponding pin, if pin is configured as a digital output.
	PORT_PCR12_DSE_1 = 0x1
	// Position of MUX field.
	PORT_PCR12_MUX_Pos = 0x8
	// Bit mask of MUX field.
	PORT_PCR12_MUX_Msk = 0x700
	// Pin disabled (Alternative 0) (analog).
	PORT_PCR12_MUX_000 = 0x0
	// Alternative 1 (GPIO).
	PORT_PCR12_MUX_001 = 0x1
	// Alternative 2 (chip-specific).
	PORT_PCR12_MUX_010 = 0x2
	// Alternative 3 (chip-specific).
	PORT_PCR12_MUX_011 = 0x3
	// Alternative 4 (chip-specific).
	PORT_PCR12_MUX_100 = 0x4
	// Alternative 5 (chip-specific).
	PORT_PCR12_MUX_101 = 0x5
	// Alternative 6 (chip-specific).
	PORT_PCR12_MUX_110 = 0x6
	// Alternative 7 (chip-specific).
	PORT_PCR12_MUX_111 = 0x7
	// Position of IRQC field.
	PORT_PCR12_IRQC_Pos = 0x10
	// Bit mask of IRQC field.
	PORT_PCR12_IRQC_Msk = 0xf0000
	// Interrupt Status Flag (ISF) is disabled.
	PORT_PCR12_IRQC_0000 = 0x0
	// ISF flag and DMA request on rising edge.
	PORT_PCR12_IRQC_0001 = 0x1
	// ISF flag and DMA request on falling edge.
	PORT_PCR12_IRQC_0010 = 0x2
	// ISF flag and DMA request on either edge.
	PORT_PCR12_IRQC_0011 = 0x3
	// ISF flag and Interrupt when logic 0.
	PORT_PCR12_IRQC_1000 = 0x8
	// ISF flag and Interrupt on rising-edge.
	PORT_PCR12_IRQC_1001 = 0x9
	// ISF flag and Interrupt on falling-edge.
	PORT_PCR12_IRQC_1010 = 0xa
	// ISF flag and Interrupt on either edge.
	PORT_PCR12_IRQC_1011 = 0xb
	// ISF flag and Interrupt when logic 1.
	PORT_PCR12_IRQC_1100 = 0xc
	// Position of ISF field.
	PORT_PCR12_ISF_Pos = 0x18
	// Bit mask of ISF field.
	PORT_PCR12_ISF_Msk = 0x1000000
	// Bit ISF.
	PORT_PCR12_ISF = 0x1000000
	// Configured interrupt is not detected.
	PORT_PCR12_ISF_0 = 0x0
	// Configured interrupt is detected. If the pin is configured to generate a DMA request, then the corresponding flag will be cleared automatically at the completion of the requested DMA transfer. Otherwise, the flag remains set until a logic 1 is written to the flag. If the pin is configured for a level sensitive interrupt and the pin remains asserted, then the flag is set again immediately after it is cleared.
	PORT_PCR12_ISF_1 = 0x1

	// PCR13: Pin Control Register n
	// Position of PS field.
	PORT_PCR13_PS_Pos = 0x0
	// Bit mask of PS field.
	PORT_PCR13_PS_Msk = 0x1
	// Bit PS.
	PORT_PCR13_PS = 0x1
	// Internal pulldown resistor is enabled on the corresponding pin, if the corresponding PE field is set.
	PORT_PCR13_PS_0 = 0x0
	// Internal pullup resistor is enabled on the corresponding pin, if the corresponding PE field is set.
	PORT_PCR13_PS_1 = 0x1
	// Position of PE field.
	PORT_PCR13_PE_Pos = 0x1
	// Bit mask of PE field.
	PORT_PCR13_PE_Msk = 0x2
	// Bit PE.
	PORT_PCR13_PE = 0x2
	// Internal pullup or pulldown resistor is not enabled on the corresponding pin.
	PORT_PCR13_PE_0 = 0x0
	// Internal pullup or pulldown resistor is enabled on the corresponding pin, if the pin is configured as a digital input.
	PORT_PCR13_PE_1 = 0x1
	// Position of SRE field.
	PORT_PCR13_SRE_Pos = 0x2
	// Bit mask of SRE field.
	PORT_PCR13_SRE_Msk = 0x4
	// Bit SRE.
	PORT_PCR13_SRE = 0x4
	// Fast slew rate is configured on the corresponding pin, if the pin is configured as a digital output.
	PORT_PCR13_SRE_0 = 0x0
	// Slow slew rate is configured on the corresponding pin, if the pin is configured as a digital output.
	PORT_PCR13_SRE_1 = 0x1
	// Position of PFE field.
	PORT_PCR13_PFE_Pos = 0x4
	// Bit mask of PFE field.
	PORT_PCR13_PFE_Msk = 0x10
	// Bit PFE.
	PORT_PCR13_PFE = 0x10
	// Passive input filter is disabled on the corresponding pin.
	PORT_PCR13_PFE_0 = 0x0
	// Passive input filter is enabled on the corresponding pin, if the pin is configured as a digital input. Refer to the device data sheet for filter characteristics.
	PORT_PCR13_PFE_1 = 0x1
	// Position of DSE field.
	PORT_PCR13_DSE_Pos = 0x6
	// Bit mask of DSE field.
	PORT_PCR13_DSE_Msk = 0x40
	// Bit DSE.
	PORT_PCR13_DSE = 0x40
	// Low drive strength is configured on the corresponding pin, if pin is configured as a digital output.
	PORT_PCR13_DSE_0 = 0x0
	// High drive strength is configured on the corresponding pin, if pin is configured as a digital output.
	PORT_PCR13_DSE_1 = 0x1
	// Position of MUX field.
	PORT_PCR13_MUX_Pos = 0x8
	// Bit mask of MUX field.
	PORT_PCR13_MUX_Msk = 0x700
	// Pin disabled (Alternative 0) (analog).
	PORT_PCR13_MUX_000 = 0x0
	// Alternative 1 (GPIO).
	PORT_PCR13_MUX_001 = 0x1
	// Alternative 2 (chip-specific).
	PORT_PCR13_MUX_010 = 0x2
	// Alternative 3 (chip-specific).
	PORT_PCR13_MUX_011 = 0x3
	// Alternative 4 (chip-specific).
	PORT_PCR13_MUX_100 = 0x4
	// Alternative 5 (chip-specific).
	PORT_PCR13_MUX_101 = 0x5
	// Alternative 6 (chip-specific).
	PORT_PCR13_MUX_110 = 0x6
	// Alternative 7 (chip-specific).
	PORT_PCR13_MUX_111 = 0x7
	// Position of IRQC field.
	PORT_PCR13_IRQC_Pos = 0x10
	// Bit mask of IRQC field.
	PORT_PCR13_IRQC_Msk = 0xf0000
	// Interrupt Status Flag (ISF) is disabled.
	PORT_PCR13_IRQC_0000 = 0x0
	// ISF flag and DMA request on rising edge.
	PORT_PCR13_IRQC_0001 = 0x1
	// ISF flag and DMA request on falling edge.
	PORT_PCR13_IRQC_0010 = 0x2
	// ISF flag and DMA request on either edge.
	PORT_PCR13_IRQC_0011 = 0x3
	// ISF flag and Interrupt when logic 0.
	PORT_PCR13_IRQC_1000 = 0x8
	// ISF flag and Interrupt on rising-edge.
	PORT_PCR13_IRQC_1001 = 0x9
	// ISF flag and Interrupt on falling-edge.
	PORT_PCR13_IRQC_1010 = 0xa
	// ISF flag and Interrupt on either edge.
	PORT_PCR13_IRQC_1011 = 0xb
	// ISF flag and Interrupt when logic 1.
	PORT_PCR13_IRQC_1100 = 0xc
	// Position of ISF field.
	PORT_PCR13_ISF_Pos = 0x18
	// Bit mask of ISF field.
	PORT_PCR13_ISF_Msk = 0x1000000
	// Bit ISF.
	PORT_PCR13_ISF = 0x1000000
	// Configured interrupt is not detected.
	PORT_PCR13_ISF_0 = 0x0
	// Configured interrupt is detected. If the pin is configured to generate a DMA request, then the corresponding flag will be cleared automatically at the completion of the requested DMA transfer. Otherwise, the flag remains set until a logic 1 is written to the flag. If the pin is configured for a level sensitive interrupt and the pin remains asserted, then the flag is set again immediately after it is cleared.
	PORT_PCR13_ISF_1 = 0x1

	// PCR14: Pin Control Register n
	// Position of PS field.
	PORT_PCR14_PS_Pos = 0x0
	// Bit mask of PS field.
	PORT_PCR14_PS_Msk = 0x1
	// Bit PS.
	PORT_PCR14_PS = 0x1
	// Internal pulldown resistor is enabled on the corresponding pin, if the corresponding PE field is set.
	PORT_PCR14_PS_0 = 0x0
	// Internal pullup resistor is enabled on the corresponding pin, if the corresponding PE field is set.
	PORT_PCR14_PS_1 = 0x1
	// Position of PE field.
	PORT_PCR14_PE_Pos = 0x1
	// Bit mask of PE field.
	PORT_PCR14_PE_Msk = 0x2
	// Bit PE.
	PORT_PCR14_PE = 0x2
	// Internal pullup or pulldown resistor is not enabled on the corresponding pin.
	PORT_PCR14_PE_0 = 0x0
	// Internal pullup or pulldown resistor is enabled on the corresponding pin, if the pin is configured as a digital input.
	PORT_PCR14_PE_1 = 0x1
	// Position of SRE field.
	PORT_PCR14_SRE_Pos = 0x2
	// Bit mask of SRE field.
	PORT_PCR14_SRE_Msk = 0x4
	// Bit SRE.
	PORT_PCR14_SRE = 0x4
	// Fast slew rate is configured on the corresponding pin, if the pin is configured as a digital output.
	PORT_PCR14_SRE_0 = 0x0
	// Slow slew rate is configured on the corresponding pin, if the pin is configured as a digital output.
	PORT_PCR14_SRE_1 = 0x1
	// Position of PFE field.
	PORT_PCR14_PFE_Pos = 0x4
	// Bit mask of PFE field.
	PORT_PCR14_PFE_Msk = 0x10
	// Bit PFE.
	PORT_PCR14_PFE = 0x10
	// Passive input filter is disabled on the corresponding pin.
	PORT_PCR14_PFE_0 = 0x0
	// Passive input filter is enabled on the corresponding pin, if the pin is configured as a digital input. Refer to the device data sheet for filter characteristics.
	PORT_PCR14_PFE_1 = 0x1
	// Position of DSE field.
	PORT_PCR14_DSE_Pos = 0x6
	// Bit mask of DSE field.
	PORT_PCR14_DSE_Msk = 0x40
	// Bit DSE.
	PORT_PCR14_DSE = 0x40
	// Low drive strength is configured on the corresponding pin, if pin is configured as a digital output.
	PORT_PCR14_DSE_0 = 0x0
	// High drive strength is configured on the corresponding pin, if pin is configured as a digital output.
	PORT_PCR14_DSE_1 = 0x1
	// Position of MUX field.
	PORT_PCR14_MUX_Pos = 0x8
	// Bit mask of MUX field.
	PORT_PCR14_MUX_Msk = 0x700
	// Pin disabled (Alternative 0) (analog).
	PORT_PCR14_MUX_000 = 0x0
	// Alternative 1 (GPIO).
	PORT_PCR14_MUX_001 = 0x1
	// Alternative 2 (chip-specific).
	PORT_PCR14_MUX_010 = 0x2
	// Alternative 3 (chip-specific).
	PORT_PCR14_MUX_011 = 0x3
	// Alternative 4 (chip-specific).
	PORT_PCR14_MUX_100 = 0x4
	// Alternative 5 (chip-specific).
	PORT_PCR14_MUX_101 = 0x5
	// Alternative 6 (chip-specific).
	PORT_PCR14_MUX_110 = 0x6
	// Alternative 7 (chip-specific).
	PORT_PCR14_MUX_111 = 0x7
	// Position of IRQC field.
	PORT_PCR14_IRQC_Pos = 0x10
	// Bit mask of IRQC field.
	PORT_PCR14_IRQC_Msk = 0xf0000
	// Interrupt Status Flag (ISF) is disabled.
	PORT_PCR14_IRQC_0000 = 0x0
	// ISF flag and DMA request on rising edge.
	PORT_PCR14_IRQC_0001 = 0x1
	// ISF flag and DMA request on falling edge.
	PORT_PCR14_IRQC_0010 = 0x2
	// ISF flag and DMA request on either edge.
	PORT_PCR14_IRQC_0011 = 0x3
	// ISF flag and Interrupt when logic 0.
	PORT_PCR14_IRQC_1000 = 0x8
	// ISF flag and Interrupt on rising-edge.
	PORT_PCR14_IRQC_1001 = 0x9
	// ISF flag and Interrupt on falling-edge.
	PORT_PCR14_IRQC_1010 = 0xa
	// ISF flag and Interrupt on either edge.
	PORT_PCR14_IRQC_1011 = 0xb
	// ISF flag and Interrupt when logic 1.
	PORT_PCR14_IRQC_1100 = 0xc
	// Position of ISF field.
	PORT_PCR14_ISF_Pos = 0x18
	// Bit mask of ISF field.
	PORT_PCR14_ISF_Msk = 0x1000000
	// Bit ISF.
	PORT_PCR14_ISF = 0x1000000
	// Configured interrupt is not detected.
	PORT_PCR14_ISF_0 = 0x0
	// Configured interrupt is detected. If the pin is configured to generate a DMA request, then the corresponding flag will be cleared automatically at the completion of the requested DMA transfer. Otherwise, the flag remains set until a logic 1 is written to the flag. If the pin is configured for a level sensitive interrupt and the pin remains asserted, then the flag is set again immediately after it is cleared.
	PORT_PCR14_ISF_1 = 0x1

	// PCR15: Pin Control Register n
	// Position of PS field.
	PORT_PCR15_PS_Pos = 0x0
	// Bit mask of PS field.
	PORT_PCR15_PS_Msk = 0x1
	// Bit PS.
	PORT_PCR15_PS = 0x1
	// Internal pulldown resistor is enabled on the corresponding pin, if the corresponding PE field is set.
	PORT_PCR15_PS_0 = 0x0
	// Internal pullup resistor is enabled on the corresponding pin, if the corresponding PE field is set.
	PORT_PCR15_PS_1 = 0x1
	// Position of PE field.
	PORT_PCR15_PE_Pos = 0x1
	// Bit mask of PE field.
	PORT_PCR15_PE_Msk = 0x2
	// Bit PE.
	PORT_PCR15_PE = 0x2
	// Internal pullup or pulldown resistor is not enabled on the corresponding pin.
	PORT_PCR15_PE_0 = 0x0
	// Internal pullup or pulldown resistor is enabled on the corresponding pin, if the pin is configured as a digital input.
	PORT_PCR15_PE_1 = 0x1
	// Position of SRE field.
	PORT_PCR15_SRE_Pos = 0x2
	// Bit mask of SRE field.
	PORT_PCR15_SRE_Msk = 0x4
	// Bit SRE.
	PORT_PCR15_SRE = 0x4
	// Fast slew rate is configured on the corresponding pin, if the pin is configured as a digital output.
	PORT_PCR15_SRE_0 = 0x0
	// Slow slew rate is configured on the corresponding pin, if the pin is configured as a digital output.
	PORT_PCR15_SRE_1 = 0x1
	// Position of PFE field.
	PORT_PCR15_PFE_Pos = 0x4
	// Bit mask of PFE field.
	PORT_PCR15_PFE_Msk = 0x10
	// Bit PFE.
	PORT_PCR15_PFE = 0x10
	// Passive input filter is disabled on the corresponding pin.
	PORT_PCR15_PFE_0 = 0x0
	// Passive input filter is enabled on the corresponding pin, if the pin is configured as a digital input. Refer to the device data sheet for filter characteristics.
	PORT_PCR15_PFE_1 = 0x1
	// Position of DSE field.
	PORT_PCR15_DSE_Pos = 0x6
	// Bit mask of DSE field.
	PORT_PCR15_DSE_Msk = 0x40
	// Bit DSE.
	PORT_PCR15_DSE = 0x40
	// Low drive strength is configured on the corresponding pin, if pin is configured as a digital output.
	PORT_PCR15_DSE_0 = 0x0
	// High drive strength is configured on the corresponding pin, if pin is configured as a digital output.
	PORT_PCR15_DSE_1 = 0x1
	// Position of MUX field.
	PORT_PCR15_MUX_Pos = 0x8
	// Bit mask of MUX field.
	PORT_PCR15_MUX_Msk = 0x700
	// Pin disabled (Alternative 0) (analog).
	PORT_PCR15_MUX_000 = 0x0
	// Alternative 1 (GPIO).
	PORT_PCR15_MUX_001 = 0x1
	// Alternative 2 (chip-specific).
	PORT_PCR15_MUX_010 = 0x2
	// Alternative 3 (chip-specific).
	PORT_PCR15_MUX_011 = 0x3
	// Alternative 4 (chip-specific).
	PORT_PCR15_MUX_100 = 0x4
	// Alternative 5 (chip-specific).
	PORT_PCR15_MUX_101 = 0x5
	// Alternative 6 (chip-specific).
	PORT_PCR15_MUX_110 = 0x6
	// Alternative 7 (chip-specific).
	PORT_PCR15_MUX_111 = 0x7
	// Position of IRQC field.
	PORT_PCR15_IRQC_Pos = 0x10
	// Bit mask of IRQC field.
	PORT_PCR15_IRQC_Msk = 0xf0000
	// Interrupt Status Flag (ISF) is disabled.
	PORT_PCR15_IRQC_0000 = 0x0
	// ISF flag and DMA request on rising edge.
	PORT_PCR15_IRQC_0001 = 0x1
	// ISF flag and DMA request on falling edge.
	PORT_PCR15_IRQC_0010 = 0x2
	// ISF flag and DMA request on either edge.
	PORT_PCR15_IRQC_0011 = 0x3
	// ISF flag and Interrupt when logic 0.
	PORT_PCR15_IRQC_1000 = 0x8
	// ISF flag and Interrupt on rising-edge.
	PORT_PCR15_IRQC_1001 = 0x9
	// ISF flag and Interrupt on falling-edge.
	PORT_PCR15_IRQC_1010 = 0xa
	// ISF flag and Interrupt on either edge.
	PORT_PCR15_IRQC_1011 = 0xb
	// ISF flag and Interrupt when logic 1.
	PORT_PCR15_IRQC_1100 = 0xc
	// Position of ISF field.
	PORT_PCR15_ISF_Pos = 0x18
	// Bit mask of ISF field.
	PORT_PCR15_ISF_Msk = 0x1000000
	// Bit ISF.
	PORT_PCR15_ISF = 0x1000000
	// Configured interrupt is not detected.
	PORT_PCR15_ISF_0 = 0x0
	// Configured interrupt is detected. If the pin is configured to generate a DMA request, then the corresponding flag will be cleared automatically at the completion of the requested DMA transfer. Otherwise, the flag remains set until a logic 1 is written to the flag. If the pin is configured for a level sensitive interrupt and the pin remains asserted, then the flag is set again immediately after it is cleared.
	PORT_PCR15_ISF_1 = 0x1

	// PCR16: Pin Control Register n
	// Position of PS field.
	PORT_PCR16_PS_Pos = 0x0
	// Bit mask of PS field.
	PORT_PCR16_PS_Msk = 0x1
	// Bit PS.
	PORT_PCR16_PS = 0x1
	// Internal pulldown resistor is enabled on the corresponding pin, if the corresponding PE field is set.
	PORT_PCR16_PS_0 = 0x0
	// Internal pullup resistor is enabled on the corresponding pin, if the corresponding PE field is set.
	PORT_PCR16_PS_1 = 0x1
	// Position of PE field.
	PORT_PCR16_PE_Pos = 0x1
	// Bit mask of PE field.
	PORT_PCR16_PE_Msk = 0x2
	// Bit PE.
	PORT_PCR16_PE = 0x2
	// Internal pullup or pulldown resistor is not enabled on the corresponding pin.
	PORT_PCR16_PE_0 = 0x0
	// Internal pullup or pulldown resistor is enabled on the corresponding pin, if the pin is configured as a digital input.
	PORT_PCR16_PE_1 = 0x1
	// Position of SRE field.
	PORT_PCR16_SRE_Pos = 0x2
	// Bit mask of SRE field.
	PORT_PCR16_SRE_Msk = 0x4
	// Bit SRE.
	PORT_PCR16_SRE = 0x4
	// Fast slew rate is configured on the corresponding pin, if the pin is configured as a digital output.
	PORT_PCR16_SRE_0 = 0x0
	// Slow slew rate is configured on the corresponding pin, if the pin is configured as a digital output.
	PORT_PCR16_SRE_1 = 0x1
	// Position of PFE field.
	PORT_PCR16_PFE_Pos = 0x4
	// Bit mask of PFE field.
	PORT_PCR16_PFE_Msk = 0x10
	// Bit PFE.
	PORT_PCR16_PFE = 0x10
	// Passive input filter is disabled on the corresponding pin.
	PORT_PCR16_PFE_0 = 0x0
	// Passive input filter is enabled on the corresponding pin, if the pin is configured as a digital input. Refer to the device data sheet for filter characteristics.
	PORT_PCR16_PFE_1 = 0x1
	// Position of DSE field.
	PORT_PCR16_DSE_Pos = 0x6
	// Bit mask of DSE field.
	PORT_PCR16_DSE_Msk = 0x40
	// Bit DSE.
	PORT_PCR16_DSE = 0x40
	// Low drive strength is configured on the corresponding pin, if pin is configured as a digital output.
	PORT_PCR16_DSE_0 = 0x0
	// High drive strength is configured on the corresponding pin, if pin is configured as a digital output.
	PORT_PCR16_DSE_1 = 0x1
	// Position of MUX field.
	PORT_PCR16_MUX_Pos = 0x8
	// Bit mask of MUX field.
	PORT_PCR16_MUX_Msk = 0x700
	// Pin disabled (Alternative 0) (analog).
	PORT_PCR16_MUX_000 = 0x0
	// Alternative 1 (GPIO).
	PORT_PCR16_MUX_001 = 0x1
	// Alternative 2 (chip-specific).
	PORT_PCR16_MUX_010 = 0x2
	// Alternative 3 (chip-specific).
	PORT_PCR16_MUX_011 = 0x3
	// Alternative 4 (chip-specific).
	PORT_PCR16_MUX_100 = 0x4
	// Alternative 5 (chip-specific).
	PORT_PCR16_MUX_101 = 0x5
	// Alternative 6 (chip-specific).
	PORT_PCR16_MUX_110 = 0x6
	// Alternative 7 (chip-specific).
	PORT_PCR16_MUX_111 = 0x7
	// Position of IRQC field.
	PORT_PCR16_IRQC_Pos = 0x10
	// Bit mask of IRQC field.
	PORT_PCR16_IRQC_Msk = 0xf0000
	// Interrupt Status Flag (ISF) is disabled.
	PORT_PCR16_IRQC_0000 = 0x0
	// ISF flag and DMA request on rising edge.
	PORT_PCR16_IRQC_0001 = 0x1
	// ISF flag and DMA request on falling edge.
	PORT_PCR16_IRQC_0010 = 0x2
	// ISF flag and DMA request on either edge.
	PORT_PCR16_IRQC_0011 = 0x3
	// ISF flag and Interrupt when logic 0.
	PORT_PCR16_IRQC_1000 = 0x8
	// ISF flag and Interrupt on rising-edge.
	PORT_PCR16_IRQC_1001 = 0x9
	// ISF flag and Interrupt on falling-edge.
	PORT_PCR16_IRQC_1010 = 0xa
	// ISF flag and Interrupt on either edge.
	PORT_PCR16_IRQC_1011 = 0xb
	// ISF flag and Interrupt when logic 1.
	PORT_PCR16_IRQC_1100 = 0xc
	// Position of ISF field.
	PORT_PCR16_ISF_Pos = 0x18
	// Bit mask of ISF field.
	PORT_PCR16_ISF_Msk = 0x1000000
	// Bit ISF.
	PORT_PCR16_ISF = 0x1000000
	// Configured interrupt is not detected.
	PORT_PCR16_ISF_0 = 0x0
	// Configured interrupt is detected. If the pin is configured to generate a DMA request, then the corresponding flag will be cleared automatically at the completion of the requested DMA transfer. Otherwise, the flag remains set until a logic 1 is written to the flag. If the pin is configured for a level sensitive interrupt and the pin remains asserted, then the flag is set again immediately after it is cleared.
	PORT_PCR16_ISF_1 = 0x1

	// PCR17: Pin Control Register n
	// Position of PS field.
	PORT_PCR17_PS_Pos = 0x0
	// Bit mask of PS field.
	PORT_PCR17_PS_Msk = 0x1
	// Bit PS.
	PORT_PCR17_PS = 0x1
	// Internal pulldown resistor is enabled on the corresponding pin, if the corresponding PE field is set.
	PORT_PCR17_PS_0 = 0x0
	// Internal pullup resistor is enabled on the corresponding pin, if the corresponding PE field is set.
	PORT_PCR17_PS_1 = 0x1
	// Position of PE field.
	PORT_PCR17_PE_Pos = 0x1
	// Bit mask of PE field.
	PORT_PCR17_PE_Msk = 0x2
	// Bit PE.
	PORT_PCR17_PE = 0x2
	// Internal pullup or pulldown resistor is not enabled on the corresponding pin.
	PORT_PCR17_PE_0 = 0x0
	// Internal pullup or pulldown resistor is enabled on the corresponding pin, if the pin is configured as a digital input.
	PORT_PCR17_PE_1 = 0x1
	// Position of SRE field.
	PORT_PCR17_SRE_Pos = 0x2
	// Bit mask of SRE field.
	PORT_PCR17_SRE_Msk = 0x4
	// Bit SRE.
	PORT_PCR17_SRE = 0x4
	// Fast slew rate is configured on the corresponding pin, if the pin is configured as a digital output.
	PORT_PCR17_SRE_0 = 0x0
	// Slow slew rate is configured on the corresponding pin, if the pin is configured as a digital output.
	PORT_PCR17_SRE_1 = 0x1
	// Position of PFE field.
	PORT_PCR17_PFE_Pos = 0x4
	// Bit mask of PFE field.
	PORT_PCR17_PFE_Msk = 0x10
	// Bit PFE.
	PORT_PCR17_PFE = 0x10
	// Passive input filter is disabled on the corresponding pin.
	PORT_PCR17_PFE_0 = 0x0
	// Passive input filter is enabled on the corresponding pin, if the pin is configured as a digital input. Refer to the device data sheet for filter characteristics.
	PORT_PCR17_PFE_1 = 0x1
	// Position of DSE field.
	PORT_PCR17_DSE_Pos = 0x6
	// Bit mask of DSE field.
	PORT_PCR17_DSE_Msk = 0x40
	// Bit DSE.
	PORT_PCR17_DSE = 0x40
	// Low drive strength is configured on the corresponding pin, if pin is configured as a digital output.
	PORT_PCR17_DSE_0 = 0x0
	// High drive strength is configured on the corresponding pin, if pin is configured as a digital output.
	PORT_PCR17_DSE_1 = 0x1
	// Position of MUX field.
	PORT_PCR17_MUX_Pos = 0x8
	// Bit mask of MUX field.
	PORT_PCR17_MUX_Msk = 0x700
	// Pin disabled (Alternative 0) (analog).
	PORT_PCR17_MUX_000 = 0x0
	// Alternative 1 (GPIO).
	PORT_PCR17_MUX_001 = 0x1
	// Alternative 2 (chip-specific).
	PORT_PCR17_MUX_010 = 0x2
	// Alternative 3 (chip-specific).
	PORT_PCR17_MUX_011 = 0x3
	// Alternative 4 (chip-specific).
	PORT_PCR17_MUX_100 = 0x4
	// Alternative 5 (chip-specific).
	PORT_PCR17_MUX_101 = 0x5
	// Alternative 6 (chip-specific).
	PORT_PCR17_MUX_110 = 0x6
	// Alternative 7 (chip-specific).
	PORT_PCR17_MUX_111 = 0x7
	// Position of IRQC field.
	PORT_PCR17_IRQC_Pos = 0x10
	// Bit mask of IRQC field.
	PORT_PCR17_IRQC_Msk = 0xf0000
	// Interrupt Status Flag (ISF) is disabled.
	PORT_PCR17_IRQC_0000 = 0x0
	// ISF flag and DMA request on rising edge.
	PORT_PCR17_IRQC_0001 = 0x1
	// ISF flag and DMA request on falling edge.
	PORT_PCR17_IRQC_0010 = 0x2
	// ISF flag and DMA request on either edge.
	PORT_PCR17_IRQC_0011 = 0x3
	// ISF flag and Interrupt when logic 0.
	PORT_PCR17_IRQC_1000 = 0x8
	// ISF flag and Interrupt on rising-edge.
	PORT_PCR17_IRQC_1001 = 0x9
	// ISF flag and Interrupt on falling-edge.
	PORT_PCR17_IRQC_1010 = 0xa
	// ISF flag and Interrupt on either edge.
	PORT_PCR17_IRQC_1011 = 0xb
	// ISF flag and Interrupt when logic 1.
	PORT_PCR17_IRQC_1100 = 0xc
	// Position of ISF field.
	PORT_PCR17_ISF_Pos = 0x18
	// Bit mask of ISF field.
	PORT_PCR17_ISF_Msk = 0x1000000
	// Bit ISF.
	PORT_PCR17_ISF = 0x1000000
	// Configured interrupt is not detected.
	PORT_PCR17_ISF_0 = 0x0
	// Configured interrupt is detected. If the pin is configured to generate a DMA request, then the corresponding flag will be cleared automatically at the completion of the requested DMA transfer. Otherwise, the flag remains set until a logic 1 is written to the flag. If the pin is configured for a level sensitive interrupt and the pin remains asserted, then the flag is set again immediately after it is cleared.
	PORT_PCR17_ISF_1 = 0x1

	// PCR18: Pin Control Register n
	// Position of PS field.
	PORT_PCR18_PS_Pos = 0x0
	// Bit mask of PS field.
	PORT_PCR18_PS_Msk = 0x1
	// Bit PS.
	PORT_PCR18_PS = 0x1
	// Internal pulldown resistor is enabled on the corresponding pin, if the corresponding PE field is set.
	PORT_PCR18_PS_0 = 0x0
	// Internal pullup resistor is enabled on the corresponding pin, if the corresponding PE field is set.
	PORT_PCR18_PS_1 = 0x1
	// Position of PE field.
	PORT_PCR18_PE_Pos = 0x1
	// Bit mask of PE field.
	PORT_PCR18_PE_Msk = 0x2
	// Bit PE.
	PORT_PCR18_PE = 0x2
	// Internal pullup or pulldown resistor is not enabled on the corresponding pin.
	PORT_PCR18_PE_0 = 0x0
	// Internal pullup or pulldown resistor is enabled on the corresponding pin, if the pin is configured as a digital input.
	PORT_PCR18_PE_1 = 0x1
	// Position of SRE field.
	PORT_PCR18_SRE_Pos = 0x2
	// Bit mask of SRE field.
	PORT_PCR18_SRE_Msk = 0x4
	// Bit SRE.
	PORT_PCR18_SRE = 0x4
	// Fast slew rate is configured on the corresponding pin, if the pin is configured as a digital output.
	PORT_PCR18_SRE_0 = 0x0
	// Slow slew rate is configured on the corresponding pin, if the pin is configured as a digital output.
	PORT_PCR18_SRE_1 = 0x1
	// Position of PFE field.
	PORT_PCR18_PFE_Pos = 0x4
	// Bit mask of PFE field.
	PORT_PCR18_PFE_Msk = 0x10
	// Bit PFE.
	PORT_PCR18_PFE = 0x10
	// Passive input filter is disabled on the corresponding pin.
	PORT_PCR18_PFE_0 = 0x0
	// Passive input filter is enabled on the corresponding pin, if the pin is configured as a digital input. Refer to the device data sheet for filter characteristics.
	PORT_PCR18_PFE_1 = 0x1
	// Position of DSE field.
	PORT_PCR18_DSE_Pos = 0x6
	// Bit mask of DSE field.
	PORT_PCR18_DSE_Msk = 0x40
	// Bit DSE.
	PORT_PCR18_DSE = 0x40
	// Low drive strength is configured on the corresponding pin, if pin is configured as a digital output.
	PORT_PCR18_DSE_0 = 0x0
	// High drive strength is configured on the corresponding pin, if pin is configured as a digital output.
	PORT_PCR18_DSE_1 = 0x1
	// Position of MUX field.
	PORT_PCR18_MUX_Pos = 0x8
	// Bit mask of MUX field.
	PORT_PCR18_MUX_Msk = 0x700
	// Pin disabled (Alternative 0) (analog).
	PORT_PCR18_MUX_000 = 0x0
	// Alternative 1 (GPIO).
	PORT_PCR18_MUX_001 = 0x1
	// Alternative 2 (chip-specific).
	PORT_PCR18_MUX_010 = 0x2
	// Alternative 3 (chip-specific).
	PORT_PCR18_MUX_011 = 0x3
	// Alternative 4 (chip-specific).
	PORT_PCR18_MUX_100 = 0x4
	// Alternative 5 (chip-specific).
	PORT_PCR18_MUX_101 = 0x5
	// Alternative 6 (chip-specific).
	PORT_PCR18_MUX_110 = 0x6
	// Alternative 7 (chip-specific).
	PORT_PCR18_MUX_111 = 0x7
	// Position of IRQC field.
	PORT_PCR18_IRQC_Pos = 0x10
	// Bit mask of IRQC field.
	PORT_PCR18_IRQC_Msk = 0xf0000
	// Interrupt Status Flag (ISF) is disabled.
	PORT_PCR18_IRQC_0000 = 0x0
	// ISF flag and DMA request on rising edge.
	PORT_PCR18_IRQC_0001 = 0x1
	// ISF flag and DMA request on falling edge.
	PORT_PCR18_IRQC_0010 = 0x2
	// ISF flag and DMA request on either edge.
	PORT_PCR18_IRQC_0011 = 0x3
	// ISF flag and Interrupt when logic 0.
	PORT_PCR18_IRQC_1000 = 0x8
	// ISF flag and Interrupt on rising-edge.
	PORT_PCR18_IRQC_1001 = 0x9
	// ISF flag and Interrupt on falling-edge.
	PORT_PCR18_IRQC_1010 = 0xa
	// ISF flag and Interrupt on either edge.
	PORT_PCR18_IRQC_1011 = 0xb
	// ISF flag and Interrupt when logic 1.
	PORT_PCR18_IRQC_1100 = 0xc
	// Position of ISF field.
	PORT_PCR18_ISF_Pos = 0x18
	// Bit mask of ISF field.
	PORT_PCR18_ISF_Msk = 0x1000000
	// Bit ISF.
	PORT_PCR18_ISF = 0x1000000
	// Configured interrupt is not detected.
	PORT_PCR18_ISF_0 = 0x0
	// Configured interrupt is detected. If the pin is configured to generate a DMA request, then the corresponding flag will be cleared automatically at the completion of the requested DMA transfer. Otherwise, the flag remains set until a logic 1 is written to the flag. If the pin is configured for a level sensitive interrupt and the pin remains asserted, then the flag is set again immediately after it is cleared.
	PORT_PCR18_ISF_1 = 0x1

	// PCR19: Pin Control Register n
	// Position of PS field.
	PORT_PCR19_PS_Pos = 0x0
	// Bit mask of PS field.
	PORT_PCR19_PS_Msk = 0x1
	// Bit PS.
	PORT_PCR19_PS = 0x1
	// Internal pulldown resistor is enabled on the corresponding pin, if the corresponding PE field is set.
	PORT_PCR19_PS_0 = 0x0
	// Internal pullup resistor is enabled on the corresponding pin, if the corresponding PE field is set.
	PORT_PCR19_PS_1 = 0x1
	// Position of PE field.
	PORT_PCR19_PE_Pos = 0x1
	// Bit mask of PE field.
	PORT_PCR19_PE_Msk = 0x2
	// Bit PE.
	PORT_PCR19_PE = 0x2
	// Internal pullup or pulldown resistor is not enabled on the corresponding pin.
	PORT_PCR19_PE_0 = 0x0
	// Internal pullup or pulldown resistor is enabled on the corresponding pin, if the pin is configured as a digital input.
	PORT_PCR19_PE_1 = 0x1
	// Position of SRE field.
	PORT_PCR19_SRE_Pos = 0x2
	// Bit mask of SRE field.
	PORT_PCR19_SRE_Msk = 0x4
	// Bit SRE.
	PORT_PCR19_SRE = 0x4
	// Fast slew rate is configured on the corresponding pin, if the pin is configured as a digital output.
	PORT_PCR19_SRE_0 = 0x0
	// Slow slew rate is configured on the corresponding pin, if the pin is configured as a digital output.
	PORT_PCR19_SRE_1 = 0x1
	// Position of PFE field.
	PORT_PCR19_PFE_Pos = 0x4
	// Bit mask of PFE field.
	PORT_PCR19_PFE_Msk = 0x10
	// Bit PFE.
	PORT_PCR19_PFE = 0x10
	// Passive input filter is disabled on the corresponding pin.
	PORT_PCR19_PFE_0 = 0x0
	// Passive input filter is enabled on the corresponding pin, if the pin is configured as a digital input. Refer to the device data sheet for filter characteristics.
	PORT_PCR19_PFE_1 = 0x1
	// Position of DSE field.
	PORT_PCR19_DSE_Pos = 0x6
	// Bit mask of DSE field.
	PORT_PCR19_DSE_Msk = 0x40
	// Bit DSE.
	PORT_PCR19_DSE = 0x40
	// Low drive strength is configured on the corresponding pin, if pin is configured as a digital output.
	PORT_PCR19_DSE_0 = 0x0
	// High drive strength is configured on the corresponding pin, if pin is configured as a digital output.
	PORT_PCR19_DSE_1 = 0x1
	// Position of MUX field.
	PORT_PCR19_MUX_Pos = 0x8
	// Bit mask of MUX field.
	PORT_PCR19_MUX_Msk = 0x700
	// Pin disabled (Alternative 0) (analog).
	PORT_PCR19_MUX_000 = 0x0
	// Alternative 1 (GPIO).
	PORT_PCR19_MUX_001 = 0x1
	// Alternative 2 (chip-specific).
	PORT_PCR19_MUX_010 = 0x2
	// Alternative 3 (chip-specific).
	PORT_PCR19_MUX_011 = 0x3
	// Alternative 4 (chip-specific).
	PORT_PCR19_MUX_100 = 0x4
	// Alternative 5 (chip-specific).
	PORT_PCR19_MUX_101 = 0x5
	// Alternative 6 (chip-specific).
	PORT_PCR19_MUX_110 = 0x6
	// Alternative 7 (chip-specific).
	PORT_PCR19_MUX_111 = 0x7
	// Position of IRQC field.
	PORT_PCR19_IRQC_Pos = 0x10
	// Bit mask of IRQC field.
	PORT_PCR19_IRQC_Msk = 0xf0000
	// Interrupt Status Flag (ISF) is disabled.
	PORT_PCR19_IRQC_0000 = 0x0
	// ISF flag and DMA request on rising edge.
	PORT_PCR19_IRQC_0001 = 0x1
	// ISF flag and DMA request on falling edge.
	PORT_PCR19_IRQC_0010 = 0x2
	// ISF flag and DMA request on either edge.
	PORT_PCR19_IRQC_0011 = 0x3
	// ISF flag and Interrupt when logic 0.
	PORT_PCR19_IRQC_1000 = 0x8
	// ISF flag and Interrupt on rising-edge.
	PORT_PCR19_IRQC_1001 = 0x9
	// ISF flag and Interrupt on falling-edge.
	PORT_PCR19_IRQC_1010 = 0xa
	// ISF flag and Interrupt on either edge.
	PORT_PCR19_IRQC_1011 = 0xb
	// ISF flag and Interrupt when logic 1.
	PORT_PCR19_IRQC_1100 = 0xc
	// Position of ISF field.
	PORT_PCR19_ISF_Pos = 0x18
	// Bit mask of ISF field.
	PORT_PCR19_ISF_Msk = 0x1000000
	// Bit ISF.
	PORT_PCR19_ISF = 0x1000000
	// Configured interrupt is not detected.
	PORT_PCR19_ISF_0 = 0x0
	// Configured interrupt is detected. If the pin is configured to generate a DMA request, then the corresponding flag will be cleared automatically at the completion of the requested DMA transfer. Otherwise, the flag remains set until a logic 1 is written to the flag. If the pin is configured for a level sensitive interrupt and the pin remains asserted, then the flag is set again immediately after it is cleared.
	PORT_PCR19_ISF_1 = 0x1

	// PCR20: Pin Control Register n
	// Position of PS field.
	PORT_PCR20_PS_Pos = 0x0
	// Bit mask of PS field.
	PORT_PCR20_PS_Msk = 0x1
	// Bit PS.
	PORT_PCR20_PS = 0x1
	// Internal pulldown resistor is enabled on the corresponding pin, if the corresponding PE field is set.
	PORT_PCR20_PS_0 = 0x0
	// Internal pullup resistor is enabled on the corresponding pin, if the corresponding PE field is set.
	PORT_PCR20_PS_1 = 0x1
	// Position of PE field.
	PORT_PCR20_PE_Pos = 0x1
	// Bit mask of PE field.
	PORT_PCR20_PE_Msk = 0x2
	// Bit PE.
	PORT_PCR20_PE = 0x2
	// Internal pullup or pulldown resistor is not enabled on the corresponding pin.
	PORT_PCR20_PE_0 = 0x0
	// Internal pullup or pulldown resistor is enabled on the corresponding pin, if the pin is configured as a digital input.
	PORT_PCR20_PE_1 = 0x1
	// Position of SRE field.
	PORT_PCR20_SRE_Pos = 0x2
	// Bit mask of SRE field.
	PORT_PCR20_SRE_Msk = 0x4
	// Bit SRE.
	PORT_PCR20_SRE = 0x4
	// Fast slew rate is configured on the corresponding pin, if the pin is configured as a digital output.
	PORT_PCR20_SRE_0 = 0x0
	// Slow slew rate is configured on the corresponding pin, if the pin is configured as a digital output.
	PORT_PCR20_SRE_1 = 0x1
	// Position of PFE field.
	PORT_PCR20_PFE_Pos = 0x4
	// Bit mask of PFE field.
	PORT_PCR20_PFE_Msk = 0x10
	// Bit PFE.
	PORT_PCR20_PFE = 0x10
	// Passive input filter is disabled on the corresponding pin.
	PORT_PCR20_PFE_0 = 0x0
	// Passive input filter is enabled on the corresponding pin, if the pin is configured as a digital input. Refer to the device data sheet for filter characteristics.
	PORT_PCR20_PFE_1 = 0x1
	// Position of DSE field.
	PORT_PCR20_DSE_Pos = 0x6
	// Bit mask of DSE field.
	PORT_PCR20_DSE_Msk = 0x40
	// Bit DSE.
	PORT_PCR20_DSE = 0x40
	// Low drive strength is configured on the corresponding pin, if pin is configured as a digital output.
	PORT_PCR20_DSE_0 = 0x0
	// High drive strength is configured on the corresponding pin, if pin is configured as a digital output.
	PORT_PCR20_DSE_1 = 0x1
	// Position of MUX field.
	PORT_PCR20_MUX_Pos = 0x8
	// Bit mask of MUX field.
	PORT_PCR20_MUX_Msk = 0x700
	// Pin disabled (Alternative 0) (analog).
	PORT_PCR20_MUX_000 = 0x0
	// Alternative 1 (GPIO).
	PORT_PCR20_MUX_001 = 0x1
	// Alternative 2 (chip-specific).
	PORT_PCR20_MUX_010 = 0x2
	// Alternative 3 (chip-specific).
	PORT_PCR20_MUX_011 = 0x3
	// Alternative 4 (chip-specific).
	PORT_PCR20_MUX_100 = 0x4
	// Alternative 5 (chip-specific).
	PORT_PCR20_MUX_101 = 0x5
	// Alternative 6 (chip-specific).
	PORT_PCR20_MUX_110 = 0x6
	// Alternative 7 (chip-specific).
	PORT_PCR20_MUX_111 = 0x7
	// Position of IRQC field.
	PORT_PCR20_IRQC_Pos = 0x10
	// Bit mask of IRQC field.
	PORT_PCR20_IRQC_Msk = 0xf0000
	// Interrupt Status Flag (ISF) is disabled.
	PORT_PCR20_IRQC_0000 = 0x0
	// ISF flag and DMA request on rising edge.
	PORT_PCR20_IRQC_0001 = 0x1
	// ISF flag and DMA request on falling edge.
	PORT_PCR20_IRQC_0010 = 0x2
	// ISF flag and DMA request on either edge.
	PORT_PCR20_IRQC_0011 = 0x3
	// ISF flag and Interrupt when logic 0.
	PORT_PCR20_IRQC_1000 = 0x8
	// ISF flag and Interrupt on rising-edge.
	PORT_PCR20_IRQC_1001 = 0x9
	// ISF flag and Interrupt on falling-edge.
	PORT_PCR20_IRQC_1010 = 0xa
	// ISF flag and Interrupt on either edge.
	PORT_PCR20_IRQC_1011 = 0xb
	// ISF flag and Interrupt when logic 1.
	PORT_PCR20_IRQC_1100 = 0xc
	// Position of ISF field.
	PORT_PCR20_ISF_Pos = 0x18
	// Bit mask of ISF field.
	PORT_PCR20_ISF_Msk = 0x1000000
	// Bit ISF.
	PORT_PCR20_ISF = 0x1000000
	// Configured interrupt is not detected.
	PORT_PCR20_ISF_0 = 0x0
	// Configured interrupt is detected. If the pin is configured to generate a DMA request, then the corresponding flag will be cleared automatically at the completion of the requested DMA transfer. Otherwise, the flag remains set until a logic 1 is written to the flag. If the pin is configured for a level sensitive interrupt and the pin remains asserted, then the flag is set again immediately after it is cleared.
	PORT_PCR20_ISF_1 = 0x1

	// PCR21: Pin Control Register n
	// Position of PS field.
	PORT_PCR21_PS_Pos = 0x0
	// Bit mask of PS field.
	PORT_PCR21_PS_Msk = 0x1
	// Bit PS.
	PORT_PCR21_PS = 0x1
	// Internal pulldown resistor is enabled on the corresponding pin, if the corresponding PE field is set.
	PORT_PCR21_PS_0 = 0x0
	// Internal pullup resistor is enabled on the corresponding pin, if the corresponding PE field is set.
	PORT_PCR21_PS_1 = 0x1
	// Position of PE field.
	PORT_PCR21_PE_Pos = 0x1
	// Bit mask of PE field.
	PORT_PCR21_PE_Msk = 0x2
	// Bit PE.
	PORT_PCR21_PE = 0x2
	// Internal pullup or pulldown resistor is not enabled on the corresponding pin.
	PORT_PCR21_PE_0 = 0x0
	// Internal pullup or pulldown resistor is enabled on the corresponding pin, if the pin is configured as a digital input.
	PORT_PCR21_PE_1 = 0x1
	// Position of SRE field.
	PORT_PCR21_SRE_Pos = 0x2
	// Bit mask of SRE field.
	PORT_PCR21_SRE_Msk = 0x4
	// Bit SRE.
	PORT_PCR21_SRE = 0x4
	// Fast slew rate is configured on the corresponding pin, if the pin is configured as a digital output.
	PORT_PCR21_SRE_0 = 0x0
	// Slow slew rate is configured on the corresponding pin, if the pin is configured as a digital output.
	PORT_PCR21_SRE_1 = 0x1
	// Position of PFE field.
	PORT_PCR21_PFE_Pos = 0x4
	// Bit mask of PFE field.
	PORT_PCR21_PFE_Msk = 0x10
	// Bit PFE.
	PORT_PCR21_PFE = 0x10
	// Passive input filter is disabled on the corresponding pin.
	PORT_PCR21_PFE_0 = 0x0
	// Passive input filter is enabled on the corresponding pin, if the pin is configured as a digital input. Refer to the device data sheet for filter characteristics.
	PORT_PCR21_PFE_1 = 0x1
	// Position of DSE field.
	PORT_PCR21_DSE_Pos = 0x6
	// Bit mask of DSE field.
	PORT_PCR21_DSE_Msk = 0x40
	// Bit DSE.
	PORT_PCR21_DSE = 0x40
	// Low drive strength is configured on the corresponding pin, if pin is configured as a digital output.
	PORT_PCR21_DSE_0 = 0x0
	// High drive strength is configured on the corresponding pin, if pin is configured as a digital output.
	PORT_PCR21_DSE_1 = 0x1
	// Position of MUX field.
	PORT_PCR21_MUX_Pos = 0x8
	// Bit mask of MUX field.
	PORT_PCR21_MUX_Msk = 0x700
	// Pin disabled (Alternative 0) (analog).
	PORT_PCR21_MUX_000 = 0x0
	// Alternative 1 (GPIO).
	PORT_PCR21_MUX_001 = 0x1
	// Alternative 2 (chip-specific).
	PORT_PCR21_MUX_010 = 0x2
	// Alternative 3 (chip-specific).
	PORT_PCR21_MUX_011 = 0x3
	// Alternative 4 (chip-specific).
	PORT_PCR21_MUX_100 = 0x4
	// Alternative 5 (chip-specific).
	PORT_PCR21_MUX_101 = 0x5
	// Alternative 6 (chip-specific).
	PORT_PCR21_MUX_110 = 0x6
	// Alternative 7 (chip-specific).
	PORT_PCR21_MUX_111 = 0x7
	// Position of IRQC field.
	PORT_PCR21_IRQC_Pos = 0x10
	// Bit mask of IRQC field.
	PORT_PCR21_IRQC_Msk = 0xf0000
	// Interrupt Status Flag (ISF) is disabled.
	PORT_PCR21_IRQC_0000 = 0x0
	// ISF flag and DMA request on rising edge.
	PORT_PCR21_IRQC_0001 = 0x1
	// ISF flag and DMA request on falling edge.
	PORT_PCR21_IRQC_0010 = 0x2
	// ISF flag and DMA request on either edge.
	PORT_PCR21_IRQC_0011 = 0x3
	// ISF flag and Interrupt when logic 0.
	PORT_PCR21_IRQC_1000 = 0x8
	// ISF flag and Interrupt on rising-edge.
	PORT_PCR21_IRQC_1001 = 0x9
	// ISF flag and Interrupt on falling-edge.
	PORT_PCR21_IRQC_1010 = 0xa
	// ISF flag and Interrupt on either edge.
	PORT_PCR21_IRQC_1011 = 0xb
	// ISF flag and Interrupt when logic 1.
	PORT_PCR21_IRQC_1100 = 0xc
	// Position of ISF field.
	PORT_PCR21_ISF_Pos = 0x18
	// Bit mask of ISF field.
	PORT_PCR21_ISF_Msk = 0x1000000
	// Bit ISF.
	PORT_PCR21_ISF = 0x1000000
	// Configured interrupt is not detected.
	PORT_PCR21_ISF_0 = 0x0
	// Configured interrupt is detected. If the pin is configured to generate a DMA request, then the corresponding flag will be cleared automatically at the completion of the requested DMA transfer. Otherwise, the flag remains set until a logic 1 is written to the flag. If the pin is configured for a level sensitive interrupt and the pin remains asserted, then the flag is set again immediately after it is cleared.
	PORT_PCR21_ISF_1 = 0x1

	// PCR22: Pin Control Register n
	// Position of PS field.
	PORT_PCR22_PS_Pos = 0x0
	// Bit mask of PS field.
	PORT_PCR22_PS_Msk = 0x1
	// Bit PS.
	PORT_PCR22_PS = 0x1
	// Internal pulldown resistor is enabled on the corresponding pin, if the corresponding PE field is set.
	PORT_PCR22_PS_0 = 0x0
	// Internal pullup resistor is enabled on the corresponding pin, if the corresponding PE field is set.
	PORT_PCR22_PS_1 = 0x1
	// Position of PE field.
	PORT_PCR22_PE_Pos = 0x1
	// Bit mask of PE field.
	PORT_PCR22_PE_Msk = 0x2
	// Bit PE.
	PORT_PCR22_PE = 0x2
	// Internal pullup or pulldown resistor is not enabled on the corresponding pin.
	PORT_PCR22_PE_0 = 0x0
	// Internal pullup or pulldown resistor is enabled on the corresponding pin, if the pin is configured as a digital input.
	PORT_PCR22_PE_1 = 0x1
	// Position of SRE field.
	PORT_PCR22_SRE_Pos = 0x2
	// Bit mask of SRE field.
	PORT_PCR22_SRE_Msk = 0x4
	// Bit SRE.
	PORT_PCR22_SRE = 0x4
	// Fast slew rate is configured on the corresponding pin, if the pin is configured as a digital output.
	PORT_PCR22_SRE_0 = 0x0
	// Slow slew rate is configured on the corresponding pin, if the pin is configured as a digital output.
	PORT_PCR22_SRE_1 = 0x1
	// Position of PFE field.
	PORT_PCR22_PFE_Pos = 0x4
	// Bit mask of PFE field.
	PORT_PCR22_PFE_Msk = 0x10
	// Bit PFE.
	PORT_PCR22_PFE = 0x10
	// Passive input filter is disabled on the corresponding pin.
	PORT_PCR22_PFE_0 = 0x0
	// Passive input filter is enabled on the corresponding pin, if the pin is configured as a digital input. Refer to the device data sheet for filter characteristics.
	PORT_PCR22_PFE_1 = 0x1
	// Position of DSE field.
	PORT_PCR22_DSE_Pos = 0x6
	// Bit mask of DSE field.
	PORT_PCR22_DSE_Msk = 0x40
	// Bit DSE.
	PORT_PCR22_DSE = 0x40
	// Low drive strength is configured on the corresponding pin, if pin is configured as a digital output.
	PORT_PCR22_DSE_0 = 0x0
	// High drive strength is configured on the corresponding pin, if pin is configured as a digital output.
	PORT_PCR22_DSE_1 = 0x1
	// Position of MUX field.
	PORT_PCR22_MUX_Pos = 0x8
	// Bit mask of MUX field.
	PORT_PCR22_MUX_Msk = 0x700
	// Pin disabled (Alternative 0) (analog).
	PORT_PCR22_MUX_000 = 0x0
	// Alternative 1 (GPIO).
	PORT_PCR22_MUX_001 = 0x1
	// Alternative 2 (chip-specific).
	PORT_PCR22_MUX_010 = 0x2
	// Alternative 3 (chip-specific).
	PORT_PCR22_MUX_011 = 0x3
	// Alternative 4 (chip-specific).
	PORT_PCR22_MUX_100 = 0x4
	// Alternative 5 (chip-specific).
	PORT_PCR22_MUX_101 = 0x5
	// Alternative 6 (chip-specific).
	PORT_PCR22_MUX_110 = 0x6
	// Alternative 7 (chip-specific).
	PORT_PCR22_MUX_111 = 0x7
	// Position of IRQC field.
	PORT_PCR22_IRQC_Pos = 0x10
	// Bit mask of IRQC field.
	PORT_PCR22_IRQC_Msk = 0xf0000
	// Interrupt Status Flag (ISF) is disabled.
	PORT_PCR22_IRQC_0000 = 0x0
	// ISF flag and DMA request on rising edge.
	PORT_PCR22_IRQC_0001 = 0x1
	// ISF flag and DMA request on falling edge.
	PORT_PCR22_IRQC_0010 = 0x2
	// ISF flag and DMA request on either edge.
	PORT_PCR22_IRQC_0011 = 0x3
	// ISF flag and Interrupt when logic 0.
	PORT_PCR22_IRQC_1000 = 0x8
	// ISF flag and Interrupt on rising-edge.
	PORT_PCR22_IRQC_1001 = 0x9
	// ISF flag and Interrupt on falling-edge.
	PORT_PCR22_IRQC_1010 = 0xa
	// ISF flag and Interrupt on either edge.
	PORT_PCR22_IRQC_1011 = 0xb
	// ISF flag and Interrupt when logic 1.
	PORT_PCR22_IRQC_1100 = 0xc
	// Position of ISF field.
	PORT_PCR22_ISF_Pos = 0x18
	// Bit mask of ISF field.
	PORT_PCR22_ISF_Msk = 0x1000000
	// Bit ISF.
	PORT_PCR22_ISF = 0x1000000
	// Configured interrupt is not detected.
	PORT_PCR22_ISF_0 = 0x0
	// Configured interrupt is detected. If the pin is configured to generate a DMA request, then the corresponding flag will be cleared automatically at the completion of the requested DMA transfer. Otherwise, the flag remains set until a logic 1 is written to the flag. If the pin is configured for a level sensitive interrupt and the pin remains asserted, then the flag is set again immediately after it is cleared.
	PORT_PCR22_ISF_1 = 0x1

	// PCR23: Pin Control Register n
	// Position of PS field.
	PORT_PCR23_PS_Pos = 0x0
	// Bit mask of PS field.
	PORT_PCR23_PS_Msk = 0x1
	// Bit PS.
	PORT_PCR23_PS = 0x1
	// Internal pulldown resistor is enabled on the corresponding pin, if the corresponding PE field is set.
	PORT_PCR23_PS_0 = 0x0
	// Internal pullup resistor is enabled on the corresponding pin, if the corresponding PE field is set.
	PORT_PCR23_PS_1 = 0x1
	// Position of PE field.
	PORT_PCR23_PE_Pos = 0x1
	// Bit mask of PE field.
	PORT_PCR23_PE_Msk = 0x2
	// Bit PE.
	PORT_PCR23_PE = 0x2
	// Internal pullup or pulldown resistor is not enabled on the corresponding pin.
	PORT_PCR23_PE_0 = 0x0
	// Internal pullup or pulldown resistor is enabled on the corresponding pin, if the pin is configured as a digital input.
	PORT_PCR23_PE_1 = 0x1
	// Position of SRE field.
	PORT_PCR23_SRE_Pos = 0x2
	// Bit mask of SRE field.
	PORT_PCR23_SRE_Msk = 0x4
	// Bit SRE.
	PORT_PCR23_SRE = 0x4
	// Fast slew rate is configured on the corresponding pin, if the pin is configured as a digital output.
	PORT_PCR23_SRE_0 = 0x0
	// Slow slew rate is configured on the corresponding pin, if the pin is configured as a digital output.
	PORT_PCR23_SRE_1 = 0x1
	// Position of PFE field.
	PORT_PCR23_PFE_Pos = 0x4
	// Bit mask of PFE field.
	PORT_PCR23_PFE_Msk = 0x10
	// Bit PFE.
	PORT_PCR23_PFE = 0x10
	// Passive input filter is disabled on the corresponding pin.
	PORT_PCR23_PFE_0 = 0x0
	// Passive input filter is enabled on the corresponding pin, if the pin is configured as a digital input. Refer to the device data sheet for filter characteristics.
	PORT_PCR23_PFE_1 = 0x1
	// Position of DSE field.
	PORT_PCR23_DSE_Pos = 0x6
	// Bit mask of DSE field.
	PORT_PCR23_DSE_Msk = 0x40
	// Bit DSE.
	PORT_PCR23_DSE = 0x40
	// Low drive strength is configured on the corresponding pin, if pin is configured as a digital output.
	PORT_PCR23_DSE_0 = 0x0
	// High drive strength is configured on the corresponding pin, if pin is configured as a digital output.
	PORT_PCR23_DSE_1 = 0x1
	// Position of MUX field.
	PORT_PCR23_MUX_Pos = 0x8
	// Bit mask of MUX field.
	PORT_PCR23_MUX_Msk = 0x700
	// Pin disabled (Alternative 0) (analog).
	PORT_PCR23_MUX_000 = 0x0
	// Alternative 1 (GPIO).
	PORT_PCR23_MUX_001 = 0x1
	// Alternative 2 (chip-specific).
	PORT_PCR23_MUX_010 = 0x2
	// Alternative 3 (chip-specific).
	PORT_PCR23_MUX_011 = 0x3
	// Alternative 4 (chip-specific).
	PORT_PCR23_MUX_100 = 0x4
	// Alternative 5 (chip-specific).
	PORT_PCR23_MUX_101 = 0x5
	// Alternative 6 (chip-specific).
	PORT_PCR23_MUX_110 = 0x6
	// Alternative 7 (chip-specific).
	PORT_PCR23_MUX_111 = 0x7
	// Position of IRQC field.
	PORT_PCR23_IRQC_Pos = 0x10
	// Bit mask of IRQC field.
	PORT_PCR23_IRQC_Msk = 0xf0000
	// Interrupt Status Flag (ISF) is disabled.
	PORT_PCR23_IRQC_0000 = 0x0
	// ISF flag and DMA request on rising edge.
	PORT_PCR23_IRQC_0001 = 0x1
	// ISF flag and DMA request on falling edge.
	PORT_PCR23_IRQC_0010 = 0x2
	// ISF flag and DMA request on either edge.
	PORT_PCR23_IRQC_0011 = 0x3
	// ISF flag and Interrupt when logic 0.
	PORT_PCR23_IRQC_1000 = 0x8
	// ISF flag and Interrupt on rising-edge.
	PORT_PCR23_IRQC_1001 = 0x9
	// ISF flag and Interrupt on falling-edge.
	PORT_PCR23_IRQC_1010 = 0xa
	// ISF flag and Interrupt on either edge.
	PORT_PCR23_IRQC_1011 = 0xb
	// ISF flag and Interrupt when logic 1.
	PORT_PCR23_IRQC_1100 = 0xc
	// Position of ISF field.
	PORT_PCR23_ISF_Pos = 0x18
	// Bit mask of ISF field.
	PORT_PCR23_ISF_Msk = 0x1000000
	// Bit ISF.
	PORT_PCR23_ISF = 0x1000000
	// Configured interrupt is not detected.
	PORT_PCR23_ISF_0 = 0x0
	// Configured interrupt is detected. If the pin is configured to generate a DMA request, then the corresponding flag will be cleared automatically at the completion of the requested DMA transfer. Otherwise, the flag remains set until a logic 1 is written to the flag. If the pin is configured for a level sensitive interrupt and the pin remains asserted, then the flag is set again immediately after it is cleared.
	PORT_PCR23_ISF_1 = 0x1

	// PCR24: Pin Control Register n
	// Position of PS field.
	PORT_PCR24_PS_Pos = 0x0
	// Bit mask of PS field.
	PORT_PCR24_PS_Msk = 0x1
	// Bit PS.
	PORT_PCR24_PS = 0x1
	// Internal pulldown resistor is enabled on the corresponding pin, if the corresponding PE field is set.
	PORT_PCR24_PS_0 = 0x0
	// Internal pullup resistor is enabled on the corresponding pin, if the corresponding PE field is set.
	PORT_PCR24_PS_1 = 0x1
	// Position of PE field.
	PORT_PCR24_PE_Pos = 0x1
	// Bit mask of PE field.
	PORT_PCR24_PE_Msk = 0x2
	// Bit PE.
	PORT_PCR24_PE = 0x2
	// Internal pullup or pulldown resistor is not enabled on the corresponding pin.
	PORT_PCR24_PE_0 = 0x0
	// Internal pullup or pulldown resistor is enabled on the corresponding pin, if the pin is configured as a digital input.
	PORT_PCR24_PE_1 = 0x1
	// Position of SRE field.
	PORT_PCR24_SRE_Pos = 0x2
	// Bit mask of SRE field.
	PORT_PCR24_SRE_Msk = 0x4
	// Bit SRE.
	PORT_PCR24_SRE = 0x4
	// Fast slew rate is configured on the corresponding pin, if the pin is configured as a digital output.
	PORT_PCR24_SRE_0 = 0x0
	// Slow slew rate is configured on the corresponding pin, if the pin is configured as a digital output.
	PORT_PCR24_SRE_1 = 0x1
	// Position of PFE field.
	PORT_PCR24_PFE_Pos = 0x4
	// Bit mask of PFE field.
	PORT_PCR24_PFE_Msk = 0x10
	// Bit PFE.
	PORT_PCR24_PFE = 0x10
	// Passive input filter is disabled on the corresponding pin.
	PORT_PCR24_PFE_0 = 0x0
	// Passive input filter is enabled on the corresponding pin, if the pin is configured as a digital input. Refer to the device data sheet for filter characteristics.
	PORT_PCR24_PFE_1 = 0x1
	// Position of DSE field.
	PORT_PCR24_DSE_Pos = 0x6
	// Bit mask of DSE field.
	PORT_PCR24_DSE_Msk = 0x40
	// Bit DSE.
	PORT_PCR24_DSE = 0x40
	// Low drive strength is configured on the corresponding pin, if pin is configured as a digital output.
	PORT_PCR24_DSE_0 = 0x0
	// High drive strength is configured on the corresponding pin, if pin is configured as a digital output.
	PORT_PCR24_DSE_1 = 0x1
	// Position of MUX field.
	PORT_PCR24_MUX_Pos = 0x8
	// Bit mask of MUX field.
	PORT_PCR24_MUX_Msk = 0x700
	// Pin disabled (Alternative 0) (analog).
	PORT_PCR24_MUX_000 = 0x0
	// Alternative 1 (GPIO).
	PORT_PCR24_MUX_001 = 0x1
	// Alternative 2 (chip-specific).
	PORT_PCR24_MUX_010 = 0x2
	// Alternative 3 (chip-specific).
	PORT_PCR24_MUX_011 = 0x3
	// Alternative 4 (chip-specific).
	PORT_PCR24_MUX_100 = 0x4
	// Alternative 5 (chip-specific).
	PORT_PCR24_MUX_101 = 0x5
	// Alternative 6 (chip-specific).
	PORT_PCR24_MUX_110 = 0x6
	// Alternative 7 (chip-specific).
	PORT_PCR24_MUX_111 = 0x7
	// Position of IRQC field.
	PORT_PCR24_IRQC_Pos = 0x10
	// Bit mask of IRQC field.
	PORT_PCR24_IRQC_Msk = 0xf0000
	// Interrupt Status Flag (ISF) is disabled.
	PORT_PCR24_IRQC_0000 = 0x0
	// ISF flag and DMA request on rising edge.
	PORT_PCR24_IRQC_0001 = 0x1
	// ISF flag and DMA request on falling edge.
	PORT_PCR24_IRQC_0010 = 0x2
	// ISF flag and DMA request on either edge.
	PORT_PCR24_IRQC_0011 = 0x3
	// ISF flag and Interrupt when logic 0.
	PORT_PCR24_IRQC_1000 = 0x8
	// ISF flag and Interrupt on rising-edge.
	PORT_PCR24_IRQC_1001 = 0x9
	// ISF flag and Interrupt on falling-edge.
	PORT_PCR24_IRQC_1010 = 0xa
	// ISF flag and Interrupt on either edge.
	PORT_PCR24_IRQC_1011 = 0xb
	// ISF flag and Interrupt when logic 1.
	PORT_PCR24_IRQC_1100 = 0xc
	// Position of ISF field.
	PORT_PCR24_ISF_Pos = 0x18
	// Bit mask of ISF field.
	PORT_PCR24_ISF_Msk = 0x1000000
	// Bit ISF.
	PORT_PCR24_ISF = 0x1000000
	// Configured interrupt is not detected.
	PORT_PCR24_ISF_0 = 0x0
	// Configured interrupt is detected. If the pin is configured to generate a DMA request, then the corresponding flag will be cleared automatically at the completion of the requested DMA transfer. Otherwise, the flag remains set until a logic 1 is written to the flag. If the pin is configured for a level sensitive interrupt and the pin remains asserted, then the flag is set again immediately after it is cleared.
	PORT_PCR24_ISF_1 = 0x1

	// PCR25: Pin Control Register n
	// Position of PS field.
	PORT_PCR25_PS_Pos = 0x0
	// Bit mask of PS field.
	PORT_PCR25_PS_Msk = 0x1
	// Bit PS.
	PORT_PCR25_PS = 0x1
	// Internal pulldown resistor is enabled on the corresponding pin, if the corresponding PE field is set.
	PORT_PCR25_PS_0 = 0x0
	// Internal pullup resistor is enabled on the corresponding pin, if the corresponding PE field is set.
	PORT_PCR25_PS_1 = 0x1
	// Position of PE field.
	PORT_PCR25_PE_Pos = 0x1
	// Bit mask of PE field.
	PORT_PCR25_PE_Msk = 0x2
	// Bit PE.
	PORT_PCR25_PE = 0x2
	// Internal pullup or pulldown resistor is not enabled on the corresponding pin.
	PORT_PCR25_PE_0 = 0x0
	// Internal pullup or pulldown resistor is enabled on the corresponding pin, if the pin is configured as a digital input.
	PORT_PCR25_PE_1 = 0x1
	// Position of SRE field.
	PORT_PCR25_SRE_Pos = 0x2
	// Bit mask of SRE field.
	PORT_PCR25_SRE_Msk = 0x4
	// Bit SRE.
	PORT_PCR25_SRE = 0x4
	// Fast slew rate is configured on the corresponding pin, if the pin is configured as a digital output.
	PORT_PCR25_SRE_0 = 0x0
	// Slow slew rate is configured on the corresponding pin, if the pin is configured as a digital output.
	PORT_PCR25_SRE_1 = 0x1
	// Position of PFE field.
	PORT_PCR25_PFE_Pos = 0x4
	// Bit mask of PFE field.
	PORT_PCR25_PFE_Msk = 0x10
	// Bit PFE.
	PORT_PCR25_PFE = 0x10
	// Passive input filter is disabled on the corresponding pin.
	PORT_PCR25_PFE_0 = 0x0
	// Passive input filter is enabled on the corresponding pin, if the pin is configured as a digital input. Refer to the device data sheet for filter characteristics.
	PORT_PCR25_PFE_1 = 0x1
	// Position of DSE field.
	PORT_PCR25_DSE_Pos = 0x6
	// Bit mask of DSE field.
	PORT_PCR25_DSE_Msk = 0x40
	// Bit DSE.
	PORT_PCR25_DSE = 0x40
	// Low drive strength is configured on the corresponding pin, if pin is configured as a digital output.
	PORT_PCR25_DSE_0 = 0x0
	// High drive strength is configured on the corresponding pin, if pin is configured as a digital output.
	PORT_PCR25_DSE_1 = 0x1
	// Position of MUX field.
	PORT_PCR25_MUX_Pos = 0x8
	// Bit mask of MUX field.
	PORT_PCR25_MUX_Msk = 0x700
	// Pin disabled (Alternative 0) (analog).
	PORT_PCR25_MUX_000 = 0x0
	// Alternative 1 (GPIO).
	PORT_PCR25_MUX_001 = 0x1
	// Alternative 2 (chip-specific).
	PORT_PCR25_MUX_010 = 0x2
	// Alternative 3 (chip-specific).
	PORT_PCR25_MUX_011 = 0x3
	// Alternative 4 (chip-specific).
	PORT_PCR25_MUX_100 = 0x4
	// Alternative 5 (chip-specific).
	PORT_PCR25_MUX_101 = 0x5
	// Alternative 6 (chip-specific).
	PORT_PCR25_MUX_110 = 0x6
	// Alternative 7 (chip-specific).
	PORT_PCR25_MUX_111 = 0x7
	// Position of IRQC field.
	PORT_PCR25_IRQC_Pos = 0x10
	// Bit mask of IRQC field.
	PORT_PCR25_IRQC_Msk = 0xf0000
	// Interrupt Status Flag (ISF) is disabled.
	PORT_PCR25_IRQC_0000 = 0x0
	// ISF flag and DMA request on rising edge.
	PORT_PCR25_IRQC_0001 = 0x1
	// ISF flag and DMA request on falling edge.
	PORT_PCR25_IRQC_0010 = 0x2
	// ISF flag and DMA request on either edge.
	PORT_PCR25_IRQC_0011 = 0x3
	// ISF flag and Interrupt when logic 0.
	PORT_PCR25_IRQC_1000 = 0x8
	// ISF flag and Interrupt on rising-edge.
	PORT_PCR25_IRQC_1001 = 0x9
	// ISF flag and Interrupt on falling-edge.
	PORT_PCR25_IRQC_1010 = 0xa
	// ISF flag and Interrupt on either edge.
	PORT_PCR25_IRQC_1011 = 0xb
	// ISF flag and Interrupt when logic 1.
	PORT_PCR25_IRQC_1100 = 0xc
	// Position of ISF field.
	PORT_PCR25_ISF_Pos = 0x18
	// Bit mask of ISF field.
	PORT_PCR25_ISF_Msk = 0x1000000
	// Bit ISF.
	PORT_PCR25_ISF = 0x1000000
	// Configured interrupt is not detected.
	PORT_PCR25_ISF_0 = 0x0
	// Configured interrupt is detected. If the pin is configured to generate a DMA request, then the corresponding flag will be cleared automatically at the completion of the requested DMA transfer. Otherwise, the flag remains set until a logic 1 is written to the flag. If the pin is configured for a level sensitive interrupt and the pin remains asserted, then the flag is set again immediately after it is cleared.
	PORT_PCR25_ISF_1 = 0x1

	// PCR26: Pin Control Register n
	// Position of PS field.
	PORT_PCR26_PS_Pos = 0x0
	// Bit mask of PS field.
	PORT_PCR26_PS_Msk = 0x1
	// Bit PS.
	PORT_PCR26_PS = 0x1
	// Internal pulldown resistor is enabled on the corresponding pin, if the corresponding PE field is set.
	PORT_PCR26_PS_0 = 0x0
	// Internal pullup resistor is enabled on the corresponding pin, if the corresponding PE field is set.
	PORT_PCR26_PS_1 = 0x1
	// Position of PE field.
	PORT_PCR26_PE_Pos = 0x1
	// Bit mask of PE field.
	PORT_PCR26_PE_Msk = 0x2
	// Bit PE.
	PORT_PCR26_PE = 0x2
	// Internal pullup or pulldown resistor is not enabled on the corresponding pin.
	PORT_PCR26_PE_0 = 0x0
	// Internal pullup or pulldown resistor is enabled on the corresponding pin, if the pin is configured as a digital input.
	PORT_PCR26_PE_1 = 0x1
	// Position of SRE field.
	PORT_PCR26_SRE_Pos = 0x2
	// Bit mask of SRE field.
	PORT_PCR26_SRE_Msk = 0x4
	// Bit SRE.
	PORT_PCR26_SRE = 0x4
	// Fast slew rate is configured on the corresponding pin, if the pin is configured as a digital output.
	PORT_PCR26_SRE_0 = 0x0
	// Slow slew rate is configured on the corresponding pin, if the pin is configured as a digital output.
	PORT_PCR26_SRE_1 = 0x1
	// Position of PFE field.
	PORT_PCR26_PFE_Pos = 0x4
	// Bit mask of PFE field.
	PORT_PCR26_PFE_Msk = 0x10
	// Bit PFE.
	PORT_PCR26_PFE = 0x10
	// Passive input filter is disabled on the corresponding pin.
	PORT_PCR26_PFE_0 = 0x0
	// Passive input filter is enabled on the corresponding pin, if the pin is configured as a digital input. Refer to the device data sheet for filter characteristics.
	PORT_PCR26_PFE_1 = 0x1
	// Position of DSE field.
	PORT_PCR26_DSE_Pos = 0x6
	// Bit mask of DSE field.
	PORT_PCR26_DSE_Msk = 0x40
	// Bit DSE.
	PORT_PCR26_DSE = 0x40
	// Low drive strength is configured on the corresponding pin, if pin is configured as a digital output.
	PORT_PCR26_DSE_0 = 0x0
	// High drive strength is configured on the corresponding pin, if pin is configured as a digital output.
	PORT_PCR26_DSE_1 = 0x1
	// Position of MUX field.
	PORT_PCR26_MUX_Pos = 0x8
	// Bit mask of MUX field.
	PORT_PCR26_MUX_Msk = 0x700
	// Pin disabled (Alternative 0) (analog).
	PORT_PCR26_MUX_000 = 0x0
	// Alternative 1 (GPIO).
	PORT_PCR26_MUX_001 = 0x1
	// Alternative 2 (chip-specific).
	PORT_PCR26_MUX_010 = 0x2
	// Alternative 3 (chip-specific).
	PORT_PCR26_MUX_011 = 0x3
	// Alternative 4 (chip-specific).
	PORT_PCR26_MUX_100 = 0x4
	// Alternative 5 (chip-specific).
	PORT_PCR26_MUX_101 = 0x5
	// Alternative 6 (chip-specific).
	PORT_PCR26_MUX_110 = 0x6
	// Alternative 7 (chip-specific).
	PORT_PCR26_MUX_111 = 0x7
	// Position of IRQC field.
	PORT_PCR26_IRQC_Pos = 0x10
	// Bit mask of IRQC field.
	PORT_PCR26_IRQC_Msk = 0xf0000
	// Interrupt Status Flag (ISF) is disabled.
	PORT_PCR26_IRQC_0000 = 0x0
	// ISF flag and DMA request on rising edge.
	PORT_PCR26_IRQC_0001 = 0x1
	// ISF flag and DMA request on falling edge.
	PORT_PCR26_IRQC_0010 = 0x2
	// ISF flag and DMA request on either edge.
	PORT_PCR26_IRQC_0011 = 0x3
	// ISF flag and Interrupt when logic 0.
	PORT_PCR26_IRQC_1000 = 0x8
	// ISF flag and Interrupt on rising-edge.
	PORT_PCR26_IRQC_1001 = 0x9
	// ISF flag and Interrupt on falling-edge.
	PORT_PCR26_IRQC_1010 = 0xa
	// ISF flag and Interrupt on either edge.
	PORT_PCR26_IRQC_1011 = 0xb
	// ISF flag and Interrupt when logic 1.
	PORT_PCR26_IRQC_1100 = 0xc
	// Position of ISF field.
	PORT_PCR26_ISF_Pos = 0x18
	// Bit mask of ISF field.
	PORT_PCR26_ISF_Msk = 0x1000000
	// Bit ISF.
	PORT_PCR26_ISF = 0x1000000
	// Configured interrupt is not detected.
	PORT_PCR26_ISF_0 = 0x0
	// Configured interrupt is detected. If the pin is configured to generate a DMA request, then the corresponding flag will be cleared automatically at the completion of the requested DMA transfer. Otherwise, the flag remains set until a logic 1 is written to the flag. If the pin is configured for a level sensitive interrupt and the pin remains asserted, then the flag is set again immediately after it is cleared.
	PORT_PCR26_ISF_1 = 0x1

	// PCR27: Pin Control Register n
	// Position of PS field.
	PORT_PCR27_PS_Pos = 0x0
	// Bit mask of PS field.
	PORT_PCR27_PS_Msk = 0x1
	// Bit PS.
	PORT_PCR27_PS = 0x1
	// Internal pulldown resistor is enabled on the corresponding pin, if the corresponding PE field is set.
	PORT_PCR27_PS_0 = 0x0
	// Internal pullup resistor is enabled on the corresponding pin, if the corresponding PE field is set.
	PORT_PCR27_PS_1 = 0x1
	// Position of PE field.
	PORT_PCR27_PE_Pos = 0x1
	// Bit mask of PE field.
	PORT_PCR27_PE_Msk = 0x2
	// Bit PE.
	PORT_PCR27_PE = 0x2
	// Internal pullup or pulldown resistor is not enabled on the corresponding pin.
	PORT_PCR27_PE_0 = 0x0
	// Internal pullup or pulldown resistor is enabled on the corresponding pin, if the pin is configured as a digital input.
	PORT_PCR27_PE_1 = 0x1
	// Position of SRE field.
	PORT_PCR27_SRE_Pos = 0x2
	// Bit mask of SRE field.
	PORT_PCR27_SRE_Msk = 0x4
	// Bit SRE.
	PORT_PCR27_SRE = 0x4
	// Fast slew rate is configured on the corresponding pin, if the pin is configured as a digital output.
	PORT_PCR27_SRE_0 = 0x0
	// Slow slew rate is configured on the corresponding pin, if the pin is configured as a digital output.
	PORT_PCR27_SRE_1 = 0x1
	// Position of PFE field.
	PORT_PCR27_PFE_Pos = 0x4
	// Bit mask of PFE field.
	PORT_PCR27_PFE_Msk = 0x10
	// Bit PFE.
	PORT_PCR27_PFE = 0x10
	// Passive input filter is disabled on the corresponding pin.
	PORT_PCR27_PFE_0 = 0x0
	// Passive input filter is enabled on the corresponding pin, if the pin is configured as a digital input. Refer to the device data sheet for filter characteristics.
	PORT_PCR27_PFE_1 = 0x1
	// Position of DSE field.
	PORT_PCR27_DSE_Pos = 0x6
	// Bit mask of DSE field.
	PORT_PCR27_DSE_Msk = 0x40
	// Bit DSE.
	PORT_PCR27_DSE = 0x40
	// Low drive strength is configured on the corresponding pin, if pin is configured as a digital output.
	PORT_PCR27_DSE_0 = 0x0
	// High drive strength is configured on the corresponding pin, if pin is configured as a digital output.
	PORT_PCR27_DSE_1 = 0x1
	// Position of MUX field.
	PORT_PCR27_MUX_Pos = 0x8
	// Bit mask of MUX field.
	PORT_PCR27_MUX_Msk = 0x700
	// Pin disabled (Alternative 0) (analog).
	PORT_PCR27_MUX_000 = 0x0
	// Alternative 1 (GPIO).
	PORT_PCR27_MUX_001 = 0x1
	// Alternative 2 (chip-specific).
	PORT_PCR27_MUX_010 = 0x2
	// Alternative 3 (chip-specific).
	PORT_PCR27_MUX_011 = 0x3
	// Alternative 4 (chip-specific).
	PORT_PCR27_MUX_100 = 0x4
	// Alternative 5 (chip-specific).
	PORT_PCR27_MUX_101 = 0x5
	// Alternative 6 (chip-specific).
	PORT_PCR27_MUX_110 = 0x6
	// Alternative 7 (chip-specific).
	PORT_PCR27_MUX_111 = 0x7
	// Position of IRQC field.
	PORT_PCR27_IRQC_Pos = 0x10
	// Bit mask of IRQC field.
	PORT_PCR27_IRQC_Msk = 0xf0000
	// Interrupt Status Flag (ISF) is disabled.
	PORT_PCR27_IRQC_0000 = 0x0
	// ISF flag and DMA request on rising edge.
	PORT_PCR27_IRQC_0001 = 0x1
	// ISF flag and DMA request on falling edge.
	PORT_PCR27_IRQC_0010 = 0x2
	// ISF flag and DMA request on either edge.
	PORT_PCR27_IRQC_0011 = 0x3
	// ISF flag and Interrupt when logic 0.
	PORT_PCR27_IRQC_1000 = 0x8
	// ISF flag and Interrupt on rising-edge.
	PORT_PCR27_IRQC_1001 = 0x9
	// ISF flag and Interrupt on falling-edge.
	PORT_PCR27_IRQC_1010 = 0xa
	// ISF flag and Interrupt on either edge.
	PORT_PCR27_IRQC_1011 = 0xb
	// ISF flag and Interrupt when logic 1.
	PORT_PCR27_IRQC_1100 = 0xc
	// Position of ISF field.
	PORT_PCR27_ISF_Pos = 0x18
	// Bit mask of ISF field.
	PORT_PCR27_ISF_Msk = 0x1000000
	// Bit ISF.
	PORT_PCR27_ISF = 0x1000000
	// Configured interrupt is not detected.
	PORT_PCR27_ISF_0 = 0x0
	// Configured interrupt is detected. If the pin is configured to generate a DMA request, then the corresponding flag will be cleared automatically at the completion of the requested DMA transfer. Otherwise, the flag remains set until a logic 1 is written to the flag. If the pin is configured for a level sensitive interrupt and the pin remains asserted, then the flag is set again immediately after it is cleared.
	PORT_PCR27_ISF_1 = 0x1

	// PCR28: Pin Control Register n
	// Position of PS field.
	PORT_PCR28_PS_Pos = 0x0
	// Bit mask of PS field.
	PORT_PCR28_PS_Msk = 0x1
	// Bit PS.
	PORT_PCR28_PS = 0x1
	// Internal pulldown resistor is enabled on the corresponding pin, if the corresponding PE field is set.
	PORT_PCR28_PS_0 = 0x0
	// Internal pullup resistor is enabled on the corresponding pin, if the corresponding PE field is set.
	PORT_PCR28_PS_1 = 0x1
	// Position of PE field.
	PORT_PCR28_PE_Pos = 0x1
	// Bit mask of PE field.
	PORT_PCR28_PE_Msk = 0x2
	// Bit PE.
	PORT_PCR28_PE = 0x2
	// Internal pullup or pulldown resistor is not enabled on the corresponding pin.
	PORT_PCR28_PE_0 = 0x0
	// Internal pullup or pulldown resistor is enabled on the corresponding pin, if the pin is configured as a digital input.
	PORT_PCR28_PE_1 = 0x1
	// Position of SRE field.
	PORT_PCR28_SRE_Pos = 0x2
	// Bit mask of SRE field.
	PORT_PCR28_SRE_Msk = 0x4
	// Bit SRE.
	PORT_PCR28_SRE = 0x4
	// Fast slew rate is configured on the corresponding pin, if the pin is configured as a digital output.
	PORT_PCR28_SRE_0 = 0x0
	// Slow slew rate is configured on the corresponding pin, if the pin is configured as a digital output.
	PORT_PCR28_SRE_1 = 0x1
	// Position of PFE field.
	PORT_PCR28_PFE_Pos = 0x4
	// Bit mask of PFE field.
	PORT_PCR28_PFE_Msk = 0x10
	// Bit PFE.
	PORT_PCR28_PFE = 0x10
	// Passive input filter is disabled on the corresponding pin.
	PORT_PCR28_PFE_0 = 0x0
	// Passive input filter is enabled on the corresponding pin, if the pin is configured as a digital input. Refer to the device data sheet for filter characteristics.
	PORT_PCR28_PFE_1 = 0x1
	// Position of DSE field.
	PORT_PCR28_DSE_Pos = 0x6
	// Bit mask of DSE field.
	PORT_PCR28_DSE_Msk = 0x40
	// Bit DSE.
	PORT_PCR28_DSE = 0x40
	// Low drive strength is configured on the corresponding pin, if pin is configured as a digital output.
	PORT_PCR28_DSE_0 = 0x0
	// High drive strength is configured on the corresponding pin, if pin is configured as a digital output.
	PORT_PCR28_DSE_1 = 0x1
	// Position of MUX field.
	PORT_PCR28_MUX_Pos = 0x8
	// Bit mask of MUX field.
	PORT_PCR28_MUX_Msk = 0x700
	// Pin disabled (Alternative 0) (analog).
	PORT_PCR28_MUX_000 = 0x0
	// Alternative 1 (GPIO).
	PORT_PCR28_MUX_001 = 0x1
	// Alternative 2 (chip-specific).
	PORT_PCR28_MUX_010 = 0x2
	// Alternative 3 (chip-specific).
	PORT_PCR28_MUX_011 = 0x3
	// Alternative 4 (chip-specific).
	PORT_PCR28_MUX_100 = 0x4
	// Alternative 5 (chip-specific).
	PORT_PCR28_MUX_101 = 0x5
	// Alternative 6 (chip-specific).
	PORT_PCR28_MUX_110 = 0x6
	// Alternative 7 (chip-specific).
	PORT_PCR28_MUX_111 = 0x7
	// Position of IRQC field.
	PORT_PCR28_IRQC_Pos = 0x10
	// Bit mask of IRQC field.
	PORT_PCR28_IRQC_Msk = 0xf0000
	// Interrupt Status Flag (ISF) is disabled.
	PORT_PCR28_IRQC_0000 = 0x0
	// ISF flag and DMA request on rising edge.
	PORT_PCR28_IRQC_0001 = 0x1
	// ISF flag and DMA request on falling edge.
	PORT_PCR28_IRQC_0010 = 0x2
	// ISF flag and DMA request on either edge.
	PORT_PCR28_IRQC_0011 = 0x3
	// ISF flag and Interrupt when logic 0.
	PORT_PCR28_IRQC_1000 = 0x8
	// ISF flag and Interrupt on rising-edge.
	PORT_PCR28_IRQC_1001 = 0x9
	// ISF flag and Interrupt on falling-edge.
	PORT_PCR28_IRQC_1010 = 0xa
	// ISF flag and Interrupt on either edge.
	PORT_PCR28_IRQC_1011 = 0xb
	// ISF flag and Interrupt when logic 1.
	PORT_PCR28_IRQC_1100 = 0xc
	// Position of ISF field.
	PORT_PCR28_ISF_Pos = 0x18
	// Bit mask of ISF field.
	PORT_PCR28_ISF_Msk = 0x1000000
	// Bit ISF.
	PORT_PCR28_ISF = 0x1000000
	// Configured interrupt is not detected.
	PORT_PCR28_ISF_0 = 0x0
	// Configured interrupt is detected. If the pin is configured to generate a DMA request, then the corresponding flag will be cleared automatically at the completion of the requested DMA transfer. Otherwise, the flag remains set until a logic 1 is written to the flag. If the pin is configured for a level sensitive interrupt and the pin remains asserted, then the flag is set again immediately after it is cleared.
	PORT_PCR28_ISF_1 = 0x1

	// PCR29: Pin Control Register n
	// Position of PS field.
	PORT_PCR29_PS_Pos = 0x0
	// Bit mask of PS field.
	PORT_PCR29_PS_Msk = 0x1
	// Bit PS.
	PORT_PCR29_PS = 0x1
	// Internal pulldown resistor is enabled on the corresponding pin, if the corresponding PE field is set.
	PORT_PCR29_PS_0 = 0x0
	// Internal pullup resistor is enabled on the corresponding pin, if the corresponding PE field is set.
	PORT_PCR29_PS_1 = 0x1
	// Position of PE field.
	PORT_PCR29_PE_Pos = 0x1
	// Bit mask of PE field.
	PORT_PCR29_PE_Msk = 0x2
	// Bit PE.
	PORT_PCR29_PE = 0x2
	// Internal pullup or pulldown resistor is not enabled on the corresponding pin.
	PORT_PCR29_PE_0 = 0x0
	// Internal pullup or pulldown resistor is enabled on the corresponding pin, if the pin is configured as a digital input.
	PORT_PCR29_PE_1 = 0x1
	// Position of SRE field.
	PORT_PCR29_SRE_Pos = 0x2
	// Bit mask of SRE field.
	PORT_PCR29_SRE_Msk = 0x4
	// Bit SRE.
	PORT_PCR29_SRE = 0x4
	// Fast slew rate is configured on the corresponding pin, if the pin is configured as a digital output.
	PORT_PCR29_SRE_0 = 0x0
	// Slow slew rate is configured on the corresponding pin, if the pin is configured as a digital output.
	PORT_PCR29_SRE_1 = 0x1
	// Position of PFE field.
	PORT_PCR29_PFE_Pos = 0x4
	// Bit mask of PFE field.
	PORT_PCR29_PFE_Msk = 0x10
	// Bit PFE.
	PORT_PCR29_PFE = 0x10
	// Passive input filter is disabled on the corresponding pin.
	PORT_PCR29_PFE_0 = 0x0
	// Passive input filter is enabled on the corresponding pin, if the pin is configured as a digital input. Refer to the device data sheet for filter characteristics.
	PORT_PCR29_PFE_1 = 0x1
	// Position of DSE field.
	PORT_PCR29_DSE_Pos = 0x6
	// Bit mask of DSE field.
	PORT_PCR29_DSE_Msk = 0x40
	// Bit DSE.
	PORT_PCR29_DSE = 0x40
	// Low drive strength is configured on the corresponding pin, if pin is configured as a digital output.
	PORT_PCR29_DSE_0 = 0x0
	// High drive strength is configured on the corresponding pin, if pin is configured as a digital output.
	PORT_PCR29_DSE_1 = 0x1
	// Position of MUX field.
	PORT_PCR29_MUX_Pos = 0x8
	// Bit mask of MUX field.
	PORT_PCR29_MUX_Msk = 0x700
	// Pin disabled (Alternative 0) (analog).
	PORT_PCR29_MUX_000 = 0x0
	// Alternative 1 (GPIO).
	PORT_PCR29_MUX_001 = 0x1
	// Alternative 2 (chip-specific).
	PORT_PCR29_MUX_010 = 0x2
	// Alternative 3 (chip-specific).
	PORT_PCR29_MUX_011 = 0x3
	// Alternative 4 (chip-specific).
	PORT_PCR29_MUX_100 = 0x4
	// Alternative 5 (chip-specific).
	PORT_PCR29_MUX_101 = 0x5
	// Alternative 6 (chip-specific).
	PORT_PCR29_MUX_110 = 0x6
	// Alternative 7 (chip-specific).
	PORT_PCR29_MUX_111 = 0x7
	// Position of IRQC field.
	PORT_PCR29_IRQC_Pos = 0x10
	// Bit mask of IRQC field.
	PORT_PCR29_IRQC_Msk = 0xf0000
	// Interrupt Status Flag (ISF) is disabled.
	PORT_PCR29_IRQC_0000 = 0x0
	// ISF flag and DMA request on rising edge.
	PORT_PCR29_IRQC_0001 = 0x1
	// ISF flag and DMA request on falling edge.
	PORT_PCR29_IRQC_0010 = 0x2
	// ISF flag and DMA request on either edge.
	PORT_PCR29_IRQC_0011 = 0x3
	// ISF flag and Interrupt when logic 0.
	PORT_PCR29_IRQC_1000 = 0x8
	// ISF flag and Interrupt on rising-edge.
	PORT_PCR29_IRQC_1001 = 0x9
	// ISF flag and Interrupt on falling-edge.
	PORT_PCR29_IRQC_1010 = 0xa
	// ISF flag and Interrupt on either edge.
	PORT_PCR29_IRQC_1011 = 0xb
	// ISF flag and Interrupt when logic 1.
	PORT_PCR29_IRQC_1100 = 0xc
	// Position of ISF field.
	PORT_PCR29_ISF_Pos = 0x18
	// Bit mask of ISF field.
	PORT_PCR29_ISF_Msk = 0x1000000
	// Bit ISF.
	PORT_PCR29_ISF = 0x1000000
	// Configured interrupt is not detected.
	PORT_PCR29_ISF_0 = 0x0
	// Configured interrupt is detected. If the pin is configured to generate a DMA request, then the corresponding flag will be cleared automatically at the completion of the requested DMA transfer. Otherwise, the flag remains set until a logic 1 is written to the flag. If the pin is configured for a level sensitive interrupt and the pin remains asserted, then the flag is set again immediately after it is cleared.
	PORT_PCR29_ISF_1 = 0x1

	// PCR30: Pin Control Register n
	// Position of PS field.
	PORT_PCR30_PS_Pos = 0x0
	// Bit mask of PS field.
	PORT_PCR30_PS_Msk = 0x1
	// Bit PS.
	PORT_PCR30_PS = 0x1
	// Internal pulldown resistor is enabled on the corresponding pin, if the corresponding PE field is set.
	PORT_PCR30_PS_0 = 0x0
	// Internal pullup resistor is enabled on the corresponding pin, if the corresponding PE field is set.
	PORT_PCR30_PS_1 = 0x1
	// Position of PE field.
	PORT_PCR30_PE_Pos = 0x1
	// Bit mask of PE field.
	PORT_PCR30_PE_Msk = 0x2
	// Bit PE.
	PORT_PCR30_PE = 0x2
	// Internal pullup or pulldown resistor is not enabled on the corresponding pin.
	PORT_PCR30_PE_0 = 0x0
	// Internal pullup or pulldown resistor is enabled on the corresponding pin, if the pin is configured as a digital input.
	PORT_PCR30_PE_1 = 0x1
	// Position of SRE field.
	PORT_PCR30_SRE_Pos = 0x2
	// Bit mask of SRE field.
	PORT_PCR30_SRE_Msk = 0x4
	// Bit SRE.
	PORT_PCR30_SRE = 0x4
	// Fast slew rate is configured on the corresponding pin, if the pin is configured as a digital output.
	PORT_PCR30_SRE_0 = 0x0
	// Slow slew rate is configured on the corresponding pin, if the pin is configured as a digital output.
	PORT_PCR30_SRE_1 = 0x1
	// Position of PFE field.
	PORT_PCR30_PFE_Pos = 0x4
	// Bit mask of PFE field.
	PORT_PCR30_PFE_Msk = 0x10
	// Bit PFE.
	PORT_PCR30_PFE = 0x10
	// Passive input filter is disabled on the corresponding pin.
	PORT_PCR30_PFE_0 = 0x0
	// Passive input filter is enabled on the corresponding pin, if the pin is configured as a digital input. Refer to the device data sheet for filter characteristics.
	PORT_PCR30_PFE_1 = 0x1
	// Position of DSE field.
	PORT_PCR30_DSE_Pos = 0x6
	// Bit mask of DSE field.
	PORT_PCR30_DSE_Msk = 0x40
	// Bit DSE.
	PORT_PCR30_DSE = 0x40
	// Low drive strength is configured on the corresponding pin, if pin is configured as a digital output.
	PORT_PCR30_DSE_0 = 0x0
	// High drive strength is configured on the corresponding pin, if pin is configured as a digital output.
	PORT_PCR30_DSE_1 = 0x1
	// Position of MUX field.
	PORT_PCR30_MUX_Pos = 0x8
	// Bit mask of MUX field.
	PORT_PCR30_MUX_Msk = 0x700
	// Pin disabled (Alternative 0) (analog).
	PORT_PCR30_MUX_000 = 0x0
	// Alternative 1 (GPIO).
	PORT_PCR30_MUX_001 = 0x1
	// Alternative 2 (chip-specific).
	PORT_PCR30_MUX_010 = 0x2
	// Alternative 3 (chip-specific).
	PORT_PCR30_MUX_011 = 0x3
	// Alternative 4 (chip-specific).
	PORT_PCR30_MUX_100 = 0x4
	// Alternative 5 (chip-specific).
	PORT_PCR30_MUX_101 = 0x5
	// Alternative 6 (chip-specific).
	PORT_PCR30_MUX_110 = 0x6
	// Alternative 7 (chip-specific).
	PORT_PCR30_MUX_111 = 0x7
	// Position of IRQC field.
	PORT_PCR30_IRQC_Pos = 0x10
	// Bit mask of IRQC field.
	PORT_PCR30_IRQC_Msk = 0xf0000
	// Interrupt Status Flag (ISF) is disabled.
	PORT_PCR30_IRQC_0000 = 0x0
	// ISF flag and DMA request on rising edge.
	PORT_PCR30_IRQC_0001 = 0x1
	// ISF flag and DMA request on falling edge.
	PORT_PCR30_IRQC_0010 = 0x2
	// ISF flag and DMA request on either edge.
	PORT_PCR30_IRQC_0011 = 0x3
	// ISF flag and Interrupt when logic 0.
	PORT_PCR30_IRQC_1000 = 0x8
	// ISF flag and Interrupt on rising-edge.
	PORT_PCR30_IRQC_1001 = 0x9
	// ISF flag and Interrupt on falling-edge.
	PORT_PCR30_IRQC_1010 = 0xa
	// ISF flag and Interrupt on either edge.
	PORT_PCR30_IRQC_1011 = 0xb
	// ISF flag and Interrupt when logic 1.
	PORT_PCR30_IRQC_1100 = 0xc
	// Position of ISF field.
	PORT_PCR30_ISF_Pos = 0x18
	// Bit mask of ISF field.
	PORT_PCR30_ISF_Msk = 0x1000000
	// Bit ISF.
	PORT_PCR30_ISF = 0x1000000
	// Configured interrupt is not detected.
	PORT_PCR30_ISF_0 = 0x0
	// Configured interrupt is detected. If the pin is configured to generate a DMA request, then the corresponding flag will be cleared automatically at the completion of the requested DMA transfer. Otherwise, the flag remains set until a logic 1 is written to the flag. If the pin is configured for a level sensitive interrupt and the pin remains asserted, then the flag is set again immediately after it is cleared.
	PORT_PCR30_ISF_1 = 0x1

	// PCR31: Pin Control Register n
	// Position of PS field.
	PORT_PCR31_PS_Pos = 0x0
	// Bit mask of PS field.
	PORT_PCR31_PS_Msk = 0x1
	// Bit PS.
	PORT_PCR31_PS = 0x1
	// Internal pulldown resistor is enabled on the corresponding pin, if the corresponding PE field is set.
	PORT_PCR31_PS_0 = 0x0
	// Internal pullup resistor is enabled on the corresponding pin, if the corresponding PE field is set.
	PORT_PCR31_PS_1 = 0x1
	// Position of PE field.
	PORT_PCR31_PE_Pos = 0x1
	// Bit mask of PE field.
	PORT_PCR31_PE_Msk = 0x2
	// Bit PE.
	PORT_PCR31_PE = 0x2
	// Internal pullup or pulldown resistor is not enabled on the corresponding pin.
	PORT_PCR31_PE_0 = 0x0
	// Internal pullup or pulldown resistor is enabled on the corresponding pin, if the pin is configured as a digital input.
	PORT_PCR31_PE_1 = 0x1
	// Position of SRE field.
	PORT_PCR31_SRE_Pos = 0x2
	// Bit mask of SRE field.
	PORT_PCR31_SRE_Msk = 0x4
	// Bit SRE.
	PORT_PCR31_SRE = 0x4
	// Fast slew rate is configured on the corresponding pin, if the pin is configured as a digital output.
	PORT_PCR31_SRE_0 = 0x0
	// Slow slew rate is configured on the corresponding pin, if the pin is configured as a digital output.
	PORT_PCR31_SRE_1 = 0x1
	// Position of PFE field.
	PORT_PCR31_PFE_Pos = 0x4
	// Bit mask of PFE field.
	PORT_PCR31_PFE_Msk = 0x10
	// Bit PFE.
	PORT_PCR31_PFE = 0x10
	// Passive input filter is disabled on the corresponding pin.
	PORT_PCR31_PFE_0 = 0x0
	// Passive input filter is enabled on the corresponding pin, if the pin is configured as a digital input. Refer to the device data sheet for filter characteristics.
	PORT_PCR31_PFE_1 = 0x1
	// Position of DSE field.
	PORT_PCR31_DSE_Pos = 0x6
	// Bit mask of DSE field.
	PORT_PCR31_DSE_Msk = 0x40
	// Bit DSE.
	PORT_PCR31_DSE = 0x40
	// Low drive strength is configured on the corresponding pin, if pin is configured as a digital output.
	PORT_PCR31_DSE_0 = 0x0
	// High drive strength is configured on the corresponding pin, if pin is configured as a digital output.
	PORT_PCR31_DSE_1 = 0x1
	// Position of MUX field.
	PORT_PCR31_MUX_Pos = 0x8
	// Bit mask of MUX field.
	PORT_PCR31_MUX_Msk = 0x700
	// Pin disabled (Alternative 0) (analog).
	PORT_PCR31_MUX_000 = 0x0
	// Alternative 1 (GPIO).
	PORT_PCR31_MUX_001 = 0x1
	// Alternative 2 (chip-specific).
	PORT_PCR31_MUX_010 = 0x2
	// Alternative 3 (chip-specific).
	PORT_PCR31_MUX_011 = 0x3
	// Alternative 4 (chip-specific).
	PORT_PCR31_MUX_100 = 0x4
	// Alternative 5 (chip-specific).
	PORT_PCR31_MUX_101 = 0x5
	// Alternative 6 (chip-specific).
	PORT_PCR31_MUX_110 = 0x6
	// Alternative 7 (chip-specific).
	PORT_PCR31_MUX_111 = 0x7
	// Position of IRQC field.
	PORT_PCR31_IRQC_Pos = 0x10
	// Bit mask of IRQC field.
	PORT_PCR31_IRQC_Msk = 0xf0000
	// Interrupt Status Flag (ISF) is disabled.
	PORT_PCR31_IRQC_0000 = 0x0
	// ISF flag and DMA request on rising edge.
	PORT_PCR31_IRQC_0001 = 0x1
	// ISF flag and DMA request on falling edge.
	PORT_PCR31_IRQC_0010 = 0x2
	// ISF flag and DMA request on either edge.
	PORT_PCR31_IRQC_0011 = 0x3
	// ISF flag and Interrupt when logic 0.
	PORT_PCR31_IRQC_1000 = 0x8
	// ISF flag and Interrupt on rising-edge.
	PORT_PCR31_IRQC_1001 = 0x9
	// ISF flag and Interrupt on falling-edge.
	PORT_PCR31_IRQC_1010 = 0xa
	// ISF flag and Interrupt on either edge.
	PORT_PCR31_IRQC_1011 = 0xb
	// ISF flag and Interrupt when logic 1.
	PORT_PCR31_IRQC_1100 = 0xc
	// Position of ISF field.
	PORT_PCR31_ISF_Pos = 0x18
	// Bit mask of ISF field.
	PORT_PCR31_ISF_Msk = 0x1000000
	// Bit ISF.
	PORT_PCR31_ISF = 0x1000000
	// Configured interrupt is not detected.
	PORT_PCR31_ISF_0 = 0x0
	// Configured interrupt is detected. If the pin is configured to generate a DMA request, then the corresponding flag will be cleared automatically at the completion of the requested DMA transfer. Otherwise, the flag remains set until a logic 1 is written to the flag. If the pin is configured for a level sensitive interrupt and the pin remains asserted, then the flag is set again immediately after it is cleared.
	PORT_PCR31_ISF_1 = 0x1

	// GPCLR: Global Pin Control Low Register
	// Position of GPWD field.
	PORT_GPCLR_GPWD_Pos = 0x0
	// Bit mask of GPWD field.
	PORT_GPCLR_GPWD_Msk = 0xffff
	// Position of GPWE field.
	PORT_GPCLR_GPWE_Pos = 0x10
	// Bit mask of GPWE field.
	PORT_GPCLR_GPWE_Msk = 0xffff0000
	// Corresponding Pin Control Register is not updated with the value in GPWD.
	PORT_GPCLR_GPWE_0 = 0x0
	// Corresponding Pin Control Register is updated with the value in GPWD.
	PORT_GPCLR_GPWE_1 = 0x1

	// GPCHR: Global Pin Control High Register
	// Position of GPWD field.
	PORT_GPCHR_GPWD_Pos = 0x0
	// Bit mask of GPWD field.
	PORT_GPCHR_GPWD_Msk = 0xffff
	// Position of GPWE field.
	PORT_GPCHR_GPWE_Pos = 0x10
	// Bit mask of GPWE field.
	PORT_GPCHR_GPWE_Msk = 0xffff0000
	// Corresponding Pin Control Register is not updated with the value in GPWD.
	PORT_GPCHR_GPWE_0 = 0x0
	// Corresponding Pin Control Register is updated with the value in GPWD.
	PORT_GPCHR_GPWE_1 = 0x1

	// ISFR: Interrupt Status Flag Register
	// Position of ISF field.
	PORT_ISFR_ISF_Pos = 0x0
	// Bit mask of ISF field.
	PORT_ISFR_ISF_Msk = 0xffffffff
	// Configured interrupt is not detected.
	PORT_ISFR_ISF_0 = 0x0
	// Configured interrupt is detected. If the pin is configured to generate a DMA request, then the corresponding flag will be cleared automatically at the completion of the requested DMA transfer. Otherwise, the flag remains set until a logic 1 is written to the flag. If the pin is configured for a level sensitive interrupt and the pin remains asserted, then the flag is set again immediately after it is cleared.
	PORT_ISFR_ISF_1 = 0x1
)

// Bitfields for LPUART0: Universal Asynchronous Receiver/Transmitter
const (
	// BAUD: LPUART Baud Rate Register
	// Position of SBR field.
	LPUART0_BAUD_SBR_Pos = 0x0
	// Bit mask of SBR field.
	LPUART0_BAUD_SBR_Msk = 0x1fff
	// Position of SBNS field.
	LPUART0_BAUD_SBNS_Pos = 0xd
	// Bit mask of SBNS field.
	LPUART0_BAUD_SBNS_Msk = 0x2000
	// Bit SBNS.
	LPUART0_BAUD_SBNS = 0x2000
	// One stop bit.
	LPUART0_BAUD_SBNS_0 = 0x0
	// Two stop bits.
	LPUART0_BAUD_SBNS_1 = 0x1
	// Position of RXEDGIE field.
	LPUART0_BAUD_RXEDGIE_Pos = 0xe
	// Bit mask of RXEDGIE field.
	LPUART0_BAUD_RXEDGIE_Msk = 0x4000
	// Bit RXEDGIE.
	LPUART0_BAUD_RXEDGIE = 0x4000
	// Hardware interrupts from LPUART_STAT[RXEDGIF] disabled (use polling).
	LPUART0_BAUD_RXEDGIE_0 = 0x0
	// Hardware interrupt requested when LPUART_STAT[RXEDGIF] flag is 1.
	LPUART0_BAUD_RXEDGIE_1 = 0x1
	// Position of LBKDIE field.
	LPUART0_BAUD_LBKDIE_Pos = 0xf
	// Bit mask of LBKDIE field.
	LPUART0_BAUD_LBKDIE_Msk = 0x8000
	// Bit LBKDIE.
	LPUART0_BAUD_LBKDIE = 0x8000
	// Hardware interrupts from LPUART_STAT[LBKDIF] disabled (use polling).
	LPUART0_BAUD_LBKDIE_0 = 0x0
	// Hardware interrupt requested when LPUART_STAT[LBKDIF] flag is 1.
	LPUART0_BAUD_LBKDIE_1 = 0x1
	// Position of RESYNCDIS field.
	LPUART0_BAUD_RESYNCDIS_Pos = 0x10
	// Bit mask of RESYNCDIS field.
	LPUART0_BAUD_RESYNCDIS_Msk = 0x10000
	// Bit RESYNCDIS.
	LPUART0_BAUD_RESYNCDIS = 0x10000
	// Resynchronization during received data word is supported
	LPUART0_BAUD_RESYNCDIS_0 = 0x0
	// Resynchronization during received data word is disabled
	LPUART0_BAUD_RESYNCDIS_1 = 0x1
	// Position of BOTHEDGE field.
	LPUART0_BAUD_BOTHEDGE_Pos = 0x11
	// Bit mask of BOTHEDGE field.
	LPUART0_BAUD_BOTHEDGE_Msk = 0x20000
	// Bit BOTHEDGE.
	LPUART0_BAUD_BOTHEDGE = 0x20000
	// Receiver samples input data using the rising edge of the baud rate clock.
	LPUART0_BAUD_BOTHEDGE_0 = 0x0
	// Receiver samples input data using the rising and falling edge of the baud rate clock.
	LPUART0_BAUD_BOTHEDGE_1 = 0x1
	// Position of MATCFG field.
	LPUART0_BAUD_MATCFG_Pos = 0x12
	// Bit mask of MATCFG field.
	LPUART0_BAUD_MATCFG_Msk = 0xc0000
	// Address Match Wakeup
	LPUART0_BAUD_MATCFG_00 = 0x0
	// Idle Match Wakeup
	LPUART0_BAUD_MATCFG_01 = 0x1
	// Match On and Match Off
	LPUART0_BAUD_MATCFG_10 = 0x2
	// Enables RWU on Data Match and Match On/Off for transmitter CTS input
	LPUART0_BAUD_MATCFG_11 = 0x3
	// Position of RDMAE field.
	LPUART0_BAUD_RDMAE_Pos = 0x15
	// Bit mask of RDMAE field.
	LPUART0_BAUD_RDMAE_Msk = 0x200000
	// Bit RDMAE.
	LPUART0_BAUD_RDMAE = 0x200000
	// DMA request disabled.
	LPUART0_BAUD_RDMAE_0 = 0x0
	// DMA request enabled.
	LPUART0_BAUD_RDMAE_1 = 0x1
	// Position of TDMAE field.
	LPUART0_BAUD_TDMAE_Pos = 0x17
	// Bit mask of TDMAE field.
	LPUART0_BAUD_TDMAE_Msk = 0x800000
	// Bit TDMAE.
	LPUART0_BAUD_TDMAE = 0x800000
	// DMA request disabled.
	LPUART0_BAUD_TDMAE_0 = 0x0
	// DMA request enabled.
	LPUART0_BAUD_TDMAE_1 = 0x1
	// Position of OSR field.
	LPUART0_BAUD_OSR_Pos = 0x18
	// Bit mask of OSR field.
	LPUART0_BAUD_OSR_Msk = 0x1f000000
	// Position of M10 field.
	LPUART0_BAUD_M10_Pos = 0x1d
	// Bit mask of M10 field.
	LPUART0_BAUD_M10_Msk = 0x20000000
	// Bit M10.
	LPUART0_BAUD_M10 = 0x20000000
	// Receiver and transmitter use 8-bit or 9-bit data characters.
	LPUART0_BAUD_M10_0 = 0x0
	// Receiver and transmitter use 10-bit data characters.
	LPUART0_BAUD_M10_1 = 0x1
	// Position of MAEN2 field.
	LPUART0_BAUD_MAEN2_Pos = 0x1e
	// Bit mask of MAEN2 field.
	LPUART0_BAUD_MAEN2_Msk = 0x40000000
	// Bit MAEN2.
	LPUART0_BAUD_MAEN2 = 0x40000000
	// Normal operation.
	LPUART0_BAUD_MAEN2_0 = 0x0
	// Enables automatic address matching or data matching mode for MATCH[MA2].
	LPUART0_BAUD_MAEN2_1 = 0x1
	// Position of MAEN1 field.
	LPUART0_BAUD_MAEN1_Pos = 0x1f
	// Bit mask of MAEN1 field.
	LPUART0_BAUD_MAEN1_Msk = 0x80000000
	// Bit MAEN1.
	LPUART0_BAUD_MAEN1 = 0x80000000
	// Normal operation.
	LPUART0_BAUD_MAEN1_0 = 0x0
	// Enables automatic address matching or data matching mode for MATCH[MA1].
	LPUART0_BAUD_MAEN1_1 = 0x1

	// STAT: LPUART Status Register
	// Position of MA2F field.
	LPUART0_STAT_MA2F_Pos = 0xe
	// Bit mask of MA2F field.
	LPUART0_STAT_MA2F_Msk = 0x4000
	// Bit MA2F.
	LPUART0_STAT_MA2F = 0x4000
	// Received data is not equal to MA2
	LPUART0_STAT_MA2F_0 = 0x0
	// Received data is equal to MA2
	LPUART0_STAT_MA2F_1 = 0x1
	// Position of MA1F field.
	LPUART0_STAT_MA1F_Pos = 0xf
	// Bit mask of MA1F field.
	LPUART0_STAT_MA1F_Msk = 0x8000
	// Bit MA1F.
	LPUART0_STAT_MA1F = 0x8000
	// Received data is not equal to MA1
	LPUART0_STAT_MA1F_0 = 0x0
	// Received data is equal to MA1
	LPUART0_STAT_MA1F_1 = 0x1
	// Position of PF field.
	LPUART0_STAT_PF_Pos = 0x10
	// Bit mask of PF field.
	LPUART0_STAT_PF_Msk = 0x10000
	// Bit PF.
	LPUART0_STAT_PF = 0x10000
	// No parity error.
	LPUART0_STAT_PF_0 = 0x0
	// Parity error.
	LPUART0_STAT_PF_1 = 0x1
	// Position of FE field.
	LPUART0_STAT_FE_Pos = 0x11
	// Bit mask of FE field.
	LPUART0_STAT_FE_Msk = 0x20000
	// Bit FE.
	LPUART0_STAT_FE = 0x20000
	// No framing error detected. This does not guarantee the framing is correct.
	LPUART0_STAT_FE_0 = 0x0
	// Framing error.
	LPUART0_STAT_FE_1 = 0x1
	// Position of NF field.
	LPUART0_STAT_NF_Pos = 0x12
	// Bit mask of NF field.
	LPUART0_STAT_NF_Msk = 0x40000
	// Bit NF.
	LPUART0_STAT_NF = 0x40000
	// No noise detected.
	LPUART0_STAT_NF_0 = 0x0
	// Noise detected in the received character in LPUART_DATA.
	LPUART0_STAT_NF_1 = 0x1
	// Position of OR field.
	LPUART0_STAT_OR_Pos = 0x13
	// Bit mask of OR field.
	LPUART0_STAT_OR_Msk = 0x80000
	// Bit OR.
	LPUART0_STAT_OR = 0x80000
	// No overrun.
	LPUART0_STAT_OR_0 = 0x0
	// Receive overrun (new LPUART data lost).
	LPUART0_STAT_OR_1 = 0x1
	// Position of IDLE field.
	LPUART0_STAT_IDLE_Pos = 0x14
	// Bit mask of IDLE field.
	LPUART0_STAT_IDLE_Msk = 0x100000
	// Bit IDLE.
	LPUART0_STAT_IDLE = 0x100000
	// No idle line detected.
	LPUART0_STAT_IDLE_0 = 0x0
	// Idle line was detected.
	LPUART0_STAT_IDLE_1 = 0x1
	// Position of RDRF field.
	LPUART0_STAT_RDRF_Pos = 0x15
	// Bit mask of RDRF field.
	LPUART0_STAT_RDRF_Msk = 0x200000
	// Bit RDRF.
	LPUART0_STAT_RDRF = 0x200000
	// Receive data buffer empty.
	LPUART0_STAT_RDRF_0 = 0x0
	// Receive data buffer full.
	LPUART0_STAT_RDRF_1 = 0x1
	// Position of TC field.
	LPUART0_STAT_TC_Pos = 0x16
	// Bit mask of TC field.
	LPUART0_STAT_TC_Msk = 0x400000
	// Bit TC.
	LPUART0_STAT_TC = 0x400000
	// Transmitter active (sending data, a preamble, or a break).
	LPUART0_STAT_TC_0 = 0x0
	// Transmitter idle (transmission activity complete).
	LPUART0_STAT_TC_1 = 0x1
	// Position of TDRE field.
	LPUART0_STAT_TDRE_Pos = 0x17
	// Bit mask of TDRE field.
	LPUART0_STAT_TDRE_Msk = 0x800000
	// Bit TDRE.
	LPUART0_STAT_TDRE = 0x800000
	// Transmit data buffer full.
	LPUART0_STAT_TDRE_0 = 0x0
	// Transmit data buffer empty.
	LPUART0_STAT_TDRE_1 = 0x1
	// Position of RAF field.
	LPUART0_STAT_RAF_Pos = 0x18
	// Bit mask of RAF field.
	LPUART0_STAT_RAF_Msk = 0x1000000
	// Bit RAF.
	LPUART0_STAT_RAF = 0x1000000
	// LPUART receiver idle waiting for a start bit.
	LPUART0_STAT_RAF_0 = 0x0
	// LPUART receiver active (LPUART_RX input not idle).
	LPUART0_STAT_RAF_1 = 0x1
	// Position of LBKDE field.
	LPUART0_STAT_LBKDE_Pos = 0x19
	// Bit mask of LBKDE field.
	LPUART0_STAT_LBKDE_Msk = 0x2000000
	// Bit LBKDE.
	LPUART0_STAT_LBKDE = 0x2000000
	// Break character is detected at length 10 bit times (if M = 0, SBNS = 0) or 11 (if M = 1, SBNS = 0 or M = 0, SBNS = 1) or 12 (if M = 1, SBNS = 1 or M10 = 1, SNBS = 0) or 13 (if M10 = 1, SNBS = 1).
	LPUART0_STAT_LBKDE_0 = 0x0
	// Break character is detected at length of 11 bit times (if M = 0, SBNS = 0) or 12 (if M = 1, SBNS = 0 or M = 0, SBNS = 1) or 14 (if M = 1, SBNS = 1 or M10 = 1, SNBS = 0) or 15 (if M10 = 1, SNBS = 1).
	LPUART0_STAT_LBKDE_1 = 0x1
	// Position of BRK13 field.
	LPUART0_STAT_BRK13_Pos = 0x1a
	// Bit mask of BRK13 field.
	LPUART0_STAT_BRK13_Msk = 0x4000000
	// Bit BRK13.
	LPUART0_STAT_BRK13 = 0x4000000
	// Break character is transmitted with length of 10 bit times (if M = 0, SBNS = 0) or 11 (if M = 1, SBNS = 0 or M = 0, SBNS = 1) or 12 (if M = 1, SBNS = 1 or M10 = 1, SNBS = 0) or 13 (if M10 = 1, SNBS = 1).
	LPUART0_STAT_BRK13_0 = 0x0
	// Break character is transmitted with length of 13 bit times (if M = 0, SBNS = 0) or 14 (if M = 1, SBNS = 0 or M = 0, SBNS = 1) or 15 (if M = 1, SBNS = 1 or M10 = 1, SNBS = 0) or 16 (if M10 = 1, SNBS = 1).
	LPUART0_STAT_BRK13_1 = 0x1
	// Position of RWUID field.
	LPUART0_STAT_RWUID_Pos = 0x1b
	// Bit mask of RWUID field.
	LPUART0_STAT_RWUID_Msk = 0x8000000
	// Bit RWUID.
	LPUART0_STAT_RWUID = 0x8000000
	// During receive standby state (RWU = 1), the IDLE bit does not get set upon detection of an idle character. During address match wakeup, the IDLE bit does not get set when an address does not match.
	LPUART0_STAT_RWUID_0 = 0x0
	// During receive standby state (RWU = 1), the IDLE bit gets set upon detection of an idle character. During address match wakeup, the IDLE bit does get set when an address does not match.
	LPUART0_STAT_RWUID_1 = 0x1
	// Position of RXINV field.
	LPUART0_STAT_RXINV_Pos = 0x1c
	// Bit mask of RXINV field.
	LPUART0_STAT_RXINV_Msk = 0x10000000
	// Bit RXINV.
	LPUART0_STAT_RXINV = 0x10000000
	// Receive data not inverted.
	LPUART0_STAT_RXINV_0 = 0x0
	// Receive data inverted.
	LPUART0_STAT_RXINV_1 = 0x1
	// Position of MSBF field.
	LPUART0_STAT_MSBF_Pos = 0x1d
	// Bit mask of MSBF field.
	LPUART0_STAT_MSBF_Msk = 0x20000000
	// Bit MSBF.
	LPUART0_STAT_MSBF = 0x20000000
	// LSB (bit0) is the first bit that is transmitted following the start bit. Further, the first bit received after the start bit is identified as bit0.
	LPUART0_STAT_MSBF_0 = 0x0
	// MSB (bit9, bit8, bit7 or bit6) is the first bit that is transmitted following the start bit depending on the setting of CTRL[M], CTRL[PE] and BAUD[M10]. Further, the first bit received after the start bit is identified as bit9, bit8, bit7 or bit6 depending on the setting of CTRL[M] and CTRL[PE].
	LPUART0_STAT_MSBF_1 = 0x1
	// Position of RXEDGIF field.
	LPUART0_STAT_RXEDGIF_Pos = 0x1e
	// Bit mask of RXEDGIF field.
	LPUART0_STAT_RXEDGIF_Msk = 0x40000000
	// Bit RXEDGIF.
	LPUART0_STAT_RXEDGIF = 0x40000000
	// No active edge on the receive pin has occurred.
	LPUART0_STAT_RXEDGIF_0 = 0x0
	// An active edge on the receive pin has occurred.
	LPUART0_STAT_RXEDGIF_1 = 0x1
	// Position of LBKDIF field.
	LPUART0_STAT_LBKDIF_Pos = 0x1f
	// Bit mask of LBKDIF field.
	LPUART0_STAT_LBKDIF_Msk = 0x80000000
	// Bit LBKDIF.
	LPUART0_STAT_LBKDIF = 0x80000000
	// No LIN break character has been detected.
	LPUART0_STAT_LBKDIF_0 = 0x0
	// LIN break character has been detected.
	LPUART0_STAT_LBKDIF_1 = 0x1

	// CTRL: LPUART Control Register
	// Position of PT field.
	LPUART0_CTRL_PT_Pos = 0x0
	// Bit mask of PT field.
	LPUART0_CTRL_PT_Msk = 0x1
	// Bit PT.
	LPUART0_CTRL_PT = 0x1
	// Even parity.
	LPUART0_CTRL_PT_0 = 0x0
	// Odd parity.
	LPUART0_CTRL_PT_1 = 0x1
	// Position of PE field.
	LPUART0_CTRL_PE_Pos = 0x1
	// Bit mask of PE field.
	LPUART0_CTRL_PE_Msk = 0x2
	// Bit PE.
	LPUART0_CTRL_PE = 0x2
	// No hardware parity generation or checking.
	LPUART0_CTRL_PE_0 = 0x0
	// Parity enabled.
	LPUART0_CTRL_PE_1 = 0x1
	// Position of ILT field.
	LPUART0_CTRL_ILT_Pos = 0x2
	// Bit mask of ILT field.
	LPUART0_CTRL_ILT_Msk = 0x4
	// Bit ILT.
	LPUART0_CTRL_ILT = 0x4
	// Idle character bit count starts after start bit.
	LPUART0_CTRL_ILT_0 = 0x0
	// Idle character bit count starts after stop bit.
	LPUART0_CTRL_ILT_1 = 0x1
	// Position of WAKE field.
	LPUART0_CTRL_WAKE_Pos = 0x3
	// Bit mask of WAKE field.
	LPUART0_CTRL_WAKE_Msk = 0x8
	// Bit WAKE.
	LPUART0_CTRL_WAKE = 0x8
	// Configures RWU for idle-line wakeup.
	LPUART0_CTRL_WAKE_0 = 0x0
	// Configures RWU with address-mark wakeup.
	LPUART0_CTRL_WAKE_1 = 0x1
	// Position of M field.
	LPUART0_CTRL_M_Pos = 0x4
	// Bit mask of M field.
	LPUART0_CTRL_M_Msk = 0x10
	// Bit M.
	LPUART0_CTRL_M = 0x10
	// Receiver and transmitter use 8-bit data characters.
	LPUART0_CTRL_M_0 = 0x0
	// Receiver and transmitter use 9-bit data characters.
	LPUART0_CTRL_M_1 = 0x1
	// Position of RSRC field.
	LPUART0_CTRL_RSRC_Pos = 0x5
	// Bit mask of RSRC field.
	LPUART0_CTRL_RSRC_Msk = 0x20
	// Bit RSRC.
	LPUART0_CTRL_RSRC = 0x20
	// Provided LOOPS is set, RSRC is cleared, selects internal loop back mode and the LPUART does not use the LPUART_RX pin.
	LPUART0_CTRL_RSRC_0 = 0x0
	// Single-wire LPUART mode where the LPUART_TX pin is connected to the transmitter output and receiver input.
	LPUART0_CTRL_RSRC_1 = 0x1
	// Position of DOZEEN field.
	LPUART0_CTRL_DOZEEN_Pos = 0x6
	// Bit mask of DOZEEN field.
	LPUART0_CTRL_DOZEEN_Msk = 0x40
	// Bit DOZEEN.
	LPUART0_CTRL_DOZEEN = 0x40
	// LPUART is enabled in Doze mode.
	LPUART0_CTRL_DOZEEN_0 = 0x0
	// LPUART is disabled in Doze mode.
	LPUART0_CTRL_DOZEEN_1 = 0x1
	// Position of LOOPS field.
	LPUART0_CTRL_LOOPS_Pos = 0x7
	// Bit mask of LOOPS field.
	LPUART0_CTRL_LOOPS_Msk = 0x80
	// Bit LOOPS.
	LPUART0_CTRL_LOOPS = 0x80
	// Normal operation - LPUART_RX and LPUART_TX use separate pins.
	LPUART0_CTRL_LOOPS_0 = 0x0
	// Loop mode or single-wire mode where transmitter outputs are internally connected to receiver input (see RSRC bit).
	LPUART0_CTRL_LOOPS_1 = 0x1
	// Position of IDLECFG field.
	LPUART0_CTRL_IDLECFG_Pos = 0x8
	// Bit mask of IDLECFG field.
	LPUART0_CTRL_IDLECFG_Msk = 0x700
	// 1 idle character
	LPUART0_CTRL_IDLECFG_000 = 0x0
	// 2 idle characters
	LPUART0_CTRL_IDLECFG_001 = 0x1
	// 4 idle characters
	LPUART0_CTRL_IDLECFG_010 = 0x2
	// 8 idle characters
	LPUART0_CTRL_IDLECFG_011 = 0x3
	// 16 idle characters
	LPUART0_CTRL_IDLECFG_100 = 0x4
	// 32 idle characters
	LPUART0_CTRL_IDLECFG_101 = 0x5
	// 64 idle characters
	LPUART0_CTRL_IDLECFG_110 = 0x6
	// 128 idle characters
	LPUART0_CTRL_IDLECFG_111 = 0x7
	// Position of MA2IE field.
	LPUART0_CTRL_MA2IE_Pos = 0xe
	// Bit mask of MA2IE field.
	LPUART0_CTRL_MA2IE_Msk = 0x4000
	// Bit MA2IE.
	LPUART0_CTRL_MA2IE = 0x4000
	// MA2F interrupt disabled
	LPUART0_CTRL_MA2IE_0 = 0x0
	// MA2F interrupt enabled
	LPUART0_CTRL_MA2IE_1 = 0x1
	// Position of MA1IE field.
	LPUART0_CTRL_MA1IE_Pos = 0xf
	// Bit mask of MA1IE field.
	LPUART0_CTRL_MA1IE_Msk = 0x8000
	// Bit MA1IE.
	LPUART0_CTRL_MA1IE = 0x8000
	// MA1F interrupt disabled
	LPUART0_CTRL_MA1IE_0 = 0x0
	// MA1F interrupt enabled
	LPUART0_CTRL_MA1IE_1 = 0x1
	// Position of SBK field.
	LPUART0_CTRL_SBK_Pos = 0x10
	// Bit mask of SBK field.
	LPUART0_CTRL_SBK_Msk = 0x10000
	// Bit SBK.
	LPUART0_CTRL_SBK = 0x10000
	// Normal transmitter operation.
	LPUART0_CTRL_SBK_0 = 0x0
	// Queue break character(s) to be sent.
	LPUART0_CTRL_SBK_1 = 0x1
	// Position of RWU field.
	LPUART0_CTRL_RWU_Pos = 0x11
	// Bit mask of RWU field.
	LPUART0_CTRL_RWU_Msk = 0x20000
	// Bit RWU.
	LPUART0_CTRL_RWU = 0x20000
	// Normal receiver operation.
	LPUART0_CTRL_RWU_0 = 0x0
	// LPUART receiver in standby waiting for wakeup condition.
	LPUART0_CTRL_RWU_1 = 0x1
	// Position of RE field.
	LPUART0_CTRL_RE_Pos = 0x12
	// Bit mask of RE field.
	LPUART0_CTRL_RE_Msk = 0x40000
	// Bit RE.
	LPUART0_CTRL_RE = 0x40000
	// Receiver disabled.
	LPUART0_CTRL_RE_0 = 0x0
	// Receiver enabled.
	LPUART0_CTRL_RE_1 = 0x1
	// Position of TE field.
	LPUART0_CTRL_TE_Pos = 0x13
	// Bit mask of TE field.
	LPUART0_CTRL_TE_Msk = 0x80000
	// Bit TE.
	LPUART0_CTRL_TE = 0x80000
	// Transmitter disabled.
	LPUART0_CTRL_TE_0 = 0x0
	// Transmitter enabled.
	LPUART0_CTRL_TE_1 = 0x1
	// Position of ILIE field.
	LPUART0_CTRL_ILIE_Pos = 0x14
	// Bit mask of ILIE field.
	LPUART0_CTRL_ILIE_Msk = 0x100000
	// Bit ILIE.
	LPUART0_CTRL_ILIE = 0x100000
	// Hardware interrupts from IDLE disabled; use polling.
	LPUART0_CTRL_ILIE_0 = 0x0
	// Hardware interrupt requested when IDLE flag is 1.
	LPUART0_CTRL_ILIE_1 = 0x1
	// Position of RIE field.
	LPUART0_CTRL_RIE_Pos = 0x15
	// Bit mask of RIE field.
	LPUART0_CTRL_RIE_Msk = 0x200000
	// Bit RIE.
	LPUART0_CTRL_RIE = 0x200000
	// Hardware interrupts from RDRF disabled; use polling.
	LPUART0_CTRL_RIE_0 = 0x0
	// Hardware interrupt requested when RDRF flag is 1.
	LPUART0_CTRL_RIE_1 = 0x1
	// Position of TCIE field.
	LPUART0_CTRL_TCIE_Pos = 0x16
	// Bit mask of TCIE field.
	LPUART0_CTRL_TCIE_Msk = 0x400000
	// Bit TCIE.
	LPUART0_CTRL_TCIE = 0x400000
	// Hardware interrupts from TC disabled; use polling.
	LPUART0_CTRL_TCIE_0 = 0x0
	// Hardware interrupt requested when TC flag is 1.
	LPUART0_CTRL_TCIE_1 = 0x1
	// Position of TIE field.
	LPUART0_CTRL_TIE_Pos = 0x17
	// Bit mask of TIE field.
	LPUART0_CTRL_TIE_Msk = 0x800000
	// Bit TIE.
	LPUART0_CTRL_TIE = 0x800000
	// Hardware interrupts from TDRE disabled; use polling.
	LPUART0_CTRL_TIE_0 = 0x0
	// Hardware interrupt requested when TDRE flag is 1.
	LPUART0_CTRL_TIE_1 = 0x1
	// Position of PEIE field.
	LPUART0_CTRL_PEIE_Pos = 0x18
	// Bit mask of PEIE field.
	LPUART0_CTRL_PEIE_Msk = 0x1000000
	// Bit PEIE.
	LPUART0_CTRL_PEIE = 0x1000000
	// PF interrupts disabled; use polling).
	LPUART0_CTRL_PEIE_0 = 0x0
	// Hardware interrupt requested when PF is set.
	LPUART0_CTRL_PEIE_1 = 0x1
	// Position of FEIE field.
	LPUART0_CTRL_FEIE_Pos = 0x19
	// Bit mask of FEIE field.
	LPUART0_CTRL_FEIE_Msk = 0x2000000
	// Bit FEIE.
	LPUART0_CTRL_FEIE = 0x2000000
	// FE interrupts disabled; use polling.
	LPUART0_CTRL_FEIE_0 = 0x0
	// Hardware interrupt requested when FE is set.
	LPUART0_CTRL_FEIE_1 = 0x1
	// Position of NEIE field.
	LPUART0_CTRL_NEIE_Pos = 0x1a
	// Bit mask of NEIE field.
	LPUART0_CTRL_NEIE_Msk = 0x4000000
	// Bit NEIE.
	LPUART0_CTRL_NEIE = 0x4000000
	// NF interrupts disabled; use polling.
	LPUART0_CTRL_NEIE_0 = 0x0
	// Hardware interrupt requested when NF is set.
	LPUART0_CTRL_NEIE_1 = 0x1
	// Position of ORIE field.
	LPUART0_CTRL_ORIE_Pos = 0x1b
	// Bit mask of ORIE field.
	LPUART0_CTRL_ORIE_Msk = 0x8000000
	// Bit ORIE.
	LPUART0_CTRL_ORIE = 0x8000000
	// OR interrupts disabled; use polling.
	LPUART0_CTRL_ORIE_0 = 0x0
	// Hardware interrupt requested when OR is set.
	LPUART0_CTRL_ORIE_1 = 0x1
	// Position of TXINV field.
	LPUART0_CTRL_TXINV_Pos = 0x1c
	// Bit mask of TXINV field.
	LPUART0_CTRL_TXINV_Msk = 0x10000000
	// Bit TXINV.
	LPUART0_CTRL_TXINV = 0x10000000
	// Transmit data not inverted.
	LPUART0_CTRL_TXINV_0 = 0x0
	// Transmit data inverted.
	LPUART0_CTRL_TXINV_1 = 0x1
	// Position of TXDIR field.
	LPUART0_CTRL_TXDIR_Pos = 0x1d
	// Bit mask of TXDIR field.
	LPUART0_CTRL_TXDIR_Msk = 0x20000000
	// Bit TXDIR.
	LPUART0_CTRL_TXDIR = 0x20000000
	// LPUART_TX pin is an input in single-wire mode.
	LPUART0_CTRL_TXDIR_0 = 0x0
	// LPUART_TX pin is an output in single-wire mode.
	LPUART0_CTRL_TXDIR_1 = 0x1
	// Position of R9T8 field.
	LPUART0_CTRL_R9T8_Pos = 0x1e
	// Bit mask of R9T8 field.
	LPUART0_CTRL_R9T8_Msk = 0x40000000
	// Bit R9T8.
	LPUART0_CTRL_R9T8 = 0x40000000
	// Position of R8T9 field.
	LPUART0_CTRL_R8T9_Pos = 0x1f
	// Bit mask of R8T9 field.
	LPUART0_CTRL_R8T9_Msk = 0x80000000
	// Bit R8T9.
	LPUART0_CTRL_R8T9 = 0x80000000

	// DATA: LPUART Data Register
	// Position of R0T0 field.
	LPUART0_DATA_R0T0_Pos = 0x0
	// Bit mask of R0T0 field.
	LPUART0_DATA_R0T0_Msk = 0x1
	// Bit R0T0.
	LPUART0_DATA_R0T0 = 0x1
	// Position of R1T1 field.
	LPUART0_DATA_R1T1_Pos = 0x1
	// Bit mask of R1T1 field.
	LPUART0_DATA_R1T1_Msk = 0x2
	// Bit R1T1.
	LPUART0_DATA_R1T1 = 0x2
	// Position of R2T2 field.
	LPUART0_DATA_R2T2_Pos = 0x2
	// Bit mask of R2T2 field.
	LPUART0_DATA_R2T2_Msk = 0x4
	// Bit R2T2.
	LPUART0_DATA_R2T2 = 0x4
	// Position of R3T3 field.
	LPUART0_DATA_R3T3_Pos = 0x3
	// Bit mask of R3T3 field.
	LPUART0_DATA_R3T3_Msk = 0x8
	// Bit R3T3.
	LPUART0_DATA_R3T3 = 0x8
	// Position of R4T4 field.
	LPUART0_DATA_R4T4_Pos = 0x4
	// Bit mask of R4T4 field.
	LPUART0_DATA_R4T4_Msk = 0x10
	// Bit R4T4.
	LPUART0_DATA_R4T4 = 0x10
	// Position of R5T5 field.
	LPUART0_DATA_R5T5_Pos = 0x5
	// Bit mask of R5T5 field.
	LPUART0_DATA_R5T5_Msk = 0x20
	// Bit R5T5.
	LPUART0_DATA_R5T5 = 0x20
	// Position of R6T6 field.
	LPUART0_DATA_R6T6_Pos = 0x6
	// Bit mask of R6T6 field.
	LPUART0_DATA_R6T6_Msk = 0x40
	// Bit R6T6.
	LPUART0_DATA_R6T6 = 0x40
	// Position of R7T7 field.
	LPUART0_DATA_R7T7_Pos = 0x7
	// Bit mask of R7T7 field.
	LPUART0_DATA_R7T7_Msk = 0x80
	// Bit R7T7.
	LPUART0_DATA_R7T7 = 0x80
	// Position of R8T8 field.
	LPUART0_DATA_R8T8_Pos = 0x8
	// Bit mask of R8T8 field.
	LPUART0_DATA_R8T8_Msk = 0x100
	// Bit R8T8.
	LPUART0_DATA_R8T8 = 0x100
	// Position of R9T9 field.
	LPUART0_DATA_R9T9_Pos = 0x9
	// Bit mask of R9T9 field.
	LPUART0_DATA_R9T9_Msk = 0x200
	// Bit R9T9.
	LPUART0_DATA_R9T9 = 0x200
	// Position of IDLINE field.
	LPUART0_DATA_IDLINE_Pos = 0xb
	// Bit mask of IDLINE field.
	LPUART0_DATA_IDLINE_Msk = 0x800
	// Bit IDLINE.
	LPUART0_DATA_IDLINE = 0x800
	// Receiver was not idle before receiving this character.
	LPUART0_DATA_IDLINE_0 = 0x0
	// Receiver was idle before receiving this character.
	LPUART0_DATA_IDLINE_1 = 0x1
	// Position of RXEMPT field.
	LPUART0_DATA_RXEMPT_Pos = 0xc
	// Bit mask of RXEMPT field.
	LPUART0_DATA_RXEMPT_Msk = 0x1000
	// Bit RXEMPT.
	LPUART0_DATA_RXEMPT = 0x1000
	// Receive buffer contains valid data.
	LPUART0_DATA_RXEMPT_0 = 0x0
	// Receive buffer is empty, data returned on read is not valid.
	LPUART0_DATA_RXEMPT_1 = 0x1
	// Position of FRETSC field.
	LPUART0_DATA_FRETSC_Pos = 0xd
	// Bit mask of FRETSC field.
	LPUART0_DATA_FRETSC_Msk = 0x2000
	// Bit FRETSC.
	LPUART0_DATA_FRETSC = 0x2000
	// The dataword was received without a frame error on read, transmit a normal character on write.
	LPUART0_DATA_FRETSC_0 = 0x0
	// The dataword was received with a frame error, transmit an idle or break character on transmit.
	LPUART0_DATA_FRETSC_1 = 0x1
	// Position of PARITYE field.
	LPUART0_DATA_PARITYE_Pos = 0xe
	// Bit mask of PARITYE field.
	LPUART0_DATA_PARITYE_Msk = 0x4000
	// Bit PARITYE.
	LPUART0_DATA_PARITYE = 0x4000
	// The dataword was received without a parity error.
	LPUART0_DATA_PARITYE_0 = 0x0
	// The dataword was received with a parity error.
	LPUART0_DATA_PARITYE_1 = 0x1
	// Position of NOISY field.
	LPUART0_DATA_NOISY_Pos = 0xf
	// Bit mask of NOISY field.
	LPUART0_DATA_NOISY_Msk = 0x8000
	// Bit NOISY.
	LPUART0_DATA_NOISY = 0x8000
	// The dataword was received without noise.
	LPUART0_DATA_NOISY_0 = 0x0
	// The data was received with noise.
	LPUART0_DATA_NOISY_1 = 0x1

	// MATCH: LPUART Match Address Register
	// Position of MA1 field.
	LPUART0_MATCH_MA1_Pos = 0x0
	// Bit mask of MA1 field.
	LPUART0_MATCH_MA1_Msk = 0x3ff
	// Position of MA2 field.
	LPUART0_MATCH_MA2_Pos = 0x10
	// Bit mask of MA2 field.
	LPUART0_MATCH_MA2_Msk = 0x3ff0000

	// MODIR: LPUART Modem IrDA Register
	// Position of TXCTSE field.
	LPUART0_MODIR_TXCTSE_Pos = 0x0
	// Bit mask of TXCTSE field.
	LPUART0_MODIR_TXCTSE_Msk = 0x1
	// Bit TXCTSE.
	LPUART0_MODIR_TXCTSE = 0x1
	// CTS has no effect on the transmitter.
	LPUART0_MODIR_TXCTSE_0 = 0x0
	// Enables clear-to-send operation. The transmitter checks the state of CTS each time it is ready to send a character. If CTS is asserted, the character is sent. If CTS is deasserted, the signal TXD remains in the mark state and transmission is delayed until CTS is asserted. Changes in CTS as a character is being sent do not affect its transmission.
	LPUART0_MODIR_TXCTSE_1 = 0x1
	// Position of TXRTSE field.
	LPUART0_MODIR_TXRTSE_Pos = 0x1
	// Bit mask of TXRTSE field.
	LPUART0_MODIR_TXRTSE_Msk = 0x2
	// Bit TXRTSE.
	LPUART0_MODIR_TXRTSE = 0x2
	// The transmitter has no effect on RTS.
	LPUART0_MODIR_TXRTSE_0 = 0x0
	// When a character is placed into an empty transmitter data buffer , RTS asserts one bit time before the start bit is transmitted. RTS deasserts one bit time after all characters in the transmitter data buffer and shift register are completely sent, including the last stop bit.
	LPUART0_MODIR_TXRTSE_1 = 0x1
	// Position of TXRTSPOL field.
	LPUART0_MODIR_TXRTSPOL_Pos = 0x2
	// Bit mask of TXRTSPOL field.
	LPUART0_MODIR_TXRTSPOL_Msk = 0x4
	// Bit TXRTSPOL.
	LPUART0_MODIR_TXRTSPOL = 0x4
	// Transmitter RTS is active low.
	LPUART0_MODIR_TXRTSPOL_0 = 0x0
	// Transmitter RTS is active high.
	LPUART0_MODIR_TXRTSPOL_1 = 0x1
	// Position of RXRTSE field.
	LPUART0_MODIR_RXRTSE_Pos = 0x3
	// Bit mask of RXRTSE field.
	LPUART0_MODIR_RXRTSE_Msk = 0x8
	// Bit RXRTSE.
	LPUART0_MODIR_RXRTSE = 0x8
	// The receiver has no effect on RTS.
	LPUART0_MODIR_RXRTSE_0 = 0x0
	// RTS assertion is configured by the RTSWATER field
	LPUART0_MODIR_RXRTSE_1 = 0x1
	// Position of TXCTSC field.
	LPUART0_MODIR_TXCTSC_Pos = 0x4
	// Bit mask of TXCTSC field.
	LPUART0_MODIR_TXCTSC_Msk = 0x10
	// Bit TXCTSC.
	LPUART0_MODIR_TXCTSC = 0x10
	// CTS input is sampled at the start of each character.
	LPUART0_MODIR_TXCTSC_0 = 0x0
	// CTS input is sampled when the transmitter is idle.
	LPUART0_MODIR_TXCTSC_1 = 0x1
	// Position of TXCTSSRC field.
	LPUART0_MODIR_TXCTSSRC_Pos = 0x5
	// Bit mask of TXCTSSRC field.
	LPUART0_MODIR_TXCTSSRC_Msk = 0x20
	// Bit TXCTSSRC.
	LPUART0_MODIR_TXCTSSRC = 0x20
	// CTS input is the LPUART_CTS pin.
	LPUART0_MODIR_TXCTSSRC_0 = 0x0
	// CTS input is the inverted Receiver Match result.
	LPUART0_MODIR_TXCTSSRC_1 = 0x1
	// Position of TNP field.
	LPUART0_MODIR_TNP_Pos = 0x10
	// Bit mask of TNP field.
	LPUART0_MODIR_TNP_Msk = 0x30000
	// 1/OSR.
	LPUART0_MODIR_TNP_00 = 0x0
	// 2/OSR.
	LPUART0_MODIR_TNP_01 = 0x1
	// 3/OSR.
	LPUART0_MODIR_TNP_10 = 0x2
	// 4/OSR.
	LPUART0_MODIR_TNP_11 = 0x3
	// Position of IREN field.
	LPUART0_MODIR_IREN_Pos = 0x12
	// Bit mask of IREN field.
	LPUART0_MODIR_IREN_Msk = 0x40000
	// Bit IREN.
	LPUART0_MODIR_IREN = 0x40000
	// IR disabled.
	LPUART0_MODIR_IREN_0 = 0x0
	// IR enabled.
	LPUART0_MODIR_IREN_1 = 0x1
)

// Bitfields for LTC0: LTC
const (
	// MD: Mode Register
	// Position of ENC field.
	LTC0_MD_ENC_Pos = 0x0
	// Bit mask of ENC field.
	LTC0_MD_ENC_Msk = 0x1
	// Bit ENC.
	LTC0_MD_ENC = 0x1
	// Decrypt.
	LTC0_MD_ENC_0 = 0x0
	// Encrypt.
	LTC0_MD_ENC_1 = 0x1
	// Position of ICV_TEST field.
	LTC0_MD_ICV_TEST_Pos = 0x1
	// Bit mask of ICV_TEST field.
	LTC0_MD_ICV_TEST_Msk = 0x2
	// Bit ICV_TEST.
	LTC0_MD_ICV_TEST = 0x2
	// Position of AS field.
	LTC0_MD_AS_Pos = 0x2
	// Bit mask of AS field.
	LTC0_MD_AS_Msk = 0xc
	// Update
	LTC0_MD_AS_00 = 0x0
	// Initialize
	LTC0_MD_AS_01 = 0x1
	// Finalize
	LTC0_MD_AS_10 = 0x2
	// Initialize/Finalize
	LTC0_MD_AS_11 = 0x3
	// Position of AAI field.
	LTC0_MD_AAI_Pos = 0x4
	// Bit mask of AAI field.
	LTC0_MD_AAI_Msk = 0x1ff0
	// Position of ALG field.
	LTC0_MD_ALG_Pos = 0x10
	// Bit mask of ALG field.
	LTC0_MD_ALG_Msk = 0xff0000
	// AES
	LTC0_MD_ALG_00010000 = 0x10

	// KS: Key Size Register
	// Position of KS field.
	LTC0_KS_KS_Pos = 0x0
	// Bit mask of KS field.
	LTC0_KS_KS_Msk = 0x1f

	// DS: Data Size Register
	// Position of DS field.
	LTC0_DS_DS_Pos = 0x0
	// Bit mask of DS field.
	LTC0_DS_DS_Msk = 0xfff

	// ICVS: ICV Size Register
	// Position of ICVS field.
	LTC0_ICVS_ICVS_Pos = 0x0
	// Bit mask of ICVS field.
	LTC0_ICVS_ICVS_Msk = 0x1f

	// COM: Command Register
	// Position of ALL field.
	LTC0_COM_ALL_Pos = 0x0
	// Bit mask of ALL field.
	LTC0_COM_ALL_Msk = 0x1
	// Bit ALL.
	LTC0_COM_ALL = 0x1
	// Do Not Reset
	LTC0_COM_ALL_0 = 0x0
	// Reset all CHAs in use by this CCB.
	LTC0_COM_ALL_1 = 0x1
	// Position of AES field.
	LTC0_COM_AES_Pos = 0x1
	// Bit mask of AES field.
	LTC0_COM_AES_Msk = 0x2
	// Bit AES.
	LTC0_COM_AES = 0x2
	// Do Not Reset
	LTC0_COM_AES_0 = 0x0
	// Reset AES Accelerator
	LTC0_COM_AES_1 = 0x1

	// CTL: Control Register
	// Position of IM field.
	LTC0_CTL_IM_Pos = 0x0
	// Bit mask of IM field.
	LTC0_CTL_IM_Msk = 0x1
	// Bit IM.
	LTC0_CTL_IM = 0x1
	// Interrupt not masked.
	LTC0_CTL_IM_0 = 0x0
	// Interrupt masked
	LTC0_CTL_IM_1 = 0x1
	// Position of IFE field.
	LTC0_CTL_IFE_Pos = 0x8
	// Bit mask of IFE field.
	LTC0_CTL_IFE_Msk = 0x100
	// Bit IFE.
	LTC0_CTL_IFE = 0x100
	// DMA Request and Done signals disabled for the Input FIFO.
	LTC0_CTL_IFE_0 = 0x0
	// DMA Request and Done signals enabled for the Input FIFO.
	LTC0_CTL_IFE_1 = 0x1
	// Position of IFR field.
	LTC0_CTL_IFR_Pos = 0x9
	// Bit mask of IFR field.
	LTC0_CTL_IFR_Msk = 0x200
	// Bit IFR.
	LTC0_CTL_IFR = 0x200
	// DMA request size is 1 entry.
	LTC0_CTL_IFR_0 = 0x0
	// DMA request size is 4 entries.
	LTC0_CTL_IFR_1 = 0x1
	// Position of OFE field.
	LTC0_CTL_OFE_Pos = 0xc
	// Bit mask of OFE field.
	LTC0_CTL_OFE_Msk = 0x1000
	// Bit OFE.
	LTC0_CTL_OFE = 0x1000
	// DMA Request and Done signals disabled for the Output FIFO.
	LTC0_CTL_OFE_0 = 0x0
	// DMA Request and Done signals enabled for the Output FIFO.
	LTC0_CTL_OFE_1 = 0x1
	// Position of OFR field.
	LTC0_CTL_OFR_Pos = 0xd
	// Bit mask of OFR field.
	LTC0_CTL_OFR_Msk = 0x2000
	// Bit OFR.
	LTC0_CTL_OFR = 0x2000
	// DMA request size is 1 entry.
	LTC0_CTL_OFR_0 = 0x0
	// DMA request size is 4 entries.
	LTC0_CTL_OFR_1 = 0x1
	// Position of IFS field.
	LTC0_CTL_IFS_Pos = 0x10
	// Bit mask of IFS field.
	LTC0_CTL_IFS_Msk = 0x10000
	// Bit IFS.
	LTC0_CTL_IFS = 0x10000
	// Do Not Byte Swap Data.
	LTC0_CTL_IFS_0 = 0x0
	// Byte Swap Data.
	LTC0_CTL_IFS_1 = 0x1
	// Position of OFS field.
	LTC0_CTL_OFS_Pos = 0x11
	// Bit mask of OFS field.
	LTC0_CTL_OFS_Msk = 0x20000
	// Bit OFS.
	LTC0_CTL_OFS = 0x20000
	// Do Not Byte Swap Data.
	LTC0_CTL_OFS_0 = 0x0
	// Byte Swap Data.
	LTC0_CTL_OFS_1 = 0x1
	// Position of KIS field.
	LTC0_CTL_KIS_Pos = 0x14
	// Bit mask of KIS field.
	LTC0_CTL_KIS_Msk = 0x100000
	// Bit KIS.
	LTC0_CTL_KIS = 0x100000
	// Do Not Byte Swap Data.
	LTC0_CTL_KIS_0 = 0x0
	// Byte Swap Data.
	LTC0_CTL_KIS_1 = 0x1
	// Position of KOS field.
	LTC0_CTL_KOS_Pos = 0x15
	// Bit mask of KOS field.
	LTC0_CTL_KOS_Msk = 0x200000
	// Bit KOS.
	LTC0_CTL_KOS = 0x200000
	// Do Not Byte Swap Data.
	LTC0_CTL_KOS_0 = 0x0
	// Byte Swap Data.
	LTC0_CTL_KOS_1 = 0x1
	// Position of CIS field.
	LTC0_CTL_CIS_Pos = 0x16
	// Bit mask of CIS field.
	LTC0_CTL_CIS_Msk = 0x400000
	// Bit CIS.
	LTC0_CTL_CIS = 0x400000
	// Do Not Byte Swap Data.
	LTC0_CTL_CIS_0 = 0x0
	// Byte Swap Data.
	LTC0_CTL_CIS_1 = 0x1
	// Position of COS field.
	LTC0_CTL_COS_Pos = 0x17
	// Bit mask of COS field.
	LTC0_CTL_COS_Msk = 0x800000
	// Bit COS.
	LTC0_CTL_COS = 0x800000
	// Do Not Byte Swap Data.
	LTC0_CTL_COS_0 = 0x0
	// Byte Swap Data.
	LTC0_CTL_COS_1 = 0x1
	// Position of KAL field.
	LTC0_CTL_KAL_Pos = 0x1f
	// Bit mask of KAL field.
	LTC0_CTL_KAL_Msk = 0x80000000
	// Bit KAL.
	LTC0_CTL_KAL = 0x80000000
	// Key Register is readable.
	LTC0_CTL_KAL_0 = 0x0
	// Key Register is not readable.
	LTC0_CTL_KAL_1 = 0x1

	// CW: Clear Written Register
	// Position of CM field.
	LTC0_CW_CM_Pos = 0x0
	// Bit mask of CM field.
	LTC0_CW_CM_Msk = 0x1
	// Bit CM.
	LTC0_CW_CM = 0x1
	// Position of CDS field.
	LTC0_CW_CDS_Pos = 0x2
	// Bit mask of CDS field.
	LTC0_CW_CDS_Msk = 0x4
	// Bit CDS.
	LTC0_CW_CDS = 0x4
	// Position of CICV field.
	LTC0_CW_CICV_Pos = 0x3
	// Bit mask of CICV field.
	LTC0_CW_CICV_Msk = 0x8
	// Bit CICV.
	LTC0_CW_CICV = 0x8
	// Position of CCR field.
	LTC0_CW_CCR_Pos = 0x5
	// Bit mask of CCR field.
	LTC0_CW_CCR_Msk = 0x20
	// Bit CCR.
	LTC0_CW_CCR = 0x20
	// Position of CKR field.
	LTC0_CW_CKR_Pos = 0x6
	// Bit mask of CKR field.
	LTC0_CW_CKR_Msk = 0x40
	// Bit CKR.
	LTC0_CW_CKR = 0x40
	// Position of COF field.
	LTC0_CW_COF_Pos = 0x1e
	// Bit mask of COF field.
	LTC0_CW_COF_Msk = 0x40000000
	// Bit COF.
	LTC0_CW_COF = 0x40000000
	// Position of CIF field.
	LTC0_CW_CIF_Pos = 0x1f
	// Bit mask of CIF field.
	LTC0_CW_CIF_Msk = 0x80000000
	// Bit CIF.
	LTC0_CW_CIF = 0x80000000

	// STA: Status Register
	// Position of AB field.
	LTC0_STA_AB_Pos = 0x1
	// Bit mask of AB field.
	LTC0_STA_AB_Msk = 0x2
	// Bit AB.
	LTC0_STA_AB = 0x2
	// AESA Idle
	LTC0_STA_AB_0 = 0x0
	// AESA Busy.
	LTC0_STA_AB_1 = 0x1
	// Position of DI field.
	LTC0_STA_DI_Pos = 0x10
	// Bit mask of DI field.
	LTC0_STA_DI_Msk = 0x10000
	// Bit DI.
	LTC0_STA_DI = 0x10000
	// Position of EI field.
	LTC0_STA_EI_Pos = 0x14
	// Bit mask of EI field.
	LTC0_STA_EI_Msk = 0x100000
	// Bit EI.
	LTC0_STA_EI = 0x100000
	// Not Error.
	LTC0_STA_EI_0 = 0x0
	// Error Interrupt.
	LTC0_STA_EI_1 = 0x1

	// ESTA: Error Status Register
	// Position of ERRID1 field.
	LTC0_ESTA_ERRID1_Pos = 0x0
	// Bit mask of ERRID1 field.
	LTC0_ESTA_ERRID1_Msk = 0xf
	// Mode Error
	LTC0_ESTA_ERRID1_0001 = 0x1
	// Data Size Error
	LTC0_ESTA_ERRID1_0010 = 0x2
	// Key Size Error
	LTC0_ESTA_ERRID1_0011 = 0x3
	// Data Arrived out of Sequence Error
	LTC0_ESTA_ERRID1_0110 = 0x6
	// ICV Check Failed
	LTC0_ESTA_ERRID1_1010 = 0xa
	// Internal Hardware Failure
	LTC0_ESTA_ERRID1_1011 = 0xb
	// CCM AAD Size Error (either 1. AAD flag in B0 =1 and no AAD type provided, 2. AAD flag in B0 = 0 and AAD povided, or 3. AAD flag in B0 =1 and not enough AAD provided - expecting more based on AAD size.)
	LTC0_ESTA_ERRID1_1100 = 0xc
	// Invalid Crypto Engine Selected
	LTC0_ESTA_ERRID1_1111 = 0xf
	// Position of CL1 field.
	LTC0_ESTA_CL1_Pos = 0x8
	// Bit mask of CL1 field.
	LTC0_ESTA_CL1_Msk = 0xf00
	// General Error
	LTC0_ESTA_CL1_0000 = 0x0
	// AES
	LTC0_ESTA_CL1_0001 = 0x1

	// AADSZ: AAD Size Register
	// Position of AADSZ field.
	LTC0_AADSZ_AADSZ_Pos = 0x0
	// Bit mask of AADSZ field.
	LTC0_AADSZ_AADSZ_Msk = 0xf
	// Position of AL field.
	LTC0_AADSZ_AL_Pos = 0x1f
	// Bit mask of AL field.
	LTC0_AADSZ_AL_Msk = 0x80000000
	// Bit AL.
	LTC0_AADSZ_AL = 0x80000000

	// CTX_0: Context Register
	// Position of CTX field.
	LTC0_CTX_0_CTX_Pos = 0x0
	// Bit mask of CTX field.
	LTC0_CTX_0_CTX_Msk = 0xffffffff

	// CTX_1: Context Register
	// Position of CTX field.
	LTC0_CTX_1_CTX_Pos = 0x0
	// Bit mask of CTX field.
	LTC0_CTX_1_CTX_Msk = 0xffffffff

	// CTX_2: Context Register
	// Position of CTX field.
	LTC0_CTX_2_CTX_Pos = 0x0
	// Bit mask of CTX field.
	LTC0_CTX_2_CTX_Msk = 0xffffffff

	// CTX_3: Context Register
	// Position of CTX field.
	LTC0_CTX_3_CTX_Pos = 0x0
	// Bit mask of CTX field.
	LTC0_CTX_3_CTX_Msk = 0xffffffff

	// CTX_4: Context Register
	// Position of CTX field.
	LTC0_CTX_4_CTX_Pos = 0x0
	// Bit mask of CTX field.
	LTC0_CTX_4_CTX_Msk = 0xffffffff

	// CTX_5: Context Register
	// Position of CTX field.
	LTC0_CTX_5_CTX_Pos = 0x0
	// Bit mask of CTX field.
	LTC0_CTX_5_CTX_Msk = 0xffffffff

	// CTX_6: Context Register
	// Position of CTX field.
	LTC0_CTX_6_CTX_Pos = 0x0
	// Bit mask of CTX field.
	LTC0_CTX_6_CTX_Msk = 0xffffffff

	// CTX_7: Context Register
	// Position of CTX field.
	LTC0_CTX_7_CTX_Pos = 0x0
	// Bit mask of CTX field.
	LTC0_CTX_7_CTX_Msk = 0xffffffff

	// CTX_8: Context Register
	// Position of CTX field.
	LTC0_CTX_8_CTX_Pos = 0x0
	// Bit mask of CTX field.
	LTC0_CTX_8_CTX_Msk = 0xffffffff

	// CTX_9: Context Register
	// Position of CTX field.
	LTC0_CTX_9_CTX_Pos = 0x0
	// Bit mask of CTX field.
	LTC0_CTX_9_CTX_Msk = 0xffffffff

	// CTX_10: Context Register
	// Position of CTX field.
	LTC0_CTX_10_CTX_Pos = 0x0
	// Bit mask of CTX field.
	LTC0_CTX_10_CTX_Msk = 0xffffffff

	// CTX_11: Context Register
	// Position of CTX field.
	LTC0_CTX_11_CTX_Pos = 0x0
	// Bit mask of CTX field.
	LTC0_CTX_11_CTX_Msk = 0xffffffff

	// CTX_12: Context Register
	// Position of CTX field.
	LTC0_CTX_12_CTX_Pos = 0x0
	// Bit mask of CTX field.
	LTC0_CTX_12_CTX_Msk = 0xffffffff

	// CTX_13: Context Register
	// Position of CTX field.
	LTC0_CTX_13_CTX_Pos = 0x0
	// Bit mask of CTX field.
	LTC0_CTX_13_CTX_Msk = 0xffffffff

	// KEY_0: Key Registers
	// Position of KEY field.
	LTC0_KEY_0_KEY_Pos = 0x0
	// Bit mask of KEY field.
	LTC0_KEY_0_KEY_Msk = 0xffffffff

	// KEY_1: Key Registers
	// Position of KEY field.
	LTC0_KEY_1_KEY_Pos = 0x0
	// Bit mask of KEY field.
	LTC0_KEY_1_KEY_Msk = 0xffffffff

	// KEY_2: Key Registers
	// Position of KEY field.
	LTC0_KEY_2_KEY_Pos = 0x0
	// Bit mask of KEY field.
	LTC0_KEY_2_KEY_Msk = 0xffffffff

	// KEY_3: Key Registers
	// Position of KEY field.
	LTC0_KEY_3_KEY_Pos = 0x0
	// Bit mask of KEY field.
	LTC0_KEY_3_KEY_Msk = 0xffffffff

	// VID1: Version ID Register
	// Position of MIN_REV field.
	LTC0_VID1_MIN_REV_Pos = 0x0
	// Bit mask of MIN_REV field.
	LTC0_VID1_MIN_REV_Msk = 0xff
	// Position of MAJ_REV field.
	LTC0_VID1_MAJ_REV_Pos = 0x8
	// Bit mask of MAJ_REV field.
	LTC0_VID1_MAJ_REV_Msk = 0xff00
	// Position of IP_ID field.
	LTC0_VID1_IP_ID_Pos = 0x10
	// Bit mask of IP_ID field.
	LTC0_VID1_IP_ID_Msk = 0xffff0000

	// VID2: Version ID 2 Register
	// Position of ECO_REV field.
	LTC0_VID2_ECO_REV_Pos = 0x0
	// Bit mask of ECO_REV field.
	LTC0_VID2_ECO_REV_Msk = 0xff
	// Position of ARCH_ERA field.
	LTC0_VID2_ARCH_ERA_Pos = 0x8
	// Bit mask of ARCH_ERA field.
	LTC0_VID2_ARCH_ERA_Msk = 0xff00

	// CHAVID: CHA Version ID Register
	// Position of AESREV field.
	LTC0_CHAVID_AESREV_Pos = 0x0
	// Bit mask of AESREV field.
	LTC0_CHAVID_AESREV_Msk = 0xf
	// Position of AESVID field.
	LTC0_CHAVID_AESVID_Pos = 0x4
	// Bit mask of AESVID field.
	LTC0_CHAVID_AESVID_Msk = 0xf0

	// FIFOSTA: FIFO Status Register
	// Position of IFL field.
	LTC0_FIFOSTA_IFL_Pos = 0x0
	// Bit mask of IFL field.
	LTC0_FIFOSTA_IFL_Msk = 0x7f
	// Position of IFF field.
	LTC0_FIFOSTA_IFF_Pos = 0xf
	// Bit mask of IFF field.
	LTC0_FIFOSTA_IFF_Msk = 0x8000
	// Bit IFF.
	LTC0_FIFOSTA_IFF = 0x8000
	// Position of OFL field.
	LTC0_FIFOSTA_OFL_Pos = 0x10
	// Bit mask of OFL field.
	LTC0_FIFOSTA_OFL_Msk = 0x7f0000
	// Position of OFF field.
	LTC0_FIFOSTA_OFF_Pos = 0x1f
	// Bit mask of OFF field.
	LTC0_FIFOSTA_OFF_Msk = 0x80000000
	// Bit OFF.
	LTC0_FIFOSTA_OFF = 0x80000000

	// IFIFO: Input Data FIFO
	// Position of IFIFO field.
	LTC0_IFIFO_IFIFO_Pos = 0x0
	// Bit mask of IFIFO field.
	LTC0_IFIFO_IFIFO_Msk = 0xffffffff

	// OFIFO: Output Data FIFO
	// Position of OFIFO field.
	LTC0_OFIFO_OFIFO_Pos = 0x0
	// Bit mask of OFIFO field.
	LTC0_OFIFO_OFIFO_Msk = 0xffffffff
)

// Bitfields for RSIM: RSIM
const (
	// CONTROL: Radio System Control
	// Position of BLE_RF_OSC_REQ_EN field.
	RSIM_CONTROL_BLE_RF_OSC_REQ_EN_Pos = 0x0
	// Bit mask of BLE_RF_OSC_REQ_EN field.
	RSIM_CONTROL_BLE_RF_OSC_REQ_EN_Msk = 0x1
	// Bit BLE_RF_OSC_REQ_EN.
	RSIM_CONTROL_BLE_RF_OSC_REQ_EN = 0x1
	// Position of BLE_RF_OSC_REQ_STAT field.
	RSIM_CONTROL_BLE_RF_OSC_REQ_STAT_Pos = 0x1
	// Bit mask of BLE_RF_OSC_REQ_STAT field.
	RSIM_CONTROL_BLE_RF_OSC_REQ_STAT_Msk = 0x2
	// Bit BLE_RF_OSC_REQ_STAT.
	RSIM_CONTROL_BLE_RF_OSC_REQ_STAT = 0x2
	// Position of BLE_RF_OSC_REQ_INT_EN field.
	RSIM_CONTROL_BLE_RF_OSC_REQ_INT_EN_Pos = 0x4
	// Bit mask of BLE_RF_OSC_REQ_INT_EN field.
	RSIM_CONTROL_BLE_RF_OSC_REQ_INT_EN_Msk = 0x10
	// Bit BLE_RF_OSC_REQ_INT_EN.
	RSIM_CONTROL_BLE_RF_OSC_REQ_INT_EN = 0x10
	// Position of BLE_RF_OSC_REQ_INT field.
	RSIM_CONTROL_BLE_RF_OSC_REQ_INT_Pos = 0x5
	// Bit mask of BLE_RF_OSC_REQ_INT field.
	RSIM_CONTROL_BLE_RF_OSC_REQ_INT_Msk = 0x20
	// Bit BLE_RF_OSC_REQ_INT.
	RSIM_CONTROL_BLE_RF_OSC_REQ_INT = 0x20
	// Position of RF_OSC_EN field.
	RSIM_CONTROL_RF_OSC_EN_Pos = 0x8
	// Bit mask of RF_OSC_EN field.
	RSIM_CONTROL_RF_OSC_EN_Msk = 0xf00
	// RF Ref Osc will be controlled by the SoC, external pin, or a link layer
	RSIM_CONTROL_RF_OSC_EN_0000 = 0x0
	// RF Ref Osc on in Run/Wait
	RSIM_CONTROL_RF_OSC_EN_0001 = 0x1
	// RF Ref Osc on in Stop
	RSIM_CONTROL_RF_OSC_EN_0011 = 0x3
	// RF Ref Osc on in VLPR/VLPW
	RSIM_CONTROL_RF_OSC_EN_0111 = 0x7
	// RF Ref Osc on in VLPS
	RSIM_CONTROL_RF_OSC_EN_1111 = 0xf
	// Position of RADIO_GASKET_BYPASS_OVRD_EN field.
	RSIM_CONTROL_RADIO_GASKET_BYPASS_OVRD_EN_Pos = 0xc
	// Bit mask of RADIO_GASKET_BYPASS_OVRD_EN field.
	RSIM_CONTROL_RADIO_GASKET_BYPASS_OVRD_EN_Msk = 0x1000
	// Bit RADIO_GASKET_BYPASS_OVRD_EN.
	RSIM_CONTROL_RADIO_GASKET_BYPASS_OVRD_EN = 0x1000
	// Position of RADIO_GASKET_BYPASS_OVRD field.
	RSIM_CONTROL_RADIO_GASKET_BYPASS_OVRD_Pos = 0xd
	// Bit mask of RADIO_GASKET_BYPASS_OVRD field.
	RSIM_CONTROL_RADIO_GASKET_BYPASS_OVRD_Msk = 0x2000
	// Bit RADIO_GASKET_BYPASS_OVRD.
	RSIM_CONTROL_RADIO_GASKET_BYPASS_OVRD = 0x2000
	// Position of IPP_OBE_3V_BLE_ACTIVE_1 field.
	RSIM_CONTROL_IPP_OBE_3V_BLE_ACTIVE_1_Pos = 0x10
	// Bit mask of IPP_OBE_3V_BLE_ACTIVE_1 field.
	RSIM_CONTROL_IPP_OBE_3V_BLE_ACTIVE_1_Msk = 0x10000
	// Bit IPP_OBE_3V_BLE_ACTIVE_1.
	RSIM_CONTROL_IPP_OBE_3V_BLE_ACTIVE_1 = 0x10000
	// Position of IPP_OBE_3V_BLE_ACTIVE_2 field.
	RSIM_CONTROL_IPP_OBE_3V_BLE_ACTIVE_2_Pos = 0x11
	// Bit mask of IPP_OBE_3V_BLE_ACTIVE_2 field.
	RSIM_CONTROL_IPP_OBE_3V_BLE_ACTIVE_2_Msk = 0x20000
	// Bit IPP_OBE_3V_BLE_ACTIVE_2.
	RSIM_CONTROL_IPP_OBE_3V_BLE_ACTIVE_2 = 0x20000
	// Position of RADIO_RAM_ACCESS_OVRD_EN field.
	RSIM_CONTROL_RADIO_RAM_ACCESS_OVRD_EN_Pos = 0x12
	// Bit mask of RADIO_RAM_ACCESS_OVRD_EN field.
	RSIM_CONTROL_RADIO_RAM_ACCESS_OVRD_EN_Msk = 0x40000
	// Bit RADIO_RAM_ACCESS_OVRD_EN.
	RSIM_CONTROL_RADIO_RAM_ACCESS_OVRD_EN = 0x40000
	// Position of RADIO_RAM_ACCESS_OVRD field.
	RSIM_CONTROL_RADIO_RAM_ACCESS_OVRD_Pos = 0x13
	// Bit mask of RADIO_RAM_ACCESS_OVRD field.
	RSIM_CONTROL_RADIO_RAM_ACCESS_OVRD_Msk = 0x80000
	// Bit RADIO_RAM_ACCESS_OVRD.
	RSIM_CONTROL_RADIO_RAM_ACCESS_OVRD = 0x80000
	// Position of RSIM_DSM_EXIT field.
	RSIM_CONTROL_RSIM_DSM_EXIT_Pos = 0x14
	// Bit mask of RSIM_DSM_EXIT field.
	RSIM_CONTROL_RSIM_DSM_EXIT_Msk = 0x100000
	// Bit RSIM_DSM_EXIT.
	RSIM_CONTROL_RSIM_DSM_EXIT = 0x100000
	// Position of RSIM_STOP_ACK_OVRD_EN field.
	RSIM_CONTROL_RSIM_STOP_ACK_OVRD_EN_Pos = 0x16
	// Bit mask of RSIM_STOP_ACK_OVRD_EN field.
	RSIM_CONTROL_RSIM_STOP_ACK_OVRD_EN_Msk = 0x400000
	// Bit RSIM_STOP_ACK_OVRD_EN.
	RSIM_CONTROL_RSIM_STOP_ACK_OVRD_EN = 0x400000
	// Position of RSIM_STOP_ACK_OVRD field.
	RSIM_CONTROL_RSIM_STOP_ACK_OVRD_Pos = 0x17
	// Bit mask of RSIM_STOP_ACK_OVRD field.
	RSIM_CONTROL_RSIM_STOP_ACK_OVRD_Msk = 0x800000
	// Bit RSIM_STOP_ACK_OVRD.
	RSIM_CONTROL_RSIM_STOP_ACK_OVRD = 0x800000
	// Position of RF_OSC_READY field.
	RSIM_CONTROL_RF_OSC_READY_Pos = 0x18
	// Bit mask of RF_OSC_READY field.
	RSIM_CONTROL_RF_OSC_READY_Msk = 0x1000000
	// Bit RF_OSC_READY.
	RSIM_CONTROL_RF_OSC_READY = 0x1000000
	// Position of RF_OSC_READY_OVRD_EN field.
	RSIM_CONTROL_RF_OSC_READY_OVRD_EN_Pos = 0x19
	// Bit mask of RF_OSC_READY_OVRD_EN field.
	RSIM_CONTROL_RF_OSC_READY_OVRD_EN_Msk = 0x2000000
	// Bit RF_OSC_READY_OVRD_EN.
	RSIM_CONTROL_RF_OSC_READY_OVRD_EN = 0x2000000
	// Position of RF_OSC_READY_OVRD field.
	RSIM_CONTROL_RF_OSC_READY_OVRD_Pos = 0x1a
	// Bit mask of RF_OSC_READY_OVRD field.
	RSIM_CONTROL_RF_OSC_READY_OVRD_Msk = 0x4000000
	// Bit RF_OSC_READY_OVRD.
	RSIM_CONTROL_RF_OSC_READY_OVRD = 0x4000000
	// Position of BLOCK_SOC_RESETS field.
	RSIM_CONTROL_BLOCK_SOC_RESETS_Pos = 0x1c
	// Bit mask of BLOCK_SOC_RESETS field.
	RSIM_CONTROL_BLOCK_SOC_RESETS_Msk = 0x10000000
	// Bit BLOCK_SOC_RESETS.
	RSIM_CONTROL_BLOCK_SOC_RESETS = 0x10000000
	// Position of BLOCK_RADIO_OUTPUTS field.
	RSIM_CONTROL_BLOCK_RADIO_OUTPUTS_Pos = 0x1d
	// Bit mask of BLOCK_RADIO_OUTPUTS field.
	RSIM_CONTROL_BLOCK_RADIO_OUTPUTS_Msk = 0x20000000
	// Bit BLOCK_RADIO_OUTPUTS.
	RSIM_CONTROL_BLOCK_RADIO_OUTPUTS = 0x20000000
	// Position of ALLOW_DFT_RESETS field.
	RSIM_CONTROL_ALLOW_DFT_RESETS_Pos = 0x1e
	// Bit mask of ALLOW_DFT_RESETS field.
	RSIM_CONTROL_ALLOW_DFT_RESETS_Msk = 0x40000000
	// Bit ALLOW_DFT_RESETS.
	RSIM_CONTROL_ALLOW_DFT_RESETS = 0x40000000
	// Position of RADIO_RESET_BIT field.
	RSIM_CONTROL_RADIO_RESET_BIT_Pos = 0x1f
	// Bit mask of RADIO_RESET_BIT field.
	RSIM_CONTROL_RADIO_RESET_BIT_Msk = 0x80000000
	// Bit RADIO_RESET_BIT.
	RSIM_CONTROL_RADIO_RESET_BIT = 0x80000000

	// ACTIVE_DELAY: Radio Active Early Warning
	// Position of BLE_FINE_DELAY field.
	RSIM_ACTIVE_DELAY_BLE_FINE_DELAY_Pos = 0x0
	// Bit mask of BLE_FINE_DELAY field.
	RSIM_ACTIVE_DELAY_BLE_FINE_DELAY_Msk = 0x3f
	// Position of BLE_COARSE_DELAY field.
	RSIM_ACTIVE_DELAY_BLE_COARSE_DELAY_Pos = 0x10
	// Bit mask of BLE_COARSE_DELAY field.
	RSIM_ACTIVE_DELAY_BLE_COARSE_DELAY_Msk = 0xf0000

	// MAC_MSB: Radio MAC Address
	// Position of MAC_ADDR_MSB field.
	RSIM_MAC_MSB_MAC_ADDR_MSB_Pos = 0x0
	// Bit mask of MAC_ADDR_MSB field.
	RSIM_MAC_MSB_MAC_ADDR_MSB_Msk = 0xff

	// MAC_LSB: Radio MAC Address
	// Position of MAC_ADDR_LSB field.
	RSIM_MAC_LSB_MAC_ADDR_LSB_Pos = 0x0
	// Bit mask of MAC_ADDR_LSB field.
	RSIM_MAC_LSB_MAC_ADDR_LSB_Msk = 0xffffffff

	// MISC: Radio Miscellaneous
	// Position of ANALOG_TEST_EN field.
	RSIM_MISC_ANALOG_TEST_EN_Pos = 0x0
	// Bit mask of ANALOG_TEST_EN field.
	RSIM_MISC_ANALOG_TEST_EN_Msk = 0x1f
	// Position of RADIO_VERSION field.
	RSIM_MISC_RADIO_VERSION_Pos = 0x18
	// Bit mask of RADIO_VERSION field.
	RSIM_MISC_RADIO_VERSION_Msk = 0xff000000

	// DSM_TIMER: Deep Sleep Timer
	// Position of DSM_TIMER field.
	RSIM_DSM_TIMER_DSM_TIMER_Pos = 0x0
	// Bit mask of DSM_TIMER field.
	RSIM_DSM_TIMER_DSM_TIMER_Msk = 0xffffff

	// DSM_CONTROL: Deep Sleep Timer Control
	// Position of DSM_ANT_READY field.
	RSIM_DSM_CONTROL_DSM_ANT_READY_Pos = 0x0
	// Bit mask of DSM_ANT_READY field.
	RSIM_DSM_CONTROL_DSM_ANT_READY_Msk = 0x1
	// Bit DSM_ANT_READY.
	RSIM_DSM_CONTROL_DSM_ANT_READY = 0x1
	// Position of ANT_DEEP_SLEEP_STATUS field.
	RSIM_DSM_CONTROL_ANT_DEEP_SLEEP_STATUS_Pos = 0x1
	// Bit mask of ANT_DEEP_SLEEP_STATUS field.
	RSIM_DSM_CONTROL_ANT_DEEP_SLEEP_STATUS_Msk = 0x2
	// Bit ANT_DEEP_SLEEP_STATUS.
	RSIM_DSM_CONTROL_ANT_DEEP_SLEEP_STATUS = 0x2
	// Position of DSM_ANT_FINISHED field.
	RSIM_DSM_CONTROL_DSM_ANT_FINISHED_Pos = 0x2
	// Bit mask of DSM_ANT_FINISHED field.
	RSIM_DSM_CONTROL_DSM_ANT_FINISHED_Msk = 0x4
	// Bit DSM_ANT_FINISHED.
	RSIM_DSM_CONTROL_DSM_ANT_FINISHED = 0x4
	// Position of ANT_SYSCLK_REQUEST_EN field.
	RSIM_DSM_CONTROL_ANT_SYSCLK_REQUEST_EN_Pos = 0x3
	// Bit mask of ANT_SYSCLK_REQUEST_EN field.
	RSIM_DSM_CONTROL_ANT_SYSCLK_REQUEST_EN_Msk = 0x8
	// Bit ANT_SYSCLK_REQUEST_EN.
	RSIM_DSM_CONTROL_ANT_SYSCLK_REQUEST_EN = 0x8
	// Position of ANT_SLEEP_REQUEST field.
	RSIM_DSM_CONTROL_ANT_SLEEP_REQUEST_Pos = 0x4
	// Bit mask of ANT_SLEEP_REQUEST field.
	RSIM_DSM_CONTROL_ANT_SLEEP_REQUEST_Msk = 0x10
	// Bit ANT_SLEEP_REQUEST.
	RSIM_DSM_CONTROL_ANT_SLEEP_REQUEST = 0x10
	// Position of ANT_SYSCLK_REQ field.
	RSIM_DSM_CONTROL_ANT_SYSCLK_REQ_Pos = 0x5
	// Bit mask of ANT_SYSCLK_REQ field.
	RSIM_DSM_CONTROL_ANT_SYSCLK_REQ_Msk = 0x20
	// Bit ANT_SYSCLK_REQ.
	RSIM_DSM_CONTROL_ANT_SYSCLK_REQ = 0x20
	// Position of ANT_SYSCLK_INTERRUPT_EN field.
	RSIM_DSM_CONTROL_ANT_SYSCLK_INTERRUPT_EN_Pos = 0x6
	// Bit mask of ANT_SYSCLK_INTERRUPT_EN field.
	RSIM_DSM_CONTROL_ANT_SYSCLK_INTERRUPT_EN_Msk = 0x40
	// Bit ANT_SYSCLK_INTERRUPT_EN.
	RSIM_DSM_CONTROL_ANT_SYSCLK_INTERRUPT_EN = 0x40
	// Position of ANT_SYSCLK_REQ_INT field.
	RSIM_DSM_CONTROL_ANT_SYSCLK_REQ_INT_Pos = 0x7
	// Bit mask of ANT_SYSCLK_REQ_INT field.
	RSIM_DSM_CONTROL_ANT_SYSCLK_REQ_INT_Msk = 0x80
	// Bit ANT_SYSCLK_REQ_INT.
	RSIM_DSM_CONTROL_ANT_SYSCLK_REQ_INT = 0x80
	// Position of DSM_GEN_READY field.
	RSIM_DSM_CONTROL_DSM_GEN_READY_Pos = 0x8
	// Bit mask of DSM_GEN_READY field.
	RSIM_DSM_CONTROL_DSM_GEN_READY_Msk = 0x100
	// Bit DSM_GEN_READY.
	RSIM_DSM_CONTROL_DSM_GEN_READY = 0x100
	// Position of GEN_DEEP_SLEEP_STATUS field.
	RSIM_DSM_CONTROL_GEN_DEEP_SLEEP_STATUS_Pos = 0x9
	// Bit mask of GEN_DEEP_SLEEP_STATUS field.
	RSIM_DSM_CONTROL_GEN_DEEP_SLEEP_STATUS_Msk = 0x200
	// Bit GEN_DEEP_SLEEP_STATUS.
	RSIM_DSM_CONTROL_GEN_DEEP_SLEEP_STATUS = 0x200
	// Position of DSM_GEN_FINISHED field.
	RSIM_DSM_CONTROL_DSM_GEN_FINISHED_Pos = 0xa
	// Bit mask of DSM_GEN_FINISHED field.
	RSIM_DSM_CONTROL_DSM_GEN_FINISHED_Msk = 0x400
	// Bit DSM_GEN_FINISHED.
	RSIM_DSM_CONTROL_DSM_GEN_FINISHED = 0x400
	// Position of GEN_SYSCLK_REQUEST_EN field.
	RSIM_DSM_CONTROL_GEN_SYSCLK_REQUEST_EN_Pos = 0xb
	// Bit mask of GEN_SYSCLK_REQUEST_EN field.
	RSIM_DSM_CONTROL_GEN_SYSCLK_REQUEST_EN_Msk = 0x800
	// Bit GEN_SYSCLK_REQUEST_EN.
	RSIM_DSM_CONTROL_GEN_SYSCLK_REQUEST_EN = 0x800
	// Position of GEN_SLEEP_REQUEST field.
	RSIM_DSM_CONTROL_GEN_SLEEP_REQUEST_Pos = 0xc
	// Bit mask of GEN_SLEEP_REQUEST field.
	RSIM_DSM_CONTROL_GEN_SLEEP_REQUEST_Msk = 0x1000
	// Bit GEN_SLEEP_REQUEST.
	RSIM_DSM_CONTROL_GEN_SLEEP_REQUEST = 0x1000
	// Position of GEN_SYSCLK_REQ field.
	RSIM_DSM_CONTROL_GEN_SYSCLK_REQ_Pos = 0xd
	// Bit mask of GEN_SYSCLK_REQ field.
	RSIM_DSM_CONTROL_GEN_SYSCLK_REQ_Msk = 0x2000
	// Bit GEN_SYSCLK_REQ.
	RSIM_DSM_CONTROL_GEN_SYSCLK_REQ = 0x2000
	// Position of GEN_SYSCLK_INTERRUPT_EN field.
	RSIM_DSM_CONTROL_GEN_SYSCLK_INTERRUPT_EN_Pos = 0xe
	// Bit mask of GEN_SYSCLK_INTERRUPT_EN field.
	RSIM_DSM_CONTROL_GEN_SYSCLK_INTERRUPT_EN_Msk = 0x4000
	// Bit GEN_SYSCLK_INTERRUPT_EN.
	RSIM_DSM_CONTROL_GEN_SYSCLK_INTERRUPT_EN = 0x4000
	// Position of GEN_SYSCLK_REQ_INT field.
	RSIM_DSM_CONTROL_GEN_SYSCLK_REQ_INT_Pos = 0xf
	// Bit mask of GEN_SYSCLK_REQ_INT field.
	RSIM_DSM_CONTROL_GEN_SYSCLK_REQ_INT_Msk = 0x8000
	// Bit GEN_SYSCLK_REQ_INT.
	RSIM_DSM_CONTROL_GEN_SYSCLK_REQ_INT = 0x8000
	// Position of DSM_ZIG_READY field.
	RSIM_DSM_CONTROL_DSM_ZIG_READY_Pos = 0x10
	// Bit mask of DSM_ZIG_READY field.
	RSIM_DSM_CONTROL_DSM_ZIG_READY_Msk = 0x10000
	// Bit DSM_ZIG_READY.
	RSIM_DSM_CONTROL_DSM_ZIG_READY = 0x10000
	// Position of ZIG_DEEP_SLEEP_STATUS field.
	RSIM_DSM_CONTROL_ZIG_DEEP_SLEEP_STATUS_Pos = 0x11
	// Bit mask of ZIG_DEEP_SLEEP_STATUS field.
	RSIM_DSM_CONTROL_ZIG_DEEP_SLEEP_STATUS_Msk = 0x20000
	// Bit ZIG_DEEP_SLEEP_STATUS.
	RSIM_DSM_CONTROL_ZIG_DEEP_SLEEP_STATUS = 0x20000
	// Position of DSM_ZIG_FINISHED field.
	RSIM_DSM_CONTROL_DSM_ZIG_FINISHED_Pos = 0x12
	// Bit mask of DSM_ZIG_FINISHED field.
	RSIM_DSM_CONTROL_DSM_ZIG_FINISHED_Msk = 0x40000
	// Bit DSM_ZIG_FINISHED.
	RSIM_DSM_CONTROL_DSM_ZIG_FINISHED = 0x40000
	// Position of ZIG_SYSCLK_REQUEST_EN field.
	RSIM_DSM_CONTROL_ZIG_SYSCLK_REQUEST_EN_Pos = 0x13
	// Bit mask of ZIG_SYSCLK_REQUEST_EN field.
	RSIM_DSM_CONTROL_ZIG_SYSCLK_REQUEST_EN_Msk = 0x80000
	// Bit ZIG_SYSCLK_REQUEST_EN.
	RSIM_DSM_CONTROL_ZIG_SYSCLK_REQUEST_EN = 0x80000
	// Position of ZIG_SLEEP_REQUEST field.
	RSIM_DSM_CONTROL_ZIG_SLEEP_REQUEST_Pos = 0x14
	// Bit mask of ZIG_SLEEP_REQUEST field.
	RSIM_DSM_CONTROL_ZIG_SLEEP_REQUEST_Msk = 0x100000
	// Bit ZIG_SLEEP_REQUEST.
	RSIM_DSM_CONTROL_ZIG_SLEEP_REQUEST = 0x100000
	// Position of ZIG_SYSCLK_REQ field.
	RSIM_DSM_CONTROL_ZIG_SYSCLK_REQ_Pos = 0x15
	// Bit mask of ZIG_SYSCLK_REQ field.
	RSIM_DSM_CONTROL_ZIG_SYSCLK_REQ_Msk = 0x200000
	// Bit ZIG_SYSCLK_REQ.
	RSIM_DSM_CONTROL_ZIG_SYSCLK_REQ = 0x200000
	// Position of ZIG_SYSCLK_INTERRUPT_EN field.
	RSIM_DSM_CONTROL_ZIG_SYSCLK_INTERRUPT_EN_Pos = 0x16
	// Bit mask of ZIG_SYSCLK_INTERRUPT_EN field.
	RSIM_DSM_CONTROL_ZIG_SYSCLK_INTERRUPT_EN_Msk = 0x400000
	// Bit ZIG_SYSCLK_INTERRUPT_EN.
	RSIM_DSM_CONTROL_ZIG_SYSCLK_INTERRUPT_EN = 0x400000
	// Position of ZIG_SYSCLK_REQ_INT field.
	RSIM_DSM_CONTROL_ZIG_SYSCLK_REQ_INT_Pos = 0x17
	// Bit mask of ZIG_SYSCLK_REQ_INT field.
	RSIM_DSM_CONTROL_ZIG_SYSCLK_REQ_INT_Msk = 0x800000
	// Bit ZIG_SYSCLK_REQ_INT.
	RSIM_DSM_CONTROL_ZIG_SYSCLK_REQ_INT = 0x800000
	// Position of DSM_TIMER_CLR field.
	RSIM_DSM_CONTROL_DSM_TIMER_CLR_Pos = 0x1b
	// Bit mask of DSM_TIMER_CLR field.
	RSIM_DSM_CONTROL_DSM_TIMER_CLR_Msk = 0x8000000
	// Bit DSM_TIMER_CLR.
	RSIM_DSM_CONTROL_DSM_TIMER_CLR = 0x8000000
	// Position of DSM_TIMER_EN field.
	RSIM_DSM_CONTROL_DSM_TIMER_EN_Pos = 0x1f
	// Bit mask of DSM_TIMER_EN field.
	RSIM_DSM_CONTROL_DSM_TIMER_EN_Msk = 0x80000000
	// Bit DSM_TIMER_EN.
	RSIM_DSM_CONTROL_DSM_TIMER_EN = 0x80000000

	// DSM_OSC_OFFSET: Deep Sleep Wakeup Time Offset
	// Position of DSM_OSC_STABILIZE_TIME field.
	RSIM_DSM_OSC_OFFSET_DSM_OSC_STABILIZE_TIME_Pos = 0x0
	// Bit mask of DSM_OSC_STABILIZE_TIME field.
	RSIM_DSM_OSC_OFFSET_DSM_OSC_STABILIZE_TIME_Msk = 0x3ff

	// ANT_SLEEP: ANT Link Layer Sleep Time
	// Position of ANT_SLEEP_TIME field.
	RSIM_ANT_SLEEP_ANT_SLEEP_TIME_Pos = 0x0
	// Bit mask of ANT_SLEEP_TIME field.
	RSIM_ANT_SLEEP_ANT_SLEEP_TIME_Msk = 0xffffff

	// ANT_WAKE: ANT Link Layer Wake Time
	// Position of ANT_WAKE_TIME field.
	RSIM_ANT_WAKE_ANT_WAKE_TIME_Pos = 0x0
	// Bit mask of ANT_WAKE_TIME field.
	RSIM_ANT_WAKE_ANT_WAKE_TIME_Msk = 0xffffff

	// ZIG_SLEEP: 802.15.4 Link Layer Sleep Time
	// Position of ZIG_SLEEP_TIME field.
	RSIM_ZIG_SLEEP_ZIG_SLEEP_TIME_Pos = 0x0
	// Bit mask of ZIG_SLEEP_TIME field.
	RSIM_ZIG_SLEEP_ZIG_SLEEP_TIME_Msk = 0xffffff

	// ZIG_WAKE: 802.15.4 Link Layer Wake Time
	// Position of ZIG_WAKE_TIME field.
	RSIM_ZIG_WAKE_ZIG_WAKE_TIME_Pos = 0x0
	// Bit mask of ZIG_WAKE_TIME field.
	RSIM_ZIG_WAKE_ZIG_WAKE_TIME_Msk = 0xffffff

	// GEN_SLEEP: Generic FSK Link Layer Sleep Time
	// Position of GEN_SLEEP_TIME field.
	RSIM_GEN_SLEEP_GEN_SLEEP_TIME_Pos = 0x0
	// Bit mask of GEN_SLEEP_TIME field.
	RSIM_GEN_SLEEP_GEN_SLEEP_TIME_Msk = 0xffffff

	// GEN_WAKE: Generic FSK Link Layer Wake Time
	// Position of GEN_WAKE_TIME field.
	RSIM_GEN_WAKE_GEN_WAKE_TIME_Pos = 0x0
	// Bit mask of GEN_WAKE_TIME field.
	RSIM_GEN_WAKE_GEN_WAKE_TIME_Msk = 0xffffff

	// RF_OSC_CTRL: Radio Oscillator Control
	// Position of BB_XTAL_ALC_COUNT_SEL field.
	RSIM_RF_OSC_CTRL_BB_XTAL_ALC_COUNT_SEL_Pos = 0x0
	// Bit mask of BB_XTAL_ALC_COUNT_SEL field.
	RSIM_RF_OSC_CTRL_BB_XTAL_ALC_COUNT_SEL_Msk = 0x3
	// Position of BB_XTAL_ALC_ON field.
	RSIM_RF_OSC_CTRL_BB_XTAL_ALC_ON_Pos = 0x2
	// Bit mask of BB_XTAL_ALC_ON field.
	RSIM_RF_OSC_CTRL_BB_XTAL_ALC_ON_Msk = 0x4
	// Bit BB_XTAL_ALC_ON.
	RSIM_RF_OSC_CTRL_BB_XTAL_ALC_ON = 0x4
	// Position of RF_OSC_BYPASS_EN field.
	RSIM_RF_OSC_CTRL_RF_OSC_BYPASS_EN_Pos = 0x3
	// Bit mask of RF_OSC_BYPASS_EN field.
	RSIM_RF_OSC_CTRL_RF_OSC_BYPASS_EN_Msk = 0x8
	// Bit RF_OSC_BYPASS_EN.
	RSIM_RF_OSC_CTRL_RF_OSC_BYPASS_EN = 0x8
	// Position of BB_XTAL_COMP_BIAS field.
	RSIM_RF_OSC_CTRL_BB_XTAL_COMP_BIAS_Pos = 0x4
	// Bit mask of BB_XTAL_COMP_BIAS field.
	RSIM_RF_OSC_CTRL_BB_XTAL_COMP_BIAS_Msk = 0x1f0
	// Position of BB_XTAL_DC_COUP_MODE_EN field.
	RSIM_RF_OSC_CTRL_BB_XTAL_DC_COUP_MODE_EN_Pos = 0x9
	// Bit mask of BB_XTAL_DC_COUP_MODE_EN field.
	RSIM_RF_OSC_CTRL_BB_XTAL_DC_COUP_MODE_EN_Msk = 0x200
	// Bit BB_XTAL_DC_COUP_MODE_EN.
	RSIM_RF_OSC_CTRL_BB_XTAL_DC_COUP_MODE_EN = 0x200
	// Position of BB_XTAL_DIAGSEL field.
	RSIM_RF_OSC_CTRL_BB_XTAL_DIAGSEL_Pos = 0xa
	// Bit mask of BB_XTAL_DIAGSEL field.
	RSIM_RF_OSC_CTRL_BB_XTAL_DIAGSEL_Msk = 0x400
	// Bit BB_XTAL_DIAGSEL.
	RSIM_RF_OSC_CTRL_BB_XTAL_DIAGSEL = 0x400
	// Position of BB_XTAL_DIG_CLK_ON field.
	RSIM_RF_OSC_CTRL_BB_XTAL_DIG_CLK_ON_Pos = 0xb
	// Bit mask of BB_XTAL_DIG_CLK_ON field.
	RSIM_RF_OSC_CTRL_BB_XTAL_DIG_CLK_ON_Msk = 0x800
	// Bit BB_XTAL_DIG_CLK_ON.
	RSIM_RF_OSC_CTRL_BB_XTAL_DIG_CLK_ON = 0x800
	// Position of BB_XTAL_GM field.
	RSIM_RF_OSC_CTRL_BB_XTAL_GM_Pos = 0xc
	// Bit mask of BB_XTAL_GM field.
	RSIM_RF_OSC_CTRL_BB_XTAL_GM_Msk = 0x1f000
	// Position of BB_XTAL_ON_OVRD field.
	RSIM_RF_OSC_CTRL_BB_XTAL_ON_OVRD_Pos = 0x11
	// Bit mask of BB_XTAL_ON_OVRD field.
	RSIM_RF_OSC_CTRL_BB_XTAL_ON_OVRD_Msk = 0x20000
	// Bit BB_XTAL_ON_OVRD.
	RSIM_RF_OSC_CTRL_BB_XTAL_ON_OVRD = 0x20000
	// Position of BB_XTAL_ON_OVRD_ON field.
	RSIM_RF_OSC_CTRL_BB_XTAL_ON_OVRD_ON_Pos = 0x12
	// Bit mask of BB_XTAL_ON_OVRD_ON field.
	RSIM_RF_OSC_CTRL_BB_XTAL_ON_OVRD_ON_Msk = 0x40000
	// Bit BB_XTAL_ON_OVRD_ON.
	RSIM_RF_OSC_CTRL_BB_XTAL_ON_OVRD_ON = 0x40000
	// Position of BB_XTAL_READY_COUNT_SEL field.
	RSIM_RF_OSC_CTRL_BB_XTAL_READY_COUNT_SEL_Pos = 0x14
	// Bit mask of BB_XTAL_READY_COUNT_SEL field.
	RSIM_RF_OSC_CTRL_BB_XTAL_READY_COUNT_SEL_Msk = 0x300000
	// Position of RADIO_EXT_OSC_RF_EN_SEL field.
	RSIM_RF_OSC_CTRL_RADIO_EXT_OSC_RF_EN_SEL_Pos = 0x1b
	// Bit mask of RADIO_EXT_OSC_RF_EN_SEL field.
	RSIM_RF_OSC_CTRL_RADIO_EXT_OSC_RF_EN_SEL_Msk = 0x8000000
	// Bit RADIO_EXT_OSC_RF_EN_SEL.
	RSIM_RF_OSC_CTRL_RADIO_EXT_OSC_RF_EN_SEL = 0x8000000
	// Position of RADIO_EXT_OSC_OVRD field.
	RSIM_RF_OSC_CTRL_RADIO_EXT_OSC_OVRD_Pos = 0x1c
	// Bit mask of RADIO_EXT_OSC_OVRD field.
	RSIM_RF_OSC_CTRL_RADIO_EXT_OSC_OVRD_Msk = 0x10000000
	// Bit RADIO_EXT_OSC_OVRD.
	RSIM_RF_OSC_CTRL_RADIO_EXT_OSC_OVRD = 0x10000000
	// Position of RADIO_EXT_OSC_OVRD_EN field.
	RSIM_RF_OSC_CTRL_RADIO_EXT_OSC_OVRD_EN_Pos = 0x1d
	// Bit mask of RADIO_EXT_OSC_OVRD_EN field.
	RSIM_RF_OSC_CTRL_RADIO_EXT_OSC_OVRD_EN_Msk = 0x20000000
	// Bit RADIO_EXT_OSC_OVRD_EN.
	RSIM_RF_OSC_CTRL_RADIO_EXT_OSC_OVRD_EN = 0x20000000
	// Position of RADIO_RF_ABORT_OVRD field.
	RSIM_RF_OSC_CTRL_RADIO_RF_ABORT_OVRD_Pos = 0x1e
	// Bit mask of RADIO_RF_ABORT_OVRD field.
	RSIM_RF_OSC_CTRL_RADIO_RF_ABORT_OVRD_Msk = 0x40000000
	// Bit RADIO_RF_ABORT_OVRD.
	RSIM_RF_OSC_CTRL_RADIO_RF_ABORT_OVRD = 0x40000000
	// Position of RADIO_RF_ABORT_OVRD_EN field.
	RSIM_RF_OSC_CTRL_RADIO_RF_ABORT_OVRD_EN_Pos = 0x1f
	// Bit mask of RADIO_RF_ABORT_OVRD_EN field.
	RSIM_RF_OSC_CTRL_RADIO_RF_ABORT_OVRD_EN_Msk = 0x80000000
	// Bit RADIO_RF_ABORT_OVRD_EN.
	RSIM_RF_OSC_CTRL_RADIO_RF_ABORT_OVRD_EN = 0x80000000

	// ANA_TEST: Radio Analog Test Registers
	// Position of BB_LDO_LS_BYP field.
	RSIM_ANA_TEST_BB_LDO_LS_BYP_Pos = 0x0
	// Bit mask of BB_LDO_LS_BYP field.
	RSIM_ANA_TEST_BB_LDO_LS_BYP_Msk = 0x1
	// Bit BB_LDO_LS_BYP.
	RSIM_ANA_TEST_BB_LDO_LS_BYP = 0x1
	// Position of BB_LDO_LS_DIAGSEL field.
	RSIM_ANA_TEST_BB_LDO_LS_DIAGSEL_Pos = 0x1
	// Bit mask of BB_LDO_LS_DIAGSEL field.
	RSIM_ANA_TEST_BB_LDO_LS_DIAGSEL_Msk = 0x2
	// Bit BB_LDO_LS_DIAGSEL.
	RSIM_ANA_TEST_BB_LDO_LS_DIAGSEL = 0x2
	// Position of BB_LDO_XO_BYP_ON field.
	RSIM_ANA_TEST_BB_LDO_XO_BYP_ON_Pos = 0x2
	// Bit mask of BB_LDO_XO_BYP_ON field.
	RSIM_ANA_TEST_BB_LDO_XO_BYP_ON_Msk = 0x4
	// Bit BB_LDO_XO_BYP_ON.
	RSIM_ANA_TEST_BB_LDO_XO_BYP_ON = 0x4
	// Position of BB_LDO_XO_DIAGSEL field.
	RSIM_ANA_TEST_BB_LDO_XO_DIAGSEL_Pos = 0x3
	// Bit mask of BB_LDO_XO_DIAGSEL field.
	RSIM_ANA_TEST_BB_LDO_XO_DIAGSEL_Msk = 0x8
	// Bit BB_LDO_XO_DIAGSEL.
	RSIM_ANA_TEST_BB_LDO_XO_DIAGSEL = 0x8
	// Position of BB_XTAL_TEST field.
	RSIM_ANA_TEST_BB_XTAL_TEST_Pos = 0x4
	// Bit mask of BB_XTAL_TEST field.
	RSIM_ANA_TEST_BB_XTAL_TEST_Msk = 0x10
	// Bit BB_XTAL_TEST.
	RSIM_ANA_TEST_BB_XTAL_TEST = 0x10
	// Position of BG_DIAGBUF field.
	RSIM_ANA_TEST_BG_DIAGBUF_Pos = 0x5
	// Bit mask of BG_DIAGBUF field.
	RSIM_ANA_TEST_BG_DIAGBUF_Msk = 0x20
	// Bit BG_DIAGBUF.
	RSIM_ANA_TEST_BG_DIAGBUF = 0x20
	// Position of BG_DIAGSEL field.
	RSIM_ANA_TEST_BG_DIAGSEL_Pos = 0x6
	// Bit mask of BG_DIAGSEL field.
	RSIM_ANA_TEST_BG_DIAGSEL_Msk = 0x40
	// Bit BG_DIAGSEL.
	RSIM_ANA_TEST_BG_DIAGSEL = 0x40
	// Position of BG_STARTUPFORCE field.
	RSIM_ANA_TEST_BG_STARTUPFORCE_Pos = 0x7
	// Bit mask of BG_STARTUPFORCE field.
	RSIM_ANA_TEST_BG_STARTUPFORCE_Msk = 0x80
	// Bit BG_STARTUPFORCE.
	RSIM_ANA_TEST_BG_STARTUPFORCE = 0x80
	// Position of DIAG_1234_ON field.
	RSIM_ANA_TEST_DIAG_1234_ON_Pos = 0x8
	// Bit mask of DIAG_1234_ON field.
	RSIM_ANA_TEST_DIAG_1234_ON_Msk = 0x100
	// Bit DIAG_1234_ON.
	RSIM_ANA_TEST_DIAG_1234_ON = 0x100
	// Position of DIAG2SOCADC_DEC field.
	RSIM_ANA_TEST_DIAG2SOCADC_DEC_Pos = 0x9
	// Bit mask of DIAG2SOCADC_DEC field.
	RSIM_ANA_TEST_DIAG2SOCADC_DEC_Msk = 0x600
	// Position of DIAG2SOCADC_DEC_ON field.
	RSIM_ANA_TEST_DIAG2SOCADC_DEC_ON_Pos = 0xb
	// Bit mask of DIAG2SOCADC_DEC_ON field.
	RSIM_ANA_TEST_DIAG2SOCADC_DEC_ON_Msk = 0x800
	// Bit DIAG2SOCADC_DEC_ON.
	RSIM_ANA_TEST_DIAG2SOCADC_DEC_ON = 0x800
	// Position of DIAGCODE field.
	RSIM_ANA_TEST_DIAGCODE_Pos = 0xc
	// Bit mask of DIAGCODE field.
	RSIM_ANA_TEST_DIAGCODE_Msk = 0x7000

	// ANA_TRIM: Radio Analog Trim Registers
	// Position of BB_LDO_LS_SPARE field.
	RSIM_ANA_TRIM_BB_LDO_LS_SPARE_Pos = 0x0
	// Bit mask of BB_LDO_LS_SPARE field.
	RSIM_ANA_TRIM_BB_LDO_LS_SPARE_Msk = 0x3
	// Position of BB_LDO_LS_TRIM field.
	RSIM_ANA_TRIM_BB_LDO_LS_TRIM_Pos = 0x3
	// Bit mask of BB_LDO_LS_TRIM field.
	RSIM_ANA_TRIM_BB_LDO_LS_TRIM_Msk = 0x38
	// Position of BB_LDO_XO_SPARE field.
	RSIM_ANA_TRIM_BB_LDO_XO_SPARE_Pos = 0x6
	// Bit mask of BB_LDO_XO_SPARE field.
	RSIM_ANA_TRIM_BB_LDO_XO_SPARE_Msk = 0xc0
	// Position of BB_LDO_XO_TRIM field.
	RSIM_ANA_TRIM_BB_LDO_XO_TRIM_Pos = 0x8
	// Bit mask of BB_LDO_XO_TRIM field.
	RSIM_ANA_TRIM_BB_LDO_XO_TRIM_Msk = 0x700
	// Position of BB_XTAL_SPARE field.
	RSIM_ANA_TRIM_BB_XTAL_SPARE_Pos = 0xb
	// Bit mask of BB_XTAL_SPARE field.
	RSIM_ANA_TRIM_BB_XTAL_SPARE_Msk = 0xf800
	// Position of BB_XTAL_TRIM field.
	RSIM_ANA_TRIM_BB_XTAL_TRIM_Pos = 0x10
	// Bit mask of BB_XTAL_TRIM field.
	RSIM_ANA_TRIM_BB_XTAL_TRIM_Msk = 0xff0000
	// Position of BG_1V_TRIM field.
	RSIM_ANA_TRIM_BG_1V_TRIM_Pos = 0x18
	// Bit mask of BG_1V_TRIM field.
	RSIM_ANA_TRIM_BG_1V_TRIM_Msk = 0xf000000
	// Position of BG_IBIAS_5U_TRIM field.
	RSIM_ANA_TRIM_BG_IBIAS_5U_TRIM_Pos = 0x1c
	// Bit mask of BG_IBIAS_5U_TRIM field.
	RSIM_ANA_TRIM_BG_IBIAS_5U_TRIM_Msk = 0xf0000000
)

// Bitfields for DCDC: DC to DC Converter
const (
	// REG0: DCDC REGISTER 0
	// Position of DCDC_DISABLE_AUTO_CLK_SWITCH field.
	DCDC_REG0_DCDC_DISABLE_AUTO_CLK_SWITCH_Pos = 0x1
	// Bit mask of DCDC_DISABLE_AUTO_CLK_SWITCH field.
	DCDC_REG0_DCDC_DISABLE_AUTO_CLK_SWITCH_Msk = 0x2
	// Bit DCDC_DISABLE_AUTO_CLK_SWITCH.
	DCDC_REG0_DCDC_DISABLE_AUTO_CLK_SWITCH = 0x2
	// Position of DCDC_SEL_CLK field.
	DCDC_REG0_DCDC_SEL_CLK_Pos = 0x2
	// Bit mask of DCDC_SEL_CLK field.
	DCDC_REG0_DCDC_SEL_CLK_Msk = 0x4
	// Bit DCDC_SEL_CLK.
	DCDC_REG0_DCDC_SEL_CLK = 0x4
	// Position of DCDC_PWD_OSC_INT field.
	DCDC_REG0_DCDC_PWD_OSC_INT_Pos = 0x3
	// Bit mask of DCDC_PWD_OSC_INT field.
	DCDC_REG0_DCDC_PWD_OSC_INT_Msk = 0x8
	// Bit DCDC_PWD_OSC_INT.
	DCDC_REG0_DCDC_PWD_OSC_INT = 0x8
	// Position of DCDC_LP_DF_CMP_ENABLE field.
	DCDC_REG0_DCDC_LP_DF_CMP_ENABLE_Pos = 0x9
	// Bit mask of DCDC_LP_DF_CMP_ENABLE field.
	DCDC_REG0_DCDC_LP_DF_CMP_ENABLE_Msk = 0x200
	// Bit DCDC_LP_DF_CMP_ENABLE.
	DCDC_REG0_DCDC_LP_DF_CMP_ENABLE = 0x200
	// Position of DCDC_VBAT_DIV_CTRL field.
	DCDC_REG0_DCDC_VBAT_DIV_CTRL_Pos = 0xa
	// Bit mask of DCDC_VBAT_DIV_CTRL field.
	DCDC_REG0_DCDC_VBAT_DIV_CTRL_Msk = 0xc00
	// Position of DCDC_LP_STATE_HYS_L field.
	DCDC_REG0_DCDC_LP_STATE_HYS_L_Pos = 0x11
	// Bit mask of DCDC_LP_STATE_HYS_L field.
	DCDC_REG0_DCDC_LP_STATE_HYS_L_Msk = 0x60000
	// Target voltage value - 0 mV
	DCDC_REG0_DCDC_LP_STATE_HYS_L_00 = 0x0
	// Target voltage value - 25 mV
	DCDC_REG0_DCDC_LP_STATE_HYS_L_01 = 0x1
	// Target voltage value - 50 mV
	DCDC_REG0_DCDC_LP_STATE_HYS_L_10 = 0x2
	// Target voltage value - 75 mV
	DCDC_REG0_DCDC_LP_STATE_HYS_L_11 = 0x3
	// Position of DCDC_LP_STATE_HYS_H field.
	DCDC_REG0_DCDC_LP_STATE_HYS_H_Pos = 0x13
	// Bit mask of DCDC_LP_STATE_HYS_H field.
	DCDC_REG0_DCDC_LP_STATE_HYS_H_Msk = 0x180000
	// Target voltage value + 0 mV
	DCDC_REG0_DCDC_LP_STATE_HYS_H_00 = 0x0
	// Target voltage value + 25 mV
	DCDC_REG0_DCDC_LP_STATE_HYS_H_01 = 0x1
	// Target voltage value + 50 mV
	DCDC_REG0_DCDC_LP_STATE_HYS_H_10 = 0x2
	// Target voltage value + 75 mV
	DCDC_REG0_DCDC_LP_STATE_HYS_H_11 = 0x3
	// Position of HYST_LP_COMP_ADJ field.
	DCDC_REG0_HYST_LP_COMP_ADJ_Pos = 0x15
	// Bit mask of HYST_LP_COMP_ADJ field.
	DCDC_REG0_HYST_LP_COMP_ADJ_Msk = 0x200000
	// Bit HYST_LP_COMP_ADJ.
	DCDC_REG0_HYST_LP_COMP_ADJ = 0x200000
	// Position of HYST_LP_CMP_DISABLE field.
	DCDC_REG0_HYST_LP_CMP_DISABLE_Pos = 0x16
	// Bit mask of HYST_LP_CMP_DISABLE field.
	DCDC_REG0_HYST_LP_CMP_DISABLE_Msk = 0x400000
	// Bit HYST_LP_CMP_DISABLE.
	DCDC_REG0_HYST_LP_CMP_DISABLE = 0x400000
	// Position of OFFSET_RSNS_LP_ADJ field.
	DCDC_REG0_OFFSET_RSNS_LP_ADJ_Pos = 0x17
	// Bit mask of OFFSET_RSNS_LP_ADJ field.
	DCDC_REG0_OFFSET_RSNS_LP_ADJ_Msk = 0x800000
	// Bit OFFSET_RSNS_LP_ADJ.
	DCDC_REG0_OFFSET_RSNS_LP_ADJ = 0x800000
	// Position of OFFSET_RSNS_LP_DISABLE field.
	DCDC_REG0_OFFSET_RSNS_LP_DISABLE_Pos = 0x18
	// Bit mask of OFFSET_RSNS_LP_DISABLE field.
	DCDC_REG0_OFFSET_RSNS_LP_DISABLE_Msk = 0x1000000
	// Bit OFFSET_RSNS_LP_DISABLE.
	DCDC_REG0_OFFSET_RSNS_LP_DISABLE = 0x1000000
	// Position of DCDC_LESS_I field.
	DCDC_REG0_DCDC_LESS_I_Pos = 0x19
	// Bit mask of DCDC_LESS_I field.
	DCDC_REG0_DCDC_LESS_I_Msk = 0x2000000
	// Bit DCDC_LESS_I.
	DCDC_REG0_DCDC_LESS_I = 0x2000000
	// Position of PWD_CMP_OFFSET field.
	DCDC_REG0_PWD_CMP_OFFSET_Pos = 0x1a
	// Bit mask of PWD_CMP_OFFSET field.
	DCDC_REG0_PWD_CMP_OFFSET_Msk = 0x4000000
	// Bit PWD_CMP_OFFSET.
	DCDC_REG0_PWD_CMP_OFFSET = 0x4000000
	// Position of DCDC_XTALOK_DISABLE field.
	DCDC_REG0_DCDC_XTALOK_DISABLE_Pos = 0x1b
	// Bit mask of DCDC_XTALOK_DISABLE field.
	DCDC_REG0_DCDC_XTALOK_DISABLE_Msk = 0x8000000
	// Bit DCDC_XTALOK_DISABLE.
	DCDC_REG0_DCDC_XTALOK_DISABLE = 0x8000000
	// Position of PSWITCH_STATUS field.
	DCDC_REG0_PSWITCH_STATUS_Pos = 0x1c
	// Bit mask of PSWITCH_STATUS field.
	DCDC_REG0_PSWITCH_STATUS_Msk = 0x10000000
	// Bit PSWITCH_STATUS.
	DCDC_REG0_PSWITCH_STATUS = 0x10000000
	// Position of VLPS_CONFIG_DCDC_HP field.
	DCDC_REG0_VLPS_CONFIG_DCDC_HP_Pos = 0x1d
	// Bit mask of VLPS_CONFIG_DCDC_HP field.
	DCDC_REG0_VLPS_CONFIG_DCDC_HP_Msk = 0x20000000
	// Bit VLPS_CONFIG_DCDC_HP.
	DCDC_REG0_VLPS_CONFIG_DCDC_HP = 0x20000000
	// Position of VLPR_VLPW_CONFIG_DCDC_HP field.
	DCDC_REG0_VLPR_VLPW_CONFIG_DCDC_HP_Pos = 0x1e
	// Bit mask of VLPR_VLPW_CONFIG_DCDC_HP field.
	DCDC_REG0_VLPR_VLPW_CONFIG_DCDC_HP_Msk = 0x40000000
	// Bit VLPR_VLPW_CONFIG_DCDC_HP.
	DCDC_REG0_VLPR_VLPW_CONFIG_DCDC_HP = 0x40000000
	// Position of DCDC_STS_DC_OK field.
	DCDC_REG0_DCDC_STS_DC_OK_Pos = 0x1f
	// Bit mask of DCDC_STS_DC_OK field.
	DCDC_REG0_DCDC_STS_DC_OK_Msk = 0x80000000
	// Bit DCDC_STS_DC_OK.
	DCDC_REG0_DCDC_STS_DC_OK = 0x80000000

	// REG1: DCDC REGISTER 1
	// Position of POSLIMIT_BUCK_IN field.
	DCDC_REG1_POSLIMIT_BUCK_IN_Pos = 0x0
	// Bit mask of POSLIMIT_BUCK_IN field.
	DCDC_REG1_POSLIMIT_BUCK_IN_Msk = 0x7f
	// Position of POSLIMIT_BOOST_IN field.
	DCDC_REG1_POSLIMIT_BOOST_IN_Pos = 0x7
	// Bit mask of POSLIMIT_BOOST_IN field.
	DCDC_REG1_POSLIMIT_BOOST_IN_Msk = 0x3f80
	// Position of DCDC_LOOPCTRL_CM_HST_THRESH field.
	DCDC_REG1_DCDC_LOOPCTRL_CM_HST_THRESH_Pos = 0x15
	// Bit mask of DCDC_LOOPCTRL_CM_HST_THRESH field.
	DCDC_REG1_DCDC_LOOPCTRL_CM_HST_THRESH_Msk = 0x200000
	// Bit DCDC_LOOPCTRL_CM_HST_THRESH.
	DCDC_REG1_DCDC_LOOPCTRL_CM_HST_THRESH = 0x200000
	// Position of DCDC_LOOPCTRL_DF_HST_THRESH field.
	DCDC_REG1_DCDC_LOOPCTRL_DF_HST_THRESH_Pos = 0x16
	// Bit mask of DCDC_LOOPCTRL_DF_HST_THRESH field.
	DCDC_REG1_DCDC_LOOPCTRL_DF_HST_THRESH_Msk = 0x400000
	// Bit DCDC_LOOPCTRL_DF_HST_THRESH.
	DCDC_REG1_DCDC_LOOPCTRL_DF_HST_THRESH = 0x400000
	// Position of DCDC_LOOPCTRL_EN_CM_HYST field.
	DCDC_REG1_DCDC_LOOPCTRL_EN_CM_HYST_Pos = 0x17
	// Bit mask of DCDC_LOOPCTRL_EN_CM_HYST field.
	DCDC_REG1_DCDC_LOOPCTRL_EN_CM_HYST_Msk = 0x800000
	// Bit DCDC_LOOPCTRL_EN_CM_HYST.
	DCDC_REG1_DCDC_LOOPCTRL_EN_CM_HYST = 0x800000
	// Position of DCDC_LOOPCTRL_EN_DF_HYST field.
	DCDC_REG1_DCDC_LOOPCTRL_EN_DF_HYST_Pos = 0x18
	// Bit mask of DCDC_LOOPCTRL_EN_DF_HYST field.
	DCDC_REG1_DCDC_LOOPCTRL_EN_DF_HYST_Msk = 0x1000000
	// Bit DCDC_LOOPCTRL_EN_DF_HYST.
	DCDC_REG1_DCDC_LOOPCTRL_EN_DF_HYST = 0x1000000

	// REG2: DCDC REGISTER 2
	// Position of DCDC_LOOPCTRL_HYST_SIGN field.
	DCDC_REG2_DCDC_LOOPCTRL_HYST_SIGN_Pos = 0xd
	// Bit mask of DCDC_LOOPCTRL_HYST_SIGN field.
	DCDC_REG2_DCDC_LOOPCTRL_HYST_SIGN_Msk = 0x2000
	// Bit DCDC_LOOPCTRL_HYST_SIGN.
	DCDC_REG2_DCDC_LOOPCTRL_HYST_SIGN = 0x2000
	// Position of DCDC_BATTMONITOR_EN_BATADJ field.
	DCDC_REG2_DCDC_BATTMONITOR_EN_BATADJ_Pos = 0xf
	// Bit mask of DCDC_BATTMONITOR_EN_BATADJ field.
	DCDC_REG2_DCDC_BATTMONITOR_EN_BATADJ_Msk = 0x8000
	// Bit DCDC_BATTMONITOR_EN_BATADJ.
	DCDC_REG2_DCDC_BATTMONITOR_EN_BATADJ = 0x8000
	// Position of DCDC_BATTMONITOR_BATT_VAL field.
	DCDC_REG2_DCDC_BATTMONITOR_BATT_VAL_Pos = 0x10
	// Bit mask of DCDC_BATTMONITOR_BATT_VAL field.
	DCDC_REG2_DCDC_BATTMONITOR_BATT_VAL_Msk = 0x3ff0000

	// REG3: DCDC REGISTER 3
	// Position of DCDC_VDD1P8CTRL_TRG field.
	DCDC_REG3_DCDC_VDD1P8CTRL_TRG_Pos = 0x0
	// Bit mask of DCDC_VDD1P8CTRL_TRG field.
	DCDC_REG3_DCDC_VDD1P8CTRL_TRG_Msk = 0x3f
	// 1.65 V
	DCDC_REG3_DCDC_VDD1P8CTRL_TRG_0 = 0x0
	// 1.8 V
	DCDC_REG3_DCDC_VDD1P8CTRL_TRG_110 = 0x6
	// 2.075 V
	DCDC_REG3_DCDC_VDD1P8CTRL_TRG_10001 = 0x11
	// 2.8 V
	DCDC_REG3_DCDC_VDD1P8CTRL_TRG_100000 = 0x20
	// 3.3 V
	DCDC_REG3_DCDC_VDD1P8CTRL_TRG_110100 = 0x34
	// 3.575 V
	DCDC_REG3_DCDC_VDD1P8CTRL_TRG_111111 = 0x3f
	// Position of DCDC_VDD1P5CTRL_TRG_BUCK field.
	DCDC_REG3_DCDC_VDD1P5CTRL_TRG_BUCK_Pos = 0x6
	// Bit mask of DCDC_VDD1P5CTRL_TRG_BUCK field.
	DCDC_REG3_DCDC_VDD1P5CTRL_TRG_BUCK_Msk = 0x7c0
	// 1.65 V
	DCDC_REG3_DCDC_VDD1P5CTRL_TRG_BUCK_1111 = 0xf
	// 1.5 V
	DCDC_REG3_DCDC_VDD1P5CTRL_TRG_BUCK_1001 = 0x9
	// 1.275 V
	DCDC_REG3_DCDC_VDD1P5CTRL_TRG_BUCK_0 = 0x0
	// Position of DCDC_VDD1P5CTRL_TRG_BOOST field.
	DCDC_REG3_DCDC_VDD1P5CTRL_TRG_BOOST_Pos = 0xb
	// Bit mask of DCDC_VDD1P5CTRL_TRG_BOOST field.
	DCDC_REG3_DCDC_VDD1P5CTRL_TRG_BOOST_Msk = 0xf800
	// 1.8 V
	DCDC_REG3_DCDC_VDD1P5CTRL_TRG_BOOST_10101 = 0x15
	// 1.65 V
	DCDC_REG3_DCDC_VDD1P5CTRL_TRG_BOOST_1111 = 0xf
	// 1.5 V
	DCDC_REG3_DCDC_VDD1P5CTRL_TRG_BOOST_1001 = 0x9
	// 1.275 V
	DCDC_REG3_DCDC_VDD1P5CTRL_TRG_BOOST_0 = 0x0
	// Position of DCDC_VDD1P5CTRL_ADJTN field.
	DCDC_REG3_DCDC_VDD1P5CTRL_ADJTN_Pos = 0x11
	// Bit mask of DCDC_VDD1P5CTRL_ADJTN field.
	DCDC_REG3_DCDC_VDD1P5CTRL_ADJTN_Msk = 0x1e0000
	// Position of DCDC_MINPWR_DC_HALFCLK_PULSED field.
	DCDC_REG3_DCDC_MINPWR_DC_HALFCLK_PULSED_Pos = 0x15
	// Bit mask of DCDC_MINPWR_DC_HALFCLK_PULSED field.
	DCDC_REG3_DCDC_MINPWR_DC_HALFCLK_PULSED_Msk = 0x200000
	// Bit DCDC_MINPWR_DC_HALFCLK_PULSED.
	DCDC_REG3_DCDC_MINPWR_DC_HALFCLK_PULSED = 0x200000
	// Position of DCDC_MINPWR_DOUBLE_FETS_PULSED field.
	DCDC_REG3_DCDC_MINPWR_DOUBLE_FETS_PULSED_Pos = 0x16
	// Bit mask of DCDC_MINPWR_DOUBLE_FETS_PULSED field.
	DCDC_REG3_DCDC_MINPWR_DOUBLE_FETS_PULSED_Msk = 0x400000
	// Bit DCDC_MINPWR_DOUBLE_FETS_PULSED.
	DCDC_REG3_DCDC_MINPWR_DOUBLE_FETS_PULSED = 0x400000
	// Position of DCDC_MINPWR_HALF_FETS_PULSED field.
	DCDC_REG3_DCDC_MINPWR_HALF_FETS_PULSED_Pos = 0x17
	// Bit mask of DCDC_MINPWR_HALF_FETS_PULSED field.
	DCDC_REG3_DCDC_MINPWR_HALF_FETS_PULSED_Msk = 0x800000
	// Bit DCDC_MINPWR_HALF_FETS_PULSED.
	DCDC_REG3_DCDC_MINPWR_HALF_FETS_PULSED = 0x800000
	// Position of DCDC_MINPWR_DC_HALFCLK field.
	DCDC_REG3_DCDC_MINPWR_DC_HALFCLK_Pos = 0x18
	// Bit mask of DCDC_MINPWR_DC_HALFCLK field.
	DCDC_REG3_DCDC_MINPWR_DC_HALFCLK_Msk = 0x1000000
	// Bit DCDC_MINPWR_DC_HALFCLK.
	DCDC_REG3_DCDC_MINPWR_DC_HALFCLK = 0x1000000
	// Position of DCDC_MINPWR_DOUBLE_FETS field.
	DCDC_REG3_DCDC_MINPWR_DOUBLE_FETS_Pos = 0x19
	// Bit mask of DCDC_MINPWR_DOUBLE_FETS field.
	DCDC_REG3_DCDC_MINPWR_DOUBLE_FETS_Msk = 0x2000000
	// Bit DCDC_MINPWR_DOUBLE_FETS.
	DCDC_REG3_DCDC_MINPWR_DOUBLE_FETS = 0x2000000
	// Position of DCDC_MINPWR_HALF_FETS field.
	DCDC_REG3_DCDC_MINPWR_HALF_FETS_Pos = 0x1a
	// Bit mask of DCDC_MINPWR_HALF_FETS field.
	DCDC_REG3_DCDC_MINPWR_HALF_FETS_Msk = 0x4000000
	// Bit DCDC_MINPWR_HALF_FETS.
	DCDC_REG3_DCDC_MINPWR_HALF_FETS = 0x4000000
	// Position of DCDC_VDD1P5CTRL_DISABLE_STEP field.
	DCDC_REG3_DCDC_VDD1P5CTRL_DISABLE_STEP_Pos = 0x1d
	// Bit mask of DCDC_VDD1P5CTRL_DISABLE_STEP field.
	DCDC_REG3_DCDC_VDD1P5CTRL_DISABLE_STEP_Msk = 0x20000000
	// Bit DCDC_VDD1P5CTRL_DISABLE_STEP.
	DCDC_REG3_DCDC_VDD1P5CTRL_DISABLE_STEP = 0x20000000
	// Position of DCDC_VDD1P8CTRL_DISABLE_STEP field.
	DCDC_REG3_DCDC_VDD1P8CTRL_DISABLE_STEP_Pos = 0x1e
	// Bit mask of DCDC_VDD1P8CTRL_DISABLE_STEP field.
	DCDC_REG3_DCDC_VDD1P8CTRL_DISABLE_STEP_Msk = 0x40000000
	// Bit DCDC_VDD1P8CTRL_DISABLE_STEP.
	DCDC_REG3_DCDC_VDD1P8CTRL_DISABLE_STEP = 0x40000000

	// REG4: DCDC REGISTER 4
	// Position of DCDC_SW_SHUTDOWN field.
	DCDC_REG4_DCDC_SW_SHUTDOWN_Pos = 0x0
	// Bit mask of DCDC_SW_SHUTDOWN field.
	DCDC_REG4_DCDC_SW_SHUTDOWN_Msk = 0x1
	// Bit DCDC_SW_SHUTDOWN.
	DCDC_REG4_DCDC_SW_SHUTDOWN = 0x1
	// Position of UNLOCK field.
	DCDC_REG4_UNLOCK_Pos = 0x10
	// Bit mask of UNLOCK field.
	DCDC_REG4_UNLOCK_Msk = 0xffff0000

	// REG6: DCDC REGISTER 6
	// Position of PSWITCH_INT_RISE_EN field.
	DCDC_REG6_PSWITCH_INT_RISE_EN_Pos = 0x0
	// Bit mask of PSWITCH_INT_RISE_EN field.
	DCDC_REG6_PSWITCH_INT_RISE_EN_Msk = 0x1
	// Bit PSWITCH_INT_RISE_EN.
	DCDC_REG6_PSWITCH_INT_RISE_EN = 0x1
	// Position of PSWITCH_INT_FALL_EN field.
	DCDC_REG6_PSWITCH_INT_FALL_EN_Pos = 0x1
	// Bit mask of PSWITCH_INT_FALL_EN field.
	DCDC_REG6_PSWITCH_INT_FALL_EN_Msk = 0x2
	// Bit PSWITCH_INT_FALL_EN.
	DCDC_REG6_PSWITCH_INT_FALL_EN = 0x2
	// Position of PSWITCH_INT_CLEAR field.
	DCDC_REG6_PSWITCH_INT_CLEAR_Pos = 0x2
	// Bit mask of PSWITCH_INT_CLEAR field.
	DCDC_REG6_PSWITCH_INT_CLEAR_Msk = 0x4
	// Bit PSWITCH_INT_CLEAR.
	DCDC_REG6_PSWITCH_INT_CLEAR = 0x4
	// Position of PSWITCH_INT_MUTE field.
	DCDC_REG6_PSWITCH_INT_MUTE_Pos = 0x3
	// Bit mask of PSWITCH_INT_MUTE field.
	DCDC_REG6_PSWITCH_INT_MUTE_Msk = 0x8
	// Bit PSWITCH_INT_MUTE.
	DCDC_REG6_PSWITCH_INT_MUTE = 0x8
	// Position of PSWITCH_INT_STS field.
	DCDC_REG6_PSWITCH_INT_STS_Pos = 0x1f
	// Bit mask of PSWITCH_INT_STS field.
	DCDC_REG6_PSWITCH_INT_STS_Msk = 0x80000000
	// Bit PSWITCH_INT_STS.
	DCDC_REG6_PSWITCH_INT_STS = 0x80000000

	// REG7: DCDC REGISTER 7
	// Position of INTEGRATOR_VALUE field.
	DCDC_REG7_INTEGRATOR_VALUE_Pos = 0x0
	// Bit mask of INTEGRATOR_VALUE field.
	DCDC_REG7_INTEGRATOR_VALUE_Msk = 0x7ffff
	// Position of INTEGRATOR_VALUE_SEL field.
	DCDC_REG7_INTEGRATOR_VALUE_SEL_Pos = 0x13
	// Bit mask of INTEGRATOR_VALUE_SEL field.
	DCDC_REG7_INTEGRATOR_VALUE_SEL_Msk = 0x80000
	// Bit INTEGRATOR_VALUE_SEL.
	DCDC_REG7_INTEGRATOR_VALUE_SEL = 0x80000
	// Position of PULSE_RUN_SPEEDUP field.
	DCDC_REG7_PULSE_RUN_SPEEDUP_Pos = 0x14
	// Bit mask of PULSE_RUN_SPEEDUP field.
	DCDC_REG7_PULSE_RUN_SPEEDUP_Msk = 0x100000
	// Bit PULSE_RUN_SPEEDUP.
	DCDC_REG7_PULSE_RUN_SPEEDUP = 0x100000
)

// Bitfields for BTLE_RF: BLE_RF
const (
	// BLE_PART_ID: BLUETOOTH LOW ENERGY PART ID
	// Position of BLE_PART_ID field.
	BTLE_RF_BLE_PART_ID_BLE_PART_ID_Pos = 0x0
	// Bit mask of BLE_PART_ID field.
	BTLE_RF_BLE_PART_ID_BLE_PART_ID_Msk = 0xffff
	// Pre-production
	BTLE_RF_BLE_PART_ID_BLE_PART_ID_0 = 0x0
	// Pre-production
	BTLE_RF_BLE_PART_ID_BLE_PART_ID_1 = 0x1
	// KW40Z
	BTLE_RF_BLE_PART_ID_BLE_PART_ID_2 = 0x2
	// KW41Z
	BTLE_RF_BLE_PART_ID_BLE_PART_ID_3 = 0x3

	// DSM_STATUS: BLE DSM STATUS
	// Position of ORF_SYSCLK_REQ field.
	BTLE_RF_DSM_STATUS_ORF_SYSCLK_REQ_Pos = 0x0
	// Bit mask of ORF_SYSCLK_REQ field.
	BTLE_RF_DSM_STATUS_ORF_SYSCLK_REQ_Msk = 0x1
	// Bit ORF_SYSCLK_REQ.
	BTLE_RF_DSM_STATUS_ORF_SYSCLK_REQ = 0x1
	// Position of RIF_LL_ACTIVE field.
	BTLE_RF_DSM_STATUS_RIF_LL_ACTIVE_Pos = 0x1
	// Bit mask of RIF_LL_ACTIVE field.
	BTLE_RF_DSM_STATUS_RIF_LL_ACTIVE_Msk = 0x2
	// Bit RIF_LL_ACTIVE.
	BTLE_RF_DSM_STATUS_RIF_LL_ACTIVE = 0x2
	// Position of XCVR_BUSY field.
	BTLE_RF_DSM_STATUS_XCVR_BUSY_Pos = 0x2
	// Bit mask of XCVR_BUSY field.
	BTLE_RF_DSM_STATUS_XCVR_BUSY_Msk = 0x4
	// Bit XCVR_BUSY.
	BTLE_RF_DSM_STATUS_XCVR_BUSY = 0x4
	// RF Channel in available (TSM is idle)
	BTLE_RF_DSM_STATUS_XCVR_BUSY_0 = 0x0
	// RF Channel in use (TSM is busy)
	BTLE_RF_DSM_STATUS_XCVR_BUSY_1 = 0x1

	// MISC_CTRL: BLUETOOTH LOW ENERGY MISCELLANEOUS CONTROL
	// Position of TSM_INTR_EN field.
	BTLE_RF_MISC_CTRL_TSM_INTR_EN_Pos = 0x1
	// Bit mask of TSM_INTR_EN field.
	BTLE_RF_MISC_CTRL_TSM_INTR_EN_Msk = 0x2
	// Bit TSM_INTR_EN.
	BTLE_RF_MISC_CTRL_TSM_INTR_EN = 0x2
	// a TSM Interrupt during a BLE TX or RX sequence will not set bit [8] of BLE EVENT_STATUS
	BTLE_RF_MISC_CTRL_TSM_INTR_EN_0 = 0x0
	// a TSM Interrupt during a BLE TX or RX sequence will set bit [8] of BLE EVENT_STATUS
	BTLE_RF_MISC_CTRL_TSM_INTR_EN_1 = 0x1
)

// Bitfields for XCVR_RX_DIG: XCVR_RX_DIG
const (
	// RX_DIG_CTRL: RX Digital Control
	// Position of RX_ADC_NEGEDGE field.
	XCVR_RX_DIG_RX_DIG_CTRL_RX_ADC_NEGEDGE_Pos = 0x0
	// Bit mask of RX_ADC_NEGEDGE field.
	XCVR_RX_DIG_RX_DIG_CTRL_RX_ADC_NEGEDGE_Msk = 0x1
	// Bit RX_ADC_NEGEDGE.
	XCVR_RX_DIG_RX_DIG_CTRL_RX_ADC_NEGEDGE = 0x1
	// Register ADC data on positive edge of clock
	XCVR_RX_DIG_RX_DIG_CTRL_RX_ADC_NEGEDGE_0 = 0x0
	// Register ADC data on negative edge of clock
	XCVR_RX_DIG_RX_DIG_CTRL_RX_ADC_NEGEDGE_1 = 0x1
	// Position of RX_CH_FILT_BYPASS field.
	XCVR_RX_DIG_RX_DIG_CTRL_RX_CH_FILT_BYPASS_Pos = 0x1
	// Bit mask of RX_CH_FILT_BYPASS field.
	XCVR_RX_DIG_RX_DIG_CTRL_RX_CH_FILT_BYPASS_Msk = 0x2
	// Bit RX_CH_FILT_BYPASS.
	XCVR_RX_DIG_RX_DIG_CTRL_RX_CH_FILT_BYPASS = 0x2
	// Channel filter is enabled.
	XCVR_RX_DIG_RX_DIG_CTRL_RX_CH_FILT_BYPASS_0 = 0x0
	// Disable and bypass channel filter.
	XCVR_RX_DIG_RX_DIG_CTRL_RX_CH_FILT_BYPASS_1 = 0x1
	// Position of RX_ADC_RAW_EN field.
	XCVR_RX_DIG_RX_DIG_CTRL_RX_ADC_RAW_EN_Pos = 0x2
	// Bit mask of RX_ADC_RAW_EN field.
	XCVR_RX_DIG_RX_DIG_CTRL_RX_ADC_RAW_EN_Msk = 0x4
	// Bit RX_ADC_RAW_EN.
	XCVR_RX_DIG_RX_DIG_CTRL_RX_ADC_RAW_EN = 0x4
	// Normal operation.
	XCVR_RX_DIG_RX_DIG_CTRL_RX_ADC_RAW_EN_0 = 0x0
	// The decimation filter's 12bit output consists of ADC samples in the 8 LSBs. This is for test purposes only to observe ADC output via XCVR DMA or DTEST.
	XCVR_RX_DIG_RX_DIG_CTRL_RX_ADC_RAW_EN_1 = 0x1
	// Position of RX_ADC_POL field.
	XCVR_RX_DIG_RX_DIG_CTRL_RX_ADC_POL_Pos = 0x3
	// Bit mask of RX_ADC_POL field.
	XCVR_RX_DIG_RX_DIG_CTRL_RX_ADC_POL_Msk = 0x8
	// Bit RX_ADC_POL.
	XCVR_RX_DIG_RX_DIG_CTRL_RX_ADC_POL = 0x8
	// ADC output of 1'b0 maps to -1, 1'b1 maps to +1 (default)
	XCVR_RX_DIG_RX_DIG_CTRL_RX_ADC_POL_0 = 0x0
	// ADC output of 1'b0 maps to +1, 1'b1 maps to -1
	XCVR_RX_DIG_RX_DIG_CTRL_RX_ADC_POL_1 = 0x1
	// Position of RX_DEC_FILT_OSR field.
	XCVR_RX_DIG_RX_DIG_CTRL_RX_DEC_FILT_OSR_Pos = 0x4
	// Bit mask of RX_DEC_FILT_OSR field.
	XCVR_RX_DIG_RX_DIG_CTRL_RX_DEC_FILT_OSR_Msk = 0x70
	// OSR 4
	XCVR_RX_DIG_RX_DIG_CTRL_RX_DEC_FILT_OSR_0 = 0x0
	// OSR 8
	XCVR_RX_DIG_RX_DIG_CTRL_RX_DEC_FILT_OSR_1 = 0x1
	// OSR 16
	XCVR_RX_DIG_RX_DIG_CTRL_RX_DEC_FILT_OSR_2 = 0x2
	// OSR 32
	XCVR_RX_DIG_RX_DIG_CTRL_RX_DEC_FILT_OSR_4 = 0x4
	// OSR 6
	XCVR_RX_DIG_RX_DIG_CTRL_RX_DEC_FILT_OSR_3 = 0x3
	// OSR 12
	XCVR_RX_DIG_RX_DIG_CTRL_RX_DEC_FILT_OSR_5 = 0x5
	// OSR 24
	XCVR_RX_DIG_RX_DIG_CTRL_RX_DEC_FILT_OSR_6 = 0x6
	// Position of RX_FSK_ZB_SEL field.
	XCVR_RX_DIG_RX_DIG_CTRL_RX_FSK_ZB_SEL_Pos = 0x8
	// Bit mask of RX_FSK_ZB_SEL field.
	XCVR_RX_DIG_RX_DIG_CTRL_RX_FSK_ZB_SEL_Msk = 0x100
	// Bit RX_FSK_ZB_SEL.
	XCVR_RX_DIG_RX_DIG_CTRL_RX_FSK_ZB_SEL = 0x100
	// FSK demodulator.
	XCVR_RX_DIG_RX_DIG_CTRL_RX_FSK_ZB_SEL_0 = 0x0
	// 802.15.4 demodulator.
	XCVR_RX_DIG_RX_DIG_CTRL_RX_FSK_ZB_SEL_1 = 0x1
	// Position of RX_NORM_EN field.
	XCVR_RX_DIG_RX_DIG_CTRL_RX_NORM_EN_Pos = 0x9
	// Bit mask of RX_NORM_EN field.
	XCVR_RX_DIG_RX_DIG_CTRL_RX_NORM_EN_Msk = 0x200
	// Bit RX_NORM_EN.
	XCVR_RX_DIG_RX_DIG_CTRL_RX_NORM_EN = 0x200
	// Normalizer is disabled.
	XCVR_RX_DIG_RX_DIG_CTRL_RX_NORM_EN_0 = 0x0
	// Normalizer is enabled.
	XCVR_RX_DIG_RX_DIG_CTRL_RX_NORM_EN_1 = 0x1
	// Position of RX_RSSI_EN field.
	XCVR_RX_DIG_RX_DIG_CTRL_RX_RSSI_EN_Pos = 0xa
	// Bit mask of RX_RSSI_EN field.
	XCVR_RX_DIG_RX_DIG_CTRL_RX_RSSI_EN_Msk = 0x400
	// Bit RX_RSSI_EN.
	XCVR_RX_DIG_RX_DIG_CTRL_RX_RSSI_EN = 0x400
	// RSSI measurement is disabled.
	XCVR_RX_DIG_RX_DIG_CTRL_RX_RSSI_EN_0 = 0x0
	// RSSI measurement is enabled.
	XCVR_RX_DIG_RX_DIG_CTRL_RX_RSSI_EN_1 = 0x1
	// Position of RX_AGC_EN field.
	XCVR_RX_DIG_RX_DIG_CTRL_RX_AGC_EN_Pos = 0xb
	// Bit mask of RX_AGC_EN field.
	XCVR_RX_DIG_RX_DIG_CTRL_RX_AGC_EN_Msk = 0x800
	// Bit RX_AGC_EN.
	XCVR_RX_DIG_RX_DIG_CTRL_RX_AGC_EN = 0x800
	// AGC is disabled.
	XCVR_RX_DIG_RX_DIG_CTRL_RX_AGC_EN_0 = 0x0
	// AGC is enabled.
	XCVR_RX_DIG_RX_DIG_CTRL_RX_AGC_EN_1 = 0x1
	// Position of RX_DCOC_EN field.
	XCVR_RX_DIG_RX_DIG_CTRL_RX_DCOC_EN_Pos = 0xc
	// Bit mask of RX_DCOC_EN field.
	XCVR_RX_DIG_RX_DIG_CTRL_RX_DCOC_EN_Msk = 0x1000
	// Bit RX_DCOC_EN.
	XCVR_RX_DIG_RX_DIG_CTRL_RX_DCOC_EN = 0x1000
	// DCOC is disabled.
	XCVR_RX_DIG_RX_DIG_CTRL_RX_DCOC_EN_0 = 0x0
	// DCOC is enabled.
	XCVR_RX_DIG_RX_DIG_CTRL_RX_DCOC_EN_1 = 0x1
	// Position of RX_DCOC_CAL_EN field.
	XCVR_RX_DIG_RX_DIG_CTRL_RX_DCOC_CAL_EN_Pos = 0xd
	// Bit mask of RX_DCOC_CAL_EN field.
	XCVR_RX_DIG_RX_DIG_CTRL_RX_DCOC_CAL_EN_Msk = 0x2000
	// Bit RX_DCOC_CAL_EN.
	XCVR_RX_DIG_RX_DIG_CTRL_RX_DCOC_CAL_EN = 0x2000
	// DCOC calibration is disabled.
	XCVR_RX_DIG_RX_DIG_CTRL_RX_DCOC_CAL_EN_0 = 0x0
	// DCOC calibration is enabled.
	XCVR_RX_DIG_RX_DIG_CTRL_RX_DCOC_CAL_EN_1 = 0x1
	// Position of RX_IQ_SWAP field.
	XCVR_RX_DIG_RX_DIG_CTRL_RX_IQ_SWAP_Pos = 0xe
	// Bit mask of RX_IQ_SWAP field.
	XCVR_RX_DIG_RX_DIG_CTRL_RX_IQ_SWAP_Msk = 0x4000
	// Bit RX_IQ_SWAP.
	XCVR_RX_DIG_RX_DIG_CTRL_RX_IQ_SWAP = 0x4000
	// IQ swap is disabled.
	XCVR_RX_DIG_RX_DIG_CTRL_RX_IQ_SWAP_0 = 0x0
	// IQ swap is enabled.
	XCVR_RX_DIG_RX_DIG_CTRL_RX_IQ_SWAP_1 = 0x1
	// Position of RX_DC_RESID_EN field.
	XCVR_RX_DIG_RX_DIG_CTRL_RX_DC_RESID_EN_Pos = 0xf
	// Bit mask of RX_DC_RESID_EN field.
	XCVR_RX_DIG_RX_DIG_CTRL_RX_DC_RESID_EN_Msk = 0x8000
	// Bit RX_DC_RESID_EN.
	XCVR_RX_DIG_RX_DIG_CTRL_RX_DC_RESID_EN = 0x8000
	// DC Residual block is disabled.
	XCVR_RX_DIG_RX_DIG_CTRL_RX_DC_RESID_EN_0 = 0x0
	// DC Residual block is enabled.
	XCVR_RX_DIG_RX_DIG_CTRL_RX_DC_RESID_EN_1 = 0x1
	// Position of RX_SRC_EN field.
	XCVR_RX_DIG_RX_DIG_CTRL_RX_SRC_EN_Pos = 0x10
	// Bit mask of RX_SRC_EN field.
	XCVR_RX_DIG_RX_DIG_CTRL_RX_SRC_EN_Msk = 0x10000
	// Bit RX_SRC_EN.
	XCVR_RX_DIG_RX_DIG_CTRL_RX_SRC_EN = 0x10000
	// SRC is disabled.
	XCVR_RX_DIG_RX_DIG_CTRL_RX_SRC_EN_0 = 0x0
	// SRC is enabled.
	XCVR_RX_DIG_RX_DIG_CTRL_RX_SRC_EN_1 = 0x1
	// Position of RX_SRC_RATE field.
	XCVR_RX_DIG_RX_DIG_CTRL_RX_SRC_RATE_Pos = 0x11
	// Bit mask of RX_SRC_RATE field.
	XCVR_RX_DIG_RX_DIG_CTRL_RX_SRC_RATE_Msk = 0x20000
	// Bit RX_SRC_RATE.
	XCVR_RX_DIG_RX_DIG_CTRL_RX_SRC_RATE = 0x20000
	// SRC is configured for a First Order Hold rate of 8/13.
	XCVR_RX_DIG_RX_DIG_CTRL_RX_SRC_RATE_0 = 0x0
	// SRC is configured for a Zero Order Hold rate of 12/13.
	XCVR_RX_DIG_RX_DIG_CTRL_RX_SRC_RATE_1 = 0x1
	// Position of RX_DMA_DTEST_EN field.
	XCVR_RX_DIG_RX_DIG_CTRL_RX_DMA_DTEST_EN_Pos = 0x12
	// Bit mask of RX_DMA_DTEST_EN field.
	XCVR_RX_DIG_RX_DIG_CTRL_RX_DMA_DTEST_EN_Msk = 0x40000
	// Bit RX_DMA_DTEST_EN.
	XCVR_RX_DIG_RX_DIG_CTRL_RX_DMA_DTEST_EN = 0x40000
	// Position of RX_DEC_FILT_GAIN field.
	XCVR_RX_DIG_RX_DIG_CTRL_RX_DEC_FILT_GAIN_Pos = 0x14
	// Bit mask of RX_DEC_FILT_GAIN field.
	XCVR_RX_DIG_RX_DIG_CTRL_RX_DEC_FILT_GAIN_Msk = 0x1f00000
	// Position of RX_DEC_FILT_HZD_CORR_DIS field.
	XCVR_RX_DIG_RX_DIG_CTRL_RX_DEC_FILT_HZD_CORR_DIS_Pos = 0x19
	// Bit mask of RX_DEC_FILT_HZD_CORR_DIS field.
	XCVR_RX_DIG_RX_DIG_CTRL_RX_DEC_FILT_HZD_CORR_DIS_Msk = 0x2000000
	// Bit RX_DEC_FILT_HZD_CORR_DIS.
	XCVR_RX_DIG_RX_DIG_CTRL_RX_DEC_FILT_HZD_CORR_DIS = 0x2000000
	// Position of RX_DEC_FILT_HAZARD field.
	XCVR_RX_DIG_RX_DIG_CTRL_RX_DEC_FILT_HAZARD_Pos = 0x1c
	// Bit mask of RX_DEC_FILT_HAZARD field.
	XCVR_RX_DIG_RX_DIG_CTRL_RX_DEC_FILT_HAZARD_Msk = 0x10000000
	// Bit RX_DEC_FILT_HAZARD.
	XCVR_RX_DIG_RX_DIG_CTRL_RX_DEC_FILT_HAZARD = 0x10000000
	// A hazard condition has not been detected
	XCVR_RX_DIG_RX_DIG_CTRL_RX_DEC_FILT_HAZARD_0 = 0x0
	// A hazard condition has been detected
	XCVR_RX_DIG_RX_DIG_CTRL_RX_DEC_FILT_HAZARD_1 = 0x1
	// Position of RX_RSSI_FILT_HAZARD field.
	XCVR_RX_DIG_RX_DIG_CTRL_RX_RSSI_FILT_HAZARD_Pos = 0x1d
	// Bit mask of RX_RSSI_FILT_HAZARD field.
	XCVR_RX_DIG_RX_DIG_CTRL_RX_RSSI_FILT_HAZARD_Msk = 0x20000000
	// Bit RX_RSSI_FILT_HAZARD.
	XCVR_RX_DIG_RX_DIG_CTRL_RX_RSSI_FILT_HAZARD = 0x20000000
	// A hazard condition has not been detected
	XCVR_RX_DIG_RX_DIG_CTRL_RX_RSSI_FILT_HAZARD_0 = 0x0
	// A hazard condition has been detected
	XCVR_RX_DIG_RX_DIG_CTRL_RX_RSSI_FILT_HAZARD_1 = 0x1
	// Position of RX_DEC_FILT_SAT_I field.
	XCVR_RX_DIG_RX_DIG_CTRL_RX_DEC_FILT_SAT_I_Pos = 0x1e
	// Bit mask of RX_DEC_FILT_SAT_I field.
	XCVR_RX_DIG_RX_DIG_CTRL_RX_DEC_FILT_SAT_I_Msk = 0x40000000
	// Bit RX_DEC_FILT_SAT_I.
	XCVR_RX_DIG_RX_DIG_CTRL_RX_DEC_FILT_SAT_I = 0x40000000
	// A saturation condition has not occurred.
	XCVR_RX_DIG_RX_DIG_CTRL_RX_DEC_FILT_SAT_I_0 = 0x0
	// A saturation condition has occurred.
	XCVR_RX_DIG_RX_DIG_CTRL_RX_DEC_FILT_SAT_I_1 = 0x1
	// Position of RX_DEC_FILT_SAT_Q field.
	XCVR_RX_DIG_RX_DIG_CTRL_RX_DEC_FILT_SAT_Q_Pos = 0x1f
	// Bit mask of RX_DEC_FILT_SAT_Q field.
	XCVR_RX_DIG_RX_DIG_CTRL_RX_DEC_FILT_SAT_Q_Msk = 0x80000000
	// Bit RX_DEC_FILT_SAT_Q.
	XCVR_RX_DIG_RX_DIG_CTRL_RX_DEC_FILT_SAT_Q = 0x80000000
	// A saturation condition has not occurred.
	XCVR_RX_DIG_RX_DIG_CTRL_RX_DEC_FILT_SAT_Q_0 = 0x0
	// A saturation condition has occurred.
	XCVR_RX_DIG_RX_DIG_CTRL_RX_DEC_FILT_SAT_Q_1 = 0x1

	// AGC_CTRL_0: AGC Control 0
	// Position of SLOW_AGC_EN field.
	XCVR_RX_DIG_AGC_CTRL_0_SLOW_AGC_EN_Pos = 0x0
	// Bit mask of SLOW_AGC_EN field.
	XCVR_RX_DIG_AGC_CTRL_0_SLOW_AGC_EN_Msk = 0x1
	// Bit SLOW_AGC_EN.
	XCVR_RX_DIG_AGC_CTRL_0_SLOW_AGC_EN = 0x1
	// Position of SLOW_AGC_SRC field.
	XCVR_RX_DIG_AGC_CTRL_0_SLOW_AGC_SRC_Pos = 0x1
	// Bit mask of SLOW_AGC_SRC field.
	XCVR_RX_DIG_AGC_CTRL_0_SLOW_AGC_SRC_Msk = 0x6
	// Access Address match (for active protocol)
	XCVR_RX_DIG_AGC_CTRL_0_SLOW_AGC_SRC_0 = 0x0
	// Preamble Detect (for active protocol)
	XCVR_RX_DIG_AGC_CTRL_0_SLOW_AGC_SRC_1 = 0x1
	// Fast AGC expire timer
	XCVR_RX_DIG_AGC_CTRL_0_SLOW_AGC_SRC_2 = 0x2
	// Position of AGC_FREEZE_EN field.
	XCVR_RX_DIG_AGC_CTRL_0_AGC_FREEZE_EN_Pos = 0x3
	// Bit mask of AGC_FREEZE_EN field.
	XCVR_RX_DIG_AGC_CTRL_0_AGC_FREEZE_EN_Msk = 0x8
	// Bit AGC_FREEZE_EN.
	XCVR_RX_DIG_AGC_CTRL_0_AGC_FREEZE_EN = 0x8
	// Position of AGC_FREEZE_PRE_OR_AA field.
	XCVR_RX_DIG_AGC_CTRL_0_AGC_FREEZE_PRE_OR_AA_Pos = 0x4
	// Bit mask of AGC_FREEZE_PRE_OR_AA field.
	XCVR_RX_DIG_AGC_CTRL_0_AGC_FREEZE_PRE_OR_AA_Msk = 0x10
	// Bit AGC_FREEZE_PRE_OR_AA.
	XCVR_RX_DIG_AGC_CTRL_0_AGC_FREEZE_PRE_OR_AA = 0x10
	// Access Address match (for active protocol)
	XCVR_RX_DIG_AGC_CTRL_0_AGC_FREEZE_PRE_OR_AA_0 = 0x0
	// Preamble Detect (for active protocol)
	XCVR_RX_DIG_AGC_CTRL_0_AGC_FREEZE_PRE_OR_AA_1 = 0x1
	// Position of AGC_UP_EN field.
	XCVR_RX_DIG_AGC_CTRL_0_AGC_UP_EN_Pos = 0x6
	// Bit mask of AGC_UP_EN field.
	XCVR_RX_DIG_AGC_CTRL_0_AGC_UP_EN_Msk = 0x40
	// Bit AGC_UP_EN.
	XCVR_RX_DIG_AGC_CTRL_0_AGC_UP_EN = 0x40
	// Position of AGC_UP_SRC field.
	XCVR_RX_DIG_AGC_CTRL_0_AGC_UP_SRC_Pos = 0x7
	// Bit mask of AGC_UP_SRC field.
	XCVR_RX_DIG_AGC_CTRL_0_AGC_UP_SRC_Msk = 0x80
	// Bit AGC_UP_SRC.
	XCVR_RX_DIG_AGC_CTRL_0_AGC_UP_SRC = 0x80
	// PDET LO
	XCVR_RX_DIG_AGC_CTRL_0_AGC_UP_SRC_0 = 0x0
	// RSSI
	XCVR_RX_DIG_AGC_CTRL_0_AGC_UP_SRC_1 = 0x1
	// Position of AGC_DOWN_BBA_STEP_SZ field.
	XCVR_RX_DIG_AGC_CTRL_0_AGC_DOWN_BBA_STEP_SZ_Pos = 0x8
	// Bit mask of AGC_DOWN_BBA_STEP_SZ field.
	XCVR_RX_DIG_AGC_CTRL_0_AGC_DOWN_BBA_STEP_SZ_Msk = 0xf00
	// Position of AGC_DOWN_LNA_STEP_SZ field.
	XCVR_RX_DIG_AGC_CTRL_0_AGC_DOWN_LNA_STEP_SZ_Pos = 0xc
	// Bit mask of AGC_DOWN_LNA_STEP_SZ field.
	XCVR_RX_DIG_AGC_CTRL_0_AGC_DOWN_LNA_STEP_SZ_Msk = 0xf000
	// Position of AGC_UP_RSSI_THRESH field.
	XCVR_RX_DIG_AGC_CTRL_0_AGC_UP_RSSI_THRESH_Pos = 0x10
	// Bit mask of AGC_UP_RSSI_THRESH field.
	XCVR_RX_DIG_AGC_CTRL_0_AGC_UP_RSSI_THRESH_Msk = 0xff0000
	// Position of AGC_DOWN_RSSI_THRESH field.
	XCVR_RX_DIG_AGC_CTRL_0_AGC_DOWN_RSSI_THRESH_Pos = 0x18
	// Bit mask of AGC_DOWN_RSSI_THRESH field.
	XCVR_RX_DIG_AGC_CTRL_0_AGC_DOWN_RSSI_THRESH_Msk = 0xff000000

	// AGC_CTRL_1: AGC Control 1
	// Position of BBA_ALT_CODE field.
	XCVR_RX_DIG_AGC_CTRL_1_BBA_ALT_CODE_Pos = 0x0
	// Bit mask of BBA_ALT_CODE field.
	XCVR_RX_DIG_AGC_CTRL_1_BBA_ALT_CODE_Msk = 0xf
	// Position of LNA_ALT_CODE field.
	XCVR_RX_DIG_AGC_CTRL_1_LNA_ALT_CODE_Pos = 0x4
	// Bit mask of LNA_ALT_CODE field.
	XCVR_RX_DIG_AGC_CTRL_1_LNA_ALT_CODE_Msk = 0xff0
	// Position of LNA_USER_GAIN field.
	XCVR_RX_DIG_AGC_CTRL_1_LNA_USER_GAIN_Pos = 0xc
	// Bit mask of LNA_USER_GAIN field.
	XCVR_RX_DIG_AGC_CTRL_1_LNA_USER_GAIN_Msk = 0xf000
	// Position of BBA_USER_GAIN field.
	XCVR_RX_DIG_AGC_CTRL_1_BBA_USER_GAIN_Pos = 0x10
	// Bit mask of BBA_USER_GAIN field.
	XCVR_RX_DIG_AGC_CTRL_1_BBA_USER_GAIN_Msk = 0xf0000
	// Position of USER_LNA_GAIN_EN field.
	XCVR_RX_DIG_AGC_CTRL_1_USER_LNA_GAIN_EN_Pos = 0x14
	// Bit mask of USER_LNA_GAIN_EN field.
	XCVR_RX_DIG_AGC_CTRL_1_USER_LNA_GAIN_EN_Msk = 0x100000
	// Bit USER_LNA_GAIN_EN.
	XCVR_RX_DIG_AGC_CTRL_1_USER_LNA_GAIN_EN = 0x100000
	// Position of USER_BBA_GAIN_EN field.
	XCVR_RX_DIG_AGC_CTRL_1_USER_BBA_GAIN_EN_Pos = 0x15
	// Bit mask of USER_BBA_GAIN_EN field.
	XCVR_RX_DIG_AGC_CTRL_1_USER_BBA_GAIN_EN_Msk = 0x200000
	// Bit USER_BBA_GAIN_EN.
	XCVR_RX_DIG_AGC_CTRL_1_USER_BBA_GAIN_EN = 0x200000
	// Position of PRESLOW_EN field.
	XCVR_RX_DIG_AGC_CTRL_1_PRESLOW_EN_Pos = 0x16
	// Bit mask of PRESLOW_EN field.
	XCVR_RX_DIG_AGC_CTRL_1_PRESLOW_EN_Msk = 0x400000
	// Bit PRESLOW_EN.
	XCVR_RX_DIG_AGC_CTRL_1_PRESLOW_EN = 0x400000
	// Pre-slow is disabled.
	XCVR_RX_DIG_AGC_CTRL_1_PRESLOW_EN_0 = 0x0
	// Pre-slow is enabled.
	XCVR_RX_DIG_AGC_CTRL_1_PRESLOW_EN_1 = 0x1
	// Position of LNA_GAIN_SETTLE_TIME field.
	XCVR_RX_DIG_AGC_CTRL_1_LNA_GAIN_SETTLE_TIME_Pos = 0x18
	// Bit mask of LNA_GAIN_SETTLE_TIME field.
	XCVR_RX_DIG_AGC_CTRL_1_LNA_GAIN_SETTLE_TIME_Msk = 0xff000000

	// AGC_CTRL_2: AGC Control 2
	// Position of BBA_PDET_RST field.
	XCVR_RX_DIG_AGC_CTRL_2_BBA_PDET_RST_Pos = 0x0
	// Bit mask of BBA_PDET_RST field.
	XCVR_RX_DIG_AGC_CTRL_2_BBA_PDET_RST_Msk = 0x1
	// Bit BBA_PDET_RST.
	XCVR_RX_DIG_AGC_CTRL_2_BBA_PDET_RST = 0x1
	// Position of TZA_PDET_RST field.
	XCVR_RX_DIG_AGC_CTRL_2_TZA_PDET_RST_Pos = 0x1
	// Bit mask of TZA_PDET_RST field.
	XCVR_RX_DIG_AGC_CTRL_2_TZA_PDET_RST_Msk = 0x2
	// Bit TZA_PDET_RST.
	XCVR_RX_DIG_AGC_CTRL_2_TZA_PDET_RST = 0x2
	// Position of MAN_PDET_RST field.
	XCVR_RX_DIG_AGC_CTRL_2_MAN_PDET_RST_Pos = 0x2
	// Bit mask of MAN_PDET_RST field.
	XCVR_RX_DIG_AGC_CTRL_2_MAN_PDET_RST_Msk = 0x4
	// Bit MAN_PDET_RST.
	XCVR_RX_DIG_AGC_CTRL_2_MAN_PDET_RST = 0x4
	// The peak detector reset signals are controlled automatically by the AGC.
	XCVR_RX_DIG_AGC_CTRL_2_MAN_PDET_RST_0 = 0x0
	// The BBA_PDET_RST and TZA_PDET_RST are used to manually control the peak detector reset signals.
	XCVR_RX_DIG_AGC_CTRL_2_MAN_PDET_RST_1 = 0x1
	// Position of BBA_GAIN_SETTLE_TIME field.
	XCVR_RX_DIG_AGC_CTRL_2_BBA_GAIN_SETTLE_TIME_Pos = 0x4
	// Bit mask of BBA_GAIN_SETTLE_TIME field.
	XCVR_RX_DIG_AGC_CTRL_2_BBA_GAIN_SETTLE_TIME_Msk = 0xff0
	// Position of BBA_PDET_SEL_LO field.
	XCVR_RX_DIG_AGC_CTRL_2_BBA_PDET_SEL_LO_Pos = 0xc
	// Bit mask of BBA_PDET_SEL_LO field.
	XCVR_RX_DIG_AGC_CTRL_2_BBA_PDET_SEL_LO_Msk = 0x7000
	// 0.600V
	XCVR_RX_DIG_AGC_CTRL_2_BBA_PDET_SEL_LO_000 = 0x0
	// 0.615V
	XCVR_RX_DIG_AGC_CTRL_2_BBA_PDET_SEL_LO_001 = 0x1
	// 0.630V
	XCVR_RX_DIG_AGC_CTRL_2_BBA_PDET_SEL_LO_010 = 0x2
	// 0.645V
	XCVR_RX_DIG_AGC_CTRL_2_BBA_PDET_SEL_LO_011 = 0x3
	// 0.660V
	XCVR_RX_DIG_AGC_CTRL_2_BBA_PDET_SEL_LO_100 = 0x4
	// 0.675V
	XCVR_RX_DIG_AGC_CTRL_2_BBA_PDET_SEL_LO_101 = 0x5
	// 0.690V
	XCVR_RX_DIG_AGC_CTRL_2_BBA_PDET_SEL_LO_110 = 0x6
	// 0.705V
	XCVR_RX_DIG_AGC_CTRL_2_BBA_PDET_SEL_LO_111 = 0x7
	// Position of BBA_PDET_SEL_HI field.
	XCVR_RX_DIG_AGC_CTRL_2_BBA_PDET_SEL_HI_Pos = 0xf
	// Bit mask of BBA_PDET_SEL_HI field.
	XCVR_RX_DIG_AGC_CTRL_2_BBA_PDET_SEL_HI_Msk = 0x38000
	// 0.600V
	XCVR_RX_DIG_AGC_CTRL_2_BBA_PDET_SEL_HI_000 = 0x0
	// 0.795V
	XCVR_RX_DIG_AGC_CTRL_2_BBA_PDET_SEL_HI_001 = 0x1
	// 0.900V
	XCVR_RX_DIG_AGC_CTRL_2_BBA_PDET_SEL_HI_010 = 0x2
	// 0.945V
	XCVR_RX_DIG_AGC_CTRL_2_BBA_PDET_SEL_HI_011 = 0x3
	// 1.005V
	XCVR_RX_DIG_AGC_CTRL_2_BBA_PDET_SEL_HI_100 = 0x4
	// 1.050V
	XCVR_RX_DIG_AGC_CTRL_2_BBA_PDET_SEL_HI_101 = 0x5
	// 1.095V
	XCVR_RX_DIG_AGC_CTRL_2_BBA_PDET_SEL_HI_110 = 0x6
	// 1.155V
	XCVR_RX_DIG_AGC_CTRL_2_BBA_PDET_SEL_HI_111 = 0x7
	// Position of TZA_PDET_SEL_LO field.
	XCVR_RX_DIG_AGC_CTRL_2_TZA_PDET_SEL_LO_Pos = 0x12
	// Bit mask of TZA_PDET_SEL_LO field.
	XCVR_RX_DIG_AGC_CTRL_2_TZA_PDET_SEL_LO_Msk = 0x1c0000
	// 0.600V
	XCVR_RX_DIG_AGC_CTRL_2_TZA_PDET_SEL_LO_000 = 0x0
	// 0.615V
	XCVR_RX_DIG_AGC_CTRL_2_TZA_PDET_SEL_LO_001 = 0x1
	// 0.630V
	XCVR_RX_DIG_AGC_CTRL_2_TZA_PDET_SEL_LO_010 = 0x2
	// 0.645V
	XCVR_RX_DIG_AGC_CTRL_2_TZA_PDET_SEL_LO_011 = 0x3
	// 0.660V
	XCVR_RX_DIG_AGC_CTRL_2_TZA_PDET_SEL_LO_100 = 0x4
	// 0.675V
	XCVR_RX_DIG_AGC_CTRL_2_TZA_PDET_SEL_LO_101 = 0x5
	// 0.690V
	XCVR_RX_DIG_AGC_CTRL_2_TZA_PDET_SEL_LO_110 = 0x6
	// 0.705V
	XCVR_RX_DIG_AGC_CTRL_2_TZA_PDET_SEL_LO_111 = 0x7
	// Position of TZA_PDET_SEL_HI field.
	XCVR_RX_DIG_AGC_CTRL_2_TZA_PDET_SEL_HI_Pos = 0x15
	// Bit mask of TZA_PDET_SEL_HI field.
	XCVR_RX_DIG_AGC_CTRL_2_TZA_PDET_SEL_HI_Msk = 0xe00000
	// 0.60V
	XCVR_RX_DIG_AGC_CTRL_2_TZA_PDET_SEL_HI_000 = 0x0
	// 0.63V
	XCVR_RX_DIG_AGC_CTRL_2_TZA_PDET_SEL_HI_001 = 0x1
	// 0.66V
	XCVR_RX_DIG_AGC_CTRL_2_TZA_PDET_SEL_HI_010 = 0x2
	// 0.69V
	XCVR_RX_DIG_AGC_CTRL_2_TZA_PDET_SEL_HI_011 = 0x3
	// 0.72V
	XCVR_RX_DIG_AGC_CTRL_2_TZA_PDET_SEL_HI_100 = 0x4
	// 0.75V
	XCVR_RX_DIG_AGC_CTRL_2_TZA_PDET_SEL_HI_101 = 0x5
	// 0.78V
	XCVR_RX_DIG_AGC_CTRL_2_TZA_PDET_SEL_HI_110 = 0x6
	// 0.81V
	XCVR_RX_DIG_AGC_CTRL_2_TZA_PDET_SEL_HI_111 = 0x7
	// Position of AGC_FAST_EXPIRE field.
	XCVR_RX_DIG_AGC_CTRL_2_AGC_FAST_EXPIRE_Pos = 0x18
	// Bit mask of AGC_FAST_EXPIRE field.
	XCVR_RX_DIG_AGC_CTRL_2_AGC_FAST_EXPIRE_Msk = 0x3f000000
	// Position of LNA_LG_ON_OVR field.
	XCVR_RX_DIG_AGC_CTRL_2_LNA_LG_ON_OVR_Pos = 0x1e
	// Bit mask of LNA_LG_ON_OVR field.
	XCVR_RX_DIG_AGC_CTRL_2_LNA_LG_ON_OVR_Msk = 0x40000000
	// Bit LNA_LG_ON_OVR.
	XCVR_RX_DIG_AGC_CTRL_2_LNA_LG_ON_OVR = 0x40000000
	// Position of LNA_HG_ON_OVR field.
	XCVR_RX_DIG_AGC_CTRL_2_LNA_HG_ON_OVR_Pos = 0x1f
	// Bit mask of LNA_HG_ON_OVR field.
	XCVR_RX_DIG_AGC_CTRL_2_LNA_HG_ON_OVR_Msk = 0x80000000
	// Bit LNA_HG_ON_OVR.
	XCVR_RX_DIG_AGC_CTRL_2_LNA_HG_ON_OVR = 0x80000000

	// AGC_CTRL_3: AGC Control 3
	// Position of AGC_UNFREEZE_TIME field.
	XCVR_RX_DIG_AGC_CTRL_3_AGC_UNFREEZE_TIME_Pos = 0x0
	// Bit mask of AGC_UNFREEZE_TIME field.
	XCVR_RX_DIG_AGC_CTRL_3_AGC_UNFREEZE_TIME_Msk = 0x1fff
	// Position of AGC_PDET_LO_DLY field.
	XCVR_RX_DIG_AGC_CTRL_3_AGC_PDET_LO_DLY_Pos = 0xd
	// Bit mask of AGC_PDET_LO_DLY field.
	XCVR_RX_DIG_AGC_CTRL_3_AGC_PDET_LO_DLY_Msk = 0xe000
	// Position of AGC_RSSI_DELT_H2S field.
	XCVR_RX_DIG_AGC_CTRL_3_AGC_RSSI_DELT_H2S_Pos = 0x10
	// Bit mask of AGC_RSSI_DELT_H2S field.
	XCVR_RX_DIG_AGC_CTRL_3_AGC_RSSI_DELT_H2S_Msk = 0x7f0000
	// Position of AGC_H2S_STEP_SZ field.
	XCVR_RX_DIG_AGC_CTRL_3_AGC_H2S_STEP_SZ_Pos = 0x17
	// Bit mask of AGC_H2S_STEP_SZ field.
	XCVR_RX_DIG_AGC_CTRL_3_AGC_H2S_STEP_SZ_Msk = 0xf800000
	// Position of AGC_UP_STEP_SZ field.
	XCVR_RX_DIG_AGC_CTRL_3_AGC_UP_STEP_SZ_Pos = 0x1c
	// Bit mask of AGC_UP_STEP_SZ field.
	XCVR_RX_DIG_AGC_CTRL_3_AGC_UP_STEP_SZ_Msk = 0xf0000000

	// AGC_STAT: AGC Status
	// Position of BBA_PDET_LO_STAT field.
	XCVR_RX_DIG_AGC_STAT_BBA_PDET_LO_STAT_Pos = 0x0
	// Bit mask of BBA_PDET_LO_STAT field.
	XCVR_RX_DIG_AGC_STAT_BBA_PDET_LO_STAT_Msk = 0x1
	// Bit BBA_PDET_LO_STAT.
	XCVR_RX_DIG_AGC_STAT_BBA_PDET_LO_STAT = 0x1
	// Position of BBA_PDET_HI_STAT field.
	XCVR_RX_DIG_AGC_STAT_BBA_PDET_HI_STAT_Pos = 0x1
	// Bit mask of BBA_PDET_HI_STAT field.
	XCVR_RX_DIG_AGC_STAT_BBA_PDET_HI_STAT_Msk = 0x2
	// Bit BBA_PDET_HI_STAT.
	XCVR_RX_DIG_AGC_STAT_BBA_PDET_HI_STAT = 0x2
	// Position of TZA_PDET_LO_STAT field.
	XCVR_RX_DIG_AGC_STAT_TZA_PDET_LO_STAT_Pos = 0x2
	// Bit mask of TZA_PDET_LO_STAT field.
	XCVR_RX_DIG_AGC_STAT_TZA_PDET_LO_STAT_Msk = 0x4
	// Bit TZA_PDET_LO_STAT.
	XCVR_RX_DIG_AGC_STAT_TZA_PDET_LO_STAT = 0x4
	// Position of TZA_PDET_HI_STAT field.
	XCVR_RX_DIG_AGC_STAT_TZA_PDET_HI_STAT_Pos = 0x3
	// Bit mask of TZA_PDET_HI_STAT field.
	XCVR_RX_DIG_AGC_STAT_TZA_PDET_HI_STAT_Msk = 0x8
	// Bit TZA_PDET_HI_STAT.
	XCVR_RX_DIG_AGC_STAT_TZA_PDET_HI_STAT = 0x8
	// Position of CURR_AGC_IDX field.
	XCVR_RX_DIG_AGC_STAT_CURR_AGC_IDX_Pos = 0x4
	// Bit mask of CURR_AGC_IDX field.
	XCVR_RX_DIG_AGC_STAT_CURR_AGC_IDX_Msk = 0x1f0
	// Position of AGC_FROZEN field.
	XCVR_RX_DIG_AGC_STAT_AGC_FROZEN_Pos = 0x9
	// Bit mask of AGC_FROZEN field.
	XCVR_RX_DIG_AGC_STAT_AGC_FROZEN_Msk = 0x200
	// Bit AGC_FROZEN.
	XCVR_RX_DIG_AGC_STAT_AGC_FROZEN = 0x200
	// AGC is not frozen.
	XCVR_RX_DIG_AGC_STAT_AGC_FROZEN_0 = 0x0
	// AGC is frozen.
	XCVR_RX_DIG_AGC_STAT_AGC_FROZEN_1 = 0x1
	// Position of RSSI_ADC_RAW field.
	XCVR_RX_DIG_AGC_STAT_RSSI_ADC_RAW_Pos = 0x10
	// Bit mask of RSSI_ADC_RAW field.
	XCVR_RX_DIG_AGC_STAT_RSSI_ADC_RAW_Msk = 0xff0000

	// RSSI_CTRL_0: RSSI Control 0
	// Position of RSSI_USE_VALS field.
	XCVR_RX_DIG_RSSI_CTRL_0_RSSI_USE_VALS_Pos = 0x0
	// Bit mask of RSSI_USE_VALS field.
	XCVR_RX_DIG_RSSI_CTRL_0_RSSI_USE_VALS_Msk = 0x1
	// Bit RSSI_USE_VALS.
	XCVR_RX_DIG_RSSI_CTRL_0_RSSI_USE_VALS = 0x1
	// Position of RSSI_HOLD_SRC field.
	XCVR_RX_DIG_RSSI_CTRL_0_RSSI_HOLD_SRC_Pos = 0x1
	// Bit mask of RSSI_HOLD_SRC field.
	XCVR_RX_DIG_RSSI_CTRL_0_RSSI_HOLD_SRC_Msk = 0x6
	// Access Address match
	XCVR_RX_DIG_RSSI_CTRL_0_RSSI_HOLD_SRC_00 = 0x0
	// Preamble Detect
	XCVR_RX_DIG_RSSI_CTRL_0_RSSI_HOLD_SRC_01 = 0x1
	// 802.15.4 LQI done (1=freeze, 0=run AGC)
	XCVR_RX_DIG_RSSI_CTRL_0_RSSI_HOLD_SRC_11 = 0x3
	// Position of RSSI_HOLD_EN field.
	XCVR_RX_DIG_RSSI_CTRL_0_RSSI_HOLD_EN_Pos = 0x3
	// Bit mask of RSSI_HOLD_EN field.
	XCVR_RX_DIG_RSSI_CTRL_0_RSSI_HOLD_EN_Msk = 0x8
	// Bit RSSI_HOLD_EN.
	XCVR_RX_DIG_RSSI_CTRL_0_RSSI_HOLD_EN = 0x8
	// Position of RSSI_IIR_CW_WEIGHT field.
	XCVR_RX_DIG_RSSI_CTRL_0_RSSI_IIR_CW_WEIGHT_Pos = 0x5
	// Bit mask of RSSI_IIR_CW_WEIGHT field.
	XCVR_RX_DIG_RSSI_CTRL_0_RSSI_IIR_CW_WEIGHT_Msk = 0x60
	// Bypass
	XCVR_RX_DIG_RSSI_CTRL_0_RSSI_IIR_CW_WEIGHT_0 = 0x0
	// 1/8
	XCVR_RX_DIG_RSSI_CTRL_0_RSSI_IIR_CW_WEIGHT_1 = 0x1
	// 1/16
	XCVR_RX_DIG_RSSI_CTRL_0_RSSI_IIR_CW_WEIGHT_2 = 0x2
	// 1/32
	XCVR_RX_DIG_RSSI_CTRL_0_RSSI_IIR_CW_WEIGHT_3 = 0x3
	// Position of RSSI_N_WINDOW_AVG field.
	XCVR_RX_DIG_RSSI_CTRL_0_RSSI_N_WINDOW_AVG_Pos = 0x8
	// Bit mask of RSSI_N_WINDOW_AVG field.
	XCVR_RX_DIG_RSSI_CTRL_0_RSSI_N_WINDOW_AVG_Msk = 0x300
	// No averaging
	XCVR_RX_DIG_RSSI_CTRL_0_RSSI_N_WINDOW_AVG_0 = 0x0
	// Averaging window length is 2 samples
	XCVR_RX_DIG_RSSI_CTRL_0_RSSI_N_WINDOW_AVG_1 = 0x1
	// Averaging window length is 4 samples
	XCVR_RX_DIG_RSSI_CTRL_0_RSSI_N_WINDOW_AVG_2 = 0x2
	// Averaging window length is 8 samples
	XCVR_RX_DIG_RSSI_CTRL_0_RSSI_N_WINDOW_AVG_3 = 0x3
	// Position of RSSI_HOLD_DELAY field.
	XCVR_RX_DIG_RSSI_CTRL_0_RSSI_HOLD_DELAY_Pos = 0xa
	// Bit mask of RSSI_HOLD_DELAY field.
	XCVR_RX_DIG_RSSI_CTRL_0_RSSI_HOLD_DELAY_Msk = 0xfc00
	// Position of RSSI_IIR_WEIGHT field.
	XCVR_RX_DIG_RSSI_CTRL_0_RSSI_IIR_WEIGHT_Pos = 0x10
	// Bit mask of RSSI_IIR_WEIGHT field.
	XCVR_RX_DIG_RSSI_CTRL_0_RSSI_IIR_WEIGHT_Msk = 0xf0000
	// Bypass
	XCVR_RX_DIG_RSSI_CTRL_0_RSSI_IIR_WEIGHT_0 = 0x0
	// 1/2
	XCVR_RX_DIG_RSSI_CTRL_0_RSSI_IIR_WEIGHT_1 = 0x1
	// 1/4
	XCVR_RX_DIG_RSSI_CTRL_0_RSSI_IIR_WEIGHT_2 = 0x2
	// 1/8
	XCVR_RX_DIG_RSSI_CTRL_0_RSSI_IIR_WEIGHT_3 = 0x3
	// 1/16
	XCVR_RX_DIG_RSSI_CTRL_0_RSSI_IIR_WEIGHT_4 = 0x4
	// 1/32
	XCVR_RX_DIG_RSSI_CTRL_0_RSSI_IIR_WEIGHT_5 = 0x5
	// Position of RSSI_VLD_SETTLE field.
	XCVR_RX_DIG_RSSI_CTRL_0_RSSI_VLD_SETTLE_Pos = 0x14
	// Bit mask of RSSI_VLD_SETTLE field.
	XCVR_RX_DIG_RSSI_CTRL_0_RSSI_VLD_SETTLE_Msk = 0x700000
	// Position of RSSI_ADJ field.
	XCVR_RX_DIG_RSSI_CTRL_0_RSSI_ADJ_Pos = 0x18
	// Bit mask of RSSI_ADJ field.
	XCVR_RX_DIG_RSSI_CTRL_0_RSSI_ADJ_Msk = 0xff000000

	// RSSI_CTRL_1: RSSI Control 1
	// Position of RSSI_OUT field.
	XCVR_RX_DIG_RSSI_CTRL_1_RSSI_OUT_Pos = 0x18
	// Bit mask of RSSI_OUT field.
	XCVR_RX_DIG_RSSI_CTRL_1_RSSI_OUT_Msk = 0xff000000

	// RSSI_DFT: RSSI DFT
	// Position of DFT_MAG field.
	XCVR_RX_DIG_RSSI_DFT_DFT_MAG_Pos = 0x0
	// Bit mask of DFT_MAG field.
	XCVR_RX_DIG_RSSI_DFT_DFT_MAG_Msk = 0x1fff
	// Position of DFT_NOISE field.
	XCVR_RX_DIG_RSSI_DFT_DFT_NOISE_Pos = 0x10
	// Bit mask of DFT_NOISE field.
	XCVR_RX_DIG_RSSI_DFT_DFT_NOISE_Msk = 0x1fff0000

	// DCOC_CTRL_0: DCOC Control 0
	// Position of DCOC_MIDPWR_TRK_DIS field.
	XCVR_RX_DIG_DCOC_CTRL_0_DCOC_MIDPWR_TRK_DIS_Pos = 0x0
	// Bit mask of DCOC_MIDPWR_TRK_DIS field.
	XCVR_RX_DIG_DCOC_CTRL_0_DCOC_MIDPWR_TRK_DIS_Msk = 0x1
	// Bit DCOC_MIDPWR_TRK_DIS.
	XCVR_RX_DIG_DCOC_CTRL_0_DCOC_MIDPWR_TRK_DIS = 0x1
	// Tracking corrections are enabled as determined by DCOC_CORRECT_SRC and DCOC_TRK_MIN_AGC_IDX.
	XCVR_RX_DIG_DCOC_CTRL_0_DCOC_MIDPWR_TRK_DIS_0 = 0x0
	// Tracking corrections are disabled when either the TZA or BBA lo peak detector asserts.
	XCVR_RX_DIG_DCOC_CTRL_0_DCOC_MIDPWR_TRK_DIS_1 = 0x1
	// Position of DCOC_MAN field.
	XCVR_RX_DIG_DCOC_CTRL_0_DCOC_MAN_Pos = 0x1
	// Bit mask of DCOC_MAN field.
	XCVR_RX_DIG_DCOC_CTRL_0_DCOC_MAN_Msk = 0x2
	// Bit DCOC_MAN.
	XCVR_RX_DIG_DCOC_CTRL_0_DCOC_MAN = 0x2
	// Position of DCOC_TRK_EST_OVR field.
	XCVR_RX_DIG_DCOC_CTRL_0_DCOC_TRK_EST_OVR_Pos = 0x2
	// Bit mask of DCOC_TRK_EST_OVR field.
	XCVR_RX_DIG_DCOC_CTRL_0_DCOC_TRK_EST_OVR_Msk = 0x4
	// Bit DCOC_TRK_EST_OVR.
	XCVR_RX_DIG_DCOC_CTRL_0_DCOC_TRK_EST_OVR = 0x4
	// The tracking estimator is enabled only as needed by the corrector
	XCVR_RX_DIG_DCOC_CTRL_0_DCOC_TRK_EST_OVR_0 = 0x0
	// The tracking estimator remains enabled whenever the DCOC is active
	XCVR_RX_DIG_DCOC_CTRL_0_DCOC_TRK_EST_OVR_1 = 0x1
	// Position of DCOC_CORRECT_SRC field.
	XCVR_RX_DIG_DCOC_CTRL_0_DCOC_CORRECT_SRC_Pos = 0x3
	// Bit mask of DCOC_CORRECT_SRC field.
	XCVR_RX_DIG_DCOC_CTRL_0_DCOC_CORRECT_SRC_Msk = 0x8
	// Bit DCOC_CORRECT_SRC.
	XCVR_RX_DIG_DCOC_CTRL_0_DCOC_CORRECT_SRC = 0x8
	// If correction is enabled, the DCOC will use only the DCOC calibration table to correct the DC offset.
	XCVR_RX_DIG_DCOC_CTRL_0_DCOC_CORRECT_SRC_0 = 0x0
	// If correction is enabled, the DCOC will use the DCOC calibration table and then the tracking estimator to correct the DC offset.
	XCVR_RX_DIG_DCOC_CTRL_0_DCOC_CORRECT_SRC_1 = 0x1
	// Position of DCOC_CORRECT_EN field.
	XCVR_RX_DIG_DCOC_CTRL_0_DCOC_CORRECT_EN_Pos = 0x4
	// Bit mask of DCOC_CORRECT_EN field.
	XCVR_RX_DIG_DCOC_CTRL_0_DCOC_CORRECT_EN_Msk = 0x10
	// Bit DCOC_CORRECT_EN.
	XCVR_RX_DIG_DCOC_CTRL_0_DCOC_CORRECT_EN = 0x10
	// Correction disabled. The DCOC will not correct the DC offset.
	XCVR_RX_DIG_DCOC_CTRL_0_DCOC_CORRECT_EN_0 = 0x0
	// Correction enabled. The DCOC will use the TZA and BBA DACs, and apply digital corrections (if DCOC_CORRECT_SRC=1) to correct the DC offset.
	XCVR_RX_DIG_DCOC_CTRL_0_DCOC_CORRECT_EN_1 = 0x1
	// Position of TRACK_FROM_ZERO field.
	XCVR_RX_DIG_DCOC_CTRL_0_TRACK_FROM_ZERO_Pos = 0x5
	// Bit mask of TRACK_FROM_ZERO field.
	XCVR_RX_DIG_DCOC_CTRL_0_TRACK_FROM_ZERO_Msk = 0x20
	// Bit TRACK_FROM_ZERO.
	XCVR_RX_DIG_DCOC_CTRL_0_TRACK_FROM_ZERO = 0x20
	// Track from current I/Q sample.
	XCVR_RX_DIG_DCOC_CTRL_0_TRACK_FROM_ZERO_0 = 0x0
	// Track from zero.
	XCVR_RX_DIG_DCOC_CTRL_0_TRACK_FROM_ZERO_1 = 0x1
	// Position of BBA_CORR_POL field.
	XCVR_RX_DIG_DCOC_CTRL_0_BBA_CORR_POL_Pos = 0x6
	// Bit mask of BBA_CORR_POL field.
	XCVR_RX_DIG_DCOC_CTRL_0_BBA_CORR_POL_Msk = 0x40
	// Bit BBA_CORR_POL.
	XCVR_RX_DIG_DCOC_CTRL_0_BBA_CORR_POL = 0x40
	// Normal polarity.
	XCVR_RX_DIG_DCOC_CTRL_0_BBA_CORR_POL_0 = 0x0
	// Negative polarity. This should be set if the ADC output is inverted, or if the BBA DACs were implemented with negative polarity.
	XCVR_RX_DIG_DCOC_CTRL_0_BBA_CORR_POL_1 = 0x1
	// Position of TZA_CORR_POL field.
	XCVR_RX_DIG_DCOC_CTRL_0_TZA_CORR_POL_Pos = 0x7
	// Bit mask of TZA_CORR_POL field.
	XCVR_RX_DIG_DCOC_CTRL_0_TZA_CORR_POL_Msk = 0x80
	// Bit TZA_CORR_POL.
	XCVR_RX_DIG_DCOC_CTRL_0_TZA_CORR_POL = 0x80
	// Normal polarity.
	XCVR_RX_DIG_DCOC_CTRL_0_TZA_CORR_POL_0 = 0x0
	// Negative polarity. This should be set if the ADC output is inverted, or if the TZA DACs were implemented with negative polarity.
	XCVR_RX_DIG_DCOC_CTRL_0_TZA_CORR_POL_1 = 0x1
	// Position of DCOC_CAL_DURATION field.
	XCVR_RX_DIG_DCOC_CTRL_0_DCOC_CAL_DURATION_Pos = 0x8
	// Bit mask of DCOC_CAL_DURATION field.
	XCVR_RX_DIG_DCOC_CTRL_0_DCOC_CAL_DURATION_Msk = 0x1f00
	// Position of DCOC_CORR_DLY field.
	XCVR_RX_DIG_DCOC_CTRL_0_DCOC_CORR_DLY_Pos = 0x10
	// Bit mask of DCOC_CORR_DLY field.
	XCVR_RX_DIG_DCOC_CTRL_0_DCOC_CORR_DLY_Msk = 0x1f0000
	// Position of DCOC_CORR_HOLD_TIME field.
	XCVR_RX_DIG_DCOC_CTRL_0_DCOC_CORR_HOLD_TIME_Pos = 0x18
	// Bit mask of DCOC_CORR_HOLD_TIME field.
	XCVR_RX_DIG_DCOC_CTRL_0_DCOC_CORR_HOLD_TIME_Msk = 0x7f000000
	// The DC correction is not frozen.
	XCVR_RX_DIG_DCOC_CTRL_0_DCOC_CORR_HOLD_TIME_127 = 0x7f

	// DCOC_CTRL_1: DCOC Control 1
	// Position of DCOC_SIGN_SCALE_IDX field.
	XCVR_RX_DIG_DCOC_CTRL_1_DCOC_SIGN_SCALE_IDX_Pos = 0x0
	// Bit mask of DCOC_SIGN_SCALE_IDX field.
	XCVR_RX_DIG_DCOC_CTRL_1_DCOC_SIGN_SCALE_IDX_Msk = 0x3
	// 1/8
	XCVR_RX_DIG_DCOC_CTRL_1_DCOC_SIGN_SCALE_IDX_00 = 0x0
	// 1/16
	XCVR_RX_DIG_DCOC_CTRL_1_DCOC_SIGN_SCALE_IDX_01 = 0x1
	// 1/32
	XCVR_RX_DIG_DCOC_CTRL_1_DCOC_SIGN_SCALE_IDX_10 = 0x2
	// 1/64
	XCVR_RX_DIG_DCOC_CTRL_1_DCOC_SIGN_SCALE_IDX_11 = 0x3
	// Position of DCOC_ALPHAC_SCALE_IDX field.
	XCVR_RX_DIG_DCOC_CTRL_1_DCOC_ALPHAC_SCALE_IDX_Pos = 0x2
	// Bit mask of DCOC_ALPHAC_SCALE_IDX field.
	XCVR_RX_DIG_DCOC_CTRL_1_DCOC_ALPHAC_SCALE_IDX_Msk = 0x1c
	// 1/2
	XCVR_RX_DIG_DCOC_CTRL_1_DCOC_ALPHAC_SCALE_IDX_000 = 0x0
	// 1/4
	XCVR_RX_DIG_DCOC_CTRL_1_DCOC_ALPHAC_SCALE_IDX_001 = 0x1
	// 1/8
	XCVR_RX_DIG_DCOC_CTRL_1_DCOC_ALPHAC_SCALE_IDX_010 = 0x2
	// 1/16
	XCVR_RX_DIG_DCOC_CTRL_1_DCOC_ALPHAC_SCALE_IDX_011 = 0x3
	// 1/32
	XCVR_RX_DIG_DCOC_CTRL_1_DCOC_ALPHAC_SCALE_IDX_100 = 0x4
	// 1/64
	XCVR_RX_DIG_DCOC_CTRL_1_DCOC_ALPHAC_SCALE_IDX_101 = 0x5
	// Position of DCOC_ALPHA_RADIUS_IDX field.
	XCVR_RX_DIG_DCOC_CTRL_1_DCOC_ALPHA_RADIUS_IDX_Pos = 0x5
	// Bit mask of DCOC_ALPHA_RADIUS_IDX field.
	XCVR_RX_DIG_DCOC_CTRL_1_DCOC_ALPHA_RADIUS_IDX_Msk = 0xe0
	// 1
	XCVR_RX_DIG_DCOC_CTRL_1_DCOC_ALPHA_RADIUS_IDX_000 = 0x0
	// 1/2
	XCVR_RX_DIG_DCOC_CTRL_1_DCOC_ALPHA_RADIUS_IDX_001 = 0x1
	// 1/4
	XCVR_RX_DIG_DCOC_CTRL_1_DCOC_ALPHA_RADIUS_IDX_010 = 0x2
	// 1/8
	XCVR_RX_DIG_DCOC_CTRL_1_DCOC_ALPHA_RADIUS_IDX_011 = 0x3
	// 1/16
	XCVR_RX_DIG_DCOC_CTRL_1_DCOC_ALPHA_RADIUS_IDX_100 = 0x4
	// 1/32
	XCVR_RX_DIG_DCOC_CTRL_1_DCOC_ALPHA_RADIUS_IDX_101 = 0x5
	// 1/64
	XCVR_RX_DIG_DCOC_CTRL_1_DCOC_ALPHA_RADIUS_IDX_110 = 0x6
	// Position of DCOC_TRK_EST_GS_CNT field.
	XCVR_RX_DIG_DCOC_CTRL_1_DCOC_TRK_EST_GS_CNT_Pos = 0xc
	// Bit mask of DCOC_TRK_EST_GS_CNT field.
	XCVR_RX_DIG_DCOC_CTRL_1_DCOC_TRK_EST_GS_CNT_Msk = 0x7000
	// Position of DCOC_SIGN_SCALE_GS_IDX field.
	XCVR_RX_DIG_DCOC_CTRL_1_DCOC_SIGN_SCALE_GS_IDX_Pos = 0x10
	// Bit mask of DCOC_SIGN_SCALE_GS_IDX field.
	XCVR_RX_DIG_DCOC_CTRL_1_DCOC_SIGN_SCALE_GS_IDX_Msk = 0x30000
	// 1/8
	XCVR_RX_DIG_DCOC_CTRL_1_DCOC_SIGN_SCALE_GS_IDX_00 = 0x0
	// 1/16
	XCVR_RX_DIG_DCOC_CTRL_1_DCOC_SIGN_SCALE_GS_IDX_01 = 0x1
	// 1/32
	XCVR_RX_DIG_DCOC_CTRL_1_DCOC_SIGN_SCALE_GS_IDX_10 = 0x2
	// 1/64
	XCVR_RX_DIG_DCOC_CTRL_1_DCOC_SIGN_SCALE_GS_IDX_11 = 0x3
	// Position of DCOC_ALPHAC_SCALE_GS_IDX field.
	XCVR_RX_DIG_DCOC_CTRL_1_DCOC_ALPHAC_SCALE_GS_IDX_Pos = 0x12
	// Bit mask of DCOC_ALPHAC_SCALE_GS_IDX field.
	XCVR_RX_DIG_DCOC_CTRL_1_DCOC_ALPHAC_SCALE_GS_IDX_Msk = 0x1c0000
	// 1/2
	XCVR_RX_DIG_DCOC_CTRL_1_DCOC_ALPHAC_SCALE_GS_IDX_000 = 0x0
	// 1/4
	XCVR_RX_DIG_DCOC_CTRL_1_DCOC_ALPHAC_SCALE_GS_IDX_001 = 0x1
	// 1/8
	XCVR_RX_DIG_DCOC_CTRL_1_DCOC_ALPHAC_SCALE_GS_IDX_010 = 0x2
	// 1/16
	XCVR_RX_DIG_DCOC_CTRL_1_DCOC_ALPHAC_SCALE_GS_IDX_011 = 0x3
	// 1/32
	XCVR_RX_DIG_DCOC_CTRL_1_DCOC_ALPHAC_SCALE_GS_IDX_100 = 0x4
	// 1/64
	XCVR_RX_DIG_DCOC_CTRL_1_DCOC_ALPHAC_SCALE_GS_IDX_101 = 0x5
	// Position of DCOC_ALPHA_RADIUS_GS_IDX field.
	XCVR_RX_DIG_DCOC_CTRL_1_DCOC_ALPHA_RADIUS_GS_IDX_Pos = 0x15
	// Bit mask of DCOC_ALPHA_RADIUS_GS_IDX field.
	XCVR_RX_DIG_DCOC_CTRL_1_DCOC_ALPHA_RADIUS_GS_IDX_Msk = 0xe00000
	// 1
	XCVR_RX_DIG_DCOC_CTRL_1_DCOC_ALPHA_RADIUS_GS_IDX_000 = 0x0
	// 1/2
	XCVR_RX_DIG_DCOC_CTRL_1_DCOC_ALPHA_RADIUS_GS_IDX_001 = 0x1
	// 1/4
	XCVR_RX_DIG_DCOC_CTRL_1_DCOC_ALPHA_RADIUS_GS_IDX_010 = 0x2
	// 1/8
	XCVR_RX_DIG_DCOC_CTRL_1_DCOC_ALPHA_RADIUS_GS_IDX_011 = 0x3
	// 1/16
	XCVR_RX_DIG_DCOC_CTRL_1_DCOC_ALPHA_RADIUS_GS_IDX_100 = 0x4
	// 1/32
	XCVR_RX_DIG_DCOC_CTRL_1_DCOC_ALPHA_RADIUS_GS_IDX_101 = 0x5
	// 1/64
	XCVR_RX_DIG_DCOC_CTRL_1_DCOC_ALPHA_RADIUS_GS_IDX_110 = 0x6
	// Position of DCOC_TRK_MIN_AGC_IDX field.
	XCVR_RX_DIG_DCOC_CTRL_1_DCOC_TRK_MIN_AGC_IDX_Pos = 0x18
	// Bit mask of DCOC_TRK_MIN_AGC_IDX field.
	XCVR_RX_DIG_DCOC_CTRL_1_DCOC_TRK_MIN_AGC_IDX_Msk = 0x1f000000

	// DCOC_DAC_INIT: DCOC DAC Initialization
	// Position of BBA_DCOC_INIT_I field.
	XCVR_RX_DIG_DCOC_DAC_INIT_BBA_DCOC_INIT_I_Pos = 0x0
	// Bit mask of BBA_DCOC_INIT_I field.
	XCVR_RX_DIG_DCOC_DAC_INIT_BBA_DCOC_INIT_I_Msk = 0x3f
	// Position of BBA_DCOC_INIT_Q field.
	XCVR_RX_DIG_DCOC_DAC_INIT_BBA_DCOC_INIT_Q_Pos = 0x8
	// Bit mask of BBA_DCOC_INIT_Q field.
	XCVR_RX_DIG_DCOC_DAC_INIT_BBA_DCOC_INIT_Q_Msk = 0x3f00
	// Position of TZA_DCOC_INIT_I field.
	XCVR_RX_DIG_DCOC_DAC_INIT_TZA_DCOC_INIT_I_Pos = 0x10
	// Bit mask of TZA_DCOC_INIT_I field.
	XCVR_RX_DIG_DCOC_DAC_INIT_TZA_DCOC_INIT_I_Msk = 0xff0000
	// Position of TZA_DCOC_INIT_Q field.
	XCVR_RX_DIG_DCOC_DAC_INIT_TZA_DCOC_INIT_Q_Pos = 0x18
	// Bit mask of TZA_DCOC_INIT_Q field.
	XCVR_RX_DIG_DCOC_DAC_INIT_TZA_DCOC_INIT_Q_Msk = 0xff000000

	// DCOC_DIG_MAN: DCOC Digital Correction Manual Override
	// Position of DIG_DCOC_INIT_I field.
	XCVR_RX_DIG_DCOC_DIG_MAN_DIG_DCOC_INIT_I_Pos = 0x0
	// Bit mask of DIG_DCOC_INIT_I field.
	XCVR_RX_DIG_DCOC_DIG_MAN_DIG_DCOC_INIT_I_Msk = 0xfff
	// Position of DIG_DCOC_INIT_Q field.
	XCVR_RX_DIG_DCOC_DIG_MAN_DIG_DCOC_INIT_Q_Pos = 0x10
	// Bit mask of DIG_DCOC_INIT_Q field.
	XCVR_RX_DIG_DCOC_DIG_MAN_DIG_DCOC_INIT_Q_Msk = 0xfff0000

	// DCOC_CAL_GAIN: DCOC Calibration Gain
	// Position of DCOC_BBA_CAL_GAIN1 field.
	XCVR_RX_DIG_DCOC_CAL_GAIN_DCOC_BBA_CAL_GAIN1_Pos = 0x8
	// Bit mask of DCOC_BBA_CAL_GAIN1 field.
	XCVR_RX_DIG_DCOC_CAL_GAIN_DCOC_BBA_CAL_GAIN1_Msk = 0xf00
	// Position of DCOC_LNA_CAL_GAIN1 field.
	XCVR_RX_DIG_DCOC_CAL_GAIN_DCOC_LNA_CAL_GAIN1_Pos = 0xc
	// Bit mask of DCOC_LNA_CAL_GAIN1 field.
	XCVR_RX_DIG_DCOC_CAL_GAIN_DCOC_LNA_CAL_GAIN1_Msk = 0xf000
	// Position of DCOC_BBA_CAL_GAIN2 field.
	XCVR_RX_DIG_DCOC_CAL_GAIN_DCOC_BBA_CAL_GAIN2_Pos = 0x10
	// Bit mask of DCOC_BBA_CAL_GAIN2 field.
	XCVR_RX_DIG_DCOC_CAL_GAIN_DCOC_BBA_CAL_GAIN2_Msk = 0xf0000
	// Position of DCOC_LNA_CAL_GAIN2 field.
	XCVR_RX_DIG_DCOC_CAL_GAIN_DCOC_LNA_CAL_GAIN2_Pos = 0x14
	// Bit mask of DCOC_LNA_CAL_GAIN2 field.
	XCVR_RX_DIG_DCOC_CAL_GAIN_DCOC_LNA_CAL_GAIN2_Msk = 0xf00000
	// Position of DCOC_BBA_CAL_GAIN3 field.
	XCVR_RX_DIG_DCOC_CAL_GAIN_DCOC_BBA_CAL_GAIN3_Pos = 0x18
	// Bit mask of DCOC_BBA_CAL_GAIN3 field.
	XCVR_RX_DIG_DCOC_CAL_GAIN_DCOC_BBA_CAL_GAIN3_Msk = 0xf000000
	// Position of DCOC_LNA_CAL_GAIN3 field.
	XCVR_RX_DIG_DCOC_CAL_GAIN_DCOC_LNA_CAL_GAIN3_Pos = 0x1c
	// Bit mask of DCOC_LNA_CAL_GAIN3 field.
	XCVR_RX_DIG_DCOC_CAL_GAIN_DCOC_LNA_CAL_GAIN3_Msk = 0xf0000000

	// DCOC_STAT: DCOC Status
	// Position of BBA_DCOC_I field.
	XCVR_RX_DIG_DCOC_STAT_BBA_DCOC_I_Pos = 0x0
	// Bit mask of BBA_DCOC_I field.
	XCVR_RX_DIG_DCOC_STAT_BBA_DCOC_I_Msk = 0x3f
	// Position of BBA_DCOC_Q field.
	XCVR_RX_DIG_DCOC_STAT_BBA_DCOC_Q_Pos = 0x8
	// Bit mask of BBA_DCOC_Q field.
	XCVR_RX_DIG_DCOC_STAT_BBA_DCOC_Q_Msk = 0x3f00
	// Position of TZA_DCOC_I field.
	XCVR_RX_DIG_DCOC_STAT_TZA_DCOC_I_Pos = 0x10
	// Bit mask of TZA_DCOC_I field.
	XCVR_RX_DIG_DCOC_STAT_TZA_DCOC_I_Msk = 0xff0000
	// Position of TZA_DCOC_Q field.
	XCVR_RX_DIG_DCOC_STAT_TZA_DCOC_Q_Pos = 0x18
	// Bit mask of TZA_DCOC_Q field.
	XCVR_RX_DIG_DCOC_STAT_TZA_DCOC_Q_Msk = 0xff000000

	// DCOC_DC_EST: DCOC DC Estimate
	// Position of DC_EST_I field.
	XCVR_RX_DIG_DCOC_DC_EST_DC_EST_I_Pos = 0x0
	// Bit mask of DC_EST_I field.
	XCVR_RX_DIG_DCOC_DC_EST_DC_EST_I_Msk = 0xfff
	// Position of DC_EST_Q field.
	XCVR_RX_DIG_DCOC_DC_EST_DC_EST_Q_Pos = 0x10
	// Bit mask of DC_EST_Q field.
	XCVR_RX_DIG_DCOC_DC_EST_DC_EST_Q_Msk = 0xfff0000

	// DCOC_CAL_RCP: DCOC Calibration Reciprocals
	// Position of DCOC_TMP_CALC_RECIP field.
	XCVR_RX_DIG_DCOC_CAL_RCP_DCOC_TMP_CALC_RECIP_Pos = 0x0
	// Bit mask of DCOC_TMP_CALC_RECIP field.
	XCVR_RX_DIG_DCOC_CAL_RCP_DCOC_TMP_CALC_RECIP_Msk = 0x7ff
	// Position of ALPHA_CALC_RECIP field.
	XCVR_RX_DIG_DCOC_CAL_RCP_ALPHA_CALC_RECIP_Pos = 0x10
	// Bit mask of ALPHA_CALC_RECIP field.
	XCVR_RX_DIG_DCOC_CAL_RCP_ALPHA_CALC_RECIP_Msk = 0x7ff0000

	// IQMC_CTRL: IQMC Control
	// Position of IQMC_CAL_EN field.
	XCVR_RX_DIG_IQMC_CTRL_IQMC_CAL_EN_Pos = 0x0
	// Bit mask of IQMC_CAL_EN field.
	XCVR_RX_DIG_IQMC_CTRL_IQMC_CAL_EN_Msk = 0x1
	// Bit IQMC_CAL_EN.
	XCVR_RX_DIG_IQMC_CTRL_IQMC_CAL_EN = 0x1
	// Position of IQMC_NUM_ITER field.
	XCVR_RX_DIG_IQMC_CTRL_IQMC_NUM_ITER_Pos = 0x8
	// Bit mask of IQMC_NUM_ITER field.
	XCVR_RX_DIG_IQMC_CTRL_IQMC_NUM_ITER_Msk = 0xff00
	// Position of IQMC_DC_GAIN_ADJ field.
	XCVR_RX_DIG_IQMC_CTRL_IQMC_DC_GAIN_ADJ_Pos = 0x10
	// Bit mask of IQMC_DC_GAIN_ADJ field.
	XCVR_RX_DIG_IQMC_CTRL_IQMC_DC_GAIN_ADJ_Msk = 0x7ff0000

	// IQMC_CAL: IQMC Calibration
	// Position of IQMC_GAIN_ADJ field.
	XCVR_RX_DIG_IQMC_CAL_IQMC_GAIN_ADJ_Pos = 0x0
	// Bit mask of IQMC_GAIN_ADJ field.
	XCVR_RX_DIG_IQMC_CAL_IQMC_GAIN_ADJ_Msk = 0x7ff
	// Position of IQMC_PHASE_ADJ field.
	XCVR_RX_DIG_IQMC_CAL_IQMC_PHASE_ADJ_Pos = 0x10
	// Bit mask of IQMC_PHASE_ADJ field.
	XCVR_RX_DIG_IQMC_CAL_IQMC_PHASE_ADJ_Msk = 0xfff0000

	// LNA_GAIN_VAL_3_0: LNA_GAIN Step Values 3..0
	// Position of LNA_GAIN_VAL_0 field.
	XCVR_RX_DIG_LNA_GAIN_VAL_3_0_LNA_GAIN_VAL_0_Pos = 0x0
	// Bit mask of LNA_GAIN_VAL_0 field.
	XCVR_RX_DIG_LNA_GAIN_VAL_3_0_LNA_GAIN_VAL_0_Msk = 0xff
	// Position of LNA_GAIN_VAL_1 field.
	XCVR_RX_DIG_LNA_GAIN_VAL_3_0_LNA_GAIN_VAL_1_Pos = 0x8
	// Bit mask of LNA_GAIN_VAL_1 field.
	XCVR_RX_DIG_LNA_GAIN_VAL_3_0_LNA_GAIN_VAL_1_Msk = 0xff00
	// Position of LNA_GAIN_VAL_2 field.
	XCVR_RX_DIG_LNA_GAIN_VAL_3_0_LNA_GAIN_VAL_2_Pos = 0x10
	// Bit mask of LNA_GAIN_VAL_2 field.
	XCVR_RX_DIG_LNA_GAIN_VAL_3_0_LNA_GAIN_VAL_2_Msk = 0xff0000
	// Position of LNA_GAIN_VAL_3 field.
	XCVR_RX_DIG_LNA_GAIN_VAL_3_0_LNA_GAIN_VAL_3_Pos = 0x18
	// Bit mask of LNA_GAIN_VAL_3 field.
	XCVR_RX_DIG_LNA_GAIN_VAL_3_0_LNA_GAIN_VAL_3_Msk = 0xff000000

	// LNA_GAIN_VAL_7_4: LNA_GAIN Step Values 7..4
	// Position of LNA_GAIN_VAL_4 field.
	XCVR_RX_DIG_LNA_GAIN_VAL_7_4_LNA_GAIN_VAL_4_Pos = 0x0
	// Bit mask of LNA_GAIN_VAL_4 field.
	XCVR_RX_DIG_LNA_GAIN_VAL_7_4_LNA_GAIN_VAL_4_Msk = 0xff
	// Position of LNA_GAIN_VAL_5 field.
	XCVR_RX_DIG_LNA_GAIN_VAL_7_4_LNA_GAIN_VAL_5_Pos = 0x8
	// Bit mask of LNA_GAIN_VAL_5 field.
	XCVR_RX_DIG_LNA_GAIN_VAL_7_4_LNA_GAIN_VAL_5_Msk = 0xff00
	// Position of LNA_GAIN_VAL_6 field.
	XCVR_RX_DIG_LNA_GAIN_VAL_7_4_LNA_GAIN_VAL_6_Pos = 0x10
	// Bit mask of LNA_GAIN_VAL_6 field.
	XCVR_RX_DIG_LNA_GAIN_VAL_7_4_LNA_GAIN_VAL_6_Msk = 0xff0000
	// Position of LNA_GAIN_VAL_7 field.
	XCVR_RX_DIG_LNA_GAIN_VAL_7_4_LNA_GAIN_VAL_7_Pos = 0x18
	// Bit mask of LNA_GAIN_VAL_7 field.
	XCVR_RX_DIG_LNA_GAIN_VAL_7_4_LNA_GAIN_VAL_7_Msk = 0xff000000

	// LNA_GAIN_VAL_8: LNA_GAIN Step Values 8
	// Position of LNA_GAIN_VAL_8 field.
	XCVR_RX_DIG_LNA_GAIN_VAL_8_LNA_GAIN_VAL_8_Pos = 0x0
	// Bit mask of LNA_GAIN_VAL_8 field.
	XCVR_RX_DIG_LNA_GAIN_VAL_8_LNA_GAIN_VAL_8_Msk = 0xff
	// Position of LNA_GAIN_VAL_9 field.
	XCVR_RX_DIG_LNA_GAIN_VAL_8_LNA_GAIN_VAL_9_Pos = 0x8
	// Bit mask of LNA_GAIN_VAL_9 field.
	XCVR_RX_DIG_LNA_GAIN_VAL_8_LNA_GAIN_VAL_9_Msk = 0xff00

	// BBA_RES_TUNE_VAL_7_0: BBA Resistor Tune Values 7..0
	// Position of BBA_RES_TUNE_VAL_0 field.
	XCVR_RX_DIG_BBA_RES_TUNE_VAL_7_0_BBA_RES_TUNE_VAL_0_Pos = 0x0
	// Bit mask of BBA_RES_TUNE_VAL_0 field.
	XCVR_RX_DIG_BBA_RES_TUNE_VAL_7_0_BBA_RES_TUNE_VAL_0_Msk = 0xf
	// Position of BBA_RES_TUNE_VAL_1 field.
	XCVR_RX_DIG_BBA_RES_TUNE_VAL_7_0_BBA_RES_TUNE_VAL_1_Pos = 0x4
	// Bit mask of BBA_RES_TUNE_VAL_1 field.
	XCVR_RX_DIG_BBA_RES_TUNE_VAL_7_0_BBA_RES_TUNE_VAL_1_Msk = 0xf0
	// Position of BBA_RES_TUNE_VAL_2 field.
	XCVR_RX_DIG_BBA_RES_TUNE_VAL_7_0_BBA_RES_TUNE_VAL_2_Pos = 0x8
	// Bit mask of BBA_RES_TUNE_VAL_2 field.
	XCVR_RX_DIG_BBA_RES_TUNE_VAL_7_0_BBA_RES_TUNE_VAL_2_Msk = 0xf00
	// Position of BBA_RES_TUNE_VAL_3 field.
	XCVR_RX_DIG_BBA_RES_TUNE_VAL_7_0_BBA_RES_TUNE_VAL_3_Pos = 0xc
	// Bit mask of BBA_RES_TUNE_VAL_3 field.
	XCVR_RX_DIG_BBA_RES_TUNE_VAL_7_0_BBA_RES_TUNE_VAL_3_Msk = 0xf000
	// Position of BBA_RES_TUNE_VAL_4 field.
	XCVR_RX_DIG_BBA_RES_TUNE_VAL_7_0_BBA_RES_TUNE_VAL_4_Pos = 0x10
	// Bit mask of BBA_RES_TUNE_VAL_4 field.
	XCVR_RX_DIG_BBA_RES_TUNE_VAL_7_0_BBA_RES_TUNE_VAL_4_Msk = 0xf0000
	// Position of BBA_RES_TUNE_VAL_5 field.
	XCVR_RX_DIG_BBA_RES_TUNE_VAL_7_0_BBA_RES_TUNE_VAL_5_Pos = 0x14
	// Bit mask of BBA_RES_TUNE_VAL_5 field.
	XCVR_RX_DIG_BBA_RES_TUNE_VAL_7_0_BBA_RES_TUNE_VAL_5_Msk = 0xf00000
	// Position of BBA_RES_TUNE_VAL_6 field.
	XCVR_RX_DIG_BBA_RES_TUNE_VAL_7_0_BBA_RES_TUNE_VAL_6_Pos = 0x18
	// Bit mask of BBA_RES_TUNE_VAL_6 field.
	XCVR_RX_DIG_BBA_RES_TUNE_VAL_7_0_BBA_RES_TUNE_VAL_6_Msk = 0xf000000
	// Position of BBA_RES_TUNE_VAL_7 field.
	XCVR_RX_DIG_BBA_RES_TUNE_VAL_7_0_BBA_RES_TUNE_VAL_7_Pos = 0x1c
	// Bit mask of BBA_RES_TUNE_VAL_7 field.
	XCVR_RX_DIG_BBA_RES_TUNE_VAL_7_0_BBA_RES_TUNE_VAL_7_Msk = 0xf0000000

	// BBA_RES_TUNE_VAL_10_8: BBA Resistor Tune Values 10..8
	// Position of BBA_RES_TUNE_VAL_8 field.
	XCVR_RX_DIG_BBA_RES_TUNE_VAL_10_8_BBA_RES_TUNE_VAL_8_Pos = 0x0
	// Bit mask of BBA_RES_TUNE_VAL_8 field.
	XCVR_RX_DIG_BBA_RES_TUNE_VAL_10_8_BBA_RES_TUNE_VAL_8_Msk = 0xf
	// Position of BBA_RES_TUNE_VAL_9 field.
	XCVR_RX_DIG_BBA_RES_TUNE_VAL_10_8_BBA_RES_TUNE_VAL_9_Pos = 0x4
	// Bit mask of BBA_RES_TUNE_VAL_9 field.
	XCVR_RX_DIG_BBA_RES_TUNE_VAL_10_8_BBA_RES_TUNE_VAL_9_Msk = 0xf0
	// Position of BBA_RES_TUNE_VAL_10 field.
	XCVR_RX_DIG_BBA_RES_TUNE_VAL_10_8_BBA_RES_TUNE_VAL_10_Pos = 0x8
	// Bit mask of BBA_RES_TUNE_VAL_10 field.
	XCVR_RX_DIG_BBA_RES_TUNE_VAL_10_8_BBA_RES_TUNE_VAL_10_Msk = 0xf00

	// LNA_GAIN_LIN_VAL_2_0: LNA Linear Gain Values 2..0
	// Position of LNA_GAIN_LIN_VAL_0 field.
	XCVR_RX_DIG_LNA_GAIN_LIN_VAL_2_0_LNA_GAIN_LIN_VAL_0_Pos = 0x0
	// Bit mask of LNA_GAIN_LIN_VAL_0 field.
	XCVR_RX_DIG_LNA_GAIN_LIN_VAL_2_0_LNA_GAIN_LIN_VAL_0_Msk = 0x3ff
	// Position of LNA_GAIN_LIN_VAL_1 field.
	XCVR_RX_DIG_LNA_GAIN_LIN_VAL_2_0_LNA_GAIN_LIN_VAL_1_Pos = 0xa
	// Bit mask of LNA_GAIN_LIN_VAL_1 field.
	XCVR_RX_DIG_LNA_GAIN_LIN_VAL_2_0_LNA_GAIN_LIN_VAL_1_Msk = 0xffc00
	// Position of LNA_GAIN_LIN_VAL_2 field.
	XCVR_RX_DIG_LNA_GAIN_LIN_VAL_2_0_LNA_GAIN_LIN_VAL_2_Pos = 0x14
	// Bit mask of LNA_GAIN_LIN_VAL_2 field.
	XCVR_RX_DIG_LNA_GAIN_LIN_VAL_2_0_LNA_GAIN_LIN_VAL_2_Msk = 0x3ff00000

	// LNA_GAIN_LIN_VAL_5_3: LNA Linear Gain Values 5..3
	// Position of LNA_GAIN_LIN_VAL_3 field.
	XCVR_RX_DIG_LNA_GAIN_LIN_VAL_5_3_LNA_GAIN_LIN_VAL_3_Pos = 0x0
	// Bit mask of LNA_GAIN_LIN_VAL_3 field.
	XCVR_RX_DIG_LNA_GAIN_LIN_VAL_5_3_LNA_GAIN_LIN_VAL_3_Msk = 0x3ff
	// Position of LNA_GAIN_LIN_VAL_4 field.
	XCVR_RX_DIG_LNA_GAIN_LIN_VAL_5_3_LNA_GAIN_LIN_VAL_4_Pos = 0xa
	// Bit mask of LNA_GAIN_LIN_VAL_4 field.
	XCVR_RX_DIG_LNA_GAIN_LIN_VAL_5_3_LNA_GAIN_LIN_VAL_4_Msk = 0xffc00
	// Position of LNA_GAIN_LIN_VAL_5 field.
	XCVR_RX_DIG_LNA_GAIN_LIN_VAL_5_3_LNA_GAIN_LIN_VAL_5_Pos = 0x14
	// Bit mask of LNA_GAIN_LIN_VAL_5 field.
	XCVR_RX_DIG_LNA_GAIN_LIN_VAL_5_3_LNA_GAIN_LIN_VAL_5_Msk = 0x3ff00000

	// LNA_GAIN_LIN_VAL_8_6: LNA Linear Gain Values 8..6
	// Position of LNA_GAIN_LIN_VAL_6 field.
	XCVR_RX_DIG_LNA_GAIN_LIN_VAL_8_6_LNA_GAIN_LIN_VAL_6_Pos = 0x0
	// Bit mask of LNA_GAIN_LIN_VAL_6 field.
	XCVR_RX_DIG_LNA_GAIN_LIN_VAL_8_6_LNA_GAIN_LIN_VAL_6_Msk = 0x3ff
	// Position of LNA_GAIN_LIN_VAL_7 field.
	XCVR_RX_DIG_LNA_GAIN_LIN_VAL_8_6_LNA_GAIN_LIN_VAL_7_Pos = 0xa
	// Bit mask of LNA_GAIN_LIN_VAL_7 field.
	XCVR_RX_DIG_LNA_GAIN_LIN_VAL_8_6_LNA_GAIN_LIN_VAL_7_Msk = 0xffc00
	// Position of LNA_GAIN_LIN_VAL_8 field.
	XCVR_RX_DIG_LNA_GAIN_LIN_VAL_8_6_LNA_GAIN_LIN_VAL_8_Pos = 0x14
	// Bit mask of LNA_GAIN_LIN_VAL_8 field.
	XCVR_RX_DIG_LNA_GAIN_LIN_VAL_8_6_LNA_GAIN_LIN_VAL_8_Msk = 0x3ff00000

	// LNA_GAIN_LIN_VAL_9: LNA Linear Gain Values 9
	// Position of LNA_GAIN_LIN_VAL_9 field.
	XCVR_RX_DIG_LNA_GAIN_LIN_VAL_9_LNA_GAIN_LIN_VAL_9_Pos = 0x0
	// Bit mask of LNA_GAIN_LIN_VAL_9 field.
	XCVR_RX_DIG_LNA_GAIN_LIN_VAL_9_LNA_GAIN_LIN_VAL_9_Msk = 0x3ff

	// BBA_RES_TUNE_LIN_VAL_3_0: BBA Resistor Tune Values 3..0
	// Position of BBA_RES_TUNE_LIN_VAL_0 field.
	XCVR_RX_DIG_BBA_RES_TUNE_LIN_VAL_3_0_BBA_RES_TUNE_LIN_VAL_0_Pos = 0x0
	// Bit mask of BBA_RES_TUNE_LIN_VAL_0 field.
	XCVR_RX_DIG_BBA_RES_TUNE_LIN_VAL_3_0_BBA_RES_TUNE_LIN_VAL_0_Msk = 0xff
	// Position of BBA_RES_TUNE_LIN_VAL_1 field.
	XCVR_RX_DIG_BBA_RES_TUNE_LIN_VAL_3_0_BBA_RES_TUNE_LIN_VAL_1_Pos = 0x8
	// Bit mask of BBA_RES_TUNE_LIN_VAL_1 field.
	XCVR_RX_DIG_BBA_RES_TUNE_LIN_VAL_3_0_BBA_RES_TUNE_LIN_VAL_1_Msk = 0xff00
	// Position of BBA_RES_TUNE_LIN_VAL_2 field.
	XCVR_RX_DIG_BBA_RES_TUNE_LIN_VAL_3_0_BBA_RES_TUNE_LIN_VAL_2_Pos = 0x10
	// Bit mask of BBA_RES_TUNE_LIN_VAL_2 field.
	XCVR_RX_DIG_BBA_RES_TUNE_LIN_VAL_3_0_BBA_RES_TUNE_LIN_VAL_2_Msk = 0xff0000
	// Position of BBA_RES_TUNE_LIN_VAL_3 field.
	XCVR_RX_DIG_BBA_RES_TUNE_LIN_VAL_3_0_BBA_RES_TUNE_LIN_VAL_3_Pos = 0x18
	// Bit mask of BBA_RES_TUNE_LIN_VAL_3 field.
	XCVR_RX_DIG_BBA_RES_TUNE_LIN_VAL_3_0_BBA_RES_TUNE_LIN_VAL_3_Msk = 0xff000000

	// BBA_RES_TUNE_LIN_VAL_7_4: BBA Resistor Tune Values 7..4
	// Position of BBA_RES_TUNE_LIN_VAL_4 field.
	XCVR_RX_DIG_BBA_RES_TUNE_LIN_VAL_7_4_BBA_RES_TUNE_LIN_VAL_4_Pos = 0x0
	// Bit mask of BBA_RES_TUNE_LIN_VAL_4 field.
	XCVR_RX_DIG_BBA_RES_TUNE_LIN_VAL_7_4_BBA_RES_TUNE_LIN_VAL_4_Msk = 0xff
	// Position of BBA_RES_TUNE_LIN_VAL_5 field.
	XCVR_RX_DIG_BBA_RES_TUNE_LIN_VAL_7_4_BBA_RES_TUNE_LIN_VAL_5_Pos = 0x8
	// Bit mask of BBA_RES_TUNE_LIN_VAL_5 field.
	XCVR_RX_DIG_BBA_RES_TUNE_LIN_VAL_7_4_BBA_RES_TUNE_LIN_VAL_5_Msk = 0xff00
	// Position of BBA_RES_TUNE_LIN_VAL_6 field.
	XCVR_RX_DIG_BBA_RES_TUNE_LIN_VAL_7_4_BBA_RES_TUNE_LIN_VAL_6_Pos = 0x10
	// Bit mask of BBA_RES_TUNE_LIN_VAL_6 field.
	XCVR_RX_DIG_BBA_RES_TUNE_LIN_VAL_7_4_BBA_RES_TUNE_LIN_VAL_6_Msk = 0xff0000
	// Position of BBA_RES_TUNE_LIN_VAL_7 field.
	XCVR_RX_DIG_BBA_RES_TUNE_LIN_VAL_7_4_BBA_RES_TUNE_LIN_VAL_7_Pos = 0x18
	// Bit mask of BBA_RES_TUNE_LIN_VAL_7 field.
	XCVR_RX_DIG_BBA_RES_TUNE_LIN_VAL_7_4_BBA_RES_TUNE_LIN_VAL_7_Msk = 0xff000000

	// BBA_RES_TUNE_LIN_VAL_10_8: BBA Resistor Tune Values 10..8
	// Position of BBA_RES_TUNE_LIN_VAL_8 field.
	XCVR_RX_DIG_BBA_RES_TUNE_LIN_VAL_10_8_BBA_RES_TUNE_LIN_VAL_8_Pos = 0x0
	// Bit mask of BBA_RES_TUNE_LIN_VAL_8 field.
	XCVR_RX_DIG_BBA_RES_TUNE_LIN_VAL_10_8_BBA_RES_TUNE_LIN_VAL_8_Msk = 0x3ff
	// Position of BBA_RES_TUNE_LIN_VAL_9 field.
	XCVR_RX_DIG_BBA_RES_TUNE_LIN_VAL_10_8_BBA_RES_TUNE_LIN_VAL_9_Pos = 0xa
	// Bit mask of BBA_RES_TUNE_LIN_VAL_9 field.
	XCVR_RX_DIG_BBA_RES_TUNE_LIN_VAL_10_8_BBA_RES_TUNE_LIN_VAL_9_Msk = 0xffc00
	// Position of BBA_RES_TUNE_LIN_VAL_10 field.
	XCVR_RX_DIG_BBA_RES_TUNE_LIN_VAL_10_8_BBA_RES_TUNE_LIN_VAL_10_Pos = 0x14
	// Bit mask of BBA_RES_TUNE_LIN_VAL_10 field.
	XCVR_RX_DIG_BBA_RES_TUNE_LIN_VAL_10_8_BBA_RES_TUNE_LIN_VAL_10_Msk = 0x3ff00000

	// AGC_GAIN_TBL_03_00: AGC Gain Tables Step 03..00
	// Position of BBA_GAIN_00 field.
	XCVR_RX_DIG_AGC_GAIN_TBL_03_00_BBA_GAIN_00_Pos = 0x0
	// Bit mask of BBA_GAIN_00 field.
	XCVR_RX_DIG_AGC_GAIN_TBL_03_00_BBA_GAIN_00_Msk = 0xf
	// Position of LNA_GAIN_00 field.
	XCVR_RX_DIG_AGC_GAIN_TBL_03_00_LNA_GAIN_00_Pos = 0x4
	// Bit mask of LNA_GAIN_00 field.
	XCVR_RX_DIG_AGC_GAIN_TBL_03_00_LNA_GAIN_00_Msk = 0xf0
	// Position of BBA_GAIN_01 field.
	XCVR_RX_DIG_AGC_GAIN_TBL_03_00_BBA_GAIN_01_Pos = 0x8
	// Bit mask of BBA_GAIN_01 field.
	XCVR_RX_DIG_AGC_GAIN_TBL_03_00_BBA_GAIN_01_Msk = 0xf00
	// Position of LNA_GAIN_01 field.
	XCVR_RX_DIG_AGC_GAIN_TBL_03_00_LNA_GAIN_01_Pos = 0xc
	// Bit mask of LNA_GAIN_01 field.
	XCVR_RX_DIG_AGC_GAIN_TBL_03_00_LNA_GAIN_01_Msk = 0xf000
	// Position of BBA_GAIN_02 field.
	XCVR_RX_DIG_AGC_GAIN_TBL_03_00_BBA_GAIN_02_Pos = 0x10
	// Bit mask of BBA_GAIN_02 field.
	XCVR_RX_DIG_AGC_GAIN_TBL_03_00_BBA_GAIN_02_Msk = 0xf0000
	// Position of LNA_GAIN_02 field.
	XCVR_RX_DIG_AGC_GAIN_TBL_03_00_LNA_GAIN_02_Pos = 0x14
	// Bit mask of LNA_GAIN_02 field.
	XCVR_RX_DIG_AGC_GAIN_TBL_03_00_LNA_GAIN_02_Msk = 0xf00000
	// Position of BBA_GAIN_03 field.
	XCVR_RX_DIG_AGC_GAIN_TBL_03_00_BBA_GAIN_03_Pos = 0x18
	// Bit mask of BBA_GAIN_03 field.
	XCVR_RX_DIG_AGC_GAIN_TBL_03_00_BBA_GAIN_03_Msk = 0xf000000
	// Position of LNA_GAIN_03 field.
	XCVR_RX_DIG_AGC_GAIN_TBL_03_00_LNA_GAIN_03_Pos = 0x1c
	// Bit mask of LNA_GAIN_03 field.
	XCVR_RX_DIG_AGC_GAIN_TBL_03_00_LNA_GAIN_03_Msk = 0xf0000000

	// AGC_GAIN_TBL_07_04: AGC Gain Tables Step 07..04
	// Position of BBA_GAIN_04 field.
	XCVR_RX_DIG_AGC_GAIN_TBL_07_04_BBA_GAIN_04_Pos = 0x0
	// Bit mask of BBA_GAIN_04 field.
	XCVR_RX_DIG_AGC_GAIN_TBL_07_04_BBA_GAIN_04_Msk = 0xf
	// Position of LNA_GAIN_04 field.
	XCVR_RX_DIG_AGC_GAIN_TBL_07_04_LNA_GAIN_04_Pos = 0x4
	// Bit mask of LNA_GAIN_04 field.
	XCVR_RX_DIG_AGC_GAIN_TBL_07_04_LNA_GAIN_04_Msk = 0xf0
	// Position of BBA_GAIN_05 field.
	XCVR_RX_DIG_AGC_GAIN_TBL_07_04_BBA_GAIN_05_Pos = 0x8
	// Bit mask of BBA_GAIN_05 field.
	XCVR_RX_DIG_AGC_GAIN_TBL_07_04_BBA_GAIN_05_Msk = 0xf00
	// Position of LNA_GAIN_05 field.
	XCVR_RX_DIG_AGC_GAIN_TBL_07_04_LNA_GAIN_05_Pos = 0xc
	// Bit mask of LNA_GAIN_05 field.
	XCVR_RX_DIG_AGC_GAIN_TBL_07_04_LNA_GAIN_05_Msk = 0xf000
	// Position of BBA_GAIN_06 field.
	XCVR_RX_DIG_AGC_GAIN_TBL_07_04_BBA_GAIN_06_Pos = 0x10
	// Bit mask of BBA_GAIN_06 field.
	XCVR_RX_DIG_AGC_GAIN_TBL_07_04_BBA_GAIN_06_Msk = 0xf0000
	// Position of LNA_GAIN_06 field.
	XCVR_RX_DIG_AGC_GAIN_TBL_07_04_LNA_GAIN_06_Pos = 0x14
	// Bit mask of LNA_GAIN_06 field.
	XCVR_RX_DIG_AGC_GAIN_TBL_07_04_LNA_GAIN_06_Msk = 0xf00000
	// Position of BBA_GAIN_07 field.
	XCVR_RX_DIG_AGC_GAIN_TBL_07_04_BBA_GAIN_07_Pos = 0x18
	// Bit mask of BBA_GAIN_07 field.
	XCVR_RX_DIG_AGC_GAIN_TBL_07_04_BBA_GAIN_07_Msk = 0xf000000
	// Position of LNA_GAIN_07 field.
	XCVR_RX_DIG_AGC_GAIN_TBL_07_04_LNA_GAIN_07_Pos = 0x1c
	// Bit mask of LNA_GAIN_07 field.
	XCVR_RX_DIG_AGC_GAIN_TBL_07_04_LNA_GAIN_07_Msk = 0xf0000000

	// AGC_GAIN_TBL_11_08: AGC Gain Tables Step 11..08
	// Position of BBA_GAIN_08 field.
	XCVR_RX_DIG_AGC_GAIN_TBL_11_08_BBA_GAIN_08_Pos = 0x0
	// Bit mask of BBA_GAIN_08 field.
	XCVR_RX_DIG_AGC_GAIN_TBL_11_08_BBA_GAIN_08_Msk = 0xf
	// Position of LNA_GAIN_08 field.
	XCVR_RX_DIG_AGC_GAIN_TBL_11_08_LNA_GAIN_08_Pos = 0x4
	// Bit mask of LNA_GAIN_08 field.
	XCVR_RX_DIG_AGC_GAIN_TBL_11_08_LNA_GAIN_08_Msk = 0xf0
	// Position of BBA_GAIN_09 field.
	XCVR_RX_DIG_AGC_GAIN_TBL_11_08_BBA_GAIN_09_Pos = 0x8
	// Bit mask of BBA_GAIN_09 field.
	XCVR_RX_DIG_AGC_GAIN_TBL_11_08_BBA_GAIN_09_Msk = 0xf00
	// Position of LNA_GAIN_09 field.
	XCVR_RX_DIG_AGC_GAIN_TBL_11_08_LNA_GAIN_09_Pos = 0xc
	// Bit mask of LNA_GAIN_09 field.
	XCVR_RX_DIG_AGC_GAIN_TBL_11_08_LNA_GAIN_09_Msk = 0xf000
	// Position of BBA_GAIN_10 field.
	XCVR_RX_DIG_AGC_GAIN_TBL_11_08_BBA_GAIN_10_Pos = 0x10
	// Bit mask of BBA_GAIN_10 field.
	XCVR_RX_DIG_AGC_GAIN_TBL_11_08_BBA_GAIN_10_Msk = 0xf0000
	// Position of LNA_GAIN_10 field.
	XCVR_RX_DIG_AGC_GAIN_TBL_11_08_LNA_GAIN_10_Pos = 0x14
	// Bit mask of LNA_GAIN_10 field.
	XCVR_RX_DIG_AGC_GAIN_TBL_11_08_LNA_GAIN_10_Msk = 0xf00000
	// Position of BBA_GAIN_11 field.
	XCVR_RX_DIG_AGC_GAIN_TBL_11_08_BBA_GAIN_11_Pos = 0x18
	// Bit mask of BBA_GAIN_11 field.
	XCVR_RX_DIG_AGC_GAIN_TBL_11_08_BBA_GAIN_11_Msk = 0xf000000
	// Position of LNA_GAIN_11 field.
	XCVR_RX_DIG_AGC_GAIN_TBL_11_08_LNA_GAIN_11_Pos = 0x1c
	// Bit mask of LNA_GAIN_11 field.
	XCVR_RX_DIG_AGC_GAIN_TBL_11_08_LNA_GAIN_11_Msk = 0xf0000000

	// AGC_GAIN_TBL_15_12: AGC Gain Tables Step 15..12
	// Position of BBA_GAIN_12 field.
	XCVR_RX_DIG_AGC_GAIN_TBL_15_12_BBA_GAIN_12_Pos = 0x0
	// Bit mask of BBA_GAIN_12 field.
	XCVR_RX_DIG_AGC_GAIN_TBL_15_12_BBA_GAIN_12_Msk = 0xf
	// Position of LNA_GAIN_12 field.
	XCVR_RX_DIG_AGC_GAIN_TBL_15_12_LNA_GAIN_12_Pos = 0x4
	// Bit mask of LNA_GAIN_12 field.
	XCVR_RX_DIG_AGC_GAIN_TBL_15_12_LNA_GAIN_12_Msk = 0xf0
	// Position of BBA_GAIN_13 field.
	XCVR_RX_DIG_AGC_GAIN_TBL_15_12_BBA_GAIN_13_Pos = 0x8
	// Bit mask of BBA_GAIN_13 field.
	XCVR_RX_DIG_AGC_GAIN_TBL_15_12_BBA_GAIN_13_Msk = 0xf00
	// Position of LNA_GAIN_13 field.
	XCVR_RX_DIG_AGC_GAIN_TBL_15_12_LNA_GAIN_13_Pos = 0xc
	// Bit mask of LNA_GAIN_13 field.
	XCVR_RX_DIG_AGC_GAIN_TBL_15_12_LNA_GAIN_13_Msk = 0xf000
	// Position of BBA_GAIN_14 field.
	XCVR_RX_DIG_AGC_GAIN_TBL_15_12_BBA_GAIN_14_Pos = 0x10
	// Bit mask of BBA_GAIN_14 field.
	XCVR_RX_DIG_AGC_GAIN_TBL_15_12_BBA_GAIN_14_Msk = 0xf0000
	// Position of LNA_GAIN_14 field.
	XCVR_RX_DIG_AGC_GAIN_TBL_15_12_LNA_GAIN_14_Pos = 0x14
	// Bit mask of LNA_GAIN_14 field.
	XCVR_RX_DIG_AGC_GAIN_TBL_15_12_LNA_GAIN_14_Msk = 0xf00000
	// Position of BBA_GAIN_15 field.
	XCVR_RX_DIG_AGC_GAIN_TBL_15_12_BBA_GAIN_15_Pos = 0x18
	// Bit mask of BBA_GAIN_15 field.
	XCVR_RX_DIG_AGC_GAIN_TBL_15_12_BBA_GAIN_15_Msk = 0xf000000
	// Position of LNA_GAIN_15 field.
	XCVR_RX_DIG_AGC_GAIN_TBL_15_12_LNA_GAIN_15_Pos = 0x1c
	// Bit mask of LNA_GAIN_15 field.
	XCVR_RX_DIG_AGC_GAIN_TBL_15_12_LNA_GAIN_15_Msk = 0xf0000000

	// AGC_GAIN_TBL_19_16: AGC Gain Tables Step 19..16
	// Position of BBA_GAIN_16 field.
	XCVR_RX_DIG_AGC_GAIN_TBL_19_16_BBA_GAIN_16_Pos = 0x0
	// Bit mask of BBA_GAIN_16 field.
	XCVR_RX_DIG_AGC_GAIN_TBL_19_16_BBA_GAIN_16_Msk = 0xf
	// Position of LNA_GAIN_16 field.
	XCVR_RX_DIG_AGC_GAIN_TBL_19_16_LNA_GAIN_16_Pos = 0x4
	// Bit mask of LNA_GAIN_16 field.
	XCVR_RX_DIG_AGC_GAIN_TBL_19_16_LNA_GAIN_16_Msk = 0xf0
	// Position of BBA_GAIN_17 field.
	XCVR_RX_DIG_AGC_GAIN_TBL_19_16_BBA_GAIN_17_Pos = 0x8
	// Bit mask of BBA_GAIN_17 field.
	XCVR_RX_DIG_AGC_GAIN_TBL_19_16_BBA_GAIN_17_Msk = 0xf00
	// Position of LNA_GAIN_17 field.
	XCVR_RX_DIG_AGC_GAIN_TBL_19_16_LNA_GAIN_17_Pos = 0xc
	// Bit mask of LNA_GAIN_17 field.
	XCVR_RX_DIG_AGC_GAIN_TBL_19_16_LNA_GAIN_17_Msk = 0xf000
	// Position of BBA_GAIN_18 field.
	XCVR_RX_DIG_AGC_GAIN_TBL_19_16_BBA_GAIN_18_Pos = 0x10
	// Bit mask of BBA_GAIN_18 field.
	XCVR_RX_DIG_AGC_GAIN_TBL_19_16_BBA_GAIN_18_Msk = 0xf0000
	// Position of LNA_GAIN_18 field.
	XCVR_RX_DIG_AGC_GAIN_TBL_19_16_LNA_GAIN_18_Pos = 0x14
	// Bit mask of LNA_GAIN_18 field.
	XCVR_RX_DIG_AGC_GAIN_TBL_19_16_LNA_GAIN_18_Msk = 0xf00000
	// Position of BBA_GAIN_19 field.
	XCVR_RX_DIG_AGC_GAIN_TBL_19_16_BBA_GAIN_19_Pos = 0x18
	// Bit mask of BBA_GAIN_19 field.
	XCVR_RX_DIG_AGC_GAIN_TBL_19_16_BBA_GAIN_19_Msk = 0xf000000
	// Position of LNA_GAIN_19 field.
	XCVR_RX_DIG_AGC_GAIN_TBL_19_16_LNA_GAIN_19_Pos = 0x1c
	// Bit mask of LNA_GAIN_19 field.
	XCVR_RX_DIG_AGC_GAIN_TBL_19_16_LNA_GAIN_19_Msk = 0xf0000000

	// AGC_GAIN_TBL_23_20: AGC Gain Tables Step 23..20
	// Position of BBA_GAIN_20 field.
	XCVR_RX_DIG_AGC_GAIN_TBL_23_20_BBA_GAIN_20_Pos = 0x0
	// Bit mask of BBA_GAIN_20 field.
	XCVR_RX_DIG_AGC_GAIN_TBL_23_20_BBA_GAIN_20_Msk = 0xf
	// Position of LNA_GAIN_20 field.
	XCVR_RX_DIG_AGC_GAIN_TBL_23_20_LNA_GAIN_20_Pos = 0x4
	// Bit mask of LNA_GAIN_20 field.
	XCVR_RX_DIG_AGC_GAIN_TBL_23_20_LNA_GAIN_20_Msk = 0xf0
	// Position of BBA_GAIN_21 field.
	XCVR_RX_DIG_AGC_GAIN_TBL_23_20_BBA_GAIN_21_Pos = 0x8
	// Bit mask of BBA_GAIN_21 field.
	XCVR_RX_DIG_AGC_GAIN_TBL_23_20_BBA_GAIN_21_Msk = 0xf00
	// Position of LNA_GAIN_21 field.
	XCVR_RX_DIG_AGC_GAIN_TBL_23_20_LNA_GAIN_21_Pos = 0xc
	// Bit mask of LNA_GAIN_21 field.
	XCVR_RX_DIG_AGC_GAIN_TBL_23_20_LNA_GAIN_21_Msk = 0xf000
	// Position of BBA_GAIN_22 field.
	XCVR_RX_DIG_AGC_GAIN_TBL_23_20_BBA_GAIN_22_Pos = 0x10
	// Bit mask of BBA_GAIN_22 field.
	XCVR_RX_DIG_AGC_GAIN_TBL_23_20_BBA_GAIN_22_Msk = 0xf0000
	// Position of LNA_GAIN_22 field.
	XCVR_RX_DIG_AGC_GAIN_TBL_23_20_LNA_GAIN_22_Pos = 0x14
	// Bit mask of LNA_GAIN_22 field.
	XCVR_RX_DIG_AGC_GAIN_TBL_23_20_LNA_GAIN_22_Msk = 0xf00000
	// Position of BBA_GAIN_23 field.
	XCVR_RX_DIG_AGC_GAIN_TBL_23_20_BBA_GAIN_23_Pos = 0x18
	// Bit mask of BBA_GAIN_23 field.
	XCVR_RX_DIG_AGC_GAIN_TBL_23_20_BBA_GAIN_23_Msk = 0xf000000
	// Position of LNA_GAIN_23 field.
	XCVR_RX_DIG_AGC_GAIN_TBL_23_20_LNA_GAIN_23_Pos = 0x1c
	// Bit mask of LNA_GAIN_23 field.
	XCVR_RX_DIG_AGC_GAIN_TBL_23_20_LNA_GAIN_23_Msk = 0xf0000000

	// AGC_GAIN_TBL_26_24: AGC Gain Tables Step 26..24
	// Position of BBA_GAIN_24 field.
	XCVR_RX_DIG_AGC_GAIN_TBL_26_24_BBA_GAIN_24_Pos = 0x0
	// Bit mask of BBA_GAIN_24 field.
	XCVR_RX_DIG_AGC_GAIN_TBL_26_24_BBA_GAIN_24_Msk = 0xf
	// Position of LNA_GAIN_24 field.
	XCVR_RX_DIG_AGC_GAIN_TBL_26_24_LNA_GAIN_24_Pos = 0x4
	// Bit mask of LNA_GAIN_24 field.
	XCVR_RX_DIG_AGC_GAIN_TBL_26_24_LNA_GAIN_24_Msk = 0xf0
	// Position of BBA_GAIN_25 field.
	XCVR_RX_DIG_AGC_GAIN_TBL_26_24_BBA_GAIN_25_Pos = 0x8
	// Bit mask of BBA_GAIN_25 field.
	XCVR_RX_DIG_AGC_GAIN_TBL_26_24_BBA_GAIN_25_Msk = 0xf00
	// Position of LNA_GAIN_25 field.
	XCVR_RX_DIG_AGC_GAIN_TBL_26_24_LNA_GAIN_25_Pos = 0xc
	// Bit mask of LNA_GAIN_25 field.
	XCVR_RX_DIG_AGC_GAIN_TBL_26_24_LNA_GAIN_25_Msk = 0xf000
	// Position of BBA_GAIN_26 field.
	XCVR_RX_DIG_AGC_GAIN_TBL_26_24_BBA_GAIN_26_Pos = 0x10
	// Bit mask of BBA_GAIN_26 field.
	XCVR_RX_DIG_AGC_GAIN_TBL_26_24_BBA_GAIN_26_Msk = 0xf0000
	// Position of LNA_GAIN_26 field.
	XCVR_RX_DIG_AGC_GAIN_TBL_26_24_LNA_GAIN_26_Pos = 0x14
	// Bit mask of LNA_GAIN_26 field.
	XCVR_RX_DIG_AGC_GAIN_TBL_26_24_LNA_GAIN_26_Msk = 0xf00000

	// DCOC_OFFSET_0: DCOC Offset
	// Position of DCOC_BBA_OFFSET_I field.
	XCVR_RX_DIG_DCOC_OFFSET_0_DCOC_BBA_OFFSET_I_Pos = 0x0
	// Bit mask of DCOC_BBA_OFFSET_I field.
	XCVR_RX_DIG_DCOC_OFFSET_0_DCOC_BBA_OFFSET_I_Msk = 0x3f
	// Position of DCOC_BBA_OFFSET_Q field.
	XCVR_RX_DIG_DCOC_OFFSET_0_DCOC_BBA_OFFSET_Q_Pos = 0x8
	// Bit mask of DCOC_BBA_OFFSET_Q field.
	XCVR_RX_DIG_DCOC_OFFSET_0_DCOC_BBA_OFFSET_Q_Msk = 0x3f00
	// Position of DCOC_TZA_OFFSET_I field.
	XCVR_RX_DIG_DCOC_OFFSET_0_DCOC_TZA_OFFSET_I_Pos = 0x10
	// Bit mask of DCOC_TZA_OFFSET_I field.
	XCVR_RX_DIG_DCOC_OFFSET_0_DCOC_TZA_OFFSET_I_Msk = 0xff0000
	// Position of DCOC_TZA_OFFSET_Q field.
	XCVR_RX_DIG_DCOC_OFFSET_0_DCOC_TZA_OFFSET_Q_Pos = 0x18
	// Bit mask of DCOC_TZA_OFFSET_Q field.
	XCVR_RX_DIG_DCOC_OFFSET_0_DCOC_TZA_OFFSET_Q_Msk = 0xff000000

	// DCOC_OFFSET_1: DCOC Offset
	// Position of DCOC_BBA_OFFSET_I field.
	XCVR_RX_DIG_DCOC_OFFSET_1_DCOC_BBA_OFFSET_I_Pos = 0x0
	// Bit mask of DCOC_BBA_OFFSET_I field.
	XCVR_RX_DIG_DCOC_OFFSET_1_DCOC_BBA_OFFSET_I_Msk = 0x3f
	// Position of DCOC_BBA_OFFSET_Q field.
	XCVR_RX_DIG_DCOC_OFFSET_1_DCOC_BBA_OFFSET_Q_Pos = 0x8
	// Bit mask of DCOC_BBA_OFFSET_Q field.
	XCVR_RX_DIG_DCOC_OFFSET_1_DCOC_BBA_OFFSET_Q_Msk = 0x3f00
	// Position of DCOC_TZA_OFFSET_I field.
	XCVR_RX_DIG_DCOC_OFFSET_1_DCOC_TZA_OFFSET_I_Pos = 0x10
	// Bit mask of DCOC_TZA_OFFSET_I field.
	XCVR_RX_DIG_DCOC_OFFSET_1_DCOC_TZA_OFFSET_I_Msk = 0xff0000
	// Position of DCOC_TZA_OFFSET_Q field.
	XCVR_RX_DIG_DCOC_OFFSET_1_DCOC_TZA_OFFSET_Q_Pos = 0x18
	// Bit mask of DCOC_TZA_OFFSET_Q field.
	XCVR_RX_DIG_DCOC_OFFSET_1_DCOC_TZA_OFFSET_Q_Msk = 0xff000000

	// DCOC_OFFSET_2: DCOC Offset
	// Position of DCOC_BBA_OFFSET_I field.
	XCVR_RX_DIG_DCOC_OFFSET_2_DCOC_BBA_OFFSET_I_Pos = 0x0
	// Bit mask of DCOC_BBA_OFFSET_I field.
	XCVR_RX_DIG_DCOC_OFFSET_2_DCOC_BBA_OFFSET_I_Msk = 0x3f
	// Position of DCOC_BBA_OFFSET_Q field.
	XCVR_RX_DIG_DCOC_OFFSET_2_DCOC_BBA_OFFSET_Q_Pos = 0x8
	// Bit mask of DCOC_BBA_OFFSET_Q field.
	XCVR_RX_DIG_DCOC_OFFSET_2_DCOC_BBA_OFFSET_Q_Msk = 0x3f00
	// Position of DCOC_TZA_OFFSET_I field.
	XCVR_RX_DIG_DCOC_OFFSET_2_DCOC_TZA_OFFSET_I_Pos = 0x10
	// Bit mask of DCOC_TZA_OFFSET_I field.
	XCVR_RX_DIG_DCOC_OFFSET_2_DCOC_TZA_OFFSET_I_Msk = 0xff0000
	// Position of DCOC_TZA_OFFSET_Q field.
	XCVR_RX_DIG_DCOC_OFFSET_2_DCOC_TZA_OFFSET_Q_Pos = 0x18
	// Bit mask of DCOC_TZA_OFFSET_Q field.
	XCVR_RX_DIG_DCOC_OFFSET_2_DCOC_TZA_OFFSET_Q_Msk = 0xff000000

	// DCOC_OFFSET_3: DCOC Offset
	// Position of DCOC_BBA_OFFSET_I field.
	XCVR_RX_DIG_DCOC_OFFSET_3_DCOC_BBA_OFFSET_I_Pos = 0x0
	// Bit mask of DCOC_BBA_OFFSET_I field.
	XCVR_RX_DIG_DCOC_OFFSET_3_DCOC_BBA_OFFSET_I_Msk = 0x3f
	// Position of DCOC_BBA_OFFSET_Q field.
	XCVR_RX_DIG_DCOC_OFFSET_3_DCOC_BBA_OFFSET_Q_Pos = 0x8
	// Bit mask of DCOC_BBA_OFFSET_Q field.
	XCVR_RX_DIG_DCOC_OFFSET_3_DCOC_BBA_OFFSET_Q_Msk = 0x3f00
	// Position of DCOC_TZA_OFFSET_I field.
	XCVR_RX_DIG_DCOC_OFFSET_3_DCOC_TZA_OFFSET_I_Pos = 0x10
	// Bit mask of DCOC_TZA_OFFSET_I field.
	XCVR_RX_DIG_DCOC_OFFSET_3_DCOC_TZA_OFFSET_I_Msk = 0xff0000
	// Position of DCOC_TZA_OFFSET_Q field.
	XCVR_RX_DIG_DCOC_OFFSET_3_DCOC_TZA_OFFSET_Q_Pos = 0x18
	// Bit mask of DCOC_TZA_OFFSET_Q field.
	XCVR_RX_DIG_DCOC_OFFSET_3_DCOC_TZA_OFFSET_Q_Msk = 0xff000000

	// DCOC_OFFSET_4: DCOC Offset
	// Position of DCOC_BBA_OFFSET_I field.
	XCVR_RX_DIG_DCOC_OFFSET_4_DCOC_BBA_OFFSET_I_Pos = 0x0
	// Bit mask of DCOC_BBA_OFFSET_I field.
	XCVR_RX_DIG_DCOC_OFFSET_4_DCOC_BBA_OFFSET_I_Msk = 0x3f
	// Position of DCOC_BBA_OFFSET_Q field.
	XCVR_RX_DIG_DCOC_OFFSET_4_DCOC_BBA_OFFSET_Q_Pos = 0x8
	// Bit mask of DCOC_BBA_OFFSET_Q field.
	XCVR_RX_DIG_DCOC_OFFSET_4_DCOC_BBA_OFFSET_Q_Msk = 0x3f00
	// Position of DCOC_TZA_OFFSET_I field.
	XCVR_RX_DIG_DCOC_OFFSET_4_DCOC_TZA_OFFSET_I_Pos = 0x10
	// Bit mask of DCOC_TZA_OFFSET_I field.
	XCVR_RX_DIG_DCOC_OFFSET_4_DCOC_TZA_OFFSET_I_Msk = 0xff0000
	// Position of DCOC_TZA_OFFSET_Q field.
	XCVR_RX_DIG_DCOC_OFFSET_4_DCOC_TZA_OFFSET_Q_Pos = 0x18
	// Bit mask of DCOC_TZA_OFFSET_Q field.
	XCVR_RX_DIG_DCOC_OFFSET_4_DCOC_TZA_OFFSET_Q_Msk = 0xff000000

	// DCOC_OFFSET_5: DCOC Offset
	// Position of DCOC_BBA_OFFSET_I field.
	XCVR_RX_DIG_DCOC_OFFSET_5_DCOC_BBA_OFFSET_I_Pos = 0x0
	// Bit mask of DCOC_BBA_OFFSET_I field.
	XCVR_RX_DIG_DCOC_OFFSET_5_DCOC_BBA_OFFSET_I_Msk = 0x3f
	// Position of DCOC_BBA_OFFSET_Q field.
	XCVR_RX_DIG_DCOC_OFFSET_5_DCOC_BBA_OFFSET_Q_Pos = 0x8
	// Bit mask of DCOC_BBA_OFFSET_Q field.
	XCVR_RX_DIG_DCOC_OFFSET_5_DCOC_BBA_OFFSET_Q_Msk = 0x3f00
	// Position of DCOC_TZA_OFFSET_I field.
	XCVR_RX_DIG_DCOC_OFFSET_5_DCOC_TZA_OFFSET_I_Pos = 0x10
	// Bit mask of DCOC_TZA_OFFSET_I field.
	XCVR_RX_DIG_DCOC_OFFSET_5_DCOC_TZA_OFFSET_I_Msk = 0xff0000
	// Position of DCOC_TZA_OFFSET_Q field.
	XCVR_RX_DIG_DCOC_OFFSET_5_DCOC_TZA_OFFSET_Q_Pos = 0x18
	// Bit mask of DCOC_TZA_OFFSET_Q field.
	XCVR_RX_DIG_DCOC_OFFSET_5_DCOC_TZA_OFFSET_Q_Msk = 0xff000000

	// DCOC_OFFSET_6: DCOC Offset
	// Position of DCOC_BBA_OFFSET_I field.
	XCVR_RX_DIG_DCOC_OFFSET_6_DCOC_BBA_OFFSET_I_Pos = 0x0
	// Bit mask of DCOC_BBA_OFFSET_I field.
	XCVR_RX_DIG_DCOC_OFFSET_6_DCOC_BBA_OFFSET_I_Msk = 0x3f
	// Position of DCOC_BBA_OFFSET_Q field.
	XCVR_RX_DIG_DCOC_OFFSET_6_DCOC_BBA_OFFSET_Q_Pos = 0x8
	// Bit mask of DCOC_BBA_OFFSET_Q field.
	XCVR_RX_DIG_DCOC_OFFSET_6_DCOC_BBA_OFFSET_Q_Msk = 0x3f00
	// Position of DCOC_TZA_OFFSET_I field.
	XCVR_RX_DIG_DCOC_OFFSET_6_DCOC_TZA_OFFSET_I_Pos = 0x10
	// Bit mask of DCOC_TZA_OFFSET_I field.
	XCVR_RX_DIG_DCOC_OFFSET_6_DCOC_TZA_OFFSET_I_Msk = 0xff0000
	// Position of DCOC_TZA_OFFSET_Q field.
	XCVR_RX_DIG_DCOC_OFFSET_6_DCOC_TZA_OFFSET_Q_Pos = 0x18
	// Bit mask of DCOC_TZA_OFFSET_Q field.
	XCVR_RX_DIG_DCOC_OFFSET_6_DCOC_TZA_OFFSET_Q_Msk = 0xff000000

	// DCOC_OFFSET_7: DCOC Offset
	// Position of DCOC_BBA_OFFSET_I field.
	XCVR_RX_DIG_DCOC_OFFSET_7_DCOC_BBA_OFFSET_I_Pos = 0x0
	// Bit mask of DCOC_BBA_OFFSET_I field.
	XCVR_RX_DIG_DCOC_OFFSET_7_DCOC_BBA_OFFSET_I_Msk = 0x3f
	// Position of DCOC_BBA_OFFSET_Q field.
	XCVR_RX_DIG_DCOC_OFFSET_7_DCOC_BBA_OFFSET_Q_Pos = 0x8
	// Bit mask of DCOC_BBA_OFFSET_Q field.
	XCVR_RX_DIG_DCOC_OFFSET_7_DCOC_BBA_OFFSET_Q_Msk = 0x3f00
	// Position of DCOC_TZA_OFFSET_I field.
	XCVR_RX_DIG_DCOC_OFFSET_7_DCOC_TZA_OFFSET_I_Pos = 0x10
	// Bit mask of DCOC_TZA_OFFSET_I field.
	XCVR_RX_DIG_DCOC_OFFSET_7_DCOC_TZA_OFFSET_I_Msk = 0xff0000
	// Position of DCOC_TZA_OFFSET_Q field.
	XCVR_RX_DIG_DCOC_OFFSET_7_DCOC_TZA_OFFSET_Q_Pos = 0x18
	// Bit mask of DCOC_TZA_OFFSET_Q field.
	XCVR_RX_DIG_DCOC_OFFSET_7_DCOC_TZA_OFFSET_Q_Msk = 0xff000000

	// DCOC_OFFSET_8: DCOC Offset
	// Position of DCOC_BBA_OFFSET_I field.
	XCVR_RX_DIG_DCOC_OFFSET_8_DCOC_BBA_OFFSET_I_Pos = 0x0
	// Bit mask of DCOC_BBA_OFFSET_I field.
	XCVR_RX_DIG_DCOC_OFFSET_8_DCOC_BBA_OFFSET_I_Msk = 0x3f
	// Position of DCOC_BBA_OFFSET_Q field.
	XCVR_RX_DIG_DCOC_OFFSET_8_DCOC_BBA_OFFSET_Q_Pos = 0x8
	// Bit mask of DCOC_BBA_OFFSET_Q field.
	XCVR_RX_DIG_DCOC_OFFSET_8_DCOC_BBA_OFFSET_Q_Msk = 0x3f00
	// Position of DCOC_TZA_OFFSET_I field.
	XCVR_RX_DIG_DCOC_OFFSET_8_DCOC_TZA_OFFSET_I_Pos = 0x10
	// Bit mask of DCOC_TZA_OFFSET_I field.
	XCVR_RX_DIG_DCOC_OFFSET_8_DCOC_TZA_OFFSET_I_Msk = 0xff0000
	// Position of DCOC_TZA_OFFSET_Q field.
	XCVR_RX_DIG_DCOC_OFFSET_8_DCOC_TZA_OFFSET_Q_Pos = 0x18
	// Bit mask of DCOC_TZA_OFFSET_Q field.
	XCVR_RX_DIG_DCOC_OFFSET_8_DCOC_TZA_OFFSET_Q_Msk = 0xff000000

	// DCOC_OFFSET_9: DCOC Offset
	// Position of DCOC_BBA_OFFSET_I field.
	XCVR_RX_DIG_DCOC_OFFSET_9_DCOC_BBA_OFFSET_I_Pos = 0x0
	// Bit mask of DCOC_BBA_OFFSET_I field.
	XCVR_RX_DIG_DCOC_OFFSET_9_DCOC_BBA_OFFSET_I_Msk = 0x3f
	// Position of DCOC_BBA_OFFSET_Q field.
	XCVR_RX_DIG_DCOC_OFFSET_9_DCOC_BBA_OFFSET_Q_Pos = 0x8
	// Bit mask of DCOC_BBA_OFFSET_Q field.
	XCVR_RX_DIG_DCOC_OFFSET_9_DCOC_BBA_OFFSET_Q_Msk = 0x3f00
	// Position of DCOC_TZA_OFFSET_I field.
	XCVR_RX_DIG_DCOC_OFFSET_9_DCOC_TZA_OFFSET_I_Pos = 0x10
	// Bit mask of DCOC_TZA_OFFSET_I field.
	XCVR_RX_DIG_DCOC_OFFSET_9_DCOC_TZA_OFFSET_I_Msk = 0xff0000
	// Position of DCOC_TZA_OFFSET_Q field.
	XCVR_RX_DIG_DCOC_OFFSET_9_DCOC_TZA_OFFSET_Q_Pos = 0x18
	// Bit mask of DCOC_TZA_OFFSET_Q field.
	XCVR_RX_DIG_DCOC_OFFSET_9_DCOC_TZA_OFFSET_Q_Msk = 0xff000000

	// DCOC_OFFSET_10: DCOC Offset
	// Position of DCOC_BBA_OFFSET_I field.
	XCVR_RX_DIG_DCOC_OFFSET_10_DCOC_BBA_OFFSET_I_Pos = 0x0
	// Bit mask of DCOC_BBA_OFFSET_I field.
	XCVR_RX_DIG_DCOC_OFFSET_10_DCOC_BBA_OFFSET_I_Msk = 0x3f
	// Position of DCOC_BBA_OFFSET_Q field.
	XCVR_RX_DIG_DCOC_OFFSET_10_DCOC_BBA_OFFSET_Q_Pos = 0x8
	// Bit mask of DCOC_BBA_OFFSET_Q field.
	XCVR_RX_DIG_DCOC_OFFSET_10_DCOC_BBA_OFFSET_Q_Msk = 0x3f00
	// Position of DCOC_TZA_OFFSET_I field.
	XCVR_RX_DIG_DCOC_OFFSET_10_DCOC_TZA_OFFSET_I_Pos = 0x10
	// Bit mask of DCOC_TZA_OFFSET_I field.
	XCVR_RX_DIG_DCOC_OFFSET_10_DCOC_TZA_OFFSET_I_Msk = 0xff0000
	// Position of DCOC_TZA_OFFSET_Q field.
	XCVR_RX_DIG_DCOC_OFFSET_10_DCOC_TZA_OFFSET_Q_Pos = 0x18
	// Bit mask of DCOC_TZA_OFFSET_Q field.
	XCVR_RX_DIG_DCOC_OFFSET_10_DCOC_TZA_OFFSET_Q_Msk = 0xff000000

	// DCOC_OFFSET_11: DCOC Offset
	// Position of DCOC_BBA_OFFSET_I field.
	XCVR_RX_DIG_DCOC_OFFSET_11_DCOC_BBA_OFFSET_I_Pos = 0x0
	// Bit mask of DCOC_BBA_OFFSET_I field.
	XCVR_RX_DIG_DCOC_OFFSET_11_DCOC_BBA_OFFSET_I_Msk = 0x3f
	// Position of DCOC_BBA_OFFSET_Q field.
	XCVR_RX_DIG_DCOC_OFFSET_11_DCOC_BBA_OFFSET_Q_Pos = 0x8
	// Bit mask of DCOC_BBA_OFFSET_Q field.
	XCVR_RX_DIG_DCOC_OFFSET_11_DCOC_BBA_OFFSET_Q_Msk = 0x3f00
	// Position of DCOC_TZA_OFFSET_I field.
	XCVR_RX_DIG_DCOC_OFFSET_11_DCOC_TZA_OFFSET_I_Pos = 0x10
	// Bit mask of DCOC_TZA_OFFSET_I field.
	XCVR_RX_DIG_DCOC_OFFSET_11_DCOC_TZA_OFFSET_I_Msk = 0xff0000
	// Position of DCOC_TZA_OFFSET_Q field.
	XCVR_RX_DIG_DCOC_OFFSET_11_DCOC_TZA_OFFSET_Q_Pos = 0x18
	// Bit mask of DCOC_TZA_OFFSET_Q field.
	XCVR_RX_DIG_DCOC_OFFSET_11_DCOC_TZA_OFFSET_Q_Msk = 0xff000000

	// DCOC_OFFSET_12: DCOC Offset
	// Position of DCOC_BBA_OFFSET_I field.
	XCVR_RX_DIG_DCOC_OFFSET_12_DCOC_BBA_OFFSET_I_Pos = 0x0
	// Bit mask of DCOC_BBA_OFFSET_I field.
	XCVR_RX_DIG_DCOC_OFFSET_12_DCOC_BBA_OFFSET_I_Msk = 0x3f
	// Position of DCOC_BBA_OFFSET_Q field.
	XCVR_RX_DIG_DCOC_OFFSET_12_DCOC_BBA_OFFSET_Q_Pos = 0x8
	// Bit mask of DCOC_BBA_OFFSET_Q field.
	XCVR_RX_DIG_DCOC_OFFSET_12_DCOC_BBA_OFFSET_Q_Msk = 0x3f00
	// Position of DCOC_TZA_OFFSET_I field.
	XCVR_RX_DIG_DCOC_OFFSET_12_DCOC_TZA_OFFSET_I_Pos = 0x10
	// Bit mask of DCOC_TZA_OFFSET_I field.
	XCVR_RX_DIG_DCOC_OFFSET_12_DCOC_TZA_OFFSET_I_Msk = 0xff0000
	// Position of DCOC_TZA_OFFSET_Q field.
	XCVR_RX_DIG_DCOC_OFFSET_12_DCOC_TZA_OFFSET_Q_Pos = 0x18
	// Bit mask of DCOC_TZA_OFFSET_Q field.
	XCVR_RX_DIG_DCOC_OFFSET_12_DCOC_TZA_OFFSET_Q_Msk = 0xff000000

	// DCOC_OFFSET_13: DCOC Offset
	// Position of DCOC_BBA_OFFSET_I field.
	XCVR_RX_DIG_DCOC_OFFSET_13_DCOC_BBA_OFFSET_I_Pos = 0x0
	// Bit mask of DCOC_BBA_OFFSET_I field.
	XCVR_RX_DIG_DCOC_OFFSET_13_DCOC_BBA_OFFSET_I_Msk = 0x3f
	// Position of DCOC_BBA_OFFSET_Q field.
	XCVR_RX_DIG_DCOC_OFFSET_13_DCOC_BBA_OFFSET_Q_Pos = 0x8
	// Bit mask of DCOC_BBA_OFFSET_Q field.
	XCVR_RX_DIG_DCOC_OFFSET_13_DCOC_BBA_OFFSET_Q_Msk = 0x3f00
	// Position of DCOC_TZA_OFFSET_I field.
	XCVR_RX_DIG_DCOC_OFFSET_13_DCOC_TZA_OFFSET_I_Pos = 0x10
	// Bit mask of DCOC_TZA_OFFSET_I field.
	XCVR_RX_DIG_DCOC_OFFSET_13_DCOC_TZA_OFFSET_I_Msk = 0xff0000
	// Position of DCOC_TZA_OFFSET_Q field.
	XCVR_RX_DIG_DCOC_OFFSET_13_DCOC_TZA_OFFSET_Q_Pos = 0x18
	// Bit mask of DCOC_TZA_OFFSET_Q field.
	XCVR_RX_DIG_DCOC_OFFSET_13_DCOC_TZA_OFFSET_Q_Msk = 0xff000000

	// DCOC_OFFSET_14: DCOC Offset
	// Position of DCOC_BBA_OFFSET_I field.
	XCVR_RX_DIG_DCOC_OFFSET_14_DCOC_BBA_OFFSET_I_Pos = 0x0
	// Bit mask of DCOC_BBA_OFFSET_I field.
	XCVR_RX_DIG_DCOC_OFFSET_14_DCOC_BBA_OFFSET_I_Msk = 0x3f
	// Position of DCOC_BBA_OFFSET_Q field.
	XCVR_RX_DIG_DCOC_OFFSET_14_DCOC_BBA_OFFSET_Q_Pos = 0x8
	// Bit mask of DCOC_BBA_OFFSET_Q field.
	XCVR_RX_DIG_DCOC_OFFSET_14_DCOC_BBA_OFFSET_Q_Msk = 0x3f00
	// Position of DCOC_TZA_OFFSET_I field.
	XCVR_RX_DIG_DCOC_OFFSET_14_DCOC_TZA_OFFSET_I_Pos = 0x10
	// Bit mask of DCOC_TZA_OFFSET_I field.
	XCVR_RX_DIG_DCOC_OFFSET_14_DCOC_TZA_OFFSET_I_Msk = 0xff0000
	// Position of DCOC_TZA_OFFSET_Q field.
	XCVR_RX_DIG_DCOC_OFFSET_14_DCOC_TZA_OFFSET_Q_Pos = 0x18
	// Bit mask of DCOC_TZA_OFFSET_Q field.
	XCVR_RX_DIG_DCOC_OFFSET_14_DCOC_TZA_OFFSET_Q_Msk = 0xff000000

	// DCOC_OFFSET_15: DCOC Offset
	// Position of DCOC_BBA_OFFSET_I field.
	XCVR_RX_DIG_DCOC_OFFSET_15_DCOC_BBA_OFFSET_I_Pos = 0x0
	// Bit mask of DCOC_BBA_OFFSET_I field.
	XCVR_RX_DIG_DCOC_OFFSET_15_DCOC_BBA_OFFSET_I_Msk = 0x3f
	// Position of DCOC_BBA_OFFSET_Q field.
	XCVR_RX_DIG_DCOC_OFFSET_15_DCOC_BBA_OFFSET_Q_Pos = 0x8
	// Bit mask of DCOC_BBA_OFFSET_Q field.
	XCVR_RX_DIG_DCOC_OFFSET_15_DCOC_BBA_OFFSET_Q_Msk = 0x3f00
	// Position of DCOC_TZA_OFFSET_I field.
	XCVR_RX_DIG_DCOC_OFFSET_15_DCOC_TZA_OFFSET_I_Pos = 0x10
	// Bit mask of DCOC_TZA_OFFSET_I field.
	XCVR_RX_DIG_DCOC_OFFSET_15_DCOC_TZA_OFFSET_I_Msk = 0xff0000
	// Position of DCOC_TZA_OFFSET_Q field.
	XCVR_RX_DIG_DCOC_OFFSET_15_DCOC_TZA_OFFSET_Q_Pos = 0x18
	// Bit mask of DCOC_TZA_OFFSET_Q field.
	XCVR_RX_DIG_DCOC_OFFSET_15_DCOC_TZA_OFFSET_Q_Msk = 0xff000000

	// DCOC_OFFSET_16: DCOC Offset
	// Position of DCOC_BBA_OFFSET_I field.
	XCVR_RX_DIG_DCOC_OFFSET_16_DCOC_BBA_OFFSET_I_Pos = 0x0
	// Bit mask of DCOC_BBA_OFFSET_I field.
	XCVR_RX_DIG_DCOC_OFFSET_16_DCOC_BBA_OFFSET_I_Msk = 0x3f
	// Position of DCOC_BBA_OFFSET_Q field.
	XCVR_RX_DIG_DCOC_OFFSET_16_DCOC_BBA_OFFSET_Q_Pos = 0x8
	// Bit mask of DCOC_BBA_OFFSET_Q field.
	XCVR_RX_DIG_DCOC_OFFSET_16_DCOC_BBA_OFFSET_Q_Msk = 0x3f00
	// Position of DCOC_TZA_OFFSET_I field.
	XCVR_RX_DIG_DCOC_OFFSET_16_DCOC_TZA_OFFSET_I_Pos = 0x10
	// Bit mask of DCOC_TZA_OFFSET_I field.
	XCVR_RX_DIG_DCOC_OFFSET_16_DCOC_TZA_OFFSET_I_Msk = 0xff0000
	// Position of DCOC_TZA_OFFSET_Q field.
	XCVR_RX_DIG_DCOC_OFFSET_16_DCOC_TZA_OFFSET_Q_Pos = 0x18
	// Bit mask of DCOC_TZA_OFFSET_Q field.
	XCVR_RX_DIG_DCOC_OFFSET_16_DCOC_TZA_OFFSET_Q_Msk = 0xff000000

	// DCOC_OFFSET_17: DCOC Offset
	// Position of DCOC_BBA_OFFSET_I field.
	XCVR_RX_DIG_DCOC_OFFSET_17_DCOC_BBA_OFFSET_I_Pos = 0x0
	// Bit mask of DCOC_BBA_OFFSET_I field.
	XCVR_RX_DIG_DCOC_OFFSET_17_DCOC_BBA_OFFSET_I_Msk = 0x3f
	// Position of DCOC_BBA_OFFSET_Q field.
	XCVR_RX_DIG_DCOC_OFFSET_17_DCOC_BBA_OFFSET_Q_Pos = 0x8
	// Bit mask of DCOC_BBA_OFFSET_Q field.
	XCVR_RX_DIG_DCOC_OFFSET_17_DCOC_BBA_OFFSET_Q_Msk = 0x3f00
	// Position of DCOC_TZA_OFFSET_I field.
	XCVR_RX_DIG_DCOC_OFFSET_17_DCOC_TZA_OFFSET_I_Pos = 0x10
	// Bit mask of DCOC_TZA_OFFSET_I field.
	XCVR_RX_DIG_DCOC_OFFSET_17_DCOC_TZA_OFFSET_I_Msk = 0xff0000
	// Position of DCOC_TZA_OFFSET_Q field.
	XCVR_RX_DIG_DCOC_OFFSET_17_DCOC_TZA_OFFSET_Q_Pos = 0x18
	// Bit mask of DCOC_TZA_OFFSET_Q field.
	XCVR_RX_DIG_DCOC_OFFSET_17_DCOC_TZA_OFFSET_Q_Msk = 0xff000000

	// DCOC_OFFSET_18: DCOC Offset
	// Position of DCOC_BBA_OFFSET_I field.
	XCVR_RX_DIG_DCOC_OFFSET_18_DCOC_BBA_OFFSET_I_Pos = 0x0
	// Bit mask of DCOC_BBA_OFFSET_I field.
	XCVR_RX_DIG_DCOC_OFFSET_18_DCOC_BBA_OFFSET_I_Msk = 0x3f
	// Position of DCOC_BBA_OFFSET_Q field.
	XCVR_RX_DIG_DCOC_OFFSET_18_DCOC_BBA_OFFSET_Q_Pos = 0x8
	// Bit mask of DCOC_BBA_OFFSET_Q field.
	XCVR_RX_DIG_DCOC_OFFSET_18_DCOC_BBA_OFFSET_Q_Msk = 0x3f00
	// Position of DCOC_TZA_OFFSET_I field.
	XCVR_RX_DIG_DCOC_OFFSET_18_DCOC_TZA_OFFSET_I_Pos = 0x10
	// Bit mask of DCOC_TZA_OFFSET_I field.
	XCVR_RX_DIG_DCOC_OFFSET_18_DCOC_TZA_OFFSET_I_Msk = 0xff0000
	// Position of DCOC_TZA_OFFSET_Q field.
	XCVR_RX_DIG_DCOC_OFFSET_18_DCOC_TZA_OFFSET_Q_Pos = 0x18
	// Bit mask of DCOC_TZA_OFFSET_Q field.
	XCVR_RX_DIG_DCOC_OFFSET_18_DCOC_TZA_OFFSET_Q_Msk = 0xff000000

	// DCOC_OFFSET_19: DCOC Offset
	// Position of DCOC_BBA_OFFSET_I field.
	XCVR_RX_DIG_DCOC_OFFSET_19_DCOC_BBA_OFFSET_I_Pos = 0x0
	// Bit mask of DCOC_BBA_OFFSET_I field.
	XCVR_RX_DIG_DCOC_OFFSET_19_DCOC_BBA_OFFSET_I_Msk = 0x3f
	// Position of DCOC_BBA_OFFSET_Q field.
	XCVR_RX_DIG_DCOC_OFFSET_19_DCOC_BBA_OFFSET_Q_Pos = 0x8
	// Bit mask of DCOC_BBA_OFFSET_Q field.
	XCVR_RX_DIG_DCOC_OFFSET_19_DCOC_BBA_OFFSET_Q_Msk = 0x3f00
	// Position of DCOC_TZA_OFFSET_I field.
	XCVR_RX_DIG_DCOC_OFFSET_19_DCOC_TZA_OFFSET_I_Pos = 0x10
	// Bit mask of DCOC_TZA_OFFSET_I field.
	XCVR_RX_DIG_DCOC_OFFSET_19_DCOC_TZA_OFFSET_I_Msk = 0xff0000
	// Position of DCOC_TZA_OFFSET_Q field.
	XCVR_RX_DIG_DCOC_OFFSET_19_DCOC_TZA_OFFSET_Q_Pos = 0x18
	// Bit mask of DCOC_TZA_OFFSET_Q field.
	XCVR_RX_DIG_DCOC_OFFSET_19_DCOC_TZA_OFFSET_Q_Msk = 0xff000000

	// DCOC_OFFSET_20: DCOC Offset
	// Position of DCOC_BBA_OFFSET_I field.
	XCVR_RX_DIG_DCOC_OFFSET_20_DCOC_BBA_OFFSET_I_Pos = 0x0
	// Bit mask of DCOC_BBA_OFFSET_I field.
	XCVR_RX_DIG_DCOC_OFFSET_20_DCOC_BBA_OFFSET_I_Msk = 0x3f
	// Position of DCOC_BBA_OFFSET_Q field.
	XCVR_RX_DIG_DCOC_OFFSET_20_DCOC_BBA_OFFSET_Q_Pos = 0x8
	// Bit mask of DCOC_BBA_OFFSET_Q field.
	XCVR_RX_DIG_DCOC_OFFSET_20_DCOC_BBA_OFFSET_Q_Msk = 0x3f00
	// Position of DCOC_TZA_OFFSET_I field.
	XCVR_RX_DIG_DCOC_OFFSET_20_DCOC_TZA_OFFSET_I_Pos = 0x10
	// Bit mask of DCOC_TZA_OFFSET_I field.
	XCVR_RX_DIG_DCOC_OFFSET_20_DCOC_TZA_OFFSET_I_Msk = 0xff0000
	// Position of DCOC_TZA_OFFSET_Q field.
	XCVR_RX_DIG_DCOC_OFFSET_20_DCOC_TZA_OFFSET_Q_Pos = 0x18
	// Bit mask of DCOC_TZA_OFFSET_Q field.
	XCVR_RX_DIG_DCOC_OFFSET_20_DCOC_TZA_OFFSET_Q_Msk = 0xff000000

	// DCOC_OFFSET_21: DCOC Offset
	// Position of DCOC_BBA_OFFSET_I field.
	XCVR_RX_DIG_DCOC_OFFSET_21_DCOC_BBA_OFFSET_I_Pos = 0x0
	// Bit mask of DCOC_BBA_OFFSET_I field.
	XCVR_RX_DIG_DCOC_OFFSET_21_DCOC_BBA_OFFSET_I_Msk = 0x3f
	// Position of DCOC_BBA_OFFSET_Q field.
	XCVR_RX_DIG_DCOC_OFFSET_21_DCOC_BBA_OFFSET_Q_Pos = 0x8
	// Bit mask of DCOC_BBA_OFFSET_Q field.
	XCVR_RX_DIG_DCOC_OFFSET_21_DCOC_BBA_OFFSET_Q_Msk = 0x3f00
	// Position of DCOC_TZA_OFFSET_I field.
	XCVR_RX_DIG_DCOC_OFFSET_21_DCOC_TZA_OFFSET_I_Pos = 0x10
	// Bit mask of DCOC_TZA_OFFSET_I field.
	XCVR_RX_DIG_DCOC_OFFSET_21_DCOC_TZA_OFFSET_I_Msk = 0xff0000
	// Position of DCOC_TZA_OFFSET_Q field.
	XCVR_RX_DIG_DCOC_OFFSET_21_DCOC_TZA_OFFSET_Q_Pos = 0x18
	// Bit mask of DCOC_TZA_OFFSET_Q field.
	XCVR_RX_DIG_DCOC_OFFSET_21_DCOC_TZA_OFFSET_Q_Msk = 0xff000000

	// DCOC_OFFSET_22: DCOC Offset
	// Position of DCOC_BBA_OFFSET_I field.
	XCVR_RX_DIG_DCOC_OFFSET_22_DCOC_BBA_OFFSET_I_Pos = 0x0
	// Bit mask of DCOC_BBA_OFFSET_I field.
	XCVR_RX_DIG_DCOC_OFFSET_22_DCOC_BBA_OFFSET_I_Msk = 0x3f
	// Position of DCOC_BBA_OFFSET_Q field.
	XCVR_RX_DIG_DCOC_OFFSET_22_DCOC_BBA_OFFSET_Q_Pos = 0x8
	// Bit mask of DCOC_BBA_OFFSET_Q field.
	XCVR_RX_DIG_DCOC_OFFSET_22_DCOC_BBA_OFFSET_Q_Msk = 0x3f00
	// Position of DCOC_TZA_OFFSET_I field.
	XCVR_RX_DIG_DCOC_OFFSET_22_DCOC_TZA_OFFSET_I_Pos = 0x10
	// Bit mask of DCOC_TZA_OFFSET_I field.
	XCVR_RX_DIG_DCOC_OFFSET_22_DCOC_TZA_OFFSET_I_Msk = 0xff0000
	// Position of DCOC_TZA_OFFSET_Q field.
	XCVR_RX_DIG_DCOC_OFFSET_22_DCOC_TZA_OFFSET_Q_Pos = 0x18
	// Bit mask of DCOC_TZA_OFFSET_Q field.
	XCVR_RX_DIG_DCOC_OFFSET_22_DCOC_TZA_OFFSET_Q_Msk = 0xff000000

	// DCOC_OFFSET_23: DCOC Offset
	// Position of DCOC_BBA_OFFSET_I field.
	XCVR_RX_DIG_DCOC_OFFSET_23_DCOC_BBA_OFFSET_I_Pos = 0x0
	// Bit mask of DCOC_BBA_OFFSET_I field.
	XCVR_RX_DIG_DCOC_OFFSET_23_DCOC_BBA_OFFSET_I_Msk = 0x3f
	// Position of DCOC_BBA_OFFSET_Q field.
	XCVR_RX_DIG_DCOC_OFFSET_23_DCOC_BBA_OFFSET_Q_Pos = 0x8
	// Bit mask of DCOC_BBA_OFFSET_Q field.
	XCVR_RX_DIG_DCOC_OFFSET_23_DCOC_BBA_OFFSET_Q_Msk = 0x3f00
	// Position of DCOC_TZA_OFFSET_I field.
	XCVR_RX_DIG_DCOC_OFFSET_23_DCOC_TZA_OFFSET_I_Pos = 0x10
	// Bit mask of DCOC_TZA_OFFSET_I field.
	XCVR_RX_DIG_DCOC_OFFSET_23_DCOC_TZA_OFFSET_I_Msk = 0xff0000
	// Position of DCOC_TZA_OFFSET_Q field.
	XCVR_RX_DIG_DCOC_OFFSET_23_DCOC_TZA_OFFSET_Q_Pos = 0x18
	// Bit mask of DCOC_TZA_OFFSET_Q field.
	XCVR_RX_DIG_DCOC_OFFSET_23_DCOC_TZA_OFFSET_Q_Msk = 0xff000000

	// DCOC_OFFSET_24: DCOC Offset
	// Position of DCOC_BBA_OFFSET_I field.
	XCVR_RX_DIG_DCOC_OFFSET_24_DCOC_BBA_OFFSET_I_Pos = 0x0
	// Bit mask of DCOC_BBA_OFFSET_I field.
	XCVR_RX_DIG_DCOC_OFFSET_24_DCOC_BBA_OFFSET_I_Msk = 0x3f
	// Position of DCOC_BBA_OFFSET_Q field.
	XCVR_RX_DIG_DCOC_OFFSET_24_DCOC_BBA_OFFSET_Q_Pos = 0x8
	// Bit mask of DCOC_BBA_OFFSET_Q field.
	XCVR_RX_DIG_DCOC_OFFSET_24_DCOC_BBA_OFFSET_Q_Msk = 0x3f00
	// Position of DCOC_TZA_OFFSET_I field.
	XCVR_RX_DIG_DCOC_OFFSET_24_DCOC_TZA_OFFSET_I_Pos = 0x10
	// Bit mask of DCOC_TZA_OFFSET_I field.
	XCVR_RX_DIG_DCOC_OFFSET_24_DCOC_TZA_OFFSET_I_Msk = 0xff0000
	// Position of DCOC_TZA_OFFSET_Q field.
	XCVR_RX_DIG_DCOC_OFFSET_24_DCOC_TZA_OFFSET_Q_Pos = 0x18
	// Bit mask of DCOC_TZA_OFFSET_Q field.
	XCVR_RX_DIG_DCOC_OFFSET_24_DCOC_TZA_OFFSET_Q_Msk = 0xff000000

	// DCOC_OFFSET_25: DCOC Offset
	// Position of DCOC_BBA_OFFSET_I field.
	XCVR_RX_DIG_DCOC_OFFSET_25_DCOC_BBA_OFFSET_I_Pos = 0x0
	// Bit mask of DCOC_BBA_OFFSET_I field.
	XCVR_RX_DIG_DCOC_OFFSET_25_DCOC_BBA_OFFSET_I_Msk = 0x3f
	// Position of DCOC_BBA_OFFSET_Q field.
	XCVR_RX_DIG_DCOC_OFFSET_25_DCOC_BBA_OFFSET_Q_Pos = 0x8
	// Bit mask of DCOC_BBA_OFFSET_Q field.
	XCVR_RX_DIG_DCOC_OFFSET_25_DCOC_BBA_OFFSET_Q_Msk = 0x3f00
	// Position of DCOC_TZA_OFFSET_I field.
	XCVR_RX_DIG_DCOC_OFFSET_25_DCOC_TZA_OFFSET_I_Pos = 0x10
	// Bit mask of DCOC_TZA_OFFSET_I field.
	XCVR_RX_DIG_DCOC_OFFSET_25_DCOC_TZA_OFFSET_I_Msk = 0xff0000
	// Position of DCOC_TZA_OFFSET_Q field.
	XCVR_RX_DIG_DCOC_OFFSET_25_DCOC_TZA_OFFSET_Q_Pos = 0x18
	// Bit mask of DCOC_TZA_OFFSET_Q field.
	XCVR_RX_DIG_DCOC_OFFSET_25_DCOC_TZA_OFFSET_Q_Msk = 0xff000000

	// DCOC_OFFSET_26: DCOC Offset
	// Position of DCOC_BBA_OFFSET_I field.
	XCVR_RX_DIG_DCOC_OFFSET_26_DCOC_BBA_OFFSET_I_Pos = 0x0
	// Bit mask of DCOC_BBA_OFFSET_I field.
	XCVR_RX_DIG_DCOC_OFFSET_26_DCOC_BBA_OFFSET_I_Msk = 0x3f
	// Position of DCOC_BBA_OFFSET_Q field.
	XCVR_RX_DIG_DCOC_OFFSET_26_DCOC_BBA_OFFSET_Q_Pos = 0x8
	// Bit mask of DCOC_BBA_OFFSET_Q field.
	XCVR_RX_DIG_DCOC_OFFSET_26_DCOC_BBA_OFFSET_Q_Msk = 0x3f00
	// Position of DCOC_TZA_OFFSET_I field.
	XCVR_RX_DIG_DCOC_OFFSET_26_DCOC_TZA_OFFSET_I_Pos = 0x10
	// Bit mask of DCOC_TZA_OFFSET_I field.
	XCVR_RX_DIG_DCOC_OFFSET_26_DCOC_TZA_OFFSET_I_Msk = 0xff0000
	// Position of DCOC_TZA_OFFSET_Q field.
	XCVR_RX_DIG_DCOC_OFFSET_26_DCOC_TZA_OFFSET_Q_Pos = 0x18
	// Bit mask of DCOC_TZA_OFFSET_Q field.
	XCVR_RX_DIG_DCOC_OFFSET_26_DCOC_TZA_OFFSET_Q_Msk = 0xff000000

	// DCOC_BBA_STEP: DCOC BBA DAC Step
	// Position of BBA_DCOC_STEP_RECIP field.
	XCVR_RX_DIG_DCOC_BBA_STEP_BBA_DCOC_STEP_RECIP_Pos = 0x0
	// Bit mask of BBA_DCOC_STEP_RECIP field.
	XCVR_RX_DIG_DCOC_BBA_STEP_BBA_DCOC_STEP_RECIP_Msk = 0x1fff
	// Position of BBA_DCOC_STEP field.
	XCVR_RX_DIG_DCOC_BBA_STEP_BBA_DCOC_STEP_Pos = 0x10
	// Bit mask of BBA_DCOC_STEP field.
	XCVR_RX_DIG_DCOC_BBA_STEP_BBA_DCOC_STEP_Msk = 0x1ff0000

	// DCOC_TZA_STEP_0: DCOC TZA DAC Step 0
	// Position of DCOC_TZA_STEP_RCP_0 field.
	XCVR_RX_DIG_DCOC_TZA_STEP_0_DCOC_TZA_STEP_RCP_0_Pos = 0x0
	// Bit mask of DCOC_TZA_STEP_RCP_0 field.
	XCVR_RX_DIG_DCOC_TZA_STEP_0_DCOC_TZA_STEP_RCP_0_Msk = 0x1fff
	// Position of DCOC_TZA_STEP_GAIN_0 field.
	XCVR_RX_DIG_DCOC_TZA_STEP_0_DCOC_TZA_STEP_GAIN_0_Pos = 0x10
	// Bit mask of DCOC_TZA_STEP_GAIN_0 field.
	XCVR_RX_DIG_DCOC_TZA_STEP_0_DCOC_TZA_STEP_GAIN_0_Msk = 0xfff0000

	// DCOC_TZA_STEP_1: DCOC TZA DAC Step 1
	// Position of DCOC_TZA_STEP_RCP_1 field.
	XCVR_RX_DIG_DCOC_TZA_STEP_1_DCOC_TZA_STEP_RCP_1_Pos = 0x0
	// Bit mask of DCOC_TZA_STEP_RCP_1 field.
	XCVR_RX_DIG_DCOC_TZA_STEP_1_DCOC_TZA_STEP_RCP_1_Msk = 0x1fff
	// Position of DCOC_TZA_STEP_GAIN_1 field.
	XCVR_RX_DIG_DCOC_TZA_STEP_1_DCOC_TZA_STEP_GAIN_1_Pos = 0x10
	// Bit mask of DCOC_TZA_STEP_GAIN_1 field.
	XCVR_RX_DIG_DCOC_TZA_STEP_1_DCOC_TZA_STEP_GAIN_1_Msk = 0xfff0000

	// DCOC_TZA_STEP_2: DCOC TZA DAC Step 2
	// Position of DCOC_TZA_STEP_RCP_2 field.
	XCVR_RX_DIG_DCOC_TZA_STEP_2_DCOC_TZA_STEP_RCP_2_Pos = 0x0
	// Bit mask of DCOC_TZA_STEP_RCP_2 field.
	XCVR_RX_DIG_DCOC_TZA_STEP_2_DCOC_TZA_STEP_RCP_2_Msk = 0x1fff
	// Position of DCOC_TZA_STEP_GAIN_2 field.
	XCVR_RX_DIG_DCOC_TZA_STEP_2_DCOC_TZA_STEP_GAIN_2_Pos = 0x10
	// Bit mask of DCOC_TZA_STEP_GAIN_2 field.
	XCVR_RX_DIG_DCOC_TZA_STEP_2_DCOC_TZA_STEP_GAIN_2_Msk = 0xfff0000

	// DCOC_TZA_STEP_3: DCOC TZA DAC Step 3
	// Position of DCOC_TZA_STEP_RCP_3 field.
	XCVR_RX_DIG_DCOC_TZA_STEP_3_DCOC_TZA_STEP_RCP_3_Pos = 0x0
	// Bit mask of DCOC_TZA_STEP_RCP_3 field.
	XCVR_RX_DIG_DCOC_TZA_STEP_3_DCOC_TZA_STEP_RCP_3_Msk = 0x1fff
	// Position of DCOC_TZA_STEP_GAIN_3 field.
	XCVR_RX_DIG_DCOC_TZA_STEP_3_DCOC_TZA_STEP_GAIN_3_Pos = 0x10
	// Bit mask of DCOC_TZA_STEP_GAIN_3 field.
	XCVR_RX_DIG_DCOC_TZA_STEP_3_DCOC_TZA_STEP_GAIN_3_Msk = 0xfff0000

	// DCOC_TZA_STEP_4: DCOC TZA DAC Step 4
	// Position of DCOC_TZA_STEP_RCP_4 field.
	XCVR_RX_DIG_DCOC_TZA_STEP_4_DCOC_TZA_STEP_RCP_4_Pos = 0x0
	// Bit mask of DCOC_TZA_STEP_RCP_4 field.
	XCVR_RX_DIG_DCOC_TZA_STEP_4_DCOC_TZA_STEP_RCP_4_Msk = 0x1fff
	// Position of DCOC_TZA_STEP_GAIN_4 field.
	XCVR_RX_DIG_DCOC_TZA_STEP_4_DCOC_TZA_STEP_GAIN_4_Pos = 0x10
	// Bit mask of DCOC_TZA_STEP_GAIN_4 field.
	XCVR_RX_DIG_DCOC_TZA_STEP_4_DCOC_TZA_STEP_GAIN_4_Msk = 0xfff0000

	// DCOC_TZA_STEP_5: DCOC TZA DAC Step 5
	// Position of DCOC_TZA_STEP_RCP_5 field.
	XCVR_RX_DIG_DCOC_TZA_STEP_5_DCOC_TZA_STEP_RCP_5_Pos = 0x0
	// Bit mask of DCOC_TZA_STEP_RCP_5 field.
	XCVR_RX_DIG_DCOC_TZA_STEP_5_DCOC_TZA_STEP_RCP_5_Msk = 0x1fff
	// Position of DCOC_TZA_STEP_GAIN_5 field.
	XCVR_RX_DIG_DCOC_TZA_STEP_5_DCOC_TZA_STEP_GAIN_5_Pos = 0x10
	// Bit mask of DCOC_TZA_STEP_GAIN_5 field.
	XCVR_RX_DIG_DCOC_TZA_STEP_5_DCOC_TZA_STEP_GAIN_5_Msk = 0xfff0000

	// DCOC_TZA_STEP_6: DCOC TZA DAC Step 6
	// Position of DCOC_TZA_STEP_RCP_6 field.
	XCVR_RX_DIG_DCOC_TZA_STEP_6_DCOC_TZA_STEP_RCP_6_Pos = 0x0
	// Bit mask of DCOC_TZA_STEP_RCP_6 field.
	XCVR_RX_DIG_DCOC_TZA_STEP_6_DCOC_TZA_STEP_RCP_6_Msk = 0x1fff
	// Position of DCOC_TZA_STEP_GAIN_6 field.
	XCVR_RX_DIG_DCOC_TZA_STEP_6_DCOC_TZA_STEP_GAIN_6_Pos = 0x10
	// Bit mask of DCOC_TZA_STEP_GAIN_6 field.
	XCVR_RX_DIG_DCOC_TZA_STEP_6_DCOC_TZA_STEP_GAIN_6_Msk = 0xfff0000

	// DCOC_TZA_STEP_7: DCOC TZA DAC Step 7
	// Position of DCOC_TZA_STEP_RCP_7 field.
	XCVR_RX_DIG_DCOC_TZA_STEP_7_DCOC_TZA_STEP_RCP_7_Pos = 0x0
	// Bit mask of DCOC_TZA_STEP_RCP_7 field.
	XCVR_RX_DIG_DCOC_TZA_STEP_7_DCOC_TZA_STEP_RCP_7_Msk = 0x1fff
	// Position of DCOC_TZA_STEP_GAIN_7 field.
	XCVR_RX_DIG_DCOC_TZA_STEP_7_DCOC_TZA_STEP_GAIN_7_Pos = 0x10
	// Bit mask of DCOC_TZA_STEP_GAIN_7 field.
	XCVR_RX_DIG_DCOC_TZA_STEP_7_DCOC_TZA_STEP_GAIN_7_Msk = 0x1fff0000

	// DCOC_TZA_STEP_8: DCOC TZA DAC Step 5
	// Position of DCOC_TZA_STEP_RCP_8 field.
	XCVR_RX_DIG_DCOC_TZA_STEP_8_DCOC_TZA_STEP_RCP_8_Pos = 0x0
	// Bit mask of DCOC_TZA_STEP_RCP_8 field.
	XCVR_RX_DIG_DCOC_TZA_STEP_8_DCOC_TZA_STEP_RCP_8_Msk = 0x1fff
	// Position of DCOC_TZA_STEP_GAIN_8 field.
	XCVR_RX_DIG_DCOC_TZA_STEP_8_DCOC_TZA_STEP_GAIN_8_Pos = 0x10
	// Bit mask of DCOC_TZA_STEP_GAIN_8 field.
	XCVR_RX_DIG_DCOC_TZA_STEP_8_DCOC_TZA_STEP_GAIN_8_Msk = 0x1fff0000

	// DCOC_TZA_STEP_9: DCOC TZA DAC Step 9
	// Position of DCOC_TZA_STEP_RCP_9 field.
	XCVR_RX_DIG_DCOC_TZA_STEP_9_DCOC_TZA_STEP_RCP_9_Pos = 0x0
	// Bit mask of DCOC_TZA_STEP_RCP_9 field.
	XCVR_RX_DIG_DCOC_TZA_STEP_9_DCOC_TZA_STEP_RCP_9_Msk = 0x1fff
	// Position of DCOC_TZA_STEP_GAIN_9 field.
	XCVR_RX_DIG_DCOC_TZA_STEP_9_DCOC_TZA_STEP_GAIN_9_Pos = 0x10
	// Bit mask of DCOC_TZA_STEP_GAIN_9 field.
	XCVR_RX_DIG_DCOC_TZA_STEP_9_DCOC_TZA_STEP_GAIN_9_Msk = 0x3fff0000

	// DCOC_TZA_STEP_10: DCOC TZA DAC Step 10
	// Position of DCOC_TZA_STEP_RCP_10 field.
	XCVR_RX_DIG_DCOC_TZA_STEP_10_DCOC_TZA_STEP_RCP_10_Pos = 0x0
	// Bit mask of DCOC_TZA_STEP_RCP_10 field.
	XCVR_RX_DIG_DCOC_TZA_STEP_10_DCOC_TZA_STEP_RCP_10_Msk = 0x1fff
	// Position of DCOC_TZA_STEP_GAIN_10 field.
	XCVR_RX_DIG_DCOC_TZA_STEP_10_DCOC_TZA_STEP_GAIN_10_Pos = 0x10
	// Bit mask of DCOC_TZA_STEP_GAIN_10 field.
	XCVR_RX_DIG_DCOC_TZA_STEP_10_DCOC_TZA_STEP_GAIN_10_Msk = 0x3fff0000

	// DCOC_CAL_ALPHA: DCOC Calibration Alpha
	// Position of DCOC_CAL_ALPHA_I field.
	XCVR_RX_DIG_DCOC_CAL_ALPHA_DCOC_CAL_ALPHA_I_Pos = 0x0
	// Bit mask of DCOC_CAL_ALPHA_I field.
	XCVR_RX_DIG_DCOC_CAL_ALPHA_DCOC_CAL_ALPHA_I_Msk = 0x7ff
	// Position of DCOC_CAL_ALPHA_Q field.
	XCVR_RX_DIG_DCOC_CAL_ALPHA_DCOC_CAL_ALPHA_Q_Pos = 0x10
	// Bit mask of DCOC_CAL_ALPHA_Q field.
	XCVR_RX_DIG_DCOC_CAL_ALPHA_DCOC_CAL_ALPHA_Q_Msk = 0x7ff0000

	// DCOC_CAL_BETA_Q: DCOC Calibration Beta Q
	// Position of DCOC_CAL_BETA_Q field.
	XCVR_RX_DIG_DCOC_CAL_BETA_Q_DCOC_CAL_BETA_Q_Pos = 0x0
	// Bit mask of DCOC_CAL_BETA_Q field.
	XCVR_RX_DIG_DCOC_CAL_BETA_Q_DCOC_CAL_BETA_Q_Msk = 0x1ffff

	// DCOC_CAL_BETA_I: DCOC Calibration Beta I
	// Position of DCOC_CAL_BETA_I field.
	XCVR_RX_DIG_DCOC_CAL_BETA_I_DCOC_CAL_BETA_I_Pos = 0x0
	// Bit mask of DCOC_CAL_BETA_I field.
	XCVR_RX_DIG_DCOC_CAL_BETA_I_DCOC_CAL_BETA_I_Msk = 0x1ffff

	// DCOC_CAL_GAMMA: DCOC Calibration Gamma
	// Position of DCOC_CAL_GAMMA_I field.
	XCVR_RX_DIG_DCOC_CAL_GAMMA_DCOC_CAL_GAMMA_I_Pos = 0x0
	// Bit mask of DCOC_CAL_GAMMA_I field.
	XCVR_RX_DIG_DCOC_CAL_GAMMA_DCOC_CAL_GAMMA_I_Msk = 0xffff
	// Position of DCOC_CAL_GAMMA_Q field.
	XCVR_RX_DIG_DCOC_CAL_GAMMA_DCOC_CAL_GAMMA_Q_Pos = 0x10
	// Bit mask of DCOC_CAL_GAMMA_Q field.
	XCVR_RX_DIG_DCOC_CAL_GAMMA_DCOC_CAL_GAMMA_Q_Msk = 0xffff0000

	// DCOC_CAL_IIR: DCOC Calibration IIR
	// Position of DCOC_CAL_IIR1A_IDX field.
	XCVR_RX_DIG_DCOC_CAL_IIR_DCOC_CAL_IIR1A_IDX_Pos = 0x0
	// Bit mask of DCOC_CAL_IIR1A_IDX field.
	XCVR_RX_DIG_DCOC_CAL_IIR_DCOC_CAL_IIR1A_IDX_Msk = 0x3
	// 1/1
	XCVR_RX_DIG_DCOC_CAL_IIR_DCOC_CAL_IIR1A_IDX_0 = 0x0
	// 1/4
	XCVR_RX_DIG_DCOC_CAL_IIR_DCOC_CAL_IIR1A_IDX_1 = 0x1
	// 1/8
	XCVR_RX_DIG_DCOC_CAL_IIR_DCOC_CAL_IIR1A_IDX_2 = 0x2
	// 1/16
	XCVR_RX_DIG_DCOC_CAL_IIR_DCOC_CAL_IIR1A_IDX_3 = 0x3
	// Position of DCOC_CAL_IIR2A_IDX field.
	XCVR_RX_DIG_DCOC_CAL_IIR_DCOC_CAL_IIR2A_IDX_Pos = 0x2
	// Bit mask of DCOC_CAL_IIR2A_IDX field.
	XCVR_RX_DIG_DCOC_CAL_IIR_DCOC_CAL_IIR2A_IDX_Msk = 0xc
	// 1/1
	XCVR_RX_DIG_DCOC_CAL_IIR_DCOC_CAL_IIR2A_IDX_0 = 0x0
	// 1/4
	XCVR_RX_DIG_DCOC_CAL_IIR_DCOC_CAL_IIR2A_IDX_1 = 0x1
	// 1/8
	XCVR_RX_DIG_DCOC_CAL_IIR_DCOC_CAL_IIR2A_IDX_2 = 0x2
	// 1/16
	XCVR_RX_DIG_DCOC_CAL_IIR_DCOC_CAL_IIR2A_IDX_3 = 0x3
	// Position of DCOC_CAL_IIR3A_IDX field.
	XCVR_RX_DIG_DCOC_CAL_IIR_DCOC_CAL_IIR3A_IDX_Pos = 0x4
	// Bit mask of DCOC_CAL_IIR3A_IDX field.
	XCVR_RX_DIG_DCOC_CAL_IIR_DCOC_CAL_IIR3A_IDX_Msk = 0x30
	// 1/4
	XCVR_RX_DIG_DCOC_CAL_IIR_DCOC_CAL_IIR3A_IDX_0 = 0x0
	// 1/8
	XCVR_RX_DIG_DCOC_CAL_IIR_DCOC_CAL_IIR3A_IDX_1 = 0x1
	// 1/16
	XCVR_RX_DIG_DCOC_CAL_IIR_DCOC_CAL_IIR3A_IDX_2 = 0x2
	// 1/32
	XCVR_RX_DIG_DCOC_CAL_IIR_DCOC_CAL_IIR3A_IDX_3 = 0x3

	// DCOC_CAL1: DCOC Calibration Result
	// Position of DCOC_CAL_RES_I field.
	XCVR_RX_DIG_DCOC_CAL1_DCOC_CAL_RES_I_Pos = 0x0
	// Bit mask of DCOC_CAL_RES_I field.
	XCVR_RX_DIG_DCOC_CAL1_DCOC_CAL_RES_I_Msk = 0xfff
	// Position of DCOC_CAL_RES_Q field.
	XCVR_RX_DIG_DCOC_CAL1_DCOC_CAL_RES_Q_Pos = 0x10
	// Bit mask of DCOC_CAL_RES_Q field.
	XCVR_RX_DIG_DCOC_CAL1_DCOC_CAL_RES_Q_Msk = 0xfff0000

	// DCOC_CAL2: DCOC Calibration Result
	// Position of DCOC_CAL_RES_I field.
	XCVR_RX_DIG_DCOC_CAL2_DCOC_CAL_RES_I_Pos = 0x0
	// Bit mask of DCOC_CAL_RES_I field.
	XCVR_RX_DIG_DCOC_CAL2_DCOC_CAL_RES_I_Msk = 0xfff
	// Position of DCOC_CAL_RES_Q field.
	XCVR_RX_DIG_DCOC_CAL2_DCOC_CAL_RES_Q_Pos = 0x10
	// Bit mask of DCOC_CAL_RES_Q field.
	XCVR_RX_DIG_DCOC_CAL2_DCOC_CAL_RES_Q_Msk = 0xfff0000

	// DCOC_CAL3: DCOC Calibration Result
	// Position of DCOC_CAL_RES_I field.
	XCVR_RX_DIG_DCOC_CAL3_DCOC_CAL_RES_I_Pos = 0x0
	// Bit mask of DCOC_CAL_RES_I field.
	XCVR_RX_DIG_DCOC_CAL3_DCOC_CAL_RES_I_Msk = 0xfff
	// Position of DCOC_CAL_RES_Q field.
	XCVR_RX_DIG_DCOC_CAL3_DCOC_CAL_RES_Q_Pos = 0x10
	// Bit mask of DCOC_CAL_RES_Q field.
	XCVR_RX_DIG_DCOC_CAL3_DCOC_CAL_RES_Q_Msk = 0xfff0000

	// CCA_ED_LQI_CTRL_0: RX_DIG CCA ED LQI Control Register 0
	// Position of LQI_CORR_THRESH field.
	XCVR_RX_DIG_CCA_ED_LQI_CTRL_0_LQI_CORR_THRESH_Pos = 0x0
	// Bit mask of LQI_CORR_THRESH field.
	XCVR_RX_DIG_CCA_ED_LQI_CTRL_0_LQI_CORR_THRESH_Msk = 0xff
	// Position of CORR_CNTR_THRESH field.
	XCVR_RX_DIG_CCA_ED_LQI_CTRL_0_CORR_CNTR_THRESH_Pos = 0x8
	// Bit mask of CORR_CNTR_THRESH field.
	XCVR_RX_DIG_CCA_ED_LQI_CTRL_0_CORR_CNTR_THRESH_Msk = 0xff00
	// Position of LQI_CNTR field.
	XCVR_RX_DIG_CCA_ED_LQI_CTRL_0_LQI_CNTR_Pos = 0x10
	// Bit mask of LQI_CNTR field.
	XCVR_RX_DIG_CCA_ED_LQI_CTRL_0_LQI_CNTR_Msk = 0xff0000
	// Position of SNR_ADJ field.
	XCVR_RX_DIG_CCA_ED_LQI_CTRL_0_SNR_ADJ_Pos = 0x18
	// Bit mask of SNR_ADJ field.
	XCVR_RX_DIG_CCA_ED_LQI_CTRL_0_SNR_ADJ_Msk = 0x3f000000

	// CCA_ED_LQI_CTRL_1: RX_DIG CCA ED LQI Control Register 1
	// Position of RSSI_NOISE_AVG_DELAY field.
	XCVR_RX_DIG_CCA_ED_LQI_CTRL_1_RSSI_NOISE_AVG_DELAY_Pos = 0x0
	// Bit mask of RSSI_NOISE_AVG_DELAY field.
	XCVR_RX_DIG_CCA_ED_LQI_CTRL_1_RSSI_NOISE_AVG_DELAY_Msk = 0x3f
	// Position of RSSI_NOISE_AVG_FACTOR field.
	XCVR_RX_DIG_CCA_ED_LQI_CTRL_1_RSSI_NOISE_AVG_FACTOR_Pos = 0x6
	// Bit mask of RSSI_NOISE_AVG_FACTOR field.
	XCVR_RX_DIG_CCA_ED_LQI_CTRL_1_RSSI_NOISE_AVG_FACTOR_Msk = 0x1c0
	// 1
	XCVR_RX_DIG_CCA_ED_LQI_CTRL_1_RSSI_NOISE_AVG_FACTOR_0 = 0x0
	// 64
	XCVR_RX_DIG_CCA_ED_LQI_CTRL_1_RSSI_NOISE_AVG_FACTOR_1 = 0x1
	// 70
	XCVR_RX_DIG_CCA_ED_LQI_CTRL_1_RSSI_NOISE_AVG_FACTOR_2 = 0x2
	// 128
	XCVR_RX_DIG_CCA_ED_LQI_CTRL_1_RSSI_NOISE_AVG_FACTOR_3 = 0x3
	// 139
	XCVR_RX_DIG_CCA_ED_LQI_CTRL_1_RSSI_NOISE_AVG_FACTOR_4 = 0x4
	// 256
	XCVR_RX_DIG_CCA_ED_LQI_CTRL_1_RSSI_NOISE_AVG_FACTOR_5 = 0x5
	// 277
	XCVR_RX_DIG_CCA_ED_LQI_CTRL_1_RSSI_NOISE_AVG_FACTOR_6 = 0x6
	// 512
	XCVR_RX_DIG_CCA_ED_LQI_CTRL_1_RSSI_NOISE_AVG_FACTOR_7 = 0x7
	// Position of LQI_RSSI_WEIGHT field.
	XCVR_RX_DIG_CCA_ED_LQI_CTRL_1_LQI_RSSI_WEIGHT_Pos = 0x9
	// Bit mask of LQI_RSSI_WEIGHT field.
	XCVR_RX_DIG_CCA_ED_LQI_CTRL_1_LQI_RSSI_WEIGHT_Msk = 0xe00
	// 2.0
	XCVR_RX_DIG_CCA_ED_LQI_CTRL_1_LQI_RSSI_WEIGHT_0 = 0x0
	// 2.125
	XCVR_RX_DIG_CCA_ED_LQI_CTRL_1_LQI_RSSI_WEIGHT_1 = 0x1
	// 2.25
	XCVR_RX_DIG_CCA_ED_LQI_CTRL_1_LQI_RSSI_WEIGHT_2 = 0x2
	// 2.375
	XCVR_RX_DIG_CCA_ED_LQI_CTRL_1_LQI_RSSI_WEIGHT_3 = 0x3
	// 2.5
	XCVR_RX_DIG_CCA_ED_LQI_CTRL_1_LQI_RSSI_WEIGHT_4 = 0x4
	// 2.625
	XCVR_RX_DIG_CCA_ED_LQI_CTRL_1_LQI_RSSI_WEIGHT_5 = 0x5
	// 2.75
	XCVR_RX_DIG_CCA_ED_LQI_CTRL_1_LQI_RSSI_WEIGHT_6 = 0x6
	// 2.875
	XCVR_RX_DIG_CCA_ED_LQI_CTRL_1_LQI_RSSI_WEIGHT_7 = 0x7
	// Position of LQI_RSSI_SENS field.
	XCVR_RX_DIG_CCA_ED_LQI_CTRL_1_LQI_RSSI_SENS_Pos = 0xc
	// Bit mask of LQI_RSSI_SENS field.
	XCVR_RX_DIG_CCA_ED_LQI_CTRL_1_LQI_RSSI_SENS_Msk = 0xf000
	// Position of SNR_LQI_DIS field.
	XCVR_RX_DIG_CCA_ED_LQI_CTRL_1_SNR_LQI_DIS_Pos = 0x10
	// Bit mask of SNR_LQI_DIS field.
	XCVR_RX_DIG_CCA_ED_LQI_CTRL_1_SNR_LQI_DIS_Msk = 0x10000
	// Bit SNR_LQI_DIS.
	XCVR_RX_DIG_CCA_ED_LQI_CTRL_1_SNR_LQI_DIS = 0x10000
	// Normal operation.
	XCVR_RX_DIG_CCA_ED_LQI_CTRL_1_SNR_LQI_DIS_0 = 0x0
	// The RX_DIG CCA/ED/LQI block ignores the AA match input which starts an LQI measurement.
	XCVR_RX_DIG_CCA_ED_LQI_CTRL_1_SNR_LQI_DIS_1 = 0x1
	// Position of SEL_SNR_MODE field.
	XCVR_RX_DIG_CCA_ED_LQI_CTRL_1_SEL_SNR_MODE_Pos = 0x11
	// Bit mask of SEL_SNR_MODE field.
	XCVR_RX_DIG_CCA_ED_LQI_CTRL_1_SEL_SNR_MODE_Msk = 0x20000
	// Bit SEL_SNR_MODE.
	XCVR_RX_DIG_CCA_ED_LQI_CTRL_1_SEL_SNR_MODE = 0x20000
	// SNR estimate
	XCVR_RX_DIG_CCA_ED_LQI_CTRL_1_SEL_SNR_MODE_0 = 0x0
	// Mapped correlation magnitude
	XCVR_RX_DIG_CCA_ED_LQI_CTRL_1_SEL_SNR_MODE_1 = 0x1
	// Position of MEAS_TRANS_TO_IDLE field.
	XCVR_RX_DIG_CCA_ED_LQI_CTRL_1_MEAS_TRANS_TO_IDLE_Pos = 0x12
	// Bit mask of MEAS_TRANS_TO_IDLE field.
	XCVR_RX_DIG_CCA_ED_LQI_CTRL_1_MEAS_TRANS_TO_IDLE_Msk = 0x40000
	// Bit MEAS_TRANS_TO_IDLE.
	XCVR_RX_DIG_CCA_ED_LQI_CTRL_1_MEAS_TRANS_TO_IDLE = 0x40000
	// Module transitions to RSSI state
	XCVR_RX_DIG_CCA_ED_LQI_CTRL_1_MEAS_TRANS_TO_IDLE_0 = 0x0
	// Module transitions to IDLE state
	XCVR_RX_DIG_CCA_ED_LQI_CTRL_1_MEAS_TRANS_TO_IDLE_1 = 0x1
	// Position of CCA1_ED_EN_DIS field.
	XCVR_RX_DIG_CCA_ED_LQI_CTRL_1_CCA1_ED_EN_DIS_Pos = 0x13
	// Bit mask of CCA1_ED_EN_DIS field.
	XCVR_RX_DIG_CCA_ED_LQI_CTRL_1_CCA1_ED_EN_DIS_Msk = 0x80000
	// Bit CCA1_ED_EN_DIS.
	XCVR_RX_DIG_CCA_ED_LQI_CTRL_1_CCA1_ED_EN_DIS = 0x80000
	// Normal operation
	XCVR_RX_DIG_CCA_ED_LQI_CTRL_1_CCA1_ED_EN_DIS_0 = 0x0
	// CCA1_ED_EN input is disabled
	XCVR_RX_DIG_CCA_ED_LQI_CTRL_1_CCA1_ED_EN_DIS_1 = 0x1
	// Position of MAN_MEAS_COMPLETE field.
	XCVR_RX_DIG_CCA_ED_LQI_CTRL_1_MAN_MEAS_COMPLETE_Pos = 0x14
	// Bit mask of MAN_MEAS_COMPLETE field.
	XCVR_RX_DIG_CCA_ED_LQI_CTRL_1_MAN_MEAS_COMPLETE_Msk = 0x100000
	// Bit MAN_MEAS_COMPLETE.
	XCVR_RX_DIG_CCA_ED_LQI_CTRL_1_MAN_MEAS_COMPLETE = 0x100000
	// Normal operation
	XCVR_RX_DIG_CCA_ED_LQI_CTRL_1_MAN_MEAS_COMPLETE_0 = 0x0
	// Manually asserts the measurement complete signal for the RX_DIG CCA/ED/LQI blocks. Intended to be used only for debug.
	XCVR_RX_DIG_CCA_ED_LQI_CTRL_1_MAN_MEAS_COMPLETE_1 = 0x1
	// Position of MAN_AA_MATCH field.
	XCVR_RX_DIG_CCA_ED_LQI_CTRL_1_MAN_AA_MATCH_Pos = 0x15
	// Bit mask of MAN_AA_MATCH field.
	XCVR_RX_DIG_CCA_ED_LQI_CTRL_1_MAN_AA_MATCH_Msk = 0x200000
	// Bit MAN_AA_MATCH.
	XCVR_RX_DIG_CCA_ED_LQI_CTRL_1_MAN_AA_MATCH = 0x200000
	// Normal operation
	XCVR_RX_DIG_CCA_ED_LQI_CTRL_1_MAN_AA_MATCH_0 = 0x0
	// Manually asserts the AA match signal for the RX_DIG CCA/ED/LQI and AGC blocks. Intended to be used only for debug.
	XCVR_RX_DIG_CCA_ED_LQI_CTRL_1_MAN_AA_MATCH_1 = 0x1
	// Position of SNR_LQI_WEIGHT field.
	XCVR_RX_DIG_CCA_ED_LQI_CTRL_1_SNR_LQI_WEIGHT_Pos = 0x18
	// Bit mask of SNR_LQI_WEIGHT field.
	XCVR_RX_DIG_CCA_ED_LQI_CTRL_1_SNR_LQI_WEIGHT_Msk = 0xf000000
	// 0.0
	XCVR_RX_DIG_CCA_ED_LQI_CTRL_1_SNR_LQI_WEIGHT_0 = 0x0
	// 1.0
	XCVR_RX_DIG_CCA_ED_LQI_CTRL_1_SNR_LQI_WEIGHT_1 = 0x1
	// 1.125
	XCVR_RX_DIG_CCA_ED_LQI_CTRL_1_SNR_LQI_WEIGHT_2 = 0x2
	// 1.25
	XCVR_RX_DIG_CCA_ED_LQI_CTRL_1_SNR_LQI_WEIGHT_3 = 0x3
	// 1.375
	XCVR_RX_DIG_CCA_ED_LQI_CTRL_1_SNR_LQI_WEIGHT_4 = 0x4
	// 1.5
	XCVR_RX_DIG_CCA_ED_LQI_CTRL_1_SNR_LQI_WEIGHT_5 = 0x5
	// 1.625
	XCVR_RX_DIG_CCA_ED_LQI_CTRL_1_SNR_LQI_WEIGHT_6 = 0x6
	// 1.75
	XCVR_RX_DIG_CCA_ED_LQI_CTRL_1_SNR_LQI_WEIGHT_7 = 0x7
	// 1.875
	XCVR_RX_DIG_CCA_ED_LQI_CTRL_1_SNR_LQI_WEIGHT_8 = 0x8
	// 2.0
	XCVR_RX_DIG_CCA_ED_LQI_CTRL_1_SNR_LQI_WEIGHT_9 = 0x9
	// 2.125
	XCVR_RX_DIG_CCA_ED_LQI_CTRL_1_SNR_LQI_WEIGHT_10 = 0xa
	// 2.25
	XCVR_RX_DIG_CCA_ED_LQI_CTRL_1_SNR_LQI_WEIGHT_11 = 0xb
	// 2.375
	XCVR_RX_DIG_CCA_ED_LQI_CTRL_1_SNR_LQI_WEIGHT_12 = 0xc
	// 2.5
	XCVR_RX_DIG_CCA_ED_LQI_CTRL_1_SNR_LQI_WEIGHT_13 = 0xd
	// 2.625
	XCVR_RX_DIG_CCA_ED_LQI_CTRL_1_SNR_LQI_WEIGHT_14 = 0xe
	// 2.75
	XCVR_RX_DIG_CCA_ED_LQI_CTRL_1_SNR_LQI_WEIGHT_15 = 0xf
	// Position of LQI_BIAS field.
	XCVR_RX_DIG_CCA_ED_LQI_CTRL_1_LQI_BIAS_Pos = 0x1c
	// Bit mask of LQI_BIAS field.
	XCVR_RX_DIG_CCA_ED_LQI_CTRL_1_LQI_BIAS_Msk = 0xf0000000

	// CCA_ED_LQI_STAT_0: RX_DIG CCA ED LQI Status Register 0
	// Position of LQI_OUT field.
	XCVR_RX_DIG_CCA_ED_LQI_STAT_0_LQI_OUT_Pos = 0x0
	// Bit mask of LQI_OUT field.
	XCVR_RX_DIG_CCA_ED_LQI_STAT_0_LQI_OUT_Msk = 0xff
	// Position of ED_OUT field.
	XCVR_RX_DIG_CCA_ED_LQI_STAT_0_ED_OUT_Pos = 0x8
	// Bit mask of ED_OUT field.
	XCVR_RX_DIG_CCA_ED_LQI_STAT_0_ED_OUT_Msk = 0xff00
	// Position of SNR_OUT field.
	XCVR_RX_DIG_CCA_ED_LQI_STAT_0_SNR_OUT_Pos = 0x10
	// Bit mask of SNR_OUT field.
	XCVR_RX_DIG_CCA_ED_LQI_STAT_0_SNR_OUT_Msk = 0xff0000
	// Position of CCA1_STATE field.
	XCVR_RX_DIG_CCA_ED_LQI_STAT_0_CCA1_STATE_Pos = 0x18
	// Bit mask of CCA1_STATE field.
	XCVR_RX_DIG_CCA_ED_LQI_STAT_0_CCA1_STATE_Msk = 0x1000000
	// Bit CCA1_STATE.
	XCVR_RX_DIG_CCA_ED_LQI_STAT_0_CCA1_STATE = 0x1000000
	// Position of MEAS_COMPLETE field.
	XCVR_RX_DIG_CCA_ED_LQI_STAT_0_MEAS_COMPLETE_Pos = 0x19
	// Bit mask of MEAS_COMPLETE field.
	XCVR_RX_DIG_CCA_ED_LQI_STAT_0_MEAS_COMPLETE_Msk = 0x2000000
	// Bit MEAS_COMPLETE.
	XCVR_RX_DIG_CCA_ED_LQI_STAT_0_MEAS_COMPLETE = 0x2000000

	// RX_CHF_COEF_0: Receive Channel Filter Coefficient 0
	// Position of RX_CH_FILT_H0 field.
	XCVR_RX_DIG_RX_CHF_COEF_0_RX_CH_FILT_H0_Pos = 0x0
	// Bit mask of RX_CH_FILT_H0 field.
	XCVR_RX_DIG_RX_CHF_COEF_0_RX_CH_FILT_H0_Msk = 0x3f

	// RX_CHF_COEF_1: Receive Channel Filter Coefficient 1
	// Position of RX_CH_FILT_H1 field.
	XCVR_RX_DIG_RX_CHF_COEF_1_RX_CH_FILT_H1_Pos = 0x0
	// Bit mask of RX_CH_FILT_H1 field.
	XCVR_RX_DIG_RX_CHF_COEF_1_RX_CH_FILT_H1_Msk = 0x3f

	// RX_CHF_COEF_2: Receive Channel Filter Coefficient 2
	// Position of RX_CH_FILT_H2 field.
	XCVR_RX_DIG_RX_CHF_COEF_2_RX_CH_FILT_H2_Pos = 0x0
	// Bit mask of RX_CH_FILT_H2 field.
	XCVR_RX_DIG_RX_CHF_COEF_2_RX_CH_FILT_H2_Msk = 0x7f

	// RX_CHF_COEF_3: Receive Channel Filter Coefficient 3
	// Position of RX_CH_FILT_H3 field.
	XCVR_RX_DIG_RX_CHF_COEF_3_RX_CH_FILT_H3_Pos = 0x0
	// Bit mask of RX_CH_FILT_H3 field.
	XCVR_RX_DIG_RX_CHF_COEF_3_RX_CH_FILT_H3_Msk = 0x7f

	// RX_CHF_COEF_4: Receive Channel Filter Coefficient 4
	// Position of RX_CH_FILT_H4 field.
	XCVR_RX_DIG_RX_CHF_COEF_4_RX_CH_FILT_H4_Pos = 0x0
	// Bit mask of RX_CH_FILT_H4 field.
	XCVR_RX_DIG_RX_CHF_COEF_4_RX_CH_FILT_H4_Msk = 0x7f

	// RX_CHF_COEF_5: Receive Channel Filter Coefficient 5
	// Position of RX_CH_FILT_H5 field.
	XCVR_RX_DIG_RX_CHF_COEF_5_RX_CH_FILT_H5_Pos = 0x0
	// Bit mask of RX_CH_FILT_H5 field.
	XCVR_RX_DIG_RX_CHF_COEF_5_RX_CH_FILT_H5_Msk = 0x7f

	// RX_CHF_COEF_6: Receive Channel Filter Coefficient 6
	// Position of RX_CH_FILT_H6 field.
	XCVR_RX_DIG_RX_CHF_COEF_6_RX_CH_FILT_H6_Pos = 0x0
	// Bit mask of RX_CH_FILT_H6 field.
	XCVR_RX_DIG_RX_CHF_COEF_6_RX_CH_FILT_H6_Msk = 0xff

	// RX_CHF_COEF_7: Receive Channel Filter Coefficient 7
	// Position of RX_CH_FILT_H7 field.
	XCVR_RX_DIG_RX_CHF_COEF_7_RX_CH_FILT_H7_Pos = 0x0
	// Bit mask of RX_CH_FILT_H7 field.
	XCVR_RX_DIG_RX_CHF_COEF_7_RX_CH_FILT_H7_Msk = 0xff

	// RX_CHF_COEF_8: Receive Channel Filter Coefficient 8
	// Position of RX_CH_FILT_H8 field.
	XCVR_RX_DIG_RX_CHF_COEF_8_RX_CH_FILT_H8_Pos = 0x0
	// Bit mask of RX_CH_FILT_H8 field.
	XCVR_RX_DIG_RX_CHF_COEF_8_RX_CH_FILT_H8_Msk = 0x1ff

	// RX_CHF_COEF_9: Receive Channel Filter Coefficient 9
	// Position of RX_CH_FILT_H9 field.
	XCVR_RX_DIG_RX_CHF_COEF_9_RX_CH_FILT_H9_Pos = 0x0
	// Bit mask of RX_CH_FILT_H9 field.
	XCVR_RX_DIG_RX_CHF_COEF_9_RX_CH_FILT_H9_Msk = 0x1ff

	// RX_CHF_COEF_10: Receive Channel Filter Coefficient 10
	// Position of RX_CH_FILT_H10 field.
	XCVR_RX_DIG_RX_CHF_COEF_10_RX_CH_FILT_H10_Pos = 0x0
	// Bit mask of RX_CH_FILT_H10 field.
	XCVR_RX_DIG_RX_CHF_COEF_10_RX_CH_FILT_H10_Msk = 0x3ff

	// RX_CHF_COEF_11: Receive Channel Filter Coefficient 11
	// Position of RX_CH_FILT_H11 field.
	XCVR_RX_DIG_RX_CHF_COEF_11_RX_CH_FILT_H11_Pos = 0x0
	// Bit mask of RX_CH_FILT_H11 field.
	XCVR_RX_DIG_RX_CHF_COEF_11_RX_CH_FILT_H11_Msk = 0x3ff

	// AGC_MAN_AGC_IDX: AGC Manual AGC Index
	// Position of AGC_MAN_IDX field.
	XCVR_RX_DIG_AGC_MAN_AGC_IDX_AGC_MAN_IDX_Pos = 0x10
	// Bit mask of AGC_MAN_IDX field.
	XCVR_RX_DIG_AGC_MAN_AGC_IDX_AGC_MAN_IDX_Msk = 0x1f0000
	// Position of AGC_MAN_IDX_EN field.
	XCVR_RX_DIG_AGC_MAN_AGC_IDX_AGC_MAN_IDX_EN_Pos = 0x18
	// Bit mask of AGC_MAN_IDX_EN field.
	XCVR_RX_DIG_AGC_MAN_AGC_IDX_AGC_MAN_IDX_EN_Msk = 0x1000000
	// Bit AGC_MAN_IDX_EN.
	XCVR_RX_DIG_AGC_MAN_AGC_IDX_AGC_MAN_IDX_EN = 0x1000000
	// Position of AGC_DCOC_START_PT field.
	XCVR_RX_DIG_AGC_MAN_AGC_IDX_AGC_DCOC_START_PT_Pos = 0x19
	// Bit mask of AGC_DCOC_START_PT field.
	XCVR_RX_DIG_AGC_MAN_AGC_IDX_AGC_DCOC_START_PT_Msk = 0x2000000
	// Bit AGC_DCOC_START_PT.
	XCVR_RX_DIG_AGC_MAN_AGC_IDX_AGC_DCOC_START_PT = 0x2000000

	// DC_RESID_CTRL: DC Residual Control
	// Position of DC_RESID_NWIN field.
	XCVR_RX_DIG_DC_RESID_CTRL_DC_RESID_NWIN_Pos = 0x0
	// Bit mask of DC_RESID_NWIN field.
	XCVR_RX_DIG_DC_RESID_CTRL_DC_RESID_NWIN_Msk = 0x7f
	// Position of DC_RESID_ITER_FREEZE field.
	XCVR_RX_DIG_DC_RESID_CTRL_DC_RESID_ITER_FREEZE_Pos = 0x8
	// Bit mask of DC_RESID_ITER_FREEZE field.
	XCVR_RX_DIG_DC_RESID_CTRL_DC_RESID_ITER_FREEZE_Msk = 0xf00
	// Position of DC_RESID_ALPHA field.
	XCVR_RX_DIG_DC_RESID_CTRL_DC_RESID_ALPHA_Pos = 0xc
	// Bit mask of DC_RESID_ALPHA field.
	XCVR_RX_DIG_DC_RESID_CTRL_DC_RESID_ALPHA_Msk = 0x7000
	// Position of DC_RESID_DLY field.
	XCVR_RX_DIG_DC_RESID_CTRL_DC_RESID_DLY_Pos = 0x10
	// Bit mask of DC_RESID_DLY field.
	XCVR_RX_DIG_DC_RESID_CTRL_DC_RESID_DLY_Msk = 0x70000
	// Position of DC_RESID_EXT_DC_EN field.
	XCVR_RX_DIG_DC_RESID_CTRL_DC_RESID_EXT_DC_EN_Pos = 0x14
	// Bit mask of DC_RESID_EXT_DC_EN field.
	XCVR_RX_DIG_DC_RESID_CTRL_DC_RESID_EXT_DC_EN_Msk = 0x100000
	// Bit DC_RESID_EXT_DC_EN.
	XCVR_RX_DIG_DC_RESID_CTRL_DC_RESID_EXT_DC_EN = 0x100000
	// Position of DC_RESID_MIN_AGC_IDX field.
	XCVR_RX_DIG_DC_RESID_CTRL_DC_RESID_MIN_AGC_IDX_Pos = 0x18
	// Bit mask of DC_RESID_MIN_AGC_IDX field.
	XCVR_RX_DIG_DC_RESID_CTRL_DC_RESID_MIN_AGC_IDX_Msk = 0x1f000000

	// DC_RESID_EST: DC Residual Estimate
	// Position of DC_RESID_OFFSET_I field.
	XCVR_RX_DIG_DC_RESID_EST_DC_RESID_OFFSET_I_Pos = 0x0
	// Bit mask of DC_RESID_OFFSET_I field.
	XCVR_RX_DIG_DC_RESID_EST_DC_RESID_OFFSET_I_Msk = 0x1fff
	// Position of DC_RESID_OFFSET_Q field.
	XCVR_RX_DIG_DC_RESID_EST_DC_RESID_OFFSET_Q_Pos = 0x10
	// Bit mask of DC_RESID_OFFSET_Q field.
	XCVR_RX_DIG_DC_RESID_EST_DC_RESID_OFFSET_Q_Msk = 0x1fff0000

	// RX_RCCAL_CTRL0: RX RC Calibration Control0
	// Position of BBA_RCCAL_OFFSET field.
	XCVR_RX_DIG_RX_RCCAL_CTRL0_BBA_RCCAL_OFFSET_Pos = 0x0
	// Bit mask of BBA_RCCAL_OFFSET field.
	XCVR_RX_DIG_RX_RCCAL_CTRL0_BBA_RCCAL_OFFSET_Msk = 0xf
	// Position of BBA_RCCAL_MANUAL field.
	XCVR_RX_DIG_RX_RCCAL_CTRL0_BBA_RCCAL_MANUAL_Pos = 0x4
	// Bit mask of BBA_RCCAL_MANUAL field.
	XCVR_RX_DIG_RX_RCCAL_CTRL0_BBA_RCCAL_MANUAL_Msk = 0x1f0
	// Position of BBA_RCCAL_DIS field.
	XCVR_RX_DIG_RX_RCCAL_CTRL0_BBA_RCCAL_DIS_Pos = 0x9
	// Bit mask of BBA_RCCAL_DIS field.
	XCVR_RX_DIG_RX_RCCAL_CTRL0_BBA_RCCAL_DIS_Msk = 0x200
	// Bit BBA_RCCAL_DIS.
	XCVR_RX_DIG_RX_RCCAL_CTRL0_BBA_RCCAL_DIS = 0x200
	// BBA RC Calibration is enabled
	XCVR_RX_DIG_RX_RCCAL_CTRL0_BBA_RCCAL_DIS_0 = 0x0
	// BBA RC Calibration is disabled
	XCVR_RX_DIG_RX_RCCAL_CTRL0_BBA_RCCAL_DIS_1 = 0x1
	// Position of RCCAL_SMP_DLY field.
	XCVR_RX_DIG_RX_RCCAL_CTRL0_RCCAL_SMP_DLY_Pos = 0xc
	// Bit mask of RCCAL_SMP_DLY field.
	XCVR_RX_DIG_RX_RCCAL_CTRL0_RCCAL_SMP_DLY_Msk = 0x3000
	// The comp_out signal is sampled 0 clk cycle after sample signal is deasserted
	XCVR_RX_DIG_RX_RCCAL_CTRL0_RCCAL_SMP_DLY_00 = 0x0
	// The comp_out signal is sampled 1 clk cycle after sample signal is deasserted
	XCVR_RX_DIG_RX_RCCAL_CTRL0_RCCAL_SMP_DLY_01 = 0x1
	// The comp_out signal is sampled 2 clk cycle after sample signal is deasserted
	XCVR_RX_DIG_RX_RCCAL_CTRL0_RCCAL_SMP_DLY_10 = 0x2
	// The comp_out signal is sampled 3 clk cycle after sample signal is deasserted
	XCVR_RX_DIG_RX_RCCAL_CTRL0_RCCAL_SMP_DLY_11 = 0x3
	// Position of RCCAL_COMP_INV field.
	XCVR_RX_DIG_RX_RCCAL_CTRL0_RCCAL_COMP_INV_Pos = 0xf
	// Bit mask of RCCAL_COMP_INV field.
	XCVR_RX_DIG_RX_RCCAL_CTRL0_RCCAL_COMP_INV_Msk = 0x8000
	// Bit RCCAL_COMP_INV.
	XCVR_RX_DIG_RX_RCCAL_CTRL0_RCCAL_COMP_INV = 0x8000
	// The comp_out signal polarity is NOT inverted
	XCVR_RX_DIG_RX_RCCAL_CTRL0_RCCAL_COMP_INV_0 = 0x0
	// The comp_out signal polarity is inverted
	XCVR_RX_DIG_RX_RCCAL_CTRL0_RCCAL_COMP_INV_1 = 0x1
	// Position of TZA_RCCAL_OFFSET field.
	XCVR_RX_DIG_RX_RCCAL_CTRL0_TZA_RCCAL_OFFSET_Pos = 0x10
	// Bit mask of TZA_RCCAL_OFFSET field.
	XCVR_RX_DIG_RX_RCCAL_CTRL0_TZA_RCCAL_OFFSET_Msk = 0xf0000
	// Position of TZA_RCCAL_MANUAL field.
	XCVR_RX_DIG_RX_RCCAL_CTRL0_TZA_RCCAL_MANUAL_Pos = 0x14
	// Bit mask of TZA_RCCAL_MANUAL field.
	XCVR_RX_DIG_RX_RCCAL_CTRL0_TZA_RCCAL_MANUAL_Msk = 0x1f00000
	// Position of TZA_RCCAL_DIS field.
	XCVR_RX_DIG_RX_RCCAL_CTRL0_TZA_RCCAL_DIS_Pos = 0x19
	// Bit mask of TZA_RCCAL_DIS field.
	XCVR_RX_DIG_RX_RCCAL_CTRL0_TZA_RCCAL_DIS_Msk = 0x2000000
	// Bit TZA_RCCAL_DIS.
	XCVR_RX_DIG_RX_RCCAL_CTRL0_TZA_RCCAL_DIS = 0x2000000
	// TZA RC Calibration is enabled
	XCVR_RX_DIG_RX_RCCAL_CTRL0_TZA_RCCAL_DIS_0 = 0x0
	// TZA RC Calibration is disabled
	XCVR_RX_DIG_RX_RCCAL_CTRL0_TZA_RCCAL_DIS_1 = 0x1

	// RX_RCCAL_CTRL1: RX RC Calibration Control1
	// Position of ADC_RCCAL_OFFSET field.
	XCVR_RX_DIG_RX_RCCAL_CTRL1_ADC_RCCAL_OFFSET_Pos = 0x0
	// Bit mask of ADC_RCCAL_OFFSET field.
	XCVR_RX_DIG_RX_RCCAL_CTRL1_ADC_RCCAL_OFFSET_Msk = 0xf
	// Position of ADC_RCCAL_MANUAL field.
	XCVR_RX_DIG_RX_RCCAL_CTRL1_ADC_RCCAL_MANUAL_Pos = 0x4
	// Bit mask of ADC_RCCAL_MANUAL field.
	XCVR_RX_DIG_RX_RCCAL_CTRL1_ADC_RCCAL_MANUAL_Msk = 0x1f0
	// Position of ADC_RCCAL_DIS field.
	XCVR_RX_DIG_RX_RCCAL_CTRL1_ADC_RCCAL_DIS_Pos = 0x9
	// Bit mask of ADC_RCCAL_DIS field.
	XCVR_RX_DIG_RX_RCCAL_CTRL1_ADC_RCCAL_DIS_Msk = 0x200
	// Bit ADC_RCCAL_DIS.
	XCVR_RX_DIG_RX_RCCAL_CTRL1_ADC_RCCAL_DIS = 0x200
	// ADC RC Calibration is enabled
	XCVR_RX_DIG_RX_RCCAL_CTRL1_ADC_RCCAL_DIS_0 = 0x0
	// ADC RC Calibration is disabled
	XCVR_RX_DIG_RX_RCCAL_CTRL1_ADC_RCCAL_DIS_1 = 0x1
	// Position of BBA2_RCCAL_OFFSET field.
	XCVR_RX_DIG_RX_RCCAL_CTRL1_BBA2_RCCAL_OFFSET_Pos = 0x10
	// Bit mask of BBA2_RCCAL_OFFSET field.
	XCVR_RX_DIG_RX_RCCAL_CTRL1_BBA2_RCCAL_OFFSET_Msk = 0xf0000
	// Position of BBA2_RCCAL_MANUAL field.
	XCVR_RX_DIG_RX_RCCAL_CTRL1_BBA2_RCCAL_MANUAL_Pos = 0x14
	// Bit mask of BBA2_RCCAL_MANUAL field.
	XCVR_RX_DIG_RX_RCCAL_CTRL1_BBA2_RCCAL_MANUAL_Msk = 0x1f00000
	// Position of BBA2_RCCAL_DIS field.
	XCVR_RX_DIG_RX_RCCAL_CTRL1_BBA2_RCCAL_DIS_Pos = 0x19
	// Bit mask of BBA2_RCCAL_DIS field.
	XCVR_RX_DIG_RX_RCCAL_CTRL1_BBA2_RCCAL_DIS_Msk = 0x2000000
	// Bit BBA2_RCCAL_DIS.
	XCVR_RX_DIG_RX_RCCAL_CTRL1_BBA2_RCCAL_DIS = 0x2000000
	// BBA2 RC Calibration is enabled
	XCVR_RX_DIG_RX_RCCAL_CTRL1_BBA2_RCCAL_DIS_0 = 0x0
	// BBA2 RC Calibration is disabled
	XCVR_RX_DIG_RX_RCCAL_CTRL1_BBA2_RCCAL_DIS_1 = 0x1

	// RX_RCCAL_STAT: RX RC Calibration Status
	// Position of RCCAL_CODE field.
	XCVR_RX_DIG_RX_RCCAL_STAT_RCCAL_CODE_Pos = 0x0
	// Bit mask of RCCAL_CODE field.
	XCVR_RX_DIG_RX_RCCAL_STAT_RCCAL_CODE_Msk = 0x1f
	// Position of ADC_RCCAL field.
	XCVR_RX_DIG_RX_RCCAL_STAT_ADC_RCCAL_Pos = 0x5
	// Bit mask of ADC_RCCAL field.
	XCVR_RX_DIG_RX_RCCAL_STAT_ADC_RCCAL_Msk = 0x3e0
	// Position of BBA2_RCCAL field.
	XCVR_RX_DIG_RX_RCCAL_STAT_BBA2_RCCAL_Pos = 0xa
	// Bit mask of BBA2_RCCAL field.
	XCVR_RX_DIG_RX_RCCAL_STAT_BBA2_RCCAL_Msk = 0x7c00
	// Position of BBA_RCCAL field.
	XCVR_RX_DIG_RX_RCCAL_STAT_BBA_RCCAL_Pos = 0x10
	// Bit mask of BBA_RCCAL field.
	XCVR_RX_DIG_RX_RCCAL_STAT_BBA_RCCAL_Msk = 0x1f0000
	// Position of TZA_RCCAL field.
	XCVR_RX_DIG_RX_RCCAL_STAT_TZA_RCCAL_Pos = 0x15
	// Bit mask of TZA_RCCAL field.
	XCVR_RX_DIG_RX_RCCAL_STAT_TZA_RCCAL_Msk = 0x3e00000

	// AUXPLL_FCAL_CTRL: Aux PLL Frequency Calibration Control
	// Position of DAC_CAL_ADJUST_MANUAL field.
	XCVR_RX_DIG_AUXPLL_FCAL_CTRL_DAC_CAL_ADJUST_MANUAL_Pos = 0x0
	// Bit mask of DAC_CAL_ADJUST_MANUAL field.
	XCVR_RX_DIG_AUXPLL_FCAL_CTRL_DAC_CAL_ADJUST_MANUAL_Msk = 0x7f
	// Position of AUXPLL_DAC_CAL_ADJUST_DIS field.
	XCVR_RX_DIG_AUXPLL_FCAL_CTRL_AUXPLL_DAC_CAL_ADJUST_DIS_Pos = 0x7
	// Bit mask of AUXPLL_DAC_CAL_ADJUST_DIS field.
	XCVR_RX_DIG_AUXPLL_FCAL_CTRL_AUXPLL_DAC_CAL_ADJUST_DIS_Msk = 0x80
	// Bit AUXPLL_DAC_CAL_ADJUST_DIS.
	XCVR_RX_DIG_AUXPLL_FCAL_CTRL_AUXPLL_DAC_CAL_ADJUST_DIS = 0x80
	// Calibration is enabled
	XCVR_RX_DIG_AUXPLL_FCAL_CTRL_AUXPLL_DAC_CAL_ADJUST_DIS_0 = 0x0
	// Calibration is disabled
	XCVR_RX_DIG_AUXPLL_FCAL_CTRL_AUXPLL_DAC_CAL_ADJUST_DIS_1 = 0x1
	// Position of FCAL_RUN_CNT field.
	XCVR_RX_DIG_AUXPLL_FCAL_CTRL_FCAL_RUN_CNT_Pos = 0x8
	// Bit mask of FCAL_RUN_CNT field.
	XCVR_RX_DIG_AUXPLL_FCAL_CTRL_FCAL_RUN_CNT_Msk = 0x100
	// Bit FCAL_RUN_CNT.
	XCVR_RX_DIG_AUXPLL_FCAL_CTRL_FCAL_RUN_CNT = 0x100
	// Run count is 256 clock cycles
	XCVR_RX_DIG_AUXPLL_FCAL_CTRL_FCAL_RUN_CNT_0 = 0x0
	// Run count is 512 clock cycles
	XCVR_RX_DIG_AUXPLL_FCAL_CTRL_FCAL_RUN_CNT_1 = 0x1
	// Position of FCAL_COMP_INV field.
	XCVR_RX_DIG_AUXPLL_FCAL_CTRL_FCAL_COMP_INV_Pos = 0x9
	// Bit mask of FCAL_COMP_INV field.
	XCVR_RX_DIG_AUXPLL_FCAL_CTRL_FCAL_COMP_INV_Msk = 0x200
	// Bit FCAL_COMP_INV.
	XCVR_RX_DIG_AUXPLL_FCAL_CTRL_FCAL_COMP_INV = 0x200
	// (Default) The comparison associated with the count is not inverted.
	XCVR_RX_DIG_AUXPLL_FCAL_CTRL_FCAL_COMP_INV_0 = 0x0
	// The comparison associated with the count is inverted
	XCVR_RX_DIG_AUXPLL_FCAL_CTRL_FCAL_COMP_INV_1 = 0x1
	// Position of FCAL_SMP_DLY field.
	XCVR_RX_DIG_AUXPLL_FCAL_CTRL_FCAL_SMP_DLY_Pos = 0xa
	// Bit mask of FCAL_SMP_DLY field.
	XCVR_RX_DIG_AUXPLL_FCAL_CTRL_FCAL_SMP_DLY_Msk = 0xc00
	// The count signal is sampled 1 clk cycle after fcal_run signal is deasserted
	XCVR_RX_DIG_AUXPLL_FCAL_CTRL_FCAL_SMP_DLY_00 = 0x0
	// The count signal is sampled 2 clk cycle after fcal_run signal is deasserted
	XCVR_RX_DIG_AUXPLL_FCAL_CTRL_FCAL_SMP_DLY_01 = 0x1
	// The count signal is sampled 3 clk cycle after fcal_run signal is deasserted
	XCVR_RX_DIG_AUXPLL_FCAL_CTRL_FCAL_SMP_DLY_10 = 0x2
	// The count signal is sampled 4 clk cycle after fcal_run signal is deasserted
	XCVR_RX_DIG_AUXPLL_FCAL_CTRL_FCAL_SMP_DLY_11 = 0x3
	// Position of DAC_CAL_ADJUST field.
	XCVR_RX_DIG_AUXPLL_FCAL_CTRL_DAC_CAL_ADJUST_Pos = 0x10
	// Bit mask of DAC_CAL_ADJUST field.
	XCVR_RX_DIG_AUXPLL_FCAL_CTRL_DAC_CAL_ADJUST_Msk = 0x7f0000

	// AUXPLL_FCAL_CNT6: Aux PLL Frequency Calibration Count 6
	// Position of FCAL_COUNT_6 field.
	XCVR_RX_DIG_AUXPLL_FCAL_CNT6_FCAL_COUNT_6_Pos = 0x0
	// Bit mask of FCAL_COUNT_6 field.
	XCVR_RX_DIG_AUXPLL_FCAL_CNT6_FCAL_COUNT_6_Msk = 0x3ff
	// Position of FCAL_BESTDIFF field.
	XCVR_RX_DIG_AUXPLL_FCAL_CNT6_FCAL_BESTDIFF_Pos = 0x10
	// Bit mask of FCAL_BESTDIFF field.
	XCVR_RX_DIG_AUXPLL_FCAL_CNT6_FCAL_BESTDIFF_Msk = 0x3ff0000

	// AUXPLL_FCAL_CNT5_4: Aux PLL Frequency Calibration Count 5 and 4
	// Position of FCAL_COUNT_4 field.
	XCVR_RX_DIG_AUXPLL_FCAL_CNT5_4_FCAL_COUNT_4_Pos = 0x0
	// Bit mask of FCAL_COUNT_4 field.
	XCVR_RX_DIG_AUXPLL_FCAL_CNT5_4_FCAL_COUNT_4_Msk = 0x3ff
	// Position of FCAL_COUNT_5 field.
	XCVR_RX_DIG_AUXPLL_FCAL_CNT5_4_FCAL_COUNT_5_Pos = 0x10
	// Bit mask of FCAL_COUNT_5 field.
	XCVR_RX_DIG_AUXPLL_FCAL_CNT5_4_FCAL_COUNT_5_Msk = 0x3ff0000

	// AUXPLL_FCAL_CNT3_2: Aux PLL Frequency Calibration Count 3 and 2
	// Position of FCAL_COUNT_2 field.
	XCVR_RX_DIG_AUXPLL_FCAL_CNT3_2_FCAL_COUNT_2_Pos = 0x0
	// Bit mask of FCAL_COUNT_2 field.
	XCVR_RX_DIG_AUXPLL_FCAL_CNT3_2_FCAL_COUNT_2_Msk = 0x3ff
	// Position of FCAL_COUNT_3 field.
	XCVR_RX_DIG_AUXPLL_FCAL_CNT3_2_FCAL_COUNT_3_Pos = 0x10
	// Bit mask of FCAL_COUNT_3 field.
	XCVR_RX_DIG_AUXPLL_FCAL_CNT3_2_FCAL_COUNT_3_Msk = 0x3ff0000

	// AUXPLL_FCAL_CNT1_0: Aux PLL Frequency Calibration Count 1 and 0
	// Position of FCAL_COUNT_0 field.
	XCVR_RX_DIG_AUXPLL_FCAL_CNT1_0_FCAL_COUNT_0_Pos = 0x0
	// Bit mask of FCAL_COUNT_0 field.
	XCVR_RX_DIG_AUXPLL_FCAL_CNT1_0_FCAL_COUNT_0_Msk = 0x3ff
	// Position of FCAL_COUNT_1 field.
	XCVR_RX_DIG_AUXPLL_FCAL_CNT1_0_FCAL_COUNT_1_Pos = 0x10
	// Bit mask of FCAL_COUNT_1 field.
	XCVR_RX_DIG_AUXPLL_FCAL_CNT1_0_FCAL_COUNT_1_Msk = 0x3ff0000

	// RXDIG_DFT: RXDIG DFT
	// Position of DFT_TONE_FREQ field.
	XCVR_RX_DIG_RXDIG_DFT_DFT_TONE_FREQ_Pos = 0x0
	// Bit mask of DFT_TONE_FREQ field.
	XCVR_RX_DIG_RXDIG_DFT_DFT_TONE_FREQ_Msk = 0x7
	// 1/64 of the ref osc frequency (500kHz for 32MHz ref osc)
	XCVR_RX_DIG_RXDIG_DFT_DFT_TONE_FREQ_0 = 0x0
	// 1/128 of the ref osc frequency (250kHz for 32MHz ref osc)
	XCVR_RX_DIG_RXDIG_DFT_DFT_TONE_FREQ_1 = 0x1
	// 1/256 of the ref osc frequency (125kHz for 32MHz ref osc)
	XCVR_RX_DIG_RXDIG_DFT_DFT_TONE_FREQ_2 = 0x2
	// 1/512 of the ref osc frequency (62.5kHz for 32MHz ref osc)
	XCVR_RX_DIG_RXDIG_DFT_DFT_TONE_FREQ_3 = 0x3
	// 1/1024 of the ref osc frequency (31.25kHz for 32MHz ref osc)
	XCVR_RX_DIG_RXDIG_DFT_DFT_TONE_FREQ_4 = 0x4
	// Position of DFT_TONE_SCALE field.
	XCVR_RX_DIG_RXDIG_DFT_DFT_TONE_SCALE_Pos = 0x3
	// Bit mask of DFT_TONE_SCALE field.
	XCVR_RX_DIG_RXDIG_DFT_DFT_TONE_SCALE_Msk = 0x8
	// Bit DFT_TONE_SCALE.
	XCVR_RX_DIG_RXDIG_DFT_DFT_TONE_SCALE = 0x8
	// The DFT tone generator uses 3/4 of the DC offset correction DAC range.
	XCVR_RX_DIG_RXDIG_DFT_DFT_TONE_SCALE_0 = 0x0
	// The DFT tone generator uses 1/2 of the DC offset correction DAC range.
	XCVR_RX_DIG_RXDIG_DFT_DFT_TONE_SCALE_1 = 0x1
	// Position of DFT_TONE_TZA_EN field.
	XCVR_RX_DIG_RXDIG_DFT_DFT_TONE_TZA_EN_Pos = 0x4
	// Bit mask of DFT_TONE_TZA_EN field.
	XCVR_RX_DIG_RXDIG_DFT_DFT_TONE_TZA_EN_Msk = 0x10
	// Bit DFT_TONE_TZA_EN.
	XCVR_RX_DIG_RXDIG_DFT_DFT_TONE_TZA_EN = 0x10
	// The DCOC controls the TZA DC offset correction DACs
	XCVR_RX_DIG_RXDIG_DFT_DFT_TONE_TZA_EN_0 = 0x0
	// A tone is generated using the TZA DC offset correction DACs.
	XCVR_RX_DIG_RXDIG_DFT_DFT_TONE_TZA_EN_1 = 0x1
	// Position of DFT_TONE_BBA_EN field.
	XCVR_RX_DIG_RXDIG_DFT_DFT_TONE_BBA_EN_Pos = 0x5
	// Bit mask of DFT_TONE_BBA_EN field.
	XCVR_RX_DIG_RXDIG_DFT_DFT_TONE_BBA_EN_Msk = 0x20
	// Bit DFT_TONE_BBA_EN.
	XCVR_RX_DIG_RXDIG_DFT_DFT_TONE_BBA_EN = 0x20
	// The DCOC controls the BBA DC offset correction DACs
	XCVR_RX_DIG_RXDIG_DFT_DFT_TONE_BBA_EN_0 = 0x0
	// A tone is generated using the BBA DC offset correction DACs.
	XCVR_RX_DIG_RXDIG_DFT_DFT_TONE_BBA_EN_1 = 0x1
)

// Bitfields for XCVR_TX_DIG: XCVR_TX_DIG
const (
	// CTRL: TX Digital Control
	// Position of RADIO_DFT_MODE field.
	XCVR_TX_DIG_CTRL_RADIO_DFT_MODE_Pos = 0x0
	// Bit mask of RADIO_DFT_MODE field.
	XCVR_TX_DIG_CTRL_RADIO_DFT_MODE_Msk = 0xf
	// Normal Radio Operation, DFT not engaged.
	XCVR_TX_DIG_CTRL_RADIO_DFT_MODE_0000 = 0x0
	// Carrier Frequency Only
	XCVR_TX_DIG_CTRL_RADIO_DFT_MODE_0001 = 0x1
	// Pattern Register GFSK
	XCVR_TX_DIG_CTRL_RADIO_DFT_MODE_0010 = 0x2
	// LFSR GFSK
	XCVR_TX_DIG_CTRL_RADIO_DFT_MODE_0011 = 0x3
	// Pattern Register FSK
	XCVR_TX_DIG_CTRL_RADIO_DFT_MODE_0100 = 0x4
	// LFSR FSK
	XCVR_TX_DIG_CTRL_RADIO_DFT_MODE_0101 = 0x5
	// Pattern Register O-QPSK
	XCVR_TX_DIG_CTRL_RADIO_DFT_MODE_0110 = 0x6
	// LFSR O-QPSK
	XCVR_TX_DIG_CTRL_RADIO_DFT_MODE_0111 = 0x7
	// LFSR 802.15.4 Symbols
	XCVR_TX_DIG_CTRL_RADIO_DFT_MODE_1000 = 0x8
	// PLL Modulation from RAM
	XCVR_TX_DIG_CTRL_RADIO_DFT_MODE_1001 = 0x9
	// PLL Coarse Tune BIST
	XCVR_TX_DIG_CTRL_RADIO_DFT_MODE_1010 = 0xa
	// PLL Frequency Synthesizer BIST
	XCVR_TX_DIG_CTRL_RADIO_DFT_MODE_1011 = 0xb
	// High Port DAC BIST
	XCVR_TX_DIG_CTRL_RADIO_DFT_MODE_1100 = 0xc
	// VCO Frequency Meter
	XCVR_TX_DIG_CTRL_RADIO_DFT_MODE_1101 = 0xd
	// Position of LFSR_LENGTH field.
	XCVR_TX_DIG_CTRL_LFSR_LENGTH_Pos = 0x4
	// Bit mask of LFSR_LENGTH field.
	XCVR_TX_DIG_CTRL_LFSR_LENGTH_Msk = 0x70
	// LFSR 9, tap mask 100010000
	XCVR_TX_DIG_CTRL_LFSR_LENGTH_000 = 0x0
	// LFSR 10, tap mask 1001000000
	XCVR_TX_DIG_CTRL_LFSR_LENGTH_001 = 0x1
	// LFSR 11, tap mask 11101000000
	XCVR_TX_DIG_CTRL_LFSR_LENGTH_010 = 0x2
	// LFSR 13, tap mask 1101100000000
	XCVR_TX_DIG_CTRL_LFSR_LENGTH_011 = 0x3
	// LFSR 15, tap mask 111010000000000
	XCVR_TX_DIG_CTRL_LFSR_LENGTH_100 = 0x4
	// LFSR 17, tap mask 11110000000000000
	XCVR_TX_DIG_CTRL_LFSR_LENGTH_101 = 0x5
	// Position of LFSR_EN field.
	XCVR_TX_DIG_CTRL_LFSR_EN_Pos = 0x7
	// Bit mask of LFSR_EN field.
	XCVR_TX_DIG_CTRL_LFSR_EN_Msk = 0x80
	// Bit LFSR_EN.
	XCVR_TX_DIG_CTRL_LFSR_EN = 0x80
	// Position of DFT_CLK_SEL field.
	XCVR_TX_DIG_CTRL_DFT_CLK_SEL_Pos = 0x8
	// Bit mask of DFT_CLK_SEL field.
	XCVR_TX_DIG_CTRL_DFT_CLK_SEL_Msk = 0x700
	// 62.5 kHz
	XCVR_TX_DIG_CTRL_DFT_CLK_SEL_000 = 0x0
	// 125 kHz
	XCVR_TX_DIG_CTRL_DFT_CLK_SEL_001 = 0x1
	// 250 kHz
	XCVR_TX_DIG_CTRL_DFT_CLK_SEL_010 = 0x2
	// 500 kHz
	XCVR_TX_DIG_CTRL_DFT_CLK_SEL_011 = 0x3
	// 1 MHz
	XCVR_TX_DIG_CTRL_DFT_CLK_SEL_100 = 0x4
	// 2 MHz
	XCVR_TX_DIG_CTRL_DFT_CLK_SEL_101 = 0x5
	// 4 MHz
	XCVR_TX_DIG_CTRL_DFT_CLK_SEL_110 = 0x6
	// RF OSC Clock
	XCVR_TX_DIG_CTRL_DFT_CLK_SEL_111 = 0x7
	// Position of TX_DFT_EN field.
	XCVR_TX_DIG_CTRL_TX_DFT_EN_Pos = 0xb
	// Bit mask of TX_DFT_EN field.
	XCVR_TX_DIG_CTRL_TX_DFT_EN_Msk = 0x800
	// Bit TX_DFT_EN.
	XCVR_TX_DIG_CTRL_TX_DFT_EN = 0x800
	// Position of SOC_TEST_SEL field.
	XCVR_TX_DIG_CTRL_SOC_TEST_SEL_Pos = 0xc
	// Bit mask of SOC_TEST_SEL field.
	XCVR_TX_DIG_CTRL_SOC_TEST_SEL_Msk = 0x3000
	// No Clock Selected
	XCVR_TX_DIG_CTRL_SOC_TEST_SEL_00 = 0x0
	// PLL Sigma Delta Clock, divided by 2
	XCVR_TX_DIG_CTRL_SOC_TEST_SEL_01 = 0x1
	// Auxiliary PLL Clock, divided by 2
	XCVR_TX_DIG_CTRL_SOC_TEST_SEL_10 = 0x2
	// RF Ref Osc clock, divided by 2
	XCVR_TX_DIG_CTRL_SOC_TEST_SEL_11 = 0x3
	// Position of TX_CAPTURE_POL field.
	XCVR_TX_DIG_CTRL_TX_CAPTURE_POL_Pos = 0x10
	// Bit mask of TX_CAPTURE_POL field.
	XCVR_TX_DIG_CTRL_TX_CAPTURE_POL_Msk = 0x10000
	// Bit TX_CAPTURE_POL.
	XCVR_TX_DIG_CTRL_TX_CAPTURE_POL = 0x10000
	// Position of FREQ_WORD_ADJ field.
	XCVR_TX_DIG_CTRL_FREQ_WORD_ADJ_Pos = 0x16
	// Bit mask of FREQ_WORD_ADJ field.
	XCVR_TX_DIG_CTRL_FREQ_WORD_ADJ_Msk = 0xffc00000

	// DATA_PADDING: TX Data Padding
	// Position of DATA_PADDING_PAT_0 field.
	XCVR_TX_DIG_DATA_PADDING_DATA_PADDING_PAT_0_Pos = 0x0
	// Bit mask of DATA_PADDING_PAT_0 field.
	XCVR_TX_DIG_DATA_PADDING_DATA_PADDING_PAT_0_Msk = 0xff
	// Position of DATA_PADDING_PAT_1 field.
	XCVR_TX_DIG_DATA_PADDING_DATA_PADDING_PAT_1_Pos = 0x8
	// Bit mask of DATA_PADDING_PAT_1 field.
	XCVR_TX_DIG_DATA_PADDING_DATA_PADDING_PAT_1_Msk = 0xff00
	// Position of DFT_LFSR_OUT field.
	XCVR_TX_DIG_DATA_PADDING_DFT_LFSR_OUT_Pos = 0x10
	// Bit mask of DFT_LFSR_OUT field.
	XCVR_TX_DIG_DATA_PADDING_DFT_LFSR_OUT_Msk = 0x7fff0000
	// Position of LRM field.
	XCVR_TX_DIG_DATA_PADDING_LRM_Pos = 0x1f
	// Bit mask of LRM field.
	XCVR_TX_DIG_DATA_PADDING_LRM_Msk = 0x80000000
	// Bit LRM.
	XCVR_TX_DIG_DATA_PADDING_LRM = 0x80000000

	// GFSK_CTRL: TX GFSK Modulator Control
	// Position of GFSK_MULTIPLY_TABLE_MANUAL field.
	XCVR_TX_DIG_GFSK_CTRL_GFSK_MULTIPLY_TABLE_MANUAL_Pos = 0x0
	// Bit mask of GFSK_MULTIPLY_TABLE_MANUAL field.
	XCVR_TX_DIG_GFSK_CTRL_GFSK_MULTIPLY_TABLE_MANUAL_Msk = 0xffff
	// Position of GFSK_MI field.
	XCVR_TX_DIG_GFSK_CTRL_GFSK_MI_Pos = 0x10
	// Bit mask of GFSK_MI field.
	XCVR_TX_DIG_GFSK_CTRL_GFSK_MI_Msk = 0x30000
	// 0.32
	XCVR_TX_DIG_GFSK_CTRL_GFSK_MI_00 = 0x0
	// 0.50
	XCVR_TX_DIG_GFSK_CTRL_GFSK_MI_01 = 0x1
	// 0.70
	XCVR_TX_DIG_GFSK_CTRL_GFSK_MI_10 = 0x2
	// 1.00
	XCVR_TX_DIG_GFSK_CTRL_GFSK_MI_11 = 0x3
	// Position of GFSK_MLD field.
	XCVR_TX_DIG_GFSK_CTRL_GFSK_MLD_Pos = 0x14
	// Bit mask of GFSK_MLD field.
	XCVR_TX_DIG_GFSK_CTRL_GFSK_MLD_Msk = 0x100000
	// Bit GFSK_MLD.
	XCVR_TX_DIG_GFSK_CTRL_GFSK_MLD = 0x100000
	// Position of GFSK_FLD field.
	XCVR_TX_DIG_GFSK_CTRL_GFSK_FLD_Pos = 0x15
	// Bit mask of GFSK_FLD field.
	XCVR_TX_DIG_GFSK_CTRL_GFSK_FLD_Msk = 0x200000
	// Bit GFSK_FLD.
	XCVR_TX_DIG_GFSK_CTRL_GFSK_FLD = 0x200000
	// Position of GFSK_MOD_INDEX_SCALING field.
	XCVR_TX_DIG_GFSK_CTRL_GFSK_MOD_INDEX_SCALING_Pos = 0x18
	// Bit mask of GFSK_MOD_INDEX_SCALING field.
	XCVR_TX_DIG_GFSK_CTRL_GFSK_MOD_INDEX_SCALING_Msk = 0x7000000
	// 1
	XCVR_TX_DIG_GFSK_CTRL_GFSK_MOD_INDEX_SCALING_000 = 0x0
	// 1 + 1/32
	XCVR_TX_DIG_GFSK_CTRL_GFSK_MOD_INDEX_SCALING_001 = 0x1
	// 1 + 1/16
	XCVR_TX_DIG_GFSK_CTRL_GFSK_MOD_INDEX_SCALING_010 = 0x2
	// 1 + 1/8
	XCVR_TX_DIG_GFSK_CTRL_GFSK_MOD_INDEX_SCALING_011 = 0x3
	// 1 - 1/32
	XCVR_TX_DIG_GFSK_CTRL_GFSK_MOD_INDEX_SCALING_100 = 0x4
	// 1 - 1/16
	XCVR_TX_DIG_GFSK_CTRL_GFSK_MOD_INDEX_SCALING_101 = 0x5
	// 1 - 1/8
	XCVR_TX_DIG_GFSK_CTRL_GFSK_MOD_INDEX_SCALING_110 = 0x6
	// Position of TX_IMAGE_FILTER_OVRD_EN field.
	XCVR_TX_DIG_GFSK_CTRL_TX_IMAGE_FILTER_OVRD_EN_Pos = 0x1c
	// Bit mask of TX_IMAGE_FILTER_OVRD_EN field.
	XCVR_TX_DIG_GFSK_CTRL_TX_IMAGE_FILTER_OVRD_EN_Msk = 0x10000000
	// Bit TX_IMAGE_FILTER_OVRD_EN.
	XCVR_TX_DIG_GFSK_CTRL_TX_IMAGE_FILTER_OVRD_EN = 0x10000000
	// Position of TX_IMAGE_FILTER_0_OVRD field.
	XCVR_TX_DIG_GFSK_CTRL_TX_IMAGE_FILTER_0_OVRD_Pos = 0x1d
	// Bit mask of TX_IMAGE_FILTER_0_OVRD field.
	XCVR_TX_DIG_GFSK_CTRL_TX_IMAGE_FILTER_0_OVRD_Msk = 0x20000000
	// Bit TX_IMAGE_FILTER_0_OVRD.
	XCVR_TX_DIG_GFSK_CTRL_TX_IMAGE_FILTER_0_OVRD = 0x20000000
	// Position of TX_IMAGE_FILTER_1_OVRD field.
	XCVR_TX_DIG_GFSK_CTRL_TX_IMAGE_FILTER_1_OVRD_Pos = 0x1e
	// Bit mask of TX_IMAGE_FILTER_1_OVRD field.
	XCVR_TX_DIG_GFSK_CTRL_TX_IMAGE_FILTER_1_OVRD_Msk = 0x40000000
	// Bit TX_IMAGE_FILTER_1_OVRD.
	XCVR_TX_DIG_GFSK_CTRL_TX_IMAGE_FILTER_1_OVRD = 0x40000000
	// Position of TX_IMAGE_FILTER_2_OVRD field.
	XCVR_TX_DIG_GFSK_CTRL_TX_IMAGE_FILTER_2_OVRD_Pos = 0x1f
	// Bit mask of TX_IMAGE_FILTER_2_OVRD field.
	XCVR_TX_DIG_GFSK_CTRL_TX_IMAGE_FILTER_2_OVRD_Msk = 0x80000000
	// Bit TX_IMAGE_FILTER_2_OVRD.
	XCVR_TX_DIG_GFSK_CTRL_TX_IMAGE_FILTER_2_OVRD = 0x80000000

	// GFSK_COEFF2: TX GFSK Filter Coefficients 2
	// Position of GFSK_FILTER_COEFF_MANUAL2 field.
	XCVR_TX_DIG_GFSK_COEFF2_GFSK_FILTER_COEFF_MANUAL2_Pos = 0x0
	// Bit mask of GFSK_FILTER_COEFF_MANUAL2 field.
	XCVR_TX_DIG_GFSK_COEFF2_GFSK_FILTER_COEFF_MANUAL2_Msk = 0xffffffff

	// GFSK_COEFF1: TX GFSK Filter Coefficients 1
	// Position of GFSK_FILTER_COEFF_MANUAL1 field.
	XCVR_TX_DIG_GFSK_COEFF1_GFSK_FILTER_COEFF_MANUAL1_Pos = 0x0
	// Bit mask of GFSK_FILTER_COEFF_MANUAL1 field.
	XCVR_TX_DIG_GFSK_COEFF1_GFSK_FILTER_COEFF_MANUAL1_Msk = 0xffffffff

	// FSK_SCALE: TX FSK Modulation Levels
	// Position of FSK_MODULATION_SCALE_0 field.
	XCVR_TX_DIG_FSK_SCALE_FSK_MODULATION_SCALE_0_Pos = 0x0
	// Bit mask of FSK_MODULATION_SCALE_0 field.
	XCVR_TX_DIG_FSK_SCALE_FSK_MODULATION_SCALE_0_Msk = 0x1fff
	// Position of FSK_MODULATION_SCALE_1 field.
	XCVR_TX_DIG_FSK_SCALE_FSK_MODULATION_SCALE_1_Pos = 0x10
	// Bit mask of FSK_MODULATION_SCALE_1 field.
	XCVR_TX_DIG_FSK_SCALE_FSK_MODULATION_SCALE_1_Msk = 0x1fff0000

	// DFT_PATTERN: TX DFT Modulation Pattern
	// Position of DFT_MOD_PATTERN field.
	XCVR_TX_DIG_DFT_PATTERN_DFT_MOD_PATTERN_Pos = 0x0
	// Bit mask of DFT_MOD_PATTERN field.
	XCVR_TX_DIG_DFT_PATTERN_DFT_MOD_PATTERN_Msk = 0xffffffff

	// RF_DFT_BIST_1: TX DFT Control 1
	// Position of CTUNE_BIST_GO field.
	XCVR_TX_DIG_RF_DFT_BIST_1_CTUNE_BIST_GO_Pos = 0x0
	// Bit mask of CTUNE_BIST_GO field.
	XCVR_TX_DIG_RF_DFT_BIST_1_CTUNE_BIST_GO_Msk = 0x1
	// Bit CTUNE_BIST_GO.
	XCVR_TX_DIG_RF_DFT_BIST_1_CTUNE_BIST_GO = 0x1
	// Position of CTUNE_BIST_FINISHED field.
	XCVR_TX_DIG_RF_DFT_BIST_1_CTUNE_BIST_FINISHED_Pos = 0x1
	// Bit mask of CTUNE_BIST_FINISHED field.
	XCVR_TX_DIG_RF_DFT_BIST_1_CTUNE_BIST_FINISHED_Msk = 0x2
	// Bit CTUNE_BIST_FINISHED.
	XCVR_TX_DIG_RF_DFT_BIST_1_CTUNE_BIST_FINISHED = 0x2
	// Position of CTUNE_BIST_RESULT field.
	XCVR_TX_DIG_RF_DFT_BIST_1_CTUNE_BIST_RESULT_Pos = 0x2
	// Bit mask of CTUNE_BIST_RESULT field.
	XCVR_TX_DIG_RF_DFT_BIST_1_CTUNE_BIST_RESULT_Msk = 0x4
	// Bit CTUNE_BIST_RESULT.
	XCVR_TX_DIG_RF_DFT_BIST_1_CTUNE_BIST_RESULT = 0x4
	// Position of CTUNE_BIST_THRSHLD field.
	XCVR_TX_DIG_RF_DFT_BIST_1_CTUNE_BIST_THRSHLD_Pos = 0x4
	// Bit mask of CTUNE_BIST_THRSHLD field.
	XCVR_TX_DIG_RF_DFT_BIST_1_CTUNE_BIST_THRSHLD_Msk = 0xf0
	// Position of CTUNE_MAX_DIFF field.
	XCVR_TX_DIG_RF_DFT_BIST_1_CTUNE_MAX_DIFF_Pos = 0x8
	// Bit mask of CTUNE_MAX_DIFF field.
	XCVR_TX_DIG_RF_DFT_BIST_1_CTUNE_MAX_DIFF_Msk = 0xff00
	// Position of CTUNE_MAX_DIFF_CH field.
	XCVR_TX_DIG_RF_DFT_BIST_1_CTUNE_MAX_DIFF_CH_Pos = 0x10
	// Bit mask of CTUNE_MAX_DIFF_CH field.
	XCVR_TX_DIG_RF_DFT_BIST_1_CTUNE_MAX_DIFF_CH_Msk = 0x7f0000
	// Position of PA_AM_MOD_FREQ field.
	XCVR_TX_DIG_RF_DFT_BIST_1_PA_AM_MOD_FREQ_Pos = 0x18
	// Bit mask of PA_AM_MOD_FREQ field.
	XCVR_TX_DIG_RF_DFT_BIST_1_PA_AM_MOD_FREQ_Msk = 0x7000000
	// 4 MHz
	XCVR_TX_DIG_RF_DFT_BIST_1_PA_AM_MOD_FREQ_000 = 0x0
	// 2 MHz
	XCVR_TX_DIG_RF_DFT_BIST_1_PA_AM_MOD_FREQ_001 = 0x1
	// 1 MHz
	XCVR_TX_DIG_RF_DFT_BIST_1_PA_AM_MOD_FREQ_010 = 0x2
	// 500 kHz
	XCVR_TX_DIG_RF_DFT_BIST_1_PA_AM_MOD_FREQ_011 = 0x3
	// 250 kHz
	XCVR_TX_DIG_RF_DFT_BIST_1_PA_AM_MOD_FREQ_100 = 0x4
	// 125 kHz
	XCVR_TX_DIG_RF_DFT_BIST_1_PA_AM_MOD_FREQ_101 = 0x5
	// 62.5 kHz
	XCVR_TX_DIG_RF_DFT_BIST_1_PA_AM_MOD_FREQ_110 = 0x6
	// Position of PA_AM_MOD_ENTRIES field.
	XCVR_TX_DIG_RF_DFT_BIST_1_PA_AM_MOD_ENTRIES_Pos = 0x1c
	// Bit mask of PA_AM_MOD_ENTRIES field.
	XCVR_TX_DIG_RF_DFT_BIST_1_PA_AM_MOD_ENTRIES_Msk = 0x70000000
	// 2 entries
	XCVR_TX_DIG_RF_DFT_BIST_1_PA_AM_MOD_ENTRIES_001 = 0x1
	// 3 entries
	XCVR_TX_DIG_RF_DFT_BIST_1_PA_AM_MOD_ENTRIES_010 = 0x2
	// 4 entries
	XCVR_TX_DIG_RF_DFT_BIST_1_PA_AM_MOD_ENTRIES_011 = 0x3
	// 5 entries
	XCVR_TX_DIG_RF_DFT_BIST_1_PA_AM_MOD_ENTRIES_100 = 0x4
	// 6 entries
	XCVR_TX_DIG_RF_DFT_BIST_1_PA_AM_MOD_ENTRIES_101 = 0x5
	// 7 entries
	XCVR_TX_DIG_RF_DFT_BIST_1_PA_AM_MOD_ENTRIES_110 = 0x6
	// 8 entries
	XCVR_TX_DIG_RF_DFT_BIST_1_PA_AM_MOD_ENTRIES_111 = 0x7
	// Position of PA_AM_MOD_EN field.
	XCVR_TX_DIG_RF_DFT_BIST_1_PA_AM_MOD_EN_Pos = 0x1f
	// Bit mask of PA_AM_MOD_EN field.
	XCVR_TX_DIG_RF_DFT_BIST_1_PA_AM_MOD_EN_Msk = 0x80000000
	// Bit PA_AM_MOD_EN.
	XCVR_TX_DIG_RF_DFT_BIST_1_PA_AM_MOD_EN = 0x80000000

	// RF_DFT_BIST_2: TX DFT Control 2
	// Position of SYN_BIST_GO field.
	XCVR_TX_DIG_RF_DFT_BIST_2_SYN_BIST_GO_Pos = 0x0
	// Bit mask of SYN_BIST_GO field.
	XCVR_TX_DIG_RF_DFT_BIST_2_SYN_BIST_GO_Msk = 0x1
	// Bit SYN_BIST_GO.
	XCVR_TX_DIG_RF_DFT_BIST_2_SYN_BIST_GO = 0x1
	// Position of SYN_BIST_FINISHED field.
	XCVR_TX_DIG_RF_DFT_BIST_2_SYN_BIST_FINISHED_Pos = 0x1
	// Bit mask of SYN_BIST_FINISHED field.
	XCVR_TX_DIG_RF_DFT_BIST_2_SYN_BIST_FINISHED_Msk = 0x2
	// Bit SYN_BIST_FINISHED.
	XCVR_TX_DIG_RF_DFT_BIST_2_SYN_BIST_FINISHED = 0x2
	// Position of SYN_BIST_RESULT field.
	XCVR_TX_DIG_RF_DFT_BIST_2_SYN_BIST_RESULT_Pos = 0x2
	// Bit mask of SYN_BIST_RESULT field.
	XCVR_TX_DIG_RF_DFT_BIST_2_SYN_BIST_RESULT_Msk = 0x4
	// Bit SYN_BIST_RESULT.
	XCVR_TX_DIG_RF_DFT_BIST_2_SYN_BIST_RESULT = 0x4
	// Position of SYN_BIST_ALL_CHANNELS field.
	XCVR_TX_DIG_RF_DFT_BIST_2_SYN_BIST_ALL_CHANNELS_Pos = 0x3
	// Bit mask of SYN_BIST_ALL_CHANNELS field.
	XCVR_TX_DIG_RF_DFT_BIST_2_SYN_BIST_ALL_CHANNELS_Msk = 0x8
	// Bit SYN_BIST_ALL_CHANNELS.
	XCVR_TX_DIG_RF_DFT_BIST_2_SYN_BIST_ALL_CHANNELS = 0x8
	// Position of FREQ_COUNT_THRESHOLD field.
	XCVR_TX_DIG_RF_DFT_BIST_2_FREQ_COUNT_THRESHOLD_Pos = 0x4
	// Bit mask of FREQ_COUNT_THRESHOLD field.
	XCVR_TX_DIG_RF_DFT_BIST_2_FREQ_COUNT_THRESHOLD_Msk = 0xff0
	// Position of HPM_INL_BIST_GO field.
	XCVR_TX_DIG_RF_DFT_BIST_2_HPM_INL_BIST_GO_Pos = 0xc
	// Bit mask of HPM_INL_BIST_GO field.
	XCVR_TX_DIG_RF_DFT_BIST_2_HPM_INL_BIST_GO_Msk = 0x1000
	// Bit HPM_INL_BIST_GO.
	XCVR_TX_DIG_RF_DFT_BIST_2_HPM_INL_BIST_GO = 0x1000
	// Position of HPM_INL_BIST_FINISHED field.
	XCVR_TX_DIG_RF_DFT_BIST_2_HPM_INL_BIST_FINISHED_Pos = 0xd
	// Bit mask of HPM_INL_BIST_FINISHED field.
	XCVR_TX_DIG_RF_DFT_BIST_2_HPM_INL_BIST_FINISHED_Msk = 0x2000
	// Bit HPM_INL_BIST_FINISHED.
	XCVR_TX_DIG_RF_DFT_BIST_2_HPM_INL_BIST_FINISHED = 0x2000
	// Position of HPM_INL_BIST_RESULT field.
	XCVR_TX_DIG_RF_DFT_BIST_2_HPM_INL_BIST_RESULT_Pos = 0xe
	// Bit mask of HPM_INL_BIST_RESULT field.
	XCVR_TX_DIG_RF_DFT_BIST_2_HPM_INL_BIST_RESULT_Msk = 0x4000
	// Bit HPM_INL_BIST_RESULT.
	XCVR_TX_DIG_RF_DFT_BIST_2_HPM_INL_BIST_RESULT = 0x4000
	// Position of HPM_DNL_BIST_GO field.
	XCVR_TX_DIG_RF_DFT_BIST_2_HPM_DNL_BIST_GO_Pos = 0x10
	// Bit mask of HPM_DNL_BIST_GO field.
	XCVR_TX_DIG_RF_DFT_BIST_2_HPM_DNL_BIST_GO_Msk = 0x10000
	// Bit HPM_DNL_BIST_GO.
	XCVR_TX_DIG_RF_DFT_BIST_2_HPM_DNL_BIST_GO = 0x10000
	// Position of HPM_DNL_BIST_FINISHED field.
	XCVR_TX_DIG_RF_DFT_BIST_2_HPM_DNL_BIST_FINISHED_Pos = 0x11
	// Bit mask of HPM_DNL_BIST_FINISHED field.
	XCVR_TX_DIG_RF_DFT_BIST_2_HPM_DNL_BIST_FINISHED_Msk = 0x20000
	// Bit HPM_DNL_BIST_FINISHED.
	XCVR_TX_DIG_RF_DFT_BIST_2_HPM_DNL_BIST_FINISHED = 0x20000
	// Position of HPM_DNL_BIST_RESULT field.
	XCVR_TX_DIG_RF_DFT_BIST_2_HPM_DNL_BIST_RESULT_Pos = 0x12
	// Bit mask of HPM_DNL_BIST_RESULT field.
	XCVR_TX_DIG_RF_DFT_BIST_2_HPM_DNL_BIST_RESULT_Msk = 0x40000
	// Bit HPM_DNL_BIST_RESULT.
	XCVR_TX_DIG_RF_DFT_BIST_2_HPM_DNL_BIST_RESULT = 0x40000
	// Position of DFT_MAX_RAM_SIZE field.
	XCVR_TX_DIG_RF_DFT_BIST_2_DFT_MAX_RAM_SIZE_Pos = 0x14
	// Bit mask of DFT_MAX_RAM_SIZE field.
	XCVR_TX_DIG_RF_DFT_BIST_2_DFT_MAX_RAM_SIZE_Msk = 0x1ff00000
)

// Bitfields for XCVR_PLL_DIG: XCVR_PLL_DIG
const (
	// HPM_BUMP: PLL HPM Analog Bump Control
	// Position of HPM_VCM_TX field.
	XCVR_PLL_DIG_HPM_BUMP_HPM_VCM_TX_Pos = 0x0
	// Bit mask of HPM_VCM_TX field.
	XCVR_PLL_DIG_HPM_BUMP_HPM_VCM_TX_Msk = 0x7
	// 432 mV
	XCVR_PLL_DIG_HPM_BUMP_HPM_VCM_TX_000 = 0x0
	// 328 mV
	XCVR_PLL_DIG_HPM_BUMP_HPM_VCM_TX_001 = 0x1
	// 456 mV
	XCVR_PLL_DIG_HPM_BUMP_HPM_VCM_TX_010 = 0x2
	// 473 mV
	XCVR_PLL_DIG_HPM_BUMP_HPM_VCM_TX_011 = 0x3
	// 488 mV
	XCVR_PLL_DIG_HPM_BUMP_HPM_VCM_TX_100 = 0x4
	// 408 mV
	XCVR_PLL_DIG_HPM_BUMP_HPM_VCM_TX_101 = 0x5
	// 392 mV
	XCVR_PLL_DIG_HPM_BUMP_HPM_VCM_TX_110 = 0x6
	// 376 mV
	XCVR_PLL_DIG_HPM_BUMP_HPM_VCM_TX_111 = 0x7
	// Position of HPM_VCM_CAL field.
	XCVR_PLL_DIG_HPM_BUMP_HPM_VCM_CAL_Pos = 0x4
	// Bit mask of HPM_VCM_CAL field.
	XCVR_PLL_DIG_HPM_BUMP_HPM_VCM_CAL_Msk = 0x70
	// 432 mV
	XCVR_PLL_DIG_HPM_BUMP_HPM_VCM_CAL_000 = 0x0
	// 328 mV
	XCVR_PLL_DIG_HPM_BUMP_HPM_VCM_CAL_001 = 0x1
	// 456 mV
	XCVR_PLL_DIG_HPM_BUMP_HPM_VCM_CAL_010 = 0x2
	// 473 mV
	XCVR_PLL_DIG_HPM_BUMP_HPM_VCM_CAL_011 = 0x3
	// 488 mV
	XCVR_PLL_DIG_HPM_BUMP_HPM_VCM_CAL_100 = 0x4
	// 408 mV
	XCVR_PLL_DIG_HPM_BUMP_HPM_VCM_CAL_101 = 0x5
	// 392 mV
	XCVR_PLL_DIG_HPM_BUMP_HPM_VCM_CAL_110 = 0x6
	// 376 mV
	XCVR_PLL_DIG_HPM_BUMP_HPM_VCM_CAL_111 = 0x7
	// Position of HPM_FDB_RES_TX field.
	XCVR_PLL_DIG_HPM_BUMP_HPM_FDB_RES_TX_Pos = 0x8
	// Bit mask of HPM_FDB_RES_TX field.
	XCVR_PLL_DIG_HPM_BUMP_HPM_FDB_RES_TX_Msk = 0x300
	// 29 kohms
	XCVR_PLL_DIG_HPM_BUMP_HPM_FDB_RES_TX_00 = 0x0
	// 58 kohms(gain of 2)
	XCVR_PLL_DIG_HPM_BUMP_HPM_FDB_RES_TX_01 = 0x1
	// 13 kohms
	XCVR_PLL_DIG_HPM_BUMP_HPM_FDB_RES_TX_10 = 0x2
	// 23.7 kohms
	XCVR_PLL_DIG_HPM_BUMP_HPM_FDB_RES_TX_11 = 0x3
	// Position of HPM_FDB_RES_CAL field.
	XCVR_PLL_DIG_HPM_BUMP_HPM_FDB_RES_CAL_Pos = 0xc
	// Bit mask of HPM_FDB_RES_CAL field.
	XCVR_PLL_DIG_HPM_BUMP_HPM_FDB_RES_CAL_Msk = 0x3000
	// 29 kohms
	XCVR_PLL_DIG_HPM_BUMP_HPM_FDB_RES_CAL_00 = 0x0
	// 58 kohms(gain of 2)
	XCVR_PLL_DIG_HPM_BUMP_HPM_FDB_RES_CAL_01 = 0x1
	// 13 kohms
	XCVR_PLL_DIG_HPM_BUMP_HPM_FDB_RES_CAL_10 = 0x2
	// 23.7 kohms
	XCVR_PLL_DIG_HPM_BUMP_HPM_FDB_RES_CAL_11 = 0x3

	// MOD_CTRL: PLL Modulation Control
	// Position of MODULATION_WORD_MANUAL field.
	XCVR_PLL_DIG_MOD_CTRL_MODULATION_WORD_MANUAL_Pos = 0x0
	// Bit mask of MODULATION_WORD_MANUAL field.
	XCVR_PLL_DIG_MOD_CTRL_MODULATION_WORD_MANUAL_Msk = 0x1fff
	// Position of MOD_DISABLE field.
	XCVR_PLL_DIG_MOD_CTRL_MOD_DISABLE_Pos = 0xf
	// Bit mask of MOD_DISABLE field.
	XCVR_PLL_DIG_MOD_CTRL_MOD_DISABLE_Msk = 0x8000
	// Bit MOD_DISABLE.
	XCVR_PLL_DIG_MOD_CTRL_MOD_DISABLE = 0x8000
	// Position of HPM_MOD_MANUAL field.
	XCVR_PLL_DIG_MOD_CTRL_HPM_MOD_MANUAL_Pos = 0x10
	// Bit mask of HPM_MOD_MANUAL field.
	XCVR_PLL_DIG_MOD_CTRL_HPM_MOD_MANUAL_Msk = 0xff0000
	// Position of HPM_MOD_DISABLE field.
	XCVR_PLL_DIG_MOD_CTRL_HPM_MOD_DISABLE_Pos = 0x1b
	// Bit mask of HPM_MOD_DISABLE field.
	XCVR_PLL_DIG_MOD_CTRL_HPM_MOD_DISABLE_Msk = 0x8000000
	// Bit HPM_MOD_DISABLE.
	XCVR_PLL_DIG_MOD_CTRL_HPM_MOD_DISABLE = 0x8000000
	// Position of HPM_SDM_OUT_MANUAL field.
	XCVR_PLL_DIG_MOD_CTRL_HPM_SDM_OUT_MANUAL_Pos = 0x1c
	// Bit mask of HPM_SDM_OUT_MANUAL field.
	XCVR_PLL_DIG_MOD_CTRL_HPM_SDM_OUT_MANUAL_Msk = 0x30000000
	// Position of HPM_SDM_OUT_DISABLE field.
	XCVR_PLL_DIG_MOD_CTRL_HPM_SDM_OUT_DISABLE_Pos = 0x1f
	// Bit mask of HPM_SDM_OUT_DISABLE field.
	XCVR_PLL_DIG_MOD_CTRL_HPM_SDM_OUT_DISABLE_Msk = 0x80000000
	// Bit HPM_SDM_OUT_DISABLE.
	XCVR_PLL_DIG_MOD_CTRL_HPM_SDM_OUT_DISABLE = 0x80000000

	// CHAN_MAP: PLL Channel Mapping
	// Position of CHANNEL_NUM field.
	XCVR_PLL_DIG_CHAN_MAP_CHANNEL_NUM_Pos = 0x0
	// Bit mask of CHANNEL_NUM field.
	XCVR_PLL_DIG_CHAN_MAP_CHANNEL_NUM_Msk = 0x7f
	// Position of BOC field.
	XCVR_PLL_DIG_CHAN_MAP_BOC_Pos = 0x8
	// Bit mask of BOC field.
	XCVR_PLL_DIG_CHAN_MAP_BOC_Msk = 0x100
	// Bit BOC.
	XCVR_PLL_DIG_CHAN_MAP_BOC = 0x100
	// BLE channel number comes from the BLE Link Layer
	XCVR_PLL_DIG_CHAN_MAP_BOC_0 = 0x0
	// BLE channel number comes from the CHANNEL_NUM register (BLE protocols 0 and 2)
	XCVR_PLL_DIG_CHAN_MAP_BOC_1 = 0x1
	// Position of BMR field.
	XCVR_PLL_DIG_CHAN_MAP_BMR_Pos = 0x9
	// Bit mask of BMR field.
	XCVR_PLL_DIG_CHAN_MAP_BMR_Msk = 0x200
	// Bit BMR.
	XCVR_PLL_DIG_CHAN_MAP_BMR = 0x200
	// BLE channel 39 is mapped to BLE channel 39, 2.480 GHz
	XCVR_PLL_DIG_CHAN_MAP_BMR_0 = 0x0
	// BLE channel 39 is mapped to MBAN channel 39, 2.399 GHz
	XCVR_PLL_DIG_CHAN_MAP_BMR_1 = 0x1
	// Position of ZOC field.
	XCVR_PLL_DIG_CHAN_MAP_ZOC_Pos = 0xa
	// Bit mask of ZOC field.
	XCVR_PLL_DIG_CHAN_MAP_ZOC_Msk = 0x400
	// Bit ZOC.
	XCVR_PLL_DIG_CHAN_MAP_ZOC = 0x400
	// 802.15.4 channel number comes from the 802.15.4 Link Layer.
	XCVR_PLL_DIG_CHAN_MAP_ZOC_0 = 0x0
	// 802.15.4 channel number comes from the CHANNEL_NUM register (802.15.4 protocols 4 and 5)
	XCVR_PLL_DIG_CHAN_MAP_ZOC_1 = 0x1

	// LOCK_DETECT: PLL Lock Detect Control
	// Position of CT_FAIL field.
	XCVR_PLL_DIG_LOCK_DETECT_CT_FAIL_Pos = 0x0
	// Bit mask of CT_FAIL field.
	XCVR_PLL_DIG_LOCK_DETECT_CT_FAIL_Msk = 0x1
	// Bit CT_FAIL.
	XCVR_PLL_DIG_LOCK_DETECT_CT_FAIL = 0x1
	// Position of CTFF field.
	XCVR_PLL_DIG_LOCK_DETECT_CTFF_Pos = 0x1
	// Bit mask of CTFF field.
	XCVR_PLL_DIG_LOCK_DETECT_CTFF_Msk = 0x2
	// Bit CTFF.
	XCVR_PLL_DIG_LOCK_DETECT_CTFF = 0x2
	// Position of CS_FAIL field.
	XCVR_PLL_DIG_LOCK_DETECT_CS_FAIL_Pos = 0x2
	// Bit mask of CS_FAIL field.
	XCVR_PLL_DIG_LOCK_DETECT_CS_FAIL_Msk = 0x4
	// Bit CS_FAIL.
	XCVR_PLL_DIG_LOCK_DETECT_CS_FAIL = 0x4
	// Position of CSFF field.
	XCVR_PLL_DIG_LOCK_DETECT_CSFF_Pos = 0x3
	// Bit mask of CSFF field.
	XCVR_PLL_DIG_LOCK_DETECT_CSFF_Msk = 0x8
	// Bit CSFF.
	XCVR_PLL_DIG_LOCK_DETECT_CSFF = 0x8
	// Position of FT_FAIL field.
	XCVR_PLL_DIG_LOCK_DETECT_FT_FAIL_Pos = 0x4
	// Bit mask of FT_FAIL field.
	XCVR_PLL_DIG_LOCK_DETECT_FT_FAIL_Msk = 0x10
	// Bit FT_FAIL.
	XCVR_PLL_DIG_LOCK_DETECT_FT_FAIL = 0x10
	// Position of FTFF field.
	XCVR_PLL_DIG_LOCK_DETECT_FTFF_Pos = 0x5
	// Bit mask of FTFF field.
	XCVR_PLL_DIG_LOCK_DETECT_FTFF_Msk = 0x20
	// Bit FTFF.
	XCVR_PLL_DIG_LOCK_DETECT_FTFF = 0x20
	// Position of TAFF field.
	XCVR_PLL_DIG_LOCK_DETECT_TAFF_Pos = 0x7
	// Bit mask of TAFF field.
	XCVR_PLL_DIG_LOCK_DETECT_TAFF_Msk = 0x80
	// Bit TAFF.
	XCVR_PLL_DIG_LOCK_DETECT_TAFF = 0x80
	// Position of CTUNE_LDF_LEV field.
	XCVR_PLL_DIG_LOCK_DETECT_CTUNE_LDF_LEV_Pos = 0x8
	// Bit mask of CTUNE_LDF_LEV field.
	XCVR_PLL_DIG_LOCK_DETECT_CTUNE_LDF_LEV_Msk = 0xf00
	// Position of FTF_RX_THRSH field.
	XCVR_PLL_DIG_LOCK_DETECT_FTF_RX_THRSH_Pos = 0xc
	// Bit mask of FTF_RX_THRSH field.
	XCVR_PLL_DIG_LOCK_DETECT_FTF_RX_THRSH_Msk = 0x3f000
	// Position of FTW_RX field.
	XCVR_PLL_DIG_LOCK_DETECT_FTW_RX_Pos = 0x13
	// Bit mask of FTW_RX field.
	XCVR_PLL_DIG_LOCK_DETECT_FTW_RX_Msk = 0x80000
	// Bit FTW_RX.
	XCVR_PLL_DIG_LOCK_DETECT_FTW_RX = 0x80000
	// 4 us
	XCVR_PLL_DIG_LOCK_DETECT_FTW_RX_0 = 0x0
	// 8 us
	XCVR_PLL_DIG_LOCK_DETECT_FTW_RX_1 = 0x1
	// Position of FTF_TX_THRSH field.
	XCVR_PLL_DIG_LOCK_DETECT_FTF_TX_THRSH_Pos = 0x14
	// Bit mask of FTF_TX_THRSH field.
	XCVR_PLL_DIG_LOCK_DETECT_FTF_TX_THRSH_Msk = 0x3f00000
	// Position of FTW_TX field.
	XCVR_PLL_DIG_LOCK_DETECT_FTW_TX_Pos = 0x1b
	// Bit mask of FTW_TX field.
	XCVR_PLL_DIG_LOCK_DETECT_FTW_TX_Msk = 0x8000000
	// Bit FTW_TX.
	XCVR_PLL_DIG_LOCK_DETECT_FTW_TX = 0x8000000
	// 4 us
	XCVR_PLL_DIG_LOCK_DETECT_FTW_TX_0 = 0x0
	// 8 us
	XCVR_PLL_DIG_LOCK_DETECT_FTW_TX_1 = 0x1
	// Position of FREQ_COUNT_GO field.
	XCVR_PLL_DIG_LOCK_DETECT_FREQ_COUNT_GO_Pos = 0x1c
	// Bit mask of FREQ_COUNT_GO field.
	XCVR_PLL_DIG_LOCK_DETECT_FREQ_COUNT_GO_Msk = 0x10000000
	// Bit FREQ_COUNT_GO.
	XCVR_PLL_DIG_LOCK_DETECT_FREQ_COUNT_GO = 0x10000000
	// Position of FREQ_COUNT_FINISHED field.
	XCVR_PLL_DIG_LOCK_DETECT_FREQ_COUNT_FINISHED_Pos = 0x1d
	// Bit mask of FREQ_COUNT_FINISHED field.
	XCVR_PLL_DIG_LOCK_DETECT_FREQ_COUNT_FINISHED_Msk = 0x20000000
	// Bit FREQ_COUNT_FINISHED.
	XCVR_PLL_DIG_LOCK_DETECT_FREQ_COUNT_FINISHED = 0x20000000
	// Position of FREQ_COUNT_TIME field.
	XCVR_PLL_DIG_LOCK_DETECT_FREQ_COUNT_TIME_Pos = 0x1e
	// Bit mask of FREQ_COUNT_TIME field.
	XCVR_PLL_DIG_LOCK_DETECT_FREQ_COUNT_TIME_Msk = 0xc0000000
	// 10 us
	XCVR_PLL_DIG_LOCK_DETECT_FREQ_COUNT_TIME_00 = 0x0
	// 25 us
	XCVR_PLL_DIG_LOCK_DETECT_FREQ_COUNT_TIME_01 = 0x1
	// 50 us
	XCVR_PLL_DIG_LOCK_DETECT_FREQ_COUNT_TIME_10 = 0x2
	// 100 us
	XCVR_PLL_DIG_LOCK_DETECT_FREQ_COUNT_TIME_11 = 0x3

	// HPM_CTRL: PLL High Port Modulator Control
	// Position of HPM_SDM_IN_MANUAL field.
	XCVR_PLL_DIG_HPM_CTRL_HPM_SDM_IN_MANUAL_Pos = 0x0
	// Bit mask of HPM_SDM_IN_MANUAL field.
	XCVR_PLL_DIG_HPM_CTRL_HPM_SDM_IN_MANUAL_Msk = 0x3ff
	// Position of HPFF field.
	XCVR_PLL_DIG_HPM_CTRL_HPFF_Pos = 0xd
	// Bit mask of HPFF field.
	XCVR_PLL_DIG_HPM_CTRL_HPFF_Msk = 0x2000
	// Bit HPFF.
	XCVR_PLL_DIG_HPM_CTRL_HPFF = 0x2000
	// Position of HPM_SDM_OUT_INVERT field.
	XCVR_PLL_DIG_HPM_CTRL_HPM_SDM_OUT_INVERT_Pos = 0xe
	// Bit mask of HPM_SDM_OUT_INVERT field.
	XCVR_PLL_DIG_HPM_CTRL_HPM_SDM_OUT_INVERT_Msk = 0x4000
	// Bit HPM_SDM_OUT_INVERT.
	XCVR_PLL_DIG_HPM_CTRL_HPM_SDM_OUT_INVERT = 0x4000
	// Position of HPM_SDM_IN_DISABLE field.
	XCVR_PLL_DIG_HPM_CTRL_HPM_SDM_IN_DISABLE_Pos = 0xf
	// Bit mask of HPM_SDM_IN_DISABLE field.
	XCVR_PLL_DIG_HPM_CTRL_HPM_SDM_IN_DISABLE_Msk = 0x8000
	// Bit HPM_SDM_IN_DISABLE.
	XCVR_PLL_DIG_HPM_CTRL_HPM_SDM_IN_DISABLE = 0x8000
	// Position of HPM_LFSR_SIZE field.
	XCVR_PLL_DIG_HPM_CTRL_HPM_LFSR_SIZE_Pos = 0x10
	// Bit mask of HPM_LFSR_SIZE field.
	XCVR_PLL_DIG_HPM_CTRL_HPM_LFSR_SIZE_Msk = 0x70000
	// LFSR 9, tap mask 100010000
	XCVR_PLL_DIG_HPM_CTRL_HPM_LFSR_SIZE_000 = 0x0
	// LFSR 10, tap mask 1001000000
	XCVR_PLL_DIG_HPM_CTRL_HPM_LFSR_SIZE_001 = 0x1
	// LFSR 11, tap mask 11101000000
	XCVR_PLL_DIG_HPM_CTRL_HPM_LFSR_SIZE_010 = 0x2
	// LFSR 13, tap mask 1101100000000
	XCVR_PLL_DIG_HPM_CTRL_HPM_LFSR_SIZE_011 = 0x3
	// LFSR 15, tap mask 111010000000000
	XCVR_PLL_DIG_HPM_CTRL_HPM_LFSR_SIZE_100 = 0x4
	// LFSR 17, tap mask 11110000000000000
	XCVR_PLL_DIG_HPM_CTRL_HPM_LFSR_SIZE_101 = 0x5
	// Position of HPM_DTH_SCL field.
	XCVR_PLL_DIG_HPM_CTRL_HPM_DTH_SCL_Pos = 0x14
	// Bit mask of HPM_DTH_SCL field.
	XCVR_PLL_DIG_HPM_CTRL_HPM_DTH_SCL_Msk = 0x100000
	// Bit HPM_DTH_SCL.
	XCVR_PLL_DIG_HPM_CTRL_HPM_DTH_SCL = 0x100000
	// Position of HPM_DTH_EN field.
	XCVR_PLL_DIG_HPM_CTRL_HPM_DTH_EN_Pos = 0x17
	// Bit mask of HPM_DTH_EN field.
	XCVR_PLL_DIG_HPM_CTRL_HPM_DTH_EN_Msk = 0x800000
	// Bit HPM_DTH_EN.
	XCVR_PLL_DIG_HPM_CTRL_HPM_DTH_EN = 0x800000
	// Position of HPM_INTEGER_SCALE field.
	XCVR_PLL_DIG_HPM_CTRL_HPM_INTEGER_SCALE_Pos = 0x18
	// Bit mask of HPM_INTEGER_SCALE field.
	XCVR_PLL_DIG_HPM_CTRL_HPM_INTEGER_SCALE_Msk = 0x3000000
	// No Scaling
	XCVR_PLL_DIG_HPM_CTRL_HPM_INTEGER_SCALE_00 = 0x0
	// Multiply by 2
	XCVR_PLL_DIG_HPM_CTRL_HPM_INTEGER_SCALE_01 = 0x1
	// Divide by 2
	XCVR_PLL_DIG_HPM_CTRL_HPM_INTEGER_SCALE_10 = 0x2
	// Position of HPM_INTEGER_INVERT field.
	XCVR_PLL_DIG_HPM_CTRL_HPM_INTEGER_INVERT_Pos = 0x1b
	// Bit mask of HPM_INTEGER_INVERT field.
	XCVR_PLL_DIG_HPM_CTRL_HPM_INTEGER_INVERT_Msk = 0x8000000
	// Bit HPM_INTEGER_INVERT.
	XCVR_PLL_DIG_HPM_CTRL_HPM_INTEGER_INVERT = 0x8000000
	// Position of HPM_CAL_INVERT field.
	XCVR_PLL_DIG_HPM_CTRL_HPM_CAL_INVERT_Pos = 0x1c
	// Bit mask of HPM_CAL_INVERT field.
	XCVR_PLL_DIG_HPM_CTRL_HPM_CAL_INVERT_Msk = 0x10000000
	// Bit HPM_CAL_INVERT.
	XCVR_PLL_DIG_HPM_CTRL_HPM_CAL_INVERT = 0x10000000
	// Position of HPM_MOD_IN_INVERT field.
	XCVR_PLL_DIG_HPM_CTRL_HPM_MOD_IN_INVERT_Pos = 0x1f
	// Bit mask of HPM_MOD_IN_INVERT field.
	XCVR_PLL_DIG_HPM_CTRL_HPM_MOD_IN_INVERT_Msk = 0x80000000
	// Bit HPM_MOD_IN_INVERT.
	XCVR_PLL_DIG_HPM_CTRL_HPM_MOD_IN_INVERT = 0x80000000

	// HPMCAL_CTRL: PLL High Port Calibration Control
	// Position of HPM_CAL_FACTOR field.
	XCVR_PLL_DIG_HPMCAL_CTRL_HPM_CAL_FACTOR_Pos = 0x0
	// Bit mask of HPM_CAL_FACTOR field.
	XCVR_PLL_DIG_HPMCAL_CTRL_HPM_CAL_FACTOR_Msk = 0x1fff
	// Position of HPM_CAL_NOT_BUMPED field.
	XCVR_PLL_DIG_HPMCAL_CTRL_HPM_CAL_NOT_BUMPED_Pos = 0xd
	// Bit mask of HPM_CAL_NOT_BUMPED field.
	XCVR_PLL_DIG_HPMCAL_CTRL_HPM_CAL_NOT_BUMPED_Msk = 0x2000
	// Bit HPM_CAL_NOT_BUMPED.
	XCVR_PLL_DIG_HPMCAL_CTRL_HPM_CAL_NOT_BUMPED = 0x2000
	// Position of HPM_CAL_COUNT_SCALE field.
	XCVR_PLL_DIG_HPMCAL_CTRL_HPM_CAL_COUNT_SCALE_Pos = 0xe
	// Bit mask of HPM_CAL_COUNT_SCALE field.
	XCVR_PLL_DIG_HPMCAL_CTRL_HPM_CAL_COUNT_SCALE_Msk = 0x4000
	// Bit HPM_CAL_COUNT_SCALE.
	XCVR_PLL_DIG_HPMCAL_CTRL_HPM_CAL_COUNT_SCALE = 0x4000
	// Position of HP_CAL_DISABLE field.
	XCVR_PLL_DIG_HPMCAL_CTRL_HP_CAL_DISABLE_Pos = 0xf
	// Bit mask of HP_CAL_DISABLE field.
	XCVR_PLL_DIG_HPMCAL_CTRL_HP_CAL_DISABLE_Msk = 0x8000
	// Bit HP_CAL_DISABLE.
	XCVR_PLL_DIG_HPMCAL_CTRL_HP_CAL_DISABLE = 0x8000
	// Position of HPM_CAL_FACTOR_MANUAL field.
	XCVR_PLL_DIG_HPMCAL_CTRL_HPM_CAL_FACTOR_MANUAL_Pos = 0x10
	// Bit mask of HPM_CAL_FACTOR_MANUAL field.
	XCVR_PLL_DIG_HPMCAL_CTRL_HPM_CAL_FACTOR_MANUAL_Msk = 0x1fff0000
	// Position of HPM_CAL_ARRAY_SIZE field.
	XCVR_PLL_DIG_HPMCAL_CTRL_HPM_CAL_ARRAY_SIZE_Pos = 0x1e
	// Bit mask of HPM_CAL_ARRAY_SIZE field.
	XCVR_PLL_DIG_HPMCAL_CTRL_HPM_CAL_ARRAY_SIZE_Msk = 0x40000000
	// Bit HPM_CAL_ARRAY_SIZE.
	XCVR_PLL_DIG_HPMCAL_CTRL_HPM_CAL_ARRAY_SIZE = 0x40000000
	// 128
	XCVR_PLL_DIG_HPMCAL_CTRL_HPM_CAL_ARRAY_SIZE_0 = 0x0
	// 256
	XCVR_PLL_DIG_HPMCAL_CTRL_HPM_CAL_ARRAY_SIZE_1 = 0x1
	// Position of HPM_CAL_TIME field.
	XCVR_PLL_DIG_HPMCAL_CTRL_HPM_CAL_TIME_Pos = 0x1f
	// Bit mask of HPM_CAL_TIME field.
	XCVR_PLL_DIG_HPMCAL_CTRL_HPM_CAL_TIME_Msk = 0x80000000
	// Bit HPM_CAL_TIME.
	XCVR_PLL_DIG_HPMCAL_CTRL_HPM_CAL_TIME = 0x80000000
	// 25 us
	XCVR_PLL_DIG_HPMCAL_CTRL_HPM_CAL_TIME_0 = 0x0
	// 50 us
	XCVR_PLL_DIG_HPMCAL_CTRL_HPM_CAL_TIME_1 = 0x1

	// HPM_CAL1: PLL High Port Calibration Result 1
	// Position of HPM_COUNT_1 field.
	XCVR_PLL_DIG_HPM_CAL1_HPM_COUNT_1_Pos = 0x0
	// Bit mask of HPM_COUNT_1 field.
	XCVR_PLL_DIG_HPM_CAL1_HPM_COUNT_1_Msk = 0x7ffff
	// Position of CS_WT field.
	XCVR_PLL_DIG_HPM_CAL1_CS_WT_Pos = 0x14
	// Bit mask of CS_WT field.
	XCVR_PLL_DIG_HPM_CAL1_CS_WT_Msk = 0x700000
	// 128 us
	XCVR_PLL_DIG_HPM_CAL1_CS_WT_000 = 0x0
	// 256 us
	XCVR_PLL_DIG_HPM_CAL1_CS_WT_001 = 0x1
	// 384 us
	XCVR_PLL_DIG_HPM_CAL1_CS_WT_010 = 0x2
	// 512 us
	XCVR_PLL_DIG_HPM_CAL1_CS_WT_011 = 0x3
	// 640 us
	XCVR_PLL_DIG_HPM_CAL1_CS_WT_100 = 0x4
	// 768 us
	XCVR_PLL_DIG_HPM_CAL1_CS_WT_101 = 0x5
	// 896 us
	XCVR_PLL_DIG_HPM_CAL1_CS_WT_110 = 0x6
	// 1024 us
	XCVR_PLL_DIG_HPM_CAL1_CS_WT_111 = 0x7
	// Position of CS_FW field.
	XCVR_PLL_DIG_HPM_CAL1_CS_FW_Pos = 0x18
	// Bit mask of CS_FW field.
	XCVR_PLL_DIG_HPM_CAL1_CS_FW_Msk = 0x7000000
	// 8 us
	XCVR_PLL_DIG_HPM_CAL1_CS_FW_000 = 0x0
	// 16 us
	XCVR_PLL_DIG_HPM_CAL1_CS_FW_001 = 0x1
	// 24 us
	XCVR_PLL_DIG_HPM_CAL1_CS_FW_010 = 0x2
	// 32 us
	XCVR_PLL_DIG_HPM_CAL1_CS_FW_011 = 0x3
	// 64 us
	XCVR_PLL_DIG_HPM_CAL1_CS_FW_100 = 0x4
	// 96 us
	XCVR_PLL_DIG_HPM_CAL1_CS_FW_101 = 0x5
	// 128 us
	XCVR_PLL_DIG_HPM_CAL1_CS_FW_110 = 0x6
	// 256 us
	XCVR_PLL_DIG_HPM_CAL1_CS_FW_111 = 0x7
	// Position of CS_FCNT field.
	XCVR_PLL_DIG_HPM_CAL1_CS_FCNT_Pos = 0x1c
	// Bit mask of CS_FCNT field.
	XCVR_PLL_DIG_HPM_CAL1_CS_FCNT_Msk = 0xf0000000

	// HPM_CAL2: PLL High Port Calibration Result 2
	// Position of HPM_COUNT_2 field.
	XCVR_PLL_DIG_HPM_CAL2_HPM_COUNT_2_Pos = 0x0
	// Bit mask of HPM_COUNT_2 field.
	XCVR_PLL_DIG_HPM_CAL2_HPM_COUNT_2_Msk = 0x7ffff
	// Position of CS_RC field.
	XCVR_PLL_DIG_HPM_CAL2_CS_RC_Pos = 0x14
	// Bit mask of CS_RC field.
	XCVR_PLL_DIG_HPM_CAL2_CS_RC_Msk = 0x100000
	// Bit CS_RC.
	XCVR_PLL_DIG_HPM_CAL2_CS_RC = 0x100000
	// Position of CS_FT field.
	XCVR_PLL_DIG_HPM_CAL2_CS_FT_Pos = 0x18
	// Bit mask of CS_FT field.
	XCVR_PLL_DIG_HPM_CAL2_CS_FT_Msk = 0x1f000000

	// HPM_SDM_RES: PLL High Port Sigma Delta Results
	// Position of HPM_NUM_SELECTED field.
	XCVR_PLL_DIG_HPM_SDM_RES_HPM_NUM_SELECTED_Pos = 0x0
	// Bit mask of HPM_NUM_SELECTED field.
	XCVR_PLL_DIG_HPM_SDM_RES_HPM_NUM_SELECTED_Msk = 0x3ff
	// Position of HPM_DENOM field.
	XCVR_PLL_DIG_HPM_SDM_RES_HPM_DENOM_Pos = 0x10
	// Bit mask of HPM_DENOM field.
	XCVR_PLL_DIG_HPM_SDM_RES_HPM_DENOM_Msk = 0x3ff0000
	// Position of HPM_COUNT_ADJUST field.
	XCVR_PLL_DIG_HPM_SDM_RES_HPM_COUNT_ADJUST_Pos = 0x1c
	// Bit mask of HPM_COUNT_ADJUST field.
	XCVR_PLL_DIG_HPM_SDM_RES_HPM_COUNT_ADJUST_Msk = 0xf0000000

	// LPM_CTRL: PLL Low Port Modulator Control
	// Position of PLL_LD_MANUAL field.
	XCVR_PLL_DIG_LPM_CTRL_PLL_LD_MANUAL_Pos = 0x0
	// Bit mask of PLL_LD_MANUAL field.
	XCVR_PLL_DIG_LPM_CTRL_PLL_LD_MANUAL_Msk = 0x3f
	// Position of PLL_LD_DISABLE field.
	XCVR_PLL_DIG_LPM_CTRL_PLL_LD_DISABLE_Pos = 0xb
	// Bit mask of PLL_LD_DISABLE field.
	XCVR_PLL_DIG_LPM_CTRL_PLL_LD_DISABLE_Msk = 0x800
	// Bit PLL_LD_DISABLE.
	XCVR_PLL_DIG_LPM_CTRL_PLL_LD_DISABLE = 0x800
	// Position of LPFF field.
	XCVR_PLL_DIG_LPM_CTRL_LPFF_Pos = 0xd
	// Bit mask of LPFF field.
	XCVR_PLL_DIG_LPM_CTRL_LPFF_Msk = 0x2000
	// Bit LPFF.
	XCVR_PLL_DIG_LPM_CTRL_LPFF = 0x2000
	// Position of LPM_SDM_INV field.
	XCVR_PLL_DIG_LPM_CTRL_LPM_SDM_INV_Pos = 0xe
	// Bit mask of LPM_SDM_INV field.
	XCVR_PLL_DIG_LPM_CTRL_LPM_SDM_INV_Msk = 0x4000
	// Bit LPM_SDM_INV.
	XCVR_PLL_DIG_LPM_CTRL_LPM_SDM_INV = 0x4000
	// Position of LPM_DISABLE field.
	XCVR_PLL_DIG_LPM_CTRL_LPM_DISABLE_Pos = 0xf
	// Bit mask of LPM_DISABLE field.
	XCVR_PLL_DIG_LPM_CTRL_LPM_DISABLE_Msk = 0x8000
	// Bit LPM_DISABLE.
	XCVR_PLL_DIG_LPM_CTRL_LPM_DISABLE = 0x8000
	// Position of LPM_DTH_SCL field.
	XCVR_PLL_DIG_LPM_CTRL_LPM_DTH_SCL_Pos = 0x10
	// Bit mask of LPM_DTH_SCL field.
	XCVR_PLL_DIG_LPM_CTRL_LPM_DTH_SCL_Msk = 0xf0000
	// -128 to 96
	XCVR_PLL_DIG_LPM_CTRL_LPM_DTH_SCL_0101 = 0x5
	// -256 to 192
	XCVR_PLL_DIG_LPM_CTRL_LPM_DTH_SCL_0110 = 0x6
	// -512 to 384
	XCVR_PLL_DIG_LPM_CTRL_LPM_DTH_SCL_0111 = 0x7
	// -1024 to 768
	XCVR_PLL_DIG_LPM_CTRL_LPM_DTH_SCL_1000 = 0x8
	// -2048 to 1536
	XCVR_PLL_DIG_LPM_CTRL_LPM_DTH_SCL_1001 = 0x9
	// -4096 to 3072
	XCVR_PLL_DIG_LPM_CTRL_LPM_DTH_SCL_1010 = 0xa
	// -8192 to 6144
	XCVR_PLL_DIG_LPM_CTRL_LPM_DTH_SCL_1011 = 0xb
	// Position of LPM_D_CTRL field.
	XCVR_PLL_DIG_LPM_CTRL_LPM_D_CTRL_Pos = 0x16
	// Bit mask of LPM_D_CTRL field.
	XCVR_PLL_DIG_LPM_CTRL_LPM_D_CTRL_Msk = 0x400000
	// Bit LPM_D_CTRL.
	XCVR_PLL_DIG_LPM_CTRL_LPM_D_CTRL = 0x400000
	// Position of LPM_D_OVRD field.
	XCVR_PLL_DIG_LPM_CTRL_LPM_D_OVRD_Pos = 0x17
	// Bit mask of LPM_D_OVRD field.
	XCVR_PLL_DIG_LPM_CTRL_LPM_D_OVRD_Msk = 0x800000
	// Bit LPM_D_OVRD.
	XCVR_PLL_DIG_LPM_CTRL_LPM_D_OVRD = 0x800000
	// Position of LPM_SCALE field.
	XCVR_PLL_DIG_LPM_CTRL_LPM_SCALE_Pos = 0x18
	// Bit mask of LPM_SCALE field.
	XCVR_PLL_DIG_LPM_CTRL_LPM_SCALE_Msk = 0xf000000
	// No Scaling
	XCVR_PLL_DIG_LPM_CTRL_LPM_SCALE_0000 = 0x0
	// Multiply by 2
	XCVR_PLL_DIG_LPM_CTRL_LPM_SCALE_0001 = 0x1
	// Multiply by 4
	XCVR_PLL_DIG_LPM_CTRL_LPM_SCALE_0010 = 0x2
	// Multiply by 8
	XCVR_PLL_DIG_LPM_CTRL_LPM_SCALE_0011 = 0x3
	// Multiply by 16
	XCVR_PLL_DIG_LPM_CTRL_LPM_SCALE_0100 = 0x4
	// Multiply by 32
	XCVR_PLL_DIG_LPM_CTRL_LPM_SCALE_0101 = 0x5
	// Multiply by 64
	XCVR_PLL_DIG_LPM_CTRL_LPM_SCALE_0110 = 0x6
	// Multiply by 128
	XCVR_PLL_DIG_LPM_CTRL_LPM_SCALE_0111 = 0x7
	// Multiply by 256
	XCVR_PLL_DIG_LPM_CTRL_LPM_SCALE_1000 = 0x8
	// Multiply by 512
	XCVR_PLL_DIG_LPM_CTRL_LPM_SCALE_1001 = 0x9
	// Multiply by 1024
	XCVR_PLL_DIG_LPM_CTRL_LPM_SCALE_1010 = 0xa
	// Multiply by 2048
	XCVR_PLL_DIG_LPM_CTRL_LPM_SCALE_1011 = 0xb
	// Position of LPM_SDM_USE_NEG field.
	XCVR_PLL_DIG_LPM_CTRL_LPM_SDM_USE_NEG_Pos = 0x1f
	// Bit mask of LPM_SDM_USE_NEG field.
	XCVR_PLL_DIG_LPM_CTRL_LPM_SDM_USE_NEG_Msk = 0x80000000
	// Bit LPM_SDM_USE_NEG.
	XCVR_PLL_DIG_LPM_CTRL_LPM_SDM_USE_NEG = 0x80000000

	// LPM_SDM_CTRL1: PLL Low Port Sigma Delta Control 1
	// Position of LPM_INTG_SELECTED field.
	XCVR_PLL_DIG_LPM_SDM_CTRL1_LPM_INTG_SELECTED_Pos = 0x0
	// Bit mask of LPM_INTG_SELECTED field.
	XCVR_PLL_DIG_LPM_SDM_CTRL1_LPM_INTG_SELECTED_Msk = 0x7f
	// Position of HPM_ARRAY_BIAS field.
	XCVR_PLL_DIG_LPM_SDM_CTRL1_HPM_ARRAY_BIAS_Pos = 0x8
	// Bit mask of HPM_ARRAY_BIAS field.
	XCVR_PLL_DIG_LPM_SDM_CTRL1_HPM_ARRAY_BIAS_Msk = 0x7f00
	// Position of LPM_INTG field.
	XCVR_PLL_DIG_LPM_SDM_CTRL1_LPM_INTG_Pos = 0x10
	// Bit mask of LPM_INTG field.
	XCVR_PLL_DIG_LPM_SDM_CTRL1_LPM_INTG_Msk = 0x7f0000
	// Position of SDM_MAP_DISABLE field.
	XCVR_PLL_DIG_LPM_SDM_CTRL1_SDM_MAP_DISABLE_Pos = 0x1f
	// Bit mask of SDM_MAP_DISABLE field.
	XCVR_PLL_DIG_LPM_SDM_CTRL1_SDM_MAP_DISABLE_Msk = 0x80000000
	// Bit SDM_MAP_DISABLE.
	XCVR_PLL_DIG_LPM_SDM_CTRL1_SDM_MAP_DISABLE = 0x80000000

	// LPM_SDM_CTRL2: PLL Low Port Sigma Delta Control 2
	// Position of LPM_NUM field.
	XCVR_PLL_DIG_LPM_SDM_CTRL2_LPM_NUM_Pos = 0x0
	// Bit mask of LPM_NUM field.
	XCVR_PLL_DIG_LPM_SDM_CTRL2_LPM_NUM_Msk = 0xfffffff

	// LPM_SDM_CTRL3: PLL Low Port Sigma Delta Control 3
	// Position of LPM_DENOM field.
	XCVR_PLL_DIG_LPM_SDM_CTRL3_LPM_DENOM_Pos = 0x0
	// Bit mask of LPM_DENOM field.
	XCVR_PLL_DIG_LPM_SDM_CTRL3_LPM_DENOM_Msk = 0xfffffff

	// LPM_SDM_RES1: PLL Low Port Sigma Delta Result 1
	// Position of LPM_NUM_SELECTED field.
	XCVR_PLL_DIG_LPM_SDM_RES1_LPM_NUM_SELECTED_Pos = 0x0
	// Bit mask of LPM_NUM_SELECTED field.
	XCVR_PLL_DIG_LPM_SDM_RES1_LPM_NUM_SELECTED_Msk = 0xfffffff

	// LPM_SDM_RES2: PLL Low Port Sigma Delta Result 2
	// Position of LPM_DENOM_SELECTED field.
	XCVR_PLL_DIG_LPM_SDM_RES2_LPM_DENOM_SELECTED_Pos = 0x0
	// Bit mask of LPM_DENOM_SELECTED field.
	XCVR_PLL_DIG_LPM_SDM_RES2_LPM_DENOM_SELECTED_Msk = 0xfffffff

	// DELAY_MATCH: PLL Delay Matching
	// Position of LPM_SDM_DELAY field.
	XCVR_PLL_DIG_DELAY_MATCH_LPM_SDM_DELAY_Pos = 0x0
	// Bit mask of LPM_SDM_DELAY field.
	XCVR_PLL_DIG_DELAY_MATCH_LPM_SDM_DELAY_Msk = 0xf
	// Position of HPM_SDM_DELAY field.
	XCVR_PLL_DIG_DELAY_MATCH_HPM_SDM_DELAY_Pos = 0x8
	// Bit mask of HPM_SDM_DELAY field.
	XCVR_PLL_DIG_DELAY_MATCH_HPM_SDM_DELAY_Msk = 0xf00
	// Position of HPM_INTEGER_DELAY field.
	XCVR_PLL_DIG_DELAY_MATCH_HPM_INTEGER_DELAY_Pos = 0x10
	// Bit mask of HPM_INTEGER_DELAY field.
	XCVR_PLL_DIG_DELAY_MATCH_HPM_INTEGER_DELAY_Msk = 0xf0000

	// CTUNE_CTRL: PLL Coarse Tune Control
	// Position of CTUNE_TARGET_MANUAL field.
	XCVR_PLL_DIG_CTUNE_CTRL_CTUNE_TARGET_MANUAL_Pos = 0x0
	// Bit mask of CTUNE_TARGET_MANUAL field.
	XCVR_PLL_DIG_CTUNE_CTRL_CTUNE_TARGET_MANUAL_Msk = 0xfff
	// Position of CTUNE_TARGET_DISABLE field.
	XCVR_PLL_DIG_CTUNE_CTRL_CTUNE_TARGET_DISABLE_Pos = 0xf
	// Bit mask of CTUNE_TARGET_DISABLE field.
	XCVR_PLL_DIG_CTUNE_CTRL_CTUNE_TARGET_DISABLE_Msk = 0x8000
	// Bit CTUNE_TARGET_DISABLE.
	XCVR_PLL_DIG_CTUNE_CTRL_CTUNE_TARGET_DISABLE = 0x8000
	// Position of CTUNE_ADJUST field.
	XCVR_PLL_DIG_CTUNE_CTRL_CTUNE_ADJUST_Pos = 0x10
	// Bit mask of CTUNE_ADJUST field.
	XCVR_PLL_DIG_CTUNE_CTRL_CTUNE_ADJUST_Msk = 0xf0000
	// Position of CTUNE_MANUAL field.
	XCVR_PLL_DIG_CTUNE_CTRL_CTUNE_MANUAL_Pos = 0x18
	// Bit mask of CTUNE_MANUAL field.
	XCVR_PLL_DIG_CTUNE_CTRL_CTUNE_MANUAL_Msk = 0x7f000000
	// Position of CTUNE_DISABLE field.
	XCVR_PLL_DIG_CTUNE_CTRL_CTUNE_DISABLE_Pos = 0x1f
	// Bit mask of CTUNE_DISABLE field.
	XCVR_PLL_DIG_CTUNE_CTRL_CTUNE_DISABLE_Msk = 0x80000000
	// Bit CTUNE_DISABLE.
	XCVR_PLL_DIG_CTUNE_CTRL_CTUNE_DISABLE = 0x80000000

	// CTUNE_CNT6: PLL Coarse Tune Count 6
	// Position of CTUNE_COUNT_6 field.
	XCVR_PLL_DIG_CTUNE_CNT6_CTUNE_COUNT_6_Pos = 0x0
	// Bit mask of CTUNE_COUNT_6 field.
	XCVR_PLL_DIG_CTUNE_CNT6_CTUNE_COUNT_6_Msk = 0x1fff

	// CTUNE_CNT5_4: PLL Coarse Tune Counts 5 and 4
	// Position of CTUNE_COUNT_4 field.
	XCVR_PLL_DIG_CTUNE_CNT5_4_CTUNE_COUNT_4_Pos = 0x0
	// Bit mask of CTUNE_COUNT_4 field.
	XCVR_PLL_DIG_CTUNE_CNT5_4_CTUNE_COUNT_4_Msk = 0x1fff
	// Position of CTUNE_COUNT_5 field.
	XCVR_PLL_DIG_CTUNE_CNT5_4_CTUNE_COUNT_5_Pos = 0x10
	// Bit mask of CTUNE_COUNT_5 field.
	XCVR_PLL_DIG_CTUNE_CNT5_4_CTUNE_COUNT_5_Msk = 0x1fff0000

	// CTUNE_CNT3_2: PLL Coarse Tune Counts 3 and 2
	// Position of CTUNE_COUNT_2 field.
	XCVR_PLL_DIG_CTUNE_CNT3_2_CTUNE_COUNT_2_Pos = 0x0
	// Bit mask of CTUNE_COUNT_2 field.
	XCVR_PLL_DIG_CTUNE_CNT3_2_CTUNE_COUNT_2_Msk = 0x1fff
	// Position of CTUNE_COUNT_3 field.
	XCVR_PLL_DIG_CTUNE_CNT3_2_CTUNE_COUNT_3_Pos = 0x10
	// Bit mask of CTUNE_COUNT_3 field.
	XCVR_PLL_DIG_CTUNE_CNT3_2_CTUNE_COUNT_3_Msk = 0x1fff0000

	// CTUNE_CNT1_0: PLL Coarse Tune Counts 1 and 0
	// Position of CTUNE_COUNT_0 field.
	XCVR_PLL_DIG_CTUNE_CNT1_0_CTUNE_COUNT_0_Pos = 0x0
	// Bit mask of CTUNE_COUNT_0 field.
	XCVR_PLL_DIG_CTUNE_CNT1_0_CTUNE_COUNT_0_Msk = 0x1fff
	// Position of CTUNE_COUNT_1 field.
	XCVR_PLL_DIG_CTUNE_CNT1_0_CTUNE_COUNT_1_Pos = 0x10
	// Bit mask of CTUNE_COUNT_1 field.
	XCVR_PLL_DIG_CTUNE_CNT1_0_CTUNE_COUNT_1_Msk = 0x1fff0000

	// CTUNE_RES: PLL Coarse Tune Results
	// Position of CTUNE_SELECTED field.
	XCVR_PLL_DIG_CTUNE_RES_CTUNE_SELECTED_Pos = 0x0
	// Bit mask of CTUNE_SELECTED field.
	XCVR_PLL_DIG_CTUNE_RES_CTUNE_SELECTED_Msk = 0x7f
	// Position of CTUNE_BEST_DIFF field.
	XCVR_PLL_DIG_CTUNE_RES_CTUNE_BEST_DIFF_Pos = 0x8
	// Bit mask of CTUNE_BEST_DIFF field.
	XCVR_PLL_DIG_CTUNE_RES_CTUNE_BEST_DIFF_Msk = 0xff00
	// Position of CTUNE_FREQ_SELECTED field.
	XCVR_PLL_DIG_CTUNE_RES_CTUNE_FREQ_SELECTED_Pos = 0x10
	// Bit mask of CTUNE_FREQ_SELECTED field.
	XCVR_PLL_DIG_CTUNE_RES_CTUNE_FREQ_SELECTED_Msk = 0xfff0000
)

// Bitfields for XCVR_MISC: XCVR_MISC
const (
	// XCVR_CTRL: TRANSCEIVER CONTROL
	// Position of PROTOCOL field.
	XCVR_MISC_XCVR_CTRL_PROTOCOL_Pos = 0x0
	// Bit mask of PROTOCOL field.
	XCVR_MISC_XCVR_CTRL_PROTOCOL_Msk = 0xf
	// BLE
	XCVR_MISC_XCVR_CTRL_PROTOCOL_0000 = 0x0
	// BLE in MBAN
	XCVR_MISC_XCVR_CTRL_PROTOCOL_0001 = 0x1
	// BLE overlap MBAN
	XCVR_MISC_XCVR_CTRL_PROTOCOL_0010 = 0x2
	// ANT
	XCVR_MISC_XCVR_CTRL_PROTOCOL_0011 = 0x3
	// Zigbee
	XCVR_MISC_XCVR_CTRL_PROTOCOL_0100 = 0x4
	// 802.15.4j
	XCVR_MISC_XCVR_CTRL_PROTOCOL_0101 = 0x5
	// 128 Channel FSK
	XCVR_MISC_XCVR_CTRL_PROTOCOL_0110 = 0x6
	// 128 Channel GFSK
	XCVR_MISC_XCVR_CTRL_PROTOCOL_0111 = 0x7
	// Generic FSK
	XCVR_MISC_XCVR_CTRL_PROTOCOL_1000 = 0x8
	// MSK
	XCVR_MISC_XCVR_CTRL_PROTOCOL_1001 = 0x9
	// Position of TGT_PWR_SRC field.
	XCVR_MISC_XCVR_CTRL_TGT_PWR_SRC_Pos = 0x4
	// Bit mask of TGT_PWR_SRC field.
	XCVR_MISC_XCVR_CTRL_TGT_PWR_SRC_Msk = 0x70
	// Position of REF_CLK_FREQ field.
	XCVR_MISC_XCVR_CTRL_REF_CLK_FREQ_Pos = 0x8
	// Bit mask of REF_CLK_FREQ field.
	XCVR_MISC_XCVR_CTRL_REF_CLK_FREQ_Msk = 0x300
	// 32 MHz
	XCVR_MISC_XCVR_CTRL_REF_CLK_FREQ_00 = 0x0
	// 26 MHz
	XCVR_MISC_XCVR_CTRL_REF_CLK_FREQ_01 = 0x1
	// Position of SOC_RF_OSC_CLK_GATE_EN field.
	XCVR_MISC_XCVR_CTRL_SOC_RF_OSC_CLK_GATE_EN_Pos = 0xb
	// Bit mask of SOC_RF_OSC_CLK_GATE_EN field.
	XCVR_MISC_XCVR_CTRL_SOC_RF_OSC_CLK_GATE_EN_Msk = 0x800
	// Bit SOC_RF_OSC_CLK_GATE_EN.
	XCVR_MISC_XCVR_CTRL_SOC_RF_OSC_CLK_GATE_EN = 0x800
	// Position of DEMOD_SEL field.
	XCVR_MISC_XCVR_CTRL_DEMOD_SEL_Pos = 0xc
	// Bit mask of DEMOD_SEL field.
	XCVR_MISC_XCVR_CTRL_DEMOD_SEL_Msk = 0x3000
	// No demodulator selected
	XCVR_MISC_XCVR_CTRL_DEMOD_SEL_00 = 0x0
	// Use Freescale Constant Envelope demodulator
	XCVR_MISC_XCVR_CTRL_DEMOD_SEL_01 = 0x1
	// Use Legacy 802.15.4 demodulator
	XCVR_MISC_XCVR_CTRL_DEMOD_SEL_10 = 0x2
	// Position of RADIO0_IRQ_SEL field.
	XCVR_MISC_XCVR_CTRL_RADIO0_IRQ_SEL_Pos = 0x10
	// Bit mask of RADIO0_IRQ_SEL field.
	XCVR_MISC_XCVR_CTRL_RADIO0_IRQ_SEL_Msk = 0x70000
	// Assign Radio #0 Interrupt to BLE
	XCVR_MISC_XCVR_CTRL_RADIO0_IRQ_SEL_000 = 0x0
	// Assign Radio #0 Interrupt to 802.15.4
	XCVR_MISC_XCVR_CTRL_RADIO0_IRQ_SEL_001 = 0x1
	// Assign Radio #0 Interrupt to ANT
	XCVR_MISC_XCVR_CTRL_RADIO0_IRQ_SEL_010 = 0x2
	// Assign Radio #0 Interrupt to GENERIC_FSK
	XCVR_MISC_XCVR_CTRL_RADIO0_IRQ_SEL_011 = 0x3
	// Radio #0 Interrupt unassigned
	XCVR_MISC_XCVR_CTRL_RADIO0_IRQ_SEL_100 = 0x4
	// Radio #0 Interrupt unassigned
	XCVR_MISC_XCVR_CTRL_RADIO0_IRQ_SEL_101 = 0x5
	// Radio #0 Interrupt unassigned
	XCVR_MISC_XCVR_CTRL_RADIO0_IRQ_SEL_110 = 0x6
	// Radio #0 Interrupt unassigned
	XCVR_MISC_XCVR_CTRL_RADIO0_IRQ_SEL_111 = 0x7
	// Position of RADIO1_IRQ_SEL field.
	XCVR_MISC_XCVR_CTRL_RADIO1_IRQ_SEL_Pos = 0x14
	// Bit mask of RADIO1_IRQ_SEL field.
	XCVR_MISC_XCVR_CTRL_RADIO1_IRQ_SEL_Msk = 0x700000
	// Assign Radio #1 Interrupt to BLE
	XCVR_MISC_XCVR_CTRL_RADIO1_IRQ_SEL_000 = 0x0
	// Assign Radio #1 Interrupt to 802.15.4
	XCVR_MISC_XCVR_CTRL_RADIO1_IRQ_SEL_001 = 0x1
	// Assign Radio #1 Interrupt to ANT
	XCVR_MISC_XCVR_CTRL_RADIO1_IRQ_SEL_010 = 0x2
	// Assign Radio #1 Interrupt to GENERIC_FSK
	XCVR_MISC_XCVR_CTRL_RADIO1_IRQ_SEL_011 = 0x3
	// Radio #1 Interrupt unassigned
	XCVR_MISC_XCVR_CTRL_RADIO1_IRQ_SEL_100 = 0x4
	// Radio #1 Interrupt unassigned
	XCVR_MISC_XCVR_CTRL_RADIO1_IRQ_SEL_101 = 0x5
	// Radio #1 Interrupt unassigned
	XCVR_MISC_XCVR_CTRL_RADIO1_IRQ_SEL_110 = 0x6
	// Radio #1 Interrupt unassigned
	XCVR_MISC_XCVR_CTRL_RADIO1_IRQ_SEL_111 = 0x7

	// XCVR_STATUS: TRANSCEIVER STATUS
	// Position of TSM_COUNT field.
	XCVR_MISC_XCVR_STATUS_TSM_COUNT_Pos = 0x0
	// Bit mask of TSM_COUNT field.
	XCVR_MISC_XCVR_STATUS_TSM_COUNT_Msk = 0xff
	// Position of PLL_SEQ_STATE field.
	XCVR_MISC_XCVR_STATUS_PLL_SEQ_STATE_Pos = 0x8
	// Bit mask of PLL_SEQ_STATE field.
	XCVR_MISC_XCVR_STATUS_PLL_SEQ_STATE_Msk = 0xf00
	// PLL OFF
	XCVR_MISC_XCVR_STATUS_PLL_SEQ_STATE_0 = 0x0
	// CTUNE
	XCVR_MISC_XCVR_STATUS_PLL_SEQ_STATE_2 = 0x2
	// CTUNE_SETTLE
	XCVR_MISC_XCVR_STATUS_PLL_SEQ_STATE_3 = 0x3
	// HPMCAL1
	XCVR_MISC_XCVR_STATUS_PLL_SEQ_STATE_6 = 0x6
	// HPMCAL1_SETTLE
	XCVR_MISC_XCVR_STATUS_PLL_SEQ_STATE_8 = 0x8
	// HPMCAL2
	XCVR_MISC_XCVR_STATUS_PLL_SEQ_STATE_10 = 0xa
	// HPMCAL2_SETTLE
	XCVR_MISC_XCVR_STATUS_PLL_SEQ_STATE_12 = 0xc
	// PLLREADY
	XCVR_MISC_XCVR_STATUS_PLL_SEQ_STATE_15 = 0xf
	// Position of RX_MODE field.
	XCVR_MISC_XCVR_STATUS_RX_MODE_Pos = 0xc
	// Bit mask of RX_MODE field.
	XCVR_MISC_XCVR_STATUS_RX_MODE_Msk = 0x1000
	// Bit RX_MODE.
	XCVR_MISC_XCVR_STATUS_RX_MODE = 0x1000
	// Position of TX_MODE field.
	XCVR_MISC_XCVR_STATUS_TX_MODE_Pos = 0xd
	// Bit mask of TX_MODE field.
	XCVR_MISC_XCVR_STATUS_TX_MODE_Msk = 0x2000
	// Bit TX_MODE.
	XCVR_MISC_XCVR_STATUS_TX_MODE = 0x2000
	// Position of BTLE_SYSCLK_REQ field.
	XCVR_MISC_XCVR_STATUS_BTLE_SYSCLK_REQ_Pos = 0x10
	// Bit mask of BTLE_SYSCLK_REQ field.
	XCVR_MISC_XCVR_STATUS_BTLE_SYSCLK_REQ_Msk = 0x10000
	// Bit BTLE_SYSCLK_REQ.
	XCVR_MISC_XCVR_STATUS_BTLE_SYSCLK_REQ = 0x10000
	// Position of RIF_LL_ACTIVE field.
	XCVR_MISC_XCVR_STATUS_RIF_LL_ACTIVE_Pos = 0x11
	// Bit mask of RIF_LL_ACTIVE field.
	XCVR_MISC_XCVR_STATUS_RIF_LL_ACTIVE_Msk = 0x20000
	// Bit RIF_LL_ACTIVE.
	XCVR_MISC_XCVR_STATUS_RIF_LL_ACTIVE = 0x20000
	// Position of XTAL_READY field.
	XCVR_MISC_XCVR_STATUS_XTAL_READY_Pos = 0x12
	// Bit mask of XTAL_READY field.
	XCVR_MISC_XCVR_STATUS_XTAL_READY_Msk = 0x40000
	// Bit XTAL_READY.
	XCVR_MISC_XCVR_STATUS_XTAL_READY = 0x40000
	// Indicates that the RF Oscillator is disabled or has not completed its warmup.
	XCVR_MISC_XCVR_STATUS_XTAL_READY_0 = 0x0
	// Indicates that the RF Oscillator has completed its warmup count and is ready for use.
	XCVR_MISC_XCVR_STATUS_XTAL_READY_1 = 0x1
	// Position of SOC_USING_RF_OSC_CLK field.
	XCVR_MISC_XCVR_STATUS_SOC_USING_RF_OSC_CLK_Pos = 0x13
	// Bit mask of SOC_USING_RF_OSC_CLK field.
	XCVR_MISC_XCVR_STATUS_SOC_USING_RF_OSC_CLK_Msk = 0x80000
	// Bit SOC_USING_RF_OSC_CLK.
	XCVR_MISC_XCVR_STATUS_SOC_USING_RF_OSC_CLK = 0x80000
	// Position of TSM_IRQ0 field.
	XCVR_MISC_XCVR_STATUS_TSM_IRQ0_Pos = 0x18
	// Bit mask of TSM_IRQ0 field.
	XCVR_MISC_XCVR_STATUS_TSM_IRQ0_Msk = 0x1000000
	// Bit TSM_IRQ0.
	XCVR_MISC_XCVR_STATUS_TSM_IRQ0 = 0x1000000
	// TSM Interrupt #0 is not asserted.
	XCVR_MISC_XCVR_STATUS_TSM_IRQ0_0 = 0x0
	// TSM Interrupt #0 is asserted. Write '1' to this bit to clear it.
	XCVR_MISC_XCVR_STATUS_TSM_IRQ0_1 = 0x1
	// Position of TSM_IRQ1 field.
	XCVR_MISC_XCVR_STATUS_TSM_IRQ1_Pos = 0x19
	// Bit mask of TSM_IRQ1 field.
	XCVR_MISC_XCVR_STATUS_TSM_IRQ1_Msk = 0x2000000
	// Bit TSM_IRQ1.
	XCVR_MISC_XCVR_STATUS_TSM_IRQ1 = 0x2000000
	// TSM Interrupt #1 is not asserted.
	XCVR_MISC_XCVR_STATUS_TSM_IRQ1_0 = 0x0
	// TSM Interrupt #1 is asserted. Write '1' to this bit to clear it.
	XCVR_MISC_XCVR_STATUS_TSM_IRQ1_1 = 0x1

	// BLE_ARB_CTRL: BLE ARBITRATION CONTROL
	// Position of BLE_RELINQUISH field.
	XCVR_MISC_BLE_ARB_CTRL_BLE_RELINQUISH_Pos = 0x0
	// Bit mask of BLE_RELINQUISH field.
	XCVR_MISC_BLE_ARB_CTRL_BLE_RELINQUISH_Msk = 0x1
	// Bit BLE_RELINQUISH.
	XCVR_MISC_BLE_ARB_CTRL_BLE_RELINQUISH = 0x1
	// Position of XCVR_BUSY field.
	XCVR_MISC_BLE_ARB_CTRL_XCVR_BUSY_Pos = 0x1
	// Bit mask of XCVR_BUSY field.
	XCVR_MISC_BLE_ARB_CTRL_XCVR_BUSY_Msk = 0x2
	// Bit XCVR_BUSY.
	XCVR_MISC_BLE_ARB_CTRL_XCVR_BUSY = 0x2
	// RF Channel in available (TSM is idle)
	XCVR_MISC_BLE_ARB_CTRL_XCVR_BUSY_0 = 0x0
	// RF Channel in use (TSM is busy)
	XCVR_MISC_BLE_ARB_CTRL_XCVR_BUSY_1 = 0x1

	// OVERWRITE_VER: OVERWRITE VERSION
	// Position of OVERWRITE_VER field.
	XCVR_MISC_OVERWRITE_VER_OVERWRITE_VER_Pos = 0x0
	// Bit mask of OVERWRITE_VER field.
	XCVR_MISC_OVERWRITE_VER_OVERWRITE_VER_Msk = 0xff

	// DMA_CTRL: TRANSCEIVER DMA CONTROL
	// Position of DMA_PAGE field.
	XCVR_MISC_DMA_CTRL_DMA_PAGE_Pos = 0x0
	// Bit mask of DMA_PAGE field.
	XCVR_MISC_DMA_CTRL_DMA_PAGE_Msk = 0xf
	// DMA Idle
	XCVR_MISC_DMA_CTRL_DMA_PAGE_0000 = 0x0
	// RX_DIG I and Q
	XCVR_MISC_DMA_CTRL_DMA_PAGE_0001 = 0x1
	// RX_DIG I Only
	XCVR_MISC_DMA_CTRL_DMA_PAGE_0010 = 0x2
	// RX_DIG Q Only
	XCVR_MISC_DMA_CTRL_DMA_PAGE_0011 = 0x3
	// RAW ADC I and Q
	XCVR_MISC_DMA_CTRL_DMA_PAGE_0100 = 0x4
	// RAW ADC I Only
	XCVR_MISC_DMA_CTRL_DMA_PAGE_0101 = 0x5
	// RAW ADC Q only
	XCVR_MISC_DMA_CTRL_DMA_PAGE_0110 = 0x6
	// DC Estimator I and Q
	XCVR_MISC_DMA_CTRL_DMA_PAGE_0111 = 0x7
	// DC Estimator I Only
	XCVR_MISC_DMA_CTRL_DMA_PAGE_1000 = 0x8
	// DC Estimator Q only
	XCVR_MISC_DMA_CTRL_DMA_PAGE_1001 = 0x9
	// RX_DIG Phase Output
	XCVR_MISC_DMA_CTRL_DMA_PAGE_1010 = 0xa
	// Demodulator Hard Decision
	XCVR_MISC_DMA_CTRL_DMA_PAGE_1011 = 0xb
	// Demodulator Soft Decision
	XCVR_MISC_DMA_CTRL_DMA_PAGE_1100 = 0xc
	// Demodulator Data Output
	XCVR_MISC_DMA_CTRL_DMA_PAGE_1101 = 0xd
	// Demodulator CFO Phase Output
	XCVR_MISC_DMA_CTRL_DMA_PAGE_1110 = 0xe
	// Position of SINGLE_REQ_MODE field.
	XCVR_MISC_DMA_CTRL_SINGLE_REQ_MODE_Pos = 0x4
	// Bit mask of SINGLE_REQ_MODE field.
	XCVR_MISC_DMA_CTRL_SINGLE_REQ_MODE_Msk = 0x10
	// Bit SINGLE_REQ_MODE.
	XCVR_MISC_DMA_CTRL_SINGLE_REQ_MODE = 0x10
	// Disable Single Request Mode. The transceiver will assert ipd_req_radio_rx whenever it has a new sample ready for transfer.
	XCVR_MISC_DMA_CTRL_SINGLE_REQ_MODE_0 = 0x0
	// Enable Single Request Mode. A single initial request by the transceiver will transfer the entire DMA block of data
	XCVR_MISC_DMA_CTRL_SINGLE_REQ_MODE_1 = 0x1
	// Position of BYPASS_DMA_SYNC field.
	XCVR_MISC_DMA_CTRL_BYPASS_DMA_SYNC_Pos = 0x5
	// Bit mask of BYPASS_DMA_SYNC field.
	XCVR_MISC_DMA_CTRL_BYPASS_DMA_SYNC_Msk = 0x20
	// Bit BYPASS_DMA_SYNC.
	XCVR_MISC_DMA_CTRL_BYPASS_DMA_SYNC = 0x20
	// Don't Bypass External Synchronization. Use this setting if SINGLE_REQ_MODE=1.
	XCVR_MISC_DMA_CTRL_BYPASS_DMA_SYNC_0 = 0x0
	// Bypass External Synchronization. This setting is mandatory if SINGLE_REQ_MODE=0.
	XCVR_MISC_DMA_CTRL_BYPASS_DMA_SYNC_1 = 0x1
	// Position of DMA_TRIGGERRED field.
	XCVR_MISC_DMA_CTRL_DMA_TRIGGERRED_Pos = 0x6
	// Bit mask of DMA_TRIGGERRED field.
	XCVR_MISC_DMA_CTRL_DMA_TRIGGERRED_Msk = 0x40
	// Bit DMA_TRIGGERRED.
	XCVR_MISC_DMA_CTRL_DMA_TRIGGERRED = 0x40
	// Position of DMA_TIMED_OUT field.
	XCVR_MISC_DMA_CTRL_DMA_TIMED_OUT_Pos = 0x7
	// Bit mask of DMA_TIMED_OUT field.
	XCVR_MISC_DMA_CTRL_DMA_TIMED_OUT_Msk = 0x80
	// Bit DMA_TIMED_OUT.
	XCVR_MISC_DMA_CTRL_DMA_TIMED_OUT = 0x80
	// A DMA timeout has not occurred
	XCVR_MISC_DMA_CTRL_DMA_TIMED_OUT_0 = 0x0
	// A DMA timeout has occurred in Single Request Mode since the last time this bit was cleared
	XCVR_MISC_DMA_CTRL_DMA_TIMED_OUT_1 = 0x1
	// Position of DMA_TIMEOUT field.
	XCVR_MISC_DMA_CTRL_DMA_TIMEOUT_Pos = 0x8
	// Bit mask of DMA_TIMEOUT field.
	XCVR_MISC_DMA_CTRL_DMA_TIMEOUT_Msk = 0xf00

	// DMA_DATA: TRANSCEIVER DMA DATA
	// Position of DMA_DATA field.
	XCVR_MISC_DMA_DATA_DMA_DATA_Pos = 0x0
	// Bit mask of DMA_DATA field.
	XCVR_MISC_DMA_DATA_DMA_DATA_Msk = 0xffffffff

	// DTEST_CTRL: DIGITAL TEST MUX CONTROL
	// Position of DTEST_PAGE field.
	XCVR_MISC_DTEST_CTRL_DTEST_PAGE_Pos = 0x0
	// Bit mask of DTEST_PAGE field.
	XCVR_MISC_DTEST_CTRL_DTEST_PAGE_Msk = 0x3f
	// Position of DTEST_EN field.
	XCVR_MISC_DTEST_CTRL_DTEST_EN_Pos = 0x7
	// Bit mask of DTEST_EN field.
	XCVR_MISC_DTEST_CTRL_DTEST_EN_Msk = 0x80
	// Bit DTEST_EN.
	XCVR_MISC_DTEST_CTRL_DTEST_EN = 0x80
	// Disables DTEST. The DTEST pins assume their mission function.
	XCVR_MISC_DTEST_CTRL_DTEST_EN_0 = 0x0
	// Enables DTEST. The contents of the selected page (DTEST_PAGE) will appear on the DTEST output pins.
	XCVR_MISC_DTEST_CTRL_DTEST_EN_1 = 0x1
	// Position of GPIO0_OVLAY_PIN field.
	XCVR_MISC_DTEST_CTRL_GPIO0_OVLAY_PIN_Pos = 0x8
	// Bit mask of GPIO0_OVLAY_PIN field.
	XCVR_MISC_DTEST_CTRL_GPIO0_OVLAY_PIN_Msk = 0xf00
	// Position of GPIO1_OVLAY_PIN field.
	XCVR_MISC_DTEST_CTRL_GPIO1_OVLAY_PIN_Pos = 0xc
	// Bit mask of GPIO1_OVLAY_PIN field.
	XCVR_MISC_DTEST_CTRL_GPIO1_OVLAY_PIN_Msk = 0xf000
	// Position of TSM_GPIO_OVLAY field.
	XCVR_MISC_DTEST_CTRL_TSM_GPIO_OVLAY_Pos = 0x10
	// Bit mask of TSM_GPIO_OVLAY field.
	XCVR_MISC_DTEST_CTRL_TSM_GPIO_OVLAY_Msk = 0x30000
	// there is no overlay, and the DTEST Page Table dictates the node that appears on each DTEST pin.
	XCVR_MISC_DTEST_CTRL_TSM_GPIO_OVLAY_00 = 0x0
	// the register GPIO0_OVLAY_PIN[3:0] selects the DTEST pin on which GPIO0_TRIG_EN will appear.
	XCVR_MISC_DTEST_CTRL_TSM_GPIO_OVLAY_01 = 0x1
	// Position of DTEST_SHFT field.
	XCVR_MISC_DTEST_CTRL_DTEST_SHFT_Pos = 0x18
	// Bit mask of DTEST_SHFT field.
	XCVR_MISC_DTEST_CTRL_DTEST_SHFT_Msk = 0x7000000
	// Position of RAW_MODE_I field.
	XCVR_MISC_DTEST_CTRL_RAW_MODE_I_Pos = 0x1c
	// Bit mask of RAW_MODE_I field.
	XCVR_MISC_DTEST_CTRL_RAW_MODE_I_Msk = 0x10000000
	// Bit RAW_MODE_I.
	XCVR_MISC_DTEST_CTRL_RAW_MODE_I = 0x10000000
	// Position of RAW_MODE_Q field.
	XCVR_MISC_DTEST_CTRL_RAW_MODE_Q_Pos = 0x1d
	// Bit mask of RAW_MODE_Q field.
	XCVR_MISC_DTEST_CTRL_RAW_MODE_Q_Msk = 0x20000000
	// Bit RAW_MODE_Q.
	XCVR_MISC_DTEST_CTRL_RAW_MODE_Q = 0x20000000

	// PACKET_RAM_CTRL: PACKET RAM CONTROL
	// Position of DBG_PAGE field.
	XCVR_MISC_PACKET_RAM_CTRL_DBG_PAGE_Pos = 0x0
	// Bit mask of DBG_PAGE field.
	XCVR_MISC_PACKET_RAM_CTRL_DBG_PAGE_Msk = 0xf
	// Packet RAM Debug Mode Idle
	XCVR_MISC_PACKET_RAM_CTRL_DBG_PAGE_0000 = 0x0
	// RX_DIG I and Q
	XCVR_MISC_PACKET_RAM_CTRL_DBG_PAGE_0001 = 0x1
	// RAW ADC I and Q
	XCVR_MISC_PACKET_RAM_CTRL_DBG_PAGE_0100 = 0x4
	// DC Estimator I and Q
	XCVR_MISC_PACKET_RAM_CTRL_DBG_PAGE_0111 = 0x7
	// RX_DIG Phase Output
	XCVR_MISC_PACKET_RAM_CTRL_DBG_PAGE_1010 = 0xa
	// Demodulator Hard Decision
	XCVR_MISC_PACKET_RAM_CTRL_DBG_PAGE_1011 = 0xb
	// Demodulator Soft Decision
	XCVR_MISC_PACKET_RAM_CTRL_DBG_PAGE_1100 = 0xc
	// Demodulator Data Output
	XCVR_MISC_PACKET_RAM_CTRL_DBG_PAGE_1101 = 0xd
	// Demodulator CFO Phase Output
	XCVR_MISC_PACKET_RAM_CTRL_DBG_PAGE_1110 = 0xe
	// Position of PB_PROTECT field.
	XCVR_MISC_PACKET_RAM_CTRL_PB_PROTECT_Pos = 0x4
	// Bit mask of PB_PROTECT field.
	XCVR_MISC_PACKET_RAM_CTRL_PB_PROTECT_Msk = 0x10
	// Bit PB_PROTECT.
	XCVR_MISC_PACKET_RAM_CTRL_PB_PROTECT = 0x10
	// Incoming received packets overwrite Packet Buffer RX contents (default)
	XCVR_MISC_PACKET_RAM_CTRL_PB_PROTECT_0 = 0x0
	// Incoming received packets are blocked from overwriting Packet Buffer RX contents
	XCVR_MISC_PACKET_RAM_CTRL_PB_PROTECT_1 = 0x1
	// Position of XCVR_RAM_ALLOW field.
	XCVR_MISC_PACKET_RAM_CTRL_XCVR_RAM_ALLOW_Pos = 0x5
	// Bit mask of XCVR_RAM_ALLOW field.
	XCVR_MISC_PACKET_RAM_CTRL_XCVR_RAM_ALLOW_Msk = 0x20
	// Bit XCVR_RAM_ALLOW.
	XCVR_MISC_PACKET_RAM_CTRL_XCVR_RAM_ALLOW = 0x20
	// Protocol Engines, and associated IPS busses, have exclusive access to Packet RAM (mission mode)
	XCVR_MISC_PACKET_RAM_CTRL_XCVR_RAM_ALLOW_0 = 0x0
	// Transceiver-space access to Packet RAM, including Packet RAM debug mode, are allowed
	XCVR_MISC_PACKET_RAM_CTRL_XCVR_RAM_ALLOW_1 = 0x1
	// Position of ALL_PROTOCOLS_ALLOW field.
	XCVR_MISC_PACKET_RAM_CTRL_ALL_PROTOCOLS_ALLOW_Pos = 0x6
	// Bit mask of ALL_PROTOCOLS_ALLOW field.
	XCVR_MISC_PACKET_RAM_CTRL_ALL_PROTOCOLS_ALLOW_Msk = 0x40
	// Bit ALL_PROTOCOLS_ALLOW.
	XCVR_MISC_PACKET_RAM_CTRL_ALL_PROTOCOLS_ALLOW = 0x40
	// IPS bus access to Packet RAM is restricted to the protocol engine currently selected by XCVR_CTRL[PROTOCOL].
	XCVR_MISC_PACKET_RAM_CTRL_ALL_PROTOCOLS_ALLOW_0 = 0x0
	// All IPS bus access to Packet RAM permitted, regardless of XCVR_CTRL[PROTOCOL] setting
	XCVR_MISC_PACKET_RAM_CTRL_ALL_PROTOCOLS_ALLOW_1 = 0x1
	// Position of DBG_TRIGGERRED field.
	XCVR_MISC_PACKET_RAM_CTRL_DBG_TRIGGERRED_Pos = 0x7
	// Bit mask of DBG_TRIGGERRED field.
	XCVR_MISC_PACKET_RAM_CTRL_DBG_TRIGGERRED_Msk = 0x80
	// Bit DBG_TRIGGERRED.
	XCVR_MISC_PACKET_RAM_CTRL_DBG_TRIGGERRED = 0x80
	// Position of DBG_RAM_FULL field.
	XCVR_MISC_PACKET_RAM_CTRL_DBG_RAM_FULL_Pos = 0x8
	// Bit mask of DBG_RAM_FULL field.
	XCVR_MISC_PACKET_RAM_CTRL_DBG_RAM_FULL_Msk = 0x300
	// Neither Packet RAM0 nor RAM1 is full
	XCVR_MISC_PACKET_RAM_CTRL_DBG_RAM_FULL_00 = 0x0
	// Position of RAM0_CLK_ON_OVRD_EN field.
	XCVR_MISC_PACKET_RAM_CTRL_RAM0_CLK_ON_OVRD_EN_Pos = 0xa
	// Bit mask of RAM0_CLK_ON_OVRD_EN field.
	XCVR_MISC_PACKET_RAM_CTRL_RAM0_CLK_ON_OVRD_EN_Msk = 0x400
	// Bit RAM0_CLK_ON_OVRD_EN.
	XCVR_MISC_PACKET_RAM_CTRL_RAM0_CLK_ON_OVRD_EN = 0x400
	// Normal operation.
	XCVR_MISC_PACKET_RAM_CTRL_RAM0_CLK_ON_OVRD_EN_0 = 0x0
	// Use the state of RAM0_CLK_ON_OVRD to override the RAM0 Clock Gate Enable.
	XCVR_MISC_PACKET_RAM_CTRL_RAM0_CLK_ON_OVRD_EN_1 = 0x1
	// Position of RAM0_CLK_ON_OVRD field.
	XCVR_MISC_PACKET_RAM_CTRL_RAM0_CLK_ON_OVRD_Pos = 0xb
	// Bit mask of RAM0_CLK_ON_OVRD field.
	XCVR_MISC_PACKET_RAM_CTRL_RAM0_CLK_ON_OVRD_Msk = 0x800
	// Bit RAM0_CLK_ON_OVRD.
	XCVR_MISC_PACKET_RAM_CTRL_RAM0_CLK_ON_OVRD = 0x800
	// Position of RAM1_CLK_ON_OVRD_EN field.
	XCVR_MISC_PACKET_RAM_CTRL_RAM1_CLK_ON_OVRD_EN_Pos = 0xc
	// Bit mask of RAM1_CLK_ON_OVRD_EN field.
	XCVR_MISC_PACKET_RAM_CTRL_RAM1_CLK_ON_OVRD_EN_Msk = 0x1000
	// Bit RAM1_CLK_ON_OVRD_EN.
	XCVR_MISC_PACKET_RAM_CTRL_RAM1_CLK_ON_OVRD_EN = 0x1000
	// Normal operation.
	XCVR_MISC_PACKET_RAM_CTRL_RAM1_CLK_ON_OVRD_EN_0 = 0x0
	// Use the state of RAM1_CLK_ON_OVRD to override the RAM1 Clock Gate Enable.
	XCVR_MISC_PACKET_RAM_CTRL_RAM1_CLK_ON_OVRD_EN_1 = 0x1
	// Position of RAM1_CLK_ON_OVRD field.
	XCVR_MISC_PACKET_RAM_CTRL_RAM1_CLK_ON_OVRD_Pos = 0xd
	// Bit mask of RAM1_CLK_ON_OVRD field.
	XCVR_MISC_PACKET_RAM_CTRL_RAM1_CLK_ON_OVRD_Msk = 0x2000
	// Bit RAM1_CLK_ON_OVRD.
	XCVR_MISC_PACKET_RAM_CTRL_RAM1_CLK_ON_OVRD = 0x2000
	// Position of RAM0_CE_ON_OVRD_EN field.
	XCVR_MISC_PACKET_RAM_CTRL_RAM0_CE_ON_OVRD_EN_Pos = 0xe
	// Bit mask of RAM0_CE_ON_OVRD_EN field.
	XCVR_MISC_PACKET_RAM_CTRL_RAM0_CE_ON_OVRD_EN_Msk = 0x4000
	// Bit RAM0_CE_ON_OVRD_EN.
	XCVR_MISC_PACKET_RAM_CTRL_RAM0_CE_ON_OVRD_EN = 0x4000
	// Normal operation.
	XCVR_MISC_PACKET_RAM_CTRL_RAM0_CE_ON_OVRD_EN_0 = 0x0
	// Use the state of RAM0_CE_ON_OVRD to override the RAM0 CE.
	XCVR_MISC_PACKET_RAM_CTRL_RAM0_CE_ON_OVRD_EN_1 = 0x1
	// Position of RAM0_CE_ON_OVRD field.
	XCVR_MISC_PACKET_RAM_CTRL_RAM0_CE_ON_OVRD_Pos = 0xf
	// Bit mask of RAM0_CE_ON_OVRD field.
	XCVR_MISC_PACKET_RAM_CTRL_RAM0_CE_ON_OVRD_Msk = 0x8000
	// Bit RAM0_CE_ON_OVRD.
	XCVR_MISC_PACKET_RAM_CTRL_RAM0_CE_ON_OVRD = 0x8000
	// Position of RAM1_CE_ON_OVRD_EN field.
	XCVR_MISC_PACKET_RAM_CTRL_RAM1_CE_ON_OVRD_EN_Pos = 0x10
	// Bit mask of RAM1_CE_ON_OVRD_EN field.
	XCVR_MISC_PACKET_RAM_CTRL_RAM1_CE_ON_OVRD_EN_Msk = 0x10000
	// Bit RAM1_CE_ON_OVRD_EN.
	XCVR_MISC_PACKET_RAM_CTRL_RAM1_CE_ON_OVRD_EN = 0x10000
	// Normal operation.
	XCVR_MISC_PACKET_RAM_CTRL_RAM1_CE_ON_OVRD_EN_0 = 0x0
	// Use the state of RAM1_CE_ON_OVRD to override the RAM1 CE.
	XCVR_MISC_PACKET_RAM_CTRL_RAM1_CE_ON_OVRD_EN_1 = 0x1
	// Position of RAM1_CE_ON_OVRD field.
	XCVR_MISC_PACKET_RAM_CTRL_RAM1_CE_ON_OVRD_Pos = 0x11
	// Bit mask of RAM1_CE_ON_OVRD field.
	XCVR_MISC_PACKET_RAM_CTRL_RAM1_CE_ON_OVRD_Msk = 0x20000
	// Bit RAM1_CE_ON_OVRD.
	XCVR_MISC_PACKET_RAM_CTRL_RAM1_CE_ON_OVRD = 0x20000

	// FAD_CTRL: FAD CONTROL
	// Position of FAD_EN field.
	XCVR_MISC_FAD_CTRL_FAD_EN_Pos = 0x0
	// Bit mask of FAD_EN field.
	XCVR_MISC_FAD_CTRL_FAD_EN_Msk = 0x1
	// Bit FAD_EN.
	XCVR_MISC_FAD_CTRL_FAD_EN = 0x1
	// Fast Antenna Diversity disabled
	XCVR_MISC_FAD_CTRL_FAD_EN_0 = 0x0
	// Fast Antenna Diversity enabled for 802.15.4
	XCVR_MISC_FAD_CTRL_FAD_EN_1 = 0x1
	// Position of ANTX field.
	XCVR_MISC_FAD_CTRL_ANTX_Pos = 0x1
	// Bit mask of ANTX field.
	XCVR_MISC_FAD_CTRL_ANTX_Msk = 0x2
	// Bit ANTX.
	XCVR_MISC_FAD_CTRL_ANTX = 0x2
	// Position of ANTX_EN field.
	XCVR_MISC_FAD_CTRL_ANTX_EN_Pos = 0x4
	// Bit mask of ANTX_EN field.
	XCVR_MISC_FAD_CTRL_ANTX_EN_Msk = 0x30
	// all disabled (held low)
	XCVR_MISC_FAD_CTRL_ANTX_EN_00 = 0x0
	// only RX/TX_SWITCH enabled
	XCVR_MISC_FAD_CTRL_ANTX_EN_01 = 0x1
	// only ANT_A/B enabled
	XCVR_MISC_FAD_CTRL_ANTX_EN_10 = 0x2
	// all enabled
	XCVR_MISC_FAD_CTRL_ANTX_EN_11 = 0x3
	// Position of ANTX_HZ field.
	XCVR_MISC_FAD_CTRL_ANTX_HZ_Pos = 0x6
	// Bit mask of ANTX_HZ field.
	XCVR_MISC_FAD_CTRL_ANTX_HZ_Msk = 0x40
	// Bit ANTX_HZ.
	XCVR_MISC_FAD_CTRL_ANTX_HZ = 0x40
	// ANT_A, ANT_B, RX_SWITCH and TX_SWITCH are actively driven outputs.
	XCVR_MISC_FAD_CTRL_ANTX_HZ_0 = 0x0
	// Antenna controls high impedance- Set ANT_A, ANT_B, RX_SWITCH and TX_SWITCH in high impedance.
	XCVR_MISC_FAD_CTRL_ANTX_HZ_1 = 0x1
	// Position of ANTX_CTRLMODE field.
	XCVR_MISC_FAD_CTRL_ANTX_CTRLMODE_Pos = 0x7
	// Bit mask of ANTX_CTRLMODE field.
	XCVR_MISC_FAD_CTRL_ANTX_CTRLMODE_Msk = 0x80
	// Bit ANTX_CTRLMODE.
	XCVR_MISC_FAD_CTRL_ANTX_CTRLMODE = 0x80
	// Position of ANTX_POL field.
	XCVR_MISC_FAD_CTRL_ANTX_POL_Pos = 0x8
	// Bit mask of ANTX_POL field.
	XCVR_MISC_FAD_CTRL_ANTX_POL_Msk = 0xf00
	// Position of FAD_NOT_GPIO field.
	XCVR_MISC_FAD_CTRL_FAD_NOT_GPIO_Pos = 0xc
	// Bit mask of FAD_NOT_GPIO field.
	XCVR_MISC_FAD_CTRL_FAD_NOT_GPIO_Msk = 0xf000

	// LPPS_CTRL: LOW POWER PREAMBLE SEARCH CONTROL
	// Position of LPPS_ENABLE field.
	XCVR_MISC_LPPS_CTRL_LPPS_ENABLE_Pos = 0x0
	// Bit mask of LPPS_ENABLE field.
	XCVR_MISC_LPPS_CTRL_LPPS_ENABLE_Msk = 0x1
	// Bit LPPS_ENABLE.
	XCVR_MISC_LPPS_CTRL_LPPS_ENABLE = 0x1
	// Position of LPPS_TZA_ALLOW field.
	XCVR_MISC_LPPS_CTRL_LPPS_TZA_ALLOW_Pos = 0x1
	// Bit mask of LPPS_TZA_ALLOW field.
	XCVR_MISC_LPPS_CTRL_LPPS_TZA_ALLOW_Msk = 0x2
	// Bit LPPS_TZA_ALLOW.
	XCVR_MISC_LPPS_CTRL_LPPS_TZA_ALLOW = 0x2
	// Position of LPPS_BBA_ALLOW field.
	XCVR_MISC_LPPS_CTRL_LPPS_BBA_ALLOW_Pos = 0x2
	// Bit mask of LPPS_BBA_ALLOW field.
	XCVR_MISC_LPPS_CTRL_LPPS_BBA_ALLOW_Msk = 0x4
	// Bit LPPS_BBA_ALLOW.
	XCVR_MISC_LPPS_CTRL_LPPS_BBA_ALLOW = 0x4
	// Position of LPPS_ADC_ALLOW field.
	XCVR_MISC_LPPS_CTRL_LPPS_ADC_ALLOW_Pos = 0x3
	// Bit mask of LPPS_ADC_ALLOW field.
	XCVR_MISC_LPPS_CTRL_LPPS_ADC_ALLOW_Msk = 0x8
	// Bit LPPS_ADC_ALLOW.
	XCVR_MISC_LPPS_CTRL_LPPS_ADC_ALLOW = 0x8
	// Position of LPPS_DCOC_ALLOW field.
	XCVR_MISC_LPPS_CTRL_LPPS_DCOC_ALLOW_Pos = 0x4
	// Bit mask of LPPS_DCOC_ALLOW field.
	XCVR_MISC_LPPS_CTRL_LPPS_DCOC_ALLOW_Msk = 0x10
	// Bit LPPS_DCOC_ALLOW.
	XCVR_MISC_LPPS_CTRL_LPPS_DCOC_ALLOW = 0x10
	// Position of LPPS_PDET_ALLOW field.
	XCVR_MISC_LPPS_CTRL_LPPS_PDET_ALLOW_Pos = 0x5
	// Bit mask of LPPS_PDET_ALLOW field.
	XCVR_MISC_LPPS_CTRL_LPPS_PDET_ALLOW_Msk = 0x20
	// Bit LPPS_PDET_ALLOW.
	XCVR_MISC_LPPS_CTRL_LPPS_PDET_ALLOW = 0x20
	// Position of LPPS_SY_LO_ALLOW field.
	XCVR_MISC_LPPS_CTRL_LPPS_SY_LO_ALLOW_Pos = 0x6
	// Bit mask of LPPS_SY_LO_ALLOW field.
	XCVR_MISC_LPPS_CTRL_LPPS_SY_LO_ALLOW_Msk = 0x40
	// Bit LPPS_SY_LO_ALLOW.
	XCVR_MISC_LPPS_CTRL_LPPS_SY_LO_ALLOW = 0x40
	// Position of LPPS_SY_LO_BUF_ALLOW field.
	XCVR_MISC_LPPS_CTRL_LPPS_SY_LO_BUF_ALLOW_Pos = 0x7
	// Bit mask of LPPS_SY_LO_BUF_ALLOW field.
	XCVR_MISC_LPPS_CTRL_LPPS_SY_LO_BUF_ALLOW_Msk = 0x80
	// Bit LPPS_SY_LO_BUF_ALLOW.
	XCVR_MISC_LPPS_CTRL_LPPS_SY_LO_BUF_ALLOW = 0x80
	// Position of LPPS_RX_DIG_ALLOW field.
	XCVR_MISC_LPPS_CTRL_LPPS_RX_DIG_ALLOW_Pos = 0x8
	// Bit mask of LPPS_RX_DIG_ALLOW field.
	XCVR_MISC_LPPS_CTRL_LPPS_RX_DIG_ALLOW_Msk = 0x100
	// Bit LPPS_RX_DIG_ALLOW.
	XCVR_MISC_LPPS_CTRL_LPPS_RX_DIG_ALLOW = 0x100
	// Position of LPPS_DCOC_DIG_ALLOW field.
	XCVR_MISC_LPPS_CTRL_LPPS_DCOC_DIG_ALLOW_Pos = 0x9
	// Bit mask of LPPS_DCOC_DIG_ALLOW field.
	XCVR_MISC_LPPS_CTRL_LPPS_DCOC_DIG_ALLOW_Msk = 0x200
	// Bit LPPS_DCOC_DIG_ALLOW.
	XCVR_MISC_LPPS_CTRL_LPPS_DCOC_DIG_ALLOW = 0x200
	// Position of LPPS_START_RX field.
	XCVR_MISC_LPPS_CTRL_LPPS_START_RX_Pos = 0x10
	// Bit mask of LPPS_START_RX field.
	XCVR_MISC_LPPS_CTRL_LPPS_START_RX_Msk = 0xff0000
	// Position of LPPS_DEST_RX field.
	XCVR_MISC_LPPS_CTRL_LPPS_DEST_RX_Pos = 0x18
	// Bit mask of LPPS_DEST_RX field.
	XCVR_MISC_LPPS_CTRL_LPPS_DEST_RX_Msk = 0xff000000

	// RF_NOT_ALLOWED_CTRL: WIFI COEXISTENCE CONTROL
	// Position of RF_NOT_ALLOWED_NO_TX field.
	XCVR_MISC_RF_NOT_ALLOWED_CTRL_RF_NOT_ALLOWED_NO_TX_Pos = 0x0
	// Bit mask of RF_NOT_ALLOWED_NO_TX field.
	XCVR_MISC_RF_NOT_ALLOWED_CTRL_RF_NOT_ALLOWED_NO_TX_Msk = 0x1
	// Bit RF_NOT_ALLOWED_NO_TX.
	XCVR_MISC_RF_NOT_ALLOWED_CTRL_RF_NOT_ALLOWED_NO_TX = 0x1
	// Assertion on RF_NOT_ALLOWED has no effect on TX
	XCVR_MISC_RF_NOT_ALLOWED_CTRL_RF_NOT_ALLOWED_NO_TX_0 = 0x0
	// Assertion on RF_NOT_ALLOWED can abort TX
	XCVR_MISC_RF_NOT_ALLOWED_CTRL_RF_NOT_ALLOWED_NO_TX_1 = 0x1
	// Position of RF_NOT_ALLOWED_NO_RX field.
	XCVR_MISC_RF_NOT_ALLOWED_CTRL_RF_NOT_ALLOWED_NO_RX_Pos = 0x1
	// Bit mask of RF_NOT_ALLOWED_NO_RX field.
	XCVR_MISC_RF_NOT_ALLOWED_CTRL_RF_NOT_ALLOWED_NO_RX_Msk = 0x2
	// Bit RF_NOT_ALLOWED_NO_RX.
	XCVR_MISC_RF_NOT_ALLOWED_CTRL_RF_NOT_ALLOWED_NO_RX = 0x2
	// Assertion on RF_NOT_ALLOWED has no effect on RX
	XCVR_MISC_RF_NOT_ALLOWED_CTRL_RF_NOT_ALLOWED_NO_RX_0 = 0x0
	// Assertion on RF_NOT_ALLOWED can abort RX
	XCVR_MISC_RF_NOT_ALLOWED_CTRL_RF_NOT_ALLOWED_NO_RX_1 = 0x1
	// Position of RF_NOT_ALLOWED_ASSERTED field.
	XCVR_MISC_RF_NOT_ALLOWED_CTRL_RF_NOT_ALLOWED_ASSERTED_Pos = 0x2
	// Bit mask of RF_NOT_ALLOWED_ASSERTED field.
	XCVR_MISC_RF_NOT_ALLOWED_CTRL_RF_NOT_ALLOWED_ASSERTED_Msk = 0x4
	// Bit RF_NOT_ALLOWED_ASSERTED.
	XCVR_MISC_RF_NOT_ALLOWED_CTRL_RF_NOT_ALLOWED_ASSERTED = 0x4
	// Assertion on RF_NOT_ALLOWED has not occurred
	XCVR_MISC_RF_NOT_ALLOWED_CTRL_RF_NOT_ALLOWED_ASSERTED_0 = 0x0
	// Assertion on RF_NOT_ALLOWED has occurred since the last time this bit was cleared
	XCVR_MISC_RF_NOT_ALLOWED_CTRL_RF_NOT_ALLOWED_ASSERTED_1 = 0x1
	// Position of RF_NOT_ALLOWED_TX_ABORT field.
	XCVR_MISC_RF_NOT_ALLOWED_CTRL_RF_NOT_ALLOWED_TX_ABORT_Pos = 0x3
	// Bit mask of RF_NOT_ALLOWED_TX_ABORT field.
	XCVR_MISC_RF_NOT_ALLOWED_CTRL_RF_NOT_ALLOWED_TX_ABORT_Msk = 0x8
	// Bit RF_NOT_ALLOWED_TX_ABORT.
	XCVR_MISC_RF_NOT_ALLOWED_CTRL_RF_NOT_ALLOWED_TX_ABORT = 0x8
	// A TX abort due to assertion on RF_NOT_ALLOWED has not occurred
	XCVR_MISC_RF_NOT_ALLOWED_CTRL_RF_NOT_ALLOWED_TX_ABORT_0 = 0x0
	// A TX abort due to assertion on RF_NOT_ALLOWED has occurred since the last time this bit was cleared
	XCVR_MISC_RF_NOT_ALLOWED_CTRL_RF_NOT_ALLOWED_TX_ABORT_1 = 0x1
	// Position of RF_NOT_ALLOWED_RX_ABORT field.
	XCVR_MISC_RF_NOT_ALLOWED_CTRL_RF_NOT_ALLOWED_RX_ABORT_Pos = 0x4
	// Bit mask of RF_NOT_ALLOWED_RX_ABORT field.
	XCVR_MISC_RF_NOT_ALLOWED_CTRL_RF_NOT_ALLOWED_RX_ABORT_Msk = 0x10
	// Bit RF_NOT_ALLOWED_RX_ABORT.
	XCVR_MISC_RF_NOT_ALLOWED_CTRL_RF_NOT_ALLOWED_RX_ABORT = 0x10
	// A RX abort due to assertion on RF_NOT_ALLOWED has not occurred
	XCVR_MISC_RF_NOT_ALLOWED_CTRL_RF_NOT_ALLOWED_RX_ABORT_0 = 0x0
	// A RX abort due to assertion on RF_NOT_ALLOWED has occurred since the last time this bit was cleared
	XCVR_MISC_RF_NOT_ALLOWED_CTRL_RF_NOT_ALLOWED_RX_ABORT_1 = 0x1
	// Position of RF_NOT_ALLOWED field.
	XCVR_MISC_RF_NOT_ALLOWED_CTRL_RF_NOT_ALLOWED_Pos = 0x5
	// Bit mask of RF_NOT_ALLOWED field.
	XCVR_MISC_RF_NOT_ALLOWED_CTRL_RF_NOT_ALLOWED_Msk = 0x20
	// Bit RF_NOT_ALLOWED.
	XCVR_MISC_RF_NOT_ALLOWED_CTRL_RF_NOT_ALLOWED = 0x20

	// CRCW_CFG: CRC/WHITENER CONTROL
	// Position of CRCW_EN field.
	XCVR_MISC_CRCW_CFG_CRCW_EN_Pos = 0x0
	// Bit mask of CRCW_EN field.
	XCVR_MISC_CRCW_CFG_CRCW_EN_Msk = 0x1
	// Bit CRCW_EN.
	XCVR_MISC_CRCW_CFG_CRCW_EN = 0x1
	// Position of CRC_ZERO field.
	XCVR_MISC_CRCW_CFG_CRC_ZERO_Pos = 0x1
	// Bit mask of CRC_ZERO field.
	XCVR_MISC_CRCW_CFG_CRC_ZERO_Msk = 0x2
	// Bit CRC_ZERO.
	XCVR_MISC_CRCW_CFG_CRC_ZERO = 0x2
	// Position of CRC_EARLY_FAIL field.
	XCVR_MISC_CRCW_CFG_CRC_EARLY_FAIL_Pos = 0x2
	// Bit mask of CRC_EARLY_FAIL field.
	XCVR_MISC_CRCW_CFG_CRC_EARLY_FAIL_Msk = 0x4
	// Bit CRC_EARLY_FAIL.
	XCVR_MISC_CRCW_CFG_CRC_EARLY_FAIL = 0x4
	// Position of CRC_RES_OUT_VLD field.
	XCVR_MISC_CRCW_CFG_CRC_RES_OUT_VLD_Pos = 0x3
	// Bit mask of CRC_RES_OUT_VLD field.
	XCVR_MISC_CRCW_CFG_CRC_RES_OUT_VLD_Msk = 0x8
	// Bit CRC_RES_OUT_VLD.
	XCVR_MISC_CRCW_CFG_CRC_RES_OUT_VLD = 0x8
	// Position of CRC_EC_OFFSET field.
	XCVR_MISC_CRCW_CFG_CRC_EC_OFFSET_Pos = 0x10
	// Bit mask of CRC_EC_OFFSET field.
	XCVR_MISC_CRCW_CFG_CRC_EC_OFFSET_Msk = 0x7ff0000
	// Position of CRC_EC_DONE field.
	XCVR_MISC_CRCW_CFG_CRC_EC_DONE_Pos = 0x1c
	// Bit mask of CRC_EC_DONE field.
	XCVR_MISC_CRCW_CFG_CRC_EC_DONE_Msk = 0x10000000
	// Bit CRC_EC_DONE.
	XCVR_MISC_CRCW_CFG_CRC_EC_DONE = 0x10000000
	// Position of CRC_EC_FAIL field.
	XCVR_MISC_CRCW_CFG_CRC_EC_FAIL_Pos = 0x1d
	// Bit mask of CRC_EC_FAIL field.
	XCVR_MISC_CRCW_CFG_CRC_EC_FAIL_Msk = 0x20000000
	// Bit CRC_EC_FAIL.
	XCVR_MISC_CRCW_CFG_CRC_EC_FAIL = 0x20000000

	// CRC_EC_MASK: CRC ERROR CORRECTION MASK
	// Position of CRC_EC_MASK field.
	XCVR_MISC_CRC_EC_MASK_CRC_EC_MASK_Pos = 0x0
	// Bit mask of CRC_EC_MASK field.
	XCVR_MISC_CRC_EC_MASK_CRC_EC_MASK_Msk = 0xffffffff

	// CRC_RES_OUT: CRC RESULT
	// Position of CRC_RES_OUT field.
	XCVR_MISC_CRC_RES_OUT_CRC_RES_OUT_Pos = 0x0
	// Bit mask of CRC_RES_OUT field.
	XCVR_MISC_CRC_RES_OUT_CRC_RES_OUT_Msk = 0xffffffff
)

// Bitfields for XCVR_TSM: XCVR_TSM
const (
	// CTRL: TRANSCEIVER SEQUENCE MANAGER CONTROL
	// Position of FORCE_TX_EN field.
	XCVR_TSM_CTRL_FORCE_TX_EN_Pos = 0x2
	// Bit mask of FORCE_TX_EN field.
	XCVR_TSM_CTRL_FORCE_TX_EN_Msk = 0x4
	// Bit FORCE_TX_EN.
	XCVR_TSM_CTRL_FORCE_TX_EN = 0x4
	// TSM Idle
	XCVR_TSM_CTRL_FORCE_TX_EN_0 = 0x0
	// TSM executes a TX sequence
	XCVR_TSM_CTRL_FORCE_TX_EN_1 = 0x1
	// Position of FORCE_RX_EN field.
	XCVR_TSM_CTRL_FORCE_RX_EN_Pos = 0x3
	// Bit mask of FORCE_RX_EN field.
	XCVR_TSM_CTRL_FORCE_RX_EN_Msk = 0x8
	// Bit FORCE_RX_EN.
	XCVR_TSM_CTRL_FORCE_RX_EN = 0x8
	// TSM Idle
	XCVR_TSM_CTRL_FORCE_RX_EN_0 = 0x0
	// TSM executes a RX sequence
	XCVR_TSM_CTRL_FORCE_RX_EN_1 = 0x1
	// Position of PA_RAMP_SEL field.
	XCVR_TSM_CTRL_PA_RAMP_SEL_Pos = 0x4
	// Bit mask of PA_RAMP_SEL field.
	XCVR_TSM_CTRL_PA_RAMP_SEL_Msk = 0x30
	// Position of DATA_PADDING_EN field.
	XCVR_TSM_CTRL_DATA_PADDING_EN_Pos = 0x6
	// Bit mask of DATA_PADDING_EN field.
	XCVR_TSM_CTRL_DATA_PADDING_EN_Msk = 0xc0
	// Disable TX Data Padding
	XCVR_TSM_CTRL_DATA_PADDING_EN_00 = 0x0
	// Enable TX Data Padding
	XCVR_TSM_CTRL_DATA_PADDING_EN_01 = 0x1
	// Position of TSM_IRQ0_EN field.
	XCVR_TSM_CTRL_TSM_IRQ0_EN_Pos = 0x8
	// Bit mask of TSM_IRQ0_EN field.
	XCVR_TSM_CTRL_TSM_IRQ0_EN_Msk = 0x100
	// Bit TSM_IRQ0_EN.
	XCVR_TSM_CTRL_TSM_IRQ0_EN = 0x100
	// TSM_IRQ0 is disabled
	XCVR_TSM_CTRL_TSM_IRQ0_EN_0 = 0x0
	// TSM_IRQ0 is enabled
	XCVR_TSM_CTRL_TSM_IRQ0_EN_1 = 0x1
	// Position of TSM_IRQ1_EN field.
	XCVR_TSM_CTRL_TSM_IRQ1_EN_Pos = 0x9
	// Bit mask of TSM_IRQ1_EN field.
	XCVR_TSM_CTRL_TSM_IRQ1_EN_Msk = 0x200
	// Bit TSM_IRQ1_EN.
	XCVR_TSM_CTRL_TSM_IRQ1_EN = 0x200
	// TSM_IRQ1 is disabled
	XCVR_TSM_CTRL_TSM_IRQ1_EN_0 = 0x0
	// TSM_IRQ1 is enabled
	XCVR_TSM_CTRL_TSM_IRQ1_EN_1 = 0x1
	// Position of RAMP_DN_DELAY field.
	XCVR_TSM_CTRL_RAMP_DN_DELAY_Pos = 0xc
	// Bit mask of RAMP_DN_DELAY field.
	XCVR_TSM_CTRL_RAMP_DN_DELAY_Msk = 0xf000
	// Position of TX_ABORT_DIS field.
	XCVR_TSM_CTRL_TX_ABORT_DIS_Pos = 0x10
	// Bit mask of TX_ABORT_DIS field.
	XCVR_TSM_CTRL_TX_ABORT_DIS_Msk = 0x10000
	// Bit TX_ABORT_DIS.
	XCVR_TSM_CTRL_TX_ABORT_DIS = 0x10000
	// Position of RX_ABORT_DIS field.
	XCVR_TSM_CTRL_RX_ABORT_DIS_Pos = 0x11
	// Bit mask of RX_ABORT_DIS field.
	XCVR_TSM_CTRL_RX_ABORT_DIS_Msk = 0x20000
	// Bit RX_ABORT_DIS.
	XCVR_TSM_CTRL_RX_ABORT_DIS = 0x20000
	// Position of ABORT_ON_CTUNE field.
	XCVR_TSM_CTRL_ABORT_ON_CTUNE_Pos = 0x12
	// Bit mask of ABORT_ON_CTUNE field.
	XCVR_TSM_CTRL_ABORT_ON_CTUNE_Msk = 0x40000
	// Bit ABORT_ON_CTUNE.
	XCVR_TSM_CTRL_ABORT_ON_CTUNE = 0x40000
	// don't allow TSM abort on Coarse Tune Unlock Detect
	XCVR_TSM_CTRL_ABORT_ON_CTUNE_0 = 0x0
	// allow TSM abort on Coarse Tune Unlock Detect
	XCVR_TSM_CTRL_ABORT_ON_CTUNE_1 = 0x1
	// Position of ABORT_ON_CYCLE_SLIP field.
	XCVR_TSM_CTRL_ABORT_ON_CYCLE_SLIP_Pos = 0x13
	// Bit mask of ABORT_ON_CYCLE_SLIP field.
	XCVR_TSM_CTRL_ABORT_ON_CYCLE_SLIP_Msk = 0x80000
	// Bit ABORT_ON_CYCLE_SLIP.
	XCVR_TSM_CTRL_ABORT_ON_CYCLE_SLIP = 0x80000
	// don't allow TSM abort on Cycle Slip Unlock Detect
	XCVR_TSM_CTRL_ABORT_ON_CYCLE_SLIP_0 = 0x0
	// allow TSM abort on Cycle Slip Unlock Detect
	XCVR_TSM_CTRL_ABORT_ON_CYCLE_SLIP_1 = 0x1
	// Position of ABORT_ON_FREQ_TARG field.
	XCVR_TSM_CTRL_ABORT_ON_FREQ_TARG_Pos = 0x14
	// Bit mask of ABORT_ON_FREQ_TARG field.
	XCVR_TSM_CTRL_ABORT_ON_FREQ_TARG_Msk = 0x100000
	// Bit ABORT_ON_FREQ_TARG.
	XCVR_TSM_CTRL_ABORT_ON_FREQ_TARG = 0x100000
	// don't allow TSM abort on Frequency Target Unlock Detect
	XCVR_TSM_CTRL_ABORT_ON_FREQ_TARG_0 = 0x0
	// allow TSM abort on Frequency Target Unlock Detect
	XCVR_TSM_CTRL_ABORT_ON_FREQ_TARG_1 = 0x1
	// Position of BKPT field.
	XCVR_TSM_CTRL_BKPT_Pos = 0x18
	// Bit mask of BKPT field.
	XCVR_TSM_CTRL_BKPT_Msk = 0xff000000

	// END_OF_SEQ: TSM END OF SEQUENCE
	// Position of END_OF_TX_WU field.
	XCVR_TSM_END_OF_SEQ_END_OF_TX_WU_Pos = 0x0
	// Bit mask of END_OF_TX_WU field.
	XCVR_TSM_END_OF_SEQ_END_OF_TX_WU_Msk = 0xff
	// Position of END_OF_TX_WD field.
	XCVR_TSM_END_OF_SEQ_END_OF_TX_WD_Pos = 0x8
	// Bit mask of END_OF_TX_WD field.
	XCVR_TSM_END_OF_SEQ_END_OF_TX_WD_Msk = 0xff00
	// Position of END_OF_RX_WU field.
	XCVR_TSM_END_OF_SEQ_END_OF_RX_WU_Pos = 0x10
	// Bit mask of END_OF_RX_WU field.
	XCVR_TSM_END_OF_SEQ_END_OF_RX_WU_Msk = 0xff0000
	// Position of END_OF_RX_WD field.
	XCVR_TSM_END_OF_SEQ_END_OF_RX_WD_Pos = 0x18
	// Bit mask of END_OF_RX_WD field.
	XCVR_TSM_END_OF_SEQ_END_OF_RX_WD_Msk = 0xff000000

	// OVRD0: TSM OVERRIDE REGISTER 0
	// Position of BB_LDO_HF_EN_OVRD_EN field.
	XCVR_TSM_OVRD0_BB_LDO_HF_EN_OVRD_EN_Pos = 0x0
	// Bit mask of BB_LDO_HF_EN_OVRD_EN field.
	XCVR_TSM_OVRD0_BB_LDO_HF_EN_OVRD_EN_Msk = 0x1
	// Bit BB_LDO_HF_EN_OVRD_EN.
	XCVR_TSM_OVRD0_BB_LDO_HF_EN_OVRD_EN = 0x1
	// Normal operation.
	XCVR_TSM_OVRD0_BB_LDO_HF_EN_OVRD_EN_0 = 0x0
	// Use the state of BB_LDO_HF_EN_OVRD to override the signal "bb_ldo_hf_en".
	XCVR_TSM_OVRD0_BB_LDO_HF_EN_OVRD_EN_1 = 0x1
	// Position of BB_LDO_HF_EN_OVRD field.
	XCVR_TSM_OVRD0_BB_LDO_HF_EN_OVRD_Pos = 0x1
	// Bit mask of BB_LDO_HF_EN_OVRD field.
	XCVR_TSM_OVRD0_BB_LDO_HF_EN_OVRD_Msk = 0x2
	// Bit BB_LDO_HF_EN_OVRD.
	XCVR_TSM_OVRD0_BB_LDO_HF_EN_OVRD = 0x2
	// Position of BB_LDO_ADCDAC_EN_OVRD_EN field.
	XCVR_TSM_OVRD0_BB_LDO_ADCDAC_EN_OVRD_EN_Pos = 0x2
	// Bit mask of BB_LDO_ADCDAC_EN_OVRD_EN field.
	XCVR_TSM_OVRD0_BB_LDO_ADCDAC_EN_OVRD_EN_Msk = 0x4
	// Bit BB_LDO_ADCDAC_EN_OVRD_EN.
	XCVR_TSM_OVRD0_BB_LDO_ADCDAC_EN_OVRD_EN = 0x4
	// Normal operation.
	XCVR_TSM_OVRD0_BB_LDO_ADCDAC_EN_OVRD_EN_0 = 0x0
	// Use the state of BB_LDO_ADCDAC_EN_OVRD to override the signal "bb_ldo_adcdac_en".
	XCVR_TSM_OVRD0_BB_LDO_ADCDAC_EN_OVRD_EN_1 = 0x1
	// Position of BB_LDO_ADCDAC_EN_OVRD field.
	XCVR_TSM_OVRD0_BB_LDO_ADCDAC_EN_OVRD_Pos = 0x3
	// Bit mask of BB_LDO_ADCDAC_EN_OVRD field.
	XCVR_TSM_OVRD0_BB_LDO_ADCDAC_EN_OVRD_Msk = 0x8
	// Bit BB_LDO_ADCDAC_EN_OVRD.
	XCVR_TSM_OVRD0_BB_LDO_ADCDAC_EN_OVRD = 0x8
	// Position of BB_LDO_BBA_EN_OVRD_EN field.
	XCVR_TSM_OVRD0_BB_LDO_BBA_EN_OVRD_EN_Pos = 0x4
	// Bit mask of BB_LDO_BBA_EN_OVRD_EN field.
	XCVR_TSM_OVRD0_BB_LDO_BBA_EN_OVRD_EN_Msk = 0x10
	// Bit BB_LDO_BBA_EN_OVRD_EN.
	XCVR_TSM_OVRD0_BB_LDO_BBA_EN_OVRD_EN = 0x10
	// Normal operation.
	XCVR_TSM_OVRD0_BB_LDO_BBA_EN_OVRD_EN_0 = 0x0
	// Use the state of BB_LDO_BBA_EN_OVRD to override the signal "bb_ldo_bba_en".
	XCVR_TSM_OVRD0_BB_LDO_BBA_EN_OVRD_EN_1 = 0x1
	// Position of BB_LDO_BBA_EN_OVRD field.
	XCVR_TSM_OVRD0_BB_LDO_BBA_EN_OVRD_Pos = 0x5
	// Bit mask of BB_LDO_BBA_EN_OVRD field.
	XCVR_TSM_OVRD0_BB_LDO_BBA_EN_OVRD_Msk = 0x20
	// Bit BB_LDO_BBA_EN_OVRD.
	XCVR_TSM_OVRD0_BB_LDO_BBA_EN_OVRD = 0x20
	// Position of BB_LDO_PD_EN_OVRD_EN field.
	XCVR_TSM_OVRD0_BB_LDO_PD_EN_OVRD_EN_Pos = 0x6
	// Bit mask of BB_LDO_PD_EN_OVRD_EN field.
	XCVR_TSM_OVRD0_BB_LDO_PD_EN_OVRD_EN_Msk = 0x40
	// Bit BB_LDO_PD_EN_OVRD_EN.
	XCVR_TSM_OVRD0_BB_LDO_PD_EN_OVRD_EN = 0x40
	// Normal operation.
	XCVR_TSM_OVRD0_BB_LDO_PD_EN_OVRD_EN_0 = 0x0
	// Use the state of BB_LDO_PD_EN_OVRD to override the signal "bb_ldo_pd_en".
	XCVR_TSM_OVRD0_BB_LDO_PD_EN_OVRD_EN_1 = 0x1
	// Position of BB_LDO_PD_EN_OVRD field.
	XCVR_TSM_OVRD0_BB_LDO_PD_EN_OVRD_Pos = 0x7
	// Bit mask of BB_LDO_PD_EN_OVRD field.
	XCVR_TSM_OVRD0_BB_LDO_PD_EN_OVRD_Msk = 0x80
	// Bit BB_LDO_PD_EN_OVRD.
	XCVR_TSM_OVRD0_BB_LDO_PD_EN_OVRD = 0x80
	// Position of BB_LDO_FDBK_EN_OVRD_EN field.
	XCVR_TSM_OVRD0_BB_LDO_FDBK_EN_OVRD_EN_Pos = 0x8
	// Bit mask of BB_LDO_FDBK_EN_OVRD_EN field.
	XCVR_TSM_OVRD0_BB_LDO_FDBK_EN_OVRD_EN_Msk = 0x100
	// Bit BB_LDO_FDBK_EN_OVRD_EN.
	XCVR_TSM_OVRD0_BB_LDO_FDBK_EN_OVRD_EN = 0x100
	// Normal operation.
	XCVR_TSM_OVRD0_BB_LDO_FDBK_EN_OVRD_EN_0 = 0x0
	// Use the state of BB_LDO_FDBK_EN_OVRD to override the signal "bb_ldo_fdbk_en".
	XCVR_TSM_OVRD0_BB_LDO_FDBK_EN_OVRD_EN_1 = 0x1
	// Position of BB_LDO_FDBK_EN_OVRD field.
	XCVR_TSM_OVRD0_BB_LDO_FDBK_EN_OVRD_Pos = 0x9
	// Bit mask of BB_LDO_FDBK_EN_OVRD field.
	XCVR_TSM_OVRD0_BB_LDO_FDBK_EN_OVRD_Msk = 0x200
	// Bit BB_LDO_FDBK_EN_OVRD.
	XCVR_TSM_OVRD0_BB_LDO_FDBK_EN_OVRD = 0x200
	// Position of BB_LDO_VCOLO_EN_OVRD_EN field.
	XCVR_TSM_OVRD0_BB_LDO_VCOLO_EN_OVRD_EN_Pos = 0xa
	// Bit mask of BB_LDO_VCOLO_EN_OVRD_EN field.
	XCVR_TSM_OVRD0_BB_LDO_VCOLO_EN_OVRD_EN_Msk = 0x400
	// Bit BB_LDO_VCOLO_EN_OVRD_EN.
	XCVR_TSM_OVRD0_BB_LDO_VCOLO_EN_OVRD_EN = 0x400
	// Normal operation.
	XCVR_TSM_OVRD0_BB_LDO_VCOLO_EN_OVRD_EN_0 = 0x0
	// Use the state of BB_LDO_VCOLO_EN_OVRD to override the signal "bb_ldo_vcolo_en".
	XCVR_TSM_OVRD0_BB_LDO_VCOLO_EN_OVRD_EN_1 = 0x1
	// Position of BB_LDO_VCOLO_EN_OVRD field.
	XCVR_TSM_OVRD0_BB_LDO_VCOLO_EN_OVRD_Pos = 0xb
	// Bit mask of BB_LDO_VCOLO_EN_OVRD field.
	XCVR_TSM_OVRD0_BB_LDO_VCOLO_EN_OVRD_Msk = 0x800
	// Bit BB_LDO_VCOLO_EN_OVRD.
	XCVR_TSM_OVRD0_BB_LDO_VCOLO_EN_OVRD = 0x800
	// Position of BB_LDO_VTREF_EN_OVRD_EN field.
	XCVR_TSM_OVRD0_BB_LDO_VTREF_EN_OVRD_EN_Pos = 0xc
	// Bit mask of BB_LDO_VTREF_EN_OVRD_EN field.
	XCVR_TSM_OVRD0_BB_LDO_VTREF_EN_OVRD_EN_Msk = 0x1000
	// Bit BB_LDO_VTREF_EN_OVRD_EN.
	XCVR_TSM_OVRD0_BB_LDO_VTREF_EN_OVRD_EN = 0x1000
	// Normal operation.
	XCVR_TSM_OVRD0_BB_LDO_VTREF_EN_OVRD_EN_0 = 0x0
	// Use the state of BB_LDO_VTREF_EN_OVRD to override the signal "bb_ldo_vtref_en".
	XCVR_TSM_OVRD0_BB_LDO_VTREF_EN_OVRD_EN_1 = 0x1
	// Position of BB_LDO_VTREF_EN_OVRD field.
	XCVR_TSM_OVRD0_BB_LDO_VTREF_EN_OVRD_Pos = 0xd
	// Bit mask of BB_LDO_VTREF_EN_OVRD field.
	XCVR_TSM_OVRD0_BB_LDO_VTREF_EN_OVRD_Msk = 0x2000
	// Bit BB_LDO_VTREF_EN_OVRD.
	XCVR_TSM_OVRD0_BB_LDO_VTREF_EN_OVRD = 0x2000
	// Position of BB_LDO_FDBK_BLEED_EN_OVRD_EN field.
	XCVR_TSM_OVRD0_BB_LDO_FDBK_BLEED_EN_OVRD_EN_Pos = 0xe
	// Bit mask of BB_LDO_FDBK_BLEED_EN_OVRD_EN field.
	XCVR_TSM_OVRD0_BB_LDO_FDBK_BLEED_EN_OVRD_EN_Msk = 0x4000
	// Bit BB_LDO_FDBK_BLEED_EN_OVRD_EN.
	XCVR_TSM_OVRD0_BB_LDO_FDBK_BLEED_EN_OVRD_EN = 0x4000
	// Normal operation.
	XCVR_TSM_OVRD0_BB_LDO_FDBK_BLEED_EN_OVRD_EN_0 = 0x0
	// Use the state of BB_LDO_FDBK_BLEED_EN_OVRD to override the signal "bb_ldo_fdbk_bleed_en".
	XCVR_TSM_OVRD0_BB_LDO_FDBK_BLEED_EN_OVRD_EN_1 = 0x1
	// Position of BB_LDO_FDBK_BLEED_EN_OVRD field.
	XCVR_TSM_OVRD0_BB_LDO_FDBK_BLEED_EN_OVRD_Pos = 0xf
	// Bit mask of BB_LDO_FDBK_BLEED_EN_OVRD field.
	XCVR_TSM_OVRD0_BB_LDO_FDBK_BLEED_EN_OVRD_Msk = 0x8000
	// Bit BB_LDO_FDBK_BLEED_EN_OVRD.
	XCVR_TSM_OVRD0_BB_LDO_FDBK_BLEED_EN_OVRD = 0x8000
	// Position of BB_LDO_VCOLO_BLEED_EN_OVRD_EN field.
	XCVR_TSM_OVRD0_BB_LDO_VCOLO_BLEED_EN_OVRD_EN_Pos = 0x10
	// Bit mask of BB_LDO_VCOLO_BLEED_EN_OVRD_EN field.
	XCVR_TSM_OVRD0_BB_LDO_VCOLO_BLEED_EN_OVRD_EN_Msk = 0x10000
	// Bit BB_LDO_VCOLO_BLEED_EN_OVRD_EN.
	XCVR_TSM_OVRD0_BB_LDO_VCOLO_BLEED_EN_OVRD_EN = 0x10000
	// Normal operation.
	XCVR_TSM_OVRD0_BB_LDO_VCOLO_BLEED_EN_OVRD_EN_0 = 0x0
	// Use the state of BB_LDO_VCOLO_BLEED_EN_OVRD to override the signal "bb_ldo_vcolo_bleed_en".
	XCVR_TSM_OVRD0_BB_LDO_VCOLO_BLEED_EN_OVRD_EN_1 = 0x1
	// Position of BB_LDO_VCOLO_BLEED_EN_OVRD field.
	XCVR_TSM_OVRD0_BB_LDO_VCOLO_BLEED_EN_OVRD_Pos = 0x11
	// Bit mask of BB_LDO_VCOLO_BLEED_EN_OVRD field.
	XCVR_TSM_OVRD0_BB_LDO_VCOLO_BLEED_EN_OVRD_Msk = 0x20000
	// Bit BB_LDO_VCOLO_BLEED_EN_OVRD.
	XCVR_TSM_OVRD0_BB_LDO_VCOLO_BLEED_EN_OVRD = 0x20000
	// Position of BB_LDO_VCOLO_FASTCHARGE_EN_OVRD_EN field.
	XCVR_TSM_OVRD0_BB_LDO_VCOLO_FASTCHARGE_EN_OVRD_EN_Pos = 0x12
	// Bit mask of BB_LDO_VCOLO_FASTCHARGE_EN_OVRD_EN field.
	XCVR_TSM_OVRD0_BB_LDO_VCOLO_FASTCHARGE_EN_OVRD_EN_Msk = 0x40000
	// Bit BB_LDO_VCOLO_FASTCHARGE_EN_OVRD_EN.
	XCVR_TSM_OVRD0_BB_LDO_VCOLO_FASTCHARGE_EN_OVRD_EN = 0x40000
	// Normal operation.
	XCVR_TSM_OVRD0_BB_LDO_VCOLO_FASTCHARGE_EN_OVRD_EN_0 = 0x0
	// Use the state of BB_LDO_VCOLO_FASTCHARGE_EN_OVRD to override the signal "bb_ldo_vcolo_fastcharge_en".
	XCVR_TSM_OVRD0_BB_LDO_VCOLO_FASTCHARGE_EN_OVRD_EN_1 = 0x1
	// Position of BB_LDO_VCOLO_FASTCHARGE_EN_OVRD field.
	XCVR_TSM_OVRD0_BB_LDO_VCOLO_FASTCHARGE_EN_OVRD_Pos = 0x13
	// Bit mask of BB_LDO_VCOLO_FASTCHARGE_EN_OVRD field.
	XCVR_TSM_OVRD0_BB_LDO_VCOLO_FASTCHARGE_EN_OVRD_Msk = 0x80000
	// Bit BB_LDO_VCOLO_FASTCHARGE_EN_OVRD.
	XCVR_TSM_OVRD0_BB_LDO_VCOLO_FASTCHARGE_EN_OVRD = 0x80000
	// Position of BB_XTAL_PLL_REF_CLK_EN_OVRD_EN field.
	XCVR_TSM_OVRD0_BB_XTAL_PLL_REF_CLK_EN_OVRD_EN_Pos = 0x14
	// Bit mask of BB_XTAL_PLL_REF_CLK_EN_OVRD_EN field.
	XCVR_TSM_OVRD0_BB_XTAL_PLL_REF_CLK_EN_OVRD_EN_Msk = 0x100000
	// Bit BB_XTAL_PLL_REF_CLK_EN_OVRD_EN.
	XCVR_TSM_OVRD0_BB_XTAL_PLL_REF_CLK_EN_OVRD_EN = 0x100000
	// Normal operation.
	XCVR_TSM_OVRD0_BB_XTAL_PLL_REF_CLK_EN_OVRD_EN_0 = 0x0
	// Use the state of BB_XTAL_PLL_REF_CLK_EN_OVRD to override the signal "bb_xtal_pll_ref_clk_en".
	XCVR_TSM_OVRD0_BB_XTAL_PLL_REF_CLK_EN_OVRD_EN_1 = 0x1
	// Position of BB_XTAL_PLL_REF_CLK_EN_OVRD field.
	XCVR_TSM_OVRD0_BB_XTAL_PLL_REF_CLK_EN_OVRD_Pos = 0x15
	// Bit mask of BB_XTAL_PLL_REF_CLK_EN_OVRD field.
	XCVR_TSM_OVRD0_BB_XTAL_PLL_REF_CLK_EN_OVRD_Msk = 0x200000
	// Bit BB_XTAL_PLL_REF_CLK_EN_OVRD.
	XCVR_TSM_OVRD0_BB_XTAL_PLL_REF_CLK_EN_OVRD = 0x200000
	// Position of BB_XTAL_DAC_REF_CLK_EN_OVRD_EN field.
	XCVR_TSM_OVRD0_BB_XTAL_DAC_REF_CLK_EN_OVRD_EN_Pos = 0x16
	// Bit mask of BB_XTAL_DAC_REF_CLK_EN_OVRD_EN field.
	XCVR_TSM_OVRD0_BB_XTAL_DAC_REF_CLK_EN_OVRD_EN_Msk = 0x400000
	// Bit BB_XTAL_DAC_REF_CLK_EN_OVRD_EN.
	XCVR_TSM_OVRD0_BB_XTAL_DAC_REF_CLK_EN_OVRD_EN = 0x400000
	// Normal operation.
	XCVR_TSM_OVRD0_BB_XTAL_DAC_REF_CLK_EN_OVRD_EN_0 = 0x0
	// Use the state of BB_XTAL_DAC_REF_CLK_EN_OVRD to override the signal "bb_xtal_dac_ref_clk_en".
	XCVR_TSM_OVRD0_BB_XTAL_DAC_REF_CLK_EN_OVRD_EN_1 = 0x1
	// Position of BB_XTAL_DAC_REF_CLK_EN_OVRD field.
	XCVR_TSM_OVRD0_BB_XTAL_DAC_REF_CLK_EN_OVRD_Pos = 0x17
	// Bit mask of BB_XTAL_DAC_REF_CLK_EN_OVRD field.
	XCVR_TSM_OVRD0_BB_XTAL_DAC_REF_CLK_EN_OVRD_Msk = 0x800000
	// Bit BB_XTAL_DAC_REF_CLK_EN_OVRD.
	XCVR_TSM_OVRD0_BB_XTAL_DAC_REF_CLK_EN_OVRD = 0x800000
	// Position of BB_XTAL_AUXPLL_REF_CLK_EN_OVRD_EN field.
	XCVR_TSM_OVRD0_BB_XTAL_AUXPLL_REF_CLK_EN_OVRD_EN_Pos = 0x18
	// Bit mask of BB_XTAL_AUXPLL_REF_CLK_EN_OVRD_EN field.
	XCVR_TSM_OVRD0_BB_XTAL_AUXPLL_REF_CLK_EN_OVRD_EN_Msk = 0x1000000
	// Bit BB_XTAL_AUXPLL_REF_CLK_EN_OVRD_EN.
	XCVR_TSM_OVRD0_BB_XTAL_AUXPLL_REF_CLK_EN_OVRD_EN = 0x1000000
	// Normal operation.
	XCVR_TSM_OVRD0_BB_XTAL_AUXPLL_REF_CLK_EN_OVRD_EN_0 = 0x0
	// Use the state of BB_XTAL_AUXPLL_REF_CLK_EN_OVRD to override the signal "bb_xtal_auxpll_ref_clk_en".
	XCVR_TSM_OVRD0_BB_XTAL_AUXPLL_REF_CLK_EN_OVRD_EN_1 = 0x1
	// Position of BB_XTAL_AUXPLL_REF_CLK_EN_OVRD field.
	XCVR_TSM_OVRD0_BB_XTAL_AUXPLL_REF_CLK_EN_OVRD_Pos = 0x19
	// Bit mask of BB_XTAL_AUXPLL_REF_CLK_EN_OVRD field.
	XCVR_TSM_OVRD0_BB_XTAL_AUXPLL_REF_CLK_EN_OVRD_Msk = 0x2000000
	// Bit BB_XTAL_AUXPLL_REF_CLK_EN_OVRD.
	XCVR_TSM_OVRD0_BB_XTAL_AUXPLL_REF_CLK_EN_OVRD = 0x2000000
	// Position of SY_VCO_AUTOTUNE_EN_OVRD_EN field.
	XCVR_TSM_OVRD0_SY_VCO_AUTOTUNE_EN_OVRD_EN_Pos = 0x1a
	// Bit mask of SY_VCO_AUTOTUNE_EN_OVRD_EN field.
	XCVR_TSM_OVRD0_SY_VCO_AUTOTUNE_EN_OVRD_EN_Msk = 0x4000000
	// Bit SY_VCO_AUTOTUNE_EN_OVRD_EN.
	XCVR_TSM_OVRD0_SY_VCO_AUTOTUNE_EN_OVRD_EN = 0x4000000
	// Normal operation.
	XCVR_TSM_OVRD0_SY_VCO_AUTOTUNE_EN_OVRD_EN_0 = 0x0
	// Use the state of SY_VCO_AUTOTUNE_EN_OVRD to override the signal "sy_vco_autotune_en".
	XCVR_TSM_OVRD0_SY_VCO_AUTOTUNE_EN_OVRD_EN_1 = 0x1
	// Position of SY_VCO_AUTOTUNE_EN_OVRD field.
	XCVR_TSM_OVRD0_SY_VCO_AUTOTUNE_EN_OVRD_Pos = 0x1b
	// Bit mask of SY_VCO_AUTOTUNE_EN_OVRD field.
	XCVR_TSM_OVRD0_SY_VCO_AUTOTUNE_EN_OVRD_Msk = 0x8000000
	// Bit SY_VCO_AUTOTUNE_EN_OVRD.
	XCVR_TSM_OVRD0_SY_VCO_AUTOTUNE_EN_OVRD = 0x8000000
	// Position of SY_PD_CYCLE_SLIP_LD_EN_OVRD_EN field.
	XCVR_TSM_OVRD0_SY_PD_CYCLE_SLIP_LD_EN_OVRD_EN_Pos = 0x1c
	// Bit mask of SY_PD_CYCLE_SLIP_LD_EN_OVRD_EN field.
	XCVR_TSM_OVRD0_SY_PD_CYCLE_SLIP_LD_EN_OVRD_EN_Msk = 0x10000000
	// Bit SY_PD_CYCLE_SLIP_LD_EN_OVRD_EN.
	XCVR_TSM_OVRD0_SY_PD_CYCLE_SLIP_LD_EN_OVRD_EN = 0x10000000
	// Normal operation.
	XCVR_TSM_OVRD0_SY_PD_CYCLE_SLIP_LD_EN_OVRD_EN_0 = 0x0
	// Use the state of SY_PD_CYCLE_SLIP_LD_EN_OVRD to override the signal "sy_pd_cycle_slip_ld_en".
	XCVR_TSM_OVRD0_SY_PD_CYCLE_SLIP_LD_EN_OVRD_EN_1 = 0x1
	// Position of SY_PD_CYCLE_SLIP_LD_EN_OVRD field.
	XCVR_TSM_OVRD0_SY_PD_CYCLE_SLIP_LD_EN_OVRD_Pos = 0x1d
	// Bit mask of SY_PD_CYCLE_SLIP_LD_EN_OVRD field.
	XCVR_TSM_OVRD0_SY_PD_CYCLE_SLIP_LD_EN_OVRD_Msk = 0x20000000
	// Bit SY_PD_CYCLE_SLIP_LD_EN_OVRD.
	XCVR_TSM_OVRD0_SY_PD_CYCLE_SLIP_LD_EN_OVRD = 0x20000000
	// Position of SY_VCO_EN_OVRD_EN field.
	XCVR_TSM_OVRD0_SY_VCO_EN_OVRD_EN_Pos = 0x1e
	// Bit mask of SY_VCO_EN_OVRD_EN field.
	XCVR_TSM_OVRD0_SY_VCO_EN_OVRD_EN_Msk = 0x40000000
	// Bit SY_VCO_EN_OVRD_EN.
	XCVR_TSM_OVRD0_SY_VCO_EN_OVRD_EN = 0x40000000
	// Normal operation.
	XCVR_TSM_OVRD0_SY_VCO_EN_OVRD_EN_0 = 0x0
	// Use the state of SY_VCO_EN_OVRD to override the signal "sy_vco_en".
	XCVR_TSM_OVRD0_SY_VCO_EN_OVRD_EN_1 = 0x1
	// Position of SY_VCO_EN_OVRD field.
	XCVR_TSM_OVRD0_SY_VCO_EN_OVRD_Pos = 0x1f
	// Bit mask of SY_VCO_EN_OVRD field.
	XCVR_TSM_OVRD0_SY_VCO_EN_OVRD_Msk = 0x80000000
	// Bit SY_VCO_EN_OVRD.
	XCVR_TSM_OVRD0_SY_VCO_EN_OVRD = 0x80000000

	// OVRD1: TSM OVERRIDE REGISTER 1
	// Position of SY_LO_RX_BUF_EN_OVRD_EN field.
	XCVR_TSM_OVRD1_SY_LO_RX_BUF_EN_OVRD_EN_Pos = 0x0
	// Bit mask of SY_LO_RX_BUF_EN_OVRD_EN field.
	XCVR_TSM_OVRD1_SY_LO_RX_BUF_EN_OVRD_EN_Msk = 0x1
	// Bit SY_LO_RX_BUF_EN_OVRD_EN.
	XCVR_TSM_OVRD1_SY_LO_RX_BUF_EN_OVRD_EN = 0x1
	// Normal operation.
	XCVR_TSM_OVRD1_SY_LO_RX_BUF_EN_OVRD_EN_0 = 0x0
	// Use the state of SY_LO_RX_BUF_EN_OVRD to override the signal "sy_lo_rx_buf_en".
	XCVR_TSM_OVRD1_SY_LO_RX_BUF_EN_OVRD_EN_1 = 0x1
	// Position of SY_LO_RX_BUF_EN_OVRD field.
	XCVR_TSM_OVRD1_SY_LO_RX_BUF_EN_OVRD_Pos = 0x1
	// Bit mask of SY_LO_RX_BUF_EN_OVRD field.
	XCVR_TSM_OVRD1_SY_LO_RX_BUF_EN_OVRD_Msk = 0x2
	// Bit SY_LO_RX_BUF_EN_OVRD.
	XCVR_TSM_OVRD1_SY_LO_RX_BUF_EN_OVRD = 0x2
	// Position of SY_LO_TX_BUF_EN_OVRD_EN field.
	XCVR_TSM_OVRD1_SY_LO_TX_BUF_EN_OVRD_EN_Pos = 0x2
	// Bit mask of SY_LO_TX_BUF_EN_OVRD_EN field.
	XCVR_TSM_OVRD1_SY_LO_TX_BUF_EN_OVRD_EN_Msk = 0x4
	// Bit SY_LO_TX_BUF_EN_OVRD_EN.
	XCVR_TSM_OVRD1_SY_LO_TX_BUF_EN_OVRD_EN = 0x4
	// Normal operation.
	XCVR_TSM_OVRD1_SY_LO_TX_BUF_EN_OVRD_EN_0 = 0x0
	// Use the state of SY_LO_TX_BUF_EN_OVRD to override the signal "sy_lo_tx_buf_en".
	XCVR_TSM_OVRD1_SY_LO_TX_BUF_EN_OVRD_EN_1 = 0x1
	// Position of SY_LO_TX_BUF_EN_OVRD field.
	XCVR_TSM_OVRD1_SY_LO_TX_BUF_EN_OVRD_Pos = 0x3
	// Bit mask of SY_LO_TX_BUF_EN_OVRD field.
	XCVR_TSM_OVRD1_SY_LO_TX_BUF_EN_OVRD_Msk = 0x8
	// Bit SY_LO_TX_BUF_EN_OVRD.
	XCVR_TSM_OVRD1_SY_LO_TX_BUF_EN_OVRD = 0x8
	// Position of SY_DIVN_EN_OVRD_EN field.
	XCVR_TSM_OVRD1_SY_DIVN_EN_OVRD_EN_Pos = 0x4
	// Bit mask of SY_DIVN_EN_OVRD_EN field.
	XCVR_TSM_OVRD1_SY_DIVN_EN_OVRD_EN_Msk = 0x10
	// Bit SY_DIVN_EN_OVRD_EN.
	XCVR_TSM_OVRD1_SY_DIVN_EN_OVRD_EN = 0x10
	// Normal operation.
	XCVR_TSM_OVRD1_SY_DIVN_EN_OVRD_EN_0 = 0x0
	// Use the state of SY_DIVN_EN_OVRD to override the signal "sy_divn_en".
	XCVR_TSM_OVRD1_SY_DIVN_EN_OVRD_EN_1 = 0x1
	// Position of SY_DIVN_EN_OVRD field.
	XCVR_TSM_OVRD1_SY_DIVN_EN_OVRD_Pos = 0x5
	// Bit mask of SY_DIVN_EN_OVRD field.
	XCVR_TSM_OVRD1_SY_DIVN_EN_OVRD_Msk = 0x20
	// Bit SY_DIVN_EN_OVRD.
	XCVR_TSM_OVRD1_SY_DIVN_EN_OVRD = 0x20
	// Position of SY_PD_FILTER_CHARGE_EN_OVRD_EN field.
	XCVR_TSM_OVRD1_SY_PD_FILTER_CHARGE_EN_OVRD_EN_Pos = 0x6
	// Bit mask of SY_PD_FILTER_CHARGE_EN_OVRD_EN field.
	XCVR_TSM_OVRD1_SY_PD_FILTER_CHARGE_EN_OVRD_EN_Msk = 0x40
	// Bit SY_PD_FILTER_CHARGE_EN_OVRD_EN.
	XCVR_TSM_OVRD1_SY_PD_FILTER_CHARGE_EN_OVRD_EN = 0x40
	// Normal operation.
	XCVR_TSM_OVRD1_SY_PD_FILTER_CHARGE_EN_OVRD_EN_0 = 0x0
	// Use the state of SY_PD_FILTER_CHARGE_EN_OVRD to override the signal "sy_pd_filter_charge_en".
	XCVR_TSM_OVRD1_SY_PD_FILTER_CHARGE_EN_OVRD_EN_1 = 0x1
	// Position of SY_PD_FILTER_CHARGE_EN_OVRD field.
	XCVR_TSM_OVRD1_SY_PD_FILTER_CHARGE_EN_OVRD_Pos = 0x7
	// Bit mask of SY_PD_FILTER_CHARGE_EN_OVRD field.
	XCVR_TSM_OVRD1_SY_PD_FILTER_CHARGE_EN_OVRD_Msk = 0x80
	// Bit SY_PD_FILTER_CHARGE_EN_OVRD.
	XCVR_TSM_OVRD1_SY_PD_FILTER_CHARGE_EN_OVRD = 0x80
	// Position of SY_PD_EN_OVRD_EN field.
	XCVR_TSM_OVRD1_SY_PD_EN_OVRD_EN_Pos = 0x8
	// Bit mask of SY_PD_EN_OVRD_EN field.
	XCVR_TSM_OVRD1_SY_PD_EN_OVRD_EN_Msk = 0x100
	// Bit SY_PD_EN_OVRD_EN.
	XCVR_TSM_OVRD1_SY_PD_EN_OVRD_EN = 0x100
	// Normal operation.
	XCVR_TSM_OVRD1_SY_PD_EN_OVRD_EN_0 = 0x0
	// Use the state of SY_PD_EN_OVRD to override the signal "sy_pd_en".
	XCVR_TSM_OVRD1_SY_PD_EN_OVRD_EN_1 = 0x1
	// Position of SY_PD_EN_OVRD field.
	XCVR_TSM_OVRD1_SY_PD_EN_OVRD_Pos = 0x9
	// Bit mask of SY_PD_EN_OVRD field.
	XCVR_TSM_OVRD1_SY_PD_EN_OVRD_Msk = 0x200
	// Bit SY_PD_EN_OVRD.
	XCVR_TSM_OVRD1_SY_PD_EN_OVRD = 0x200
	// Position of SY_LO_DIVN_EN_OVRD_EN field.
	XCVR_TSM_OVRD1_SY_LO_DIVN_EN_OVRD_EN_Pos = 0xa
	// Bit mask of SY_LO_DIVN_EN_OVRD_EN field.
	XCVR_TSM_OVRD1_SY_LO_DIVN_EN_OVRD_EN_Msk = 0x400
	// Bit SY_LO_DIVN_EN_OVRD_EN.
	XCVR_TSM_OVRD1_SY_LO_DIVN_EN_OVRD_EN = 0x400
	// Normal operation.
	XCVR_TSM_OVRD1_SY_LO_DIVN_EN_OVRD_EN_0 = 0x0
	// Use the state of SY_LO_DIVN_EN_OVRD to override the signal "sy_lo_divn_en".
	XCVR_TSM_OVRD1_SY_LO_DIVN_EN_OVRD_EN_1 = 0x1
	// Position of SY_LO_DIVN_EN_OVRD field.
	XCVR_TSM_OVRD1_SY_LO_DIVN_EN_OVRD_Pos = 0xb
	// Bit mask of SY_LO_DIVN_EN_OVRD field.
	XCVR_TSM_OVRD1_SY_LO_DIVN_EN_OVRD_Msk = 0x800
	// Bit SY_LO_DIVN_EN_OVRD.
	XCVR_TSM_OVRD1_SY_LO_DIVN_EN_OVRD = 0x800
	// Position of SY_LO_RX_EN_OVRD_EN field.
	XCVR_TSM_OVRD1_SY_LO_RX_EN_OVRD_EN_Pos = 0xc
	// Bit mask of SY_LO_RX_EN_OVRD_EN field.
	XCVR_TSM_OVRD1_SY_LO_RX_EN_OVRD_EN_Msk = 0x1000
	// Bit SY_LO_RX_EN_OVRD_EN.
	XCVR_TSM_OVRD1_SY_LO_RX_EN_OVRD_EN = 0x1000
	// Normal operation.
	XCVR_TSM_OVRD1_SY_LO_RX_EN_OVRD_EN_0 = 0x0
	// Use the state of SY_LO_RX_EN_OVRD to override the signal "sy_lo_rx_en".
	XCVR_TSM_OVRD1_SY_LO_RX_EN_OVRD_EN_1 = 0x1
	// Position of SY_LO_RX_EN_OVRD field.
	XCVR_TSM_OVRD1_SY_LO_RX_EN_OVRD_Pos = 0xd
	// Bit mask of SY_LO_RX_EN_OVRD field.
	XCVR_TSM_OVRD1_SY_LO_RX_EN_OVRD_Msk = 0x2000
	// Bit SY_LO_RX_EN_OVRD.
	XCVR_TSM_OVRD1_SY_LO_RX_EN_OVRD = 0x2000
	// Position of SY_LO_TX_EN_OVRD_EN field.
	XCVR_TSM_OVRD1_SY_LO_TX_EN_OVRD_EN_Pos = 0xe
	// Bit mask of SY_LO_TX_EN_OVRD_EN field.
	XCVR_TSM_OVRD1_SY_LO_TX_EN_OVRD_EN_Msk = 0x4000
	// Bit SY_LO_TX_EN_OVRD_EN.
	XCVR_TSM_OVRD1_SY_LO_TX_EN_OVRD_EN = 0x4000
	// Normal operation.
	XCVR_TSM_OVRD1_SY_LO_TX_EN_OVRD_EN_0 = 0x0
	// Use the state of SY_LO_TX_EN_OVRD to override the signal "sy_lo_tx_en".
	XCVR_TSM_OVRD1_SY_LO_TX_EN_OVRD_EN_1 = 0x1
	// Position of SY_LO_TX_EN_OVRD field.
	XCVR_TSM_OVRD1_SY_LO_TX_EN_OVRD_Pos = 0xf
	// Bit mask of SY_LO_TX_EN_OVRD field.
	XCVR_TSM_OVRD1_SY_LO_TX_EN_OVRD_Msk = 0x8000
	// Bit SY_LO_TX_EN_OVRD.
	XCVR_TSM_OVRD1_SY_LO_TX_EN_OVRD = 0x8000
	// Position of SY_DIVN_CAL_EN_OVRD_EN field.
	XCVR_TSM_OVRD1_SY_DIVN_CAL_EN_OVRD_EN_Pos = 0x10
	// Bit mask of SY_DIVN_CAL_EN_OVRD_EN field.
	XCVR_TSM_OVRD1_SY_DIVN_CAL_EN_OVRD_EN_Msk = 0x10000
	// Bit SY_DIVN_CAL_EN_OVRD_EN.
	XCVR_TSM_OVRD1_SY_DIVN_CAL_EN_OVRD_EN = 0x10000
	// Normal operation.
	XCVR_TSM_OVRD1_SY_DIVN_CAL_EN_OVRD_EN_0 = 0x0
	// Use the state of SY_DIVN_CAL_EN_OVRD to override the signal "sy_divn_cal_en".
	XCVR_TSM_OVRD1_SY_DIVN_CAL_EN_OVRD_EN_1 = 0x1
	// Position of SY_DIVN_CAL_EN_OVRD field.
	XCVR_TSM_OVRD1_SY_DIVN_CAL_EN_OVRD_Pos = 0x11
	// Bit mask of SY_DIVN_CAL_EN_OVRD field.
	XCVR_TSM_OVRD1_SY_DIVN_CAL_EN_OVRD_Msk = 0x20000
	// Bit SY_DIVN_CAL_EN_OVRD.
	XCVR_TSM_OVRD1_SY_DIVN_CAL_EN_OVRD = 0x20000
	// Position of RX_MIXER_EN_OVRD_EN field.
	XCVR_TSM_OVRD1_RX_MIXER_EN_OVRD_EN_Pos = 0x12
	// Bit mask of RX_MIXER_EN_OVRD_EN field.
	XCVR_TSM_OVRD1_RX_MIXER_EN_OVRD_EN_Msk = 0x40000
	// Bit RX_MIXER_EN_OVRD_EN.
	XCVR_TSM_OVRD1_RX_MIXER_EN_OVRD_EN = 0x40000
	// Normal operation.
	XCVR_TSM_OVRD1_RX_MIXER_EN_OVRD_EN_0 = 0x0
	// Use the state of RX_MIXER_EN_OVRD to override the signal "rx_mixer_en".
	XCVR_TSM_OVRD1_RX_MIXER_EN_OVRD_EN_1 = 0x1
	// Position of RX_MIXER_EN_OVRD field.
	XCVR_TSM_OVRD1_RX_MIXER_EN_OVRD_Pos = 0x13
	// Bit mask of RX_MIXER_EN_OVRD field.
	XCVR_TSM_OVRD1_RX_MIXER_EN_OVRD_Msk = 0x80000
	// Bit RX_MIXER_EN_OVRD.
	XCVR_TSM_OVRD1_RX_MIXER_EN_OVRD = 0x80000
	// Position of TX_PA_EN_OVRD_EN field.
	XCVR_TSM_OVRD1_TX_PA_EN_OVRD_EN_Pos = 0x14
	// Bit mask of TX_PA_EN_OVRD_EN field.
	XCVR_TSM_OVRD1_TX_PA_EN_OVRD_EN_Msk = 0x100000
	// Bit TX_PA_EN_OVRD_EN.
	XCVR_TSM_OVRD1_TX_PA_EN_OVRD_EN = 0x100000
	// Normal operation.
	XCVR_TSM_OVRD1_TX_PA_EN_OVRD_EN_0 = 0x0
	// Use the state of TX_PA_EN_OVRD to override the signal "tx_pa_en".
	XCVR_TSM_OVRD1_TX_PA_EN_OVRD_EN_1 = 0x1
	// Position of TX_PA_EN_OVRD field.
	XCVR_TSM_OVRD1_TX_PA_EN_OVRD_Pos = 0x15
	// Bit mask of TX_PA_EN_OVRD field.
	XCVR_TSM_OVRD1_TX_PA_EN_OVRD_Msk = 0x200000
	// Bit TX_PA_EN_OVRD.
	XCVR_TSM_OVRD1_TX_PA_EN_OVRD = 0x200000
	// Position of RX_ADC_I_EN_OVRD_EN field.
	XCVR_TSM_OVRD1_RX_ADC_I_EN_OVRD_EN_Pos = 0x16
	// Bit mask of RX_ADC_I_EN_OVRD_EN field.
	XCVR_TSM_OVRD1_RX_ADC_I_EN_OVRD_EN_Msk = 0x400000
	// Bit RX_ADC_I_EN_OVRD_EN.
	XCVR_TSM_OVRD1_RX_ADC_I_EN_OVRD_EN = 0x400000
	// Normal operation.
	XCVR_TSM_OVRD1_RX_ADC_I_EN_OVRD_EN_0 = 0x0
	// Use the state of RX_ADC_I_EN_OVRD to override the signal "rx_adc_i_en".
	XCVR_TSM_OVRD1_RX_ADC_I_EN_OVRD_EN_1 = 0x1
	// Position of RX_ADC_I_EN_OVRD field.
	XCVR_TSM_OVRD1_RX_ADC_I_EN_OVRD_Pos = 0x17
	// Bit mask of RX_ADC_I_EN_OVRD field.
	XCVR_TSM_OVRD1_RX_ADC_I_EN_OVRD_Msk = 0x800000
	// Bit RX_ADC_I_EN_OVRD.
	XCVR_TSM_OVRD1_RX_ADC_I_EN_OVRD = 0x800000
	// Position of RX_ADC_Q_EN_OVRD_EN field.
	XCVR_TSM_OVRD1_RX_ADC_Q_EN_OVRD_EN_Pos = 0x18
	// Bit mask of RX_ADC_Q_EN_OVRD_EN field.
	XCVR_TSM_OVRD1_RX_ADC_Q_EN_OVRD_EN_Msk = 0x1000000
	// Bit RX_ADC_Q_EN_OVRD_EN.
	XCVR_TSM_OVRD1_RX_ADC_Q_EN_OVRD_EN = 0x1000000
	// Normal operation.
	XCVR_TSM_OVRD1_RX_ADC_Q_EN_OVRD_EN_0 = 0x0
	// Use the state of RX_ADC_Q_EN_OVRD to override the signal "rx_adc_q_en".
	XCVR_TSM_OVRD1_RX_ADC_Q_EN_OVRD_EN_1 = 0x1
	// Position of RX_ADC_Q_EN_OVRD field.
	XCVR_TSM_OVRD1_RX_ADC_Q_EN_OVRD_Pos = 0x19
	// Bit mask of RX_ADC_Q_EN_OVRD field.
	XCVR_TSM_OVRD1_RX_ADC_Q_EN_OVRD_Msk = 0x2000000
	// Bit RX_ADC_Q_EN_OVRD.
	XCVR_TSM_OVRD1_RX_ADC_Q_EN_OVRD = 0x2000000
	// Position of RX_ADC_RESET_EN_OVRD_EN field.
	XCVR_TSM_OVRD1_RX_ADC_RESET_EN_OVRD_EN_Pos = 0x1a
	// Bit mask of RX_ADC_RESET_EN_OVRD_EN field.
	XCVR_TSM_OVRD1_RX_ADC_RESET_EN_OVRD_EN_Msk = 0x4000000
	// Bit RX_ADC_RESET_EN_OVRD_EN.
	XCVR_TSM_OVRD1_RX_ADC_RESET_EN_OVRD_EN = 0x4000000
	// Normal operation.
	XCVR_TSM_OVRD1_RX_ADC_RESET_EN_OVRD_EN_0 = 0x0
	// Use the state of RX_ADC_RESET_EN_OVRD to override the signal "rx_adc_reset_en".
	XCVR_TSM_OVRD1_RX_ADC_RESET_EN_OVRD_EN_1 = 0x1
	// Position of RX_ADC_RESET_EN_OVRD field.
	XCVR_TSM_OVRD1_RX_ADC_RESET_EN_OVRD_Pos = 0x1b
	// Bit mask of RX_ADC_RESET_EN_OVRD field.
	XCVR_TSM_OVRD1_RX_ADC_RESET_EN_OVRD_Msk = 0x8000000
	// Bit RX_ADC_RESET_EN_OVRD.
	XCVR_TSM_OVRD1_RX_ADC_RESET_EN_OVRD = 0x8000000
	// Position of RX_BBA_I_EN_OVRD_EN field.
	XCVR_TSM_OVRD1_RX_BBA_I_EN_OVRD_EN_Pos = 0x1c
	// Bit mask of RX_BBA_I_EN_OVRD_EN field.
	XCVR_TSM_OVRD1_RX_BBA_I_EN_OVRD_EN_Msk = 0x10000000
	// Bit RX_BBA_I_EN_OVRD_EN.
	XCVR_TSM_OVRD1_RX_BBA_I_EN_OVRD_EN = 0x10000000
	// Normal operation.
	XCVR_TSM_OVRD1_RX_BBA_I_EN_OVRD_EN_0 = 0x0
	// Use the state of RX_BBA_I_EN_OVRD to override the signal "rx_bba_i_en".
	XCVR_TSM_OVRD1_RX_BBA_I_EN_OVRD_EN_1 = 0x1
	// Position of RX_BBA_I_EN_OVRD field.
	XCVR_TSM_OVRD1_RX_BBA_I_EN_OVRD_Pos = 0x1d
	// Bit mask of RX_BBA_I_EN_OVRD field.
	XCVR_TSM_OVRD1_RX_BBA_I_EN_OVRD_Msk = 0x20000000
	// Bit RX_BBA_I_EN_OVRD.
	XCVR_TSM_OVRD1_RX_BBA_I_EN_OVRD = 0x20000000
	// Position of RX_BBA_Q_EN_OVRD_EN field.
	XCVR_TSM_OVRD1_RX_BBA_Q_EN_OVRD_EN_Pos = 0x1e
	// Bit mask of RX_BBA_Q_EN_OVRD_EN field.
	XCVR_TSM_OVRD1_RX_BBA_Q_EN_OVRD_EN_Msk = 0x40000000
	// Bit RX_BBA_Q_EN_OVRD_EN.
	XCVR_TSM_OVRD1_RX_BBA_Q_EN_OVRD_EN = 0x40000000
	// Normal operation.
	XCVR_TSM_OVRD1_RX_BBA_Q_EN_OVRD_EN_0 = 0x0
	// Use the state of RX_BBA_Q_EN_OVRD to override the signal "rx_bba_q_en".
	XCVR_TSM_OVRD1_RX_BBA_Q_EN_OVRD_EN_1 = 0x1
	// Position of RX_BBA_Q_EN_OVRD field.
	XCVR_TSM_OVRD1_RX_BBA_Q_EN_OVRD_Pos = 0x1f
	// Bit mask of RX_BBA_Q_EN_OVRD field.
	XCVR_TSM_OVRD1_RX_BBA_Q_EN_OVRD_Msk = 0x80000000
	// Bit RX_BBA_Q_EN_OVRD.
	XCVR_TSM_OVRD1_RX_BBA_Q_EN_OVRD = 0x80000000

	// OVRD2: TSM OVERRIDE REGISTER 2
	// Position of RX_BBA_PDET_EN_OVRD_EN field.
	XCVR_TSM_OVRD2_RX_BBA_PDET_EN_OVRD_EN_Pos = 0x0
	// Bit mask of RX_BBA_PDET_EN_OVRD_EN field.
	XCVR_TSM_OVRD2_RX_BBA_PDET_EN_OVRD_EN_Msk = 0x1
	// Bit RX_BBA_PDET_EN_OVRD_EN.
	XCVR_TSM_OVRD2_RX_BBA_PDET_EN_OVRD_EN = 0x1
	// Normal operation.
	XCVR_TSM_OVRD2_RX_BBA_PDET_EN_OVRD_EN_0 = 0x0
	// Use the state of RX_BBA_PDET_EN_OVRD to override the signal "rx_bba_pdet_en".
	XCVR_TSM_OVRD2_RX_BBA_PDET_EN_OVRD_EN_1 = 0x1
	// Position of RX_BBA_PDET_EN_OVRD field.
	XCVR_TSM_OVRD2_RX_BBA_PDET_EN_OVRD_Pos = 0x1
	// Bit mask of RX_BBA_PDET_EN_OVRD field.
	XCVR_TSM_OVRD2_RX_BBA_PDET_EN_OVRD_Msk = 0x2
	// Bit RX_BBA_PDET_EN_OVRD.
	XCVR_TSM_OVRD2_RX_BBA_PDET_EN_OVRD = 0x2
	// Position of RX_BBA_DCOC_EN_OVRD_EN field.
	XCVR_TSM_OVRD2_RX_BBA_DCOC_EN_OVRD_EN_Pos = 0x2
	// Bit mask of RX_BBA_DCOC_EN_OVRD_EN field.
	XCVR_TSM_OVRD2_RX_BBA_DCOC_EN_OVRD_EN_Msk = 0x4
	// Bit RX_BBA_DCOC_EN_OVRD_EN.
	XCVR_TSM_OVRD2_RX_BBA_DCOC_EN_OVRD_EN = 0x4
	// Normal operation.
	XCVR_TSM_OVRD2_RX_BBA_DCOC_EN_OVRD_EN_0 = 0x0
	// Use the state of RX_BBA_DCOC_EN_OVRD to override the signal "rx_bba_dcoc_en".
	XCVR_TSM_OVRD2_RX_BBA_DCOC_EN_OVRD_EN_1 = 0x1
	// Position of RX_BBA_DCOC_EN_OVRD field.
	XCVR_TSM_OVRD2_RX_BBA_DCOC_EN_OVRD_Pos = 0x3
	// Bit mask of RX_BBA_DCOC_EN_OVRD field.
	XCVR_TSM_OVRD2_RX_BBA_DCOC_EN_OVRD_Msk = 0x8
	// Bit RX_BBA_DCOC_EN_OVRD.
	XCVR_TSM_OVRD2_RX_BBA_DCOC_EN_OVRD = 0x8
	// Position of RX_LNA_EN_OVRD_EN field.
	XCVR_TSM_OVRD2_RX_LNA_EN_OVRD_EN_Pos = 0x4
	// Bit mask of RX_LNA_EN_OVRD_EN field.
	XCVR_TSM_OVRD2_RX_LNA_EN_OVRD_EN_Msk = 0x10
	// Bit RX_LNA_EN_OVRD_EN.
	XCVR_TSM_OVRD2_RX_LNA_EN_OVRD_EN = 0x10
	// Normal operation.
	XCVR_TSM_OVRD2_RX_LNA_EN_OVRD_EN_0 = 0x0
	// Use the state of RX_LNA_EN_OVRD to override the signal "rx_lna_en".
	XCVR_TSM_OVRD2_RX_LNA_EN_OVRD_EN_1 = 0x1
	// Position of RX_LNA_EN_OVRD field.
	XCVR_TSM_OVRD2_RX_LNA_EN_OVRD_Pos = 0x5
	// Bit mask of RX_LNA_EN_OVRD field.
	XCVR_TSM_OVRD2_RX_LNA_EN_OVRD_Msk = 0x20
	// Bit RX_LNA_EN_OVRD.
	XCVR_TSM_OVRD2_RX_LNA_EN_OVRD = 0x20
	// Position of RX_TZA_I_EN_OVRD_EN field.
	XCVR_TSM_OVRD2_RX_TZA_I_EN_OVRD_EN_Pos = 0x6
	// Bit mask of RX_TZA_I_EN_OVRD_EN field.
	XCVR_TSM_OVRD2_RX_TZA_I_EN_OVRD_EN_Msk = 0x40
	// Bit RX_TZA_I_EN_OVRD_EN.
	XCVR_TSM_OVRD2_RX_TZA_I_EN_OVRD_EN = 0x40
	// Normal operation.
	XCVR_TSM_OVRD2_RX_TZA_I_EN_OVRD_EN_0 = 0x0
	// Use the state of RX_TZA_I_EN_OVRD to override the signal "rx_tza_i_en".
	XCVR_TSM_OVRD2_RX_TZA_I_EN_OVRD_EN_1 = 0x1
	// Position of RX_TZA_I_EN_OVRD field.
	XCVR_TSM_OVRD2_RX_TZA_I_EN_OVRD_Pos = 0x7
	// Bit mask of RX_TZA_I_EN_OVRD field.
	XCVR_TSM_OVRD2_RX_TZA_I_EN_OVRD_Msk = 0x80
	// Bit RX_TZA_I_EN_OVRD.
	XCVR_TSM_OVRD2_RX_TZA_I_EN_OVRD = 0x80
	// Position of RX_TZA_Q_EN_OVRD_EN field.
	XCVR_TSM_OVRD2_RX_TZA_Q_EN_OVRD_EN_Pos = 0x8
	// Bit mask of RX_TZA_Q_EN_OVRD_EN field.
	XCVR_TSM_OVRD2_RX_TZA_Q_EN_OVRD_EN_Msk = 0x100
	// Bit RX_TZA_Q_EN_OVRD_EN.
	XCVR_TSM_OVRD2_RX_TZA_Q_EN_OVRD_EN = 0x100
	// Normal operation.
	XCVR_TSM_OVRD2_RX_TZA_Q_EN_OVRD_EN_0 = 0x0
	// Use the state of RX_TZA_Q_EN_OVRD to override the signal "rx_tza_q_en".
	XCVR_TSM_OVRD2_RX_TZA_Q_EN_OVRD_EN_1 = 0x1
	// Position of RX_TZA_Q_EN_OVRD field.
	XCVR_TSM_OVRD2_RX_TZA_Q_EN_OVRD_Pos = 0x9
	// Bit mask of RX_TZA_Q_EN_OVRD field.
	XCVR_TSM_OVRD2_RX_TZA_Q_EN_OVRD_Msk = 0x200
	// Bit RX_TZA_Q_EN_OVRD.
	XCVR_TSM_OVRD2_RX_TZA_Q_EN_OVRD = 0x200
	// Position of RX_TZA_PDET_EN_OVRD_EN field.
	XCVR_TSM_OVRD2_RX_TZA_PDET_EN_OVRD_EN_Pos = 0xa
	// Bit mask of RX_TZA_PDET_EN_OVRD_EN field.
	XCVR_TSM_OVRD2_RX_TZA_PDET_EN_OVRD_EN_Msk = 0x400
	// Bit RX_TZA_PDET_EN_OVRD_EN.
	XCVR_TSM_OVRD2_RX_TZA_PDET_EN_OVRD_EN = 0x400
	// Normal operation.
	XCVR_TSM_OVRD2_RX_TZA_PDET_EN_OVRD_EN_0 = 0x0
	// Use the state of RX_TZA_PDET_EN_OVRD to override the signal "rx_tza_pdet_en".
	XCVR_TSM_OVRD2_RX_TZA_PDET_EN_OVRD_EN_1 = 0x1
	// Position of RX_TZA_PDET_EN_OVRD field.
	XCVR_TSM_OVRD2_RX_TZA_PDET_EN_OVRD_Pos = 0xb
	// Bit mask of RX_TZA_PDET_EN_OVRD field.
	XCVR_TSM_OVRD2_RX_TZA_PDET_EN_OVRD_Msk = 0x800
	// Bit RX_TZA_PDET_EN_OVRD.
	XCVR_TSM_OVRD2_RX_TZA_PDET_EN_OVRD = 0x800
	// Position of RX_TZA_DCOC_EN_OVRD_EN field.
	XCVR_TSM_OVRD2_RX_TZA_DCOC_EN_OVRD_EN_Pos = 0xc
	// Bit mask of RX_TZA_DCOC_EN_OVRD_EN field.
	XCVR_TSM_OVRD2_RX_TZA_DCOC_EN_OVRD_EN_Msk = 0x1000
	// Bit RX_TZA_DCOC_EN_OVRD_EN.
	XCVR_TSM_OVRD2_RX_TZA_DCOC_EN_OVRD_EN = 0x1000
	// Normal operation.
	XCVR_TSM_OVRD2_RX_TZA_DCOC_EN_OVRD_EN_0 = 0x0
	// Use the state of RX_TZA_DCOC_EN_OVRD to override the signal "rx_tza_dcoc_en".
	XCVR_TSM_OVRD2_RX_TZA_DCOC_EN_OVRD_EN_1 = 0x1
	// Position of RX_TZA_DCOC_EN_OVRD field.
	XCVR_TSM_OVRD2_RX_TZA_DCOC_EN_OVRD_Pos = 0xd
	// Bit mask of RX_TZA_DCOC_EN_OVRD field.
	XCVR_TSM_OVRD2_RX_TZA_DCOC_EN_OVRD_Msk = 0x2000
	// Bit RX_TZA_DCOC_EN_OVRD.
	XCVR_TSM_OVRD2_RX_TZA_DCOC_EN_OVRD = 0x2000
	// Normal operation.
	XCVR_TSM_OVRD2_RX_TZA_DCOC_EN_OVRD_0 = 0x0
	// Use the state of RX_TZA_DCOC_EN_OVRD to override the signal "rx_tza_dcoc_en".
	XCVR_TSM_OVRD2_RX_TZA_DCOC_EN_OVRD_1 = 0x1
	// Position of PLL_DIG_EN_OVRD_EN field.
	XCVR_TSM_OVRD2_PLL_DIG_EN_OVRD_EN_Pos = 0xe
	// Bit mask of PLL_DIG_EN_OVRD_EN field.
	XCVR_TSM_OVRD2_PLL_DIG_EN_OVRD_EN_Msk = 0x4000
	// Bit PLL_DIG_EN_OVRD_EN.
	XCVR_TSM_OVRD2_PLL_DIG_EN_OVRD_EN = 0x4000
	// Normal operation.
	XCVR_TSM_OVRD2_PLL_DIG_EN_OVRD_EN_0 = 0x0
	// Use the state of PLL_DIG_EN_OVRD to override the signal "pll_dig_en".
	XCVR_TSM_OVRD2_PLL_DIG_EN_OVRD_EN_1 = 0x1
	// Position of PLL_DIG_EN_OVRD field.
	XCVR_TSM_OVRD2_PLL_DIG_EN_OVRD_Pos = 0xf
	// Bit mask of PLL_DIG_EN_OVRD field.
	XCVR_TSM_OVRD2_PLL_DIG_EN_OVRD_Msk = 0x8000
	// Bit PLL_DIG_EN_OVRD.
	XCVR_TSM_OVRD2_PLL_DIG_EN_OVRD = 0x8000
	// Position of TX_DIG_EN_OVRD_EN field.
	XCVR_TSM_OVRD2_TX_DIG_EN_OVRD_EN_Pos = 0x10
	// Bit mask of TX_DIG_EN_OVRD_EN field.
	XCVR_TSM_OVRD2_TX_DIG_EN_OVRD_EN_Msk = 0x10000
	// Bit TX_DIG_EN_OVRD_EN.
	XCVR_TSM_OVRD2_TX_DIG_EN_OVRD_EN = 0x10000
	// Normal operation.
	XCVR_TSM_OVRD2_TX_DIG_EN_OVRD_EN_0 = 0x0
	// Use the state of TX_DIG_EN_OVRD to override the signal "tx_dig_en".
	XCVR_TSM_OVRD2_TX_DIG_EN_OVRD_EN_1 = 0x1
	// Position of TX_DIG_EN_OVRD field.
	XCVR_TSM_OVRD2_TX_DIG_EN_OVRD_Pos = 0x11
	// Bit mask of TX_DIG_EN_OVRD field.
	XCVR_TSM_OVRD2_TX_DIG_EN_OVRD_Msk = 0x20000
	// Bit TX_DIG_EN_OVRD.
	XCVR_TSM_OVRD2_TX_DIG_EN_OVRD = 0x20000
	// Position of RX_DIG_EN_OVRD_EN field.
	XCVR_TSM_OVRD2_RX_DIG_EN_OVRD_EN_Pos = 0x12
	// Bit mask of RX_DIG_EN_OVRD_EN field.
	XCVR_TSM_OVRD2_RX_DIG_EN_OVRD_EN_Msk = 0x40000
	// Bit RX_DIG_EN_OVRD_EN.
	XCVR_TSM_OVRD2_RX_DIG_EN_OVRD_EN = 0x40000
	// Normal operation.
	XCVR_TSM_OVRD2_RX_DIG_EN_OVRD_EN_0 = 0x0
	// Use the state of RX_DIG_EN_OVRD to override the signal "rx_dig_en".
	XCVR_TSM_OVRD2_RX_DIG_EN_OVRD_EN_1 = 0x1
	// Position of RX_DIG_EN_OVRD field.
	XCVR_TSM_OVRD2_RX_DIG_EN_OVRD_Pos = 0x13
	// Bit mask of RX_DIG_EN_OVRD field.
	XCVR_TSM_OVRD2_RX_DIG_EN_OVRD_Msk = 0x80000
	// Bit RX_DIG_EN_OVRD.
	XCVR_TSM_OVRD2_RX_DIG_EN_OVRD = 0x80000
	// Position of RX_INIT_OVRD_EN field.
	XCVR_TSM_OVRD2_RX_INIT_OVRD_EN_Pos = 0x14
	// Bit mask of RX_INIT_OVRD_EN field.
	XCVR_TSM_OVRD2_RX_INIT_OVRD_EN_Msk = 0x100000
	// Bit RX_INIT_OVRD_EN.
	XCVR_TSM_OVRD2_RX_INIT_OVRD_EN = 0x100000
	// Normal operation.
	XCVR_TSM_OVRD2_RX_INIT_OVRD_EN_0 = 0x0
	// Use the state of RX_INIT_OVRD to override the signal "rx_init".
	XCVR_TSM_OVRD2_RX_INIT_OVRD_EN_1 = 0x1
	// Position of RX_INIT_OVRD field.
	XCVR_TSM_OVRD2_RX_INIT_OVRD_Pos = 0x15
	// Bit mask of RX_INIT_OVRD field.
	XCVR_TSM_OVRD2_RX_INIT_OVRD_Msk = 0x200000
	// Bit RX_INIT_OVRD.
	XCVR_TSM_OVRD2_RX_INIT_OVRD = 0x200000
	// Position of SIGMA_DELTA_EN_OVRD_EN field.
	XCVR_TSM_OVRD2_SIGMA_DELTA_EN_OVRD_EN_Pos = 0x16
	// Bit mask of SIGMA_DELTA_EN_OVRD_EN field.
	XCVR_TSM_OVRD2_SIGMA_DELTA_EN_OVRD_EN_Msk = 0x400000
	// Bit SIGMA_DELTA_EN_OVRD_EN.
	XCVR_TSM_OVRD2_SIGMA_DELTA_EN_OVRD_EN = 0x400000
	// Normal operation.
	XCVR_TSM_OVRD2_SIGMA_DELTA_EN_OVRD_EN_0 = 0x0
	// Use the state of SIGMA_DELTA_EN_OVRD to override the signal "sigma_delta_en".
	XCVR_TSM_OVRD2_SIGMA_DELTA_EN_OVRD_EN_1 = 0x1
	// Position of SIGMA_DELTA_EN_OVRD field.
	XCVR_TSM_OVRD2_SIGMA_DELTA_EN_OVRD_Pos = 0x17
	// Bit mask of SIGMA_DELTA_EN_OVRD field.
	XCVR_TSM_OVRD2_SIGMA_DELTA_EN_OVRD_Msk = 0x800000
	// Bit SIGMA_DELTA_EN_OVRD.
	XCVR_TSM_OVRD2_SIGMA_DELTA_EN_OVRD = 0x800000
	// Position of RX_PHY_EN_OVRD_EN field.
	XCVR_TSM_OVRD2_RX_PHY_EN_OVRD_EN_Pos = 0x18
	// Bit mask of RX_PHY_EN_OVRD_EN field.
	XCVR_TSM_OVRD2_RX_PHY_EN_OVRD_EN_Msk = 0x1000000
	// Bit RX_PHY_EN_OVRD_EN.
	XCVR_TSM_OVRD2_RX_PHY_EN_OVRD_EN = 0x1000000
	// Normal operation.
	XCVR_TSM_OVRD2_RX_PHY_EN_OVRD_EN_0 = 0x0
	// Use the state of RX_PHY_EN_OVRD to override the signal "rx_phy_en".
	XCVR_TSM_OVRD2_RX_PHY_EN_OVRD_EN_1 = 0x1
	// Position of RX_PHY_EN_OVRD field.
	XCVR_TSM_OVRD2_RX_PHY_EN_OVRD_Pos = 0x19
	// Bit mask of RX_PHY_EN_OVRD field.
	XCVR_TSM_OVRD2_RX_PHY_EN_OVRD_Msk = 0x2000000
	// Bit RX_PHY_EN_OVRD.
	XCVR_TSM_OVRD2_RX_PHY_EN_OVRD = 0x2000000
	// Position of DCOC_EN_OVRD_EN field.
	XCVR_TSM_OVRD2_DCOC_EN_OVRD_EN_Pos = 0x1a
	// Bit mask of DCOC_EN_OVRD_EN field.
	XCVR_TSM_OVRD2_DCOC_EN_OVRD_EN_Msk = 0x4000000
	// Bit DCOC_EN_OVRD_EN.
	XCVR_TSM_OVRD2_DCOC_EN_OVRD_EN = 0x4000000
	// Normal operation.
	XCVR_TSM_OVRD2_DCOC_EN_OVRD_EN_0 = 0x0
	// Use the state of DCOC_EN_OVRD to override the signal "dcoc_en".
	XCVR_TSM_OVRD2_DCOC_EN_OVRD_EN_1 = 0x1
	// Position of DCOC_EN_OVRD field.
	XCVR_TSM_OVRD2_DCOC_EN_OVRD_Pos = 0x1b
	// Bit mask of DCOC_EN_OVRD field.
	XCVR_TSM_OVRD2_DCOC_EN_OVRD_Msk = 0x8000000
	// Bit DCOC_EN_OVRD.
	XCVR_TSM_OVRD2_DCOC_EN_OVRD = 0x8000000
	// Position of DCOC_INIT_OVRD_EN field.
	XCVR_TSM_OVRD2_DCOC_INIT_OVRD_EN_Pos = 0x1c
	// Bit mask of DCOC_INIT_OVRD_EN field.
	XCVR_TSM_OVRD2_DCOC_INIT_OVRD_EN_Msk = 0x10000000
	// Bit DCOC_INIT_OVRD_EN.
	XCVR_TSM_OVRD2_DCOC_INIT_OVRD_EN = 0x10000000
	// Normal operation.
	XCVR_TSM_OVRD2_DCOC_INIT_OVRD_EN_0 = 0x0
	// Use the state of DCOC_INIT_OVRD to override the signal "dcoc_init".
	XCVR_TSM_OVRD2_DCOC_INIT_OVRD_EN_1 = 0x1
	// Position of DCOC_INIT_OVRD field.
	XCVR_TSM_OVRD2_DCOC_INIT_OVRD_Pos = 0x1d
	// Bit mask of DCOC_INIT_OVRD field.
	XCVR_TSM_OVRD2_DCOC_INIT_OVRD_Msk = 0x20000000
	// Bit DCOC_INIT_OVRD.
	XCVR_TSM_OVRD2_DCOC_INIT_OVRD = 0x20000000
	// Position of FREQ_TARG_LD_EN_OVRD_EN field.
	XCVR_TSM_OVRD2_FREQ_TARG_LD_EN_OVRD_EN_Pos = 0x1e
	// Bit mask of FREQ_TARG_LD_EN_OVRD_EN field.
	XCVR_TSM_OVRD2_FREQ_TARG_LD_EN_OVRD_EN_Msk = 0x40000000
	// Bit FREQ_TARG_LD_EN_OVRD_EN.
	XCVR_TSM_OVRD2_FREQ_TARG_LD_EN_OVRD_EN = 0x40000000
	// Normal operation.
	XCVR_TSM_OVRD2_FREQ_TARG_LD_EN_OVRD_EN_0 = 0x0
	// Use the state of FREQ_TARG_LD_EN_OVRD to override the signal "freq_targ_ld_en".
	XCVR_TSM_OVRD2_FREQ_TARG_LD_EN_OVRD_EN_1 = 0x1
	// Position of FREQ_TARG_LD_EN_OVRD field.
	XCVR_TSM_OVRD2_FREQ_TARG_LD_EN_OVRD_Pos = 0x1f
	// Bit mask of FREQ_TARG_LD_EN_OVRD field.
	XCVR_TSM_OVRD2_FREQ_TARG_LD_EN_OVRD_Msk = 0x80000000
	// Bit FREQ_TARG_LD_EN_OVRD.
	XCVR_TSM_OVRD2_FREQ_TARG_LD_EN_OVRD = 0x80000000

	// OVRD3: TSM OVERRIDE REGISTER 3
	// Position of TSM_SPARE0_EN_OVRD_EN field.
	XCVR_TSM_OVRD3_TSM_SPARE0_EN_OVRD_EN_Pos = 0x0
	// Bit mask of TSM_SPARE0_EN_OVRD_EN field.
	XCVR_TSM_OVRD3_TSM_SPARE0_EN_OVRD_EN_Msk = 0x1
	// Bit TSM_SPARE0_EN_OVRD_EN.
	XCVR_TSM_OVRD3_TSM_SPARE0_EN_OVRD_EN = 0x1
	// Normal operation.
	XCVR_TSM_OVRD3_TSM_SPARE0_EN_OVRD_EN_0 = 0x0
	// Use the state of TSM_SPARE0_EN_OVRD to override the signal "tsm_spare0_en".
	XCVR_TSM_OVRD3_TSM_SPARE0_EN_OVRD_EN_1 = 0x1
	// Position of TSM_SPARE0_EN_OVRD field.
	XCVR_TSM_OVRD3_TSM_SPARE0_EN_OVRD_Pos = 0x1
	// Bit mask of TSM_SPARE0_EN_OVRD field.
	XCVR_TSM_OVRD3_TSM_SPARE0_EN_OVRD_Msk = 0x2
	// Bit TSM_SPARE0_EN_OVRD.
	XCVR_TSM_OVRD3_TSM_SPARE0_EN_OVRD = 0x2
	// Position of TSM_SPARE1_EN_OVRD_EN field.
	XCVR_TSM_OVRD3_TSM_SPARE1_EN_OVRD_EN_Pos = 0x2
	// Bit mask of TSM_SPARE1_EN_OVRD_EN field.
	XCVR_TSM_OVRD3_TSM_SPARE1_EN_OVRD_EN_Msk = 0x4
	// Bit TSM_SPARE1_EN_OVRD_EN.
	XCVR_TSM_OVRD3_TSM_SPARE1_EN_OVRD_EN = 0x4
	// Normal operation.
	XCVR_TSM_OVRD3_TSM_SPARE1_EN_OVRD_EN_0 = 0x0
	// Use the state of TSM_SPARE1_EN_OVRD to override the signal "tsm_spare1_en".
	XCVR_TSM_OVRD3_TSM_SPARE1_EN_OVRD_EN_1 = 0x1
	// Position of TSM_SPARE1_EN_OVRD field.
	XCVR_TSM_OVRD3_TSM_SPARE1_EN_OVRD_Pos = 0x3
	// Bit mask of TSM_SPARE1_EN_OVRD field.
	XCVR_TSM_OVRD3_TSM_SPARE1_EN_OVRD_Msk = 0x8
	// Bit TSM_SPARE1_EN_OVRD.
	XCVR_TSM_OVRD3_TSM_SPARE1_EN_OVRD = 0x8
	// Position of TSM_SPARE2_EN_OVRD_EN field.
	XCVR_TSM_OVRD3_TSM_SPARE2_EN_OVRD_EN_Pos = 0x4
	// Bit mask of TSM_SPARE2_EN_OVRD_EN field.
	XCVR_TSM_OVRD3_TSM_SPARE2_EN_OVRD_EN_Msk = 0x10
	// Bit TSM_SPARE2_EN_OVRD_EN.
	XCVR_TSM_OVRD3_TSM_SPARE2_EN_OVRD_EN = 0x10
	// Normal operation.
	XCVR_TSM_OVRD3_TSM_SPARE2_EN_OVRD_EN_0 = 0x0
	// Use the state of TSM_SPARE2_EN_OVRD to override the signal "tsm_spare2_en".
	XCVR_TSM_OVRD3_TSM_SPARE2_EN_OVRD_EN_1 = 0x1
	// Position of TSM_SPARE2_EN_OVRD field.
	XCVR_TSM_OVRD3_TSM_SPARE2_EN_OVRD_Pos = 0x5
	// Bit mask of TSM_SPARE2_EN_OVRD field.
	XCVR_TSM_OVRD3_TSM_SPARE2_EN_OVRD_Msk = 0x20
	// Bit TSM_SPARE2_EN_OVRD.
	XCVR_TSM_OVRD3_TSM_SPARE2_EN_OVRD = 0x20
	// Position of TSM_SPARE3_EN_OVRD_EN field.
	XCVR_TSM_OVRD3_TSM_SPARE3_EN_OVRD_EN_Pos = 0x6
	// Bit mask of TSM_SPARE3_EN_OVRD_EN field.
	XCVR_TSM_OVRD3_TSM_SPARE3_EN_OVRD_EN_Msk = 0x40
	// Bit TSM_SPARE3_EN_OVRD_EN.
	XCVR_TSM_OVRD3_TSM_SPARE3_EN_OVRD_EN = 0x40
	// Normal operation.
	XCVR_TSM_OVRD3_TSM_SPARE3_EN_OVRD_EN_0 = 0x0
	// Use the state of TSM_SPARE3_EN_OVRD to override the signal "tsm_spare3_en".
	XCVR_TSM_OVRD3_TSM_SPARE3_EN_OVRD_EN_1 = 0x1
	// Position of TSM_SPARE3_EN_OVRD field.
	XCVR_TSM_OVRD3_TSM_SPARE3_EN_OVRD_Pos = 0x7
	// Bit mask of TSM_SPARE3_EN_OVRD field.
	XCVR_TSM_OVRD3_TSM_SPARE3_EN_OVRD_Msk = 0x80
	// Bit TSM_SPARE3_EN_OVRD.
	XCVR_TSM_OVRD3_TSM_SPARE3_EN_OVRD = 0x80
	// Position of RXTX_AUXPLL_BIAS_EN_OVRD_EN field.
	XCVR_TSM_OVRD3_RXTX_AUXPLL_BIAS_EN_OVRD_EN_Pos = 0x8
	// Bit mask of RXTX_AUXPLL_BIAS_EN_OVRD_EN field.
	XCVR_TSM_OVRD3_RXTX_AUXPLL_BIAS_EN_OVRD_EN_Msk = 0x100
	// Bit RXTX_AUXPLL_BIAS_EN_OVRD_EN.
	XCVR_TSM_OVRD3_RXTX_AUXPLL_BIAS_EN_OVRD_EN = 0x100
	// Normal operation.
	XCVR_TSM_OVRD3_RXTX_AUXPLL_BIAS_EN_OVRD_EN_0 = 0x0
	// Use the state of RXTX_AUXPLL_BIAS_EN_OVRD to override the signal "rxtx_auxpll_bias_en".
	XCVR_TSM_OVRD3_RXTX_AUXPLL_BIAS_EN_OVRD_EN_1 = 0x1
	// Position of RXTX_AUXPLL_BIAS_EN_OVRD field.
	XCVR_TSM_OVRD3_RXTX_AUXPLL_BIAS_EN_OVRD_Pos = 0x9
	// Bit mask of RXTX_AUXPLL_BIAS_EN_OVRD field.
	XCVR_TSM_OVRD3_RXTX_AUXPLL_BIAS_EN_OVRD_Msk = 0x200
	// Bit RXTX_AUXPLL_BIAS_EN_OVRD.
	XCVR_TSM_OVRD3_RXTX_AUXPLL_BIAS_EN_OVRD = 0x200
	// Position of RXTX_AUXPLL_VCO_EN_OVRD_EN field.
	XCVR_TSM_OVRD3_RXTX_AUXPLL_VCO_EN_OVRD_EN_Pos = 0xa
	// Bit mask of RXTX_AUXPLL_VCO_EN_OVRD_EN field.
	XCVR_TSM_OVRD3_RXTX_AUXPLL_VCO_EN_OVRD_EN_Msk = 0x400
	// Bit RXTX_AUXPLL_VCO_EN_OVRD_EN.
	XCVR_TSM_OVRD3_RXTX_AUXPLL_VCO_EN_OVRD_EN = 0x400
	// Normal operation.
	XCVR_TSM_OVRD3_RXTX_AUXPLL_VCO_EN_OVRD_EN_0 = 0x0
	// Use the state of RXTX_AUXPLL_VCO_EN_OVRD to override the signal "rxtx_auxpll_vco_en".
	XCVR_TSM_OVRD3_RXTX_AUXPLL_VCO_EN_OVRD_EN_1 = 0x1
	// Position of RXTX_AUXPLL_VCO_EN_OVRD field.
	XCVR_TSM_OVRD3_RXTX_AUXPLL_VCO_EN_OVRD_Pos = 0xb
	// Bit mask of RXTX_AUXPLL_VCO_EN_OVRD field.
	XCVR_TSM_OVRD3_RXTX_AUXPLL_VCO_EN_OVRD_Msk = 0x800
	// Bit RXTX_AUXPLL_VCO_EN_OVRD.
	XCVR_TSM_OVRD3_RXTX_AUXPLL_VCO_EN_OVRD = 0x800
	// Position of RXTX_AUXPLL_FCAL_EN_OVRD_EN field.
	XCVR_TSM_OVRD3_RXTX_AUXPLL_FCAL_EN_OVRD_EN_Pos = 0xc
	// Bit mask of RXTX_AUXPLL_FCAL_EN_OVRD_EN field.
	XCVR_TSM_OVRD3_RXTX_AUXPLL_FCAL_EN_OVRD_EN_Msk = 0x1000
	// Bit RXTX_AUXPLL_FCAL_EN_OVRD_EN.
	XCVR_TSM_OVRD3_RXTX_AUXPLL_FCAL_EN_OVRD_EN = 0x1000
	// Normal operation.
	XCVR_TSM_OVRD3_RXTX_AUXPLL_FCAL_EN_OVRD_EN_0 = 0x0
	// Use the state of RXTX_AUXPLL_FCAL_EN_OVRD to override the signal "rxtx_auxpll_fcal_en".
	XCVR_TSM_OVRD3_RXTX_AUXPLL_FCAL_EN_OVRD_EN_1 = 0x1
	// Position of RXTX_AUXPLL_FCAL_EN_OVRD field.
	XCVR_TSM_OVRD3_RXTX_AUXPLL_FCAL_EN_OVRD_Pos = 0xd
	// Bit mask of RXTX_AUXPLL_FCAL_EN_OVRD field.
	XCVR_TSM_OVRD3_RXTX_AUXPLL_FCAL_EN_OVRD_Msk = 0x2000
	// Bit RXTX_AUXPLL_FCAL_EN_OVRD.
	XCVR_TSM_OVRD3_RXTX_AUXPLL_FCAL_EN_OVRD = 0x2000
	// Position of RXTX_AUXPLL_LF_EN_OVRD_EN field.
	XCVR_TSM_OVRD3_RXTX_AUXPLL_LF_EN_OVRD_EN_Pos = 0xe
	// Bit mask of RXTX_AUXPLL_LF_EN_OVRD_EN field.
	XCVR_TSM_OVRD3_RXTX_AUXPLL_LF_EN_OVRD_EN_Msk = 0x4000
	// Bit RXTX_AUXPLL_LF_EN_OVRD_EN.
	XCVR_TSM_OVRD3_RXTX_AUXPLL_LF_EN_OVRD_EN = 0x4000
	// Normal operation.
	XCVR_TSM_OVRD3_RXTX_AUXPLL_LF_EN_OVRD_EN_0 = 0x0
	// Use the state of RXTX_AUXPLL_LF_EN_OVRD to override the signal "rxtx_auxpll_lf_en".
	XCVR_TSM_OVRD3_RXTX_AUXPLL_LF_EN_OVRD_EN_1 = 0x1
	// Position of RXTX_AUXPLL_LF_EN_OVRD field.
	XCVR_TSM_OVRD3_RXTX_AUXPLL_LF_EN_OVRD_Pos = 0xf
	// Bit mask of RXTX_AUXPLL_LF_EN_OVRD field.
	XCVR_TSM_OVRD3_RXTX_AUXPLL_LF_EN_OVRD_Msk = 0x8000
	// Bit RXTX_AUXPLL_LF_EN_OVRD.
	XCVR_TSM_OVRD3_RXTX_AUXPLL_LF_EN_OVRD = 0x8000
	// Position of RXTX_AUXPLL_PD_EN_OVRD_EN field.
	XCVR_TSM_OVRD3_RXTX_AUXPLL_PD_EN_OVRD_EN_Pos = 0x10
	// Bit mask of RXTX_AUXPLL_PD_EN_OVRD_EN field.
	XCVR_TSM_OVRD3_RXTX_AUXPLL_PD_EN_OVRD_EN_Msk = 0x10000
	// Bit RXTX_AUXPLL_PD_EN_OVRD_EN.
	XCVR_TSM_OVRD3_RXTX_AUXPLL_PD_EN_OVRD_EN = 0x10000
	// Normal operation.
	XCVR_TSM_OVRD3_RXTX_AUXPLL_PD_EN_OVRD_EN_0 = 0x0
	// Use the state of RXTX_AUXPLL_PD_EN_OVRD to override the signal "rxtx_auxpll_pd_en".
	XCVR_TSM_OVRD3_RXTX_AUXPLL_PD_EN_OVRD_EN_1 = 0x1
	// Position of RXTX_AUXPLL_PD_EN_OVRD field.
	XCVR_TSM_OVRD3_RXTX_AUXPLL_PD_EN_OVRD_Pos = 0x11
	// Bit mask of RXTX_AUXPLL_PD_EN_OVRD field.
	XCVR_TSM_OVRD3_RXTX_AUXPLL_PD_EN_OVRD_Msk = 0x20000
	// Bit RXTX_AUXPLL_PD_EN_OVRD.
	XCVR_TSM_OVRD3_RXTX_AUXPLL_PD_EN_OVRD = 0x20000
	// Position of RXTX_AUXPLL_PD_LF_FILTER_CHARGE_EN_OVRD_EN field.
	XCVR_TSM_OVRD3_RXTX_AUXPLL_PD_LF_FILTER_CHARGE_EN_OVRD_EN_Pos = 0x12
	// Bit mask of RXTX_AUXPLL_PD_LF_FILTER_CHARGE_EN_OVRD_EN field.
	XCVR_TSM_OVRD3_RXTX_AUXPLL_PD_LF_FILTER_CHARGE_EN_OVRD_EN_Msk = 0x40000
	// Bit RXTX_AUXPLL_PD_LF_FILTER_CHARGE_EN_OVRD_EN.
	XCVR_TSM_OVRD3_RXTX_AUXPLL_PD_LF_FILTER_CHARGE_EN_OVRD_EN = 0x40000
	// Normal operation.
	XCVR_TSM_OVRD3_RXTX_AUXPLL_PD_LF_FILTER_CHARGE_EN_OVRD_EN_0 = 0x0
	// Use the state of RXTX_AUXPLL_PD_LF_FILTER_CHARGE_EN_OVRD to override the signal "rxtx_auxpll_pd_lf_filter_charge_en".
	XCVR_TSM_OVRD3_RXTX_AUXPLL_PD_LF_FILTER_CHARGE_EN_OVRD_EN_1 = 0x1
	// Position of RXTX_AUXPLL_PD_LF_FILTER_CHARGE_EN_OVRD field.
	XCVR_TSM_OVRD3_RXTX_AUXPLL_PD_LF_FILTER_CHARGE_EN_OVRD_Pos = 0x13
	// Bit mask of RXTX_AUXPLL_PD_LF_FILTER_CHARGE_EN_OVRD field.
	XCVR_TSM_OVRD3_RXTX_AUXPLL_PD_LF_FILTER_CHARGE_EN_OVRD_Msk = 0x80000
	// Bit RXTX_AUXPLL_PD_LF_FILTER_CHARGE_EN_OVRD.
	XCVR_TSM_OVRD3_RXTX_AUXPLL_PD_LF_FILTER_CHARGE_EN_OVRD = 0x80000
	// Position of RXTX_AUXPLL_ADC_BUF_EN_OVRD_EN field.
	XCVR_TSM_OVRD3_RXTX_AUXPLL_ADC_BUF_EN_OVRD_EN_Pos = 0x14
	// Bit mask of RXTX_AUXPLL_ADC_BUF_EN_OVRD_EN field.
	XCVR_TSM_OVRD3_RXTX_AUXPLL_ADC_BUF_EN_OVRD_EN_Msk = 0x100000
	// Bit RXTX_AUXPLL_ADC_BUF_EN_OVRD_EN.
	XCVR_TSM_OVRD3_RXTX_AUXPLL_ADC_BUF_EN_OVRD_EN = 0x100000
	// Normal operation.
	XCVR_TSM_OVRD3_RXTX_AUXPLL_ADC_BUF_EN_OVRD_EN_0 = 0x0
	// Use the state of RXTX_AUXPLL_ADC_BUF_EN_OVRD to override the signal "rxtx_auxpll_adc_buf_en".
	XCVR_TSM_OVRD3_RXTX_AUXPLL_ADC_BUF_EN_OVRD_EN_1 = 0x1
	// Position of RXTX_AUXPLL_ADC_BUF_EN_OVRD field.
	XCVR_TSM_OVRD3_RXTX_AUXPLL_ADC_BUF_EN_OVRD_Pos = 0x15
	// Bit mask of RXTX_AUXPLL_ADC_BUF_EN_OVRD field.
	XCVR_TSM_OVRD3_RXTX_AUXPLL_ADC_BUF_EN_OVRD_Msk = 0x200000
	// Bit RXTX_AUXPLL_ADC_BUF_EN_OVRD.
	XCVR_TSM_OVRD3_RXTX_AUXPLL_ADC_BUF_EN_OVRD = 0x200000
	// Position of RXTX_AUXPLL_DIG_BUF_EN_OVRD_EN field.
	XCVR_TSM_OVRD3_RXTX_AUXPLL_DIG_BUF_EN_OVRD_EN_Pos = 0x16
	// Bit mask of RXTX_AUXPLL_DIG_BUF_EN_OVRD_EN field.
	XCVR_TSM_OVRD3_RXTX_AUXPLL_DIG_BUF_EN_OVRD_EN_Msk = 0x400000
	// Bit RXTX_AUXPLL_DIG_BUF_EN_OVRD_EN.
	XCVR_TSM_OVRD3_RXTX_AUXPLL_DIG_BUF_EN_OVRD_EN = 0x400000
	// Normal operation.
	XCVR_TSM_OVRD3_RXTX_AUXPLL_DIG_BUF_EN_OVRD_EN_0 = 0x0
	// Use the state of RXTX_AUXPLL_DIG_BUF_EN_OVRD to override the signal "rxtx_auxpll_dig_buf_en".
	XCVR_TSM_OVRD3_RXTX_AUXPLL_DIG_BUF_EN_OVRD_EN_1 = 0x1
	// Position of RXTX_AUXPLL_DIG_BUF_EN_OVRD field.
	XCVR_TSM_OVRD3_RXTX_AUXPLL_DIG_BUF_EN_OVRD_Pos = 0x17
	// Bit mask of RXTX_AUXPLL_DIG_BUF_EN_OVRD field.
	XCVR_TSM_OVRD3_RXTX_AUXPLL_DIG_BUF_EN_OVRD_Msk = 0x800000
	// Bit RXTX_AUXPLL_DIG_BUF_EN_OVRD.
	XCVR_TSM_OVRD3_RXTX_AUXPLL_DIG_BUF_EN_OVRD = 0x800000
	// Position of RXTX_RCCAL_EN_OVRD_EN field.
	XCVR_TSM_OVRD3_RXTX_RCCAL_EN_OVRD_EN_Pos = 0x18
	// Bit mask of RXTX_RCCAL_EN_OVRD_EN field.
	XCVR_TSM_OVRD3_RXTX_RCCAL_EN_OVRD_EN_Msk = 0x1000000
	// Bit RXTX_RCCAL_EN_OVRD_EN.
	XCVR_TSM_OVRD3_RXTX_RCCAL_EN_OVRD_EN = 0x1000000
	// Normal operation.
	XCVR_TSM_OVRD3_RXTX_RCCAL_EN_OVRD_EN_0 = 0x0
	// Use the state of RXTX_RCCAL_EN_OVRD to override the signal "rxtx_rccal_en".
	XCVR_TSM_OVRD3_RXTX_RCCAL_EN_OVRD_EN_1 = 0x1
	// Position of RXTX_RCCAL_EN_OVRD field.
	XCVR_TSM_OVRD3_RXTX_RCCAL_EN_OVRD_Pos = 0x19
	// Bit mask of RXTX_RCCAL_EN_OVRD field.
	XCVR_TSM_OVRD3_RXTX_RCCAL_EN_OVRD_Msk = 0x2000000
	// Bit RXTX_RCCAL_EN_OVRD.
	XCVR_TSM_OVRD3_RXTX_RCCAL_EN_OVRD = 0x2000000
	// Position of TX_HPM_DAC_EN_OVRD_EN field.
	XCVR_TSM_OVRD3_TX_HPM_DAC_EN_OVRD_EN_Pos = 0x1a
	// Bit mask of TX_HPM_DAC_EN_OVRD_EN field.
	XCVR_TSM_OVRD3_TX_HPM_DAC_EN_OVRD_EN_Msk = 0x4000000
	// Bit TX_HPM_DAC_EN_OVRD_EN.
	XCVR_TSM_OVRD3_TX_HPM_DAC_EN_OVRD_EN = 0x4000000
	// Normal operation.
	XCVR_TSM_OVRD3_TX_HPM_DAC_EN_OVRD_EN_0 = 0x0
	// Use the state of TX_HPM_DAC_EN_OVRD to override the signal "tx_hpm_dac_en".
	XCVR_TSM_OVRD3_TX_HPM_DAC_EN_OVRD_EN_1 = 0x1
	// Position of TX_HPM_DAC_EN_OVRD field.
	XCVR_TSM_OVRD3_TX_HPM_DAC_EN_OVRD_Pos = 0x1b
	// Bit mask of TX_HPM_DAC_EN_OVRD field.
	XCVR_TSM_OVRD3_TX_HPM_DAC_EN_OVRD_Msk = 0x8000000
	// Bit TX_HPM_DAC_EN_OVRD.
	XCVR_TSM_OVRD3_TX_HPM_DAC_EN_OVRD = 0x8000000
	// Position of TX_MODE_OVRD_EN field.
	XCVR_TSM_OVRD3_TX_MODE_OVRD_EN_Pos = 0x1c
	// Bit mask of TX_MODE_OVRD_EN field.
	XCVR_TSM_OVRD3_TX_MODE_OVRD_EN_Msk = 0x10000000
	// Bit TX_MODE_OVRD_EN.
	XCVR_TSM_OVRD3_TX_MODE_OVRD_EN = 0x10000000
	// Normal operation.
	XCVR_TSM_OVRD3_TX_MODE_OVRD_EN_0 = 0x0
	// Use the state of TX_MODE_OVRD to override the signal "tx_mode".
	XCVR_TSM_OVRD3_TX_MODE_OVRD_EN_1 = 0x1
	// Position of TX_MODE_OVRD field.
	XCVR_TSM_OVRD3_TX_MODE_OVRD_Pos = 0x1d
	// Bit mask of TX_MODE_OVRD field.
	XCVR_TSM_OVRD3_TX_MODE_OVRD_Msk = 0x20000000
	// Bit TX_MODE_OVRD.
	XCVR_TSM_OVRD3_TX_MODE_OVRD = 0x20000000
	// Position of RX_MODE_OVRD_EN field.
	XCVR_TSM_OVRD3_RX_MODE_OVRD_EN_Pos = 0x1e
	// Bit mask of RX_MODE_OVRD_EN field.
	XCVR_TSM_OVRD3_RX_MODE_OVRD_EN_Msk = 0x40000000
	// Bit RX_MODE_OVRD_EN.
	XCVR_TSM_OVRD3_RX_MODE_OVRD_EN = 0x40000000
	// Normal operation.
	XCVR_TSM_OVRD3_RX_MODE_OVRD_EN_0 = 0x0
	// Use the state of RX_MODE_OVRD to override the signal "rx_mode".
	XCVR_TSM_OVRD3_RX_MODE_OVRD_EN_1 = 0x1
	// Position of RX_MODE_OVRD field.
	XCVR_TSM_OVRD3_RX_MODE_OVRD_Pos = 0x1f
	// Bit mask of RX_MODE_OVRD field.
	XCVR_TSM_OVRD3_RX_MODE_OVRD_Msk = 0x80000000
	// Bit RX_MODE_OVRD.
	XCVR_TSM_OVRD3_RX_MODE_OVRD = 0x80000000

	// PA_POWER: PA POWER
	// Position of PA_POWER field.
	XCVR_TSM_PA_POWER_PA_POWER_Pos = 0x0
	// Bit mask of PA_POWER field.
	XCVR_TSM_PA_POWER_PA_POWER_Msk = 0x3f

	// PA_RAMP_TBL0: PA RAMP TABLE 0
	// Position of PA_RAMP0 field.
	XCVR_TSM_PA_RAMP_TBL0_PA_RAMP0_Pos = 0x0
	// Bit mask of PA_RAMP0 field.
	XCVR_TSM_PA_RAMP_TBL0_PA_RAMP0_Msk = 0x3f
	// Position of PA_RAMP1 field.
	XCVR_TSM_PA_RAMP_TBL0_PA_RAMP1_Pos = 0x8
	// Bit mask of PA_RAMP1 field.
	XCVR_TSM_PA_RAMP_TBL0_PA_RAMP1_Msk = 0x3f00
	// Position of PA_RAMP2 field.
	XCVR_TSM_PA_RAMP_TBL0_PA_RAMP2_Pos = 0x10
	// Bit mask of PA_RAMP2 field.
	XCVR_TSM_PA_RAMP_TBL0_PA_RAMP2_Msk = 0x3f0000
	// Position of PA_RAMP3 field.
	XCVR_TSM_PA_RAMP_TBL0_PA_RAMP3_Pos = 0x18
	// Bit mask of PA_RAMP3 field.
	XCVR_TSM_PA_RAMP_TBL0_PA_RAMP3_Msk = 0x3f000000

	// PA_RAMP_TBL1: PA RAMP TABLE 1
	// Position of PA_RAMP4 field.
	XCVR_TSM_PA_RAMP_TBL1_PA_RAMP4_Pos = 0x0
	// Bit mask of PA_RAMP4 field.
	XCVR_TSM_PA_RAMP_TBL1_PA_RAMP4_Msk = 0x3f
	// Position of PA_RAMP5 field.
	XCVR_TSM_PA_RAMP_TBL1_PA_RAMP5_Pos = 0x8
	// Bit mask of PA_RAMP5 field.
	XCVR_TSM_PA_RAMP_TBL1_PA_RAMP5_Msk = 0x3f00
	// Position of PA_RAMP6 field.
	XCVR_TSM_PA_RAMP_TBL1_PA_RAMP6_Pos = 0x10
	// Bit mask of PA_RAMP6 field.
	XCVR_TSM_PA_RAMP_TBL1_PA_RAMP6_Msk = 0x3f0000
	// Position of PA_RAMP7 field.
	XCVR_TSM_PA_RAMP_TBL1_PA_RAMP7_Pos = 0x18
	// Bit mask of PA_RAMP7 field.
	XCVR_TSM_PA_RAMP_TBL1_PA_RAMP7_Msk = 0x3f000000

	// RECYCLE_COUNT: TSM RECYCLE COUNT
	// Position of RECYCLE_COUNT0 field.
	XCVR_TSM_RECYCLE_COUNT_RECYCLE_COUNT0_Pos = 0x0
	// Bit mask of RECYCLE_COUNT0 field.
	XCVR_TSM_RECYCLE_COUNT_RECYCLE_COUNT0_Msk = 0xff
	// Position of RECYCLE_COUNT1 field.
	XCVR_TSM_RECYCLE_COUNT_RECYCLE_COUNT1_Pos = 0x8
	// Bit mask of RECYCLE_COUNT1 field.
	XCVR_TSM_RECYCLE_COUNT_RECYCLE_COUNT1_Msk = 0xff00
	// Position of RECYCLE_COUNT2 field.
	XCVR_TSM_RECYCLE_COUNT_RECYCLE_COUNT2_Pos = 0x10
	// Bit mask of RECYCLE_COUNT2 field.
	XCVR_TSM_RECYCLE_COUNT_RECYCLE_COUNT2_Msk = 0xff0000

	// FAST_CTRL1: TSM FAST WARMUP CONTROL REGISTER 1
	// Position of FAST_TX_WU_EN field.
	XCVR_TSM_FAST_CTRL1_FAST_TX_WU_EN_Pos = 0x0
	// Bit mask of FAST_TX_WU_EN field.
	XCVR_TSM_FAST_CTRL1_FAST_TX_WU_EN_Msk = 0x1
	// Bit FAST_TX_WU_EN.
	XCVR_TSM_FAST_CTRL1_FAST_TX_WU_EN = 0x1
	// Fast TSM TX Warmups are disabled
	XCVR_TSM_FAST_CTRL1_FAST_TX_WU_EN_0 = 0x0
	// Fast TSM TX Warmups are enabled, if the RF channel has not changed since the last TX warmup, and for BLE mode, the RF channel is not an advertising channel.
	XCVR_TSM_FAST_CTRL1_FAST_TX_WU_EN_1 = 0x1
	// Position of FAST_RX_WU_EN field.
	XCVR_TSM_FAST_CTRL1_FAST_RX_WU_EN_Pos = 0x1
	// Bit mask of FAST_RX_WU_EN field.
	XCVR_TSM_FAST_CTRL1_FAST_RX_WU_EN_Msk = 0x2
	// Bit FAST_RX_WU_EN.
	XCVR_TSM_FAST_CTRL1_FAST_RX_WU_EN = 0x2
	// Fast TSM RX Warmups are disabled
	XCVR_TSM_FAST_CTRL1_FAST_RX_WU_EN_0 = 0x0
	// Fast TSM RX Warmups are enabled, if the RF channel has not changed since the last RX warmup, and for BLE mode, the RF channel is not an advertising channel.
	XCVR_TSM_FAST_CTRL1_FAST_RX_WU_EN_1 = 0x1
	// Position of FAST_RX2TX_EN field.
	XCVR_TSM_FAST_CTRL1_FAST_RX2TX_EN_Pos = 0x2
	// Bit mask of FAST_RX2TX_EN field.
	XCVR_TSM_FAST_CTRL1_FAST_RX2TX_EN_Msk = 0x4
	// Bit FAST_RX2TX_EN.
	XCVR_TSM_FAST_CTRL1_FAST_RX2TX_EN = 0x4
	// Position of FAST_WU_CLEAR field.
	XCVR_TSM_FAST_CTRL1_FAST_WU_CLEAR_Pos = 0x3
	// Bit mask of FAST_WU_CLEAR field.
	XCVR_TSM_FAST_CTRL1_FAST_WU_CLEAR_Msk = 0x8
	// Bit FAST_WU_CLEAR.
	XCVR_TSM_FAST_CTRL1_FAST_WU_CLEAR = 0x8
	// Position of FAST_RX2TX_START field.
	XCVR_TSM_FAST_CTRL1_FAST_RX2TX_START_Pos = 0x8
	// Bit mask of FAST_RX2TX_START field.
	XCVR_TSM_FAST_CTRL1_FAST_RX2TX_START_Msk = 0xff00

	// FAST_CTRL2: TSM FAST WARMUP CONTROL REGISTER 2
	// Position of FAST_START_TX field.
	XCVR_TSM_FAST_CTRL2_FAST_START_TX_Pos = 0x0
	// Bit mask of FAST_START_TX field.
	XCVR_TSM_FAST_CTRL2_FAST_START_TX_Msk = 0xff
	// Position of FAST_DEST_TX field.
	XCVR_TSM_FAST_CTRL2_FAST_DEST_TX_Pos = 0x8
	// Bit mask of FAST_DEST_TX field.
	XCVR_TSM_FAST_CTRL2_FAST_DEST_TX_Msk = 0xff00
	// Position of FAST_START_RX field.
	XCVR_TSM_FAST_CTRL2_FAST_START_RX_Pos = 0x10
	// Bit mask of FAST_START_RX field.
	XCVR_TSM_FAST_CTRL2_FAST_START_RX_Msk = 0xff0000
	// Position of FAST_DEST_RX field.
	XCVR_TSM_FAST_CTRL2_FAST_DEST_RX_Pos = 0x18
	// Bit mask of FAST_DEST_RX field.
	XCVR_TSM_FAST_CTRL2_FAST_DEST_RX_Msk = 0xff000000

	// TIMING00: TSM_TIMING00
	// Position of BB_LDO_HF_EN_TX_HI field.
	XCVR_TSM_TIMING00_BB_LDO_HF_EN_TX_HI_Pos = 0x0
	// Bit mask of BB_LDO_HF_EN_TX_HI field.
	XCVR_TSM_TIMING00_BB_LDO_HF_EN_TX_HI_Msk = 0xff
	// Position of BB_LDO_HF_EN_TX_LO field.
	XCVR_TSM_TIMING00_BB_LDO_HF_EN_TX_LO_Pos = 0x8
	// Bit mask of BB_LDO_HF_EN_TX_LO field.
	XCVR_TSM_TIMING00_BB_LDO_HF_EN_TX_LO_Msk = 0xff00
	// Position of BB_LDO_HF_EN_RX_HI field.
	XCVR_TSM_TIMING00_BB_LDO_HF_EN_RX_HI_Pos = 0x10
	// Bit mask of BB_LDO_HF_EN_RX_HI field.
	XCVR_TSM_TIMING00_BB_LDO_HF_EN_RX_HI_Msk = 0xff0000
	// Position of BB_LDO_HF_EN_RX_LO field.
	XCVR_TSM_TIMING00_BB_LDO_HF_EN_RX_LO_Pos = 0x18
	// Bit mask of BB_LDO_HF_EN_RX_LO field.
	XCVR_TSM_TIMING00_BB_LDO_HF_EN_RX_LO_Msk = 0xff000000

	// TIMING01: TSM_TIMING01
	// Position of BB_LDO_ADCDAC_EN_TX_HI field.
	XCVR_TSM_TIMING01_BB_LDO_ADCDAC_EN_TX_HI_Pos = 0x0
	// Bit mask of BB_LDO_ADCDAC_EN_TX_HI field.
	XCVR_TSM_TIMING01_BB_LDO_ADCDAC_EN_TX_HI_Msk = 0xff
	// Position of BB_LDO_ADCDAC_EN_TX_LO field.
	XCVR_TSM_TIMING01_BB_LDO_ADCDAC_EN_TX_LO_Pos = 0x8
	// Bit mask of BB_LDO_ADCDAC_EN_TX_LO field.
	XCVR_TSM_TIMING01_BB_LDO_ADCDAC_EN_TX_LO_Msk = 0xff00
	// Position of BB_LDO_ADCDAC_EN_RX_HI field.
	XCVR_TSM_TIMING01_BB_LDO_ADCDAC_EN_RX_HI_Pos = 0x10
	// Bit mask of BB_LDO_ADCDAC_EN_RX_HI field.
	XCVR_TSM_TIMING01_BB_LDO_ADCDAC_EN_RX_HI_Msk = 0xff0000
	// Position of BB_LDO_ADCDAC_EN_RX_LO field.
	XCVR_TSM_TIMING01_BB_LDO_ADCDAC_EN_RX_LO_Pos = 0x18
	// Bit mask of BB_LDO_ADCDAC_EN_RX_LO field.
	XCVR_TSM_TIMING01_BB_LDO_ADCDAC_EN_RX_LO_Msk = 0xff000000

	// TIMING02: TSM_TIMING02
	// Position of BB_LDO_BBA_EN_RX_HI field.
	XCVR_TSM_TIMING02_BB_LDO_BBA_EN_RX_HI_Pos = 0x10
	// Bit mask of BB_LDO_BBA_EN_RX_HI field.
	XCVR_TSM_TIMING02_BB_LDO_BBA_EN_RX_HI_Msk = 0xff0000
	// Position of BB_LDO_BBA_EN_RX_LO field.
	XCVR_TSM_TIMING02_BB_LDO_BBA_EN_RX_LO_Pos = 0x18
	// Bit mask of BB_LDO_BBA_EN_RX_LO field.
	XCVR_TSM_TIMING02_BB_LDO_BBA_EN_RX_LO_Msk = 0xff000000

	// TIMING03: TSM_TIMING03
	// Position of BB_LDO_PD_EN_TX_HI field.
	XCVR_TSM_TIMING03_BB_LDO_PD_EN_TX_HI_Pos = 0x0
	// Bit mask of BB_LDO_PD_EN_TX_HI field.
	XCVR_TSM_TIMING03_BB_LDO_PD_EN_TX_HI_Msk = 0xff
	// Position of BB_LDO_PD_EN_TX_LO field.
	XCVR_TSM_TIMING03_BB_LDO_PD_EN_TX_LO_Pos = 0x8
	// Bit mask of BB_LDO_PD_EN_TX_LO field.
	XCVR_TSM_TIMING03_BB_LDO_PD_EN_TX_LO_Msk = 0xff00
	// Position of BB_LDO_PD_EN_RX_HI field.
	XCVR_TSM_TIMING03_BB_LDO_PD_EN_RX_HI_Pos = 0x10
	// Bit mask of BB_LDO_PD_EN_RX_HI field.
	XCVR_TSM_TIMING03_BB_LDO_PD_EN_RX_HI_Msk = 0xff0000
	// Position of BB_LDO_PD_EN_RX_LO field.
	XCVR_TSM_TIMING03_BB_LDO_PD_EN_RX_LO_Pos = 0x18
	// Bit mask of BB_LDO_PD_EN_RX_LO field.
	XCVR_TSM_TIMING03_BB_LDO_PD_EN_RX_LO_Msk = 0xff000000

	// TIMING04: TSM_TIMING04
	// Position of BB_LDO_FDBK_EN_TX_HI field.
	XCVR_TSM_TIMING04_BB_LDO_FDBK_EN_TX_HI_Pos = 0x0
	// Bit mask of BB_LDO_FDBK_EN_TX_HI field.
	XCVR_TSM_TIMING04_BB_LDO_FDBK_EN_TX_HI_Msk = 0xff
	// Position of BB_LDO_FDBK_EN_TX_LO field.
	XCVR_TSM_TIMING04_BB_LDO_FDBK_EN_TX_LO_Pos = 0x8
	// Bit mask of BB_LDO_FDBK_EN_TX_LO field.
	XCVR_TSM_TIMING04_BB_LDO_FDBK_EN_TX_LO_Msk = 0xff00
	// Position of BB_LDO_FDBK_EN_RX_HI field.
	XCVR_TSM_TIMING04_BB_LDO_FDBK_EN_RX_HI_Pos = 0x10
	// Bit mask of BB_LDO_FDBK_EN_RX_HI field.
	XCVR_TSM_TIMING04_BB_LDO_FDBK_EN_RX_HI_Msk = 0xff0000
	// Position of BB_LDO_FDBK_EN_RX_LO field.
	XCVR_TSM_TIMING04_BB_LDO_FDBK_EN_RX_LO_Pos = 0x18
	// Bit mask of BB_LDO_FDBK_EN_RX_LO field.
	XCVR_TSM_TIMING04_BB_LDO_FDBK_EN_RX_LO_Msk = 0xff000000

	// TIMING05: TSM_TIMING05
	// Position of BB_LDO_VCOLO_EN_TX_HI field.
	XCVR_TSM_TIMING05_BB_LDO_VCOLO_EN_TX_HI_Pos = 0x0
	// Bit mask of BB_LDO_VCOLO_EN_TX_HI field.
	XCVR_TSM_TIMING05_BB_LDO_VCOLO_EN_TX_HI_Msk = 0xff
	// Position of BB_LDO_VCOLO_EN_TX_LO field.
	XCVR_TSM_TIMING05_BB_LDO_VCOLO_EN_TX_LO_Pos = 0x8
	// Bit mask of BB_LDO_VCOLO_EN_TX_LO field.
	XCVR_TSM_TIMING05_BB_LDO_VCOLO_EN_TX_LO_Msk = 0xff00
	// Position of BB_LDO_VCOLO_EN_RX_HI field.
	XCVR_TSM_TIMING05_BB_LDO_VCOLO_EN_RX_HI_Pos = 0x10
	// Bit mask of BB_LDO_VCOLO_EN_RX_HI field.
	XCVR_TSM_TIMING05_BB_LDO_VCOLO_EN_RX_HI_Msk = 0xff0000
	// Position of BB_LDO_VCOLO_EN_RX_LO field.
	XCVR_TSM_TIMING05_BB_LDO_VCOLO_EN_RX_LO_Pos = 0x18
	// Bit mask of BB_LDO_VCOLO_EN_RX_LO field.
	XCVR_TSM_TIMING05_BB_LDO_VCOLO_EN_RX_LO_Msk = 0xff000000

	// TIMING06: TSM_TIMING06
	// Position of BB_LDO_VTREF_EN_TX_HI field.
	XCVR_TSM_TIMING06_BB_LDO_VTREF_EN_TX_HI_Pos = 0x0
	// Bit mask of BB_LDO_VTREF_EN_TX_HI field.
	XCVR_TSM_TIMING06_BB_LDO_VTREF_EN_TX_HI_Msk = 0xff
	// Position of BB_LDO_VTREF_EN_TX_LO field.
	XCVR_TSM_TIMING06_BB_LDO_VTREF_EN_TX_LO_Pos = 0x8
	// Bit mask of BB_LDO_VTREF_EN_TX_LO field.
	XCVR_TSM_TIMING06_BB_LDO_VTREF_EN_TX_LO_Msk = 0xff00
	// Position of BB_LDO_VTREF_EN_RX_HI field.
	XCVR_TSM_TIMING06_BB_LDO_VTREF_EN_RX_HI_Pos = 0x10
	// Bit mask of BB_LDO_VTREF_EN_RX_HI field.
	XCVR_TSM_TIMING06_BB_LDO_VTREF_EN_RX_HI_Msk = 0xff0000
	// Position of BB_LDO_VTREF_EN_RX_LO field.
	XCVR_TSM_TIMING06_BB_LDO_VTREF_EN_RX_LO_Pos = 0x18
	// Bit mask of BB_LDO_VTREF_EN_RX_LO field.
	XCVR_TSM_TIMING06_BB_LDO_VTREF_EN_RX_LO_Msk = 0xff000000

	// TIMING07: TSM_TIMING07
	// Position of BB_LDO_FDBK_BLEED_EN_TX_HI field.
	XCVR_TSM_TIMING07_BB_LDO_FDBK_BLEED_EN_TX_HI_Pos = 0x0
	// Bit mask of BB_LDO_FDBK_BLEED_EN_TX_HI field.
	XCVR_TSM_TIMING07_BB_LDO_FDBK_BLEED_EN_TX_HI_Msk = 0xff
	// Position of BB_LDO_FDBK_BLEED_EN_TX_LO field.
	XCVR_TSM_TIMING07_BB_LDO_FDBK_BLEED_EN_TX_LO_Pos = 0x8
	// Bit mask of BB_LDO_FDBK_BLEED_EN_TX_LO field.
	XCVR_TSM_TIMING07_BB_LDO_FDBK_BLEED_EN_TX_LO_Msk = 0xff00
	// Position of BB_LDO_FDBK_BLEED_EN_RX_HI field.
	XCVR_TSM_TIMING07_BB_LDO_FDBK_BLEED_EN_RX_HI_Pos = 0x10
	// Bit mask of BB_LDO_FDBK_BLEED_EN_RX_HI field.
	XCVR_TSM_TIMING07_BB_LDO_FDBK_BLEED_EN_RX_HI_Msk = 0xff0000
	// Position of BB_LDO_FDBK_BLEED_EN_RX_LO field.
	XCVR_TSM_TIMING07_BB_LDO_FDBK_BLEED_EN_RX_LO_Pos = 0x18
	// Bit mask of BB_LDO_FDBK_BLEED_EN_RX_LO field.
	XCVR_TSM_TIMING07_BB_LDO_FDBK_BLEED_EN_RX_LO_Msk = 0xff000000

	// TIMING08: TSM_TIMING08
	// Position of BB_LDO_VCOLO_BLEED_EN_TX_HI field.
	XCVR_TSM_TIMING08_BB_LDO_VCOLO_BLEED_EN_TX_HI_Pos = 0x0
	// Bit mask of BB_LDO_VCOLO_BLEED_EN_TX_HI field.
	XCVR_TSM_TIMING08_BB_LDO_VCOLO_BLEED_EN_TX_HI_Msk = 0xff
	// Position of BB_LDO_VCOLO_BLEED_EN_TX_LO field.
	XCVR_TSM_TIMING08_BB_LDO_VCOLO_BLEED_EN_TX_LO_Pos = 0x8
	// Bit mask of BB_LDO_VCOLO_BLEED_EN_TX_LO field.
	XCVR_TSM_TIMING08_BB_LDO_VCOLO_BLEED_EN_TX_LO_Msk = 0xff00
	// Position of BB_LDO_VCOLO_BLEED_EN_RX_HI field.
	XCVR_TSM_TIMING08_BB_LDO_VCOLO_BLEED_EN_RX_HI_Pos = 0x10
	// Bit mask of BB_LDO_VCOLO_BLEED_EN_RX_HI field.
	XCVR_TSM_TIMING08_BB_LDO_VCOLO_BLEED_EN_RX_HI_Msk = 0xff0000
	// Position of BB_LDO_VCOLO_BLEED_EN_RX_LO field.
	XCVR_TSM_TIMING08_BB_LDO_VCOLO_BLEED_EN_RX_LO_Pos = 0x18
	// Bit mask of BB_LDO_VCOLO_BLEED_EN_RX_LO field.
	XCVR_TSM_TIMING08_BB_LDO_VCOLO_BLEED_EN_RX_LO_Msk = 0xff000000

	// TIMING09: TSM_TIMING09
	// Position of BB_LDO_VCOLO_FASTCHARGE_EN_TX_HI field.
	XCVR_TSM_TIMING09_BB_LDO_VCOLO_FASTCHARGE_EN_TX_HI_Pos = 0x0
	// Bit mask of BB_LDO_VCOLO_FASTCHARGE_EN_TX_HI field.
	XCVR_TSM_TIMING09_BB_LDO_VCOLO_FASTCHARGE_EN_TX_HI_Msk = 0xff
	// Position of BB_LDO_VCOLO_FASTCHARGE_EN_TX_LO field.
	XCVR_TSM_TIMING09_BB_LDO_VCOLO_FASTCHARGE_EN_TX_LO_Pos = 0x8
	// Bit mask of BB_LDO_VCOLO_FASTCHARGE_EN_TX_LO field.
	XCVR_TSM_TIMING09_BB_LDO_VCOLO_FASTCHARGE_EN_TX_LO_Msk = 0xff00
	// Position of BB_LDO_VCOLO_FASTCHARGE_EN_RX_HI field.
	XCVR_TSM_TIMING09_BB_LDO_VCOLO_FASTCHARGE_EN_RX_HI_Pos = 0x10
	// Bit mask of BB_LDO_VCOLO_FASTCHARGE_EN_RX_HI field.
	XCVR_TSM_TIMING09_BB_LDO_VCOLO_FASTCHARGE_EN_RX_HI_Msk = 0xff0000
	// Position of BB_LDO_VCOLO_FASTCHARGE_EN_RX_LO field.
	XCVR_TSM_TIMING09_BB_LDO_VCOLO_FASTCHARGE_EN_RX_LO_Pos = 0x18
	// Bit mask of BB_LDO_VCOLO_FASTCHARGE_EN_RX_LO field.
	XCVR_TSM_TIMING09_BB_LDO_VCOLO_FASTCHARGE_EN_RX_LO_Msk = 0xff000000

	// TIMING10: TSM_TIMING10
	// Position of BB_XTAL_PLL_REF_CLK_EN_TX_HI field.
	XCVR_TSM_TIMING10_BB_XTAL_PLL_REF_CLK_EN_TX_HI_Pos = 0x0
	// Bit mask of BB_XTAL_PLL_REF_CLK_EN_TX_HI field.
	XCVR_TSM_TIMING10_BB_XTAL_PLL_REF_CLK_EN_TX_HI_Msk = 0xff
	// Position of BB_XTAL_PLL_REF_CLK_EN_TX_LO field.
	XCVR_TSM_TIMING10_BB_XTAL_PLL_REF_CLK_EN_TX_LO_Pos = 0x8
	// Bit mask of BB_XTAL_PLL_REF_CLK_EN_TX_LO field.
	XCVR_TSM_TIMING10_BB_XTAL_PLL_REF_CLK_EN_TX_LO_Msk = 0xff00
	// Position of BB_XTAL_PLL_REF_CLK_EN_RX_HI field.
	XCVR_TSM_TIMING10_BB_XTAL_PLL_REF_CLK_EN_RX_HI_Pos = 0x10
	// Bit mask of BB_XTAL_PLL_REF_CLK_EN_RX_HI field.
	XCVR_TSM_TIMING10_BB_XTAL_PLL_REF_CLK_EN_RX_HI_Msk = 0xff0000
	// Position of BB_XTAL_PLL_REF_CLK_EN_RX_LO field.
	XCVR_TSM_TIMING10_BB_XTAL_PLL_REF_CLK_EN_RX_LO_Pos = 0x18
	// Bit mask of BB_XTAL_PLL_REF_CLK_EN_RX_LO field.
	XCVR_TSM_TIMING10_BB_XTAL_PLL_REF_CLK_EN_RX_LO_Msk = 0xff000000

	// TIMING11: TSM_TIMING11
	// Position of BB_XTAL_DAC_REF_CLK_EN_TX_HI field.
	XCVR_TSM_TIMING11_BB_XTAL_DAC_REF_CLK_EN_TX_HI_Pos = 0x0
	// Bit mask of BB_XTAL_DAC_REF_CLK_EN_TX_HI field.
	XCVR_TSM_TIMING11_BB_XTAL_DAC_REF_CLK_EN_TX_HI_Msk = 0xff
	// Position of BB_XTAL_DAC_REF_CLK_EN_TX_LO field.
	XCVR_TSM_TIMING11_BB_XTAL_DAC_REF_CLK_EN_TX_LO_Pos = 0x8
	// Bit mask of BB_XTAL_DAC_REF_CLK_EN_TX_LO field.
	XCVR_TSM_TIMING11_BB_XTAL_DAC_REF_CLK_EN_TX_LO_Msk = 0xff00

	// TIMING12: TSM_TIMING12
	// Position of RXTX_AUXPLL_VCO_REF_CLK_EN_RX_HI field.
	XCVR_TSM_TIMING12_RXTX_AUXPLL_VCO_REF_CLK_EN_RX_HI_Pos = 0x10
	// Bit mask of RXTX_AUXPLL_VCO_REF_CLK_EN_RX_HI field.
	XCVR_TSM_TIMING12_RXTX_AUXPLL_VCO_REF_CLK_EN_RX_HI_Msk = 0xff0000
	// Position of RXTX_AUXPLL_VCO_REF_CLK_EN_RX_LO field.
	XCVR_TSM_TIMING12_RXTX_AUXPLL_VCO_REF_CLK_EN_RX_LO_Pos = 0x18
	// Bit mask of RXTX_AUXPLL_VCO_REF_CLK_EN_RX_LO field.
	XCVR_TSM_TIMING12_RXTX_AUXPLL_VCO_REF_CLK_EN_RX_LO_Msk = 0xff000000

	// TIMING13: TSM_TIMING13
	// Position of SY_VCO_AUTOTUNE_EN_TX_HI field.
	XCVR_TSM_TIMING13_SY_VCO_AUTOTUNE_EN_TX_HI_Pos = 0x0
	// Bit mask of SY_VCO_AUTOTUNE_EN_TX_HI field.
	XCVR_TSM_TIMING13_SY_VCO_AUTOTUNE_EN_TX_HI_Msk = 0xff
	// Position of SY_VCO_AUTOTUNE_EN_TX_LO field.
	XCVR_TSM_TIMING13_SY_VCO_AUTOTUNE_EN_TX_LO_Pos = 0x8
	// Bit mask of SY_VCO_AUTOTUNE_EN_TX_LO field.
	XCVR_TSM_TIMING13_SY_VCO_AUTOTUNE_EN_TX_LO_Msk = 0xff00
	// Position of SY_VCO_AUTOTUNE_EN_RX_HI field.
	XCVR_TSM_TIMING13_SY_VCO_AUTOTUNE_EN_RX_HI_Pos = 0x10
	// Bit mask of SY_VCO_AUTOTUNE_EN_RX_HI field.
	XCVR_TSM_TIMING13_SY_VCO_AUTOTUNE_EN_RX_HI_Msk = 0xff0000
	// Position of SY_VCO_AUTOTUNE_EN_RX_LO field.
	XCVR_TSM_TIMING13_SY_VCO_AUTOTUNE_EN_RX_LO_Pos = 0x18
	// Bit mask of SY_VCO_AUTOTUNE_EN_RX_LO field.
	XCVR_TSM_TIMING13_SY_VCO_AUTOTUNE_EN_RX_LO_Msk = 0xff000000

	// TIMING14: TSM_TIMING14
	// Position of SY_PD_CYCLE_SLIP_LD_FT_EN_TX_HI field.
	XCVR_TSM_TIMING14_SY_PD_CYCLE_SLIP_LD_FT_EN_TX_HI_Pos = 0x0
	// Bit mask of SY_PD_CYCLE_SLIP_LD_FT_EN_TX_HI field.
	XCVR_TSM_TIMING14_SY_PD_CYCLE_SLIP_LD_FT_EN_TX_HI_Msk = 0xff
	// Position of SY_PD_CYCLE_SLIP_LD_FT_EN_TX_LO field.
	XCVR_TSM_TIMING14_SY_PD_CYCLE_SLIP_LD_FT_EN_TX_LO_Pos = 0x8
	// Bit mask of SY_PD_CYCLE_SLIP_LD_FT_EN_TX_LO field.
	XCVR_TSM_TIMING14_SY_PD_CYCLE_SLIP_LD_FT_EN_TX_LO_Msk = 0xff00
	// Position of SY_PD_CYCLE_SLIP_LD_FT_EN_RX_HI field.
	XCVR_TSM_TIMING14_SY_PD_CYCLE_SLIP_LD_FT_EN_RX_HI_Pos = 0x10
	// Bit mask of SY_PD_CYCLE_SLIP_LD_FT_EN_RX_HI field.
	XCVR_TSM_TIMING14_SY_PD_CYCLE_SLIP_LD_FT_EN_RX_HI_Msk = 0xff0000
	// Position of SY_PD_CYCLE_SLIP_LD_FT_EN_RX_LO field.
	XCVR_TSM_TIMING14_SY_PD_CYCLE_SLIP_LD_FT_EN_RX_LO_Pos = 0x18
	// Bit mask of SY_PD_CYCLE_SLIP_LD_FT_EN_RX_LO field.
	XCVR_TSM_TIMING14_SY_PD_CYCLE_SLIP_LD_FT_EN_RX_LO_Msk = 0xff000000

	// TIMING15: TSM_TIMING15
	// Position of SY_VCO_EN_TX_HI field.
	XCVR_TSM_TIMING15_SY_VCO_EN_TX_HI_Pos = 0x0
	// Bit mask of SY_VCO_EN_TX_HI field.
	XCVR_TSM_TIMING15_SY_VCO_EN_TX_HI_Msk = 0xff
	// Position of SY_VCO_EN_TX_LO field.
	XCVR_TSM_TIMING15_SY_VCO_EN_TX_LO_Pos = 0x8
	// Bit mask of SY_VCO_EN_TX_LO field.
	XCVR_TSM_TIMING15_SY_VCO_EN_TX_LO_Msk = 0xff00
	// Position of SY_VCO_EN_RX_HI field.
	XCVR_TSM_TIMING15_SY_VCO_EN_RX_HI_Pos = 0x10
	// Bit mask of SY_VCO_EN_RX_HI field.
	XCVR_TSM_TIMING15_SY_VCO_EN_RX_HI_Msk = 0xff0000
	// Position of SY_VCO_EN_RX_LO field.
	XCVR_TSM_TIMING15_SY_VCO_EN_RX_LO_Pos = 0x18
	// Bit mask of SY_VCO_EN_RX_LO field.
	XCVR_TSM_TIMING15_SY_VCO_EN_RX_LO_Msk = 0xff000000

	// TIMING16: TSM_TIMING16
	// Position of SY_LO_RX_BUF_EN_RX_HI field.
	XCVR_TSM_TIMING16_SY_LO_RX_BUF_EN_RX_HI_Pos = 0x10
	// Bit mask of SY_LO_RX_BUF_EN_RX_HI field.
	XCVR_TSM_TIMING16_SY_LO_RX_BUF_EN_RX_HI_Msk = 0xff0000
	// Position of SY_LO_RX_BUF_EN_RX_LO field.
	XCVR_TSM_TIMING16_SY_LO_RX_BUF_EN_RX_LO_Pos = 0x18
	// Bit mask of SY_LO_RX_BUF_EN_RX_LO field.
	XCVR_TSM_TIMING16_SY_LO_RX_BUF_EN_RX_LO_Msk = 0xff000000

	// TIMING17: TSM_TIMING17
	// Position of SY_LO_TX_BUF_EN_TX_HI field.
	XCVR_TSM_TIMING17_SY_LO_TX_BUF_EN_TX_HI_Pos = 0x0
	// Bit mask of SY_LO_TX_BUF_EN_TX_HI field.
	XCVR_TSM_TIMING17_SY_LO_TX_BUF_EN_TX_HI_Msk = 0xff
	// Position of SY_LO_TX_BUF_EN_TX_LO field.
	XCVR_TSM_TIMING17_SY_LO_TX_BUF_EN_TX_LO_Pos = 0x8
	// Bit mask of SY_LO_TX_BUF_EN_TX_LO field.
	XCVR_TSM_TIMING17_SY_LO_TX_BUF_EN_TX_LO_Msk = 0xff00

	// TIMING18: TSM_TIMING18
	// Position of SY_DIVN_EN_TX_HI field.
	XCVR_TSM_TIMING18_SY_DIVN_EN_TX_HI_Pos = 0x0
	// Bit mask of SY_DIVN_EN_TX_HI field.
	XCVR_TSM_TIMING18_SY_DIVN_EN_TX_HI_Msk = 0xff
	// Position of SY_DIVN_EN_TX_LO field.
	XCVR_TSM_TIMING18_SY_DIVN_EN_TX_LO_Pos = 0x8
	// Bit mask of SY_DIVN_EN_TX_LO field.
	XCVR_TSM_TIMING18_SY_DIVN_EN_TX_LO_Msk = 0xff00
	// Position of SY_DIVN_EN_RX_HI field.
	XCVR_TSM_TIMING18_SY_DIVN_EN_RX_HI_Pos = 0x10
	// Bit mask of SY_DIVN_EN_RX_HI field.
	XCVR_TSM_TIMING18_SY_DIVN_EN_RX_HI_Msk = 0xff0000
	// Position of SY_DIVN_EN_RX_LO field.
	XCVR_TSM_TIMING18_SY_DIVN_EN_RX_LO_Pos = 0x18
	// Bit mask of SY_DIVN_EN_RX_LO field.
	XCVR_TSM_TIMING18_SY_DIVN_EN_RX_LO_Msk = 0xff000000

	// TIMING19: TSM_TIMING19
	// Position of SY_PD_FILTER_CHARGE_EN_TX_HI field.
	XCVR_TSM_TIMING19_SY_PD_FILTER_CHARGE_EN_TX_HI_Pos = 0x0
	// Bit mask of SY_PD_FILTER_CHARGE_EN_TX_HI field.
	XCVR_TSM_TIMING19_SY_PD_FILTER_CHARGE_EN_TX_HI_Msk = 0xff
	// Position of SY_PD_FILTER_CHARGE_EN_TX_LO field.
	XCVR_TSM_TIMING19_SY_PD_FILTER_CHARGE_EN_TX_LO_Pos = 0x8
	// Bit mask of SY_PD_FILTER_CHARGE_EN_TX_LO field.
	XCVR_TSM_TIMING19_SY_PD_FILTER_CHARGE_EN_TX_LO_Msk = 0xff00
	// Position of SY_PD_FILTER_CHARGE_EN_RX_HI field.
	XCVR_TSM_TIMING19_SY_PD_FILTER_CHARGE_EN_RX_HI_Pos = 0x10
	// Bit mask of SY_PD_FILTER_CHARGE_EN_RX_HI field.
	XCVR_TSM_TIMING19_SY_PD_FILTER_CHARGE_EN_RX_HI_Msk = 0xff0000
	// Position of SY_PD_FILTER_CHARGE_EN_RX_LO field.
	XCVR_TSM_TIMING19_SY_PD_FILTER_CHARGE_EN_RX_LO_Pos = 0x18
	// Bit mask of SY_PD_FILTER_CHARGE_EN_RX_LO field.
	XCVR_TSM_TIMING19_SY_PD_FILTER_CHARGE_EN_RX_LO_Msk = 0xff000000

	// TIMING20: TSM_TIMING20
	// Position of SY_PD_EN_TX_HI field.
	XCVR_TSM_TIMING20_SY_PD_EN_TX_HI_Pos = 0x0
	// Bit mask of SY_PD_EN_TX_HI field.
	XCVR_TSM_TIMING20_SY_PD_EN_TX_HI_Msk = 0xff
	// Position of SY_PD_EN_TX_LO field.
	XCVR_TSM_TIMING20_SY_PD_EN_TX_LO_Pos = 0x8
	// Bit mask of SY_PD_EN_TX_LO field.
	XCVR_TSM_TIMING20_SY_PD_EN_TX_LO_Msk = 0xff00
	// Position of SY_PD_EN_RX_HI field.
	XCVR_TSM_TIMING20_SY_PD_EN_RX_HI_Pos = 0x10
	// Bit mask of SY_PD_EN_RX_HI field.
	XCVR_TSM_TIMING20_SY_PD_EN_RX_HI_Msk = 0xff0000
	// Position of SY_PD_EN_RX_LO field.
	XCVR_TSM_TIMING20_SY_PD_EN_RX_LO_Pos = 0x18
	// Bit mask of SY_PD_EN_RX_LO field.
	XCVR_TSM_TIMING20_SY_PD_EN_RX_LO_Msk = 0xff000000

	// TIMING21: TSM_TIMING21
	// Position of SY_LO_DIVN_EN_TX_HI field.
	XCVR_TSM_TIMING21_SY_LO_DIVN_EN_TX_HI_Pos = 0x0
	// Bit mask of SY_LO_DIVN_EN_TX_HI field.
	XCVR_TSM_TIMING21_SY_LO_DIVN_EN_TX_HI_Msk = 0xff
	// Position of SY_LO_DIVN_EN_TX_LO field.
	XCVR_TSM_TIMING21_SY_LO_DIVN_EN_TX_LO_Pos = 0x8
	// Bit mask of SY_LO_DIVN_EN_TX_LO field.
	XCVR_TSM_TIMING21_SY_LO_DIVN_EN_TX_LO_Msk = 0xff00
	// Position of SY_LO_DIVN_EN_RX_HI field.
	XCVR_TSM_TIMING21_SY_LO_DIVN_EN_RX_HI_Pos = 0x10
	// Bit mask of SY_LO_DIVN_EN_RX_HI field.
	XCVR_TSM_TIMING21_SY_LO_DIVN_EN_RX_HI_Msk = 0xff0000
	// Position of SY_LO_DIVN_EN_RX_LO field.
	XCVR_TSM_TIMING21_SY_LO_DIVN_EN_RX_LO_Pos = 0x18
	// Bit mask of SY_LO_DIVN_EN_RX_LO field.
	XCVR_TSM_TIMING21_SY_LO_DIVN_EN_RX_LO_Msk = 0xff000000

	// TIMING22: TSM_TIMING22
	// Position of SY_LO_RX_EN_RX_HI field.
	XCVR_TSM_TIMING22_SY_LO_RX_EN_RX_HI_Pos = 0x10
	// Bit mask of SY_LO_RX_EN_RX_HI field.
	XCVR_TSM_TIMING22_SY_LO_RX_EN_RX_HI_Msk = 0xff0000
	// Position of SY_LO_RX_EN_RX_LO field.
	XCVR_TSM_TIMING22_SY_LO_RX_EN_RX_LO_Pos = 0x18
	// Bit mask of SY_LO_RX_EN_RX_LO field.
	XCVR_TSM_TIMING22_SY_LO_RX_EN_RX_LO_Msk = 0xff000000

	// TIMING23: TSM_TIMING23
	// Position of SY_LO_TX_EN_TX_HI field.
	XCVR_TSM_TIMING23_SY_LO_TX_EN_TX_HI_Pos = 0x0
	// Bit mask of SY_LO_TX_EN_TX_HI field.
	XCVR_TSM_TIMING23_SY_LO_TX_EN_TX_HI_Msk = 0xff
	// Position of SY_LO_TX_EN_TX_LO field.
	XCVR_TSM_TIMING23_SY_LO_TX_EN_TX_LO_Pos = 0x8
	// Bit mask of SY_LO_TX_EN_TX_LO field.
	XCVR_TSM_TIMING23_SY_LO_TX_EN_TX_LO_Msk = 0xff00

	// TIMING24: TSM_TIMING24
	// Position of SY_DIVN_CAL_EN_TX_HI field.
	XCVR_TSM_TIMING24_SY_DIVN_CAL_EN_TX_HI_Pos = 0x0
	// Bit mask of SY_DIVN_CAL_EN_TX_HI field.
	XCVR_TSM_TIMING24_SY_DIVN_CAL_EN_TX_HI_Msk = 0xff
	// Position of SY_DIVN_CAL_EN_TX_LO field.
	XCVR_TSM_TIMING24_SY_DIVN_CAL_EN_TX_LO_Pos = 0x8
	// Bit mask of SY_DIVN_CAL_EN_TX_LO field.
	XCVR_TSM_TIMING24_SY_DIVN_CAL_EN_TX_LO_Msk = 0xff00
	// Position of SY_DIVN_CAL_EN_RX_HI field.
	XCVR_TSM_TIMING24_SY_DIVN_CAL_EN_RX_HI_Pos = 0x10
	// Bit mask of SY_DIVN_CAL_EN_RX_HI field.
	XCVR_TSM_TIMING24_SY_DIVN_CAL_EN_RX_HI_Msk = 0xff0000
	// Position of SY_DIVN_CAL_EN_RX_LO field.
	XCVR_TSM_TIMING24_SY_DIVN_CAL_EN_RX_LO_Pos = 0x18
	// Bit mask of SY_DIVN_CAL_EN_RX_LO field.
	XCVR_TSM_TIMING24_SY_DIVN_CAL_EN_RX_LO_Msk = 0xff000000

	// TIMING25: TSM_TIMING25
	// Position of RX_LNA_MIXER_EN_RX_HI field.
	XCVR_TSM_TIMING25_RX_LNA_MIXER_EN_RX_HI_Pos = 0x10
	// Bit mask of RX_LNA_MIXER_EN_RX_HI field.
	XCVR_TSM_TIMING25_RX_LNA_MIXER_EN_RX_HI_Msk = 0xff0000
	// Position of RX_LNA_MIXER_EN_RX_LO field.
	XCVR_TSM_TIMING25_RX_LNA_MIXER_EN_RX_LO_Pos = 0x18
	// Bit mask of RX_LNA_MIXER_EN_RX_LO field.
	XCVR_TSM_TIMING25_RX_LNA_MIXER_EN_RX_LO_Msk = 0xff000000

	// TIMING26: TSM_TIMING26
	// Position of TX_PA_EN_TX_HI field.
	XCVR_TSM_TIMING26_TX_PA_EN_TX_HI_Pos = 0x0
	// Bit mask of TX_PA_EN_TX_HI field.
	XCVR_TSM_TIMING26_TX_PA_EN_TX_HI_Msk = 0xff
	// Position of TX_PA_EN_TX_LO field.
	XCVR_TSM_TIMING26_TX_PA_EN_TX_LO_Pos = 0x8
	// Bit mask of TX_PA_EN_TX_LO field.
	XCVR_TSM_TIMING26_TX_PA_EN_TX_LO_Msk = 0xff00

	// TIMING27: TSM_TIMING27
	// Position of RX_ADC_I_Q_EN_RX_HI field.
	XCVR_TSM_TIMING27_RX_ADC_I_Q_EN_RX_HI_Pos = 0x10
	// Bit mask of RX_ADC_I_Q_EN_RX_HI field.
	XCVR_TSM_TIMING27_RX_ADC_I_Q_EN_RX_HI_Msk = 0xff0000
	// Position of RX_ADC_I_Q_EN_RX_LO field.
	XCVR_TSM_TIMING27_RX_ADC_I_Q_EN_RX_LO_Pos = 0x18
	// Bit mask of RX_ADC_I_Q_EN_RX_LO field.
	XCVR_TSM_TIMING27_RX_ADC_I_Q_EN_RX_LO_Msk = 0xff000000

	// TIMING28: TSM_TIMING28
	// Position of RX_ADC_RESET_EN_RX_HI field.
	XCVR_TSM_TIMING28_RX_ADC_RESET_EN_RX_HI_Pos = 0x10
	// Bit mask of RX_ADC_RESET_EN_RX_HI field.
	XCVR_TSM_TIMING28_RX_ADC_RESET_EN_RX_HI_Msk = 0xff0000
	// Position of RX_ADC_RESET_EN_RX_LO field.
	XCVR_TSM_TIMING28_RX_ADC_RESET_EN_RX_LO_Pos = 0x18
	// Bit mask of RX_ADC_RESET_EN_RX_LO field.
	XCVR_TSM_TIMING28_RX_ADC_RESET_EN_RX_LO_Msk = 0xff000000

	// TIMING29: TSM_TIMING29
	// Position of RX_BBA_I_Q_EN_RX_HI field.
	XCVR_TSM_TIMING29_RX_BBA_I_Q_EN_RX_HI_Pos = 0x10
	// Bit mask of RX_BBA_I_Q_EN_RX_HI field.
	XCVR_TSM_TIMING29_RX_BBA_I_Q_EN_RX_HI_Msk = 0xff0000
	// Position of RX_BBA_I_Q_EN_RX_LO field.
	XCVR_TSM_TIMING29_RX_BBA_I_Q_EN_RX_LO_Pos = 0x18
	// Bit mask of RX_BBA_I_Q_EN_RX_LO field.
	XCVR_TSM_TIMING29_RX_BBA_I_Q_EN_RX_LO_Msk = 0xff000000

	// TIMING30: TSM_TIMING30
	// Position of RX_BBA_PDET_EN_RX_HI field.
	XCVR_TSM_TIMING30_RX_BBA_PDET_EN_RX_HI_Pos = 0x10
	// Bit mask of RX_BBA_PDET_EN_RX_HI field.
	XCVR_TSM_TIMING30_RX_BBA_PDET_EN_RX_HI_Msk = 0xff0000
	// Position of RX_BBA_PDET_EN_RX_LO field.
	XCVR_TSM_TIMING30_RX_BBA_PDET_EN_RX_LO_Pos = 0x18
	// Bit mask of RX_BBA_PDET_EN_RX_LO field.
	XCVR_TSM_TIMING30_RX_BBA_PDET_EN_RX_LO_Msk = 0xff000000

	// TIMING31: TSM_TIMING31
	// Position of RX_BBA_TZA_DCOC_EN_RX_HI field.
	XCVR_TSM_TIMING31_RX_BBA_TZA_DCOC_EN_RX_HI_Pos = 0x10
	// Bit mask of RX_BBA_TZA_DCOC_EN_RX_HI field.
	XCVR_TSM_TIMING31_RX_BBA_TZA_DCOC_EN_RX_HI_Msk = 0xff0000
	// Position of RX_BBA_TZA_DCOC_EN_RX_LO field.
	XCVR_TSM_TIMING31_RX_BBA_TZA_DCOC_EN_RX_LO_Pos = 0x18
	// Bit mask of RX_BBA_TZA_DCOC_EN_RX_LO field.
	XCVR_TSM_TIMING31_RX_BBA_TZA_DCOC_EN_RX_LO_Msk = 0xff000000

	// TIMING32: TSM_TIMING32
	// Position of RX_TZA_I_Q_EN_RX_HI field.
	XCVR_TSM_TIMING32_RX_TZA_I_Q_EN_RX_HI_Pos = 0x10
	// Bit mask of RX_TZA_I_Q_EN_RX_HI field.
	XCVR_TSM_TIMING32_RX_TZA_I_Q_EN_RX_HI_Msk = 0xff0000
	// Position of RX_TZA_I_Q_EN_RX_LO field.
	XCVR_TSM_TIMING32_RX_TZA_I_Q_EN_RX_LO_Pos = 0x18
	// Bit mask of RX_TZA_I_Q_EN_RX_LO field.
	XCVR_TSM_TIMING32_RX_TZA_I_Q_EN_RX_LO_Msk = 0xff000000

	// TIMING33: TSM_TIMING33
	// Position of RX_TZA_PDET_EN_RX_HI field.
	XCVR_TSM_TIMING33_RX_TZA_PDET_EN_RX_HI_Pos = 0x10
	// Bit mask of RX_TZA_PDET_EN_RX_HI field.
	XCVR_TSM_TIMING33_RX_TZA_PDET_EN_RX_HI_Msk = 0xff0000
	// Position of RX_TZA_PDET_EN_RX_LO field.
	XCVR_TSM_TIMING33_RX_TZA_PDET_EN_RX_LO_Pos = 0x18
	// Bit mask of RX_TZA_PDET_EN_RX_LO field.
	XCVR_TSM_TIMING33_RX_TZA_PDET_EN_RX_LO_Msk = 0xff000000

	// TIMING34: TSM_TIMING34
	// Position of PLL_DIG_EN_TX_HI field.
	XCVR_TSM_TIMING34_PLL_DIG_EN_TX_HI_Pos = 0x0
	// Bit mask of PLL_DIG_EN_TX_HI field.
	XCVR_TSM_TIMING34_PLL_DIG_EN_TX_HI_Msk = 0xff
	// Position of PLL_DIG_EN_TX_LO field.
	XCVR_TSM_TIMING34_PLL_DIG_EN_TX_LO_Pos = 0x8
	// Bit mask of PLL_DIG_EN_TX_LO field.
	XCVR_TSM_TIMING34_PLL_DIG_EN_TX_LO_Msk = 0xff00
	// Position of PLL_DIG_EN_RX_HI field.
	XCVR_TSM_TIMING34_PLL_DIG_EN_RX_HI_Pos = 0x10
	// Bit mask of PLL_DIG_EN_RX_HI field.
	XCVR_TSM_TIMING34_PLL_DIG_EN_RX_HI_Msk = 0xff0000
	// Position of PLL_DIG_EN_RX_LO field.
	XCVR_TSM_TIMING34_PLL_DIG_EN_RX_LO_Pos = 0x18
	// Bit mask of PLL_DIG_EN_RX_LO field.
	XCVR_TSM_TIMING34_PLL_DIG_EN_RX_LO_Msk = 0xff000000

	// TIMING35: TSM_TIMING35
	// Position of TX_DIG_EN_TX_HI field.
	XCVR_TSM_TIMING35_TX_DIG_EN_TX_HI_Pos = 0x0
	// Bit mask of TX_DIG_EN_TX_HI field.
	XCVR_TSM_TIMING35_TX_DIG_EN_TX_HI_Msk = 0xff
	// Position of TX_DIG_EN_TX_LO field.
	XCVR_TSM_TIMING35_TX_DIG_EN_TX_LO_Pos = 0x8
	// Bit mask of TX_DIG_EN_TX_LO field.
	XCVR_TSM_TIMING35_TX_DIG_EN_TX_LO_Msk = 0xff00

	// TIMING36: TSM_TIMING36
	// Position of RX_DIG_EN_RX_HI field.
	XCVR_TSM_TIMING36_RX_DIG_EN_RX_HI_Pos = 0x10
	// Bit mask of RX_DIG_EN_RX_HI field.
	XCVR_TSM_TIMING36_RX_DIG_EN_RX_HI_Msk = 0xff0000
	// Position of RX_DIG_EN_RX_LO field.
	XCVR_TSM_TIMING36_RX_DIG_EN_RX_LO_Pos = 0x18
	// Bit mask of RX_DIG_EN_RX_LO field.
	XCVR_TSM_TIMING36_RX_DIG_EN_RX_LO_Msk = 0xff000000

	// TIMING37: TSM_TIMING37
	// Position of RX_INIT_RX_HI field.
	XCVR_TSM_TIMING37_RX_INIT_RX_HI_Pos = 0x10
	// Bit mask of RX_INIT_RX_HI field.
	XCVR_TSM_TIMING37_RX_INIT_RX_HI_Msk = 0xff0000
	// Position of RX_INIT_RX_LO field.
	XCVR_TSM_TIMING37_RX_INIT_RX_LO_Pos = 0x18
	// Bit mask of RX_INIT_RX_LO field.
	XCVR_TSM_TIMING37_RX_INIT_RX_LO_Msk = 0xff000000

	// TIMING38: TSM_TIMING38
	// Position of SIGMA_DELTA_EN_TX_HI field.
	XCVR_TSM_TIMING38_SIGMA_DELTA_EN_TX_HI_Pos = 0x0
	// Bit mask of SIGMA_DELTA_EN_TX_HI field.
	XCVR_TSM_TIMING38_SIGMA_DELTA_EN_TX_HI_Msk = 0xff
	// Position of SIGMA_DELTA_EN_TX_LO field.
	XCVR_TSM_TIMING38_SIGMA_DELTA_EN_TX_LO_Pos = 0x8
	// Bit mask of SIGMA_DELTA_EN_TX_LO field.
	XCVR_TSM_TIMING38_SIGMA_DELTA_EN_TX_LO_Msk = 0xff00
	// Position of SIGMA_DELTA_EN_RX_HI field.
	XCVR_TSM_TIMING38_SIGMA_DELTA_EN_RX_HI_Pos = 0x10
	// Bit mask of SIGMA_DELTA_EN_RX_HI field.
	XCVR_TSM_TIMING38_SIGMA_DELTA_EN_RX_HI_Msk = 0xff0000
	// Position of SIGMA_DELTA_EN_RX_LO field.
	XCVR_TSM_TIMING38_SIGMA_DELTA_EN_RX_LO_Pos = 0x18
	// Bit mask of SIGMA_DELTA_EN_RX_LO field.
	XCVR_TSM_TIMING38_SIGMA_DELTA_EN_RX_LO_Msk = 0xff000000

	// TIMING39: TSM_TIMING39
	// Position of RX_PHY_EN_RX_HI field.
	XCVR_TSM_TIMING39_RX_PHY_EN_RX_HI_Pos = 0x10
	// Bit mask of RX_PHY_EN_RX_HI field.
	XCVR_TSM_TIMING39_RX_PHY_EN_RX_HI_Msk = 0xff0000
	// Position of RX_PHY_EN_RX_LO field.
	XCVR_TSM_TIMING39_RX_PHY_EN_RX_LO_Pos = 0x18
	// Bit mask of RX_PHY_EN_RX_LO field.
	XCVR_TSM_TIMING39_RX_PHY_EN_RX_LO_Msk = 0xff000000

	// TIMING40: TSM_TIMING40
	// Position of DCOC_EN_RX_HI field.
	XCVR_TSM_TIMING40_DCOC_EN_RX_HI_Pos = 0x10
	// Bit mask of DCOC_EN_RX_HI field.
	XCVR_TSM_TIMING40_DCOC_EN_RX_HI_Msk = 0xff0000
	// Position of DCOC_EN_RX_LO field.
	XCVR_TSM_TIMING40_DCOC_EN_RX_LO_Pos = 0x18
	// Bit mask of DCOC_EN_RX_LO field.
	XCVR_TSM_TIMING40_DCOC_EN_RX_LO_Msk = 0xff000000

	// TIMING41: TSM_TIMING41
	// Position of DCOC_INIT_RX_HI field.
	XCVR_TSM_TIMING41_DCOC_INIT_RX_HI_Pos = 0x10
	// Bit mask of DCOC_INIT_RX_HI field.
	XCVR_TSM_TIMING41_DCOC_INIT_RX_HI_Msk = 0xff0000
	// Position of DCOC_INIT_RX_LO field.
	XCVR_TSM_TIMING41_DCOC_INIT_RX_LO_Pos = 0x18
	// Bit mask of DCOC_INIT_RX_LO field.
	XCVR_TSM_TIMING41_DCOC_INIT_RX_LO_Msk = 0xff000000

	// TIMING42: TSM_TIMING42
	// Position of SAR_ADC_TRIG_EN_TX_HI field.
	XCVR_TSM_TIMING42_SAR_ADC_TRIG_EN_TX_HI_Pos = 0x0
	// Bit mask of SAR_ADC_TRIG_EN_TX_HI field.
	XCVR_TSM_TIMING42_SAR_ADC_TRIG_EN_TX_HI_Msk = 0xff
	// Position of SAR_ADC_TRIG_EN_TX_LO field.
	XCVR_TSM_TIMING42_SAR_ADC_TRIG_EN_TX_LO_Pos = 0x8
	// Bit mask of SAR_ADC_TRIG_EN_TX_LO field.
	XCVR_TSM_TIMING42_SAR_ADC_TRIG_EN_TX_LO_Msk = 0xff00
	// Position of SAR_ADC_TRIG_EN_RX_HI field.
	XCVR_TSM_TIMING42_SAR_ADC_TRIG_EN_RX_HI_Pos = 0x10
	// Bit mask of SAR_ADC_TRIG_EN_RX_HI field.
	XCVR_TSM_TIMING42_SAR_ADC_TRIG_EN_RX_HI_Msk = 0xff0000
	// Position of SAR_ADC_TRIG_EN_RX_LO field.
	XCVR_TSM_TIMING42_SAR_ADC_TRIG_EN_RX_LO_Pos = 0x18
	// Bit mask of SAR_ADC_TRIG_EN_RX_LO field.
	XCVR_TSM_TIMING42_SAR_ADC_TRIG_EN_RX_LO_Msk = 0xff000000

	// TIMING43: TSM_TIMING43
	// Position of TSM_SPARE0_EN_TX_HI field.
	XCVR_TSM_TIMING43_TSM_SPARE0_EN_TX_HI_Pos = 0x0
	// Bit mask of TSM_SPARE0_EN_TX_HI field.
	XCVR_TSM_TIMING43_TSM_SPARE0_EN_TX_HI_Msk = 0xff
	// Position of TSM_SPARE0_EN_TX_LO field.
	XCVR_TSM_TIMING43_TSM_SPARE0_EN_TX_LO_Pos = 0x8
	// Bit mask of TSM_SPARE0_EN_TX_LO field.
	XCVR_TSM_TIMING43_TSM_SPARE0_EN_TX_LO_Msk = 0xff00
	// Position of TSM_SPARE0_EN_RX_HI field.
	XCVR_TSM_TIMING43_TSM_SPARE0_EN_RX_HI_Pos = 0x10
	// Bit mask of TSM_SPARE0_EN_RX_HI field.
	XCVR_TSM_TIMING43_TSM_SPARE0_EN_RX_HI_Msk = 0xff0000
	// Position of TSM_SPARE0_EN_RX_LO field.
	XCVR_TSM_TIMING43_TSM_SPARE0_EN_RX_LO_Pos = 0x18
	// Bit mask of TSM_SPARE0_EN_RX_LO field.
	XCVR_TSM_TIMING43_TSM_SPARE0_EN_RX_LO_Msk = 0xff000000

	// TIMING44: TSM_TIMING44
	// Position of TSM_SPARE1_EN_TX_HI field.
	XCVR_TSM_TIMING44_TSM_SPARE1_EN_TX_HI_Pos = 0x0
	// Bit mask of TSM_SPARE1_EN_TX_HI field.
	XCVR_TSM_TIMING44_TSM_SPARE1_EN_TX_HI_Msk = 0xff
	// Position of TSM_SPARE1_EN_TX_LO field.
	XCVR_TSM_TIMING44_TSM_SPARE1_EN_TX_LO_Pos = 0x8
	// Bit mask of TSM_SPARE1_EN_TX_LO field.
	XCVR_TSM_TIMING44_TSM_SPARE1_EN_TX_LO_Msk = 0xff00
	// Position of TSM_SPARE1_EN_RX_HI field.
	XCVR_TSM_TIMING44_TSM_SPARE1_EN_RX_HI_Pos = 0x10
	// Bit mask of TSM_SPARE1_EN_RX_HI field.
	XCVR_TSM_TIMING44_TSM_SPARE1_EN_RX_HI_Msk = 0xff0000
	// Position of TSM_SPARE1_EN_RX_LO field.
	XCVR_TSM_TIMING44_TSM_SPARE1_EN_RX_LO_Pos = 0x18
	// Bit mask of TSM_SPARE1_EN_RX_LO field.
	XCVR_TSM_TIMING44_TSM_SPARE1_EN_RX_LO_Msk = 0xff000000

	// TIMING45: TSM_TIMING45
	// Position of TSM_SPARE2_EN_TX_HI field.
	XCVR_TSM_TIMING45_TSM_SPARE2_EN_TX_HI_Pos = 0x0
	// Bit mask of TSM_SPARE2_EN_TX_HI field.
	XCVR_TSM_TIMING45_TSM_SPARE2_EN_TX_HI_Msk = 0xff
	// Position of TSM_SPARE2_EN_TX_LO field.
	XCVR_TSM_TIMING45_TSM_SPARE2_EN_TX_LO_Pos = 0x8
	// Bit mask of TSM_SPARE2_EN_TX_LO field.
	XCVR_TSM_TIMING45_TSM_SPARE2_EN_TX_LO_Msk = 0xff00
	// Position of TSM_SPARE2_EN_RX_HI field.
	XCVR_TSM_TIMING45_TSM_SPARE2_EN_RX_HI_Pos = 0x10
	// Bit mask of TSM_SPARE2_EN_RX_HI field.
	XCVR_TSM_TIMING45_TSM_SPARE2_EN_RX_HI_Msk = 0xff0000
	// Position of TSM_SPARE2_EN_RX_LO field.
	XCVR_TSM_TIMING45_TSM_SPARE2_EN_RX_LO_Pos = 0x18
	// Bit mask of TSM_SPARE2_EN_RX_LO field.
	XCVR_TSM_TIMING45_TSM_SPARE2_EN_RX_LO_Msk = 0xff000000

	// TIMING46: TSM_TIMING46
	// Position of TSM_SPARE3_EN_TX_HI field.
	XCVR_TSM_TIMING46_TSM_SPARE3_EN_TX_HI_Pos = 0x0
	// Bit mask of TSM_SPARE3_EN_TX_HI field.
	XCVR_TSM_TIMING46_TSM_SPARE3_EN_TX_HI_Msk = 0xff
	// Position of TSM_SPARE3_EN_TX_LO field.
	XCVR_TSM_TIMING46_TSM_SPARE3_EN_TX_LO_Pos = 0x8
	// Bit mask of TSM_SPARE3_EN_TX_LO field.
	XCVR_TSM_TIMING46_TSM_SPARE3_EN_TX_LO_Msk = 0xff00
	// Position of TSM_SPARE3_EN_RX_HI field.
	XCVR_TSM_TIMING46_TSM_SPARE3_EN_RX_HI_Pos = 0x10
	// Bit mask of TSM_SPARE3_EN_RX_HI field.
	XCVR_TSM_TIMING46_TSM_SPARE3_EN_RX_HI_Msk = 0xff0000
	// Position of TSM_SPARE3_EN_RX_LO field.
	XCVR_TSM_TIMING46_TSM_SPARE3_EN_RX_LO_Pos = 0x18
	// Bit mask of TSM_SPARE3_EN_RX_LO field.
	XCVR_TSM_TIMING46_TSM_SPARE3_EN_RX_LO_Msk = 0xff000000

	// TIMING47: TSM_TIMING47
	// Position of GPIO0_TRIG_EN_TX_HI field.
	XCVR_TSM_TIMING47_GPIO0_TRIG_EN_TX_HI_Pos = 0x0
	// Bit mask of GPIO0_TRIG_EN_TX_HI field.
	XCVR_TSM_TIMING47_GPIO0_TRIG_EN_TX_HI_Msk = 0xff
	// Position of GPIO0_TRIG_EN_TX_LO field.
	XCVR_TSM_TIMING47_GPIO0_TRIG_EN_TX_LO_Pos = 0x8
	// Bit mask of GPIO0_TRIG_EN_TX_LO field.
	XCVR_TSM_TIMING47_GPIO0_TRIG_EN_TX_LO_Msk = 0xff00
	// Position of GPIO0_TRIG_EN_RX_HI field.
	XCVR_TSM_TIMING47_GPIO0_TRIG_EN_RX_HI_Pos = 0x10
	// Bit mask of GPIO0_TRIG_EN_RX_HI field.
	XCVR_TSM_TIMING47_GPIO0_TRIG_EN_RX_HI_Msk = 0xff0000
	// Position of GPIO0_TRIG_EN_RX_LO field.
	XCVR_TSM_TIMING47_GPIO0_TRIG_EN_RX_LO_Pos = 0x18
	// Bit mask of GPIO0_TRIG_EN_RX_LO field.
	XCVR_TSM_TIMING47_GPIO0_TRIG_EN_RX_LO_Msk = 0xff000000

	// TIMING48: TSM_TIMING48
	// Position of GPIO1_TRIG_EN_TX_HI field.
	XCVR_TSM_TIMING48_GPIO1_TRIG_EN_TX_HI_Pos = 0x0
	// Bit mask of GPIO1_TRIG_EN_TX_HI field.
	XCVR_TSM_TIMING48_GPIO1_TRIG_EN_TX_HI_Msk = 0xff
	// Position of GPIO1_TRIG_EN_TX_LO field.
	XCVR_TSM_TIMING48_GPIO1_TRIG_EN_TX_LO_Pos = 0x8
	// Bit mask of GPIO1_TRIG_EN_TX_LO field.
	XCVR_TSM_TIMING48_GPIO1_TRIG_EN_TX_LO_Msk = 0xff00
	// Position of GPIO1_TRIG_EN_RX_HI field.
	XCVR_TSM_TIMING48_GPIO1_TRIG_EN_RX_HI_Pos = 0x10
	// Bit mask of GPIO1_TRIG_EN_RX_HI field.
	XCVR_TSM_TIMING48_GPIO1_TRIG_EN_RX_HI_Msk = 0xff0000
	// Position of GPIO1_TRIG_EN_RX_LO field.
	XCVR_TSM_TIMING48_GPIO1_TRIG_EN_RX_LO_Pos = 0x18
	// Bit mask of GPIO1_TRIG_EN_RX_LO field.
	XCVR_TSM_TIMING48_GPIO1_TRIG_EN_RX_LO_Msk = 0xff000000

	// TIMING49: TSM_TIMING49
	// Position of GPIO2_TRIG_EN_TX_HI field.
	XCVR_TSM_TIMING49_GPIO2_TRIG_EN_TX_HI_Pos = 0x0
	// Bit mask of GPIO2_TRIG_EN_TX_HI field.
	XCVR_TSM_TIMING49_GPIO2_TRIG_EN_TX_HI_Msk = 0xff
	// Position of GPIO2_TRIG_EN_TX_LO field.
	XCVR_TSM_TIMING49_GPIO2_TRIG_EN_TX_LO_Pos = 0x8
	// Bit mask of GPIO2_TRIG_EN_TX_LO field.
	XCVR_TSM_TIMING49_GPIO2_TRIG_EN_TX_LO_Msk = 0xff00
	// Position of GPIO2_TRIG_EN_RX_HI field.
	XCVR_TSM_TIMING49_GPIO2_TRIG_EN_RX_HI_Pos = 0x10
	// Bit mask of GPIO2_TRIG_EN_RX_HI field.
	XCVR_TSM_TIMING49_GPIO2_TRIG_EN_RX_HI_Msk = 0xff0000
	// Position of GPIO2_TRIG_EN_RX_LO field.
	XCVR_TSM_TIMING49_GPIO2_TRIG_EN_RX_LO_Pos = 0x18
	// Bit mask of GPIO2_TRIG_EN_RX_LO field.
	XCVR_TSM_TIMING49_GPIO2_TRIG_EN_RX_LO_Msk = 0xff000000

	// TIMING50: TSM_TIMING50
	// Position of GPIO3_TRIG_EN_TX_HI field.
	XCVR_TSM_TIMING50_GPIO3_TRIG_EN_TX_HI_Pos = 0x0
	// Bit mask of GPIO3_TRIG_EN_TX_HI field.
	XCVR_TSM_TIMING50_GPIO3_TRIG_EN_TX_HI_Msk = 0xff
	// Position of GPIO3_TRIG_EN_TX_LO field.
	XCVR_TSM_TIMING50_GPIO3_TRIG_EN_TX_LO_Pos = 0x8
	// Bit mask of GPIO3_TRIG_EN_TX_LO field.
	XCVR_TSM_TIMING50_GPIO3_TRIG_EN_TX_LO_Msk = 0xff00
	// Position of GPIO3_TRIG_EN_RX_HI field.
	XCVR_TSM_TIMING50_GPIO3_TRIG_EN_RX_HI_Pos = 0x10
	// Bit mask of GPIO3_TRIG_EN_RX_HI field.
	XCVR_TSM_TIMING50_GPIO3_TRIG_EN_RX_HI_Msk = 0xff0000
	// Position of GPIO3_TRIG_EN_RX_LO field.
	XCVR_TSM_TIMING50_GPIO3_TRIG_EN_RX_LO_Pos = 0x18
	// Bit mask of GPIO3_TRIG_EN_RX_LO field.
	XCVR_TSM_TIMING50_GPIO3_TRIG_EN_RX_LO_Msk = 0xff000000

	// TIMING51: TSM_TIMING51
	// Position of RXTX_AUXPLL_BIAS_EN_RX_HI field.
	XCVR_TSM_TIMING51_RXTX_AUXPLL_BIAS_EN_RX_HI_Pos = 0x10
	// Bit mask of RXTX_AUXPLL_BIAS_EN_RX_HI field.
	XCVR_TSM_TIMING51_RXTX_AUXPLL_BIAS_EN_RX_HI_Msk = 0xff0000
	// Position of RXTX_AUXPLL_BIAS_EN_RX_LO field.
	XCVR_TSM_TIMING51_RXTX_AUXPLL_BIAS_EN_RX_LO_Pos = 0x18
	// Bit mask of RXTX_AUXPLL_BIAS_EN_RX_LO field.
	XCVR_TSM_TIMING51_RXTX_AUXPLL_BIAS_EN_RX_LO_Msk = 0xff000000

	// TIMING52: TSM_TIMING52
	// Position of RXTX_AUXPLL_FCAL_EN_RX_HI field.
	XCVR_TSM_TIMING52_RXTX_AUXPLL_FCAL_EN_RX_HI_Pos = 0x10
	// Bit mask of RXTX_AUXPLL_FCAL_EN_RX_HI field.
	XCVR_TSM_TIMING52_RXTX_AUXPLL_FCAL_EN_RX_HI_Msk = 0xff0000
	// Position of RXTX_AUXPLL_FCAL_EN_RX_LO field.
	XCVR_TSM_TIMING52_RXTX_AUXPLL_FCAL_EN_RX_LO_Pos = 0x18
	// Bit mask of RXTX_AUXPLL_FCAL_EN_RX_LO field.
	XCVR_TSM_TIMING52_RXTX_AUXPLL_FCAL_EN_RX_LO_Msk = 0xff000000

	// TIMING53: TSM_TIMING53
	// Position of RXTX_AUXPLL_LF_PD_EN_RX_HI field.
	XCVR_TSM_TIMING53_RXTX_AUXPLL_LF_PD_EN_RX_HI_Pos = 0x10
	// Bit mask of RXTX_AUXPLL_LF_PD_EN_RX_HI field.
	XCVR_TSM_TIMING53_RXTX_AUXPLL_LF_PD_EN_RX_HI_Msk = 0xff0000
	// Position of RXTX_AUXPLL_LF_PD_EN_RX_LO field.
	XCVR_TSM_TIMING53_RXTX_AUXPLL_LF_PD_EN_RX_LO_Pos = 0x18
	// Bit mask of RXTX_AUXPLL_LF_PD_EN_RX_LO field.
	XCVR_TSM_TIMING53_RXTX_AUXPLL_LF_PD_EN_RX_LO_Msk = 0xff000000

	// TIMING54: TSM_TIMING54
	// Position of RXTX_AUXPLL_PD_LF_FILTER_CHARGE_EN_RX_HI field.
	XCVR_TSM_TIMING54_RXTX_AUXPLL_PD_LF_FILTER_CHARGE_EN_RX_HI_Pos = 0x10
	// Bit mask of RXTX_AUXPLL_PD_LF_FILTER_CHARGE_EN_RX_HI field.
	XCVR_TSM_TIMING54_RXTX_AUXPLL_PD_LF_FILTER_CHARGE_EN_RX_HI_Msk = 0xff0000
	// Position of RXTX_AUXPLL_PD_LF_FILTER_CHARGE_EN_RX_LO field.
	XCVR_TSM_TIMING54_RXTX_AUXPLL_PD_LF_FILTER_CHARGE_EN_RX_LO_Pos = 0x18
	// Bit mask of RXTX_AUXPLL_PD_LF_FILTER_CHARGE_EN_RX_LO field.
	XCVR_TSM_TIMING54_RXTX_AUXPLL_PD_LF_FILTER_CHARGE_EN_RX_LO_Msk = 0xff000000

	// TIMING55: TSM_TIMING55
	// Position of RXTX_AUXPLL_ADC_BUF_EN_RX_HI field.
	XCVR_TSM_TIMING55_RXTX_AUXPLL_ADC_BUF_EN_RX_HI_Pos = 0x10
	// Bit mask of RXTX_AUXPLL_ADC_BUF_EN_RX_HI field.
	XCVR_TSM_TIMING55_RXTX_AUXPLL_ADC_BUF_EN_RX_HI_Msk = 0xff0000
	// Position of RXTX_AUXPLL_ADC_BUF_EN_RX_LO field.
	XCVR_TSM_TIMING55_RXTX_AUXPLL_ADC_BUF_EN_RX_LO_Pos = 0x18
	// Bit mask of RXTX_AUXPLL_ADC_BUF_EN_RX_LO field.
	XCVR_TSM_TIMING55_RXTX_AUXPLL_ADC_BUF_EN_RX_LO_Msk = 0xff000000

	// TIMING56: TSM_TIMING56
	// Position of RXTX_AUXPLL_DIG_BUF_EN_RX_HI field.
	XCVR_TSM_TIMING56_RXTX_AUXPLL_DIG_BUF_EN_RX_HI_Pos = 0x10
	// Bit mask of RXTX_AUXPLL_DIG_BUF_EN_RX_HI field.
	XCVR_TSM_TIMING56_RXTX_AUXPLL_DIG_BUF_EN_RX_HI_Msk = 0xff0000
	// Position of RXTX_AUXPLL_DIG_BUF_EN_RX_LO field.
	XCVR_TSM_TIMING56_RXTX_AUXPLL_DIG_BUF_EN_RX_LO_Pos = 0x18
	// Bit mask of RXTX_AUXPLL_DIG_BUF_EN_RX_LO field.
	XCVR_TSM_TIMING56_RXTX_AUXPLL_DIG_BUF_EN_RX_LO_Msk = 0xff000000

	// TIMING57: TSM_TIMING57
	// Position of RXTX_RCCAL_EN_RX_HI field.
	XCVR_TSM_TIMING57_RXTX_RCCAL_EN_RX_HI_Pos = 0x10
	// Bit mask of RXTX_RCCAL_EN_RX_HI field.
	XCVR_TSM_TIMING57_RXTX_RCCAL_EN_RX_HI_Msk = 0xff0000
	// Position of RXTX_RCCAL_EN_RX_LO field.
	XCVR_TSM_TIMING57_RXTX_RCCAL_EN_RX_LO_Pos = 0x18
	// Bit mask of RXTX_RCCAL_EN_RX_LO field.
	XCVR_TSM_TIMING57_RXTX_RCCAL_EN_RX_LO_Msk = 0xff000000

	// TIMING58: TSM_TIMING58
	// Position of TX_HPM_DAC_EN_TX_HI field.
	XCVR_TSM_TIMING58_TX_HPM_DAC_EN_TX_HI_Pos = 0x0
	// Bit mask of TX_HPM_DAC_EN_TX_HI field.
	XCVR_TSM_TIMING58_TX_HPM_DAC_EN_TX_HI_Msk = 0xff
	// Position of TX_HPM_DAC_EN_TX_LO field.
	XCVR_TSM_TIMING58_TX_HPM_DAC_EN_TX_LO_Pos = 0x8
	// Bit mask of TX_HPM_DAC_EN_TX_LO field.
	XCVR_TSM_TIMING58_TX_HPM_DAC_EN_TX_LO_Msk = 0xff00
)

// Bitfields for XCVR_PHY: XCVR_PHY
const (
	// PHY_PRE_REF0: PREAMBLE REFERENCE WAVEFORM 0
	// Position of FSK_PREAMBLE_REF0 field.
	XCVR_PHY_PHY_PRE_REF0_FSK_PREAMBLE_REF0_Pos = 0x0
	// Bit mask of FSK_PREAMBLE_REF0 field.
	XCVR_PHY_PHY_PRE_REF0_FSK_PREAMBLE_REF0_Msk = 0xffffffff

	// PRE_REF1: PREAMBLE REFERENCE WAVEFORM 1
	// Position of FSK_PREAMBLE_REF1 field.
	XCVR_PHY_PRE_REF1_FSK_PREAMBLE_REF1_Pos = 0x0
	// Bit mask of FSK_PREAMBLE_REF1 field.
	XCVR_PHY_PRE_REF1_FSK_PREAMBLE_REF1_Msk = 0xffffffff

	// PRE_REF2: PREAMBLE REFERENCE WAVEFORM 2
	// Position of FSK_PREAMBLE_REF2 field.
	XCVR_PHY_PRE_REF2_FSK_PREAMBLE_REF2_Pos = 0x0
	// Bit mask of FSK_PREAMBLE_REF2 field.
	XCVR_PHY_PRE_REF2_FSK_PREAMBLE_REF2_Msk = 0xffff

	// CFG1: PHY CONFIGURATION REGISTER 1
	// Position of AA_PLAYBACK field.
	XCVR_PHY_CFG1_AA_PLAYBACK_Pos = 0x1
	// Bit mask of AA_PLAYBACK field.
	XCVR_PHY_CFG1_AA_PLAYBACK_Msk = 0x2
	// Bit AA_PLAYBACK.
	XCVR_PHY_CFG1_AA_PLAYBACK = 0x2
	// Position of AA_OUTPUT_SEL field.
	XCVR_PHY_CFG1_AA_OUTPUT_SEL_Pos = 0x2
	// Bit mask of AA_OUTPUT_SEL field.
	XCVR_PHY_CFG1_AA_OUTPUT_SEL_Msk = 0x4
	// Bit AA_OUTPUT_SEL.
	XCVR_PHY_CFG1_AA_OUTPUT_SEL = 0x4
	// demodulated
	XCVR_PHY_CFG1_AA_OUTPUT_SEL_0 = 0x0
	// matched
	XCVR_PHY_CFG1_AA_OUTPUT_SEL_1 = 0x1
	// Position of FSK_BIT_INVERT field.
	XCVR_PHY_CFG1_FSK_BIT_INVERT_Pos = 0x3
	// Bit mask of FSK_BIT_INVERT field.
	XCVR_PHY_CFG1_FSK_BIT_INVERT_Msk = 0x8
	// Bit FSK_BIT_INVERT.
	XCVR_PHY_CFG1_FSK_BIT_INVERT = 0x8
	// Position of RFU00 field.
	XCVR_PHY_CFG1_RFU00_Pos = 0x4
	// Bit mask of RFU00 field.
	XCVR_PHY_CFG1_RFU00_Msk = 0x10
	// Bit RFU00.
	XCVR_PHY_CFG1_RFU00 = 0x10
	// Position of BSM_EN_BLE field.
	XCVR_PHY_CFG1_BSM_EN_BLE_Pos = 0x5
	// Bit mask of BSM_EN_BLE field.
	XCVR_PHY_CFG1_BSM_EN_BLE_Msk = 0x20
	// Bit BSM_EN_BLE.
	XCVR_PHY_CFG1_BSM_EN_BLE = 0x20
	// BSM for BLE disabled
	XCVR_PHY_CFG1_BSM_EN_BLE_0 = 0x0
	// BSM for BLE enabled
	XCVR_PHY_CFG1_BSM_EN_BLE_1 = 0x1
	// Position of DEMOD_CLK_MODE field.
	XCVR_PHY_CFG1_DEMOD_CLK_MODE_Pos = 0x6
	// Bit mask of DEMOD_CLK_MODE field.
	XCVR_PHY_CFG1_DEMOD_CLK_MODE_Msk = 0xc0
	// Normal
	XCVR_PHY_CFG1_DEMOD_CLK_MODE_0 = 0x0
	// Demodulate all samples
	XCVR_PHY_CFG1_DEMOD_CLK_MODE_1 = 0x1
	// Position of CTS_THRESH field.
	XCVR_PHY_CFG1_CTS_THRESH_Pos = 0x8
	// Bit mask of CTS_THRESH field.
	XCVR_PHY_CFG1_CTS_THRESH_Msk = 0xff00
	// Position of FSK_FTS_TIMEOUT field.
	XCVR_PHY_CFG1_FSK_FTS_TIMEOUT_Pos = 0x14
	// Bit mask of FSK_FTS_TIMEOUT field.
	XCVR_PHY_CFG1_FSK_FTS_TIMEOUT_Msk = 0x700000
	// 4 symbols
	XCVR_PHY_CFG1_FSK_FTS_TIMEOUT_0 = 0x0
	// 5 symbols
	XCVR_PHY_CFG1_FSK_FTS_TIMEOUT_1 = 0x1
	// 6 symbols
	XCVR_PHY_CFG1_FSK_FTS_TIMEOUT_2 = 0x2
	// 7 symbols
	XCVR_PHY_CFG1_FSK_FTS_TIMEOUT_3 = 0x3
	// 8 symbols
	XCVR_PHY_CFG1_FSK_FTS_TIMEOUT_4 = 0x4
	// 9 symbols
	XCVR_PHY_CFG1_FSK_FTS_TIMEOUT_5 = 0x5
	// 10 symbols
	XCVR_PHY_CFG1_FSK_FTS_TIMEOUT_6 = 0x6
	// 11 symbols
	XCVR_PHY_CFG1_FSK_FTS_TIMEOUT_7 = 0x7
	// Position of RFU01 field.
	XCVR_PHY_CFG1_RFU01_Pos = 0x18
	// Bit mask of RFU01 field.
	XCVR_PHY_CFG1_RFU01_Msk = 0x1000000
	// Bit RFU01.
	XCVR_PHY_CFG1_RFU01 = 0x1000000
	// Position of RFU02 field.
	XCVR_PHY_CFG1_RFU02_Pos = 0x19
	// Bit mask of RFU02 field.
	XCVR_PHY_CFG1_RFU02_Msk = 0x2000000
	// Bit RFU02.
	XCVR_PHY_CFG1_RFU02 = 0x2000000
	// Position of BLE_NTW_ADR_THR field.
	XCVR_PHY_CFG1_BLE_NTW_ADR_THR_Pos = 0x1c
	// Bit mask of BLE_NTW_ADR_THR field.
	XCVR_PHY_CFG1_BLE_NTW_ADR_THR_Msk = 0x70000000

	// CFG2: PHY CONFIGURATION REGISTER 2
	// Position of PHY_FIFO_PRECHG field.
	XCVR_PHY_CFG2_PHY_FIFO_PRECHG_Pos = 0x0
	// Bit mask of PHY_FIFO_PRECHG field.
	XCVR_PHY_CFG2_PHY_FIFO_PRECHG_Msk = 0xf
	// Position of RFU03 field.
	XCVR_PHY_CFG2_RFU03_Pos = 0x4
	// Bit mask of RFU03 field.
	XCVR_PHY_CFG2_RFU03_Msk = 0x10
	// Bit RFU03.
	XCVR_PHY_CFG2_RFU03 = 0x10
	// Position of RFU04 field.
	XCVR_PHY_CFG2_RFU04_Pos = 0x5
	// Bit mask of RFU04 field.
	XCVR_PHY_CFG2_RFU04_Msk = 0x20
	// Bit RFU04.
	XCVR_PHY_CFG2_RFU04 = 0x20
	// Position of RFU05 field.
	XCVR_PHY_CFG2_RFU05_Pos = 0x6
	// Bit mask of RFU05 field.
	XCVR_PHY_CFG2_RFU05_Msk = 0x40
	// Bit RFU05.
	XCVR_PHY_CFG2_RFU05 = 0x40
	// Position of RFU06 field.
	XCVR_PHY_CFG2_RFU06_Pos = 0x7
	// Bit mask of RFU06 field.
	XCVR_PHY_CFG2_RFU06_Msk = 0x80
	// Bit RFU06.
	XCVR_PHY_CFG2_RFU06 = 0x80
	// Position of X2_DEMOD_GAIN field.
	XCVR_PHY_CFG2_X2_DEMOD_GAIN_Pos = 0x8
	// Bit mask of X2_DEMOD_GAIN field.
	XCVR_PHY_CFG2_X2_DEMOD_GAIN_Msk = 0xf00
	// Position of RFU07 field.
	XCVR_PHY_CFG2_RFU07_Pos = 0x10
	// Bit mask of RFU07 field.
	XCVR_PHY_CFG2_RFU07_Msk = 0x10000
	// Bit RFU07.
	XCVR_PHY_CFG2_RFU07 = 0x10000
	// Position of RFU08 field.
	XCVR_PHY_CFG2_RFU08_Pos = 0x11
	// Bit mask of RFU08 field.
	XCVR_PHY_CFG2_RFU08_Msk = 0x20000
	// Bit RFU08.
	XCVR_PHY_CFG2_RFU08 = 0x20000
	// Position of RFU09 field.
	XCVR_PHY_CFG2_RFU09_Pos = 0x12
	// Bit mask of RFU09 field.
	XCVR_PHY_CFG2_RFU09_Msk = 0x40000
	// Bit RFU09.
	XCVR_PHY_CFG2_RFU09 = 0x40000
	// Position of RFU10 field.
	XCVR_PHY_CFG2_RFU10_Pos = 0x13
	// Bit mask of RFU10 field.
	XCVR_PHY_CFG2_RFU10_Msk = 0x80000
	// Bit RFU10.
	XCVR_PHY_CFG2_RFU10 = 0x80000
	// Position of RFU11 field.
	XCVR_PHY_CFG2_RFU11_Pos = 0x14
	// Bit mask of RFU11 field.
	XCVR_PHY_CFG2_RFU11_Msk = 0x100000
	// Bit RFU11.
	XCVR_PHY_CFG2_RFU11 = 0x100000
	// Position of RFU12 field.
	XCVR_PHY_CFG2_RFU12_Pos = 0x15
	// Bit mask of RFU12 field.
	XCVR_PHY_CFG2_RFU12_Msk = 0x200000
	// Bit RFU12.
	XCVR_PHY_CFG2_RFU12 = 0x200000
	// Position of RFU13 field.
	XCVR_PHY_CFG2_RFU13_Pos = 0x16
	// Bit mask of RFU13 field.
	XCVR_PHY_CFG2_RFU13_Msk = 0x400000
	// Bit RFU13.
	XCVR_PHY_CFG2_RFU13 = 0x400000
	// Position of RFU14 field.
	XCVR_PHY_CFG2_RFU14_Pos = 0x17
	// Bit mask of RFU14 field.
	XCVR_PHY_CFG2_RFU14_Msk = 0x800000
	// Bit RFU14.
	XCVR_PHY_CFG2_RFU14 = 0x800000
	// Position of RFU15 field.
	XCVR_PHY_CFG2_RFU15_Pos = 0x18
	// Bit mask of RFU15 field.
	XCVR_PHY_CFG2_RFU15_Msk = 0x1000000
	// Bit RFU15.
	XCVR_PHY_CFG2_RFU15 = 0x1000000
	// Position of RFU16 field.
	XCVR_PHY_CFG2_RFU16_Pos = 0x19
	// Bit mask of RFU16 field.
	XCVR_PHY_CFG2_RFU16_Msk = 0x2000000
	// Bit RFU16.
	XCVR_PHY_CFG2_RFU16 = 0x2000000
	// Position of PHY_CLK_ON field.
	XCVR_PHY_CFG2_PHY_CLK_ON_Pos = 0x1f
	// Bit mask of PHY_CLK_ON field.
	XCVR_PHY_CFG2_PHY_CLK_ON_Msk = 0x80000000
	// Bit PHY_CLK_ON.
	XCVR_PHY_CFG2_PHY_CLK_ON = 0x80000000
	// PHY clock is enabled by TSM output: rx_phy_en
	XCVR_PHY_CFG2_PHY_CLK_ON_0 = 0x0
	// PHY clock is forced on at all times
	XCVR_PHY_CFG2_PHY_CLK_ON_1 = 0x1

	// EL_CFG: PHY EARLY/LATE CONFIGURATION REGISTER
	// Position of EL_ENABLE field.
	XCVR_PHY_EL_CFG_EL_ENABLE_Pos = 0x0
	// Bit mask of EL_ENABLE field.
	XCVR_PHY_EL_CFG_EL_ENABLE_Msk = 0x1
	// Bit EL_ENABLE.
	XCVR_PHY_EL_CFG_EL_ENABLE = 0x1
	// Disable Early/Late
	XCVR_PHY_EL_CFG_EL_ENABLE_0 = 0x0
	// Enable Early/Late
	XCVR_PHY_EL_CFG_EL_ENABLE_1 = 0x1
	// Position of EL_ZB_ENABLE field.
	XCVR_PHY_EL_CFG_EL_ZB_ENABLE_Pos = 0x1
	// Bit mask of EL_ZB_ENABLE field.
	XCVR_PHY_EL_CFG_EL_ZB_ENABLE_Msk = 0x2
	// Bit EL_ZB_ENABLE.
	XCVR_PHY_EL_CFG_EL_ZB_ENABLE = 0x2
	// Disable Early/Late
	XCVR_PHY_EL_CFG_EL_ZB_ENABLE_0 = 0x0
	// Enable Early/Late
	XCVR_PHY_EL_CFG_EL_ZB_ENABLE_1 = 0x1
	// Position of EL_ZB_WIN_SIZE field.
	XCVR_PHY_EL_CFG_EL_ZB_WIN_SIZE_Pos = 0x2
	// Bit mask of EL_ZB_WIN_SIZE field.
	XCVR_PHY_EL_CFG_EL_ZB_WIN_SIZE_Msk = 0x4
	// Bit EL_ZB_WIN_SIZE.
	XCVR_PHY_EL_CFG_EL_ZB_WIN_SIZE = 0x4
	// 2 symbols
	XCVR_PHY_EL_CFG_EL_ZB_WIN_SIZE_0 = 0x0
	// 3 symbols
	XCVR_PHY_EL_CFG_EL_ZB_WIN_SIZE_1 = 0x1
	// Position of EL_WIN_SIZE field.
	XCVR_PHY_EL_CFG_EL_WIN_SIZE_Pos = 0x8
	// Bit mask of EL_WIN_SIZE field.
	XCVR_PHY_EL_CFG_EL_WIN_SIZE_Msk = 0xf00
	// Position of EL_INTERVAL field.
	XCVR_PHY_EL_CFG_EL_INTERVAL_Pos = 0x10
	// Bit mask of EL_INTERVAL field.
	XCVR_PHY_EL_CFG_EL_INTERVAL_Msk = 0x3f0000

	// NTW_ADR_BSM: PHY NETWORK ADDRESS FOR BSM
	// Position of NTW_ADR_BSM field.
	XCVR_PHY_NTW_ADR_BSM_NTW_ADR_BSM_Pos = 0x0
	// Bit mask of NTW_ADR_BSM field.
	XCVR_PHY_NTW_ADR_BSM_NTW_ADR_BSM_Msk = 0xffffffff

	// STATUS: PHY STATUS REGISTER
	// Position of PREAMBLE_FOUND field.
	XCVR_PHY_STATUS_PREAMBLE_FOUND_Pos = 0x0
	// Bit mask of PREAMBLE_FOUND field.
	XCVR_PHY_STATUS_PREAMBLE_FOUND_Msk = 0x1
	// Bit PREAMBLE_FOUND.
	XCVR_PHY_STATUS_PREAMBLE_FOUND = 0x1
	// Position of AA_SFD_MATCHED field.
	XCVR_PHY_STATUS_AA_SFD_MATCHED_Pos = 0x1
	// Bit mask of AA_SFD_MATCHED field.
	XCVR_PHY_STATUS_AA_SFD_MATCHED_Msk = 0x2
	// Bit AA_SFD_MATCHED.
	XCVR_PHY_STATUS_AA_SFD_MATCHED = 0x2
	// Position of AA_MATCHED field.
	XCVR_PHY_STATUS_AA_MATCHED_Pos = 0x4
	// Bit mask of AA_MATCHED field.
	XCVR_PHY_STATUS_AA_MATCHED_Msk = 0xf0
	// No Network Address has matched
	XCVR_PHY_STATUS_AA_MATCHED_0000 = 0x0
	// Network Address 0 has matched
	XCVR_PHY_STATUS_AA_MATCHED_0001 = 0x1
	// Network Address 1 has matched
	XCVR_PHY_STATUS_AA_MATCHED_0010 = 0x2
	// Network Address 2 has matched
	XCVR_PHY_STATUS_AA_MATCHED_0100 = 0x4
	// Network Address 3 has matched
	XCVR_PHY_STATUS_AA_MATCHED_1000 = 0x8
	// Position of HAMMING_DISTANCE field.
	XCVR_PHY_STATUS_HAMMING_DISTANCE_Pos = 0x8
	// Bit mask of HAMMING_DISTANCE field.
	XCVR_PHY_STATUS_HAMMING_DISTANCE_Msk = 0x700
	// Position of DATA_FIFO_DEPTH field.
	XCVR_PHY_STATUS_DATA_FIFO_DEPTH_Pos = 0xc
	// Bit mask of DATA_FIFO_DEPTH field.
	XCVR_PHY_STATUS_DATA_FIFO_DEPTH_Msk = 0xf000
	// Position of CFO_ESTIMATE field.
	XCVR_PHY_STATUS_CFO_ESTIMATE_Pos = 0x10
	// Bit mask of CFO_ESTIMATE field.
	XCVR_PHY_STATUS_CFO_ESTIMATE_Msk = 0xff0000
)

// Bitfields for XCVR_ZBDEM: XCVR_ZBDEMOD
const (
	// CORR_CTRL: 802.15.4 DEMOD CORRELLATOR CONTROL
	// Position of CORR_VT field.
	XCVR_ZBDEM_CORR_CTRL_CORR_VT_Pos = 0x0
	// Bit mask of CORR_VT field.
	XCVR_ZBDEM_CORR_CTRL_CORR_VT_Msk = 0xff
	// Position of CORR_NVAL field.
	XCVR_ZBDEM_CORR_CTRL_CORR_NVAL_Pos = 0x8
	// Bit mask of CORR_NVAL field.
	XCVR_ZBDEM_CORR_CTRL_CORR_NVAL_Msk = 0x700
	// Position of MAX_CORR_EN field.
	XCVR_ZBDEM_CORR_CTRL_MAX_CORR_EN_Pos = 0xb
	// Bit mask of MAX_CORR_EN field.
	XCVR_ZBDEM_CORR_CTRL_MAX_CORR_EN_Msk = 0x800
	// Bit MAX_CORR_EN.
	XCVR_ZBDEM_CORR_CTRL_MAX_CORR_EN = 0x800
	// Position of ZBDEM_CLK_ON field.
	XCVR_ZBDEM_CORR_CTRL_ZBDEM_CLK_ON_Pos = 0xf
	// Bit mask of ZBDEM_CLK_ON field.
	XCVR_ZBDEM_CORR_CTRL_ZBDEM_CLK_ON_Msk = 0x8000
	// Bit ZBDEM_CLK_ON.
	XCVR_ZBDEM_CORR_CTRL_ZBDEM_CLK_ON = 0x8000
	// Normal Operation
	XCVR_ZBDEM_CORR_CTRL_ZBDEM_CLK_ON_0 = 0x0
	// Force 802.15.4 Demodulator Clock On (debug purposes only)
	XCVR_ZBDEM_CORR_CTRL_ZBDEM_CLK_ON_1 = 0x1
	// Position of RX_MAX_CORR field.
	XCVR_ZBDEM_CORR_CTRL_RX_MAX_CORR_Pos = 0x10
	// Bit mask of RX_MAX_CORR field.
	XCVR_ZBDEM_CORR_CTRL_RX_MAX_CORR_Msk = 0xff0000
	// Position of RX_MAX_PREAMBLE field.
	XCVR_ZBDEM_CORR_CTRL_RX_MAX_PREAMBLE_Pos = 0x18
	// Bit mask of RX_MAX_PREAMBLE field.
	XCVR_ZBDEM_CORR_CTRL_RX_MAX_PREAMBLE_Msk = 0xff000000

	// PN_TYPE: 802.15.4 DEMOD PN TYPE
	// Position of PN_TYPE field.
	XCVR_ZBDEM_PN_TYPE_PN_TYPE_Pos = 0x0
	// Bit mask of PN_TYPE field.
	XCVR_ZBDEM_PN_TYPE_PN_TYPE_Msk = 0x1
	// Bit PN_TYPE.
	XCVR_ZBDEM_PN_TYPE_PN_TYPE = 0x1
	// Position of TX_INV field.
	XCVR_ZBDEM_PN_TYPE_TX_INV_Pos = 0x1
	// Bit mask of TX_INV field.
	XCVR_ZBDEM_PN_TYPE_TX_INV_Msk = 0x2
	// Bit TX_INV.
	XCVR_ZBDEM_PN_TYPE_TX_INV = 0x2

	// PN_CODE: 802.15.4 DEMOD PN CODE
	// Position of PN_LSB field.
	XCVR_ZBDEM_PN_CODE_PN_LSB_Pos = 0x0
	// Bit mask of PN_LSB field.
	XCVR_ZBDEM_PN_CODE_PN_LSB_Msk = 0xffff
	// Position of PN_MSB field.
	XCVR_ZBDEM_PN_CODE_PN_MSB_Pos = 0x10
	// Bit mask of PN_MSB field.
	XCVR_ZBDEM_PN_CODE_PN_MSB_Msk = 0xffff0000

	// SYNC_CTRL: 802.15.4 DEMOD SYMBOL SYNC CONTROL
	// Position of SYNC_PER field.
	XCVR_ZBDEM_SYNC_CTRL_SYNC_PER_Pos = 0x0
	// Bit mask of SYNC_PER field.
	XCVR_ZBDEM_SYNC_CTRL_SYNC_PER_Msk = 0x7
	// Position of TRACK_ENABLE field.
	XCVR_ZBDEM_SYNC_CTRL_TRACK_ENABLE_Pos = 0x3
	// Bit mask of TRACK_ENABLE field.
	XCVR_ZBDEM_SYNC_CTRL_TRACK_ENABLE_Msk = 0x8
	// Bit TRACK_ENABLE.
	XCVR_ZBDEM_SYNC_CTRL_TRACK_ENABLE = 0x8
	// symbol timing synchronization tracking disabled in Rx frontend
	XCVR_ZBDEM_SYNC_CTRL_TRACK_ENABLE_0 = 0x0
	// symbol timing synchronization tracking enabled in Rx frontend (default)
	XCVR_ZBDEM_SYNC_CTRL_TRACK_ENABLE_1 = 0x1

	// CCA_LQI_SRC: 802.15.4 CCA/LQI SOURCE
	// Position of CCA1_FROM_RX_DIG field.
	XCVR_ZBDEM_CCA_LQI_SRC_CCA1_FROM_RX_DIG_Pos = 0x0
	// Bit mask of CCA1_FROM_RX_DIG field.
	XCVR_ZBDEM_CCA_LQI_SRC_CCA1_FROM_RX_DIG_Msk = 0x1
	// Bit CCA1_FROM_RX_DIG.
	XCVR_ZBDEM_CCA_LQI_SRC_CCA1_FROM_RX_DIG = 0x1
	// Use the CCA1 information computed internally in the 802.15.4 Demod
	XCVR_ZBDEM_CCA_LQI_SRC_CCA1_FROM_RX_DIG_0 = 0x0
	// Use the CCA1 information computed by the RX Digital
	XCVR_ZBDEM_CCA_LQI_SRC_CCA1_FROM_RX_DIG_1 = 0x1
	// Position of LQI_FROM_RX_DIG field.
	XCVR_ZBDEM_CCA_LQI_SRC_LQI_FROM_RX_DIG_Pos = 0x1
	// Bit mask of LQI_FROM_RX_DIG field.
	XCVR_ZBDEM_CCA_LQI_SRC_LQI_FROM_RX_DIG_Msk = 0x2
	// Bit LQI_FROM_RX_DIG.
	XCVR_ZBDEM_CCA_LQI_SRC_LQI_FROM_RX_DIG = 0x2
	// Use the LQI information computed internally in the 802.15.4 Demod
	XCVR_ZBDEM_CCA_LQI_SRC_LQI_FROM_RX_DIG_0 = 0x0
	// Use the LQI information computed by the RX Digital
	XCVR_ZBDEM_CCA_LQI_SRC_LQI_FROM_RX_DIG_1 = 0x1
	// Position of LQI_START_AT_SFD field.
	XCVR_ZBDEM_CCA_LQI_SRC_LQI_START_AT_SFD_Pos = 0x2
	// Bit mask of LQI_START_AT_SFD field.
	XCVR_ZBDEM_CCA_LQI_SRC_LQI_START_AT_SFD_Msk = 0x4
	// Bit LQI_START_AT_SFD.
	XCVR_ZBDEM_CCA_LQI_SRC_LQI_START_AT_SFD = 0x4
	// Start LQI computation at Preamble Detection (similar to previous Freescale 802.15.4 products)
	XCVR_ZBDEM_CCA_LQI_SRC_LQI_START_AT_SFD_0 = 0x0
	// Start LQI computation at SFD (Start of Frame Delimiter) Detection
	XCVR_ZBDEM_CCA_LQI_SRC_LQI_START_AT_SFD_1 = 0x1

	// FAD_THR: FAD CORRELATOR THRESHOLD
	// Position of FAD_THR field.
	XCVR_ZBDEM_FAD_THR_FAD_THR_Pos = 0x0
	// Bit mask of FAD_THR field.
	XCVR_ZBDEM_FAD_THR_FAD_THR_Msk = 0xff

	// ZBDEM_AFC: 802.15.4 AFC STATUS
	// Position of AFC_EN field.
	XCVR_ZBDEM_ZBDEM_AFC_AFC_EN_Pos = 0x0
	// Bit mask of AFC_EN field.
	XCVR_ZBDEM_ZBDEM_AFC_AFC_EN_Msk = 0x1
	// Bit AFC_EN.
	XCVR_ZBDEM_ZBDEM_AFC_AFC_EN = 0x1
	// AFC is disabled
	XCVR_ZBDEM_ZBDEM_AFC_AFC_EN_0 = 0x0
	// AFC is enabled
	XCVR_ZBDEM_ZBDEM_AFC_AFC_EN_1 = 0x1
	// Position of DCD_EN field.
	XCVR_ZBDEM_ZBDEM_AFC_DCD_EN_Pos = 0x1
	// Bit mask of DCD_EN field.
	XCVR_ZBDEM_ZBDEM_AFC_DCD_EN_Msk = 0x2
	// Bit DCD_EN.
	XCVR_ZBDEM_ZBDEM_AFC_DCD_EN = 0x2
	// NCD Mode (default)
	XCVR_ZBDEM_ZBDEM_AFC_DCD_EN_0 = 0x0
	// DCD Mode
	XCVR_ZBDEM_ZBDEM_AFC_DCD_EN_1 = 0x1
	// Position of AFC_OUT field.
	XCVR_ZBDEM_ZBDEM_AFC_AFC_OUT_Pos = 0x8
	// Bit mask of AFC_OUT field.
	XCVR_ZBDEM_ZBDEM_AFC_AFC_OUT_Msk = 0x1f00
)

// Bitfields for XCVR_ANA: XCVR_ANALOG
const (
	// BB_LDO_1: RF Analog Baseband LDO Control 1
	// Position of BB_LDO_ADCDAC_BYP field.
	XCVR_ANA_BB_LDO_1_BB_LDO_ADCDAC_BYP_Pos = 0x0
	// Bit mask of BB_LDO_ADCDAC_BYP field.
	XCVR_ANA_BB_LDO_1_BB_LDO_ADCDAC_BYP_Msk = 0x1
	// Bit BB_LDO_ADCDAC_BYP.
	XCVR_ANA_BB_LDO_1_BB_LDO_ADCDAC_BYP = 0x1
	// Bypass disabled.
	XCVR_ANA_BB_LDO_1_BB_LDO_ADCDAC_BYP_0 = 0x0
	// Bypass enabled
	XCVR_ANA_BB_LDO_1_BB_LDO_ADCDAC_BYP_1 = 0x1
	// Position of BB_LDO_ADCDAC_DIAGSEL field.
	XCVR_ANA_BB_LDO_1_BB_LDO_ADCDAC_DIAGSEL_Pos = 0x1
	// Bit mask of BB_LDO_ADCDAC_DIAGSEL field.
	XCVR_ANA_BB_LDO_1_BB_LDO_ADCDAC_DIAGSEL_Msk = 0x2
	// Bit BB_LDO_ADCDAC_DIAGSEL.
	XCVR_ANA_BB_LDO_1_BB_LDO_ADCDAC_DIAGSEL = 0x2
	// Diag disable
	XCVR_ANA_BB_LDO_1_BB_LDO_ADCDAC_DIAGSEL_0 = 0x0
	// Diag enable
	XCVR_ANA_BB_LDO_1_BB_LDO_ADCDAC_DIAGSEL_1 = 0x1
	// Position of BB_LDO_ADCDAC_SPARE field.
	XCVR_ANA_BB_LDO_1_BB_LDO_ADCDAC_SPARE_Pos = 0x2
	// Bit mask of BB_LDO_ADCDAC_SPARE field.
	XCVR_ANA_BB_LDO_1_BB_LDO_ADCDAC_SPARE_Msk = 0xc
	// Position of BB_LDO_ADCDAC_TRIM field.
	XCVR_ANA_BB_LDO_1_BB_LDO_ADCDAC_TRIM_Pos = 0x4
	// Bit mask of BB_LDO_ADCDAC_TRIM field.
	XCVR_ANA_BB_LDO_1_BB_LDO_ADCDAC_TRIM_Msk = 0x70
	// 1.20 V ( Default )
	XCVR_ANA_BB_LDO_1_BB_LDO_ADCDAC_TRIM_000 = 0x0
	// 1.25 V
	XCVR_ANA_BB_LDO_1_BB_LDO_ADCDAC_TRIM_001 = 0x1
	// 1.28 V
	XCVR_ANA_BB_LDO_1_BB_LDO_ADCDAC_TRIM_010 = 0x2
	// 1.33 V
	XCVR_ANA_BB_LDO_1_BB_LDO_ADCDAC_TRIM_011 = 0x3
	// 1.40 V
	XCVR_ANA_BB_LDO_1_BB_LDO_ADCDAC_TRIM_100 = 0x4
	// 1.44 V
	XCVR_ANA_BB_LDO_1_BB_LDO_ADCDAC_TRIM_101 = 0x5
	// 1.50 V
	XCVR_ANA_BB_LDO_1_BB_LDO_ADCDAC_TRIM_110 = 0x6
	// 1.66 V
	XCVR_ANA_BB_LDO_1_BB_LDO_ADCDAC_TRIM_111 = 0x7
	// Position of BB_LDO_BBA_BYP field.
	XCVR_ANA_BB_LDO_1_BB_LDO_BBA_BYP_Pos = 0x8
	// Bit mask of BB_LDO_BBA_BYP field.
	XCVR_ANA_BB_LDO_1_BB_LDO_BBA_BYP_Msk = 0x100
	// Bit BB_LDO_BBA_BYP.
	XCVR_ANA_BB_LDO_1_BB_LDO_BBA_BYP = 0x100
	// Bypass disabled.
	XCVR_ANA_BB_LDO_1_BB_LDO_BBA_BYP_0 = 0x0
	// Bypass enabled
	XCVR_ANA_BB_LDO_1_BB_LDO_BBA_BYP_1 = 0x1
	// Position of BB_LDO_BBA_DIAGSEL field.
	XCVR_ANA_BB_LDO_1_BB_LDO_BBA_DIAGSEL_Pos = 0x9
	// Bit mask of BB_LDO_BBA_DIAGSEL field.
	XCVR_ANA_BB_LDO_1_BB_LDO_BBA_DIAGSEL_Msk = 0x200
	// Bit BB_LDO_BBA_DIAGSEL.
	XCVR_ANA_BB_LDO_1_BB_LDO_BBA_DIAGSEL = 0x200
	// Diag disable
	XCVR_ANA_BB_LDO_1_BB_LDO_BBA_DIAGSEL_0 = 0x0
	// Diag enable
	XCVR_ANA_BB_LDO_1_BB_LDO_BBA_DIAGSEL_1 = 0x1
	// Position of BB_LDO_BBA_SPARE field.
	XCVR_ANA_BB_LDO_1_BB_LDO_BBA_SPARE_Pos = 0xa
	// Bit mask of BB_LDO_BBA_SPARE field.
	XCVR_ANA_BB_LDO_1_BB_LDO_BBA_SPARE_Msk = 0xc00
	// Position of BB_LDO_BBA_TRIM field.
	XCVR_ANA_BB_LDO_1_BB_LDO_BBA_TRIM_Pos = 0xc
	// Bit mask of BB_LDO_BBA_TRIM field.
	XCVR_ANA_BB_LDO_1_BB_LDO_BBA_TRIM_Msk = 0x7000
	// 1.20 V ( Default )
	XCVR_ANA_BB_LDO_1_BB_LDO_BBA_TRIM_0 = 0x0
	// 1.25 V
	XCVR_ANA_BB_LDO_1_BB_LDO_BBA_TRIM_1 = 0x1
	// 1.28 V
	XCVR_ANA_BB_LDO_1_BB_LDO_BBA_TRIM_2 = 0x2
	// 1.33 V
	XCVR_ANA_BB_LDO_1_BB_LDO_BBA_TRIM_3 = 0x3
	// 1.40 V
	XCVR_ANA_BB_LDO_1_BB_LDO_BBA_TRIM_4 = 0x4
	// 1.44 V
	XCVR_ANA_BB_LDO_1_BB_LDO_BBA_TRIM_5 = 0x5
	// 1.50 V
	XCVR_ANA_BB_LDO_1_BB_LDO_BBA_TRIM_6 = 0x6
	// 1.66 V
	XCVR_ANA_BB_LDO_1_BB_LDO_BBA_TRIM_7 = 0x7
	// Position of BB_LDO_FDBK_BYP field.
	XCVR_ANA_BB_LDO_1_BB_LDO_FDBK_BYP_Pos = 0x10
	// Bit mask of BB_LDO_FDBK_BYP field.
	XCVR_ANA_BB_LDO_1_BB_LDO_FDBK_BYP_Msk = 0x10000
	// Bit BB_LDO_FDBK_BYP.
	XCVR_ANA_BB_LDO_1_BB_LDO_FDBK_BYP = 0x10000
	// Bypass disabled.
	XCVR_ANA_BB_LDO_1_BB_LDO_FDBK_BYP_0 = 0x0
	// Bypass enabled
	XCVR_ANA_BB_LDO_1_BB_LDO_FDBK_BYP_1 = 0x1
	// Position of BB_LDO_FDBK_DIAGSEL field.
	XCVR_ANA_BB_LDO_1_BB_LDO_FDBK_DIAGSEL_Pos = 0x11
	// Bit mask of BB_LDO_FDBK_DIAGSEL field.
	XCVR_ANA_BB_LDO_1_BB_LDO_FDBK_DIAGSEL_Msk = 0x20000
	// Bit BB_LDO_FDBK_DIAGSEL.
	XCVR_ANA_BB_LDO_1_BB_LDO_FDBK_DIAGSEL = 0x20000
	// Diag disable
	XCVR_ANA_BB_LDO_1_BB_LDO_FDBK_DIAGSEL_0 = 0x0
	// Diag enable
	XCVR_ANA_BB_LDO_1_BB_LDO_FDBK_DIAGSEL_1 = 0x1
	// Position of BB_LDO_FDBK_SPARE field.
	XCVR_ANA_BB_LDO_1_BB_LDO_FDBK_SPARE_Pos = 0x12
	// Bit mask of BB_LDO_FDBK_SPARE field.
	XCVR_ANA_BB_LDO_1_BB_LDO_FDBK_SPARE_Msk = 0xc0000
	// Position of BB_LDO_FDBK_TRIM field.
	XCVR_ANA_BB_LDO_1_BB_LDO_FDBK_TRIM_Pos = 0x14
	// Bit mask of BB_LDO_FDBK_TRIM field.
	XCVR_ANA_BB_LDO_1_BB_LDO_FDBK_TRIM_Msk = 0x700000
	// 1.2/1.176 V ( Default )
	XCVR_ANA_BB_LDO_1_BB_LDO_FDBK_TRIM_0 = 0x0
	// 1.138/1.115 V
	XCVR_ANA_BB_LDO_1_BB_LDO_FDBK_TRIM_1 = 0x1
	// 1.085/1.066 V
	XCVR_ANA_BB_LDO_1_BB_LDO_FDBK_TRIM_2 = 0x2
	// 1.04/1.025 V
	XCVR_ANA_BB_LDO_1_BB_LDO_FDBK_TRIM_3 = 0x3
	// 1.28/1.25 V
	XCVR_ANA_BB_LDO_1_BB_LDO_FDBK_TRIM_4 = 0x4
	// 1.4/1.35 V
	XCVR_ANA_BB_LDO_1_BB_LDO_FDBK_TRIM_5 = 0x5
	// 1.55/1.4 V
	XCVR_ANA_BB_LDO_1_BB_LDO_FDBK_TRIM_6 = 0x6
	// 1.78/1.4 V
	XCVR_ANA_BB_LDO_1_BB_LDO_FDBK_TRIM_7 = 0x7
	// Position of BB_LDO_HF_BYP field.
	XCVR_ANA_BB_LDO_1_BB_LDO_HF_BYP_Pos = 0x18
	// Bit mask of BB_LDO_HF_BYP field.
	XCVR_ANA_BB_LDO_1_BB_LDO_HF_BYP_Msk = 0x1000000
	// Bit BB_LDO_HF_BYP.
	XCVR_ANA_BB_LDO_1_BB_LDO_HF_BYP = 0x1000000
	// Bypass disabled.
	XCVR_ANA_BB_LDO_1_BB_LDO_HF_BYP_0 = 0x0
	// Bypass enabled
	XCVR_ANA_BB_LDO_1_BB_LDO_HF_BYP_1 = 0x1
	// Position of BB_LDO_HF_DIAGSEL field.
	XCVR_ANA_BB_LDO_1_BB_LDO_HF_DIAGSEL_Pos = 0x19
	// Bit mask of BB_LDO_HF_DIAGSEL field.
	XCVR_ANA_BB_LDO_1_BB_LDO_HF_DIAGSEL_Msk = 0x2000000
	// Bit BB_LDO_HF_DIAGSEL.
	XCVR_ANA_BB_LDO_1_BB_LDO_HF_DIAGSEL = 0x2000000
	// Diag disable
	XCVR_ANA_BB_LDO_1_BB_LDO_HF_DIAGSEL_0 = 0x0
	// Diag enable
	XCVR_ANA_BB_LDO_1_BB_LDO_HF_DIAGSEL_1 = 0x1
	// Position of BB_LDO_HF_SPARE field.
	XCVR_ANA_BB_LDO_1_BB_LDO_HF_SPARE_Pos = 0x1a
	// Bit mask of BB_LDO_HF_SPARE field.
	XCVR_ANA_BB_LDO_1_BB_LDO_HF_SPARE_Msk = 0xc000000
	// Position of BB_LDO_HF_TRIM field.
	XCVR_ANA_BB_LDO_1_BB_LDO_HF_TRIM_Pos = 0x1c
	// Bit mask of BB_LDO_HF_TRIM field.
	XCVR_ANA_BB_LDO_1_BB_LDO_HF_TRIM_Msk = 0x70000000
	// 1.20 V ( Default )
	XCVR_ANA_BB_LDO_1_BB_LDO_HF_TRIM_0 = 0x0
	// 1.25 V
	XCVR_ANA_BB_LDO_1_BB_LDO_HF_TRIM_1 = 0x1
	// 1.28 V
	XCVR_ANA_BB_LDO_1_BB_LDO_HF_TRIM_2 = 0x2
	// 1.33 V
	XCVR_ANA_BB_LDO_1_BB_LDO_HF_TRIM_3 = 0x3
	// 1.40 V
	XCVR_ANA_BB_LDO_1_BB_LDO_HF_TRIM_4 = 0x4
	// 1.44 V
	XCVR_ANA_BB_LDO_1_BB_LDO_HF_TRIM_5 = 0x5
	// 1.50 V
	XCVR_ANA_BB_LDO_1_BB_LDO_HF_TRIM_6 = 0x6
	// 1.66 V
	XCVR_ANA_BB_LDO_1_BB_LDO_HF_TRIM_7 = 0x7

	// BB_LDO_2: RF Analog Baseband LDO Control 2
	// Position of BB_LDO_PD_BYP field.
	XCVR_ANA_BB_LDO_2_BB_LDO_PD_BYP_Pos = 0x0
	// Bit mask of BB_LDO_PD_BYP field.
	XCVR_ANA_BB_LDO_2_BB_LDO_PD_BYP_Msk = 0x1
	// Bit BB_LDO_PD_BYP.
	XCVR_ANA_BB_LDO_2_BB_LDO_PD_BYP = 0x1
	// Bypass disabled.
	XCVR_ANA_BB_LDO_2_BB_LDO_PD_BYP_0 = 0x0
	// Bypass enabled
	XCVR_ANA_BB_LDO_2_BB_LDO_PD_BYP_1 = 0x1
	// Position of BB_LDO_PD_DIAGSEL field.
	XCVR_ANA_BB_LDO_2_BB_LDO_PD_DIAGSEL_Pos = 0x1
	// Bit mask of BB_LDO_PD_DIAGSEL field.
	XCVR_ANA_BB_LDO_2_BB_LDO_PD_DIAGSEL_Msk = 0x2
	// Bit BB_LDO_PD_DIAGSEL.
	XCVR_ANA_BB_LDO_2_BB_LDO_PD_DIAGSEL = 0x2
	// Diag disable
	XCVR_ANA_BB_LDO_2_BB_LDO_PD_DIAGSEL_0 = 0x0
	// Diag enable
	XCVR_ANA_BB_LDO_2_BB_LDO_PD_DIAGSEL_1 = 0x1
	// Position of BB_LDO_PD_SPARE field.
	XCVR_ANA_BB_LDO_2_BB_LDO_PD_SPARE_Pos = 0x2
	// Bit mask of BB_LDO_PD_SPARE field.
	XCVR_ANA_BB_LDO_2_BB_LDO_PD_SPARE_Msk = 0xc
	// Position of BB_LDO_PD_TRIM field.
	XCVR_ANA_BB_LDO_2_BB_LDO_PD_TRIM_Pos = 0x4
	// Bit mask of BB_LDO_PD_TRIM field.
	XCVR_ANA_BB_LDO_2_BB_LDO_PD_TRIM_Msk = 0x70
	// 1.20 V ( Default )
	XCVR_ANA_BB_LDO_2_BB_LDO_PD_TRIM_0 = 0x0
	// 1.25 V
	XCVR_ANA_BB_LDO_2_BB_LDO_PD_TRIM_1 = 0x1
	// 1.28 V
	XCVR_ANA_BB_LDO_2_BB_LDO_PD_TRIM_2 = 0x2
	// 1.33 V
	XCVR_ANA_BB_LDO_2_BB_LDO_PD_TRIM_3 = 0x3
	// 1.40 V
	XCVR_ANA_BB_LDO_2_BB_LDO_PD_TRIM_4 = 0x4
	// 1.44 V
	XCVR_ANA_BB_LDO_2_BB_LDO_PD_TRIM_5 = 0x5
	// 1.50 V
	XCVR_ANA_BB_LDO_2_BB_LDO_PD_TRIM_6 = 0x6
	// 1.66 V
	XCVR_ANA_BB_LDO_2_BB_LDO_PD_TRIM_7 = 0x7
	// Position of BB_LDO_VCO_SPARE field.
	XCVR_ANA_BB_LDO_2_BB_LDO_VCO_SPARE_Pos = 0x8
	// Bit mask of BB_LDO_VCO_SPARE field.
	XCVR_ANA_BB_LDO_2_BB_LDO_VCO_SPARE_Msk = 0x300
	// Position of BB_LDO_VCOLO_BYP field.
	XCVR_ANA_BB_LDO_2_BB_LDO_VCOLO_BYP_Pos = 0xa
	// Bit mask of BB_LDO_VCOLO_BYP field.
	XCVR_ANA_BB_LDO_2_BB_LDO_VCOLO_BYP_Msk = 0x400
	// Bit BB_LDO_VCOLO_BYP.
	XCVR_ANA_BB_LDO_2_BB_LDO_VCOLO_BYP = 0x400
	// Bypass disabled.
	XCVR_ANA_BB_LDO_2_BB_LDO_VCOLO_BYP_0 = 0x0
	// Bypass enabled
	XCVR_ANA_BB_LDO_2_BB_LDO_VCOLO_BYP_1 = 0x1
	// Position of BB_LDO_VCOLO_DIAGSEL field.
	XCVR_ANA_BB_LDO_2_BB_LDO_VCOLO_DIAGSEL_Pos = 0xb
	// Bit mask of BB_LDO_VCOLO_DIAGSEL field.
	XCVR_ANA_BB_LDO_2_BB_LDO_VCOLO_DIAGSEL_Msk = 0x800
	// Bit BB_LDO_VCOLO_DIAGSEL.
	XCVR_ANA_BB_LDO_2_BB_LDO_VCOLO_DIAGSEL = 0x800
	// Diag disable
	XCVR_ANA_BB_LDO_2_BB_LDO_VCOLO_DIAGSEL_0 = 0x0
	// Diag enable
	XCVR_ANA_BB_LDO_2_BB_LDO_VCOLO_DIAGSEL_1 = 0x1
	// Position of BB_LDO_VCOLO_TRIM field.
	XCVR_ANA_BB_LDO_2_BB_LDO_VCOLO_TRIM_Pos = 0xc
	// Bit mask of BB_LDO_VCOLO_TRIM field.
	XCVR_ANA_BB_LDO_2_BB_LDO_VCOLO_TRIM_Msk = 0x7000
	// 1.138/1.117 V ( Default )
	XCVR_ANA_BB_LDO_2_BB_LDO_VCOLO_TRIM_0 = 0x0
	// 1.076/1.058 V
	XCVR_ANA_BB_LDO_2_BB_LDO_VCOLO_TRIM_1 = 0x1
	// 1.027/1.012 V
	XCVR_ANA_BB_LDO_2_BB_LDO_VCOLO_TRIM_2 = 0x2
	// 0.98/0.97 V
	XCVR_ANA_BB_LDO_2_BB_LDO_VCOLO_TRIM_3 = 0x3
	// 1.22/1.19 V
	XCVR_ANA_BB_LDO_2_BB_LDO_VCOLO_TRIM_4 = 0x4
	// 1.33/1.3 V
	XCVR_ANA_BB_LDO_2_BB_LDO_VCOLO_TRIM_5 = 0x5
	// 1.5/1.4 V
	XCVR_ANA_BB_LDO_2_BB_LDO_VCOLO_TRIM_6 = 0x6
	// 1.82/1.4 V
	XCVR_ANA_BB_LDO_2_BB_LDO_VCOLO_TRIM_7 = 0x7
	// Position of BB_LDO_VTREF_DIAGSEL field.
	XCVR_ANA_BB_LDO_2_BB_LDO_VTREF_DIAGSEL_Pos = 0x10
	// Bit mask of BB_LDO_VTREF_DIAGSEL field.
	XCVR_ANA_BB_LDO_2_BB_LDO_VTREF_DIAGSEL_Msk = 0x10000
	// Bit BB_LDO_VTREF_DIAGSEL.
	XCVR_ANA_BB_LDO_2_BB_LDO_VTREF_DIAGSEL = 0x10000
	// Diag disable
	XCVR_ANA_BB_LDO_2_BB_LDO_VTREF_DIAGSEL_0 = 0x0
	// Diag enable
	XCVR_ANA_BB_LDO_2_BB_LDO_VTREF_DIAGSEL_1 = 0x1
	// Position of BB_LDO_VTREF_TC field.
	XCVR_ANA_BB_LDO_2_BB_LDO_VTREF_TC_Pos = 0x11
	// Bit mask of BB_LDO_VTREF_TC field.
	XCVR_ANA_BB_LDO_2_BB_LDO_VTREF_TC_Msk = 0x60000
	// 1.117/1.176 V
	XCVR_ANA_BB_LDO_2_BB_LDO_VTREF_TC_0 = 0x0
	// 1.134/1.188 V
	XCVR_ANA_BB_LDO_2_BB_LDO_VTREF_TC_1 = 0x1
	// 1.10/1.162 V
	XCVR_ANA_BB_LDO_2_BB_LDO_VTREF_TC_2 = 0x2
	// 1.09/1.152 V
	XCVR_ANA_BB_LDO_2_BB_LDO_VTREF_TC_3 = 0x3

	// RX_ADC: RF Analog ADC Control
	// Position of RX_ADC_BUMP field.
	XCVR_ANA_RX_ADC_RX_ADC_BUMP_Pos = 0x0
	// Bit mask of RX_ADC_BUMP field.
	XCVR_ANA_RX_ADC_RX_ADC_BUMP_Msk = 0xff
	// Position of RX_ADC_FS_SEL field.
	XCVR_ANA_RX_ADC_RX_ADC_FS_SEL_Pos = 0x8
	// Bit mask of RX_ADC_FS_SEL field.
	XCVR_ANA_RX_ADC_RX_ADC_FS_SEL_Msk = 0x300
	// 52MHz (2x26MHz)
	XCVR_ANA_RX_ADC_RX_ADC_FS_SEL_0 = 0x0
	// 64MHz (2x32MHz)
	XCVR_ANA_RX_ADC_RX_ADC_FS_SEL_1 = 0x1
	// +13% of 64MHz
	XCVR_ANA_RX_ADC_RX_ADC_FS_SEL_2 = 0x2
	// - 11% of 64MHz
	XCVR_ANA_RX_ADC_RX_ADC_FS_SEL_3 = 0x3
	// Position of RX_ADC_I_DIAGSEL field.
	XCVR_ANA_RX_ADC_RX_ADC_I_DIAGSEL_Pos = 0xa
	// Bit mask of RX_ADC_I_DIAGSEL field.
	XCVR_ANA_RX_ADC_RX_ADC_I_DIAGSEL_Msk = 0x400
	// Bit RX_ADC_I_DIAGSEL.
	XCVR_ANA_RX_ADC_RX_ADC_I_DIAGSEL = 0x400
	// Position of RX_ADC_Q_DIAGSEL field.
	XCVR_ANA_RX_ADC_RX_ADC_Q_DIAGSEL_Pos = 0xb
	// Bit mask of RX_ADC_Q_DIAGSEL field.
	XCVR_ANA_RX_ADC_RX_ADC_Q_DIAGSEL_Msk = 0x800
	// Bit RX_ADC_Q_DIAGSEL.
	XCVR_ANA_RX_ADC_RX_ADC_Q_DIAGSEL = 0x800
	// Position of RX_ADC_SPARE field.
	XCVR_ANA_RX_ADC_RX_ADC_SPARE_Pos = 0xc
	// Bit mask of RX_ADC_SPARE field.
	XCVR_ANA_RX_ADC_RX_ADC_SPARE_Msk = 0xf000

	// RX_BBA: RF Analog BBA Control
	// Position of RX_BBA_BW_SEL field.
	XCVR_ANA_RX_BBA_RX_BBA_BW_SEL_Pos = 0x0
	// Bit mask of RX_BBA_BW_SEL field.
	XCVR_ANA_RX_BBA_RX_BBA_BW_SEL_Msk = 0x7
	// 1000K
	XCVR_ANA_RX_BBA_RX_BBA_BW_SEL_000 = 0x0
	// 900K
	XCVR_ANA_RX_BBA_RX_BBA_BW_SEL_001 = 0x1
	// 800K
	XCVR_ANA_RX_BBA_RX_BBA_BW_SEL_010 = 0x2
	// 700K Default
	XCVR_ANA_RX_BBA_RX_BBA_BW_SEL_011 = 0x3
	// 600K
	XCVR_ANA_RX_BBA_RX_BBA_BW_SEL_100 = 0x4
	// 500K
	XCVR_ANA_RX_BBA_RX_BBA_BW_SEL_101 = 0x5
	// Position of RX_BBA_CUR_BUMP field.
	XCVR_ANA_RX_BBA_RX_BBA_CUR_BUMP_Pos = 0x3
	// Bit mask of RX_BBA_CUR_BUMP field.
	XCVR_ANA_RX_BBA_RX_BBA_CUR_BUMP_Msk = 0x8
	// Bit RX_BBA_CUR_BUMP.
	XCVR_ANA_RX_BBA_RX_BBA_CUR_BUMP = 0x8
	// Position of RX_BBA_DIAGSEL1 field.
	XCVR_ANA_RX_BBA_RX_BBA_DIAGSEL1_Pos = 0x4
	// Bit mask of RX_BBA_DIAGSEL1 field.
	XCVR_ANA_RX_BBA_RX_BBA_DIAGSEL1_Msk = 0x10
	// Bit RX_BBA_DIAGSEL1.
	XCVR_ANA_RX_BBA_RX_BBA_DIAGSEL1 = 0x10
	// Diag disable
	XCVR_ANA_RX_BBA_RX_BBA_DIAGSEL1_0 = 0x0
	// Diag enable
	XCVR_ANA_RX_BBA_RX_BBA_DIAGSEL1_1 = 0x1
	// Position of RX_BBA_DIAGSEL2 field.
	XCVR_ANA_RX_BBA_RX_BBA_DIAGSEL2_Pos = 0x5
	// Bit mask of RX_BBA_DIAGSEL2 field.
	XCVR_ANA_RX_BBA_RX_BBA_DIAGSEL2_Msk = 0x20
	// Bit RX_BBA_DIAGSEL2.
	XCVR_ANA_RX_BBA_RX_BBA_DIAGSEL2 = 0x20
	// Diag disable
	XCVR_ANA_RX_BBA_RX_BBA_DIAGSEL2_0 = 0x0
	// Diag enable
	XCVR_ANA_RX_BBA_RX_BBA_DIAGSEL2_1 = 0x1
	// Position of RX_BBA_DIAGSEL3 field.
	XCVR_ANA_RX_BBA_RX_BBA_DIAGSEL3_Pos = 0x6
	// Bit mask of RX_BBA_DIAGSEL3 field.
	XCVR_ANA_RX_BBA_RX_BBA_DIAGSEL3_Msk = 0x40
	// Bit RX_BBA_DIAGSEL3.
	XCVR_ANA_RX_BBA_RX_BBA_DIAGSEL3 = 0x40
	// Diag disable
	XCVR_ANA_RX_BBA_RX_BBA_DIAGSEL3_0 = 0x0
	// Diag enable
	XCVR_ANA_RX_BBA_RX_BBA_DIAGSEL3_1 = 0x1
	// Position of RX_BBA_DIAGSEL4 field.
	XCVR_ANA_RX_BBA_RX_BBA_DIAGSEL4_Pos = 0x7
	// Bit mask of RX_BBA_DIAGSEL4 field.
	XCVR_ANA_RX_BBA_RX_BBA_DIAGSEL4_Msk = 0x80
	// Bit RX_BBA_DIAGSEL4.
	XCVR_ANA_RX_BBA_RX_BBA_DIAGSEL4 = 0x80
	// Diag disable
	XCVR_ANA_RX_BBA_RX_BBA_DIAGSEL4_0 = 0x0
	// Diag enable
	XCVR_ANA_RX_BBA_RX_BBA_DIAGSEL4_1 = 0x1
	// Position of RX_BBA_SPARE field.
	XCVR_ANA_RX_BBA_RX_BBA_SPARE_Pos = 0x10
	// Bit mask of RX_BBA_SPARE field.
	XCVR_ANA_RX_BBA_RX_BBA_SPARE_Msk = 0x3f0000
	// 600mV (Default)
	XCVR_ANA_RX_BBA_RX_BBA_SPARE_00 = 0x0
	// 675mV
	XCVR_ANA_RX_BBA_RX_BBA_SPARE_01 = 0x1
	// 450mV
	XCVR_ANA_RX_BBA_RX_BBA_SPARE_10 = 0x2
	// 525mV
	XCVR_ANA_RX_BBA_RX_BBA_SPARE_11 = 0x3
	// Position of RX_BBA2_BW_SEL field.
	XCVR_ANA_RX_BBA_RX_BBA2_BW_SEL_Pos = 0x18
	// Bit mask of RX_BBA2_BW_SEL field.
	XCVR_ANA_RX_BBA_RX_BBA2_BW_SEL_Msk = 0x7000000
	// 1000K
	XCVR_ANA_RX_BBA_RX_BBA2_BW_SEL_000 = 0x0
	// 900K
	XCVR_ANA_RX_BBA_RX_BBA2_BW_SEL_001 = 0x1
	// 800K
	XCVR_ANA_RX_BBA_RX_BBA2_BW_SEL_010 = 0x2
	// 700K Default
	XCVR_ANA_RX_BBA_RX_BBA2_BW_SEL_011 = 0x3
	// 600K
	XCVR_ANA_RX_BBA_RX_BBA2_BW_SEL_100 = 0x4
	// 500K
	XCVR_ANA_RX_BBA_RX_BBA2_BW_SEL_101 = 0x5
	// Position of RX_BBA2_SPARE field.
	XCVR_ANA_RX_BBA_RX_BBA2_SPARE_Pos = 0x1c
	// Bit mask of RX_BBA2_SPARE field.
	XCVR_ANA_RX_BBA_RX_BBA2_SPARE_Msk = 0x70000000

	// RX_LNA: RF Analog LNA Control
	// Position of RX_LNA_BUMP field.
	XCVR_ANA_RX_LNA_RX_LNA_BUMP_Pos = 0x0
	// Bit mask of RX_LNA_BUMP field.
	XCVR_ANA_RX_LNA_RX_LNA_BUMP_Msk = 0xf
	// Default
	XCVR_ANA_RX_LNA_RX_LNA_BUMP_0 = 0x0
	// -25%
	XCVR_ANA_RX_LNA_RX_LNA_BUMP_1 = 0x1
	// +50%
	XCVR_ANA_RX_LNA_RX_LNA_BUMP_2 = 0x2
	// +25%
	XCVR_ANA_RX_LNA_RX_LNA_BUMP_3 = 0x3
	// CM 480mV
	XCVR_ANA_RX_LNA_RX_LNA_BUMP_4 = 0x4
	// CM 600mV
	XCVR_ANA_RX_LNA_RX_LNA_BUMP_8 = 0x8
	// CM 660mV
	XCVR_ANA_RX_LNA_RX_LNA_BUMP_12 = 0xc
	// Position of RX_LNA_HG_DIAGSEL field.
	XCVR_ANA_RX_LNA_RX_LNA_HG_DIAGSEL_Pos = 0x4
	// Bit mask of RX_LNA_HG_DIAGSEL field.
	XCVR_ANA_RX_LNA_RX_LNA_HG_DIAGSEL_Msk = 0x10
	// Bit RX_LNA_HG_DIAGSEL.
	XCVR_ANA_RX_LNA_RX_LNA_HG_DIAGSEL = 0x10
	// Position of RX_LNA_HIZ_ENABLE field.
	XCVR_ANA_RX_LNA_RX_LNA_HIZ_ENABLE_Pos = 0x5
	// Bit mask of RX_LNA_HIZ_ENABLE field.
	XCVR_ANA_RX_LNA_RX_LNA_HIZ_ENABLE_Msk = 0x20
	// Bit RX_LNA_HIZ_ENABLE.
	XCVR_ANA_RX_LNA_RX_LNA_HIZ_ENABLE = 0x20
	// Position of RX_LNA_LG_DIAGSEL field.
	XCVR_ANA_RX_LNA_RX_LNA_LG_DIAGSEL_Pos = 0x6
	// Bit mask of RX_LNA_LG_DIAGSEL field.
	XCVR_ANA_RX_LNA_RX_LNA_LG_DIAGSEL_Msk = 0x40
	// Bit RX_LNA_LG_DIAGSEL.
	XCVR_ANA_RX_LNA_RX_LNA_LG_DIAGSEL = 0x40
	// Position of RX_LNA_SPARE field.
	XCVR_ANA_RX_LNA_RX_LNA_SPARE_Pos = 0x8
	// Bit mask of RX_LNA_SPARE field.
	XCVR_ANA_RX_LNA_RX_LNA_SPARE_Msk = 0x300
	// Position of RX_MIXER_BUMP field.
	XCVR_ANA_RX_LNA_RX_MIXER_BUMP_Pos = 0x10
	// Bit mask of RX_MIXER_BUMP field.
	XCVR_ANA_RX_LNA_RX_MIXER_BUMP_Msk = 0xf0000
	// 825mV (Default)
	XCVR_ANA_RX_LNA_RX_MIXER_BUMP_0 = 0x0
	// 750mV
	XCVR_ANA_RX_LNA_RX_MIXER_BUMP_1 = 0x1
	// 900mV
	XCVR_ANA_RX_LNA_RX_MIXER_BUMP_2 = 0x2
	// 975mV
	XCVR_ANA_RX_LNA_RX_MIXER_BUMP_3 = 0x3
	// Position of RX_MIXER_SPARE field.
	XCVR_ANA_RX_LNA_RX_MIXER_SPARE_Pos = 0x14
	// Bit mask of RX_MIXER_SPARE field.
	XCVR_ANA_RX_LNA_RX_MIXER_SPARE_Msk = 0x100000
	// Bit RX_MIXER_SPARE.
	XCVR_ANA_RX_LNA_RX_MIXER_SPARE = 0x100000

	// RX_TZA: RF Analog TZA Control
	// Position of RX_TZA_BW_SEL field.
	XCVR_ANA_RX_TZA_RX_TZA_BW_SEL_Pos = 0x0
	// Bit mask of RX_TZA_BW_SEL field.
	XCVR_ANA_RX_TZA_RX_TZA_BW_SEL_Msk = 0x7
	// 1000K
	XCVR_ANA_RX_TZA_RX_TZA_BW_SEL_000 = 0x0
	// 900K
	XCVR_ANA_RX_TZA_RX_TZA_BW_SEL_001 = 0x1
	// 800K
	XCVR_ANA_RX_TZA_RX_TZA_BW_SEL_010 = 0x2
	// 700K Default
	XCVR_ANA_RX_TZA_RX_TZA_BW_SEL_011 = 0x3
	// 600K
	XCVR_ANA_RX_TZA_RX_TZA_BW_SEL_100 = 0x4
	// 500K
	XCVR_ANA_RX_TZA_RX_TZA_BW_SEL_101 = 0x5
	// Position of RX_TZA_CUR_BUMP field.
	XCVR_ANA_RX_TZA_RX_TZA_CUR_BUMP_Pos = 0x3
	// Bit mask of RX_TZA_CUR_BUMP field.
	XCVR_ANA_RX_TZA_RX_TZA_CUR_BUMP_Msk = 0x8
	// Bit RX_TZA_CUR_BUMP.
	XCVR_ANA_RX_TZA_RX_TZA_CUR_BUMP = 0x8
	// Position of RX_TZA_GAIN_BUMP field.
	XCVR_ANA_RX_TZA_RX_TZA_GAIN_BUMP_Pos = 0x4
	// Bit mask of RX_TZA_GAIN_BUMP field.
	XCVR_ANA_RX_TZA_RX_TZA_GAIN_BUMP_Msk = 0x10
	// Bit RX_TZA_GAIN_BUMP.
	XCVR_ANA_RX_TZA_RX_TZA_GAIN_BUMP = 0x10
	// Position of RX_TZA_SPARE field.
	XCVR_ANA_RX_TZA_RX_TZA_SPARE_Pos = 0x10
	// Bit mask of RX_TZA_SPARE field.
	XCVR_ANA_RX_TZA_RX_TZA_SPARE_Msk = 0x3f0000
	// 600mV (Default)
	XCVR_ANA_RX_TZA_RX_TZA_SPARE_00 = 0x0
	// 675mV
	XCVR_ANA_RX_TZA_RX_TZA_SPARE_01 = 0x1
	// 450mV
	XCVR_ANA_RX_TZA_RX_TZA_SPARE_10 = 0x2
	// 525mV
	XCVR_ANA_RX_TZA_RX_TZA_SPARE_11 = 0x3
	// Position of RX_TZA1_DIAGSEL field.
	XCVR_ANA_RX_TZA_RX_TZA1_DIAGSEL_Pos = 0x18
	// Bit mask of RX_TZA1_DIAGSEL field.
	XCVR_ANA_RX_TZA_RX_TZA1_DIAGSEL_Msk = 0x1000000
	// Bit RX_TZA1_DIAGSEL.
	XCVR_ANA_RX_TZA_RX_TZA1_DIAGSEL = 0x1000000
	// Diag disable
	XCVR_ANA_RX_TZA_RX_TZA1_DIAGSEL_0 = 0x0
	// Diag enable
	XCVR_ANA_RX_TZA_RX_TZA1_DIAGSEL_1 = 0x1
	// Position of RX_TZA2_DIAGSEL field.
	XCVR_ANA_RX_TZA_RX_TZA2_DIAGSEL_Pos = 0x19
	// Bit mask of RX_TZA2_DIAGSEL field.
	XCVR_ANA_RX_TZA_RX_TZA2_DIAGSEL_Msk = 0x2000000
	// Bit RX_TZA2_DIAGSEL.
	XCVR_ANA_RX_TZA_RX_TZA2_DIAGSEL = 0x2000000
	// Diag disable
	XCVR_ANA_RX_TZA_RX_TZA2_DIAGSEL_0 = 0x0
	// Diag enable
	XCVR_ANA_RX_TZA_RX_TZA2_DIAGSEL_1 = 0x1
	// Position of RX_TZA3_DIAGSEL field.
	XCVR_ANA_RX_TZA_RX_TZA3_DIAGSEL_Pos = 0x1a
	// Bit mask of RX_TZA3_DIAGSEL field.
	XCVR_ANA_RX_TZA_RX_TZA3_DIAGSEL_Msk = 0x4000000
	// Bit RX_TZA3_DIAGSEL.
	XCVR_ANA_RX_TZA_RX_TZA3_DIAGSEL = 0x4000000
	// Diag disable
	XCVR_ANA_RX_TZA_RX_TZA3_DIAGSEL_0 = 0x0
	// Diag enable
	XCVR_ANA_RX_TZA_RX_TZA3_DIAGSEL_1 = 0x1
	// Position of RX_TZA4_DIAGSEL field.
	XCVR_ANA_RX_TZA_RX_TZA4_DIAGSEL_Pos = 0x1b
	// Bit mask of RX_TZA4_DIAGSEL field.
	XCVR_ANA_RX_TZA_RX_TZA4_DIAGSEL_Msk = 0x8000000
	// Bit RX_TZA4_DIAGSEL.
	XCVR_ANA_RX_TZA_RX_TZA4_DIAGSEL = 0x8000000
	// Diag disable
	XCVR_ANA_RX_TZA_RX_TZA4_DIAGSEL_0 = 0x0
	// Diag enable
	XCVR_ANA_RX_TZA_RX_TZA4_DIAGSEL_1 = 0x1

	// RX_AUXPLL: RF Analog Aux PLL Control
	// Position of BIAS_TRIM field.
	XCVR_ANA_RX_AUXPLL_BIAS_TRIM_Pos = 0x0
	// Bit mask of BIAS_TRIM field.
	XCVR_ANA_RX_AUXPLL_BIAS_TRIM_Msk = 0x7
	// Position of DIAGSEL1 field.
	XCVR_ANA_RX_AUXPLL_DIAGSEL1_Pos = 0x3
	// Bit mask of DIAGSEL1 field.
	XCVR_ANA_RX_AUXPLL_DIAGSEL1_Msk = 0x8
	// Bit DIAGSEL1.
	XCVR_ANA_RX_AUXPLL_DIAGSEL1 = 0x8
	// Position of DIAGSEL2 field.
	XCVR_ANA_RX_AUXPLL_DIAGSEL2_Pos = 0x4
	// Bit mask of DIAGSEL2 field.
	XCVR_ANA_RX_AUXPLL_DIAGSEL2_Msk = 0x10
	// Bit DIAGSEL2.
	XCVR_ANA_RX_AUXPLL_DIAGSEL2 = 0x10
	// Position of LF_CNTL field.
	XCVR_ANA_RX_AUXPLL_LF_CNTL_Pos = 0x5
	// Bit mask of LF_CNTL field.
	XCVR_ANA_RX_AUXPLL_LF_CNTL_Msk = 0xe0
	// Position of SPARE field.
	XCVR_ANA_RX_AUXPLL_SPARE_Pos = 0x8
	// Bit mask of SPARE field.
	XCVR_ANA_RX_AUXPLL_SPARE_Msk = 0xf00
	// Position of VCO_DAC_REF_ADJUST field.
	XCVR_ANA_RX_AUXPLL_VCO_DAC_REF_ADJUST_Pos = 0xc
	// Bit mask of VCO_DAC_REF_ADJUST field.
	XCVR_ANA_RX_AUXPLL_VCO_DAC_REF_ADJUST_Msk = 0xf000
	// Position of VTUNE_TESTMODE field.
	XCVR_ANA_RX_AUXPLL_VTUNE_TESTMODE_Pos = 0x10
	// Bit mask of VTUNE_TESTMODE field.
	XCVR_ANA_RX_AUXPLL_VTUNE_TESTMODE_Msk = 0x10000
	// Bit VTUNE_TESTMODE.
	XCVR_ANA_RX_AUXPLL_VTUNE_TESTMODE = 0x10000
	// Position of RXTX_BAL_BIAST field.
	XCVR_ANA_RX_AUXPLL_RXTX_BAL_BIAST_Pos = 0x14
	// Bit mask of RXTX_BAL_BIAST field.
	XCVR_ANA_RX_AUXPLL_RXTX_BAL_BIAST_Msk = 0x300000
	// 0.6
	XCVR_ANA_RX_AUXPLL_RXTX_BAL_BIAST_0 = 0x0
	// 0.4
	XCVR_ANA_RX_AUXPLL_RXTX_BAL_BIAST_1 = 0x1
	// 0.9
	XCVR_ANA_RX_AUXPLL_RXTX_BAL_BIAST_2 = 0x2
	// 1.2
	XCVR_ANA_RX_AUXPLL_RXTX_BAL_BIAST_3 = 0x3
	// Position of RXTX_BAL_SPARE field.
	XCVR_ANA_RX_AUXPLL_RXTX_BAL_SPARE_Pos = 0x18
	// Bit mask of RXTX_BAL_SPARE field.
	XCVR_ANA_RX_AUXPLL_RXTX_BAL_SPARE_Msk = 0x7000000
	// Position of RXTX_RCCAL_DIAGSEL field.
	XCVR_ANA_RX_AUXPLL_RXTX_RCCAL_DIAGSEL_Pos = 0x1c
	// Bit mask of RXTX_RCCAL_DIAGSEL field.
	XCVR_ANA_RX_AUXPLL_RXTX_RCCAL_DIAGSEL_Msk = 0x10000000
	// Bit RXTX_RCCAL_DIAGSEL.
	XCVR_ANA_RX_AUXPLL_RXTX_RCCAL_DIAGSEL = 0x10000000

	// SY_CTRL_1: RF Analog Synthesizer Control 1
	// Position of SY_DIVN_SPARE field.
	XCVR_ANA_SY_CTRL_1_SY_DIVN_SPARE_Pos = 0x0
	// Bit mask of SY_DIVN_SPARE field.
	XCVR_ANA_SY_CTRL_1_SY_DIVN_SPARE_Msk = 0x1
	// Bit SY_DIVN_SPARE.
	XCVR_ANA_SY_CTRL_1_SY_DIVN_SPARE = 0x1
	// Position of SY_FCAL_SPARE field.
	XCVR_ANA_SY_CTRL_1_SY_FCAL_SPARE_Pos = 0x1
	// Bit mask of SY_FCAL_SPARE field.
	XCVR_ANA_SY_CTRL_1_SY_FCAL_SPARE_Msk = 0x2
	// Bit SY_FCAL_SPARE.
	XCVR_ANA_SY_CTRL_1_SY_FCAL_SPARE = 0x2
	// Position of SY_LO_BUMP_RTLO_FDBK field.
	XCVR_ANA_SY_CTRL_1_SY_LO_BUMP_RTLO_FDBK_Pos = 0x4
	// Bit mask of SY_LO_BUMP_RTLO_FDBK field.
	XCVR_ANA_SY_CTRL_1_SY_LO_BUMP_RTLO_FDBK_Msk = 0x30
	// 1.045 V
	XCVR_ANA_SY_CTRL_1_SY_LO_BUMP_RTLO_FDBK_0 = 0x0
	// 1.084 V
	XCVR_ANA_SY_CTRL_1_SY_LO_BUMP_RTLO_FDBK_1 = 0x1
	// 1.097 V
	XCVR_ANA_SY_CTRL_1_SY_LO_BUMP_RTLO_FDBK_2 = 0x2
	// 1.10 V
	XCVR_ANA_SY_CTRL_1_SY_LO_BUMP_RTLO_FDBK_3 = 0x3
	// Position of SY_LO_BUMP_RTLO_RX field.
	XCVR_ANA_SY_CTRL_1_SY_LO_BUMP_RTLO_RX_Pos = 0x6
	// Bit mask of SY_LO_BUMP_RTLO_RX field.
	XCVR_ANA_SY_CTRL_1_SY_LO_BUMP_RTLO_RX_Msk = 0xc0
	// 1.051/1.037 V
	XCVR_ANA_SY_CTRL_1_SY_LO_BUMP_RTLO_RX_0 = 0x0
	// 1.082/1.075 V
	XCVR_ANA_SY_CTRL_1_SY_LO_BUMP_RTLO_RX_1 = 0x1
	// 1.092/1.088 V
	XCVR_ANA_SY_CTRL_1_SY_LO_BUMP_RTLO_RX_2 = 0x2
	// 1.098/1.094 V
	XCVR_ANA_SY_CTRL_1_SY_LO_BUMP_RTLO_RX_3 = 0x3
	// Position of SY_LO_BUMP_RTLO_TX field.
	XCVR_ANA_SY_CTRL_1_SY_LO_BUMP_RTLO_TX_Pos = 0x8
	// Bit mask of SY_LO_BUMP_RTLO_TX field.
	XCVR_ANA_SY_CTRL_1_SY_LO_BUMP_RTLO_TX_Msk = 0x300
	// 1.071/1.065 V
	XCVR_ANA_SY_CTRL_1_SY_LO_BUMP_RTLO_TX_0 = 0x0
	// 1.092/1.090 V
	XCVR_ANA_SY_CTRL_1_SY_LO_BUMP_RTLO_TX_1 = 0x1
	// 1.099/1.098 V
	XCVR_ANA_SY_CTRL_1_SY_LO_BUMP_RTLO_TX_2 = 0x2
	// 1.10/1.1 V
	XCVR_ANA_SY_CTRL_1_SY_LO_BUMP_RTLO_TX_3 = 0x3
	// Position of SY_LO_DIAGSEL field.
	XCVR_ANA_SY_CTRL_1_SY_LO_DIAGSEL_Pos = 0xa
	// Bit mask of SY_LO_DIAGSEL field.
	XCVR_ANA_SY_CTRL_1_SY_LO_DIAGSEL_Msk = 0x400
	// Bit SY_LO_DIAGSEL.
	XCVR_ANA_SY_CTRL_1_SY_LO_DIAGSEL = 0x400
	// Diag disable
	XCVR_ANA_SY_CTRL_1_SY_LO_DIAGSEL_0 = 0x0
	// Diag enable
	XCVR_ANA_SY_CTRL_1_SY_LO_DIAGSEL_1 = 0x1
	// Position of SY_LO_SPARE field.
	XCVR_ANA_SY_CTRL_1_SY_LO_SPARE_Pos = 0xc
	// Bit mask of SY_LO_SPARE field.
	XCVR_ANA_SY_CTRL_1_SY_LO_SPARE_Msk = 0x7000
	// Position of SY_LPF_FILT_CTRL field.
	XCVR_ANA_SY_CTRL_1_SY_LPF_FILT_CTRL_Pos = 0x10
	// Bit mask of SY_LPF_FILT_CTRL field.
	XCVR_ANA_SY_CTRL_1_SY_LPF_FILT_CTRL_Msk = 0x70000
	// Position of SY_LPF_SPARE field.
	XCVR_ANA_SY_CTRL_1_SY_LPF_SPARE_Pos = 0x13
	// Bit mask of SY_LPF_SPARE field.
	XCVR_ANA_SY_CTRL_1_SY_LPF_SPARE_Msk = 0x80000
	// Bit SY_LPF_SPARE.
	XCVR_ANA_SY_CTRL_1_SY_LPF_SPARE = 0x80000
	// Position of SY_PD_DIAGSEL field.
	XCVR_ANA_SY_CTRL_1_SY_PD_DIAGSEL_Pos = 0x14
	// Bit mask of SY_PD_DIAGSEL field.
	XCVR_ANA_SY_CTRL_1_SY_PD_DIAGSEL_Msk = 0x100000
	// Bit SY_PD_DIAGSEL.
	XCVR_ANA_SY_CTRL_1_SY_PD_DIAGSEL = 0x100000
	// Position of SY_PD_PCH_TUNE field.
	XCVR_ANA_SY_CTRL_1_SY_PD_PCH_TUNE_Pos = 0x15
	// Bit mask of SY_PD_PCH_TUNE field.
	XCVR_ANA_SY_CTRL_1_SY_PD_PCH_TUNE_Msk = 0x600000
	// Position of SY_PD_PCH_SEL field.
	XCVR_ANA_SY_CTRL_1_SY_PD_PCH_SEL_Pos = 0x17
	// Bit mask of SY_PD_PCH_SEL field.
	XCVR_ANA_SY_CTRL_1_SY_PD_PCH_SEL_Msk = 0x800000
	// Bit SY_PD_PCH_SEL.
	XCVR_ANA_SY_CTRL_1_SY_PD_PCH_SEL = 0x800000
	// inverter based precharge
	XCVR_ANA_SY_CTRL_1_SY_PD_PCH_SEL_0 = 0x0
	// resistor divider based precharge
	XCVR_ANA_SY_CTRL_1_SY_PD_PCH_SEL_1 = 0x1
	// Position of SY_PD_SPARE field.
	XCVR_ANA_SY_CTRL_1_SY_PD_SPARE_Pos = 0x18
	// Bit mask of SY_PD_SPARE field.
	XCVR_ANA_SY_CTRL_1_SY_PD_SPARE_Msk = 0x3000000
	// Default ;
	XCVR_ANA_SY_CTRL_1_SY_PD_SPARE_0 = 0x0
	// PD output is pulled down.
	XCVR_ANA_SY_CTRL_1_SY_PD_SPARE_1 = 0x1
	// Position of SY_PD_VTUNE_OVERRIDE_TEST_MODE field.
	XCVR_ANA_SY_CTRL_1_SY_PD_VTUNE_OVERRIDE_TEST_MODE_Pos = 0x1c
	// Bit mask of SY_PD_VTUNE_OVERRIDE_TEST_MODE field.
	XCVR_ANA_SY_CTRL_1_SY_PD_VTUNE_OVERRIDE_TEST_MODE_Msk = 0x10000000
	// Bit SY_PD_VTUNE_OVERRIDE_TEST_MODE.
	XCVR_ANA_SY_CTRL_1_SY_PD_VTUNE_OVERRIDE_TEST_MODE = 0x10000000

	// SY_CTRL_2: RF Analog Synthesizer Control 2
	// Position of SY_VCO_BIAS field.
	XCVR_ANA_SY_CTRL_2_SY_VCO_BIAS_Pos = 0x0
	// Bit mask of SY_VCO_BIAS field.
	XCVR_ANA_SY_CTRL_2_SY_VCO_BIAS_Msk = 0x7
	// 0.97V
	XCVR_ANA_SY_CTRL_2_SY_VCO_BIAS_0 = 0x0
	// 1.033V
	XCVR_ANA_SY_CTRL_2_SY_VCO_BIAS_1 = 0x1
	// 1.06V
	XCVR_ANA_SY_CTRL_2_SY_VCO_BIAS_2 = 0x2
	// 1.07V
	XCVR_ANA_SY_CTRL_2_SY_VCO_BIAS_3 = 0x3
	// 1.08V
	XCVR_ANA_SY_CTRL_2_SY_VCO_BIAS_4 = 0x4
	// 1.085V
	XCVR_ANA_SY_CTRL_2_SY_VCO_BIAS_5 = 0x5
	// 1.090V
	XCVR_ANA_SY_CTRL_2_SY_VCO_BIAS_6 = 0x6
	// 1.095V
	XCVR_ANA_SY_CTRL_2_SY_VCO_BIAS_7 = 0x7
	// Position of SY_VCO_DIAGSEL field.
	XCVR_ANA_SY_CTRL_2_SY_VCO_DIAGSEL_Pos = 0x3
	// Bit mask of SY_VCO_DIAGSEL field.
	XCVR_ANA_SY_CTRL_2_SY_VCO_DIAGSEL_Msk = 0x8
	// Bit SY_VCO_DIAGSEL.
	XCVR_ANA_SY_CTRL_2_SY_VCO_DIAGSEL = 0x8
	// Diag enable
	XCVR_ANA_SY_CTRL_2_SY_VCO_DIAGSEL_1 = 0x1
	// Diag disable
	XCVR_ANA_SY_CTRL_2_SY_VCO_DIAGSEL_0 = 0x0
	// Position of SY_VCO_KV field.
	XCVR_ANA_SY_CTRL_2_SY_VCO_KV_Pos = 0x4
	// Bit mask of SY_VCO_KV field.
	XCVR_ANA_SY_CTRL_2_SY_VCO_KV_Msk = 0x70
	// 50MHz/V
	XCVR_ANA_SY_CTRL_2_SY_VCO_KV_0 = 0x0
	// 60MHz/V
	XCVR_ANA_SY_CTRL_2_SY_VCO_KV_1 = 0x1
	// 70MHz/V
	XCVR_ANA_SY_CTRL_2_SY_VCO_KV_2 = 0x2
	// 80MHz/V
	XCVR_ANA_SY_CTRL_2_SY_VCO_KV_3 = 0x3
	// 80MHz/V
	XCVR_ANA_SY_CTRL_2_SY_VCO_KV_4 = 0x4
	// 80MHz/V
	XCVR_ANA_SY_CTRL_2_SY_VCO_KV_5 = 0x5
	// 80MHz/V
	XCVR_ANA_SY_CTRL_2_SY_VCO_KV_6 = 0x6
	// 80MHz/V
	XCVR_ANA_SY_CTRL_2_SY_VCO_KV_7 = 0x7
	// Position of SY_VCO_KVM field.
	XCVR_ANA_SY_CTRL_2_SY_VCO_KVM_Pos = 0x8
	// Bit mask of SY_VCO_KVM field.
	XCVR_ANA_SY_CTRL_2_SY_VCO_KVM_Msk = 0x700
	// 10MHz/V
	XCVR_ANA_SY_CTRL_2_SY_VCO_KVM_0 = 0x0
	// 20MHz/V
	XCVR_ANA_SY_CTRL_2_SY_VCO_KVM_1 = 0x1
	// 30MHz/V
	XCVR_ANA_SY_CTRL_2_SY_VCO_KVM_2 = 0x2
	// 40MHz/V
	XCVR_ANA_SY_CTRL_2_SY_VCO_KVM_3 = 0x3
	// 40MHz/V
	XCVR_ANA_SY_CTRL_2_SY_VCO_KVM_4 = 0x4
	// 40MHz/V
	XCVR_ANA_SY_CTRL_2_SY_VCO_KVM_5 = 0x5
	// 40MHz/V
	XCVR_ANA_SY_CTRL_2_SY_VCO_KVM_6 = 0x6
	// 40MHz/V
	XCVR_ANA_SY_CTRL_2_SY_VCO_KVM_7 = 0x7
	// Position of SY_VCO_PK_DET_ON field.
	XCVR_ANA_SY_CTRL_2_SY_VCO_PK_DET_ON_Pos = 0xc
	// Bit mask of SY_VCO_PK_DET_ON field.
	XCVR_ANA_SY_CTRL_2_SY_VCO_PK_DET_ON_Msk = 0x1000
	// Bit SY_VCO_PK_DET_ON.
	XCVR_ANA_SY_CTRL_2_SY_VCO_PK_DET_ON = 0x1000
	// Enable
	XCVR_ANA_SY_CTRL_2_SY_VCO_PK_DET_ON_1 = 0x1
	// Disable
	XCVR_ANA_SY_CTRL_2_SY_VCO_PK_DET_ON_0 = 0x0
	// Position of SY_VCO_SPARE field.
	XCVR_ANA_SY_CTRL_2_SY_VCO_SPARE_Pos = 0xe
	// Bit mask of SY_VCO_SPARE field.
	XCVR_ANA_SY_CTRL_2_SY_VCO_SPARE_Msk = 0x1c000

	// TX_DAC_PA: RF Analog TX HPM DAC and PA Control
	// Position of TX_DAC_BUMP_CAP field.
	XCVR_ANA_TX_DAC_PA_TX_DAC_BUMP_CAP_Pos = 0x0
	// Bit mask of TX_DAC_BUMP_CAP field.
	XCVR_ANA_TX_DAC_PA_TX_DAC_BUMP_CAP_Msk = 0x3
	// 1pF(default)
	XCVR_ANA_TX_DAC_PA_TX_DAC_BUMP_CAP_0 = 0x0
	// 1.5pF
	XCVR_ANA_TX_DAC_PA_TX_DAC_BUMP_CAP_1 = 0x1
	// 1.5pF
	XCVR_ANA_TX_DAC_PA_TX_DAC_BUMP_CAP_2 = 0x2
	// 2pF
	XCVR_ANA_TX_DAC_PA_TX_DAC_BUMP_CAP_3 = 0x3
	// Position of TX_DAC_BUMP_IDAC field.
	XCVR_ANA_TX_DAC_PA_TX_DAC_BUMP_IDAC_Pos = 0x3
	// Bit mask of TX_DAC_BUMP_IDAC field.
	XCVR_ANA_TX_DAC_PA_TX_DAC_BUMP_IDAC_Msk = 0x18
	// 250nA(default)
	XCVR_ANA_TX_DAC_PA_TX_DAC_BUMP_IDAC_0 = 0x0
	// 207nA
	XCVR_ANA_TX_DAC_PA_TX_DAC_BUMP_IDAC_1 = 0x1
	// 312nA
	XCVR_ANA_TX_DAC_PA_TX_DAC_BUMP_IDAC_2 = 0x2
	// 415nA
	XCVR_ANA_TX_DAC_PA_TX_DAC_BUMP_IDAC_3 = 0x3
	// Position of TX_DAC_BUMP_RLOAD field.
	XCVR_ANA_TX_DAC_PA_TX_DAC_BUMP_RLOAD_Pos = 0x6
	// Bit mask of TX_DAC_BUMP_RLOAD field.
	XCVR_ANA_TX_DAC_PA_TX_DAC_BUMP_RLOAD_Msk = 0xc0
	// 3.12 kohms(default)
	XCVR_ANA_TX_DAC_PA_TX_DAC_BUMP_RLOAD_0 = 0x0
	// 2.34 kohms
	XCVR_ANA_TX_DAC_PA_TX_DAC_BUMP_RLOAD_1 = 0x1
	// 3.9 kohms
	XCVR_ANA_TX_DAC_PA_TX_DAC_BUMP_RLOAD_2 = 0x2
	// 4.6 kohms
	XCVR_ANA_TX_DAC_PA_TX_DAC_BUMP_RLOAD_3 = 0x3
	// Position of TX_DAC_DIAGSEL field.
	XCVR_ANA_TX_DAC_PA_TX_DAC_DIAGSEL_Pos = 0x9
	// Bit mask of TX_DAC_DIAGSEL field.
	XCVR_ANA_TX_DAC_PA_TX_DAC_DIAGSEL_Msk = 0x200
	// Bit TX_DAC_DIAGSEL.
	XCVR_ANA_TX_DAC_PA_TX_DAC_DIAGSEL = 0x200
	// Disable Diag
	XCVR_ANA_TX_DAC_PA_TX_DAC_DIAGSEL_0 = 0x0
	// Enable Diag
	XCVR_ANA_TX_DAC_PA_TX_DAC_DIAGSEL_1 = 0x1
	// Position of TX_DAC_INVERT_CLK field.
	XCVR_ANA_TX_DAC_PA_TX_DAC_INVERT_CLK_Pos = 0xa
	// Bit mask of TX_DAC_INVERT_CLK field.
	XCVR_ANA_TX_DAC_PA_TX_DAC_INVERT_CLK_Msk = 0x400
	// Bit TX_DAC_INVERT_CLK.
	XCVR_ANA_TX_DAC_PA_TX_DAC_INVERT_CLK = 0x400
	// Position of TX_DAC_OPAMP_DIAGSEL field.
	XCVR_ANA_TX_DAC_PA_TX_DAC_OPAMP_DIAGSEL_Pos = 0xb
	// Bit mask of TX_DAC_OPAMP_DIAGSEL field.
	XCVR_ANA_TX_DAC_PA_TX_DAC_OPAMP_DIAGSEL_Msk = 0x800
	// Bit TX_DAC_OPAMP_DIAGSEL.
	XCVR_ANA_TX_DAC_PA_TX_DAC_OPAMP_DIAGSEL = 0x800
	// Disable Diag
	XCVR_ANA_TX_DAC_PA_TX_DAC_OPAMP_DIAGSEL_0 = 0x0
	// Enable Diag
	XCVR_ANA_TX_DAC_PA_TX_DAC_OPAMP_DIAGSEL_1 = 0x1
	// Position of TX_DAC_SPARE field.
	XCVR_ANA_TX_DAC_PA_TX_DAC_SPARE_Pos = 0xd
	// Bit mask of TX_DAC_SPARE field.
	XCVR_ANA_TX_DAC_PA_TX_DAC_SPARE_Msk = 0xe000
	// Position of TX_PA_BUMP_VBIAS field.
	XCVR_ANA_TX_DAC_PA_TX_PA_BUMP_VBIAS_Pos = 0x11
	// Bit mask of TX_PA_BUMP_VBIAS field.
	XCVR_ANA_TX_DAC_PA_TX_PA_BUMP_VBIAS_Msk = 0xe0000
	// 0.557
	XCVR_ANA_TX_DAC_PA_TX_PA_BUMP_VBIAS_0 = 0x0
	// 0.651
	XCVR_ANA_TX_DAC_PA_TX_PA_BUMP_VBIAS_1 = 0x1
	// 0.741
	XCVR_ANA_TX_DAC_PA_TX_PA_BUMP_VBIAS_2 = 0x2
	// 0.822
	XCVR_ANA_TX_DAC_PA_TX_PA_BUMP_VBIAS_3 = 0x3
	// 0.590
	XCVR_ANA_TX_DAC_PA_TX_PA_BUMP_VBIAS_4 = 0x4
	// 0.683
	XCVR_ANA_TX_DAC_PA_TX_PA_BUMP_VBIAS_5 = 0x5
	// 0.771
	XCVR_ANA_TX_DAC_PA_TX_PA_BUMP_VBIAS_6 = 0x6
	// 0.850
	XCVR_ANA_TX_DAC_PA_TX_PA_BUMP_VBIAS_7 = 0x7
	// Position of TX_PA_DIAGSEL field.
	XCVR_ANA_TX_DAC_PA_TX_PA_DIAGSEL_Pos = 0x15
	// Bit mask of TX_PA_DIAGSEL field.
	XCVR_ANA_TX_DAC_PA_TX_PA_DIAGSEL_Msk = 0x200000
	// Bit TX_PA_DIAGSEL.
	XCVR_ANA_TX_DAC_PA_TX_PA_DIAGSEL = 0x200000
	// Position of TX_PA_SPARE field.
	XCVR_ANA_TX_DAC_PA_TX_PA_SPARE_Pos = 0x17
	// Bit mask of TX_PA_SPARE field.
	XCVR_ANA_TX_DAC_PA_TX_PA_SPARE_Msk = 0x3800000

	// BALUN_TX: RF Analog Balun TX Mode Control
	// Position of RXTX_BAL_TX_CODE field.
	XCVR_ANA_BALUN_TX_RXTX_BAL_TX_CODE_Pos = 0x0
	// Bit mask of RXTX_BAL_TX_CODE field.
	XCVR_ANA_BALUN_TX_RXTX_BAL_TX_CODE_Msk = 0xffffff

	// BALUN_RX: RF Analog Balun RX Mode Control
	// Position of RXTX_BAL_RX_CODE field.
	XCVR_ANA_BALUN_RX_RXTX_BAL_RX_CODE_Pos = 0x0
	// Bit mask of RXTX_BAL_RX_CODE field.
	XCVR_ANA_BALUN_RX_RXTX_BAL_RX_CODE_Msk = 0xffffff

	// DFT_OBSV_1: RF Analog DFT Observation Register 1
	// Position of DFT_FREQ_COUNTER field.
	XCVR_ANA_DFT_OBSV_1_DFT_FREQ_COUNTER_Pos = 0x0
	// Bit mask of DFT_FREQ_COUNTER field.
	XCVR_ANA_DFT_OBSV_1_DFT_FREQ_COUNTER_Msk = 0x7ffff
	// Position of CTUNE_MAX_DIFF field.
	XCVR_ANA_DFT_OBSV_1_CTUNE_MAX_DIFF_Pos = 0x14
	// Bit mask of CTUNE_MAX_DIFF field.
	XCVR_ANA_DFT_OBSV_1_CTUNE_MAX_DIFF_Msk = 0xff00000

	// DFT_OBSV_2: RF Analog DFT Observation Register 2
	// Position of SYN_BIST_MAX_DIFF field.
	XCVR_ANA_DFT_OBSV_2_SYN_BIST_MAX_DIFF_Pos = 0x0
	// Bit mask of SYN_BIST_MAX_DIFF field.
	XCVR_ANA_DFT_OBSV_2_SYN_BIST_MAX_DIFF_Msk = 0x1ffff
	// Position of SYN_BIST_MAX_DIFF_CH field.
	XCVR_ANA_DFT_OBSV_2_SYN_BIST_MAX_DIFF_CH_Pos = 0x18
	// Bit mask of SYN_BIST_MAX_DIFF_CH field.
	XCVR_ANA_DFT_OBSV_2_SYN_BIST_MAX_DIFF_CH_Msk = 0x7f000000
	// Position of SYN_BIST_IGNORE_FAILS field.
	XCVR_ANA_DFT_OBSV_2_SYN_BIST_IGNORE_FAILS_Pos = 0x1f
	// Bit mask of SYN_BIST_IGNORE_FAILS field.
	XCVR_ANA_DFT_OBSV_2_SYN_BIST_IGNORE_FAILS_Msk = 0x80000000
	// Bit SYN_BIST_IGNORE_FAILS.
	XCVR_ANA_DFT_OBSV_2_SYN_BIST_IGNORE_FAILS = 0x80000000
)

// Bitfields for XCVR_PKT_RAM: XCVR_PKT_RAM
const (
	// PACKET_RAM_0_0: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_0_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_0_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_0_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_0_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_1: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_1_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_1_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_1_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_1_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_2: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_2_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_2_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_2_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_2_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_3: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_3_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_3_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_3_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_3_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_4: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_4_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_4_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_4_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_4_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_5: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_5_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_5_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_5_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_5_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_6: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_6_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_6_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_6_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_6_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_7: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_7_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_7_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_7_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_7_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_8: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_8_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_8_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_8_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_8_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_9: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_9_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_9_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_9_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_9_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_10: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_10_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_10_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_10_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_10_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_11: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_11_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_11_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_11_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_11_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_12: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_12_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_12_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_12_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_12_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_13: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_13_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_13_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_13_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_13_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_14: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_14_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_14_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_14_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_14_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_15: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_15_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_15_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_15_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_15_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_16: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_16_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_16_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_16_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_16_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_17: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_17_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_17_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_17_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_17_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_18: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_18_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_18_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_18_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_18_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_19: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_19_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_19_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_19_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_19_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_20: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_20_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_20_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_20_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_20_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_21: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_21_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_21_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_21_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_21_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_22: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_22_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_22_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_22_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_22_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_23: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_23_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_23_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_23_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_23_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_24: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_24_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_24_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_24_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_24_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_25: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_25_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_25_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_25_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_25_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_26: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_26_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_26_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_26_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_26_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_27: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_27_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_27_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_27_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_27_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_28: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_28_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_28_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_28_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_28_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_29: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_29_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_29_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_29_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_29_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_30: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_30_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_30_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_30_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_30_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_31: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_31_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_31_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_31_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_31_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_32: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_32_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_32_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_32_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_32_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_33: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_33_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_33_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_33_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_33_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_34: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_34_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_34_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_34_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_34_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_35: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_35_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_35_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_35_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_35_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_36: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_36_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_36_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_36_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_36_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_37: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_37_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_37_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_37_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_37_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_38: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_38_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_38_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_38_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_38_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_39: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_39_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_39_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_39_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_39_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_40: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_40_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_40_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_40_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_40_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_41: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_41_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_41_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_41_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_41_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_42: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_42_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_42_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_42_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_42_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_43: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_43_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_43_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_43_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_43_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_44: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_44_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_44_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_44_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_44_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_45: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_45_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_45_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_45_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_45_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_46: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_46_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_46_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_46_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_46_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_47: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_47_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_47_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_47_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_47_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_48: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_48_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_48_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_48_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_48_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_49: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_49_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_49_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_49_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_49_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_50: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_50_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_50_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_50_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_50_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_51: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_51_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_51_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_51_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_51_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_52: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_52_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_52_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_52_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_52_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_53: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_53_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_53_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_53_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_53_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_54: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_54_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_54_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_54_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_54_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_55: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_55_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_55_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_55_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_55_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_56: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_56_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_56_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_56_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_56_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_57: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_57_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_57_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_57_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_57_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_58: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_58_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_58_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_58_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_58_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_59: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_59_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_59_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_59_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_59_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_60: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_60_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_60_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_60_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_60_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_61: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_61_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_61_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_61_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_61_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_62: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_62_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_62_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_62_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_62_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_63: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_63_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_63_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_63_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_63_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_64: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_64_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_64_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_64_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_64_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_65: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_65_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_65_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_65_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_65_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_66: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_66_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_66_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_66_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_66_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_67: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_67_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_67_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_67_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_67_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_68: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_68_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_68_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_68_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_68_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_69: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_69_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_69_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_69_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_69_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_70: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_70_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_70_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_70_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_70_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_71: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_71_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_71_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_71_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_71_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_72: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_72_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_72_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_72_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_72_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_73: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_73_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_73_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_73_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_73_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_74: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_74_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_74_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_74_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_74_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_75: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_75_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_75_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_75_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_75_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_76: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_76_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_76_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_76_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_76_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_77: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_77_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_77_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_77_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_77_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_78: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_78_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_78_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_78_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_78_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_79: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_79_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_79_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_79_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_79_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_80: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_80_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_80_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_80_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_80_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_81: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_81_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_81_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_81_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_81_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_82: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_82_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_82_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_82_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_82_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_83: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_83_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_83_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_83_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_83_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_84: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_84_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_84_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_84_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_84_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_85: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_85_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_85_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_85_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_85_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_86: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_86_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_86_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_86_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_86_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_87: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_87_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_87_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_87_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_87_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_88: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_88_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_88_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_88_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_88_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_89: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_89_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_89_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_89_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_89_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_90: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_90_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_90_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_90_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_90_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_91: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_91_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_91_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_91_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_91_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_92: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_92_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_92_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_92_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_92_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_93: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_93_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_93_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_93_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_93_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_94: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_94_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_94_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_94_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_94_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_95: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_95_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_95_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_95_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_95_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_96: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_96_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_96_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_96_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_96_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_97: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_97_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_97_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_97_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_97_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_98: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_98_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_98_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_98_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_98_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_99: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_99_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_99_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_99_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_99_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_100: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_100_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_100_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_100_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_100_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_101: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_101_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_101_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_101_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_101_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_102: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_102_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_102_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_102_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_102_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_103: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_103_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_103_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_103_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_103_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_104: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_104_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_104_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_104_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_104_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_105: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_105_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_105_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_105_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_105_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_106: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_106_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_106_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_106_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_106_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_107: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_107_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_107_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_107_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_107_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_108: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_108_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_108_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_108_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_108_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_109: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_109_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_109_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_109_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_109_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_110: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_110_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_110_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_110_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_110_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_111: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_111_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_111_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_111_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_111_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_112: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_112_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_112_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_112_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_112_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_113: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_113_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_113_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_113_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_113_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_114: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_114_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_114_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_114_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_114_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_115: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_115_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_115_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_115_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_115_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_116: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_116_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_116_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_116_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_116_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_117: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_117_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_117_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_117_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_117_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_118: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_118_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_118_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_118_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_118_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_119: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_119_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_119_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_119_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_119_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_120: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_120_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_120_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_120_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_120_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_121: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_121_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_121_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_121_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_121_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_122: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_122_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_122_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_122_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_122_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_123: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_123_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_123_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_123_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_123_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_124: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_124_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_124_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_124_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_124_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_125: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_125_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_125_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_125_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_125_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_126: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_126_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_126_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_126_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_126_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_127: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_127_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_127_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_127_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_127_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_128: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_128_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_128_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_128_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_128_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_129: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_129_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_129_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_129_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_129_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_130: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_130_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_130_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_130_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_130_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_131: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_131_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_131_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_131_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_131_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_132: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_132_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_132_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_132_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_132_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_133: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_133_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_133_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_133_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_133_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_134: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_134_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_134_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_134_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_134_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_135: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_135_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_135_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_135_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_135_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_136: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_136_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_136_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_136_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_136_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_137: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_137_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_137_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_137_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_137_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_138: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_138_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_138_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_138_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_138_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_139: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_139_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_139_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_139_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_139_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_140: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_140_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_140_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_140_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_140_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_141: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_141_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_141_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_141_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_141_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_142: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_142_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_142_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_142_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_142_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_143: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_143_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_143_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_143_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_143_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_144: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_144_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_144_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_144_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_144_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_145: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_145_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_145_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_145_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_145_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_146: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_146_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_146_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_146_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_146_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_147: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_147_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_147_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_147_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_147_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_148: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_148_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_148_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_148_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_148_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_149: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_149_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_149_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_149_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_149_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_150: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_150_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_150_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_150_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_150_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_151: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_151_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_151_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_151_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_151_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_152: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_152_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_152_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_152_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_152_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_153: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_153_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_153_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_153_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_153_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_154: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_154_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_154_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_154_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_154_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_155: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_155_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_155_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_155_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_155_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_156: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_156_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_156_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_156_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_156_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_157: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_157_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_157_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_157_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_157_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_158: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_158_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_158_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_158_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_158_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_159: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_159_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_159_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_159_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_159_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_160: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_160_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_160_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_160_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_160_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_161: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_161_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_161_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_161_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_161_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_162: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_162_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_162_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_162_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_162_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_163: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_163_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_163_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_163_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_163_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_164: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_164_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_164_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_164_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_164_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_165: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_165_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_165_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_165_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_165_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_166: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_166_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_166_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_166_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_166_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_167: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_167_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_167_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_167_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_167_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_168: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_168_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_168_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_168_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_168_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_169: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_169_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_169_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_169_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_169_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_170: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_170_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_170_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_170_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_170_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_171: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_171_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_171_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_171_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_171_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_172: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_172_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_172_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_172_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_172_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_173: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_173_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_173_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_173_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_173_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_174: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_174_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_174_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_174_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_174_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_175: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_175_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_175_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_175_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_175_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_176: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_176_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_176_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_176_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_176_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_177: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_177_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_177_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_177_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_177_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_178: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_178_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_178_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_178_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_178_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_179: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_179_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_179_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_179_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_179_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_180: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_180_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_180_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_180_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_180_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_181: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_181_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_181_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_181_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_181_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_182: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_182_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_182_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_182_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_182_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_183: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_183_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_183_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_183_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_183_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_184: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_184_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_184_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_184_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_184_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_185: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_185_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_185_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_185_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_185_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_186: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_186_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_186_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_186_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_186_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_187: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_187_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_187_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_187_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_187_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_188: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_188_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_188_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_188_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_188_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_189: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_189_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_189_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_189_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_189_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_190: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_190_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_190_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_190_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_190_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_191: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_191_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_191_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_191_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_191_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_192: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_192_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_192_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_192_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_192_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_193: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_193_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_193_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_193_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_193_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_194: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_194_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_194_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_194_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_194_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_195: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_195_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_195_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_195_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_195_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_196: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_196_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_196_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_196_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_196_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_197: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_197_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_197_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_197_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_197_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_198: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_198_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_198_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_198_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_198_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_199: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_199_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_199_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_199_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_199_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_200: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_200_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_200_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_200_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_200_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_201: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_201_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_201_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_201_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_201_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_202: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_202_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_202_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_202_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_202_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_203: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_203_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_203_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_203_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_203_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_204: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_204_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_204_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_204_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_204_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_205: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_205_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_205_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_205_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_205_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_206: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_206_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_206_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_206_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_206_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_207: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_207_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_207_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_207_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_207_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_208: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_208_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_208_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_208_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_208_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_209: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_209_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_209_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_209_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_209_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_210: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_210_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_210_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_210_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_210_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_211: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_211_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_211_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_211_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_211_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_212: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_212_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_212_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_212_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_212_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_213: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_213_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_213_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_213_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_213_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_214: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_214_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_214_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_214_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_214_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_215: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_215_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_215_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_215_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_215_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_216: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_216_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_216_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_216_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_216_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_217: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_217_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_217_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_217_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_217_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_218: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_218_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_218_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_218_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_218_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_219: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_219_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_219_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_219_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_219_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_220: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_220_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_220_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_220_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_220_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_221: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_221_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_221_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_221_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_221_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_222: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_222_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_222_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_222_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_222_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_223: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_223_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_223_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_223_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_223_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_224: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_224_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_224_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_224_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_224_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_225: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_225_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_225_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_225_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_225_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_226: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_226_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_226_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_226_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_226_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_227: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_227_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_227_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_227_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_227_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_228: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_228_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_228_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_228_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_228_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_229: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_229_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_229_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_229_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_229_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_230: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_230_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_230_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_230_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_230_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_231: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_231_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_231_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_231_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_231_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_232: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_232_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_232_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_232_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_232_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_233: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_233_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_233_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_233_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_233_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_234: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_234_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_234_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_234_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_234_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_235: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_235_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_235_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_235_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_235_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_236: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_236_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_236_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_236_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_236_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_237: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_237_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_237_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_237_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_237_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_238: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_238_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_238_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_238_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_238_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_239: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_239_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_239_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_239_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_239_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_240: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_240_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_240_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_240_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_240_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_241: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_241_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_241_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_241_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_241_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_242: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_242_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_242_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_242_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_242_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_243: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_243_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_243_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_243_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_243_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_244: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_244_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_244_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_244_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_244_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_245: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_245_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_245_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_245_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_245_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_246: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_246_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_246_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_246_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_246_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_247: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_247_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_247_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_247_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_247_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_248: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_248_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_248_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_248_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_248_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_249: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_249_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_249_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_249_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_249_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_250: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_250_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_250_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_250_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_250_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_251: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_251_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_251_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_251_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_251_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_252: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_252_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_252_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_252_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_252_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_253: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_253_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_253_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_253_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_253_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_254: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_254_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_254_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_254_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_254_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_255: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_255_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_255_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_255_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_255_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_256: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_256_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_256_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_256_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_256_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_257: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_257_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_257_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_257_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_257_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_258: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_258_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_258_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_258_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_258_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_259: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_259_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_259_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_259_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_259_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_260: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_260_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_260_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_260_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_260_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_261: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_261_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_261_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_261_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_261_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_262: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_262_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_262_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_262_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_262_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_263: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_263_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_263_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_263_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_263_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_264: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_264_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_264_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_264_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_264_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_265: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_265_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_265_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_265_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_265_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_266: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_266_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_266_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_266_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_266_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_267: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_267_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_267_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_267_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_267_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_268: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_268_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_268_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_268_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_268_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_269: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_269_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_269_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_269_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_269_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_270: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_270_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_270_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_270_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_270_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_271: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_271_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_271_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_271_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_271_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_272: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_272_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_272_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_272_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_272_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_273: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_273_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_273_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_273_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_273_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_274: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_274_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_274_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_274_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_274_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_275: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_275_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_275_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_275_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_275_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_276: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_276_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_276_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_276_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_276_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_277: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_277_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_277_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_277_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_277_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_278: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_278_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_278_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_278_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_278_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_279: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_279_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_279_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_279_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_279_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_280: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_280_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_280_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_280_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_280_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_281: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_281_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_281_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_281_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_281_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_282: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_282_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_282_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_282_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_282_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_283: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_283_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_283_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_283_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_283_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_284: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_284_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_284_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_284_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_284_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_285: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_285_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_285_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_285_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_285_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_286: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_286_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_286_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_286_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_286_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_287: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_287_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_287_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_287_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_287_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_288: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_288_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_288_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_288_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_288_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_289: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_289_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_289_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_289_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_289_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_290: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_290_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_290_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_290_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_290_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_291: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_291_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_291_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_291_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_291_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_292: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_292_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_292_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_292_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_292_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_293: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_293_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_293_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_293_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_293_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_294: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_294_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_294_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_294_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_294_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_295: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_295_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_295_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_295_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_295_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_296: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_296_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_296_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_296_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_296_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_297: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_297_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_297_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_297_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_297_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_298: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_298_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_298_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_298_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_298_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_299: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_299_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_299_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_299_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_299_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_300: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_300_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_300_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_300_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_300_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_301: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_301_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_301_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_301_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_301_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_302: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_302_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_302_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_302_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_302_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_303: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_303_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_303_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_303_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_303_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_304: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_304_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_304_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_304_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_304_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_305: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_305_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_305_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_305_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_305_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_306: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_306_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_306_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_306_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_306_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_307: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_307_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_307_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_307_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_307_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_308: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_308_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_308_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_308_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_308_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_309: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_309_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_309_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_309_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_309_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_310: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_310_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_310_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_310_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_310_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_311: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_311_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_311_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_311_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_311_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_312: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_312_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_312_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_312_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_312_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_313: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_313_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_313_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_313_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_313_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_314: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_314_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_314_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_314_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_314_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_315: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_315_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_315_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_315_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_315_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_316: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_316_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_316_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_316_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_316_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_317: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_317_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_317_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_317_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_317_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_318: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_318_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_318_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_318_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_318_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_319: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_319_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_319_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_319_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_319_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_320: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_320_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_320_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_320_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_320_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_321: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_321_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_321_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_321_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_321_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_322: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_322_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_322_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_322_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_322_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_323: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_323_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_323_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_323_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_323_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_324: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_324_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_324_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_324_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_324_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_325: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_325_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_325_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_325_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_325_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_326: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_326_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_326_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_326_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_326_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_327: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_327_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_327_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_327_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_327_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_328: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_328_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_328_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_328_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_328_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_329: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_329_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_329_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_329_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_329_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_330: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_330_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_330_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_330_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_330_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_331: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_331_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_331_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_331_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_331_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_332: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_332_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_332_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_332_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_332_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_333: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_333_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_333_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_333_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_333_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_334: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_334_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_334_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_334_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_334_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_335: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_335_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_335_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_335_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_335_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_336: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_336_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_336_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_336_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_336_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_337: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_337_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_337_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_337_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_337_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_338: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_338_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_338_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_338_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_338_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_339: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_339_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_339_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_339_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_339_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_340: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_340_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_340_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_340_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_340_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_341: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_341_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_341_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_341_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_341_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_342: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_342_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_342_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_342_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_342_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_343: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_343_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_343_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_343_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_343_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_344: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_344_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_344_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_344_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_344_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_345: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_345_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_345_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_345_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_345_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_346: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_346_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_346_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_346_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_346_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_347: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_347_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_347_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_347_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_347_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_348: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_348_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_348_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_348_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_348_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_349: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_349_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_349_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_349_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_349_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_350: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_350_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_350_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_350_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_350_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_351: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_351_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_351_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_351_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_351_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_352: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_352_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_352_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_352_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_352_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_353: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_353_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_353_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_353_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_353_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_354: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_354_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_354_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_354_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_354_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_355: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_355_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_355_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_355_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_355_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_356: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_356_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_356_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_356_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_356_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_357: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_357_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_357_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_357_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_357_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_358: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_358_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_358_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_358_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_358_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_359: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_359_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_359_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_359_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_359_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_360: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_360_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_360_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_360_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_360_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_361: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_361_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_361_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_361_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_361_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_362: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_362_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_362_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_362_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_362_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_363: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_363_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_363_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_363_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_363_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_364: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_364_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_364_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_364_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_364_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_365: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_365_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_365_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_365_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_365_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_366: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_366_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_366_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_366_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_366_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_367: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_367_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_367_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_367_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_367_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_368: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_368_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_368_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_368_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_368_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_369: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_369_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_369_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_369_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_369_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_370: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_370_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_370_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_370_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_370_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_371: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_371_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_371_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_371_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_371_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_372: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_372_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_372_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_372_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_372_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_373: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_373_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_373_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_373_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_373_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_374: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_374_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_374_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_374_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_374_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_375: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_375_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_375_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_375_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_375_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_376: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_376_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_376_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_376_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_376_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_377: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_377_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_377_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_377_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_377_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_378: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_378_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_378_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_378_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_378_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_379: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_379_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_379_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_379_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_379_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_380: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_380_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_380_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_380_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_380_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_381: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_381_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_381_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_381_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_381_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_382: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_382_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_382_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_382_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_382_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_383: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_383_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_383_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_383_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_383_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_384: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_384_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_384_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_384_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_384_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_385: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_385_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_385_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_385_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_385_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_386: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_386_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_386_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_386_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_386_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_387: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_387_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_387_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_387_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_387_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_388: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_388_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_388_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_388_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_388_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_389: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_389_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_389_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_389_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_389_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_390: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_390_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_390_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_390_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_390_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_391: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_391_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_391_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_391_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_391_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_392: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_392_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_392_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_392_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_392_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_393: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_393_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_393_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_393_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_393_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_394: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_394_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_394_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_394_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_394_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_395: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_395_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_395_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_395_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_395_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_396: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_396_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_396_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_396_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_396_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_397: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_397_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_397_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_397_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_397_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_398: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_398_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_398_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_398_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_398_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_399: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_399_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_399_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_399_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_399_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_400: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_400_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_400_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_400_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_400_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_401: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_401_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_401_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_401_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_401_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_402: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_402_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_402_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_402_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_402_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_403: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_403_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_403_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_403_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_403_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_404: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_404_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_404_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_404_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_404_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_405: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_405_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_405_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_405_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_405_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_406: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_406_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_406_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_406_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_406_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_407: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_407_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_407_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_407_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_407_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_408: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_408_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_408_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_408_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_408_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_409: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_409_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_409_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_409_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_409_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_410: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_410_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_410_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_410_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_410_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_411: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_411_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_411_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_411_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_411_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_412: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_412_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_412_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_412_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_412_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_413: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_413_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_413_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_413_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_413_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_414: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_414_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_414_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_414_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_414_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_415: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_415_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_415_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_415_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_415_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_416: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_416_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_416_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_416_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_416_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_417: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_417_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_417_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_417_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_417_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_418: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_418_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_418_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_418_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_418_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_419: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_419_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_419_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_419_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_419_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_420: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_420_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_420_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_420_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_420_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_421: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_421_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_421_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_421_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_421_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_422: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_422_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_422_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_422_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_422_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_423: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_423_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_423_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_423_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_423_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_424: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_424_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_424_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_424_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_424_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_425: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_425_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_425_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_425_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_425_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_426: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_426_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_426_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_426_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_426_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_427: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_427_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_427_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_427_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_427_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_428: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_428_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_428_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_428_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_428_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_429: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_429_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_429_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_429_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_429_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_430: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_430_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_430_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_430_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_430_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_431: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_431_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_431_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_431_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_431_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_432: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_432_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_432_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_432_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_432_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_433: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_433_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_433_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_433_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_433_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_434: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_434_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_434_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_434_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_434_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_435: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_435_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_435_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_435_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_435_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_436: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_436_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_436_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_436_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_436_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_437: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_437_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_437_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_437_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_437_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_438: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_438_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_438_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_438_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_438_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_439: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_439_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_439_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_439_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_439_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_440: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_440_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_440_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_440_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_440_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_441: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_441_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_441_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_441_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_441_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_442: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_442_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_442_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_442_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_442_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_443: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_443_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_443_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_443_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_443_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_444: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_444_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_444_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_444_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_444_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_445: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_445_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_445_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_445_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_445_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_446: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_446_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_446_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_446_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_446_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_447: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_447_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_447_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_447_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_447_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_448: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_448_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_448_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_448_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_448_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_449: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_449_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_449_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_449_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_449_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_450: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_450_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_450_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_450_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_450_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_451: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_451_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_451_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_451_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_451_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_452: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_452_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_452_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_452_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_452_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_453: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_453_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_453_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_453_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_453_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_454: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_454_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_454_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_454_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_454_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_455: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_455_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_455_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_455_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_455_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_456: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_456_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_456_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_456_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_456_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_457: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_457_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_457_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_457_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_457_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_458: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_458_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_458_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_458_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_458_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_459: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_459_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_459_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_459_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_459_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_460: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_460_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_460_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_460_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_460_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_461: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_461_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_461_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_461_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_461_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_462: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_462_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_462_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_462_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_462_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_463: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_463_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_463_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_463_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_463_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_464: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_464_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_464_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_464_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_464_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_465: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_465_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_465_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_465_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_465_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_466: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_466_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_466_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_466_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_466_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_467: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_467_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_467_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_467_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_467_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_468: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_468_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_468_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_468_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_468_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_469: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_469_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_469_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_469_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_469_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_470: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_470_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_470_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_470_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_470_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_471: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_471_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_471_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_471_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_471_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_472: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_472_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_472_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_472_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_472_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_473: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_473_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_473_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_473_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_473_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_474: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_474_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_474_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_474_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_474_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_475: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_475_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_475_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_475_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_475_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_476: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_476_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_476_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_476_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_476_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_477: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_477_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_477_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_477_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_477_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_478: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_478_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_478_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_478_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_478_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_479: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_479_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_479_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_479_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_479_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_480: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_480_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_480_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_480_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_480_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_481: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_481_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_481_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_481_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_481_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_482: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_482_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_482_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_482_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_482_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_483: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_483_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_483_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_483_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_483_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_484: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_484_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_484_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_484_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_484_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_485: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_485_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_485_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_485_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_485_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_486: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_486_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_486_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_486_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_486_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_487: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_487_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_487_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_487_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_487_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_488: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_488_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_488_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_488_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_488_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_489: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_489_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_489_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_489_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_489_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_490: Shared Packet RAM for multiple Link Layer usage.
	// Position of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_490_LSBYTE_Pos = 0x0
	// Bit mask of LSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_490_LSBYTE_Msk = 0xff
	// Position of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_490_MSBYTE_Pos = 0x8
	// Bit mask of MSBYTE field.
	XCVR_PKT_RAM_PACKET_RAM_0_490_MSBYTE_Msk = 0xff00

	// PACKET_RAM_0_491: Shared Packet RAM for multiple Link Layer usage.
	// Position o