/*
 * Decompiled with CFR 0.152.
 */
package org.ice4j.ice;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ice4j.TransportAddress;
import org.ice4j.ice.Agent;
import org.ice4j.ice.Candidate;
import org.ice4j.ice.CandidatePair;
import org.ice4j.ice.CandidatePrioritizer;
import org.ice4j.ice.CandidateType;
import org.ice4j.ice.CheckList;
import org.ice4j.ice.CheckListState;
import org.ice4j.ice.IceMediaStream;
import org.ice4j.ice.LocalCandidate;
import org.ice4j.ice.RemoteCandidate;
import org.ice4j.ice.UPNPCandidate;

public class Component {
    private static final Logger logger = Logger.getLogger(Component.class.getName());
    public static final int RTP = 1;
    public static final int RTCP = 2;
    private final int componentID;
    private final IceMediaStream parentStream;
    private final List<LocalCandidate> localCandidates = new LinkedList<LocalCandidate>();
    private final List<RemoteCandidate> remoteCandidates = new LinkedList<RemoteCandidate>();
    private final List<RemoteCandidate> remoteUpdateCandidates = new LinkedList<RemoteCandidate>();
    private final CandidatePrioritizer candidatePrioritizer = new CandidatePrioritizer();
    private LocalCandidate defaultCandidate = null;
    private CandidatePair selectedPair;
    private Candidate<?> defaultRemoteCandidate = null;

    protected Component(int componentID, IceMediaStream mediaStream) {
        this.componentID = componentID;
        this.parentStream = mediaStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addLocalCandidate(LocalCandidate candidate) {
        Agent agent = this.getParentStream().getParentAgent();
        agent.getFoundationsRegistry().assignFoundation(candidate);
        candidate.computePriority();
        List<LocalCandidate> list = this.localCandidates;
        synchronized (list) {
            LocalCandidate redundantCandidate = this.findRedundant(candidate);
            if (redundantCandidate != null) {
                return false;
            }
            this.localCandidates.add(candidate);
            Collections.sort(this.localCandidates);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<LocalCandidate> getLocalCandidates() {
        List<LocalCandidate> list = this.localCandidates;
        synchronized (list) {
            return new ArrayList<LocalCandidate>(this.localCandidates);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int countLocalHostCandidates() {
        List<LocalCandidate> list = this.localCandidates;
        synchronized (list) {
            int count = 0;
            for (Candidate candidate : this.localCandidates) {
                if (candidate.getType() != CandidateType.HOST_CANDIDATE || candidate.isVirtual()) continue;
                ++count;
            }
            return count;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLocalCandidateCount() {
        List<LocalCandidate> list = this.localCandidates;
        synchronized (list) {
            return this.localCandidates.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRemoteCandidate(RemoteCandidate candidate) {
        logger.info("Add remote candidate for " + this.toShortString() + ": " + candidate.toShortString());
        List<RemoteCandidate> list = this.remoteCandidates;
        synchronized (list) {
            this.remoteCandidates.add(candidate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addUpdateRemoteCandidates(RemoteCandidate candidate) {
        logger.info("Update remote candidate for " + this.toShortString() + ": " + candidate.getTransportAddress());
        LinkedList<RemoteCandidate> existingCandidates = new LinkedList<RemoteCandidate>();
        List<RemoteCandidate> list = this.remoteCandidates;
        synchronized (list) {
            existingCandidates.addAll(this.remoteCandidates);
        }
        list = this.remoteUpdateCandidates;
        synchronized (list) {
            existingCandidates.addAll(this.remoteUpdateCandidates);
            TransportAddress transportAddress = candidate.getTransportAddress();
            CandidateType type = candidate.getType();
            for (RemoteCandidate existingCandidate : existingCandidates) {
                if (!transportAddress.equals(existingCandidate.getTransportAddress()) || type != existingCandidate.getType()) continue;
                logger.info("Not adding duplicate remote candidate: " + candidate.getTransportAddress());
                return;
            }
            this.remoteUpdateCandidates.add(candidate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateRemoteCandidates() {
        Vector<CandidatePair> checkList;
        LinkedList<RemoteCandidate> newRemoteCandidates;
        List<RemoteCandidate> list = this.remoteUpdateCandidates;
        synchronized (list) {
            if (this.remoteUpdateCandidates.size() == 0) {
                return;
            }
            newRemoteCandidates = new LinkedList<RemoteCandidate>(this.remoteUpdateCandidates);
            List<LocalCandidate> localCnds = this.getLocalCandidates();
            LocalCandidate upnpBase = null;
            for (LocalCandidate lc : localCnds) {
                if (!(lc instanceof UPNPCandidate)) continue;
                upnpBase = (LocalCandidate)lc.getBase();
            }
            checkList = new Vector<CandidatePair>();
            for (LocalCandidate localCnd : localCnds) {
                if (localCnd == upnpBase) continue;
                for (RemoteCandidate remoteCnd : this.remoteUpdateCandidates) {
                    if (!localCnd.canReach(remoteCnd) || remoteCnd.getTransportAddress().getPort() == 0) continue;
                    CandidatePair pair = this.getParentStream().getParentAgent().createCandidatePair(localCnd, remoteCnd);
                    logger.info("new Pair added: " + pair.toShortString());
                    checkList.add(pair);
                }
            }
            this.remoteUpdateCandidates.clear();
        }
        list = this.remoteCandidates;
        synchronized (list) {
            this.remoteCandidates.addAll(newRemoteCandidates);
        }
        Collections.sort(checkList, CandidatePair.comparator);
        this.parentStream.pruneCheckList(checkList);
        if (this.parentStream.getCheckList().getState().equals((Object)CheckListState.RUNNING)) {
            CheckList streamCheckList;
            CheckList checkList2 = streamCheckList = this.parentStream.getCheckList();
            synchronized (checkList2) {
                for (CandidatePair pair : checkList) {
                    streamCheckList.add(pair);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<RemoteCandidate> getRemoteCandidates() {
        List<RemoteCandidate> list = this.remoteCandidates;
        synchronized (list) {
            return new ArrayList<RemoteCandidate>(this.remoteCandidates);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRemoteCandidates(List<RemoteCandidate> candidates) {
        List<RemoteCandidate> list = this.remoteCandidates;
        synchronized (list) {
            this.remoteCandidates.addAll(candidates);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRemoteCandidateCount() {
        List<RemoteCandidate> list = this.remoteCandidates;
        synchronized (list) {
            return this.remoteCandidates.size();
        }
    }

    public IceMediaStream getParentStream() {
        return this.parentStream;
    }

    public int getComponentID() {
        return this.componentID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuffer buff = new StringBuffer("Component id=").append(this.getComponentID());
        buff.append(" parent stream=").append(this.getParentStream().getName());
        int localCandidatesCount = this.getLocalCandidateCount();
        if (localCandidatesCount > 0) {
            buff.append("\n").append(localCandidatesCount).append(" Local candidates:");
            buff.append("\ndefault candidate: ").append(this.getDefaultCandidate());
            List<LocalCandidate> list = this.localCandidates;
            synchronized (list) {
                for (Candidate candidate : this.localCandidates) {
                    buff.append('\n').append(candidate.toString());
                }
            }
        } else {
            buff.append("\nno local candidates.");
        }
        int remoteCandidatesCount = this.getRemoteCandidateCount();
        if (remoteCandidatesCount > 0) {
            buff.append("\n").append(remoteCandidatesCount).append(" Remote candidates:");
            buff.append("\ndefault remote candidate: ").append(this.getDefaultRemoteCandidate());
            List<RemoteCandidate> list = this.remoteCandidates;
            synchronized (list) {
                for (RemoteCandidate cand : this.remoteCandidates) {
                    buff.append("\n").append(cand);
                }
            }
        } else {
            buff.append("\nno remote candidates.");
        }
        return buff.toString();
    }

    public String toShortString() {
        return this.parentStream.getName() + "." + this.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    protected void prioritizeCandidates() {
        List<LocalCandidate> list = this.localCandidates;
        synchronized (list) {
            LocalCandidate[] candidates = new LocalCandidate[this.localCandidates.size()];
            this.localCandidates.toArray(candidates);
            for (LocalCandidate cand : candidates) {
                cand.computePriority();
            }
            Arrays.sort(candidates, this.candidatePrioritizer);
            this.localCandidates.clear();
            for (LocalCandidate cand : candidates) {
                this.localCandidates.add(cand);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    protected void eliminateRedundantCandidates() {
        List<LocalCandidate> list = this.localCandidates;
        synchronized (list) {
            for (int i = 0; i < this.localCandidates.size(); ++i) {
                LocalCandidate cand = this.localCandidates.get(i);
                int j = i + 1;
                while (j < this.localCandidates.size()) {
                    LocalCandidate cand2 = this.localCandidates.get(j);
                    if (cand != cand2 && cand.getTransportAddress().equals(cand2.getTransportAddress()) && ((LocalCandidate)cand.getBase()).equals(cand2.getBase()) && cand.getPriority() >= cand2.getPriority()) {
                        this.localCandidates.remove(j);
                        if (!logger.isLoggable(Level.FINEST)) continue;
                        logger.finest("eliminating redundant cand: " + cand2);
                        continue;
                    }
                    ++j;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LocalCandidate findRedundant(LocalCandidate cand) {
        List<LocalCandidate> list = this.localCandidates;
        synchronized (list) {
            for (LocalCandidate redundantCand : this.localCandidates) {
                if (cand == redundantCand || !cand.getTransportAddress().equals(redundantCand.getTransportAddress()) || !((LocalCandidate)cand.getBase()).equals(redundantCand.getBase())) continue;
                return redundantCand;
            }
        }
        return null;
    }

    public LocalCandidate getDefaultCandidate() {
        return this.defaultCandidate;
    }

    public Candidate<?> getDefaultRemoteCandidate() {
        return this.defaultRemoteCandidate;
    }

    public void setDefaultRemoteCandidate(Candidate<?> candidate) {
        this.defaultRemoteCandidate = candidate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void selectDefaultCandidate() {
        List<LocalCandidate> list = this.localCandidates;
        synchronized (list) {
            for (LocalCandidate cand : this.localCandidates) {
                if (this.defaultCandidate != null && this.defaultCandidate.getDefaultPreference() >= cand.getDefaultPreference()) continue;
                this.defaultCandidate = cand;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void free() {
        List<LocalCandidate> list = this.localCandidates;
        synchronized (list) {
            CandidateType[] candidateTypes;
            for (CandidateType candidateType : candidateTypes = new CandidateType[]{CandidateType.RELAYED_CANDIDATE, CandidateType.PEER_REFLEXIVE_CANDIDATE, CandidateType.SERVER_REFLEXIVE_CANDIDATE}) {
                Iterator<LocalCandidate> localCandidateIter = this.localCandidates.iterator();
                while (localCandidateIter.hasNext()) {
                    LocalCandidate localCandidate = localCandidateIter.next();
                    if (!candidateType.equals((Object)localCandidate.getType())) continue;
                    this.free(localCandidate);
                    localCandidateIter.remove();
                }
            }
            Iterator<LocalCandidate> localCandidateIter = this.localCandidates.iterator();
            while (localCandidateIter.hasNext()) {
                LocalCandidate localCandidate = localCandidateIter.next();
                this.free(localCandidate);
                localCandidateIter.remove();
            }
        }
    }

    private void free(LocalCandidate localCandidate) {
        block3: {
            try {
                localCandidate.free();
            }
            catch (Throwable t) {
                if (t instanceof ThreadDeath) {
                    throw (ThreadDeath)t;
                }
                if (!logger.isLoggable(Level.INFO)) break block3;
                logger.log(Level.INFO, "Failed to free LocalCandidate: " + localCandidate);
            }
        }
    }

    public LocalCandidate findLocalCandidate(TransportAddress localAddress) {
        for (LocalCandidate localCnd : this.localCandidates) {
            if (!localCnd.getTransportAddress().equals(localAddress)) continue;
            return localCnd;
        }
        return null;
    }

    public RemoteCandidate findRemoteCandidate(TransportAddress remoteAddress) {
        for (RemoteCandidate remoteCnd : this.remoteCandidates) {
            if (!remoteCnd.getTransportAddress().equals(remoteAddress)) continue;
            return remoteCnd;
        }
        return null;
    }

    protected void setSelectedPair(CandidatePair pair) {
        this.selectedPair = pair;
    }

    public CandidatePair getSelectedPair() {
        return this.selectedPair;
    }

    public String getName() {
        if (this.componentID == 1) {
            return "RTP";
        }
        if (this.componentID == 2) {
            return "RTCP";
        }
        return Integer.toString(this.componentID);
    }

    public static Component build(int componentID, IceMediaStream mediaStream) {
        return new Component(componentID, mediaStream);
    }
}

