/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.params;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.jdesktop.swingx.JXTable;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.extension.AbstractPanel;
import org.parosproxy.paros.model.SiteNode;
import org.parosproxy.paros.network.HtmlParameter;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.extension.params.ExtensionParams;
import org.zaproxy.zap.extension.params.HtmlParameterStats;
import org.zaproxy.zap.extension.params.ParamsTableModel;
import org.zaproxy.zap.extension.params.SiteParameters;
import org.zaproxy.zap.utils.SortedComboBoxModel;
import org.zaproxy.zap.utils.TableExportButton;
import org.zaproxy.zap.view.ScanPanel;

public class ParamsPanel
extends AbstractPanel {
    private static final long serialVersionUID = 1L;
    public static final String PANEL_NAME = "params";
    private ExtensionParams extension = null;
    private JPanel panelCommand = null;
    private JToolBar panelToolbar = null;
    private JScrollPane jScrollPane = null;
    private String currentSite = null;
    private JComboBox<String> siteSelect = null;
    private SortedComboBoxModel<String> siteModel = new SortedComboBoxModel();
    private JXTable paramsTable = null;
    private ParamsTableModel paramsModel = new ParamsTableModel();
    private TableExportButton<JXTable> exportButton = null;

    public ParamsPanel(ExtensionParams extension) {
        this.extension = extension;
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new CardLayout());
        this.setSize(474, 251);
        this.setName(Constant.messages.getString("params.panel.title"));
        this.setIcon(new ImageIcon(ParamsPanel.class.getResource("/resource/icon/16/179.png")));
        this.setDefaultAccelerator(this.extension.getView().getMenuShortcutKeyStroke(80, 64, false));
        this.setMnemonic(Constant.messages.getChar("params.panel.mnemonic"));
        this.add((Component)this.getPanelCommand(), this.getPanelCommand().getName());
    }

    private JPanel getPanelCommand() {
        if (this.panelCommand == null) {
            this.panelCommand = new JPanel();
            this.panelCommand.setLayout(new GridBagLayout());
            this.panelCommand.setName("Params");
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints1.gridx = 0;
            gridBagConstraints1.gridy = 0;
            gridBagConstraints1.insets = new Insets(2, 2, 2, 2);
            gridBagConstraints1.anchor = 18;
            gridBagConstraints1.fill = 2;
            gridBagConstraints1.weightx = 1.0;
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.gridy = 1;
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.weighty = 1.0;
            gridBagConstraints2.fill = 1;
            gridBagConstraints2.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints2.anchor = 18;
            this.panelCommand.add((Component)this.getPanelToolbar(), gridBagConstraints1);
            this.panelCommand.add((Component)this.getJScrollPane(), gridBagConstraints2);
        }
        return this.panelCommand;
    }

    private JToolBar getPanelToolbar() {
        if (this.panelToolbar == null) {
            this.panelToolbar = new JToolBar();
            this.panelToolbar.setLayout(new GridBagLayout());
            this.panelToolbar.setEnabled(true);
            this.panelToolbar.setFloatable(false);
            this.panelToolbar.setRollover(true);
            this.panelToolbar.setPreferredSize(new Dimension(800, 30));
            this.panelToolbar.setName("ParamsToolbar");
            GridBagConstraints gridBagConstraints0 = new GridBagConstraints();
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            GridBagConstraints gridBagConstraintsx = new GridBagConstraints();
            gridBagConstraints0.gridx = 0;
            gridBagConstraints0.gridy = 0;
            gridBagConstraints0.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints0.anchor = 17;
            gridBagConstraints1.gridx = 1;
            gridBagConstraints1.gridy = 0;
            gridBagConstraints1.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints1.anchor = 17;
            gridBagConstraints2.gridx = 2;
            gridBagConstraints2.gridy = 0;
            gridBagConstraints2.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints2.anchor = 17;
            gridBagConstraints3.gridx = 3;
            gridBagConstraints3.gridy = 0;
            gridBagConstraints3.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints3.anchor = 17;
            gridBagConstraintsx.gridx = 4;
            gridBagConstraintsx.gridy = 0;
            gridBagConstraintsx.weightx = 1.0;
            gridBagConstraintsx.weighty = 1.0;
            gridBagConstraintsx.insets = new Insets(0, 0, 0, 0);
            gridBagConstraintsx.anchor = 13;
            gridBagConstraintsx.fill = 2;
            JLabel t1 = new JLabel();
            this.panelToolbar.add((Component)new JLabel(Constant.messages.getString("params.toolbar.site.label")), gridBagConstraints1);
            this.panelToolbar.add(this.getSiteSelect(), gridBagConstraints2);
            this.panelToolbar.add(this.getExportButton(), gridBagConstraints3);
            this.panelToolbar.add((Component)t1, gridBagConstraintsx);
        }
        return this.panelToolbar;
    }

    private TableExportButton<JXTable> getExportButton() {
        if (this.exportButton == null) {
            this.exportButton = new TableExportButton<JXTable>(this.getParamsTable());
        }
        return this.exportButton;
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setViewportView((Component)this.getParamsTable());
        }
        return this.jScrollPane;
    }

    private void setParamsTableColumnSizes() {
        for (int i = 0; i < this.paramsTable.getColumnCount(); ++i) {
            DefaultTableColumnModel colModel = (DefaultTableColumnModel)this.paramsTable.getColumnModel();
            TableColumn col = colModel.getColumn(i);
            int width = 0;
            TableCellRenderer renderer = col.getHeaderRenderer();
            if (renderer == null) {
                renderer = this.paramsTable.getTableHeader().getDefaultRenderer();
            }
            Component comp = renderer.getTableCellRendererComponent((JTable)this.paramsTable, col.getHeaderValue(), false, false, 0, 0);
            width = comp.getPreferredSize().width;
            col.setPreferredWidth(width + 2);
        }
        this.paramsTable.getColumnModel().getColumn(6).setPreferredWidth(999);
    }

    protected JXTable getParamsTable() {
        if (this.paramsTable == null) {
            this.paramsTable = new JXTable((TableModel)this.paramsModel);
            this.paramsTable.setColumnSelectionAllowed(false);
            this.paramsTable.setCellSelectionEnabled(false);
            this.paramsTable.setRowSelectionAllowed(true);
            this.paramsTable.setAutoCreateRowSorter(true);
            this.paramsTable.setColumnControlVisible(true);
            this.setParamsTableColumnSizes();
            this.paramsTable.setName(PANEL_NAME);
            this.paramsTable.setDoubleBuffered(true);
            this.paramsTable.addMouseListener((MouseListener)new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    this.showPopupMenuIfTriggered(e);
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    this.showPopupMenuIfTriggered(e);
                }

                private void showPopupMenuIfTriggered(MouseEvent e) {
                    if (e.isPopupTrigger()) {
                        int row = ParamsPanel.this.paramsTable.rowAtPoint(e.getPoint());
                        if (row < 0 || !ParamsPanel.this.paramsTable.getSelectionModel().isSelectedIndex(row)) {
                            ParamsPanel.this.paramsTable.getSelectionModel().clearSelection();
                            if (row >= 0) {
                                ParamsPanel.this.paramsTable.getSelectionModel().setSelectionInterval(row, row);
                            }
                        }
                        View.getSingleton().getPopupMenu().show(e.getComponent(), e.getX(), e.getY());
                    }
                }
            });
        }
        return this.paramsTable;
    }

    private JComboBox<String> getSiteSelect() {
        if (this.siteSelect == null) {
            this.siteSelect = new JComboBox<String>(this.siteModel);
            this.siteSelect.addItem(Constant.messages.getString("params.toolbar.site.select"));
            this.siteSelect.setSelectedIndex(0);
            this.siteSelect.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String item = (String)ParamsPanel.this.siteSelect.getSelectedItem();
                    if (item != null && ParamsPanel.this.siteSelect.getSelectedIndex() > 0) {
                        ParamsPanel.this.siteSelected(item);
                    }
                }
            });
        }
        return this.siteSelect;
    }

    public void addSite(String site) {
        if (this.siteModel.getIndexOf(site = ScanPanel.cleanSiteName(site, true)) < 0) {
            this.siteModel.addElement(site);
            if (this.siteModel.getSize() == 2 && this.currentSite == null) {
                this.getSiteSelect().setSelectedIndex(1);
                this.siteSelected(site);
            }
        }
    }

    private void siteSelected(String site) {
        if (!(site = ScanPanel.cleanSiteName(site, true)).equals(this.currentSite)) {
            this.siteModel.setSelectedItem(site);
            this.paramsModel = this.extension.getSiteParameters(site).getModel();
            this.getParamsTable().setModel((TableModel)this.paramsModel);
            this.setParamsTableColumnSizes();
            this.currentSite = site;
        }
    }

    public void nodeSelected(SiteNode node) {
        if (node != null) {
            this.siteSelected(ScanPanel.cleanSiteName(node, true));
        }
    }

    public void reset() {
        this.currentSite = null;
        this.siteModel.removeAllElements();
        this.siteSelect.addItem(Constant.messages.getString("params.toolbar.site.select"));
        this.siteSelect.setSelectedIndex(0);
        this.paramsModel.removeAllElements();
        this.paramsModel.fireTableDataChanged();
        this.paramsTable.setModel((TableModel)this.paramsModel);
    }

    public String getCurrentSite() {
        return this.currentSite;
    }

    protected HtmlParameterStats getSelectedParam() {
        int selectedRow = this.getParamsTable().getSelectedRow();
        if (selectedRow == -1) {
            return null;
        }
        String type = (String)this.getParamsTable().getValueAt(selectedRow, 0);
        String name = (String)this.getParamsTable().getValueAt(selectedRow, 1);
        SiteParameters sps = this.extension.getSiteParameters(this.currentSite);
        if (sps != null) {
            return sps.getParam(HtmlParameter.Type.valueOf(type.toLowerCase()), name);
        }
        return null;
    }

    boolean isOnlyOneParamSelected() {
        return this.getParamsTable().getSelectedRowCount() == 1;
    }
}

