<?php

declare(strict_types=1);

/**
 * @copyright 2020 Christoph Wurst <christoph@winzerhof-wurst.at>
 *
 * @author 2020 Christoph Wurst <christoph@winzerhof-wurst.at>
 *
 * @license GNU AGPL version 3 or any later version
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

namespace OCA\Mail\Service;

use JsonSerializable;

class Quota implements JsonSerializable {

	/** @var int */
	private $usage;

	/** @var int */
	private $limit;

	public function __construct(int $usage,
								int $limit) {
		$this->usage = $usage;
		$this->limit = $limit;
	}

	public function getUsage(): int {
		return $this->usage;
	}

	public function getLimit(): int {
		return $this->limit;
	}

	public function jsonSerialize() {
		return [
			'usage' => $this->getUsage(),
			'limit' => $this->getLimit(),
		];
	}
}
