/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.heapviewer.java;

import com.sun.tools.visualvm.heapviewer.java.Bundle;
import com.sun.tools.visualvm.heapviewer.java.InstanceNode;
import com.sun.tools.visualvm.heapviewer.model.DataType;
import org.netbeans.lib.profiler.heap.ArrayItemValue;
import org.netbeans.lib.profiler.heap.Heap;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.lib.profiler.heap.JavaClass;
import org.netbeans.lib.profiler.heap.ObjectFieldValue;
import org.netbeans.lib.profiler.heap.Value;

public abstract class InstanceReferenceNode
extends InstanceNode {
    private final InstanceNode.Mode mode;
    private final Value value;
    private String fieldName;

    public InstanceReferenceNode(Value value, Instance instance, boolean incoming) {
        super(instance);
        this.value = value;
        this.mode = incoming ? InstanceNode.Mode.INCOMING_REFERENCE : InstanceNode.Mode.OUTGOING_REFERENCE;
    }

    public static InstanceReferenceNode outgoing(Value value) {
        return InstanceReferenceNode.reference(value, false);
    }

    public static InstanceReferenceNode incoming(Value value) {
        return InstanceReferenceNode.reference(value, true);
    }

    public static InstanceReferenceNode reference(Value value, boolean incoming) {
        if (value instanceof ObjectFieldValue) {
            return new Field((ObjectFieldValue)value, incoming);
        }
        if (value instanceof ArrayItemValue) {
            return new ArrayItem((ArrayItemValue)value, incoming);
        }
        return null;
    }

    @Override
    public InstanceNode.Mode getMode() {
        return this.mode;
    }

    public Value getValue() {
        return this.value;
    }

    public String getFieldName() {
        if (this.fieldName == null) {
            this.fieldName = this.computeFieldName();
        }
        return this.fieldName;
    }

    protected abstract String computeFieldName();

    @Override
    public JavaClass getJavaClass() {
        return this.getInstance() == null ? null : super.getJavaClass();
    }

    @Override
    public String getName(Heap heap) {
        return this.getInstance() == null ? "null" : super.getName(heap);
    }

    @Override
    public String getLogicalValue(Heap heap) {
        return this.getInstance() == null ? "" : super.getLogicalValue(heap);
    }

    @Override
    public long getOwnSize() {
        return this.getInstance() == null ? DataType.OWN_SIZE.getNoValue().longValue() : super.getOwnSize();
    }

    @Override
    public long getRetainedSize(Heap heap) {
        return this.getInstance() == null ? DataType.RETAINED_SIZE.getNoValue().longValue() : super.getRetainedSize(heap);
    }

    @Override
    public boolean isLeaf() {
        return this.getInstance() == null ? true : super.isLeaf();
    }

    @Override
    public String toString() {
        if (InstanceNode.Mode.INCOMING_REFERENCE.equals((Object)this.mode)) {
            return Bundle.InstanceReferenceNode_NodeNameReference(this.getFieldName(), this.getName(null));
        }
        return Bundle.InstanceReferenceNode_NodeNameField(this.getFieldName(), this.getName(null));
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InstanceReferenceNode)) {
            return false;
        }
        InstanceReferenceNode r = (InstanceReferenceNode)((Object)o);
        return this.mode == r.mode && this.value.equals(r.value);
    }

    @Override
    public int hashCode() {
        return this.value.hashCode();
    }

    public static class ArrayItem
    extends InstanceReferenceNode {
        public ArrayItem(ArrayItemValue value, boolean incoming) {
            super((Value)value, incoming ? value.getDefiningInstance() : value.getInstance(), incoming);
        }

        public ArrayItemValue getValue() {
            return (ArrayItemValue)super.getValue();
        }

        @Override
        protected String computeFieldName() {
            return "[" + this.getValue().getIndex() + "]";
        }
    }

    public static class Field
    extends InstanceReferenceNode {
        public Field(ObjectFieldValue value, boolean incoming) {
            super((Value)value, incoming ? value.getDefiningInstance() : value.getInstance(), incoming);
        }

        public ObjectFieldValue getValue() {
            return (ObjectFieldValue)super.getValue();
        }

        @Override
        protected String computeFieldName() {
            org.netbeans.lib.profiler.heap.Field field = this.getValue().getField();
            return (field.isStatic() ? "static " : "") + field.getName();
        }
    }
}

