/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.heapviewer.java;

import com.sun.tools.visualvm.heapviewer.java.PrimitiveNode;
import com.sun.tools.visualvm.heapviewer.ui.HeapViewerRenderer;
import javax.swing.Icon;
import org.netbeans.lib.profiler.ui.swing.renderer.LabelRenderer;
import org.netbeans.lib.profiler.ui.swing.renderer.MultiRenderer;
import org.netbeans.lib.profiler.ui.swing.renderer.NormalBoldGrayRenderer;
import org.netbeans.lib.profiler.ui.swing.renderer.ProfilerRenderer;
import org.netbeans.modules.profiler.api.icons.Icons;

public class PrimitiveNodeRenderer
extends MultiRenderer
implements HeapViewerRenderer {
    private final NormalBoldGrayRenderer nameRenderer = new NormalBoldGrayRenderer(){

        public void setValue(Object value, int row) {
            String name = ((PrimitiveNode)((Object)value)).getFieldName();
            if (name.startsWith("static ")) {
                this.setNormalValue("static ");
                this.setBoldValue(name.substring("static ".length()));
            } else {
                this.setNormalValue("");
                this.setBoldValue(name);
            }
            this.setIcon(Icons.getIcon((String)"ProfilerIcons.NodeForward"));
        }
    };
    private final LabelRenderer equalsRenderer = new LabelRenderer();
    private final NormalBoldGrayRenderer valueRenderer;
    private final ProfilerRenderer[] renderers;

    public PrimitiveNodeRenderer() {
        this.equalsRenderer.setText("=");
        this.equalsRenderer.setMargin(3, 0, 3, 0);
        this.valueRenderer = new NormalBoldGrayRenderer(){

            public void setValue(Object value, int row) {
                PrimitiveNode node = (PrimitiveNode)((Object)value);
                this.setNormalValue(node.getType());
                this.setBoldValue(node.getValue());
                this.setIcon(Icons.getIcon((String)"LanguageIcons.Primitive"));
                this.setIconTextGap(1);
                ((LabelRenderer)this.valueRenderers()[0]).setMargin(3, 0, 3, 3);
            }
        };
        this.renderers = new ProfilerRenderer[]{this.nameRenderer, this.equalsRenderer, this.valueRenderer};
    }

    @Override
    public Icon getIcon() {
        return this.nameRenderer.getIcon();
    }

    @Override
    public String getShortName() {
        return this.nameRenderer.toString();
    }

    protected ProfilerRenderer[] valueRenderers() {
        return this.renderers;
    }

    public void setValue(Object value, int row) {
        this.nameRenderer.setValue(value, row);
        this.valueRenderer.setValue(value, row);
    }
}

