/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.v2.impl;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.swing.ProfilerPopup;
import org.netbeans.lib.profiler.ui.swing.SmallButton;
import org.netbeans.lib.profiler.ui.swing.renderer.JavaNameRenderer;
import org.netbeans.lib.profiler.utils.formatting.DefaultMethodNameFormatter;
import org.netbeans.lib.profiler.utils.formatting.MethodNameFormatter;
import org.netbeans.modules.profiler.api.icons.Icons;
import org.netbeans.modules.profiler.api.java.SourceClassInfo;
import org.netbeans.modules.profiler.api.java.SourceMethodInfo;
import org.netbeans.modules.profiler.v2.ProfilerSession;
import org.netbeans.modules.profiler.v2.impl.Bundle;
import org.netbeans.modules.profiler.v2.impl.ClassMethodSelector;
import org.openide.util.ImageUtilities;

public final class ClassMethodList {
    public static void showClasses(ProfilerSession profilerSession, Set<ClientUtils.SourceCodeSelection> set, Component component) {
        UI.forClasses(profilerSession, set).show(component);
    }

    public static void showMethods(ProfilerSession profilerSession, Set<ClientUtils.SourceCodeSelection> set, Component component) {
        UI.forMethods(profilerSession, set).show(component);
    }

    private ClassMethodList() {
    }

    private static class UI {
        private JPanel panel;

        static UI forClasses(ProfilerSession profilerSession, Set<ClientUtils.SourceCodeSelection> set) {
            return new UI(profilerSession, set, false);
        }

        static UI forMethods(ProfilerSession profilerSession, Set<ClientUtils.SourceCodeSelection> set) {
            return new UI(profilerSession, set, true);
        }

        void show(Component component) {
            int n = 12;
            ProfilerPopup.createRelative((Component)component, (Component)this.panel, (int)6, (int)n).show();
        }

        private UI(final ProfilerSession profilerSession, final Set<ClientUtils.SourceCodeSelection> set, final boolean bl) {
            JPanel jPanel = new JPanel(new BorderLayout());
            JLabel jLabel = new JLabel(bl ? Bundle.ClassMethodList_selectedMethods() : Bundle.ClassMethodList_selectedClasses(), 10);
            jLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 6, 0));
            jPanel.add((Component)jLabel, "North");
            class XListModel
            extends AbstractListModel<ClientUtils.SourceCodeSelection> {
                XListModel() {
                }

                @Override
                public int getSize() {
                    return set.size();
                }

                @Override
                public ClientUtils.SourceCodeSelection getElementAt(int n) {
                    return (ClientUtils.SourceCodeSelection)new ArrayList(set).get(n);
                }

                public void refresh() {
                    super.fireContentsChanged(this, 0, this.getSize());
                }
            }
            final XListModel xListModel = new XListModel();
            final JList jList = new JList(xListModel){

                @Override
                public Dimension getPreferredScrollableViewportSize() {
                    Dimension dimension = super.getPreferredScrollableViewportSize();
                    dimension.width = 420;
                    return dimension;
                }
            };
            jList.setBackground(UIUtils.getProfilerResultsBackground());
            int n = bl ? 3 : 1;
            DefaultMethodNameFormatter defaultMethodNameFormatter = new DefaultMethodNameFormatter(n);
            final JavaNameRenderer javaNameRenderer = new JavaNameRenderer();
            jList.setCellRenderer(new ListCellRenderer((MethodNameFormatter)defaultMethodNameFormatter){
                final /* synthetic */ MethodNameFormatter val$formatter;
                {
                    this.val$formatter = methodNameFormatter;
                }

                public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                    javaNameRenderer.setValue((Object)this.val$formatter.formatMethodName((ClientUtils.SourceCodeSelection)object).toFormatted(), n);
                    JComponent jComponent = javaNameRenderer.getComponent();
                    if (bl) {
                        jComponent.setForeground(jList.getSelectionForeground());
                        jComponent.setBackground(jList.getSelectionBackground());
                    } else {
                        jComponent.setForeground(jList.getForeground());
                        jComponent.setBackground((n & 1) == 0 ? jList.getBackground() : UIUtils.getDarker((Color)jList.getBackground()));
                    }
                    return jComponent;
                }
            });
            String string = bl ? "LanguageIcons.Method" : "LanguageIcons.Class";
            Image image = Icons.getImage((String)string);
            Image image2 = Icons.getImage((String)"GeneralIcons.BadgeAdd");
            Image image3 = ImageUtilities.mergeImages((Image)image, (Image)image2, (int)0, (int)0);
            SmallButton smallButton = new SmallButton(ImageUtilities.image2Icon((Image)image3)){
                {
                    super(icon);
                }

                protected void fireActionPerformed(ActionEvent actionEvent) {
                    HashSet<ClientUtils.SourceCodeSelection> hashSet = null;
                    if (bl) {
                        List<SourceMethodInfo> list = ClassMethodSelector.selectMethods(profilerSession);
                        if (!list.isEmpty()) {
                            hashSet = new HashSet<ClientUtils.SourceCodeSelection>();
                            for (SourceMethodInfo sourceMethodInfo : list) {
                                hashSet.add(new ClientUtils.SourceCodeSelection(sourceMethodInfo.getClassName(), sourceMethodInfo.getName(), sourceMethodInfo.getSignature()));
                            }
                        }
                    } else {
                        List<SourceClassInfo> list = ClassMethodSelector.selectClasses(profilerSession);
                        if (!list.isEmpty()) {
                            hashSet = new HashSet();
                            for (SourceClassInfo sourceClassInfo : list) {
                                hashSet.add(new ClientUtils.SourceCodeSelection(sourceClassInfo.getQualifiedName(), "*", null));
                            }
                        }
                    }
                    if (hashSet != null) {
                        set.addAll(hashSet);
                        xListModel.refresh();
                    }
                }
            };
            smallButton.setToolTipText(bl ? Bundle.ClassMethodList_addMethod() : Bundle.ClassMethodList_addClass());
            Image image4 = Icons.getImage((String)"GeneralIcons.BadgeRemove");
            Image image5 = ImageUtilities.mergeImages((Image)image, (Image)image4, (int)0, (int)0);
            SmallButton smallButton2 = new SmallButton(ImageUtilities.image2Icon((Image)image5)){
                {
                    super(icon);
                }

                protected void fireActionPerformed(ActionEvent actionEvent) {
                    set.removeAll(jList.getSelectedValuesList());
                    xListModel.refresh();
                    jList.clearSelection();
                    this.setEnabled(false);
                }
            };
            smallButton2.setToolTipText(bl ? Bundle.ClassMethodList_removeMethods() : Bundle.ClassMethodList_removeClasses());
            smallButton2.setEnabled(false);
            jList.setSelectionMode(2);
            jList.addListSelectionListener(new ListSelectionListener((JButton)smallButton2, jList){
                final /* synthetic */ JButton val$removeB;
                final /* synthetic */ JList val$list;
                {
                    this.val$removeB = jButton;
                    this.val$list = jList;
                }

                @Override
                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    if (listSelectionEvent.getValueIsAdjusting()) {
                        return;
                    }
                    this.val$removeB.setEnabled(this.val$list.getSelectedValue() != null);
                }
            });
            JScrollPane jScrollPane = new JScrollPane(jList);
            jLabel.setLabelFor(jScrollPane);
            jPanel.add((Component)jScrollPane, "Center");
            JPanel jPanel2 = new JPanel(null);
            jPanel2.setBorder(BorderFactory.createEmptyBorder(0, 8, 0, 0));
            jPanel2.setLayout(new BoxLayout(jPanel2, 1));
            jPanel2.add((Component)smallButton);
            jPanel2.add((Component)smallButton2);
            jPanel.add((Component)jPanel2, "East");
            this.panel = jPanel;
        }
    }
}

