/* list of available colors 
   according to 
   https://www.codeproject.com/Articles/1276/Naming-Common-Colors 
*/

#if !defined(__ID_COLOR_NAMES_H)
#define __ID_COLOR_NAMES_H

struct colortable {
    COLORREF rgbc;
    char name[32];
    int R;
    int G;
    int B;
};

static struct colortable ctable[] = {
    { 0, "AliceBlue            ",240,248,255 },
    { 0, "AntiqueWhite         ",250,235,215 },
    { 0, "Aqua                 ",  0,255,255 },
    { 0, "Aquamarine           ",127,255,212 },
    { 0, "Azure                ",240,255,255 },
    { 0, "Beige                ",245,245,220 },
    { 0, "Bisque               ",255,228,196 },
    { 0, "Black                ",  0,  0,  0 },
    { 0, "BlanchedAlmond       ",255,255,205 },
    { 0, "Blue                 ",  0,  0,255 },
    { 0, "BlueViolet           ",138, 43,226 },
    { 0, "Brown                ",165, 42, 42 },
    { 0, "Burlywood            ",222,184,135 },
    { 0, "CadetBlue            ", 95,158,160 },
    { 0, "Chartreuse           ",127,255,  0 },
    { 0, "Chocolate            ",210,105, 30 },
    { 0, "Coral                ",255,127, 80 },
    { 0, "CornflowerBlue       ",100,149,237 },
    { 0, "Cornsilk             ",255,248,220 },
    { 0, "Crimson              ",220, 20, 60 },
    { 0, "Cyan                 ",  0,255,255 },
    { 0, "DarkBlue             ",  0,  0,139 },
    { 0, "DarkCyan             ",  0,139,139 },
    { 0, "DarkGoldenRod        ",184,134, 11 },
    { 0, "DarkGray             ",169,169,169 },
    { 0, "DarkGreen            ",  0,100,  0 },
    { 0, "DarkKhaki            ",189,183,107 },
    { 0, "DarkMagenta          ",139,  0,139 },
    { 0, "DarkOliveGreen       ", 85,107, 47 },
    { 0, "DarkOrange           ",255,140,  0 },
    { 0, "DarkOrchid           ",153, 50,204 },
    { 0, "DarkRed              ",139,  0,  0 },
    { 0, "DarkSalmon           ",233,150,122 },
    { 0, "DarkSeaGreen         ",143,188,143 },
    { 0, "DarkSlateBlue        ", 72, 61,139 },
    { 0, "DarkSlateGray        ", 47, 79, 79 },
    { 0, "DarkTurquoise        ",  0,206,209 },
    { 0, "DarkViolet           ",148,  0,211 },
    { 0, "DeepPink             ",255, 20,147 },
    { 0, "DeepSkyBlue          ",  0,191,255 },
    { 0, "DimGray              ",105,105,105 },
    { 0, "DodgerBlue           ", 30,144,255 },
    { 0, "FireBrick            ",178, 34, 34 },
    { 0, "FloralWhite          ",255,250,240 },
    { 0, "ForestGreen          ", 34,139, 34 },
    { 0, "Fuchsia              ",255,  0,255 },
    { 0, "Gainsboro            ",220,220,220 },
    { 0, "GhostWhite           ",248,248,255 },
    { 0, "Gold                 ",255,215,  0 },
    { 0, "GoldenRod            ",218,165, 32 },
    { 0, "Gray                 ",127,127,127 },
    { 0, "Green                ",  0,255,  0 },
    { 0, "GreenYellow          ",173,255, 47 },
    { 0, "HoneyDew             ",240,255,240 },
    { 0, "HotPink              ",255,105,180 },
    { 0, "IndianRed            ",205, 92, 92 },
    { 0, "Indigo               ", 75,  0,130 },
    { 0, "Ivory                ",255,255,240 },
    { 0, "Khaki                ",240,230,140 },
    { 0, "Lavender             ",230,230,250 },
    { 0, "LavenderBlush        ",255,240,245 },
    { 0, "Lawngreen            ",124,252,  0 },
    { 0, "LemonChiffon         ",255,250,205 },
    { 0, "LightBlue            ",173,216,230 },
    { 0, "LightCoral           ",240,128,128 },
    { 0, "LightCyan            ",224,255,255 },
    { 0, "LightGoldenRodYellow ",250,250,210 },
    { 0, "LightGreen           ",144,238,144 },
    { 0, "LightGrey            ",211,211,211 },
    { 0, "LightPink            ",255,182,193 },
    { 0, "LightSalmon          ",255,160,122 },
    { 0, "LightSeaGreen        ", 32,178,170 },
    { 0, "LightSkyBlue         ",135,206,250 },
    { 0, "LightSlateGray       ",119,136,153 },
    { 0, "LightSteelBlue       ",176,196,222 },
    { 0, "Light Violet         ",128,  0,255 },
    { 0, "LightYellow          ",255,255,224 },
    { 0, "Lime                 ",  0,255,  0 },
    { 0, "LimeGreen            ", 50,205, 50 },
    { 0, "Linen                ",250,240,230 },
    { 0, "Magenta              ",255,  0,255 },
    { 0, "Maroon               ",128,  0,  0 },
    { 0, "MediumAquamarine     ",102,205,170 },
    { 0, "MediumBlue           ",  0,  0,205 },
    { 0, "MediumOrchid         ",186, 85,211 },
    { 0, "MediumPurple         ",147,112,219 },
    { 0, "MediumSeaGreen       ", 60,179,113 },
    { 0, "MediumSlateBlue      ",123,104,238 },
    { 0, "MediumSpringGreen    ",  0,250,154 },
    { 0, "MediumTurquoise      ", 72,209,204 },
    { 0, "MediumVioletRed      ",199, 21,133 },
    { 0, "MidnightBlue         ", 25, 25,112 },
    { 0, "MintCream            ",245,255,250 },
    { 0, "MistyRose            ",255,228,225 },
    { 0, "Moccasin             ",255,228,181 },
    { 0, "NavajoWhite          ",255,222,173 },
    { 0, "Navy                 ",  0,  0,128 },
    { 0, "Navyblue             ",159,175,223 },
    { 0, "OldLace              ",253,245,230 },
    { 0, "Olive                ",128,128,  0 },
    { 0, "OliveDrab            ",107,142, 35 },
    { 0, "Orange               ",255,165,  0 },
    { 0, "OrangeRed            ",255, 69,  0 },
    { 0, "Orchid               ",218,112,214 },
    { 0, "PaleGoldenRod        ",238,232,170 },
    { 0, "PaleGreen            ",152,251,152 },
    { 0, "PaleTurquoise        ",175,238,238 },
    { 0, "PaleVioletRed        ",219,112,147 },
    { 0, "PapayaWhip           ",255,239,213 },
    { 0, "PeachPuff            ",255,218,185 },
    { 0, "Peru                 ",205,133, 63 },
    { 0, "Pink                 ",255,192,203 },
    { 0, "Plum                 ",221,160,221 },
    { 0, "PowderBlue           ",176,224,230 },
    { 0, "Purple               ",128,  0,128 },
    { 0, "Red                  ",255,  0,  0 },
    { 0, "RosyBrown            ",188,143,143 },
    { 0, "RoyalBlue            ", 65,105,225 },
    { 0, "SaddleBrown          ",139, 69, 19 },
    { 0, "Salmon               ",250,128,114 },
    { 0, "SandyBrown           ",244,164, 96 },
    { 0, "SeaGreen             ", 46,139, 87 },
    { 0, "SeaShell             ",255,245,238 },
    { 0, "Sienna               ",160, 82, 45 },
    { 0, "Silver               ",192,192,192 },
    { 0, "SkyBlue              ",135,206,235 },
    { 0, "SlateBlue            ",106, 90,205 },
    { 0, "SlateGray            ",112,128,144 },
    { 0, "Snow                 ",255,250,250 },
    { 0, "SpringGreen          ",  0,255,127 },
    { 0, "SteelBlue            ", 70,130,180 },
    { 0, "Tan                  ",210,180,140 },
    { 0, "Teal                 ",  0,128,128 },
    { 0, "Thistle              ",216,191,216 },
    { 0, "Tomato               ",255, 99, 71 },
    { 0, "Turquoise            ", 64,224,208 },
    { 0, "Violet               ",238,130,238 },
    { 0, "WebGreen             ",  0,128,  0 },
    { 0, "Wheat                ",245,222,179 },
    { 0, "White                ",255,255,255 },
    { 0, "WhiteSmoke           ",245,245,245 },
    { 0, "Yellow               ",255,255,  0 },
    { 0, "YellowGreen          ",139,205, 50 }
};

char* stdcolornames[] =
{
    "black", "white", "green", "red", "blue", "yellow", "violet",
    "azure", "orange", "brown", "light violet", "pink",
    "white", "green", "red", "blue", "yellow", "violet",
    "azure", "orange", "brown", "light violet", "pink"
};
#endif // __ID_COLOR_NAMES
