/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.layout.plugin.openord;

public enum Params {
    DEFAULT(new Stage(0.0f, 2000.0f, 10.0f, 1.0f), new Stage(0.25f, 2000.0f, 10.0f, 1.0f), new Stage(0.25f, 2000.0f, 2.0f, 1.0f), new Stage(0.25f, 2000.0f, 1.0f, 0.1f), new Stage(0.1f, 250.0f, 1.0f, 0.25f), new Stage(0.15f, 250.0f, 0.5f, 0.0f)),
    COARSEN(new Stage(0.0f, 2000.0f, 10.0f, 1.0f), new Stage(200.0f, 2000.0f, 2.0f, 1.0f), new Stage(200.0f, 2000.0f, 10.0f, 1.0f), new Stage(200.0f, 2000.0f, 1.0f, 0.1f), new Stage(50.0f, 250.0f, 1.0f, 0.25f), new Stage(100.0f, 250.0f, 0.5f, 0.0f)),
    COARSEST(new Stage(0.0f, 2000.0f, 10.0f, 1.0f), new Stage(200.0f, 2000.0f, 2.0f, 1.0f), new Stage(200.0f, 2000.0f, 10.0f, 1.0f), new Stage(200.0f, 2000.0f, 1.0f, 0.1f), new Stage(200.0f, 250.0f, 1.0f, 0.25f), new Stage(100.0f, 250.0f, 0.5f, 0.0f)),
    REFINE(new Stage(0.0f, 50.0f, 0.5f, 0.0f), new Stage(0.0f, 2000.0f, 2.0f, 1.0f), new Stage(50.0f, 500.0f, 0.1f, 0.25f), new Stage(50.0f, 200.0f, 1.0f, 0.1f), new Stage(50.0f, 250.0f, 1.0f, 0.25f), new Stage(0.0f, 250.0f, 0.5f, 0.0f)),
    FINAL(new Stage(0.0f, 50.0f, 0.5f, 0.0f), new Stage(0.0f, 2000.0f, 2.0f, 1.0f), new Stage(50.0f, 50.0f, 0.1f, 0.25f), new Stage(50.0f, 200.0f, 1.0f, 0.1f), new Stage(50.0f, 250.0f, 1.0f, 0.25f), new Stage(25.0f, 250.0f, 0.5f, 0.0f));

    private final Stage initial;
    private final Stage liquid;
    private final Stage expansion;
    private final Stage cooldown;
    private final Stage crunch;
    private final Stage simmer;

    private Params(Stage initial, Stage liquid, Stage expansion, Stage cooldown, Stage crunch, Stage simmer) {
        this.initial = initial;
        this.liquid = liquid;
        this.expansion = expansion;
        this.cooldown = cooldown;
        this.crunch = crunch;
        this.simmer = simmer;
    }

    public Stage getCooldown() {
        return this.cooldown;
    }

    public Stage getCrunch() {
        return this.crunch;
    }

    public Stage getExpansion() {
        return this.expansion;
    }

    public Stage getInitial() {
        return this.initial;
    }

    public Stage getLiquid() {
        return this.liquid;
    }

    public Stage getSimmer() {
        return this.simmer;
    }

    public float getIterationsSum() {
        return this.liquid.iterations + this.expansion.iterations + this.cooldown.iterations + this.crunch.iterations + this.simmer.iterations;
    }

    public static class Stage {
        private float iterations;
        private final float temperature;
        private final float attraction;
        private final float dampingMult;

        Stage(float iterations, float temperature, float attraction, float dampingMult) {
            this.iterations = iterations;
            this.temperature = temperature;
            this.attraction = attraction;
            this.dampingMult = dampingMult;
        }

        public float getAttraction() {
            return this.attraction;
        }

        public float getDampingMult() {
            return this.dampingMult;
        }

        public float getIterations() {
            return this.iterations;
        }

        public int getIterationsTotal(int totalIterations) {
            return (int)(this.iterations * (float)totalIterations);
        }

        public int getIterationsPercentage() {
            return (int)(this.iterations * 100.0f);
        }

        public float getTemperature() {
            return this.temperature;
        }

        public void setIterations(float iterations) {
            this.iterations = iterations;
        }
    }
}

