/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.build.report.BuildReporter;
import org.jetbrains.kotlin.build.report.metrics.BuildAttribute;
import org.jetbrains.kotlin.build.report.metrics.BuildMetricsReporter;
import org.jetbrains.kotlin.build.report.metrics.BuildTime;
import org.jetbrains.kotlin.incremental.BuildDifference;
import org.jetbrains.kotlin.incremental.BuildDiffsStorage;
import org.jetbrains.kotlin.incremental.BuildInfo;
import org.jetbrains.kotlin.incremental.ChangedFiles;
import org.jetbrains.kotlin.incremental.ChangesEither;
import org.jetbrains.kotlin.incremental.DirtyData;
import org.jetbrains.kotlin.incremental.LookupSymbol;
import org.jetbrains.kotlin.incremental.multiproject.ModulesApiHistory;
import org.jetbrains.kotlin.incremental.util.Either;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a6\u0010\u0000\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0000\u00a8\u0006\r"}, d2={"getClasspathChanges", "Lorg/jetbrains/kotlin/incremental/ChangesEither;", "classpath", "", "Ljava/io/File;", "changedFiles", "Lorg/jetbrains/kotlin/incremental/ChangedFiles$Known;", "lastBuildInfo", "Lorg/jetbrains/kotlin/incremental/BuildInfo;", "modulesApiHistory", "Lorg/jetbrains/kotlin/incremental/multiproject/ModulesApiHistory;", "reporter", "Lorg/jetbrains/kotlin/build/report/BuildReporter;", "incremental-compilation-impl"})
public final class ChangesDetectionUtilsKt {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public static final ChangesEither getClasspathChanges(@NotNull List<? extends File> classpath, @NotNull ChangedFiles.Known changedFiles, @NotNull BuildInfo lastBuildInfo, @NotNull ModulesApiHistory modulesApiHistory, @NotNull BuildReporter reporter) {
        ChangesEither changesEither;
        void $this$measure$iv;
        Either<Set<File>> either;
        void $this$measure$iv2;
        Collection $this$filterTo$iv;
        boolean bl;
        File it;
        boolean $i$f$filterTo;
        Intrinsics.checkNotNullParameter(classpath, "classpath");
        Intrinsics.checkNotNullParameter(changedFiles, "changedFiles");
        Intrinsics.checkNotNullParameter(lastBuildInfo, "lastBuildInfo");
        Intrinsics.checkNotNullParameter(modulesApiHistory, "modulesApiHistory");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        HashSet<File> classpathSet = new HashSet<File>();
        for (File file2 : classpath) {
            if (file2.isFile()) {
                classpathSet.add(file2);
                continue;
            }
            if (!file2.isDirectory()) continue;
            Sequence $this$filterTo$iv2 = FilesKt.walk$default(file2, null, 1, null);
            $i$f$filterTo = false;
            Iterator iterator2 = $this$filterTo$iv2.iterator();
            while (iterator2.hasNext()) {
                Object element$iv = iterator2.next();
                it = (File)element$iv;
                bl = false;
                if (!it.isFile()) continue;
                ((Collection)classpathSet).add(element$iv);
            }
        }
        Iterable iterable = changedFiles.getModified();
        Iterable destination$iv = new HashSet();
        $i$f$filterTo = false;
        for (Object element$iv2 : iterable) {
            it = (File)element$iv2;
            bl = false;
            if (!classpathSet.contains(it)) continue;
            destination$iv.add(element$iv2);
        }
        HashSet modifiedClasspath = (HashSet)destination$iv;
        destination$iv = changedFiles.getRemoved();
        Collection destination$iv2 = new HashSet();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv3 : $this$filterTo$iv) {
            File it2 = (File)element$iv3;
            boolean bl2 = false;
            if (!classpathSet.contains(it2)) continue;
            destination$iv2.add(element$iv3);
        }
        HashSet hashSet = (HashSet)destination$iv2;
        $this$filterTo$iv = hashSet;
        boolean bl3 = false;
        if (!$this$filterTo$iv.isEmpty()) {
            reporter.report(new Function0<String>((HashSet<File>)hashSet){
                final /* synthetic */ HashSet<File> $removedClasspath;
                {
                    this.$removedClasspath = $removedClasspath;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return Intrinsics.stringPlus("Some files are removed from classpath: ", this.$removedClasspath);
                }
            });
            return new ChangesEither.Unknown(BuildAttribute.DEP_CHANGE_REMOVED_ENTRY);
        }
        if (modifiedClasspath.isEmpty()) {
            return new ChangesEither.Known(null, null, 3, null);
        }
        long lastBuildTS = lastBuildInfo.getStartTS();
        HashSet<LookupSymbol> symbols2 = new HashSet<LookupSymbol>();
        HashSet<FqName> fqNames = new HashSet<FqName>();
        BuildMetricsReporter it2 = reporter;
        Object metric$iv = BuildTime.IC_FIND_HISTORY_FILES;
        boolean $i$f$measure = false;
        long start$iv = System.nanoTime();
        $this$measure$iv2.startMeasure((BuildTime)metric$iv, start$iv);
        try {
            boolean bl2 = false;
            either = modulesApiHistory.historyFilesForChangedFiles(modifiedClasspath);
        }
        finally {
            long end$iv = System.nanoTime();
            $this$measure$iv2.endMeasure((BuildTime)metric$iv, end$iv);
        }
        Either<Set<File>> historyFilesEither = either;
        metric$iv = historyFilesEither;
        if (!(metric$iv instanceof Either.Success)) {
            if (metric$iv instanceof Either.Error) {
                reporter.report(new Function0<String>(historyFilesEither){
                    final /* synthetic */ Either<Set<File>> $historyFilesEither;
                    {
                        this.$historyFilesEither = $historyFilesEither;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return Intrinsics.stringPlus("Could not find history files: ", ((Either.Error)this.$historyFilesEither).getReason());
                    }
                });
                return new ChangesEither.Unknown(BuildAttribute.DEP_CHANGE_HISTORY_IS_NOT_FOUND);
            }
            throw new NoWhenBranchMatchedException();
        }
        Set historyFiles2 = (Set)((Either.Success)historyFilesEither).getValue();
        metric$iv = reporter;
        BuildTime metric$iv2 = BuildTime.IC_ANALYZE_HISTORY_FILES;
        boolean $i$f$measure2 = false;
        long start$iv2 = System.nanoTime();
        $this$measure$iv.startMeasure(metric$iv2, start$iv2);
        try {
            boolean bl32 = false;
            changesEither = ChangesDetectionUtilsKt.getClasspathChanges$analyzeHistoryFiles(historyFiles2, reporter, symbols2, fqNames, lastBuildTS);
        }
        finally {
            long end$iv = System.nanoTime();
            $this$measure$iv.endMeasure(metric$iv2, end$iv);
        }
        return changesEither;
    }

    private static final ChangesEither getClasspathChanges$analyzeHistoryFiles(Set<? extends File> $historyFiles, BuildReporter $reporter, HashSet<LookupSymbol> $symbols, HashSet<FqName> $fqNames, long $lastBuildTS) {
        for (File file2 : $historyFiles) {
            List<BuildDifference> list2 = BuildDiffsStorage.Companion.readDiffsFromFile(file2, $reporter);
            if (list2 == null) {
                boolean bl = false;
                boolean bl2 = false;
                boolean bl3 = false;
                $reporter.report(new Function0<String>(file2){
                    final /* synthetic */ File $historyFile;
                    {
                        this.$historyFile = $historyFile;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return Intrinsics.stringPlus("Could not read diffs from ", this.$historyFile);
                    }
                });
                return new ChangesEither.Unknown(BuildAttribute.DEP_CHANGE_HISTORY_CANNOT_BE_READ);
            }
            List<BuildDifference> allBuilds2 = list2;
            Iterable $this$partition$iv = allBuilds2;
            boolean $i$f$partition = false;
            ArrayList first$iv = new ArrayList();
            ArrayList second$iv = new ArrayList();
            for (Object element$iv : $this$partition$iv) {
                BuildDifference it = (BuildDifference)element$iv;
                boolean bl = false;
                if (it.getTs() <= $lastBuildTS) {
                    first$iv.add(element$iv);
                    continue;
                }
                second$iv.add(element$iv);
            }
            list2 = new Pair(first$iv, second$iv);
            List knownBuilds = (List)((Pair)((Object)list2)).component1();
            List newBuilds = (List)((Pair)((Object)list2)).component2();
            if (knownBuilds.isEmpty()) {
                $reporter.report(new Function0<String>(file2){
                    final /* synthetic */ File $historyFile;
                    {
                        this.$historyFile = $historyFile;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return Intrinsics.stringPlus("No previously known builds for ", this.$historyFile);
                    }
                });
                return new ChangesEither.Unknown(BuildAttribute.DEP_CHANGE_HISTORY_NO_KNOWN_BUILDS);
            }
            for (BuildDifference buildDiff : newBuilds) {
                if (!buildDiff.isIncremental()) {
                    $reporter.report(new Function0<String>(file2){
                        final /* synthetic */ File $historyFile;
                        {
                            this.$historyFile = $historyFile;
                            super(0);
                        }

                        @NotNull
                        public final String invoke() {
                            return Intrinsics.stringPlus("Non-incremental build from dependency ", this.$historyFile);
                        }
                    });
                    return new ChangesEither.Unknown(BuildAttribute.DEP_CHANGE_NON_INCREMENTAL_BUILD_IN_DEP);
                }
                DirtyData dirtyData = buildDiff.getDirtyData();
                $symbols.addAll(dirtyData.getDirtyLookupSymbols());
                $fqNames.addAll(dirtyData.getDirtyClassesFqNames());
            }
        }
        return new ChangesEither.Known((Collection<LookupSymbol>)$symbols, (Collection<FqName>)$fqNames);
    }
}

