/*
 * Decompiled with CFR 0.152.
 */
package org.apache.naming;

import java.util.Iterator;
import javax.naming.Binding;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import org.apache.naming.NamingEntry;

public class NamingContextBindingsEnumeration
implements NamingEnumeration<Binding> {
    protected Iterator<NamingEntry> iterator;
    private Context ctx;

    public NamingContextBindingsEnumeration(Iterator<NamingEntry> iterator, Context context) {
        this.iterator = iterator;
        this.ctx = context;
    }

    @Override
    public Binding next() throws NamingException {
        return this.nextElementInternal();
    }

    @Override
    public boolean hasMore() throws NamingException {
        return this.iterator.hasNext();
    }

    @Override
    public void close() throws NamingException {
    }

    @Override
    public boolean hasMoreElements() {
        return this.iterator.hasNext();
    }

    @Override
    public Binding nextElement() {
        try {
            return this.nextElementInternal();
        }
        catch (NamingException namingException) {
            throw new RuntimeException(namingException.getMessage(), namingException);
        }
    }

    private Binding nextElementInternal() throws NamingException {
        Object object;
        NamingEntry namingEntry = this.iterator.next();
        if (namingEntry.type == 2 || namingEntry.type == 1) {
            try {
                object = this.ctx.lookup(new CompositeName(namingEntry.name));
            }
            catch (NamingException namingException) {
                throw namingException;
            }
            catch (Exception exception) {
                NamingException namingException = new NamingException(exception.getMessage());
                namingException.initCause(exception);
                throw namingException;
            }
        } else {
            object = namingEntry.value;
        }
        return new Binding(namingEntry.name, object.getClass().getName(), object, true);
    }
}

