/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.startup;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipException;
import org.apache.catalina.Host;
import org.apache.catalina.util.FileUtil;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.res.StringManager;

public class ExpandWar {
    private static final Log log = LogFactory.getLog(ExpandWar.class);
    protected static final StringManager sm = StringManager.getManager((String)"org.apache.catalina.startup");

    public static String expand(Host host, URL uRL, String string) throws IOException {
        File file = new File(host.getAppBase());
        if (!file.isAbsolute()) {
            file = new File(System.getProperty("catalina.base"), host.getAppBase());
        }
        if (!file.exists() || !file.isDirectory()) {
            throw new IOException(sm.getString("hostConfig.appBase", new Object[]{file.getAbsolutePath()}));
        }
        File file2 = new File(file, string);
        if (file2.exists()) {
            return file2.getAbsolutePath();
        }
        if (!file2.mkdir() && !file2.isDirectory()) {
            throw new IOException(sm.getString("expandWar.createFailed", new Object[]{file2}));
        }
        FileUtil fileUtil = new FileUtil(file2);
        JarURLConnection jarURLConnection = (JarURLConnection)uRL.openConnection();
        jarURLConnection.setUseCaches(false);
        JarFile jarFile = null;
        InputStream inputStream = null;
        boolean bl = false;
        try {
            jarFile = jarURLConnection.getJarFile();
            Enumeration<JarEntry> enumeration = jarFile.entries();
            while (enumeration.hasMoreElements()) {
                File file3;
                JarEntry jarEntry = enumeration.nextElement();
                String string2 = jarEntry.getName();
                File file4 = new File(file2, string2);
                if (!fileUtil.isParentOf(file4)) {
                    throw new IllegalArgumentException(sm.getString("expandWar.illegalPath", new Object[]{uRL, string2, file4.getCanonicalPath(), fileUtil.getCanonicalPath()}));
                }
                int n = string2.lastIndexOf(47);
                if (n >= 0 && !(file3 = new File(file2, string2.substring(0, n))).mkdirs() && !file3.isDirectory()) {
                    throw new IOException(sm.getString("expandWar.createFailed", new Object[]{file3}));
                }
                if (string2.endsWith("/")) continue;
                inputStream = jarFile.getInputStream(jarEntry);
                if (null == inputStream) {
                    throw new ZipException(sm.getString("expandWar.missingJarEntry", new Object[]{jarEntry.getName()}));
                }
                ExpandWar.expand(inputStream, file4);
                long l = jarEntry.getTime();
                if (l != -1L && l != 0L) {
                    file4.setLastModified(l);
                }
                inputStream.close();
                inputStream = null;
            }
            bl = true;
        }
        catch (IOException iOException) {
            throw iOException;
        }
        finally {
            if (!bl) {
                ExpandWar.deleteDir(file2);
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Throwable throwable) {
                    ExceptionUtils.handleThrowable((Throwable)throwable);
                }
                inputStream = null;
            }
            if (jarFile != null) {
                try {
                    jarFile.close();
                }
                catch (Throwable throwable) {
                    ExceptionUtils.handleThrowable((Throwable)throwable);
                }
                jarFile = null;
            }
        }
        return file2.getAbsolutePath();
    }

    public static void validate(Host host, URL uRL, String string) throws IOException {
        File file = new File(host.getAppBase());
        if (!file.isAbsolute()) {
            file = new File(System.getProperty("catalina.base"), host.getAppBase());
        }
        File file2 = new File(file, string);
        FileUtil fileUtil = new FileUtil(file2);
        JarURLConnection jarURLConnection = (JarURLConnection)uRL.openConnection();
        jarURLConnection.setUseCaches(false);
        JarFile jarFile = null;
        try {
            jarFile = jarURLConnection.getJarFile();
            Enumeration<JarEntry> enumeration = jarFile.entries();
            while (enumeration.hasMoreElements()) {
                JarEntry jarEntry = enumeration.nextElement();
                String string2 = jarEntry.getName();
                File file3 = new File(file2, string2);
                if (fileUtil.isParentOf(file3)) continue;
                throw new IllegalArgumentException(sm.getString("expandWar.illegalPath", new Object[]{uRL, string2, file3.getCanonicalPath(), fileUtil.getCanonicalPath()}));
            }
        }
        catch (IOException iOException) {
            throw iOException;
        }
        finally {
            if (jarFile != null) {
                try {
                    jarFile.close();
                }
                catch (Throwable throwable) {
                    ExceptionUtils.handleThrowable((Throwable)throwable);
                }
                jarFile = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copy(File file, File file2) {
        boolean bl = true;
        String[] stringArray = null;
        if (file.isDirectory()) {
            stringArray = file.list();
            bl = file2.mkdir();
        } else {
            stringArray = new String[]{""};
        }
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        for (int i = 0; i < stringArray.length && bl; ++i) {
            File file3 = new File(file, stringArray[i]);
            File file4 = new File(file2, stringArray[i]);
            if (file3.isDirectory()) {
                bl = ExpandWar.copy(file3, file4);
                continue;
            }
            FileChannel fileChannel = null;
            AbstractInterruptibleChannel abstractInterruptibleChannel = null;
            try {
                fileChannel = new FileInputStream(file3).getChannel();
                abstractInterruptibleChannel = new FileOutputStream(file4).getChannel();
                fileChannel.transferTo(0L, fileChannel.size(), (WritableByteChannel)((Object)abstractInterruptibleChannel));
                continue;
            }
            catch (IOException iOException) {
                log.error((Object)sm.getString("expandWar.copy", new Object[]{file3, file4}), (Throwable)iOException);
                bl = false;
                continue;
            }
            finally {
                if (fileChannel != null) {
                    try {
                        fileChannel.close();
                    }
                    catch (IOException iOException) {}
                }
                if (abstractInterruptibleChannel != null) {
                    try {
                        abstractInterruptibleChannel.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return bl;
    }

    public static boolean delete(File file) {
        return ExpandWar.delete(file, true);
    }

    public static boolean delete(File file, boolean bl) {
        boolean bl2 = file.isDirectory() ? ExpandWar.deleteDir(file, bl) : (file.exists() ? file.delete() : true);
        if (bl && !bl2) {
            log.error((Object)sm.getString("expandWar.deleteFailed", new Object[]{file.getAbsolutePath()}));
        }
        return bl2;
    }

    public static boolean deleteDir(File file) {
        return ExpandWar.deleteDir(file, true);
    }

    public static boolean deleteDir(File file, boolean bl) {
        String[] stringArray = file.list();
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        for (String string : stringArray) {
            File file2 = new File(file, string);
            if (file2.isDirectory()) {
                ExpandWar.deleteDir(file2, bl);
                continue;
            }
            file2.delete();
        }
        boolean bl2 = file.exists() ? file.delete() : true;
        if (bl && !bl2) {
            log.error((Object)sm.getString("expandWar.deleteFailed", new Object[]{file.getAbsolutePath()}));
        }
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void expand(InputStream inputStream, File file) throws IOException {
        FilterOutputStream filterOutputStream = null;
        try {
            int n;
            filterOutputStream = new BufferedOutputStream(new FileOutputStream(file));
            byte[] byArray = new byte[2048];
            while ((n = inputStream.read(byArray)) > 0) {
                ((BufferedOutputStream)filterOutputStream).write(byArray, 0, n);
            }
        }
        finally {
            if (filterOutputStream != null) {
                try {
                    filterOutputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

