/*
 * This file contains D-Bus client proxy classes generated by qt-client-gen.py.
 *
 * This file can be distributed under the same terms as the specification from
 * which it was generated.
 */

#ifndef IN_TP_QT_HEADER
#error IN_TP_QT_HEADER
#endif

#include <TelepathyQt/Types>

#include <QtGlobal>

#include <QString>
#include <QObject>
#include <QVariant>

#include <QDBusPendingReply>

#include <TelepathyQt/AbstractInterface>
#include <TelepathyQt/DBusProxy>
#include <TelepathyQt/Global>

namespace Tp
{
class PendingVariant;
class PendingOperation;
}

namespace Tp
{
namespace Client
{

/**
 * \class MediaStreamHandlerInterface
 * \headerfile TelepathyQt/media-stream-handler.h <TelepathyQt/MediaStreamHandler>
 * \ingroup clientmstrh
 *
 * Proxy class providing a 1:1 mapping of the D-Bus interface "org.freedesktop.Telepathy.Media.StreamHandler".
 */
class TP_QT_EXPORT MediaStreamHandlerInterface : public Tp::AbstractInterface
{
    Q_OBJECT

public:
    /**
     * Returns the name of the interface "org.freedesktop.Telepathy.Media.StreamHandler", which this class
     * represents.
     *
     * \return The D-Bus interface name.
     */
    static inline QLatin1String staticInterfaceName()
    {
        return QLatin1String("org.freedesktop.Telepathy.Media.StreamHandler");
    }

    /**
     * Creates a MediaStreamHandlerInterface associated with the given object on the session bus.
     *
     * \param busName Name of the service the object is on.
     * \param objectPath Path to the object on the service.
     * \param parent Passed to the parent class constructor.
     */
    MediaStreamHandlerInterface(
        const QString& busName,
        const QString& objectPath,
        QObject* parent = 0
    );

    /**
     * Creates a MediaStreamHandlerInterface associated with the given object on the given bus.
     *
     * \param connection The bus via which the object can be reached.
     * \param busName Name of the service the object is on.
     * \param objectPath Path to the object on the service.
     * \param parent Passed to the parent class constructor.
     */
    MediaStreamHandlerInterface(
        const QDBusConnection& connection,
        const QString& busName,
        const QString& objectPath,
        QObject* parent = 0
    );

    /**
     * Creates a MediaStreamHandlerInterface associated with the same object as the given proxy.
     *
     * \param proxy The proxy to use. It will also be the QObject::parent()
     *               for this object.
     */
    MediaStreamHandlerInterface(Tp::DBusProxy *proxy);

    /**
     * Asynchronous getter for the remote object property \c STUNServers of type \c Tp::SocketAddressIPList.
     *
     * 
     * The IP addresses of possible STUN servers to use for NAT traversal, as 
     * dotted-quad IPv4 address literals or RFC2373 IPv6 address literals. 
     * This property cannot change once the stream has been created, so there 
     * is no change notification. The IP addresses MUST NOT be given as DNS 
     * hostnames. High-quality connection managers already need an 
     * asynchronous DNS resolver, so they might as well resolve this name to 
     * an IP to make life easier for streaming implementations.
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertySTUNServers() const
    {
        return internalRequestProperty(QLatin1String("STUNServers"));
    }

    /**
     * Asynchronous getter for the remote object property \c CreatedLocally of type \c bool.
     *
     * 
     * True if we were the creator of this stream, false otherwise. This 
     * information is needed for some nat traversal mechanisms, such as 
     * ICE-UDP, where the creator gets the role of the controlling agent.
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyCreatedLocally() const
    {
        return internalRequestProperty(QLatin1String("CreatedLocally"));
    }

    /**
     * Asynchronous getter for the remote object property \c NATTraversal of type \c QString.
     *
     * 
     * \htmlonly
     * <p>The transport (NAT traversal technique) to be used for this
     *   stream. Well-known values include:</p>
     * 
     * <dl>
     *   <dt>none</dt>
     *   <dd>Raw UDP, with or without STUN, should be used. If the
     *      \endhtmlonly \link requestPropertySTUNServers() STUNServers \endlink \htmlonly  property is non-empty,
     *     STUN SHOULD be used.</dd>
     * 
     *   <dt>stun</dt>
     *   <dd>A deprecated synonym for 'none'.</dd>
     * 
     *   <dt>gtalk-p2p</dt>
     *   <dd>Google Talk peer-to-peer connectivity establishment should be
     *     used, as implemented in libjingle 0.3.</dd>
     * 
     *   <dt>ice-udp</dt>
     *   <dd>Interactive Connectivity Establishment should be used,
     *     as defined by the IETF MMUSIC working group.</dd>
     * 
     *   <dt>wlm-8.5</dt>
     *   <dd>The transport used by Windows Live Messenger 8.5 or later,
     *     which resembles ICE draft 6, should be used.</dd>
     * 
     *   <dt>wlm-2009</dt>
     *   <dd>The transport used by Windows Live Messenger 2009 or later,
     *     which resembles ICE draft 19, should be used.</dd>
     * </dl>
     * 
     * <p>This property cannot change once the stream has been created, so
     *   there is no change notification.</p>
     * \endhtmlonly
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyNATTraversal() const
    {
        return internalRequestProperty(QLatin1String("NATTraversal"));
    }

    /**
     * Asynchronous getter for the remote object property \c RelayInfo of type \c Tp::StringVariantMapList.
     *
     * 
     * \htmlonly
     * <p>A list of mappings describing TURN or Google relay servers
     *   available for the client to use in its candidate gathering, as
     *   determined from the protocol. Map keys are:</p>
     * 
     * <dl>
     *   <dt><code>ip</code> - s</dt>
     *   <dd>The IP address of the relay server as a dotted-quad IPv4
     *     address literal or an RFC2373 IPv6 address literal. This MUST NOT
     *     be a DNS hostname.
     * 
     *     <div class="rationale">
     *       High-quality connection managers already need an asynchronous
     *       DNS resolver, so they might as well resolve this name to an IP
     *       and make life easier for streaming implementations.
     *     </div>
     *   </dd>
     * 
     *   <dt><code>type</code> - s</dt>
     *   <dd>
     *     <p>Either <code>udp</code> for UDP (UDP MUST be assumed if this
     *       key is omitted), <code>tcp</code> for TCP, or
     *       <code>tls</code>.</p>
     * 
     *     <p>The precise meaning of this key depends on the
     *        \endhtmlonly \link requestPropertyNATTraversal() NATTraversal \endlink \htmlonly  property: if
     *       NATTraversal is <code>ice-udp</code>, <code>tls</code> means
     *       TLS over TCP as referenced by ICE draft 19, and if
     *       NATTraversal is <code>gtalk-p2p</code>, <code>tls</code> means
     *       a fake SSL session over TCP as implemented by libjingle.</p>
     *   </dd>
     * 
     *   <dt><code>port</code> - q</dt>
     *   <dd>The UDP or TCP port of the relay server as an ASCII unsigned
     *     integer</dd>
     * 
     *   <dt><code>username</code> - s</dt>
     *   <dd>The username to use</dd>
     * 
     *   <dt><code>password</code> - s</dt>
     *   <dd>The password to use</dd>
     * 
     *   <dt><code>component</code> - u</dt>
     *   <dd>The component number to use this relay server for, as an
     *     ASCII unsigned integer; if not included, this relay server
     *     may be used for any or all components.
     * 
     *     <div class="rationale">
     *       In ICE draft 6, as used by Google Talk, credentials are only
     *       valid once, so each component needs relaying separately.
     *     </div>
     *   </dd>
     * </dl>
     * 
     * <div class="rationale">
     *   <p>An equivalent of the gtalk-p2p-relay-token property on
     *     MediaSignalling channels is not included here. The connection
     *     manager should be responsible for making the necessary HTTP
     *     requests to turn the token into a username and password.</p>
     * </div>
     * 
     * <p>The type of relay server that this represents depends on
     *   the value of the  \endhtmlonly \link requestPropertyNATTraversal() NATTraversal \endlink \htmlonly 
     *   property. If NATTraversal is ice-udp, this is a TURN server;
     *   if NATTraversal is gtalk-p2p, this is a Google relay server;
     *   otherwise, the meaning of RelayInfo is undefined.</p>
     * 
     * <p>If relaying is not possible for this stream, the list is empty.</p>
     * 
     * <p>This property cannot change once the stream has been created, so
     *   there is no change notification.</p>
     * \endhtmlonly
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyRelayInfo() const
    {
        return internalRequestProperty(QLatin1String("RelayInfo"));
    }

    /**
     * Request all of the DBus properties on the interface.
     *
     * \return A pending variant map which will emit finished when the properties have
     *          been retrieved.
     */
    Tp::PendingVariantMap *requestAllProperties() const
    {
        return internalRequestAllProperties();
    }

public Q_SLOTS:
    /**
     * Begins a call to the D-Bus method \c CodecChoice on the remote object.
     * 
     * Inform the connection manager of codec used to receive data.
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     * \param timeout The timeout in milliseconds.
     */
    inline QDBusPendingReply<> CodecChoice(uint codecID, int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("CodecChoice"));
        callMessage << QVariant::fromValue(codecID);
        return this->connection().asyncCall(callMessage, timeout);
    }

    /**
     * Begins a call to the D-Bus method \c Error on the remote object.
     * 
     * Inform the connection manager that an error occured in this stream. The 
     * connection manager should emit the StreamError signal for the stream on 
     * the relevant channel, and remove the stream from the session.
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     *
     * \param errorCode
     *     
     *     ID of error, from the MediaStreamError enumeration
     *
     * \param message
     *     
     *     String describing the error
     * \param timeout The timeout in milliseconds.
     */
    inline QDBusPendingReply<> Error(uint errorCode, const QString& message, int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("Error"));
        callMessage << QVariant::fromValue(errorCode) << QVariant::fromValue(message);
        return this->connection().asyncCall(callMessage, timeout);
    }

    /**
     * Begins a call to the D-Bus method \c NativeCandidatesPrepared on the remote object.
     * 
     * Informs the connection manager that all possible native candisates have 
     * been discovered for the moment.
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     * \param timeout The timeout in milliseconds.
     */
    inline QDBusPendingReply<> NativeCandidatesPrepared(int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("NativeCandidatesPrepared"));
        return this->connection().asyncCall(callMessage, timeout);
    }

    /**
     * Begins a call to the D-Bus method \c NewActiveCandidatePair on the remote object.
     * 
     * Informs the connection manager that a valid candidate pair has been 
     * discovered and streaming is in progress.
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     * \param timeout The timeout in milliseconds.
     */
    inline QDBusPendingReply<> NewActiveCandidatePair(const QString& nativeCandidateID, const QString& remoteCandidateID, int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("NewActiveCandidatePair"));
        callMessage << QVariant::fromValue(nativeCandidateID) << QVariant::fromValue(remoteCandidateID);
        return this->connection().asyncCall(callMessage, timeout);
    }

    /**
     * Begins a call to the D-Bus method \c NewActiveTransportPair on the remote object.
     * 
     * Informs the connection manager that a valid transport pair has been 
     * discovered and streaming is in progress. Component id MUST be the same 
     * for both transports and the pair is only valid for that component. The 
     * connection manager might need to send the details of the active 
     * transport pair (e.g. c and o parameters of SDP body need to contain 
     * address of selected native RTP transport as stipulated by RFC 5245). 
     * However, the candidate ID might not be enough to determine these info 
     * if the transport was found after NativeCandidatesPrepared has been 
     * called (e.g. peer reflexive ICE candidate). This method must be called 
     * before NewActiveCandidatePair. This way, connection managers supporting 
     * this method can safely ignore subsequent NewActiveCandidatePair call. 
     * Connection managers SHOULD NOT implement this method unless they need 
     * to inform the peer about selected transports. As a result, streaming 
     * implementations MUST NOT treat errors raised by this method as fatal. 
     * Usually, connection managers only need to do one answer/offer 
     * round-trip. However, some protocols give the possibility to to send an 
     * updated offer (e.g. ICE defines such mechanism to avoid some race 
     * conditions and to properly set the state of gateway devices).
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     * \param timeout The timeout in milliseconds.
     */
    inline QDBusPendingReply<> NewActiveTransportPair(const QString& nativeCandidateID, const Tp::MediaStreamHandlerTransport& nativeTransport, const QString& remoteCandidateID, const Tp::MediaStreamHandlerTransport& remoteTransport, int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("NewActiveTransportPair"));
        callMessage << QVariant::fromValue(nativeCandidateID) << QVariant::fromValue(nativeTransport) << QVariant::fromValue(remoteCandidateID) << QVariant::fromValue(remoteTransport);
        return this->connection().asyncCall(callMessage, timeout);
    }

    /**
     * Begins a call to the D-Bus method \c NewNativeCandidate on the remote object.
     * 
     * Inform this MediaStreamHandler that a new native transport candidate 
     * has been ascertained.
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     *
     * \param candidateID
     *     
     *     String identifier for this candidate
     *
     * \param transports
     *     
     *     \htmlonly
     *     Array of transports for this candidate, with fields:
     *     <ul>
     *       <li>component number</li>
     *       <li>IP address (as a string)</li>
     *       <li>port</li>
     *       <li>base network protocol (one of the values of MediaStreamBaseProto)</li>
     *       <li>proto subtype (e.g. RTP)</li>
     *       <li>proto profile (e.g. AVP)</li>
     *       <li>our preference value of this transport (double in range 0.0-1.0
     *         inclusive); 1 signals the most preferred transport</li>
     *       <li>transport type, one of the values of MediaStreamTransportType</li>
     *       <li>username if authentication is required</li>
     *       <li>password if authentication is required</li>
     *     </ul>
     *     \endhtmlonly
     * \param timeout The timeout in milliseconds.
     */
    inline QDBusPendingReply<> NewNativeCandidate(const QString& candidateID, const Tp::MediaStreamHandlerTransportList& transports, int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("NewNativeCandidate"));
        callMessage << QVariant::fromValue(candidateID) << QVariant::fromValue(transports);
        return this->connection().asyncCall(callMessage, timeout);
    }

    /**
     * Begins a call to the D-Bus method \c Ready on the remote object.
     * 
     * Inform the connection manager that a client is ready to handle this 
     * StreamHandler. Also provide it with info about all supported codecs.
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     *
     * \param codecs
     *     
     *     Locally-supported codecs.
     * \param timeout The timeout in milliseconds.
     */
    inline QDBusPendingReply<> Ready(const Tp::MediaStreamHandlerCodecList& codecs, int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("Ready"));
        callMessage << QVariant::fromValue(codecs);
        return this->connection().asyncCall(callMessage, timeout);
    }

    /**
     * Begins a call to the D-Bus method \c SetLocalCodecs on the remote object.
     * 
     * \htmlonly
     * <p>Used to provide codecs after Ready(), so the media client can go
     *   ready for an incoming call and exchange candidates/codecs before
     *   knowing what local codecs are available.</p>
     * 
     * <p>This is useful for gatewaying calls between two connection managers.
     *   Given an incoming call, you need to call
     *    \endhtmlonly Ready() \htmlonly  to get the remote codecs before
     *   you can use them as the &quot;local&quot; codecs to place the outgoing call,
     *   and hence receive the outgoing call's remote codecs to use as the
     *   incoming call's &quot;local&quot; codecs.</p>
     * 
     * <p>In this situation, you would pass an empty list of codecs to the
     *   incoming call's Ready method, then later call SetLocalCodecs on the
     *   incoming call in order to respond to the offer.</p>
     * \endhtmlonly
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     *
     * \param codecs
     *     
     *     Locally-supported codecs
     * \param timeout The timeout in milliseconds.
     */
    inline QDBusPendingReply<> SetLocalCodecs(const Tp::MediaStreamHandlerCodecList& codecs, int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("SetLocalCodecs"));
        callMessage << QVariant::fromValue(codecs);
        return this->connection().asyncCall(callMessage, timeout);
    }

    /**
     * Begins a call to the D-Bus method \c StreamState on the remote object.
     * 
     * Informs the connection manager of the stream&apos;s current state, as 
     * as specified in Channel.Type.StreamedMedia::ListStreams.
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     * \param timeout The timeout in milliseconds.
     */
    inline QDBusPendingReply<> StreamState(uint state, int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("StreamState"));
        callMessage << QVariant::fromValue(state);
        return this->connection().asyncCall(callMessage, timeout);
    }

    /**
     * Begins a call to the D-Bus method \c SupportedCodecs on the remote object.
     * 
     * Inform the connection manager of the supported codecs for this session. 
     * This is called after the connection manager has emitted SetRemoteCodecs 
     * to notify what codecs are supported by the peer, and will thus be an 
     * intersection of all locally supported codecs (passed to Ready) and 
     * those supported by the peer.
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     *
     * \param codecs
     *     
     *     Locally supported codecs.
     * \param timeout The timeout in milliseconds.
     */
    inline QDBusPendingReply<> SupportedCodecs(const Tp::MediaStreamHandlerCodecList& codecs, int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("SupportedCodecs"));
        callMessage << QVariant::fromValue(codecs);
        return this->connection().asyncCall(callMessage, timeout);
    }

    /**
     * Begins a call to the D-Bus method \c CodecsUpdated on the remote object.
     * 
     * Inform the connection manager that the parameters of the supported 
     * codecs for this session have changed. The connection manager should 
     * send the new parameters to the remote contact. This is required for 
     * H.264 and Theora, for example.
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     *
     * \param codecs
     *     
     *     Locally supported codecs, which SHOULD be the same as were 
     *     previously in effect, but possibly with different parameters.
     * \param timeout The timeout in milliseconds.
     */
    inline QDBusPendingReply<> CodecsUpdated(const Tp::MediaStreamHandlerCodecList& codecs, int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("CodecsUpdated"));
        callMessage << QVariant::fromValue(codecs);
        return this->connection().asyncCall(callMessage, timeout);
    }

    /**
     * Begins a call to the D-Bus method \c HoldState on the remote object.
     * 
     * Notify the connection manager that the stream&apos;s hold state has 
     * been changed successfully in response to SetStreamHeld.
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     *
     * \param held
     *     
     *     If true, the stream is now on hold.
     * \param timeout The timeout in milliseconds.
     */
    inline QDBusPendingReply<> HoldState(bool held, int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("HoldState"));
        callMessage << QVariant::fromValue(held);
        return this->connection().asyncCall(callMessage, timeout);
    }

    /**
     * Begins a call to the D-Bus method \c UnholdFailure on the remote object.
     * 
     * Notify the connection manager that an attempt to reacquire the 
     * necessary hardware or software resources to unhold the stream, in 
     * response to SetStreamHeld, has failed.
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     * \param timeout The timeout in milliseconds.
     */
    inline QDBusPendingReply<> UnholdFailure(int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("UnholdFailure"));
        return this->connection().asyncCall(callMessage, timeout);
    }

    /**
     * Begins a call to the D-Bus method \c SupportedFeedbackMessages on the remote object.
     * 
     * Inform the connection manager of the supported feedback messages for 
     * this session. This is called a before calling SupportedCodecs, Ready or 
     * CodecsUpdated to indicate the local, or negotiated feedback messages.
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     *
     * \param messages
     *     
     *     Locally supported feedback messages.
     * \param timeout The timeout in milliseconds.
     */
    inline QDBusPendingReply<> SupportedFeedbackMessages(const Tp::RTCPFeedbackMessageMap& messages, int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("SupportedFeedbackMessages"));
        callMessage << QVariant::fromValue(messages);
        return this->connection().asyncCall(callMessage, timeout);
    }

    /**
     * Begins a call to the D-Bus method \c SupportedHeaderExtensions on the remote object.
     * 
     * Inform the connection manager of the supported RTP header extensions 
     * for this session. This is called before calling SupportedCodecs, Ready 
     * or CodecsUpdated to indicate the local or negotiated RTP header 
     * extensions.
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     *
     * \param headerExtensions
     *     
     *     Locally supported RTP header extensions.
     * \param timeout The timeout in milliseconds.
     */
    inline QDBusPendingReply<> SupportedHeaderExtensions(const Tp::RTPHeaderExtensionsList& headerExtensions, int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("SupportedHeaderExtensions"));
        callMessage << QVariant::fromValue(headerExtensions);
        return this->connection().asyncCall(callMessage, timeout);
    }

Q_SIGNALS:
    /**
     * Represents the signal \c AddRemoteCandidate on the remote object.
     * 
     * Signal emitted when the connection manager wishes to inform the client 
     * of a new remote candidate.
     *
     * \param candidateID
     *     
     *     String identifier for this candidate
     *
     * \param transports
     *     
     *     Array of transports for this candidate with fields, as defined in 
     *     NewNativeCandidate
     */
    void AddRemoteCandidate(const QString& candidateID, const Tp::MediaStreamHandlerTransportList& transports);

    /**
     * Represents the signal \c Close on the remote object.
     * 
     * Signal emitted when the connection manager wishes the stream to be 
     * closed.
     */
    void Close();

    /**
     * Represents the signal \c RemoveRemoteCandidate on the remote object.
     * 
     * Signal emitted when the connection manager wishes to inform the client 
     * that the remote end has removed a previously usable candidate. It 
     * seemed like a good idea at the time, but wasn&apos;t.
     *
     * \param candidateID
     *     
     *     String identifier for remote candidate to drop
     */
    void RemoveRemoteCandidate(const QString& candidateID);

    /**
     * Represents the signal \c SetActiveCandidatePair on the remote object.
     * 
     * Emitted by the connection manager to inform the client that a valid 
     * candidate pair has been discovered by the remote end and streaming is 
     * in progress.
     */
    void SetActiveCandidatePair(const QString& nativeCandidateID, const QString& remoteCandidateID);

    /**
     * Represents the signal \c SetRemoteCandidateList on the remote object.
     * 
     * Signal emitted when the connection manager wishes to inform the client 
     * of all the available remote candidates at once.
     *
     * \param remoteCandidates
     *     
     *     A list of candidate id and a list of transports as defined in 
     *     NewNativeCandidate
     */
    void SetRemoteCandidateList(const Tp::MediaStreamHandlerCandidateList& remoteCandidates);

    /**
     * Represents the signal \c SetRemoteCodecs on the remote object.
     * 
     * Signal emitted when the connection manager wishes to inform the client 
     * of the codecs supported by the remote end. If these codecs are 
     * compatible with the remote codecs, then the client must call 
     * SupportedCodecs, otherwise call Error.
     *
     * \param codecs
     *     
     *     Codecs supported by the remote peer.
     */
    void SetRemoteCodecs(const Tp::MediaStreamHandlerCodecList& codecs);

    /**
     * Represents the signal \c SetStreamPlaying on the remote object.
     * 
     * If emitted with argument TRUE, this means that the connection manager 
     * wishes to set the stream playing; this means that the streaming 
     * implementation should expect to receive data. If emitted with argument 
     * FALSE this signal is basically meaningless and should be ignored. 
     * We&apos;re very sorry.
     */
    void SetStreamPlaying(bool playing);

    /**
     * Represents the signal \c SetStreamSending on the remote object.
     * 
     * Signal emitted when the connection manager wishes to set whether or not 
     * the stream sends to the remote end.
     */
    void SetStreamSending(bool sending);

    /**
     * Represents the signal \c StartTelephonyEvent on the remote object.
     * 
     * Request that a telephony event (as defined by RFC 4733) is transmitted 
     * over this stream until StopTelephonyEvent is called.
     *
     * \param event
     *     
     *     A telephony event code.
     */
    void StartTelephonyEvent(uchar event);

    /**
     * Represents the signal \c StartNamedTelephonyEvent on the remote object.
     * 
     * Request that a telephony event (as defined by RFC 4733) is transmitted 
     * over this stream until StopTelephonyEvent is called. This differs from 
     * StartTelephonyEvent in that you force the event to be transmitted as a 
     * RFC 4733 named event, not as sound. You can also force a specific Codec 
     * ID.
     *
     * \param event
     *     
     *     A telephony event code as defined by RFC 4733.
     *
     * \param codecID
     *     
     *     The payload type to use when sending events. The value 0xFFFFFFFF 
     *     means to send with the already configured event type instead of 
     *     using the specified one.
     */
    void StartNamedTelephonyEvent(uchar event, uint codecID);

    /**
     * Represents the signal \c StartSoundTelephonyEvent on the remote object.
     * 
     * Request that a telephony event (as defined by RFC 4733) is transmitted 
     * over this stream until StopTelephonyEvent is called. This differs from 
     * StartTelephonyEvent in that you force the event to be transmitted as 
     * sound instead of as a named event.
     *
     * \param event
     *     
     *     A telephony event code as defined by RFC 4733.
     */
    void StartSoundTelephonyEvent(uchar event);

    /**
     * Represents the signal \c StopTelephonyEvent on the remote object.
     * 
     * Request that any ongoing telephony events (as defined by RFC 4733) 
     * being transmitted over this stream are stopped.
     */
    void StopTelephonyEvent();

    /**
     * Represents the signal \c SetStreamHeld on the remote object.
     * 
     * \htmlonly
     * <p>Emitted when the connection manager wishes to place the stream on
     *   hold (so the streaming client should free hardware or software
     *   resources) or take the stream off hold (so the streaming client
     *   should reacquire the necessary resources).</p>
     * 
     * <p>When placing a channel's streams on hold, the connection manager
     *   SHOULD notify the remote contact that this will be done (if
     *   appropriate in the protocol) before it emits this signal.</p>
     * 
     * <div class="rationale">
     *   <p>It is assumed that relinquishing a resource will not fail.
     *     If it does, the call is probably doomed anyway.</p>
     * </div>
     * 
     * <p>When unholding a channel's streams, the connection manager
     *   SHOULD emit this signal and wait for success to be indicated
     *   via HoldState before it notifies the remote contact that the
     *   channel has been taken off hold.</p>
     * 
     * <div class="rationale">
     *   <p>This means that if a resource is unavailable, the remote
     *     contact will never even be told that we tried to acquire it.</p>
     * </div>
     * \endhtmlonly
     *
     * \param held
     *     
     *     If true, the stream is to be placed on hold.
     */
    void SetStreamHeld(bool held);

    /**
     * Represents the signal \c SetRemoteFeedbackMessages on the remote object.
     * 
     * Signal emitted when the connection manager wishes to inform the client 
     * of the feedback messages supported by the remote end. This signal is 
     * emitted before SetRemoteCodecs. If the client supports any of these 
     * messages, it must call SupportedFeedbackMessages before calling 
     * SupportedCodecs.
     *
     * \param messages
     *     
     *     Remote Feedback messages desired by the remote side
     */
    void SetRemoteFeedbackMessages(const Tp::RTCPFeedbackMessageMap& messages);

    /**
     * Represents the signal \c SetRemoteHeaderExtensions on the remote object.
     * 
     * Signal emitted when the connection manager wishes to inform the client 
     * of the RTP header extensions supported by the remote end. This signal 
     * is emitted before SetRemoteCodecs. If the client supports any of these 
     * messages, it must call SupportedHeaderExtensions before calling 
     * SupportedCodecs.
     *
     * \param headerExtensions
     *     
     *     Header extensions desired by the remote side
     */
    void SetRemoteHeaderExtensions(const Tp::RTPHeaderExtensionsList& headerExtensions);

protected:
    virtual void invalidate(Tp::DBusProxy *, const QString &, const QString &);
};
}
}
Q_DECLARE_METATYPE(Tp::Client::MediaStreamHandlerInterface*)
