/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.rights;

import org.hsqldb.HsqlNameManager;
import org.hsqldb.error.Error;
import org.hsqldb.lib.StringConverter;
import org.hsqldb.rights.Grantee;
import org.hsqldb.rights.GranteeManager;

public class User
extends Grantee {
    private String password;
    public boolean isLocalOnly;
    public boolean isExternalOnly;
    private HsqlNameManager.HsqlName initialSchema = null;

    User(HsqlNameManager.HsqlName hsqlName, GranteeManager granteeManager) {
        super(hsqlName, granteeManager);
        if (granteeManager != null) {
            this.updateAllRights();
        }
    }

    @Override
    public String getSQL() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("CREATE").append(' ').append("USER");
        stringBuffer.append(' ').append(this.granteeName.statementName).append(' ');
        stringBuffer.append("PASSWORD").append(' ').append("DIGEST");
        stringBuffer.append(' ').append('\'').append(this.password).append('\'');
        return stringBuffer.toString();
    }

    public String getPasswordDigest() {
        return this.password;
    }

    public void setPassword(String string, boolean bl) {
        if (!bl) {
            string = this.granteeManager.digest(string);
        }
        this.password = string;
    }

    public void checkPassword(String string) {
        String string2 = this.granteeManager.digest(string);
        if (!string2.equals(this.password)) {
            throw Error.error(4000);
        }
    }

    public HsqlNameManager.HsqlName getInitialSchema() {
        return this.initialSchema;
    }

    public HsqlNameManager.HsqlName getInitialOrDefaultSchema() {
        if (this.initialSchema != null) {
            return this.initialSchema;
        }
        HsqlNameManager.HsqlName hsqlName = this.granteeManager.database.schemaManager.findSchemaHsqlName(this.getName().getNameString());
        if (hsqlName == null) {
            return this.granteeManager.database.schemaManager.getDefaultSchemaHsqlName();
        }
        return hsqlName;
    }

    public void setInitialSchema(HsqlNameManager.HsqlName hsqlName) {
        this.initialSchema = hsqlName;
    }

    public String getInitialSchemaSQL() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("ALTER").append(' ');
        stringBuffer.append("USER").append(' ');
        stringBuffer.append(this.getName().getStatementName()).append(' ');
        stringBuffer.append("SET").append(' ');
        stringBuffer.append("INITIAL").append(' ');
        stringBuffer.append("SCHEMA").append(' ');
        stringBuffer.append(this.initialSchema.getStatementName());
        return stringBuffer.toString();
    }

    public String getLocalUserSQL() {
        StringBuffer stringBuffer = new StringBuffer(64);
        stringBuffer.append("ALTER").append(' ');
        stringBuffer.append("USER").append(' ');
        stringBuffer.append(this.getName().getStatementName()).append(' ');
        stringBuffer.append("SET").append(' ').append("LOCAL");
        stringBuffer.append(' ').append("TRUE");
        return stringBuffer.toString();
    }

    public String getSetUserPasswordDigestSQL(String string, boolean bl) {
        if (!bl) {
            string = this.granteeManager.digest(string);
        }
        StringBuffer stringBuffer = new StringBuffer(64);
        stringBuffer.append("ALTER").append(' ');
        stringBuffer.append("USER").append(' ');
        stringBuffer.append(this.getName().getStatementName()).append(' ');
        stringBuffer.append("SET").append(' ');
        stringBuffer.append("PASSWORD").append(' ').append("DIGEST");
        stringBuffer.append(' ').append('\'').append(string).append('\'');
        return stringBuffer.toString();
    }

    public static String getSetCurrentPasswordDigestSQL(GranteeManager granteeManager, String string, boolean bl) {
        if (!bl) {
            string = granteeManager.digest(string);
        }
        StringBuffer stringBuffer = new StringBuffer(64);
        stringBuffer.append("SET").append(' ');
        stringBuffer.append("PASSWORD").append(' ').append("DIGEST");
        stringBuffer.append(' ').append('\'').append(string).append('\'');
        return stringBuffer.toString();
    }

    public String getConnectUserSQL() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SET").append(' ');
        stringBuffer.append("SESSION").append(' ');
        stringBuffer.append("AUTHORIZATION").append(' ');
        stringBuffer.append(StringConverter.toQuotedString(this.getName().getNameString(), '\'', true));
        return stringBuffer.toString();
    }
}

