/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.search.provider.impl;

import java.awt.EventQueue;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Stack;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.netbeans.api.search.SearchScopeOptions;
import org.netbeans.api.search.provider.FileNameMatcher;
import org.netbeans.api.search.provider.SearchListener;
import org.netbeans.api.search.provider.impl.AbstractFileObjectIterator;
import org.netbeans.api.search.provider.impl.FilterHelper;
import org.netbeans.spi.search.SearchFilterDefinition;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Enumerations;

public class SimpleSearchIterator
extends AbstractFileObjectIterator {
    private Enumeration<? extends FileObject> childrenEnum;
    private final Stack<Enumeration<? extends FileObject>> enums = new Stack();
    private boolean upToDate = false;
    private FileObject nextObject;
    private FileObject rootFile;
    private SearchListener listener;
    private FileNameMatcher fileNameMatcher;
    private FilterHelper filterHelper;
    private boolean searchInArchives;
    private AtomicBoolean terminated;

    public SimpleSearchIterator(FileObject fileObject, SearchScopeOptions searchScopeOptions, List<SearchFilterDefinition> list, SearchListener searchListener, AtomicBoolean atomicBoolean) {
        this.rootFile = fileObject;
        this.childrenEnum = this.rootFile.isFolder() ? SimpleSearchIterator.sortEnum(this.rootFile.getChildren(false)) : Enumerations.singleton((Object)this.rootFile);
        this.listener = searchListener;
        this.fileNameMatcher = FileNameMatcher.create(searchScopeOptions);
        this.searchInArchives = searchScopeOptions.isSearchInArchives();
        this.filterHelper = new FilterHelper(list, searchScopeOptions);
        this.terminated = atomicBoolean;
    }

    @Override
    public boolean hasNext() {
        assert (!EventQueue.isDispatchThread());
        if (!this.upToDate) {
            this.update();
        }
        return this.nextObject != null;
    }

    @Override
    public FileObject next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.upToDate = false;
        return this.nextObject;
    }

    private void update() {
        assert (!this.upToDate);
        assert (this.childrenEnum != null);
        do {
            if (this.childrenEnum.hasMoreElements()) {
                FileObject fileObject = this.childrenEnum.nextElement();
                if (fileObject.isFolder()) {
                    this.processFolder(fileObject);
                    continue;
                }
                if (this.searchInArchives && this.isArchive(fileObject)) {
                    this.listener.directoryEntered(fileObject.getPath());
                    FileObject fileObject2 = FileUtil.getArchiveRoot((FileObject)fileObject);
                    this.processFolder(fileObject2);
                    continue;
                }
                if (!this.fileNameMatcher.pathMatches(fileObject) || !this.checkFileFilters(fileObject)) continue;
                this.nextObject = fileObject;
                break;
            }
            this.nextObject = null;
            if (this.enums.isEmpty()) {
                this.childrenEnum = null;
                continue;
            }
            this.childrenEnum = this.enums.pop();
            this.filterHelper.popStack();
        } while (this.childrenEnum != null);
        this.upToDate = true;
    }

    private void processFolder(FileObject fileObject) {
        if (!this.terminated.get() && this.checkFolderFilters(fileObject)) {
            this.listener.directoryEntered(fileObject.getPath());
            this.enums.push(this.childrenEnum);
            this.childrenEnum = SimpleSearchIterator.sortEnum(fileObject.getChildren(false));
        }
    }

    private boolean checkFolderFilters(FileObject fileObject) {
        assert (fileObject.isFolder());
        return this.filterHelper.directoryAllowed(fileObject, this.listener);
    }

    private boolean checkFileFilters(FileObject fileObject) {
        assert (!fileObject.isFolder());
        return this.filterHelper.fileAllowed(fileObject, this.listener);
    }

    private boolean isArchive(FileObject fileObject) {
        return this.isArchiveExtension(fileObject.getExt()) && FileUtil.isArchiveFile((FileObject)fileObject);
    }

    private boolean isArchiveExtension(String string) {
        return "zip".equalsIgnoreCase(string) || "jar".equalsIgnoreCase(string);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    static <T extends FileObject> Enumeration<T> sortEnum(Enumeration<T> enumeration) {
        Object object;
        TreeMap<String, FileObject> treeMap = new TreeMap<String, FileObject>();
        while (enumeration.hasMoreElements()) {
            object = (FileObject)enumeration.nextElement();
            treeMap.put(object.getNameExt(), (FileObject)object);
        }
        object = treeMap.values().iterator();
        return new Enumeration<T>((Iterator)object){
            final /* synthetic */ Iterator val$iterator;
            {
                this.val$iterator = iterator;
            }

            @Override
            public boolean hasMoreElements() {
                return this.val$iterator.hasNext();
            }

            @Override
            public T nextElement() {
                return (FileObject)this.val$iterator.next();
            }
        };
    }
}

