/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.save;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import tim.prune.ExternalTools;
import tim.prune.I18nManager;
import tim.prune.UpdateMessageBroker;
import tim.prune.config.Config;
import tim.prune.data.DataPoint;
import tim.prune.data.MediaObject;
import tim.prune.data.Photo;
import tim.prune.data.PhotoList;
import tim.prune.save.PhotoTableEntry;
import tim.prune.save.PhotoTableModel;

public class ExifSaver
implements Runnable {
    private Frame _parentFrame = null;
    private JDialog _dialog = null;
    private JButton _okButton = null;
    private JCheckBox _overwriteCheckbox = null;
    private JCheckBox _forceCheckbox = null;
    private JProgressBar _progressBar = null;
    private PhotoTableModel _photoTableModel = null;
    private boolean _saveCancelled = false;

    public ExifSaver(Frame frame) {
        this._parentFrame = frame;
    }

    public boolean saveExifInformation(PhotoList photoList) {
        int n;
        boolean bl = ExternalTools.isToolInstalled(0);
        if (!(bl || (n = JOptionPane.showConfirmDialog(this._dialog, I18nManager.getText("dialog.saveexif.noexiftool"), I18nManager.getText("dialog.saveexif.title"), 0, 2)) != 1 && n != -1)) {
            return false;
        }
        this._photoTableModel = new PhotoTableModel(photoList.getNumPhotos());
        n = 0;
        while (n < photoList.getNumPhotos()) {
            Photo photo = photoList.getPhoto(n);
            PhotoTableEntry photoTableEntry = new PhotoTableEntry(photo);
            this._photoTableModel.addPhotoInfo(photoTableEntry);
            ++n;
        }
        if (this._photoTableModel.getNumSaveablePhotos() < 1) {
            JOptionPane.showMessageDialog(this._parentFrame, I18nManager.getText("dialog.saveexif.nothingtosave"), I18nManager.getText("dialog.saveexif.title"), 2);
            return false;
        }
        this._dialog = new JDialog(this._parentFrame, I18nManager.getText("dialog.saveexif.title"), true);
        this._dialog.setLocationRelativeTo(this._parentFrame);
        this._dialog.setDefaultCloseOperation(2);
        this._dialog.getContentPane().add(this.makeDialogComponents());
        this._dialog.pack();
        this._progressBar.setVisible(false);
        this._dialog.setVisible(true);
        return true;
    }

    private JPanel makeDialogComponents() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        JLabel jLabel = new JLabel(I18nManager.getText("dialog.saveexif.intro"));
        jLabel.setBorder(BorderFactory.createEmptyBorder(8, 6, 5, 6));
        jPanel.add((Component)jLabel, "North");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout());
        JTable jTable = new JTable(this._photoTableModel);
        JScrollPane jScrollPane = new JScrollPane(jTable);
        jScrollPane.setPreferredSize(new Dimension(300, 160));
        jPanel3.add((Component)jScrollPane, "Center");
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BoxLayout(jPanel4, 1));
        this._overwriteCheckbox = new JCheckBox(I18nManager.getText("dialog.saveexif.overwrite"));
        this._overwriteCheckbox.setSelected(false);
        jPanel4.add(this._overwriteCheckbox);
        this._forceCheckbox = new JCheckBox(I18nManager.getText("dialog.saveexif.force"));
        this._forceCheckbox.setSelected(false);
        jPanel4.add(this._forceCheckbox);
        jPanel3.add((Component)jPanel4, "South");
        jPanel2.add((Component)jPanel3, "Center");
        this._progressBar = new JProgressBar(0, 100);
        jPanel2.add((Component)this._progressBar, "South");
        jPanel.add((Component)jPanel2, "Center");
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BoxLayout(jPanel5, 1));
        JButton jButton = new JButton(I18nManager.getText("button.selectall"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ExifSaver.this.selectPhotos(true);
            }
        });
        jPanel5.add(jButton);
        JButton jButton2 = new JButton(I18nManager.getText("button.selectnone"));
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ExifSaver.this.selectPhotos(false);
            }
        });
        jPanel5.add(jButton2);
        jPanel.add((Component)jPanel5, "East");
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new FlowLayout(2));
        this._okButton = new JButton(I18nManager.getText("button.ok"));
        this._okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ExifSaver.this._okButton.setEnabled(false);
                new Thread(ExifSaver.this).start();
            }
        });
        jPanel6.add(this._okButton);
        JButton jButton3 = new JButton(I18nManager.getText("button.cancel"));
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ExifSaver.this._saveCancelled = true;
                ExifSaver.this._dialog.dispose();
            }
        });
        jPanel6.add(jButton3);
        jPanel.add((Component)jPanel6, "South");
        return jPanel;
    }

    private void selectPhotos(boolean bl) {
        int n = this._photoTableModel.getRowCount();
        int n2 = 0;
        while (n2 < n) {
            this._photoTableModel.getPhotoTableEntry(n2).setSaveFlag(bl);
            ++n2;
        }
        this._photoTableModel.fireTableDataChanged();
    }

    @Override
    public void run() {
        this._saveCancelled = false;
        PhotoTableEntry photoTableEntry = null;
        Photo photo = null;
        int n = this._photoTableModel.getRowCount();
        this._progressBar.setMaximum(n);
        this._progressBar.setValue(0);
        this._progressBar.setVisible(true);
        boolean bl = this._overwriteCheckbox.isSelected();
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (n5 < n) {
            photoTableEntry = this._photoTableModel.getPhotoTableEntry(n5);
            if (photoTableEntry != null && photoTableEntry.getSaveFlag() && !this._saveCancelled && (photo = photoTableEntry.getPhoto()) != null && photo.isModified()) {
                if (this.savePhoto(photo, bl, false)) {
                    ++n2;
                } else if (this._forceCheckbox.isSelected() && this.savePhoto(photo, bl, true)) {
                    ++n4;
                } else {
                    ++n3;
                }
            }
            this._progressBar.setValue(n5 + 1);
            ++n5;
        }
        this._progressBar.setVisible(false);
        UpdateMessageBroker.informSubscribers(I18nManager.getTextWithNumber("confirm.saveexif.ok", n2));
        if (n3 > 0) {
            JOptionPane.showMessageDialog(this._parentFrame, I18nManager.getTextWithNumber("error.saveexif.failed", n3), I18nManager.getText("dialog.saveexif.title"), 0);
        }
        if (n4 > 0) {
            JOptionPane.showMessageDialog(this._parentFrame, I18nManager.getTextWithNumber("error.saveexif.forced", n4), I18nManager.getText("dialog.saveexif.title"), 2);
        }
        this._dialog.dispose();
    }

    private boolean savePhoto(Photo photo, boolean bl, boolean bl2) {
        if (photo.getFile() == null) {
            return false;
        }
        if (!photo.getFile().exists()) {
            JOptionPane.showMessageDialog(this._parentFrame, String.valueOf(I18nManager.getText("error.saveexif.filenotfound")) + " : " + photo.getFile().getAbsolutePath(), I18nManager.getText("dialog.saveexif.title"), 0);
            return false;
        }
        if (bl && !photo.getFile().canWrite()) {
            int n = JOptionPane.showConfirmDialog(this._parentFrame, String.valueOf(I18nManager.getText("error.saveexif.cannotoverwrite1")) + " " + photo.getFile().getAbsolutePath() + " " + I18nManager.getText("error.saveexif.cannotoverwrite2"), I18nManager.getText("dialog.saveexif.title"), 0, 0);
            if (n == 0) {
                bl = false;
            } else {
                return false;
            }
        }
        String[] stringArray = null;
        stringArray = photo.getCurrentStatus() == MediaObject.Status.NOT_CONNECTED ? ExifSaver.getDeleteGpsExifTagsCommand(photo.getFile(), bl) : ExifSaver.getWriteGpsExifTagsCommand(photo.getFile(), photo.getDataPoint(), bl, bl2);
        boolean bl3 = false;
        try {
            Process process = Runtime.getRuntime().exec(stringArray);
            try {
                process.waitFor();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            bl3 = process.exitValue() == 0;
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this._parentFrame, "Exception: '" + exception.getClass().getName() + "' : " + exception.getMessage(), I18nManager.getText("dialog.saveexif.title"), 0);
        }
        return bl3;
    }

    private static String[] getDeleteGpsExifTagsCommand(File file, boolean bl) {
        String[] stringArray = new String[bl ? 5 : 4];
        stringArray[0] = Config.getConfigString("prune.exiftoolpath");
        stringArray[1] = "-P";
        if (bl) {
            stringArray[2] = " -overwrite_original_in_place";
        }
        int n = bl ? 3 : 2;
        stringArray[n] = "-GPS:All=";
        stringArray[n + 1] = file.getAbsolutePath();
        return stringArray;
    }

    private static String[] getWriteGpsExifTagsCommand(File file, DataPoint dataPoint, boolean bl, boolean bl2) {
        int n;
        String[] stringArray = new String[(bl ? 10 : 9) + (bl2 ? 1 : 0)];
        stringArray[0] = Config.getConfigString("prune.exiftoolpath");
        stringArray[1] = "-P";
        if (bl) {
            stringArray[2] = "-overwrite_original_in_place";
        }
        int n2 = n = bl ? 3 : 2;
        if (bl2) {
            stringArray[n] = "-m";
            ++n;
        }
        stringArray[n] = "-GPSLatitude='" + dataPoint.getLatitude().output(15) + "'";
        stringArray[n + 1] = "-GPSLatitudeRef=" + dataPoint.getLatitude().output(16);
        stringArray[n + 2] = "-GPSLongitude='" + dataPoint.getLongitude().output(15) + "'";
        stringArray[n + 3] = "-GPSLongitudeRef=" + dataPoint.getLongitude().output(16);
        stringArray[n + 4] = "-GPSAltitude=" + (dataPoint.hasAltitude() ? dataPoint.getAltitude().getMetricValue() : 0.0);
        stringArray[n + 5] = "-GPSAltitudeRef='Above Sea Level'";
        stringArray[n + 6] = file.getAbsolutePath();
        return stringArray;
    }
}

