/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.save.xml;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;

public abstract class XmlUtils {
    private static final String CDATA_START = "<![CDATA[";
    private static final String CDATA_END = "]]>";
    private static String _systemEncoding = null;

    public static String fixCdata(String string) {
        if (string == null || string.isEmpty()) {
            return "";
        }
        if (!XmlUtils.hasIllegalCharacter(string)) {
            return string;
        }
        String string2 = string;
        if (string2.startsWith(CDATA_START)) {
            string2 = string2.substring(CDATA_START.length());
        }
        if (!XmlUtils.hasIllegalCharacter(string2 = string2.replaceAll(CDATA_END, ""))) {
            return string2;
        }
        return CDATA_START + string2 + CDATA_END;
    }

    public static boolean hasIllegalCharacter(String string) {
        if (string == null) {
            return false;
        }
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (c == '<' || c == '>' || c == '&') {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean isSystemUtf8() {
        String string = XmlUtils.getSystemEncoding();
        return string != null && string.toUpperCase().equals("UTF-8");
    }

    public static String getSystemEncoding() {
        if (_systemEncoding == null) {
            _systemEncoding = XmlUtils.determineSystemEncoding();
        }
        return _systemEncoding;
    }

    private static String determineSystemEncoding() {
        File file = null;
        String string = null;
        try {
            file = File.createTempFile("gpsprune", null);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(new FileOutputStream(file));
            string = XmlUtils.getEncoding(outputStreamWriter);
            outputStreamWriter.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (file != null && file.exists() && !file.delete()) {
            System.err.println("Cannot delete temp file: " + file.getAbsolutePath());
        }
        if (string == null) {
            string = Charset.defaultCharset().name();
        }
        return string;
    }

    public static String getEncoding(OutputStreamWriter outputStreamWriter) {
        String string = outputStreamWriter.getEncoding();
        try {
            string = Charset.forName(string).name();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }
}

