/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.jlatexmath;

import java.util.LinkedList;
import java.util.ListIterator;
import org.scilab.forge.jlatexmath.Atom;
import org.scilab.forge.jlatexmath.Box;
import org.scilab.forge.jlatexmath.HorizontalBox;
import org.scilab.forge.jlatexmath.SpaceAtom;
import org.scilab.forge.jlatexmath.StrutBox;
import org.scilab.forge.jlatexmath.TeXEnvironment;
import org.scilab.forge.jlatexmath.VerticalBox;

public class VRowAtom
extends Atom {
    protected LinkedList<Atom> elements = new LinkedList();
    private SpaceAtom raise = new SpaceAtom(1, 0.0f, 0.0f, 0.0f);
    protected boolean addInterline = false;
    protected boolean vtop = false;
    protected int halign = 5;

    public VRowAtom() {
    }

    public VRowAtom(Atom el) {
        if (el != null) {
            if (el instanceof VRowAtom) {
                this.elements.addAll(((VRowAtom)el).elements);
            } else {
                this.elements.add(el);
            }
        }
    }

    public void setAddInterline(boolean addInterline) {
        this.addInterline = addInterline;
    }

    public boolean getAddInterline() {
        return this.addInterline;
    }

    public void setHalign(int halign) {
        this.halign = halign;
    }

    public int getHalign() {
        return this.halign;
    }

    public void setVtop(boolean vtop) {
        this.vtop = vtop;
    }

    public boolean getVtop() {
        return this.vtop;
    }

    public void setRaise(int unit, float r) {
        this.raise = new SpaceAtom(unit, r, 0.0f, 0.0f);
    }

    public Atom getLastAtom() {
        return this.elements.removeLast();
    }

    public final void add(Atom el) {
        if (el != null) {
            this.elements.add(0, el);
        }
    }

    public final void append(Atom el) {
        if (el != null) {
            this.elements.add(el);
        }
    }

    @Override
    public Box createBox(TeXEnvironment env) {
        float t;
        VerticalBox vb = new VerticalBox();
        if (this.halign != 5) {
            float maxWidth = Float.NEGATIVE_INFINITY;
            LinkedList<Box> boxes = new LinkedList<Box>();
            ListIterator it = this.elements.listIterator();
            while (it.hasNext()) {
                Box b = ((Atom)it.next()).createBox(env);
                boxes.add(b);
                if (!(maxWidth < b.getWidth())) continue;
                maxWidth = b.getWidth();
            }
            StrutBox interline = new StrutBox(0.0f, env.getInterline(), 0.0f, 0.0f);
            ListIterator it2 = boxes.listIterator();
            while (it2.hasNext()) {
                Box b = (Box)it2.next();
                vb.add(new HorizontalBox(b, maxWidth, this.halign));
                if (!this.addInterline || !it2.hasNext()) continue;
                vb.add(interline);
            }
        } else {
            StrutBox interline = new StrutBox(0.0f, env.getInterline(), 0.0f, 0.0f);
            ListIterator it = this.elements.listIterator();
            while (it.hasNext()) {
                vb.add(((Atom)it.next()).createBox(env));
                if (!this.addInterline || !it.hasNext()) continue;
                vb.add(interline);
            }
        }
        vb.setShift(-this.raise.createBox(env).getWidth());
        if (this.vtop) {
            t = vb.getSize() == 0 ? 0.0f : ((Box)vb.children.getFirst()).getHeight();
            vb.setHeight(t);
            vb.setDepth(vb.getDepth() + vb.getHeight() - t);
        } else {
            t = vb.getSize() == 0 ? 0.0f : ((Box)vb.children.getLast()).getDepth();
            vb.setHeight(vb.getDepth() + vb.getHeight() - t);
            vb.setDepth(t);
        }
        return vb;
    }
}

