/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.NotNull;

public class ProfilingInfo {
    private final long myCreatedTimeStamp;
    private volatile long myDisposedTimeStamp;
    private final AtomicLong myUseCount;
    @NotNull
    private final StackTraceElement myOrigin;

    public ProfilingInfo(@NotNull StackTraceElement origin) {
        if (origin == null) {
            ProfilingInfo.$$$reportNull$$$0(0);
        }
        this.myDisposedTimeStamp = -1L;
        this.myUseCount = new AtomicLong();
        this.myCreatedTimeStamp = ProfilingInfo.currentTime();
        this.myOrigin = origin;
    }

    public synchronized void valueDisposed() {
        if (this.myDisposedTimeStamp != 0L) {
            this.myDisposedTimeStamp = ProfilingInfo.currentTime();
        }
    }

    public void valueUsed() {
        this.myUseCount.incrementAndGet();
    }

    public long getCreatedTimeStamp() {
        return this.myCreatedTimeStamp;
    }

    public long getDisposedTimeStamp() {
        return this.myDisposedTimeStamp;
    }

    public long getUseCount() {
        return this.myUseCount.get();
    }

    public long getLifetime() {
        long disposedTime = this.myDisposedTimeStamp;
        if (disposedTime == -1L) {
            disposedTime = ProfilingInfo.currentTime();
        }
        return disposedTime - this.myCreatedTimeStamp;
    }

    @NotNull
    public StackTraceElement getOrigin() {
        StackTraceElement stackTraceElement = this.myOrigin;
        if (stackTraceElement == null) {
            ProfilingInfo.$$$reportNull$$$0(1);
        }
        return stackTraceElement;
    }

    private static long currentTime() {
        return System.currentTimeMillis();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "origin";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/util/ProfilingInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/util/ProfilingInfo";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrigin";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

