/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.FirEffectiveVisibility;
import org.jetbrains.kotlin.fir.FirEffectiveVisibilityImpl;
import org.jetbrains.kotlin.fir.FirEffectiveVisibilityResolver;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.FirSourceElement;
import org.jetbrains.kotlin.fir.SessionUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirAnnotatedDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousObject;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirCallableMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.resolve.MainSessionComponentsKt;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.symbols.AbstractFirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.name.ClassId;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0002\b\u0003\u0018\u00010\rH\u0014J&\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u00102\u000e\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u00122\u0006\u0010\u0014\u001a\u00020\u0015J4\u0010\u0016\u001a\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\r\u0012\u0004\u0012\u00020\b\u0018\u00010\u0017*\u00020\u00182\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u001a\u0010\u0019\u001a\u00020\b*\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0002\b\u0003\u0018\u00010\rH\u0004J\u000e\u0010\u001a\u001a\u0004\u0018\u00010\u0018*\u00020\u0013H\u0002J\u000e\u0010\u001b\u001a\u0004\u0018\u00010\u0018*\u00020\u0013H\u0002J6\u0010\u001c\u001a\u0014\u0012\n\u0012\b\u0012\u0002\b\u0003\u0018\u00010\r\u0012\u0004\u0012\u00020\b0\u0017*\u00020\u00102\u000e\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0014\u0010\u001d\u001a\u00020\b*\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\bH\u0002R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/fir/FirEffectiveVisibilityResolverImpl;", "Lorg/jetbrains/kotlin/fir/FirEffectiveVisibilityResolver;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "(Lorg/jetbrains/kotlin/fir/FirSession;)V", "cache", "", "Lorg/jetbrains/kotlin/fir/FirSourceElement;", "Lorg/jetbrains/kotlin/fir/FirEffectiveVisibility;", "computeEffectiveVisibility", "visibility", "Lorg/jetbrains/kotlin/descriptors/Visibility;", "containerSymbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassLikeSymbol;", "resolveFor", "declaration", "Lorg/jetbrains/kotlin/fir/declarations/FirMemberDeclaration;", "containingDeclarations", "", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "scopeSession", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "findOuterContainerInfo", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/name/ClassId;", "forVisibility", "getClassId", "getParentClassId", "getParentInfo", "remember", "Lorg/jetbrains/kotlin/fir/FirElement;", "effectiveVisibility", "resolve"})
public class FirEffectiveVisibilityResolverImpl
extends FirEffectiveVisibilityResolver {
    @NotNull
    private final FirSession session;
    @NotNull
    private final Map<FirSourceElement, FirEffectiveVisibility> cache;

    public FirEffectiveVisibilityResolverImpl(@NotNull FirSession session2) {
        Intrinsics.checkNotNullParameter(session2, "session");
        this.session = session2;
        boolean bl = false;
        this.cache = new LinkedHashMap();
    }

    @Override
    @NotNull
    public final FirEffectiveVisibility resolveFor(@NotNull FirMemberDeclaration declaration2, @Nullable List<? extends FirDeclaration> containingDeclarations, @NotNull ScopeSession scopeSession) {
        Object object;
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        Intrinsics.checkNotNullParameter(scopeSession, "scopeSession");
        if (declaration2.getSource() != null) {
            Object object2 = this.cache;
            FirSourceElement firSourceElement = declaration2.getSource();
            boolean bl = false;
            object = object2.get(firSourceElement);
            if (object != null) {
                object2 = object;
                boolean bl2 = false;
                bl = false;
                Object it = object2;
                boolean bl3 = false;
                return it;
            }
        }
        object = this.getParentInfo(declaration2, containingDeclarations, scopeSession);
        FirClassLikeSymbol<?> parentSymbol = ((Pair)object).component1();
        FirEffectiveVisibility parentEffectiveVisibility = ((Pair)object).component2();
        Visibility visibility2 = null;
        FirAnnotatedDeclaration $this$visibility$iv = declaration2;
        boolean $i$f$getVisibility2 = false;
        visibility2 = $this$visibility$iv.getStatus().getVisibility();
        if (declaration2 instanceof FirSimpleFunction) {
            FirClassLikeSymbol<?> $i$f$getVisibility2 = parentSymbol;
            FirClassLikeDeclaration $this$safeAs$iv = $i$f$getVisibility2 == null ? null : (FirClassLikeDeclaration)$i$f$getVisibility2.getFir();
            boolean $i$f$safeAs = false;
            FirClassLikeDeclaration firClassLikeDeclaration = $this$safeAs$iv;
            if (!(firClassLikeDeclaration instanceof FirClass)) {
                firClassLikeDeclaration = null;
            }
            if (($this$visibility$iv = (FirClass)firClassLikeDeclaration) != null) {
                FirAnnotatedDeclaration firAnnotatedDeclaration = $this$visibility$iv;
                boolean bl = false;
                boolean bl4 = false;
                FirAnnotatedDeclaration it = firAnnotatedDeclaration;
                boolean bl5 = false;
                visibility2 = SessionUtilsKt.lowestVisibilityAmongOverrides((FirSimpleFunction)declaration2, it, this.session, scopeSession);
            }
        }
        FirEffectiveVisibility selfEffectiveVisibility = this.computeEffectiveVisibility(visibility2, parentSymbol);
        selfEffectiveVisibility = parentEffectiveVisibility.lowerBound(selfEffectiveVisibility);
        return this.remember(declaration2, selfEffectiveVisibility);
    }

    @NotNull
    protected FirEffectiveVisibility computeEffectiveVisibility(@NotNull Visibility visibility2, @Nullable FirClassLikeSymbol<?> containerSymbol) {
        Intrinsics.checkNotNullParameter(visibility2, "visibility");
        return this.forVisibility(visibility2.normalize(), containerSymbol);
    }

    @NotNull
    protected final FirEffectiveVisibility forVisibility(@NotNull Visibility $this$forVisibility, @Nullable FirClassLikeSymbol<?> containerSymbol) {
        FirEffectiveVisibility firEffectiveVisibility;
        Intrinsics.checkNotNullParameter($this$forVisibility, "<this>");
        Visibility visibility2 = $this$forVisibility;
        if ((Intrinsics.areEqual(visibility2, Visibilities.Private.INSTANCE) ? true : Intrinsics.areEqual(visibility2, Visibilities.PrivateToThis.INSTANCE)) ? true : Intrinsics.areEqual(visibility2, Visibilities.InvisibleFake.INSTANCE)) {
            firEffectiveVisibility = FirEffectiveVisibilityImpl.Private.INSTANCE;
        } else if (Intrinsics.areEqual(visibility2, Visibilities.Protected.INSTANCE)) {
            firEffectiveVisibility = new FirEffectiveVisibilityImpl.Protected(containerSymbol, this.session);
        } else if (Intrinsics.areEqual(visibility2, Visibilities.Internal.INSTANCE)) {
            firEffectiveVisibility = FirEffectiveVisibilityImpl.Internal.INSTANCE;
        } else if (Intrinsics.areEqual(visibility2, Visibilities.Public.INSTANCE)) {
            firEffectiveVisibility = FirEffectiveVisibilityImpl.Public.INSTANCE;
        } else if (Intrinsics.areEqual(visibility2, Visibilities.Local.INSTANCE)) {
            firEffectiveVisibility = FirEffectiveVisibilityImpl.Local.INSTANCE;
        } else if (Intrinsics.areEqual(visibility2, Visibilities.Unknown.INSTANCE)) {
            firEffectiveVisibility = FirEffectiveVisibilityImpl.Private.INSTANCE;
        } else {
            String string2 = "Visibility " + $this$forVisibility.getName() + " is not allowed in forVisibility";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        return firEffectiveVisibility;
    }

    private final FirEffectiveVisibility remember(FirElement $this$remember, FirEffectiveVisibility effectiveVisibility) {
        FirSourceElement source = $this$remember.getSource();
        if (source != null) {
            Map<FirSourceElement, FirEffectiveVisibility> map = this.cache;
            boolean bl = false;
            map.put(source, effectiveVisibility);
        }
        return effectiveVisibility;
    }

    private final Pair<FirClassLikeSymbol<?>, FirEffectiveVisibility> getParentInfo(FirMemberDeclaration $this$getParentInfo, List<? extends FirDeclaration> containingDeclarations, ScopeSession scopeSession) {
        Object it2;
        boolean bl;
        boolean bl2;
        Object object;
        Object object2;
        FirEffectiveVisibility parentEffectiveVisibility = null;
        parentEffectiveVisibility = FirEffectiveVisibilityImpl.Public.INSTANCE;
        FirClassLikeSymbol<Object> parentSymbol = null;
        ClassId parentClassId = this.getParentClassId($this$getParentInfo);
        boolean succeededToGetSymbol = false;
        if (parentClassId != null && containingDeclarations != null && (object2 = this.findOuterContainerInfo(parentClassId, containingDeclarations, scopeSession)) != null) {
            object = object2;
            bl2 = false;
            bl = false;
            it2 = object;
            boolean bl3 = false;
            parentSymbol = ((Pair)it2).getFirst();
            parentEffectiveVisibility = ((Pair)it2).getSecond();
            succeededToGetSymbol = true;
        }
        if (!succeededToGetSymbol) {
            object2 = parentClassId;
            if (Intrinsics.areEqual(object2 == null ? null : Boolean.valueOf(((ClassId)object2).isLocal()), false)) {
                FirClassLikeSymbol<?> firClassLikeSymbol;
                object2 = MainSessionComponentsKt.getFirSymbolProvider($this$getParentInfo.getSession()).getClassLikeSymbolByFqName(parentClassId);
                if (object2 == null) {
                    object = parentClassId.getOuterClassId();
                    if (object == null) {
                        firClassLikeSymbol = null;
                    } else {
                        FirClassLikeSymbol<Object> firClassLikeSymbol2 = object;
                        bl = false;
                        boolean it2 = false;
                        FirClassLikeSymbol<Object> it3 = firClassLikeSymbol2;
                        boolean bl4 = false;
                        FirClassLikeSymbol<?> firClassLikeSymbol3 = MainSessionComponentsKt.getFirSymbolProvider($this$getParentInfo.getSession()).getClassLikeSymbolByFqName((ClassId)((Object)it3));
                        firClassLikeSymbol = firClassLikeSymbol3;
                    }
                } else {
                    firClassLikeSymbol = object2;
                }
                parentSymbol = firClassLikeSymbol;
                object = parentSymbol;
                FirClassLikeDeclaration $this$safeAs$iv = object == null ? null : (FirClassLikeDeclaration)((AbstractFirBasedSymbol)object).getFir();
                boolean $i$f$safeAs = false;
                FirClassLikeDeclaration firClassLikeDeclaration = $this$safeAs$iv;
                if (!(firClassLikeDeclaration instanceof FirMemberDeclaration)) {
                    firClassLikeDeclaration = null;
                }
                if ((object2 = (FirMemberDeclaration)((Object)firClassLikeDeclaration)) != null) {
                    object = object2;
                    bl2 = false;
                    bl = false;
                    it2 = object;
                    boolean bl5 = false;
                    parentEffectiveVisibility = this.resolveFor((FirMemberDeclaration)it2, null, scopeSession);
                }
            } else {
                object2 = parentClassId;
                if (Intrinsics.areEqual(object2 == null ? null : Boolean.valueOf(((ClassId)object2).isLocal()), true)) {
                    parentEffectiveVisibility = FirEffectiveVisibilityImpl.Local.INSTANCE;
                }
            }
        }
        return TuplesKt.to(parentSymbol, parentEffectiveVisibility);
    }

    private final ClassId getParentClassId(FirDeclaration $this$getParentClassId) {
        ConeClassLikeLookupTag coneClassLikeLookupTag;
        FirDeclaration firDeclaration = $this$getParentClassId;
        return firDeclaration instanceof FirCallableMemberDeclaration ? ((coneClassLikeLookupTag = ClassMembersKt.containingClass((FirCallableDeclaration)$this$getParentClassId)) == null ? null : coneClassLikeLookupTag.getClassId()) : (firDeclaration instanceof FirClassLikeDeclaration ? ((FirClassLikeDeclaration)$this$getParentClassId).getSymbol().getClassId().getOuterClassId() : null);
    }

    private final ClassId getClassId(FirDeclaration $this$getClassId) {
        ConeClassLikeLookupTag coneClassLikeLookupTag;
        FirDeclaration firDeclaration = $this$getClassId;
        return firDeclaration instanceof FirCallableMemberDeclaration ? ((coneClassLikeLookupTag = ClassMembersKt.containingClass((FirCallableDeclaration)$this$getClassId)) == null ? null : coneClassLikeLookupTag.getClassId()) : (firDeclaration instanceof FirClassLikeDeclaration ? ((FirClassLikeDeclaration)$this$getClassId).getSymbol().getClassId() : null);
    }

    private final Pair<FirClassLikeSymbol<?>, FirEffectiveVisibility> findOuterContainerInfo(ClassId $this$findOuterContainerInfo, List<? extends FirDeclaration> containingDeclarations, ScopeSession scopeSession) {
        int n = 0;
        int n2 = containingDeclarations.size() + -1;
        if (n <= n2) {
            do {
                Object object;
                int index2 = n++;
                FirDeclaration declaration2 = containingDeclarations.get(index2);
                ClassId declarationClassId = this.getClassId(declaration2);
                if (!Intrinsics.areEqual($this$findOuterContainerInfo.getRelativeClassName(), (object = declarationClassId) == null ? null : ((ClassId)object).getRelativeClassName())) continue;
                object = declaration2;
                return object instanceof FirRegularClass ? TuplesKt.to(((FirRegularClass)declaration2).getSymbol(), this.resolveFor((FirMemberDeclaration)declaration2, containingDeclarations.subList(0, index2), scopeSession)) : (object instanceof FirAnonymousObject ? TuplesKt.to(((FirAnonymousObject)declaration2).getSymbol(), this.remember(declaration2, FirEffectiveVisibilityImpl.Local.INSTANCE)) : (Pair<FirRegularClassSymbol, FirEffectiveVisibility>)null);
            } while (n <= n2);
        }
        return null;
    }
}

