/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.spelling;

import java.io.File;
import java.net.URL;
import java.util.Arrays;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Ignore;
import org.junit.Test;
import org.languagetool.JLanguageTool;
import org.languagetool.languagemodel.LanguageModel;
import org.languagetool.languagemodel.LuceneLanguageModel;
import org.languagetool.rules.spelling.SuggestionSorter;

public class SuggestionSorterTest {
    @Test
    @Ignore(value="interferes with LuceneSingleIndexLanguageModel")
    public void testSort() {
        URL ngramUrl = JLanguageTool.getDataBroker().getFromResourceDirAsUrl("/yy/ngram-index");
        try (LuceneLanguageModel model = new LuceneLanguageModel(new File(ngramUrl.getFile()));){
            SuggestionSorter sorter = new SuggestionSorter((LanguageModel)model);
            MatcherAssert.assertThat((Object)sorter.sortSuggestions(Arrays.asList("thee", "the", "teh")), (Matcher)CoreMatchers.is(Arrays.asList("the", "thee", "teh")));
            MatcherAssert.assertThat((Object)sorter.sortSuggestions(Arrays.asList("nuce", "foo", "nice")), (Matcher)CoreMatchers.is(Arrays.asList("nice", "nuce", "foo")));
            MatcherAssert.assertThat((Object)sorter.sortSuggestions(Arrays.asList("nuce")), (Matcher)CoreMatchers.is(Arrays.asList("nuce")));
            MatcherAssert.assertThat((Object)sorter.sortSuggestions(Arrays.asList("nice")), (Matcher)CoreMatchers.is(Arrays.asList("nice")));
            MatcherAssert.assertThat((Object)sorter.sortSuggestions(Arrays.asList("")), (Matcher)CoreMatchers.is(Arrays.asList("")));
        }
    }

    @Test
    @Ignore(value="needs full index")
    public void testSortWithFullNgrams() {
        String ngramIndex = "/home/dnaber/data/google-ngram-index/de";
        try (LuceneLanguageModel model = new LuceneLanguageModel(new File(ngramIndex));){
            SuggestionSorter suggestionSorter = new SuggestionSorter((LanguageModel)model);
        }
    }
}

