/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graph2;

import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;
import net.sourceforge.plantuml.graph2.Neighborhood2;

public class Singularity2 {
    private final TreeSet<Double> angles = new TreeSet();
    private final Point2D.Double center;

    public Singularity2(Point2D.Double center) {
        this.center = center;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.center.toString());
        for (Double a : this.angles) {
            int degree = (int)(a * 180.0 / Math.PI);
            sb.append(' ');
            sb.append(degree);
        }
        return sb.toString();
    }

    public void addLineSegment(Line2D.Double seg) {
        if (seg.getP1().equals(this.center)) {
            this.angles.add(Singularity2.convertAngle(Singularity2.getAngle(seg)));
        } else if (seg.getP2().equals(this.center)) {
            this.angles.add(Singularity2.convertAngle(Singularity2.getOppositeAngle(seg)));
        } else {
            throw new IllegalArgumentException();
        }
        assert (this.betweenZeroAndTwoPi());
    }

    static final double getAngle(Line2D.Double line) {
        if (line.getP1().equals(line.getP2())) {
            throw new IllegalArgumentException();
        }
        return Math.atan2(line.getP2().getY() - line.getP1().getY(), line.getP2().getX() - line.getP1().getX());
    }

    static final double getOppositeAngle(Line2D.Double line) {
        return Math.atan2(line.getP1().getY() - line.getP2().getY(), line.getP1().getX() - line.getP2().getX());
    }

    static double convertAngle(double a) {
        while (a < 0.0) {
            a += Math.PI * 2;
        }
        return a;
    }

    private boolean betweenZeroAndTwoPi() {
        for (Double d : this.angles) {
            assert (d >= 0.0);
            assert (d < Math.PI * 2);
        }
        return true;
    }

    List<Double> getAngles() {
        return new ArrayList<Double>(this.angles);
    }

    public boolean crossing(Point2D.Double direction1, Point2D.Double direction2) {
        boolean result = this.crossingInternal(direction1, direction2);
        assert (result == this.crossingInternal(direction2, direction1));
        return result;
    }

    private boolean crossingInternal(Point2D.Double direction1, Point2D.Double direction2) {
        if (this.angles.size() < 2) {
            return false;
        }
        double angle1 = Singularity2.convertAngle(Singularity2.getAngle(new Line2D.Double(this.center, direction1)));
        double angle2 = Singularity2.convertAngle(Singularity2.getAngle(new Line2D.Double(this.center, direction2)));
        Double last = null;
        for (Double current : this.angles) {
            if (last != null) {
                assert (last < current);
                if (this.isBetween(angle1, last, current) && this.isBetween(angle2, last, current)) {
                    return false;
                }
            }
            last = current;
        }
        double first = this.angles.first();
        return !(angle1 <= first) && !(angle1 >= last) || !(angle2 <= first) && !(angle2 >= last);
    }

    private boolean isBetween(double test, double v1, double v2) {
        assert (v1 < v2);
        return test >= v1 && test <= v2;
    }

    protected final Point2D.Double getCenter() {
        return this.center;
    }

    public void merge(Singularity2 other) {
        this.angles.addAll(other.angles);
    }

    public List<Neighborhood2> getNeighborhoods() {
        if (this.angles.size() == 0) {
            return Collections.singletonList(new Neighborhood2(this.center));
        }
        ArrayList<Neighborhood2> result = new ArrayList<Neighborhood2>();
        double last = this.angles.last();
        for (Double currentAngle : this.angles) {
            result.add(new Neighborhood2(this.center, last, currentAngle));
            last = currentAngle;
        }
        return Collections.unmodifiableList(result);
    }
}

