/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project.lang;

import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.project.GanttConstraint;
import net.sourceforge.plantuml.project.GanttDiagram;
import net.sourceforge.plantuml.project.core.Task;
import net.sourceforge.plantuml.project.core.TaskAttribute;
import net.sourceforge.plantuml.project.core.TaskInstant;
import net.sourceforge.plantuml.project.lang.ComplementFromTo;
import net.sourceforge.plantuml.project.lang.SentenceSimple;
import net.sourceforge.plantuml.project.lang.SubjectTask;
import net.sourceforge.plantuml.project.lang.TwoNames;
import net.sourceforge.plantuml.project.lang.Verbs;

public class SentenceOccurs
extends SentenceSimple {
    public SentenceOccurs() {
        super(new SubjectTask(), Verbs.occurs(), new ComplementFromTo());
    }

    @Override
    public CommandExecutionResult execute(GanttDiagram project, Object subject, Object complement) {
        Task task = (Task)subject;
        TwoNames bothNames = (TwoNames)complement;
        String name1 = bothNames.getName1();
        String name2 = bothNames.getName2();
        Task from = project.getExistingTask(name1);
        if (from == null) {
            return CommandExecutionResult.error("No such " + name1 + " task");
        }
        Task to = project.getExistingTask(name2);
        if (to == null) {
            return CommandExecutionResult.error("No such " + name2 + " task");
        }
        task.setStart(from.getEnd());
        task.setEnd(to.getEnd());
        project.addContraint(new GanttConstraint(new TaskInstant(from, TaskAttribute.START), new TaskInstant(task, TaskAttribute.START)));
        project.addContraint(new GanttConstraint(new TaskInstant(to, TaskAttribute.END), new TaskInstant(task, TaskAttribute.END)));
        return CommandExecutionResult.ok();
    }
}

