/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.skin.rose;

import net.sourceforge.plantuml.ISkinSimple;
import net.sourceforge.plantuml.UseStyle;
import net.sourceforge.plantuml.creole.Stencil;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.SymbolContext;
import net.sourceforge.plantuml.skin.AbstractTextualComponent;
import net.sourceforge.plantuml.skin.Area;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.svek.image.Opale;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UGraphicStencil;
import net.sourceforge.plantuml.ugraphic.UPath;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public final class ComponentRoseNote
extends AbstractTextualComponent
implements Stencil {
    private final double paddingX;
    private final double paddingY;
    private final SymbolContext symbolContext;
    private final double roundCorner;

    public ComponentRoseNote(Style style, SymbolContext symbolContext, FontConfiguration font, Display strings, double paddingX, double paddingY, ISkinSimple spriteContainer, double roundCorner, HorizontalAlignment horizontalAlignment) {
        super(style, spriteContainer.wrapWidth(), strings, font, horizontalAlignment, horizontalAlignment == HorizontalAlignment.CENTER ? 15 : 6, 15, 5, spriteContainer, true, null, null);
        this.paddingX = paddingX;
        this.paddingY = paddingY;
        if (UseStyle.useBetaStyle()) {
            this.symbolContext = style.getSymbolContext(this.getIHtmlColorSet());
            this.roundCorner = style.value(PName.RoundCorner).asInt();
        } else {
            this.symbolContext = symbolContext;
            this.roundCorner = roundCorner;
        }
    }

    @Override
    public final double getPreferredWidth(StringBounder stringBounder) {
        double result = this.getTextWidth(stringBounder) + 2.0 * this.getPaddingX() + this.symbolContext.getDeltaShadow();
        return result;
    }

    @Override
    public final double getPreferredHeight(StringBounder stringBounder) {
        return this.getTextHeight(stringBounder) + 2.0 * this.getPaddingY() + this.symbolContext.getDeltaShadow();
    }

    @Override
    public double getPaddingX() {
        return this.paddingX;
    }

    @Override
    public double getPaddingY() {
        return this.paddingY;
    }

    @Override
    protected void drawInternalU(UGraphic ug, Area area) {
        StringBounder stringBounder = ug.getStringBounder();
        int textHeight = (int)this.getTextHeight(stringBounder);
        int x2 = (int)this.getTextWidth(stringBounder);
        double diffX = area.getDimensionToUse().getWidth() - this.getPreferredWidth(stringBounder);
        if (diffX < 0.0) {
            throw new IllegalArgumentException();
        }
        if (area.getDimensionToUse().getWidth() > this.getPreferredWidth(stringBounder)) {
            x2 = (int)(area.getDimensionToUse().getWidth() - 2.0 * this.getPaddingX());
        }
        UPath polygon = Opale.getPolygonNormal(x2, textHeight, this.roundCorner);
        polygon.setDeltaShadow(this.symbolContext.getDeltaShadow());
        ug = this.symbolContext.apply(ug);
        ug.draw(polygon);
        ug.draw(Opale.getCorner(x2, this.roundCorner));
        UGraphic ug2 = UGraphicStencil.create(ug, this, new UStroke());
        ug2 = ug2.apply(new UTranslate((double)this.getMarginX1() + diffX / 2.0, this.getMarginY()));
        this.getTextBlock().drawU(ug2);
    }

    @Override
    public double getStartingX(StringBounder stringBounder, double y) {
        return 0.0;
    }

    @Override
    public double getEndingX(StringBounder stringBounder, double y) {
        return this.getTextWidth(stringBounder);
    }
}

