/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.view;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import org.protege.editor.core.ui.util.Resettable;
import org.protege.editor.core.ui.view.ViewsPane;
import org.protege.editor.core.ui.view.ViewsPaneMemento;
import org.protege.editor.core.ui.workspace.Workspace;
import org.protege.editor.core.util.HandlerRegistration;
import org.protege.editor.owl.model.entity.EntityBannerPresenter;
import org.protege.editor.owl.model.entity.EntityBannerViewImpl;
import org.protege.editor.owl.model.selection.SelectionDriver;
import org.protege.editor.owl.model.selection.SelectionPlane;
import org.protege.editor.owl.ui.util.NothingSelectedPanel;
import org.protege.editor.owl.ui.view.AbstractOWLViewComponent;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEntityVisitor;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectedEntityCardView
extends AbstractOWLViewComponent
implements Resettable,
SelectionPlane {
    public static final String ID = "org.protege.editor.owl.SelectedEntityView";
    private final CardLayout cardLayout = new CardLayout();
    private final JPanel cardPanel = new JPanel();
    private final List<ViewsPane> viewsPanes = new ArrayList<ViewsPane>();
    private static final String CLASSES_PANEL = "Classes";
    private static final String OBJECT_PROPERTIES_PANEL = "ObjectProperties";
    private static final String DATA_PROPERTIES_PANEL = "DataProperties";
    private static final String ANNOTATION_PROPERTIES_PANEL = "AnnotationProperties";
    private static final String INDIVIDUALS_PANEL = "Individual";
    private static final String DATATYPES_PANEL = "Datatypes";
    private static final String BLANK_PANEL = "Blank";
    private EntityBannerPresenter entityBannerPresenter;
    private static final Logger logger = LoggerFactory.getLogger(SelectedEntityCardView.class);

    @Override
    protected void initialiseOWLView() throws Exception {
        this.entityBannerPresenter = new EntityBannerPresenter(new EntityBannerViewImpl(), this.getOWLEditorKit());
        this.entityBannerPresenter.getView().setBorder(BorderFactory.createEmptyBorder(0, 0, 1, 0));
        this.setLayout(new BorderLayout());
        this.add(this.entityBannerPresenter.getView(), "North");
        this.add(this.cardPanel);
        this.cardPanel.setLayout(this.cardLayout);
        this.cardPanel.add((Component)new NothingSelectedPanel(), BLANK_PANEL);
        this.createViewPanes(false);
        this.getOWLWorkspace().getOWLSelectionModel().addListener(this::processSelection);
        this.getView().setShowViewBar(false);
        this.processSelection();
        this.entityBannerPresenter.start();
    }

    private void createViewPanes(boolean reset) {
        this.addPane(CLASSES_PANEL, "/selected-entity-view-class-panel.xml", "org.protege.editor.owl.ui.view.selectedentityview.classes", reset);
        this.addPane(OBJECT_PROPERTIES_PANEL, "/selected-entity-view-objectproperty-panel.xml", "org.protege.editor.owl.ui.view.selectedentityview.objectproperties", reset);
        this.addPane(DATA_PROPERTIES_PANEL, "/selected-entity-view-dataproperty-panel.xml", "org.protege.editor.owl.ui.view.selectedentityview.dataproperties", reset);
        this.addPane(ANNOTATION_PROPERTIES_PANEL, "/selected-entity-view-annotationproperty-panel.xml", "org.protege.editor.owl.ui.view.selectedentityview.annotproperties", reset);
        this.addPane(INDIVIDUALS_PANEL, "/selected-entity-view-individual-panel.xml", "org.protege.editor.owl.ui.view.selectedentityview.individuals", reset);
        this.addPane(DATATYPES_PANEL, "/selected-entity-view-datatype-panel.xml", "org.protege.editor.owl.ui.view.selectedentityview.datatypes", reset);
    }

    private void addPane(String panelId, String configFile, String viewPaneId, boolean reset) {
        URL clsURL = this.getClass().getResource(configFile);
        ViewsPane pane = new ViewsPane((Workspace)this.getOWLWorkspace(), new ViewsPaneMemento(clsURL, viewPaneId, reset));
        this.cardPanel.add((Component)pane, panelId);
        this.viewsPanes.add(pane);
    }

    public void reset() {
        for (ViewsPane pane : this.viewsPanes) {
            this.cardPanel.remove((Component)pane);
            pane.dispose();
        }
        this.viewsPanes.clear();
        this.createViewPanes(true);
        this.validate();
        for (ViewsPane pane : this.viewsPanes) {
            pane.saveViews();
        }
    }

    private void processSelection() {
        OWLObject selectedObject = this.getOWLWorkspace().getOWLSelectionModel().getSelectedObject();
        if (selectedObject == null) {
            this.selectPanel(BLANK_PANEL);
            return;
        }
        if (!(selectedObject instanceof OWLEntity)) {
            return;
        }
        OWLEntity selEntity = (OWLEntity)selectedObject;
        selEntity.accept(new OWLEntityVisitor(){

            public void visit(@Nonnull OWLClass cls) {
                SelectedEntityCardView.this.selectPanel(SelectedEntityCardView.CLASSES_PANEL);
            }

            public void visit(@Nonnull OWLObjectProperty property) {
                SelectedEntityCardView.this.selectPanel(SelectedEntityCardView.OBJECT_PROPERTIES_PANEL);
            }

            public void visit(@Nonnull OWLDataProperty property) {
                SelectedEntityCardView.this.selectPanel(SelectedEntityCardView.DATA_PROPERTIES_PANEL);
            }

            public void visit(@Nonnull OWLAnnotationProperty property) {
                SelectedEntityCardView.this.selectPanel(SelectedEntityCardView.ANNOTATION_PROPERTIES_PANEL);
            }

            public void visit(@Nonnull OWLNamedIndividual individual) {
                SelectedEntityCardView.this.selectPanel(SelectedEntityCardView.INDIVIDUALS_PANEL);
            }

            public void visit(@Nonnull OWLDatatype dataType) {
                SelectedEntityCardView.this.selectPanel(SelectedEntityCardView.DATATYPES_PANEL);
            }
        });
    }

    private void selectPanel(String name) {
        this.cardLayout.show(this.cardPanel, name);
    }

    @Override
    protected void disposeOWLView() {
        for (ViewsPane pane : this.viewsPanes) {
            pane.saveViews();
            pane.dispose();
        }
        this.entityBannerPresenter.dispose();
    }

    @Override
    public HandlerRegistration registerSelectionDriver(SelectionDriver driver) {
        return () -> {};
    }

    @Override
    public void transmitSelection(SelectionDriver driver, OWLObject selection) {
        logger.debug("[SelectedEntityCardView] Ignoring request to transmit selection");
    }
}

