/*
 * Decompiled with CFR 0.152.
 */
package com.tigervnc.vncviewer;

import com.tigervnc.network.Socket;
import com.tigervnc.network.TcpSocket;
import com.tigervnc.rdr.FdInStreamBlockCallback;
import com.tigervnc.rfb.CConnection;
import com.tigervnc.rfb.Encodings;
import com.tigervnc.rfb.Hostname;
import com.tigervnc.rfb.LogWriter;
import com.tigervnc.rfb.PixelFormat;
import com.tigervnc.rfb.Point;
import com.tigervnc.rfb.Rect;
import com.tigervnc.rfb.ScreenSet;
import com.tigervnc.rfb.Security;
import com.tigervnc.vncviewer.ClipboardDialog;
import com.tigervnc.vncviewer.DesktopWindow;
import com.tigervnc.vncviewer.OptionsDialog;
import com.tigervnc.vncviewer.Parameters;
import com.tigervnc.vncviewer.Tunnel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public class CConn
extends CConnection
implements FdInStreamBlockCallback,
ActionListener {
    static final PixelFormat verylowColorPF = new PixelFormat(8, 3, false, true, 1, 1, 1, 2, 1, 0);
    static final PixelFormat lowColorPF = new PixelFormat(8, 6, false, true, 3, 3, 3, 4, 2, 0);
    static final PixelFormat mediumColorPF = new PixelFormat(8, 8, false, true, 7, 7, 3, 5, 2, 0);
    boolean shuttingDown = false;
    private String serverHost = null;
    private int serverPort = 0;
    private Socket sock;
    protected DesktopWindow desktop = null;
    private int updateCount = 0;
    private int pixelCount = 0;
    private PixelFormat serverPF;
    private PixelFormat fullColorPF;
    private int lastServerEncoding = -1;
    public ActionListener closeListener = null;
    static LogWriter vlog = new LogWriter("CConn");

    public CConn(String string, Socket socket) {
        this.setShared(Parameters.shared.getValue());
        this.sock = socket;
        this.server.supportsLocalCursor = true;
        this.server.supportsDesktopResize = true;
        this.server.supportsClientRedirect = true;
        if (Parameters.customCompressLevel.getValue()) {
            this.setCompressLevel(Parameters.compressLevel.getValue());
        }
        if (!Parameters.noJpeg.getValue()) {
            this.setQualityLevel(Parameters.qualityLevel.getValue());
        }
        if (this.sock == null) {
            this.setServerName(Hostname.getHost(string));
            this.setServerPort(Hostname.getPort(string));
            try {
                if (Parameters.tunnel.getValue() || !Parameters.via.getValue().isEmpty()) {
                    int n = TcpSocket.findFreeTcpPort();
                    if (n == 0) {
                        throw new com.tigervnc.rfb.Exception("Could not obtain free TCP port");
                    }
                    String string2 = Tunnel.getSshHost();
                    if (string2.isEmpty()) {
                        string2 = this.getServerName();
                    }
                    Tunnel.createTunnel(string2, this.getServerName(), this.getServerPort(), n);
                    this.sock = new TcpSocket("localhost", n);
                    vlog.info("connected to localhost port " + n, new Object[0]);
                }
                this.sock = new TcpSocket(this.getServerName(), this.getServerPort());
                vlog.info("connected to host " + this.getServerName() + " port " + this.getServerPort(), new Object[0]);
            }
            catch (Exception exception) {
                throw new com.tigervnc.rfb.Exception(exception.getMessage());
            }
        } else {
            String string3 = this.sock.getPeerEndpoint();
            if (Parameters.listenMode.getValue()) {
                vlog.info("Accepted connection from " + string3, new Object[0]);
            } else {
                vlog.info("connected to host " + Hostname.getHost(string3) + " port " + Hostname.getPort(string3), new Object[0]);
            }
        }
        this.sock.inStream().setBlockCallback(this);
        this.setStreams(this.sock.inStream(), this.sock.outStream());
        this.initialiseProtocol();
        OptionsDialog.addCallback("handleOptions", this);
    }

    public String connectionInfo() {
        String string = new String("Desktop name: %s%nHost: %s:%d%nSize: %dx%d%nPixel format: %s%n  (server default: %s)%nRequested encoding: %s%nLast used encoding: %s%nLine speed estimate: %d kbit/s%nProtocol version: %d.%d%nSecurity method: %s [%s]%n");
        String string2 = String.format(string, this.server.name(), this.sock.getPeerName(), this.sock.getPeerPort(), this.server.width(), this.server.height(), this.server.pf().print(), this.serverPF.print(), Encodings.encodingName(this.getPreferredEncoding()), Encodings.encodingName(this.lastServerEncoding), this.sock.inStream().kbitsPerSecond(), this.server.majorVersion, this.server.minorVersion, Security.secTypeName(this.csecurity.getType()), this.csecurity.description());
        return string2;
    }

    public int getUpdateCount() {
        return this.updateCount;
    }

    public int getPixelCount() {
        return this.pixelCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void blockCallback() {
        try {
            CConn cConn = this;
            synchronized (cConn) {
                this.wait(1L);
            }
        }
        catch (InterruptedException interruptedException) {
            throw new com.tigervnc.rfb.Exception(interruptedException.getMessage());
        }
    }

    @Override
    public void initDone() {
        if (this.server.beforeVersion(3, 8) && Parameters.autoSelect.getValue()) {
            Parameters.fullColor.setParam(true);
        }
        this.serverPF = this.server.pf();
        this.desktop = new DesktopWindow(this.server.width(), this.server.height(), this.server.name(), this.serverPF, this);
        this.fullColorPF = this.desktop.getPreferredPF();
        this.updatePixelFormat();
        int n = Encodings.encodingNum(Parameters.preferredEncoding.getValue());
        if (n != -1) {
            this.setPreferredEncoding(n);
        }
    }

    @Override
    public void setDesktopSize(int n, int n2) {
        super.setDesktopSize(n, n2);
        this.resizeFramebuffer();
    }

    @Override
    public void setExtendedDesktopSize(int n, int n2, int n3, int n4, ScreenSet screenSet) {
        super.setExtendedDesktopSize(n, n2, n3, n4, screenSet);
        if (n == 1 && n2 != 0) {
            vlog.error("SetDesktopSize failed: " + n2, new Object[0]);
            return;
        }
        this.resizeFramebuffer();
    }

    @Override
    public void clientRedirect(int n, String string, String string2) {
        try {
            this.sock.close();
            this.sock = new TcpSocket(string, n);
            vlog.info("Redirected to " + string + ":" + n, new Object[0]);
            this.setServerName(string);
            this.setServerPort(n);
            this.sock.inStream().setBlockCallback(this);
            this.setStreams(this.sock.inStream(), this.sock.outStream());
            if (this.desktop != null) {
                this.desktop.dispose();
            }
            this.initialiseProtocol();
        }
        catch (Exception exception) {
            throw new com.tigervnc.rfb.Exception(exception.getMessage());
        }
    }

    @Override
    public void setName(String string) {
        super.setName(string);
        if (this.desktop != null) {
            this.desktop.setName(string);
        }
    }

    @Override
    public void framebufferUpdateStart() {
        super.framebufferUpdateStart();
    }

    @Override
    public void framebufferUpdateEnd() {
        super.framebufferUpdateEnd();
        ++this.updateCount;
        this.desktop.updateWindow();
        if (Parameters.autoSelect.getValue()) {
            this.autoSelectFormatAndEncoding();
        }
    }

    @Override
    public void setColourMapEntries(int n, int n2, int[] nArray) {
        vlog.error("Invalid SetColourMapEntries from server!", new Object[0]);
    }

    @Override
    public void bell() {
        if (Parameters.acceptBell.getValue()) {
            this.desktop.getToolkit().beep();
        }
    }

    @Override
    public void serverCutText(String string, int n) {
        if (!Parameters.acceptClipboard.getValue()) {
            return;
        }
        ClipboardDialog.serverCutText(string);
    }

    @Override
    public void dataRect(Rect rect, int n) {
        this.sock.inStream().startTiming();
        if (n != 1) {
            this.lastServerEncoding = n;
        }
        super.dataRect(rect, n);
        this.sock.inStream().stopTiming();
        this.pixelCount += rect.area();
    }

    @Override
    public void setCursor(int n, int n2, Point point, byte[] byArray) {
        this.desktop.setCursor(n, n2, point, byArray);
    }

    @Override
    public void fence(int n, int n2, byte[] byArray) {
        this.server.supportsFence = true;
        if ((n & Integer.MIN_VALUE) != 0) {
            this.writer().writeFence(n &= 3, n2, byArray);
            return;
        }
    }

    @Override
    public void resizeFramebuffer() {
        if (this.desktop == null) {
            return;
        }
        this.desktop.resizeFramebuffer(this.server.width(), this.server.height());
    }

    private void autoSelectFormatAndEncoding() {
        long l = this.sock.inStream().kbitsPerSecond();
        long l2 = this.sock.inStream().timeWaited();
        boolean bl = Parameters.fullColor.getValue();
        int n = Parameters.qualityLevel.getValue();
        this.setPreferredEncoding(7);
        if (l == 0L || l2 < 100L) {
            return;
        }
        if (!Parameters.noJpeg.getValue() && (n = l > 16000L ? 8 : 6) != Parameters.qualityLevel.getValue()) {
            vlog.info("Throughput " + l + " kbit/s - changing to quality " + n, new Object[0]);
            Parameters.qualityLevel.setParam(n);
            this.setQualityLevel(n);
        }
        if (this.server.beforeVersion(3, 8)) {
            return;
        }
        boolean bl2 = bl = l > 256L;
        if (bl != Parameters.fullColor.getValue()) {
            if (bl) {
                vlog.info("Throughput " + l + " kbit/s - full color is now enabled", new Object[0]);
            } else {
                vlog.info("Throughput " + l + " kbit/s - full color is now disabled", new Object[0]);
            }
            Parameters.fullColor.setParam(bl);
            this.updatePixelFormat();
        }
    }

    private void updatePixelFormat() {
        PixelFormat pixelFormat = Parameters.fullColor.getValue() ? this.fullColorPF : (Parameters.lowColorLevel.getValue() == 0 ? verylowColorPF : (Parameters.lowColorLevel.getValue() == 1 ? lowColorPF : mediumColorPF));
        String string = pixelFormat.print();
        vlog.info("Using pixel format " + string, new Object[0]);
        this.setPF(pixelFormat);
    }

    public void handleOptions() {
        int n;
        if (!Parameters.autoSelect.getValue() && (n = Encodings.encodingNum(Parameters.preferredEncoding.getValue())) != -1) {
            this.setPreferredEncoding(n);
        }
        if (Parameters.customCompressLevel.getValue()) {
            this.setCompressLevel(Parameters.compressLevel.getValue());
        } else {
            this.setCompressLevel(-1);
        }
        if (!Parameters.noJpeg.getValue() && !Parameters.autoSelect.getValue()) {
            this.setQualityLevel(Parameters.qualityLevel.getValue());
        } else {
            this.setQualityLevel(-1);
        }
        this.updatePixelFormat();
    }

    public void close() {
        JFrame jFrame;
        if (this.closeListener != null && (jFrame = (JFrame)SwingUtilities.getAncestorOfClass(JFrame.class, this.desktop)) != null) {
            jFrame.dispatchEvent(new WindowEvent(jFrame, 201));
        }
        this.shuttingDown = true;
        try {
            if (this.sock != null) {
                this.sock.shutdown();
            }
        }
        catch (Exception exception) {
            throw new com.tigervnc.rfb.Exception(exception.getMessage());
        }
    }

    public void writeClientCutText(String string, int n) {
        if (this.state() != CConnection.stateEnum.RFBSTATE_NORMAL || this.shuttingDown) {
            return;
        }
        this.writer().writeClientCutText(string, n);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
    }

    public Socket getSocket() {
        return this.sock;
    }
}

