//! Utility macros.

macro_rules! constify_imm6 {
    ($imm8:expr, $expand:ident) => {
        #[allow(overflowing_literals)]
        match ($imm8) & 0b1_1111 {
            0 => $expand!(0),
            1 => $expand!(1),
            2 => $expand!(2),
            3 => $expand!(3),
            4 => $expand!(4),
            5 => $expand!(5),
            6 => $expand!(6),
            7 => $expand!(7),
            8 => $expand!(8),
            9 => $expand!(9),
            10 => $expand!(10),
            11 => $expand!(11),
            12 => $expand!(12),
            13 => $expand!(13),
            14 => $expand!(14),
            15 => $expand!(15),
            16 => $expand!(16),
            17 => $expand!(17),
            18 => $expand!(18),
            19 => $expand!(19),
            20 => $expand!(20),
            21 => $expand!(21),
            22 => $expand!(22),
            23 => $expand!(23),
            24 => $expand!(24),
            25 => $expand!(25),
            26 => $expand!(26),
            27 => $expand!(27),
            28 => $expand!(28),
            29 => $expand!(29),
            30 => $expand!(30),
            _ => $expand!(31),
        }
    };
}

macro_rules! constify_imm4 {
    ($imm8:expr, $expand:ident) => {
        #[allow(overflowing_literals)]
        match ($imm8) & 0b1111 {
            0 => $expand!(0),
            1 => $expand!(1),
            2 => $expand!(2),
            3 => $expand!(3),
            4 => $expand!(4),
            5 => $expand!(5),
            6 => $expand!(6),
            7 => $expand!(7),
            8 => $expand!(8),
            9 => $expand!(9),
            10 => $expand!(10),
            11 => $expand!(11),
            12 => $expand!(12),
            13 => $expand!(13),
            14 => $expand!(14),
            _ => $expand!(15),
        }
    };
}

macro_rules! constify_imm3 {
    ($imm8:expr, $expand:ident) => {
        #[allow(overflowing_literals)]
        match ($imm8) & 0b111 {
            0 => $expand!(0),
            1 => $expand!(1),
            2 => $expand!(2),
            3 => $expand!(3),
            4 => $expand!(4),
            5 => $expand!(5),
            6 => $expand!(6),
            _ => $expand!(7),
        }
    };
}

macro_rules! constify_imm2 {
    ($imm8:expr, $expand:ident) => {
        #[allow(overflowing_literals)]
        match ($imm8) & 0b11 {
            0 => $expand!(0),
            1 => $expand!(1),
            2 => $expand!(2),
            _ => $expand!(3),
        }
    };
}

// Constifies 5 bits along with an sae option without rounding control.
// See: https://github.com/llvm/llvm-project/blob/bd50cf905fa7c0c7caa134301c6ca0658c81eeb1/clang/lib/Sema/SemaChecking.cpp#L3497
#[allow(unused)]
macro_rules! constify_imm5_sae {
    ($imm5:expr, $imm4:expr, $expand:ident) => {
        #[allow(overflowing_literals)]
        match ($imm5 & 0b1111_1, $imm4 & 0b1111) {
            (0, 4) => $expand!(0, 4),
            (0, 8) => $expand!(0, 8),
            (0, 12) => $expand!(0, 12),
            (1, 4) => $expand!(1, 4),
            (1, 8) => $expand!(1, 8),
            (1, 12) => $expand!(1, 12),
            (2, 4) => $expand!(2, 4),
            (2, 8) => $expand!(2, 8),
            (2, 12) => $expand!(2, 12),
            (3, 4) => $expand!(3, 4),
            (3, 8) => $expand!(3, 8),
            (3, 12) => $expand!(3, 12),
            (4, 4) => $expand!(4, 4),
            (4, 8) => $expand!(4, 8),
            (4, 12) => $expand!(4, 12),
            (5, 4) => $expand!(5, 4),
            (5, 8) => $expand!(5, 8),
            (5, 12) => $expand!(5, 12),
            (6, 4) => $expand!(6, 4),
            (6, 8) => $expand!(6, 8),
            (6, 12) => $expand!(6, 12),
            (7, 4) => $expand!(7, 4),
            (7, 8) => $expand!(7, 8),
            (7, 12) => $expand!(7, 12),
            (8, 4) => $expand!(8, 4),
            (8, 8) => $expand!(8, 8),
            (8, 12) => $expand!(8, 12),
            (9, 4) => $expand!(9, 4),
            (9, 8) => $expand!(9, 8),
            (9, 12) => $expand!(9, 12),
            (10, 4) => $expand!(10, 4),
            (10, 8) => $expand!(10, 8),
            (10, 12) => $expand!(10, 12),
            (11, 4) => $expand!(11, 4),
            (11, 8) => $expand!(11, 8),
            (11, 12) => $expand!(11, 12),
            (12, 4) => $expand!(12, 4),
            (12, 8) => $expand!(12, 8),
            (12, 12) => $expand!(12, 12),
            (13, 4) => $expand!(13, 4),
            (13, 8) => $expand!(13, 8),
            (13, 12) => $expand!(13, 12),
            (14, 4) => $expand!(14, 4),
            (14, 8) => $expand!(14, 8),
            (14, 12) => $expand!(14, 12),
            (15, 4) => $expand!(15, 4),
            (15, 8) => $expand!(15, 8),
            (15, 12) => $expand!(15, 12),
            (16, 4) => $expand!(16, 4),
            (16, 8) => $expand!(16, 8),
            (16, 12) => $expand!(16, 12),
            (17, 4) => $expand!(17, 4),
            (17, 8) => $expand!(17, 8),
            (17, 12) => $expand!(17, 12),
            (18, 4) => $expand!(18, 4),
            (18, 8) => $expand!(18, 8),
            (18, 12) => $expand!(18, 12),
            (19, 4) => $expand!(19, 4),
            (19, 8) => $expand!(19, 8),
            (19, 12) => $expand!(19, 12),
            (20, 4) => $expand!(20, 4),
            (20, 8) => $expand!(20, 8),
            (20, 12) => $expand!(20, 12),
            (21, 4) => $expand!(21, 4),
            (21, 8) => $expand!(21, 8),
            (21, 12) => $expand!(21, 12),
            (22, 4) => $expand!(22, 4),
            (22, 8) => $expand!(22, 8),
            (22, 12) => $expand!(22, 12),
            (23, 4) => $expand!(23, 4),
            (23, 8) => $expand!(23, 8),
            (23, 12) => $expand!(23, 12),
            (24, 4) => $expand!(24, 4),
            (24, 8) => $expand!(24, 8),
            (24, 12) => $expand!(24, 12),
            (25, 4) => $expand!(25, 4),
            (25, 8) => $expand!(25, 8),
            (25, 12) => $expand!(25, 12),
            (26, 4) => $expand!(26, 4),
            (26, 8) => $expand!(26, 8),
            (26, 12) => $expand!(26, 12),
            (27, 4) => $expand!(27, 4),
            (27, 8) => $expand!(27, 8),
            (27, 12) => $expand!(27, 12),
            (28, 4) => $expand!(28, 4),
            (28, 8) => $expand!(28, 8),
            (28, 12) => $expand!(28, 12),
            (29, 4) => $expand!(29, 4),
            (29, 8) => $expand!(29, 8),
            (29, 12) => $expand!(29, 12),
            (30, 4) => $expand!(30, 4),
            (30, 8) => $expand!(30, 8),
            (30, 12) => $expand!(30, 12),
            (31, 4) => $expand!(31, 4),
            (31, 8) => $expand!(31, 8),
            (31, 12) => $expand!(31, 12),
            (_, _) => panic!("Invalid sae value"),
        }
    };
}

// For gather instructions, the only valid values for scale are 1, 2, 4 and 8.
// This macro enforces that.
#[allow(unused)]
macro_rules! constify_imm8_gather {
    ($imm8:expr, $expand:ident) => {
        #[allow(overflowing_literals)]
        match ($imm8) {
            1 => $expand!(1),
            2 => $expand!(2),
            4 => $expand!(4),
            8 => $expand!(8),
            _ => panic!("Only 1, 2, 4, and 8 are valid values"),
        }
    };
}

// For round instructions, the only valid values for rounding are 4, 8, 9, 10 and 11.
// This macro enforces that.
#[allow(unused)]
macro_rules! constify_imm4_round {
    ($imm8:expr, $expand:ident) => {
        #[allow(overflowing_literals)]
        match ($imm8) & 0b1111 {
            4 => $expand!(4),
            8 => $expand!(8),
            9 => $expand!(9),
            10 => $expand!(10),
            11 => $expand!(11),
            _ => panic!("Invalid round value"),
        }
    };
}

// For sae instructions, the only valid values for sae are 4 and 8.
// This macro enforces that.
#[allow(unused)]
macro_rules! constify_imm4_sae {
    ($imm8:expr, $expand:ident) => {
        #[allow(overflowing_literals)]
        match ($imm8) & 0b1111 {
            4 => $expand!(4),
            8 => $expand!(8),
            _ => panic!("Invalid sae value"),
        }
    };
}

// Two mantissas parameters.
// This macro enforces that.
#[allow(unused)]
macro_rules! constify_imm4_mantissas {
    ($imm4:expr, $imm2:expr, $expand:ident) => {
        #[allow(overflowing_literals)]
        match ($imm4, $imm2) {
            (0, 0) => $expand!(0, 0),
            (0, 1) => $expand!(0, 1),
            (0, 2) => $expand!(0, 2),
            (0, 3) => $expand!(0, 3),
            (1, 0) => $expand!(1, 0),
            (1, 1) => $expand!(1, 1),
            (1, 2) => $expand!(1, 2),
            (1, 3) => $expand!(1, 3),
            (2, 0) => $expand!(2, 0),
            (2, 1) => $expand!(2, 1),
            (2, 2) => $expand!(2, 2),
            (2, 3) => $expand!(2, 3),
            (3, 0) => $expand!(3, 0),
            (3, 1) => $expand!(3, 1),
            (3, 2) => $expand!(3, 2),
            (3, 3) => $expand!(3, 3),
            (4, 0) => $expand!(4, 0),
            (4, 1) => $expand!(4, 1),
            (4, 2) => $expand!(4, 2),
            (4, 3) => $expand!(4, 3),
            (5, 0) => $expand!(5, 0),
            (5, 1) => $expand!(5, 1),
            (5, 2) => $expand!(5, 2),
            (5, 3) => $expand!(5, 3),
            (6, 0) => $expand!(6, 0),
            (6, 1) => $expand!(6, 1),
            (6, 2) => $expand!(6, 2),
            (6, 3) => $expand!(6, 3),
            (7, 0) => $expand!(7, 0),
            (7, 1) => $expand!(7, 1),
            (7, 2) => $expand!(7, 2),
            (7, 3) => $expand!(7, 3),
            (8, 0) => $expand!(8, 0),
            (8, 1) => $expand!(8, 1),
            (8, 2) => $expand!(8, 2),
            (8, 3) => $expand!(8, 3),
            (9, 0) => $expand!(9, 0),
            (9, 1) => $expand!(9, 1),
            (9, 2) => $expand!(9, 2),
            (9, 3) => $expand!(9, 3),
            (10, 0) => $expand!(10, 0),
            (10, 1) => $expand!(10, 1),
            (10, 2) => $expand!(10, 2),
            (10, 3) => $expand!(10, 3),
            (11, 0) => $expand!(11, 0),
            (11, 1) => $expand!(11, 1),
            (11, 2) => $expand!(11, 2),
            (11, 3) => $expand!(11, 3),
            (12, 0) => $expand!(12, 0),
            (12, 1) => $expand!(12, 1),
            (12, 2) => $expand!(12, 2),
            (12, 3) => $expand!(12, 3),
            (13, 0) => $expand!(13, 0),
            (13, 1) => $expand!(13, 1),
            (13, 2) => $expand!(13, 2),
            (13, 3) => $expand!(13, 3),
            (14, 0) => $expand!(14, 0),
            (14, 1) => $expand!(14, 1),
            (14, 2) => $expand!(14, 2),
            (14, 3) => $expand!(14, 3),
            (15, 0) => $expand!(15, 0),
            (15, 1) => $expand!(15, 1),
            (15, 2) => $expand!(15, 2),
            (15, 3) => $expand!(15, 3),
            (_, _) => panic!("Invalid sae value"),
        }
    };
}

// Include mantissas parameters.
// For sae instructions, the only valid values for sae are 4 and 8.
// This macro enforces that.
#[allow(unused)]
macro_rules! constify_imm4_mantissas_sae {
    ($imm4_1:expr, $imm2:expr, $imm4_2:expr, $expand:ident) => {
        #[allow(overflowing_literals)]
        match ($imm4_1, $imm2, $imm4_2) {
            (0, 0, 4) => $expand!(0, 0, 4),
            (0, 0, 8) => $expand!(0, 0, 8),
            (0, 0, 12) => $expand!(0, 0, 12),
            (0, 1, 4) => $expand!(0, 1, 4),
            (0, 1, 8) => $expand!(0, 1, 8),
            (0, 1, 12) => $expand!(0, 1, 12),
            (0, 2, 4) => $expand!(0, 2, 4),
            (0, 2, 8) => $expand!(0, 2, 8),
            (0, 2, 12) => $expand!(0, 2, 12),
            (0, 3, 4) => $expand!(0, 3, 4),
            (0, 3, 8) => $expand!(0, 3, 8),
            (0, 3, 12) => $expand!(0, 3, 12),
            (1, 0, 4) => $expand!(1, 0, 4),
            (1, 0, 8) => $expand!(1, 0, 8),
            (1, 0, 12) => $expand!(1, 0, 12),
            (1, 1, 4) => $expand!(1, 1, 4),
            (1, 1, 8) => $expand!(1, 1, 8),
            (1, 1, 12) => $expand!(1, 1, 12),
            (1, 2, 4) => $expand!(1, 2, 4),
            (1, 2, 8) => $expand!(1, 2, 8),
            (1, 2, 12) => $expand!(1, 2, 12),
            (1, 3, 4) => $expand!(1, 3, 4),
            (1, 3, 8) => $expand!(1, 3, 8),
            (1, 3, 12) => $expand!(1, 3, 12),
            (2, 0, 4) => $expand!(2, 0, 4),
            (2, 0, 8) => $expand!(2, 0, 8),
            (2, 0, 12) => $expand!(2, 0, 12),
            (2, 1, 4) => $expand!(2, 1, 4),
            (2, 1, 8) => $expand!(2, 1, 8),
            (2, 1, 12) => $expand!(2, 1, 12),
            (2, 2, 4) => $expand!(2, 2, 4),
            (2, 2, 8) => $expand!(2, 2, 8),
            (2, 2, 12) => $expand!(2, 2, 12),
            (2, 3, 4) => $expand!(2, 3, 4),
            (2, 3, 8) => $expand!(2, 3, 8),
            (2, 3, 12) => $expand!(2, 3, 12),
            (3, 0, 4) => $expand!(3, 0, 4),
            (3, 0, 8) => $expand!(3, 0, 8),
            (3, 0, 12) => $expand!(3, 0, 12),
            (3, 1, 4) => $expand!(3, 1, 4),
            (3, 1, 8) => $expand!(3, 1, 8),
            (3, 1, 12) => $expand!(3, 1, 12),
            (3, 2, 4) => $expand!(3, 2, 4),
            (3, 2, 8) => $expand!(3, 2, 8),
            (3, 2, 12) => $expand!(3, 2, 12),
            (3, 3, 4) => $expand!(3, 3, 4),
            (3, 3, 8) => $expand!(3, 3, 8),
            (3, 3, 12) => $expand!(3, 3, 12),
            (4, 0, 4) => $expand!(4, 0, 4),
            (4, 0, 8) => $expand!(4, 0, 8),
            (4, 0, 12) => $expand!(4, 0, 12),
            (4, 1, 4) => $expand!(4, 1, 4),
            (4, 1, 8) => $expand!(4, 1, 8),
            (4, 1, 12) => $expand!(4, 1, 12),
            (4, 2, 4) => $expand!(4, 2, 4),
            (4, 2, 8) => $expand!(4, 2, 8),
            (4, 2, 12) => $expand!(4, 2, 12),
            (4, 3, 4) => $expand!(4, 3, 4),
            (4, 3, 8) => $expand!(4, 3, 8),
            (4, 3, 12) => $expand!(4, 3, 12),
            (5, 0, 4) => $expand!(5, 0, 4),
            (5, 0, 8) => $expand!(5, 0, 8),
            (5, 0, 12) => $expand!(5, 0, 12),
            (5, 1, 4) => $expand!(5, 1, 4),
            (5, 1, 8) => $expand!(5, 1, 8),
            (5, 1, 12) => $expand!(5, 1, 12),
            (5, 2, 4) => $expand!(5, 2, 4),
            (5, 2, 8) => $expand!(5, 2, 8),
            (5, 2, 12) => $expand!(5, 2, 12),
            (5, 3, 4) => $expand!(5, 3, 4),
            (5, 3, 8) => $expand!(5, 3, 8),
            (5, 3, 12) => $expand!(5, 3, 12),
            (6, 0, 4) => $expand!(6, 0, 4),
            (6, 0, 8) => $expand!(6, 0, 8),
            (6, 0, 12) => $expand!(6, 0, 12),
            (6, 1, 4) => $expand!(6, 1, 4),
            (6, 1, 8) => $expand!(6, 1, 8),
            (6, 1, 12) => $expand!(6, 1, 12),
            (6, 2, 4) => $expand!(6, 2, 4),
            (6, 2, 8) => $expand!(6, 2, 8),
            (6, 2, 12) => $expand!(6, 2, 12),
            (6, 3, 4) => $expand!(6, 3, 4),
            (6, 3, 8) => $expand!(6, 3, 8),
            (6, 3, 12) => $expand!(6, 3, 12),
            (7, 0, 4) => $expand!(7, 0, 4),
            (7, 0, 8) => $expand!(7, 0, 8),
            (7, 0, 12) => $expand!(7, 0, 12),
            (7, 1, 4) => $expand!(7, 1, 4),
            (7, 1, 8) => $expand!(7, 1, 8),
            (7, 1, 12) => $expand!(7, 1, 12),
            (7, 2, 4) => $expand!(7, 2, 4),
            (7, 2, 8) => $expand!(7, 2, 8),
            (7, 2, 12) => $expand!(7, 2, 12),
            (7, 3, 4) => $expand!(7, 3, 4),
            (7, 3, 8) => $expand!(7, 3, 8),
            (7, 3, 12) => $expand!(7, 3, 12),
            (8, 0, 4) => $expand!(8, 0, 4),
            (8, 0, 8) => $expand!(8, 0, 8),
            (8, 0, 12) => $expand!(8, 0, 12),
            (8, 1, 4) => $expand!(8, 1, 4),
            (8, 1, 8) => $expand!(8, 1, 8),
            (8, 1, 12) => $expand!(8, 1, 12),
            (8, 2, 4) => $expand!(8, 2, 4),
            (8, 2, 8) => $expand!(8, 2, 8),
            (8, 2, 12) => $expand!(8, 2, 12),
            (8, 3, 4) => $expand!(8, 3, 4),
            (8, 3, 8) => $expand!(8, 3, 8),
            (8, 3, 12) => $expand!(8, 3, 12),
            (9, 0, 4) => $expand!(9, 0, 4),
            (9, 0, 8) => $expand!(9, 0, 8),
            (9, 0, 12) => $expand!(9, 0, 12),
            (9, 1, 4) => $expand!(9, 1, 4),
            (9, 1, 8) => $expand!(9, 1, 8),
            (9, 1, 12) => $expand!(9, 1, 12),
            (9, 2, 4) => $expand!(9, 2, 4),
            (9, 2, 8) => $expand!(9, 2, 8),
            (9, 2, 12) => $expand!(9, 2, 12),
            (9, 3, 4) => $expand!(9, 3, 4),
            (9, 3, 8) => $expand!(9, 3, 8),
            (9, 3, 12) => $expand!(9, 3, 12),
            (10, 0, 4) => $expand!(10, 0, 4),
            (10, 0, 8) => $expand!(10, 0, 8),
            (10, 0, 12) => $expand!(10, 0, 12),
            (10, 1, 4) => $expand!(10, 1, 4),
            (10, 1, 8) => $expand!(10, 1, 8),
            (10, 1, 12) => $expand!(10, 1, 12),
            (10, 2, 4) => $expand!(10, 2, 4),
            (10, 2, 8) => $expand!(10, 2, 8),
            (10, 2, 12) => $expand!(10, 2, 12),
            (10, 3, 4) => $expand!(10, 3, 4),
            (10, 3, 8) => $expand!(10, 3, 8),
            (10, 3, 12) => $expand!(10, 3, 12),
            (11, 0, 4) => $expand!(11, 0, 4),
            (11, 0, 8) => $expand!(11, 0, 8),
            (11, 0, 12) => $expand!(11, 0, 12),
            (11, 1, 4) => $expand!(11, 1, 4),
            (11, 1, 8) => $expand!(11, 1, 8),
            (11, 1, 12) => $expand!(11, 1, 12),
            (11, 2, 4) => $expand!(11, 2, 4),
            (11, 2, 8) => $expand!(11, 2, 8),
            (11, 2, 12) => $expand!(11, 2, 12),
            (11, 3, 4) => $expand!(11, 3, 4),
            (11, 3, 8) => $expand!(11, 3, 8),
            (11, 3, 12) => $expand!(11, 3, 12),
            (12, 0, 4) => $expand!(12, 0, 4),
            (12, 0, 8) => $expand!(12, 0, 8),
            (12, 0, 12) => $expand!(12, 0, 12),
            (12, 1, 4) => $expand!(12, 1, 4),
            (12, 1, 8) => $expand!(12, 1, 8),
            (12, 1, 12) => $expand!(12, 1, 12),
            (12, 2, 4) => $expand!(12, 2, 4),
            (12, 2, 8) => $expand!(12, 2, 8),
            (12, 2, 12) => $expand!(12, 2, 12),
            (12, 3, 4) => $expand!(12, 3, 4),
            (12, 3, 8) => $expand!(12, 3, 8),
            (12, 3, 12) => $expand!(12, 3, 12),
            (13, 0, 4) => $expand!(13, 0, 4),
            (13, 0, 8) => $expand!(13, 0, 8),
            (13, 0, 12) => $expand!(13, 0, 12),
            (13, 1, 4) => $expand!(13, 1, 4),
            (13, 1, 8) => $expand!(13, 1, 8),
            (13, 1, 12) => $expand!(13, 1, 12),
            (13, 2, 4) => $expand!(13, 2, 4),
            (13, 2, 8) => $expand!(13, 2, 8),
            (13, 2, 12) => $expand!(13, 2, 12),
            (13, 3, 4) => $expand!(13, 3, 4),
            (13, 3, 8) => $expand!(13, 3, 8),
            (13, 3, 12) => $expand!(13, 3, 12),
            (14, 0, 4) => $expand!(14, 0, 4),
            (14, 0, 8) => $expand!(14, 0, 8),
            (14, 0, 12) => $expand!(14, 0, 12),
            (14, 1, 4) => $expand!(14, 1, 4),
            (14, 1, 8) => $expand!(14, 1, 8),
            (14, 1, 12) => $expand!(14, 1, 12),
            (14, 2, 4) => $expand!(14, 2, 4),
            (14, 2, 8) => $expand!(14, 2, 8),
            (14, 2, 12) => $expand!(14, 2, 12),
            (14, 3, 4) => $expand!(14, 3, 4),
            (14, 3, 8) => $expand!(14, 3, 8),
            (14, 3, 12) => $expand!(14, 3, 12),
            (15, 0, 4) => $expand!(15, 0, 4),
            (15, 0, 8) => $expand!(15, 0, 8),
            (15, 0, 12) => $expand!(15, 0, 12),
            (15, 1, 4) => $expand!(15, 1, 4),
            (15, 1, 8) => $expand!(15, 1, 8),
            (15, 1, 12) => $expand!(15, 1, 12),
            (15, 2, 4) => $expand!(15, 2, 4),
            (15, 2, 8) => $expand!(15, 2, 8),
            (15, 2, 12) => $expand!(15, 2, 12),
            (15, 3, 4) => $expand!(15, 3, 4),
            (15, 3, 8) => $expand!(15, 3, 8),
            (15, 3, 12) => $expand!(15, 3, 12),
            (_, _, _) => panic!("Invalid sae value"),
        }
    };
}

// Constifies 8 bits along with an sae option without rounding control.
// The only valid values are 0 to 255.
// This macro enforces that.
#[allow(unused)]
macro_rules! constify_imm8_sae {
    ($imm8:expr, $expand:ident) => {
        #[allow(overflowing_literals)]
        match ($imm8) & 0b1111_1111 {
            0 => $expand!(0),
            1 => $expand!(1),
            2 => $expand!(2),
            3 => $expand!(3),
            4 => $expand!(4),
            5 => $expand!(5),
            6 => $expand!(6),
            7 => $expand!(7),
            8 => $expand!(8),
            9 => $expand!(9),
            10 => $expand!(10),
            11 => $expand!(11),
            12 => $expand!(12),
            13 => $expand!(13),
            14 => $expand!(14),
            15 => $expand!(15),
            16 => $expand!(16),
            17 => $expand!(17),
            18 => $expand!(18),
            19 => $expand!(19),
            20 => $expand!(20),
            21 => $expand!(21),
            22 => $expand!(22),
            23 => $expand!(23),
            24 => $expand!(24),
            25 => $expand!(25),
            26 => $expand!(26),
            27 => $expand!(27),
            28 => $expand!(28),
            29 => $expand!(29),
            30 => $expand!(30),
            31 => $expand!(31),
            32 => $expand!(32),
            33 => $expand!(33),
            34 => $expand!(34),
            35 => $expand!(35),
            36 => $expand!(36),
            37 => $expand!(37),
            38 => $expand!(38),
            39 => $expand!(39),
            40 => $expand!(40),
            41 => $expand!(41),
            42 => $expand!(42),
            43 => $expand!(43),
            44 => $expand!(44),
            45 => $expand!(45),
            46 => $expand!(46),
            47 => $expand!(47),
            48 => $expand!(48),
            49 => $expand!(49),
            50 => $expand!(50),
            51 => $expand!(51),
            52 => $expand!(52),
            53 => $expand!(53),
            54 => $expand!(54),
            55 => $expand!(55),
            56 => $expand!(56),
            57 => $expand!(57),
            58 => $expand!(58),
            59 => $expand!(59),
            60 => $expand!(60),
            61 => $expand!(61),
            62 => $expand!(62),
            63 => $expand!(63),
            64 => $expand!(64),
            65 => $expand!(65),
            66 => $expand!(66),
            67 => $expand!(67),
            68 => $expand!(68),
            69 => $expand!(69),
            70 => $expand!(70),
            71 => $expand!(71),
            72 => $expand!(72),
            73 => $expand!(73),
            74 => $expand!(74),
            75 => $expand!(75),
            76 => $expand!(76),
            77 => $expand!(77),
            78 => $expand!(78),
            79 => $expand!(79),
            80 => $expand!(80),
            81 => $expand!(81),
            82 => $expand!(82),
            83 => $expand!(83),
            84 => $expand!(84),
            85 => $expand!(85),
            86 => $expand!(86),
            87 => $expand!(87),
            88 => $expand!(88),
            89 => $expand!(89),
            90 => $expand!(90),
            91 => $expand!(91),
            92 => $expand!(92),
            93 => $expand!(93),
            94 => $expand!(94),
            95 => $expand!(95),
            96 => $expand!(96),
            97 => $expand!(97),
            98 => $expand!(98),
            99 => $expand!(99),
            100 => $expand!(100),
            101 => $expand!(101),
            102 => $expand!(102),
            103 => $expand!(103),
            104 => $expand!(104),
            105 => $expand!(105),
            106 => $expand!(106),
            107 => $expand!(107),
            108 => $expand!(108),
            109 => $expand!(109),
            110 => $expand!(110),
            111 => $expand!(111),
            112 => $expand!(112),
            113 => $expand!(113),
            114 => $expand!(114),
            115 => $expand!(115),
            116 => $expand!(116),
            117 => $expand!(117),
            118 => $expand!(118),
            119 => $expand!(119),
            120 => $expand!(120),
            121 => $expand!(121),
            122 => $expand!(122),
            123 => $expand!(123),
            124 => $expand!(124),
            125 => $expand!(125),
            126 => $expand!(126),
            127 => $expand!(127),
            128 => $expand!(128),
            129 => $expand!(129),
            130 => $expand!(130),
            131 => $expand!(131),
            132 => $expand!(132),
            133 => $expand!(133),
            134 => $expand!(134),
            135 => $expand!(135),
            136 => $expand!(136),
            137 => $expand!(137),
            138 => $expand!(138),
            139 => $expand!(139),
            140 => $expand!(140),
            141 => $expand!(141),
            142 => $expand!(142),
            143 => $expand!(143),
            144 => $expand!(144),
            145 => $expand!(145),
            146 => $expand!(146),
            147 => $expand!(147),
            148 => $expand!(148),
            149 => $expand!(149),
            150 => $expand!(150),
            151 => $expand!(151),
            152 => $expand!(152),
            153 => $expand!(153),
            154 => $expand!(154),
            155 => $expand!(155),
            156 => $expand!(156),
            157 => $expand!(157),
            158 => $expand!(158),
            159 => $expand!(159),
            160 => $expand!(160),
            161 => $expand!(161),
            162 => $expand!(162),
            163 => $expand!(163),
            164 => $expand!(164),
            165 => $expand!(165),
            166 => $expand!(166),
            167 => $expand!(167),
            168 => $expand!(168),
            169 => $expand!(169),
            170 => $expand!(170),
            171 => $expand!(171),
            172 => $expand!(172),
            173 => $expand!(173),
            174 => $expand!(174),
            175 => $expand!(175),
            176 => $expand!(176),
            177 => $expand!(177),
            178 => $expand!(178),
            179 => $expand!(179),
            180 => $expand!(180),
            181 => $expand!(181),
            182 => $expand!(182),
            183 => $expand!(183),
            184 => $expand!(184),
            185 => $expand!(185),
            186 => $expand!(186),
            187 => $expand!(187),
            188 => $expand!(188),
            189 => $expand!(189),
            190 => $expand!(190),
            191 => $expand!(191),
            192 => $expand!(192),
            193 => $expand!(193),
            194 => $expand!(194),
            195 => $expand!(195),
            196 => $expand!(196),
            197 => $expand!(197),
            198 => $expand!(198),
            199 => $expand!(199),
            200 => $expand!(200),
            201 => $expand!(201),
            202 => $expand!(202),
            203 => $expand!(203),
            204 => $expand!(204),
            205 => $expand!(205),
            206 => $expand!(206),
            207 => $expand!(207),
            208 => $expand!(208),
            209 => $expand!(209),
            210 => $expand!(210),
            211 => $expand!(211),
            212 => $expand!(212),
            213 => $expand!(213),
            214 => $expand!(214),
            215 => $expand!(215),
            216 => $expand!(216),
            217 => $expand!(217),
            218 => $expand!(218),
            219 => $expand!(219),
            220 => $expand!(220),
            221 => $expand!(221),
            222 => $expand!(222),
            223 => $expand!(223),
            224 => $expand!(224),
            225 => $expand!(225),
            226 => $expand!(226),
            227 => $expand!(227),
            228 => $expand!(228),
            229 => $expand!(229),
            230 => $expand!(230),
            231 => $expand!(231),
            232 => $expand!(232),
            233 => $expand!(233),
            234 => $expand!(234),
            235 => $expand!(235),
            236 => $expand!(236),
            237 => $expand!(237),
            238 => $expand!(238),
            239 => $expand!(239),
            240 => $expand!(240),
            241 => $expand!(241),
            242 => $expand!(242),
            243 => $expand!(243),
            244 => $expand!(244),
            245 => $expand!(245),
            246 => $expand!(246),
            247 => $expand!(247),
            248 => $expand!(248),
            249 => $expand!(249),
            250 => $expand!(250),
            251 => $expand!(251),
            252 => $expand!(252),
            253 => $expand!(253),
            254 => $expand!(254),
            255 => $expand!(255),
            _ => panic!("Invalid sae value"),
        }
    };
}

// Two sae parameters.
// This macro enforces that.
#[allow(unused)]
macro_rules! constify_imm8_roundscale {
    ($imm8:expr, $imm4:expr, $expand:ident) => {
        #[allow(overflowing_literals)]
        match ($imm8 & 0b11111111, $imm4) {
            (0, 4) => $expand!(0, 4),
            (0, 8) => $expand!(0, 8),
            (0, 12) => $expand!(0, 12),
            (1, 4) => $expand!(1, 4),
            (1, 8) => $expand!(1, 8),
            (1, 12) => $expand!(1, 12),
            (2, 4) => $expand!(2, 4),
            (2, 8) => $expand!(2, 8),
            (2, 12) => $expand!(2, 12),
            (3, 4) => $expand!(3, 4),
            (3, 8) => $expand!(3, 8),
            (3, 12) => $expand!(3, 12),
            (4, 4) => $expand!(4, 4),
            (4, 8) => $expand!(4, 8),
            (4, 12) => $expand!(4, 12),
            (5, 4) => $expand!(5, 4),
            (5, 8) => $expand!(5, 8),
            (5, 12) => $expand!(5, 12),
            (6, 4) => $expand!(6, 4),
            (6, 8) => $expand!(6, 8),
            (6, 12) => $expand!(6, 12),
            (7, 4) => $expand!(7, 4),
            (7, 8) => $expand!(7, 8),
            (7, 12) => $expand!(7, 12),
            (8, 4) => $expand!(8, 4),
            (8, 8) => $expand!(8, 8),
            (8, 12) => $expand!(8, 12),
            (9, 4) => $expand!(9, 4),
            (9, 8) => $expand!(9, 8),
            (9, 12) => $expand!(9, 12),
            (10, 4) => $expand!(10, 4),
            (10, 8) => $expand!(10, 8),
            (10, 12) => $expand!(10, 12),
            (11, 4) => $expand!(11, 4),
            (11, 8) => $expand!(11, 8),
            (11, 12) => $expand!(11, 12),
            (12, 4) => $expand!(12, 4),
            (12, 8) => $expand!(12, 8),
            (12, 12) => $expand!(12, 12),
            (13, 4) => $expand!(13, 4),
            (13, 8) => $expand!(13, 8),
            (13, 12) => $expand!(13, 12),
            (14, 4) => $expand!(14, 4),
            (14, 8) => $expand!(14, 8),
            (14, 12) => $expand!(14, 12),
            (15, 4) => $expand!(15, 4),
            (15, 8) => $expand!(15, 8),
            (15, 12) => $expand!(15, 12),
            (16, 4) => $expand!(16, 4),
            (16, 8) => $expand!(16, 8),
            (16, 12) => $expand!(16, 12),
            (17, 4) => $expand!(17, 4),
            (17, 8) => $expand!(17, 8),
            (17, 12) => $expand!(17, 12),
            (18, 4) => $expand!(18, 4),
            (18, 8) => $expand!(18, 8),
            (18, 12) => $expand!(18, 12),
            (19, 4) => $expand!(19, 4),
            (19, 8) => $expand!(19, 8),
            (19, 12) => $expand!(19, 12),
            (20, 4) => $expand!(20, 4),
            (20, 8) => $expand!(20, 8),
            (20, 12) => $expand!(20, 12),
            (21, 4) => $expand!(21, 4),
            (21, 8) => $expand!(21, 8),
            (21, 12) => $expand!(21, 12),
            (22, 4) => $expand!(22, 4),
            (22, 8) => $expand!(22, 8),
            (22, 12) => $expand!(22, 12),
            (23, 4) => $expand!(23, 4),
            (23, 8) => $expand!(23, 8),
            (23, 12) => $expand!(23, 12),
            (24, 4) => $expand!(24, 4),
            (24, 8) => $expand!(24, 8),
            (24, 12) => $expand!(24, 12),
            (25, 4) => $expand!(25, 4),
            (25, 8) => $expand!(25, 8),
            (25, 12) => $expand!(25, 12),
            (26, 4) => $expand!(26, 4),
            (26, 8) => $expand!(26, 8),
            (26, 12) => $expand!(26, 12),
            (27, 4) => $expand!(27, 4),
            (27, 8) => $expand!(27, 8),
            (27, 12) => $expand!(27, 12),
            (28, 4) => $expand!(28, 4),
            (28, 8) => $expand!(28, 8),
            (28, 12) => $expand!(28, 12),
            (29, 4) => $expand!(29, 4),
            (29, 8) => $expand!(29, 8),
            (29, 12) => $expand!(29, 12),
            (30, 4) => $expand!(30, 4),
            (30, 8) => $expand!(30, 8),
            (30, 12) => $expand!(30, 12),
            (31, 4) => $expand!(31, 4),
            (31, 8) => $expand!(31, 8),
            (31, 12) => $expand!(31, 12),
            (32, 4) => $expand!(32, 4),
            (32, 8) => $expand!(32, 8),
            (32, 12) => $expand!(32, 12),
            (33, 4) => $expand!(33, 4),
            (33, 8) => $expand!(33, 8),
            (33, 12) => $expand!(33, 12),
            (34, 4) => $expand!(34, 4),
            (34, 8) => $expand!(34, 8),
            (34, 12) => $expand!(34, 12),
            (35, 4) => $expand!(35, 4),
            (35, 8) => $expand!(35, 8),
            (35, 12) => $expand!(35, 12),
            (36, 4) => $expand!(36, 4),
            (36, 8) => $expand!(36, 8),
            (36, 12) => $expand!(36, 12),
            (37, 4) => $expand!(37, 4),
            (37, 8) => $expand!(37, 8),
            (37, 12) => $expand!(37, 12),
            (38, 4) => $expand!(38, 4),
            (38, 8) => $expand!(38, 8),
            (38, 12) => $expand!(38, 12),
            (39, 4) => $expand!(39, 4),
            (39, 8) => $expand!(39, 8),
            (39, 12) => $expand!(39, 12),
            (40, 4) => $expand!(40, 4),
            (40, 8) => $expand!(40, 8),
            (40, 12) => $expand!(40, 12),
            (41, 4) => $expand!(41, 4),
            (41, 8) => $expand!(41, 8),
            (41, 12) => $expand!(41, 12),
            (42, 4) => $expand!(42, 4),
            (42, 8) => $expand!(42, 8),
            (42, 12) => $expand!(42, 12),
            (43, 4) => $expand!(43, 4),
            (43, 8) => $expand!(43, 8),
            (43, 12) => $expand!(43, 12),
            (44, 4) => $expand!(44, 4),
            (44, 8) => $expand!(44, 8),
            (44, 12) => $expand!(44, 12),
            (45, 4) => $expand!(45, 4),
            (45, 8) => $expand!(45, 8),
            (45, 12) => $expand!(45, 12),
            (46, 4) => $expand!(46, 4),
            (46, 8) => $expand!(46, 8),
            (46, 12) => $expand!(46, 12),
            (47, 4) => $expand!(47, 4),
            (47, 8) => $expand!(47, 8),
            (47, 12) => $expand!(47, 12),
            (48, 4) => $expand!(48, 4),
            (48, 8) => $expand!(48, 8),
            (48, 12) => $expand!(48, 12),
            (49, 4) => $expand!(49, 4),
            (49, 8) => $expand!(49, 8),
            (49, 12) => $expand!(49, 12),
            (50, 4) => $expand!(50, 4),
            (50, 8) => $expand!(50, 8),
            (50, 12) => $expand!(50, 12),
            (51, 4) => $expand!(51, 4),
            (51, 8) => $expand!(51, 8),
            (51, 12) => $expand!(51, 12),
            (52, 4) => $expand!(52, 4),
            (52, 8) => $expand!(52, 8),
            (52, 12) => $expand!(52, 12),
            (53, 4) => $expand!(53, 4),
            (53, 8) => $expand!(53, 8),
            (53, 12) => $expand!(53, 12),
            (54, 4) => $expand!(54, 4),
            (54, 8) => $expand!(54, 8),
            (54, 12) => $expand!(54, 12),
            (55, 4) => $expand!(55, 4),
            (55, 8) => $expand!(55, 8),
            (55, 12) => $expand!(55, 12),
            (56, 4) => $expand!(56, 4),
            (56, 8) => $expand!(56, 8),
            (56, 12) => $expand!(56, 12),
            (57, 4) => $expand!(57, 4),
            (57, 8) => $expand!(57, 8),
            (57, 12) => $expand!(57, 12),
            (58, 4) => $expand!(58, 4),
            (58, 8) => $expand!(58, 8),
            (58, 12) => $expand!(58, 12),
            (59, 4) => $expand!(59, 4),
            (59, 8) => $expand!(59, 8),
            (59, 12) => $expand!(59, 12),
            (60, 4) => $expand!(60, 4),
            (60, 8) => $expand!(60, 8),
            (60, 12) => $expand!(60, 12),
            (61, 4) => $expand!(61, 4),
            (61, 8) => $expand!(61, 8),
            (61, 12) => $expand!(61, 12),
            (62, 4) => $expand!(62, 4),
            (62, 8) => $expand!(62, 8),
            (62, 12) => $expand!(62, 12),
            (63, 4) => $expand!(63, 4),
            (63, 8) => $expand!(63, 8),
            (63, 12) => $expand!(63, 12),
            (64, 4) => $expand!(64, 4),
            (64, 8) => $expand!(64, 8),
            (64, 12) => $expand!(64, 12),
            (65, 4) => $expand!(65, 4),
            (65, 8) => $expand!(65, 8),
            (65, 12) => $expand!(65, 12),
            (66, 4) => $expand!(66, 4),
            (66, 8) => $expand!(66, 8),
            (66, 12) => $expand!(66, 12),
            (67, 4) => $expand!(67, 4),
            (67, 8) => $expand!(67, 8),
            (67, 12) => $expand!(67, 12),
            (68, 4) => $expand!(68, 4),
            (68, 8) => $expand!(68, 8),
            (68, 12) => $expand!(68, 12),
            (69, 4) => $expand!(69, 4),
            (69, 8) => $expand!(69, 8),
            (69, 12) => $expand!(69, 12),
            (70, 4) => $expand!(70, 4),
            (70, 8) => $expand!(70, 8),
            (70, 12) => $expand!(70, 12),
            (71, 4) => $expand!(71, 4),
            (71, 8) => $expand!(71, 8),
            (71, 12) => $expand!(71, 12),
            (72, 4) => $expand!(72, 4),
            (72, 8) => $expand!(72, 8),
            (72, 12) => $expand!(72, 12),
            (73, 4) => $expand!(73, 4),
            (73, 8) => $expand!(73, 8),
            (73, 12) => $expand!(73, 12),
            (74, 4) => $expand!(74, 4),
            (74, 8) => $expand!(74, 8),
            (74, 12) => $expand!(74, 12),
            (75, 4) => $expand!(75, 4),
            (75, 8) => $expand!(75, 8),
            (75, 12) => $expand!(75, 12),
            (76, 4) => $expand!(76, 4),
            (76, 8) => $expand!(76, 8),
            (76, 12) => $expand!(76, 12),
            (77, 4) => $expand!(77, 4),
            (77, 8) => $expand!(77, 8),
            (77, 12) => $expand!(77, 12),
            (78, 4) => $expand!(78, 4),
            (78, 8) => $expand!(78, 8),
            (78, 12) => $expand!(78, 12),
            (79, 4) => $expand!(79, 4),
            (79, 8) => $expand!(79, 8),
            (79, 12) => $expand!(79, 12),
            (80, 4) => $expand!(80, 4),
            (80, 8) => $expand!(80, 8),
            (80, 12) => $expand!(80, 12),
            (81, 4) => $expand!(81, 4),
            (81, 8) => $expand!(81, 8),
            (81, 12) => $expand!(81, 12),
            (82, 4) => $expand!(82, 4),
            (82, 8) => $expand!(82, 8),
            (82, 12) => $expand!(82, 12),
            (83, 4) => $expand!(83, 4),
            (83, 8) => $expand!(83, 8),
            (83, 12) => $expand!(83, 12),
            (84, 4) => $expand!(84, 4),
            (84, 8) => $expand!(84, 8),
            (84, 12) => $expand!(84, 12),
            (85, 4) => $expand!(85, 4),
            (85, 8) => $expand!(85, 8),
            (85, 12) => $expand!(85, 12),
            (86, 4) => $expand!(86, 4),
            (86, 8) => $expand!(86, 8),
            (86, 12) => $expand!(86, 12),
            (87, 4) => $expand!(87, 4),
            (87, 8) => $expand!(87, 8),
            (87, 12) => $expand!(87, 12),
            (88, 4) => $expand!(88, 4),
            (88, 8) => $expand!(88, 8),
            (88, 12) => $expand!(88, 12),
            (89, 4) => $expand!(89, 4),
            (89, 8) => $expand!(89, 8),
            (89, 12) => $expand!(89, 12),
            (90, 4) => $expand!(90, 4),
            (90, 8) => $expand!(90, 8),
            (90, 12) => $expand!(90, 12),
            (91, 4) => $expand!(91, 4),
            (91, 8) => $expand!(91, 8),
            (91, 12) => $expand!(91, 12),
            (92, 4) => $expand!(92, 4),
            (92, 8) => $expand!(92, 8),
            (92, 12) => $expand!(92, 12),
            (93, 4) => $expand!(93, 4),
            (93, 8) => $expand!(93, 8),
            (93, 12) => $expand!(93, 12),
            (94, 4) => $expand!(94, 4),
            (94, 8) => $expand!(94, 8),
            (94, 12) => $expand!(94, 12),
            (95, 4) => $expand!(95, 4),
            (95, 8) => $expand!(95, 8),
            (95, 12) => $expand!(95, 12),
            (96, 4) => $expand!(96, 4),
            (96, 8) => $expand!(96, 8),
            (96, 12) => $expand!(96, 12),
            (97, 4) => $expand!(97, 4),
            (97, 8) => $expand!(97, 8),
            (97, 12) => $expand!(97, 12),
            (98, 4) => $expand!(98, 4),
            (98, 8) => $expand!(98, 8),
            (98, 12) => $expand!(98, 12),
            (99, 4) => $expand!(99, 4),
            (99, 8) => $expand!(99, 8),
            (99, 12) => $expand!(99, 12),
            (100, 4) => $expand!(100, 4),
            (100, 8) => $expand!(100, 8),
            (100, 12) => $expand!(100, 12),
            (101, 4) => $expand!(101, 4),
            (101, 8) => $expand!(101, 8),
            (101, 12) => $expand!(101, 12),
            (102, 4) => $expand!(102, 4),
            (102, 8) => $expand!(102, 8),
            (102, 12) => $expand!(102, 12),
            (103, 4) => $expand!(103, 4),
            (103, 8) => $expand!(103, 8),
            (103, 12) => $expand!(103, 12),
            (104, 4) => $expand!(104, 4),
            (104, 8) => $expand!(104, 8),
            (104, 12) => $expand!(104, 12),
            (105, 4) => $expand!(105, 4),
            (105, 8) => $expand!(105, 8),
            (105, 12) => $expand!(105, 12),
            (106, 4) => $expand!(106, 4),
            (106, 8) => $expand!(106, 8),
            (106, 12) => $expand!(106, 12),
            (107, 4) => $expand!(107, 4),
            (107, 8) => $expand!(107, 8),
            (107, 12) => $expand!(107, 12),
            (108, 4) => $expand!(108, 4),
            (108, 8) => $expand!(108, 8),
            (108, 12) => $expand!(108, 12),
            (109, 4) => $expand!(109, 4),
            (109, 8) => $expand!(109, 8),
            (109, 12) => $expand!(109, 12),
            (110, 4) => $expand!(110, 4),
            (110, 8) => $expand!(110, 8),
            (110, 12) => $expand!(110, 12),
            (111, 4) => $expand!(111, 4),
            (111, 8) => $expand!(111, 8),
            (111, 12) => $expand!(111, 12),
            (112, 4) => $expand!(112, 4),
            (112, 8) => $expand!(112, 8),
            (112, 12) => $expand!(112, 12),
            (113, 4) => $expand!(113, 4),
            (113, 8) => $expand!(113, 8),
            (113, 12) => $expand!(113, 12),
            (114, 4) => $expand!(114, 4),
            (114, 8) => $expand!(114, 8),
            (114, 12) => $expand!(114, 12),
            (115, 4) => $expand!(115, 4),
            (115, 8) => $expand!(115, 8),
            (115, 12) => $expand!(115, 12),
            (116, 4) => $expand!(116, 4),
            (116, 8) => $expand!(116, 8),
            (116, 12) => $expand!(116, 12),
            (117, 4) => $expand!(117, 4),
            (117, 8) => $expand!(117, 8),
            (117, 12) => $expand!(117, 12),
            (118, 4) => $expand!(118, 4),
            (118, 8) => $expand!(118, 8),
            (118, 12) => $expand!(118, 12),
            (119, 4) => $expand!(119, 4),
            (119, 8) => $expand!(119, 8),
            (119, 12) => $expand!(119, 12),
            (120, 4) => $expand!(120, 4),
            (120, 8) => $expand!(120, 8),
            (120, 12) => $expand!(120, 12),
            (121, 4) => $expand!(121, 4),
            (121, 8) => $expand!(121, 8),
            (121, 12) => $expand!(121, 12),
            (122, 4) => $expand!(122, 4),
            (122, 8) => $expand!(122, 8),
            (122, 12) => $expand!(122, 12),
            (123, 4) => $expand!(123, 4),
            (123, 8) => $expand!(123, 8),
            (123, 12) => $expand!(123, 12),
            (124, 4) => $expand!(124, 4),
            (124, 8) => $expand!(124, 8),
            (124, 12) => $expand!(124, 12),
            (125, 4) => $expand!(125, 4),
            (125, 8) => $expand!(125, 8),
            (125, 12) => $expand!(125, 12),
            (126, 4) => $expand!(126, 4),
            (126, 8) => $expand!(126, 8),
            (126, 12) => $expand!(126, 12),
            (127, 4) => $expand!(127, 4),
            (127, 8) => $expand!(127, 8),
            (127, 12) => $expand!(127, 12),
            (128, 4) => $expand!(128, 4),
            (128, 8) => $expand!(128, 8),
            (128, 12) => $expand!(128, 12),
            (129, 4) => $expand!(129, 4),
            (129, 8) => $expand!(129, 8),
            (129, 12) => $expand!(129, 12),
            (130, 4) => $expand!(130, 4),
            (130, 8) => $expand!(130, 8),
            (130, 12) => $expand!(130, 12),
            (131, 4) => $expand!(131, 4),
            (131, 8) => $expand!(131, 8),
            (131, 12) => $expand!(131, 12),
            (132, 4) => $expand!(132, 4),
            (132, 8) => $expand!(132, 8),
            (132, 12) => $expand!(132, 12),
            (133, 4) => $expand!(133, 4),
            (133, 8) => $expand!(133, 8),
            (133, 12) => $expand!(133, 12),
            (134, 4) => $expand!(134, 4),
            (134, 8) => $expand!(134, 8),
            (134, 12) => $expand!(134, 12),
            (135, 4) => $expand!(135, 4),
            (135, 8) => $expand!(135, 8),
            (135, 12) => $expand!(135, 12),
            (136, 4) => $expand!(136, 4),
            (136, 8) => $expand!(136, 8),
            (136, 12) => $expand!(136, 12),
            (137, 4) => $expand!(137, 4),
            (137, 8) => $expand!(137, 8),
            (137, 12) => $expand!(137, 12),
            (138, 4) => $expand!(138, 4),
            (138, 8) => $expand!(138, 8),
            (138, 12) => $expand!(138, 12),
            (139, 4) => $expand!(139, 4),
            (139, 8) => $expand!(139, 8),
            (139, 12) => $expand!(139, 12),
            (140, 4) => $expand!(140, 4),
            (140, 8) => $expand!(140, 8),
            (140, 12) => $expand!(140, 12),
            (141, 4) => $expand!(141, 4),
            (141, 8) => $expand!(141, 8),
            (141, 12) => $expand!(141, 12),
            (142, 4) => $expand!(142, 4),
            (142, 8) => $expand!(142, 8),
            (142, 12) => $expand!(142, 12),
            (143, 4) => $expand!(143, 4),
            (143, 8) => $expand!(143, 8),
            (143, 12) => $expand!(143, 12),
            (144, 4) => $expand!(144, 4),
            (144, 8) => $expand!(144, 8),
            (144, 12) => $expand!(144, 12),
            (145, 4) => $expand!(145, 4),
            (145, 8) => $expand!(145, 8),
            (145, 12) => $expand!(145, 12),
            (146, 4) => $expand!(146, 4),
            (146, 8) => $expand!(146, 8),
            (146, 12) => $expand!(146, 12),
            (147, 4) => $expand!(147, 4),
            (147, 8) => $expand!(147, 8),
            (147, 12) => $expand!(147, 12),
            (148, 4) => $expand!(148, 4),
            (148, 8) => $expand!(148, 8),
            (148, 12) => $expand!(148, 12),
            (149, 4) => $expand!(149, 4),
            (149, 8) => $expand!(149, 8),
            (149, 12) => $expand!(149, 12),
            (150, 4) => $expand!(150, 4),
            (150, 8) => $expand!(150, 8),
            (150, 12) => $expand!(150, 12),
            (151, 4) => $expand!(151, 4),
            (151, 8) => $expand!(151, 8),
            (151, 12) => $expand!(151, 12),
            (152, 4) => $expand!(152, 4),
            (152, 8) => $expand!(152, 8),
            (152, 12) => $expand!(152, 12),
            (153, 4) => $expand!(153, 4),
            (153, 8) => $expand!(153, 8),
            (153, 12) => $expand!(153, 12),
            (154, 4) => $expand!(154, 4),
            (154, 8) => $expand!(154, 8),
            (154, 12) => $expand!(154, 12),
            (155, 4) => $expand!(155, 4),
            (155, 8) => $expand!(155, 8),
            (155, 12) => $expand!(155, 12),
            (156, 4) => $expand!(156, 4),
            (156, 8) => $expand!(156, 8),
            (156, 12) => $expand!(156, 12),
            (157, 4) => $expand!(157, 4),
            (157, 8) => $expand!(157, 8),
            (157, 12) => $expand!(157, 12),
            (158, 4) => $expand!(158, 4),
            (158, 8) => $expand!(158, 8),
            (158, 12) => $expand!(158, 12),
            (159, 4) => $expand!(159, 4),
            (159, 8) => $expand!(159, 8),
            (159, 12) => $expand!(159, 12),
            (160, 4) => $expand!(160, 4),
            (160, 8) => $expand!(160, 8),
            (160, 12) => $expand!(160, 12),
            (161, 4) => $expand!(161, 4),
            (161, 8) => $expand!(161, 8),
            (161, 12) => $expand!(161, 12),
            (162, 4) => $expand!(162, 4),
            (162, 8) => $expand!(162, 8),
            (162, 12) => $expand!(162, 12),
            (163, 4) => $expand!(163, 4),
            (163, 8) => $expand!(163, 8),
            (163, 12) => $expand!(163, 12),
            (164, 4) => $expand!(164, 4),
            (164, 8) => $expand!(164, 8),
            (164, 12) => $expand!(164, 12),
            (165, 4) => $expand!(165, 4),
            (165, 8) => $expand!(165, 8),
            (165, 12) => $expand!(165, 12),
            (166, 4) => $expand!(166, 4),
            (166, 8) => $expand!(166, 8),
            (166, 12) => $expand!(166, 12),
            (167, 4) => $expand!(167, 4),
            (167, 8) => $expand!(167, 8),
            (167, 12) => $expand!(167, 12),
            (168, 4) => $expand!(168, 4),
            (168, 8) => $expand!(168, 8),
            (168, 12) => $expand!(168, 12),
            (169, 4) => $expand!(169, 4),
            (169, 8) => $expand!(169, 8),
            (169, 12) => $expand!(169, 12),
            (170, 4) => $expand!(170, 4),
            (170, 8) => $expand!(170, 8),
            (170, 12) => $expand!(170, 12),
            (171, 4) => $expand!(171, 4),
            (171, 8) => $expand!(171, 8),
            (171, 12) => $expand!(171, 12),
            (172, 4) => $expand!(172, 4),
            (172, 8) => $expand!(172, 8),
            (172, 12) => $expand!(172, 12),
            (173, 4) => $expand!(173, 4),
            (173, 8) => $expand!(173, 8),
            (173, 12) => $expand!(173, 12),
            (174, 4) => $expand!(174, 4),
            (174, 8) => $expand!(174, 8),
            (174, 12) => $expand!(174, 12),
            (175, 4) => $expand!(175, 4),
            (175, 8) => $expand!(175, 8),
            (175, 12) => $expand!(175, 12),
            (176, 4) => $expand!(176, 4),
            (176, 8) => $expand!(176, 8),
            (176, 12) => $expand!(176, 12),
            (177, 4) => $expand!(177, 4),
            (177, 8) => $expand!(177, 8),
            (177, 12) => $expand!(177, 12),
            (178, 4) => $expand!(178, 4),
            (178, 8) => $expand!(178, 8),
            (178, 12) => $expand!(178, 12),
            (179, 4) => $expand!(179, 4),
            (179, 8) => $expand!(179, 8),
            (179, 12) => $expand!(179, 12),
            (180, 4) => $expand!(180, 4),
            (180, 8) => $expand!(180, 8),
            (180, 12) => $expand!(180, 12),
            (181, 4) => $expand!(181, 4),
            (181, 8) => $expand!(181, 8),
            (181, 12) => $expand!(181, 12),
            (182, 4) => $expand!(182, 4),
            (182, 8) => $expand!(182, 8),
            (182, 12) => $expand!(182, 12),
            (183, 4) => $expand!(183, 4),
            (183, 8) => $expand!(183, 8),
            (183, 12) => $expand!(183, 12),
            (184, 4) => $expand!(184, 4),
            (184, 8) => $expand!(184, 8),
            (184, 12) => $expand!(184, 12),
            (185, 4) => $expand!(185, 4),
            (185, 8) => $expand!(185, 8),
            (185, 12) => $expand!(185, 12),
            (186, 4) => $expand!(186, 4),
            (186, 8) => $expand!(186, 8),
            (186, 12) => $expand!(186, 12),
            (187, 4) => $expand!(187, 4),
            (187, 8) => $expand!(187, 8),
            (187, 12) => $expand!(187, 12),
            (188, 4) => $expand!(188, 4),
            (188, 8) => $expand!(188, 8),
            (188, 12) => $expand!(188, 12),
            (189, 4) => $expand!(189, 4),
            (189, 8) => $expand!(189, 8),
            (189, 12) => $expand!(189, 12),
            (190, 4) => $expand!(190, 4),
            (190, 8) => $expand!(190, 8),
            (190, 12) => $expand!(190, 12),
            (191, 4) => $expand!(191, 4),
            (191, 8) => $expand!(191, 8),
            (191, 12) => $expand!(191, 12),
            (192, 4) => $expand!(192, 4),
            (192, 8) => $expand!(192, 8),
            (192, 12) => $expand!(192, 12),
            (193, 4) => $expand!(193, 4),
            (193, 8) => $expand!(193, 8),
            (193, 12) => $expand!(193, 12),
            (194, 4) => $expand!(194, 4),
            (194, 8) => $expand!(194, 8),
            (194, 12) => $expand!(194, 12),
            (195, 4) => $expand!(195, 4),
            (195, 8) => $expand!(195, 8),
            (195, 12) => $expand!(195, 12),
            (196, 4) => $expand!(196, 4),
            (196, 8) => $expand!(196, 8),
            (196, 12) => $expand!(196, 12),
            (197, 4) => $expand!(197, 4),
            (197, 8) => $expand!(197, 8),
            (197, 12) => $expand!(197, 12),
            (198, 4) => $expand!(198, 4),
            (198, 8) => $expand!(198, 8),
            (198, 12) => $expand!(198, 12),
            (199, 4) => $expand!(199, 4),
            (199, 8) => $expand!(199, 8),
            (199, 12) => $expand!(199, 12),
            (200, 4) => $expand!(200, 4),
            (200, 8) => $expand!(200, 8),
            (200, 12) => $expand!(200, 12),
            (201, 4) => $expand!(201, 4),
            (201, 8) => $expand!(201, 8),
            (201, 12) => $expand!(201, 12),
            (202, 4) => $expand!(202, 4),
            (202, 8) => $expand!(202, 8),
            (202, 12) => $expand!(202, 12),
            (203, 4) => $expand!(203, 4),
            (203, 8) => $expand!(203, 8),
            (203, 12) => $expand!(203, 12),
            (204, 4) => $expand!(204, 4),
            (204, 8) => $expand!(204, 8),
            (204, 12) => $expand!(204, 12),
            (205, 4) => $expand!(205, 4),
            (205, 8) => $expand!(205, 8),
            (205, 12) => $expand!(205, 12),
            (206, 4) => $expand!(206, 4),
            (206, 8) => $expand!(206, 8),
            (206, 12) => $expand!(206, 12),
            (207, 4) => $expand!(207, 4),
            (207, 8) => $expand!(207, 8),
            (207, 12) => $expand!(207, 12),
            (208, 4) => $expand!(208, 4),
            (208, 8) => $expand!(208, 8),
            (208, 12) => $expand!(208, 12),
            (209, 4) => $expand!(209, 4),
            (209, 8) => $expand!(209, 8),
            (209, 12) => $expand!(209, 12),
            (210, 4) => $expand!(210, 4),
            (210, 8) => $expand!(210, 8),
            (210, 12) => $expand!(210, 12),
            (211, 4) => $expand!(211, 4),
            (211, 8) => $expand!(211, 8),
            (211, 12) => $expand!(211, 12),
            (212, 4) => $expand!(212, 4),
            (212, 8) => $expand!(212, 8),
            (212, 12) => $expand!(212, 12),
            (213, 4) => $expand!(213, 4),
            (213, 8) => $expand!(213, 8),
            (213, 12) => $expand!(213, 12),
            (214, 4) => $expand!(214, 4),
            (214, 8) => $expand!(214, 8),
            (214, 12) => $expand!(214, 12),
            (215, 4) => $expand!(215, 4),
            (215, 8) => $expand!(215, 8),
            (215, 12) => $expand!(215, 12),
            (216, 4) => $expand!(216, 4),
            (216, 8) => $expand!(216, 8),
            (216, 12) => $expand!(216, 12),
            (217, 4) => $expand!(217, 4),
            (217, 8) => $expand!(217, 8),
            (217, 12) => $expand!(217, 12),
            (218, 4) => $expand!(218, 4),
            (218, 8) => $expand!(218, 8),
            (218, 12) => $expand!(218, 12),
            (219, 4) => $expand!(219, 4),
            (219, 8) => $expand!(219, 8),
            (219, 12) => $expand!(219, 12),
            (220, 4) => $expand!(220, 4),
            (220, 8) => $expand!(220, 8),
            (220, 12) => $expand!(220, 12),
            (221, 4) => $expand!(221, 4),
            (221, 8) => $expand!(221, 8),
            (221, 12) => $expand!(221, 12),
            (222, 4) => $expand!(222, 4),
            (222, 8) => $expand!(222, 8),
            (222, 12) => $expand!(222, 12),
            (223, 4) => $expand!(223, 4),
            (223, 8) => $expand!(223, 8),
            (223, 12) => $expand!(223, 12),
            (224, 4) => $expand!(224, 4),
            (224, 8) => $expand!(224, 8),
            (224, 12) => $expand!(224, 12),
            (225, 4) => $expand!(225, 4),
            (225, 8) => $expand!(225, 8),
            (225, 12) => $expand!(225, 12),
            (226, 4) => $expand!(226, 4),
            (226, 8) => $expand!(226, 8),
            (226, 12) => $expand!(226, 12),
            (227, 4) => $expand!(227, 4),
            (227, 8) => $expand!(227, 8),
            (227, 12) => $expand!(227, 12),
            (228, 4) => $expand!(228, 4),
            (228, 8) => $expand!(228, 8),
            (228, 12) => $expand!(228, 12),
            (229, 4) => $expand!(229, 4),
            (229, 8) => $expand!(229, 8),
            (229, 12) => $expand!(229, 12),
            (230, 4) => $expand!(230, 4),
            (230, 8) => $expand!(230, 8),
            (230, 12) => $expand!(230, 12),
            (231, 4) => $expand!(231, 4),
            (231, 8) => $expand!(231, 8),
            (231, 12) => $expand!(231, 12),
            (232, 4) => $expand!(232, 4),
            (232, 8) => $expand!(232, 8),
            (232, 12) => $expand!(232, 12),
            (233, 4) => $expand!(233, 4),
            (233, 8) => $expand!(233, 8),
            (233, 12) => $expand!(233, 12),
            (234, 4) => $expand!(234, 4),
            (234, 8) => $expand!(234, 8),
            (234, 12) => $expand!(234, 12),
            (235, 4) => $expand!(235, 4),
            (235, 8) => $expand!(235, 8),
            (235, 12) => $expand!(235, 12),
            (236, 4) => $expand!(236, 4),
            (236, 8) => $expand!(236, 8),
            (236, 12) => $expand!(236, 12),
            (237, 4) => $expand!(237, 4),
            (237, 8) => $expand!(237, 8),
            (237, 12) => $expand!(237, 12),
            (238, 4) => $expand!(238, 4),
            (238, 8) => $expand!(238, 8),
            (238, 12) => $expand!(238, 12),
            (239, 4) => $expand!(239, 4),
            (239, 8) => $expand!(239, 8),
            (239, 12) => $expand!(239, 12),
            (240, 4) => $expand!(240, 4),
            (240, 8) => $expand!(240, 8),
            (240, 12) => $expand!(240, 12),
            (241, 4) => $expand!(241, 4),
            (241, 8) => $expand!(241, 8),
            (241, 12) => $expand!(241, 12),
            (242, 4) => $expand!(242, 4),
            (242, 8) => $expand!(242, 8),
            (242, 12) => $expand!(242, 12),
            (243, 4) => $expand!(243, 4),
            (243, 8) => $expand!(243, 8),
            (243, 12) => $expand!(243, 12),
            (244, 4) => $expand!(244, 4),
            (244, 8) => $expand!(244, 8),
            (244, 12) => $expand!(244, 12),
            (245, 4) => $expand!(245, 4),
            (245, 8) => $expand!(245, 8),
            (245, 12) => $expand!(245, 12),
            (246, 4) => $expand!(246, 4),
            (246, 8) => $expand!(246, 8),
            (246, 12) => $expand!(246, 12),
            (247, 4) => $expand!(247, 4),
            (247, 8) => $expand!(247, 8),
            (247, 12) => $expand!(247, 12),
            (248, 4) => $expand!(248, 4),
            (248, 8) => $expand!(248, 8),
            (248, 12) => $expand!(248, 12),
            (249, 4) => $expand!(249, 4),
            (249, 8) => $expand!(249, 8),
            (249, 12) => $expand!(249, 12),
            (250, 4) => $expand!(250, 4),
            (250, 8) => $expand!(250, 8),
            (250, 12) => $expand!(250, 12),
            (251, 4) => $expand!(251, 4),
            (251, 8) => $expand!(251, 8),
            (251, 12) => $expand!(251, 12),
            (252, 4) => $expand!(252, 4),
            (252, 8) => $expand!(252, 8),
            (252, 12) => $expand!(252, 12),
            (253, 4) => $expand!(253, 4),
            (253, 8) => $expand!(253, 8),
            (253, 12) => $expand!(253, 12),
            (254, 4) => $expand!(254, 4),
            (254, 8) => $expand!(254, 8),
            (254, 12) => $expand!(254, 12),
            (255, 4) => $expand!(255, 4),
            (255, 8) => $expand!(255, 8),
            (255, 12) => $expand!(255, 12),
            (_, _) => panic!("Invalid sae value"),
        }
    };
}

#[cfg(test)]
macro_rules! assert_approx_eq {
    ($a:expr, $b:expr, $eps:expr) => {{
        let (a, b) = (&$a, &$b);
        assert!(
            (*a - *b).abs() < $eps,
            "assertion failed: `(left !== right)` \
             (left: `{:?}`, right: `{:?}`, expect diff: `{:?}`, real diff: `{:?}`)",
            *a,
            *b,
            $eps,
            (*a - *b).abs()
        );
    }};
}
