/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences.display;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.preferences.DefaultTabPreferenceSetting;
import org.openstreetmap.josm.gui.preferences.PreferenceSetting;
import org.openstreetmap.josm.gui.preferences.PreferenceSettingFactory;
import org.openstreetmap.josm.gui.preferences.PreferenceTabbedPane;
import org.openstreetmap.josm.gui.widgets.JosmComboBox;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.LanguageInfo;

public class LanguagePreference
extends DefaultTabPreferenceSetting {
    private static final String LANGUAGE = "language";
    private JosmComboBox<Locale> langCombo;

    LanguagePreference() {
        super(LANGUAGE, I18n.tr("Language", new Object[0]), I18n.tr("Change the language of JOSM.", new Object[0]));
    }

    @Override
    public void addGui(PreferenceTabbedPane gui) {
        LanguageComboBoxModel model = new LanguageComboBoxModel();
        model.selectLanguage(Config.getPref().get(LANGUAGE));
        this.langCombo = new JosmComboBox<Locale>(model);
        this.langCombo.setRenderer(new LanguageCellRenderer());
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel(I18n.tr("Language", new Object[0])), GBC.std().insets(20, 0, 0, 0));
        panel.add(GBC.glue(5, 0), GBC.std().fill(2));
        panel.add(this.langCombo, GBC.eol().fill(2));
        panel.add(Box.createVerticalGlue(), GBC.eol().fill(1));
        this.createPreferenceTabWithScrollPane(gui, panel);
    }

    @Override
    public boolean ok() {
        if (this.langCombo.getSelectedItem() == null) {
            return Config.getPref().put(LANGUAGE, null);
        }
        return Config.getPref().put(LANGUAGE, LanguageInfo.getJOSMLocaleCode((Locale)this.langCombo.getSelectedItem()));
    }

    @Override
    public boolean isExpert() {
        return false;
    }

    @Override
    public String getHelpContext() {
        return HelpUtil.ht("/Preferences/LanguagePreference");
    }

    private static class LanguageCellRenderer
    implements ListCellRenderer<Locale> {
        private final DefaultListCellRenderer dispatch = new DefaultListCellRenderer();

        LanguageCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends Locale> list, Locale l, int index, boolean isSelected, boolean cellHasFocus) {
            return this.dispatch.getListCellRendererComponent(list, l == null ? I18n.tr("Default (Auto determined)", new Object[0]) : LanguageInfo.getDisplayName(l), index, isSelected, cellHasFocus);
        }
    }

    private static class LanguageComboBoxModel
    extends DefaultComboBoxModel<Locale> {
        private final List<Locale> data = new ArrayList<Locale>();

        LanguageComboBoxModel() {
            this.data.add(0, null);
            I18n.getAvailableTranslations().sorted(Comparator.comparing(Locale::getDisplayLanguage)).forEachOrdered(this.data::add);
        }

        private void selectLanguage(String language) {
            this.setSelectedItem(null);
            if (language != null) {
                String lang = LanguageInfo.getJavaLocaleCode(language);
                this.data.stream().filter(locale -> locale != null && locale.toString().equals(lang)).findFirst().ifPresent(this::setSelectedItem);
            }
        }

        @Override
        public Locale getElementAt(int index) {
            return this.data.get(index);
        }

        @Override
        public int getSize() {
            return this.data.size();
        }
    }

    public static class Factory
    implements PreferenceSettingFactory {
        @Override
        public PreferenceSetting createPreferenceSetting() {
            return new LanguagePreference();
        }
    }
}

