/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Expression;
import org.hsqldb.ExpressionColumn;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.ParserDQL;
import org.hsqldb.QuerySpecification;
import org.hsqldb.RangeGroup;
import org.hsqldb.RangeVariable;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.index.Index;
import org.hsqldb.lib.HashMap;
import org.hsqldb.lib.HashSet;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.map.ValuePool;

public class RangeVariableJoined
extends RangeVariable {
    RangeVariable[] rangeArray;

    public RangeVariableJoined(Table table, HsqlNameManager.SimpleName simpleName, OrderedHashSet orderedHashSet, HsqlNameManager.SimpleName[] simpleNameArray, ParserDQL.CompileContext compileContext) {
        super(table, simpleName, orderedHashSet, simpleNameArray, compileContext);
        this.setParameters();
    }

    private void setParameters() {
        this.namedJoinColumnExpressions = new HashMap();
        QuerySpecification querySpecification = (QuerySpecification)this.rangeTable.getQueryExpression();
        this.rangeArray = querySpecification.rangeVariables;
        for (int i = 0; i < this.rangeArray.length; ++i) {
            if (this.rangeArray[i].isLeftJoin) {
                this.hasLeftJoin = true;
            }
            if (this.rangeArray[i].isRightJoin) {
                this.hasRightJoin = true;
            }
            if (this.rangeArray[i].isLateral) {
                this.hasLateral = true;
            }
            if (this.rangeArray[i].namedJoinColumnExpressions == null) continue;
            this.namedJoinColumnExpressions.putAll(this.rangeArray[i].namedJoinColumnExpressions);
        }
    }

    public RangeVariable[] getBaseRangeVariables() {
        return this.rangeArray;
    }

    @Override
    public void setRangeTableVariables() {
        super.setRangeTableVariables();
    }

    @Override
    public void setJoinType(boolean bl, boolean bl2) {
        super.setJoinType(bl, bl2);
    }

    @Override
    public void addNamedJoinColumns(OrderedHashSet orderedHashSet) {
        super.addNamedJoinColumns(orderedHashSet);
    }

    @Override
    public void addColumn(int n) {
        super.addColumn(n);
    }

    @Override
    public void addAllColumns() {
        super.addAllColumns();
    }

    @Override
    public void addNamedJoinColumnExpression(String string, Expression expression, int n) {
        super.addNamedJoinColumnExpression(string, expression, n);
    }

    @Override
    public ExpressionColumn getColumnExpression(String string) {
        return null;
    }

    @Override
    public Table getTable() {
        return super.getTable();
    }

    @Override
    public boolean hasSingleIndexCondition() {
        return super.hasSingleIndexCondition();
    }

    @Override
    public boolean setDistinctColumnsOnIndex(int[] nArray) {
        return super.setDistinctColumnsOnIndex(nArray);
    }

    @Override
    public Index getSortIndex() {
        return super.getSortIndex();
    }

    @Override
    public boolean setSortIndex(Index index, boolean bl) {
        return super.setSortIndex(index, bl);
    }

    @Override
    public boolean reverseOrder() {
        return super.reverseOrder();
    }

    @Override
    public OrderedHashSet getColumnNames() {
        return super.getColumnNames();
    }

    @Override
    public OrderedHashSet getUniqueColumnNameSet() {
        return super.getUniqueColumnNameSet();
    }

    @Override
    public int findColumn(String string, String string2, String string3) {
        if (this.tableAlias != null) {
            return super.findColumn(string, string2, string3);
        }
        int n = 0;
        int n2 = -1;
        if (string2 == null && this.namedJoinColumnExpressions.containsKey(string3)) {
            return super.findColumn(null, null, string3);
        }
        for (int i = 0; i < this.rangeArray.length; ++i) {
            RangeVariable rangeVariable = this.rangeArray[i];
            n2 = rangeVariable.findColumn(string, string2, string3);
            if (rangeVariable.namedJoinColumnCheck == null) {
                n = n2 > -1 ? (n += n2) : (n += rangeVariable.rangeTable.getColumnCount());
            } else {
                int n3 = n2 > -1 ? n2 : rangeVariable.namedJoinColumnCheck.length;
                for (int j = 0; j < n3; ++j) {
                    if (rangeVariable.namedJoinColumnCheck[j]) continue;
                    ++n;
                }
            }
            if (n2 > -1) break;
        }
        if (n2 > -1) {
            if (this.namedJoinColumnExpressions != null) {
                n += this.namedJoinColumnExpressions.size();
            }
            return n;
        }
        return -1;
    }

    @Override
    public HsqlNameManager.SimpleName getColumnAlias(int n) {
        return super.getColumnAlias(n);
    }

    @Override
    public boolean hasColumnAlias() {
        return super.hasColumnAlias();
    }

    @Override
    public HsqlNameManager.SimpleName getTableAlias() {
        return super.getTableAlias();
    }

    @Override
    public RangeVariable getRangeForTableName(String string) {
        if (this.tableAlias != null) {
            return super.getRangeForTableName(string);
        }
        for (int i = 0; i < this.rangeArray.length; ++i) {
            RangeVariable rangeVariable = this.rangeArray[i].getRangeForTableName(string);
            if (rangeVariable == null) continue;
            return rangeVariable;
        }
        return null;
    }

    @Override
    public void addTableColumns(HsqlArrayList hsqlArrayList) {
        super.addTableColumns(hsqlArrayList);
    }

    @Override
    public int addTableColumns(HsqlArrayList hsqlArrayList, int n, HashSet hashSet) {
        return super.addTableColumns(hsqlArrayList, n, hashSet);
    }

    @Override
    public void addTableColumns(RangeVariable rangeVariable, Expression expression, HashSet hashSet) {
        int n = this.getFirstColumnIndex(rangeVariable);
        this.addTableColumns(expression, n, rangeVariable.rangeTable.getColumnCount(), hashSet);
    }

    @Override
    protected int getFirstColumnIndex(RangeVariable rangeVariable) {
        if (rangeVariable == this) {
            return 0;
        }
        int n = 0;
        for (int i = 0; i < this.rangeArray.length; ++i) {
            int n2 = this.rangeArray[i].getFirstColumnIndex(rangeVariable);
            if (n2 == -1) {
                n += this.rangeArray[i].rangeTable.getColumnCount();
                continue;
            }
            return n + n2;
        }
        return -1;
    }

    @Override
    public void setForCheckConstraint() {
        super.setForCheckConstraint();
    }

    @Override
    public Expression getJoinCondition() {
        return super.getJoinCondition();
    }

    @Override
    public void addJoinCondition(Expression expression) {
        super.addJoinCondition(expression);
    }

    @Override
    public void resetConditions() {
        super.resetConditions();
    }

    public void replaceColumnReference(RangeVariable rangeVariable, Expression[] expressionArray) {
    }

    @Override
    public void replaceRangeVariables(RangeVariable[] rangeVariableArray, RangeVariable[] rangeVariableArray2) {
        super.replaceRangeVariables(rangeVariableArray, rangeVariableArray2);
    }

    @Override
    public void resolveRangeTable(Session session, RangeGroup rangeGroup, RangeGroup[] rangeGroupArray) {
        super.resolveRangeTable(session, rangeGroup, rangeGroupArray);
    }

    @Override
    public String describe(Session session, int n) {
        RangeVariable.RangeVariableConditions[] rangeVariableConditionsArray = this.joinConditions;
        String string = ValuePool.spaceString.substring(0, n);
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = "INNER";
        if (this.isLeftJoin) {
            string2 = "LEFT OUTER";
            if (this.isRightJoin) {
                string2 = "FULL";
            }
        } else if (this.isRightJoin) {
            string2 = "RIGHT OUTER";
        }
        stringBuffer.append(string).append("join type=").append(string2).append("\n");
        stringBuffer.append(string).append("table=").append(this.rangeTable.getName().name).append("\n");
        if (this.tableAlias != null) {
            stringBuffer.append(string).append("alias=").append(this.tableAlias.name).append("\n");
        }
        boolean bl = !rangeVariableConditionsArray[0].hasIndexCondition();
        stringBuffer.append(string).append("access=").append(bl ? "FULL SCAN" : "INDEX PRED").append("\n");
        for (int i = 0; i < rangeVariableConditionsArray.length; ++i) {
            RangeVariable.RangeVariableConditions rangeVariableConditions = this.joinConditions[i];
            if (i > 0) {
                stringBuffer.append(string).append("OR condition = [");
            } else {
                stringBuffer.append(string).append("condition = [");
            }
            stringBuffer.append(rangeVariableConditions.describe(session, n + 2));
            stringBuffer.append(string).append("]\n");
        }
        return stringBuffer.toString();
    }

    @Override
    public RangeVariable.RangeIteratorMain getIterator(Session session) {
        return super.getIterator(session);
    }
}

