/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.server.system;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import javax.management.openmbean.CompositeData;

public class ThreadDump {
    private static final String[][] methods = new String[][]{{"sun.management.ThreadInfoCompositeData", "toCompositeData"}, {"com.ibm.lang.management.ManagementUtils", "toThreadInfoCompositeData"}};
    private static Method toCompositeDataMethod;
    private static ThreadMXBean threadBean;
    private static boolean runningOnJdk15;

    public static void initialize(boolean bl) {
        runningOnJdk15 = bl;
        threadBean = ManagementFactory.getThreadMXBean();
        for (String[] stringArray : methods) {
            String string = stringArray[0];
            String string2 = stringArray[1];
            try {
                Class<?> clazz = Class.forName(string);
                toCompositeDataMethod = clazz.getMethod(string2, ThreadInfo.class);
                if (toCompositeDataMethod == null) continue;
                break;
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
    }

    public static Object[] takeThreadDump() {
        ThreadInfo[] threadInfoArray = runningOnJdk15 ? ThreadDump.takeThreadDump15() : ThreadDump.takeThreadDump16();
        ArrayList<CompositeData> arrayList = new ArrayList<CompositeData>(threadInfoArray.length);
        for (int i = 0; i < threadInfoArray.length; ++i) {
            ThreadInfo threadInfo = threadInfoArray[i];
            if (threadInfo == null) continue;
            arrayList.add(ThreadDump.toCompositeData(threadInfo));
        }
        return arrayList.toArray(new CompositeData[0]);
    }

    public static boolean isJDK15() {
        return runningOnJdk15;
    }

    private static CompositeData toCompositeData(ThreadInfo threadInfo) {
        try {
            return (CompositeData)toCompositeDataMethod.invoke(null, threadInfo);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new RuntimeException(illegalArgumentException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new RuntimeException(invocationTargetException);
        }
    }

    private static ThreadInfo[] takeThreadDump15() {
        long[] lArray = threadBean.getAllThreadIds();
        return threadBean.getThreadInfo(lArray, Integer.MAX_VALUE);
    }

    private static ThreadInfo[] takeThreadDump16() {
        return threadBean.dumpAllThreads(true, true);
    }
}

