/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.deploy;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.naming.NamingException;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleState;
import org.apache.catalina.Server;
import org.apache.catalina.deploy.ContextEjb;
import org.apache.catalina.deploy.ContextEnvironment;
import org.apache.catalina.deploy.ContextLocalEjb;
import org.apache.catalina.deploy.ContextResource;
import org.apache.catalina.deploy.ContextResourceEnvRef;
import org.apache.catalina.deploy.ContextResourceLink;
import org.apache.catalina.deploy.ContextService;
import org.apache.catalina.deploy.ContextTransaction;
import org.apache.catalina.deploy.InjectionTarget;
import org.apache.catalina.deploy.MessageDestinationRef;
import org.apache.catalina.deploy.ResourceBase;
import org.apache.catalina.mbeans.MBeanUtils;
import org.apache.catalina.util.Introspection;
import org.apache.catalina.util.LifecycleMBeanBase;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.naming.ContextBindings;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.res.StringManager;

public class NamingResources
extends LifecycleMBeanBase
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(NamingResources.class);
    private static final StringManager sm = StringManager.getManager((String)"org.apache.catalina.deploy");
    private volatile boolean resourceRequireExplicitRegistration = false;
    private Object container = null;
    private Set<String> entries = new HashSet<String>();
    private HashMap<String, ContextEjb> ejbs = new HashMap();
    private HashMap<String, ContextEnvironment> envs = new HashMap();
    private HashMap<String, ContextLocalEjb> localEjbs = new HashMap();
    private HashMap<String, MessageDestinationRef> mdrs = new HashMap();
    private HashMap<String, ContextResourceEnvRef> resourceEnvRefs = new HashMap();
    private HashMap<String, ContextResource> resources = new HashMap();
    private HashMap<String, ContextResourceLink> resourceLinks = new HashMap();
    private HashMap<String, ContextService> services = new HashMap();
    private ContextTransaction transaction = null;
    protected PropertyChangeSupport support = new PropertyChangeSupport(this);

    public Object getContainer() {
        return this.container;
    }

    public void setContainer(Object object) {
        this.container = object;
    }

    public void setTransaction(ContextTransaction contextTransaction) {
        this.transaction = contextTransaction;
    }

    public ContextTransaction getTransaction() {
        return this.transaction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEjb(ContextEjb contextEjb) {
        String string = contextEjb.getLink();
        String string2 = contextEjb.getLookupName();
        if (string != null && string.length() > 0 && string2 != null && string2.length() > 0) {
            throw new IllegalArgumentException(sm.getString("namingResources.ejbLookupLink", new Object[]{contextEjb.getName()}));
        }
        if (this.entries.contains(contextEjb.getName())) {
            return;
        }
        this.entries.add(contextEjb.getName());
        HashMap<String, ContextEjb> hashMap = this.ejbs;
        synchronized (hashMap) {
            contextEjb.setNamingResources(this);
            this.ejbs.put(contextEjb.getName(), contextEjb);
        }
        this.support.firePropertyChange("ejb", null, contextEjb);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addEnvironment(ContextEnvironment contextEnvironment) {
        Object object;
        Object object2;
        Object object3;
        if (this.entries.contains(contextEnvironment.getName())) {
            object3 = this.findEnvironment(contextEnvironment.getName());
            object2 = this.findResourceLink(contextEnvironment.getName());
            if (object3 != null) {
                if (!((ContextEnvironment)object3).getOverride()) return;
                this.removeEnvironment(contextEnvironment.getName());
            } else {
                if (object2 == null) return;
                object = this.getServer().getGlobalNamingResources();
                if (((NamingResources)object).findEnvironment(((ContextResourceLink)object2).getGlobal()) != null) {
                    if (!((NamingResources)object).findEnvironment(((ContextResourceLink)object2).getGlobal()).getOverride()) return;
                    this.removeResourceLink(contextEnvironment.getName());
                }
            }
        }
        object3 = contextEnvironment.getInjectionTargets();
        object2 = contextEnvironment.getValue();
        object = contextEnvironment.getLookupName();
        if (object3 != null && object3.size() > 0 && (object2 == null || ((String)object2).length() == 0)) {
            return;
        }
        if (object2 != null && ((String)object2).length() > 0 && object != null && ((String)object).length() > 0) {
            throw new IllegalArgumentException(sm.getString("namingResources.envEntryLookupValue", new Object[]{contextEnvironment.getName()}));
        }
        if (!this.checkResourceType(contextEnvironment)) {
            throw new IllegalArgumentException(sm.getString("namingResources.resourceTypeFail", new Object[]{contextEnvironment.getName(), contextEnvironment.getType()}));
        }
        this.entries.add(contextEnvironment.getName());
        HashMap<String, ContextEnvironment> hashMap = this.envs;
        synchronized (hashMap) {
            contextEnvironment.setNamingResources(this);
            this.envs.put(contextEnvironment.getName(), contextEnvironment);
        }
        this.support.firePropertyChange("environment", null, contextEnvironment);
        if (!this.resourceRequireExplicitRegistration) return;
        try {
            MBeanUtils.createMBean(contextEnvironment);
            return;
        }
        catch (Exception exception) {
            log.warn((Object)sm.getString("namingResources.mbeanCreateFail", new Object[]{contextEnvironment.getName()}), (Throwable)exception);
        }
    }

    private Server getServer() {
        if (this.container instanceof Server) {
            return (Server)this.container;
        }
        if (this.container instanceof Context) {
            Engine engine = (Engine)((Context)this.container).getParent().getParent();
            return engine.getService().getServer();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLocalEjb(ContextLocalEjb contextLocalEjb) {
        if (this.entries.contains(contextLocalEjb.getName())) {
            return;
        }
        this.entries.add(contextLocalEjb.getName());
        HashMap<String, ContextLocalEjb> hashMap = this.localEjbs;
        synchronized (hashMap) {
            contextLocalEjb.setNamingResources(this);
            this.localEjbs.put(contextLocalEjb.getName(), contextLocalEjb);
        }
        this.support.firePropertyChange("localEjb", null, contextLocalEjb);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMessageDestinationRef(MessageDestinationRef messageDestinationRef) {
        if (this.entries.contains(messageDestinationRef.getName())) {
            return;
        }
        if (!this.checkResourceType(messageDestinationRef)) {
            throw new IllegalArgumentException(sm.getString("namingResources.resourceTypeFail", new Object[]{messageDestinationRef.getName(), messageDestinationRef.getType()}));
        }
        this.entries.add(messageDestinationRef.getName());
        HashMap<String, MessageDestinationRef> hashMap = this.mdrs;
        synchronized (hashMap) {
            messageDestinationRef.setNamingResources(this);
            this.mdrs.put(messageDestinationRef.getName(), messageDestinationRef);
        }
        this.support.firePropertyChange("messageDestinationRef", null, messageDestinationRef);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addResource(ContextResource contextResource) {
        if (this.entries.contains(contextResource.getName())) {
            return;
        }
        if (!this.checkResourceType(contextResource)) {
            throw new IllegalArgumentException(sm.getString("namingResources.resourceTypeFail", new Object[]{contextResource.getName(), contextResource.getType()}));
        }
        this.entries.add(contextResource.getName());
        HashMap<String, ContextResource> hashMap = this.resources;
        synchronized (hashMap) {
            contextResource.setNamingResources(this);
            this.resources.put(contextResource.getName(), contextResource);
        }
        this.support.firePropertyChange("resource", null, contextResource);
        if (this.resourceRequireExplicitRegistration) {
            try {
                MBeanUtils.createMBean(contextResource);
            }
            catch (Exception exception) {
                log.warn((Object)sm.getString("namingResources.mbeanCreateFail", new Object[]{contextResource.getName()}), (Throwable)exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addResourceEnvRef(ContextResourceEnvRef contextResourceEnvRef) {
        if (this.entries.contains(contextResourceEnvRef.getName())) {
            return;
        }
        if (!this.checkResourceType(contextResourceEnvRef)) {
            throw new IllegalArgumentException(sm.getString("namingResources.resourceTypeFail", new Object[]{contextResourceEnvRef.getName(), contextResourceEnvRef.getType()}));
        }
        this.entries.add(contextResourceEnvRef.getName());
        HashMap<String, ContextResourceEnvRef> hashMap = this.resourceEnvRefs;
        synchronized (hashMap) {
            contextResourceEnvRef.setNamingResources(this);
            this.resourceEnvRefs.put(contextResourceEnvRef.getName(), contextResourceEnvRef);
        }
        this.support.firePropertyChange("resourceEnvRef", null, contextResourceEnvRef);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addResourceLink(ContextResourceLink contextResourceLink) {
        if (this.entries.contains(contextResourceLink.getName())) {
            return;
        }
        this.entries.add(contextResourceLink.getName());
        HashMap<String, ContextResourceLink> hashMap = this.resourceLinks;
        synchronized (hashMap) {
            contextResourceLink.setNamingResources(this);
            this.resourceLinks.put(contextResourceLink.getName(), contextResourceLink);
        }
        this.support.firePropertyChange("resourceLink", null, contextResourceLink);
        if (this.resourceRequireExplicitRegistration) {
            try {
                MBeanUtils.createMBean(contextResourceLink);
            }
            catch (Exception exception) {
                log.warn((Object)sm.getString("namingResources.mbeanCreateFail", new Object[]{contextResourceLink.getName()}), (Throwable)exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addService(ContextService contextService) {
        if (this.entries.contains(contextService.getName())) {
            return;
        }
        this.entries.add(contextService.getName());
        HashMap<String, ContextService> hashMap = this.services;
        synchronized (hashMap) {
            contextService.setNamingResources(this);
            this.services.put(contextService.getName(), contextService);
        }
        this.support.firePropertyChange("service", null, contextService);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContextEjb findEjb(String string) {
        HashMap<String, ContextEjb> hashMap = this.ejbs;
        synchronized (hashMap) {
            return this.ejbs.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContextEjb[] findEjbs() {
        HashMap<String, ContextEjb> hashMap = this.ejbs;
        synchronized (hashMap) {
            ContextEjb[] contextEjbArray = new ContextEjb[this.ejbs.size()];
            return this.ejbs.values().toArray(contextEjbArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContextEnvironment findEnvironment(String string) {
        HashMap<String, ContextEnvironment> hashMap = this.envs;
        synchronized (hashMap) {
            return this.envs.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContextEnvironment[] findEnvironments() {
        HashMap<String, ContextEnvironment> hashMap = this.envs;
        synchronized (hashMap) {
            ContextEnvironment[] contextEnvironmentArray = new ContextEnvironment[this.envs.size()];
            return this.envs.values().toArray(contextEnvironmentArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContextLocalEjb findLocalEjb(String string) {
        HashMap<String, ContextLocalEjb> hashMap = this.localEjbs;
        synchronized (hashMap) {
            return this.localEjbs.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContextLocalEjb[] findLocalEjbs() {
        HashMap<String, ContextLocalEjb> hashMap = this.localEjbs;
        synchronized (hashMap) {
            ContextLocalEjb[] contextLocalEjbArray = new ContextLocalEjb[this.localEjbs.size()];
            return this.localEjbs.values().toArray(contextLocalEjbArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageDestinationRef findMessageDestinationRef(String string) {
        HashMap<String, MessageDestinationRef> hashMap = this.mdrs;
        synchronized (hashMap) {
            return this.mdrs.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageDestinationRef[] findMessageDestinationRefs() {
        HashMap<String, MessageDestinationRef> hashMap = this.mdrs;
        synchronized (hashMap) {
            MessageDestinationRef[] messageDestinationRefArray = new MessageDestinationRef[this.mdrs.size()];
            return this.mdrs.values().toArray(messageDestinationRefArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContextResource findResource(String string) {
        HashMap<String, ContextResource> hashMap = this.resources;
        synchronized (hashMap) {
            return this.resources.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContextResourceLink findResourceLink(String string) {
        HashMap<String, ContextResourceLink> hashMap = this.resourceLinks;
        synchronized (hashMap) {
            return this.resourceLinks.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContextResourceLink[] findResourceLinks() {
        HashMap<String, ContextResourceLink> hashMap = this.resourceLinks;
        synchronized (hashMap) {
            ContextResourceLink[] contextResourceLinkArray = new ContextResourceLink[this.resourceLinks.size()];
            return this.resourceLinks.values().toArray(contextResourceLinkArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContextResource[] findResources() {
        HashMap<String, ContextResource> hashMap = this.resources;
        synchronized (hashMap) {
            ContextResource[] contextResourceArray = new ContextResource[this.resources.size()];
            return this.resources.values().toArray(contextResourceArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContextResourceEnvRef findResourceEnvRef(String string) {
        HashMap<String, ContextResourceEnvRef> hashMap = this.resourceEnvRefs;
        synchronized (hashMap) {
            return this.resourceEnvRefs.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContextResourceEnvRef[] findResourceEnvRefs() {
        HashMap<String, ContextResourceEnvRef> hashMap = this.resourceEnvRefs;
        synchronized (hashMap) {
            ContextResourceEnvRef[] contextResourceEnvRefArray = new ContextResourceEnvRef[this.resourceEnvRefs.size()];
            return this.resourceEnvRefs.values().toArray(contextResourceEnvRefArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContextService findService(String string) {
        HashMap<String, ContextService> hashMap = this.services;
        synchronized (hashMap) {
            return this.services.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContextService[] findServices() {
        HashMap<String, ContextService> hashMap = this.services;
        synchronized (hashMap) {
            ContextService[] contextServiceArray = new ContextService[this.services.size()];
            return this.services.values().toArray(contextServiceArray);
        }
    }

    @Deprecated
    public boolean exists(String string) {
        return this.entries.contains(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEjb(String string) {
        this.entries.remove(string);
        ContextEjb contextEjb = null;
        HashMap<String, ContextEjb> hashMap = this.ejbs;
        synchronized (hashMap) {
            contextEjb = this.ejbs.remove(string);
        }
        if (contextEjb != null) {
            this.support.firePropertyChange("ejb", contextEjb, null);
            contextEjb.setNamingResources(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEnvironment(String string) {
        this.entries.remove(string);
        ContextEnvironment contextEnvironment = null;
        HashMap<String, ContextEnvironment> hashMap = this.envs;
        synchronized (hashMap) {
            contextEnvironment = this.envs.remove(string);
        }
        if (contextEnvironment != null) {
            this.support.firePropertyChange("environment", contextEnvironment, null);
            if (this.resourceRequireExplicitRegistration) {
                try {
                    MBeanUtils.destroyMBean(contextEnvironment);
                }
                catch (Exception exception) {
                    log.warn((Object)sm.getString("namingResources.mbeanDestroyFail", new Object[]{contextEnvironment.getName()}), (Throwable)exception);
                }
            }
            contextEnvironment.setNamingResources(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLocalEjb(String string) {
        this.entries.remove(string);
        ContextLocalEjb contextLocalEjb = null;
        HashMap<String, ContextLocalEjb> hashMap = this.localEjbs;
        synchronized (hashMap) {
            contextLocalEjb = this.localEjbs.remove(string);
        }
        if (contextLocalEjb != null) {
            this.support.firePropertyChange("localEjb", contextLocalEjb, null);
            contextLocalEjb.setNamingResources(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMessageDestinationRef(String string) {
        this.entries.remove(string);
        MessageDestinationRef messageDestinationRef = null;
        HashMap<String, MessageDestinationRef> hashMap = this.mdrs;
        synchronized (hashMap) {
            messageDestinationRef = this.mdrs.remove(string);
        }
        if (messageDestinationRef != null) {
            this.support.firePropertyChange("messageDestinationRef", messageDestinationRef, null);
            messageDestinationRef.setNamingResources(null);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeResource(String string) {
        this.entries.remove(string);
        ContextResource contextResource = null;
        HashMap<String, ContextResource> hashMap = this.resources;
        synchronized (hashMap) {
            contextResource = this.resources.remove(string);
        }
        if (contextResource != null) {
            this.support.firePropertyChange("resource", contextResource, null);
            if (this.resourceRequireExplicitRegistration) {
                try {
                    MBeanUtils.destroyMBean(contextResource);
                }
                catch (Exception exception) {
                    log.warn((Object)sm.getString("namingResources.mbeanDestroyFail", new Object[]{contextResource.getName()}), (Throwable)exception);
                }
            }
            contextResource.setNamingResources(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeResourceEnvRef(String string) {
        this.entries.remove(string);
        ContextResourceEnvRef contextResourceEnvRef = null;
        HashMap<String, ContextResourceEnvRef> hashMap = this.resourceEnvRefs;
        synchronized (hashMap) {
            contextResourceEnvRef = this.resourceEnvRefs.remove(string);
        }
        if (contextResourceEnvRef != null) {
            this.support.firePropertyChange("resourceEnvRef", contextResourceEnvRef, null);
            contextResourceEnvRef.setNamingResources(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeResourceLink(String string) {
        this.entries.remove(string);
        ContextResourceLink contextResourceLink = null;
        HashMap<String, ContextResourceLink> hashMap = this.resourceLinks;
        synchronized (hashMap) {
            contextResourceLink = this.resourceLinks.remove(string);
        }
        if (contextResourceLink != null) {
            this.support.firePropertyChange("resourceLink", contextResourceLink, null);
            if (this.resourceRequireExplicitRegistration) {
                try {
                    MBeanUtils.destroyMBean(contextResourceLink);
                }
                catch (Exception exception) {
                    log.warn((Object)sm.getString("namingResources.mbeanDestroyFail", new Object[]{contextResourceLink.getName()}), (Throwable)exception);
                }
            }
            contextResourceLink.setNamingResources(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeService(String string) {
        this.entries.remove(string);
        ContextService contextService = null;
        HashMap<String, ContextService> hashMap = this.services;
        synchronized (hashMap) {
            contextService = this.services.remove(string);
        }
        if (contextService != null) {
            this.support.firePropertyChange("service", contextService, null);
            contextService.setNamingResources(null);
        }
    }

    @Override
    protected void initInternal() throws LifecycleException {
        super.initInternal();
        this.resourceRequireExplicitRegistration = true;
        for (ContextResource resourceBase : this.resources.values()) {
            try {
                MBeanUtils.createMBean(resourceBase);
            }
            catch (Exception exception) {
                log.warn((Object)sm.getString("namingResources.mbeanCreateFail", new Object[]{resourceBase.getName()}), (Throwable)exception);
            }
        }
        for (ContextEnvironment contextEnvironment : this.envs.values()) {
            try {
                MBeanUtils.createMBean(contextEnvironment);
            }
            catch (Exception exception) {
                log.warn((Object)sm.getString("namingResources.mbeanCreateFail", new Object[]{contextEnvironment.getName()}), (Throwable)exception);
            }
        }
        for (ContextResourceLink contextResourceLink : this.resourceLinks.values()) {
            try {
                MBeanUtils.createMBean(contextResourceLink);
            }
            catch (Exception exception) {
                log.warn((Object)sm.getString("namingResources.mbeanCreateFail", new Object[]{contextResourceLink.getName()}), (Throwable)exception);
            }
        }
    }

    @Override
    protected void startInternal() throws LifecycleException {
        this.fireLifecycleEvent("configure_start", null);
        this.setState(LifecycleState.STARTING);
    }

    @Override
    protected void stopInternal() throws LifecycleException {
        this.cleanUp();
        this.setState(LifecycleState.STOPPING);
        this.fireLifecycleEvent("configure_stop", null);
    }

    private void cleanUp() {
        javax.naming.Context context;
        if (this.resources.size() == 0) {
            return;
        }
        try {
            if (this.container instanceof Server) {
                context = ((Server)this.container).getGlobalNamingContext();
            } else {
                context = ContextBindings.getClassLoader();
                context = (javax.naming.Context)context.lookup("comp/env");
            }
        }
        catch (NamingException namingException) {
            log.warn((Object)sm.getString("namingResources.cleanupNoContext", new Object[]{this.container}), (Throwable)namingException);
            return;
        }
        for (ContextResource contextResource : this.resources.values()) {
            Object object;
            String string;
            if (!contextResource.getSingleton() || (string = contextResource.getCloseMethod()) == null || string.length() <= 0) continue;
            String string2 = contextResource.getName();
            try {
                object = context.lookup(string2);
            }
            catch (NamingException namingException) {
                log.warn((Object)sm.getString("namingResources.cleanupNoResource", new Object[]{contextResource.getName(), this.container}), (Throwable)namingException);
                continue;
            }
            this.cleanUp(object, string2, string);
        }
    }

    private void cleanUp(Object object, String string, String string2) {
        Method method = null;
        try {
            method = object.getClass().getMethod(string2, null);
        }
        catch (SecurityException securityException) {
            log.debug((Object)sm.getString("namingResources.cleanupCloseSecurity", new Object[]{string2, string, this.container}));
            return;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            log.debug((Object)sm.getString("namingResources.cleanupNoClose", new Object[]{string, this.container, string2}));
            return;
        }
        try {
            method.invoke(object, (Object[])null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            log.warn((Object)sm.getString("namingResources.cleanupCloseFailed", new Object[]{string2, string, this.container}), (Throwable)illegalArgumentException);
        }
        catch (IllegalAccessException illegalAccessException) {
            log.warn((Object)sm.getString("namingResources.cleanupCloseFailed", new Object[]{string2, string, this.container}), (Throwable)illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = ExceptionUtils.unwrapInvocationTargetException((Throwable)invocationTargetException);
            ExceptionUtils.handleThrowable((Throwable)throwable);
            log.warn((Object)sm.getString("namingResources.cleanupCloseFailed", new Object[]{string2, string, this.container}), throwable);
        }
    }

    @Override
    protected void destroyInternal() throws LifecycleException {
        this.resourceRequireExplicitRegistration = false;
        for (ContextResourceLink resourceBase : this.resourceLinks.values()) {
            try {
                MBeanUtils.destroyMBean(resourceBase);
            }
            catch (Exception exception) {
                log.warn((Object)sm.getString("namingResources.mbeanDestroyFail", new Object[]{resourceBase.getName()}), (Throwable)exception);
            }
        }
        for (ContextEnvironment contextEnvironment : this.envs.values()) {
            try {
                MBeanUtils.destroyMBean(contextEnvironment);
            }
            catch (Exception exception) {
                log.warn((Object)sm.getString("namingResources.mbeanDestroyFail", new Object[]{contextEnvironment.getName()}), (Throwable)exception);
            }
        }
        for (ContextResource contextResource : this.resources.values()) {
            try {
                MBeanUtils.destroyMBean(contextResource);
            }
            catch (Exception exception) {
                log.warn((Object)sm.getString("namingResources.mbeanDestroyFail", new Object[]{contextResource.getName()}), (Throwable)exception);
            }
        }
        super.destroyInternal();
    }

    @Override
    protected String getDomainInternal() {
        Object object = this.getContainer();
        if (object instanceof LifecycleMBeanBase) {
            return ((LifecycleMBeanBase)object).getDomain();
        }
        return null;
    }

    @Override
    protected String getObjectNameKeyProperties() {
        Object object = this.getContainer();
        if (object instanceof Container) {
            return "type=NamingResources" + MBeanUtils.getContainerKeyProperties((Container)object);
        }
        return "type=NamingResources";
    }

    private boolean checkResourceType(ResourceBase resourceBase) {
        if (!(this.container instanceof Context)) {
            return true;
        }
        if (resourceBase.getInjectionTargets() == null || resourceBase.getInjectionTargets().size() == 0) {
            return true;
        }
        Context context = (Context)this.container;
        String string = resourceBase.getType();
        Class<?> clazz = null;
        if (string != null && (clazz = Introspection.loadClass(context, string)) == null) {
            return true;
        }
        Class<?> clazz2 = this.getCompatibleType(context, resourceBase, clazz);
        if (clazz2 == null) {
            return false;
        }
        resourceBase.setType(clazz2.getCanonicalName());
        return true;
    }

    private Class<?> getCompatibleType(Context context, ResourceBase resourceBase, Class<?> clazz) {
        Class<?> clazz2 = null;
        for (InjectionTarget injectionTarget : resourceBase.getInjectionTargets()) {
            Class<?> clazz3 = Introspection.loadClass(context, injectionTarget.getTargetClass());
            if (clazz3 == null) continue;
            String string = injectionTarget.getTargetName();
            Class<?> clazz4 = this.getSetterType(clazz3, string);
            if (clazz4 == null) {
                clazz4 = this.getFieldType(clazz3, string);
            }
            if (clazz4 == null) continue;
            clazz4 = Introspection.convertPrimitiveType(clazz4);
            if (clazz == null) {
                if (clazz2 == null) {
                    clazz2 = clazz4;
                    continue;
                }
                if (clazz4.isAssignableFrom(clazz2)) continue;
                if (clazz2.isAssignableFrom(clazz4)) {
                    clazz2 = clazz4;
                    continue;
                }
                return null;
            }
            if (clazz4.isAssignableFrom(clazz)) {
                clazz2 = clazz;
                continue;
            }
            return null;
        }
        return clazz2;
    }

    private Class<?> getSetterType(Class<?> clazz, String string) {
        Method[] methodArray = Introspection.getDeclaredMethods(clazz);
        if (methodArray != null && methodArray.length > 0) {
            for (Method method : methodArray) {
                if (!Introspection.isValidSetter(method) || !Introspection.getPropertyName(method).equals(string)) continue;
                return method.getParameterTypes()[0];
            }
        }
        return null;
    }

    private Class<?> getFieldType(Class<?> clazz, String string) {
        Field[] fieldArray = Introspection.getDeclaredFields(clazz);
        if (fieldArray != null && fieldArray.length > 0) {
            for (Field field : fieldArray) {
                if (!field.getName().equals(string)) continue;
                return field.getType();
            }
        }
        return null;
    }
}

