/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom.util;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.apache.batik.dom.AbstractDocument;
import org.apache.batik.dom.util.HashTable;
import org.apache.batik.dom.util.SAXDocumentFactory;
import org.apache.batik.util.XMLConstants;
import org.apache.batik.xml.XMLUtilities;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOMUtilities
extends XMLUtilities
implements XMLConstants {
    protected static final String[] LOCK_STRINGS = new String[]{"", "CapsLock", "NumLock", "NumLock CapsLock", "Scroll", "Scroll CapsLock", "Scroll NumLock", "Scroll NumLock CapsLock", "KanaMode", "KanaMode CapsLock", "KanaMode NumLock", "KanaMode NumLock CapsLock", "KanaMode Scroll", "KanaMode Scroll CapsLock", "KanaMode Scroll NumLock", "KanaMode Scroll NumLock CapsLock"};
    protected static final String[] MODIFIER_STRINGS = new String[]{"", "Shift", "Control", "Control Shift", "Meta", "Meta Shift", "Control Meta", "Control Meta Shift", "Alt", "Alt Shift", "Alt Control", "Alt Control Shift", "Alt Meta", "Alt Meta Shift", "Alt Control Meta", "Alt Control Meta Shift", "AltGraph", "AltGraph Shift", "AltGraph Control", "AltGraph Control Shift", "AltGraph Meta", "AltGraph Meta Shift", "AltGraph Control Meta", "AltGraph Control Meta Shift", "Alt AltGraph", "Alt AltGraph Shift", "Alt AltGraph Control", "Alt AltGraph Control Shift", "Alt AltGraph Meta", "Alt AltGraph Meta Shift", "Alt AltGraph Control Meta", "Alt AltGraph Control Meta Shift"};

    protected DOMUtilities() {
    }

    public static void writeDocument(Document document, Writer writer) throws IOException {
        AbstractDocument abstractDocument = (AbstractDocument)document;
        if (document.getDocumentElement() == null) {
            throw new IOException("No document element");
        }
        NSMap nSMap = NSMap.create();
        for (Node node = document.getFirstChild(); node != null; node = node.getNextSibling()) {
            DOMUtilities.writeNode(node, writer, nSMap, "1.1".equals(abstractDocument.getXmlVersion()));
        }
    }

    protected static void writeNode(Node node, Writer writer, NSMap nSMap, boolean bl) throws IOException {
        switch (node.getNodeType()) {
            case 1: {
                Node node2;
                String string;
                Object object;
                Object object2;
                if (node.hasAttributes()) {
                    object2 = node.getAttributes();
                    int n = object2.getLength();
                    for (int i = 0; i < n; ++i) {
                        Attr attr = (Attr)object2.item(i);
                        String string2 = attr.getNodeName();
                        if (!string2.startsWith("xmlns")) continue;
                        if (string2.length() == 5) {
                            nSMap = nSMap.declare("", attr.getNodeValue());
                            continue;
                        }
                        object = string2.substring(6);
                        nSMap = nSMap.declare((String)object, attr.getNodeValue());
                    }
                }
                writer.write(60);
                object2 = node.getNamespaceURI();
                if (object2 == null) {
                    string = node.getNodeName();
                    writer.write(string);
                    if (!"".equals(nSMap.getNamespace(""))) {
                        writer.write(" xmlns=\"\"");
                        nSMap = nSMap.declare("", "");
                    }
                } else {
                    String string3 = node.getPrefix();
                    if (string3 == null) {
                        string3 = "";
                    }
                    if (((String)object2).equals(nSMap.getNamespace(string3))) {
                        string = node.getNodeName();
                        writer.write(string);
                    } else {
                        string3 = nSMap.getPrefixForElement((String)object2);
                        if (string3 == null) {
                            string3 = nSMap.getNewPrefix();
                            string = string3 + ':' + node.getLocalName();
                            writer.write(string + " xmlns:" + string3 + "=\"" + DOMUtilities.contentToString((String)object2, bl) + '\"');
                            nSMap = nSMap.declare(string3, (String)object2);
                        } else {
                            string = string3.equals("") ? node.getLocalName() : string3 + ':' + node.getLocalName();
                            writer.write(string);
                        }
                    }
                }
                if (node.hasAttributes()) {
                    NamedNodeMap namedNodeMap = node.getAttributes();
                    int n = namedNodeMap.getLength();
                    for (int i = 0; i < n; ++i) {
                        object = (Attr)namedNodeMap.item(i);
                        String string4 = object.getNodeName();
                        String string5 = object.getPrefix();
                        String string6 = object.getNamespaceURI();
                        if (!(string6 == null || "xmlns".equals(string5) || string4.equals("xmlns") || (string5 == null || string6.equals(nSMap.getNamespace(string5))) && string5 != null)) {
                            string5 = nSMap.getPrefixForAttr(string6);
                            if (string5 == null) {
                                string5 = nSMap.getNewPrefix();
                                nSMap = nSMap.declare(string5, string6);
                                writer.write(" xmlns:" + string5 + "=\"" + DOMUtilities.contentToString(string6, bl) + '\"');
                            }
                            string4 = string5 + ':' + object.getLocalName();
                        }
                        writer.write(' ' + string4 + "=\"" + DOMUtilities.contentToString(object.getNodeValue(), bl) + '\"');
                    }
                }
                if ((node2 = node.getFirstChild()) != null) {
                    writer.write(62);
                    do {
                        DOMUtilities.writeNode(node2, writer, nSMap, bl);
                    } while ((node2 = node2.getNextSibling()) != null);
                    writer.write("</" + string + '>');
                    break;
                }
                writer.write("/>");
                break;
            }
            case 3: {
                writer.write(DOMUtilities.contentToString(node.getNodeValue(), bl));
                break;
            }
            case 4: {
                String string = node.getNodeValue();
                if (string.indexOf("]]>") != -1) {
                    throw new IOException("Unserializable CDATA section node");
                }
                writer.write("<![CDATA[" + DOMUtilities.assertValidCharacters(string, bl) + "]]>");
                break;
            }
            case 5: {
                writer.write('&' + node.getNodeName() + ';');
                break;
            }
            case 7: {
                String string = node.getNodeName();
                String string7 = node.getNodeValue();
                if (string.equalsIgnoreCase("xml") || string.indexOf(58) != -1 || string7.indexOf("?>") != -1) {
                    throw new IOException("Unserializable processing instruction node");
                }
                writer.write("<?" + string + ' ' + string7 + "?>");
                break;
            }
            case 8: {
                writer.write("<!--");
                String string = node.getNodeValue();
                int n = string.length();
                if (n != 0 && string.charAt(n - 1) == '-' || string.indexOf("--") != -1) {
                    throw new IOException("Unserializable comment node");
                }
                writer.write(string);
                writer.write("-->");
                break;
            }
            case 10: {
                String string;
                String string8;
                DocumentType documentType = (DocumentType)node;
                writer.write("<!DOCTYPE " + node.getOwnerDocument().getDocumentElement().getNodeName());
                String string9 = documentType.getPublicId();
                if (string9 != null) {
                    char c = DOMUtilities.getUsableQuote(string9);
                    if (c == '\u0000') {
                        throw new IOException("Unserializable DOCTYPE node");
                    }
                    writer.write(" PUBLIC " + c + string9 + c);
                }
                if ((string8 = documentType.getSystemId()) != null) {
                    char c = DOMUtilities.getUsableQuote(string8);
                    if (c == '\u0000') {
                        throw new IOException("Unserializable DOCTYPE node");
                    }
                    if (string9 == null) {
                        writer.write(" SYSTEM");
                    }
                    writer.write(" " + c + string8 + c);
                }
                if ((string = documentType.getInternalSubset()) != null) {
                    writer.write('[' + string + ']');
                }
                writer.write(62);
                break;
            }
            default: {
                throw new IOException("Unknown DOM node type " + node.getNodeType());
            }
        }
    }

    public static void writeNode(Node node, Writer writer) throws IOException {
        if (node.getNodeType() == 9) {
            DOMUtilities.writeDocument((Document)node, writer);
        } else {
            AbstractDocument abstractDocument = (AbstractDocument)node.getOwnerDocument();
            DOMUtilities.writeNode(node, writer, NSMap.create(), abstractDocument == null ? false : "1.1".equals(abstractDocument.getXmlVersion()));
        }
    }

    private static char getUsableQuote(String string) {
        int n = 0;
        for (int i = string.length() - 1; i >= 0; --i) {
            char c = string.charAt(i);
            if (c == '\"') {
                if (n == 0) {
                    n = 39;
                    continue;
                }
                return '\u0000';
            }
            if (c != '\'') continue;
            if (n == 0) {
                n = 34;
                continue;
            }
            return '\u0000';
        }
        return (char)(n == 0 ? 34 : n);
    }

    public static String getXML(Node node) {
        StringWriter stringWriter = new StringWriter();
        try {
            DOMUtilities.writeNode(node, stringWriter);
            ((Writer)stringWriter).close();
        }
        catch (IOException iOException) {
            return "";
        }
        return ((Object)stringWriter).toString();
    }

    protected static String assertValidCharacters(String string, boolean bl) throws IOException {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if ((bl || DOMUtilities.isXMLCharacter((int)c)) && (!bl || DOMUtilities.isXML11Character((int)c))) continue;
            throw new IOException("Invalid character");
        }
        return string;
    }

    public static String contentToString(String string, boolean bl) throws IOException {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        int n = string.length();
        block7: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (!bl && !DOMUtilities.isXMLCharacter((int)c) || bl && !DOMUtilities.isXML11Character((int)c)) {
                throw new IOException("Invalid character");
            }
            switch (c) {
                case '<': {
                    stringBuffer.append("&lt;");
                    continue block7;
                }
                case '>': {
                    stringBuffer.append("&gt;");
                    continue block7;
                }
                case '&': {
                    stringBuffer.append("&amp;");
                    continue block7;
                }
                case '\"': {
                    stringBuffer.append("&quot;");
                    continue block7;
                }
                case '\'': {
                    stringBuffer.append("&apos;");
                    continue block7;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
        }
        return stringBuffer.toString();
    }

    public static int getChildIndex(Node node, Node node2) {
        if (node == null || node.getParentNode() != node2 || node.getParentNode() == null) {
            return -1;
        }
        return DOMUtilities.getChildIndex(node);
    }

    public static int getChildIndex(Node node) {
        NodeList nodeList = node.getParentNode().getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (node2 != node) continue;
            return i;
        }
        return -1;
    }

    public static boolean isAnyNodeAncestorOf(ArrayList arrayList, Node node) {
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            Node node2 = (Node)arrayList.get(i);
            if (!DOMUtilities.isAncestorOf(node2, node)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAncestorOf(Node node, Node node2) {
        if (node == null || node2 == null) {
            return false;
        }
        for (Node node3 = node2.getParentNode(); node3 != null; node3 = node3.getParentNode()) {
            if (node3 != node) continue;
            return true;
        }
        return false;
    }

    public static boolean isParentOf(Node node, Node node2) {
        return node != null && node2 != null && node.getParentNode() == node2;
    }

    public static boolean canAppend(Node node, Node node2) {
        return node != null && node2 != null && node != node2 && !DOMUtilities.isAncestorOf(node, node2);
    }

    public static boolean canAppendAny(ArrayList arrayList, Node node) {
        if (!DOMUtilities.canHaveChildren(node)) {
            return false;
        }
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            Node node2 = (Node)arrayList.get(i);
            if (!DOMUtilities.canAppend(node2, node)) continue;
            return true;
        }
        return false;
    }

    public static boolean canHaveChildren(Node node) {
        if (node == null) {
            return false;
        }
        switch (node.getNodeType()) {
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: {
                return false;
            }
        }
        return true;
    }

    public static Node parseXML(String string, Document document, String string2, Map map, String string3, SAXDocumentFactory sAXDocumentFactory) {
        Iterator iterator;
        Object object;
        Object object2;
        String string4 = "";
        String string5 = "";
        if (string3 != null) {
            string4 = "<" + string3;
            if (map != null) {
                string4 = string4 + " ";
                for (Map.Entry object32 : map.entrySet()) {
                    object2 = (String)object32.getKey();
                    object = (String)object32.getValue();
                    string4 = string4 + (String)object2 + "=\"" + (String)object + "\" ";
                }
            }
            string4 = string4 + ">";
            string5 = string5 + "</" + string3 + '>';
        }
        if (string4.trim().length() == 0 && string5.trim().length() == 0) {
            try {
                iterator = sAXDocumentFactory.createDocument(string2, new StringReader(string));
                if (document == null) {
                    return iterator;
                }
                DocumentFragment documentFragment = document.createDocumentFragment();
                documentFragment.appendChild(document.importNode(iterator.getDocumentElement(), true));
                return documentFragment;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        iterator = new StringBuffer(string4.length() + string.length() + string5.length());
        ((StringBuffer)((Object)iterator)).append(string4);
        ((StringBuffer)((Object)iterator)).append(string);
        ((StringBuffer)((Object)iterator)).append(string5);
        String string6 = ((StringBuffer)((Object)iterator)).toString();
        try {
            object2 = sAXDocumentFactory.createDocument(string2, new StringReader(string6));
            if (document == null) {
                return object2;
            }
            for (object = object2.getDocumentElement().getFirstChild(); object != null; object = object.getNextSibling()) {
                if (object.getNodeType() != 1) continue;
                object = document.importNode((Node)object, true);
                DocumentFragment documentFragment = document.createDocumentFragment();
                documentFragment.appendChild((Node)object);
                return documentFragment;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static Document deepCloneDocument(Document document, DOMImplementation dOMImplementation) {
        Element element = document.getDocumentElement();
        Document document2 = dOMImplementation.createDocument(element.getNamespaceURI(), element.getNodeName(), null);
        Element element2 = document2.getDocumentElement();
        boolean bl = true;
        for (Node node = document.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node == element) {
                Object object;
                bl = false;
                if (element.hasAttributes()) {
                    object = element.getAttributes();
                    int n = object.getLength();
                    for (int i = 0; i < n; ++i) {
                        element2.setAttributeNode((Attr)document2.importNode(object.item(i), true));
                    }
                }
                for (object = element.getFirstChild(); object != null; object = object.getNextSibling()) {
                    element2.appendChild(document2.importNode((Node)object, true));
                }
                continue;
            }
            if (node.getNodeType() == 10) continue;
            if (bl) {
                document2.insertBefore(document2.importNode(node, true), element2);
                continue;
            }
            document2.appendChild(document2.importNode(node, true));
        }
        return document2;
    }

    public static boolean isValidName(String string) {
        int n;
        int n2 = string.length();
        if (n2 == 0) {
            return false;
        }
        char c = string.charAt(0);
        int n3 = c / 32;
        if ((NAME_FIRST_CHARACTER[n3] & 1 << (n = c % 32)) == 0) {
            return false;
        }
        for (int i = 1; i < n2; ++i) {
            c = string.charAt(i);
            n3 = c / 32;
            if ((NAME_CHARACTER[n3] & 1 << (n = c % 32)) != 0) continue;
            return false;
        }
        return true;
    }

    public static boolean isValidName11(String string) {
        int n;
        int n2 = string.length();
        if (n2 == 0) {
            return false;
        }
        char c = string.charAt(0);
        int n3 = c / 32;
        if ((NAME11_FIRST_CHARACTER[n3] & 1 << (n = c % 32)) == 0) {
            return false;
        }
        for (int i = 1; i < n2; ++i) {
            c = string.charAt(i);
            n3 = c / 32;
            if ((NAME11_CHARACTER[n3] & 1 << (n = c % 32)) != 0) continue;
            return false;
        }
        return true;
    }

    public static boolean isValidPrefix(String string) {
        return string.indexOf(58) == -1;
    }

    public static String getPrefix(String string) {
        int n = string.indexOf(58);
        return n == -1 || n == string.length() - 1 ? null : string.substring(0, n);
    }

    public static String getLocalName(String string) {
        int n = string.indexOf(58);
        return n == -1 || n == string.length() - 1 ? string : string.substring(n + 1);
    }

    public static void parseStyleSheetPIData(String string, HashTable hashTable) {
        char c;
        int n;
        for (n = 0; n < string.length() && XMLUtilities.isXMLSpace((char)(c = string.charAt(n))); ++n) {
        }
        while (n < string.length()) {
            int n2;
            c = string.charAt(n);
            int n3 = c / 32;
            if ((NAME_FIRST_CHARACTER[n3] & 1 << (n2 = c % 32)) == 0) {
                throw new DOMException(5, "Wrong name initial:  " + c);
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(c);
            while (++n < string.length() && (NAME_CHARACTER[n3 = (c = string.charAt(n)) / 32] & 1 << (n2 = c % 32)) != 0) {
                stringBuffer.append(c);
            }
            if (n >= string.length()) {
                throw new DOMException(12, "Wrong xml-stylesheet data: " + string);
            }
            while (n < string.length() && XMLUtilities.isXMLSpace((char)(c = string.charAt(n)))) {
                ++n;
            }
            if (n >= string.length()) {
                throw new DOMException(12, "Wrong xml-stylesheet data: " + string);
            }
            if (string.charAt(n) != '=') {
                throw new DOMException(12, "Wrong xml-stylesheet data: " + string);
            }
            ++n;
            while (n < string.length() && XMLUtilities.isXMLSpace((char)(c = string.charAt(n)))) {
                ++n;
            }
            if (n >= string.length()) {
                throw new DOMException(12, "Wrong xml-stylesheet data: " + string);
            }
            c = string.charAt(n);
            ++n;
            StringBuffer stringBuffer2 = new StringBuffer();
            if (c == '\'') {
                while (n < string.length() && (c = string.charAt(n)) != '\'') {
                    stringBuffer2.append(c);
                    ++n;
                }
                if (n >= string.length()) {
                    throw new DOMException(12, "Wrong xml-stylesheet data: " + string);
                }
            } else if (c == '\"') {
                while (n < string.length() && (c = string.charAt(n)) != '\"') {
                    stringBuffer2.append(c);
                    ++n;
                }
                if (n >= string.length()) {
                    throw new DOMException(12, "Wrong xml-stylesheet data: " + string);
                }
            } else {
                throw new DOMException(12, "Wrong xml-stylesheet data: " + string);
            }
            hashTable.put(stringBuffer.toString().intern(), stringBuffer2.toString());
            ++n;
            while (n < string.length() && XMLUtilities.isXMLSpace((char)(c = string.charAt(n)))) {
                ++n;
            }
        }
    }

    public static String getModifiersList(int n, int n2) {
        n2 = (n2 & 0x2000) != 0 ? 0x10 | n2 >> 6 & 0xF : n2 >> 6 & 0xF;
        String string = LOCK_STRINGS[n & 0xF];
        if (string.length() != 0) {
            return string + ' ' + MODIFIER_STRINGS[n2];
        }
        return MODIFIER_STRINGS[n2];
    }

    public static boolean isAttributeSpecifiedNS(Element element, String string, String string2) {
        Attr attr = element.getAttributeNodeNS(string, string2);
        return attr != null && attr.getSpecified();
    }

    private static class NSMap {
        private String prefix;
        private String ns;
        private NSMap next;
        private int nextPrefixNumber;

        public static NSMap create() {
            return new NSMap().declare("xml", "http://www.w3.org/XML/1998/namespace").declare("xmlns", "http://www.w3.org/2000/xmlns/");
        }

        private NSMap() {
        }

        public NSMap declare(String string, String string2) {
            NSMap nSMap = new NSMap();
            nSMap.prefix = string;
            nSMap.ns = string2;
            nSMap.next = this;
            nSMap.nextPrefixNumber = this.nextPrefixNumber;
            return nSMap;
        }

        public String getNewPrefix() {
            String string;
            while (this.getNamespace(string = "a" + this.nextPrefixNumber++) != null) {
            }
            return string;
        }

        public String getNamespace(String string) {
            NSMap nSMap = this;
            while (nSMap.next != null) {
                if (nSMap.prefix.equals(string)) {
                    return nSMap.ns;
                }
                nSMap = nSMap.next;
            }
            return null;
        }

        public String getPrefixForElement(String string) {
            NSMap nSMap = this;
            while (nSMap.next != null) {
                if (string.equals(nSMap.ns)) {
                    return nSMap.prefix;
                }
                nSMap = nSMap.next;
            }
            return null;
        }

        public String getPrefixForAttr(String string) {
            NSMap nSMap = this;
            while (nSMap.next != null) {
                if (string.equals(nSMap.ns) && !nSMap.prefix.equals("")) {
                    return nSMap.prefix;
                }
                nSMap = nSMap.next;
            }
            return null;
        }
    }
}

