/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.threedee;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.vecmath.Point3d;
import javax.vecmath.TexCoord2f;
import tim.prune.data.Altitude;
import tim.prune.data.DataPoint;
import tim.prune.data.DoubleRange;
import tim.prune.data.Field;
import tim.prune.data.FieldList;
import tim.prune.data.Latitude;
import tim.prune.data.Longitude;
import tim.prune.data.Track;
import tim.prune.data.TrackExtents;
import tim.prune.data.UnitSetLibrary;
import tim.prune.gui.map.MapUtils;
import tim.prune.threedee.TerrainPatch;
import tim.prune.threedee.ThreeDModel;

public class TerrainHelper {
    private int _gridSize = 0;

    public TerrainHelper(int n) {
        this._gridSize = n;
    }

    public int getGridSize() {
        return this._gridSize;
    }

    public Point3d[] getTerrainCoordinates(Point3d[] point3dArray) {
        int n = this._gridSize * this._gridSize;
        if (this._gridSize <= 1 || point3dArray == null || point3dArray.length != n) {
            return null;
        }
        int n2 = this._gridSize * (this._gridSize * 2 - 2);
        Point3d[] point3dArray2 = new Point3d[n2];
        int n3 = this._gridSize - 1;
        int n4 = 0;
        int n5 = 0;
        while (n5 < n3) {
            int n6 = 0;
            while (n6 < this._gridSize) {
                int n7 = n5 * this._gridSize + n6;
                int n8 = n7 + this._gridSize;
                point3dArray2[n4++] = point3dArray[n7];
                point3dArray2[n4++] = point3dArray[n8];
                ++n6;
            }
            ++n5;
        }
        return point3dArray2;
    }

    public TexCoord2f[] getTextureCoordinates() {
        if (this._gridSize <= 1) {
            return null;
        }
        int n = this._gridSize * this._gridSize;
        float f = 1.0f / (float)(this._gridSize - 1);
        TexCoord2f[] texCoord2fArray = new TexCoord2f[n];
        int n2 = 0;
        while (n2 < this._gridSize) {
            int n3 = 0;
            while (n3 < this._gridSize) {
                texCoord2fArray[n3 * this._gridSize + n2] = new TexCoord2f(f * (float)n2, 1.0f - f * (float)n3);
                ++n3;
            }
            ++n2;
        }
        n2 = this._gridSize * (this._gridSize * 2 - 2);
        TexCoord2f[] texCoord2fArray2 = new TexCoord2f[n2];
        int n4 = this._gridSize - 1;
        int n5 = 0;
        int n6 = 0;
        while (n6 < n4) {
            int n7 = 0;
            while (n7 < this._gridSize) {
                int n8 = n6 * this._gridSize + n7;
                int n9 = n8 + this._gridSize;
                texCoord2fArray2[n5++] = texCoord2fArray[n8];
                texCoord2fArray2[n5++] = texCoord2fArray[n9];
                ++n7;
            }
            ++n6;
        }
        return texCoord2fArray2;
    }

    public int[] getStripLengths() {
        int n = this._gridSize - 1;
        int n2 = this._gridSize * 2;
        int[] nArray = new int[n];
        int n3 = 0;
        while (n3 < n) {
            nArray[n3] = n2;
            ++n3;
        }
        return nArray;
    }

    public Track createGridTrack(Track track) {
        TrackExtents trackExtents = new TrackExtents(track);
        trackExtents.applySquareBorder();
        DoubleRange doubleRange = trackExtents.getXRange();
        DoubleRange doubleRange2 = trackExtents.getYRange();
        int n = this._gridSize * this._gridSize;
        double d = doubleRange.getRange() / (double)(this._gridSize - 1);
        double d2 = doubleRange2.getRange() / (double)(this._gridSize - 1);
        DataPoint[] dataPointArray = new DataPoint[n];
        int n2 = 0;
        while (n2 < this._gridSize) {
            double d3 = doubleRange2.getMinimum() + (double)n2 * d2;
            int n3 = 0;
            while (n3 < this._gridSize) {
                DataPoint dataPoint;
                double d4 = doubleRange.getMinimum() + (double)n3 * d;
                dataPointArray[n2 * this._gridSize + n3] = dataPoint = new DataPoint(new Latitude(MapUtils.getLatitudeFromY(d3), 17), new Longitude(MapUtils.getLongitudeFromX(d4), 17), null);
                ++n3;
            }
            ++n2;
        }
        Field[] fieldArray = new Field[]{Field.LATITUDE, Field.LONGITUDE, Field.ALTITUDE};
        Track track2 = new Track(new FieldList(fieldArray), dataPointArray);
        return track2;
    }

    public void writeHeightMap(ThreeDModel threeDModel, File file) {
        BufferedImage bufferedImage = new BufferedImage(this._gridSize, this._gridSize, 13);
        int n = 0;
        while (n < this._gridSize) {
            int n2 = 0;
            while (n2 < this._gridSize) {
                double d = threeDModel.getScaledTerrainValue(n * this._gridSize + n2) * 256.0;
                bufferedImage.setRGB(n2, n, bufferedImage.getColorModel().getRGB((int)d));
                ++n2;
            }
            ++n;
        }
        try {
            ImageIO.write((RenderedImage)bufferedImage, "PNG", file);
        }
        catch (IOException iOException) {
            System.err.println(String.valueOf(iOException.getClass().getName()) + " - " + iOException.getMessage());
        }
    }

    public void fixVoids(Track track) {
        int n = TerrainHelper.countVoids(track);
        if (n == 0) {
            return;
        }
        this.fixSingleHoles(track);
        this.fixCornersAndEdges(track);
        this.fixBiggerHoles(track);
        int n2 = TerrainHelper.countVoids(track);
        if (n2 > 0) {
            System.out.println("Fixed bigger holes, now num voids = " + TerrainHelper.countVoids(track));
        }
    }

    private static int countVoids(Track track) {
        int n = 0;
        if (track != null) {
            int n2 = 0;
            while (n2 < track.getNumPoints()) {
                if (!track.getPoint(n2).hasAltitude()) {
                    ++n;
                }
                ++n2;
            }
        }
        return n;
    }

    private void fixSingleHoles(Track track) {
        boolean bl = true;
        int n = this._gridSize - 2;
        int n2 = 1;
        while (n2 <= n) {
            int n3 = 1;
            while (n3 <= n) {
                int n4 = n2 * this._gridSize + n3;
                DataPoint dataPoint = track.getPoint(n4);
                if (!dataPoint.hasAltitude()) {
                    DataPoint dataPoint2 = track.getPoint(n4 - 1);
                    DataPoint dataPoint3 = track.getPoint(n4 + 1);
                    DataPoint dataPoint4 = track.getPoint(n4 + this._gridSize);
                    DataPoint dataPoint5 = track.getPoint(n4 - this._gridSize);
                    if (dataPoint2 == null || dataPoint3 == null || dataPoint4 == null || dataPoint5 == null) {
                        System.err.println("Woah. Got a null point in fixSingleHoles. x=" + n2 + ", y=" + n3 + ", grid=" + this._gridSize);
                        System.err.println("index=" + n4);
                        if (dataPoint2 == null) {
                            System.err.println("pl is null");
                        }
                        if (dataPoint3 == null) {
                            System.err.println("pr is null");
                        }
                        if (dataPoint4 == null) {
                            System.err.println("pu is null");
                        }
                        if (dataPoint5 == null) {
                            System.err.println("pd is null");
                        }
                    } else if (dataPoint2.hasAltitude() && dataPoint3.hasAltitude() && dataPoint4.hasAltitude() && dataPoint5.hasAltitude()) {
                        DataPoint dataPoint6 = track.getPoint(n4 - 2);
                        DataPoint dataPoint7 = track.getPoint(n4 + 2);
                        DataPoint dataPoint8 = track.getPoint(n4 + 2 * this._gridSize);
                        DataPoint dataPoint9 = track.getPoint(n4 - 2 * this._gridSize);
                        double d = 0.0;
                        d = dataPoint6 != null && dataPoint6.hasAltitude() && dataPoint7 != null && dataPoint7.hasAltitude() && dataPoint8 != null && dataPoint8.hasAltitude() && dataPoint9 != null && dataPoint9.hasAltitude() ? (dataPoint2.getAltitude().getMetricValue() * 1.5 - dataPoint6.getAltitude().getMetricValue() * 0.5 + dataPoint3.getAltitude().getMetricValue() * 1.5 - dataPoint7.getAltitude().getMetricValue() * 0.5 + dataPoint5.getAltitude().getMetricValue() * 1.5 - dataPoint9.getAltitude().getMetricValue() * 0.5 + dataPoint4.getAltitude().getMetricValue() * 1.5 - dataPoint8.getAltitude().getMetricValue() * 0.5) / 4.0 : (dataPoint2.getAltitude().getMetricValue() + dataPoint3.getAltitude().getMetricValue() + dataPoint5.getAltitude().getMetricValue() + dataPoint4.getAltitude().getMetricValue()) / 4.0;
                        dataPoint.setFieldValue(Field.ALTITUDE, "" + d, false);
                        dataPoint.getAltitude().reset(new Altitude((int)d, UnitSetLibrary.UNITS_METRES));
                    }
                }
                ++n3;
            }
            ++n2;
        }
    }

    private void fixCornersAndEdges(Track track) {
        this.fixCorner(track, 0, 1, 1);
        this.fixCorner(track, this._gridSize - 1, -1, 1);
        this.fixCorner(track, (this._gridSize - 1) * this._gridSize, 1, -1);
        this.fixCorner(track, this._gridSize * this._gridSize - 1, -1, -1);
        this.fixEdge(track, 0, 1);
        this.fixEdge(track, this._gridSize - 1, this._gridSize);
        this.fixEdge(track, (this._gridSize - 1) * this._gridSize, -this._gridSize);
        this.fixEdge(track, this._gridSize * this._gridSize - 1, -1);
    }

    private void fixCorner(Track track, int n, int n2, int n3) {
        DataPoint dataPoint = track.getPoint(n);
        if (dataPoint == null || dataPoint.hasAltitude()) {
            return;
        }
        int n4 = n;
        int n5 = n;
        Altitude altitude = null;
        Altitude altitude2 = null;
        int n6 = 1;
        while (n6 < this._gridSize && !dataPoint.hasAltitude()) {
            DataPoint dataPoint2;
            n5 += n3 * this._gridSize;
            if (altitude == null && (dataPoint2 = track.getPoint(n4 += n2)) != null && dataPoint2.hasAltitude()) {
                altitude = dataPoint2.getAltitude();
            }
            if (altitude2 == null && (dataPoint2 = track.getPoint(n5)) != null && dataPoint2.hasAltitude()) {
                altitude2 = dataPoint2.getAltitude();
            }
            if (altitude != null && altitude2 != null) {
                int n7 = (int)((altitude.getMetricValue() + altitude2.getMetricValue()) / 2.0);
                dataPoint.setFieldValue(Field.ALTITUDE, "" + n7, false);
            }
            ++n6;
        }
    }

    private void fixEdge(Track track, int n, int n2) {
        int n3 = -1;
        int n4 = n;
        if (track.getPoint(n4).hasAltitude()) {
            n3 = 0;
        }
        int n5 = 1;
        while (n5 < this._gridSize) {
            if (track.getPoint(n4 += n2).hasAltitude()) {
                if (n3 >= 0 && n3 < n5 - 1) {
                    int n6 = n5 - n3;
                    int n7 = n + n3 * n2;
                    double d = track.getPoint(n7).getAltitude().getMetricValue();
                    int n8 = n + n5 * n2;
                    double d2 = track.getPoint(n8).getAltitude().getMetricValue();
                    int n9 = 1;
                    while (n9 < n6) {
                        double d3 = d + (d2 - d) * (double)n9 / (double)n6;
                        DataPoint dataPoint = track.getPoint(n + (n3 + n9) * n2);
                        dataPoint.setFieldValue(Field.ALTITUDE, "" + (int)d3, false);
                        ++n9;
                    }
                }
                n3 = n5;
            }
            ++n5;
        }
    }

    private void fixBiggerHoles(Track track) {
        TerrainPatch terrainPatch = new TerrainPatch(this._gridSize);
        int n = 0;
        while (n < this._gridSize) {
            int n2 = -1;
            int n3 = -1;
            int n4 = 0;
            while (n4 < this._gridSize) {
                double d;
                int n5;
                double d2;
                double d3;
                if (track.getPoint(n * this._gridSize + n4).hasAltitude()) {
                    if (n2 > -1 && n2 != n4 - 1) {
                        d3 = track.getPoint(n * this._gridSize + n2).getAltitude().getMetricValue();
                        d2 = track.getPoint(n * this._gridSize + n4).getAltitude().getMetricValue();
                        n5 = n2 + 1;
                        while (n5 < n4) {
                            d = d3 + (double)(n5 - n2) * (d2 - d3) / (double)(n4 - n2);
                            terrainPatch.addAltitude(n * this._gridSize + n5, d, n5 - n2, n4 - n2);
                            ++n5;
                        }
                    }
                    n2 = n4;
                }
                if (track.getPoint(n4 * this._gridSize + n).hasAltitude()) {
                    if (n3 > -1 && n3 != n4 - 1) {
                        d3 = track.getPoint(n3 * this._gridSize + n).getAltitude().getMetricValue();
                        d2 = track.getPoint(n4 * this._gridSize + n).getAltitude().getMetricValue();
                        n5 = n3 + 1;
                        while (n5 < n4) {
                            d = d3 + (double)(n5 - n3) * (d2 - d3) / (double)(n4 - n3);
                            terrainPatch.addAltitude(n5 * this._gridSize + n, d, n5 - n3, n4 - n3);
                            ++n5;
                        }
                    }
                    n3 = n4;
                }
                ++n4;
            }
            ++n;
        }
        terrainPatch.smooth();
        n = 0;
        while (n < track.getNumPoints()) {
            DataPoint dataPoint = track.getPoint(n);
            if (!dataPoint.hasAltitude()) {
                double d = terrainPatch.getAltitude(n);
                dataPoint.setFieldValue(Field.ALTITUDE, "" + d, false);
                dataPoint.getAltitude().reset(new Altitude((int)d, UnitSetLibrary.UNITS_METRES));
            }
            ++n;
        }
    }
}

