/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.imagery;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.swing.ImageIcon;
import org.openstreetmap.josm.data.StructUtils;
import org.openstreetmap.josm.data.imagery.DefaultLayer;
import org.openstreetmap.josm.data.imagery.ImageryLayerInfo;
import org.openstreetmap.josm.data.imagery.Shape;
import org.openstreetmap.josm.data.imagery.TMSCachedTileLoaderJob;
import org.openstreetmap.josm.data.sources.ISourceCategory;
import org.openstreetmap.josm.data.sources.ISourceType;
import org.openstreetmap.josm.data.sources.SourceBounds;
import org.openstreetmap.josm.data.sources.SourceInfo;
import org.openstreetmap.josm.data.sources.SourcePreferenceEntry;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.MultiMap;
import org.openstreetmap.josm.tools.StreamUtils;
import org.openstreetmap.josm.tools.Utils;

public class ImageryInfo
extends SourceInfo<ImageryCategory, ImageryType, ImageryBounds, ImageryPreferenceEntry> {
    private double pixelPerDegree;
    private int defaultMaxZoom;
    private int defaultMinZoom;
    private List<String> serverProjections = Collections.emptyList();
    private boolean bestMarked;
    private boolean overlay;
    protected List<ImageryInfo> mirrors;
    private boolean isGeoreferenceValid;
    private boolean transparent = true;
    private int minimumTileExpire = (int)TimeUnit.MILLISECONDS.toSeconds(TMSCachedTileLoaderJob.MINIMUM_EXPIRES.get());

    public ImageryInfo() {
    }

    public ImageryInfo(String name) {
        super(name);
    }

    public ImageryInfo(String name, String url) {
        this(name);
        this.setExtendedUrl(url);
    }

    public ImageryInfo(String name, String url, String eulaAcceptanceRequired) {
        this(name);
        this.setExtendedUrl(url);
        this.eulaAcceptanceRequired = eulaAcceptanceRequired;
    }

    public ImageryInfo(String name, String url, String type, String eulaAcceptanceRequired, String cookies) {
        this(name);
        this.setExtendedUrl(url);
        ImageryType t = ImageryType.fromString(type);
        this.cookies = cookies;
        this.eulaAcceptanceRequired = eulaAcceptanceRequired;
        if (t != null) {
            this.sourceType = t;
        } else if (type != null && !type.isEmpty()) {
            throw new IllegalArgumentException("unknown type: " + type);
        }
    }

    public ImageryInfo(String name, String url, String type, String eulaAcceptanceRequired, String cookies, String id) {
        this(name, url, type, eulaAcceptanceRequired, cookies);
        this.setId(id);
    }

    public ImageryInfo(ImageryPreferenceEntry e) {
        super(e.name, e.url, e.id);
        CheckParameterUtil.ensureParameterNotNull(e.name, "name");
        CheckParameterUtil.ensureParameterNotNull(e.url, "url");
        this.description = e.description;
        this.cookies = e.cookies;
        this.eulaAcceptanceRequired = e.eula;
        this.sourceType = ImageryType.fromString(e.type);
        if (this.sourceType == null) {
            throw new IllegalArgumentException("unknown type");
        }
        this.pixelPerDegree = e.pixel_per_eastnorth;
        this.defaultMaxZoom = e.max_zoom;
        this.defaultMinZoom = e.min_zoom;
        if (e.bounds != null) {
            this.bounds = new ImageryBounds(e.bounds, ",");
            if (e.shapes != null) {
                try {
                    for (String s : e.shapes.split(";", -1)) {
                        ((ImageryBounds)this.bounds).addShape(new Shape(s, ","));
                    }
                }
                catch (IllegalArgumentException ex) {
                    Logging.warn(ex);
                }
            }
        }
        if (e.projections != null && !e.projections.isEmpty()) {
            this.setServerProjections(Arrays.asList(e.projections.split(",", -1)));
        }
        this.attributionText = Utils.intern(e.attribution_text);
        this.attributionLinkURL = e.attribution_url;
        this.permissionReferenceURL = e.permission_reference_url;
        this.attributionImage = e.logo_image;
        this.attributionImageURL = e.logo_url;
        this.date = e.date;
        this.bestMarked = e.bestMarked;
        this.overlay = e.overlay;
        this.termsOfUseText = e.terms_of_use_text;
        this.termsOfUseURL = e.terms_of_use_url;
        this.countryCode = Utils.intern(e.country_code);
        this.icon = Utils.intern(e.icon);
        if (e.noTileHeaders != null) {
            this.noTileHeaders = e.noTileHeaders.toMap();
        }
        if (e.noTileChecksums != null) {
            this.noTileChecksums = e.noTileChecksums.toMap();
        }
        this.setTileSize(e.tileSize);
        this.metadataHeaders = e.metadataHeaders;
        this.isGeoreferenceValid = e.valid_georeference;
        this.modTileFeatures = e.modTileFeatures;
        if (e.default_layers != null) {
            try (JsonReader jsonReader = Json.createReader(new StringReader(e.default_layers));){
                this.defaultLayers = jsonReader.readArray().stream().map(x -> DefaultLayer.fromJson((JsonObject)x, (ImageryType)this.sourceType)).collect(Collectors.toList());
            }
        }
        this.setCustomHttpHeaders(e.customHttpHeaders);
        this.transparent = e.transparent;
        this.minimumTileExpire = e.minimumTileExpire;
        this.category = ImageryCategory.fromString(e.category);
    }

    public ImageryInfo(ImageryInfo i) {
        super(i.name, i.url, i.id);
        this.noTileHeaders = i.noTileHeaders;
        this.noTileChecksums = i.noTileChecksums;
        this.minZoom = i.minZoom;
        this.maxZoom = i.maxZoom;
        this.cookies = i.cookies;
        this.tileSize = i.tileSize;
        this.metadataHeaders = i.metadataHeaders;
        this.modTileFeatures = i.modTileFeatures;
        this.origName = i.origName;
        this.langName = i.langName;
        this.defaultEntry = i.defaultEntry;
        this.eulaAcceptanceRequired = null;
        this.sourceType = i.sourceType;
        this.pixelPerDegree = i.pixelPerDegree;
        this.defaultMaxZoom = i.defaultMaxZoom;
        this.defaultMinZoom = i.defaultMinZoom;
        this.bounds = i.bounds;
        this.serverProjections = i.serverProjections;
        this.description = i.description;
        this.langDescription = i.langDescription;
        this.attributionText = i.attributionText;
        this.privacyPolicyURL = i.privacyPolicyURL;
        this.permissionReferenceURL = i.permissionReferenceURL;
        this.attributionLinkURL = i.attributionLinkURL;
        this.attributionImage = i.attributionImage;
        this.attributionImageURL = i.attributionImageURL;
        this.termsOfUseText = i.termsOfUseText;
        this.termsOfUseURL = i.termsOfUseURL;
        this.countryCode = i.countryCode;
        this.date = i.date;
        this.bestMarked = i.bestMarked;
        this.overlay = i.overlay;
        this.icon = Utils.intern(i.icon);
        this.isGeoreferenceValid = i.isGeoreferenceValid;
        this.setDefaultLayers(i.defaultLayers);
        this.setCustomHttpHeaders(i.customHttpHeaders);
        this.transparent = i.transparent;
        this.minimumTileExpire = i.minimumTileExpire;
        this.categoryOriginalString = Utils.intern(i.categoryOriginalString);
        this.category = i.category;
    }

    public void addMirror(ImageryInfo entry) {
        if (this.mirrors == null) {
            this.mirrors = new ArrayList<ImageryInfo>();
        }
        this.mirrors.add(entry);
    }

    public List<ImageryInfo> getMirrors() {
        ArrayList<ImageryInfo> l = new ArrayList<ImageryInfo>();
        if (this.mirrors != null) {
            int num = 1;
            for (ImageryInfo i : this.mirrors) {
                ImageryInfo n = new ImageryInfo(this);
                if (i.defaultMaxZoom != 0) {
                    n.defaultMaxZoom = i.defaultMaxZoom;
                }
                if (i.defaultMinZoom != 0) {
                    n.defaultMinZoom = i.defaultMinZoom;
                }
                n.setServerProjections(i.getServerProjections());
                n.url = i.url;
                n.sourceType = i.sourceType;
                if (i.getTileSize() != 0) {
                    n.setTileSize(i.getTileSize());
                }
                if (i.getPrivacyPolicyURL() != null) {
                    n.setPrivacyPolicyURL(i.getPrivacyPolicyURL());
                }
                if (n.id != null) {
                    n.id = n.id + "_mirror" + num;
                }
                if (num > 1) {
                    n.name = I18n.tr("{0} mirror server {1}", n.name, num);
                    if (n.origName != null) {
                        n.origName = n.origName + " mirror server " + num;
                    }
                } else {
                    n.name = I18n.tr("{0} mirror server", n.name);
                    if (n.origName != null) {
                        n.origName = n.origName + " mirror server";
                    }
                }
                l.add(n);
                ++num;
            }
        }
        return l;
    }

    @Override
    public boolean equalsPref(SourceInfo<ImageryCategory, ImageryType, ImageryBounds, ImageryPreferenceEntry> other) {
        if (!(other instanceof ImageryInfo)) {
            return false;
        }
        ImageryInfo realOther = (ImageryInfo)other;
        return super.equalsPref(realOther) && this.bestMarked == realOther.bestMarked && this.overlay == realOther.overlay && this.isGeoreferenceValid == realOther.isGeoreferenceValid && this.defaultMaxZoom == realOther.defaultMaxZoom && this.defaultMinZoom == realOther.defaultMinZoom && Objects.equals(this.serverProjections, realOther.serverProjections) && this.transparent == realOther.transparent && this.minimumTileExpire == realOther.minimumTileExpire;
    }

    @Override
    public int compareTo(SourceInfo<ImageryCategory, ImageryType, ImageryBounds, ImageryPreferenceEntry> other) {
        int i = super.compareTo(other);
        if (other instanceof ImageryInfo) {
            ImageryInfo in = (ImageryInfo)other;
            if (i == 0) {
                i = Double.compare(this.pixelPerDegree, in.pixelPerDegree);
            }
        }
        return i;
    }

    public void setPixelPerDegree(double ppd) {
        this.pixelPerDegree = ppd;
    }

    public void setDefaultMaxZoom(int defaultMaxZoom) {
        this.defaultMaxZoom = defaultMaxZoom;
    }

    public void setDefaultMinZoom(int defaultMinZoom) {
        this.defaultMinZoom = defaultMinZoom;
    }

    @Override
    public void setBounds(ImageryBounds b) {
        this.bounds = b;
    }

    @Override
    public ImageryBounds getBounds() {
        return (ImageryBounds)super.getBounds();
    }

    public void setExtendedUrl(String url) {
        Matcher m;
        CheckParameterUtil.ensureParameterNotNull(url);
        this.url = url;
        this.sourceType = ImageryType.WMS;
        this.defaultMaxZoom = 0;
        this.defaultMinZoom = 0;
        for (ImageryType type : ImageryType.values()) {
            Matcher m2 = Pattern.compile(type.getTypeString() + "(?:\\[(?:(\\d+)[,-])?(\\d+)\\])?:(.*)").matcher(url);
            if (!m2.matches()) continue;
            this.url = m2.group(3);
            this.sourceType = type;
            if (m2.group(2) != null) {
                this.defaultMaxZoom = Integer.parseInt(m2.group(2));
            }
            if (m2.group(1) == null) break;
            this.defaultMinZoom = Integer.parseInt(m2.group(1));
            break;
        }
        if (this.serverProjections.isEmpty() && (m = Pattern.compile(".*\\{PROJ\\(([^)}]+)\\)\\}.*").matcher(url.toUpperCase(Locale.ENGLISH))).matches()) {
            this.setServerProjections(Arrays.asList(m.group(1).split(",", -1)));
        }
    }

    public double getPixelPerDegree() {
        return this.pixelPerDegree;
    }

    @Override
    public int getMaxZoom() {
        return this.defaultMaxZoom;
    }

    @Override
    public int getMinZoom() {
        return this.defaultMinZoom;
    }

    @Override
    public String getToolTipText() {
        String desc;
        StringBuilder res = new StringBuilder(this.getName());
        boolean html = false;
        String dateStr = this.getDate();
        if (dateStr != null && !dateStr.isEmpty()) {
            res.append("<br>").append(I18n.tr("Date of imagery: {0}", dateStr));
            html = true;
        }
        if (this.category != null && ((ImageryCategory)this.category).getDescription() != null) {
            res.append("<br>").append(I18n.tr("Imagery category: {0}", ((ImageryCategory)this.category).getDescription()));
            html = true;
        }
        if (this.bestMarked) {
            res.append("<br>").append(I18n.tr("This imagery is marked as best in this region in other editors.", new Object[0]));
            html = true;
        }
        if (this.overlay) {
            res.append("<br>").append(I18n.tr("This imagery is an overlay.", new Object[0]));
            html = true;
        }
        if ((desc = this.getDescription()) != null && !desc.isEmpty()) {
            res.append("<br>").append(Utils.escapeReservedCharactersHTML(desc));
            html = true;
        }
        if (html) {
            res.insert(0, "<html>").append("</html>");
        }
        return res.toString();
    }

    public List<String> getServerProjections() {
        return Collections.unmodifiableList(this.serverProjections);
    }

    public void setServerProjections(Collection<String> serverProjections) {
        CheckParameterUtil.ensureParameterNotNull(serverProjections, "serverProjections");
        this.serverProjections = serverProjections.stream().map(String::intern).collect(StreamUtils.toUnmodifiableList());
    }

    public String getExtendedUrl() {
        return ((ImageryType)this.sourceType).getTypeString() + (this.defaultMaxZoom != 0 ? '[' + (this.defaultMinZoom != 0 ? Integer.toString(this.defaultMinZoom) + ',' : "") + this.defaultMaxZoom + ']' : "") + ':' + this.url;
    }

    public String getToolbarName() {
        String res = this.name;
        if (this.pixelPerDegree != 0.0) {
            res = res + "#PPD=" + this.pixelPerDegree;
        }
        return res;
    }

    public String getMenuName() {
        String res = this.name;
        if (this.pixelPerDegree != 0.0) {
            res = res + " (" + this.pixelPerDegree + ')';
        }
        return res;
    }

    public ImageryType getImageryType() {
        return super.getSourceType() != null ? (ImageryType)super.getSourceType() : ImageryType.WMS.getDefault();
    }

    public void setImageryType(ImageryType imageryType) {
        super.setSourceType(imageryType);
    }

    public ImageryCategory getImageryCategory() {
        return (ImageryCategory)super.getSourceCategory();
    }

    public void setImageryCategory(ImageryCategory category) {
        super.setSourceCategory(category);
    }

    public String getImageryCategoryOriginalString() {
        return super.getSourceCategoryOriginalString();
    }

    public void setImageryCategoryOriginalString(String categoryOriginalString) {
        super.setSourceCategoryOriginalString(categoryOriginalString);
    }

    public boolean isGeoreferenceValid() {
        return this.isGeoreferenceValid;
    }

    public void setGeoreferenceValid(boolean isGeoreferenceValid) {
        this.isGeoreferenceValid = isGeoreferenceValid;
    }

    public boolean isBestMarked() {
        return this.bestMarked;
    }

    public boolean isOverlay() {
        return this.overlay;
    }

    public void setBestMarked(boolean bestMarked) {
        this.bestMarked = bestMarked;
    }

    public void setOverlay(boolean overlay) {
        this.overlay = overlay;
    }

    public boolean isTransparent() {
        return this.transparent;
    }

    public void setTransparent(boolean transparent) {
        this.transparent = transparent;
    }

    public int getMinimumTileExpire() {
        return this.minimumTileExpire;
    }

    public void setMinimumTileExpire(int minimumTileExpire) {
        this.minimumTileExpire = minimumTileExpire;
    }

    public String getSourceName() {
        Optional<ImageryInfo> infoEn;
        if (ImageryType.BING == this.getImageryType()) {
            return "Bing";
        }
        if (this.id != null && (infoEn = ImageryLayerInfo.allDefaultLayers.stream().filter(x -> this.id.equals(x.getId())).findAny()).isPresent()) {
            return infoEn.get().getOriginalName();
        }
        return this.getOriginalName();
    }

    public static Collection<String> getActiveIds() {
        return ImageryInfo.getActiveIds(ImageryInfo.class);
    }

    public static class ImageryPreferenceEntry
    extends SourcePreferenceEntry<ImageryInfo> {
        @StructUtils.StructEntry
        String d;
        @StructUtils.StructEntry
        double pixel_per_eastnorth;
        @StructUtils.StructEntry
        int max_zoom;
        @StructUtils.StructEntry
        int min_zoom;
        @StructUtils.StructEntry
        String projections;
        @StructUtils.StructEntry
        MultiMap<String, String> noTileHeaders;
        @StructUtils.StructEntry
        MultiMap<String, String> noTileChecksums;
        @StructUtils.StructEntry
        int tileSize = -1;
        @StructUtils.StructEntry
        Map<String, String> metadataHeaders;
        @StructUtils.StructEntry
        boolean valid_georeference;
        @StructUtils.StructEntry
        boolean bestMarked;
        @StructUtils.StructEntry
        boolean modTileFeatures;
        @StructUtils.StructEntry
        boolean overlay;
        @StructUtils.StructEntry
        boolean transparent;
        @StructUtils.StructEntry
        int minimumTileExpire;

        public ImageryPreferenceEntry() {
        }

        public ImageryPreferenceEntry(ImageryInfo i) {
            super(i);
            this.pixel_per_eastnorth = i.pixelPerDegree;
            this.bestMarked = i.bestMarked;
            this.overlay = i.overlay;
            this.max_zoom = i.defaultMaxZoom;
            this.min_zoom = i.defaultMinZoom;
            if (!i.serverProjections.isEmpty()) {
                this.projections = String.join((CharSequence)",", i.serverProjections);
            }
            if (i.noTileHeaders != null && !i.noTileHeaders.isEmpty()) {
                this.noTileHeaders = new MultiMap(i.noTileHeaders);
            }
            if (i.noTileChecksums != null && !i.noTileChecksums.isEmpty()) {
                this.noTileChecksums = new MultiMap(i.noTileChecksums);
            }
            if (i.metadataHeaders != null && !i.metadataHeaders.isEmpty()) {
                this.metadataHeaders = i.metadataHeaders;
            }
            this.tileSize = i.getTileSize();
            this.valid_georeference = i.isGeoreferenceValid();
            this.modTileFeatures = i.isModTileFeatures();
            this.transparent = i.isTransparent();
            this.minimumTileExpire = i.minimumTileExpire;
        }

        @Override
        public String toString() {
            StringBuilder s = new StringBuilder("ImageryPreferenceEntry [name=").append(this.name);
            if (this.id != null) {
                s.append(" id=").append(this.id);
            }
            s.append(']');
            return s.toString();
        }
    }

    public static class ImageryBounds
    extends SourceBounds {
        public ImageryBounds(String asString, String separator) {
            super(asString, separator);
        }
    }

    public static enum ImageryCategory implements ISourceCategory<ImageryCategory>
    {
        PHOTO("photo", I18n.tr("Aerial or satellite photo", new Object[0])),
        ELEVATION("elevation", I18n.tr("Elevation map", new Object[0])),
        MAP("map", I18n.tr("Map", new Object[0])),
        HISTORICMAP("historicmap", I18n.tr("Historic or otherwise outdated map", new Object[0])),
        OSMBASEDMAP("osmbasedmap", I18n.tr("Map based on OSM data", new Object[0])),
        HISTORICPHOTO("historicphoto", I18n.tr("Historic or otherwise outdated aerial or satellite photo", new Object[0])),
        QUALITY_ASSURANCE("qa", I18n.tr("Map for quality assurance", new Object[0])),
        OTHER("other", I18n.tr("Imagery not matching any other category", new Object[0]));

        private final String category;
        private final String description;
        private static final Map<ImageProvider.ImageSizes, Map<ImageryCategory, ImageIcon>> iconCache;

        private ImageryCategory(String category, String description) {
            this.category = category;
            this.description = description;
        }

        @Override
        public final String getCategoryString() {
            return this.category;
        }

        @Override
        public final String getDescription() {
            return this.description;
        }

        @Override
        public final ImageIcon getIcon(ImageProvider.ImageSizes size) {
            return iconCache.computeIfAbsent(size, x -> Collections.synchronizedMap(new EnumMap(ImageryCategory.class))).computeIfAbsent(this, x -> ImageProvider.get("data/imagery", x.category, size));
        }

        public static ImageryCategory fromString(String s) {
            return Arrays.stream(ImageryCategory.values()).filter(category -> category.getCategoryString().equals(s)).findFirst().orElse(null);
        }

        @Override
        public ImageryCategory getDefault() {
            return OTHER;
        }

        @Override
        public ImageryCategory getFromString(String s) {
            return ImageryCategory.fromString(s);
        }

        static {
            iconCache = Collections.synchronizedMap(new EnumMap(ImageProvider.ImageSizes.class));
        }
    }

    public static enum ImageryType implements ISourceType<ImageryType>
    {
        WMS("wms"),
        TMS("tms"),
        BING("bing"),
        SCANEX("scanex"),
        WMS_ENDPOINT("wms_endpoint"),
        WMTS("wmts");

        private final String typeString;

        private ImageryType(String typeString) {
            this.typeString = typeString;
        }

        @Override
        public final String getTypeString() {
            return this.typeString;
        }

        public static ImageryType fromString(String s) {
            return Arrays.stream(ImageryType.values()).filter(type -> type.getTypeString().equals(s)).findFirst().orElse(null);
        }

        @Override
        public ImageryType getFromString(String s) {
            return ImageryType.fromString(s);
        }

        @Override
        public ImageryType getDefault() {
            return WMS;
        }
    }
}

