/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.tagging.presets;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Tag;
import org.openstreetmap.josm.data.osm.search.SearchCompiler;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPresetItem;
import org.openstreetmap.josm.gui.tagging.presets.items.KeyedItem;
import org.openstreetmap.josm.tools.ListenerList;
import org.openstreetmap.josm.tools.template_engine.TemplateEngineDataProvider;

public final class TaggingPresetItemGuiSupport
implements TemplateEngineDataProvider {
    private final Collection<OsmPrimitive> selected;
    private final boolean presetInitiallyMatches;
    private final Supplier<Collection<Tag>> changedTagsSupplier;
    private final ListenerList<ChangeListener> listeners = ListenerList.create();

    private TaggingPresetItemGuiSupport(boolean presetInitiallyMatches, Collection<OsmPrimitive> selected, Supplier<Collection<Tag>> changedTagsSupplier) {
        this.selected = selected;
        this.presetInitiallyMatches = presetInitiallyMatches;
        this.changedTagsSupplier = changedTagsSupplier;
    }

    public Collection<OsmPrimitive> getSelected() {
        return this.selected;
    }

    public boolean isPresetInitiallyMatches() {
        return this.presetInitiallyMatches;
    }

    public static TaggingPresetItemGuiSupport create(boolean presetInitiallyMatches, Collection<OsmPrimitive> selected, Supplier<Collection<Tag>> changedTagsSupplier) {
        return new TaggingPresetItemGuiSupport(presetInitiallyMatches, selected, changedTagsSupplier);
    }

    public static TaggingPresetItemGuiSupport create(boolean presetInitiallyMatches, OsmPrimitive ... selected) {
        return new TaggingPresetItemGuiSupport(presetInitiallyMatches, Arrays.asList(selected), Collections::emptyList);
    }

    @Override
    public Collection<String> getTemplateKeys() {
        return this.changedTagsSupplier.get().stream().map(Tag::getKey).collect(Collectors.toList());
    }

    @Override
    public Object getTemplateValue(String key, boolean special) {
        return this.changedTagsSupplier.get().stream().filter(tag -> key.equals(tag.getKey())).findFirst().map(Tag::getValue).orElseGet(() -> {
            KeyedItem.Usage usage = KeyedItem.determineTextUsage(this.getSelected(), key);
            return usage.hasUniqueValue() ? usage.getFirst() : null;
        });
    }

    @Override
    public boolean evaluateCondition(SearchCompiler.Match condition) {
        throw new UnsupportedOperationException();
    }

    public void addListener(ChangeListener listener) {
        this.listeners.addListener(listener);
    }

    public void fireItemValueModified(TaggingPresetItem source, String key, String newValue) {
        this.listeners.fireEvent(e -> e.itemValueModified(source, key, newValue));
    }

    public static interface ChangeListener {
        public void itemValueModified(TaggingPresetItem var1, String var2, String var3);
    }
}

