/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.socket;

import java.io.IOException;
import org.jruby.Ruby;
import org.jruby.ext.socket.Addrinfo;
import org.jruby.ext.socket.Ifaddr;
import org.jruby.ext.socket.Option;
import org.jruby.ext.socket.RubyBasicSocket;
import org.jruby.ext.socket.RubyIPSocket;
import org.jruby.ext.socket.RubyServerSocket;
import org.jruby.ext.socket.RubySocket;
import org.jruby.ext.socket.RubyTCPServer;
import org.jruby.ext.socket.RubyTCPSocket;
import org.jruby.ext.socket.RubyUDPSocket;
import org.jruby.ext.socket.RubyUNIXServer;
import org.jruby.ext.socket.RubyUNIXSocket;
import org.jruby.platform.Platform;
import org.jruby.runtime.load.Library;

public class SocketLibrary
implements Library {
    @Override
    public void load(Ruby runtime2, boolean wrap2) throws IOException {
        runtime2.defineClass("SocketError", runtime2.getStandardError(), runtime2.getStandardError().getAllocator());
        RubyBasicSocket.createBasicSocket(runtime2);
        RubySocket.createSocket(runtime2);
        RubyServerSocket.createServerSocket(runtime2);
        if (runtime2.getInstanceConfig().isNativeEnabled() && !Platform.IS_WINDOWS) {
            RubyUNIXSocket.createUNIXSocket(runtime2);
            RubyUNIXServer.createUNIXServer(runtime2);
        }
        RubyIPSocket.createIPSocket(runtime2);
        RubyTCPSocket.createTCPSocket(runtime2);
        RubyTCPServer.createTCPServer(runtime2);
        RubyUDPSocket.createUDPSocket(runtime2);
        Addrinfo.createAddrinfo(runtime2);
        Option.createOption(runtime2);
        Ifaddr.createIfaddr(runtime2);
    }
}

