/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.common.arguments;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.arguments.ArgumentParseErrors;
import org.jetbrains.kotlin.cli.common.arguments.InternalArgument;
import org.jetbrains.kotlin.cli.common.arguments.InternalArgumentParser;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0005H\u0016J\u001f\u0010\u000b\u001a\u0004\u0018\u00018\u00002\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\rH\u0016\u00a2\u0006\u0002\u0010\u000eJ'\u0010\u000f\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\rH&\u00a2\u0006\u0002\u0010\u0012R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/cli/common/arguments/AbstractInternalArgumentParser;", "A", "Lorg/jetbrains/kotlin/cli/common/arguments/InternalArgument;", "Lorg/jetbrains/kotlin/cli/common/arguments/InternalArgumentParser;", "familyName", "", "(Ljava/lang/String;)V", "wholePrefix", "canParse", "", "arg", "parseInternalArgument", "errors", "Lorg/jetbrains/kotlin/cli/common/arguments/ArgumentParseErrors;", "(Ljava/lang/String;Lorg/jetbrains/kotlin/cli/common/arguments/ArgumentParseErrors;)Lorg/jetbrains/kotlin/cli/common/arguments/InternalArgument;", "parseTail", "tail", "wholeArgument", "(Ljava/lang/String;Ljava/lang/String;Lorg/jetbrains/kotlin/cli/common/arguments/ArgumentParseErrors;)Lorg/jetbrains/kotlin/cli/common/arguments/InternalArgument;", "cli-common"})
public abstract class AbstractInternalArgumentParser<A extends InternalArgument>
implements InternalArgumentParser<A> {
    @NotNull
    private final String wholePrefix;

    public AbstractInternalArgumentParser(@NotNull String familyName) {
        Intrinsics.checkNotNullParameter(familyName, "familyName");
        this.wholePrefix = Intrinsics.stringPlus("-XX", familyName);
    }

    @Override
    public boolean canParse(@NotNull String arg) {
        Intrinsics.checkNotNullParameter(arg, "arg");
        return StringsKt.startsWith$default(arg, this.wholePrefix, false, 2, null);
    }

    @Override
    @Nullable
    public A parseInternalArgument(@NotNull String arg, @NotNull ArgumentParseErrors errors) {
        Intrinsics.checkNotNullParameter(arg, "arg");
        Intrinsics.checkNotNullParameter(errors, "errors");
        if (!StringsKt.startsWith$default(arg, this.wholePrefix, false, 2, null)) {
            return null;
        }
        return this.parseTail(StringsKt.removePrefix(arg, (CharSequence)this.wholePrefix), arg, errors);
    }

    @Nullable
    public abstract A parseTail(@NotNull String var1, @NotNull String var2, @NotNull ArgumentParseErrors var3);
}

