/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.calls;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirNamedArgumentExpression;
import org.jetbrains.kotlin.fir.expressions.FirSpreadArgumentExpression;
import org.jetbrains.kotlin.fir.resolve.BodyResolveComponents;
import org.jetbrains.kotlin.fir.resolve.FirDefaultParametersResolverKt;
import org.jetbrains.kotlin.fir.resolve.calls.ArgumentPassedTwice;
import org.jetbrains.kotlin.fir.resolve.calls.MixingNamedAndPositionArguments;
import org.jetbrains.kotlin.fir.resolve.calls.NameNotFound;
import org.jetbrains.kotlin.fir.resolve.calls.NamedArgumentNotAllowed;
import org.jetbrains.kotlin.fir.resolve.calls.NoValueForParameter;
import org.jetbrains.kotlin.fir.resolve.calls.NonVarargSpread;
import org.jetbrains.kotlin.fir.resolve.calls.ResolutionDiagnostic;
import org.jetbrains.kotlin.fir.resolve.calls.ResolvedCallArgument;
import org.jetbrains.kotlin.fir.resolve.calls.TooManyArguments;
import org.jetbrains.kotlin.fir.resolve.calls.VarargArgumentOutsideParentheses;
import org.jetbrains.kotlin.fir.scopes.FirScope;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0010\b\u0002\u0018\u00002\u00020\u0001:\u0001;B#\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020\rH\u0002J\u0010\u0010.\u001a\u00020,2\u0006\u0010/\u001a\u00020!H\u0002J\b\u00100\u001a\u00020,H\u0002J\u001a\u00101\u001a\u0004\u0018\u00010\u00142\u0006\u0010/\u001a\u00020!2\u0006\u00102\u001a\u00020\u0013H\u0002J\u0012\u00103\u001a\u0004\u0018\u00010\u00142\u0006\u00102\u001a\u00020\u0013H\u0002J\u0014\u00104\u001a\u00020,2\f\u00105\u001a\b\u0012\u0004\u0012\u00020!0\u0016J\u0006\u00106\u001a\u00020,J\u000e\u00107\u001a\u00020,2\u0006\u00108\u001a\u00020!J\u0018\u00109\u001a\u00020,2\u0006\u0010/\u001a\u00020!2\u0006\u00102\u001a\u00020\u0013H\u0002J\u0010\u0010:\u001a\u00020&2\u0006\u0010/\u001a\u00020!H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R.\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\f2\u000e\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0012\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00140\u00168BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0010R-\u0010\u0018\u001a\u001e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u001a0\u0019j\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u001a`\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010 \u001a\n\u0012\u0004\u0012\u00020!\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\"\u001a\u0004\u0018\u00010\u0013*\u00020!8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R\u001c\u0010%\u001a\u00020&*\u0006\u0012\u0002\b\u00030\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010(R\u0018\u0010)\u001a\u00020&*\u00020!8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010*\u00a8\u0006<"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/calls/FirCallArgumentsProcessor;", "", "function", "Lorg/jetbrains/kotlin/fir/declarations/FirFunction;", "bodyResolveComponents", "Lorg/jetbrains/kotlin/fir/resolve/BodyResolveComponents;", "originScope", "Lorg/jetbrains/kotlin/fir/scopes/FirScope;", "(Lorg/jetbrains/kotlin/fir/declarations/FirFunction;Lorg/jetbrains/kotlin/fir/resolve/BodyResolveComponents;Lorg/jetbrains/kotlin/fir/scopes/FirScope;)V", "currentPositionedParameterIndex", "", "<set-?>", "", "Lorg/jetbrains/kotlin/fir/resolve/calls/ResolutionDiagnostic;", "diagnostics", "getDiagnostics", "()Ljava/util/List;", "nameToParameter", "", "Lorg/jetbrains/kotlin/name/Name;", "Lorg/jetbrains/kotlin/fir/declarations/FirValueParameter;", "parameters", "", "getParameters", "result", "Ljava/util/LinkedHashMap;", "Lorg/jetbrains/kotlin/fir/resolve/calls/ResolvedCallArgument;", "Lkotlin/collections/LinkedHashMap;", "getResult", "()Ljava/util/LinkedHashMap;", "state", "Lorg/jetbrains/kotlin/fir/resolve/calls/FirCallArgumentsProcessor$State;", "varargArguments", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "argumentName", "getArgumentName", "(Lorg/jetbrains/kotlin/fir/expressions/FirExpression;)Lorg/jetbrains/kotlin/name/Name;", "hasStableParameterNames", "", "getHasStableParameterNames", "(Lorg/jetbrains/kotlin/fir/declarations/FirFunction;)Z", "isSpread", "(Lorg/jetbrains/kotlin/fir/expressions/FirExpression;)Z", "addDiagnostic", "", "diagnostic", "addVarargArgument", "argument", "completeVarargPositionArguments", "findParameterByName", "name", "getParameterByName", "processArgumentsInParenthesis", "arguments", "processDefaultsAndRunChecks", "processExternalArgument", "externalArgument", "processNamedArgument", "processPositionArgument", "State", "resolve"})
final class FirCallArgumentsProcessor {
    @NotNull
    private final FirFunction<?> function;
    @NotNull
    private final BodyResolveComponents bodyResolveComponents;
    @Nullable
    private final FirScope originScope;
    @NotNull
    private State state;
    private int currentPositionedParameterIndex;
    @Nullable
    private List<FirExpression> varargArguments;
    @Nullable
    private Map<Name, ? extends FirValueParameter> nameToParameter;
    @Nullable
    private List<ResolutionDiagnostic> diagnostics;
    @NotNull
    private final LinkedHashMap<FirValueParameter, ResolvedCallArgument> result;

    public FirCallArgumentsProcessor(@NotNull FirFunction<?> function2, @NotNull BodyResolveComponents bodyResolveComponents, @Nullable FirScope originScope) {
        Intrinsics.checkNotNullParameter(function2, "function");
        Intrinsics.checkNotNullParameter(bodyResolveComponents, "bodyResolveComponents");
        this.function = function2;
        this.bodyResolveComponents = bodyResolveComponents;
        this.originScope = originScope;
        this.state = State.POSITION_ARGUMENTS;
        this.result = new LinkedHashMap(this.function.getValueParameters().size());
    }

    @Nullable
    public final List<ResolutionDiagnostic> getDiagnostics() {
        return this.diagnostics;
    }

    @NotNull
    public final LinkedHashMap<FirValueParameter, ResolvedCallArgument> getResult() {
        return this.result;
    }

    public final void processArgumentsInParenthesis(@NotNull List<? extends FirExpression> arguments2) {
        Intrinsics.checkNotNullParameter(arguments2, "arguments");
        for (FirExpression firExpression2 : arguments2) {
            Name argumentName = this.getArgumentName(firExpression2);
            if (argumentName == null) {
                if (!this.processPositionArgument(firExpression2)) continue;
                this.state = State.VARARG_POSITION;
                continue;
            }
            if (this.state == State.VARARG_POSITION) {
                this.completeVarargPositionArguments();
            }
            this.processNamedArgument(firExpression2, argumentName);
        }
        if (this.state == State.VARARG_POSITION) {
            this.completeVarargPositionArguments();
        }
    }

    private final boolean processPositionArgument(FirExpression argument) {
        boolean bl;
        if (this.state == State.NAMED_ONLY_ARGUMENTS) {
            this.addDiagnostic(new MixingNamedAndPositionArguments(argument));
            return false;
        }
        FirValueParameter parameter = CollectionsKt.getOrNull(this.getParameters(), this.currentPositionedParameterIndex);
        if (parameter == null) {
            this.addDiagnostic(new TooManyArguments(argument, this.function));
            return false;
        }
        if (!parameter.isVararg()) {
            Object object = this;
            int n = ((FirCallArgumentsProcessor)object).currentPositionedParameterIndex;
            ((FirCallArgumentsProcessor)object).currentPositionedParameterIndex = n + 1;
            object = this.result;
            ResolvedCallArgument.SimpleArgument simpleArgument = new ResolvedCallArgument.SimpleArgument(argument);
            boolean bl2 = false;
            object.put(parameter, simpleArgument);
            bl = false;
        } else {
            this.addVarargArgument(argument);
            bl = true;
        }
        return bl;
    }

    private final void processNamedArgument(FirExpression argument, Name name) {
        if (!this.getHasStableParameterNames(this.function)) {
            this.addDiagnostic(new NamedArgumentNotAllowed(argument, this.function));
        }
        boolean stateAllowsMixedNamedAndPositionArguments = this.state != State.NAMED_ONLY_ARGUMENTS;
        this.state = State.NAMED_ONLY_ARGUMENTS;
        Object object = this.findParameterByName(argument, name);
        if (object == null) {
            return;
        }
        Object parameter = object;
        if ((object = this.result.get(parameter)) != null) {
            Object object2 = object;
            boolean bl = false;
            boolean bl2 = false;
            Object it = object2;
            boolean bl3 = false;
            this.addDiagnostic(new ArgumentPassedTwice(argument, (FirValueParameter)parameter, (ResolvedCallArgument)it));
            return;
        }
        object = this.result;
        ResolvedCallArgument.SimpleArgument simpleArgument = new ResolvedCallArgument.SimpleArgument(argument);
        boolean bl = false;
        object.put(parameter, simpleArgument);
        if (stateAllowsMixedNamedAndPositionArguments && Intrinsics.areEqual(CollectionsKt.getOrNull(this.getParameters(), this.currentPositionedParameterIndex), parameter)) {
            this.state = State.POSITION_ARGUMENTS;
            object = this;
            int n = ((FirCallArgumentsProcessor)object).currentPositionedParameterIndex;
            ((FirCallArgumentsProcessor)object).currentPositionedParameterIndex = n + 1;
        }
    }

    public final void processExternalArgument(@NotNull FirExpression externalArgument) {
        Intrinsics.checkNotNullParameter(externalArgument, "externalArgument");
        FirValueParameter lastParameter = CollectionsKt.lastOrNull(this.getParameters());
        if (lastParameter == null) {
            this.addDiagnostic(new TooManyArguments(externalArgument, this.function));
            return;
        }
        if (lastParameter.isVararg()) {
            this.addDiagnostic(new VarargArgumentOutsideParentheses(externalArgument, lastParameter));
            return;
        }
        ResolvedCallArgument previousOccurrence = this.result.get(lastParameter);
        if (previousOccurrence != null) {
            this.addDiagnostic(new TooManyArguments(externalArgument, this.function));
            return;
        }
        Map map = this.result;
        ResolvedCallArgument.SimpleArgument simpleArgument = new ResolvedCallArgument.SimpleArgument(externalArgument);
        boolean bl = false;
        map.put(lastParameter, simpleArgument);
    }

    public final void processDefaultsAndRunChecks() {
        Object object;
        Object object2 = this.result;
        boolean bl = false;
        Iterator<Object> iterator2 = object2.entrySet().iterator();
        while (iterator2.hasNext()) {
            Object object3 = object2 = iterator2.next();
            boolean bl2 = false;
            FirValueParameter parameter = (FirValueParameter)object3.getKey();
            object = object2;
            boolean bl3 = false;
            ResolvedCallArgument resolvedArgument = (ResolvedCallArgument)object.getValue();
            if (parameter.isVararg()) continue;
            if (!(resolvedArgument instanceof ResolvedCallArgument.SimpleArgument)) {
                object = "Incorrect resolved argument for parameter " + parameter + " :" + resolvedArgument;
                bl3 = false;
                throw (Throwable)new IllegalStateException(object.toString());
            }
            if (!this.isSpread(((ResolvedCallArgument.SimpleArgument)resolvedArgument).getCallArgument())) continue;
            this.addDiagnostic(new NonVarargSpread(((ResolvedCallArgument.SimpleArgument)resolvedArgument).getCallArgument()));
        }
        iterator2 = this.getParameters().iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            boolean bl4;
            ResolvedCallArgument resolvedCallArgument;
            int index2 = n++;
            FirValueParameter parameter = (FirValueParameter)iterator2.next();
            if (this.result.containsKey(parameter)) continue;
            if (FirDefaultParametersResolverKt.getDefaultParameterResolver(this.bodyResolveComponents.getSession()).declaresDefaultValue(parameter, this.function, this.originScope, index2)) {
                object = this.result;
                resolvedCallArgument = ResolvedCallArgument.DefaultArgument.INSTANCE;
                bl4 = false;
                object.put(parameter, resolvedCallArgument);
                continue;
            }
            if (parameter.isVararg()) {
                object = this.result;
                resolvedCallArgument = new ResolvedCallArgument.VarargArgument(CollectionsKt.emptyList());
                bl4 = false;
                object.put(parameter, resolvedCallArgument);
                continue;
            }
            this.addDiagnostic(new NoValueForParameter(parameter, this.function));
        }
    }

    private final void completeVarargPositionArguments() {
        boolean bl = this.state == State.VARARG_POSITION;
        boolean bl2 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string2 = Intrinsics.stringPlus("Incorrect state: ", (Object)this.state);
            throw (Throwable)((Object)new AssertionError((Object)string2));
        }
        FirValueParameter parameter = this.getParameters().get(this.currentPositionedParameterIndex);
        List<FirExpression> list2 = this.varargArguments;
        Intrinsics.checkNotNull(list2);
        this.result.put(parameter, new ResolvedCallArgument.VarargArgument(list2));
    }

    private final void addVarargArgument(FirExpression argument) {
        if (this.varargArguments == null) {
            this.varargArguments = new ArrayList();
        }
        List<FirExpression> list2 = this.varargArguments;
        Intrinsics.checkNotNull(list2);
        list2.add(argument);
    }

    /*
     * WARNING - void declaration
     */
    private final FirValueParameter getParameterByName(Name name) {
        Object object;
        if (this.nameToParameter == null) {
            Map map;
            void $this$associateByTo$iv$iv;
            void $this$associateBy$iv;
            object = this.getParameters();
            FirCallArgumentsProcessor firCallArgumentsProcessor = this;
            boolean $i$f$associateBy = false;
            int capacity$iv = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associateBy$iv, 10)), 16);
            void var5_6 = $this$associateBy$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                void it;
                FirValueParameter firValueParameter = (FirValueParameter)element$iv$iv;
                map = destination$iv$iv;
                boolean bl = false;
                Name name2 = it.getName();
                map.put(name2, element$iv$iv);
            }
            firCallArgumentsProcessor.nameToParameter = map = destination$iv$iv;
        }
        object = this.nameToParameter;
        Intrinsics.checkNotNull(object);
        return (FirValueParameter)object.get(name);
    }

    private final FirValueParameter findParameterByName(FirExpression argument, Name name) {
        FirValueParameter parameter = this.getParameterByName(name);
        if (parameter == null) {
            this.addDiagnostic(new NameNotFound(argument, this.function));
        }
        return parameter;
    }

    private final void addDiagnostic(ResolutionDiagnostic diagnostic) {
        if (this.diagnostics == null) {
            boolean bl = false;
            this.diagnostics = new ArrayList();
        }
        List<ResolutionDiagnostic> list2 = this.diagnostics;
        Intrinsics.checkNotNull(list2);
        list2.add(diagnostic);
    }

    private final boolean isSpread(FirExpression $this$isSpread) {
        return $this$isSpread instanceof FirSpreadArgumentExpression && ((FirSpreadArgumentExpression)$this$isSpread).isSpread();
    }

    private final List<FirValueParameter> getParameters() {
        return this.function.getValueParameters();
    }

    private final Name getArgumentName(FirExpression $this$argumentName) {
        FirNamedArgumentExpression firNamedArgumentExpression = $this$argumentName instanceof FirNamedArgumentExpression ? (FirNamedArgumentExpression)$this$argumentName : null;
        return firNamedArgumentExpression == null ? null : firNamedArgumentExpression.getName();
    }

    private final boolean getHasStableParameterNames(FirFunction<?> $this$hasStableParameterNames) {
        return true;
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/calls/FirCallArgumentsProcessor$State;", "", "(Ljava/lang/String;I)V", "POSITION_ARGUMENTS", "VARARG_POSITION", "NAMED_ONLY_ARGUMENTS", "resolve"})
    private static final class State
    extends Enum<State> {
        public static final /* enum */ State POSITION_ARGUMENTS = new State();
        public static final /* enum */ State VARARG_POSITION = new State();
        public static final /* enum */ State NAMED_ONLY_ARGUMENTS = new State();
        private static final /* synthetic */ State[] $VALUES;

        public static State[] values() {
            State[] stateArray = $VALUES;
            State[] stateArray2 = new State[stateArray.length];
            System.arraycopy(stateArray, 0, stateArray2, 0, stateArray.length);
            return stateArray2;
        }

        public static State valueOf(String value2) {
            Intrinsics.checkNotNullParameter(value2, "value");
            return Enum.valueOf(State.class, value2);
        }

        static {
            State[] stateArray = new State[]{POSITION_ARGUMENTS, VARARG_POSITION, NAMED_ONLY_ARGUMENTS};
            $VALUES = stateArray;
        }
    }
}

