/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.tilesfx.skins;

import eu.hansolo.tilesfx.Tile;
import eu.hansolo.tilesfx.fonts.Fonts;
import eu.hansolo.tilesfx.skins.TileSkin;
import eu.hansolo.tilesfx.tools.Helper;
import javafx.beans.value.ChangeListener;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.control.ScrollBar;
import javafx.scene.control.ScrollPane;
import javafx.scene.image.ImageView;
import javafx.scene.shape.Shape;
import javafx.scene.text.Font;
import javafx.scene.text.Text;

public class CustomScrollableTileSkin
extends TileSkin {
    private Text titleText;
    private Text text;
    private ScrollPane graphicContainer;
    private ChangeListener graphicListener;
    private ScrollBar verticalScrollBar;
    private double scrollBarWidth;

    public CustomScrollableTileSkin(Tile TILE) {
        super(TILE);
    }

    @Override
    protected void initGraphics() {
        super.initGraphics();
        this.graphicListener = (o, ov, nv) -> {
            if (nv != null) {
                this.graphicContainer.setContent(this.tile.getGraphic());
            }
        };
        this.scrollBarWidth = 0.0;
        this.titleText = new Text();
        this.titleText.setFill(this.tile.getTitleColor());
        Helper.enableNode(this.titleText, !this.tile.getTitle().isEmpty());
        this.text = new Text(this.tile.getText());
        this.text.setFill(this.tile.getTextColor());
        Helper.enableNode(this.text, this.tile.isTextVisible());
        this.graphicContainer = new ScrollPane();
        this.graphicContainer.getStyleClass().add("edge-to-edge");
        this.graphicContainer.setMinSize(this.size * 0.9, this.tile.isTextVisible() ? this.size * 0.72 : this.size * 0.795);
        this.graphicContainer.setMaxSize(this.size * 0.9, this.tile.isTextVisible() ? this.size * 0.72 : this.size * 0.795);
        this.graphicContainer.setPrefSize(this.size * 0.9, this.tile.isTextVisible() ? this.size * 0.72 : this.size * 0.795);
        this.graphicContainer.hbarPolicyProperty().setValue(ScrollPane.ScrollBarPolicy.AS_NEEDED);
        this.graphicContainer.vbarPolicyProperty().setValue(ScrollPane.ScrollBarPolicy.AS_NEEDED);
        this.graphicContainer.setFitToHeight(true);
        this.graphicContainer.setFitToWidth(true);
        if (null != this.tile.getGraphic()) {
            this.graphicContainer.setContent(this.tile.getGraphic());
        }
        this.getPane().getChildren().addAll((Node[])new Node[]{this.titleText, this.graphicContainer, this.text});
    }

    @Override
    protected void registerListeners() {
        super.registerListeners();
        this.tile.graphicProperty().addListener(this.graphicListener);
    }

    @Override
    protected void handleEvents(String EVENT_TYPE) {
        super.handleEvents(EVENT_TYPE);
        if ("VISIBILITY".equals(EVENT_TYPE)) {
            Helper.enableNode(this.titleText, !this.tile.getTitle().isEmpty());
            Helper.enableNode(this.text, this.tile.isTextVisible());
            this.graphicContainer.setMaxSize(this.size * 0.9, this.tile.isTextVisible() ? this.size * 0.68 : this.size * 0.795);
            this.graphicContainer.setPrefSize(this.size * 0.9, this.tile.isTextVisible() ? this.size * 0.68 : this.size * 0.795);
        } else if ("GRAPHIC".equals(EVENT_TYPE) && null != this.tile.getGraphic()) {
            this.graphicContainer.setContent(this.tile.getGraphic());
        }
    }

    @Override
    public void dispose() {
        this.tile.graphicProperty().removeListener(this.graphicListener);
        super.dispose();
    }

    @Override
    protected void resizeStaticText() {
        double maxWidth = this.width - this.size * 0.1;
        double fontSize = this.size * this.textSize.factor;
        boolean customFontEnabled = this.tile.isCustomFontEnabled();
        Font customFont = this.tile.getCustomFont();
        Font font = customFontEnabled && customFont != null ? Font.font(customFont.getFamily(), fontSize) : Fonts.latoRegular(fontSize);
        this.titleText.setFont(font);
        if (this.titleText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.titleText, maxWidth, fontSize);
        }
        switch (this.tile.getTitleAlignment()) {
            default: {
                this.titleText.relocate(this.size * 0.05, this.size * 0.05);
                break;
            }
            case CENTER: {
                this.titleText.relocate((this.width - this.titleText.getLayoutBounds().getWidth()) * 0.5, this.size * 0.05);
                break;
            }
            case RIGHT: {
                this.titleText.relocate(this.width - this.size * 0.05 - this.titleText.getLayoutBounds().getWidth(), this.size * 0.05);
            }
        }
        this.text.setFont(font);
        if (this.text.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.text, maxWidth, fontSize);
        }
        switch (this.tile.getTextAlignment()) {
            default: {
                this.text.setX(this.size * 0.05);
                break;
            }
            case CENTER: {
                this.text.setX((this.width - this.text.getLayoutBounds().getWidth()) * 0.5);
                break;
            }
            case RIGHT: {
                this.text.setX(this.width - this.size * 0.05 - this.text.getLayoutBounds().getWidth());
            }
        }
        this.text.setY(this.height - this.size * 0.05);
    }

    @Override
    protected void resize() {
        super.resize();
        this.width = this.tile.getWidth() - this.tile.getInsets().getLeft() - this.tile.getInsets().getRight();
        this.height = this.tile.getHeight() - this.tile.getInsets().getTop() - this.tile.getInsets().getBottom();
        this.size = this.width < this.height ? this.width : this.height;
        double containerWidth = this.contentBounds.getWidth();
        double containerHeight = this.contentBounds.getHeight();
        if (null == this.verticalScrollBar) {
            for (Node n : this.graphicContainer.lookupAll(".scroll-bar")) {
                ScrollBar bar;
                if (!(n instanceof ScrollBar) || !(bar = (ScrollBar)n).getOrientation().equals((Object)Orientation.VERTICAL)) continue;
                this.verticalScrollBar = bar;
                this.verticalScrollBar.visibleProperty().addListener((o, ov, nv) -> {
                    if (nv.booleanValue()) {
                        this.scrollBarWidth = this.verticalScrollBar.getLayoutBounds().getWidth();
                    }
                });
                break;
            }
        } else if (this.verticalScrollBar.isVisible()) {
            this.contentBounds.setWidth(this.contentBounds.getWidth() - this.scrollBarWidth);
        } else {
            this.contentBounds.setWidth(this.contentBounds.getWidth() + this.scrollBarWidth);
        }
        if (this.tile.isShowing() && this.width > 0.0 && this.height > 0.0) {
            this.pane.setMaxSize(this.width, this.height);
            this.pane.setPrefSize(this.width, this.height);
            if (containerWidth > 0.0 && containerHeight > 0.0) {
                this.graphicContainer.setMinSize(containerWidth, containerHeight);
                this.graphicContainer.setMaxSize(containerWidth, containerHeight);
                this.graphicContainer.setPrefSize(containerWidth, containerHeight);
                this.graphicContainer.relocate(this.contentBounds.getX(), this.contentBounds.getY());
                if (null != this.tile) {
                    Node graphic = this.tile.getGraphic();
                    if (this.tile.getGraphic() instanceof Shape) {
                        double graphicWidth = graphic.getBoundsInLocal().getWidth();
                        double graphicHeight = graphic.getBoundsInLocal().getHeight();
                        if (graphicWidth > containerWidth || graphicHeight > containerHeight) {
                            double scale = 1.0;
                            scale = graphicWidth - containerWidth > graphicHeight - containerHeight ? containerWidth / graphicWidth : containerHeight / graphicHeight;
                            graphic.setScaleX(scale);
                            graphic.setScaleY(scale);
                        }
                    } else if (this.tile.getGraphic() instanceof ImageView) {
                        ImageView imgView = (ImageView)graphic;
                        imgView.setPreserveRatio(true);
                        imgView.setFitWidth(containerWidth);
                        imgView.setFitHeight(containerHeight);
                    }
                }
            }
            this.resizeStaticText();
        }
    }

    @Override
    protected void redraw() {
        super.redraw();
        this.titleText.setText(this.tile.getTitle());
        this.text.setText(this.tile.getText());
        this.resizeStaticText();
        this.titleText.setFill(this.tile.getTitleColor());
        this.text.setFill(this.tile.getTextColor());
    }
}

