/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.command;

import net.sourceforge.plantuml.TitledDiagram;
import net.sourceforge.plantuml.command.BlocLines;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.CommandMultilines2;
import net.sourceforge.plantuml.command.MultilinesStrategy;
import net.sourceforge.plantuml.command.regex.IRegex;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexOptional;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.DisplayPositionned;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.VerticalAlignment;
import net.sourceforge.plantuml.ugraphic.color.NoSuchColorException;

public class CommandMultilinesLegend
extends CommandMultilines2<TitledDiagram> {
    public CommandMultilinesLegend() {
        super(CommandMultilinesLegend.getRegexConcat(), MultilinesStrategy.REMOVE_STARTING_QUOTE);
    }

    private static IRegex getRegexConcat() {
        return RegexConcat.build(CommandMultilinesLegend.class.getName(), RegexLeaf.start(), new RegexLeaf("legend"), new RegexOptional((IRegex)new RegexConcat(RegexLeaf.spaceOneOrMore(), new RegexLeaf("VALIGN", "(top|bottom)"))), new RegexOptional((IRegex)new RegexConcat(RegexLeaf.spaceOneOrMore(), new RegexLeaf("ALIGN", "(left|right|center)"))), RegexLeaf.end());
    }

    @Override
    public String getPatternEnd() {
        return "(?i)^end[%s]?legend$";
    }

    @Override
    protected CommandExecutionResult executeNow(TitledDiagram diagram, BlocLines lines) throws NoSuchColorException {
        lines = lines.trimSmart(1);
        RegexResult line0 = this.getStartingPattern().matcher(lines.getFirst().getTrimmed().getString());
        String align = line0.get("ALIGN", 0);
        String valign = line0.get("VALIGN", 0);
        lines = lines.subExtract(1, 1);
        Display strings = (lines = lines.removeEmptyColumns()).toDisplay();
        if (strings.size() > 0) {
            VerticalAlignment valignment = VerticalAlignment.fromString(valign);
            HorizontalAlignment alignment = HorizontalAlignment.fromString(align);
            if (alignment == null) {
                alignment = HorizontalAlignment.CENTER;
            }
            diagram.setLegend(DisplayPositionned.single(strings.replaceBackslashT(), alignment, valignment));
            return CommandExecutionResult.ok();
        }
        return CommandExecutionResult.error("No legend defined");
    }
}

