/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graph;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.plantuml.graph.Board;
import net.sourceforge.plantuml.graph.CostComputer;
import net.sourceforge.plantuml.graph.SortedCollection;
import net.sourceforge.plantuml.graph.SortedCollectionArrayList;

public class BoardCollection {
    private final SortedCollection<Entry> all = new SortedCollectionArrayList<Entry>();
    private final CostComputer costComputer;

    public BoardCollection(CostComputer costComputer) {
        this.costComputer = costComputer;
    }

    public int size() {
        return this.all.size();
    }

    public Board getAndSetExploredSmallest() {
        for (Entry ent : this.all) {
            if (ent.explored) continue;
            ent.explored = true;
            assert (this.costComputer.getCost(ent.board) == ent.cost);
            return ent.board;
        }
        return null;
    }

    public double getBestCost() {
        Iterator iterator = this.all.iterator();
        if (iterator.hasNext()) {
            Entry ent = (Entry)iterator.next();
            return ent.cost;
        }
        return 0.0;
    }

    public Board getBestBoard() {
        Iterator iterator = this.all.iterator();
        if (iterator.hasNext()) {
            Entry ent = (Entry)iterator.next();
            return ent.board;
        }
        return null;
    }

    public List<Double> getCosts() {
        ArrayList<Double> result = new ArrayList<Double>();
        for (Entry ent : this.all) {
            result.add(this.costComputer.getCost(ent.board));
        }
        return result;
    }

    public void add(Board b) {
        this.all.add(new Entry(b, this.costComputer));
    }

    public boolean contains(Board b) {
        return this.all.contains(new Entry(b, null));
    }

    static class Entry
    implements Comparable<Entry> {
        private final Board board;
        private final double cost;
        private boolean explored;

        public Entry(Board b, CostComputer costComputer) {
            this.board = b;
            this.cost = costComputer == null ? 0.0 : costComputer.getCost(b);
        }

        @Override
        public int compareTo(Entry other) {
            return (int)Math.signum(this.cost - other.cost);
        }

        public boolean equals(Object obj) {
            Entry other = (Entry)obj;
            return this.board.equals(other.board);
        }

        public int hashCode() {
            return this.board.hashCode();
        }
    }
}

