/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Random;
import java.util.Set;
import javax.swing.ImageIcon;
import net.sourceforge.plantuml.AnimatedGifEncoder;
import net.sourceforge.plantuml.AnnotatedWorker;
import net.sourceforge.plantuml.CMapData;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.CornerParam;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.EmptyImageBuilder;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.FileUtils;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.LineParam;
import net.sourceforge.plantuml.Scale;
import net.sourceforge.plantuml.SvgCharSizeHack;
import net.sourceforge.plantuml.TitledDiagram;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.UseStyle;
import net.sourceforge.plantuml.anim.AffineTransformation;
import net.sourceforge.plantuml.anim.Animation;
import net.sourceforge.plantuml.api.ImageDataComplex;
import net.sourceforge.plantuml.api.ImageDataSimple;
import net.sourceforge.plantuml.braille.UGraphicBraille;
import net.sourceforge.plantuml.core.ImageData;
import net.sourceforge.plantuml.eps.EpsStrategy;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.UDrawable;
import net.sourceforge.plantuml.mjpeg.MJPEGGenerator;
import net.sourceforge.plantuml.security.ImageIO;
import net.sourceforge.plantuml.security.SFile;
import net.sourceforge.plantuml.skin.rose.Rose;
import net.sourceforge.plantuml.style.ClockwiseTopRightBottomLeft;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleSignature;
import net.sourceforge.plantuml.svek.TextBlockBackcolored;
import net.sourceforge.plantuml.svg.LengthAdjust;
import net.sourceforge.plantuml.ugraphic.LimitFinder;
import net.sourceforge.plantuml.ugraphic.MinMax;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UGraphic2;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.ColorMapper;
import net.sourceforge.plantuml.ugraphic.color.ColorMapperIdentity;
import net.sourceforge.plantuml.ugraphic.color.HColor;
import net.sourceforge.plantuml.ugraphic.color.HColorBackground;
import net.sourceforge.plantuml.ugraphic.color.HColorGradient;
import net.sourceforge.plantuml.ugraphic.color.HColorSimple;
import net.sourceforge.plantuml.ugraphic.color.HColorUtils;
import net.sourceforge.plantuml.ugraphic.debug.UGraphicDebug;
import net.sourceforge.plantuml.ugraphic.eps.UGraphicEps;
import net.sourceforge.plantuml.ugraphic.g2d.UGraphicG2d;
import net.sourceforge.plantuml.ugraphic.hand.UGraphicHandwritten;
import net.sourceforge.plantuml.ugraphic.html5.UGraphicHtml5;
import net.sourceforge.plantuml.ugraphic.svg.UGraphicSvg;
import net.sourceforge.plantuml.ugraphic.tikz.UGraphicTikz;
import net.sourceforge.plantuml.ugraphic.txt.UGraphicTxt;
import net.sourceforge.plantuml.ugraphic.visio.UGraphicVdx;

public class ImageBuilder {
    private Animation animation;
    private boolean annotations;
    private HColor backcolor = HColorUtils.WHITE;
    private HColor borderColor;
    private double borderCorner;
    private UStroke borderStroke;
    private ColorMapper colorMapper = new ColorMapperIdentity();
    private Dimension2D dimension;
    private int dpi = 96;
    private final FileFormatOption fileFormatOption;
    private boolean handwritten;
    private String hoverPathColorRGB;
    private LengthAdjust lengthAdjust = LengthAdjust.defaultValue();
    private UDrawable udrawable;
    private ClockwiseTopRightBottomLeft margin = ClockwiseTopRightBottomLeft.none();
    private String metadata;
    private String preserveAspectRatio;
    private Scale scale;
    private long seed = 42L;
    private int status = 0;
    private SvgCharSizeHack svgCharSizeHack = SvgCharSizeHack.NO_HACK;
    private boolean svgDimensionStyle = true;
    private String svgLinkTarget;
    private TitledDiagram titledDiagram;
    private boolean randomPixel;
    private String warningOrError;

    public static ImageBuilder plainImageBuilder(UDrawable drawable, FileFormatOption fileFormatOption) {
        return new ImageBuilder(drawable, fileFormatOption);
    }

    public static ImageBuilder plainPngBuilder(UDrawable drawable) {
        return ImageBuilder.plainImageBuilder(drawable, new FileFormatOption(FileFormat.PNG));
    }

    public static ImageBuilder styledImageBuilder(TitledDiagram diagram, UDrawable drawable, int index, FileFormatOption fileFormatOption) {
        return new ImageBuilder(drawable, fileFormatOption).styled(diagram);
    }

    private ImageBuilder(UDrawable drawable, FileFormatOption fileFormatOption) {
        this.udrawable = drawable;
        this.fileFormatOption = fileFormatOption;
        this.preserveAspectRatio = ImageBuilder.calculatePreserveAspectRatio(fileFormatOption, null);
        if (drawable instanceof TextBlockBackcolored) {
            this.backcolor = ((TextBlockBackcolored)drawable).getBackcolor();
        }
    }

    public ImageBuilder annotations(boolean annotations) {
        this.annotations = annotations;
        return this;
    }

    public ImageBuilder backcolor(HColor backcolor) {
        this.backcolor = backcolor;
        return this;
    }

    public ImageBuilder blackBackcolor() {
        return this.backcolor(HColorUtils.BLACK);
    }

    public ImageBuilder dimension(Dimension2D dimension) {
        this.dimension = dimension;
        return this;
    }

    public ImageBuilder margin(ClockwiseTopRightBottomLeft margin) {
        this.margin = margin;
        return this;
    }

    public ImageBuilder metadata(String metadata) {
        this.metadata = metadata;
        return this;
    }

    public String getPreserveAspectRatio() {
        return this.preserveAspectRatio;
    }

    public ImageBuilder randomPixel() {
        this.randomPixel = true;
        return this;
    }

    public ImageBuilder seed(long seed) {
        this.seed = seed;
        return this;
    }

    public ImageBuilder status(int status) {
        this.status = status;
        return this;
    }

    public ImageBuilder warningOrError(String warningOrError) {
        this.warningOrError = warningOrError;
        return this;
    }

    private ImageBuilder styled(TitledDiagram diagram) {
        ISkinParam skinParam = diagram.getSkinParam();
        this.animation = diagram.getAnimation();
        this.annotations = true;
        this.backcolor = ImageBuilder.calculateBackColor(diagram);
        this.borderColor = new Rose().getHtmlColor(skinParam, ColorParam.diagramBorder);
        this.borderCorner = skinParam.getRoundCorner(CornerParam.diagramBorder, null);
        this.borderStroke = ImageBuilder.calculateBorderStroke(this.borderColor, skinParam);
        this.colorMapper = skinParam.getColorMapper();
        this.dpi = skinParam.getDpi();
        this.handwritten = skinParam.handwritten();
        this.hoverPathColorRGB = this.calculateHoverPathColor(skinParam);
        this.lengthAdjust = skinParam.getlengthAdjust();
        this.margin = ImageBuilder.calculateMargin(diagram);
        this.metadata = this.fileFormatOption.isWithMetadata() ? diagram.getMetadata() : null;
        this.preserveAspectRatio = ImageBuilder.calculatePreserveAspectRatio(this.fileFormatOption, skinParam);
        this.scale = diagram.getScale();
        this.seed = diagram.seed();
        this.svgCharSizeHack = skinParam;
        this.svgDimensionStyle = skinParam.svgDimensionStyle();
        this.svgLinkTarget = this.fileFormatOption.getSvgLinkTarget() != null ? this.fileFormatOption.getSvgLinkTarget() : skinParam.getSvgLinkTarget();
        this.titledDiagram = diagram;
        this.warningOrError = diagram.getWarningOrError();
        return this;
    }

    public ImageData write(OutputStream os) throws IOException {
        if (this.annotations && this.titledDiagram != null) {
            if (!(this.udrawable instanceof TextBlock)) {
                throw new IllegalStateException("udrawable is not a TextBlock");
            }
            ISkinParam skinParam = this.titledDiagram.getSkinParam();
            StringBounder stringBounder = this.fileFormatOption.getDefaultStringBounder(skinParam);
            AnnotatedWorker annotatedWorker = new AnnotatedWorker(this.titledDiagram, skinParam, stringBounder);
            this.udrawable = annotatedWorker.addAdd((TextBlock)this.udrawable);
        }
        switch (this.fileFormatOption.getFileFormat()) {
            case MJPEG: {
                return this.writeImageMjpeg(os);
            }
            case ANIMATED_GIF: {
                return this.writeImageAnimatedGif(os);
            }
        }
        return this.writeImageInternal(this.fileFormatOption, os, this.animation);
    }

    public byte[] writeByteArray() throws IOException {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            this.write(baos);
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
    }

    private ImageData writeImageInternal(FileFormatOption fileFormatOption, OutputStream os, Animation animationArg) throws IOException {
        Set<Url> urls;
        Dimension2D dim = this.dimension == null ? this.getFinalDimension(fileFormatOption.getDefaultStringBounder(this.svgCharSizeHack)) : this.dimension;
        double dx = 0.0;
        double dy = 0.0;
        if (animationArg != null) {
            MinMax minmax = animationArg.getMinMax(dim);
            animationArg.setDimension(dim);
            dim = minmax.getDimension();
            dx = -minmax.getMinX();
            dy = -minmax.getMinY();
        }
        UGraphic2 ug = this.createUGraphic(fileFormatOption, dim, animationArg, dx, dy);
        UGraphic ug2 = ug;
        if (this.borderStroke != null) {
            HColor color = this.borderColor == null ? HColorUtils.BLACK : this.borderColor;
            double width = dim.getWidth() - this.borderStroke.getThickness();
            double height = dim.getHeight() - this.borderStroke.getThickness();
            URectangle shape = new URectangle(width, height).rounded(this.borderCorner);
            ug2.apply(color).apply(this.borderStroke).draw(shape);
        }
        if (this.randomPixel) {
            this.drawRandomPoint(ug2);
        }
        ug2 = this.handwritten(ug2.apply(new UTranslate(this.margin.getLeft(), this.margin.getTop())));
        this.udrawable.drawU(ug2);
        ug2.flushUg();
        ug.writeImageTOBEMOVED(os, this.metadata, 96);
        os.flush();
        if (ug instanceof UGraphicG2d && (urls = ((UGraphicG2d)ug).getAllUrlsEncountered()).size() > 0) {
            CMapData cmap = CMapData.cmapString(urls, this.dpi);
            return new ImageDataComplex(dim, cmap, this.warningOrError, this.status);
        }
        return this.createImageData(dim);
    }

    private void drawRandomPoint(UGraphic ug2) {
        Random rnd = new Random();
        int red = rnd.nextInt(40);
        int green = rnd.nextInt(40);
        int blue = rnd.nextInt(40);
        Color c = new Color(red, green, blue);
        HColorSimple color = new HColorSimple(c, false);
        ug2.apply(color).apply(color.bg()).draw(new URectangle(1.0, 1.0));
    }

    private Dimension2D getFinalDimension(StringBounder stringBounder) {
        LimitFinder limitFinder = new LimitFinder(stringBounder, true);
        this.udrawable.drawU(limitFinder);
        return new Dimension2DDouble(limitFinder.getMaxX() + 1.0 + this.margin.getLeft() + this.margin.getRight(), limitFinder.getMaxY() + 1.0 + this.margin.getTop() + this.margin.getBottom());
    }

    private Dimension2D getFinalDimension() {
        return this.getFinalDimension(this.fileFormatOption.getDefaultStringBounder(this.svgCharSizeHack));
    }

    private UGraphic handwritten(UGraphic ug) {
        if (this.handwritten) {
            return new UGraphicHandwritten(ug);
        }
        return ug;
    }

    private ImageData writeImageMjpeg(OutputStream os) throws IOException {
        Dimension2D dim = this.getFinalDimension();
        SFile f = new SFile("c:/tmp.avi");
        int nbframe = 100;
        MJPEGGenerator m = new MJPEGGenerator(f, this.getAviImage(null).getWidth(null), this.getAviImage(null).getHeight(null), 12.0, 100);
        int i = 0;
        if (i < 100) {
            AffineTransform at = AffineTransform.getTranslateInstance(dim.getWidth() / 2.0, dim.getHeight() / 2.0);
            at.rotate(1.5707963267948966 * (double)i / 100.0);
            at.translate(-dim.getWidth() / 2.0, -dim.getHeight() / 2.0);
            throw new UnsupportedOperationException();
        }
        m.finishAVI();
        FileUtils.copyToStream(f, os);
        return this.createImageData(dim);
    }

    private ImageData writeImageAnimatedGif(OutputStream os) throws IOException {
        Dimension2D dim = this.getFinalDimension();
        MinMax minmax = this.animation.getMinMax(dim);
        AnimatedGifEncoder e = new AnimatedGifEncoder();
        e.setRepeat(0);
        e.start(os);
        e.setDelay(60);
        for (AffineTransformation at : this.animation.getAll()) {
            ImageIcon ii = new ImageIcon(this.getAviImage(at));
            e.addFrame((BufferedImage)ii.getImage());
        }
        e.finish();
        return this.createImageData(dim);
    }

    private Image getAviImage(AffineTransformation affineTransform) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.writeImageInternal(new FileFormatOption(FileFormat.PNG), baos, Animation.singleton(affineTransform));
        baos.close();
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        BufferedImage im = ImageIO.read(bais);
        bais.close();
        return im;
    }

    private UGraphic2 createUGraphic(FileFormatOption option, Dimension2D dim, Animation animationArg, double dx, double dy) {
        double scaleFactor = (this.scale == null ? 1.0 : this.scale.getScale(dim.getWidth(), dim.getHeight())) * (double)this.dpi / 96.0;
        switch (option.getFileFormat()) {
            case PNG: {
                return this.createUGraphicPNG(scaleFactor, dim, animationArg, dx, dy, option.getWatermark());
            }
            case SVG: {
                return this.createUGraphicSVG(scaleFactor, dim);
            }
            case EPS: {
                return new UGraphicEps(this.colorMapper, EpsStrategy.getDefault2());
            }
            case EPS_TEXT: {
                return new UGraphicEps(this.colorMapper, EpsStrategy.WITH_MACRO_AND_TEXT);
            }
            case HTML5: {
                return new UGraphicHtml5(this.colorMapper);
            }
            case VDX: {
                return new UGraphicVdx(this.colorMapper);
            }
            case LATEX: {
                return new UGraphicTikz(this.colorMapper, scaleFactor, true, option.getTikzFontDistortion());
            }
            case LATEX_NO_PREAMBLE: {
                return new UGraphicTikz(this.colorMapper, scaleFactor, false, option.getTikzFontDistortion());
            }
            case BRAILLE_PNG: {
                return new UGraphicBraille(this.colorMapper);
            }
            case UTXT: 
            case ATXT: {
                return new UGraphicTxt();
            }
            case DEBUG: {
                return new UGraphicDebug(scaleFactor, dim, this.svgLinkTarget, this.hoverPathColorRGB, this.seed, this.preserveAspectRatio);
            }
        }
        throw new UnsupportedOperationException(option.getFileFormat().toString());
    }

    private UGraphic2 createUGraphicSVG(double scaleFactor, Dimension2D dim) {
        UGraphicSvg ug;
        HColor backColor = HColorUtils.WHITE;
        if (this.backcolor instanceof HColorSimple) {
            backColor = this.backcolor;
        }
        if (this.backcolor instanceof HColorGradient) {
            ug = new UGraphicSvg(this.svgDimensionStyle, dim, this.colorMapper, (HColorGradient)this.backcolor, false, scaleFactor, this.svgLinkTarget, this.hoverPathColorRGB, this.seed, this.preserveAspectRatio, this.svgCharSizeHack, this.lengthAdjust);
        } else if (backColor == null || this.colorMapper.toColor(backColor).equals(Color.WHITE)) {
            ug = new UGraphicSvg(this.svgDimensionStyle, dim, this.colorMapper, false, scaleFactor, this.svgLinkTarget, this.hoverPathColorRGB, this.seed, this.preserveAspectRatio, this.svgCharSizeHack, this.lengthAdjust);
        } else {
            String tmp = this.colorMapper.toSvg(backColor);
            ug = new UGraphicSvg(this.svgDimensionStyle, dim, this.colorMapper, tmp, false, scaleFactor, this.svgLinkTarget, this.hoverPathColorRGB, this.seed, this.preserveAspectRatio, this.svgCharSizeHack, this.lengthAdjust);
        }
        return ug;
    }

    private UGraphic2 createUGraphicPNG(double scaleFactor, Dimension2D dim, Animation affineTransforms, double dx, double dy, String watermark) {
        Color backColor = Color.WHITE;
        if (this.backcolor instanceof HColorSimple) {
            backColor = this.colorMapper.toColor(this.backcolor);
        } else if (this.backcolor instanceof HColorBackground) {
            backColor = null;
        }
        EmptyImageBuilder builder = new EmptyImageBuilder(watermark, (int)(dim.getWidth() * scaleFactor), (int)(dim.getHeight() * scaleFactor), backColor);
        Graphics2D graphics2D = builder.getGraphics2D();
        UGraphicG2d ug = new UGraphicG2d(this.colorMapper, graphics2D, scaleFactor, affineTransforms == null ? null : affineTransforms.getFirst(), dx, dy);
        ug.setBufferedImage(builder.getBufferedImage());
        BufferedImage im = ug.getBufferedImage();
        if (this.backcolor instanceof HColorGradient) {
            ug.apply(this.backcolor.bg()).draw(new URectangle((double)im.getWidth() / scaleFactor, (double)im.getHeight() / scaleFactor));
        }
        return ug;
    }

    private static HColor calculateBackColor(TitledDiagram diagram) {
        if (UseStyle.useBetaStyle()) {
            Style style = StyleSignature.of(SName.root, SName.document, diagram.getUmlDiagramType().getStyleName()).getMergedStyle(diagram.getSkinParam().getCurrentStyleBuilder());
            HColor backgroundColor = style.value(PName.BackGroundColor).asColor(diagram.getSkinParam().getIHtmlColorSet());
            if (backgroundColor == null) {
                backgroundColor = HColorUtils.transparent();
            }
            return backgroundColor;
        }
        return diagram.getSkinParam().getBackgroundColor(false);
    }

    private static UStroke calculateBorderStroke(HColor borderColor, ISkinParam skinParam) {
        UStroke thickness = skinParam.getThickness(LineParam.diagramBorder, null);
        return thickness == null && borderColor != null ? new UStroke() : thickness;
    }

    private String calculateHoverPathColor(ISkinParam skinParam) {
        if (this.fileFormatOption.getHoverColor() != null) {
            return this.fileFormatOption.getHoverColor();
        }
        HColor color = skinParam.hoverPathColor();
        return color == null ? null : this.colorMapper.toRGB(color);
    }

    private static ClockwiseTopRightBottomLeft calculateMargin(TitledDiagram diagram) {
        Style style;
        if (UseStyle.useBetaStyle() && (style = StyleSignature.of(SName.root, SName.document).getMergedStyle(diagram.getSkinParam().getCurrentStyleBuilder())).hasValue(PName.Margin)) {
            return style.getMargin();
        }
        return diagram.getDefaultMargins();
    }

    private static String calculatePreserveAspectRatio(FileFormatOption fileFormatOption, ISkinParam skinParam) {
        if (fileFormatOption.getPreserveAspectRatio() != null) {
            return fileFormatOption.getPreserveAspectRatio();
        }
        if (skinParam != null) {
            return skinParam.getPreserveAspectRatio();
        }
        return "none";
    }

    private ImageDataSimple createImageData(Dimension2D dim) {
        return new ImageDataSimple(dim, this.status);
    }
}

