/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.yaml;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class YamlLines
implements Iterable<String> {
    public static final String KEY = "([^:\\s]+)";
    private List<String> lines = new ArrayList<String>();

    public YamlLines(List<String> rawLines) {
        for (String s : rawLines) {
            if (s.startsWith("#") || (s = this.removeDiese(s)).trim().length() == 0) continue;
            this.lines.add(s);
        }
        this.mergeMultiline();
        this.manageSpaceTwoPoints();
        this.manageList();
        int startingEmptyCols = this.startingEmptyCols();
        this.removeFirstCols(startingEmptyCols);
    }

    private void manageSpaceTwoPoints() {
        ListIterator<String> it = this.lines.listIterator();
        while (it.hasNext()) {
            String s = it.next();
            if (s.contains("\"") || s.contains("'") || !s.contains(":") || s.indexOf(58) != s.lastIndexOf(58) || s.contains(": ")) continue;
            s = s.replace(":", ": ");
            it.set(s);
        }
    }

    private String removeDiese(String s) {
        int idx = s.indexOf(" #");
        if (idx == -1) {
            return s;
        }
        return s.substring(0, idx);
    }

    private void manageList() {
        ArrayList<String> result = new ArrayList<String>();
        for (String s : this.lines) {
            Pattern p1 = Pattern.compile("^(\\s*[-])(\\s*\\S.*)$");
            Matcher m1 = p1.matcher(s);
            if (s.contains(": ") && m1.matches()) {
                result.add(m1.group(1));
                result.add(s.replaceFirst("[-]", " "));
                continue;
            }
            if (m1.matches()) {
                result.add(" " + s);
                continue;
            }
            result.add(s);
        }
        this.lines = result;
    }

    private void removeFirstCols(int startingEmptyCols) {
        if (startingEmptyCols == 0) {
            return;
        }
        ListIterator<String> it = this.lines.listIterator();
        while (it.hasNext()) {
            String s = it.next().substring(startingEmptyCols);
            it.set(s);
        }
    }

    private int startingEmptyCols() {
        int result = Integer.MAX_VALUE;
        for (String s : this.lines) {
            if ((result = Math.min(result, YamlLines.startingSpaces(s))) != 0) continue;
            return 0;
        }
        return result;
    }

    private static int startingSpaces(String s) {
        Pattern p1 = Pattern.compile("^(\\s*).*");
        Matcher m1 = p1.matcher(s);
        if (m1.matches()) {
            return m1.group(1).length();
        }
        return 0;
    }

    private void mergeMultiline() {
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < this.lines.size(); ++i) {
            String init = this.isMultilineStart(i);
            if (init != null) {
                StringBuilder sb = new StringBuilder(init);
                while (i + 1 < this.lines.size() && this.textOnly(this.lines.get(i + 1))) {
                    sb.append(" " + this.lines.get(i + 1).trim());
                    ++i;
                }
                result.add(sb.toString());
                continue;
            }
            result.add(this.lines.get(i));
        }
        this.lines = result;
    }

    private String isMultilineStart(int i) {
        if (YamlLines.nameOnly(this.lines.get(i)) != null && this.textOnly(this.lines.get(i + 1))) {
            int idx = this.lines.get(i).indexOf(58);
            return this.lines.get(i).substring(0, idx + 1);
        }
        return null;
    }

    public static String nameOnly(String s) {
        Pattern p1 = Pattern.compile("^\\s*([^:\\s]+)\\s*:\\s*[|>]?\\s*$");
        Matcher m1 = p1.matcher(s);
        if (m1.matches()) {
            String name = m1.group(1);
            return name;
        }
        return null;
    }

    private boolean textOnly(String s) {
        if (this.isList(s)) {
            return false;
        }
        return s.indexOf(58) == -1;
    }

    private boolean isList(String s) {
        return s.trim().startsWith("-");
    }

    @Override
    public Iterator<String> iterator() {
        return Collections.unmodifiableList(this.lines).iterator();
    }
}

